#include <GUIConstantsEx.au3>
#include <Clipboard.au3>
#include <WinAPI.au3>
#include <WindowsConstants.au3>

Global $iMemo

Example()

Func Example()
	Local $aFormats[3] = [2, $CF_TEXT, $CF_OEMTEXT]

	; Create GUI
	GUICreate("Clipboard", 600, 400)
	$iMemo = GUICtrlCreateEdit("", 2, 2, 596, 396, $WS_VSCROLL)
	GUICtrlSetFont($iMemo, 9, 400, 0, "Courier New")
	GUISetState(@SW_SHOW)

	; See if there is any text in the clipboard
	MemoWrite("Priority formats .:. " & _ClipBoard_GetPriorityFormat($aFormats))
	MemoWrite("Unicode available .: " & _ClipBoard_IsFormatAvailable($CF_UNICODETEXT))

	; Loop until the user exits.
	Do
	Until GUIGetMsg() = $GUI_EVENT_CLOSE
EndFunc   ;==>Example

; Write message to memo
Func MemoWrite($sMessage = "")
	GUICtrlSetData($iMemo, $sMessage & @CRLF, 1)
EndFunc   ;==>MemoWrite
