#pragma compile(Out, ..\..\AutoIt_Tools\AutoIt_Tools.exe)
#pragma compile(UPX, True)
#pragma compile(Compression, 9)
#pragma compile(AutoItExecuteAllowed, True)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, AutoIt Tools)
#pragma compile(FileDescription, AutoIt Tools bar to extend AutoIt environment)
#pragma compile(LegalCopyright,  G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)

#Region Includes

#NoTrayIcon

#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <GUIImageList.au3>
#include <GUIButton.au3>
#include <GDIPlus.au3>
#include <File.au3>
#include 'Includes\GUIDynamicMenu.au3'
#include 'Includes\AppInteraction.au3'

#EndRegion Includes

#Region Read Prefs / Opt's / Global Vars

Opt('ExpandEnvStrings', 1)
;Opt('ExpandVarStrings', 1)
Opt('GUICloseOnESC', 0)

Global Const $sScript_Dir = _PathFull(@ScriptDir & (@Compiled ? '' : '\..\..\AutoIt_Tools'), @ScriptDir)
Global Const $sMenuEditor_Tool = $sScript_Dir & '\MenuEditor\MenuEditor.exe'

Global $sApp_Name = 'AutoIt Tools'

Global $sGUI_Image_File = $sScript_Dir & '\Resources\GUI.png'
Global $sConfig_File = $sScript_Dir & '\Config.ini'
Global $sIcons_File = $sScript_Dir & '\Resources\Icons.icl'
Global $sMenu_File = IniRead($sConfig_File, 'Main', 'Menu File', $sScript_Dir & '\Menu.ini')

Global $iShow_Exit_Button = Int(IniRead($sConfig_File, 'Main', 'Show Exit Button', '1'))
Global $iConfirm_Exit = Int(IniRead($sConfig_File, 'Main', 'Confirm Exit', '1'))
Global $iDynamic_Menu_ReLoad = Int(IniRead($sConfig_File, 'Main', 'Dynamic Menu ReLoad', '0'))
Global $sAutoIt_Dir = IniRead($sConfig_File, 'Main', 'AutoIt Dir', '%AutoIt_Dir%')
Global $sSciTE_Dir = IniRead($sConfig_File, 'Main', 'SciTE Dir', '..\SciTE')
Global $sTools_Dir = IniRead($sConfig_File, 'Main', 'Tools Dir', 'Tools')
Global $sApps_Dir = IniRead($sConfig_File, 'Main', 'Apps Dir', 'Apps')

Global $iScreen_Buttom = (@DesktopHeight - WinGetPos('[CLASS:Shell_TrayWnd]')[3])

FileChangeDir($sScript_Dir)

_GDIPlus_Startup()

EnvSet('AutoIt_Dir', $sAutoIt_Dir)
EnvSet('SciTE_Dir', $sSciTE_Dir)
EnvSet('Tools_Dir', $sTools_Dir)
EnvSet('Apps_Dir', $sApps_Dir)

_RunOnce()
_AppInteraction_SetReciever($sApp_Name, '_Interaction_Reciever')

#EndRegion Read Prefs / Opt's / Global Vars

#Region Main GUI Controls

$ahGUI = _GUICreateFromImage($sApp_Name, $sGUI_Image_File, 230, -2, -2, -1, BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST))

$hGUI = $ahGUI[1]
$iGUI_Width = $ahGUI[2]
$iGUI_Height = $ahGUI[3]

$iContext_Menu = GUICtrlCreateContextMenu()
$iEditMenu_MItem = GUICtrlCreateMenuItem('Edit menu', $iContext_Menu)
$iReloadMenu_MItem = GUICtrlCreateMenuItem('Reload menu', $iContext_Menu)
GUICtrlCreateMenuItem('', $iContext_Menu)
$iExit_MItem = GUICtrlCreateMenuItem('Exit', $iContext_Menu)
GUICtrlSetState($iExit_MItem, ($iShow_Exit_Button ? $GUI_ENABLE : $GUI_DISABLE))

$iExit_Bttn = _GUICtrlCreateButtonEx('', 5, 15, 20, 20, -1, -1, $sIcons_File, -11, $BUTTON_IMAGELIST_ALIGN_CENTER, 1, 1, 13, 13)
GUICtrlSetTip($iExit_Bttn, 'Exit')
GUICtrlSetState($iExit_Bttn, ($iShow_Exit_Button ? $GUI_SHOW : $GUI_HIDE))

$iTools_Bttn = _GUICtrlCreateButtonEx('Tools', ($iGUI_Width / 2) - 35 - 70 - 20, $iGUI_Height - 48, 70, 40, -1, -1, $sIcons_File, -31, $BUTTON_IMAGELIST_ALIGN_TOP)
$iApps_Bttn = _GUICtrlCreateButtonEx('Apps', ($iGUI_Width / 2) - 35, $iGUI_Height - 48, 70, 40, -1, -1, $sIcons_File, -9, $BUTTON_IMAGELIST_ALIGN_TOP)
$iAutoItOnWeb_Bttn = _GUICtrlCreateButtonEx('AutoIt WEB', ($iGUI_Width / 2) + 35 + 20, $iGUI_Height - 48, 70, 40, -1, -1, $sIcons_File, 0, $BUTTON_IMAGELIST_ALIGN_TOP)

_GUICtrlDynamicMenu_SetHotKeysGlobal(True)
_GUICtrlDynamicMenu_SetIconSize(20)

$hTools_Menu = _GUICtrlDynamicMenu_Create()
$hTools_DM = _GUICtrlDynamicMenu_Load($hGUI, $hTools_Menu, $sMenu_File, 'Tools Menu')

$hApps_Menu = _GUICtrlDynamicMenu_Create()
$hApps_DM = _GUICtrlDynamicMenu_Load($hGUI, $hApps_Menu, $sMenu_File, 'Apps Menu')

$hAutoItOnWeb_Menu = _GUICtrlDynamicMenu_Create()
$hAutoItOnWeb_DM = _GUICtrlDynamicMenu_Load($hGUI, $hAutoItOnWeb_Menu, $sMenu_File, 'AutoIt On The Web Menu')

$iInteract_Dummy = GUICtrlCreateDummy()
AdlibRegister('_Track_GUI', 10)

#EndRegion Main GUI Controls

While 1
	$iGUIMsg = GUIGetMsg()
	
	Switch $iGUIMsg
		Case $iExit_MItem, $iExit_Bttn, $GUI_EVENT_CLOSE
			If $iConfirm_Exit And MsgBox(BitOR(256, 52), $sApp_Name & ' - Exit?', 'Are you sure, exit from [' & $sApp_Name & ']') <> 6 Then
				ContinueLoop
			EndIf
			
			_GUICtrlDynamicMenu_Destroy($hTools_DM)
			_GUICtrlDynamicMenu_Destroy($hApps_DM)
			_GUICtrlDynamicMenu_Destroy($hAutoItOnWeb_DM)
			
			_WinAPI_AnimateWindow($ahGUI[1], BitOR($AW_HOR_NEGATIVE, $AW_VER_POSITIVE, $AW_HIDE), 20)
			_WinAPI_AnimateWindow($ahGUI[0], BitOR($AW_HOR_NEGATIVE, $AW_VER_POSITIVE, $AW_HIDE), 200)
			
			Exit
		Case $GUI_EVENT_SECONDARYUP
			_GUICtrlDynamicMenu_Show($hGUI, GUICtrlGetHandle($iContext_Menu), -1, True)
		Case $iEditMenu_MItem
			;ShellExecute($sMenu_File)
			Run($sMenuEditor_Tool)
		Case $iApps_Bttn, $iTools_Bttn, $iAutoItOnWeb_Bttn, $iInteract_Dummy, $iReloadMenu_MItem
			If $iDynamic_Menu_ReLoad Or $iGUIMsg = $iInteract_Dummy Or $iGUIMsg = $iReloadMenu_MItem Then
				$sAutoIt_Dir = IniRead($sConfig_File, 'Main', 'AutoIt Dir', '')
				EnvSet('AutoIt_Dir', $sAutoIt_Dir)
				_Reload_DynamicMenu((($iGUIMsg = $iInteract_Dummy Or $iGUIMsg = $iReloadMenu_MItem) ? 0 : $iGUIMsg))
			EndIf
			
			If $iGUIMsg <> $iInteract_Dummy And $iGUIMsg <> $iReloadMenu_MItem Then
				$h_Menu = ($iGUIMsg = $iApps_Bttn ? $hApps_Menu : ($iGUIMsg = $iTools_Bttn ? $hTools_Menu : $hAutoItOnWeb_Menu))
				$i_Bttn = ($iGUIMsg = $iApps_Bttn ? $iApps_Bttn : ($iGUIMsg = $iTools_Bttn ? $iTools_Bttn : $iAutoItOnWeb_Bttn))
				
				_GUICtrlDynamicMenu_Show($hGUI, $h_Menu, $i_Bttn, False, 0, 0, True)
			EndIf
	EndSwitch
WEnd

Func _RunOnce()
	Local $iOld_WTMM = Opt('WinTitleMatchMode', 3)
	
	If WinExists('[CLASS:AutoIt v3;TITLE:~' & $sApp_Name & '~]') Then
		MsgBox(48, $sApp_Name, 'Only one instance of this program allowed.')
		Exit
	EndIf
	
	AutoItWinSetTitle('~' & $sApp_Name & '~')
	Opt('WinTitleMatchMode', $iOld_WTMM)
EndFunc

Func _Interaction_Reciever($sData)
	If $sData = 'AutoIt_Dir_Changed' Or $sData = 'Reload_Menu' Then
		GUICtrlSendToDummy($iInteract_Dummy)
	EndIf
EndFunc

Func _Track_GUI()
	AdlibUnRegister('_Track_GUI')
	
	Local Static $bHidden = True
	Local $aMPos = MouseGetPos()
	
	If $bHidden And $aMPos[0] <= 5 And $aMPos[1] >= @DesktopHeight - 5 Then
		$bHidden = False
		_WinAPI_AnimateWindow($ahGUI[0], BitOR($AW_HOR_POSITIVE, $AW_VER_NEGATIVE), 150)
		_WinAPI_AnimateWindow($ahGUI[1], BitOR($AW_HOR_POSITIVE, $AW_VER_NEGATIVE), 20)
		
		GUISetState(@SW_SHOWNOACTIVATE, $ahGUI[0])
		GUISetState(@SW_SHOWNOACTIVATE, $ahGUI[1])
		
		WinSetOnTop($ahGUI[0], '', 1)
		WinSetOnTop($ahGUI[1], '', 1)
	ElseIf Not $bHidden And ($aMPos[0] > $iGUI_Width Or $aMPos[1] < ($iScreen_Buttom - $iGUI_Height)) And $aMPos[1] < $iScreen_Buttom Then
		$bHidden = True
		_WinAPI_AnimateWindow($ahGUI[1], BitOR($AW_HOR_NEGATIVE, $AW_VER_POSITIVE, $AW_HIDE), 20)
		_WinAPI_AnimateWindow($ahGUI[0], BitOR($AW_HOR_NEGATIVE, $AW_VER_POSITIVE, $AW_HIDE), 200)
	EndIf
	
	AdlibRegister('_Track_GUI', 10)
EndFunc

Func _Reload_DynamicMenu($iID = 0)
	Local $aIDs[3][4] = [[$iTools_Bttn, 'hTools_Menu', 'hTools_DM', 'Tools Menu'], [$iApps_Bttn, 'hApps_Menu', 'hApps_DM', 'Apps Menu'], [$iAutoItOnWeb_Bttn, 'hAutoItOnWeb_Menu', 'hAutoItOnWeb_DM', 'AutoIt On The Web Menu']]
	
	For $i = 0 To 2
		If $iID = 0 Or $aIDs[$i][0] = $iID Then
			_GUICtrlDynamicMenu_Destroy(Eval($aIDs[$i][2]))
			
			Assign($aIDs[$i][1], _GUICtrlDynamicMenu_Create())
			Assign($aIDs[$i][2], _GUICtrlDynamicMenu_Load($hGUI, Eval($aIDs[$i][1]), $sMenu_File, $aIDs[$i][3]))
			
			If $aIDs[$i][0] = $iID Then
				ExitLoop
			EndIf
		EndIf
	Next
EndFunc

Func _GUICtrlCreateButtonEx($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $nStyle = -1, $nExStyle = -1, $sIconFile = '', $nIconID = 0, $nAlign = -1, $iIconL = 1, $iIconT = 5, $iIconW = 20, $iIconH = 20)
	Local $nID = GUICtrlCreateButton($sText, $iLeft, $iTop, $iWidth, $iHeight, $nStyle, $nExStyle)
	
	If $sIconFile = '' Then
		Return $nID
	EndIf
	
	GUICtrlSetFont($nID, 7, 600)
	
	Local $hImgLst = _GUIImageList_Create($iIconW, $iIconH, 5, BitOr($ILC_MASK, $ILC_COLOR32), 0, 1)
	_GUIImageList_AddIcon($hImgLst, $sIconFile, $nIconID)
	_GUICtrlButton_SetImageList($nID, $hImgLst, $nAlign, $iIconL, $iIconT)
	
	Return $nID
EndFunc

Func _GUICreateFromImage($sTitle, $sPngFile, $iOpacity = 255, $iLeft = -1, $iTop = -1, $iStyle = -1, $iExStyle = -1, $hWnd = 0)
	Local $hImage = _GDIPlus_ImageLoadFromFile($sPngFile)
	Local $iWidth = _GDIPlus_ImageGetWidth($hImage)
	Local $iHeight = _GDIPlus_ImageGetHeight($hImage)
	
	If $iLeft = -2 Or $iTop = -2 Then
		$iLeft = 0
		$iTop = (@DesktopHeight - WinGetPos('[CLASS:Shell_TrayWnd]')[3]) - $iHeight
	EndIf
	
	Local $hParent = GUICreate($sTitle, $iWidth, $iHeight, $iLeft, $iTop, BitOR(($iStyle = -1 ? 0 : $iStyle), $WS_POPUP), BitOR(($iExStyle = -1 ? 0 : $iExStyle), $WS_EX_LAYERED))
	_WinAPI_UpdateLayeredWindowEx($hParent, $iLeft, $iTop, _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage), $iOpacity, True)
	
	_GDIPlus_ImageDispose($hImage)
	
	Local $sTrnsImage = @TempDir & '\trns_img.tmp'
	Local $sBin = '0x4749463839610100010010000021F90401000003002C0000000001000100870000000000330000660000990000CC0000FF002B00002B33002B66002B99002BCC002BFF0055000055330055660055990055CC0055FF0080000080330080660080990080CC0080FF00AA0000AA3300AA6600AA9900AACC00AAFF00D50000D53300D56600D59900D5CC00D5FF00FF0000FF3300FF6600FF9900FFCC00FFFF3300003300333300663300993300CC3300FF332B00332B33332B66332B99332BCC332BFF3355003355333355663355993355CC3355FF3380003380333380663380993380CC3380FF33AA0033AA3333AA6633AA9933AACC33AAFF33D50033D53333D56633D59933D5CC33D5FF33FF0033FF3333FF6633FF9933FFCC33FFFF6600006600336600666600996600CC6600FF662B00662B33662B66662B99662BCC662BFF6655006655336655666655996655CC6655FF6680006680336680666680996680CC6680FF66AA0066AA3366AA6666AA9966AACC66AAFF66D50066D53366D56666D59966D5CC66D5FF66FF0066FF3366FF6666FF9966FFCC66FFFF9900009900339900669900999900CC9900FF992B00992B33992B66992B99992BCC992BFF9955009955339955669955999955CC9955FF9980009980339980669980999980CC9980FF99AA0099AA3399AA6699AA9999AACC99AAFF99D50099D53399D56699D59999D5CC99D5FF99FF0099FF3399FF6699FF9999FFCC99FFFFCC0000CC0033CC0066CC0099CC00CCCC00FFCC2B00CC2B33CC2B66CC2B99CC2BCCCC2BFFCC5500CC5533CC5566CC5599CC55CCCC55FFCC8000CC8033CC8066CC8099CC80CCCC80FFCCAA00CCAA33CCAA66CCAA99CCAACCCCAAFFCCD500CCD533CCD566CCD599CCD5CCCCD5FFCCFF00CCFF33CCFF66CCFF99CCFFCCCCFFFFFF0000FF0033FF0066FF0099FF00CCFF00FFFF2B00FF2B33FF2B66FF2B99FF2BCCFF2BFFFF5500FF5533FF5566FF5599FF55CCFF55FFFF8000FF8033FF8066FF8099FF80CCFF80FFFFAA00FFAA33FFAA66FFAA99FFAACCFFAAFFFFD500FFD533FFD566FFD599FFD5CCFFD5FFFFFF00FFFF33FFFF66FFFF99FFFFCCFFFFFF000000000000000000000000080400630404003B'
	
	Local $hFile = FileOpen($sTrnsImage, 18)
	FileWrite($hFile, $sBin)
	FileClose($hFile)
	
	Local $hChild = GUICreate($sTitle, $iWidth, $iHeight, 0, 0, $WS_POPUP, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD, $WS_EX_TOOLWINDOW), $hParent)
	GUICtrlCreatePic($sTrnsImage, 0, 0, $iWidth, $iHeight)
	GUICtrlSetState(-1, $GUI_DISABLE)
	FileDelete($sTrnsImage)
	
	;GUISetState(@SW_SHOW, $hParent)
	;GUISetState(@SW_SHOW, $hChild)
	
	Local $aRet[4] = [$hParent, $hChild, $iWidth, $iHeight]
	Return $aRet
EndFunc
