#pragma compile(Out, ..\..\AutVerManager\AutVerManager.exe)
#pragma compile(UPX, True)
#pragma compile(Compression, 7)
#pragma compile(Stripper, True)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, AutVerManager)
#pragma compile(FileDescription, AutoIt Version Manager (for AutoIt Loader))
#pragma compile(LegalCopyright,  G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)

#NoTrayIcon
#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <InetConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <File.au3>
#include <WinAPIDlg.au3>
#include <WinAPIMisc.au3>
#include 'Includes\InetGetFuncs.au3'
#include 'Includes\IniString.au3'
#include 'Includes\Encoding.au3'

Global Const $sScript_Dir = _PathFull(@ScriptDir & (@Compiled ? '' : '\..\..\AutVerManager'), @ScriptDir)

FileChangeDir($sScript_Dir)

Global $sApp_Name = 'AutoIt Version Manager'
Global $sConfig_File = $sScript_Dir & '\Config.ini'
Global $sAutVers_Dir = _PathFull(IniRead($sConfig_File, 'Main', 'AutoIt Vers Dir', '..\AutoIt'), $sScript_Dir)
Global $sSciTE_Dir = _PathFull(IniRead($sConfig_File, 'Main', 'SciTE Dir', '..\SciTE'), $sScript_Dir)
Global $sAutoIt_Dir_InUse = IniRead($sSciTE_Dir & '\properties\au3.properties', 'Global', 'AutoIt3Dir', '')

Global $iGUI_Width = 500
Global $iGUI_Height = 500

Global $bABORT = False

$hGUI = GUICreate($sApp_Name, $iGUI_Width, $iGUI_Height, -1, -1, BitOR($GUI_SS_DEFAULT_GUI, $WS_CLIPCHILDREN), $WS_EX_COMPOSITED)

GUICtrlCreateLabel('Select action:', 20, 20)
$iImportFromDir_Radio = GUICtrlCreateRadio('Import version from directory', 20, 40)
$iRemove_Radio = GUICtrlCreateRadio('Remove existing version', 300, 40)
$iUpdateFromInet_Radio = GUICtrlCreateRadio('Update version from internet', 20, 70)
GUICtrlSetState($iUpdateFromInet_Radio, $GUI_CHECKED)

GUICtrlCreateLabel('', 2, 94, $iGUI_Width - 4, 2, $SS_SUNKEN)

GUICtrlCreateLabel('Status:', 20, 100, -1, 17)
$iStatus_Lbl = GUICtrlCreateLabel('', 20, 120, $iGUI_Width - 40, $iGUI_Height - 200)
$iProgress = GUICtrlCreateProgress(20, $iGUI_Height - 60, $iGUI_Width - 40, 20)

$iAdd_Bttn = GUICtrlCreateButton('Update', 20, $iGUI_Height - 30, 70, 20)

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			Exit
		Case $iImportFromDir_Radio, $iRemove_Radio, $iUpdateFromInet_Radio
			GUICtrlSetData($iAdd_Bttn, (GUICtrlRead($iImportFromDir_Radio) = $GUI_CHECKED ? 'Import' : (GUICtrlRead($iRemove_Radio) = $GUI_CHECKED ? 'Remove...' : 'Update')))
		Case $iAdd_Bttn
			Opt('GUIOnEventMode', 1)
			GUICtrlSetData($iAdd_Bttn, 'Abort')
			GUICtrlSetOnEvent($iAdd_Bttn, '_Abort_Proc')
			
			If GUICtrlRead($iImportFromDir_Radio) = $GUI_CHECKED Then
				_AutoIt_Import()
			ElseIf GUICtrlRead($iRemove_Radio) = $GUI_CHECKED Then
				GUICtrlSetState($iAdd_Bttn, $GUI_DISABLE)
				_AutoIt_Remove()
				GUICtrlSetState($iAdd_Bttn, $GUI_ENABLE)
			Else
				_AutoIt_Update()
			EndIf
			
			GUICtrlSetData($iAdd_Bttn, (GUICtrlRead($iImportFromDir_Radio) = $GUI_CHECKED ? 'Import' : (GUICtrlRead($iRemove_Radio) = $GUI_CHECKED ? 'Remove...' : 'Update')))
			Opt('GUIOnEventMode', 0)
	EndSwitch
WEnd

Func _Abort_Proc()
	If MsgBox(256 + 52, 'Attention', 'Are you sure that you want to abort this operation?', 0, $hGUI) = 6 Then
		$bABORT = True
	EndIf
EndFunc

Func _AutoIt_Import()
	Local $sSel, $iExists_In_SciTE, $iExists_In_Extras
	
	While 1
		$sSel = _WinAPI_BrowseForFolderDlg('', 'Select AutoIt dir:', $BIF_RETURNONLYFSDIRS, 0, 0, $hGUI)
		
		If $sSel = '' Then
			Return SetError(1, 0, 0)
		EndIf
		
		$iExists_In_SciTE = (FileExists($sSel & '\SciTE\au3.keywords.properties') Or FileExists($sSel & '\SciTE\properties\au3.keywords.properties')) And FileExists($sSel & '\SciTE\api\au3.api')
		$iExists_In_Extras = FileExists($sSel & '\Extras\au3.api') And FileExists($sSel & '\Extras\au3.keywords.properties')
		
		If Not FileExists($sSel & '\AutoIt3.exe') And Not $iExists_In_SciTE And Not $iExists_In_Extras Then
			MsgBox(48, 'Attention', _
				'Please select AutoIt3 dir, it should be qualified AutoIt Loader dir:' & @CRLF & _
				'* Include "AutoIt\AutoIt3.exe" file' & @CRLF & _
				'* Include "au3.api" and "au3.keywords.properties" in one of these folders:' & @CRLF & _
				'	SciTE\' & @CRLF & _
				'	SciTE\api"' & @CRLF & _
				'	SciTE\properties\' & @CRLF & _
				'	AutoIt\Extras\' _
				, 0, $hGUI)
			
			ContinueLoop
		EndIf
		
		ExitLoop
	WEnd
	
	GUICtrlSetData($iStatus_Lbl, 'Please wait, importing files...')
	
	Local $sBeta = ((MsgBox(256 + 36, 'Question', 'Is it Beta version?', 0, $hGUI) = 6) ? 'Beta\' : '')
	Local $sAutoIt_Ver = FileGetVersion($sSel & '\AutoIt3.exe')
	Local $sAutoIt_Path = $sAutVers_Dir & '\' & $sBeta & $sAutoIt_Ver
	Local $iCopy = 1
	
	If FileExists($sAutoIt_Path) Then
		$iCopy = (MsgBox(52, 'Attention', 'AutoIt version already exists, add anyway?', 0, $hGUI) = 6)
	EndIf
	
	If $iCopy Then
		Local $iCopy_PID = Run(@ComSpec & ' /C xcopy "' & $sSel & '" "' & $sAutoIt_Path & '" /S /E /I /H /R /K /Y', '', @SW_HIDE, BitOR($STDIN_CHILD, $STDOUT_CHILD))
		
		_Import_Progress($iCopy_PID, $sSel, $sAutoIt_Path)
		
		If Not @error Then
			_Import_Resources($sAutoIt_Path, $sAutoIt_Ver)
			MsgBox(64, 'Done!', 'Imported successfuly!', 0, $hGUI)
		EndIf
	EndIf
	
	GUICtrlSetData($iStatus_Lbl, '')
	GUICtrlSetData($iProgress, 0)
EndFunc

Func _AutoIt_Remove()
	Local $iOld_GOEM = Opt('GUIOnEventMode', 0)
	
	Local $iW = 300, $iH = 300
	Local $sSel_AutVer, $fRemove = False
	
	Local $hRemove_GUI = GUICreate('Remove AutoIt version...', $iW, $iH, -1, -1, -1, $WS_EX_TOOLWINDOW, $hGUI)
	
	GUICtrlCreateLabel('Select AutoIt version to remove:', 20, 20)
	Local $iAutVer_List = GUICtrlCreateList('', 20, 40, $iW - 40, $iH - 70, BitOR($WS_BORDER, $WS_VSCROLL))
	
	Local $aList = _FileListToArray($sAutVers_Dir, '*', 2)
	Local $sList = ''
	
	For $i = 1 To UBound($aList) - 1
		If StringRegExp($aList[$i], '^\d+\.\d+\.\d+\.\d+$') Then
			$sList &= ($sList ? '|' : '') & $aList[$i]
		EndIf
	Next
	
	$aList = _FileListToArray($sAutVers_Dir & '\Beta', '*', 2)
	
	For $i = 1 To UBound($aList) - 1
		If StringRegExp($aList[$i], '^\d+\.\d+\.\d+\.\d+$') Then
			$sList &= ($sList ? '|' : '') & $aList[$i] & ' [BETA]'
		EndIf
	Next
	
	GUICtrlSetData($iAutVer_List, $sList, StringRegExpReplace($sAutoIt_Dir_InUse, '^.*\\', ''))
	
	Local $iRemove_Bttn = GUICtrlCreateButton('Remove...', 20, $iH - 30, 70, 20)
	Local $iCancel_Bttn = GUICtrlCreateButton('Cancel', 120, $iH - 30, 70, 20)
	
	GUISetState(@SW_DISABLE, $hGUI)
	GUISetState(@SW_SHOW, $hRemove_GUI)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $iCancel_Bttn
				ExitLoop
			Case $iRemove_Bttn
				$sSel_AutVer = GUICtrlRead($iAutVer_List)
				$sSel_AutVer = $sAutVers_Dir & '\' & ((StringRight($sSel_AutVer, 7) = ' [BETA]') ? ('Beta\' & StringTrimRight($sSel_AutVer, 7)) : $sSel_AutVer)
				
				If Not FileExists($sSel_AutVer & '\AutoIt3.exe') Then
					MsgBox(48, 'Attention', 'Please select AutoIt3 dir.', 0, $hRemove_GUI)
					ContinueLoop
				EndIf
				
				If $sAutoIt_Dir_InUse = $sSel_AutVer Then
					MsgBox(48, 'Attention', 'Selected version is in use by AutoIt Loader.', 0, $hRemove_GUI)
					ContinueLoop
				EndIf
				
				If MsgBox(256 + 52, 'Attention', 'Are you sure, remove selected AutoIt version?!', 0, $hRemove_GUI) <> 6 Then
					ContinueLoop
				EndIf
				
				$fRemove = True
				ExitLoop
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $hGUI)
	GUIDelete($hRemove_GUI)
	
	If $fRemove Then
		Local $sAutoIt_Ver = FileGetVersion($sSel_AutVer & '\AutoIt3.exe')
		
		GUICtrlSetData($iStatus_Lbl, 'Please wait, removing [' & $sAutoIt_Ver & ']...')
		
		DirRemove($sSel_AutVer, 1)
		IniDelete($sSciTE_Dir & '\Tools\Compiler Wrapper\CW.ini', 'Root', $sAutoIt_Ver)
		
		GUICtrlSetData($iStatus_Lbl, '')
	EndIf
	
	Opt('GUIOnEventMode', $iOld_GOEM)
EndFunc

Func _AutoIt_Update()
	Local $sRead = BinaryToString(InetRead('http://www.autoitscript.com/autoit3/files/beta/update.dat', 3))
	
	Local $sApi_URL = 'https://www.autoitscript.com/autoit3/scite/download/au3.api'
	Local $sApi_URL_Beta = 'https://www.autoitscript.com/autoit3/scite/download/Beta/au3.api'
	
	Local $sAutoIt_URL = 'http://www.autoitscript.com/cgi-bin/getfile.pl?autoit3/autoit-v3.zip'
	Local $sAutoIt_URL_Beta = StringReplace(_IniString_Read($sRead, 'AutoItBeta', 'Setup', ''), 'beta-setup', 'sfx')
	
	Local $sAutoIt_Ver = _IniString_Read($sRead, 'AutoIt', 'version', '')
	Local $sAutoIt_Ver_Beta = _IniString_Read($sRead, 'AutoItBeta', 'version', '')
	
	Local $sAutoIt_Path = $sAutVers_Dir & '\' & $sAutoIt_Ver
	Local $sAutoIt_Path_Beta = $sAutVers_Dir & '\Beta\' & $sAutoIt_Ver_Beta
	
	If $sAutoIt_URL_Beta = '' Or InetGetSize($sAutoIt_URL_Beta) = 0 Then
		$sAutoIt_URL_Beta = 'http://www.autoitscript.com/autoit3/files/beta/autoit/autoit-v' & $sAutoIt_Ver_Beta & '.zip'
	EndIf
	
	Local $sMsg = 'Downloaded:'
	Local $sBeta, $sBeta_Path, $sFileName, $i7z_PID
	Local $aDwnldData[2][4] = [[$sApi_URL, $sAutoIt_URL, $sAutoIt_Ver, $sAutoIt_Path], [$sApi_URL_Beta, $sAutoIt_URL_Beta, $sAutoIt_Ver_Beta, $sAutoIt_Path_Beta]]
	
	For $i = 0 To 1
		If $bABORT Then
			ExitLoop
		EndIf
		
		$sBeta = ($i = 1 ? ' (Beta)' : '')
		$sBeta_Path = ($i = 1 ? '\Beta' : '')
		
		$sApi_URL = $aDwnldData[$i][0]
		$sAutoIt_URL = $aDwnldData[$i][1]
		$sAutoIt_Ver = $aDwnldData[$i][2]
		$sAutoIt_Path = $aDwnldData[$i][3]
		
		If Not FileExists($sAutoIt_Path) Then
			If MsgBox(36, 'Question', 'New (non existing) AutoIt version available' & $sBeta & ': ' & $sAutoIt_Ver & @CRLF & 'Download?', 0, $hGUI) = 6 Then
				$sFileName = StringRegExpReplace($sAutoIt_URL, '^.*/', '')
				
				_Download_Progress($sAutoIt_URL, $sAutVers_Dir, $sFileName)
				
				If Not @error Then
					$sMsg &= @CRLF & @CRLF & 'AutoIt v' & $sAutoIt_Ver & $sBeta
					
					$i7z_PID = Run($sScript_Dir & '\Resources\7z.exe x "' & $sAutVers_Dir & '\' & $sFileName & '" -o"' & $sAutVers_Dir & '" * -r -y -bsp2', $sScript_Dir, @SW_HIDE, BitOR($STDOUT_CHILD, $STDERR_CHILD))
					
					_Extract_Progress($i7z_PID)
					
					If Not @error Then
						DirMove($sAutVers_Dir & '\install', $sAutoIt_Path)
						_Import_Resources($sAutoIt_Path, $sAutoIt_Ver)
					EndIf
				Else
					$sMsg &= @CRLF & @CRLF & 'Unable to download: AutoIt v' & $sAutoIt_Ver & $sBeta
				EndIf
				
				DirRemove($sAutVers_Dir & '\install', 1)
				FileDelete($sAutVers_Dir & '\' & $sFileName)
			EndIf
		EndIf
	Next
	
	$sMsg = ($bABORT ? 'Aborted!' : ($sMsg = 'Downloaded:' ? 'There is nothing to update.' : $sMsg))
	$bABORT = False
	
	MsgBox(64, $sApp_Name, $sMsg, 0, $hGUI)
	
	GUICtrlSetData($iStatus_Lbl, '')
	GUICtrlSetData($iProgress, 0)
EndFunc

Func _Download_Progress($sURL, $sPath, $sFileName)
	Local $hInet = InetGet($sURL, $sPath & '\' & $sFileName, 3, 1)
	
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $aInetInfo, $iBytesRead, $iFileSize, $iPrecent, $iSpeed, $sProgress_Data
	
	While 1
		If $bABORT Then
			InetClose($hInet)
			ExitLoop
		EndIf
		
		$aInetInfo = InetGetInfo($hInet)
		
		If @error Or $aInetInfo[$INET_DOWNLOADCOMPLETE] Then
			ExitLoop
		EndIf
		
		$iBytesRead = $aInetInfo[$INET_DOWNLOADREAD]
		$iFileSize = $aInetInfo[$INET_DOWNLOADSIZE]
		$iPrecent = _InetGetPrecent($iBytesRead, $iFileSize)
		$iSpeed = _InetGetSpeed($hInet)
		
		$sProgress_Data = StringFormat('Downloading: %s\nReady: %s% (%s from %s)\nSpeed: %s KB/s\nApproximately Remained: %s', _
			$sFileName, $iPrecent, _WinAPI_StrFormatByteSize($iBytesRead), _WinAPI_StrFormatByteSize($iFileSize), Round($iSpeed/1024, 1), _InetGetSecsToTime(_InetGetRemained($iBytesRead, $iFileSize, $iSpeed)))
		
		GUICtrlSetData($iStatus_Lbl, $sProgress_Data)
		GUICtrlSetData($iProgress, $iPrecent)
	WEnd
	
	GUICtrlSetData($iProgress, 100)
	
	Return SetError((InetGetInfo($hInet, $INET_DOWNLOADSUCCESS) ? 0 : 1), 0, 0)
EndFunc

Func _Extract_Progress($iPID)
	Local $iError = 1
	Local $iPrecent = 0
	Local $sStdout_Read = ''
	Local $sStdout_Read_Last = ''
	
	While ProcessExists($iPID)
		If $bABORT Then
			$iError = 1
			ProcessClose($iPID)
			ExitLoop
		EndIf
		
		$sStdout_Read = StdoutRead($iPID)
		$sStderr_Read = StderrRead($iPID)
		
		If $sStderr_Read Then
			$iPrecent = Int(StringRegExpReplace($sStderr_Read, '(?s)^.*?([0-9]+)%.*', '\1'))
		EndIf
		
		If StringInStr($sStdout_Read, 'Everything is Ok') Then
			$iPrecent = 100
			$iError = 0
		EndIf
		
		$sStdout_Read = StringRegExpReplace(($sStdout_Read ? $sStdout_Read : $sStdout_Read_Last), '(?s)^[\s-]+', '')
		
		GUICtrlSetData($iStatus_Lbl, 'Please wait, extracting: ' & $iPrecent & '%' & @CRLF & $sStdout_Read)
		GUICtrlSetData($iProgress, $iPrecent)
		
		$sStdout_Read_Last = $sStdout_Read
	WEnd
	
	Return SetError($iError, 0, 0)
EndFunc

Func _Import_Progress($iPID, $sSrc, $sDst)
	Local $sSrc_Fldr = StringRegExpReplace($sSrc, '^.*\\', '')
	Local $iSrc_Size = DirGetSize($sSrc)
	
	Local $iError = 0
	Local $iPrecent = 0
	Local $sStdout_Read = ''
	Local $sStdout_Read_Last = ''
	
	While ProcessExists($iPID)
		If $bABORT Then
			$iError = 1
			ProcessClose($iPID)
			ExitLoop
		EndIf
		
		$iPrecent = Round(DirGetSize($sDst) / $iSrc_Size * 100)
		$sStdout_Read = StdoutRead($iPID)
		
		If $sStdout_Read Then
			$sStdout_Read = _Encoding_866To1251(StringRegExpReplace($sStdout_Read, '.*\\', $sSrc_Fldr & '\\..\\'))
		Else
			$sStdout_Read = $sStdout_Read_Last
		EndIf
		
		If $iPrecent < 0 Then
			$iPrecent = 0
		EndIf
		
		GUICtrlSetData($iStatus_Lbl, 'Please wait, importing: ' & $iPrecent & '%' & @CRLF & $sStdout_Read)
		GUICtrlSetData($iProgress, $iPrecent)
		
		$sStdout_Read_Last = $sStdout_Read
	WEnd
	
	GUICtrlSetData($iProgress, 100)
	
	Return SetError($iError, 0, 0)
EndFunc

Func _Import_Resources($sAutoIt_Path, $sAutoIt_Ver)
	If Not FileMove($sAutoIt_Path & '\SciTE\au3.keywords.properties', $sAutoIt_Path & '\Extras\au3.keywords.properties', 9) Then
		FileMove($sAutoIt_Path & '\SciTE\properties\au3.keywords.properties', $sAutoIt_Path & '\Extras\au3.keywords.properties', 9)
	EndIf
	
	FileMove($sAutoIt_Path & '\SciTE\api\au3.api', $sAutoIt_Path & '\Extras\au3.api', 9)
	DirRemove($sAutoIt_Path & '\SciTE', 1)
	
	IniWrite($sSciTE_Dir & '\Tools\Compiler Wrapper\CW.ini', 'Root', $sAutoIt_Ver, (WinExists('[CLASS:AutoIt v3;TITLE:~AutoIt Loader~]') ? $sAutoIt_Path : '%AutoIt_Loader_Dir%\AutoIt\' & $sAutoIt_Ver))
EndFunc
