local sel_text = editor:GetSelText()
local pos, set = false

if sel_text == "" then
	sel_text = editor:GetText()
	pos = 0
else
	pos = editor:PositionFromLine(props["SelectionStartLine"])
end

if #sel_text == 0 then return end

while true do
	sel_text, n = string.gsub(sel_text, "(\r?\n)%s*\r?\n", "%1")
	if n == 0 then break end
	set = true
end

if set then
	editor:BeginUndoAction()
	
	if pos == 0 then
		editor:SetText(sel_text)
	else
		editor:ReplaceSel(sel_text)
	end
	
	editor:EndUndoAction()
end

editor:GotoPos(pos)
