#pragma compile(Out, ..\..\..\AutoIt_Tools\MenuEditor\MenuEditor.exe)
#pragma compile(UPX, True)
#pragma compile(Compression, 9)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, Menu Editor)
#pragma compile(FileDescription, Menu editor for AutoIt Tools)
#pragma compile(LegalCopyright, © G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)

#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <GUIImageList.au3>
#include <GUIButton.au3>
#include <File.au3>
#include <Timers.au3>
#include "Includes\GUIHotkey.au3"
#include "Includes\GDIPlusPic.au3"
#include "Includes\IniEx.au3"
#include "..\Includes\AppInteraction.au3"
#include "..\Includes\GUIDynamicMenu.au3"

;This is actualy AutoIt_Tools dir, since we use it's resources
Global Const $sScript_Dir = _PathFull(@ScriptDir & (@Compiled ? '\..' : '\..\..\..\AutoIt_Tools'), @ScriptDir)

Global $fMenu_Changed = False

Global $sApp_Name = 'Menu Editor'
Global $sConfig_File = $sScript_Dir & '\Config.ini'
Global $sMenu_File = _PathFull(IniRead($sConfig_File, 'Main', 'Menu File', $sScript_Dir & '\Menu.ini'), $sScript_Dir)
Global $sIniStruct_File = $sScript_Dir & '\Resources\Structure.ini'
Global $sAT_Image_File = $sScript_Dir & '\Resources\GUI.png'
Global $sIcons_File = $sScript_Dir & '\Resources\Icons.icl'

Global $hTools_Menu, $hApps_Menu, $hAutoItOnWeb_Menu
Global $hTools_DM, $hApps_DM, $hAutoItOnWeb_DM

Global $aAddItem_IDs[1][6]

Global $iItem_Grayed_Last = 0
Global $iItem_Grayed_Selected = 0

Global $iGUI_Width = 305
Global $iGUI_Height = 500

Opt('ExpandEnvStrings', 1)
FileChangeDir($sScript_Dir)

$hGUI = GUICreate($sApp_Name, $iGUI_Width, $iGUI_Height)

GUICtrlCreateLabel('* Select menu item to modify or delete', 5, 10)
GUICtrlCreateLabel('* Select [ADD ITEM] in menu to add item/submenu', 5, 30)
GUICtrlCreateLabel('* Select [EDIT MENU] in menu to edit submenu', 5, 50)

$iShowIniStruct_Bttn = GUICtrlCreateButton('Ini file structure/syntax...', 10, 80, $iGUI_Width - 20, 20)

$iPic = _GDIPlusPic_Create($hGUI, $sAT_Image_File, 2.5, $iGUI_Height - 350, 300, 300, False)
GUISwitch($hGUI)

$iTools_Bttn = _GUICtrlCreateButtonEx('Tools', ($iGUI_Width / 2) - 35 - 70 - 20, $iGUI_Height - 48, 70, 40, -1, -1, $sIcons_File, -31, $BUTTON_IMAGELIST_ALIGN_TOP)
$iApps_Bttn = _GUICtrlCreateButtonEx('Apps', ($iGUI_Width / 2) - 35, $iGUI_Height - 48, 70, 40, -1, -1, $sIcons_File, -9, $BUTTON_IMAGELIST_ALIGN_TOP)
$iAutoItOnWeb_Bttn = _GUICtrlCreateButtonEx('AutoIt WEB', ($iGUI_Width / 2) + 35 + 20, $iGUI_Height - 48, 70, 40, -1, -1, $sIcons_File, 0, $BUTTON_IMAGELIST_ALIGN_TOP)

_GUICtrlDynamicMenu_SetHotKeysGlobal(False)
_GUICtrlDynamicMenu_SetIconSize(20)

GUIRegisterMsg($WM_MENUSELECT, '_WM_MENUSELECT')
GUISetState(@SW_SHOW, $hGUI)

_Timer_SetTimer($hGUI, 10, '_Menu_Click_Check')
 _Menu_Load(False, $hGUI)
_GDIPlusPic_Show($iPic, True)

While 1
	$iGUIMsg = GUIGetMsg()
	
	Switch $iGUIMsg
		Case $GUI_EVENT_CLOSE
			Exit
		Case $iShowIniStruct_Bttn
			ShellExecute($sIniStruct_File)
		Case $iApps_Bttn, $iTools_Bttn, $iAutoItOnWeb_Bttn
			$h_DM = ($iGUIMsg = $iApps_Bttn ? $hApps_DM : ($iGUIMsg = $iTools_Bttn ? $hTools_DM : $hAutoItOnWeb_DM))
			$h_Menu = ($iGUIMsg = $iApps_Bttn ? $hApps_Menu : ($iGUIMsg = $iTools_Bttn ? $hTools_Menu : $hAutoItOnWeb_Menu))
			$i_Bttn = ($iGUIMsg = $iApps_Bttn ? $iApps_Bttn : ($iGUIMsg = $iTools_Bttn ? $iTools_Bttn : $iAutoItOnWeb_Bttn))
			
			$iMenuItemID = _GUICtrlDynamicMenu_Show($hGUI, $h_Menu, $i_Bttn, False, 2, 1, True)
			
			;Workaround for selected separator or disabled item
			If $iItem_Grayed_Selected Then
				$iMenuItemID = $iItem_Grayed_Selected
			EndIf
			
			$iItem_Grayed_Selected = 0
			
			_Menu_Handler($h_DM, $iMenuItemID)
			
			If @error Then
				;MsgBox(64, 'Attention', StringFormat('Unable to handle menu item.\n\nProbably you hit an internal Separator item\n(used to separate [ADD/EDIT *] items)\n\nor a Submenu.'), 0, $hGUI)
			EndIf
	EndSwitch
WEnd

Func _GUICtrlCreateButtonEx($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $nStyle = -1, $nExStyle = -1, $sIconFile = '', $nIconID = 0, $nAlign = -1, $iIconL = 1, $iIconT = 5, $iIconW = 20, $iIconH = 20)
	Local $nID = GUICtrlCreateButton($sText, $iLeft, $iTop, $iWidth, $iHeight, $nStyle, $nExStyle)
	
	If $sIconFile = '' Then
		Return $nID
	EndIf
	
	GUICtrlSetFont($nID, 7, 600)
	
	Local $hImgLst = _GUIImageList_Create($iIconW, $iIconH, 5, BitOr($ILC_MASK, $ILC_COLOR32), 0, 1)
	_GUIImageList_AddIcon($hImgLst, $sIconFile, $nIconID)
	_GUICtrlButton_SetImageList($nID, $hImgLst, $nAlign, $iIconL, $iIconT)
	
	Return $nID
EndFunc

Func _DMenu_AddExtraItems($hDM, $hRootMenu, $fReset = False)
	Local $sMenus = ''
	Local $aInfo = _GUICtrlDynamicMenu_GetInfo($hDM)
	Local Static $iAddItem_ItemID = 0
	
	If $fReset Or $iAddItem_ItemID = 0 Then
		$iAddItem_ItemID = 10000
	EndIf
	
	For $i = 1 To UBound($aInfo) - 1
		If Not StringInStr('|' & $sMenus & '|', '|' & $aInfo[$i][$GDM_INFO_HMENU] & '|') Then
			$sMenus &= '|' & $aInfo[$i][$GDM_INFO_HMENU] & '|'
			
			Local $aItems[2] = ['[ADD ITEM]', '[EDIT MENU]']
			
			For $x = 0 To 1
				$iAddItem_ItemID += 1
				
				_GUICtrlMenu_InsertMenuItem($aInfo[$i][$GDM_INFO_HMENU], 0, $aItems[$x], $iAddItem_ItemID)
				
				$aAddItem_IDs[0][0] += 1
				ReDim $aAddItem_IDs[$aAddItem_IDs[0][0] + 1][6]
				
				$aAddItem_IDs[$aAddItem_IDs[0][0]][0] = $iAddItem_ItemID ;Extra Item ID
				$aAddItem_IDs[$aAddItem_IDs[0][0]][1] = $aInfo[$i][$GDM_INFO_HMENU] ;Menu Handle
				$aAddItem_IDs[$aAddItem_IDs[0][0]][2] = _GUICtrlMenu_GetMenuData($aInfo[$i][$GDM_INFO_HMENU]) ;Menu ID
				$aAddItem_IDs[$aAddItem_IDs[0][0]][3] = _GUICtrlMenu_GetItemText($hRootMenu, $aAddItem_IDs[$aAddItem_IDs[0][0]][2], False) ;Menu text
				$aAddItem_IDs[$aAddItem_IDs[0][0]][4] = $aInfo[$i][$GDM_INFO_SECTNAME]
				$aAddItem_IDs[$aAddItem_IDs[0][0]][5] = $aItems[$x] ;Extra Item text
				
				If $aInfo[$i][$GDM_INFO_HMENU] = $hRootMenu Or $x = 1 Then
					_GUICtrlMenu_InsertMenuItem($aInfo[$i][$GDM_INFO_HMENU], $x + 1, '')
					ExitLoop
				EndIf
			Next
		EndIf
	Next
EndFunc

Func _DMenu_UnsetHotKeys($hDM)
	For $i = 1 To UBound($hDM) - 1
		If $hDM[$i][$GDM_INFO_HOTKEY] Then
			HotKeySet($hDM[$i][$GDM_INFO_HOTKEY])
		EndIf
	Next
EndFunc

Func _Menu_Load($fReload, $hWnd)
	Local $hPrgrs_GUI = GUICreate(($fReload ? 'Rel' : 'L') & 'oading', 280, 100, -1, -1, $WS_POPUPWINDOW, $WS_EX_TOOLWINDOW)
	GUICtrlCreateLabel('Please wait, ' & ($fReload ? 're' : '') & 'loading menu...', 20, 20)
	Local $iProgress = GUICtrlCreateProgress(20, 70, 240, 20)
	
	GUISetState(@SW_DISABLE, $hWnd)
	GUISetState(@SW_SHOW, $hPrgrs_GUI)
	
	If $fReload Then
		$aAddItem_IDs = 0
		Dim $aAddItem_IDs[1][6]
		
		GUICtrlSetData($iProgress, 100 / 7)
		
		_GUICtrlDynamicMenu_Destroy($hTools_DM)
		_GUICtrlDynamicMenu_Destroy($hApps_DM)
		_GUICtrlDynamicMenu_Destroy($hAutoItOnWeb_DM)
	EndIf
	
	GUICtrlSetData($iProgress, 100 / 6)
	
	$hTools_Menu = _GUICtrlDynamicMenu_Create()
	$hTools_DM = _GUICtrlDynamicMenu_Load($hGUI, $hTools_Menu, $sMenu_File, 'Tools Menu')
	
	GUICtrlSetData($iProgress, 100 / 5)
	
	$hApps_Menu = _GUICtrlDynamicMenu_Create()
	$hApps_DM = _GUICtrlDynamicMenu_Load($hGUI, $hApps_Menu, $sMenu_File, 'Apps Menu')
	
	GUICtrlSetData($iProgress, 100 / 4)
	
	$hAutoItOnWeb_Menu = _GUICtrlDynamicMenu_Create()
	$hAutoItOnWeb_DM = _GUICtrlDynamicMenu_Load($hGUI, $hAutoItOnWeb_Menu, $sMenu_File, 'AutoIt On The Web Menu')
	
	GUICtrlSetData($iProgress, 100 / 3)
	
	_DMenu_UnsetHotKeys($hTools_DM)
	_DMenu_UnsetHotKeys($hApps_DM)
	_DMenu_UnsetHotKeys($hAutoItOnWeb_DM)
	
	GUICtrlSetData($iProgress, 100 / 2)
	
	_DMenu_AddExtraItems($hTools_DM, $hTools_Menu, $fReload)
	_DMenu_AddExtraItems($hApps_DM, $hApps_Menu)
	_DMenu_AddExtraItems($hAutoItOnWeb_DM, $hAutoItOnWeb_Menu)
	
	GUICtrlSetData($iProgress, 100)
	Sleep(500)
	
	GUISetState(@SW_ENABLE, $hWnd)
	GUIDelete($hPrgrs_GUI)
EndFunc

Func _Menu_Handler($hDM, $iItemID)
	;Nothing selected
	If $iItemID <= 0 Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $fEdit = True
	Local $aInfo = _GUICtrlDynamicMenu_GetInfo($hDM, $iMenuItemID)
	
	;Probably it's [ADD ITEM] / [EDIT MENU], handle it differently
	If @error Then
		Local $iFind = _ArraySearch($aAddItem_IDs, $iItemID, 1, 0, 1, 2, 1, 0)
		
		If $iFind = -1 Then
			Return SetError(2, 0, 0) ;Unable to get menu handle by $iItemID
		EndIf
		
		Local $hMenu = $aAddItem_IDs[$iFind][1]
		Local $iMenu = $aAddItem_IDs[$iFind][2]
		Local $sMenu_Name = $aAddItem_IDs[$iFind][3]
		Local $sSect_Name = $aAddItem_IDs[$iFind][4]
		Local $sExtraItem_Name = $aAddItem_IDs[$iFind][5]
		
		;Empty the $aInfo array
		$aInfo = 0
		Dim $aInfo[$GDM_INFO_HK_ISGLOBAL + 1]
		
		Switch $sExtraItem_Name
			Case '[ADD ITEM]'
				;Set only the section name for $aInfo array to handle it later
				$aInfo[$GDM_INFO_SECTNAME] = $sSect_Name
				$fEdit = False
			Case '[EDIT MENU]'
				Local $iFind_Menu = _ArraySearch($hDM, $hMenu, 1, 0, 1, 0, 1, $GDM_INFO_HMENU)
				Local $iFind = _ArraySearch($hDM, $iMenu, 1, 0, 1, 0, 1, $GDM_INFO_ITEMID)
				
				If $iFind = -1 Or $iFind_Menu = -1 Then
					Return SetError(3, 0, 0) ;Unable to get menu id in DynamicMenu array
				EndIf
				
				;Set item name, section name, path (to ini file if set), icon file and icon id for $aInfo array to handle it later
				$aInfo[$GDM_INFO_ITEMNAME] = $sMenu_Name
				$aInfo[$GDM_INFO_SECTNAME] = $hDM[$iFind_Menu][$GDM_INFO_SECTNAME]
				$aInfo[$GDM_INFO_COMMAND] = $hDM[$iFind][$GDM_INFO_SECTNAME] ;This one is a workaround to get parent section name
				$aInfo[$GDM_INFO_PATH] = $hDM[$iFind][$GDM_INFO_PATH]
				$aInfo[$GDM_INFO_ICONFILE] = $hDM[$iFind][$GDM_INFO_ICONFILE]
				$aInfo[$GDM_INFO_ICONID] = $hDM[$iFind][$GDM_INFO_ICONID]
				
				Return _Menu_SubMenu_Edit($aInfo)
			Case Else
				Return SetError(4, 0, 0) ;Unknown Item
		EndSwitch
	EndIf
	
	;Handle selected item
	_Menu_Item_Edit($aInfo, $fEdit)
EndFunc

Func _Menu_Item_Edit($aInfo, $fEdit)
	Local $iW = 500, $iH = 340
	Local $fReload_Menu = False
	
	Local $sSect_Name = $aInfo[$GDM_INFO_SECTNAME]
	Local $iItem_Type = $aInfo[$GDM_INFO_ITEMTYPE]
	Local $sItem_Name = StringRegExpReplace($aInfo[$GDM_INFO_ITEMNAME], '(?i)\t+\(.*$', '')
	Local $sSect_Names = _Menu_Get_Sections()
	
	;Read the data again to display original (unhandled) data (since DynamicMenu library expand strings and paths)
	If $fEdit And $iItem_Type = $GDM_TYPE_ITEM Then
		Local $sItem_Read = IniRead($sMenu_File, $sSect_Name, 'Item, "' & $sItem_Name & '"', '')
		
		If $sItem_Read Then
			Local $aSplit = __GDM_StringSplitIgnoreQuoted($sItem_Read)
			
			$aInfo[$GDM_INFO_COMMAND] = $aSplit[1]
			$aInfo[$GDM_INFO_PATH] = $aSplit[2]
			$aInfo[$GDM_INFO_ARGS] = $aSplit[3]
			$aInfo[$GDM_INFO_ICONFILE] = $aSplit[4]
			$aInfo[$GDM_INFO_ICONID] = $aSplit[5]
		EndIf
	EndIf
	
	Local $hEdit_GUI = GUICreate($sApp_Name & ' - ' & ($fEdit ? 'Edit' : 'Add'), $iW, $iH, -1, -1, -1, $WS_EX_TOOLWINDOW, $hGUI)
	
	GUICtrlCreateLabel('Type:', 20, $iH - 313)
	Local $iItemType_Combo = GUICtrlCreateCombo('', 120, $iH - 315, ($iW / 3), 20, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	Local $sDef_Type = (($iItem_Type <> $GDM_TYPE_SEPARATOR Or Not $fEdit) ? 'Item' : 'Separator')
	GUICtrlSetData($iItemType_Combo, 'Item|Submenu|Separator', $sDef_Type)
	
	GUICtrlCreateLabel('Position:', 120 + ($iW / 3) + 20, $iH - 313)
	Local $iItemPos_Input = GUICtrlCreateInput(($fEdit ? 'CURRENT' : '0'), 120 + ($iW / 3) + 100, $iH - 315, $iW - (120 + ($iW / 3) + 120), 20)
	
	GUICtrlCreateLabel('Name:', 20, $iH - 288)
	Local $iName_Input = GUICtrlCreateInput($sItem_Name, 120, $iH - 290, $iW - 140, 20)
	
	If $fEdit Then
		For $iID = $iItemType_Combo - 1 To $iItemPos_Input
			GUICtrlSetState($iID, $GUI_DISABLE)
		Next
	EndIf
	
	GUICtrlCreateLabel('Menu section:', 20, $iH - 263)
	Local $iMenuSect_Combo = GUICtrlCreateCombo('', 120, $iH - 265, $iW - 140, 20)
	GUICtrlSetData($iMenuSect_Combo, $sSect_Names)
	
	If $iItem_Type <> $GDM_TYPE_SUBMENU Then
		GUICtrlSetState($iMenuSect_Combo, $GUI_HIDE)
		GUICtrlSetState($iMenuSect_Combo - 1, $GUI_HIDE)
	EndIf
	
	GUICtrlCreateLabel('Command:', 20, $iH - 263)
	Local $iCmd_Combo = GUICtrlCreateCombo('', 120, $iH - 265, $iW - 140, 20, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	
	$sCmds = 'DISABLED'
	
	For $i = 0 To UBound($aGDM_SprtdCmds) - 1
		$sCmds &= ($sCmds ? '|' : '') & $aGDM_SprtdCmds[$i][0]
	Next
	
	GUICtrlSetData($iCmd_Combo, $sCmds, ($aInfo[$GDM_INFO_COMMAND] ? $aInfo[$GDM_INFO_COMMAND] : ($iItem_Type = $GDM_TYPE_ITEMDISABLED ? 'DISABLED' : $aGDM_SprtdCmds[0][0])))
	
	GUICtrlCreateLabel('Path / URL / Arg:', 20, $iH - 238)
	Local $iPath_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_PATH], 120, $iH - 240, $iW - 170, 20)
	Local $iPath_Bttn = GUICtrlCreateButton('...', $iW - 40, $iH - 240, 20, 20)
	
	GUICtrlCreateLabel('Arguments:', 20, $iH - 213)
	Local $iArgs_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_ARGS], 120, $iH - 215, $iW - 140, 20)
	
	GUICtrlCreateLabel('Icon file:', 20, $iH - 188)
	Local $iIconFile_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_ICONFILE], 120, $iH - 190, $iW - 170, 20)
	Local $iIconFile_Bttn = GUICtrlCreateButton('...', $iW - 40, $iH - 190, 20, 20)
	
	GUICtrlCreateLabel('Icon ID:', 20, $iH - 163)
	Local $iIconID_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_ICONID], 120, $iH - 165, $iW - 140, 20)
	
	GUICtrlCreateLabel('Hotkey:', 20, $iH - 138)
	Local $hHotkey_Hotkey = _GUICtrlHotkey_Create($hEdit_GUI, 120, $iH - 140, 150, 20)
	_GUICtrlHotkey_SetHotkey($hHotkey_Hotkey, $aInfo[$GDM_INFO_HOTKEY])
	_GUICtrlHotkey_SetRules($hHotkey_Hotkey, $HKCOMB_NONE, $HOTKEYF_ALT)
	
	Local $iHotkeyIsGlobal_CB = GUICtrlCreateCheckbox('Hotkey is Global', 290, $iH - 140, $iW - 140, 20)
	GUICtrlSetState($iHotkeyIsGlobal_CB, (($aInfo[$GDM_INFO_HK_ISGLOBAL] == '' Or Int($aInfo[$GDM_INFO_HK_ISGLOBAL])) ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	If $fEdit And $iItem_Type <> $GDM_TYPE_ITEM Then
		GUICtrlSetState($iCmd_Combo, ($iItem_Type = $GDM_TYPE_ITEMDISABLED ? $GUI_DISABLE : $GUI_HIDE))
		GUICtrlSetState($iCmd_Combo - 1, ($iItem_Type = $GDM_TYPE_ITEMDISABLED ? $GUI_DISABLE : $GUI_HIDE))
		
		GUICtrlSetState($iPath_Input, $GUI_DISABLE)
		GUICtrlSetState($iPath_Input - 1, $GUI_DISABLE)
		GUICtrlSetState($iPath_Bttn, $GUI_DISABLE)
		
		GUICtrlSetState($iArgs_Input, $GUI_DISABLE)
		GUICtrlSetState($iArgs_Input - 1, $GUI_DISABLE)
		
		If $iItem_Type = $GDM_TYPE_SEPARATOR Or $iItem_Type = $GDM_TYPE_ITEMDISABLED Then
			For $iID = $iIconFile_Input - 1 To $iIconID_Input
				GUICtrlSetState($iID, $GUI_DISABLE)
			Next
		EndIf
		
		GUICtrlSetState($iIconID_Input + 1, $GUI_DISABLE)
		WinSetState($hHotkey_Hotkey, '', @SW_DISABLE)
		GUICtrlSetState($iHotkeyIsGlobal_CB, $GUI_DISABLE)
	EndIf
	
	GUICtrlCreateLabel('* Paths can be relative to [' & StringRegExpReplace($sMenu_File, '^.*\\', '') & '] file', 20, $iH - 110)
	GUICtrlCreateLabel('* "Hotkey is Global" means that hotkey is active everywhere', 20, $iH - 90)
	GUICtrlCreateLabel('* Leave "Icon file:" empty to use icon file from "Path:"', 20, $iH - 70)
	GUICtrlCreateLabel(($fEdit ? '' : '* Use 0 in "Position" to insert the item to the end of the menu'), 20, $iH - 50)
	
	$iEditAdd_Bttn = GUICtrlCreateButton(($fEdit ? 'Edit' : 'Add'), 20, $iH - 30, 70, 20)
	$iCancel_Bttn = GUICtrlCreateButton('Cancel', 100, $iH - 30, 70, 20)
	$iDelete_Bttn = GUICtrlCreateButton('Delete', $iW - 20 - 70, $iH - 30, 70, 20)
	
	GUICtrlSetState($iDelete_Bttn, ($fEdit ? $GUI_SHOW : $GUI_HIDE))
	
	GUISetState(@SW_DISABLE, $hGUI)
	GUISetState(@SW_SHOW, $hEdit_GUI)
	
	While 1
		$iGUIMsg = GUIGetMsg()
		
		Switch $iGUIMsg
			Case $GUI_EVENT_CLOSE, $iCancel_Bttn
				ExitLoop
			Case $iCmd_Combo
				Local $sCmd = GUICtrlRead($iCmd_Combo)
				
				WinSetState($hHotkey_Hotkey, '', ($sCmd = 'DISABLED' ? @SW_DISABLE : @SW_ENABLE))
				
				For $iID = $iCmd_Combo + 1 To $iHotkeyIsGlobal_CB
					GUICtrlSetState($iID, ($sCmd = 'DISABLED' ? $GUI_DISABLE : $GUI_ENABLE))
				Next
				
				If $sCmd <> 'DISABLED' Then
					ContinueCase
				EndIf
			Case $iItemType_Combo
				Local $sType = GUICtrlRead($iItemType_Combo)
				Local $sCmd = GUICtrlRead($iCmd_Combo)
				
				GUICtrlSetState($iName_Input, $GUI_ENABLE)
				GUICtrlSetState($iName_Input - 1, $GUI_ENABLE)
				
				GUICtrlSetState($iMenuSect_Combo, ($sType <> 'Submenu' ? $GUI_HIDE : $GUI_SHOW))
				GUICtrlSetState($iMenuSect_Combo - 1, ($sType <> 'Submenu' ? $GUI_HIDE : $GUI_SHOW))
				GUICtrlSetState($iCmd_Combo, ($sType <> 'Submenu' ? BitOR($GUI_SHOW, ($sType = 'Separator' ? $GUI_DISABLE : $GUI_ENABLE)) : $GUI_HIDE))
				GUICtrlSetState($iCmd_Combo - 1, ($sType <> 'Submenu' ? BitOR($GUI_SHOW, ($sType = 'Separator' ? $GUI_DISABLE : $GUI_ENABLE)) : $GUI_HIDE))
				GUICtrlSetState($iPath_Input, (($sType = 'Item' And $sCmd <> 'DISABLED') ? $GUI_ENABLE : $GUI_DISABLE))
				GUICtrlSetState($iPath_Input - 1, (($sType = 'Item' And $sCmd <> 'DISABLED') ? $GUI_ENABLE : $GUI_DISABLE))
				GUICtrlSetState($iPath_Bttn, (($sType = 'Item' And $sCmd <> 'DISABLED') ? $GUI_ENABLE : $GUI_DISABLE))
				GUICtrlSetState($iArgs_Input, (($sType = 'Item' And $sCmd <> 'DISABLED') ? $GUI_ENABLE : $GUI_DISABLE))
				GUICtrlSetState($iArgs_Input - 1, (($sType = 'Item' And $sCmd <> 'DISABLED') ? $GUI_ENABLE : $GUI_DISABLE))
				GUICtrlSetState($iIconFile_Input, ((($sType = 'Separator') Or ($sType = 'Item' And $sCmd = 'DISABLED')) ? $GUI_DISABLE : $GUI_ENABLE))
				GUICtrlSetState($iIconFile_Input - 1, ((($sType = 'Separator') Or ($sType = 'Item' And $sCmd = 'DISABLED')) ? $GUI_DISABLE : $GUI_ENABLE))
				GUICtrlSetState($iIconID_Input, ((($sType = 'Separator') Or ($sType = 'Item' And $sCmd = 'DISABLED')) ? $GUI_DISABLE : $GUI_ENABLE))
				GUICtrlSetState($iIconID_Input - 1, ((($sType = 'Separator') Or ($sType = 'Item' And $sCmd = 'DISABLED')) ? $GUI_DISABLE : $GUI_ENABLE))
				GUICtrlSetState($iIconID_Input + 1, (($sType = 'Item' And $sCmd <> 'DISABLED') ? $GUI_ENABLE : $GUI_DISABLE))
				WinSetState($hHotkey_Hotkey, '', (($sType = 'Item' And $sCmd <> 'DISABLED') ? @SW_ENABLE : @SW_DISABLE))
				GUICtrlSetState($iHotkeyIsGlobal_CB, (($sType = 'Item' And $sCmd <> 'DISABLED') ? $GUI_ENABLE : $GUI_DISABLE))
			Case $iPath_Bttn, $iIconFile_Bttn
				Local $aSplit = StringRegExp(GUICtrlRead($iGUIMsg - 1), '^(.*)\\([^\\]*)$|()', 3)
				Local $sSel = FileOpenDialog('Open file', $aSplit[0], 'All (*.*)', 0, $aSplit[1], $hEdit_GUI)
				
				If Not @error Then
					FileChangeDir($sScript_Dir)
					GUICtrlSetData($iGUIMsg - 1, StringReplace($sSel, $sScript_Dir & '\', ''))
				EndIf
			Case $iEditAdd_Bttn
				Local $sNew_Item_Name = GUICtrlRead($iName_Input)
				
				$aInfo[$GDM_INFO_SECTNAME] = GUICtrlRead($iMenuSect_Combo)
				$aInfo[$GDM_INFO_COMMAND] = GUICtrlRead($iCmd_Combo)
				$aInfo[$GDM_INFO_PATH] = GUICtrlRead($iPath_Input)
				$aInfo[$GDM_INFO_ARGS] = GUICtrlRead($iArgs_Input)
				$aInfo[$GDM_INFO_ICONFILE] = GUICtrlRead($iIconFile_Input)
				$aInfo[$GDM_INFO_ICONID] = Number(GUICtrlRead($iIconID_Input))
				$aInfo[$GDM_INFO_HOTKEY] = _GUICtrlHotkey_GetHotkeyName($hHotkey_Hotkey)
				$aInfo[$GDM_INFO_HK_ISGLOBAL] = Int(GUICtrlRead($iHotkeyIsGlobal_CB) = $GUI_CHECKED)
				
				For $iGDM = $GDM_INFO_PATH To $GDM_INFO_HK_ISGLOBAL
					If Not ($aInfo[$iGDM] == '') Then
						$aInfo[$iGDM] = (IsNumber($aInfo[$iGDM]) ? ' ' & $aInfo[$iGDM] : ' "' & $aInfo[$iGDM] & '"')
					EndIf
				Next
				
				If StringStripWS($sNew_Item_Name, 3) = '' Then
					MsgBox(48, 'Attention', 'Item name is empty', 0, $hEdit_GUI)
					ContinueLoop
				EndIf
				
				Local $sItem_Type = StringReplace(GUICtrlRead($iItemType_Combo), 'Separator', '---')
				Local $iPos = Int(GUICtrlRead($iItemPos_Input))
				Local $sOld_Key = ($sItem_Type = '---' ? $sItem_Type : StringFormat('%s, "%s"', $sItem_Type, $sItem_Name))
				Local $sNew_Key = ($sItem_Type = '---' ? $sItem_Type : StringFormat('%s, "%s"', $sItem_Type, $sNew_Item_Name))
				Local $sVal = ''
				
				Switch $sItem_Type
					Case 'Item'
						If $aInfo[$GDM_INFO_COMMAND] = 'DISABLED' Then
							$sVal = 'DISABLED'
						Else
							$sVal = StringFormat('%s,%s,%s,%s,%s,%s,%s', _
								$aInfo[$GDM_INFO_COMMAND], $aInfo[$GDM_INFO_PATH], $aInfo[$GDM_INFO_ARGS], $aInfo[$GDM_INFO_ICONFILE], $aInfo[$GDM_INFO_ICONID], $aInfo[$GDM_INFO_HOTKEY], $aInfo[$GDM_INFO_HK_ISGLOBAL])
						EndIf
					Case 'Submenu'
						If StringStripWS($aInfo[$GDM_INFO_SECTNAME], 3) = '' Then
							MsgBox(48, 'Attention', 'Menu section is empty', 0, $hEdit_GUI)
							ContinueLoop
						EndIf
						
						$sVal = StringFormat('%s,%s,%s', $aInfo[$GDM_INFO_SECTNAME], $aInfo[$GDM_INFO_ICONFILE], $aInfo[$GDM_INFO_ICONID])
					Case '---' ;Separator
						$sVal = $sNew_Item_Name
				EndSwitch
				
				If $fEdit Then
					If $sItem_Type <> '---' And $sOld_Key <> $sNew_Key Then
						_IniEx_RenameKey($sMenu_File, $sSect_Name, $sOld_Key, $sNew_Key)
					EndIf
					
					If $sItem_Type = '---' And $sItem_Name <> $sNew_Item_Name Then
						_IniEx_RenameKeyValue($sMenu_File, $sSect_Name, $sOld_Key, $sItem_Name, $sNew_Key, $sNew_Item_Name, 0)
						
						If @error Then
							MsgBox(48, 'Attention', 'Separator name already exists,' & @CRLF & 'you can set only non existing name for Separator.', 0, $hEdit_GUI)
							ContinueLoop
						EndIf
					Else
						_IniEx_Write($sMenu_File, $sSect_Name, $sNew_Key, $sVal)
					EndIf
				Else ;Add
					_IniEx_Write($sMenu_File, $sSect_Name, $sNew_Key, $sVal, False, -1, $iPos)
				EndIf
				
				If $sItem_Type <> '---' Or ($sItem_Type = '---' And $sItem_Name <> $sNew_Item_Name) Then
					$fReload_Menu = True
				EndIf
				
				ExitLoop
			Case $iDelete_Bttn
				If MsgBox(256 + 52, 'Attention', 'Are you sure, delete item [' & $sItem_Name & ']', 0, $hEdit_GUI) <> 6 Then
					ContinueLoop
				EndIf
				
				Local $sItem_Type = StringReplace(GUICtrlRead($iItemType_Combo), 'Separator', '---')
				
				Switch $sItem_Type
					Case 'Item', 'Submenu'
						IniDelete($sMenu_File, $sSect_Name, $sItem_Type & ', "' & $sItem_Name & '"')
					Case '---'
						_IniEx_Delete($sMenu_File, $sSect_Name, $sItem_Name, True)
				EndSwitch
				
				$fReload_Menu = True
				ExitLoop
		EndSwitch
	WEnd
	
	If $fReload_Menu Then
		 _Menu_Load(True, $hEdit_GUI)
		 _AppInteraction_Send('AutoIt Tools', 'Reload_Menu') ;Reloads menus in AutoIt Tools
	EndIf
	
	GUISetState(@SW_ENABLE, $hGUI)
	GUIDelete($hEdit_GUI)
EndFunc

Func _Menu_SubMenu_Edit($aInfo)
	Local $iW = 500, $iH = 250
	Local $fReload_Menu = False
	
	Local $sOld_Name = $aInfo[$GDM_INFO_ITEMNAME]
	Local $sSect_Name = $aInfo[$GDM_INFO_COMMAND] ;This is set as sect name as a workaround to get parent section name
	
	Local $hEdit_GUI = GUICreate($sApp_Name & ' - Edit', $iW, $iH, -1, -1, -1, $WS_EX_TOOLWINDOW, $hGUI)
	
	GUICtrlCreateLabel('Menu section:', 20, 22)
	Local $iMenuSect_Combo = GUICtrlCreateCombo('', 120, 20, $iW - 140, 20)
	GUICtrlSetData($iMenuSect_Combo, _Menu_Get_Sections(), $aInfo[$GDM_INFO_SECTNAME])
	
	GUICtrlCreateLabel('Name:', 20, 47)
	Local $iName_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_ITEMNAME], 120, 45, $iW - 140, 20)
	
	GUICtrlCreateLabel('Icon file:', 20, 72)
	Local $iIconFile_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_ICONFILE], 120, 70, $iW - 170, 20)
	Local $iIconFile_Bttn = GUICtrlCreateButton('...', $iW - 40, 70, 20, 20)
	
	GUICtrlCreateLabel('Icon ID:', 20, 97)
	Local $iIconID_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_ICONID], 120, 95, $iW - 140, 20)
	
	GUICtrlCreateLabel('External Ini file:', 20, 122)
	Local $iIniFile_Input = GUICtrlCreateInput($aInfo[$GDM_INFO_PATH], 120, 120, $iW - 170, 20)
	Local $iIniFile_Bttn = GUICtrlCreateButton('...', $iW - 40, 120, 20, 20)
	
	GUICtrlCreateLabel('* Paths can be relative to [' & StringRegExpReplace($sMenu_File, '^.*\\', '') & '] file', 20, $iH - 100)
	GUICtrlCreateLabel('* Leave "Icon file:" empty to use icon file from program executable', 20, $iH - 80)
	GUICtrlCreateLabel('* "External Ini file" used to read menu from specific file', 20, $iH - 60)
	
	$iEdit_Bttn = GUICtrlCreateButton('Edit', 20, $iH - 30, 70, 20)
	$iCancel_Bttn = GUICtrlCreateButton('Cancel', 100, $iH - 30, 70, 20)
	$iDelete_Bttn = GUICtrlCreateButton('Delete', $iW - 20 - 70, $iH - 30, 70, 20)
	
	GUISetState(@SW_DISABLE, $hGUI)
	GUISetState(@SW_SHOW, $hEdit_GUI)
	
	While 1
		$iGUIMsg = GUIGetMsg()
		
		Switch $iGUIMsg
			Case $GUI_EVENT_CLOSE, $iCancel_Bttn
				$fReload_Menu = False
				ExitLoop
			Case $iIconFile_Bttn, $iIniFile_Bttn
				Local $aSplit = StringRegExp(GUICtrlRead($iGUIMsg - 1), '^(.*)\\([^\\]*)$|()', 3)
				Local $sSel = FileOpenDialog('Open file', $aSplit[0], 'All (*.*)', 0, $aSplit[1], $hEdit_GUI)
				
				If Not @error Then
					FileChangeDir($sScript_Dir)
					GUICtrlSetData($iGUIMsg - 1, StringReplace($sSel, $sScript_Dir & '\', ''))
				EndIf
			Case $iEdit_Bttn
				$aInfo[$GDM_INFO_ITEMNAME] = GUICtrlRead($iName_Input)
				$aInfo[$GDM_INFO_SECTNAME] = GUICtrlRead($iMenuSect_Combo)
				$aInfo[$GDM_INFO_PATH] = GUICtrlRead($iIniFile_Input)
				$aInfo[$GDM_INFO_ICONFILE] = GUICtrlRead($iIconFile_Input)
				$aInfo[$GDM_INFO_ICONID] = GUICtrlRead($iIconID_Input)
				$aInfo[$GDM_INFO_ICONID] = ($aInfo[$GDM_INFO_ICONID] ? Number($aInfo[$GDM_INFO_ICONID]) : '')
				
				For $iGDM = $GDM_INFO_PATH To $GDM_INFO_ICONID
					If Not ($aInfo[$iGDM] == '') Then
						$aInfo[$iGDM] = (IsNumber($aInfo[$iGDM]) ? ' ' & $aInfo[$iGDM] : ' "' & $aInfo[$iGDM] & '"')
					EndIf
				Next
				
				If StringStripWS($aInfo[$GDM_INFO_SECTNAME], 3) = '' Or StringStripWS($aInfo[$GDM_INFO_ITEMNAME], 3) = '' Then
					MsgBox(48, 'Attention', 'Menu section or Name is empty', 0, $hEdit_GUI)
					ContinueLoop
				EndIf
				
				Local $sOld_Key = StringFormat('Submenu, "%s"', $sOld_Name)
				Local $sNew_Key = StringFormat('Submenu, "%s"', $aInfo[$GDM_INFO_ITEMNAME])
				
				Local $sVal = StringFormat('%s,%s,%s,%s', $aInfo[$GDM_INFO_SECTNAME], $aInfo[$GDM_INFO_ICONFILE], $aInfo[$GDM_INFO_ICONID], $aInfo[$GDM_INFO_PATH])
				
				$sVal = StringRegExpReplace($sVal, ',+$', '')
				
				If Not _IniEx_Exists($sMenu_File, $aInfo[$GDM_INFO_SECTNAME]) Then
					If MsgBox(256 + 52, 'Attention', 'Menu section not exists.' & @CRLF & 'Create new section?', 0, $hEdit_GUI) <> 6 Then
						ContinueLoop
					EndIf
					
					;Create new section
					Local $sRead = FileRead($sMenu_File) & @CRLF & '[' & $aInfo[$GDM_INFO_SECTNAME] & ']'
					Local $hFile = FileOpen($sMenu_File, 2)
					FileWrite($hFile, $sRead)
					FileClose($hFile)
				EndIf
				
				If $sOld_Key <> $sNew_Key Then
					_IniEx_RenameKey($sMenu_File, $sSect_Name, $sOld_Key, $sNew_Key)
				EndIf
				
				_IniEx_Write($sMenu_File, $sSect_Name, $sNew_Key, $sVal)
				
				$fReload_Menu = True
				ExitLoop
			Case $iDelete_Bttn
				If MsgBox(256 + 52, 'Attention', 'Are you sure, delete item [' & $aInfo[$GDM_INFO_ITEMNAME] & ']', 0, $hEdit_GUI) <> 6 Then
					ContinueLoop
				EndIf
				
				IniDelete($sMenu_File, $sSect_Name, 'Submenu, "' & $aInfo[$GDM_INFO_ITEMNAME] & '"')
				
				$fReload_Menu = True
				ExitLoop
		EndSwitch
	WEnd
	
	If $fReload_Menu Then
		 _Menu_Load(True, $hEdit_GUI)
		 _AppInteraction_Send('AutoIt Tools', 'Reload_Menu') ;Reloads menus in AutoIt Tools
	 EndIf
	 
	GUISetState(@SW_ENABLE, $hGUI)
	GUIDelete($hEdit_GUI)
EndFunc

Func _Menu_Get_Sections()
	Local $aSect_Names = IniReadSectionNames($sMenu_File)
	Local $sSect_Names = ''
	
	For $i = 1 To UBound($aSect_Names) - 1
		If Not StringRegExp($aSect_Names[$i], '(?i)^(Tools|Apps|AutoIt On The Web) Menu$') Then
			$sSect_Names &= ($sSect_Names ? '|' : '') & $aSect_Names[$i]
		EndIf
	Next
	
	Return $sSect_Names
EndFunc

Func _Menu_Click_Check($hWnd, $iMsg, $wParam, $lParam)
	If Not $iItem_Grayed_Last Then
		Return
	EndIf
	
;~ 	Local Static $fMDown = False
	Local $aRet = DllCall('user32.dll', 'short', 'GetAsyncKeyState', 'int', '0x1')
	
	If @error Then
		Return 0
	EndIf
	
	If BitAND($aRet[0], 0x8000) Then
		$iItem_Grayed_Selected = $iItem_Grayed_Last
		DllCall('user32.dll', 'int', 'PostMessageW', 'hwnd', $hWnd, 'uint', $WM_LBUTTONUP, 'wparam', 0, 'lparam', 0)
	EndIf
	
;~ 	If Not $fMDown And BitAND($aRet[0], 0x8000) <> 0 Then
;~ 		$fMDown = True
;~ 	ElseIf $fMDown And Not BitAND($aRet[0], 0x8000) Then
;~ 		$fMDown = False
;~ 		$iItem_Grayed_Selected = $iItem_Grayed_Last
;~ 		DllCall('user32.dll', 'int', 'PostMessageW', 'hwnd', $hWnd, 'uint', $WM_LBUTTONDOWN, 'wparam', 0, 'lparam', 0)
;~ 		DllCall('user32.dll', 'int', 'PostMessageW', 'hwnd', $hWnd, 'uint', $WM_LBUTTONUP, 'wparam', 0, 'lparam', 0)
;~ 	EndIf
EndFunc

Func _WM_MENUSELECT($hWnd, $iMsg, $wParam, $lParam)
	Local $iHi = BitShift($wParam, 16)
	
	If BitAND($iHi, $MF_GRAYED) Then
		$iItem_Grayed_Last = BitAND($wParam, 0xFFFF)
	Else
		$iItem_Grayed_Last = 0
	EndIf
	
	Return $GUI_RUNDEFMSG
EndFunc
