#include-once

; #FUNCTION# ====================================================================================================
; Name...........:	_PrintF
; Description....:	Display debug data to console (or in Tooltip/MsgBox, depending on $iOutputFlag).
; Syntax.........:	_PrintF($sStr, $iOutputFlag=0, $iLine=@ScriptLineNumber)
; Parameters.....:	$sStr        - Data string to output.
;					$iOutputFlag - [Optional] Flag that indicates what method the function will use to outpout the data:
;                                     1 - In Tooltip.
;                                     2 - In MsgBox.
;                                     0 (or other than 1 and 2) - To Console (default).
;					$iLine       - [Optional] Line number to display in $sStr data.
;
; Return values..:	None.
;
; Author.........:	(Mr)CreatoR
; Modified.......:	
; Remarks........:	
; Related........:	
; Link...........:	
; Example........:	_PrintF("Debug Info")
; ===============================================================================================================
Func _PrintF($sStr, $iOutputFlag=0, $iLine=@ScriptLineNumber)
	$sStr = StringRegExpReplace(StringRegExpReplace($sStr, "[^\\]\\n", @CRLF), "([\r\n]+)", "\1!	")
	
	Local $sData = _
		"+======================================================" & @CRLF & _
		"--> Script Line (" & $iLine & "):" & @CRLF & "!" & @TAB & $sStr & @CRLF & _
		"+======================================================" & @CRLF
	
	Switch $iOutputFlag
		Case 1 ;Tooltip
			ToolTip($sData)
		Case 2 ;MsgBox
			MsgBox(64, 'PrintF Output', $sData)
		Case Else
			ConsoleWrite(@LF & $sData)
	EndSwitch
EndFunc
