#include-once

; #INDEX# =======================================================================================================================
; Title .........: API Constants UDF Library for AutoIt3
; AutoIt Version : 3.8 / 3.3.8.0
; Language ......: English
; Description ...: System error codes to be used with WinAPIEx UDF library
; Author(s) .....: Yashied
; Requirements...: AutoIt v3.3 +, Developed/Tested on Windows XP Pro Service Pack 2 and Windows Vista/7
; ===============================================================================================================================

; #CONSTANTS# ===================================================================================================================
Global Const $ERROR_SUCCESS = 0 ; The operation completed successfully.
Global Const $ERROR_INVALID_FUNCTION = 1 ; Incorrect function.
Global Const $ERROR_FILE_NOT_FOUND = 2 ; The system cannot find the file specified.
Global Const $ERROR_PATH_NOT_FOUND = 3 ; The system cannot find the path specified.
Global Const $ERROR_TOO_MANY_OPEN_FILES = 4 ; The system cannot open the file.
Global Const $ERROR_ACCESS_DENIED = 5 ; Access is denied.
Global Const $ERROR_INVALID_HANDLE = 6 ; The handle is invalid.
Global Const $ERROR_ARENA_TRASHED = 7 ; The storage control blocks were destroyed.
Global Const $ERROR_NOT_ENOUGH_MEMORY = 8 ; Not enough storage is available to process this command.
Global Const $ERROR_INVALID_BLOCK = 9 ; The storage control block address is invalid.
Global Const $ERROR_BAD_ENVIRONMENT = 10 ; The environment is incorrect.
Global Const $ERROR_BAD_FORMAT = 11 ; An attempt was made to load a program with an incorrect format.
Global Const $ERROR_INVALID_ACCESS = 12 ; The access code is invalid.
Global Const $ERROR_INVALID_DATA = 13 ; The data is invalid.
Global Const $ERROR_OUTOFMEMORY = 14 ; Not enough storage is available to complete this operation.
Global Const $ERROR_INVALID_DRIVE = 15 ; The system cannot find the drive specified.
Global Const $ERROR_CURRENT_DIRECTORY = 16 ; The directory cannot be removed.
Global Const $ERROR_NOT_SAME_DEVICE = 17 ; The system cannot move the file to a different disk drive.
Global Const $ERROR_NO_MORE_FILES = 18 ; There are no more files.
Global Const $ERROR_WRITE_PROTECT = 19 ; The media is write protected.
Global Const $ERROR_BAD_UNIT = 20 ; The system cannot find the device specified.
Global Const $ERROR_NOT_READY = 21 ; The device is not ready.
Global Const $ERROR_BAD_COMMAND = 22 ; The device does not recognize the command.
Global Const $ERROR_CRC = 23 ; Data error (cyclic redundancy check).
Global Const $ERROR_BAD_LENGTH = 24 ; The program issued a command but the command length is incorrect.
Global Const $ERROR_SEEK = 25 ; The drive cannot locate a specific area or track on the disk.
Global Const $ERROR_NOT_DOS_DISK = 26 ; The specified disk or diskette cannot be accessed.
Global Const $ERROR_SECTOR_NOT_FOUND = 27 ; The drive cannot find the sector requested.
Global Const $ERROR_OUT_OF_PAPER = 28 ; The printer is out of paper.
Global Const $ERROR_WRITE_FAULT = 29 ; The system cannot write to the specified device.
Global Const $ERROR_READ_FAULT = 30 ; The system cannot read from the specified device.
Global Const $ERROR_GEN_FAILURE = 31 ; A device attached to the system is not functioning.
Global Const $ERROR_SHARING_VIOLATION = 32 ; The process cannot access the file because it is being used by another process.
Global Const $ERROR_LOCK_VIOLATION = 33 ; The process cannot access the file because another process has locked a portion of the file.
Global Const $ERROR_WRONG_DISK = 34 ; The wrong diskette is in the drive. Insert %2 (Volume Serial Number: %3) into drive %1.
Global Const $ERROR_SHARING_BUFFER_EXCEEDED = 36 ; Too many files opened for sharing.
Global Const $ERROR_HANDLE_EOF = 38 ; Reached the end of the file.
Global Const $ERROR_HANDLE_DISK_FULL = 39 ; The disk is full.
Global Const $ERROR_NOT_SUPPORTED = 50 ; The request is not supported.
Global Const $ERROR_REM_NOT_LIST = 51 ; Windows cannot find the network path. Verify that the network path is correct and the destination computer is not busy or turned off. If Windows still cannot find the network path, contact your network administrator.
Global Const $ERROR_DUP_NAME = 52 ; You were not connected because a duplicate name exists on the network. If joining a domain, go to System in Control Panel to change the computer name and try again. If joining a workgroup, choose another workgroup name.
Global Const $ERROR_BAD_NETPATH = 53 ; The network path was not found.
Global Const $ERROR_NETWORK_BUSY = 54 ; The network is busy.
Global Const $ERROR_DEV_NOT_EXIST = 55 ; The specified network resource or device is no longer available.
Global Const $ERROR_TOO_MANY_CMDS = 56 ; The network BIOS command limit has been reached.
Global Const $ERROR_ADAP_HDW_ERR = 57 ; A network adapter hardware error occurred.
Global Const $ERROR_BAD_NET_RESP = 58 ; The specified server cannot perform the requested operation.
Global Const $ERROR_UNEXP_NET_ERR = 59 ; An unexpected network error occurred.
Global Const $ERROR_BAD_REM_ADAP = 60 ; The remote adapter is not compatible.
Global Const $ERROR_PRINTQ_FULL = 61 ; The printer queue is full.
Global Const $ERROR_NO_SPOOL_SPACE = 62 ; Space to store the file waiting to be printed is not available on the server.
Global Const $ERROR_PRINT_CANCELLED = 63 ; Your file waiting to be printed was deleted.
Global Const $ERROR_NETNAME_DELETED = 64 ; The specified network name is no longer available.
Global Const $ERROR_NETWORK_ACCESS_DENIED = 65 ; Network access is denied.
Global Const $ERROR_BAD_DEV_TYPE = 66 ; The network resource type is not correct.
Global Const $ERROR_BAD_NET_NAME = 67 ; The network name cannot be found.
Global Const $ERROR_TOO_MANY_NAMES = 68 ; The name limit for the local computer network adapter card was exceeded.
Global Const $ERROR_TOO_MANY_SESS = 69 ; The network BIOS session limit was exceeded.
Global Const $ERROR_SHARING_PAUSED = 70 ; The remote server has been paused or is in the process of being started.
Global Const $ERROR_REQ_NOT_ACCEP = 71 ; No more connections can be made to this remote computer at this time because there are already as many connections as the computer can accept.
Global Const $ERROR_REDIR_PAUSED = 72 ; The specified printer or disk device has been paused.
Global Const $ERROR_FILE_EXISTS = 80 ; The file exists.
Global Const $ERROR_CANNOT_MAKE = 82 ; The directory or file cannot be created.
Global Const $ERROR_FAIL_I24 = 83 ; Fail on INT 24.
Global Const $ERROR_OUT_OF_STRUCTURES = 84 ; Storage to process this request is not available.
Global Const $ERROR_ALREADY_ASSIGNED = 85 ; The local device name is already in use.
Global Const $ERROR_INVALID_PASSWORD = 86 ; The specified network password is not correct.
Global Const $ERROR_INVALID_PARAMETER = 87 ; The parameter is incorrect.
Global Const $ERROR_NET_WRITE_FAULT = 88 ; A write fault occurred on the network.
Global Const $ERROR_NO_PROC_SLOTS = 89 ; The system cannot start another process at this time.
Global Const $ERROR_TOO_MANY_SEMAPHORES = 100 ; Cannot create another system semaphore.
Global Const $ERROR_EXCL_SEM_ALREADY_OWNED = 101 ; The exclusive semaphore is owned by another process.
Global Const $ERROR_SEM_IS_SET = 102 ; The semaphore is set and cannot be closed.
Global Const $ERROR_TOO_MANY_SEM_REQUESTS = 103 ; The semaphore cannot be set again.
Global Const $ERROR_INVALID_AT_INTERRUPT_TIME = 104 ; Cannot request exclusive semaphores at interrupt time.
Global Const $ERROR_SEM_OWNER_DIED = 105 ; The previous ownership of this semaphore has ended.
Global Const $ERROR_SEM_USER_LIMIT = 106 ; Insert the diskette for drive %1.
Global Const $ERROR_DISK_CHANGE = 107 ; The program stopped because an alternate diskette was not inserted.
Global Const $ERROR_DRIVE_LOCKED = 108 ; The disk is in use or locked by another process.
Global Const $ERROR_BROKEN_PIPE = 109 ; The pipe has been ended.
Global Const $ERROR_OPEN_FAILED = 110 ; The system cannot open the device or file specified.
Global Const $ERROR_BUFFER_OVERFLOW = 111 ; The file name is too long.
Global Const $ERROR_DISK_FULL = 112 ; There is not enough space on the disk.
Global Const $ERROR_NO_MORE_SEARCH_HANDLES = 113 ; No more internal file identifiers available.
Global Const $ERROR_INVALID_TARGET_HANDLE = 114 ; The target internal file identifier is incorrect.
Global Const $ERROR_INVALID_CATEGORY = 117 ; The IOCTL call made by the application program is not correct.
Global Const $ERROR_INVALID_VERIFY_SWITCH = 118 ; The verify-on-write switch parameter value is not correct.
Global Const $ERROR_BAD_DRIVER_LEVEL = 119 ; The system does not support the command requested.
Global Const $ERROR_CALL_NOT_IMPLEMENTED = 120 ; This function is not supported on this system.
Global Const $ERROR_SEM_TIMEOUT = 121 ; The semaphore timeout period has expired.
Global Const $ERROR_INSUFFICIENT_BUFFER = 122 ; The data area passed to a system call is too small.
Global Const $ERROR_INVALID_NAME = 123 ; The filename, directory name, or volume label syntax is incorrect.
Global Const $ERROR_INVALID_LEVEL = 124 ; The system call level is not correct.
Global Const $ERROR_NO_VOLUME_LABEL = 125 ; The disk has no volume label.
Global Const $ERROR_MOD_NOT_FOUND = 126 ; The specified module could not be found.
Global Const $ERROR_PROC_NOT_FOUND = 127 ; The specified procedure could not be found.
Global Const $ERROR_WAIT_NO_CHILDREN = 128 ; There are no child processes to wait for.
Global Const $ERROR_CHILD_NOT_COMPLETE = 129 ; The %1 application cannot be run in Win32 mode.
Global Const $ERROR_DIRECT_ACCESS_HANDLE = 130 ; Attempt to use a file handle to an open disk partition for an operation other than raw disk I/O.
Global Const $ERROR_NEGATIVE_SEEK = 131 ; An attempt was made to move the file pointer before the beginning of the file.
Global Const $ERROR_SEEK_ON_DEVICE = 132 ; The file pointer cannot be set on the specified device or file.
Global Const $ERROR_IS_JOIN_TARGET = 133 ; A JOIN or SUBST command cannot be used for a drive that contains previously joined drives.
Global Const $ERROR_IS_JOINED = 134 ; An attempt was made to use a JOIN or SUBST command on a drive that has already been joined.
Global Const $ERROR_IS_SUBSTED = 135 ; An attempt was made to use a JOIN or SUBST command on a drive that has already been substituted.
Global Const $ERROR_NOT_JOINED = 136 ; The system tried to delete the JOIN of a drive that is not joined.
Global Const $ERROR_NOT_SUBSTED = 137 ; The system tried to delete the substitution of a drive that is not substituted.
Global Const $ERROR_JOIN_TO_JOIN = 138 ; The system tried to join a drive to a directory on a joined drive.
Global Const $ERROR_SUBST_TO_SUBST = 139 ; The system tried to substitute a drive to a directory on a substituted drive.
Global Const $ERROR_JOIN_TO_SUBST = 140 ; The system tried to join a drive to a directory on a substituted drive.
Global Const $ERROR_SUBST_TO_JOIN = 141 ; The system tried to SUBST a drive to a directory on a joined drive.
Global Const $ERROR_BUSY_DRIVE = 142 ; The system cannot perform a JOIN or SUBST at this time.
Global Const $ERROR_SAME_DRIVE = 143 ; The system cannot join or substitute a drive to or for a directory on the same drive.
Global Const $ERROR_DIR_NOT_ROOT = 144 ; The directory is not a subdirectory of the root directory.
Global Const $ERROR_DIR_NOT_EMPTY = 145 ; The directory is not empty.
Global Const $ERROR_IS_SUBST_PATH = 146 ; The path specified is being used in a substitute.
Global Const $ERROR_IS_JOIN_PATH = 147 ; Not enough resources are available to process this command.
Global Const $ERROR_PATH_BUSY = 148 ; The path specified cannot be used at this time.
Global Const $ERROR_IS_SUBST_TARGET = 149 ; An attempt was made to join or substitute a drive for which a directory on the drive is the target of a previous substitute.
Global Const $ERROR_SYSTEM_TRACE = 150 ; System trace information was not specified in your CONFIG.SYS file, or tracing is disallowed.
Global Const $ERROR_INVALID_EVENT_COUNT = 151 ; The number of specified semaphore events for DosMuxSemWait is not correct.
Global Const $ERROR_TOO_MANY_MUXWAITERS = 152 ; DosMuxSemWait did not execute; too many semaphores are already set.
Global Const $ERROR_INVALID_LIST_FORMAT = 153 ; The DosMuxSemWait list is not correct.
Global Const $ERROR_LABEL_TOO_LONG = 154 ; The volume label you entered exceeds the label character limit of the target file system.
Global Const $ERROR_TOO_MANY_TCBS = 155 ; Cannot create another thread.
Global Const $ERROR_SIGNAL_REFUSED = 156 ; The recipient process has refused the signal.
Global Const $ERROR_DISCARDED = 157 ; The segment is already discarded and cannot be locked.
Global Const $ERROR_NOT_LOCKED = 158 ; The segment is already unlocked.
Global Const $ERROR_BAD_THREADID_ADDR = 159 ; The address for the thread ID is not correct.
Global Const $ERROR_BAD_ARGUMENTS = 160 ; One or more arguments are not correct.
Global Const $ERROR_BAD_PATHNAME = 161 ; The specified path is invalid.
Global Const $ERROR_SIGNAL_PENDING = 162 ; A signal is already pending.
Global Const $ERROR_MAX_THRDS_REACHED = 164 ; No more threads can be created in the system.
Global Const $ERROR_LOCK_FAILED = 167 ; Unable to lock a region of a file.
Global Const $ERROR_BUSY = 170 ; The requested resource is in use.
Global Const $ERROR_CANCEL_VIOLATION = 173 ; A lock request was not outstanding for the supplied cancel region.
Global Const $ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174 ; The file system does not support atomic changes to the lock type.
Global Const $ERROR_INVALID_SEGMENT_NUMBER = 180 ; The system detected a segment number that was not correct.
Global Const $ERROR_INVALID_ORDINAL = 182 ; The operating system cannot run %1.
Global Const $ERROR_ALREADY_EXISTS = 183 ; Cannot create a file when that file already exists.
Global Const $ERROR_INVALID_FLAG_NUMBER = 186 ; The flag passed is not correct.
Global Const $ERROR_SEM_NOT_FOUND = 187 ; The specified system semaphore name was not found.
Global Const $ERROR_INVALID_STARTING_CODESEG = 188 ; The operating system cannot run %1.
Global Const $ERROR_INVALID_STACKSEG = 189 ; The operating system cannot run %1.
Global Const $ERROR_INVALID_MODULETYPE = 190 ; The operating system cannot run %1.
Global Const $ERROR_INVALID_EXE_SIGNATURE = 191 ; Cannot run %1 in Win32 mode.
Global Const $ERROR_EXE_MARKED_INVALID = 192 ; The operating system cannot run %1.
Global Const $ERROR_BAD_EXE_FORMAT = 193 ; %1 is not a valid Win32 application.
Global Const $ERROR_ITERATED_DATA_EXCEEDS_64k = 194 ; The operating system cannot run %1.
Global Const $ERROR_INVALID_MINALLOCSIZE = 195 ; The operating system cannot run %1.
Global Const $ERROR_DYNLINK_FROM_INVALID_RING = 196 ; The operating system cannot run this application program.
Global Const $ERROR_IOPL_NOT_ENABLED = 197 ; The operating system is not presently configured to run this application.
Global Const $ERROR_INVALID_SEGDPL = 198 ; The operating system cannot run %1.
Global Const $ERROR_AUTODATASEG_EXCEEDS_64k = 199 ; The operating system cannot run this application program.
Global Const $ERROR_RING2SEG_MUST_BE_MOVABLE = 200 ; The code segment cannot be greater than or equal to 64K.
Global Const $ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201 ; The operating system cannot run %1.
Global Const $ERROR_INFLOOP_IN_RELOC_CHAIN = 202 ; The operating system cannot run %1.
Global Const $ERROR_ENVVAR_NOT_FOUND = 203 ; The system could not find the environment option that was entered.
Global Const $ERROR_NO_SIGNAL_SENT = 205 ; No process in the command subtree has a signal handler.
Global Const $ERROR_FILENAME_EXCED_RANGE = 206 ; The filename or extension is too long.
Global Const $ERROR_RING2_STACK_IN_USE = 207 ; The ring 2 stack is in use.
Global Const $ERROR_META_EXPANSION_TOO_LONG = 208 ; The global filename characters, * or ?, are entered incorrectly or too many global filename characters are specified.
Global Const $ERROR_INVALID_SIGNAL_NUMBER = 209 ; The signal being posted is not correct.
Global Const $ERROR_THREAD_1_INACTIVE = 210 ; The signal handler cannot be set.
Global Const $ERROR_LOCKED = 212 ; The segment is locked and cannot be reallocated.
Global Const $ERROR_TOO_MANY_MODULES = 214 ; Too many dynamic-link modules are attached to this program or dynamic-link module.
Global Const $ERROR_NESTING_NOT_ALLOWED = 215 ; Cannot nest calls to LoadModule.
Global Const $ERROR_EXE_MACHINE_TYPE_MISMATCH = 216 ; The version of %1 is not compatible with the version you're running. Check your computer's system information to see whether you need a x86 (32-bit) or x64 (64-bit) version of the program, and then contact the software publisher.
Global Const $ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY = 217 ; The image file %1 is signed, unable to modify.
Global Const $ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY = 218 ; The image file %1 is strong signed, unable to modify.
Global Const $ERROR_FILE_CHECKED_OUT = 220 ; This file is checked out or locked for editing by another user.
Global Const $ERROR_CHECKOUT_REQUIRED = 221 ; The file must be checked out before saving changes.
Global Const $ERROR_BAD_FILE_TYPE = 222 ; The file type being saved or retrieved has been blocked.
Global Const $ERROR_FILE_TOO_LARGE = 223 ; The file size exceeds the limit allowed and cannot be saved.
Global Const $ERROR_FORMS_AUTH_REQUIRED = 224 ; Access Denied. Before opening files in this location, you must first add the web site to your trusted sites list, browse to the web site, and select the option to login automatically.
Global Const $ERROR_VIRUS_INFECTED = 225 ; Operation did not complete successfully because the file contains a virus.
Global Const $ERROR_VIRUS_DELETED = 226 ; This file contains a virus and cannot be opened. Due to the nature of this virus, the file has been removed from this location.
Global Const $ERROR_PIPE_LOCAL = 229 ; The pipe is local.
Global Const $ERROR_BAD_PIPE = 230 ; The pipe state is invalid.
Global Const $ERROR_PIPE_BUSY = 231 ; All pipe instances are busy.
Global Const $ERROR_NO_DATA = 232 ; The pipe is being closed.
Global Const $ERROR_PIPE_NOT_CONNECTED = 233 ; No process is on the other end of the pipe.
Global Const $ERROR_MORE_DATA = 234 ; More data is available.
Global Const $ERROR_VC_DISCONNECTED = 240 ; The session was canceled.
Global Const $ERROR_INVALID_EA_NAME = 254 ; The specified extended attribute name was invalid.
Global Const $ERROR_EA_LIST_INCONSISTENT = 255 ; The extended attributes are inconsistent.
Global Const $WAIT_TIMEOUT = 258 ; The wait operation timed out.
Global Const $ERROR_NO_MORE_ITEMS = 259 ; No more data is available.
Global Const $ERROR_CANNOT_COPY = 266 ; The copy functions cannot be used.
Global Const $ERROR_DIRECTORY = 267 ; The directory name is invalid.
Global Const $ERROR_EAS_DIDNT_FIT = 275 ; The extended attributes did not fit in the buffer.
Global Const $ERROR_EA_FILE_CORRUPT = 276 ; The extended attribute file on the mounted file system is corrupt.
Global Const $ERROR_EA_TABLE_FULL = 277 ; The extended attribute table file is full.
Global Const $ERROR_INVALID_EA_HANDLE = 278 ; The specified extended attribute handle is invalid.
Global Const $ERROR_EAS_NOT_SUPPORTED = 282 ; The mounted file system does not support extended attributes.
Global Const $ERROR_NOT_OWNER = 288 ; Attempt to release mutex not owned by caller.
Global Const $ERROR_TOO_MANY_POSTS = 298 ; Too many posts were made to a semaphore.
Global Const $ERROR_PARTIAL_COPY = 299 ; Only part of a ReadProcessMemory or WriteProcessMemory request was completed.
Global Const $ERROR_OPLOCK_NOT_GRANTED = 300 ; The oplock request is denied.
Global Const $ERROR_INVALID_OPLOCK_PROTOCOL = 301 ; An invalid oplock acknowledgment was received by the system.
Global Const $ERROR_DISK_TOO_FRAGMENTED = 302 ; The volume is too fragmented to complete this operation.
Global Const $ERROR_DELETE_PENDING = 303 ; The file cannot be opened because it is in the process of being deleted.
Global Const $ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING = 304 ; Short name settings may not be changed on this volume due to the global registry setting.
Global Const $ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME = 305 ; Short names are not enabled on this volume.
Global Const $ERROR_SECURITY_STREAM_IS_INCONSISTENT = 306 ; The security stream for the given volume is in an inconsistent state. Please run CHKDSK on the volume.
Global Const $ERROR_INVALID_LOCK_RANGE = 307 ; A requested file lock operation cannot be processed due to an invalid byte range.
Global Const $ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT = 308 ; The subsystem needed to support the image type is not present.
Global Const $ERROR_NOTIFICATION_GUID_ALREADY_DEFINED = 309 ; The specified file already has a notification GUID associated with it.
Global Const $ERROR_MR_MID_NOT_FOUND = 317 ; The system cannot find message text for message number 0x%1 in the message file for %2.
Global Const $ERROR_SCOPE_NOT_FOUND = 318 ; The scope specified was not found.
Global Const $ERROR_FAIL_NOACTION_REBOOT = 350 ; No action was taken as a system reboot is required.
Global Const $ERROR_FAIL_SHUTDOWN = 351 ; The shutdown operation failed.
Global Const $ERROR_FAIL_RESTART = 352 ; The restart operation failed.
Global Const $ERROR_MAX_SESSIONS_REACHED = 353 ; The maximum number of sessions has been reached.
Global Const $ERROR_THREAD_MODE_ALREADY_BACKGROUND = 400 ; The thread is already in background processing mode.
Global Const $ERROR_THREAD_MODE_NOT_BACKGROUND = 401 ; The thread is not in background processing mode.
Global Const $ERROR_PROCESS_MODE_ALREADY_BACKGROUND = 402 ; The process is already in background processing mode.
Global Const $ERROR_PROCESS_MODE_NOT_BACKGROUND = 403 ; The process is not in background processing mode.
Global Const $ERROR_INVALID_ADDRESS = 487 ; Attempt to access invalid address.
Global Const $ERROR_USER_PROFILE_LOAD = 500 ; User profile cannot be loaded.
Global Const $ERROR_ARITHMETIC_OVERFLOW = 534 ; Arithmetic result exceeded 32 bits.
Global Const $ERROR_PIPE_CONNECTED = 535 ; There is a process on other end of the pipe.
Global Const $ERROR_PIPE_LISTENING = 536 ; Waiting for a process to open the other end of the pipe.
Global Const $ERROR_VERIFIER_STOP = 537 ; Application verifier has found an error in the current process.
Global Const $ERROR_ABIOS_ERROR = 538 ; An error occurred in the ABIOS subsystem.
Global Const $ERROR_WX86_WARNING = 539 ; A warning occurred in the WX86 subsystem.
Global Const $ERROR_WX86_ERROR = 540 ; An error occurred in the WX86 subsystem.
Global Const $ERROR_TIMER_NOT_CANCELED = 541 ; An attempt was made to cancel or set a timer that has an associated APC and the subject thread is not the thread that originally set the timer with an associated APC routine.
Global Const $ERROR_UNWIND = 542 ; Unwind exception code.
Global Const $ERROR_BAD_STACK = 543 ; An invalid or unaligned stack was encountered during an unwind operation.
Global Const $ERROR_INVALID_UNWIND_TARGET = 544 ; An invalid unwind target was encountered during an unwind operation.
Global Const $ERROR_INVALID_PORT_ATTRIBUTES = 545 ; Invalid Object Attributes specified to NtCreatePort or invalid Port Attributes specified to NtConnectPort.
Global Const $ERROR_PORT_MESSAGE_TOO_LONG = 546 ; Length of message passed to NtRequestPort or NtRequestWaitReplyPort was longer than the maximum message allowed by the port.
Global Const $ERROR_INVALID_QUOTA_LOWER = 547 ; An attempt was made to lower a quota limit below the current usage.
Global Const $ERROR_DEVICE_ALREADY_ATTACHED = 548 ; An attempt was made to attach to a device that was already attached to another device.
Global Const $ERROR_INSTRUCTION_MISALIGNMENT = 549 ; An attempt was made to execute an instruction at an unaligned address and the host system does not support unaligned instruction references.
Global Const $ERROR_PROFILING_NOT_STARTED = 550 ; Profiling not started.
Global Const $ERROR_PROFILING_NOT_STOPPED = 551 ; Profiling not stopped.
Global Const $ERROR_COULD_NOT_INTERPRET = 552 ; The passed ACL did not contain the minimum required information.
Global Const $ERROR_PROFILING_AT_LIMIT = 553 ; The number of active profiling objects is at the maximum and no more may be started.
Global Const $ERROR_CANT_WAIT = 554 ; Used to indicate that an operation cannot continue without blocking for I/O.
Global Const $ERROR_CANT_TERMINATE_SELF = 555 ; Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process.
Global Const $ERROR_UNEXPECTED_MM_CREATE_ERR = 556 ; If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
Global Const $ERROR_UNEXPECTED_MM_MAP_ERROR = 557 ; If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
Global Const $ERROR_UNEXPECTED_MM_EXTEND_ERR = 558 ; If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
Global Const $ERROR_BAD_FUNCTION_TABLE = 559 ; A malformed function table was encountered during an unwind operation.
Global Const $ERROR_NO_GUID_TRANSLATION = 560 ; Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail.
Global Const $ERROR_INVALID_LDT_SIZE = 561 ; Indicates that an attempt was made to grow an LDT by setting its size, or that the size was not an even number of selectors.
Global Const $ERROR_INVALID_LDT_OFFSET = 563 ; Indicates that the starting value for the LDT information was not an integral multiple of the selector size.
Global Const $ERROR_INVALID_LDT_DESCRIPTOR = 564 ; Indicates that the user supplied an invalid descriptor when trying to set up Ldt descriptors.
Global Const $ERROR_TOO_MANY_THREADS = 565 ; Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads.
Global Const $ERROR_THREAD_NOT_IN_PROCESS = 566 ; An attempt was made to operate on a thread within a specific process, but the thread specified is not in the process specified.
Global Const $ERROR_PAGEFILE_QUOTA_EXCEEDED = 567 ; Page file quota was exceeded.
Global Const $ERROR_LOGON_SERVER_CONFLICT = 568 ; The Netlogon service cannot start because another Netlogon service running in the domain conflicts with the specified role.
Global Const $ERROR_SYNCHRONIZATION_REQUIRED = 569 ; The SAM database on a Windows Server is significantly out of synchronization with the copy on the Domain Controller. A complete synchronization is required.
Global Const $ERROR_NET_OPEN_FAILED = 570 ; The NtCreateFile API failed. This error should never be returned to an application, it is a place holder for the Windows Lan Manager Redirector to use in its internal error mapping routines.
Global Const $ERROR_IO_PRIVILEGE_FAILED = 571 ; {Privilege Failed} The I/O permissions for the process could not be changed.
Global Const $ERROR_CONTROL_C_EXIT = 572 ; {Application Exit by CTRL+C} The application terminated as a result of a CTRL+C.
Global Const $ERROR_MISSING_SYSTEMFILE = 573 ; {Missing System File} The required system file %hs is bad or missing.
Global Const $ERROR_UNHANDLED_EXCEPTION = 574 ; {Application Error} The exception %s (0x%08lx) occurred in the application at location 0x%08lx.
Global Const $ERROR_APP_INIT_FAILURE = 575 ; {Application Error} The application failed to initialize properly (0x%lx). Click OK to terminate the application.
Global Const $ERROR_PAGEFILE_CREATE_FAILED = 576 ; {Unable to Create Paging File} The creation of the paging file %hs failed (%lx). The requested size was %ld.
Global Const $ERROR_INVALID_IMAGE_HASH = 577 ; Windows cannot verify the digital signature for this file. A recent hardware or software change might have installed a file that is signed incorrectly or damaged, or that might be malicious software from an unknown source.
Global Const $ERROR_NO_PAGEFILE = 578 ; {No Paging File Specified} No paging file was specified in the system configuration.
Global Const $ERROR_ILLEGAL_FLOAT_CONTEXT = 579 ; {EXCEPTION} A real-mode application issued a floating-point instruction and floating-point hardware is not present.
Global Const $ERROR_NO_EVENT_PAIR = 580 ; An event pair synchronization operation was performed using the thread specific client/server event pair object, but no event pair object was associated with the thread.
Global Const $ERROR_DOMAIN_CTRLR_CONFIG_ERROR = 581 ; A Windows Server has an incorrect configuration.
Global Const $ERROR_ILLEGAL_CHARACTER = 582 ; An illegal character was encountered. For a multi-byte character set this includes a lead byte without a succeeding trail byte. For the Unicode character set this includes the characters 0xFFFF and 0xFFFE.
Global Const $ERROR_UNDEFINED_CHARACTER = 583 ; The Unicode character is not defined in the Unicode character set installed on the system.
Global Const $ERROR_FLOPPY_VOLUME = 584 ; The paging file cannot be created on a floppy diskette.
Global Const $ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT = 585 ; The system BIOS failed to connect a system interrupt to the device or bus for which the device is connected.
Global Const $ERROR_BACKUP_CONTROLLER = 586 ; This operation is only allowed for the Primary Domain Controller of the domain.
Global Const $ERROR_MUTANT_LIMIT_EXCEEDED = 587 ; An attempt was made to acquire a mutant such that its maximum count would have been exceeded.
Global Const $ERROR_FS_DRIVER_REQUIRED = 588 ; A volume has been accessed for which a file system driver is required that has not yet been loaded.
Global Const $ERROR_CANNOT_LOAD_REGISTRY_FILE = 589 ; {Registry File Failure} The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable.
Global Const $ERROR_DEBUG_ATTACH_FAILED = 590 ; {Unexpected Failure in DebugActiveProcess} An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error.
Global Const $ERROR_SYSTEM_PROCESS_TERMINATED = 591 ; {Fatal System Error} The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down.
Global Const $ERROR_DATA_NOT_ACCEPTED = 592 ; {Data Not Accepted} The TDI client could not handle the data received during an indication.
Global Const $ERROR_VDM_HARD_ERROR = 593 ; NTVDM encountered a hard error.
Global Const $ERROR_DRIVER_CANCEL_TIMEOUT = 594 ; {Cancel Timeout} The driver %hs failed to complete a canceled I/O request in the allotted time.
Global Const $ERROR_REPLY_MESSAGE_MISMATCH = 595 ; {Reply Message Mismatch} An attempt was made to reply to an LPC message, but the thread specified by the client ID in the message was not waiting on that message.
Global Const $ERROR_LOST_WRITEBEHIND_DATA = 596 ; {Delayed Write Failed} Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Please try to save this file elsewhere.
Global Const $ERROR_CLIENT_SERVER_PARAMETERS_INVALID = 597 ; The parameter(s) passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window.
Global Const $ERROR_NOT_TINY_STREAM = 598 ; The stream is not a tiny stream.
Global Const $ERROR_STACK_OVERFLOW_READ = 599 ; The request must be handled by the stack overflow code.
Global Const $ERROR_CONVERT_TO_LARGE = 600 ; Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing node is moved or the extent stream is converted to a large stream.
Global Const $ERROR_FOUND_OUT_OF_SCOPE = 601 ; The attempt to find the object found an object matching by ID on the volume but it is out of the scope of the handle used for the operation.
Global Const $ERROR_ALLOCATE_BUCKET = 602 ; The bucket array must be grown. Retry transaction after doing so.
Global Const $ERROR_MARSHALL_OVERFLOW = 603 ; The user/kernel marshalling buffer has overflowed.
Global Const $ERROR_INVALID_VARIANT = 604 ; The supplied variant structure contains invalid data.
Global Const $ERROR_BAD_COMPRESSION_BUFFER = 605 ; The specified buffer contains ill-formed data.
Global Const $ERROR_AUDIT_FAILED = 606 ; {Audit Failed} An attempt to generate a security audit failed.
Global Const $ERROR_TIMER_RESOLUTION_NOT_SET = 607 ; The timer resolution was not previously set by the current process.
Global Const $ERROR_INSUFFICIENT_LOGON_INFO = 608 ; There is insufficient account information to log you on.
Global Const $ERROR_BAD_DLL_ENTRYPOINT = 609 ; {Invalid DLL Entry point} The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entry point should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly.
Global Const $ERROR_BAD_SERVICE_ENTRYPOINT = 610 ; {Invalid Service Callback Entry point} The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entry point should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly.
Global Const $ERROR_IP_ADDRESS_CONFLICT1 = 611 ; There is an IP address conflict with another system on the network.
Global Const $ERROR_IP_ADDRESS_CONFLICT2 = 612 ; There is an IP address conflict with another system on the network.
Global Const $ERROR_REGISTRY_QUOTA_LIMIT = 613 ; {Low On Registry Space} The system has reached the maximum size allowed for the system part of the registry. Additional storage requests will be ignored.
Global Const $ERROR_NO_CALLBACK_ACTIVE = 614 ; A callback return system service cannot be executed when no callback is active.
Global Const $ERROR_PWD_TOO_SHORT = 615 ; The password provided is too short to meet the policy of your user account. Please choose a longer password.
Global Const $ERROR_PWD_TOO_RECENT = 616 ; The policy of your user account does not allow you to change passwords too frequently. This is done to prevent users from changing back to a familiar, but potentially discovered, password. If you feel your password has been compromised then please contact your administrator immediately to have a new one assigned.
Global Const $ERROR_PWD_HISTORY_CONFLICT = 617 ; You have attempted to change your password to one that you have used in the past. The policy of your user account does not allow this. Please select a password that you have not previously used.
Global Const $ERROR_UNSUPPORTED_COMPRESSION = 618 ; The specified compression format is unsupported.
Global Const $ERROR_INVALID_HW_PROFILE = 619 ; The specified hardware profile configuration is invalid.
Global Const $ERROR_INVALID_PLUGPLAY_DEVICE_PATH = 620 ; The specified Plug and Play registry device path is invalid.
Global Const $ERROR_QUOTA_LIST_INCONSISTENT = 621 ; The specified quota list is internally inconsistent with its descriptor.
Global Const $ERROR_EVALUATION_EXPIRATION = 622 ; {Windows Evaluation Notification} The evaluation period for this installation of Windows has expired. This system will shutdown in 1 hour. To restore access to this installation of Windows, please upgrade this installation using a licensed distribution of this product.
Global Const $ERROR_ILLEGAL_DLL_RELOCATION = 623 ; {Illegal System DLL Relocation} The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL.
Global Const $ERROR_DLL_INIT_FAILED_LOGOFF = 624 ; {DLL Initialization Failed} The application failed to initialize because the window station is shutting down.
Global Const $ERROR_VALIDATE_CONTINUE = 625 ; The validation process needs to continue on to the next step.
Global Const $ERROR_NO_MORE_MATCHES = 626 ; There are no more matches for the current index enumeration.
Global Const $ERROR_RANGE_LIST_CONFLICT = 627 ; The range could not be added to the range list because of a conflict.
Global Const $ERROR_SERVER_SID_MISMATCH = 628 ; The server process is running under a SID different than that required by client.
Global Const $ERROR_CANT_ENABLE_DENY_ONLY = 629 ; A group marked use for deny only cannot be enabled.
Global Const $ERROR_FLOAT_MULTIPLE_FAULTS = 630 ; {EXCEPTION} Multiple floating point faults.
Global Const $ERROR_FLOAT_MULTIPLE_TRAPS = 631 ; {EXCEPTION} Multiple floating point traps.
Global Const $ERROR_NOINTERFACE = 632 ; The requested interface is not supported.
Global Const $ERROR_DRIVER_FAILED_SLEEP = 633 ; {System Standby Failed} The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode.
Global Const $ERROR_CORRUPT_SYSTEM_FILE = 634 ; The system file %1 has become corrupt and has been replaced.
Global Const $ERROR_COMMITMENT_MINIMUM = 635 ; {Virtual Memory Minimum Too Low} Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help.
Global Const $ERROR_PNP_RESTART_ENUMERATION = 636 ; A device was removed so enumeration must be restarted.
Global Const $ERROR_SYSTEM_IMAGE_BAD_SIGNATURE = 637 ; {Fatal System Error} The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down.
Global Const $ERROR_PNP_REBOOT_REQUIRED = 638 ; Device will not start without a reboot.
Global Const $ERROR_INSUFFICIENT_POWER = 639 ; There is not enough power to complete the requested operation.
Global Const $ERROR_MULTIPLE_FAULT_VIOLATION = 640 ; ERROR_MULTIPLE_FAULT_VIOLATION
Global Const $ERROR_SYSTEM_SHUTDOWN = 641 ; The system is in the process of shutting down.
Global Const $ERROR_PORT_NOT_SET = 642 ; An attempt to remove a processes DebugPort was made, but a port was not already associated with the process.
Global Const $ERROR_DS_VERSION_CHECK_FAILURE = 643 ; This version of Windows is not compatible with the behavior version of directory forest, domain or domain controller.
Global Const $ERROR_RANGE_NOT_FOUND = 644 ; The specified range could not be found in the range list.
Global Const $ERROR_NOT_SAFE_MODE_DRIVER = 646 ; The driver was not loaded because the system is booting into safe mode.
Global Const $ERROR_FAILED_DRIVER_ENTRY = 647 ; The driver was not loaded because it failed it's initialization call.
Global Const $ERROR_DEVICE_ENUMERATION_ERROR = 648 ; The "%hs" encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection.
Global Const $ERROR_MOUNT_POINT_NOT_RESOLVED = 649 ; The create operation failed because the name contained at least one mount point which resolves to a volume to which the specified device object is not attached.
Global Const $ERROR_INVALID_DEVICE_OBJECT_PARAMETER = 650 ; The device object parameter is either not a valid device object or is not attached to the volume specified by the file name.
Global Const $ERROR_MCA_OCCURED = 651 ; A Machine Check Error has occurred. Please check the system event log for additional information.
Global Const $ERROR_DRIVER_DATABASE_ERROR = 652 ; There was error [%2] processing the driver database.
Global Const $ERROR_SYSTEM_HIVE_TOO_LARGE = 653 ; System hive size has exceeded its limit.
Global Const $ERROR_DRIVER_FAILED_PRIOR_UNLOAD = 654 ; The driver could not be loaded because a previous version of the driver is still in memory.
Global Const $ERROR_VOLSNAP_PREPARE_HIBERNATE = 655 ; {Volume Shadow Copy Service} Please wait while the Volume Shadow Copy Service prepares volume %hs for hibernation.
Global Const $ERROR_HIBERNATION_FAILURE = 656 ; The system has failed to hibernate (The error code is %hs). Hibernation will be disabled until the system is restarted.
Global Const $ERROR_FILE_SYSTEM_LIMITATION = 665 ; The requested operation could not be completed due to a file system limitation.
Global Const $ERROR_ASSERTION_FAILURE = 668 ; An assertion failure has occurred.
Global Const $ERROR_ACPI_ERROR = 669 ; An error occurred in the ACPI subsystem.
Global Const $ERROR_WOW_ASSERTION = 670 ; WOW Assertion Error.
Global Const $ERROR_PNP_BAD_MPS_TABLE = 671 ; A device is missing in the system BIOS MPS table. This device will not be used. Please contact your system vendor for system BIOS update.
Global Const $ERROR_PNP_TRANSLATION_FAILED = 672 ; A translator failed to translate resources.
Global Const $ERROR_PNP_IRQ_TRANSLATION_FAILED = 673 ; A IRQ translator failed to translate resources.
Global Const $ERROR_PNP_INVALID_ID = 674 ; Driver %2 returned invalid ID for a child device (%3).
Global Const $ERROR_WAKE_SYSTEM_DEBUGGER = 675 ; {Kernel Debugger Awakened} the system debugger was awakened by an interrupt.
Global Const $ERROR_HANDLES_CLOSED = 676 ; {Handles Closed} Handles to objects have been automatically closed as a result of the requested operation.
Global Const $ERROR_EXTRANEOUS_INFORMATION = 677 ; {Too Much Information} The specified access control list (ACL) contained more information than was expected.
Global Const $ERROR_RXACT_COMMIT_NECESSARY = 678 ; This warning level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has NOT been completed, but has not been rolled back either (so it may still be committed if desired).
Global Const $ERROR_MEDIA_CHECK = 679 ; {Media Changed} The media may have changed.
Global Const $ERROR_GUID_SUBSTITUTION_MADE = 680 ; {GUID Substitution} During the translation of a global identifier (GUID) to a Windows security ID (SID), no administratively-defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide a more restrictive access than intended.
Global Const $ERROR_STOPPED_ON_SYMLINK = 681 ; The create operation stopped after reaching a symbolic link.
Global Const $ERROR_LONGJUMP = 682 ; A long jump has been executed.
Global Const $ERROR_PLUGPLAY_QUERY_VETOED = 683 ; The Plug and Play query operation was not successful.
Global Const $ERROR_UNWIND_CONSOLIDATE = 684 ; A frame consolidation has been executed.
Global Const $ERROR_REGISTRY_HIVE_RECOVERED = 685 ; {Registry Hive Recovered} Registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost.
Global Const $ERROR_DLL_MIGHT_BE_INSECURE = 686 ; The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?
Global Const $ERROR_DLL_MIGHT_BE_INCOMPATIBLE = 687 ; The application is loading executable code from the module %hs. This is secure, but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?
Global Const $ERROR_DBG_EXCEPTION_NOT_HANDLED = 688 ; Debugger did not handle the exception.
Global Const $ERROR_DBG_REPLY_LATER = 689 ; Debugger will reply later.
Global Const $ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE = 690 ; Debugger cannot provide handle.
Global Const $ERROR_DBG_TERMINATE_THREAD = 691 ; Debugger terminated thread.
Global Const $ERROR_DBG_TERMINATE_PROCESS = 692 ; Debugger terminated process.
Global Const $ERROR_DBG_CONTROL_C = 693 ; Debugger got control C.
Global Const $ERROR_DBG_PRINTEXCEPTION_C = 694 ; Debugger printed exception on control C.
Global Const $ERROR_DBG_RIPEXCEPTION = 695 ; Debugger received RIP exception.
Global Const $ERROR_DBG_CONTROL_BREAK = 696 ; Debugger received control break.
Global Const $ERROR_DBG_COMMAND_EXCEPTION = 697 ; Debugger command communication exception.
Global Const $ERROR_OBJECT_NAME_EXISTS = 698 ; {Object Exists} An attempt was made to create an object and the object name already existed.
Global Const $ERROR_THREAD_WAS_SUSPENDED = 699 ; {Thread Suspended} A thread termination occurred while the thread was suspended. The thread was resumed, and termination proceeded.
Global Const $ERROR_IMAGE_NOT_AT_BASE = 700 ; {Image Relocated} An image file could not be mapped at the address specified in the image file. Local fixups must be performed on this image.
Global Const $ERROR_RXACT_STATE_CREATED = 701 ; This informational level status indicates that a specified registry sub-tree transaction state did not yet exist and had to be created.
Global Const $ERROR_SEGMENT_NOTIFICATION = 702 ; {Segment Load} A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so a debugger can load, unload or track symbols and breakpoints within these 16-bit segments.
Global Const $ERROR_BAD_CURRENT_DIRECTORY = 703 ; {Invalid Current Directory} The process cannot switch to the startup current directory %hs. Select OK to set current directory to %hs, or select CANCEL to exit.
Global Const $ERROR_FT_READ_RECOVERY_FROM_BACKUP = 704 ; {Redundant Read} To satisfy a read request, the NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was unable to reassign the failing area of the device.
Global Const $ERROR_FT_WRITE_RECOVERY = 705 ; {Redundant Write} To satisfy a write request, the NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was not able to reassign the failing area of the device.
Global Const $ERROR_IMAGE_MACHINE_TYPE_MISMATCH = 706 ; {Machine Type Mismatch} The image file %hs is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load.
Global Const $ERROR_RECEIVE_PARTIAL = 707 ; {Partial Data Received} The network transport returned partial data to its client. The remaining data will be sent later.
Global Const $ERROR_RECEIVE_EXPEDITED = 708 ; {Expedited Data Received} The network transport returned data to its client that was marked as expedited by the remote system.
Global Const $ERROR_RECEIVE_PARTIAL_EXPEDITED = 709 ; {Partial Expedited Data Received} The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later.
Global Const $ERROR_EVENT_DONE = 710 ; {TDI Event Done} The TDI indication has completed successfully.
Global Const $ERROR_EVENT_PENDING = 711 ; {TDI Event Pending} The TDI indication has entered the pending state.
Global Const $ERROR_CHECKING_FILE_SYSTEM = 712 ; Checking file system on %wZ
Global Const $ERROR_FATAL_APP_EXIT = 713 ; {Fatal Application Exit} %hs
Global Const $ERROR_PREDEFINED_HANDLE = 714 ; The specified registry key is referenced by a predefined handle.
Global Const $ERROR_WAS_UNLOCKED = 715 ; {Page Unlocked} The page protection of a locked page was changed to 'No Access' and the page was unlocked from memory and from the process.
Global Const $ERROR_SERVICE_NOTIFICATION = 716 ; %hs
Global Const $ERROR_WAS_LOCKED = 717 ; {Page Locked} One of the pages to lock was already locked.
Global Const $ERROR_LOG_HARD_ERROR = 718 ; Application popup: %1 : %2
Global Const $ERROR_ALREADY_WIN32 = 719 ; ERROR_ALREADY_WIN32
Global Const $ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE = 720 ; {Machine Type Mismatch} The image file %hs is valid, but is for a machine type other than the current machine.
Global Const $ERROR_NO_YIELD_PERFORMED = 721 ; A yield execution was performed and no thread was available to run.
Global Const $ERROR_TIMER_RESUME_IGNORED = 722 ; The resumable flag to a timer API was ignored.
Global Const $ERROR_ARBITRATION_UNHANDLED = 723 ; The arbiter has deferred arbitration of these resources to its parent.
Global Const $ERROR_CARDBUS_NOT_SUPPORTED = 724 ; The inserted CardBus device cannot be started because of a configuration error on "%hs".
Global Const $ERROR_MP_PROCESSOR_MISMATCH = 725 ; The CPUs in this multiprocessor system are not all the same revision level. To use all processors the operating system restricts itself to the features of the least capable processor in the system. Should problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported.
Global Const $ERROR_HIBERNATED = 726 ; The system was put into hibernation.
Global Const $ERROR_RESUME_HIBERNATION = 727 ; The system was resumed from hibernation.
Global Const $ERROR_FIRMWARE_UPDATED = 728 ; Windows has detected that the system firmware (BIOS) was updated [previous firmware date = %2, current firmware date %3].
Global Const $ERROR_DRIVERS_LEAKING_LOCKED_PAGES = 729 ; A device driver is leaking locked I/O pages causing system degradation. The system has automatically enabled tracking code in order to try and catch the culprit.
Global Const $ERROR_WAKE_SYSTEM = 730 ; The system has awoken.
Global Const $ERROR_WAIT_1 = 731 ; ERROR_WAIT_1
Global Const $ERROR_WAIT_2 = 732 ; ERROR_WAIT_2
Global Const $ERROR_WAIT_3 = 733 ; ERROR_WAIT_3
Global Const $ERROR_WAIT_63 = 734 ; ERROR_WAIT_63
Global Const $ERROR_ABANDONED_WAIT_0 = 735 ; ERROR_ABANDONED_WAIT_0
Global Const $ERROR_ABANDONED_WAIT_63 = 736 ; ERROR_ABANDONED_WAIT_63
Global Const $ERROR_USER_APC = 737 ; ERROR_USER_APC
Global Const $ERROR_KERNEL_APC = 738 ; ERROR_KERNEL_APC
Global Const $ERROR_ALERTED = 739 ; ERROR_ALERTED
Global Const $ERROR_ELEVATION_REQUIRED = 740 ; The requested operation requires elevation.
Global Const $ERROR_REPARSE = 741 ; A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
Global Const $ERROR_OPLOCK_BREAK_IN_PROGRESS = 742 ; An open/create operation completed while an oplock break is underway.
Global Const $ERROR_VOLUME_MOUNTED = 743 ; A new volume has been mounted by a file system.
Global Const $ERROR_RXACT_COMMITTED = 744 ; This success level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has now been completed.
Global Const $ERROR_NOTIFY_CLEANUP = 745 ; This indicates that a notify change request has been completed due to closing the handle which made the notify change request.
Global Const $ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED = 746 ; {Connect Failure on Primary Transport} An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer WAS able to connect on a secondary transport.
Global Const $ERROR_PAGE_FAULT_TRANSITION = 747 ; Page fault was a transition fault.
Global Const $ERROR_PAGE_FAULT_DEMAND_ZERO = 748 ; Page fault was a demand zero fault.
Global Const $ERROR_PAGE_FAULT_COPY_ON_WRITE = 749 ; Page fault was a demand zero fault.
Global Const $ERROR_PAGE_FAULT_GUARD_PAGE = 750 ; Page fault was a demand zero fault.
Global Const $ERROR_PAGE_FAULT_PAGING_FILE = 751 ; Page fault was satisfied by reading from a secondary storage device.
Global Const $ERROR_CACHE_PAGE_LOCKED = 752 ; Cached page was locked during operation.
Global Const $ERROR_CRASH_DUMP = 753 ; Crash dump exists in paging file.
Global Const $ERROR_BUFFER_ALL_ZEROS = 754 ; Specified buffer contains all zeros.
Global Const $ERROR_REPARSE_OBJECT = 755 ; A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
Global Const $ERROR_RESOURCE_REQUIREMENTS_CHANGED = 756 ; The device has succeeded a query-stop and its resource requirements have changed.
Global Const $ERROR_TRANSLATION_COMPLETE = 757 ; The translator has translated these resources into the global space and no further translations should be performed.
Global Const $ERROR_NOTHING_TO_TERMINATE = 758 ; A process being terminated has no threads to terminate.
Global Const $ERROR_PROCESS_NOT_IN_JOB = 759 ; The specified process is not part of a job.
Global Const $ERROR_PROCESS_IN_JOB = 760 ; The specified process is part of a job.
Global Const $ERROR_VOLSNAP_HIBERNATE_READY = 761 ; {Volume Shadow Copy Service} The system is now ready for hibernation.
Global Const $ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY = 762 ; A file system or file system filter driver has successfully completed an FsFilter operation.
Global Const $ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED = 763 ; The specified interrupt vector was already connected.
Global Const $ERROR_INTERRUPT_STILL_CONNECTED = 764 ; The specified interrupt vector is still connected.
Global Const $ERROR_WAIT_FOR_OPLOCK = 765 ; An operation is blocked waiting for an oplock.
Global Const $ERROR_DBG_EXCEPTION_HANDLED = 766 ; Debugger handled exception.
Global Const $ERROR_DBG_CONTINUE = 767 ; Debugger continued.
Global Const $ERROR_CALLBACK_POP_STACK = 768 ; An exception occurred in a user mode callback and the kernel callback frame should be removed.
Global Const $ERROR_COMPRESSION_DISABLED = 769 ; Compression is disabled for this volume.
Global Const $ERROR_CANTFETCHBACKWARDS = 770 ; The data provider cannot fetch backwards through a result set.
Global Const $ERROR_CANTSCROLLBACKWARDS = 771 ; The data provider cannot scroll backwards through a result set.
Global Const $ERROR_ROWSNOTRELEASED = 772 ; The data provider requires that previously fetched data is released before asking for more data.
Global Const $ERROR_BAD_ACCESSOR_FLAGS = 773 ; The data provider was not able to interpret the flags set for a column binding in an accessor.
Global Const $ERROR_ERRORS_ENCOUNTERED = 774 ; One or more errors occurred while processing the request.
Global Const $ERROR_NOT_CAPABLE = 775 ; The implementation is not capable of performing the request.
Global Const $ERROR_REQUEST_OUT_OF_SEQUENCE = 776 ; The client of a component requested an operation which is not valid given the state of the component instance.
Global Const $ERROR_VERSION_PARSE_ERROR = 777 ; A version number could not be parsed.
Global Const $ERROR_BADSTARTPOSITION = 778 ; The iterator's start position is invalid.
Global Const $ERROR_MEMORY_HARDWARE = 779 ; The hardware has reported an uncorrectable memory error.
Global Const $ERROR_DISK_REPAIR_DISABLED = 780 ; The attempted operation required self healing to be enabled.
Global Const $ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE = 781 ; The Desktop heap encountered an error while allocating session memory. There is more information in the system event log.
Global Const $ERROR_SYSTEM_POWERSTATE_TRANSITION = 782 ; The system power state is transitioning from %2 to %3.
Global Const $ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION = 783 ; The system power state is transitioning from %2 to %3 but could enter %4.
Global Const $ERROR_MCA_EXCEPTION = 784 ; A thread is getting dispatched with MCA EXCEPTION because of MCA.
Global Const $ERROR_ACCESS_AUDIT_BY_POLICY = 785 ; Access to %1 is monitored by policy rule %2.
Global Const $ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY = 786 ; Access to %1 has been restricted by your Administrator by policy rule %2.
Global Const $ERROR_ABANDON_HIBERFILE = 787 ; A valid hibernation file has been invalidated and should be abandoned.
Global Const $ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED = 788 ; {Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused by network connectivity issues. Please try to save this file elsewhere.
Global Const $ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR = 789 ; {Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error was returned by the server on which the file exists. Please try to save this file elsewhere.
Global Const $ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR = 790 ; {Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused if the device has been removed or the media is write-protected.
Global Const $ERROR_BAD_MCFG_TABLE = 791 ; The resources required for this device conflict with the MCFG table.
Global Const $ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE = 800 ; The oplock that was associated with this handle is now associated with a different handle.
Global Const $ERROR_CANNOT_GRANT_REQUESTED_OPLOCK = 801 ; An oplock of the requested level cannot be granted. An oplock of a lower level may be available.
Global Const $ERROR_CANNOT_BREAK_OPLOCK = 802 ; The operation did not complete successfully because it would cause an oplock to be broken. The caller has requested that existing oplocks not be broken.
Global Const $ERROR_OPLOCK_HANDLE_CLOSED = 803 ; The handle with which this oplock was associated has been closed. The oplock is now broken.
Global Const $ERROR_NO_ACE_CONDITION = 804 ; The specified access control entry (ACE) does not contain a condition.
Global Const $ERROR_INVALID_ACE_CONDITION = 805 ; The specified access control entry (ACE) contains an invalid condition.
Global Const $ERROR_EA_ACCESS_DENIED = 994 ; Access to the extended attribute was denied.
Global Const $ERROR_OPERATION_ABORTED = 995 ; The I/O operation has been aborted because of either a thread exit or an application request.
Global Const $ERROR_IO_INCOMPLETE = 996 ; Overlapped I/O event is not in a signaled state.
Global Const $ERROR_IO_PENDING = 997 ; Overlapped I/O operation is in progress.
Global Const $ERROR_NOACCESS = 998 ; Invalid access to memory location.
Global Const $ERROR_SWAPERROR = 999 ; Error performing inpage operation.
Global Const $ERROR_STACK_OVERFLOW = 1001 ; Recursion too deep; the stack overflowed.
Global Const $ERROR_INVALID_MESSAGE = 1002 ; The window cannot act on the sent message.
Global Const $ERROR_CAN_NOT_COMPLETE = 1003 ; Cannot complete this function.
Global Const $ERROR_INVALID_FLAGS = 1004 ; Invalid flags.
Global Const $ERROR_UNRECOGNIZED_VOLUME = 1005 ; The volume does not contain a recognized file system. Please make sure that all required file system drivers are loaded and that the volume is not corrupted.
Global Const $ERROR_FILE_INVALID = 1006 ; The volume for a file has been externally altered so that the opened file is no longer valid.
Global Const $ERROR_FULLSCREEN_MODE = 1007 ; The requested operation cannot be performed in full-screen mode.
Global Const $ERROR_NO_TOKEN = 1008 ; An attempt was made to reference a token that does not exist.
Global Const $ERROR_BADDB = 1009 ; The configuration registry database is corrupt.
Global Const $ERROR_BADKEY = 1010 ; The configuration registry key is invalid.
Global Const $ERROR_CANTOPEN = 1011 ; The configuration registry key could not be opened.
Global Const $ERROR_CANTREAD = 1012 ; The configuration registry key could not be read.
Global Const $ERROR_CANTWRITE = 1013 ; The configuration registry key could not be written.
Global Const $ERROR_REGISTRY_RECOVERED = 1014 ; One of the files in the registry database had to be recovered by use of a log or alternate copy. The recovery was successful.
Global Const $ERROR_REGISTRY_CORRUPT = 1015 ; The registry is corrupted. The structure of one of the files containing registry data is corrupted, or the system's memory image of the file is corrupted, or the file could not be recovered because the alternate copy or log was absent or corrupted.
Global Const $ERROR_REGISTRY_IO_FAILED = 1016 ; An I/O operation initiated by the registry failed unrecoverably. The registry could not read in, or write out, or flush, one of the files that contain the system's image of the registry.
Global Const $ERROR_NOT_REGISTRY_FILE = 1017 ; The system has attempted to load or restore a file into the registry, but the specified file is not in a registry file format.
Global Const $ERROR_KEY_DELETED = 1018 ; Illegal operation attempted on a registry key that has been marked for deletion.
Global Const $ERROR_NO_LOG_SPACE = 1019 ; System could not allocate the required space in a registry log.
Global Const $ERROR_KEY_HAS_CHILDREN = 1020 ; Cannot create a symbolic link in a registry key that already has subkeys or values.
Global Const $ERROR_CHILD_MUST_BE_VOLATILE = 1021 ; Cannot create a stable subkey under a volatile parent key.
Global Const $ERROR_NOTIFY_ENUM_DIR = 1022 ; A notify change request is being completed and the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes.
Global Const $ERROR_DEPENDENT_SERVICES_RUNNING = 1051 ; A stop control has been sent to a service that other running services are dependent on.
Global Const $ERROR_INVALID_SERVICE_CONTROL = 1052 ; The requested control is not valid for this service.
Global Const $ERROR_SERVICE_REQUEST_TIMEOUT = 1053 ; The service did not respond to the start or control request in a timely fashion.
Global Const $ERROR_SERVICE_NO_THREAD = 1054 ; A thread could not be created for the service.
Global Const $ERROR_SERVICE_DATABASE_LOCKED = 1055 ; The service database is locked.
Global Const $ERROR_SERVICE_ALREADY_RUNNING = 1056 ; An instance of the service is already running.
Global Const $ERROR_INVALID_SERVICE_ACCOUNT = 1057 ; The account name is invalid or does not exist, or the password is invalid for the account name specified.
Global Const $ERROR_SERVICE_DISABLED = 1058 ; The service cannot be started, either because it is disabled or because it has no enabled devices associated with it.
Global Const $ERROR_CIRCULAR_DEPENDENCY = 1059 ; Circular service dependency was specified.
Global Const $ERROR_SERVICE_DOES_NOT_EXIST = 1060 ; The specified service does not exist as an installed service.
Global Const $ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061 ; The service cannot accept control messages at this time.
Global Const $ERROR_SERVICE_NOT_ACTIVE = 1062 ; The service has not been started.
Global Const $ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063 ; The service process could not connect to the service controller.
Global Const $ERROR_EXCEPTION_IN_SERVICE = 1064 ; An exception occurred in the service when handling the control request.
Global Const $ERROR_DATABASE_DOES_NOT_EXIST = 1065 ; The database specified does not exist.
Global Const $ERROR_SERVICE_SPECIFIC_ERROR = 1066 ; The service has returned a service-specific error code.
Global Const $ERROR_PROCESS_ABORTED = 1067 ; The process terminated unexpectedly.
Global Const $ERROR_SERVICE_DEPENDENCY_FAIL = 1068 ; The dependency service or group failed to start.
Global Const $ERROR_SERVICE_LOGON_FAILED = 1069 ; The service did not start due to a logon failure.
Global Const $ERROR_SERVICE_START_HANG = 1070 ; After starting, the service hung in a start-pending state.
Global Const $ERROR_INVALID_SERVICE_LOCK = 1071 ; The specified service database lock is invalid.
Global Const $ERROR_SERVICE_MARKED_FOR_DELETE = 1072 ; The specified service has been marked for deletion.
Global Const $ERROR_SERVICE_EXISTS = 1073 ; The specified service already exists.
Global Const $ERROR_ALREADY_RUNNING_LKG = 1074 ; The system is currently running with the last-known-good configuration.
Global Const $ERROR_SERVICE_DEPENDENCY_DELETED = 1075 ; The dependency service does not exist or has been marked for deletion.
Global Const $ERROR_BOOT_ALREADY_ACCEPTED = 1076 ; The current boot has already been accepted for use as the last-known-good control set.
Global Const $ERROR_SERVICE_NEVER_STARTED = 1077 ; No attempts to start the service have been made since the last boot.
Global Const $ERROR_DUPLICATE_SERVICE_NAME = 1078 ; The name is already in use as either a service name or a service display name.
Global Const $ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079 ; The account specified for this service is different from the account specified for other services running in the same process.
Global Const $ERROR_CANNOT_DETECT_DRIVER_FAILURE = 1080 ; Failure actions can only be set for Win32 services, not for drivers.
Global Const $ERROR_CANNOT_DETECT_PROCESS_ABORT = 1081 ; This service runs in the same process as the service control manager. Therefore, the service control manager cannot take action if this service's process terminates unexpectedly.
Global Const $ERROR_NO_RECOVERY_PROGRAM = 1082 ; No recovery program has been configured for this service.
Global Const $ERROR_SERVICE_NOT_IN_EXE = 1083 ; The executable program that this service is configured to run in does not implement the service.
Global Const $ERROR_NOT_SAFEBOOT_SERVICE = 1084 ; This service cannot be started in Safe Mode.
Global Const $ERROR_END_OF_MEDIA = 1100 ; The physical end of the tape has been reached.
Global Const $ERROR_FILEMARK_DETECTED = 1101 ; A tape access reached a filemark.
Global Const $ERROR_BEGINNING_OF_MEDIA = 1102 ; The beginning of the tape or a partition was encountered.
Global Const $ERROR_SETMARK_DETECTED = 1103 ; A tape access reached the end of a set of files.
Global Const $ERROR_NO_DATA_DETECTED = 1104 ; No more data is on the tape.
Global Const $ERROR_PARTITION_FAILURE = 1105 ; Tape could not be partitioned.
Global Const $ERROR_INVALID_BLOCK_LENGTH = 1106 ; When accessing a new tape of a multivolume partition, the current block size is incorrect.
Global Const $ERROR_DEVICE_NOT_PARTITIONED = 1107 ; Tape partition information could not be found when loading a tape.
Global Const $ERROR_UNABLE_TO_LOCK_MEDIA = 1108 ; Unable to lock the media eject mechanism.
Global Const $ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109 ; Unable to unload the media.
Global Const $ERROR_MEDIA_CHANGED = 1110 ; The media in the drive may have changed.
Global Const $ERROR_BUS_RESET = 1111 ; The I/O bus was reset.
Global Const $ERROR_NO_MEDIA_IN_DRIVE = 1112 ; No media in drive.
Global Const $ERROR_NO_UNICODE_TRANSLATION = 1113 ; No mapping for the Unicode character exists in the target multi-byte code page.
Global Const $ERROR_DLL_INIT_FAILED = 1114 ; A dynamic link library (DLL) initialization routine failed.
Global Const $ERROR_SHUTDOWN_IN_PROGRESS = 1115 ; A system shutdown is in progress.
Global Const $ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116 ; Unable to abort the system shutdown because no shutdown was in progress.
Global Const $ERROR_IO_DEVICE = 1117 ; The request could not be performed because of an I/O device error.
Global Const $ERROR_SERIAL_NO_DEVICE = 1118 ; No serial device was successfully initialized. The serial driver will unload.
Global Const $ERROR_IRQ_BUSY = 1119 ; Unable to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened.
Global Const $ERROR_MORE_WRITES = 1120 ; A serial I/O operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero)
Global Const $ERROR_COUNTER_TIMEOUT = 1121 ; A serial I/O operation completed because the timeout period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero)
Global Const $ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122 ; No ID address mark was found on the floppy disk.
Global Const $ERROR_FLOPPY_WRONG_CYLINDER = 1123 ; Mismatch between the floppy disk sector ID field and the floppy disk controller track address.
Global Const $ERROR_FLOPPY_UNKNOWN_ERROR = 1124 ; The floppy disk controller reported an error that is not recognized by the floppy disk driver.
Global Const $ERROR_FLOPPY_BAD_REGISTERS = 1125 ; The floppy disk controller returned inconsistent results in its registers.
Global Const $ERROR_DISK_RECALIBRATE_FAILED = 1126 ; While accessing the hard disk, a recalibrate operation failed, even after retries.
Global Const $ERROR_DISK_OPERATION_FAILED = 1127 ; While accessing the hard disk, a disk operation failed even after retries.
Global Const $ERROR_DISK_RESET_FAILED = 1128 ; While accessing the hard disk, a disk controller reset was needed, but even that failed.
Global Const $ERROR_EOM_OVERFLOW = 1129 ; Physical end of tape encountered.
Global Const $ERROR_NOT_ENOUGH_SERVER_MEMORY = 1130 ; Not enough server storage is available to process this command.
Global Const $ERROR_POSSIBLE_DEADLOCK = 1131 ; A potential deadlock condition has been detected.
Global Const $ERROR_MAPPED_ALIGNMENT = 1132 ; The base address or the file offset specified does not have the proper alignment.
Global Const $ERROR_SET_POWER_STATE_VETOED = 1140 ; An attempt to change the system power state was vetoed by another application or driver.
Global Const $ERROR_SET_POWER_STATE_FAILED = 1141 ; The system BIOS failed an attempt to change the system power state.
Global Const $ERROR_TOO_MANY_LINKS = 1142 ; An attempt was made to create more links on a file than the file system supports.
Global Const $ERROR_OLD_WIN_VERSION = 1150 ; The specified program requires a newer version of Windows.
Global Const $ERROR_APP_WRONG_OS = 1151 ; The specified program is not a Windows or MS-DOS program.
Global Const $ERROR_SINGLE_INSTANCE_APP = 1152 ; Cannot start more than one instance of the specified program.
Global Const $ERROR_RMODE_APP = 1153 ; The specified program was written for an earlier version of Windows.
Global Const $ERROR_INVALID_DLL = 1154 ; One of the library files needed to run this application is damaged.
Global Const $ERROR_NO_ASSOCIATION = 1155 ; No application is associated with the specified file for this operation.
Global Const $ERROR_DDE_FAIL = 1156 ; An error occurred in sending the command to the application.
Global Const $ERROR_DLL_NOT_FOUND = 1157 ; One of the library files needed to run this application cannot be found.
Global Const $ERROR_NO_MORE_USER_HANDLES = 1158 ; The current process has used all of its system allowance of handles for Window Manager objects.
Global Const $ERROR_MESSAGE_SYNC_ONLY = 1159 ; The message can be used only with synchronous operations.
Global Const $ERROR_SOURCE_ELEMENT_EMPTY = 1160 ; The indicated source element has no media.
Global Const $ERROR_DESTINATION_ELEMENT_FULL = 1161 ; The indicated destination element already contains media.
Global Const $ERROR_ILLEGAL_ELEMENT_ADDRESS = 1162 ; The indicated element does not exist.
Global Const $ERROR_MAGAZINE_NOT_PRESENT = 1163 ; The indicated element is part of a magazine that is not present.
Global Const $ERROR_DEVICE_REINITIALIZATION_NEEDED = 1164 ; The indicated device requires reinitialization due to hardware errors.
Global Const $ERROR_DEVICE_REQUIRES_CLEANING = 1165 ; The device has indicated that cleaning is required before further operations are attempted.
Global Const $ERROR_DEVICE_DOOR_OPEN = 1166 ; The device has indicated that its door is open.
Global Const $ERROR_DEVICE_NOT_CONNECTED = 1167 ; The device is not connected.
Global Const $ERROR_NOT_FOUND = 1168 ; Element not found.
Global Const $ERROR_NO_MATCH = 1169 ; There was no match for the specified key in the index.
Global Const $ERROR_SET_NOT_FOUND = 1170 ; The property set specified does not exist on the object.
Global Const $ERROR_POINT_NOT_FOUND = 1171 ; The point passed to GetMouseMovePoints is not in the buffer.
Global Const $ERROR_NO_TRACKING_SERVICE = 1172 ; The tracking (workstation) service is not running.
Global Const $ERROR_NO_VOLUME_ID = 1173 ; The Volume ID could not be found.
Global Const $ERROR_UNABLE_TO_REMOVE_REPLACED = 1175 ; Unable to remove the file to be replaced.
Global Const $ERROR_UNABLE_TO_MOVE_REPLACEMENT = 1176 ; Unable to move the replacement file to the file to be replaced. The file to be replaced has retained its original name.
Global Const $ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 = 1177 ; Unable to move the replacement file to the file to be replaced. The file to be replaced has been renamed using the backup name.
Global Const $ERROR_JOURNAL_DELETE_IN_PROGRESS = 1178 ; The volume change journal is being deleted.
Global Const $ERROR_JOURNAL_NOT_ACTIVE = 1179 ; The volume change journal is not active.
Global Const $ERROR_POTENTIAL_FILE_FOUND = 1180 ; A file was found, but it may not be the correct file.
Global Const $ERROR_JOURNAL_ENTRY_DELETED = 1181 ; The journal entry has been deleted from the journal.
Global Const $ERROR_SHUTDOWN_IS_SCHEDULED = 1190 ; A system shutdown has already been scheduled.
Global Const $ERROR_SHUTDOWN_USERS_LOGGED_ON = 1191 ; The system shutdown cannot be initiated because there are other users logged on to the computer.
Global Const $ERROR_BAD_DEVICE = 1200 ; The specified device name is invalid.
Global Const $ERROR_CONNECTION_UNAVAIL = 1201 ; The device is not currently connected but it is a remembered connection.
Global Const $ERROR_DEVICE_ALREADY_REMEMBERED = 1202 ; The local device name has a remembered connection to another network resource.
Global Const $ERROR_NO_NET_OR_BAD_PATH = 1203 ; The network path was either typed incorrectly, does not exist, or the network provider is not currently available. Please try retyping the path or contact your network administrator.
Global Const $ERROR_BAD_PROVIDER = 1204 ; The specified network provider name is invalid.
Global Const $ERROR_CANNOT_OPEN_PROFILE = 1205 ; Unable to open the network connection profile.
Global Const $ERROR_BAD_PROFILE = 1206 ; The network connection profile is corrupted.
Global Const $ERROR_NOT_CONTAINER = 1207 ; Cannot enumerate a noncontainer.
Global Const $ERROR_EXTENDED_ERROR = 1208 ; An extended error has occurred.
Global Const $ERROR_INVALID_GROUPNAME = 1209 ; The format of the specified group name is invalid.
Global Const $ERROR_INVALID_COMPUTERNAME = 1210 ; The format of the specified computer name is invalid.
Global Const $ERROR_INVALID_EVENTNAME = 1211 ; The format of the specified event name is invalid.
Global Const $ERROR_INVALID_DOMAINNAME = 1212 ; The format of the specified domain name is invalid.
Global Const $ERROR_INVALID_SERVICENAME = 1213 ; The format of the specified service name is invalid.
Global Const $ERROR_INVALID_NETNAME = 1214 ; The format of the specified network name is invalid.
Global Const $ERROR_INVALID_SHARENAME = 1215 ; The format of the specified share name is invalid.
Global Const $ERROR_INVALID_PASSWORDNAME = 1216 ; The format of the specified password is invalid.
Global Const $ERROR_INVALID_MESSAGENAME = 1217 ; The format of the specified message name is invalid.
Global Const $ERROR_INVALID_MESSAGEDEST = 1218 ; The format of the specified message destination is invalid.
Global Const $ERROR_SESSION_CREDENTIAL_CONFLICT = 1219 ; Multiple connections to a server or shared resource by the same user, using more than one user name, are not allowed. Disconnect all previous connections to the server or shared resource and try again.
Global Const $ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220 ; An attempt was made to establish a session to a network server, but there are already too many sessions established to that server.
Global Const $ERROR_DUP_DOMAINNAME = 1221 ; The workgroup or domain name is already in use by another computer on the network.
Global Const $ERROR_NO_NETWORK = 1222 ; The network is not present or not started.
Global Const $ERROR_CANCELLED = 1223 ; The operation was canceled by the user.
Global Const $ERROR_USER_MAPPED_FILE = 1224 ; The requested operation cannot be performed on a file with a user-mapped section open.
Global Const $ERROR_CONNECTION_REFUSED = 1225 ; The remote computer refused the network connection.
Global Const $ERROR_GRACEFUL_DISCONNECT = 1226 ; The network connection was gracefully closed.
Global Const $ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227 ; The network transport endpoint already has an address associated with it.
Global Const $ERROR_ADDRESS_NOT_ASSOCIATED = 1228 ; An address has not yet been associated with the network endpoint.
Global Const $ERROR_CONNECTION_INVALID = 1229 ; An operation was attempted on a nonexistent network connection.
Global Const $ERROR_CONNECTION_ACTIVE = 1230 ; An invalid operation was attempted on an active network connection.
Global Const $ERROR_NETWORK_UNREACHABLE = 1231 ; The network location cannot be reached. For information about network troubleshooting, see Windows Help.
Global Const $ERROR_HOST_UNREACHABLE = 1232 ; The network location cannot be reached. For information about network troubleshooting, see Windows Help.
Global Const $ERROR_PROTOCOL_UNREACHABLE = 1233 ; The network location cannot be reached. For information about network troubleshooting, see Windows Help.
Global Const $ERROR_PORT_UNREACHABLE = 1234 ; No service is operating at the destination network endpoint on the remote system.
Global Const $ERROR_REQUEST_ABORTED = 1235 ; The request was aborted.
Global Const $ERROR_CONNECTION_ABORTED = 1236 ; The network connection was aborted by the local system.
Global Const $ERROR_RETRY = 1237 ; The operation could not be completed. A retry should be performed.
Global Const $ERROR_CONNECTION_COUNT_LIMIT = 1238 ; A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached.
Global Const $ERROR_LOGIN_TIME_RESTRICTION = 1239 ; Attempting to log in during an unauthorized time of day for this account.
Global Const $ERROR_LOGIN_WKSTA_RESTRICTION = 1240 ; The account is not authorized to log in from this station.
Global Const $ERROR_INCORRECT_ADDRESS = 1241 ; The network address could not be used for the operation requested.
Global Const $ERROR_ALREADY_REGISTERED = 1242 ; The service is already registered.
Global Const $ERROR_SERVICE_NOT_FOUND = 1243 ; The specified service does not exist.
Global Const $ERROR_NOT_AUTHENTICATED = 1244 ; The operation being requested was not performed because the user has not been authenticated.
Global Const $ERROR_NOT_LOGGED_ON = 1245 ; The operation being requested was not performed because the user has not logged on to the network. The specified service does not exist.
Global Const $ERROR_CONTINUE = 1246 ; Continue with work in progress.
Global Const $ERROR_ALREADY_INITIALIZED = 1247 ; An attempt was made to perform an initialization operation when initialization has already been completed.
Global Const $ERROR_NO_MORE_DEVICES = 1248 ; No more local devices.
Global Const $ERROR_NO_SUCH_SITE = 1249 ; The specified site does not exist.
Global Const $ERROR_DOMAIN_CONTROLLER_EXISTS = 1250 ; A domain controller with the specified name already exists.
Global Const $ERROR_ONLY_IF_CONNECTED = 1251 ; This operation is supported only when you are connected to the server.
Global Const $ERROR_OVERRIDE_NOCHANGES = 1252 ; The group policy framework should call the extension even if there are no changes.
Global Const $ERROR_BAD_USER_PROFILE = 1253 ; The specified user does not have a valid profile.
Global Const $ERROR_NOT_SUPPORTED_ON_SBS = 1254 ; This operation is not supported on a computer running Windows Server 2003 for Small Business Server.
Global Const $ERROR_SERVER_SHUTDOWN_IN_PROGRESS = 1255 ; The server machine is shutting down.
Global Const $ERROR_HOST_DOWN = 1256 ; The remote system is not available. For information about network troubleshooting, see Windows Help.
Global Const $ERROR_NON_ACCOUNT_SID = 1257 ; The security identifier provided is not from an account domain.
Global Const $ERROR_NON_DOMAIN_SID = 1258 ; The security identifier provided does not have a domain component.
Global Const $ERROR_APPHELP_BLOCK = 1259 ; AppHelp dialog canceled thus preventing the application from starting.
Global Const $ERROR_ACCESS_DISABLED_BY_POLICY = 1260 ; This program is blocked by group policy. For more information, contact your system administrator.
Global Const $ERROR_REG_NAT_CONSUMPTION = 1261 ; A program attempt to use an invalid register value. Normally caused by an uninitialized register. This error is Itanium specific.
Global Const $ERROR_CSCSHARE_OFFLINE = 1262 ; The share is currently offline or does not exist.
Global Const $ERROR_PKINIT_FAILURE = 1263 ; The Kerberos protocol encountered an error while validating the KDC certificate during smartcard logon. There is more information in the system event log.
Global Const $ERROR_SMARTCARD_SUBSYSTEM_FAILURE = 1264 ; The Kerberos protocol encountered an error while attempting to utilize the smartcard subsystem.
Global Const $ERROR_DOWNGRADE_DETECTED = 1265 ; The system detected a possible attempt to compromise security. Please ensure that you can contact the server that authenticated you.
Global Const $ERROR_MACHINE_LOCKED = 1271 ; The machine is locked and cannot be shut down without the force option.
Global Const $ERROR_CALLBACK_SUPPLIED_INVALID_DATA = 1273 ; An application-defined callback gave invalid data when called.
Global Const $ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED = 1274 ; The group policy framework should call the extension in the synchronous foreground policy refresh.
Global Const $ERROR_DRIVER_BLOCKED = 1275 ; This driver has been blocked from loading.
Global Const $ERROR_INVALID_IMPORT_OF_NON_DLL = 1276 ; A dynamic link library (DLL) referenced a module that was neither a DLL nor the process's executable image.
Global Const $ERROR_ACCESS_DISABLED_WEBBLADE = 1277 ; Windows cannot open this program since it has been disabled.
Global Const $ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER = 1278 ; Windows cannot open this program because the license enforcement system has been tampered with or become corrupted.
Global Const $ERROR_RECOVERY_FAILURE = 1279 ; A transaction recover failed.
Global Const $ERROR_ALREADY_FIBER = 1280 ; The current thread has already been converted to a fiber.
Global Const $ERROR_ALREADY_THREAD = 1281 ; The current thread has already been converted from a fiber.
Global Const $ERROR_STACK_BUFFER_OVERRUN = 1282 ; The system detected an overrun of a stack-based buffer in this application. This overrun could potentially allow a malicious user to gain control of this application.
Global Const $ERROR_PARAMETER_QUOTA_EXCEEDED = 1283 ; Data present in one of the parameters is more than the function can operate on.
Global Const $ERROR_DEBUGGER_INACTIVE = 1284 ; An attempt to do an operation on a debug object failed because the object is in the process of being deleted.
Global Const $ERROR_DELAY_LOAD_FAILED = 1285 ; An attempt to delay-load a .dll or get a function address in a delay-loaded .dll failed.
Global Const $ERROR_VDM_DISALLOWED = 1286 ; %1 is a 16-bit application. You do not have permissions to execute 16-bit applications. Check your permissions with your system administrator.
Global Const $ERROR_UNIDENTIFIED_ERROR = 1287 ; Insufficient information exists to identify the cause of failure.
Global Const $ERROR_INVALID_CRUNTIME_PARAMETER = 1288 ; The parameter passed to a C runtime function is incorrect.
Global Const $ERROR_BEYOND_VDL = 1289 ; The operation occurred beyond the valid data length of the file.
Global Const $ERROR_INCOMPATIBLE_SERVICE_SID_TYPE = 1290 ; The service start failed since one or more services in the same process have an incompatible service SID type setting. A service with restricted service SID type can only coexist in the same process with other services with a restricted SID type. If the service SID type for this service was just configured, the hosting process must be restarted in order to start this service. On Windows Server 2003 and Windows XP, an unrestricted service cannot coexist in the same process with other services. The service with the unrestricted service SID type must be moved to an owned process in order to start this service.
Global Const $ERROR_DRIVER_PROCESS_TERMINATED = 1291 ; The process hosting the driver for this device has been terminated.
Global Const $ERROR_IMPLEMENTATION_LIMIT = 1292 ; An operation attempted to exceed an implementation-defined limit.
Global Const $ERROR_PROCESS_IS_PROTECTED = 1293 ; Either the target process, or the target thread's containing process, is a protected process.
Global Const $ERROR_SERVICE_NOTIFY_CLIENT_LAGGING = 1294 ; The service notification client is lagging too far behind the current state of services in the machine.
Global Const $ERROR_DISK_QUOTA_EXCEEDED = 1295 ; The requested file operation failed because the storage quota was exceeded. To free up disk space, move files to a different location or delete unnecessary files. For more information, contact your system administrator.
Global Const $ERROR_CONTENT_BLOCKED = 1296 ; The requested files operation failed because the storage policy blocks that type of file. For more information, contact your system administrator.
Global Const $ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE = 1297 ; A privilege that the service requires to function properly does not exist in the service account configuration. You may use the Services Microsoft Management Console (MMC) snap-in (services.msc) and the Local Security Settings MMC snap-in (secpol.msc) to view the service configuration and the account configuration.
Global Const $ERROR_APP_HANG = 1298 ; A thread involved in this operation appears to be unresponsive.
Global Const $ERROR_INVALID_LABEL = 1299 ; Indicates a particular Security ID may not be assigned as the label of an object.
Global Const $ERROR_NOT_ALL_ASSIGNED = 1300 ; Not all privileges or groups referenced are assigned to the caller.
Global Const $ERROR_SOME_NOT_MAPPED = 1301 ; Some mapping between account names and security IDs was not done.
Global Const $ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302 ; No system quota limits are specifically set for this account.
Global Const $ERROR_LOCAL_USER_SESSION_KEY = 1303 ; No encryption key is available. A well-known encryption key was returned.
Global Const $ERROR_NULL_LM_PASSWORD = 1304 ; The password is too complex to be converted to a LAN Manager password. The LAN Manager password returned is a NULL string.
Global Const $ERROR_UNKNOWN_REVISION = 1305 ; The revision level is unknown.
Global Const $ERROR_REVISION_MISMATCH = 1306 ; Indicates two revision levels are incompatible.
Global Const $ERROR_INVALID_OWNER = 1307 ; This security ID may not be assigned as the owner of this object.
Global Const $ERROR_INVALID_PRIMARY_GROUP = 1308 ; This security ID may not be assigned as the primary group of an object.
Global Const $ERROR_NO_IMPERSONATION_TOKEN = 1309 ; An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client.
Global Const $ERROR_CANT_DISABLE_MANDATORY = 1310 ; The group may not be disabled.
Global Const $ERROR_NO_LOGON_SERVERS = 1311 ; There are currently no logon servers available to service the logon request.
Global Const $ERROR_NO_SUCH_LOGON_SESSION = 1312 ; A specified logon session does not exist. It may already have been terminated.
Global Const $ERROR_NO_SUCH_PRIVILEGE = 1313 ; A specified privilege does not exist.
Global Const $ERROR_PRIVILEGE_NOT_HELD = 1314 ; A required privilege is not held by the client.
Global Const $ERROR_INVALID_ACCOUNT_NAME = 1315 ; The name provided is not a properly formed account name.
Global Const $ERROR_USER_EXISTS = 1316 ; The specified account already exists.
Global Const $ERROR_NO_SUCH_USER = 1317 ; The specified account does not exist.
Global Const $ERROR_GROUP_EXISTS = 1318 ; The specified group already exists.
Global Const $ERROR_NO_SUCH_GROUP = 1319 ; The specified group does not exist.
Global Const $ERROR_MEMBER_IN_GROUP = 1320 ; Either the specified user account is already a member of the specified group, or the specified group cannot be deleted because it contains a member.
Global Const $ERROR_MEMBER_NOT_IN_GROUP = 1321 ; The specified user account is not a member of the specified group account.
Global Const $ERROR_LAST_ADMIN = 1322 ; The last remaining administration account cannot be disabled or deleted.
Global Const $ERROR_WRONG_PASSWORD = 1323 ; Unable to update the password. The value provided as the current password is incorrect.
Global Const $ERROR_ILL_FORMED_PASSWORD = 1324 ; Unable to update the password. The value provided for the new password contains values that are not allowed in passwords.
Global Const $ERROR_PASSWORD_RESTRICTION = 1325 ; Unable to update the password. The value provided for the new password does not meet the length, complexity, or history requirements of the domain.
Global Const $ERROR_LOGON_FAILURE = 1326 ; Logon failure: unknown user name or bad password.
Global Const $ERROR_ACCOUNT_RESTRICTION = 1327 ; Logon failure: user account restriction. Possible reasons are blank passwords not allowed, logon hour restrictions, or a policy restriction has been enforced.
Global Const $ERROR_INVALID_LOGON_HOURS = 1328 ; Logon failure: account logon time restriction violation.
Global Const $ERROR_INVALID_WORKSTATION = 1329 ; Logon failure: user not allowed to log on to this computer.
Global Const $ERROR_PASSWORD_EXPIRED = 1330 ; Logon failure: the specified account password has expired.
Global Const $ERROR_ACCOUNT_DISABLED = 1331 ; Logon failure: account currently disabled.
Global Const $ERROR_NONE_MAPPED = 1332 ; No mapping between account names and security IDs was done.
Global Const $ERROR_TOO_MANY_LUIDS_REQUESTED = 1333 ; Too many local user identifiers (LUIDs) were requested at one time.
Global Const $ERROR_LUIDS_EXHAUSTED = 1334 ; No more local user identifiers (LUIDs) are available.
Global Const $ERROR_INVALID_SUB_AUTHORITY = 1335 ; The subauthority part of a security ID is invalid for this particular use.
Global Const $ERROR_INVALID_ACL = 1336 ; The access control list (ACL) structure is invalid.
Global Const $ERROR_INVALID_SID = 1337 ; The security ID structure is invalid.
Global Const $ERROR_INVALID_SECURITY_DESCR = 1338 ; The security descriptor structure is invalid.
Global Const $ERROR_BAD_INHERITANCE_ACL = 1340 ; The inherited access control list (ACL) or access control entry (ACE) could not be built.
Global Const $ERROR_SERVER_DISABLED = 1341 ; The server is currently disabled.
Global Const $ERROR_SERVER_NOT_DISABLED = 1342 ; The server is currently enabled.
Global Const $ERROR_INVALID_ID_AUTHORITY = 1343 ; The value provided was an invalid value for an identifier authority.
Global Const $ERROR_ALLOTTED_SPACE_EXCEEDED = 1344 ; No more memory is available for security information updates.
Global Const $ERROR_INVALID_GROUP_ATTRIBUTES = 1345 ; The specified attributes are invalid, or incompatible with the attributes for the group as a whole.
Global Const $ERROR_BAD_IMPERSONATION_LEVEL = 1346 ; Either a required impersonation level was not provided, or the provided impersonation level is invalid.
Global Const $ERROR_CANT_OPEN_ANONYMOUS = 1347 ; Cannot open an anonymous level security token.
Global Const $ERROR_BAD_VALIDATION_CLASS = 1348 ; The validation information class requested was invalid.
Global Const $ERROR_BAD_TOKEN_TYPE = 1349 ; The type of the token is inappropriate for its attempted use.
Global Const $ERROR_NO_SECURITY_ON_OBJECT = 1350 ; Unable to perform a security operation on an object that has no associated security.
Global Const $ERROR_CANT_ACCESS_DOMAIN_INFO = 1351 ; Configuration information could not be read from the domain controller, either because the machine is unavailable, or access has been denied.
Global Const $ERROR_INVALID_SERVER_STATE = 1352 ; The security account manager (SAM) or local security authority (LSA) server was in the wrong state to perform the security operation.
Global Const $ERROR_INVALID_DOMAIN_STATE = 1353 ; The domain was in the wrong state to perform the security operation.
Global Const $ERROR_INVALID_DOMAIN_ROLE = 1354 ; This operation is only allowed for the Primary Domain Controller of the domain.
Global Const $ERROR_NO_SUCH_DOMAIN = 1355 ; The specified domain either does not exist or could not be contacted.
Global Const $ERROR_DOMAIN_EXISTS = 1356 ; The specified domain already exists.
Global Const $ERROR_DOMAIN_LIMIT_EXCEEDED = 1357 ; An attempt was made to exceed the limit on the number of domains per server.
Global Const $ERROR_INTERNAL_DB_CORRUPTION = 1358 ; Unable to complete the requested operation because of either a catastrophic media failure or a data structure corruption on the disk.
Global Const $ERROR_INTERNAL_ERROR = 1359 ; An internal error occurred.
Global Const $ERROR_GENERIC_NOT_MAPPED = 1360 ; Generic access types were contained in an access mask which should already be mapped to nongeneric types.
Global Const $ERROR_BAD_DESCRIPTOR_FORMAT = 1361 ; A security descriptor is not in the right format (absolute or self-relative).
Global Const $ERROR_NOT_LOGON_PROCESS = 1362 ; The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process.
Global Const $ERROR_LOGON_SESSION_EXISTS = 1363 ; Cannot start a new logon session with an ID that is already in use.
Global Const $ERROR_NO_SUCH_PACKAGE = 1364 ; A specified authentication package is unknown.
Global Const $ERROR_BAD_LOGON_SESSION_STATE = 1365 ; The logon session is not in a state that is consistent with the requested operation.
Global Const $ERROR_LOGON_SESSION_COLLISION = 1366 ; The logon session ID is already in use.
Global Const $ERROR_INVALID_LOGON_TYPE = 1367 ; A logon request contained an invalid logon type value.
Global Const $ERROR_CANNOT_IMPERSONATE = 1368 ; Unable to impersonate using a named pipe until data has been read from that pipe.
Global Const $ERROR_RXACT_INVALID_STATE = 1369 ; The transaction state of a registry subtree is incompatible with the requested operation.
Global Const $ERROR_RXACT_COMMIT_FAILURE = 1370 ; An internal security database corruption has been encountered.
Global Const $ERROR_SPECIAL_ACCOUNT = 1371 ; Cannot perform this operation on built-in accounts.
Global Const $ERROR_SPECIAL_GROUP = 1372 ; Cannot perform this operation on this built-in special group.
Global Const $ERROR_SPECIAL_USER = 1373 ; Cannot perform this operation on this built-in special user.
Global Const $ERROR_MEMBERS_PRIMARY_GROUP = 1374 ; The user cannot be removed from a group because the group is currently the user's primary group.
Global Const $ERROR_TOKEN_ALREADY_IN_USE = 1375 ; The token is already in use as a primary token.
Global Const $ERROR_NO_SUCH_ALIAS = 1376 ; The specified local group does not exist.
Global Const $ERROR_MEMBER_NOT_IN_ALIAS = 1377 ; The specified account name is not a member of the group.
Global Const $ERROR_MEMBER_IN_ALIAS = 1378 ; The specified account name is already a member of the group.
Global Const $ERROR_ALIAS_EXISTS = 1379 ; The specified local group already exists.
Global Const $ERROR_LOGON_NOT_GRANTED = 1380 ; Logon failure: the user has not been granted the requested logon type at this computer.
Global Const $ERROR_TOO_MANY_SECRETS = 1381 ; The maximum number of secrets that may be stored in a single system has been exceeded.
Global Const $ERROR_SECRET_TOO_LONG = 1382 ; The length of a secret exceeds the maximum length allowed.
Global Const $ERROR_INTERNAL_DB_ERROR = 1383 ; The local security authority database contains an internal inconsistency.
Global Const $ERROR_TOO_MANY_CONTEXT_IDS = 1384 ; During a logon attempt, the user's security context accumulated too many security IDs.
Global Const $ERROR_LOGON_TYPE_NOT_GRANTED = 1385 ; Logon failure: the user has not been granted the requested logon type at this computer.
Global Const $ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386 ; A cross-encrypted password is necessary to change a user password.
Global Const $ERROR_NO_SUCH_MEMBER = 1387 ; A member could not be added to or removed from the local group because the member does not exist.
Global Const $ERROR_INVALID_MEMBER = 1388 ; A new member could not be added to a local group because the member has the wrong account type.
Global Const $ERROR_TOO_MANY_SIDS = 1389 ; Too many security IDs have been specified.
Global Const $ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390 ; A cross-encrypted password is necessary to change this user password.
Global Const $ERROR_NO_INHERITANCE = 1391 ; Indicates an ACL contains no inheritable components.
Global Const $ERROR_FILE_CORRUPT = 1392 ; The file or directory is corrupted and unreadable.
Global Const $ERROR_DISK_CORRUPT = 1393 ; The disk structure is corrupted and unreadable.
Global Const $ERROR_NO_USER_SESSION_KEY = 1394 ; There is no user session key for the specified logon session.
Global Const $ERROR_LICENSE_QUOTA_EXCEEDED = 1395 ; The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because there are already as many connections as the service can accept.
Global Const $ERROR_WRONG_TARGET_NAME = 1396 ; Logon Failure: The target account name is incorrect.
Global Const $ERROR_MUTUAL_AUTH_FAILED = 1397 ; Mutual Authentication failed. The server's password is out of date at the domain controller.
Global Const $ERROR_TIME_SKEW = 1398 ; There is a time and/or date difference between the client and server.
Global Const $ERROR_CURRENT_DOMAIN_NOT_ALLOWED = 1399 ; This operation cannot be performed on the current domain.
Global Const $ERROR_INVALID_WINDOW_HANDLE = 1400 ; Invalid window handle.
Global Const $ERROR_INVALID_MENU_HANDLE = 1401 ; Invalid menu handle.
Global Const $ERROR_INVALID_CURSOR_HANDLE = 1402 ; Invalid cursor handle.
Global Const $ERROR_INVALID_ACCEL_HANDLE = 1403 ; Invalid accelerator table handle.
Global Const $ERROR_INVALID_HOOK_HANDLE = 1404 ; Invalid hook handle.
Global Const $ERROR_INVALID_DWP_HANDLE = 1405 ; Invalid handle to a multiple-window position structure.
Global Const $ERROR_TLW_WITH_WSCHILD = 1406 ; Cannot create a top-level child window.
Global Const $ERROR_CANNOT_FIND_WND_CLASS = 1407 ; Cannot find window class.
Global Const $ERROR_WINDOW_OF_OTHER_THREAD = 1408 ; Invalid window; it belongs to other thread.
Global Const $ERROR_HOTKEY_ALREADY_REGISTERED = 1409 ; Hot key is already registered.
Global Const $ERROR_CLASS_ALREADY_EXISTS = 1410 ; Class already exists.
Global Const $ERROR_CLASS_DOES_NOT_EXIST = 1411 ; Class does not exist.
Global Const $ERROR_CLASS_HAS_WINDOWS = 1412 ; Class still has open windows.
Global Const $ERROR_INVALID_INDEX = 1413 ; Invalid index.
Global Const $ERROR_INVALID_ICON_HANDLE = 1414 ; Invalid icon handle.
Global Const $ERROR_PRIVATE_DIALOG_INDEX = 1415 ; Using private DIALOG window words.
Global Const $ERROR_LISTBOX_ID_NOT_FOUND = 1416 ; The list box identifier was not found.
Global Const $ERROR_NO_WILDCARD_CHARACTERS = 1417 ; No wildcards were found.
Global Const $ERROR_CLIPBOARD_NOT_OPEN = 1418 ; Thread does not have a clipboard open.
Global Const $ERROR_HOTKEY_NOT_REGISTERED = 1419 ; Hot key is not registered.
Global Const $ERROR_WINDOW_NOT_DIALOG = 1420 ; The window is not a valid dialog window.
Global Const $ERROR_CONTROL_ID_NOT_FOUND = 1421 ; Control ID not found.
Global Const $ERROR_INVALID_COMBOBOX_MESSAGE = 1422 ; Invalid message for a combo box because it does not have an edit control.
Global Const $ERROR_WINDOW_NOT_COMBOBOX = 1423 ; The window is not a combo box.
Global Const $ERROR_INVALID_EDIT_HEIGHT = 1424 ; Height must be less than 256.
Global Const $ERROR_DC_NOT_FOUND = 1425 ; Invalid device context (DC) handle.
Global Const $ERROR_INVALID_HOOK_FILTER = 1426 ; Invalid hook procedure type.
Global Const $ERROR_INVALID_FILTER_PROC = 1427 ; Invalid hook procedure.
Global Const $ERROR_HOOK_NEEDS_HMOD = 1428 ; Cannot set nonlocal hook without a module handle.
Global Const $ERROR_GLOBAL_ONLY_HOOK = 1429 ; This hook procedure can only be set globally.
Global Const $ERROR_JOURNAL_HOOK_SET = 1430 ; The journal hook procedure is already installed.
Global Const $ERROR_HOOK_NOT_INSTALLED = 1431 ; The hook procedure is not installed.
Global Const $ERROR_INVALID_LB_MESSAGE = 1432 ; Invalid message for single-selection list box.
Global Const $ERROR_SETCOUNT_ON_BAD_LB = 1433 ; LB_SETCOUNT sent to non-lazy list box.
Global Const $ERROR_LB_WITHOUT_TABSTOPS = 1434 ; This list box does not support tab stops.
Global Const $ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435 ; Cannot destroy object created by another thread.
Global Const $ERROR_CHILD_WINDOW_MENU = 1436 ; Child windows cannot have menus.
Global Const $ERROR_NO_SYSTEM_MENU = 1437 ; The window does not have a system menu.
Global Const $ERROR_INVALID_MSGBOX_STYLE = 1438 ; Invalid message box style.
Global Const $ERROR_INVALID_SPI_VALUE = 1439 ; Invalid system-wide (SPI_*) parameter.
Global Const $ERROR_SCREEN_ALREADY_LOCKED = 1440 ; Screen already locked.
Global Const $ERROR_HWNDS_HAVE_DIFF_PARENT = 1441 ; All handles to windows in a multiple-window position structure must have the same parent.
Global Const $ERROR_NOT_CHILD_WINDOW = 1442 ; The window is not a child window.
Global Const $ERROR_INVALID_GW_COMMAND = 1443 ; Invalid GW_* command.
Global Const $ERROR_INVALID_THREAD_ID = 1444 ; Invalid thread identifier.
Global Const $ERROR_NON_MDICHILD_WINDOW = 1445 ; Cannot process a message from a window that is not a multiple document interface (MDI) window.
Global Const $ERROR_POPUP_ALREADY_ACTIVE = 1446 ; Popup menu already active.
Global Const $ERROR_NO_SCROLLBARS = 1447 ; The window does not have scroll bars.
Global Const $ERROR_INVALID_SCROLLBAR_RANGE = 1448 ; Scroll bar range cannot be greater than MAXLONG.
Global Const $ERROR_INVALID_SHOWWIN_COMMAND = 1449 ; Cannot show or remove the window in the way specified.
Global Const $ERROR_NO_SYSTEM_RESOURCES = 1450 ; Insufficient system resources exist to complete the requested service.
Global Const $ERROR_NONPAGED_SYSTEM_RESOURCES = 1451 ; Insufficient system resources exist to complete the requested service.
Global Const $ERROR_PAGED_SYSTEM_RESOURCES = 1452 ; Insufficient system resources exist to complete the requested service.
Global Const $ERROR_WORKING_SET_QUOTA = 1453 ; Insufficient quota to complete the requested service.
Global Const $ERROR_PAGEFILE_QUOTA = 1454 ; Insufficient quota to complete the requested service.
Global Const $ERROR_COMMITMENT_LIMIT = 1455 ; The paging file is too small for this operation to complete.
Global Const $ERROR_MENU_ITEM_NOT_FOUND = 1456 ; A menu item was not found.
Global Const $ERROR_INVALID_KEYBOARD_HANDLE = 1457 ; Invalid keyboard layout handle.
Global Const $ERROR_HOOK_TYPE_NOT_ALLOWED = 1458 ; Hook type not allowed.
Global Const $ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459 ; This operation requires an interactive window station.
Global Const $ERROR_TIMEOUT = 1460 ; This operation returned because the timeout period expired.
Global Const $ERROR_INVALID_MONITOR_HANDLE = 1461 ; Invalid monitor handle.
Global Const $ERROR_INCORRECT_SIZE = 1462 ; Incorrect size argument.
Global Const $ERROR_SYMLINK_CLASS_DISABLED = 1463 ; The symbolic link cannot be followed because its type is disabled.
Global Const $ERROR_SYMLINK_NOT_SUPPORTED = 1464 ; This application does not support the current operation on symbolic links.
Global Const $ERROR_XML_PARSE_ERROR = 1465 ; Windows was unable to parse the requested XML data.
Global Const $ERROR_XMLDSIG_ERROR = 1466 ; An error was encountered while processing an XML digital signature.
Global Const $ERROR_RESTART_APPLICATION = 1467 ; This application must be restarted.
Global Const $ERROR_WRONG_COMPARTMENT = 1468 ; The caller made the connection request in the wrong routing compartment.
Global Const $ERROR_AUTHIP_FAILURE = 1469 ; There was an AuthIP failure when attempting to connect to the remote host.
Global Const $ERROR_NO_NVRAM_RESOURCES = 1470 ; Insufficient NVRAM resources exist to complete the requested service. A reboot might be required.
Global Const $ERROR_EVENTLOG_FILE_CORRUPT = 1500 ; The event log file is corrupted.
Global Const $ERROR_EVENTLOG_CANT_START = 1501 ; No event log file could be opened, so the event logging service did not start.
Global Const $ERROR_LOG_FILE_FULL = 1502 ; The event log file is full.
Global Const $ERROR_EVENTLOG_FILE_CHANGED = 1503 ; The event log file has changed between read operations.
Global Const $ERROR_INVALID_TASK_NAME = 1550 ; The specified task name is invalid.
Global Const $ERROR_INVALID_TASK_INDEX = 1551 ; The specified task index is invalid.
Global Const $ERROR_THREAD_ALREADY_IN_TASK = 1552 ; The specified thread is already joining a task.
Global Const $ERROR_INSTALL_SERVICE_FAILURE = 1601 ; The Windows Installer Service could not be accessed. This can occur if the Windows Installer is not correctly installed. Contact your support personnel for assistance.
Global Const $ERROR_INSTALL_USEREXIT = 1602 ; User canceled installation.
Global Const $ERROR_INSTALL_FAILURE = 1603 ; Fatal error during installation.
Global Const $ERROR_INSTALL_SUSPEND = 1604 ; Installation suspended, incomplete.
Global Const $ERROR_UNKNOWN_PRODUCT = 1605 ; This action is only valid for products that are currently installed.
Global Const $ERROR_UNKNOWN_FEATURE = 1606 ; Feature ID not registered.
Global Const $ERROR_UNKNOWN_COMPONENT = 1607 ; Component ID not registered.
Global Const $ERROR_UNKNOWN_PROPERTY = 1608 ; Unknown property.
Global Const $ERROR_INVALID_HANDLE_STATE = 1609 ; A handle is in an invalid state.
Global Const $ERROR_BAD_CONFIGURATION = 1610 ; The configuration data for this product is corrupt. Contact your support personnel.
Global Const $ERROR_INDEX_ABSENT = 1611 ; Component qualifier not present.
Global Const $ERROR_INSTALL_SOURCE_ABSENT = 1612 ; The installation source for this product is not available. Verify that the source exists and that you can access it.
Global Const $ERROR_INSTALL_PACKAGE_VERSION = 1613 ; This installation package cannot be installed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
Global Const $ERROR_PRODUCT_UNINSTALLED = 1614 ; Product is uninstalled.
Global Const $ERROR_BAD_QUERY_SYNTAX = 1615 ; SQL query syntax invalid or unsupported.
Global Const $ERROR_INVALID_FIELD = 1616 ; Record field does not exist.
Global Const $ERROR_DEVICE_REMOVED = 1617 ; The device has been removed.
Global Const $ERROR_INSTALL_ALREADY_RUNNING = 1618 ; Another installation is already in progress. Complete that installation before proceeding with this install.
Global Const $ERROR_INSTALL_PACKAGE_OPEN_FAILED = 1619 ; This installation package could not be opened. Verify that the package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer package.
Global Const $ERROR_INSTALL_PACKAGE_INVALID = 1620 ; This installation package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer package.
Global Const $ERROR_INSTALL_UI_FAILURE = 1621 ; There was an error starting the Windows Installer service user interface. Contact your support personnel.
Global Const $ERROR_INSTALL_LOG_FAILURE = 1622 ; Error opening installation log file. Verify that the specified log file location exists and that you can write to it.
Global Const $ERROR_INSTALL_LANGUAGE_UNSUPPORTED = 1623 ; The language of this installation package is not supported by your system.
Global Const $ERROR_INSTALL_TRANSFORM_FAILURE = 1624 ; Error applying transforms. Verify that the specified transform paths are valid.
Global Const $ERROR_INSTALL_PACKAGE_REJECTED = 1625 ; This installation is forbidden by system policy. Contact your system administrator.
Global Const $ERROR_FUNCTION_NOT_CALLED = 1626 ; Function could not be executed.
Global Const $ERROR_FUNCTION_FAILED = 1627 ; Function failed during execution.
Global Const $ERROR_INVALID_TABLE = 1628 ; Invalid or unknown table specified.
Global Const $ERROR_DATATYPE_MISMATCH = 1629 ; Data supplied is of wrong type.
Global Const $ERROR_UNSUPPORTED_TYPE = 1630 ; Data of this type is not supported.
Global Const $ERROR_CREATE_FAILED = 1631 ; The Windows Installer service failed to start. Contact your support personnel.
Global Const $ERROR_INSTALL_TEMP_UNWRITABLE = 1632 ; The Temp folder is on a drive that is full or is inaccessible. Free up space on the drive or verify that you have write permission on the Temp folder.
Global Const $ERROR_INSTALL_PLATFORM_UNSUPPORTED = 1633 ; This installation package is not supported by this processor type. Contact your product vendor.
Global Const $ERROR_INSTALL_NOTUSED = 1634 ; Component not used on this computer.
Global Const $ERROR_PATCH_PACKAGE_OPEN_FAILED = 1635 ; This update package could not be opened. Verify that the update package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer update package.
Global Const $ERROR_PATCH_PACKAGE_INVALID = 1636 ; This update package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer update package.
Global Const $ERROR_PATCH_PACKAGE_UNSUPPORTED = 1637 ; This update package cannot be processed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
Global Const $ERROR_PRODUCT_VERSION = 1638 ; Another version of this product is already installed. Installation of this version cannot continue. To configure or remove the existing version of this product, use Add/Remove Programs on the Control Panel.
Global Const $ERROR_INVALID_COMMAND_LINE = 1639 ; Invalid command line argument. Consult the Windows Installer SDK for detailed command line help.
Global Const $ERROR_INSTALL_REMOTE_DISALLOWED = 1640 ; Only administrators have permission to add, remove, or configure server software during a Terminal services remote session. If you want to install or configure software on the server, contact your network administrator.
Global Const $ERROR_SUCCESS_REBOOT_INITIATED = 1641 ; The requested operation completed successfully. The system will be restarted so the changes can take effect.
Global Const $ERROR_PATCH_TARGET_NOT_FOUND = 1642 ; The upgrade cannot be installed by the Windows Installer service because the program to be upgraded may be missing, or the upgrade may update a different version of the program. Verify that the program to be upgraded exists on your computer and that you have the correct upgrade.
Global Const $ERROR_PATCH_PACKAGE_REJECTED = 1643 ; The update package is not permitted by software restriction policy.
Global Const $ERROR_INSTALL_TRANSFORM_REJECTED = 1644 ; One or more customizations are not permitted by software restriction policy.
Global Const $ERROR_INSTALL_REMOTE_PROHIBITED = 1645 ; The Windows Installer does not permit installation from a Remote Desktop Connection.
Global Const $ERROR_PATCH_REMOVAL_UNSUPPORTED = 1646 ; Uninstallation of the update package is not supported.
Global Const $ERROR_UNKNOWN_PATCH = 1647 ; The update is not applied to this product.
Global Const $ERROR_PATCH_NO_SEQUENCE = 1648 ; No valid sequence could be found for the set of updates.
Global Const $ERROR_PATCH_REMOVAL_DISALLOWED = 1649 ; Update removal was disallowed by policy.
Global Const $ERROR_INVALID_PATCH_XML = 1650 ; The XML update data is invalid.
Global Const $ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT = 1651 ; Windows Installer does not permit updating of managed advertised products. At least one feature of the product must be installed before applying the update.
Global Const $ERROR_INSTALL_SERVICE_SAFEBOOT = 1652 ; The Windows Installer service is not accessible in Safe Mode. Please try again when your computer is not in Safe Mode or you can use System Restore to return your machine to a previous good state.
Global Const $ERROR_FAIL_FAST_EXCEPTION = 1653 ; A fail fast exception occurred. Exception handlers will not be invoked and the process will be terminated immediately.
Global Const $RPC_S_INVALID_STRING_BINDING = 1700 ; The string binding is invalid.
Global Const $RPC_S_WRONG_KIND_OF_BINDING = 1701 ; The binding handle is not the correct type.
Global Const $RPC_S_INVALID_BINDING = 1702 ; The binding handle is invalid.
Global Const $RPC_S_PROTSEQ_NOT_SUPPORTED = 1703 ; The RPC protocol sequence is not supported.
Global Const $RPC_S_INVALID_RPC_PROTSEQ = 1704 ; The RPC protocol sequence is invalid.
Global Const $RPC_S_INVALID_STRING_UUID = 1705 ; The string universal unique identifier (UUID) is invalid.
Global Const $RPC_S_INVALID_ENDPOINT_FORMAT = 1706 ; The endpoint format is invalid.
Global Const $RPC_S_INVALID_NET_ADDR = 1707 ; The network address is invalid.
Global Const $RPC_S_NO_ENDPOINT_FOUND = 1708 ; No endpoint was found.
Global Const $RPC_S_INVALID_TIMEOUT = 1709 ; The timeout value is invalid.
Global Const $RPC_S_OBJECT_NOT_FOUND = 1710 ; The object universal unique identifier (UUID) was not found.
Global Const $RPC_S_ALREADY_REGISTERED = 1711 ; The object universal unique identifier (UUID) has already been registered.
Global Const $RPC_S_TYPE_ALREADY_REGISTERED = 1712 ; The type universal unique identifier (UUID) has already been registered.
Global Const $RPC_S_ALREADY_LISTENING = 1713 ; The RPC server is already listening.
Global Const $RPC_S_NO_PROTSEQS_REGISTERED = 1714 ; No protocol sequences have been registered.
Global Const $RPC_S_NOT_LISTENING = 1715 ; The RPC server is not listening.
Global Const $RPC_S_UNKNOWN_MGR_TYPE = 1716 ; The manager type is unknown.
Global Const $RPC_S_UNKNOWN_IF = 1717 ; The interface is unknown.
Global Const $RPC_S_NO_BINDINGS = 1718 ; There are no bindings.
Global Const $RPC_S_NO_PROTSEQS = 1719 ; There are no protocol sequences.
Global Const $RPC_S_CANT_CREATE_ENDPOINT = 1720 ; The endpoint cannot be created.
Global Const $RPC_S_OUT_OF_RESOURCES = 1721 ; Not enough resources are available to complete this operation.
Global Const $RPC_S_SERVER_UNAVAILABLE = 1722 ; The RPC server is unavailable.
Global Const $RPC_S_SERVER_TOO_BUSY = 1723 ; The RPC server is too busy to complete this operation.
Global Const $RPC_S_INVALID_NETWORK_OPTIONS = 1724 ; The network options are invalid.
Global Const $RPC_S_NO_CALL_ACTIVE = 1725 ; There are no remote procedure calls active on this thread.
Global Const $RPC_S_CALL_FAILED = 1726 ; The remote procedure call failed.
Global Const $RPC_S_CALL_FAILED_DNE = 1727 ; The remote procedure call failed and did not execute.
Global Const $RPC_S_PROTOCOL_ERROR = 1728 ; A remote procedure call (RPC) protocol error occurred.
Global Const $RPC_S_PROXY_ACCESS_DENIED = 1729 ; Access to the HTTP proxy is denied.
Global Const $RPC_S_UNSUPPORTED_TRANS_SYN = 1730 ; The transfer syntax is not supported by the RPC server.
Global Const $RPC_S_UNSUPPORTED_TYPE = 1732 ; The universal unique identifier (UUID) type is not supported.
Global Const $RPC_S_INVALID_TAG = 1733 ; The tag is invalid.
Global Const $RPC_S_INVALID_BOUND = 1734 ; The array bounds are invalid.
Global Const $RPC_S_NO_ENTRY_NAME = 1735 ; The binding does not contain an entry name.
Global Const $RPC_S_INVALID_NAME_SYNTAX = 1736 ; The name syntax is invalid.
Global Const $RPC_S_UNSUPPORTED_NAME_SYNTAX = 1737 ; The name syntax is not supported.
Global Const $RPC_S_UUID_NO_ADDRESS = 1739 ; No network address is available to use to construct a universal unique identifier (UUID).
Global Const $RPC_S_DUPLICATE_ENDPOINT = 1740 ; The endpoint is a duplicate.
Global Const $RPC_S_UNKNOWN_AUTHN_TYPE = 1741 ; The authentication type is unknown.
Global Const $RPC_S_MAX_CALLS_TOO_SMALL = 1742 ; The maximum number of calls is too small.
Global Const $RPC_S_STRING_TOO_LONG = 1743 ; The string is too long.
Global Const $RPC_S_PROTSEQ_NOT_FOUND = 1744 ; The RPC protocol sequence was not found.
Global Const $RPC_S_PROCNUM_OUT_OF_RANGE = 1745 ; The procedure number is out of range.
Global Const $RPC_S_BINDING_HAS_NO_AUTH = 1746 ; The binding does not contain any authentication information.
Global Const $RPC_S_UNKNOWN_AUTHN_SERVICE = 1747 ; The authentication service is unknown.
Global Const $RPC_S_UNKNOWN_AUTHN_LEVEL = 1748 ; The authentication level is unknown.
Global Const $RPC_S_INVALID_AUTH_IDENTITY = 1749 ; The security context is invalid.
Global Const $RPC_S_UNKNOWN_AUTHZ_SERVICE = 1750 ; The authorization service is unknown.
Global Const $EPT_S_INVALID_ENTRY = 1751 ; The entry is invalid.
Global Const $EPT_S_CANT_PERFORM_OP = 1752 ; The server endpoint cannot perform the operation.
Global Const $EPT_S_NOT_REGISTERED = 1753 ; There are no more endpoints available from the endpoint mapper.
Global Const $RPC_S_NOTHING_TO_EXPORT = 1754 ; No interfaces have been exported.
Global Const $RPC_S_INCOMPLETE_NAME = 1755 ; The entry name is incomplete.
Global Const $RPC_S_INVALID_VERS_OPTION = 1756 ; The version option is invalid.
Global Const $RPC_S_NO_MORE_MEMBERS = 1757 ; There are no more members.
Global Const $RPC_S_NOT_ALL_OBJS_UNEXPORTED = 1758 ; There is nothing to unexport.
Global Const $RPC_S_INTERFACE_NOT_FOUND = 1759 ; The interface was not found.
Global Const $RPC_S_ENTRY_ALREADY_EXISTS = 1760 ; The entry already exists.
Global Const $RPC_S_ENTRY_NOT_FOUND = 1761 ; The entry is not found.
Global Const $RPC_S_NAME_SERVICE_UNAVAILABLE = 1762 ; The name service is unavailable.
Global Const $RPC_S_INVALID_NAF_ID = 1763 ; The network address family is invalid.
Global Const $RPC_S_CANNOT_SUPPORT = 1764 ; The requested operation is not supported.
Global Const $RPC_S_NO_CONTEXT_AVAILABLE = 1765 ; No security context is available to allow impersonation.
Global Const $RPC_S_INTERNAL_ERROR = 1766 ; An internal error occurred in a remote procedure call (RPC).
Global Const $RPC_S_ZERO_DIVIDE = 1767 ; The RPC server attempted an integer division by zero.
Global Const $RPC_S_ADDRESS_ERROR = 1768 ; An addressing error occurred in the RPC server.
Global Const $RPC_S_FP_DIV_ZERO = 1769 ; A floating-point operation at the RPC server caused a division by zero.
Global Const $RPC_S_FP_UNDERFLOW = 1770 ; A floating-point underflow occurred at the RPC server.
Global Const $RPC_S_FP_OVERFLOW = 1771 ; A floating-point overflow occurred at the RPC server.
Global Const $RPC_X_NO_MORE_ENTRIES = 1772 ; The list of RPC servers available for the binding of auto handles has been exhausted.
Global Const $RPC_X_SS_CHAR_TRANS_OPEN_FAIL = 1773 ; Unable to open the character translation table file.
Global Const $RPC_X_SS_CHAR_TRANS_SHORT_FILE = 1774 ; The file containing the character translation table has fewer than 512 bytes.
Global Const $RPC_X_SS_IN_NULL_CONTEXT = 1775 ; A null context handle was passed from the client to the host during a remote procedure call.
Global Const $RPC_X_SS_CONTEXT_DAMAGED = 1777 ; The context handle changed during a remote procedure call.
Global Const $RPC_X_SS_HANDLES_MISMATCH = 1778 ; The binding handles passed to a remote procedure call do not match.
Global Const $RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779 ; The stub is unable to get the remote procedure call handle.
Global Const $RPC_X_NULL_REF_POINTER = 1780 ; A null reference pointer was passed to the stub.
Global Const $RPC_X_ENUM_VALUE_OUT_OF_RANGE = 1781 ; The enumeration value is out of range.
Global Const $RPC_X_BYTE_COUNT_TOO_SMALL = 1782 ; The byte count is too small.
Global Const $RPC_X_BAD_STUB_DATA = 1783 ; The stub received bad data.
Global Const $ERROR_INVALID_USER_BUFFER = 1784 ; The supplied user buffer is not valid for the requested operation.
Global Const $ERROR_UNRECOGNIZED_MEDIA = 1785 ; The disk media is not recognized. It may not be formatted.
Global Const $ERROR_NO_TRUST_LSA_SECRET = 1786 ; The workstation does not have a trust secret.
Global Const $ERROR_NO_TRUST_SAM_ACCOUNT = 1787 ; The security database on the server does not have a computer account for this workstation trust relationship.
Global Const $ERROR_TRUSTED_DOMAIN_FAILURE = 1788 ; The trust relationship between the primary domain and the trusted domain failed.
Global Const $ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789 ; The trust relationship between this workstation and the primary domain failed.
Global Const $ERROR_TRUST_FAILURE = 1790 ; The network logon failed.
Global Const $RPC_S_CALL_IN_PROGRESS = 1791 ; A remote procedure call is already in progress for this thread.
Global Const $ERROR_NETLOGON_NOT_STARTED = 1792 ; An attempt was made to logon, but the network logon service was not started.
Global Const $ERROR_ACCOUNT_EXPIRED = 1793 ; The user's account has expired.
Global Const $ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794 ; The redirector is in use and cannot be unloaded.
Global Const $ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795 ; The specified printer driver is already installed.
Global Const $ERROR_UNKNOWN_PORT = 1796 ; The specified port is unknown.
Global Const $ERROR_UNKNOWN_PRINTER_DRIVER = 1797 ; The printer driver is unknown.
Global Const $ERROR_UNKNOWN_PRINTPROCESSOR = 1798 ; The print processor is unknown.
Global Const $ERROR_INVALID_SEPARATOR_FILE = 1799 ; The specified separator file is invalid.
Global Const $ERROR_INVALID_PRIORITY = 1800 ; The specified priority is invalid.
Global Const $ERROR_INVALID_PRINTER_NAME = 1801 ; The printer name is invalid.
Global Const $ERROR_PRINTER_ALREADY_EXISTS = 1802 ; The printer already exists.
Global Const $ERROR_INVALID_PRINTER_COMMAND = 1803 ; The printer command is invalid.
Global Const $ERROR_INVALID_DATATYPE = 1804 ; The specified datatype is invalid.
Global Const $ERROR_INVALID_ENVIRONMENT = 1805 ; The environment specified is invalid.
Global Const $RPC_S_NO_MORE_BINDINGS = 1806 ; There are no more bindings.
Global Const $ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807 ; The account used is an interdomain trust account. Use your global user account or local user account to access this server.
Global Const $ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808 ; The account used is a computer account. Use your global user account or local user account to access this server.
Global Const $ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809 ; The account used is a server trust account. Use your global user account or local user account to access this server.
Global Const $ERROR_DOMAIN_TRUST_INCONSISTENT = 1810 ; The name or security ID (SID) of the domain specified is inconsistent with the trust information for that domain.
Global Const $ERROR_SERVER_HAS_OPEN_HANDLES = 1811 ; The server is in use and cannot be unloaded.
Global Const $ERROR_RESOURCE_DATA_NOT_FOUND = 1812 ; The specified image file did not contain a resource section.
Global Const $ERROR_RESOURCE_TYPE_NOT_FOUND = 1813 ; The specified resource type cannot be found in the image file.
Global Const $ERROR_RESOURCE_NAME_NOT_FOUND = 1814 ; The specified resource name cannot be found in the image file.
Global Const $ERROR_RESOURCE_LANG_NOT_FOUND = 1815 ; The specified resource language ID cannot be found in the image file.
Global Const $ERROR_NOT_ENOUGH_QUOTA = 1816 ; Not enough quota is available to process this command.
Global Const $RPC_S_NO_INTERFACES = 1817 ; No interfaces have been registered.
Global Const $RPC_S_CALL_CANCELLED = 1818 ; The remote procedure call was canceled.
Global Const $RPC_S_BINDING_INCOMPLETE = 1819 ; The binding handle does not contain all required information.
Global Const $RPC_S_COMM_FAILURE = 1820 ; A communications failure occurred during a remote procedure call.
Global Const $RPC_S_UNSUPPORTED_AUTHN_LEVEL = 1821 ; The requested authentication level is not supported.
Global Const $RPC_S_NO_PRINC_NAME = 1822 ; No principal name registered.
Global Const $RPC_S_NOT_RPC_ERROR = 1823 ; The error specified is not a valid Windows RPC error code.
Global Const $RPC_S_UUID_LOCAL_ONLY = 1824 ; A UUID that is valid only on this computer has been allocated.
Global Const $RPC_S_SEC_PKG_ERROR = 1825 ; A security package specific error occurred.
Global Const $RPC_S_NOT_CANCELLED = 1826 ; Thread is not canceled.
Global Const $RPC_X_INVALID_ES_ACTION = 1827 ; Invalid operation on the encoding/decoding handle.
Global Const $RPC_X_WRONG_ES_VERSION = 1828 ; Incompatible version of the serializing package.
Global Const $RPC_X_WRONG_STUB_VERSION = 1829 ; Incompatible version of the RPC stub.
Global Const $RPC_X_INVALID_PIPE_OBJECT = 1830 ; The RPC pipe object is invalid or corrupted.
Global Const $RPC_X_WRONG_PIPE_ORDER = 1831 ; An invalid operation was attempted on an RPC pipe object.
Global Const $RPC_X_WRONG_PIPE_VERSION = 1832 ; Unsupported RPC pipe version.
Global Const $RPC_S_COOKIE_AUTH_FAILED = 1833 ; HTTP proxy server rejected the connection because the cookie authentication failed.
Global Const $RPC_S_GROUP_MEMBER_NOT_FOUND = 1898 ; The group member was not found.
Global Const $EPT_S_CANT_CREATE = 1899 ; The endpoint mapper database entry could not be created.
Global Const $RPC_S_INVALID_OBJECT = 1900 ; The object universal unique identifier (UUID) is the nil UUID.
Global Const $ERROR_INVALID_TIME = 1901 ; The specified time is invalid.
Global Const $ERROR_INVALID_FORM_NAME = 1902 ; The specified form name is invalid.
Global Const $ERROR_INVALID_FORM_SIZE = 1903 ; The specified form size is invalid.
Global Const $ERROR_ALREADY_WAITING = 1904 ; The specified printer handle is already being waited on.
Global Const $ERROR_PRINTER_DELETED = 1905 ; The specified printer has been deleted.
Global Const $ERROR_INVALID_PRINTER_STATE = 1906 ; The state of the printer is invalid.
Global Const $ERROR_PASSWORD_MUST_CHANGE = 1907 ; The user's password must be changed before logging on the first time.
Global Const $ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908 ; Could not find the domain controller for this domain.
Global Const $ERROR_ACCOUNT_LOCKED_OUT = 1909 ; The referenced account is currently locked out and may not be logged on to.
Global Const $OR_INVALID_OXID = 1910 ; The object exporter specified was not found.
Global Const $OR_INVALID_OID = 1911 ; The object specified was not found.
Global Const $OR_INVALID_SET = 1912 ; The object resolver set specified was not found.
Global Const $RPC_S_SEND_INCOMPLETE = 1913 ; Some data remains to be sent in the request buffer.
Global Const $RPC_S_INVALID_ASYNC_HANDLE = 1914 ; Invalid asynchronous remote procedure call handle.
Global Const $RPC_S_INVALID_ASYNC_CALL = 1915 ; Invalid asynchronous RPC call handle for this operation.
Global Const $RPC_X_PIPE_CLOSED = 1916 ; The RPC pipe object has already been closed.
Global Const $RPC_X_PIPE_DISCIPLINE_ERROR = 1917 ; The RPC call completed before all pipes were processed.
Global Const $RPC_X_PIPE_EMPTY = 1918 ; No more data is available from the RPC pipe.
Global Const $ERROR_NO_SITENAME = 1919 ; No site name is available for this machine.
Global Const $ERROR_CANT_ACCESS_FILE = 1920 ; The file cannot be accessed by the system.
Global Const $ERROR_CANT_RESOLVE_FILENAME = 1921 ; The name of the file cannot be resolved by the system.
Global Const $RPC_S_ENTRY_TYPE_MISMATCH = 1922 ; The entry is not of the expected type.
Global Const $RPC_S_NOT_ALL_OBJS_EXPORTED = 1923 ; Not all object UUIDs could be exported to the specified entry.
Global Const $RPC_S_INTERFACE_NOT_EXPORTED = 1924 ; Interface could not be exported to the specified entry.
Global Const $RPC_S_PROFILE_NOT_ADDED = 1925 ; The specified profile entry could not be added.
Global Const $RPC_S_PRF_ELT_NOT_ADDED = 1926 ; The specified profile element could not be added.
Global Const $RPC_S_PRF_ELT_NOT_REMOVED = 1927 ; The specified profile element could not be removed.
Global Const $RPC_S_GRP_ELT_NOT_ADDED = 1928 ; The group element could not be added.
Global Const $RPC_S_GRP_ELT_NOT_REMOVED = 1929 ; The group element could not be removed.
Global Const $ERROR_KM_DRIVER_BLOCKED = 1930 ; The printer driver is not compatible with a policy enabled on your computer that blocks NT 4.0 drivers.
Global Const $ERROR_CONTEXT_EXPIRED = 1931 ; The context has expired and can no longer be used.
Global Const $ERROR_PER_USER_TRUST_QUOTA_EXCEEDED = 1932 ; The current user's delegated trust creation quota has been exceeded.
Global Const $ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED = 1933 ; The total delegated trust creation quota has been exceeded.
Global Const $ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED = 1934 ; The current user's delegated trust deletion quota has been exceeded.
Global Const $ERROR_AUTHENTICATION_FIREWALL_FAILED = 1935 ; Logon Failure: The machine you are logging onto is protected by an authentication firewall. The specified account is not allowed to authenticate to the machine.
Global Const $ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED = 1936 ; Remote connections to the Print Spooler are blocked by a policy set on your machine.
Global Const $ERROR_NTLM_BLOCKED = 1937 ; Authentication failed because NTLM authentication has been disabled.
Global Const $ERROR_INVALID_PIXEL_FORMAT = 2000 ; The pixel format is invalid.
Global Const $ERROR_BAD_DRIVER = 2001 ; The specified driver is invalid.
Global Const $ERROR_INVALID_WINDOW_STYLE = 2002 ; The window style or class attribute is invalid for this operation.
Global Const $ERROR_METAFILE_NOT_SUPPORTED = 2003 ; The requested metafile operation is not supported.
Global Const $ERROR_TRANSFORM_NOT_SUPPORTED = 2004 ; The requested transformation operation is not supported.
Global Const $ERROR_CLIPPING_NOT_SUPPORTED = 2005 ; The requested clipping operation is not supported.
Global Const $ERROR_INVALID_CMM = 2010 ; The specified color management module is invalid.
Global Const $ERROR_INVALID_PROFILE = 2011 ; The specified color profile is invalid.
Global Const $ERROR_TAG_NOT_FOUND = 2012 ; The specified tag was not found.
Global Const $ERROR_TAG_NOT_PRESENT = 2013 ; A required tag is not present.
Global Const $ERROR_DUPLICATE_TAG = 2014 ; The specified tag is already present.
Global Const $ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE = 2015 ; The specified color profile is not associated with the specified device.
Global Const $ERROR_PROFILE_NOT_FOUND = 2016 ; The specified color profile was not found.
Global Const $ERROR_INVALID_COLORSPACE = 2017 ; The specified color space is invalid.
Global Const $ERROR_ICM_NOT_ENABLED = 2018 ; Image Color Management is not enabled.
Global Const $ERROR_DELETING_ICM_XFORM = 2019 ; There was an error while deleting the color transform.
Global Const $ERROR_INVALID_TRANSFORM = 2020 ; The specified color transform is invalid.
Global Const $ERROR_COLORSPACE_MISMATCH = 2021 ; The specified transform does not match the bitmap's color space.
Global Const $ERROR_INVALID_COLORINDEX = 2022 ; The specified named color index is not present in the profile.
Global Const $ERROR_PROFILE_DOES_NOT_MATCH_DEVICE = 2023 ; The specified profile is intended for a device of a different type than the specified device.
Global Const $ERROR_CONNECTED_OTHER_PASSWORD = 2108 ; The network connection was made successfully, but the user had to be prompted for a password other than the one originally specified.
Global Const $ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT = 2109 ; The network connection was made successfully using default credentials.
Global Const $ERROR_BAD_USERNAME = 2202 ; The specified user name is invalid.
Global Const $ERROR_NOT_CONNECTED = 2250 ; This network connection does not exist.
Global Const $ERROR_OPEN_FILES = 2401 ; This network connection has files open or requests pending.
Global Const $ERROR_ACTIVE_CONNECTIONS = 2402 ; Active connections still exist.
Global Const $ERROR_DEVICE_IN_USE = 2404 ; The device is in use by an active process and cannot be disconnected.
Global Const $ERROR_UNKNOWN_PRINT_MONITOR = 3000 ; The specified print monitor is unknown.
Global Const $ERROR_PRINTER_DRIVER_IN_USE = 3001 ; The specified printer driver is currently in use.
Global Const $ERROR_SPOOL_FILE_NOT_FOUND = 3002 ; The spool file was not found.
Global Const $ERROR_SPL_NO_STARTDOC = 3003 ; A StartDocPrinter call was not issued.
Global Const $ERROR_SPL_NO_ADDJOB = 3004 ; An AddJob call was not issued.
Global Const $ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005 ; The specified print processor has already been installed.
Global Const $ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006 ; The specified print monitor has already been installed.
Global Const $ERROR_INVALID_PRINT_MONITOR = 3007 ; The specified print monitor does not have the required functions.
Global Const $ERROR_PRINT_MONITOR_IN_USE = 3008 ; The specified print monitor is currently in use.
Global Const $ERROR_PRINTER_HAS_JOBS_QUEUED = 3009 ; The requested operation is not allowed when there are jobs queued to the printer.
Global Const $ERROR_SUCCESS_REBOOT_REQUIRED = 3010 ; The requested operation is successful. Changes will not be effective until the system is rebooted.
Global Const $ERROR_SUCCESS_RESTART_REQUIRED = 3011 ; The requested operation is successful. Changes will not be effective until the service is restarted.
Global Const $ERROR_PRINTER_NOT_FOUND = 3012 ; No printers were found.
Global Const $ERROR_PRINTER_DRIVER_WARNED = 3013 ; The printer driver is known to be unreliable.
Global Const $ERROR_PRINTER_DRIVER_BLOCKED = 3014 ; The printer driver is known to harm the system.
Global Const $ERROR_PRINTER_DRIVER_PACKAGE_IN_USE = 3015 ; The specified printer driver package is currently in use.
Global Const $ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND = 3016 ; Unable to find a core driver package that is required by the printer driver package.
Global Const $ERROR_FAIL_REBOOT_REQUIRED = 3017 ; The requested operation failed. A system reboot is required to roll back changes made.
Global Const $ERROR_FAIL_REBOOT_INITIATED = 3018 ; The requested operation failed. A system reboot has been initiated to roll back changes made.
Global Const $ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED = 3019 ; The specified printer driver was not found on the system and needs to be downloaded.
Global Const $ERROR_PRINT_JOB_RESTART_REQUIRED = 3020 ; The requested print job has failed to print. A print system update requires the job to be resubmitted.
Global Const $ERROR_IO_REISSUE_AS_CACHED = 3950 ; Reissue the given operation as a cached I/O operation.
Global Const $ERROR_WINS_INTERNAL = 4000 ; WINS encountered an error while processing the command.
Global Const $ERROR_CAN_NOT_DEL_LOCAL_WINS = 4001 ; The local WINS cannot be deleted.
Global Const $ERROR_STATIC_INIT = 4002 ; The importation from the file failed.
Global Const $ERROR_INC_BACKUP = 4003 ; The backup failed. Was a full backup done before?
Global Const $ERROR_FULL_BACKUP = 4004 ; The backup failed. Check the directory to which you are backing the database.
Global Const $ERROR_REC_NON_EXISTENT = 4005 ; The name does not exist in the WINS database.
Global Const $ERROR_RPL_NOT_ALLOWED = 4006 ; Replication with a nonconfigured partner is not allowed.
Global Const $ERROR_DHCP_ADDRESS_CONFLICT = 4100 ; The DHCP client has obtained an IP address that is already in use on the network. The local interface will be disabled until the DHCP client can obtain a new address.
Global Const $ERROR_WMI_GUID_NOT_FOUND = 4200 ; The GUID passed was not recognized as valid by a WMI data provider.
Global Const $ERROR_WMI_INSTANCE_NOT_FOUND = 4201 ; The instance name passed was not recognized as valid by a WMI data provider.
Global Const $ERROR_WMI_ITEMID_NOT_FOUND = 4202 ; The data item ID passed was not recognized as valid by a WMI data provider.
Global Const $ERROR_WMI_TRY_AGAIN = 4203 ; The WMI request could not be completed and should be retried.
Global Const $ERROR_WMI_DP_NOT_FOUND = 4204 ; The WMI data provider could not be located.
Global Const $ERROR_WMI_UNRESOLVED_INSTANCE_REF = 4205 ; The WMI data provider references an instance set that has not been registered.
Global Const $ERROR_WMI_ALREADY_ENABLED = 4206 ; The WMI data block or event notification has already been enabled.
Global Const $ERROR_WMI_GUID_DISCONNECTED = 4207 ; The WMI data block is no longer available.
Global Const $ERROR_WMI_SERVER_UNAVAILABLE = 4208 ; The WMI data service is not available.
Global Const $ERROR_WMI_DP_FAILED = 4209 ; The WMI data provider failed to carry out the request.
Global Const $ERROR_WMI_INVALID_MOF = 4210 ; The WMI MOF information is not valid.
Global Const $ERROR_WMI_INVALID_REGINFO = 4211 ; The WMI registration information is not valid.
Global Const $ERROR_WMI_ALREADY_DISABLED = 4212 ; The WMI data block or event notification has already been disabled.
Global Const $ERROR_WMI_READ_ONLY = 4213 ; The WMI data item or data block is read only.
Global Const $ERROR_WMI_SET_FAILURE = 4214 ; The WMI data item or data block could not be changed.
Global Const $ERROR_INVALID_MEDIA = 4300 ; The media identifier does not represent a valid medium.
Global Const $ERROR_INVALID_LIBRARY = 4301 ; The library identifier does not represent a valid library.
Global Const $ERROR_INVALID_MEDIA_POOL = 4302 ; The media pool identifier does not represent a valid media pool.
Global Const $ERROR_DRIVE_MEDIA_MISMATCH = 4303 ; The drive and medium are not compatible or exist in different libraries.
Global Const $ERROR_MEDIA_OFFLINE = 4304 ; The medium currently exists in an offline library and must be online to perform this operation.
Global Const $ERROR_LIBRARY_OFFLINE = 4305 ; The operation cannot be performed on an offline library.
Global Const $ERROR_EMPTY = 4306 ; The library, drive, or media pool is empty.
Global Const $ERROR_NOT_EMPTY = 4307 ; The library, drive, or media pool must be empty to perform this operation.
Global Const $ERROR_MEDIA_UNAVAILABLE = 4308 ; No media is currently available in this media pool or library.
Global Const $ERROR_RESOURCE_DISABLED = 4309 ; A resource required for this operation is disabled.
Global Const $ERROR_INVALID_CLEANER = 4310 ; The media identifier does not represent a valid cleaner.
Global Const $ERROR_UNABLE_TO_CLEAN = 4311 ; The drive cannot be cleaned or does not support cleaning.
Global Const $ERROR_OBJECT_NOT_FOUND = 4312 ; The object identifier does not represent a valid object.
Global Const $ERROR_DATABASE_FAILURE = 4313 ; Unable to read from or write to the database.
Global Const $ERROR_DATABASE_FULL = 4314 ; The database is full.
Global Const $ERROR_MEDIA_INCOMPATIBLE = 4315 ; The medium is not compatible with the device or media pool.
Global Const $ERROR_RESOURCE_NOT_PRESENT = 4316 ; The resource required for this operation does not exist.
Global Const $ERROR_INVALID_OPERATION = 4317 ; The operation identifier is not valid.
Global Const $ERROR_MEDIA_NOT_AVAILABLE = 4318 ; The media is not mounted or ready for use.
Global Const $ERROR_DEVICE_NOT_AVAILABLE = 4319 ; The device is not ready for use.
Global Const $ERROR_REQUEST_REFUSED = 4320 ; The operator or administrator has refused the request.
Global Const $ERROR_INVALID_DRIVE_OBJECT = 4321 ; The drive identifier does not represent a valid drive.
Global Const $ERROR_LIBRARY_FULL = 4322 ; Library is full. No slot is available for use.
Global Const $ERROR_MEDIUM_NOT_ACCESSIBLE = 4323 ; The transport cannot access the medium.
Global Const $ERROR_UNABLE_TO_LOAD_MEDIUM = 4324 ; Unable to load the medium into the drive.
Global Const $ERROR_UNABLE_TO_INVENTORY_DRIVE = 4325 ; Unable to retrieve the drive status.
Global Const $ERROR_UNABLE_TO_INVENTORY_SLOT = 4326 ; Unable to retrieve the slot status.
Global Const $ERROR_UNABLE_TO_INVENTORY_TRANSPORT = 4327 ; Unable to retrieve status about the transport.
Global Const $ERROR_TRANSPORT_FULL = 4328 ; Cannot use the transport because it is already in use.
Global Const $ERROR_CONTROLLING_IEPORT = 4329 ; Unable to open or close the inject/eject port.
Global Const $ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA = 4330 ; Unable to eject the medium because it is in a drive.
Global Const $ERROR_CLEANER_SLOT_SET = 4331 ; A cleaner slot is already reserved.
Global Const $ERROR_CLEANER_SLOT_NOT_SET = 4332 ; A cleaner slot is not reserved.
Global Const $ERROR_CLEANER_CARTRIDGE_SPENT = 4333 ; The cleaner cartridge has performed the maximum number of drive cleanings.
Global Const $ERROR_UNEXPECTED_OMID = 4334 ; Unexpected on-medium identifier.
Global Const $ERROR_CANT_DELETE_LAST_ITEM = 4335 ; The last remaining item in this group or resource cannot be deleted.
Global Const $ERROR_MESSAGE_EXCEEDS_MAX_SIZE = 4336 ; The message provided exceeds the maximum size allowed for this parameter.
Global Const $ERROR_VOLUME_CONTAINS_SYS_FILES = 4337 ; The volume contains system or paging files.
Global Const $ERROR_INDIGENOUS_TYPE = 4338 ; The media type cannot be removed from this library since at least one drive in the library reports it can support this media type.
Global Const $ERROR_NO_SUPPORTING_DRIVES = 4339 ; This offline media cannot be mounted on this system since no enabled drives are present which can be used.
Global Const $ERROR_CLEANER_CARTRIDGE_INSTALLED = 4340 ; A cleaner cartridge is present in the tape library.
Global Const $ERROR_IEPORT_FULL = 4341 ; Cannot use the inject/eject port because it is not empty.
Global Const $ERROR_FILE_OFFLINE = 4350 ; The file is currently not available for use on this computer.
Global Const $ERROR_REMOTE_STORAGE_NOT_ACTIVE = 4351 ; The remote storage service is not operational at this time.
Global Const $ERROR_REMOTE_STORAGE_MEDIA_ERROR = 4352 ; The remote storage service encountered a media error.
Global Const $ERROR_NOT_A_REPARSE_POINT = 4390 ; The file or directory is not a reparse point.
Global Const $ERROR_REPARSE_ATTRIBUTE_CONFLICT = 4391 ; The reparse point attribute cannot be set because it conflicts with an existing attribute.
Global Const $ERROR_INVALID_REPARSE_DATA = 4392 ; The data present in the reparse point buffer is invalid.
Global Const $ERROR_REPARSE_TAG_INVALID = 4393 ; The tag present in the reparse point buffer is invalid.
Global Const $ERROR_REPARSE_TAG_MISMATCH = 4394 ; There is a mismatch between the tag specified in the request and the tag present in the reparse point.
Global Const $ERROR_VOLUME_NOT_SIS_ENABLED = 4500 ; Single Instance Storage is not available on this volume.
Global Const $ERROR_DEPENDENT_RESOURCE_EXISTS = 5001 ; The operation cannot be completed because other resources are dependent on this resource.
Global Const $ERROR_DEPENDENCY_NOT_FOUND = 5002 ; The cluster resource dependency cannot be found.
Global Const $ERROR_DEPENDENCY_ALREADY_EXISTS = 5003 ; The cluster resource cannot be made dependent on the specified resource because it is already dependent.
Global Const $ERROR_RESOURCE_NOT_ONLINE = 5004 ; The cluster resource is not online.
Global Const $ERROR_HOST_NODE_NOT_AVAILABLE = 5005 ; A cluster node is not available for this operation.
Global Const $ERROR_RESOURCE_NOT_AVAILABLE = 5006 ; The cluster resource is not available.
Global Const $ERROR_RESOURCE_NOT_FOUND = 5007 ; The cluster resource could not be found.
Global Const $ERROR_SHUTDOWN_CLUSTER = 5008 ; The cluster is being shut down.
Global Const $ERROR_CANT_EVICT_ACTIVE_NODE = 5009 ; A cluster node cannot be evicted from the cluster unless the node is down or it is the last node.
Global Const $ERROR_OBJECT_ALREADY_EXISTS = 5010 ; The object already exists.
Global Const $ERROR_OBJECT_IN_LIST = 5011 ; The object is already in the list.
Global Const $ERROR_GROUP_NOT_AVAILABLE = 5012 ; The cluster group is not available for any new requests.
Global Const $ERROR_GROUP_NOT_FOUND = 5013 ; The cluster group could not be found.
Global Const $ERROR_GROUP_NOT_ONLINE = 5014 ; The operation could not be completed because the cluster group is not online.
Global Const $ERROR_HOST_NODE_NOT_RESOURCE_OWNER = 5015 ; The operation failed because either the specified cluster node is not the owner of the resource, or the node is not a possible owner of the resource.
Global Const $ERROR_HOST_NODE_NOT_GROUP_OWNER = 5016 ; The operation failed because either the specified cluster node is not the owner of the group, or the node is not a possible owner of the group.
Global Const $ERROR_RESMON_CREATE_FAILED = 5017 ; The cluster resource could not be created in the specified resource monitor.
Global Const $ERROR_RESMON_ONLINE_FAILED = 5018 ; The cluster resource could not be brought online by the resource monitor.
Global Const $ERROR_RESOURCE_ONLINE = 5019 ; The operation could not be completed because the cluster resource is online.
Global Const $ERROR_QUORUM_RESOURCE = 5020 ; The cluster resource could not be deleted or brought offline because it is the quorum resource.
Global Const $ERROR_NOT_QUORUM_CAPABLE = 5021 ; The cluster could not make the specified resource a quorum resource because it is not capable of being a quorum resource.
Global Const $ERROR_CLUSTER_SHUTTING_DOWN = 5022 ; The cluster software is shutting down.
Global Const $ERROR_INVALID_STATE = 5023 ; The group or resource is not in the correct state to perform the requested operation.
Global Const $ERROR_RESOURCE_PROPERTIES_STORED = 5024 ; The properties were stored but not all changes will take effect until the next time the resource is brought online.
Global Const $ERROR_NOT_QUORUM_CLASS = 5025 ; The cluster could not make the specified resource a quorum resource because it does not belong to a shared storage class.
Global Const $ERROR_CORE_RESOURCE = 5026 ; The cluster resource could not be deleted since it is a core resource.
Global Const $ERROR_QUORUM_RESOURCE_ONLINE_FAILED = 5027 ; The quorum resource failed to come online.
Global Const $ERROR_QUORUMLOG_OPEN_FAILED = 5028 ; The quorum log could not be created or mounted successfully.
Global Const $ERROR_CLUSTERLOG_CORRUPT = 5029 ; The cluster log is corrupt.
Global Const $ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE = 5030 ; The record could not be written to the cluster log since it exceeds the maximum size.
Global Const $ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE = 5031 ; The cluster log exceeds its maximum size.
Global Const $ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND = 5032 ; No checkpoint record was found in the cluster log.
Global Const $ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE = 5033 ; The minimum required disk space needed for logging is not available.
Global Const $ERROR_QUORUM_OWNER_ALIVE = 5034 ; The cluster node failed to take control of the quorum resource because the resource is owned by another active node.
Global Const $ERROR_NETWORK_NOT_AVAILABLE = 5035 ; A cluster network is not available for this operation.
Global Const $ERROR_NODE_NOT_AVAILABLE = 5036 ; A cluster node is not available for this operation.
Global Const $ERROR_ALL_NODES_NOT_AVAILABLE = 5037 ; All cluster nodes must be running to perform this operation.
Global Const $ERROR_RESOURCE_FAILED = 5038 ; A cluster resource failed.
Global Const $ERROR_CLUSTER_INVALID_NODE = 5039 ; The cluster node is not valid.
Global Const $ERROR_CLUSTER_NODE_EXISTS = 5040 ; The cluster node already exists.
Global Const $ERROR_CLUSTER_JOIN_IN_PROGRESS = 5041 ; A node is in the process of joining the cluster.
Global Const $ERROR_CLUSTER_NODE_NOT_FOUND = 5042 ; The cluster node was not found.
Global Const $ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND = 5043 ; The cluster local node information was not found.
Global Const $ERROR_CLUSTER_NETWORK_EXISTS = 5044 ; The cluster network already exists.
Global Const $ERROR_CLUSTER_NETWORK_NOT_FOUND = 5045 ; The cluster network was not found.
Global Const $ERROR_CLUSTER_NETINTERFACE_EXISTS = 5046 ; The cluster network interface already exists.
Global Const $ERROR_CLUSTER_NETINTERFACE_NOT_FOUND = 5047 ; The cluster network interface was not found.
Global Const $ERROR_CLUSTER_INVALID_REQUEST = 5048 ; The cluster request is not valid for this object.
Global Const $ERROR_CLUSTER_INVALID_NETWORK_PROVIDER = 5049 ; The cluster network provider is not valid.
Global Const $ERROR_CLUSTER_NODE_DOWN = 5050 ; The cluster node is down.
Global Const $ERROR_CLUSTER_NODE_UNREACHABLE = 5051 ; The cluster node is not reachable.
Global Const $ERROR_CLUSTER_NODE_NOT_MEMBER = 5052 ; The cluster node is not a member of the cluster.
Global Const $ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS = 5053 ; A cluster join operation is not in progress.
Global Const $ERROR_CLUSTER_INVALID_NETWORK = 5054 ; The cluster network is not valid.
Global Const $ERROR_CLUSTER_NODE_UP = 5056 ; The cluster node is up.
Global Const $ERROR_CLUSTER_IPADDR_IN_USE = 5057 ; The cluster IP address is already in use.
Global Const $ERROR_CLUSTER_NODE_NOT_PAUSED = 5058 ; The cluster node is not paused.
Global Const $ERROR_CLUSTER_NO_SECURITY_CONTEXT = 5059 ; No cluster security context is available.
Global Const $ERROR_CLUSTER_NETWORK_NOT_INTERNAL = 5060 ; The cluster network is not configured for internal cluster communication.
Global Const $ERROR_CLUSTER_NODE_ALREADY_UP = 5061 ; The cluster node is already up.
Global Const $ERROR_CLUSTER_NODE_ALREADY_DOWN = 5062 ; The cluster node is already down.
Global Const $ERROR_CLUSTER_NETWORK_ALREADY_ONLINE = 5063 ; The cluster network is already online.
Global Const $ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE = 5064 ; The cluster network is already offline.
Global Const $ERROR_CLUSTER_NODE_ALREADY_MEMBER = 5065 ; The cluster node is already a member of the cluster.
Global Const $ERROR_CLUSTER_LAST_INTERNAL_NETWORK = 5066 ; The cluster network is the only one configured for internal cluster communication between two or more active cluster nodes. The internal communication capability cannot be removed from the network.
Global Const $ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS = 5067 ; One or more cluster resources depend on the network to provide service to clients. The client access capability cannot be removed from the network.
Global Const $ERROR_INVALID_OPERATION_ON_QUORUM = 5068 ; This operation cannot be performed on the cluster resource as it the quorum resource. You may not bring the quorum resource offline or modify its possible owners list.
Global Const $ERROR_DEPENDENCY_NOT_ALLOWED = 5069 ; The cluster quorum resource is not allowed to have any dependencies.
Global Const $ERROR_CLUSTER_NODE_PAUSED = 5070 ; The cluster node is paused.
Global Const $ERROR_NODE_CANT_HOST_RESOURCE = 5071 ; The cluster resource cannot be brought online. The owner node cannot run this resource.
Global Const $ERROR_CLUSTER_NODE_NOT_READY = 5072 ; The cluster node is not ready to perform the requested operation.
Global Const $ERROR_CLUSTER_NODE_SHUTTING_DOWN = 5073 ; The cluster node is shutting down.
Global Const $ERROR_CLUSTER_JOIN_ABORTED = 5074 ; The cluster join operation was aborted.
Global Const $ERROR_CLUSTER_INCOMPATIBLE_VERSIONS = 5075 ; The cluster join operation failed due to incompatible software versions between the joining node and its sponsor.
Global Const $ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED = 5076 ; This resource cannot be created because the cluster has reached the limit on the number of resources it can monitor.
Global Const $ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED = 5077 ; The system configuration changed during the cluster join or form operation. The join or form operation was aborted.
Global Const $ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND = 5078 ; The specified resource type was not found.
Global Const $ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED = 5079 ; The specified node does not support a resource of this type. This may be due to version inconsistencies or due to the absence of the resource DLL on this node.
Global Const $ERROR_CLUSTER_RESNAME_NOT_FOUND = 5080 ; The specified resource name is not supported by this resource DLL. This may be due to a bad (or changed) name supplied to the resource DLL.
Global Const $ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED = 5081 ; No authentication package could be registered with the RPC server.
Global Const $ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST = 5082 ; You cannot bring the group online because the owner of the group is not in the preferred list for the group. To change the owner node for the group, move the group.
Global Const $ERROR_CLUSTER_DATABASE_SEQMISMATCH = 5083 ; The join operation failed because the cluster database sequence number has changed or is incompatible with the locker node. This may happen during a join operation if the cluster database was changing during the join.
Global Const $ERROR_RESMON_INVALID_STATE = 5084 ; The resource monitor will not allow the fail operation to be performed while the resource is in its current state. This may happen if the resource is in a pending state.
Global Const $ERROR_CLUSTER_GUM_NOT_LOCKER = 5085 ; A non locker code got a request to reserve the lock for making global updates.
Global Const $ERROR_QUORUM_DISK_NOT_FOUND = 5086 ; The quorum disk could not be located by the cluster service.
Global Const $ERROR_DATABASE_BACKUP_CORRUPT = 5087 ; The backed up cluster database is possibly corrupt.
Global Const $ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT = 5088 ; A DFS root already exists in this cluster node.
Global Const $ERROR_RESOURCE_PROPERTY_UNCHANGEABLE = 5089 ; An attempt to modify a resource property failed because it conflicts with another existing property.
Global Const $ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE = 5890 ; An operation was attempted that is incompatible with the current membership state of the node.
Global Const $ERROR_CLUSTER_QUORUMLOG_NOT_FOUND = 5891 ; The quorum resource does not contain the quorum log.
Global Const $ERROR_CLUSTER_MEMBERSHIP_HALT = 5892 ; The membership engine requested shutdown of the cluster service on this node.
Global Const $ERROR_CLUSTER_INSTANCE_ID_MISMATCH = 5893 ; The join operation failed because the cluster instance ID of the joining node does not match the cluster instance ID of the sponsor node.
Global Const $ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP = 5894 ; A matching cluster network for the specified IP address could not be found.
Global Const $ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH = 5895 ; The actual data type of the property did not match the expected data type of the property.
Global Const $ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP = 5896 ; The cluster node was evicted from the cluster successfully, but the node was not cleaned up. To determine what cleanup steps failed and how to recover, see the Failover Clustering application event log using Event Viewer.
Global Const $ERROR_CLUSTER_PARAMETER_MISMATCH = 5897 ; Two or more parameter values specified for a resource's properties are in conflict.
Global Const $ERROR_NODE_CANNOT_BE_CLUSTERED = 5898 ; This computer cannot be made a member of a cluster.
Global Const $ERROR_CLUSTER_WRONG_OS_VERSION = 5899 ; This computer cannot be made a member of a cluster because it does not have the correct version of Windows installed.
Global Const $ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME = 5900 ; A cluster cannot be created with the specified cluster name because that cluster name is already in use. Specify a different name for the cluster.
Global Const $ERROR_CLUSCFG_ALREADY_COMMITTED = 5901 ; The cluster configuration action has already been committed.
Global Const $ERROR_CLUSCFG_ROLLBACK_FAILED = 5902 ; The cluster configuration action could not be rolled back.
Global Const $ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT = 5903 ; The drive letter assigned to a system disk on one node conflicted with the drive letter assigned to a disk on another node.
Global Const $ERROR_CLUSTER_OLD_VERSION = 5904 ; One or more nodes in the cluster are running a version of Windows that does not support this operation.
Global Const $ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME = 5905 ; The name of the corresponding computer account doesn't match the Network Name for this resource.
Global Const $ERROR_CLUSTER_NO_NET_ADAPTERS = 5906 ; No network adapters are available.
Global Const $ERROR_CLUSTER_POISONED = 5907 ; The cluster node has been poisoned.
Global Const $ERROR_CLUSTER_GROUP_MOVING = 5908 ; The group is unable to accept the request since it is moving to another node.
Global Const $ERROR_CLUSTER_RESOURCE_TYPE_BUSY = 5909 ; The resource type cannot accept the request since is too busy performing another operation.
Global Const $ERROR_RESOURCE_CALL_TIMED_OUT = 5910 ; The call to the cluster resource DLL timed out.
Global Const $ERROR_INVALID_CLUSTER_IPV6_ADDRESS = 5911 ; The address is not valid for an IPv6 Address resource. A global IPv6 address is required, and it must match a cluster network. Compatibility addresses are not permitted.
Global Const $ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION = 5912 ; An internal cluster error occurred. A call to an invalid function was attempted.
Global Const $ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS = 5913 ; A parameter value is out of acceptable range.
Global Const $ERROR_CLUSTER_PARTIAL_SEND = 5914 ; A network error occurred while sending data to another node in the cluster. The number of bytes transmitted was less than required.
Global Const $ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION = 5915 ; An invalid cluster registry operation was attempted.
Global Const $ERROR_CLUSTER_INVALID_STRING_TERMINATION = 5916 ; An input string of characters is not properly terminated.
Global Const $ERROR_CLUSTER_INVALID_STRING_FORMAT = 5917 ; An input string of characters is not in a valid format for the data it represents.
Global Const $ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS = 5918 ; An internal cluster error occurred. A cluster database transaction was attempted while a transaction was already in progress.
Global Const $ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS = 5919 ; An internal cluster error occurred. There was an attempt to commit a cluster database transaction while no transaction was in progress.
Global Const $ERROR_CLUSTER_NULL_DATA = 5920 ; An internal cluster error occurred. Data was not properly initialized.
Global Const $ERROR_CLUSTER_PARTIAL_READ = 5921 ; An error occurred while reading from a stream of data. An unexpected number of bytes was returned.
Global Const $ERROR_CLUSTER_PARTIAL_WRITE = 5922 ; An error occurred while writing to a stream of data. The required number of bytes could not be written.
Global Const $ERROR_CLUSTER_CANT_DESERIALIZE_DATA = 5923 ; An error occurred while deserializing a stream of cluster data.
Global Const $ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT = 5924 ; One or more property values for this resource are in conflict with one or more property values associated with its dependent resource(s).
Global Const $ERROR_CLUSTER_NO_QUORUM = 5925 ; An quorum of cluster nodes was not present to form a cluster.
Global Const $ERROR_CLUSTER_INVALID_IPV6_NETWORK = 5926 ; The cluster network is not valid for an IPv6 Address resource, or it does not match the configured address.
Global Const $ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK = 5927 ; The cluster network is not valid for an IPv6 Tunnel resource. Check the configuration of the IP Address resource on which the IPv6 Tunnel resource depends.
Global Const $ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP = 5928 ; Quorum resource cannot reside in the Available Storage group.
Global Const $ERROR_DEPENDENCY_TREE_TOO_COMPLEX = 5929 ; The dependencies for this resource are nested too deeply.
Global Const $ERROR_EXCEPTION_IN_RESOURCE_CALL = 5930 ; The call into the resource DLL raised an unhandled exception.
Global Const $ERROR_CLUSTER_RHS_FAILED_INITIALIZATION = 5931 ; The RHS process failed to initialize.
Global Const $ERROR_CLUSTER_NOT_INSTALLED = 5932 ; The Failover Clustering feature is not installed on this node.
Global Const $ERROR_CLUSTER_RESOURCES_MUST_BE_ONLINE_ON_THE_SAME_NODE = 5933 ; The resources must be online on the same node for this operation.
Global Const $ERROR_CLUSTER_MAX_NODES_IN_CLUSTER = 5934 ; A new node cannot be added since this cluster is already at its maximum number of nodes.
Global Const $ERROR_CLUSTER_TOO_MANY_NODES = 5935 ; This cluster cannot be created since the specified number of nodes exceeds the maximum allowed limit.
Global Const $ERROR_CLUSTER_OBJECT_ALREADY_USED = 5936 ; An attempt to use the specified cluster name failed because an enabled computer object with the given name already exists in the domain.
Global Const $ERROR_NONCORE_GROUPS_FOUND = 5937 ; This cluster cannot be destroyed. It has non-core application groups which must be deleted before the cluster can be destroyed.
Global Const $ERROR_FILE_SHARE_RESOURCE_CONFLICT = 5938 ; File share associated with file share witness resource cannot be hosted by this cluster or any of its nodes.
Global Const $ERROR_CLUSTER_EVICT_INVALID_REQUEST = 5939 ; Eviction of this node is invalid at this time. Due to quorum requirements node eviction will result in cluster shutdown. If it is the last node in the cluster, destroy cluster command should be used.
Global Const $ERROR_CLUSTER_SINGLETON_RESOURCE = 5940 ; Only one instance of this resource type is allowed in the cluster.
Global Const $ERROR_CLUSTER_GROUP_SINGLETON_RESOURCE = 5941 ; Only one instance of this resource type is allowed per resource group.
Global Const $ERROR_CLUSTER_RESOURCE_PROVIDER_FAILED = 5942 ; The resource failed to come online due to the failure of one or more provider resources.
Global Const $ERROR_CLUSTER_RESOURCE_CONFIGURATION_ERROR = 5943 ; The resource has indicated that it cannot come online on any node.
Global Const $ERROR_CLUSTER_GROUP_BUSY = 5944 ; The current operation cannot be performed on this group at this time.
Global Const $ERROR_CLUSTER_NOT_SHARED_VOLUME = 5945 ; The directory or file is not located on a cluster shared volume.
Global Const $ERROR_CLUSTER_INVALID_SECURITY_DESCRIPTOR = 5946 ; The Security Descriptor must explicitly grant full control to the Builtin Administrators group.
Global Const $ERROR_CLUSTER_SHARED_VOLUMES_IN_USE = 5947 ; There is one or more shared volumes resources configured in the cluster. Those resources needs to be moved to available storage in order for operation to succeed.
Global Const $ERROR_CLUSTER_USE_SHARED_VOLUMES_API = 5948 ; This group or resource cannot be directly manipulated. Use shared volume APIs to perform desired operation.
Global Const $ERROR_CLUSTER_BACKUP_IN_PROGRESS = 5949 ; Back up is in progress. Please wait for backup completion before trying this operation again.
Global Const $ERROR_ENCRYPTION_FAILED = 6000 ; The specified file could not be encrypted.
Global Const $ERROR_DECRYPTION_FAILED = 6001 ; The specified file could not be decrypted.
Global Const $ERROR_FILE_ENCRYPTED = 6002 ; The specified file is encrypted and the user does not have the ability to decrypt it.
Global Const $ERROR_NO_RECOVERY_POLICY = 6003 ; There is no valid encryption recovery policy configured for this system.
Global Const $ERROR_NO_EFS = 6004 ; The required encryption driver is not loaded for this system.
Global Const $ERROR_WRONG_EFS = 6005 ; The file was encrypted with a different encryption driver than is currently loaded.
Global Const $ERROR_NO_USER_KEYS = 6006 ; There are no EFS keys defined for the user.
Global Const $ERROR_FILE_NOT_ENCRYPTED = 6007 ; The specified file is not encrypted.
Global Const $ERROR_NOT_EXPORT_FORMAT = 6008 ; The specified file is not in the defined EFS export format.
Global Const $ERROR_FILE_READ_ONLY = 6009 ; The specified file is read only.
Global Const $ERROR_DIR_EFS_DISALLOWED = 6010 ; The directory has been disabled for encryption.
Global Const $ERROR_EFS_SERVER_NOT_TRUSTED = 6011 ; The server is not trusted for remote encryption operation.
Global Const $ERROR_BAD_RECOVERY_POLICY = 6012 ; Recovery policy configured for this system contains invalid recovery certificate.
Global Const $ERROR_EFS_ALG_BLOB_TOO_BIG = 6013 ; The encryption algorithm used on the source file needs a bigger key buffer than the one on the destination file.
Global Const $ERROR_VOLUME_NOT_SUPPORT_EFS = 6014 ; The disk partition does not support file encryption.
Global Const $ERROR_EFS_DISABLED = 6015 ; This machine is disabled for file encryption.
Global Const $ERROR_EFS_VERSION_NOT_SUPPORT = 6016 ; A newer system is required to decrypt this encrypted file.
Global Const $ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE = 6017 ; The remote server sent an invalid response for a file being opened with Client Side Encryption.
Global Const $ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER = 6018 ; Client Side Encryption is not supported by the remote server even though it claims to support it.
Global Const $ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE = 6019 ; File is encrypted and should be opened in Client Side Encryption mode.
Global Const $ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE = 6020 ; A new encrypted file is being created and a $EFS needs to be provided.
Global Const $ERROR_CS_ENCRYPTION_FILE_NOT_CSE = 6021 ; The SMB client requested a CSE FSCTL on a non-CSE file.
Global Const $ERROR_ENCRYPTION_POLICY_DENIES_OPERATION = 6022 ; The requested operation was blocked by policy. For more information, contact your system administrator.
Global Const $ERROR_NO_BROWSER_SERVERS_FOUND = 6118 ; The list of servers for this workgroup is not currently available.
Global Const $SCHED_E_SERVICE_NOT_LOCALSYSTEM = 6200 ; The Task Scheduler service must be configured to run in the System account to function properly. Individual tasks may be configured to run in other accounts.
Global Const $ERROR_LOG_SECTOR_INVALID = 6600 ; Log service encountered an invalid log sector.
Global Const $ERROR_LOG_SECTOR_PARITY_INVALID = 6601 ; Log service encountered a log sector with invalid block parity.
Global Const $ERROR_LOG_SECTOR_REMAPPED = 6602 ; Log service encountered a remapped log sector.
Global Const $ERROR_LOG_BLOCK_INCOMPLETE = 6603 ; Log service encountered a partial or incomplete log block.
Global Const $ERROR_LOG_INVALID_RANGE = 6604 ; Log service encountered an attempt access data outside the active log range.
Global Const $ERROR_LOG_BLOCKS_EXHAUSTED = 6605 ; Log service user marshalling buffers are exhausted.
Global Const $ERROR_LOG_READ_CONTEXT_INVALID = 6606 ; Log service encountered an attempt read from a marshalling area with an invalid read context.
Global Const $ERROR_LOG_RESTART_INVALID = 6607 ; Log service encountered an invalid log restart area.
Global Const $ERROR_LOG_BLOCK_VERSION = 6608 ; Log service encountered an invalid log block version.
Global Const $ERROR_LOG_BLOCK_INVALID = 6609 ; Log service encountered an invalid log block.
Global Const $ERROR_LOG_READ_MODE_INVALID = 6610 ; Log service encountered an attempt to read the log with an invalid read mode.
Global Const $ERROR_LOG_NO_RESTART = 6611 ; Log service encountered a log stream with no restart area.
Global Const $ERROR_LOG_METADATA_CORRUPT = 6612 ; Log service encountered a corrupted metadata file.
Global Const $ERROR_LOG_METADATA_INVALID = 6613 ; Log service encountered a metadata file that could not be created by the log file system.
Global Const $ERROR_LOG_METADATA_INCONSISTENT = 6614 ; Log service encountered a metadata file with inconsistent data.
Global Const $ERROR_LOG_RESERVATION_INVALID = 6615 ; Log service encountered an attempt to erroneous allocate or dispose reservation space.
Global Const $ERROR_LOG_CANT_DELETE = 6616 ; Log service cannot delete log file or file system container.
Global Const $ERROR_LOG_CONTAINER_LIMIT_EXCEEDED = 6617 ; Log service has reached the maximum allowable containers allocated to a log file.
Global Const $ERROR_LOG_START_OF_LOG = 6618 ; Log service has attempted to read or write backward past the start of the log.
Global Const $ERROR_LOG_POLICY_ALREADY_INSTALLED = 6619 ; Log policy could not be installed because a policy of the same type is already present.
Global Const $ERROR_LOG_POLICY_NOT_INSTALLED = 6620 ; Log policy in question was not installed at the time of the request.
Global Const $ERROR_LOG_POLICY_INVALID = 6621 ; The installed set of policies on the log is invalid.
Global Const $ERROR_LOG_POLICY_CONFLICT = 6622 ; A policy on the log in question prevented the operation from completing.
Global Const $ERROR_LOG_PINNED_ARCHIVE_TAIL = 6623 ; Log space cannot be reclaimed because the log is pinned by the archive tail.
Global Const $ERROR_LOG_RECORD_NONEXISTENT = 6624 ; Log record is not a record in the log file.
Global Const $ERROR_LOG_RECORDS_RESERVED_INVALID = 6625 ; The number of reserved log records or the adjustment of the number of reserved log records is invalid.
Global Const $ERROR_LOG_SPACE_RESERVED_INVALID = 6626 ; Reserved log space or the adjustment of the log space is invalid.
Global Const $ERROR_LOG_TAIL_INVALID = 6627 ; An new or existing archive tail or base of the active log is invalid.
Global Const $ERROR_LOG_FULL = 6628 ; Log space is exhausted.
Global Const $ERROR_COULD_NOT_RESIZE_LOG = 6629 ; The log could not be set to the requested size.
Global Const $ERROR_LOG_MULTIPLEXED = 6630 ; Log is multiplexed, no direct writes to the physical log is allowed.
Global Const $ERROR_LOG_DEDICATED = 6631 ; The operation failed because the log is a dedicated log.
Global Const $ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS = 6632 ; The operation requires an archive context.
Global Const $ERROR_LOG_ARCHIVE_IN_PROGRESS = 6633 ; Log archival is in progress.
Global Const $ERROR_LOG_EPHEMERAL = 6634 ; The operation requires a non-ephemeral log, but the log is ephemeral.
Global Const $ERROR_LOG_NOT_ENOUGH_CONTAINERS = 6635 ; The log must have at least two containers before it can be read from or written to.
Global Const $ERROR_LOG_CLIENT_ALREADY_REGISTERED = 6636 ; A log client has already registered on the stream.
Global Const $ERROR_LOG_CLIENT_NOT_REGISTERED = 6637 ; A log client has not been registered on the stream.
Global Const $ERROR_LOG_FULL_HANDLER_IN_PROGRESS = 6638 ; A request has already been made to handle the log full condition.
Global Const $ERROR_LOG_CONTAINER_READ_FAILED = 6639 ; Log service encountered an error when attempting to read from a log container.
Global Const $ERROR_LOG_CONTAINER_WRITE_FAILED = 6640 ; Log service encountered an error when attempting to write to a log container.
Global Const $ERROR_LOG_CONTAINER_OPEN_FAILED = 6641 ; Log service encountered an error when attempting open a log container.
Global Const $ERROR_LOG_CONTAINER_STATE_INVALID = 6642 ; Log service encountered an invalid container state when attempting a requested action.
Global Const $ERROR_LOG_STATE_INVALID = 6643 ; Log service is not in the correct state to perform a requested action.
Global Const $ERROR_LOG_PINNED = 6644 ; Log space cannot be reclaimed because the log is pinned.
Global Const $ERROR_LOG_METADATA_FLUSH_FAILED = 6645 ; Log metadata flush failed.
Global Const $ERROR_LOG_INCONSISTENT_SECURITY = 6646 ; Security on the log and its containers is inconsistent.
Global Const $ERROR_LOG_APPENDED_FLUSH_FAILED = 6647 ; Records were appended to the log or reservation changes were made, but the log could not be flushed.
Global Const $ERROR_LOG_PINNED_RESERVATION = 6648 ; The log is pinned due to reservation consuming most of the log space. Free some reserved records to make space available.
Global Const $ERROR_INVALID_TRANSACTION = 6700 ; The transaction handle associated with this operation is not valid.
Global Const $ERROR_TRANSACTION_NOT_ACTIVE = 6701 ; The requested operation was made in the context of a transaction that is no longer active.
Global Const $ERROR_TRANSACTION_REQUEST_NOT_VALID = 6702 ; The requested operation is not valid on the Transaction object in its current state.
Global Const $ERROR_TRANSACTION_NOT_REQUESTED = 6703 ; The caller has called a response API, but the response is not expected because the TM did not issue the corresponding request to the caller.
Global Const $ERROR_TRANSACTION_ALREADY_ABORTED = 6704 ; It is too late to perform the requested operation, since the Transaction has already been aborted.
Global Const $ERROR_TRANSACTION_ALREADY_COMMITTED = 6705 ; It is too late to perform the requested operation, since the Transaction has already been committed.
Global Const $ERROR_TM_INITIALIZATION_FAILED = 6706 ; The Transaction Manager was unable to be successfully initialized. Transacted operations are not supported.
Global Const $ERROR_RESOURCEMANAGER_READ_ONLY = 6707 ; The specified ResourceManager made no changes or updates to the resource under this transaction.
Global Const $ERROR_TRANSACTION_NOT_JOINED = 6708 ; The resource manager has attempted to prepare a transaction that it has not successfully joined.
Global Const $ERROR_TRANSACTION_SUPERIOR_EXISTS = 6709 ; The Transaction object already has a superior enlistment, and the caller attempted an operation that would have created a new superior. Only a single superior enlistment is allow.
Global Const $ERROR_CRM_PROTOCOL_ALREADY_EXISTS = 6710 ; The RM tried to register a protocol that already exists.
Global Const $ERROR_TRANSACTION_PROPAGATION_FAILED = 6711 ; The attempt to propagate the Transaction failed.
Global Const $ERROR_CRM_PROTOCOL_NOT_FOUND = 6712 ; The requested propagation protocol was not registered as a CRM.
Global Const $ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER = 6713 ; The buffer passed in to PushTransaction or PullTransaction is not in a valid format.
Global Const $ERROR_CURRENT_TRANSACTION_NOT_VALID = 6714 ; The current transaction context associated with the thread is not a valid handle to a transaction object.
Global Const $ERROR_TRANSACTION_NOT_FOUND = 6715 ; The specified Transaction object could not be opened, because it was not found.
Global Const $ERROR_RESOURCEMANAGER_NOT_FOUND = 6716 ; The specified ResourceManager object could not be opened, because it was not found.
Global Const $ERROR_ENLISTMENT_NOT_FOUND = 6717 ; The specified Enlistment object could not be opened, because it was not found.
Global Const $ERROR_TRANSACTIONMANAGER_NOT_FOUND = 6718 ; The specified TransactionManager object could not be opened, because it was not found. The TransactionManager must be brought fully Online by calling RecoverTransactionManager to recover to the end of its LogFile before objects in its Transaction or ResourceManager namespaces can be opened. In addition, errors in writing records to its LogFile can cause a TransactionManager to go offline.
Global Const $ERROR_TRANSACTIONMANAGER_NOT_ONLINE = 6719 ; The object specified could not be created or opened, because its associated TransactionManager is not online.
Global Const $ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION = 6720 ; The specified TransactionManager was unable to create the objects contained in its logfile in the Ob namespace. Therefore, the TransactionManager was unable to recover.
Global Const $ERROR_TRANSACTION_NOT_ROOT = 6721 ; The call to create a superior Enlistment on this Transaction object could not be completed, because the Transaction object specified for the enlistment is a subordinate branch of the Transaction. Only the root of the Transaction can be enlisted on as a superior.
Global Const $ERROR_TRANSACTION_OBJECT_EXPIRED = 6722 ; Because the associated transaction manager or resource manager has been closed, the handle is no longer valid.
Global Const $ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED = 6723 ; The specified operation could not be performed on this Superior enlistment, because the enlistment was not created with the corresponding completion response in the NotificationMask.
Global Const $ERROR_TRANSACTION_RECORD_TOO_LONG = 6724 ; The specified operation could not be performed, because the record that would be logged was too long. This can occur because of two conditions: either there are too many Enlistments on this Transaction, or the combined RecoveryInformation being logged on behalf of those Enlistments is too long.
Global Const $ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED = 6725 ; Implicit transactions are not supported.
Global Const $ERROR_TRANSACTION_INTEGRITY_VIOLATED = 6726 ; The kernel transaction manager had to abort or forget the transaction because it blocked forward progress.
Global Const $ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH = 6727 ; The TransactionManager identity that was supplied did not match the one recorded in the TransactionManager's log file.
Global Const $ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT = 6728 ; This snapshot operation cannot continue because a transactional resource manager cannot be frozen in its current state. Please try again.
Global Const $ERROR_TRANSACTION_MUST_WRITETHROUGH = 6729 ; The transaction cannot be enlisted on with the specified EnlistmentMask, because the transaction has already completed the PrePrepare phase. In order to ensure correctness, the ResourceManager must switch to a write-through mode and cease caching data within this transaction. Enlisting for only subsequent transaction phases may still succeed.
Global Const $ERROR_TRANSACTION_NO_SUPERIOR = 6730 ; The transaction does not have a superior enlistment.
Global Const $ERROR_TRANSACTIONAL_CONFLICT = 6800 ; The function attempted to use a name that is reserved for use by another transaction.
Global Const $ERROR_RM_NOT_ACTIVE = 6801 ; Transaction support within the specified resource manager is not started or was shut down due to an error.
Global Const $ERROR_RM_METADATA_CORRUPT = 6802 ; The metadata of the RM has been corrupted. The RM will not function.
Global Const $ERROR_DIRECTORY_NOT_RM = 6803 ; The specified directory does not contain a resource manager.
Global Const $ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE = 6805 ; The remote server or share does not support transacted file operations.
Global Const $ERROR_LOG_RESIZE_INVALID_SIZE = 6806 ; The requested log size is invalid.
Global Const $ERROR_OBJECT_NO_LONGER_EXISTS = 6807 ; The object (file, stream, link) corresponding to the handle has been deleted by a Transaction Savepoint Rollback.
Global Const $ERROR_STREAM_MINIVERSION_NOT_FOUND = 6808 ; The specified file miniversion was not found for this transacted file open.
Global Const $ERROR_STREAM_MINIVERSION_NOT_VALID = 6809 ; The specified file miniversion was found but has been invalidated. Most likely cause is a transaction savepoint rollback.
Global Const $ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION = 6810 ; A miniversion may only be opened in the context of the transaction that created it.
Global Const $ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT = 6811 ; It is not possible to open a miniversion with modify access.
Global Const $ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS = 6812 ; It is not possible to create any more miniversions for this stream.
Global Const $ERROR_REMOTE_FILE_VERSION_MISMATCH = 6814 ; The remote server sent mismatching version number or Fid for a file opened with transactions.
Global Const $ERROR_HANDLE_NO_LONGER_VALID = 6815 ; The handle has been invalidated by a transaction. The most likely cause is the presence of memory mapping on a file or an open handle when the transaction ended or rolled back to savepoint.
Global Const $ERROR_NO_TXF_METADATA = 6816 ; There is no transaction metadata on the file.
Global Const $ERROR_LOG_CORRUPTION_DETECTED = 6817 ; The log data is corrupt.
Global Const $ERROR_CANT_RECOVER_WITH_HANDLE_OPEN = 6818 ; The file can't be recovered because there is a handle still open on it.
Global Const $ERROR_RM_DISCONNECTED = 6819 ; The transaction outcome is unavailable because the resource manager responsible for it has disconnected.
Global Const $ERROR_ENLISTMENT_NOT_SUPERIOR = 6820 ; The request was rejected because the enlistment in question is not a superior enlistment.
Global Const $ERROR_RECOVERY_NOT_NEEDED = 6821 ; The transactional resource manager is already consistent. Recovery is not needed.
Global Const $ERROR_RM_ALREADY_STARTED = 6822 ; The transactional resource manager has already been started.
Global Const $ERROR_FILE_IDENTITY_NOT_PERSISTENT = 6823 ; The file cannot be opened transactionally, because its identity depends on the outcome of an unresolved transaction.
Global Const $ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY = 6824 ; The operation cannot be performed because another transaction is depending on the fact that this property will not change.
Global Const $ERROR_CANT_CROSS_RM_BOUNDARY = 6825 ; The operation would involve a single file with two transactional resource managers and is therefore not allowed.
Global Const $ERROR_TXF_DIR_NOT_EMPTY = 6826 ; The $Txf directory must be empty for this operation to succeed.
Global Const $ERROR_INDOUBT_TRANSACTIONS_EXIST = 6827 ; The operation would leave a transactional resource manager in an inconsistent state and is therefore not allowed.
Global Const $ERROR_TM_VOLATILE = 6828 ; The operation could not be completed because the transaction manager does not have a log.
Global Const $ERROR_ROLLBACK_TIMER_EXPIRED = 6829 ; A rollback could not be scheduled because a previously scheduled rollback has already executed or been queued for execution.
Global Const $ERROR_TXF_ATTRIBUTE_CORRUPT = 6830 ; The transactional metadata attribute on the file or directory is corrupt and unreadable.
Global Const $ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION = 6831 ; The encryption operation could not be completed because a transaction is active.
Global Const $ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED = 6832 ; This object is not allowed to be opened in a transaction.
Global Const $ERROR_LOG_GROWTH_FAILED = 6833 ; An attempt to create space in the transactional resource manager's log failed. The failure status has been recorded in the event log.
Global Const $ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE = 6834 ; Memory mapping (creating a mapped section) a remote file under a transaction is not supported.
Global Const $ERROR_TXF_METADATA_ALREADY_PRESENT = 6835 ; Transaction metadata is already present on this file and cannot be superseded.
Global Const $ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET = 6836 ; A transaction scope could not be entered because the scope handler has not been initialized.
Global Const $ERROR_TRANSACTION_REQUIRED_PROMOTION = 6837 ; Promotion was required in order to allow the resource manager to enlist, but the transaction was set to disallow it.
Global Const $ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION = 6838 ; This file is open for modification in an unresolved transaction and may be opened for execute only by a transacted reader.
Global Const $ERROR_TRANSACTIONS_NOT_FROZEN = 6839 ; The request to thaw frozen transactions was ignored because transactions had not previously been frozen.
Global Const $ERROR_TRANSACTION_FREEZE_IN_PROGRESS = 6840 ; Transactions cannot be frozen because a freeze is already in progress.
Global Const $ERROR_NOT_SNAPSHOT_VOLUME = 6841 ; The target volume is not a snapshot volume. This operation is only valid on a volume mounted as a snapshot.
Global Const $ERROR_NO_SAVEPOINT_WITH_OPEN_FILES = 6842 ; The savepoint operation failed because files are open on the transaction. This is not permitted.
Global Const $ERROR_DATA_LOST_REPAIR = 6843 ; Windows has discovered corruption in a file, and that file has since been repaired. Data loss may have occurred.
Global Const $ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION = 6844 ; The sparse operation could not be completed because a transaction is active on the file.
Global Const $ERROR_TM_IDENTITY_MISMATCH = 6845 ; The call to create a TransactionManager object failed because the Tm Identity stored in the logfile does not match the Tm Identity that was passed in as an argument.
Global Const $ERROR_FLOATED_SECTION = 6846 ; I/O was attempted on a section object that has been floated as a result of a transaction ending. There is no valid data.
Global Const $ERROR_CANNOT_ACCEPT_TRANSACTED_WORK = 6847 ; The transactional resource manager cannot currently accept transacted work due to a transient condition such as low resources.
Global Const $ERROR_CANNOT_ABORT_TRANSACTIONS = 6848 ; The transactional resource manager had too many transactions outstanding that could not be aborted. The transactional resource manager has been shut down.
Global Const $ERROR_BAD_CLUSTERS = 6849 ; The operation could not be completed due to bad clusters on disk.
Global Const $ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION = 6850 ; The compression operation could not be completed because a transaction is active on the file.
Global Const $ERROR_VOLUME_DIRTY = 6851 ; The operation could not be completed because the volume is dirty. Please run chkdsk and try again.
Global Const $ERROR_NO_LINK_TRACKING_IN_TRANSACTION = 6852 ; The link tracking operation could not be completed because a transaction is active.
Global Const $ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION = 6853 ; This operation cannot be performed in a transaction.
Global Const $ERROR_EXPIRED_HANDLE = 6854 ; The handle is no longer properly associated with its transaction. It may have been opened in a transactional resource manager that was subsequently forced to restart. Please close the handle and open a new one.
Global Const $ERROR_TRANSACTION_NOT_ENLISTED = 6855 ; The specified operation could not be performed because the resource manager is not enlisted in the transaction.
Global Const $ERROR_CTX_WINSTATION_NAME_INVALID = 7001 ; The specified session name is invalid.
Global Const $ERROR_CTX_INVALID_PD = 7002 ; The specified protocol driver is invalid.
Global Const $ERROR_CTX_PD_NOT_FOUND = 7003 ; The specified protocol driver was not found in the system path.
Global Const $ERROR_CTX_WD_NOT_FOUND = 7004 ; The specified terminal connection driver was not found in the system path.
Global Const $ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY = 7005 ; A registry key for event logging could not be created for this session.
Global Const $ERROR_CTX_SERVICE_NAME_COLLISION = 7006 ; A service with the same name already exists on the system.
Global Const $ERROR_CTX_CLOSE_PENDING = 7007 ; A close operation is pending on the session.
Global Const $ERROR_CTX_NO_OUTBUF = 7008 ; There are no free output buffers available.
Global Const $ERROR_CTX_MODEM_INF_NOT_FOUND = 7009 ; The MODEM.INF file was not found.
Global Const $ERROR_CTX_INVALID_MODEMNAME = 7010 ; The modem name was not found in MODEM.INF.
Global Const $ERROR_CTX_MODEM_RESPONSE_ERROR = 7011 ; The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem.
Global Const $ERROR_CTX_MODEM_RESPONSE_TIMEOUT = 7012 ; The modem did not respond to the command sent to it. Verify that the modem is properly cabled and powered on.
Global Const $ERROR_CTX_MODEM_RESPONSE_NO_CARRIER = 7013 ; Carrier detect has failed or carrier has been dropped due to disconnect.
Global Const $ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE = 7014 ; Dial tone not detected within the required time. Verify that the phone cable is properly attached and functional.
Global Const $ERROR_CTX_MODEM_RESPONSE_BUSY = 7015 ; Busy signal detected at remote site on callback.
Global Const $ERROR_CTX_MODEM_RESPONSE_VOICE = 7016 ; Voice detected at remote site on callback.
Global Const $ERROR_CTX_TD_ERROR = 7017 ; Transport driver error.
Global Const $ERROR_CTX_WINSTATION_NOT_FOUND = 7022 ; The specified session cannot be found.
Global Const $ERROR_CTX_WINSTATION_ALREADY_EXISTS = 7023 ; The specified session name is already in use.
Global Const $ERROR_CTX_WINSTATION_BUSY = 7024 ; The requested operation cannot be completed because the terminal connection is currently busy processing a connect, disconnect, reset, or delete operation.
Global Const $ERROR_CTX_BAD_VIDEO_MODE = 7025 ; An attempt has been made to connect to a session whose video mode is not supported by the current client.
Global Const $ERROR_CTX_GRAPHICS_INVALID = 7035 ; The application attempted to enable DOS graphics mode. DOS graphics mode is not supported.
Global Const $ERROR_CTX_LOGON_DISABLED = 7037 ; Your interactive logon privilege has been disabled. Please contact your administrator.
Global Const $ERROR_CTX_NOT_CONSOLE = 7038 ; The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access.
Global Const $ERROR_CTX_CLIENT_QUERY_TIMEOUT = 7040 ; The client failed to respond to the server connect message.
Global Const $ERROR_CTX_CONSOLE_DISCONNECT = 7041 ; Disconnecting the console session is not supported.
Global Const $ERROR_CTX_CONSOLE_CONNECT = 7042 ; Reconnecting a disconnected session to the console is not supported.
Global Const $ERROR_CTX_SHADOW_DENIED = 7044 ; The request to control another session remotely was denied.
Global Const $ERROR_CTX_WINSTATION_ACCESS_DENIED = 7045 ; The requested session access is denied.
Global Const $ERROR_CTX_INVALID_WD = 7049 ; The specified terminal connection driver is invalid.
Global Const $ERROR_CTX_SHADOW_INVALID = 7050 ; The requested session cannot be controlled remotely. This may be because the session is disconnected or does not currently have a user logged on.
Global Const $ERROR_CTX_SHADOW_DISABLED = 7051 ; The requested session is not configured to allow remote control.
Global Const $ERROR_CTX_CLIENT_LICENSE_IN_USE = 7052 ; Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number is currently being used by another user. Please call your system administrator to obtain a unique license number.
Global Const $ERROR_CTX_CLIENT_LICENSE_NOT_SET = 7053 ; Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number has not been entered for this copy of the Terminal Server client. Please contact your system administrator.
Global Const $ERROR_CTX_LICENSE_NOT_AVAILABLE = 7054 ; The number of connections to this computer is limited and all connections are in use right now. Try connecting later or contact your system administrator.
Global Const $ERROR_CTX_LICENSE_CLIENT_INVALID = 7055 ; The client you are using is not licensed to use this system. Your logon request is denied.
Global Const $ERROR_CTX_LICENSE_EXPIRED = 7056 ; The system license has expired. Your logon request is denied.
Global Const $ERROR_CTX_SHADOW_NOT_RUNNING = 7057 ; Remote control could not be terminated because the specified session is not currently being remotely controlled.
Global Const $ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE = 7058 ; The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported.
Global Const $ERROR_ACTIVATION_COUNT_EXCEEDED = 7059 ; Activation has already been reset the maximum number of times for this installation. Your activation timer will not be cleared.
Global Const $ERROR_CTX_WINSTATIONS_DISABLED = 7060 ; Remote logins are currently disabled.
Global Const $ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED = 7061 ; You do not have the proper encryption level to access this Session.
Global Const $ERROR_CTX_SESSION_IN_USE = 7062 ; The user %s\\%s is currently logged on to this computer. Only the current user or an administrator can log on to this computer.
Global Const $ERROR_CTX_NO_FORCE_LOGOFF = 7063 ; The user %s\\%s is already logged on to the console of this computer. You do not have permission to log in at this time. To resolve this issue, contact %s\\%s and have them log off.
Global Const $ERROR_CTX_ACCOUNT_RESTRICTION = 7064 ; Unable to log you on because of an account restriction.
Global Const $ERROR_RDP_PROTOCOL_ERROR = 7065 ; The RDP protocol component %2 detected an error in the protocol stream and has disconnected the client.
Global Const $ERROR_CTX_CDM_CONNECT = 7066 ; The Client Drive Mapping Service Has Connected on Terminal Connection.
Global Const $ERROR_CTX_CDM_DISCONNECT = 7067 ; The Client Drive Mapping Service Has Disconnected on Terminal Connection.
Global Const $ERROR_CTX_SECURITY_LAYER_ERROR = 7068 ; The Terminal Server security layer detected an error in the protocol stream and has disconnected the client.
Global Const $ERROR_TS_INCOMPATIBLE_SESSIONS = 7069 ; The target session is incompatible with the current session.
Global Const $FRS_ERR_INVALID_API_SEQUENCE = 8001 ; The file replication service API was called incorrectly.
Global Const $FRS_ERR_STARTING_SERVICE = 8002 ; The file replication service cannot be started.
Global Const $FRS_ERR_STOPPING_SERVICE = 8003 ; The file replication service cannot be stopped.
Global Const $FRS_ERR_INTERNAL_API = 8004 ; The file replication service API terminated the request. The event log may have more information.
Global Const $FRS_ERR_INTERNAL = 8005 ; The file replication service terminated the request. The event log may have more information.
Global Const $FRS_ERR_SERVICE_COMM = 8006 ; The file replication service cannot be contacted. The event log may have more information.
Global Const $FRS_ERR_INSUFFICIENT_PRIV = 8007 ; The file replication service cannot satisfy the request because the user has insufficient privileges. The event log may have more information.
Global Const $FRS_ERR_AUTHENTICATION = 8008 ; The file replication service cannot satisfy the request because authenticated RPC is not available. The event log may have more information.
Global Const $FRS_ERR_PARENT_INSUFFICIENT_PRIV = 8009 ; The file replication service cannot satisfy the request because the user has insufficient privileges on the domain controller. The event log may have more information.
Global Const $FRS_ERR_PARENT_AUTHENTICATION = 8010 ; The file replication service cannot satisfy the request because authenticated RPC is not available on the domain controller. The event log may have more information.
Global Const $FRS_ERR_CHILD_TO_PARENT_COMM = 8011 ; The file replication service cannot communicate with the file replication service on the domain controller. The event log may have more information.
Global Const $FRS_ERR_PARENT_TO_CHILD_COMM = 8012 ; The file replication service on the domain controller cannot communicate with the file replication service on this computer. The event log may have more information.
Global Const $FRS_ERR_SYSVOL_POPULATE = 8013 ; The file replication service cannot populate the system volume because of an internal error. The event log may have more information.
Global Const $FRS_ERR_SYSVOL_POPULATE_TIMEOUT = 8014 ; The file replication service cannot populate the system volume because of an internal timeout. The event log may have more information.
Global Const $FRS_ERR_SYSVOL_IS_BUSY = 8015 ; The file replication service cannot process the request. The system volume is busy with a previous request.
Global Const $FRS_ERR_SYSVOL_DEMOTE = 8016 ; The file replication service cannot stop replicating the system volume because of an internal error. The event log may have more information.
Global Const $FRS_ERR_INVALID_SERVICE_PARAMETER = 8017 ; The file replication service detected an invalid parameter.
Global Const $ERROR_DS_NOT_INSTALLED = 8200 ; An error occurred while installing the directory service. For more information, see the event log.
Global Const $ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY = 8201 ; The directory service evaluated group memberships locally.
Global Const $ERROR_DS_NO_ATTRIBUTE_OR_VALUE = 8202 ; The specified directory service attribute or value does not exist.
Global Const $ERROR_DS_INVALID_ATTRIBUTE_SYNTAX = 8203 ; The attribute syntax specified to the directory service is invalid.
Global Const $ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED = 8204 ; The attribute type specified to the directory service is not defined.
Global Const $ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS = 8205 ; The specified directory service attribute or value already exists.
Global Const $ERROR_DS_BUSY = 8206 ; The directory service is busy.
Global Const $ERROR_DS_UNAVAILABLE = 8207 ; The directory service is unavailable.
Global Const $ERROR_DS_NO_RIDS_ALLOCATED = 8208 ; The directory service was unable to allocate a relative identifier.
Global Const $ERROR_DS_NO_MORE_RIDS = 8209 ; The directory service has exhausted the pool of relative identifiers.
Global Const $ERROR_DS_INCORRECT_ROLE_OWNER = 8210 ; The requested operation could not be performed because the directory service is not the master for that type of operation.
Global Const $ERROR_DS_RIDMGR_INIT_ERROR = 8211 ; The directory service was unable to initialize the subsystem that allocates relative identifiers.
Global Const $ERROR_DS_OBJ_CLASS_VIOLATION = 8212 ; The requested operation did not satisfy one or more constraints associated with the class of the object.
Global Const $ERROR_DS_CANT_ON_NON_LEAF = 8213 ; The directory service can perform the requested operation only on a leaf object.
Global Const $ERROR_DS_CANT_ON_RDN = 8214 ; The directory service cannot perform the requested operation on the RDN attribute of an object.
Global Const $ERROR_DS_CANT_MOD_OBJ_CLASS = 8215 ; The directory service detected an attempt to modify the object class of an object.
Global Const $ERROR_DS_CROSS_DOM_MOVE_ERROR = 8216 ; The requested cross-domain move operation could not be performed.
Global Const $ERROR_DS_GC_NOT_AVAILABLE = 8217 ; Unable to contact the global catalog server.
Global Const $ERROR_SHARED_POLICY = 8218 ; The policy object is shared and can only be modified at the root.
Global Const $ERROR_POLICY_OBJECT_NOT_FOUND = 8219 ; The policy object does not exist.
Global Const $ERROR_POLICY_ONLY_IN_DS = 8220 ; The requested policy information is only in the directory service.
Global Const $ERROR_PROMOTION_ACTIVE = 8221 ; A domain controller promotion is currently active.
Global Const $ERROR_NO_PROMOTION_ACTIVE = 8222 ; A domain controller promotion is not currently active.
Global Const $ERROR_DS_OPERATIONS_ERROR = 8224 ; An operations error occurred.
Global Const $ERROR_DS_PROTOCOL_ERROR = 8225 ; A protocol error occurred.
Global Const $ERROR_DS_TIMELIMIT_EXCEEDED = 8226 ; The time limit for this request was exceeded.
Global Const $ERROR_DS_SIZELIMIT_EXCEEDED = 8227 ; The size limit for this request was exceeded.
Global Const $ERROR_DS_ADMIN_LIMIT_EXCEEDED = 8228 ; The administrative limit for this request was exceeded.
Global Const $ERROR_DS_COMPARE_FALSE = 8229 ; The compare response was false.
Global Const $ERROR_DS_COMPARE_TRUE = 8230 ; The compare response was true.
Global Const $ERROR_DS_AUTH_METHOD_NOT_SUPPORTED = 8231 ; The requested authentication method is not supported by the server.
Global Const $ERROR_DS_STRONG_AUTH_REQUIRED = 8232 ; A more secure authentication method is required for this server.
Global Const $ERROR_DS_INAPPROPRIATE_AUTH = 8233 ; Inappropriate authentication.
Global Const $ERROR_DS_AUTH_UNKNOWN = 8234 ; The authentication mechanism is unknown.
Global Const $ERROR_DS_REFERRAL = 8235 ; A referral was returned from the server.
Global Const $ERROR_DS_UNAVAILABLE_CRIT_EXTENSION = 8236 ; The server does not support the requested critical extension.
Global Const $ERROR_DS_CONFIDENTIALITY_REQUIRED = 8237 ; This request requires a secure connection.
Global Const $ERROR_DS_INAPPROPRIATE_MATCHING = 8238 ; Inappropriate matching.
Global Const $ERROR_DS_CONSTRAINT_VIOLATION = 8239 ; A constraint violation occurred.
Global Const $ERROR_DS_NO_SUCH_OBJECT = 8240 ; There is no such object on the server.
Global Const $ERROR_DS_ALIAS_PROBLEM = 8241 ; There is an alias problem.
Global Const $ERROR_DS_INVALID_DN_SYNTAX = 8242 ; An invalid dn syntax has been specified.
Global Const $ERROR_DS_IS_LEAF = 8243 ; The object is a leaf object.
Global Const $ERROR_DS_ALIAS_DEREF_PROBLEM = 8244 ; There is an alias dereferencing problem.
Global Const $ERROR_DS_UNWILLING_TO_PERFORM = 8245 ; The server is unwilling to process the request.
Global Const $ERROR_DS_LOOP_DETECT = 8246 ; A loop has been detected.
Global Const $ERROR_DS_NAMING_VIOLATION = 8247 ; There is a naming violation.
Global Const $ERROR_DS_OBJECT_RESULTS_TOO_LARGE = 8248 ; The result set is too large.
Global Const $ERROR_DS_AFFECTS_MULTIPLE_DSAS = 8249 ; The operation affects multiple DSAs.
Global Const $ERROR_DS_SERVER_DOWN = 8250 ; The server is not operational.
Global Const $ERROR_DS_LOCAL_ERROR = 8251 ; A local error has occurred.
Global Const $ERROR_DS_ENCODING_ERROR = 8252 ; An encoding error has occurred.
Global Const $ERROR_DS_DECODING_ERROR = 8253 ; A decoding error has occurred.
Global Const $ERROR_DS_FILTER_UNKNOWN = 8254 ; The search filter cannot be recognized.
Global Const $ERROR_DS_PARAM_ERROR = 8255 ; One or more parameters are illegal.
Global Const $ERROR_DS_NOT_SUPPORTED = 8256 ; The specified method is not supported.
Global Const $ERROR_DS_NO_RESULTS_RETURNED = 8257 ; No results were returned.
Global Const $ERROR_DS_CONTROL_NOT_FOUND = 8258 ; The specified control is not supported by the server.
Global Const $ERROR_DS_CLIENT_LOOP = 8259 ; A referral loop was detected by the client.
Global Const $ERROR_DS_REFERRAL_LIMIT_EXCEEDED = 8260 ; The preset referral limit was exceeded.
Global Const $ERROR_DS_SORT_CONTROL_MISSING = 8261 ; The search requires a SORT control.
Global Const $ERROR_DS_OFFSET_RANGE_ERROR = 8262 ; The search results exceed the offset range specified.
Global Const $ERROR_DS_ROOT_MUST_BE_NC = 8301 ; The root object must be the head of a naming context. The root object cannot have an instantiated parent.
Global Const $ERROR_DS_ADD_REPLICA_INHIBITED = 8302 ; The add replica operation cannot be performed. The naming context must be writeable in order to create the replica.
Global Const $ERROR_DS_ATT_NOT_DEF_IN_SCHEMA = 8303 ; A reference to an attribute that is not defined in the schema occurred.
Global Const $ERROR_DS_MAX_OBJ_SIZE_EXCEEDED = 8304 ; The maximum size of an object has been exceeded.
Global Const $ERROR_DS_OBJ_STRING_NAME_EXISTS = 8305 ; An attempt was made to add an object to the directory with a name that is already in use.
Global Const $ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA = 8306 ; An attempt was made to add an object of a class that does not have an RDN defined in the schema.
Global Const $ERROR_DS_RDN_DOESNT_MATCH_SCHEMA = 8307 ; An attempt was made to add an object using an RDN that is not the RDN defined in the schema.
Global Const $ERROR_DS_NO_REQUESTED_ATTS_FOUND = 8308 ; None of the requested attributes were found on the objects.
Global Const $ERROR_DS_USER_BUFFER_TO_SMALL = 8309 ; The user buffer is too small.
Global Const $ERROR_DS_ATT_IS_NOT_ON_OBJ = 8310 ; The attribute specified in the operation is not present on the object.
Global Const $ERROR_DS_ILLEGAL_MOD_OPERATION = 8311 ; Illegal modify operation. Some aspect of the modification is not permitted.
Global Const $ERROR_DS_OBJ_TOO_LARGE = 8312 ; The specified object is too large.
Global Const $ERROR_DS_BAD_INSTANCE_TYPE = 8313 ; The specified instance type is not valid.
Global Const $ERROR_DS_MASTERDSA_REQUIRED = 8314 ; The operation must be performed at a master DSA.
Global Const $ERROR_DS_OBJECT_CLASS_REQUIRED = 8315 ; The object class attribute must be specified.
Global Const $ERROR_DS_MISSING_REQUIRED_ATT = 8316 ; A required attribute is missing.
Global Const $ERROR_DS_ATT_NOT_DEF_FOR_CLASS = 8317 ; An attempt was made to modify an object to include an attribute that is not legal for its class.
Global Const $ERROR_DS_ATT_ALREADY_EXISTS = 8318 ; The specified attribute is already present on the object.
Global Const $ERROR_DS_CANT_ADD_ATT_VALUES = 8320 ; The specified attribute is not present, or has no values.
Global Const $ERROR_DS_SINGLE_VALUE_CONSTRAINT = 8321 ; Multiple values were specified for an attribute that can have only one value.
Global Const $ERROR_DS_RANGE_CONSTRAINT = 8322 ; A value for the attribute was not in the acceptable range of values.
Global Const $ERROR_DS_ATT_VAL_ALREADY_EXISTS = 8323 ; The specified value already exists.
Global Const $ERROR_DS_CANT_REM_MISSING_ATT = 8324 ; The attribute cannot be removed because it is not present on the object.
Global Const $ERROR_DS_CANT_REM_MISSING_ATT_VAL = 8325 ; The attribute value cannot be removed because it is not present on the object.
Global Const $ERROR_DS_ROOT_CANT_BE_SUBREF = 8326 ; The specified root object cannot be a subreference.
Global Const $ERROR_DS_NO_CHAINING = 8327 ; Chaining is not permitted.
Global Const $ERROR_DS_NO_CHAINED_EVAL = 8328 ; Chained evaluation is not permitted.
Global Const $ERROR_DS_NO_PARENT_OBJECT = 8329 ; The operation could not be performed because the object's parent is either uninstantiated or deleted.
Global Const $ERROR_DS_PARENT_IS_AN_ALIAS = 8330 ; Having a parent that is an alias is not permitted. Aliases are leaf objects.
Global Const $ERROR_DS_CANT_MIX_MASTER_AND_REPS = 8331 ; The object and parent must be of the same type, either both masters or both replicas.
Global Const $ERROR_DS_CHILDREN_EXIST = 8332 ; The operation cannot be performed because child objects exist. This operation can only be performed on a leaf object.
Global Const $ERROR_DS_OBJ_NOT_FOUND = 8333 ; Directory object not found.
Global Const $ERROR_DS_ALIASED_OBJ_MISSING = 8334 ; The aliased object is missing.
Global Const $ERROR_DS_BAD_NAME_SYNTAX = 8335 ; The object name has bad syntax.
Global Const $ERROR_DS_ALIAS_POINTS_TO_ALIAS = 8336 ; It is not permitted for an alias to refer to another alias.
Global Const $ERROR_DS_CANT_DEREF_ALIAS = 8337 ; The alias cannot be dereferenced.
Global Const $ERROR_DS_OUT_OF_SCOPE = 8338 ; The operation is out of scope.
Global Const $ERROR_DS_OBJECT_BEING_REMOVED = 8339 ; The operation cannot continue because the object is in the process of being removed.
Global Const $ERROR_DS_CANT_DELETE_DSA_OBJ = 8340 ; The DSA object cannot be deleted.
Global Const $ERROR_DS_GENERIC_ERROR = 8341 ; A directory service error has occurred.
Global Const $ERROR_DS_DSA_MUST_BE_INT_MASTER = 8342 ; The operation can only be performed on an internal master DSA object.
Global Const $ERROR_DS_CLASS_NOT_DSA = 8343 ; The object must be of class DSA.
Global Const $ERROR_DS_INSUFF_ACCESS_RIGHTS = 8344 ; Insufficient access rights to perform the operation.
Global Const $ERROR_DS_ILLEGAL_SUPERIOR = 8345 ; The object cannot be added because the parent is not on the list of possible superiors.
Global Const $ERROR_DS_ATTRIBUTE_OWNED_BY_SAM = 8346 ; Access to the attribute is not permitted because the attribute is owned by the Security Accounts Manager (SAM).
Global Const $ERROR_DS_NAME_TOO_MANY_PARTS = 8347 ; The name has too many parts.
Global Const $ERROR_DS_NAME_TOO_LONG = 8348 ; The name is too long.
Global Const $ERROR_DS_NAME_VALUE_TOO_LONG = 8349 ; The name value is too long.
Global Const $ERROR_DS_NAME_UNPARSEABLE = 8350 ; The directory service encountered an error parsing a name.
Global Const $ERROR_DS_NAME_TYPE_UNKNOWN = 8351 ; The directory service cannot get the attribute type for a name.
Global Const $ERROR_DS_NOT_AN_OBJECT = 8352 ; The name does not identify an object; the name identifies a phantom.
Global Const $ERROR_DS_SEC_DESC_TOO_SHORT = 8353 ; The security descriptor is too short.
Global Const $ERROR_DS_SEC_DESC_INVALID = 8354 ; The security descriptor is invalid.
Global Const $ERROR_DS_NO_DELETED_NAME = 8355 ; Failed to create name for deleted object.
Global Const $ERROR_DS_SUBREF_MUST_HAVE_PARENT = 8356 ; The parent of a new subref must exist.
Global Const $ERROR_DS_NCNAME_MUST_BE_NC = 8357 ; The object must be a naming context.
Global Const $ERROR_DS_CANT_ADD_SYSTEM_ONLY = 8358 ; It is not permitted to add an attribute which is owned by the system.
Global Const $ERROR_DS_CLASS_MUST_BE_CONCRETE = 8359 ; The class of the object must be structural; you cannot instantiate an abstract class.
Global Const $ERROR_DS_INVALID_DMD = 8360 ; The schema object could not be found.
Global Const $ERROR_DS_OBJ_GUID_EXISTS = 8361 ; A local object with this GUID (dead or alive) already exists.
Global Const $ERROR_DS_NOT_ON_BACKLINK = 8362 ; The operation cannot be performed on a back link.
Global Const $ERROR_DS_NO_CROSSREF_FOR_NC = 8363 ; The cross reference for the specified naming context could not be found.
Global Const $ERROR_DS_SHUTTING_DOWN = 8364 ; The operation could not be performed because the directory service is shutting down.
Global Const $ERROR_DS_UNKNOWN_OPERATION = 8365 ; The directory service request is invalid.
Global Const $ERROR_DS_INVALID_ROLE_OWNER = 8366 ; The role owner attribute could not be read.
Global Const $ERROR_DS_COULDNT_CONTACT_FSMO = 8367 ; The requested FSMO operation failed. The current FSMO holder could not be contacted.
Global Const $ERROR_DS_CROSS_NC_DN_RENAME = 8368 ; Modification of a DN across a naming context is not permitted.
Global Const $ERROR_DS_CANT_MOD_SYSTEM_ONLY = 8369 ; The attribute cannot be modified because it is owned by the system.
Global Const $ERROR_DS_REPLICATOR_ONLY = 8370 ; Only the replicator can perform this function.
Global Const $ERROR_DS_OBJ_CLASS_NOT_DEFINED = 8371 ; The specified class is not defined.
Global Const $ERROR_DS_OBJ_CLASS_NOT_SUBCLASS = 8372 ; The specified class is not a subclass.
Global Const $ERROR_DS_NAME_REFERENCE_INVALID = 8373 ; The name reference is invalid.
Global Const $ERROR_DS_CROSS_REF_EXISTS = 8374 ; A cross reference already exists.
Global Const $ERROR_DS_CANT_DEL_MASTER_CROSSREF = 8375 ; It is not permitted to delete a master cross reference.
Global Const $ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD = 8376 ; Subtree notifications are only supported on NC heads.
Global Const $ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX = 8377 ; Notification filter is too complex.
Global Const $ERROR_DS_DUP_RDN = 8378 ; Schema update failed: duplicate RDN.
Global Const $ERROR_DS_DUP_OID = 8379 ; Schema update failed: duplicate OID.
Global Const $ERROR_DS_DUP_MAPI_ID = 8380 ; Schema update failed: duplicate MAPI identifier.
Global Const $ERROR_DS_DUP_SCHEMA_ID_GUID = 8381 ; Schema update failed: duplicate schema-id GUID.
Global Const $ERROR_DS_DUP_LDAP_DISPLAY_NAME = 8382 ; Schema update failed: duplicate LDAP display name.
Global Const $ERROR_DS_SEMANTIC_ATT_TEST = 8383 ; Schema update failed: range-lower less than range upper.
Global Const $ERROR_DS_SYNTAX_MISMATCH = 8384 ; Schema update failed: syntax mismatch.
Global Const $ERROR_DS_EXISTS_IN_MUST_HAVE = 8385 ; Schema deletion failed: attribute is used in must-contain.
Global Const $ERROR_DS_EXISTS_IN_MAY_HAVE = 8386 ; Schema deletion failed: attribute is used in may-contain.
Global Const $ERROR_DS_NONEXISTENT_MAY_HAVE = 8387 ; Schema update failed: attribute in may-contain does not exist.
Global Const $ERROR_DS_NONEXISTENT_MUST_HAVE = 8388 ; Schema update failed: attribute in must-contain does not exist.
Global Const $ERROR_DS_AUX_CLS_TEST_FAIL = 8389 ; Schema update failed: class in aux-class list does not exist or is not an auxiliary class.
Global Const $ERROR_DS_NONEXISTENT_POSS_SUP = 8390 ; Schema update failed: class in poss-superiors does not exist.
Global Const $ERROR_DS_SUB_CLS_TEST_FAIL = 8391 ; Schema update failed: class in subclassof list does not exist or does not satisfy hierarchy rules.
Global Const $ERROR_DS_BAD_RDN_ATT_ID_SYNTAX = 8392 ; Schema update failed: Rdn-Att-Id has wrong syntax.
Global Const $ERROR_DS_EXISTS_IN_AUX_CLS = 8393 ; Schema deletion failed: class is used as auxiliary class.
Global Const $ERROR_DS_EXISTS_IN_SUB_CLS = 8394 ; Schema deletion failed: class is used as sub class.
Global Const $ERROR_DS_EXISTS_IN_POSS_SUP = 8395 ; Schema deletion failed: class is used as poss superior.
Global Const $ERROR_DS_RECALCSCHEMA_FAILED = 8396 ; Schema update failed in recalculating validation cache.
Global Const $ERROR_DS_TREE_DELETE_NOT_FINISHED = 8397 ; The tree deletion is not finished. The request must be made again to continue deleting the tree.
Global Const $ERROR_DS_CANT_DELETE = 8398 ; The requested delete operation could not be performed.
Global Const $ERROR_DS_ATT_SCHEMA_REQ_ID = 8399 ; Cannot read the governs class identifier for the schema record.
Global Const $ERROR_DS_BAD_ATT_SCHEMA_SYNTAX = 8400 ; The attribute schema has bad syntax.
Global Const $ERROR_DS_CANT_CACHE_ATT = 8401 ; The attribute could not be cached.
Global Const $ERROR_DS_CANT_CACHE_CLASS = 8402 ; The class could not be cached.
Global Const $ERROR_DS_CANT_REMOVE_ATT_CACHE = 8403 ; The attribute could not be removed from the cache.
Global Const $ERROR_DS_CANT_REMOVE_CLASS_CACHE = 8404 ; The class could not be removed from the cache.
Global Const $ERROR_DS_CANT_RETRIEVE_DN = 8405 ; The distinguished name attribute could not be read.
Global Const $ERROR_DS_MISSING_SUPREF = 8406 ; No superior reference has been configured for the directory service. The directory service is therefore unable to issue referrals to objects outside this forest.
Global Const $ERROR_DS_CANT_RETRIEVE_INSTANCE = 8407 ; The instance type attribute could not be retrieved.
Global Const $ERROR_DS_CODE_INCONSISTENCY = 8408 ; An internal error has occurred.
Global Const $ERROR_DS_DATABASE_ERROR = 8409 ; A database error has occurred.
Global Const $ERROR_DS_GOVERNSID_MISSING = 8410 ; The attribute GOVERNSID is missing.
Global Const $ERROR_DS_MISSING_EXPECTED_ATT = 8411 ; An expected attribute is missing.
Global Const $ERROR_DS_NCNAME_MISSING_CR_REF = 8412 ; The specified naming context is missing a cross reference.
Global Const $ERROR_DS_SECURITY_CHECKING_ERROR = 8413 ; A security checking error has occurred.
Global Const $ERROR_DS_SCHEMA_NOT_LOADED = 8414 ; The schema is not loaded.
Global Const $ERROR_DS_SCHEMA_ALLOC_FAILED = 8415 ; Schema allocation failed. Please check if the machine is running low on memory.
Global Const $ERROR_DS_ATT_SCHEMA_REQ_SYNTAX = 8416 ; Failed to obtain the required syntax for the attribute schema.
Global Const $ERROR_DS_GCVERIFY_ERROR = 8417 ; The global catalog verification failed. The global catalog is not available or does not support the operation. Some part of the directory is currently not available.
Global Const $ERROR_DS_DRA_SCHEMA_MISMATCH = 8418 ; The replication operation failed because of a schema mismatch between the servers involved.
Global Const $ERROR_DS_CANT_FIND_DSA_OBJ = 8419 ; The DSA object could not be found.
Global Const $ERROR_DS_CANT_FIND_EXPECTED_NC = 8420 ; The naming context could not be found.
Global Const $ERROR_DS_CANT_FIND_NC_IN_CACHE = 8421 ; The naming context could not be found in the cache.
Global Const $ERROR_DS_CANT_RETRIEVE_CHILD = 8422 ; The child object could not be retrieved.
Global Const $ERROR_DS_SECURITY_ILLEGAL_MODIFY = 8423 ; The modification was not permitted for security reasons.
Global Const $ERROR_DS_CANT_REPLACE_HIDDEN_REC = 8424 ; The operation cannot replace the hidden record.
Global Const $ERROR_DS_BAD_HIERARCHY_FILE = 8425 ; The hierarchy file is invalid.
Global Const $ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED = 8426 ; The attempt to build the hierarchy table failed.
Global Const $ERROR_DS_CONFIG_PARAM_MISSING = 8427 ; The directory configuration parameter is missing from the registry.
Global Const $ERROR_DS_COUNTING_AB_INDICES_FAILED = 8428 ; The attempt to count the address book indices failed.
Global Const $ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED = 8429 ; The allocation of the hierarchy table failed.
Global Const $ERROR_DS_INTERNAL_FAILURE = 8430 ; The directory service encountered an internal failure.
Global Const $ERROR_DS_UNKNOWN_ERROR = 8431 ; The directory service encountered an unknown failure.
Global Const $ERROR_DS_ROOT_REQUIRES_CLASS_TOP = 8432 ; A root object requires a class of 'top'.
Global Const $ERROR_DS_REFUSING_FSMO_ROLES = 8433 ; This directory server is shutting down, and cannot take ownership of new floating single-master operation roles.
Global Const $ERROR_DS_MISSING_FSMO_SETTINGS = 8434 ; The directory service is missing mandatory configuration information, and is unable to determine the ownership of floating single-master operation roles.
Global Const $ERROR_DS_UNABLE_TO_SURRENDER_ROLES = 8435 ; The directory service was unable to transfer ownership of one or more floating single-master operation roles to other servers.
Global Const $ERROR_DS_DRA_GENERIC = 8436 ; The replication operation failed.
Global Const $ERROR_DS_DRA_INVALID_PARAMETER = 8437 ; An invalid parameter was specified for this replication operation.
Global Const $ERROR_DS_DRA_BUSY = 8438 ; The directory service is too busy to complete the replication operation at this time.
Global Const $ERROR_DS_DRA_BAD_DN = 8439 ; The distinguished name specified for this replication operation is invalid.
Global Const $ERROR_DS_DRA_BAD_NC = 8440 ; The naming context specified for this replication operation is invalid.
Global Const $ERROR_DS_DRA_DN_EXISTS = 8441 ; The distinguished name specified for this replication operation already exists.
Global Const $ERROR_DS_DRA_INTERNAL_ERROR = 8442 ; The replication system encountered an internal error.
Global Const $ERROR_DS_DRA_INCONSISTENT_DIT = 8443 ; The replication operation encountered a database inconsistency.
Global Const $ERROR_DS_DRA_CONNECTION_FAILED = 8444 ; The server specified for this replication operation could not be contacted.
Global Const $ERROR_DS_DRA_BAD_INSTANCE_TYPE = 8445 ; The replication operation encountered an object with an invalid instance type.
Global Const $ERROR_DS_DRA_OUT_OF_MEM = 8446 ; The replication operation failed to allocate memory.
Global Const $ERROR_DS_DRA_MAIL_PROBLEM = 8447 ; The replication operation encountered an error with the mail system.
Global Const $ERROR_DS_DRA_REF_ALREADY_EXISTS = 8448 ; The replication reference information for the target server already exists.
Global Const $ERROR_DS_DRA_REF_NOT_FOUND = 8449 ; The replication reference information for the target server does not exist.
Global Const $ERROR_DS_DRA_OBJ_IS_REP_SOURCE = 8450 ; The naming context cannot be removed because it is replicated to another server.
Global Const $ERROR_DS_DRA_DB_ERROR = 8451 ; The replication operation encountered a database error.
Global Const $ERROR_DS_DRA_NO_REPLICA = 8452 ; The naming context is in the process of being removed or is not replicated from the specified server.
Global Const $ERROR_DS_DRA_ACCESS_DENIED = 8453 ; Replication access was denied.
Global Const $ERROR_DS_DRA_NOT_SUPPORTED = 8454 ; The requested operation is not supported by this version of the directory service.
Global Const $ERROR_DS_DRA_RPC_CANCELLED = 8455 ; The replication remote procedure call was canceled.
Global Const $ERROR_DS_DRA_SOURCE_DISABLED = 8456 ; The source server is currently rejecting replication requests.
Global Const $ERROR_DS_DRA_SINK_DISABLED = 8457 ; The destination server is currently rejecting replication requests.
Global Const $ERROR_DS_DRA_NAME_COLLISION = 8458 ; The replication operation failed due to a collision of object names.
Global Const $ERROR_DS_DRA_SOURCE_REINSTALLED = 8459 ; The replication source has been reinstalled.
Global Const $ERROR_DS_DRA_MISSING_PARENT = 8460 ; The replication operation failed because a required parent object is missing.
Global Const $ERROR_DS_DRA_PREEMPTED = 8461 ; The replication operation was preempted.
Global Const $ERROR_DS_DRA_ABANDON_SYNC = 8462 ; The replication synchronization attempt was abandoned because of a lack of updates.
Global Const $ERROR_DS_DRA_SHUTDOWN = 8463 ; The replication operation was terminated because the system is shutting down.
Global Const $ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET = 8464 ; Synchronization attempt failed because the destination DC is currently waiting to synchronize new partial attributes from source. This condition is normal if a recent schema change modified the partial attribute set. The destination partial attribute set is not a subset of source partial attribute set.
Global Const $ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA = 8465 ; The replication synchronization attempt failed because a master replica attempted to sync from a partial replica.
Global Const $ERROR_DS_DRA_EXTN_CONNECTION_FAILED = 8466 ; The server specified for this replication operation was contacted, but that server was unable to contact an additional server needed to complete the operation.
Global Const $ERROR_DS_INSTALL_SCHEMA_MISMATCH = 8467 ; The version of the directory service schema of the source forest is not compatible with the version of the directory service on this computer.
Global Const $ERROR_DS_DUP_LINK_ID = 8468 ; Schema update failed: An attribute with the same link identifier already exists.
Global Const $ERROR_DS_NAME_ERROR_RESOLVING = 8469 ; Name translation: Generic processing error.
Global Const $ERROR_DS_NAME_ERROR_NOT_FOUND = 8470 ; Name translation: Could not find the name or insufficient right to see name.
Global Const $ERROR_DS_NAME_ERROR_NOT_UNIQUE = 8471 ; Name translation: Input name mapped to more than one output name.
Global Const $ERROR_DS_NAME_ERROR_NO_MAPPING = 8472 ; Name translation: Input name found, but not the associated output format.
Global Const $ERROR_DS_NAME_ERROR_DOMAIN_ONLY = 8473 ; Name translation: Unable to resolve completely, only the domain was found.
Global Const $ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING = 8474 ; Name translation: Unable to perform purely syntactical mapping at the client without going out to the wire.
Global Const $ERROR_DS_CONSTRUCTED_ATT_MOD = 8475 ; Modification of a constructed attribute is not allowed.
Global Const $ERROR_DS_WRONG_OM_OBJ_CLASS = 8476 ; The OM-Object-Class specified is incorrect for an attribute with the specified syntax.
Global Const $ERROR_DS_DRA_REPL_PENDING = 8477 ; The replication request has been posted; waiting for reply.
Global Const $ERROR_DS_DS_REQUIRED = 8478 ; The requested operation requires a directory service, and none was available.
Global Const $ERROR_DS_INVALID_LDAP_DISPLAY_NAME = 8479 ; The LDAP display name of the class or attribute contains non-ASCII characters.
Global Const $ERROR_DS_NON_BASE_SEARCH = 8480 ; The requested search operation is only supported for base searches.
Global Const $ERROR_DS_CANT_RETRIEVE_ATTS = 8481 ; The search failed to retrieve attributes from the database.
Global Const $ERROR_DS_BACKLINK_WITHOUT_LINK = 8482 ; The schema update operation tried to add a backward link attribute that has no corresponding forward link.
Global Const $ERROR_DS_EPOCH_MISMATCH = 8483 ; Source and destination of a cross-domain move do not agree on the object's epoch number. Either source or destination does not have the latest version of the object.
Global Const $ERROR_DS_SRC_NAME_MISMATCH = 8484 ; Source and destination of a cross-domain move do not agree on the object's current name. Either source or destination does not have the latest version of the object.
Global Const $ERROR_DS_SRC_AND_DST_NC_IDENTICAL = 8485 ; Source and destination for the cross-domain move operation are identical. Caller should use local move operation instead of cross-domain move operation.
Global Const $ERROR_DS_DST_NC_MISMATCH = 8486 ; Source and destination for a cross-domain move are not in agreement on the naming contexts in the forest. Either source or destination does not have the latest version of the Partitions container.
Global Const $ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC = 8487 ; Destination of a cross-domain move is not authoritative for the destination naming context.
Global Const $ERROR_DS_SRC_GUID_MISMATCH = 8488 ; Source and destination of a cross-domain move do not agree on the identity of the source object. Either source or destination does not have the latest version of the source object.
Global Const $ERROR_DS_CANT_MOVE_DELETED_OBJECT = 8489 ; Object being moved across-domains is already known to be deleted by the destination server. The source server does not have the latest version of the source object.
Global Const $ERROR_DS_PDC_OPERATION_IN_PROGRESS = 8490 ; Another operation which requires exclusive access to the PDC FSMO is already in progress.
Global Const $ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD = 8491 ; A cross-domain move operation failed such that two versions of the moved object exist - one each in the source and destination domains. The destination object needs to be removed to restore the system to a consistent state.
Global Const $ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION = 8492 ; This object may not be moved across domain boundaries either because cross-domain moves for this class are disallowed, or the object has some special characteristics, e.g.: trust account or restricted RID, which prevent its move.
Global Const $ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS = 8493 ; Can't move objects with memberships across domain boundaries as once moved, this would violate the membership conditions of the account group. Remove the object from any account group memberships and retry.
Global Const $ERROR_DS_NC_MUST_HAVE_NC_PARENT = 8494 ; A naming context head must be the immediate child of another naming context head, not of an interior node.
Global Const $ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE = 8495 ; The directory cannot validate the propsed naming context name because it does not hold a replica of the naming context above the proposed naming context. Please ensure that the domain naming master role is held by a server that is configured as a global catalog server, and that the server is up to date with its replication partners. (Applies only to Windows Domain Naming masters)
Global Const $ERROR_DS_DST_DOMAIN_NOT_NATIVE = 8496 ; Destination domain must be in native mode.
Global Const $ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER = 8497 ; The operation cannot be performed because the server does not have an infrastructure container in the domain of interest.
Global Const $ERROR_DS_CANT_MOVE_ACCOUNT_GROUP = 8498 ; Cross-domain move of non-empty account groups is not allowed.
Global Const $ERROR_DS_CANT_MOVE_RESOURCE_GROUP = 8499 ; Cross-domain move of non-empty resource groups is not allowed.
Global Const $ERROR_DS_INVALID_SEARCH_FLAG = 8500 ; The search flags for the attribute are invalid. The ANR bit is valid only on attributes of Unicode or Teletex strings.
Global Const $ERROR_DS_NO_TREE_DELETE_ABOVE_NC = 8501 ; Tree deletions starting at an object which has an NC head as a descendant are not allowed.
Global Const $ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE = 8502 ; The directory service failed to lock a tree in preparation for a tree deletion because the tree was in use.
Global Const $ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE = 8503 ; The directory service failed to identify the list of objects to delete while attempting a tree deletion.
Global Const $ERROR_DS_SAM_INIT_FAILURE = 8504 ; Security Accounts Manager initialization failed because of the following error: %1. Error Status: 0x%2. Please shut down this system and reboot into Directory Services Restore Mode. Check the event log for more detailed information.
Global Const $ERROR_DS_SENSITIVE_GROUP_VIOLATION = 8505 ; Only an administrator can modify the membership list of an administrative group.
Global Const $ERROR_DS_CANT_MOD_PRIMARYGROUPID = 8506 ; Cannot change the primary group ID of a domain controller account.
Global Const $ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD = 8507 ; An attempt is made to modify the base schema.
Global Const $ERROR_DS_NONSAFE_SCHEMA_CHANGE = 8508 ; Adding a new mandatory attribute to an existing class, deleting a mandatory attribute from an existing class, or adding an optional attribute to the special class Top that is not a backlink attribute (directly or through inheritance, for example, by adding or deleting an auxiliary class) is not allowed.
Global Const $ERROR_DS_SCHEMA_UPDATE_DISALLOWED = 8509 ; Schema update is not allowed on this DC because the DC is not the schema FSMO Role Owner.
Global Const $ERROR_DS_CANT_CREATE_UNDER_SCHEMA = 8510 ; An object of this class cannot be created under the schema container. You can only create attribute-schema and class-schema objects under the schema container.
Global Const $ERROR_DS_INSTALL_NO_SRC_SCH_VERSION = 8511 ; The replica/child install failed to get the objectVersion attribute on the schema container on the source DC. Either the attribute is missing on the schema container or the credentials supplied do not have permission to read it.
Global Const $ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE = 8512 ; The replica/child install failed to read the objectVersion attribute in the SCHEMA section of the file schema.ini in the system32 directory.
Global Const $ERROR_DS_INVALID_GROUP_TYPE = 8513 ; The specified group type is invalid.
Global Const $ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 8514 ; You cannot nest global groups in a mixed domain if the group is security-enabled.
Global Const $ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 8515 ; You cannot nest local groups in a mixed domain if the group is security-enabled.
Global Const $ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 8516 ; A global group cannot have a local group as a member.
Global Const $ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 8517 ; A global group cannot have a universal group as a member.
Global Const $ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 8518 ; A universal group cannot have a local group as a member.
Global Const $ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 8519 ; A global group cannot have a cross-domain member.
Global Const $ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 8520 ; A local group cannot have another cross domain local group as a member.
Global Const $ERROR_DS_HAVE_PRIMARY_MEMBERS = 8521 ; A group with primary members cannot change to a security-disabled group.
Global Const $ERROR_DS_STRING_SD_CONVERSION_FAILED = 8522 ; The schema cache load failed to convert the string default SD on a class-schema object.
Global Const $ERROR_DS_NAMING_MASTER_GC = 8523 ; Only DSAs configured to be Global Catalog servers should be allowed to hold the Domain Naming Master FSMO role. (Applies only to Windows servers)
Global Const $ERROR_DS_DNS_LOOKUP_FAILURE = 8524 ; The DSA operation is unable to proceed because of a DNS lookup failure.
Global Const $ERROR_DS_COULDNT_UPDATE_SPNS = 8525 ; While processing a change to the DNS Host Name for an object, the Service Principal Name values could not be kept in sync.
Global Const $ERROR_DS_CANT_RETRIEVE_SD = 8526 ; The Security Descriptor attribute could not be read.
Global Const $ERROR_DS_KEY_NOT_UNIQUE = 8527 ; The object requested was not found, but an object with that key was found.
Global Const $ERROR_DS_WRONG_LINKED_ATT_SYNTAX = 8528 ; The syntax of the linked attribute being added is incorrect. Forward links can only have syntax 2.5.5.1, 2.5.5.7, and 2.5.5.14, and backlinks can only have syntax 2.5.5.1
Global Const $ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD = 8529 ; Security Account Manager needs to get the boot password.
Global Const $ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY = 8530 ; Security Account Manager needs to get the boot key from floppy disk.
Global Const $ERROR_DS_CANT_START = 8531 ; Directory Service cannot start.
Global Const $ERROR_DS_INIT_FAILURE = 8532 ; Directory Services could not start.
Global Const $ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION = 8533 ; The connection between client and server requires packet privacy or better.
Global Const $ERROR_DS_SOURCE_DOMAIN_IN_FOREST = 8534 ; The source domain may not be in the same forest as destination.
Global Const $ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST = 8535 ; The destination domain must be in the forest.
Global Const $ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED = 8536 ; The operation requires that destination domain auditing be enabled.
Global Const $ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN = 8537 ; The operation couldn't locate a DC for the source domain.
Global Const $ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER = 8538 ; The source object must be a group or user.
Global Const $ERROR_DS_SRC_SID_EXISTS_IN_FOREST = 8539 ; The source object's SID already exists in destination forest.
Global Const $ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH = 8540 ; The source and destination object must be of the same type.
Global Const $ERROR_SAM_INIT_FAILURE = 8541 ; Security Accounts Manager initialization failed because of the following error: %1. Error Status: 0x%2. Click OK to shut down the system and reboot into Safe Mode. Check the event log for detailed information.
Global Const $ERROR_DS_DRA_SCHEMA_INFO_SHIP = 8542 ; Schema information could not be included in the replication request.
Global Const $ERROR_DS_DRA_SCHEMA_CONFLICT = 8543 ; The replication operation could not be completed due to a schema incompatibility.
Global Const $ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT = 8544 ; The replication operation could not be completed due to a previous schema incompatibility.
Global Const $ERROR_DS_DRA_OBJ_NC_MISMATCH = 8545 ; The replication update could not be applied because either the source or the destination has not yet received information regarding a recent cross-domain move operation.
Global Const $ERROR_DS_NC_STILL_HAS_DSAS = 8546 ; The requested domain could not be deleted because there exist domain controllers that still host this domain.
Global Const $ERROR_DS_GC_REQUIRED = 8547 ; The requested operation can be performed only on a global catalog server.
Global Const $ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 8548 ; A local group can only be a member of other local groups in the same domain.
Global Const $ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS = 8549 ; Foreign security principals cannot be members of universal groups.
Global Const $ERROR_DS_CANT_ADD_TO_GC = 8550 ; The attribute is not allowed to be replicated to the GC because of security reasons.
Global Const $ERROR_DS_NO_CHECKPOINT_WITH_PDC = 8551 ; The checkpoint with the PDC could not be taken because there too many modifications being processed currently.
Global Const $ERROR_DS_SOURCE_AUDITING_NOT_ENABLED = 8552 ; The operation requires that source domain auditing be enabled.
Global Const $ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC = 8553 ; Security principal objects can only be created inside domain naming contexts.
Global Const $ERROR_DS_INVALID_NAME_FOR_SPN = 8554 ; A Service Principal Name (SPN) could not be constructed because the provided hostname is not in the necessary format.
Global Const $ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS = 8555 ; A Filter was passed that uses constructed attributes.
Global Const $ERROR_DS_UNICODEPWD_NOT_IN_QUOTES = 8556 ; The unicodePwd attribute value must be enclosed in double quotes.
Global Const $ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 8557 ; Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased.
Global Const $ERROR_DS_MUST_BE_RUN_ON_DST_DC = 8558 ; For security reasons, the operation must be run on the destination DC.
Global Const $ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER = 8559 ; For security reasons, the source DC must be NT4SP4 or greater.
Global Const $ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ = 8560 ; Critical Directory Service System objects cannot be deleted during tree delete operations. The tree delete may have been partially performed.
Global Const $ERROR_DS_INIT_FAILURE_CONSOLE = 8561 ; Directory Services could not start because of the following error: %1. Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
Global Const $ERROR_DS_SAM_INIT_FAILURE_CONSOLE = 8562 ; Security Accounts Manager initialization failed because of the following error: %1. Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
Global Const $ERROR_DS_FOREST_VERSION_TOO_HIGH = 8563 ; The version of the operating system is incompatible with the current AD DS forest functional level or AD LDS Configuration Set functional level. You must upgrade to a new version of the operating system before this server can become an AD DS Domain Controller or add an AD LDS Instance in this AD DS forest or AD LDS Configuration Set.
Global Const $ERROR_DS_DOMAIN_VERSION_TOO_HIGH = 8564 ; The version of the operating system installed is incompatible with the current domain functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this domain.
Global Const $ERROR_DS_FOREST_VERSION_TOO_LOW = 8565 ; The version of the operating system installed on this server no longer supports the current AD DS Forest functional level or AD LDS Configuration Set functional level. You must raise the AD DS Forest functional level or AD LDS Configuration Set functional level before this server can become an AD DS Domain Controller or an AD LDS Instance in this Forest or Configuration Set.
Global Const $ERROR_DS_DOMAIN_VERSION_TOO_LOW = 8566 ; The version of the operating system installed on this server no longer supports the current domain functional level. You must raise the domain functional level before this server can become a domain controller in this domain.
Global Const $ERROR_DS_INCOMPATIBLE_VERSION = 8567 ; The version of the operating system installed on this server is incompatible with the functional level of the domain or forest.
Global Const $ERROR_DS_LOW_DSA_VERSION = 8568 ; The functional level of the domain (or forest) cannot be raised to the requested value, because there exist one or more domain controllers in the domain (or forest) that are at a lower incompatible functional level.
Global Const $ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN = 8569 ; The forest functional level cannot be raised to the requested value since one or more domains are still in mixed domain mode. All domains in the forest must be in native mode, for you to raise the forest functional level.
Global Const $ERROR_DS_NOT_SUPPORTED_SORT_ORDER = 8570 ; The sort order requested is not supported.
Global Const $ERROR_DS_NAME_NOT_UNIQUE = 8571 ; The requested name already exists as a unique identifier.
Global Const $ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 = 8572 ; The machine account was created pre-NT4. The account needs to be recreated.
Global Const $ERROR_DS_OUT_OF_VERSION_STORE = 8573 ; The database is out of version store.
Global Const $ERROR_DS_INCOMPATIBLE_CONTROLS_USED = 8574 ; Unable to continue operation because multiple conflicting controls were used.
Global Const $ERROR_DS_NO_REF_DOMAIN = 8575 ; Unable to find a valid security descriptor reference domain for this partition.
Global Const $ERROR_DS_RESERVED_LINK_ID = 8576 ; Schema update failed: The link identifier is reserved.
Global Const $ERROR_DS_LINK_ID_NOT_AVAILABLE = 8577 ; Schema update failed: There are no link identifiers available.
Global Const $ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = 8578 ; An account group cannot have a universal group as a member.
Global Const $ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE = 8579 ; Rename or move operations on naming context heads or read-only objects are not allowed.
Global Const $ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC = 8580 ; Move operations on objects in the schema naming context are not allowed.
Global Const $ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG = 8581 ; A system flag has been set on the object and does not allow the object to be moved or renamed.
Global Const $ERROR_DS_MODIFYDN_WRONG_GRANDPARENT = 8582 ; This object is not allowed to change its grandparent container. Moves are not forbidden on this object, but are restricted to sibling containers.
Global Const $ERROR_DS_NAME_ERROR_TRUST_REFERRAL = 8583 ; Unable to resolve completely, a referral to another forest is generated.
Global Const $ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER = 8584 ; The requested action is not supported on standard server.
Global Const $ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD = 8585 ; Could not access a partition of the directory service located on a remote server. Make sure at least one server is running for the partition in question.
Global Const $ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 = 8586 ; The directory cannot validate the proposed naming context (or partition) name because it does not hold a replica nor can it contact a replica of the naming context above the proposed naming context. Please ensure that the parent naming context is properly registered in DNS, and at least one replica of this naming context is reachable by the Domain Naming master.
Global Const $ERROR_DS_THREAD_LIMIT_EXCEEDED = 8587 ; The thread limit for this request was exceeded.
Global Const $ERROR_DS_NOT_CLOSEST = 8588 ; The Global catalog server is not in the closest site.
Global Const $ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF = 8589 ; The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the corresponding server object in the local DS database has no serverReference attribute.
Global Const $ERROR_DS_SINGLE_USER_MODE_FAILED = 8590 ; The Directory Service failed to enter single user mode.
Global Const $ERROR_DS_NTDSCRIPT_SYNTAX_ERROR = 8591 ; The Directory Service cannot parse the script because of a syntax error.
Global Const $ERROR_DS_NTDSCRIPT_PROCESS_ERROR = 8592 ; The Directory Service cannot process the script because of an error.
Global Const $ERROR_DS_DIFFERENT_REPL_EPOCHS = 8593 ; The directory service cannot perform the requested operation because the servers involved are of different replication epochs (which is usually related to a domain rename that is in progress).
Global Const $ERROR_DS_DRS_EXTENSIONS_CHANGED = 8594 ; The directory service binding must be renegotiated due to a change in the server extensions information.
Global Const $ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR = 8595 ; Operation not allowed on a disabled cross reference.
Global Const $ERROR_DS_NO_MSDS_INTID = 8596 ; Schema update failed: No values for msDS-IntId are available.
Global Const $ERROR_DS_DUP_MSDS_INTID = 8597 ; Schema update failed: Duplicate msDS-INtId. Retry the operation.
Global Const $ERROR_DS_EXISTS_IN_RDNATTID = 8598 ; Schema deletion failed: attribute is used in rDNAttID.
Global Const $ERROR_DS_AUTHORIZATION_FAILED = 8599 ; The directory service failed to authorize the request.
Global Const $ERROR_DS_INVALID_SCRIPT = 8600 ; The Directory Service cannot process the script because it is invalid.
Global Const $ERROR_DS_REMOTE_CROSSREF_OP_FAILED = 8601 ; The remote create cross reference operation failed on the Domain Naming Master FSMO. The operation's error is in the extended data.
Global Const $ERROR_DS_CROSS_REF_BUSY = 8602 ; A cross reference is in use locally with the same name.
Global Const $ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN = 8603 ; The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the server's domain has been deleted from the forest.
Global Const $ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC = 8604 ; Writeable NCs prevent this DC from demoting.
Global Const $ERROR_DS_DUPLICATE_ID_FOUND = 8605 ; The requested object has a non-unique identifier and cannot be retrieved.
Global Const $ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT = 8606 ; Insufficient attributes were given to create an object. This object may not exist because it may have been deleted and already garbage collected.
Global Const $ERROR_DS_GROUP_CONVERSION_ERROR = 8607 ; The group cannot be converted due to attribute restrictions on the requested group type.
Global Const $ERROR_DS_CANT_MOVE_APP_BASIC_GROUP = 8608 ; Cross-domain move of non-empty basic application groups is not allowed.
Global Const $ERROR_DS_CANT_MOVE_APP_QUERY_GROUP = 8609 ; Cross-domain move of non-empty query based application groups is not allowed.
Global Const $ERROR_DS_ROLE_NOT_VERIFIED = 8610 ; The FSMO role ownership could not be verified because its directory partition has not replicated successfully with at least one replication partner.
Global Const $ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL = 8611 ; The target container for a redirection of a well known object container cannot already be a special container.
Global Const $ERROR_DS_DOMAIN_RENAME_IN_PROGRESS = 8612 ; The Directory Service cannot perform the requested operation because a domain rename operation is in progress.
Global Const $ERROR_DS_EXISTING_AD_CHILD_NC = 8613 ; The directory service detected a child partition below the requested new partition name. The partition hierarchy must be created in a top down method.
Global Const $ERROR_DS_REPL_LIFETIME_EXCEEDED = 8614 ; The directory service cannot replicate with this server because the time since the last replication with this server has exceeded the tombstone lifetime.
Global Const $ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER = 8615 ; The requested operation is not allowed on an object under the system container.
Global Const $ERROR_DS_LDAP_SEND_QUEUE_FULL = 8616 ; The LDAP servers network send queue has filled up because the client is not processing the results of it's requests fast enough. No more requests will be processed until the client catches up. If the client does not catch up then it will be disconnected.
Global Const $ERROR_DS_DRA_OUT_SCHEDULE_WINDOW = 8617 ; The scheduled replication did not take place because the system was too busy to execute the request within the schedule window. The replication queue is overloaded. Consider reducing the number of partners or decreasing the scheduled replication frequency.
Global Const $ERROR_DS_POLICY_NOT_KNOWN = 8618 ; At this time, it cannot be determined if the branch replication policy is available on the hub domain controller. Please retry at a later time to account for replication latencies.
Global Const $ERROR_NO_SITE_SETTINGS_OBJECT = 8619 ; The site settings object for the specified site does not exist.
Global Const $ERROR_NO_SECRETS = 8620 ; The local account store does not contain secret material for the specified account.
Global Const $ERROR_NO_WRITABLE_DC_FOUND = 8621 ; Could not find a writable domain controller in the domain.
Global Const $ERROR_DS_NO_SERVER_OBJECT = 8622 ; The server object for the domain controller does not exist.
Global Const $ERROR_DS_NO_NTDSA_OBJECT = 8623 ; The NTDS Settings object for the domain controller does not exist.
Global Const $ERROR_DS_NON_ASQ_SEARCH = 8624 ; The requested search operation is not supported for ASQ searches.
Global Const $ERROR_DS_AUDIT_FAILURE = 8625 ; A required audit event could not be generated for the operation.
Global Const $ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE = 8626 ; The search flags for the attribute are invalid. The subtree index bit is valid only on single valued attributes.
Global Const $ERROR_DS_INVALID_SEARCH_FLAG_TUPLE = 8627 ; The search flags for the attribute are invalid. The tuple index bit is valid only on attributes of Unicode strings.
Global Const $ERROR_DS_HIERARCHY_TABLE_TOO_DEEP = 8628 ; The address books are nested too deeply. Failed to build the hierarchy table.
Global Const $ERROR_DS_DRA_CORRUPT_UTD_VECTOR = 8629 ; The specified up-to-date-ness vector is corrupt.
Global Const $ERROR_DS_DRA_SECRETS_DENIED = 8630 ; The request to replicate secrets is denied.
Global Const $ERROR_DS_RESERVED_MAPI_ID = 8631 ; Schema update failed: The MAPI identifier is reserved.
Global Const $ERROR_DS_MAPI_ID_NOT_AVAILABLE = 8632 ; Schema update failed: There are no MAPI identifiers available.
Global Const $ERROR_DS_DRA_MISSING_KRBTGT_SECRET = 8633 ; The replication operation failed because the required attributes of the local krbtgt object are missing.
Global Const $ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST = 8634 ; The domain name of the trusted domain already exists in the forest.
Global Const $ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST = 8635 ; The flat name of the trusted domain already exists in the forest.
Global Const $ERROR_INVALID_USER_PRINCIPAL_NAME = 8636 ; The User Principal Name (UPN) is invalid.
Global Const $ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS = 8637 ; OID mapped groups cannot have members.
Global Const $ERROR_DS_OID_NOT_FOUND = 8638 ; The specified OID cannot be found.
Global Const $DNS_ERROR_RCODE_FORMAT_ERROR = 9001 ; DNS server unable to interpret format.
Global Const $DNS_ERROR_RCODE_SERVER_FAILURE = 9002 ; DNS server failure.
Global Const $DNS_ERROR_RCODE_NAME_ERROR = 9003 ; DNS name does not exist.
Global Const $DNS_ERROR_RCODE_NOT_IMPLEMENTED = 9004 ; DNS request not supported by name server.
Global Const $DNS_ERROR_RCODE_REFUSED = 9005 ; DNS operation refused.
Global Const $DNS_ERROR_RCODE_YXDOMAIN = 9006 ; DNS name that ought not exist, does exist.
Global Const $DNS_ERROR_RCODE_YXRRSET = 9007 ; DNS RR set that ought not exist, does exist.
Global Const $DNS_ERROR_RCODE_NXRRSET = 9008 ; DNS RR set that ought to exist, does not exist.
Global Const $DNS_ERROR_RCODE_NOTAUTH = 9009 ; DNS server not authoritative for zone.
Global Const $DNS_ERROR_RCODE_NOTZONE = 9010 ; DNS name in update or prereq is not in zone.
Global Const $DNS_ERROR_RCODE_BADSIG = 9016 ; DNS signature failed to verify.
Global Const $DNS_ERROR_RCODE_BADKEY = 9017 ; DNS bad key.
Global Const $DNS_ERROR_RCODE_BADTIME = 9018 ; DNS signature validity expired.
Global Const $DNS_INFO_NO_RECORDS = 9501 ; No records found for given DNS query.
Global Const $DNS_ERROR_BAD_PACKET = 9502 ; Bad DNS packet.
Global Const $DNS_ERROR_NO_PACKET = 9503 ; No DNS packet.
Global Const $DNS_ERROR_RCODE = 9504 ; DNS error, check rcode.
Global Const $DNS_ERROR_UNSECURE_PACKET = 9505 ; Unsecured DNS packet.
Global Const $DNS_ERROR_INVALID_TYPE = 9551 ; Invalid DNS type.
Global Const $DNS_ERROR_INVALID_IP_ADDRESS = 9552 ; Invalid IP address.
Global Const $DNS_ERROR_INVALID_PROPERTY = 9553 ; Invalid property.
Global Const $DNS_ERROR_TRY_AGAIN_LATER = 9554 ; Try DNS operation again later.
Global Const $DNS_ERROR_NOT_UNIQUE = 9555 ; Record for given name and type is not unique.
Global Const $DNS_ERROR_NON_RFC_NAME = 9556 ; DNS name does not comply with RFC specifications.
Global Const $DNS_STATUS_FQDN = 9557 ; DNS name is a fully-qualified DNS name.
Global Const $DNS_STATUS_DOTTED_NAME = 9558 ; DNS name is dotted (multi-label).
Global Const $DNS_STATUS_SINGLE_PART_NAME = 9559 ; DNS name is a single-part name.
Global Const $DNS_ERROR_INVALID_NAME_CHAR = 9560 ; DNS name contains an invalid character.
Global Const $DNS_ERROR_NUMERIC_NAME = 9561 ; DNS name is entirely numeric.
Global Const $DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER = 9562 ; The operation requested is not permitted on a DNS root server.
Global Const $DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION = 9563 ; The record could not be created because this part of the DNS namespace has been delegated to another server.
Global Const $DNS_ERROR_CANNOT_FIND_ROOT_HINTS = 9564 ; The DNS server could not find a set of root hints.
Global Const $DNS_ERROR_INCONSISTENT_ROOT_HINTS = 9565 ; The DNS server found root hints but they were not consistent across all adapters.
Global Const $DNS_ERROR_DWORD_VALUE_TOO_SMALL = 9566 ; The specified value is too small for this parameter.
Global Const $DNS_ERROR_DWORD_VALUE_TOO_LARGE = 9567 ; The specified value is too large for this parameter.
Global Const $DNS_ERROR_BACKGROUND_LOADING = 9568 ; This operation is not allowed while the DNS server is loading zones in the background. Please try again later.
Global Const $DNS_ERROR_NOT_ALLOWED_ON_RODC = 9569 ; The operation requested is not permitted on against a DNS server running on a read-only DC.
Global Const $DNS_ERROR_NOT_ALLOWED_UNDER_DNAME = 9570 ; No data is allowed to exist underneath a DNAME record.
Global Const $DNS_ERROR_DELEGATION_REQUIRED = 9571 ; This operation requires credentials delegation.
Global Const $DNS_ERROR_ZONE_DOES_NOT_EXIST = 9601 ; DNS zone does not exist.
Global Const $DNS_ERROR_NO_ZONE_INFO = 9602 ; DNS zone information not available.
Global Const $DNS_ERROR_INVALID_ZONE_OPERATION = 9603 ; Invalid operation for DNS zone.
Global Const $DNS_ERROR_ZONE_CONFIGURATION_ERROR = 9604 ; Invalid DNS zone configuration.
Global Const $DNS_ERROR_ZONE_HAS_NO_SOA_RECORD = 9605 ; DNS zone has no start of authority (SOA) record.
Global Const $DNS_ERROR_ZONE_HAS_NO_NS_RECORDS = 9606 ; DNS zone has no Name Server (NS) record.
Global Const $DNS_ERROR_ZONE_LOCKED = 9607 ; DNS zone is locked.
Global Const $DNS_ERROR_ZONE_CREATION_FAILED = 9608 ; DNS zone creation failed.
Global Const $DNS_ERROR_ZONE_ALREADY_EXISTS = 9609 ; DNS zone already exists.
Global Const $DNS_ERROR_AUTOZONE_ALREADY_EXISTS = 9610 ; DNS automatic zone already exists.
Global Const $DNS_ERROR_INVALID_ZONE_TYPE = 9611 ; Invalid DNS zone type.
Global Const $DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP = 9612 ; Secondary DNS zone requires master IP address.
Global Const $DNS_ERROR_ZONE_NOT_SECONDARY = 9613 ; DNS zone not secondary.
Global Const $DNS_ERROR_NEED_SECONDARY_ADDRESSES = 9614 ; Need secondary IP address.
Global Const $DNS_ERROR_WINS_INIT_FAILED = 9615 ; WINS initialization failed.
Global Const $DNS_ERROR_NEED_WINS_SERVERS = 9616 ; Need WINS servers.
Global Const $DNS_ERROR_NBSTAT_INIT_FAILED = 9617 ; NBTSTAT initialization call failed.
Global Const $DNS_ERROR_SOA_DELETE_INVALID = 9618 ; Invalid delete of start of authority (SOA).
Global Const $DNS_ERROR_FORWARDER_ALREADY_EXISTS = 9619 ; A conditional forwarding zone already exists for that name.
Global Const $DNS_ERROR_ZONE_REQUIRES_MASTER_IP = 9620 ; This zone must be configured with one or more master DNS server IP addresses.
Global Const $DNS_ERROR_ZONE_IS_SHUTDOWN = 9621 ; The operation cannot be performed because this zone is shutdown.
Global Const $DNS_ERROR_PRIMARY_REQUIRES_DATAFILE = 9651 ; Primary DNS zone requires datafile.
Global Const $DNS_ERROR_INVALID_DATAFILE_NAME = 9652 ; Invalid datafile name for DNS zone.
Global Const $DNS_ERROR_DATAFILE_OPEN_FAILURE = 9653 ; Failed to open datafile for DNS zone.
Global Const $DNS_ERROR_FILE_WRITEBACK_FAILED = 9654 ; Failed to write datafile for DNS zone.
Global Const $DNS_ERROR_DATAFILE_PARSING = 9655 ; Failure while reading datafile for DNS zone.
Global Const $DNS_ERROR_RECORD_DOES_NOT_EXIST = 9701 ; DNS record does not exist.
Global Const $DNS_ERROR_RECORD_FORMAT = 9702 ; DNS record format error.
Global Const $DNS_ERROR_NODE_CREATION_FAILED = 9703 ; Node creation failure in DNS.
Global Const $DNS_ERROR_UNKNOWN_RECORD_TYPE = 9704 ; Unknown DNS record type.
Global Const $DNS_ERROR_RECORD_TIMED_OUT = 9705 ; DNS record timed out.
Global Const $DNS_ERROR_NAME_NOT_IN_ZONE = 9706 ; Name not in DNS zone.
Global Const $DNS_ERROR_CNAME_LOOP = 9707 ; CNAME loop detected.
Global Const $DNS_ERROR_NODE_IS_CNAME = 9708 ; Node is a CNAME DNS record.
Global Const $DNS_ERROR_CNAME_COLLISION = 9709 ; A CNAME record already exists for given name.
Global Const $DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT = 9710 ; Record only at DNS zone root.
Global Const $DNS_ERROR_RECORD_ALREADY_EXISTS = 9711 ; DNS record already exists.
Global Const $DNS_ERROR_SECONDARY_DATA = 9712 ; Secondary DNS zone data error.
Global Const $DNS_ERROR_NO_CREATE_CACHE_DATA = 9713 ; Could not create DNS cache data.
Global Const $DNS_ERROR_NAME_DOES_NOT_EXIST = 9714 ; DNS name does not exist.
Global Const $DNS_WARNING_PTR_CREATE_FAILED = 9715 ; Could not create pointer (PTR) record.
Global Const $DNS_WARNING_DOMAIN_UNDELETED = 9716 ; DNS domain was undeleted.
Global Const $DNS_ERROR_DS_UNAVAILABLE = 9717 ; The directory service is unavailable.
Global Const $DNS_ERROR_DS_ZONE_ALREADY_EXISTS = 9718 ; DNS zone already exists in the directory service.
Global Const $DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE = 9719 ; DNS server not creating or reading the boot file for the directory service integrated DNS zone.
Global Const $DNS_ERROR_NODE_IS_DNAME = 9720 ; Node is a DNAME DNS record.
Global Const $DNS_ERROR_DNAME_COLLISION = 9721 ; A DNAME record already exists for given name.
Global Const $DNS_ERROR_ALIAS_LOOP = 9722 ; An alias loop has been detected with either CNAME or DNAME records.
Global Const $DNS_INFO_AXFR_COMPLETE = 9751 ; DNS AXFR (zone transfer) complete.
Global Const $DNS_ERROR_AXFR = 9752 ; DNS zone transfer failed.
Global Const $DNS_INFO_ADDED_LOCAL_WINS = 9753 ; Added local WINS server.
Global Const $DNS_STATUS_CONTINUE_NEEDED = 9801 ; Secure update call needs to continue update request.
Global Const $DNS_ERROR_NO_TCPIP = 9851 ; TCP/IP network protocol not installed.
Global Const $DNS_ERROR_NO_DNS_SERVERS = 9852 ; No DNS servers configured for local system.
Global Const $DNS_ERROR_DP_DOES_NOT_EXIST = 9901 ; The specified directory partition does not exist.
Global Const $DNS_ERROR_DP_ALREADY_EXISTS = 9902 ; The specified directory partition already exists.
Global Const $DNS_ERROR_DP_NOT_ENLISTED = 9903 ; This DNS server is not enlisted in the specified directory partition.
Global Const $DNS_ERROR_DP_ALREADY_ENLISTED = 9904 ; This DNS server is already enlisted in the specified directory partition.
Global Const $DNS_ERROR_DP_NOT_AVAILABLE = 9905 ; The directory partition is not available at this time. Please wait a few minutes and try again.
Global Const $DNS_ERROR_DP_FSMO_ERROR = 9906 ; The application directory partition operation failed. The domain controller holding the domain naming master role is down or unable to service the request or is not running Windows Server 2003.
Global Const $WSAEINTR = 10004 ; A blocking operation was interrupted by a call to WSACancelBlockingCall.
Global Const $WSAEBADF = 10009 ; The file handle supplied is not valid.
Global Const $WSAEACCES = 10013 ; An attempt was made to access a socket in a way forbidden by its access permissions.
Global Const $WSAEFAULT = 10014 ; The system detected an invalid pointer address in attempting to use a pointer argument in a call.
Global Const $WSAEINVAL = 10022 ; An invalid argument was supplied.
Global Const $WSAEMFILE = 10024 ; Too many open sockets.
Global Const $WSAEWOULDBLOCK = 10035 ; A non-blocking socket operation could not be completed immediately.
Global Const $WSAEINPROGRESS = 10036 ; A blocking operation is currently executing.
Global Const $WSAEALREADY = 10037 ; An operation was attempted on a non-blocking socket that already had an operation in progress.
Global Const $WSAENOTSOCK = 10038 ; An operation was attempted on something that is not a socket.
Global Const $WSAEDESTADDRREQ = 10039 ; A required address was omitted from an operation on a socket.
Global Const $WSAEMSGSIZE = 10040 ; A message sent on a datagram socket was larger than the internal message buffer or some other network limit, or the buffer used to receive a datagram into was smaller than the datagram itself.
Global Const $WSAEPROTOTYPE = 10041 ; A protocol was specified in the socket function call that does not support the semantics of the socket type requested.
Global Const $WSAENOPROTOOPT = 10042 ; An unknown, invalid, or unsupported option or level was specified in a getsockopt or setsockopt call.
Global Const $WSAEPROTONOSUPPORT = 10043 ; The requested protocol has not been configured into the system, or no implementation for it exists.
Global Const $WSAESOCKTNOSUPPORT = 10044 ; The support for the specified socket type does not exist in this address family.
Global Const $WSAEOPNOTSUPP = 10045 ; The attempted operation is not supported for the type of object referenced.
Global Const $WSAEPFNOSUPPORT = 10046 ; The protocol family has not been configured into the system or no implementation for it exists.
Global Const $WSAEAFNOSUPPORT = 10047 ; An address incompatible with the requested protocol was used.
Global Const $WSAEADDRINUSE = 10048 ; Only one usage of each socket address (protocol/network address/port) is normally permitted.
Global Const $WSAEADDRNOTAVAIL = 10049 ; The requested address is not valid in its context.
Global Const $WSAENETDOWN = 10050 ; A socket operation encountered a dead network.
Global Const $WSAENETUNREACH = 10051 ; A socket operation was attempted to an unreachable network.
Global Const $WSAENETRESET = 10052 ; The connection has been broken due to keep-alive activity detecting a failure while the operation was in progress.
Global Const $WSAECONNABORTED = 10053 ; An established connection was aborted by the software in your host machine.
Global Const $WSAECONNRESET = 10054 ; An existing connection was forcibly closed by the remote host.
Global Const $WSAENOBUFS = 10055 ; An operation on a socket could not be performed because the system lacked sufficient buffer space or because a queue was full.
Global Const $WSAEISCONN = 10056 ; A connect request was made on an already connected socket.
Global Const $WSAENOTCONN = 10057 ; A request to send or receive data was disallowed because the socket is not connected and (when sending on a datagram socket using a sendto call) no address was supplied.
Global Const $WSAESHUTDOWN = 10058 ; A request to send or receive data was disallowed because the socket had already been shut down in that direction with a previous shutdown call.
Global Const $WSAETOOMANYREFS = 10059 ; Too many references to some kernel object.
Global Const $WSAETIMEDOUT = 10060 ; A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.
Global Const $WSAECONNREFUSED = 10061 ; No connection could be made because the target machine actively refused it.
Global Const $WSAELOOP = 10062 ; Cannot translate name.
Global Const $WSAENAMETOOLONG = 10063 ; Name component or name was too long.
Global Const $WSAEHOSTDOWN = 10064 ; A socket operation failed because the destination host was down.
Global Const $WSAEHOSTUNREACH = 10065 ; A socket operation was attempted to an unreachable host.
Global Const $WSAENOTEMPTY = 10066 ; Cannot remove a directory that is not empty.
Global Const $WSAEPROCLIM = 10067 ; A Windows Sockets implementation may have a limit on the number of applications that may use it simultaneously.
Global Const $WSAEUSERS = 10068 ; Ran out of quota.
Global Const $WSAEDQUOT = 10069 ; Ran out of disk quota.
Global Const $WSAESTALE = 10070 ; File handle reference is no longer available.
Global Const $WSAEREMOTE = 10071 ; Item is not available locally.
Global Const $WSASYSNOTREADY = 10091 ; WSAStartup cannot function at this time because the underlying system it uses to provide network services is currently unavailable.
Global Const $WSAVERNOTSUPPORTED = 10092 ; The Windows Sockets version requested is not supported.
Global Const $WSANOTINITIALISED = 10093 ; Either the application has not called WSAStartup, or WSAStartup failed.
Global Const $WSAEDISCON = 10101 ; Returned by WSARecv or WSARecvFrom to indicate the remote party has initiated a graceful shutdown sequence.
Global Const $WSAENOMORE = 10102 ; No more results can be returned by WSALookupServiceNext.
Global Const $WSAECANCELLED = 10103 ; A call to WSALookupServiceEnd was made while this call was still processing. The call has been canceled.
Global Const $WSAEINVALIDPROCTABLE = 10104 ; The procedure call table is invalid.
Global Const $WSAEINVALIDPROVIDER = 10105 ; The requested service provider is invalid.
Global Const $WSAEPROVIDERFAILEDINIT = 10106 ; The requested service provider could not be loaded or initialized.
Global Const $WSASYSCALLFAILURE = 10107 ; A system call has failed.
Global Const $WSASERVICE_NOT_FOUND = 10108 ; No such service is known. The service cannot be found in the specified name space.
Global Const $WSATYPE_NOT_FOUND = 10109 ; The specified class was not found.
Global Const $WSA_E_NO_MORE = 10110 ; No more results can be returned by WSALookupServiceNext.
Global Const $WSA_E_CANCELLED = 10111 ; A call to WSALookupServiceEnd was made while this call was still processing. The call has been canceled.
Global Const $WSAEREFUSED = 10112 ; A database query failed because it was actively refused.
Global Const $WSAHOST_NOT_FOUND = 11001 ; No such host is known.
Global Const $WSATRY_AGAIN = 11002 ; This is usually a temporary error during hostname resolution and means that the local server did not receive a response from an authoritative server.
Global Const $WSANO_RECOVERY = 11003 ; A non-recoverable error occurred during a database lookup.
Global Const $WSANO_DATA = 11004 ; The requested name is valid, but no data of the requested type was found.
Global Const $WSA_QOS_RECEIVERS = 11005 ; At least one reserve has arrived.
Global Const $WSA_QOS_SENDERS = 11006 ; At least one path has arrived.
Global Const $WSA_QOS_NO_SENDERS = 11007 ; There are no senders.
Global Const $WSA_QOS_NO_RECEIVERS = 11008 ; There are no receivers.
Global Const $WSA_QOS_REQUEST_CONFIRMED = 11009 ; Reserve has been confirmed.
Global Const $WSA_QOS_ADMISSION_FAILURE = 11010 ; Error due to lack of resources.
Global Const $WSA_QOS_POLICY_FAILURE = 11011 ; Rejected for administrative reasons - bad credentials.
Global Const $WSA_QOS_BAD_STYLE = 11012 ; Unknown or conflicting style.
Global Const $WSA_QOS_BAD_OBJECT = 11013 ; Problem with some part of the filterspec or providerspecific buffer in general.
Global Const $WSA_QOS_TRAFFIC_CTRL_ERROR = 11014 ; Problem with some part of the flowspec.
Global Const $WSA_QOS_GENERIC_ERROR = 11015 ; General QOS error.
Global Const $WSA_QOS_ESERVICETYPE = 11016 ; An invalid or unrecognized service type was found in the flowspec.
Global Const $WSA_QOS_EFLOWSPEC = 11017 ; An invalid or inconsistent flowspec was found in the QOS structure.
Global Const $WSA_QOS_EPROVSPECBUF = 11018 ; Invalid QOS provider-specific buffer.
Global Const $WSA_QOS_EFILTERSTYLE = 11019 ; An invalid QOS filter style was used.
Global Const $WSA_QOS_EFILTERTYPE = 11020 ; An invalid QOS filter type was used.
Global Const $WSA_QOS_EFILTERCOUNT = 11021 ; An incorrect number of QOS FILTERSPECs were specified in the FLOWDESCRIPTOR.
Global Const $WSA_QOS_EOBJLENGTH = 11022 ; An object with an invalid ObjectLength field was specified in the QOS provider-specific buffer.
Global Const $WSA_QOS_EFLOWCOUNT = 11023 ; An incorrect number of flow descriptors was specified in the QOS structure.
Global Const $WSA_QOS_EUNKOWNPSOBJ = 11024 ; An unrecognized object was found in the QOS provider-specific buffer.
Global Const $WSA_QOS_EPOLICYOBJ = 11025 ; An invalid policy object was found in the QOS provider-specific buffer.
Global Const $WSA_QOS_EFLOWDESC = 11026 ; An invalid QOS flow descriptor was found in the flow descriptor list.
Global Const $WSA_QOS_EPSFLOWSPEC = 11027 ; An invalid or inconsistent flowspec was found in the QOS provider specific buffer.
Global Const $WSA_QOS_EPSFILTERSPEC = 11028 ; An invalid FILTERSPEC was found in the QOS provider-specific buffer.
Global Const $WSA_QOS_ESDMODEOBJ = 11029 ; An invalid shape discard mode object was found in the QOS provider specific buffer.
Global Const $WSA_QOS_ESHAPERATEOBJ = 11030 ; An invalid shaping rate object was found in the QOS provider-specific buffer.
Global Const $WSA_QOS_RESERVED_PETYPE = 11031 ; A reserved policy element was found in the QOS provider-specific buffer.
Global Const $WSA_SECURE_HOST_NOT_FOUND = 11032 ; No such host is known securely.
Global Const $WSA_IPSEC_NAME_POLICY_ERROR = 11033 ; Name based IPSEC policy could not be added.
; Global Const $ERROR_INTERNET_* = 12000 - 12174                                   ; Internet Error Codes
Global Const $ERROR_IPSEC_QM_POLICY_EXISTS = 13000 ; The specified quick mode policy already exists.
Global Const $ERROR_IPSEC_QM_POLICY_NOT_FOUND = 13001 ; The specified quick mode policy was not found.
Global Const $ERROR_IPSEC_QM_POLICY_IN_USE = 13002 ; The specified quick mode policy is being used.
Global Const $ERROR_IPSEC_MM_POLICY_EXISTS = 13003 ; The specified main mode policy already exists.
Global Const $ERROR_IPSEC_MM_POLICY_NOT_FOUND = 13004 ; The specified main mode policy was not found.
Global Const $ERROR_IPSEC_MM_POLICY_IN_USE = 13005 ; The specified main mode policy is being used.
Global Const $ERROR_IPSEC_MM_FILTER_EXISTS = 13006 ; The specified main mode filter already exists.
Global Const $ERROR_IPSEC_MM_FILTER_NOT_FOUND = 13007 ; The specified main mode filter was not found.
Global Const $ERROR_IPSEC_TRANSPORT_FILTER_EXISTS = 13008 ; The specified transport mode filter already exists.
Global Const $ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND = 13009 ; The specified transport mode filter does not exist.
Global Const $ERROR_IPSEC_MM_AUTH_EXISTS = 13010 ; The specified main mode authentication list exists.
Global Const $ERROR_IPSEC_MM_AUTH_NOT_FOUND = 13011 ; The specified main mode authentication list was not found.
Global Const $ERROR_IPSEC_MM_AUTH_IN_USE = 13012 ; The specified main mode authentication list is being used.
Global Const $ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND = 13013 ; The specified default main mode policy was not found.
Global Const $ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND = 13014 ; The specified default main mode authentication list was not found.
Global Const $ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND = 13015 ; The specified default quick mode policy was not found.
Global Const $ERROR_IPSEC_TUNNEL_FILTER_EXISTS = 13016 ; The specified tunnel mode filter exists.
Global Const $ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND = 13017 ; The specified tunnel mode filter was not found.
Global Const $ERROR_IPSEC_MM_FILTER_PENDING_DELETION = 13018 ; The Main Mode filter is pending deletion.
Global Const $ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION = 13019 ; The transport filter is pending deletion.
Global Const $ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION = 13020 ; The tunnel filter is pending deletion.
Global Const $ERROR_IPSEC_MM_POLICY_PENDING_DELETION = 13021 ; The Main Mode policy is pending deletion.
Global Const $ERROR_IPSEC_MM_AUTH_PENDING_DELETION = 13022 ; The Main Mode authentication bundle is pending deletion.
Global Const $ERROR_IPSEC_QM_POLICY_PENDING_DELETION = 13023 ; The Quick Mode policy is pending deletion.
Global Const $WARNING_IPSEC_MM_POLICY_PRUNED = 13024 ; The Main Mode policy was successfully added, but some of the requested offers are not supported.
Global Const $WARNING_IPSEC_QM_POLICY_PRUNED = 13025 ; The Quick Mode policy was successfully added, but some of the requested offers are not supported.
Global Const $ERROR_IPSEC_IKE_NEG_STATUS_BEGIN = 13800 ; ERROR_IPSEC_IKE_NEG_STATUS_BEGIN
Global Const $ERROR_IPSEC_IKE_AUTH_FAIL = 13801 ; IKE authentication credentials are unacceptable.
Global Const $ERROR_IPSEC_IKE_ATTRIB_FAIL = 13802 ; IKE security attributes are unacceptable.
Global Const $ERROR_IPSEC_IKE_NEGOTIATION_PENDING = 13803 ; IKE Negotiation in progress.
Global Const $ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR = 13804 ; General processing error.
Global Const $ERROR_IPSEC_IKE_TIMED_OUT = 13805 ; Negotiation timed out.
Global Const $ERROR_IPSEC_IKE_NO_CERT = 13806 ; IKE failed to find valid machine certificate. Contact your Network Security Administrator about installing a valid certificate in the appropriate Certificate Store.
Global Const $ERROR_IPSEC_IKE_SA_DELETED = 13807 ; IKE SA deleted by peer before establishment completed.
Global Const $ERROR_IPSEC_IKE_SA_REAPED = 13808 ; IKE SA deleted before establishment completed.
Global Const $ERROR_IPSEC_IKE_MM_ACQUIRE_DROP = 13809 ; Negotiation request sat in Queue too long.
Global Const $ERROR_IPSEC_IKE_QM_ACQUIRE_DROP = 13810 ; Negotiation request sat in Queue too long.
Global Const $ERROR_IPSEC_IKE_QUEUE_DROP_MM = 13811 ; Negotiation request sat in Queue too long.
Global Const $ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM = 13812 ; Negotiation request sat in Queue too long.
Global Const $ERROR_IPSEC_IKE_DROP_NO_RESPONSE = 13813 ; No response from peer.
Global Const $ERROR_IPSEC_IKE_MM_DELAY_DROP = 13814 ; Negotiation took too long.
Global Const $ERROR_IPSEC_IKE_QM_DELAY_DROP = 13815 ; Negotiation took too long.
Global Const $ERROR_IPSEC_IKE_ERROR = 13816 ; Unknown error occurred.
Global Const $ERROR_IPSEC_IKE_CRL_FAILED = 13817 ; Certificate Revocation Check failed.
Global Const $ERROR_IPSEC_IKE_INVALID_KEY_USAGE = 13818 ; Invalid certificate key usage.
Global Const $ERROR_IPSEC_IKE_INVALID_CERT_TYPE = 13819 ; Invalid certificate type.
Global Const $ERROR_IPSEC_IKE_NO_PRIVATE_KEY = 13820 ; IKE negotiation failed because the machine certificate used does not have a private key. IPsec certificates require a private key. Contact your Network Security administrator about replacing with a certificate that has a private key.
Global Const $ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY = 13821 ; Simultaneous rekeys were detected.
Global Const $ERROR_IPSEC_IKE_DH_FAIL = 13822 ; Failure in Diffie-Hellman computation.
Global Const $ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED = 13823 ; Don't know how to process critical payload.
Global Const $ERROR_IPSEC_IKE_INVALID_HEADER = 13824 ; Invalid header.
Global Const $ERROR_IPSEC_IKE_NO_POLICY = 13825 ; No policy configured.
Global Const $ERROR_IPSEC_IKE_INVALID_SIGNATURE = 13826 ; Failed to verify signature.
Global Const $ERROR_IPSEC_IKE_KERBEROS_ERROR = 13827 ; Failed to authenticate using Kerberos.
Global Const $ERROR_IPSEC_IKE_NO_PUBLIC_KEY = 13828 ; Peer's certificate did not have a public key.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR = 13829 ; Error processing error payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_SA = 13830 ; Error processing SA payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_PROP = 13831 ; Error processing Proposal payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_TRANS = 13832 ; Error processing Transform payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_KE = 13833 ; Error processing KE payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_ID = 13834 ; Error processing ID payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_CERT = 13835 ; Error processing Cert payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ = 13836 ; Error processing Certificate Request payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_HASH = 13837 ; Error processing Hash payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_SIG = 13838 ; Error processing Signature payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_NONCE = 13839 ; Error processing Nonce payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY = 13840 ; Error processing Notify payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_DELETE = 13841 ; Error processing Delete Payload.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR = 13842 ; Error processing VendorId payload.
Global Const $ERROR_IPSEC_IKE_INVALID_PAYLOAD = 13843 ; Invalid payload received.
Global Const $ERROR_IPSEC_IKE_LOAD_SOFT_SA = 13844 ; Soft SA loaded.
Global Const $ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN = 13845 ; Soft SA torn down.
Global Const $ERROR_IPSEC_IKE_INVALID_COOKIE = 13846 ; Invalid cookie received.
Global Const $ERROR_IPSEC_IKE_NO_PEER_CERT = 13847 ; Peer failed to send valid machine certificate.
Global Const $ERROR_IPSEC_IKE_PEER_CRL_FAILED = 13848 ; Certification Revocation check of peer's certificate failed.
Global Const $ERROR_IPSEC_IKE_POLICY_CHANGE = 13849 ; New policy invalidated SAs formed with old policy.
Global Const $ERROR_IPSEC_IKE_NO_MM_POLICY = 13850 ; There is no available Main Mode IKE policy.
Global Const $ERROR_IPSEC_IKE_NOTCBPRIV = 13851 ; Failed to enabled TCB privilege.
Global Const $ERROR_IPSEC_IKE_SECLOADFAIL = 13852 ; Failed to load SECURITY.DLL.
Global Const $ERROR_IPSEC_IKE_FAILSSPINIT = 13853 ; Failed to obtain security function table dispatch address from SSPI.
Global Const $ERROR_IPSEC_IKE_FAILQUERYSSP = 13854 ; Failed to query Kerberos package to obtain max token size.
Global Const $ERROR_IPSEC_IKE_SRVACQFAIL = 13855 ; Failed to obtain Kerberos server credentials for ISAKMP/ERROR_IPSEC_IKE service. Kerberos authentication will not function. The most likely reason for this is lack of domain membership. This is normal if your computer is a member of a workgroup.
Global Const $ERROR_IPSEC_IKE_SRVQUERYCRED = 13856 ; Failed to determine SSPI principal name for ISAKMP/ERROR_IPSEC_IKE service (QueryCredentialsAttributes).
Global Const $ERROR_IPSEC_IKE_GETSPIFAIL = 13857 ; Failed to obtain new SPI for the inbound SA from Ipsec driver. The most common cause for this is that the driver does not have the correct filter. Check your policy to verify the filters.
Global Const $ERROR_IPSEC_IKE_INVALID_FILTER = 13858 ; Given filter is invalid.
Global Const $ERROR_IPSEC_IKE_OUT_OF_MEMORY = 13859 ; Memory allocation failed.
Global Const $ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED = 13860 ; Failed to add Security Association to IPSec Driver. The most common cause for this is if the IKE negotiation took too long to complete. If the problem persists, reduce the load on the faulting machine.
Global Const $ERROR_IPSEC_IKE_INVALID_POLICY = 13861 ; Invalid policy.
Global Const $ERROR_IPSEC_IKE_UNKNOWN_DOI = 13862 ; Invalid DOI.
Global Const $ERROR_IPSEC_IKE_INVALID_SITUATION = 13863 ; Invalid situation.
Global Const $ERROR_IPSEC_IKE_DH_FAILURE = 13864 ; Diffie-Hellman failure.
Global Const $ERROR_IPSEC_IKE_INVALID_GROUP = 13865 ; Invalid Diffie-Hellman group.
Global Const $ERROR_IPSEC_IKE_ENCRYPT = 13866 ; Error encrypting payload.
Global Const $ERROR_IPSEC_IKE_DECRYPT = 13867 ; Error decrypting payload.
Global Const $ERROR_IPSEC_IKE_POLICY_MATCH = 13868 ; Policy match error.
Global Const $ERROR_IPSEC_IKE_UNSUPPORTED_ID = 13869 ; Unsupported ID.
Global Const $ERROR_IPSEC_IKE_INVALID_HASH = 13870 ; Hash verification failed.
Global Const $ERROR_IPSEC_IKE_INVALID_HASH_ALG = 13871 ; Invalid hash algorithm.
Global Const $ERROR_IPSEC_IKE_INVALID_HASH_SIZE = 13872 ; Invalid hash size.
Global Const $ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG = 13873 ; Invalid encryption algorithm.
Global Const $ERROR_IPSEC_IKE_INVALID_AUTH_ALG = 13874 ; Invalid authentication algorithm.
Global Const $ERROR_IPSEC_IKE_INVALID_SIG = 13875 ; Invalid certificate signature.
Global Const $ERROR_IPSEC_IKE_LOAD_FAILED = 13876 ; Load failed.
Global Const $ERROR_IPSEC_IKE_RPC_DELETE = 13877 ; Deleted via RPC call.
Global Const $ERROR_IPSEC_IKE_BENIGN_REINIT = 13878 ; Temporary state created to perform reinit. This is not a real failure.
Global Const $ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY = 13879 ; The lifetime value received in the Responder Lifetime Notify is below the Windows configured minimum value. Please fix the policy on the peer machine.
Global Const $ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION = 13880 ; The recipient cannot handle version of IKE specified in the header.
Global Const $ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN = 13881 ; Key length in certificate is too small for configured security requirements.
Global Const $ERROR_IPSEC_IKE_MM_LIMIT = 13882 ; Max number of established MM SAs to peer exceeded.
Global Const $ERROR_IPSEC_IKE_NEGOTIATION_DISABLED = 13883 ; IKE received a policy that disables negotiation.
Global Const $ERROR_IPSEC_IKE_QM_LIMIT = 13884 ; Reached maximum quick mode limit for the main mode. New main mode will be started.
Global Const $ERROR_IPSEC_IKE_MM_EXPIRED = 13885 ; Main mode SA lifetime expired or peer sent a main mode delete.
Global Const $ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID = 13886 ; Main mode SA assumed to be invalid because peer stopped responding.
Global Const $ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH = 13887 ; Certificate doesn't chain to a trusted root in IPsec policy.
Global Const $ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID = 13888 ; Received unexpected message ID.
Global Const $ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD = 13889 ; Received invalid authentication offers.
Global Const $ERROR_IPSEC_IKE_DOS_COOKIE_SENT = 13890 ; Sent DOS cookie notify to initiator.
Global Const $ERROR_IPSEC_IKE_SHUTTING_DOWN = 13891 ; IKE service is shutting down.
Global Const $ERROR_IPSEC_IKE_CGA_AUTH_FAILED = 13892 ; Could not verify binding between CGA address and certificate.
Global Const $ERROR_IPSEC_IKE_PROCESS_ERR_NATOA = 13893 ; Error processing NatOA payload.
Global Const $ERROR_IPSEC_IKE_INVALID_MM_FOR_QM = 13894 ; Parameters of the main mode are invalid for this quick mode.
Global Const $ERROR_IPSEC_IKE_QM_EXPIRED = 13895 ; Quick mode SA was expired by IPsec driver.
Global Const $ERROR_IPSEC_IKE_TOO_MANY_FILTERS = 13896 ; Too many dynamically added IKEEXT filters were detected.
Global Const $ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL = 13898 ; NAP reauth succeeded and must delete the dummy NAP IkeV2 tunnel.
Global Const $ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE = 13899 ; Error in assigning inner IP address to initiator in tunnel mode.
Global Const $ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING = 13900 ; Require configuration payload missing.
Global Const $ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING = 13901 ; A negotiation running as the security principle who issued the connection is in progress.
Global Const $ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS = 13902 ; SA was deleted due to IKEv1/AuthIP co-existence suppress check.
Global Const $ERROR_IPSEC_IKE_RATELIMIT_DROP = 13903 ; Incoming SA request was dropped due to peer IP address rate limiting.
Global Const $ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE = 13904 ; Peer does not support MOBIKE.
Global Const $ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE = 13905 ; SA establishment is not authorized.
Global Const $ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END = 13909 ; ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END
Global Const $ERROR_IPSEC_BAD_SPI = 13910 ; The SPI in the packet does not match a valid IPsec SA.
Global Const $ERROR_IPSEC_SA_LIFETIME_EXPIRED = 13911 ; Packet was received on an IPsec SA whose lifetime has expired.
Global Const $ERROR_IPSEC_WRONG_SA = 13912 ; Packet was received on an IPsec SA that doesn't match the packet characteristics.
Global Const $ERROR_IPSEC_REPLAY_CHECK_FAILED = 13913 ; Packet sequence number replay check failed.
Global Const $ERROR_IPSEC_INVALID_PACKET = 13914 ; IPsec header and/or trailer in the packet is invalid.
Global Const $ERROR_IPSEC_INTEGRITY_CHECK_FAILED = 13915 ; IPsec integrity check failed.
Global Const $ERROR_IPSEC_CLEAR_TEXT_DROP = 13916 ; IPsec dropped a clear text packet.
Global Const $ERROR_IPSEC_AUTH_FIREWALL_DROP = 13917 ; IPsec dropped an incoming ESP packet in authenticated firewall mode. This drop is benign.
Global Const $ERROR_IPSEC_THROTTLE_DROP = 13918 ; IPsec dropped a packet due to DOS throttle.
Global Const $ERROR_IPSEC_DOSP_BLOCK = 13925 ; IPsec Dos Protection matched an explicit block rule.
Global Const $ERROR_IPSEC_DOSP_RECEIVED_MULTICAST = 13926 ; IPsec Dos Protection received an IPsec specific multicast packet which is not allowed.
Global Const $ERROR_IPSEC_DOSP_INVALID_PACKET = 13927 ; IPsec Dos Protection received an incorrectly formatted packet.
Global Const $ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED = 13928 ; IPsec Dos Protection failed to lookup state.
Global Const $ERROR_IPSEC_DOSP_MAX_ENTRIES = 13929 ; IPsec Dos Protection failed to create state because there are already maximum number of entries allowed by policy.
Global Const $ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED = 13930 ; IPsec Dos Protection received an IPsec negotiation packet for a keying module which is not allowed by policy.
Global Const $ERROR_IPSEC_DOSP_NOT_INSTALLED = 13931 ; IPsec Dos Protection has not been enabled.
Global Const $ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES = 13932 ; IPsec Dos Protection failed to create per internal IP ratelimit queue because there is already maximum number of queues allowed by policy.
Global Const $ERROR_SXS_SECTION_NOT_FOUND = 14000 ; The requested section was not present in the activation context.
Global Const $ERROR_SXS_CANT_GEN_ACTCTX = 14001 ; The application has failed to start because its side-by-side configuration is incorrect. Please see the application event log or use the command-line sxstrace.exe tools for more detail.
Global Const $ERROR_SXS_INVALID_ACTCTXDATA_FORMAT = 14002 ; The application binding data format is invalid.
Global Const $ERROR_SXS_ASSEMBLY_NOT_FOUND = 14003 ; The referenced assembly is not installed on your system.
Global Const $ERROR_SXS_MANIFEST_FORMAT_ERROR = 14004 ; The manifest file does not begin with the required tag and format information.
Global Const $ERROR_SXS_MANIFEST_PARSE_ERROR = 14005 ; The manifest file contains one or more syntax errors.
Global Const $ERROR_SXS_ACTIVATION_CONTEXT_DISABLED = 14006 ; The application attempted to activate a disabled activation context.
Global Const $ERROR_SXS_KEY_NOT_FOUND = 14007 ; The requested lookup key was not found in any active activation context.
Global Const $ERROR_SXS_VERSION_CONFLICT = 14008 ; A component version required by the application conflicts with another component version already active.
Global Const $ERROR_SXS_WRONG_SECTION_TYPE = 14009 ; The type requested activation context section does not match the query API used.
Global Const $ERROR_SXS_THREAD_QUERIES_DISABLED = 14010 ; Lack of system resources has required isolated activation to be disabled for the current thread of execution.
Global Const $ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET = 14011 ; An attempt to set the process default activation context failed because the process default activation context was already set.
Global Const $ERROR_SXS_UNKNOWN_ENCODING_GROUP = 14012 ; The encoding group identifier specified is not recognized.
Global Const $ERROR_SXS_UNKNOWN_ENCODING = 14013 ; The encoding requested is not recognized.
Global Const $ERROR_SXS_INVALID_XML_NAMESPACE_URI = 14014 ; The manifest contains a reference to an invalid URI.
Global Const $ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED = 14015 ; The application manifest contains a reference to a dependent assembly which is not installed.
Global Const $ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED = 14016 ; The manifest for an assembly used by the application has a reference to a dependent assembly which is not installed.
Global Const $ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE = 14017 ; The manifest contains an attribute for the assembly identity which is not valid.
Global Const $ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE = 14018 ; The manifest is missing the required default namespace specification on the assembly element.
Global Const $ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE = 14019 ; The manifest has a default namespace specified on the assembly element but its value is not "urn:schemas-microsoft-com:asm.v1".
Global Const $ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT = 14020 ; The private manifest probed has crossed a path with an unsupported reparse point.
Global Const $ERROR_SXS_DUPLICATE_DLL_NAME = 14021 ; Two or more components referenced directly or indirectly by the application manifest have files by the same name.
Global Const $ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME = 14022 ; Two or more components referenced directly or indirectly by the application manifest have window classes with the same name.
Global Const $ERROR_SXS_DUPLICATE_CLSID = 14023 ; Two or more components referenced directly or indirectly by the application manifest have the same COM server CLSIDs.
Global Const $ERROR_SXS_DUPLICATE_IID = 14024 ; Two or more components referenced directly or indirectly by the application manifest have proxies for the same COM interface IIDs.
Global Const $ERROR_SXS_DUPLICATE_TLBID = 14025 ; Two or more components referenced directly or indirectly by the application manifest have the same COM type library TLBIDs.
Global Const $ERROR_SXS_DUPLICATE_PROGID = 14026 ; Two or more components referenced directly or indirectly by the application manifest have the same COM ProgIDs.
Global Const $ERROR_SXS_DUPLICATE_ASSEMBLY_NAME = 14027 ; Two or more components referenced directly or indirectly by the application manifest are different versions of the same component which is not permitted.
Global Const $ERROR_SXS_FILE_HASH_MISMATCH = 14028 ; A component's file does not match the verification information present in the component manifest.
Global Const $ERROR_SXS_POLICY_PARSE_ERROR = 14029 ; The policy manifest contains one or more syntax errors.
Global Const $ERROR_SXS_XML_E_MISSINGQUOTE = 14030 ; Manifest Parse Error : A string literal was expected, but no opening quote character was found.
Global Const $ERROR_SXS_XML_E_COMMENTSYNTAX = 14031 ; Manifest Parse Error : Incorrect syntax was used in a comment.
Global Const $ERROR_SXS_XML_E_BADSTARTNAMECHAR = 14032 ; Manifest Parse Error : A name was started with an invalid character.
Global Const $ERROR_SXS_XML_E_BADNAMECHAR = 14033 ; Manifest Parse Error : A name contained an invalid character.
Global Const $ERROR_SXS_XML_E_BADCHARINSTRING = 14034 ; Manifest Parse Error : A string literal contained an invalid character.
Global Const $ERROR_SXS_XML_E_XMLDECLSYNTAX = 14035 ; Manifest Parse Error : Invalid syntax for an xml declaration.
Global Const $ERROR_SXS_XML_E_BADCHARDATA = 14036 ; Manifest Parse Error : An Invalid character was found in text content.
Global Const $ERROR_SXS_XML_E_MISSINGWHITESPACE = 14037 ; Manifest Parse Error : Required white space was missing.
Global Const $ERROR_SXS_XML_E_EXPECTINGTAGEND = 14038 ; Manifest Parse Error : The character '>' was expected.
Global Const $ERROR_SXS_XML_E_MISSINGSEMICOLON = 14039 ; Manifest Parse Error : A semi colon character was expected.
Global Const $ERROR_SXS_XML_E_UNBALANCEDPAREN = 14040 ; Manifest Parse Error : Unbalanced parentheses.
Global Const $ERROR_SXS_XML_E_INTERNALERROR = 14041 ; Manifest Parse Error : Internal error.
Global Const $ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE = 14042 ; Manifest Parse Error : Whitespace is not allowed at this location.
Global Const $ERROR_SXS_XML_E_INCOMPLETE_ENCODING = 14043 ; Manifest Parse Error : End of file reached in invalid state for current encoding.
Global Const $ERROR_SXS_XML_E_MISSING_PAREN = 14044 ; Manifest Parse Error : Missing parenthesis.
Global Const $ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE = 14045 ; Manifest Parse Error : A single or double closing quote character (\' or \") is missing.
Global Const $ERROR_SXS_XML_E_MULTIPLE_COLONS = 14046 ; Manifest Parse Error : Multiple colons are not allowed in a name.
Global Const $ERROR_SXS_XML_E_INVALID_DECIMAL = 14047 ; Manifest Parse Error : Invalid character for decimal digit.
Global Const $ERROR_SXS_XML_E_INVALID_HEXIDECIMAL = 14048 ; Manifest Parse Error : Invalid character for hexadecimal digit.
Global Const $ERROR_SXS_XML_E_INVALID_UNICODE = 14049 ; Manifest Parse Error : Invalid unicode character value for this platform.
Global Const $ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK = 14050 ; Manifest Parse Error : Expecting whitespace or '?'.
Global Const $ERROR_SXS_XML_E_UNEXPECTEDENDTAG = 14051 ; Manifest Parse Error : End tag was not expected at this location.
Global Const $ERROR_SXS_XML_E_UNCLOSEDTAG = 14052 ; Manifest Parse Error : The following tags were not closed: %1.
Global Const $ERROR_SXS_XML_E_DUPLICATEATTRIBUTE = 14053 ; Manifest Parse Error : Duplicate attribute.
Global Const $ERROR_SXS_XML_E_MULTIPLEROOTS = 14054 ; Manifest Parse Error : Only one top level element is allowed in an XML document.
Global Const $ERROR_SXS_XML_E_INVALIDATROOTLEVEL = 14055 ; Manifest Parse Error : Invalid at the top level of the document.
Global Const $ERROR_SXS_XML_E_BADXMLDECL = 14056 ; Manifest Parse Error : Invalid xml declaration.
Global Const $ERROR_SXS_XML_E_MISSINGROOT = 14057 ; Manifest Parse Error : XML document must have a top level element.
Global Const $ERROR_SXS_XML_E_UNEXPECTEDEOF = 14058 ; Manifest Parse Error : Unexpected end of file.
Global Const $ERROR_SXS_XML_E_BADPEREFINSUBSET = 14059 ; Manifest Parse Error : Parameter entities cannot be used inside markup declarations in an internal subset.
Global Const $ERROR_SXS_XML_E_UNCLOSEDSTARTTAG = 14060 ; Manifest Parse Error : Element was not closed.
Global Const $ERROR_SXS_XML_E_UNCLOSEDENDTAG = 14061 ; Manifest Parse Error : End element was missing the character '>'.
Global Const $ERROR_SXS_XML_E_UNCLOSEDSTRING = 14062 ; Manifest Parse Error : A string literal was not closed.
Global Const $ERROR_SXS_XML_E_UNCLOSEDCOMMENT = 14063 ; Manifest Parse Error : A comment was not closed.
Global Const $ERROR_SXS_XML_E_UNCLOSEDDECL = 14064 ; Manifest Parse Error : A declaration was not closed.
Global Const $ERROR_SXS_XML_E_UNCLOSEDCDATA = 14065 ; Manifest Parse Error : A CDATA section was not closed.
Global Const $ERROR_SXS_XML_E_RESERVEDNAMESPACE = 14066 ; Manifest Parse Error : The namespace prefix is not allowed to start with the reserved string "xml".
Global Const $ERROR_SXS_XML_E_INVALIDENCODING = 14067 ; Manifest Parse Error : System does not support the specified encoding.
Global Const $ERROR_SXS_XML_E_INVALIDSWITCH = 14068 ; Manifest Parse Error : Switch from current encoding to specified encoding not supported.
Global Const $ERROR_SXS_XML_E_BADXMLCASE = 14069 ; Manifest Parse Error : The name 'xml' is reserved and must be lower case.
Global Const $ERROR_SXS_XML_E_INVALID_STANDALONE = 14070 ; Manifest Parse Error : The standalone attribute must have the value 'yes' or 'no'.
Global Const $ERROR_SXS_XML_E_UNEXPECTED_STANDALONE = 14071 ; Manifest Parse Error : The standalone attribute cannot be used in external entities.
Global Const $ERROR_SXS_XML_E_INVALID_VERSION = 14072 ; Manifest Parse Error : Invalid version number.
Global Const $ERROR_SXS_XML_E_MISSINGEQUALS = 14073 ; Manifest Parse Error : Missing equals sign between attribute and attribute value.
Global Const $ERROR_SXS_PROTECTION_RECOVERY_FAILED = 14074 ; Assembly Protection Error : Unable to recover the specified assembly.
Global Const $ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT = 14075 ; Assembly Protection Error : The public key for an assembly was too short to be allowed.
Global Const $ERROR_SXS_PROTECTION_CATALOG_NOT_VALID = 14076 ; Assembly Protection Error : The catalog for an assembly is not valid, or does not match the assembly's manifest.
Global Const $ERROR_SXS_UNTRANSLATABLE_HRESULT = 14077 ; An HRESULT could not be translated to a corresponding Win32 error code.
Global Const $ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING = 14078 ; Assembly Protection Error : The catalog for an assembly is missing.
Global Const $ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE = 14079 ; The supplied assembly identity is missing one or more attributes which must be present in this context.
Global Const $ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME = 14080 ; The supplied assembly identity has one or more attribute names that contain characters not permitted in XML names.
Global Const $ERROR_SXS_ASSEMBLY_MISSING = 14081 ; The referenced assembly could not be found.
Global Const $ERROR_SXS_CORRUPT_ACTIVATION_STACK = 14082 ; The activation context activation stack for the running thread of execution is corrupt.
Global Const $ERROR_SXS_CORRUPTION = 14083 ; The application isolation metadata for this process or thread has become corrupt.
Global Const $ERROR_SXS_EARLY_DEACTIVATION = 14084 ; The activation context being deactivated is not the most recently activated one.
Global Const $ERROR_SXS_INVALID_DEACTIVATION = 14085 ; The activation context being deactivated is not active for the current thread of execution.
Global Const $ERROR_SXS_MULTIPLE_DEACTIVATION = 14086 ; The activation context being deactivated has already been deactivated.
Global Const $ERROR_SXS_PROCESS_TERMINATION_REQUESTED = 14087 ; A component used by the isolation facility has requested to terminate the process.
Global Const $ERROR_SXS_RELEASE_ACTIVATION_CONTEXT = 14088 ; A kernel mode component is releasing a reference on an activation context.
Global Const $ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY = 14089 ; The activation context of system default assembly could not be generated.
Global Const $ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE = 14090 ; The value of an attribute in an identity is not within the legal range.
Global Const $ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME = 14091 ; The name of an attribute in an identity is not within the legal range.
Global Const $ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE = 14092 ; An identity contains two definitions for the same attribute.
Global Const $ERROR_SXS_IDENTITY_PARSE_ERROR = 14093 ; The identity string is malformed. This may be due to a trailing comma, more than two unnamed attributes, missing attribute name or missing attribute value.
Global Const $ERROR_MALFORMED_SUBSTITUTION_STRING = 14094 ; A string containing localized substitutable content was malformed. Either a dollar sign ($) was followed by something other than a left parenthesis or another dollar sign or an substitution's right parenthesis was not found.
Global Const $ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN = 14095 ; The public key token does not correspond to the public key specified.
Global Const $ERROR_UNMAPPED_SUBSTITUTION_STRING = 14096 ; A substitution string had no mapping.
Global Const $ERROR_SXS_ASSEMBLY_NOT_LOCKED = 14097 ; The component must be locked before making the request.
Global Const $ERROR_SXS_COMPONENT_STORE_CORRUPT = 14098 ; The component store has been corrupted.
Global Const $ERROR_ADVANCED_INSTALLER_FAILED = 14099 ; An advanced installer failed during setup or servicing.
Global Const $ERROR_XML_ENCODING_MISMATCH = 14100 ; The character encoding in the XML declaration did not match the encoding used in the document.
Global Const $ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT = 14101 ; The identities of the manifests are identical but their contents are different.
Global Const $ERROR_SXS_IDENTITIES_DIFFERENT = 14102 ; The component identities are different.
Global Const $ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT = 14103 ; The assembly is not a deployment.
Global Const $ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY = 14104 ; The file is not a part of the assembly.
Global Const $ERROR_SXS_MANIFEST_TOO_BIG = 14105 ; The size of the manifest exceeds the maximum allowed.
Global Const $ERROR_SXS_SETTING_NOT_REGISTERED = 14106 ; The setting is not registered.
Global Const $ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE = 14107 ; One or more required members of the transaction are not present.
Global Const $ERROR_SMI_PRIMITIVE_INSTALLER_FAILED = 14108 ; The SMI primitive installer failed during setup or servicing.
Global Const $ERROR_GENERIC_COMMAND_FAILED = 14109 ; A generic command executable returned a result that indicates failure.
Global Const $ERROR_SXS_FILE_HASH_MISSING = 14110 ; A component is missing file verification information in its manifest.
Global Const $ERROR_EVT_INVALID_CHANNEL_PATH = 15000 ; The specified channel path is invalid.
Global Const $ERROR_EVT_INVALID_QUERY = 15001 ; The specified query is invalid.
Global Const $ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND = 15002 ; The publisher metadata cannot be found in the resource.
Global Const $ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND = 15003 ; The template for an event definition cannot be found in the resource (error = %1).
Global Const $ERROR_EVT_INVALID_PUBLISHER_NAME = 15004 ; The specified publisher name is invalid.
Global Const $ERROR_EVT_INVALID_EVENT_DATA = 15005 ; The event data raised by the publisher is not compatible with the event template definition in the publisher's manifest.
Global Const $ERROR_EVT_CHANNEL_NOT_FOUND = 15007 ; The specified channel could not be found. Check channel configuration.
Global Const $ERROR_EVT_MALFORMED_XML_TEXT = 15008 ; The specified xml text was not well-formed. See Extended Error for more details.
Global Const $ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL = 15009 ; The caller is trying to subscribe to a direct channel which is not allowed. The events for a direct channel go directly to a logfile and cannot be subscribed to.
Global Const $ERROR_EVT_CONFIGURATION_ERROR = 15010 ; Configuration error.
Global Const $ERROR_EVT_QUERY_RESULT_STALE = 15011 ; The query result is stale / invalid. This may be due to the log being cleared or rolling over after the query result was created. Users should handle this code by releasing the query result object and reissuing the query.
Global Const $ERROR_EVT_QUERY_RESULT_INVALID_POSITION = 15012 ; Query result is currently at an invalid position.
Global Const $ERROR_EVT_NON_VALIDATING_MSXML = 15013 ; Registered MSXML doesn't support validation.
Global Const $ERROR_EVT_FILTER_ALREADYSCOPED = 15014 ; An expression can only be followed by a change of scope operation if it itself evaluates to a node set and is not already part of some other change of scope operation.
Global Const $ERROR_EVT_FILTER_NOTELTSET = 15015 ; Can't perform a step operation from a term that does not represent an element set.
Global Const $ERROR_EVT_FILTER_INVARG = 15016 ; Left hand side arguments to binary operators must be either attributes, nodes or variables and right hand side arguments must be constants.
Global Const $ERROR_EVT_FILTER_INVTEST = 15017 ; A step operation must involve either a node test or, in the case of a predicate, an algebraic expression against which to test each node in the node set identified by the preceding node set can be evaluated.
Global Const $ERROR_EVT_FILTER_INVTYPE = 15018 ; This data type is currently unsupported.
Global Const $ERROR_EVT_FILTER_PARSEERR = 15019 ; A syntax error occurred at position %1!d!
Global Const $ERROR_EVT_FILTER_UNSUPPORTEDOP = 15020 ; This operator is unsupported by this implementation of the filter.
Global Const $ERROR_EVT_FILTER_UNEXPECTEDTOKEN = 15021 ; The token encountered was unexpected.
Global Const $ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL = 15022 ; The requested operation cannot be performed over an enabled direct channel. The channel must first be disabled before performing the requested operation.
Global Const $ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE = 15023 ; Channel property %1!s! contains invalid value. The value has invalid type, is outside of valid range, can't be updated or is not supported by this type of channel.
Global Const $ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE = 15024 ; Publisher property %1!s! contains invalid value. The value has invalid type, is outside of valid range, can't be updated or is not supported by this type of publisher.
Global Const $ERROR_EVT_CHANNEL_CANNOT_ACTIVATE = 15025 ; The channel fails to activate.
Global Const $ERROR_EVT_FILTER_TOO_COMPLEX = 15026 ; The xpath expression exceeded supported complexity. Please simplify it or split it into two or more simple expressions.
Global Const $ERROR_EVT_MESSAGE_NOT_FOUND = 15027 ; The message resource is present but the message is not found in the string/message table.
Global Const $ERROR_EVT_MESSAGE_ID_NOT_FOUND = 15028 ; The message identifier for the desired message could not be found.
Global Const $ERROR_EVT_UNRESOLVED_VALUE_INSERT = 15029 ; The substitution string for insert index (%1) could not be found.
Global Const $ERROR_EVT_UNRESOLVED_PARAMETER_INSERT = 15030 ; The description string for parameter reference (%1) could not be found.
Global Const $ERROR_EVT_MAX_INSERTS_REACHED = 15031 ; The maximum number of replacements has been reached.
Global Const $ERROR_EVT_EVENT_DEFINITION_NOT_FOUND = 15032 ; The event definition could not be found for the event identifier (%1).
Global Const $ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND = 15033 ; The locale specific resource for the desired message is not present.
Global Const $ERROR_EVT_VERSION_TOO_OLD = 15034 ; The resource is too old to be compatible.
Global Const $ERROR_EVT_VERSION_TOO_NEW = 15035 ; The resource is too new to be compatible.
Global Const $ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY = 15036 ; The channel at index %1!d! of the query cannot be opened.
Global Const $ERROR_EVT_PUBLISHER_DISABLED = 15037 ; The publisher has been disabled and its resource is not available. This usually occurs when the publisher is in the process of being uninstalled or upgraded.
Global Const $ERROR_EVT_FILTER_OUT_OF_RANGE = 15038 ; Attempted to create a numeric type that is outside of its valid range.
Global Const $ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE = 15080 ; The subscription fails to activate.
Global Const $ERROR_EC_LOG_DISABLED = 15081 ; The log of the subscription is in disabled state, and cannot be used to forward events. The log must first be enabled before the subscription can be activated.
Global Const $ERROR_EC_CIRCULAR_FORWARDING = 15082 ; When forwarding events from local machine to itself, the query of the subscription can't contain target log of the subscription.
Global Const $ERROR_EC_CREDSTORE_FULL = 15083 ; The credential store that is used to save credentials is full.
Global Const $ERROR_EC_CRED_NOT_FOUND = 15084 ; The credential used by this subscription can't be found in credential store.
Global Const $ERROR_EC_NO_ACTIVE_CHANNEL = 15085 ; No active channel is found for the query.
Global Const $ERROR_MUI_FILE_NOT_FOUND = 15100 ; The resource loader failed to find MUI file.
Global Const $ERROR_MUI_INVALID_FILE = 15101 ; The resource loader failed to load MUI file because the file fail to pass validation.
Global Const $ERROR_MUI_INVALID_RC_CONFIG = 15102 ; The RC Manifest is corrupted with garbage data or unsupported version or missing required item.
Global Const $ERROR_MUI_INVALID_LOCALE_NAME = 15103 ; The RC Manifest has invalid culture name.
Global Const $ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME = 15104 ; The RC Manifest has invalid ultimatefallback name.
Global Const $ERROR_MUI_FILE_NOT_LOADED = 15105 ; The resource loader cache doesn't have loaded MUI entry.
Global Const $ERROR_RESOURCE_ENUM_USER_STOP = 15106 ; User stop resource enumeration.
Global Const $ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED = 15107 ; UI language installation failed.
Global Const $ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME = 15108 ; Locale installation failed.
Global Const $ERROR_MCA_INVALID_CAPABILITIES_STRING = 15200 ; The monitor returned a DDC/CI capabilities string that did not comply with the ACCESS.bus 3.0, DDC/CI 1.1, or MCCS 2 Revision 1 specification.
Global Const $ERROR_MCA_INVALID_VCP_VERSION = 15201 ; The monitor's VCP Version (0xDF) VCP code returned an invalid version value.
Global Const $ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION = 15202 ; The monitor does not comply with the MCCS specification it claims to supports.
Global Const $ERROR_MCA_MCCS_VERSION_MISMATCH = 15203 ; The MCCS version in a monitor's mccs_ver capability does not match the MCCS version the monitor reports when the VCP Version (0xDF) VCP code is used.
Global Const $ERROR_MCA_UNSUPPORTED_MCCS_VERSION = 15204 ; The Monitor Configuration API only works with monitors that support the MCCS 1.0 specification, MCCS 2.0 specification, or the MCCS 2.0 Revision 1 specification.
Global Const $ERROR_MCA_INTERNAL_ERROR = 15205 ; An internal Monitor Configuration API error occurred.
Global Const $ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED = 15206 ; The monitor returned an invalid monitor technology type. CRT, Plasma, and LCD (TFT) are examples of monitor technology types. This error implies that the monitor violated the MCCS 2.0 or the MCCS 2.0 Revision 1 specification.
Global Const $ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE = 15207 ; The caller of SetMonitorColorTemperature specified a color temperature that the current monitor did not support. This error implies that the monitor violated the MCCS 2.0 or the MCCS 2.0 Revision 1 specification.
Global Const $ERROR_AMBIGUOUS_SYSTEM_DEVICE = 15250 ; The requested system device cannot be identified due to multiple indistinguishable devices potentially matching the identification criteria.
Global Const $ERROR_SYSTEM_DEVICE_NOT_FOUND = 15299 ; The requested system device cannot be found.
Global Const $ERROR_HASH_NOT_SUPPORTED = 15300 ; Hash generation for the specified version and hash type is not enabled on server.
Global Const $ERROR_HASH_NOT_PRESENT = 15301 ; The hash requests is not present or not up to date with the current file contents.
; ===============================================================================================================================
