#NoTrayIcon

Global $sPI_Name = @ScriptName

If WinExists($sPI_Name) Then
	Exit
EndIf

AutoItWinSetTitle($sPI_Name)

#Region Container UDF: http://www.autoitscript.com/forum/topic/126936-container-udf-scripts-interaction-library

Global $oContainerOMErr

Func _Container_Open($sName, $iMode)
	Local $oShell, $oShellWindow, $oShellWindows
	
	If Not ObjEvent("AutoIt.Error") Then
		$oContainerOMErr = ObjEvent("AutoIt.Error", "__Container_COMErrHandler")
	EndIf
	
	$oShell = ObjCreate("Shell.Application")
	
	If Not IsObj($oShell) Then
		Return SetError(2, 0, 0)
	EndIf
	
	$oShellWindows = $oShell.Windows
	
	For $oShellWindow In $oShellWindows
		If $oShellWindow.StatusText = $sName Then
			Return $oShellWindow
		EndIf
		
		If @error Then
			ExitLoop
		EndIf
	Next
	
	If $iMode = 0 Then
		Return SetError(1, 0, 0)
	EndIf
	
	;$oContainer = ObjGet("new:{C08AFD90-F2A1-11D1-8455-00A0C91F3880}")
	$oContainer = ObjCreate("InternetExplorer.Application")
   
	If Not IsObj($oContainer) Then
		Return SetError(3, 0, 0)
	EndIf
	
	$oContainer.StatusBar = True ; IMPORTANT!!
	$oContainer.StatusText = $sName
	
	Return $oContainer
EndFunc

Func _Container_Close($oContainer)
	Local $iRet = 0
	Local $hContainer = HWnd($oContainer.HWnd)
	
	If $hContainer Then
		$iRet = WinClose($hContainer)
	EndIf
	
	Return SetError(Number($iRet <> 1), 0, $iRet)
EndFunc

Func _Container_PutProperty($oContainer, $sVarName, $vValue)
	If Not IsObj($oContainer) Then
		Return SetError(1, 0, 0)
	EndIf
	
	$oContainer.PutProperty($sVarName, $vValue)
EndFunc

Func _Container_GetProperty($oContainer, $sVarName)
	If Not IsObj($oContainer) Then
		Return SetError(1, 0, 0)
	EndIf
	
	Return $oContainer.GetProperty($sVarName)
EndFunc

Func __Container_COMErrHandler()
	SetError(1)
Endfunc

Global $oContainer = _Container_Open("PI_Storage", 0)

#EndRegion Container UDF

$sFunc_Name = _Container_GetProperty($oContainer, "PI_Func_Name")
$sFunc_Params = _Container_GetProperty($oContainer, "PI_Func_Params")

$vReturn = Call($sFunc_Name, $sFunc_Params)
_Container_PutProperty($oContainer, "PI_Func_Return", $vReturn)

While _Container_GetProperty($oContainer, "PI_Func_Return") <> ''
	Sleep(10)
WEnd

;==== UDFs Part ====

Func Some_UDF($sParams)
	Local $iRet = MsgBox(36, @ScriptName & " - Question", $sParams)
	Return $iRet
EndFunc
