#pragma compile(Out, MyApp.exe)
#pragma compile(UPX, True)
#pragma compile(Compression, 9)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, MyApp)
#pragma compile(FileDescription, A short description of the program)
#pragma compile(LegalCopyright,  G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)
#pragma compile(Sign, G.Sandler)

#include <GUIConstantsEx.au3>
#include 'AppCheckUpdates.au3'

$APPCU_7ZIP					= @ScriptDir & '\Resources\7z.exe'
$APPCU_DAT_URL 				= 'http://creator-lab.ucoz.ru/Testing_Zone/MyApp_Update.dat'
$APPCU_APP_NAME 			= 'My App'
$APPCU_APP_VER 				= _GetResData('FileVersion')

Global $sConfig_File 		= @ScriptDir & '\Config.ini'

Global $iUpdate_Check 		= Int(IniRead($sConfig_File, 'Update', 'Check Update', 1))
Global $iUpdate_Interval 	= Int(IniRead($sConfig_File, 'Update', 'Update Interval', 72)) ;In hours
Global $iUpdate_Last_Check 	= Int(IniRead($sConfig_File, 'Update', 'Last Update Check', 0))

#Region GUI Part

$hGUI = GUICreate('My Application - v' & $APPCU_APP_VER, 300, 200)

$CheckUpdates_Button = GUICtrlCreateButton('Check Updates', 200, 170, 90, 20)
$Exit_Button = GUICtrlCreateButton('Exit', 20, 170, 60, 20)

GUISetState(@SW_SHOW, $hGUI)

#EndRegion GUI Part

;Check update according to config settings
If $iUpdate_Check And (Not $iUpdate_Last_Check Or (TimerDiff($iUpdate_Last_Check) / 1000 / 60 / 60) >= $iUpdate_Interval) Then
	IniWrite($sConfig_File, 'Update', 'Last Update Check', TimerInit())
	
	;Here we check in quit mode (only if new version available there will be a message)
	_AppCheckUpdates($hGUI, 1, 1, 'English')
EndIf

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE, $Exit_Button
			Exit
		Case $CheckUpdates_Button
			$iPID = _AppCheckUpdates($hGUI, -1, 1, 'English')
			ProcessWaitClose($iPID)
			$iError = Number(StdoutRead($iPID))
			
			If $iError Then
				MsgBox(64, $APPCU_APP_NAME, 'Error returned from _AppCheckUpdates: ' & $iError, 0, $hGUI)
			EndIf
	EndSwitch
WEnd

Func _GetResData($sRes)
	If @Compiled Then
		Return FileGetVersion(@AutoItExe, $sRes)
	EndIf
	
	Local $sRet = StringRegExpReplace(FileRead(@ScriptFullPath), '(?si)^.*?#pragma compile\(' & $sRes & ', [''"]?(.*?)[''"]?\)\r\n.*$', '\1')
	
	If @extended = 0 Then
		$sRet = StringRegExpReplace(FileRead(@ScriptFullPath), '(?si)^.*?#AutoIt3Wrapper_Res_' & $sRes & '=([^\r\n]+).*$', '\1')
		
		If @extended = 0 Then
			Return $sRes
		EndIf
	EndIf
	
	Return StringStripWS($sRet, 3)
EndFunc
