#include <Marker.au3>
#include <Array.au3>

Global $sOutput = ''

_Example1()
MsgBox(64, 'Example 1', $sOutput)

$sOutput = ''
_Example2()
MsgBox(64, 'Example 2', $sOutput)

Func _Example1()
	Local Static $oMarker = _Marker_Create('MyMarker')
	
	If @error Then
		Return 0
	EndIf
	
	_Marker_Add($oMarker, 'Counter', 0)
	_Marker_SetValue($oMarker, 'Counter', $oMarker('Counter') + 1)
	
	Local $iCounter = _Marker_GetValue($oMarker, 'Counter')
	
	If _Marker_Exists($oMarker, 'Flag1') Then
		_Marker_Delete($oMarker, 'Flag1')
		$sOutput &= 'Function call #' & $iCounter & ': Flag1 deleted' & @CRLF
		_Example1()
		Return
	ElseIf _Marker_Exists($oMarker, 'Flag2') Then
		_Marker_Delete($oMarker, 'Flag2')
		$sOutput &= 'Function call #' & $iCounter & ': Flag2 deleted' & @CRLF & @CRLF
		Return
	EndIf
	
	_Marker_Add($oMarker, 'Flag1')
	_Marker_Add($oMarker, 'Flag2')
	
	$sOutput &= 'Function call #' & $iCounter & ': Flag1 and Flag2 created...' & @CRLF
	
	_Example1()
EndFunc

Func _Example2()
	Local $oMarker1 = _Marker_Create('MyMarker1')
	Local $oMarker2 = _Marker_Create('MyMarker2')
	
	Local $aArray[2] = [1, 'Element']
	
	_Marker_Add($oMarker1, 'Item1', 'Marker1, Item1')
	_Marker_Add($oMarker1, 'Item2', 'Marker1, Item2')
	_Marker_Add($oMarker1, 'Item3', 'Marker1, Item3')
	
	_Marker_Add($oMarker2, 'Item1', 'Marker2, Item1')
	_Marker_Add($oMarker2, 'Item2', 'Marker2, Item2')
	_Marker_Add($oMarker2, 'Item3', $aArray)
	
	$sOutput &= 'Count $oMarker1 (before delete): ' & _Marker_GetCount($oMarker1) & @CRLF
	$sOutput &= '"Marker1, Item2" exists in $oMarker1? (before delete): ' & _Marker_Exists($oMarker1, 'Item2') & @CRLF
	_Marker_Delete($oMarker1, 'Item2')
	$sOutput &= '"Marker1, Item2" exists in $oMarker1? (after delete): ' & _Marker_Exists($oMarker1, 'Item2') & @CRLF
	$sOutput &= '$oMarker1 count (after delete): ' & _Marker_GetCount($oMarker1) & @CRLF & @CRLF
	
	_Marker_Destroy($oMarker1)
	
	$aArray = $oMarker2('Item3')
	$sOutput &= 'Type and size of "Item3" in $oMarker2 (before replace): ' & VarGetType($aArray) & '(' & UBound($aArray) & ')' & @CRLF
	_ArrayDisplay($aArray)
	_Marker_SetValue($oMarker2, 'Item3', 'Marker2, Item3')
	$sOutput &= 'New type and value of Item3 in $oMarker2 (after replace): ' & VarGetType($oMarker2('Item3')) & '("' & _Marker_GetValue($oMarker2, 'Item1') & '")' & @CRLF & @CRLF
	$sOutput &= 'Name of $oMarker2: ' & _Marker_GetMarkerName($oMarker2) & @CRLF
EndFunc
