#include <GUIDynamicMenu.au3>

Global $sMenu_File = @ScriptDir & '\Menu.ini'

Global $hGUI, $iToggleHKGlobal_CB, $iMenuIconSize_Combo
Global $iAutoItOnWeb_Menu, $iAutoItForums_Bttn, $iOther_Bttn, $iSelfHandled_Bttn
Global $hAutoItOnWeb_Menu, $hAutoItForums_Menu, $hOther_Menu, $hSelfHandled_Menu
Global $hAutoItOnWeb_DM, $hAutoItForums_DM, $hOther_DM, $hSelfHandled_DM

$hGUI = GUICreate('GUIDynamicMenu Example', 360, 200)

$iAutoItOnWeb_Menu = GUICtrlCreateMenu('AutoIt On the web')
$iAutoItForums_Bttn = GUICtrlCreateButton('AutoIt Forums', 20, 20, 80, 30)
$iOther_Bttn = GUICtrlCreateButton('Other', 140, 20, 80, 30)
$iSelfHandled_Bttn = GUICtrlCreateButton('Self handled', 260, 20, 80, 30)

_GUICtrlDynamicMenu_SetHotKeysGlobal(True)
_GUICtrlDynamicMenu_SetIconSize(16)

;Load menus (False to ignore Reload, only load)
_LoadMenu(False)

$iToggleHKGlobal_CB = GUICtrlCreateCheckbox('HotKeys are global (unless set otherwise from the menu item)', 20, 80)
GUICtrlSetState($iToggleHKGlobal_CB, $GUI_CHECKED)

GUICtrlCreateLabel('Menu icon size:', 20, 123)
$iMenuIconSize_Combo = GUICtrlCreateCombo('', 120, 120, 50, 20, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
GUICtrlSetData($iMenuIconSize_Combo, '16|20|24|28|32|36|40|48', '20')

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			GUISetState(@SW_HIDE, $hGUI)
			
			_GUICtrlDynamicMenu_Destroy($hAutoItOnWeb_DM)
			_GUICtrlDynamicMenu_Destroy($hAutoItForums_DM)
			_GUICtrlDynamicMenu_Destroy($hOther_DM)
			_GUICtrlDynamicMenu_Destroy($hSelfHandled_DM)
			
			Exit
		Case $iAutoItForums_Bttn
			_GUICtrlDynamicMenu_Show($hGUI, $hAutoItForums_Menu, $iAutoItForums_Bttn)
		Case $iOther_Bttn
			_GUICtrlDynamicMenu_Show($hGUI, $hOther_Menu, $iOther_Bttn)
		Case $iSelfHandled_Bttn
			$iIdentifier = _GUICtrlDynamicMenu_Show($hGUI, $hSelfHandled_Menu, $iSelfHandled_Bttn, False, 2)
			$aInfo = _GUICtrlDynamicMenu_GetInfo($hSelfHandled_DM, $iIdentifier)
			
			If Not @error Then
				_ArrayDisplay($aInfo)
				ShellExecute($aInfo[$GDM_INFO_PATH])
			EndIf
		Case $iToggleHKGlobal_CB
			_GUICtrlDynamicMenu_SetHotKeysGlobal((GUICtrlRead($iToggleHKGlobal_CB) = $GUI_CHECKED))
		Case $iMenuIconSize_Combo
			_GUICtrlDynamicMenu_SetIconSize(GUICtrlRead($iMenuIconSize_Combo))
			
			GUISetState(@SW_DISABLE, $hGUI)
			
			;Reload the menu to apply changes
			_LoadMenu(True)
			
			GUISetState(@SW_ENABLE, $hGUI)
	EndSwitch
WEnd

Func _LoadMenu($fReload = False)
	If $fReload Then
		;Since it's standard gui menu, should be unloaded only, not destroyed
		_GUICtrlDynamicMenu_UnLoad($hAutoItOnWeb_DM)
		
		_GUICtrlDynamicMenu_Destroy($hAutoItForums_DM)
		_GUICtrlDynamicMenu_Destroy($hOther_DM)
		_GUICtrlDynamicMenu_Destroy($hSelfHandled_DM)
	EndIf
	
	;Since it's standard gui menu, should be created only once
	If Not $hAutoItOnWeb_Menu Then
		$hAutoItOnWeb_Menu = _GUICtrlDynamicMenu_Create($iAutoItOnWeb_Menu)
	EndIf
	
	$hAutoItForums_Menu = _GUICtrlDynamicMenu_Create()
	$hOther_Menu = _GUICtrlDynamicMenu_Create()
	$hSelfHandled_Menu = _GUICtrlDynamicMenu_Create()
	
	$hAutoItOnWeb_DM = _GUICtrlDynamicMenu_Load($hGUI, $hAutoItOnWeb_Menu, $sMenu_File, 'AutoIt On The Web Menu')
	$hAutoItForums_DM = _GUICtrlDynamicMenu_Load($hGUI, $hAutoItForums_Menu, $sMenu_File, 'AutoIt Forums Menu')
	$hOther_DM = _GUICtrlDynamicMenu_Load($hGUI, $hOther_Menu, $sMenu_File, 'Other Menu')
	$hSelfHandled_DM = _GUICtrlDynamicMenu_Load($hGUI, $hSelfHandled_Menu, $sMenu_File, 'Self Handled Menu')
EndFunc
