#pragma compile(Icon, Icon.ico)
#pragma compile(ExecLevel, HighestAvailable)
#pragma compile(UPX, True)
#pragma compile(Stripper, True)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, FindEx)
#pragma compile(FileDescription, Find & Replace in includes extension for SciTE)
#pragma compile(LegalCopyright,  G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)
#pragma compile(Sign, G.Sandler)

#Au3Stripper_Ignore_Funcs=_FindReplaceProc

#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <APIDlgConstants.au3>
#include <WindowsConstants.au3>
#include <WinAPISys.au3>
#include <WinAPIEx.au3>
#include <GUIEdit.au3>
#include <Array.au3>
#include <File.au3>
#include <SciTE.au3>

Global Const $hSCITE_WND = WinGetHandle('[CLASS:SciTEWindow]')

If Not IsHWnd($hSCITE_WND) Then
	Exit MsgBox(16, @ScriptName, 'Run only from SciTE editor.')
EndIf

_SciTE_SetMainPID(WinGetProcess($hSCITE_WND))

Global $sSel_Text = _SciTE_GetProperty('CurrentSelection')
Global $sScript_File = _SciTE_GetCurrentFile()
Global $sAutoIt_Dir = _SciTE_ExpandProperties(_SciTE_GetProperty('AutoIt3Dir'))
Global $sScript_Dir = _PathFull($sScript_File & '\..')
Global $aInclude_Dirs = StringSplit(_PathFull($sAutoIt_Dir & '\Include') & ';' & RegRead('HKCU\Software\AutoIt v3\AutoIt', 'Include'), ';')

Global $aIncludes[2] = [1, $sScript_File]
_GetIncludes($sScript_File, $aIncludes)

_FindReplaceDialog($sSel_Text, '_FindReplaceProc', $hSCITE_WND)

Func _FindReplaceDialog($sFind, $sCallProc, $hParent)
	Local $iGUI_W = 433, $iGUI_H = 236
	Local $hGUI, $iFind_Input, $iReplace_Input, $iMatchWholeWord_CB, $iCaseSensitive_CB, $iRegExp_CB
	Local $iFindNext_Bttn, $iReplace_Bttn, $iReplaceAll_Bttn, $iClose_Bttn
	Local $iMsg, $sReplace, $iFlags = 0
	
	$hGUI = GUICreate('Find & Replace (FindEx)', $iGUI_W, $iGUI_H, -1, -1, -1, $WS_EX_TOOLWINDOW, $hParent)
	
	GUICtrlCreateLabel('Find what:', 10, 13)
	$iFind_Input = GUICtrlCreateInput($sFind, 100, 11, 180, 20)
	
	GUICtrlCreateLabel('Replace with:', 10, 43)
	$iReplace_Input = GUICtrlCreateInput('', 100, 41, 180, 20)
	
	$iMatchWholeWord_CB = GUICtrlCreateCheckbox('Match whole word only', 10, 110)
	$iCaseSensitive_CB = GUICtrlCreateCheckbox('Case sensitive', 10, 135)
	$iRegExp_CB = GUICtrlCreateCheckbox('Regular expression', 10, 160)
	
	GUICtrlCreateLabel('Replacements:', 10, $iGUI_H - 30, 100)
	$iReplacements_Lbl = GUICtrlCreateLabel('0', 110, $iGUI_H - 30, 100)
	
	$iFindNext_Bttn = GUICtrlCreateButton('Find next', $iGUI_W - 148, 10, 135, 23)
	GUICtrlSetState(-1, $GUI_DEFBUTTON)
	$iReplace_Bttn = GUICtrlCreateButton('Replace', $iGUI_W - 148, 40, 135, 23)
	$iReplaceAll_Bttn = GUICtrlCreateButton('Replace all', $iGUI_W - 148, 70, 135, 23)
	
	$iClose_Bttn = GUICtrlCreateButton('Close', $iGUI_W - 148, $iGUI_H - 35, 135, 23)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $GUI_EVENT_CLOSE, $iClose_Bttn
				Exit
			Case $iFindNext_Bttn, $iReplace_Bttn, $iReplaceAll_Bttn
				$sFind = GUICtrlRead($iFind_Input)
				$sReplace = GUICtrlRead($iReplace_Input)
				
				If $sFind = '' Then
					ContinueLoop
				EndIf
				
				Switch $iMsg
					Case $iFindNext_Bttn
						$iEvent = $FR_FINDNEXT
					Case $iReplace_Bttn
						$iEvent = $FR_REPLACE
					Case $iReplaceAll_Bttn
						$iEvent = $FR_REPLACEALL
				EndSwitch
				
				If GUICtrlRead($iMatchWholeWord_CB) = $GUI_CHECKED Then
					$iFlags = $SCFIND_WHOLEWORD
				EndIf
				
				If GUICtrlRead($iCaseSensitive_CB) = $GUI_CHECKED Then
					$iFlags = BitOR($iFlags, $SCFIND_MATCHCASE)
				EndIf
				
				If GUICtrlRead($iRegExp_CB) = $GUI_CHECKED Then
					$iFlags = BitOR($iFlags, $SCFIND_REGEXP)
				EndIf
				
				$iReplacements = Call($sCallProc, $hGUI, $iEvent, $iFlags, $sFind, $sReplace)
				
				Switch $iReplacements
					Case 0
						MsgBox(48, 'SciTE', "Can not find the string '" & $sFind & "'", 0, $hGUI)
					Case Else
						If $iReplacements > 0 Then
							GUICtrlSetData($iReplacements_Lbl, $iReplacements)
						EndIf
				EndSwitch
		EndSwitch
		
		If Not WinExists($hSCITE_WND) Then
			Exit
		EndIf
	WEnd
EndFunc

Func _FindReplaceProc($hWnd, $iEvent, $iFlags, $sFind, $sReplace)
	Local $iWholeWord =  Number(BitAND($iFlags, $SCFIND_WHOLEWORD) = $SCFIND_WHOLEWORD)
	Local $iCase = Number(BitAND($iFlags, $SCFIND_MATCHCASE) = $SCFIND_MATCHCASE)
	Local $iRegExp =  Number(BitAND($iFlags, $SCFIND_REGEXP) = $SCFIND_REGEXP)
	
	Local $sRead, $iPos, $iStart
	
	;Get index of current file
	$iStart = _ArraySearch($aIncludes, _SciTE_GetCurrentFile(), 1, 0, 0, 2)
	
	;If not found or found last index, set to 0 to search from the begining
	If $iStart = -1 Or $iStart = $aIncludes[0] Then
		$iStart = 0
	EndIf
	
	Switch $iEvent
		Case $FR_FINDNEXT, $FR_REPLACE
			$iPos = -1
			
			If $iEvent = $FR_REPLACE Then
				$iPos = -2
			EndIf
			
			;Search in current document
			_SciTE_FindText($sFind, $iFlags, $iPos, False)
			
			;Found
			If Not @error Then
				If $iEvent = $FR_FINDNEXT Then
					Return -1
				EndIf
				
				;Replace found text
				_SciTE_ReplaceSelection($sReplace)
				
				;Call $FR_FINDNEXT to search next after replacement
				Return _FindReplaceProc($hWnd, $FR_FINDNEXT, $iFlags, $sFind, $sReplace)
			EndIf
			
			;Save all opened buffers (to allow proper FileRead return)
			_SciTE_MenuCommand('IDM_SAVEALL')
			
			For $x = 1 To 2
				;Search from next file
				For $i = $iStart + 1 To $aIncludes[0]
					$sRead = FileRead($aIncludes[$i])
					$iPos = _StringInStrEx($sRead, $sFind, $iCase, $iWholeWord, $iRegExp)
					
					;If found in include text open the include file and find text
					If $iPos Then
						
						_SciTE_OpenFile($aIncludes[$i])
						_SciTE_FindText($sFind, $iFlags, 0, False)
						
						;Found
						If Not @error Then
							If $iEvent = $FR_FINDNEXT Then
								Return -1
							EndIf
							
							;Replace found text
							_SciTE_ReplaceSelection($sReplace)
							
							;Call $FR_FINDNEXT to search next after replacement
							Return _FindReplaceProc($hWnd, $FR_FINDNEXT, $iFlags, $sFind, $sReplace)
						EndIf
					EndIf
				Next
				
				If $iStart = 0 Then
					ExitLoop
				EndIf
				
				$iStart = 0
			Next
			
			Return 0
		Case $FR_REPLACEALL
			Local $iFound = 0
			
			;Save all opened buffers (to allow proper FileRead return)
			_SciTE_MenuCommand('IDM_SAVEALL')
			
			For $i = 1 To $aIncludes[0]
				$sRead = FileRead($aIncludes[$i])
				$iPos = _StringInStrEx($sRead, $sFind, $iCase, $iWholeWord, $iRegExp)
				
				;If found in include text open the include file and replace all text in it
				If $iPos Then
					_SciTE_OpenFile($aIncludes[$i])
					
					$iFound += _SciTE_ReplaceAll($sFind, $sReplace, $iFlags)
					$iStart = $i
				EndIf
			Next
			
			Return $iFound
	EndSwitch
EndFunc

Func _StringInStrEx($sStr, $sSubStr, $iCaseSense = 0, $iMathWholeWord = 0, $iRegExp = 0, $iOccurense = 1, $iStart = 1)
	$iCaseSense = Int($iCaseSense)
	$iMathWholeWord = Int($iMathWholeWord)
	$iOccurense = Int($iOccurense)
	
	If $iCaseSense = 0 Then
		$iCaseSense = 2
	EndIf
	
	If $iOccurense < 1 Then
		$iOccurense = 1
	EndIf
	
	If $iRegExp Then
		Local $sPattern = ($iCaseSense ? '' : '(?i)') & ($iMathWholeWord ? '\b' : '') & $sSubStr & ($iMathWholeWord ? '\b' : '')
		Local $aRet, $iC
		
		While 1
			$aRet = StringRegExp($sStr, $sPattern, 2, $iStart)
			
			If Not @extended Then
				Return SetError(1, 0, 0)
			EndIf
			
			$iStart = @extended
			$iC += 1
			
			If $iC = $iOccurense Then
				Return $iStart - StringLen($aRet[0])
			EndIf
		WEnd
	EndIf
	
	If Not $iMathWholeWord Then
		Return StringInStr($sStr, $sSubStr, $iCaseSense, $iOccurense, $iStart)
	EndIf
	
	Local $iPos, $sLChar, $sRChar, $iSubStrLen = StringLen($sSubStr)
	
	While 1
		$iPos = StringInStr($sStr, $sSubStr, $iCaseSense, $iOccurense, $iStart)
		
		If Not $iPos Then
			Return SetError(1, 0, 0)
		EndIf
		
		$sLChar = StringMid($sStr, $iPos - 1, 1)
		$sRChar = StringMid($sStr, $iPos + $iSubStrLen, 1)
		
		If StringRegExp($sLChar, '\B') And StringRegExp($sRChar, '\B') Then
			Return $iPos
		EndIf
		
		$iStart = $iPos + $iSubStrLen
	WEnd
EndFunc

Func _GetIncludes($sScript_File, ByRef $aIncludes)
	Local $sRead = FileRead($sScript_File)
	Local $aTmp_Includes = StringRegExp($sRead, '(?i)(?:\R|\A)\h*#include \h*(?:<([^>]+)>|"([^"]+)"|''([^'']+)'')', 3)
	Local $sInclude_File
	
	For $i = 0 To UBound($aTmp_Includes) - 1
		$sInclude_File = StringStripWS($aTmp_Includes[$i], 3)
		
		If $sInclude_File = '' Then
			ContinueLoop
		EndIf
		
		If FileExists($sScript_Dir & '\' & $sInclude_File) Then
			$sInclude_File = $sScript_Dir & '\' & $sInclude_File
		EndIf
		
		For $j = 1 To $aInclude_Dirs[0]
			$aInclude_Dirs[$j] = StringStripWS($aInclude_Dirs[$j], 3)
			
			If $aInclude_Dirs[$j] = '' Then
				ContinueLoop
			EndIf
			
			If FileExists($aInclude_Dirs[$j] & '\' & $sInclude_File) Then
				$sInclude_File = $aInclude_Dirs[$j] & '\' & $sInclude_File
				ExitLoop
			EndIf
		Next
		
		If Not FileExists($sInclude_File) Then
			ContinueLoop
		EndIf
		
		If _ArraySearch($aIncludes, $sInclude_File, 1, 0, 0, 2) = -1 Then
			$aIncludes[0] += 1
			ReDim $aIncludes[$aIncludes[0] + 1]
			$aIncludes[$aIncludes[0]] = $sInclude_File
			
			_GetIncludes($sInclude_File, $aIncludes)
		EndIf
	Next
EndFunc
