#Region Header

#cs

    Title:          WinAPI Extended UDF Library for AutoIt3
    Filename:       WinAPIEx.au3
    Description:    Additional variables, constants and functions for the WinAPI.au3
    Author:         Yashied
    Version:        3.7 / 3.3.6.1
    Requirements:   AutoIt v3.3 +, Developed/Tested on Windows XP Pro Service Pack 2 and Windows Vista/7
    Uses:           StructureConstants.au3, WinAPI.au3
    Note:           The library uses the following system DLLs:

                    Advapi32.dll
                    Comctl32.dll
                    Comdlg32.dll
                    Connect.dll
                    Credui.dll
                    Dbghelp.dll
                    Dwmapi.dll
                    Gdi32.dll
                    Gdiplus.dll
                    Kernel32.dll
                    Ntdll.dll
                    Ole32.dll
                    Oleaut32.dll
                    Powrprof.dll
                    Psapi.dll
                    Sensapi.dll
                    Sfc.dll
                    Shell32.dll
                    Shlwapi.dll
                    User32.dll
                    Userenv.dll
                    Uxtheme.dll
                    Version.dll
                    Winmm.dll
                    Winspool.drv

    Available functions:

    _WinAPI_AbortPath
    _WinAPI_AboutDlg
    _WinAPI_ActivateKeyboardLayout
    _WinAPI_AddClipboardFormatListener
    _WinAPI_AddFontMemResourceEx
    _WinAPI_AddFontResourceEx
    _WinAPI_AddIconOverlay
    _WinAPI_AddIconTransparency
    _WinAPI_AddMRUString
    _WinAPI_AdjustBitmap
    _WinAPI_AdjustTokenPrivileges
    _WinAPI_AdjustWindowRectEx
    _WinAPI_AlphaBlend
    _WinAPI_AngleArc
    _WinAPI_AnimateWindow
    _WinAPI_Arc
    _WinAPI_ArcTo
    _WinAPI_ArrayToStruct
    _WinAPI_AssignProcessToJobObject
    _WinAPI_AssocGetPerceivedType
    _WinAPI_AssocQueryString
    _WinAPI_BackupRead
    _WinAPI_BackupReadAbort
    _WinAPI_BackupSeek
    _WinAPI_BackupWrite
    _WinAPI_BackupWriteAbort
    _WinAPI_BeginBufferedPaint
    _WinAPI_BeginDeferWindowPos
    _WinAPI_BeginPaint
    _WinAPI_BeginPath
    _WinAPI_BeginUpdateResource
    _WinAPI_BringWindowToTop
    _WinAPI_BroadcastSystemMessage
    _WinAPI_BrowseForFolderDlg
    _WinAPI_BufferedPaintClear
    _WinAPI_BufferedPaintInit
    _WinAPI_BufferedPaintSetAlpha
    _WinAPI_BufferedPaintUnInit
    _WinAPI_CalculatePopupWindowPosition
    _WinAPI_CallWindowProcW
    _WinAPI_CascadeWindows
    _WinAPI_ChangeWindowMessageFilterEx
    _WinAPI_CharToOem
    _WinAPI_ChildWindowFromPointEx
    _WinAPI_ClipCursor
    _WinAPI_CloseDesktop
    _WinAPI_CloseEnhMetaFile
    _WinAPI_CloseFigure
    _WinAPI_CloseThemeData
    _WinAPI_CloseWindow
    _WinAPI_CloseWindowStation
    _WinAPI_CoInitialize
    _WinAPI_ColorAdjustLuma
    _WinAPI_ColorHLSToRGB
    _WinAPI_ColorRGBToHLS
    _WinAPI_CombineTransform
    _WinAPI_CommandLineToArgv
    _WinAPI_CommDlgExtendedErrorEx
    _WinAPI_CompareString
    _WinAPI_CompressBitmapBits
    _WinAPI_CompressBuffer
    _WinAPI_ComputeCrc32
    _WinAPI_ConfirmCredentials
    _WinAPI_CopyBitmap
    _WinAPI_CopyCursor
    _WinAPI_CopyEnhMetaFile
    _WinAPI_CopyFileEx
    _WinAPI_CopyImage
    _WinAPI_CopyRect
    _WinAPI_CopyStruct
    _WinAPI_CoTaskMemAlloc
    _WinAPI_CoTaskMemFree
    _WinAPI_CoTaskMemRealloc
    _WinAPI_CoUninitialize
    _WinAPI_Create32BitHBITMAP
    _WinAPI_Create32BitHICON
    _WinAPI_CreateANDBitmap
    _WinAPI_CreateBitmapIndirect
    _WinAPI_CreateBrushIndirect
    _WinAPI_CreateBuffer
    _WinAPI_CreateCaret
    _WinAPI_CreateColorAdjustment
    _WinAPI_CreateCompatibleBitmapEx
    _WinAPI_CreateDesktop
    _WinAPI_CreateDIB
    _WinAPI_CreateDIBColorTable
    _WinAPI_CreateDIBitmap
    _WinAPI_CreateDIBSection
    _WinAPI_CreateDirectory
    _WinAPI_CreateDirectoryEx
    _WinAPI_CreateEllipticRgn
    _WinAPI_CreateEmptyIcon
    _WinAPI_CreateEnhMetaFile
    _WinAPI_CreateFileEx
    _WinAPI_CreateFileMapping
    _WinAPI_CreateGUID
    _WinAPI_CreateHardLink
    _WinAPI_CreateIcon
    _WinAPI_CreateIconFromResourceEx
    _WinAPI_CreateIconIndirect
    _WinAPI_CreateJobObject
    _WinAPI_CreateMargins
    _WinAPI_CreateMRUList
    _WinAPI_CreateMutex
    _WinAPI_CreateNullRgn
    _WinAPI_CreateNumberFormatInfo
    _WinAPI_CreateObjectID
    _WinAPI_CreatePoint
    _WinAPI_CreatePolygonRgn
    _WinAPI_CreateProcessWithToken
    _WinAPI_CreateRect
    _WinAPI_CreateRectEx
    _WinAPI_CreateRectRgnIndirect
    _WinAPI_CreateSemaphore
    _WinAPI_CreateSize
    _WinAPI_CreateStreamOnHGlobal
    _WinAPI_CreateString
    _WinAPI_CreateSymbolicLink
    _WinAPI_CreateTransform
    _WinAPI_CreateWindowStation
    _WinAPI_DecompressBuffer
    _WinAPI_DecryptFile
    _WinAPI_DeferWindowPos
    _WinAPI_DefineDosDevice
    _WinAPI_DefRawInputProc
    _WinAPI_DefSubclassProc
    _WinAPI_DefWindowProcW
    _WinAPI_DeleteEnhMetaFile
    _WinAPI_DeleteFile
    _WinAPI_DeleteObjectID
    _WinAPI_DeleteVolumeMountPoint
    _WinAPI_DeregisterShellHookWindow
    _WinAPI_DestroyCaret
    _WinAPI_DestroyCursor
    _WinAPI_DeviceIoControl
    _WinAPI_DisplayStruct
    _WinAPI_DllGetVersion
    _WinAPI_DllInstall
    _WinAPI_DllUninstall
    _WinAPI_DPtoLP
    _WinAPI_DragAcceptFiles
    _WinAPI_DragFinish
    _WinAPI_DragQueryFileEx
    _WinAPI_DragQueryPoint
    _WinAPI_DrawAnimatedRects
    _WinAPI_DrawBitmap
    _WinAPI_DrawFocusRect
    _WinAPI_DrawShadowText
    _WinAPI_DrawThemeBackground
    _WinAPI_DrawThemeEdge
    _WinAPI_DrawThemeIcon
    _WinAPI_DrawThemeParentBackground
    _WinAPI_DrawThemeText
    _WinAPI_DrawThemeTextEx
    _WinAPI_DuplicateEncryptionInfoFile
    _WinAPI_DuplicateHandle
    _WinAPI_DuplicateTokenEx
    _WinAPI_DwmEnableBlurBehindWindow
    _WinAPI_DwmEnableComposition
    _WinAPI_DwmGetColorizationColor
    _WinAPI_DwmGetWindowAttribute
    _WinAPI_DwmExtendFrameIntoClientArea
    _WinAPI_DwmInvalidateIconicBitmaps
    _WinAPI_DwmIsCompositionEnabled
    _WinAPI_DwmQueryThumbnailSourceSize
    _WinAPI_DwmRegisterThumbnail
    _WinAPI_DwmSetIconicLivePreviewBitmap
    _WinAPI_DwmSetIconicThumbnail
    _WinAPI_DwmSetWindowAttribute
    _WinAPI_DwmUnregisterThumbnail
    _WinAPI_DwmUpdateThumbnailProperties
    _WinAPI_DWordToFloat
    _WinAPI_DWordToInt
    _WinAPI_EjectMedia
    _WinAPI_Ellipse
    _WinAPI_EmptyWorkingSet
    _WinAPI_EncryptFile
    _WinAPI_EncryptionDisable
    _WinAPI_EndBufferedPaint
    _WinAPI_EndDeferWindowPos
    _WinAPI_EndPaint
    _WinAPI_EndPath
    _WinAPI_EndUpdateResource
    _WinAPI_EnumChildProcess
    _WinAPI_EnumChildWindows
    _WinAPI_EnumDesktops
    _WinAPI_EnumDesktopWindows
    _WinAPI_EnumDeviceDrivers
    _WinAPI_EnumDisplayMonitors
    _WinAPI_EnumDisplaySettings
    _WinAPI_EnumDllProc
    _WinAPI_EnumFiles
    _WinAPI_EnumFileStreams
    _WinAPI_EnumHardLinks
    _WinAPI_EnumMRUList
    _WinAPI_EnumPageFiles
    _WinAPI_EnumProcessHandles
    _WinAPI_EnumProcessModules
    _WinAPI_EnumProcessThreads
    _WinAPI_EnumProcessWindows
    _WinAPI_EnumRawInputDevices
    _WinAPI_EnumResourceLanguages
    _WinAPI_EnumResourceNames
    _WinAPI_EnumResourceTypes
    _WinAPI_EnumSystemGeoID
    _WinAPI_EnumSystemLocales
    _WinAPI_EnumUILanguages
    _WinAPI_EnumWindowStations
    _WinAPI_EqualMemory
    _WinAPI_EqualRect
    _WinAPI_EqualRgn
    _WinAPI_ExcludeClipRect
    _WinAPI_ExtCreatePen
    _WinAPI_ExtCreateRegion
    _WinAPI_ExtFloodFill
    _WinAPI_ExtractIcon
    _WinAPI_ExtSelectClipRgn
    _WinAPI_FatalExit
    _WinAPI_FileEncryptionStatus
    _WinAPI_FileExists
    _WinAPI_FileInUse
    _WinAPI_FillMemory
    _WinAPI_FillPath
   *_WinAPI_FillRect
    _WinAPI_FillRgn
    _WinAPI_FindClose
    _WinAPI_FindCloseChangeNotification
    _WinAPI_FindFirstChangeNotification
    _WinAPI_FindFirstFile
    _WinAPI_FindFirstFileName
    _WinAPI_FindFirstStream
    _WinAPI_FindNextChangeNotification
    _WinAPI_FindNextFile
    _WinAPI_FindNextFileName
    _WinAPI_FindNextStream
    _WinAPI_FindResource
    _WinAPI_FindResourceEx
    _WinAPI_FindTextDlg
    _WinAPI_FlattenPath
    _WinAPI_FloatToDWord
    _WinAPI_FlushFRBuffer
    _WinAPI_FlushViewOfFile
    _WinAPI_FormatDriveDlg
   *_WinAPI_FrameRect
    _WinAPI_FrameRgn
    _WinAPI_FreeMemory
    _WinAPI_FreeMRUList
    _WinAPI_FreeResource
    _WinAPI_GdiComment
    _WinAPI_GetActiveWindow
    _WinAPI_GetAllUsersProfileDirectory
    _WinAPI_GetApplicationRestartSettings
    _WinAPI_GetArcDirection
   *_WinAPI_GetAsyncKeyState
    _WinAPI_GetBinaryType
    _WinAPI_GetBitmapBits
    _WinAPI_GetBitmapDimension
    _WinAPI_GetBitmapDimensionEx
    _WinAPI_GetBkColor
    _WinAPI_GetBoundsRect
    _WinAPI_GetBufferedPaintBits
    _WinAPI_GetBufferedPaintDC
    _WinAPI_GetBufferedPaintTargetDC
    _WinAPI_GetBufferedPaintTargetRect
    _WinAPI_GetBValue
    _WinAPI_GetCaretBlinkTime
    _WinAPI_GetCaretPos
    _WinAPI_GetCDType
    _WinAPI_GetClassInfoEx
    _WinAPI_GetClassLongEx
    _WinAPI_GetClipboardSequenceNumber
    _WinAPI_GetClipBox
    _WinAPI_GetClipCursor
    _WinAPI_GetClipRgn
    _WinAPI_GetColorAdjustment
    _WinAPI_GetCompressedFileSize
    _WinAPI_GetCompression
    _WinAPI_GetConnectedDlg
    _WinAPI_GetCurrentDirectory
    _WinAPI_GetCurrentHwProfile
    _WinAPI_GetCurrentObject
    _WinAPI_GetCurrentPosition
    _WinAPI_GetCurrentProcessExplicitAppUserModelID
    _WinAPI_GetCurrentThemeName
    _WinAPI_GetCursor
    _WinAPI_GetDateFormat
    _WinAPI_GetDCEx
    _WinAPI_GetDefaultPrinter
    _WinAPI_GetDefaultUserProfileDirectory
    _WinAPI_GetDeviceDriverBaseName
    _WinAPI_GetDeviceDriverFileName
    _WinAPI_GetDeviceGammaRamp
    _WinAPI_GetDIBColorTable
    _WinAPI_GetDiskFreeSpaceEx
    _WinAPI_GetDllDirectory
    _WinAPI_GetDriveBusType
    _WinAPI_GetDriveGeometryEx
    _WinAPI_GetDriveNumber
    _WinAPI_GetDriveType
    _WinAPI_GetDurationFormat
    _WinAPI_GetEnhMetaFile
    _WinAPI_GetEnhMetaFileBits
    _WinAPI_GetEnhMetaFileDescription
    _WinAPI_GetEnhMetaFileDimension
    _WinAPI_GetEnhMetaFileHeader
    _WinAPI_GetErrorMessage
    _WinAPI_GetErrorMode
    _WinAPI_GetExitCodeProcess
    _WinAPI_GetExtended
    _WinAPI_GetFileAttributes
    _WinAPI_GetFileID
    _WinAPI_GetFileInformationByHandle
    _WinAPI_GetFileInformationByHandleEx
    _WinAPI_GetFilePointerEx
    _WinAPI_GetFileSizeOnDisk
    _WinAPI_GetFileTitle
    _WinAPI_GetFileType
    _WinAPI_GetFileVersionInfo
    _WinAPI_GetFinalPathNameByHandle
    _WinAPI_GetFinalPathNameByHandleEx
    _WinAPI_GetFontResourceInfo
   *_WinAPI_GetForegroundWindow
    _WinAPI_GetFRBuffer
    _WinAPI_GetFullPathName
    _WinAPI_GetGeoInfo
    _WinAPI_GetGlyphOutline
    _WinAPI_GetGraphicsMode
    _WinAPI_GetGUIThreadInfo
    _WinAPI_GetGValue
    _WinAPI_GetHandleInformation
    _WinAPI_GetHGlobalFromStream
    _WinAPI_GetIconDimension
    _WinAPI_GetIconInfoEx
    _WinAPI_GetIdleTime
    _WinAPI_GetKeyboardLayout
    _WinAPI_GetKeyboardLayoutList
    _WinAPI_GetKeyboardState
    _WinAPI_GetKeyboardType
    _WinAPI_GetKeyNameText
    _WinAPI_GetKeyState
    _WinAPI_GetLastActivePopup
   *_WinAPI_GetLayeredWindowAttributes
    _WinAPI_GetLocaleInfo
    _WinAPI_GetLogicalDrives
    _WinAPI_GetMapMode
    _WinAPI_GetMemorySize
    _WinAPI_GetMessageExtraInfo
    _WinAPI_GetModuleFileNameEx
    _WinAPI_GetModuleHandleEx
    _WinAPI_GetModuleInformation
    _WinAPI_GetMonitorInfo
    _WinAPI_GetNumberFormat
    _WinAPI_GetObjectID
    _WinAPI_GetObjectInfoByHandle
    _WinAPI_GetObjectNameByHandle
    _WinAPI_GetObjectType
    _WinAPI_GetOutlineTextMetrics
    _WinAPI_GetParentProcess
    _WinAPI_GetPerformanceInfo
    _WinAPI_GetPhysicallyInstalledSystemMemory
    _WinAPI_GetPixel
    _WinAPI_GetPolyFillMode
    _WinAPI_GetPosFromRect
    _WinAPI_GetPriorityClass
    _WinAPI_GetProcAddress
    _WinAPI_GetProcessCommandLine
    _WinAPI_GetProcessFileName
    _WinAPI_GetProcessHandleCount
    _WinAPI_GetProcessID
    _WinAPI_GetProcessIoCounters
    _WinAPI_GetProcessMemoryInfo
    _WinAPI_GetProcessName
    _WinAPI_GetProcessShutdownParameters
    _WinAPI_GetProcessTimes
    _WinAPI_GetProcessUser
    _WinAPI_GetProcessWindowStation
    _WinAPI_GetProcessWorkingDirectory
    _WinAPI_GetProfilesDirectory
    _WinAPI_GetPwrCapabilities
    _WinAPI_GetRawInputBuffer
    _WinAPI_GetRawInputBufferLength
    _WinAPI_GetRawInputData
    _WinAPI_GetRawInputDeviceInfo
    _WinAPI_GetRegionData
    _WinAPI_GetRegisteredRawInputDevices
    _WinAPI_GetRegKeyNameByHandle
    _WinAPI_GetRgnBox
    _WinAPI_GetROP2
    _WinAPI_GetRValue
    _WinAPI_GetShellWindow
    _WinAPI_GetStartupInfo
    _WinAPI_GetStretchBltMode
    _WinAPI_GetString
    _WinAPI_GetSystemDefaultLangID
    _WinAPI_GetSystemDefaultLCID
    _WinAPI_GetSystemDefaultUILanguage
    _WinAPI_GetSystemDEPPolicy
    _WinAPI_GetSystemInfo
    _WinAPI_GetSystemPowerStatus
    _WinAPI_GetSystemTimes
    _WinAPI_GetSystemWow64Directory
    _WinAPI_GetTempFileName
    _WinAPI_GetTextAlign
    _WinAPI_GetTextCharacterExtra
    _WinAPI_GetTextColor
    _WinAPI_GetTextFace
   *_WinAPI_GetTextMetrics
    _WinAPI_GetThemeAppProperties
    _WinAPI_GetThemeBackgroundContentRect
    _WinAPI_GetThemeBackgroundExtent
    _WinAPI_GetThemeBackgroundRegion
    _WinAPI_GetThemeBitmap
    _WinAPI_GetThemeBool
    _WinAPI_GetThemeColor
    _WinAPI_GetThemeDocumentationProperty
    _WinAPI_GetThemeEnumValue
    _WinAPI_GetThemeFilename
    _WinAPI_GetThemeFont
    _WinAPI_GetThemeInt
    _WinAPI_GetThemeMargins
    _WinAPI_GetThemeMetric
    _WinAPI_GetThemePartSize
    _WinAPI_GetThemePosition
    _WinAPI_GetThemePropertyOrigin
    _WinAPI_GetThemeRect
    _WinAPI_GetThemeString
    _WinAPI_GetThemeSysBool
    _WinAPI_GetThemeSysColor
    _WinAPI_GetThemeSysColorBrush
    _WinAPI_GetThemeSysFont
    _WinAPI_GetThemeSysInt
    _WinAPI_GetThemeSysSize
    _WinAPI_GetThemeSysString
    _WinAPI_GetThemeTextExtent
    _WinAPI_GetThemeTextMetrics
    _WinAPI_GetThemeTransitionDuration
    _WinAPI_GetThreadDesktop
    _WinAPI_GetThreadErrorMode
    _WinAPI_GetThreadLocale
    _WinAPI_GetThreadUILanguage
    _WinAPI_GetTickCount
    _WinAPI_GetTickCount64
    _WinAPI_GetTimeFormat
    _WinAPI_GetTopWindow
    _WinAPI_GetUDFColorMode
    _WinAPI_GetUDFVersion
    _WinAPI_GetUpdateRect
    _WinAPI_GetUpdateRgn
    _WinAPI_GetUserDefaultLangID
    _WinAPI_GetUserDefaultLCID
    _WinAPI_GetUserDefaultUILanguage
    _WinAPI_GetUserGeoID
    _WinAPI_GetUserObjectInformation
    _WinAPI_GetVersion
    _WinAPI_GetVersionEx
    _WinAPI_GetVolumeInformation
    _WinAPI_GetVolumeInformationByHandle
    _WinAPI_GetVolumeNameForVolumeMountPoint
    _WinAPI_GetWindowDisplayAffinity
    _WinAPI_GetWindowExt
    _WinAPI_GetWindowFileName
    _WinAPI_GetWindowInfo
    _WinAPI_GetWindowLongEx
    _WinAPI_GetWindowOrg
    _WinAPI_GetWindowRgnBox
    _WinAPI_GetWindowSubclass
    _WinAPI_GetWindowTheme
    _WinAPI_GetWorkArea
    _WinAPI_GetWorldTransform
    _WinAPI_GradientFill
    _WinAPI_HashData
    _WinAPI_HashString
    _WinAPI_Hex64
    _WinAPI_HiByte
    _WinAPI_HideCaret
    _WinAPI_HiDWord
    _WinAPI_InflateRect
    _WinAPI_IntersectClipRect
    _WinAPI_IntersectRect
    _WinAPI_IntToDWord
   *_WinAPI_InvalidateRect
    _WinAPI_InvalidateRgn
    _WinAPI_InvertANDBitmap
    _WinAPI_InvertColor
    _WinAPI_InvertRect
    _WinAPI_InvertRgn
    _WinAPI_IOCTL
    _WinAPI_IsAlphaBitmap
    _WinAPI_IsBadCodePtr
    _WinAPI_IsBadReadPtr
    _WinAPI_IsBadStringPtr
    _WinAPI_IsBadWritePtr
    _WinAPI_IsChild
    _WinAPI_IsDoorOpen
    _WinAPI_IsElevated
    _WinAPI_IsHungAppWindow
    _WinAPI_IsIconic
    _WinAPI_IsInternetConnected
    _WinAPI_IsLoadKBLayout
    _WinAPI_IsMemory
    _WinAPI_IsNetworkAlive
    _WinAPI_IsProcessInJob
    _WinAPI_IsProcessorFeaturePresent
    _WinAPI_IsRectEmpty
    _WinAPI_IsThemeActive
    _WinAPI_IsThemeBackgroundPartiallyTransparent
    _WinAPI_IsThemePartDefined
    _WinAPI_IsValidLocale
    _WinAPI_IsWindowEnabled
    _WinAPI_IsWindowUnicode
    _WinAPI_IsWow64Process
    _WinAPI_IsWritable
    _WinAPI_IsZoomed
    _WinAPI_Keybd_Event
    _WinAPI_KillTimer
    _WinAPI_LineDDA
    _WinAPI_LoadCursor
    _WinAPI_LoadCursorFromFile
    _WinAPI_LoadIconWithScaleDown
    _WinAPI_LoadIndirectString
    _WinAPI_LoadKeyboardLayout
    _WinAPI_LoadMedia
    _WinAPI_LoadResource
    _WinAPI_LoadStringEx
    _WinAPI_LoByte
    _WinAPI_LockDevice
    _WinAPI_LockFile
    _WinAPI_LockResource
    _WinAPI_LockWindowUpdate
    _WinAPI_LockWorkStation
    _WinAPI_LoDWord
    _WinAPI_LongMid
    _WinAPI_LookupIconIdFromDirectoryEx
    _WinAPI_LPtoDP
    _WinAPI_MakeWord
    _WinAPI_MapViewOfFile
    _WinAPI_MapVirtualKey
    _WinAPI_MaskBlt
    _WinAPI_MessageBoxCheck
    _WinAPI_MessageBoxIndirect
    _WinAPI_ModifyWorldTransform
    _WinAPI_MonitorFromPoint
    _WinAPI_MonitorFromRect
    _WinAPI_MonitorFromWindow
    _WinAPI_MoveFileEx
    _WinAPI_MoveMemory
    _WinAPI_MoveToEx
    _WinAPI_NtStatusToDosError
    _WinAPI_OemToChar
    _WinAPI_OffsetClipRgn
    _WinAPI_OffsetPoints
    _WinAPI_OffsetRect
    _WinAPI_OffsetRgn
    _WinAPI_OffsetWindowOrg
    _WinAPI_OpenDesktop
    _WinAPI_OpenFileById
    _WinAPI_OpenFileMapping
    _WinAPI_OpenIcon
    _WinAPI_OpenInputDesktop
    _WinAPI_OpenJobObject
    _WinAPI_OpenMutex
    _WinAPI_OpenProcessToken
    _WinAPI_OpenSemaphore
    _WinAPI_OpenThemeData
    _WinAPI_OpenWindowStation
    _WinAPI_PageSetupDlg
    _WinAPI_PaintDesktop
    _WinAPI_PaintRgn
    _WinAPI_ParseURL
    _WinAPI_ParseUserName
    _WinAPI_PatBlt
    _WinAPI_PathAddBackslash
    _WinAPI_PathAddExtension
    _WinAPI_PathAppend
    _WinAPI_PathBuildRoot
    _WinAPI_PathCanonicalize
    _WinAPI_PathCommonPrefix
    _WinAPI_PathCompactPath
    _WinAPI_PathCompactPathEx
    _WinAPI_PathCreateFromUrl
    _WinAPI_PathFindExtension
    _WinAPI_PathFindFileName
    _WinAPI_PathFindNextComponent
   *_WinAPI_PathFindOnPath
    _WinAPI_PathGetArgs
    _WinAPI_PathGetCharType
    _WinAPI_PathGetDriveNumber
    _WinAPI_PathIsContentType
    _WinAPI_PathIsDirectory
    _WinAPI_PathIsDirectoryEmpty
    _WinAPI_PathIsExe
    _WinAPI_PathIsFileSpec
    _WinAPI_PathIsLFNFileSpec
    _WinAPI_PathIsRelative
    _WinAPI_PathIsRoot
    _WinAPI_PathIsSameRoot
    _WinAPI_PathIsSystemFolder
    _WinAPI_PathIsUNC
    _WinAPI_PathIsUNCServer
    _WinAPI_PathIsUNCServerShare
    _WinAPI_PathMakeSystemFolder
    _WinAPI_PathMatchSpec
    _WinAPI_PathParseIconLocation
    _WinAPI_PathRelativePathTo
    _WinAPI_PathRemoveArgs
    _WinAPI_PathRemoveBackslash
    _WinAPI_PathRemoveExtension
    _WinAPI_PathRemoveFileSpec
    _WinAPI_PathRenameExtension
    _WinAPI_PathSearchAndQualify
    _WinAPI_PathSkipRoot
    _WinAPI_PathStripPath
    _WinAPI_PathStripToRoot
    _WinAPI_PathToRegion
    _WinAPI_PathUndecorate
    _WinAPI_PathUnExpandEnvStrings
    _WinAPI_PathUnmakeSystemFolder
    _WinAPI_PathUnquoteSpaces
    _WinAPI_PathYetAnotherMakeUniqueName
    _WinAPI_PickIconDlg
    _WinAPI_PlayEnhMetaFile
    _WinAPI_PlaySound
    _WinAPI_PlgBlt
    _WinAPI_PolyBezier
    _WinAPI_PolyBezierTo
    _WinAPI_PolyDraw
    _WinAPI_Polygon
    _WinAPI_PrintDlg
    _WinAPI_PrintDlgEx
    _WinAPI_PrintWindow
    _WinAPI_PtInRectEx
    _WinAPI_PtInRegion
    _WinAPI_PtVisible
    _WinAPI_QueryDosDevice
    _WinAPI_QueryInformationJobObject
    _WinAPI_QueryPerformanceCounter
    _WinAPI_QueryPerformanceFrequency
    _WinAPI_RadialGradientFill
    _WinAPI_ReadDirectoryChanges
    _WinAPI_Rectangle
    _WinAPI_RectInRegion
    _WinAPI_RectVisible
    _WinAPI_RegCloseKey
    _WinAPI_RegConnectRegistry
    _WinAPI_RegCopyTree
    _WinAPI_RegCopyTreeEx
    _WinAPI_RegCreateKey
    _WinAPI_RegDeleteEmptyKey
    _WinAPI_RegDeleteKey
    _WinAPI_RegDeleteKeyValue
    _WinAPI_RegDeleteTree
    _WinAPI_RegDeleteTreeEx
    _WinAPI_RegDeleteValue
    _WinAPI_RegDisableReflectionKey
    _WinAPI_RegDuplicateHKey
    _WinAPI_RegEnableReflectionKey
    _WinAPI_RegEnumKey
    _WinAPI_RegEnumValue
    _WinAPI_RegFlushKey
    _WinAPI_RegisterApplicationRestart
    _WinAPI_RegisterClassEx
    _WinAPI_RegisterHotKey
    _WinAPI_RegisterPowerSettingNotification
    _WinAPI_RegisterRawInputDevices
    _WinAPI_RegisterShellHookWindow
    _WinAPI_RegLoadMUIString
    _WinAPI_RegNotifyChangeKeyValue
    _WinAPI_RegOpenKey
    _WinAPI_RegQueryInfoKey
    _WinAPI_RegQueryLastWriteTime
    _WinAPI_RegQueryMultipleValues
    _WinAPI_RegQueryReflectionKey
    _WinAPI_RegQueryValue
    _WinAPI_RegRestoreKey
    _WinAPI_RegSaveKey
    _WinAPI_RegSetValue
    _WinAPI_ReleaseMutex
    _WinAPI_ReleaseSemaphore
    _WinAPI_ReleaseStream
    _WinAPI_RemoveClipboardFormatListener
    _WinAPI_RemoveDirectory
    _WinAPI_RemoveFontMemResourceEx
    _WinAPI_RemoveFontResourceEx
    _WinAPI_RemoveWindowSubclass
    _WinAPI_ReOpenFile
    _WinAPI_ReplaceFile
    _WinAPI_ReplaceTextDlg
    _WinAPI_ResetEvent
    _WinAPI_RestartDlg
    _WinAPI_RestoreDC
    _WinAPI_RGB
    _WinAPI_RotatePoints
    _WinAPI_RoundRect
    _WinAPI_SaveDC
    _WinAPI_SaveHBITMAPToFile
    _WinAPI_SaveHICONToFile
    _WinAPI_ScaleWindowExt
    _WinAPI_SelectClipPath
    _WinAPI_SelectClipRgn
    _WinAPI_SendMessageTimeout
    _WinAPI_SetActiveWindow
    _WinAPI_SetArcDirection
    _WinAPI_SetBitmapBits
    _WinAPI_SetBitmapDimensionEx
    _WinAPI_SetBoundsRect
    _WinAPI_SetClassLongEx
    _WinAPI_SetColorAdjustment
    _WinAPI_SetCompression
    _WinAPI_SetCaretBlinkTime
    _WinAPI_SetCaretPos
    _WinAPI_SetCurrentDirectory
    _WinAPI_SetCurrentProcessExplicitAppUserModelID
    _WinAPI_SetDCBrushColor
    _WinAPI_SetDCPenColor
   *_WinAPI_SetDefaultPrinter
    _WinAPI_SetDeviceGammaRamp
    _WinAPI_SetDIBColorTable
    _WinAPI_SetDIBitsToDevice
    _WinAPI_SetDllDirectory
    _WinAPI_SetEnhMetaFileBits
    _WinAPI_SetErrorMode
    _WinAPI_SetFileAttributes
    _WinAPI_SetFileInformationByHandleEx
    _WinAPI_SetFilePointerEx
    _WinAPI_SetFileShortName
    _WinAPI_SetForegroundWindow
    _WinAPI_SetFRBuffer
    _WinAPI_SetGraphicsMode
   *_WinAPI_SetHandleInformation
    _WinAPI_SetInformationJobObject
    _WinAPI_SetKeyboardLayout
    _WinAPI_SetKeyboardState
   *_WinAPI_SetLayeredWindowAttributes
    _WinAPI_SetLocaleInfo
    _WinAPI_SetMapMode
    _WinAPI_SetMessageExtraInfo
   *_WinAPI_SetParent
    _WinAPI_SetPixel
    _WinAPI_SetPolyFillMode
    _WinAPI_SetPriorityClass
    _WinAPI_SetProcessShutdownParameters
    _WinAPI_SetProcessWindowStation
    _WinAPI_SetRectRgn
    _WinAPI_SetROP2
    _WinAPI_SetStretchBltMode
    _WinAPI_SetSystemCursor
    _WinAPI_SetTextAlign
    _WinAPI_SetTextCharacterExtra
    _WinAPI_SetTextJustification
    _WinAPI_SetThemeAppProperties
    _WinAPI_SetThreadDesktop
    _WinAPI_SetThreadErrorMode
    _WinAPI_SetThreadExecutionState
    _WinAPI_SetThreadLocale
    _WinAPI_SetThreadUILanguage
    _WinAPI_SetTimer
    _WinAPI_SetUDFColorMode
    _WinAPI_SetUserGeoID
    _WinAPI_SetUserObjectInformation
    _WinAPI_SetVolumeMountPoint
    _WinAPI_SetWindowDisplayAffinity
    _WinAPI_SetWindowExt
    _WinAPI_SetWindowLongEx
    _WinAPI_SetWindowOrg
    _WinAPI_SetWindowSubclass
    _WinAPI_SetWindowTheme
    _WinAPI_SetWinEventHook
    _WinAPI_SetWorldTransform
    _WinAPI_SfcIsFileProtected
    _WinAPI_SfcIsKeyProtected
    _WinAPI_ShellAddToRecentDocs
    _WinAPI_ShellChangeNotify
    _WinAPI_ShellChangeNotifyDeregister
    _WinAPI_ShellChangeNotifyRegister
    _WinAPI_ShellEmptyRecycleBin
    _WinAPI_ShellExecute
    _WinAPI_ShellExtractAssociatedIcon
    _WinAPI_ShellExtractIcon
    _WinAPI_ShellFileOperation
    _WinAPI_ShellGetFileInfo
    _WinAPI_ShellGetKnownFolderPath
    _WinAPI_ShellGetLocalizedName
    _WinAPI_ShellGetPathFromIDList
    _WinAPI_ShellGetSetFolderCustomSettings
    _WinAPI_ShellGetSettings
    _WinAPI_ShellGetSpecialFolderLocation
    _WinAPI_ShellGetSpecialFolderPath
    _WinAPI_ShellGetStockIconInfo
    _WinAPI_ShellILCreateFromPath
    _WinAPI_ShellNotifyIcon
    _WinAPI_ShellNotifyIconGetRect
    _WinAPI_ShellObjectProperties
    _WinAPI_ShellOpenFolderAndSelectItems
    _WinAPI_ShellOpenWithDlg
    _WinAPI_ShellQueryRecycleBin
    _WinAPI_ShellQueryUserNotificationState
    _WinAPI_ShellRemoveLocalizedName
    _WinAPI_ShellRestricted
    _WinAPI_ShellSetLocalizedName
    _WinAPI_ShellSetSettings
    _WinAPI_ShellStartNetConnectionDlg
    _WinAPI_ShellUserAuthenticationDlg
    _WinAPI_ShellUserAuthenticationDlgEx
    _WinAPI_ShortToWord
    _WinAPI_ShowCaret
    _WinAPI_ShowLastError
    _WinAPI_ShowOwnedPopups
    _WinAPI_ShutdownBlockReasonCreate
    _WinAPI_ShutdownBlockReasonDestroy
    _WinAPI_ShutdownBlockReasonQuery
    _WinAPI_SizeOfResource
    _WinAPI_StretchBlt
    _WinAPI_StretchDIBits
    _WinAPI_StrFormatByteSize
    _WinAPI_StrFormatByteSizeEx
    _WinAPI_StrFormatKBSize
    _WinAPI_StrFromTimeInterval
    _WinAPI_StrLen
    _WinAPI_StrokeAndFillPath
    _WinAPI_StrokePath
    _WinAPI_StructToArray
    _WinAPI_SubtractRect
    _WinAPI_SwitchColor
    _WinAPI_SwitchDesktop
    _WinAPI_SwitchToThisWindow
    _WinAPI_SwapDWord
    _WinAPI_SwapQWord
    _WinAPI_SwapWord
    _WinAPI_TextOut
    _WinAPI_TileWindows
    _WinAPI_TransparentBlt
    _WinAPI_TrackMouseEvent
    _WinAPI_UnhookWinEvent
    _WinAPI_UnionRect
    _WinAPI_UnionStruct
    _WinAPI_UniqueHardwareID
    _WinAPI_UnloadKeyboardLayout
    _WinAPI_UnlockFile
    _WinAPI_UnmapViewOfFile
    _WinAPI_UnregisterApplicationRestart
    _WinAPI_UnregisterClass
    _WinAPI_UnregisterHotKey
    _WinAPI_UnregisterPowerSettingNotification
    _WinAPI_UpdateLayeredWindowEx
    _WinAPI_UpdateResource
    _WinAPI_UrlApplyScheme
    _WinAPI_UrlCanonicalize
    _WinAPI_UrlCombine
    _WinAPI_UrlCompare
    _WinAPI_UrlCreateFromPath
    _WinAPI_UrlFixup
    _WinAPI_UrlGetPart
    _WinAPI_UrlHash
    _WinAPI_UrlIs
    _WinAPI_ValidateRect
    _WinAPI_ValidateRgn
    _WinAPI_VerQueryRoot
    _WinAPI_VerQueryValue
    _WinAPI_VerQueryValueEx
    _WinAPI_WidenPath
    _WinAPI_WindowFromDC
    _WinAPI_WordToShort
    _WinAPI_Wow64EnableWow64FsRedirection
    _WinAPI_ZeroMemory

   * Included in WinAPI.au3

#ce

#Include-once

#Include <StructureConstants.au3>
#Include <WinAPI.au3>

#EndRegion Header

#Region Initialization

Global Const $__WINVER = __Ver()
Global Const $__UDFVER = '3.7'

#EndRegion Initialization

#Region Global Variables and Constants

Global Const $tagBITMAP = 'long bmType;long bmWidth;long bmHeight;long bmWidthBytes;ushort bmPlanes;ushort bmBitsPixel;ptr bmBits;'
Global Const $tagBITMAPINFOHEADER = 'dword biSize;long biWidth;long biHeight;ushort biPlanes;ushort biBitCount;dword biCompression;dword biSizeImage;long biXPelsPerMeter;long biYPelsPerMeter;dword biClrUsed;dword biClrImportant;'
Global Const $tagBITMAPV4HEADER = 'dword bV4Size;long bV4Width;long bV4Height;ushort bV4Planes;ushort bV4BitCount;dword bV4Compression;dword bV4SizeImage;long bV4XPelsPerMeter;long bV4YPelsPerMeter;dword bV4ClrUsed;dword bV4ClrImportant;dword bV4RedMask;dword bV4GreenMask;dword bV4BlueMask;dword bV4AlphaMask;dword bV4CSType;int bV4Endpoints[3];dword bV4GammaRed;dword bV4GammaGreen;dword bV4GammaBlue;'
Global Const $tagBITMAPV5HEADER = 'dword bV5Size;long bV5Width;long bV5Height;ushort bV5Planes;ushort bV5BitCount;dword bV5Compression;dword bV5SizeImage;long bV5XPelsPerMeter;long bV5YPelsPerMeter;dword bV5ClrUsed;dword bV5ClrImportant;dword bV5RedMask;dword bV5GreenMask;dword bV5BlueMask;dword bV5AlphaMask;dword bV5CSType;int bV5Endpoints[3];dword bV5GammaRed;dword bV5GammaGreen;dword bV5GammaBlue;dword bV5Intent;dword bV5ProfileData;dword bV5ProfileSize;dword bV5Reserved;'
;Global Const $tagBITMAPINFO = $tagBITMAPINFOHEADER & 'dword bmiColors[n];'
Global Const $tagCOLORADJUSTMENT = 'ushort Size;ushort Flags;ushort IlluminantIndex;ushort RedGamma;ushort GreenGamma;ushort BlueGamma;ushort ReferenceBlack;ushort ReferenceWhite;short Contrast;short Brightness;short Colorfulness;short RedGreenTint;'
Global Const $tagDEVMODE_DISPLAY = 'wchar DeviceName[32];ushort SpecVersion;ushort DriverVersion;ushort Size;ushort DriverExtra;dword Fields;' & $tagPOINT & ';dword DisplayOrientation;dword DisplayFixedOutput;short Unused1[5];wchar Unused2[32];ushort LogPixels;dword BitsPerPel;dword PelsWidth;dword PelsHeight;dword DisplayFlags;dword DisplayFrequency;'
Global Const $tagDEVMODE_PRINTER = 'wchar DeviceName[32];ushort SpecVersion;ushort DriverVersion;ushort Size;ushort DriverExtra;dword Fields;short Orientation;short PaperSize;short PaperLength;short PaperWidth;short Scale;short Copies;short DefaultSource;short PrintQuality;short Color;short Duplex;short YResolution;short TTOption;short Collate;wchar FormName[32];ushort Unused1;dword Unused2[3];dword Nup;dword Unused3;dword ICMMethod;dword ICMIntent;dword MediaType;dword DitherType;dword Reserved1;dword Reserved2;dword PanningWidth;dword PanningHeight;'
Global Const $tagDEVNAMES = 'ushort DriverOffset;ushort DeviceOffset;ushort OutputOffset;ushort Default;'
Global Const $tagDIBSECTION = $tagBITMAP & $tagBITMAPINFOHEADER & 'dword dsBitfields[3];ptr dshSection;dword dsOffset;'
Global Const $tagDTTOPTS = 'dword Size;dword Flags;dword clrText;dword clrBorder;dword clrShadow;int TextShadowType;' & $tagPOINT & ';int BorderSize;int FontPropId;int ColorPropId;int StateId;int ApplyOverlay;int GlowSize;ptr DrawTextCallback;lparam lParam;'
Global Const $tagENHMETAHEADER = 'dword Type;dword Size;long rcBounds[4];long rcFrame[4];dword Signature;dword Version;dword Bytes;dword Records;ushort Handles;ushort Reserved;dword Description;dword OffDescription;dword PalEntries;long Device[2];long Millimeters[2];dword PixelFormat;dword OffPixelFormat;dword OpenGL;long Micrometers[2];'
Global Const $tagEXTLOGPEN = 'dword PenStyle;dword Width;uint BrushStyle;dword Color;ulong_ptr Hatch;dword NumEntries;' ; & 'dword StyleEntry[n];'
Global Const $tagFILE_ID_DESCRIPTOR = 'dword Size;uint Type;' & $tagGUID & ';'
Global Const $tagFILEINFO = 'uint64 CreationTime;uint64 LastAccessTime;uint64 LastWriteTime;uint64 ChangeTime;dword Attributes;'
Global Const $tagFINDREPLACE = 'dword Size;hwnd hOwner;ptr hInstance;dword Flags;ptr FindWhat;ptr ReplaceWith;ushort FindWhatLen;ushort ReplaceWithLen;lparam lParam;ptr Hook;ptr TemplateName;'
Global Const $tagGLYPHMETRICS = 'uint BlackBoxX;uint BlackBoxY;' & $tagPOINT & ';short CellIncX;short CellIncY;'
;Global Const $tagGUITHREADINFO = 'dword Size;dword Flags;hwnd hWndActive;hwnd hWndFocus;hwnd hWndCapture;hwnd hWndMenuOwner;hwnd hWndMoveSize;hwnd hWndCaret;long rcCaret[4];'
;Global Const $tagICONINFO = 'int Icon;dword xHotspot;dword yHotspot;ptr hMask;ptr hColor;'
Global Const $tagIO_COUNTERS = 'uint64 ReadOperationCount;uint64 WriteOperationCount;uint64 OtherOperationCount;uint64 ReadTransferCount;uint64 WriteTransferCount;uint64 OtherTransferCount;'
Global Const $tagJOBOBJECT_ASSOCIATE_COMPLETION_PORT = 'ulong_ptr CompletionKey;ptr CompletionPort;'
Global Const $tagJOBOBJECT_BASIC_ACCOUNTING_INFORMATION = 'int64 TotalUserTime;int64 TotalKernelTime;int64 ThisPeriodTotalUserTime;int64 ThisPeriodTotalKernelTime;dword TotalPageFaultCount;dword TotalProcesses;dword ActiveProcesses;dword TotalTerminatedProcesses;'
Global Const $tagJOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION = $tagJOBOBJECT_BASIC_ACCOUNTING_INFORMATION & $tagIO_COUNTERS
Global Const $tagJOBOBJECT_BASIC_LIMIT_INFORMATION = 'int64 PerProcessUserTimeLimit;int64 PerJobUserTimeLimit;dword LimitFlags;ulong_ptr MinimumWorkingSetSize;ulong_ptr MaximumWorkingSetSize;dword ActiveProcessLimit;ulong_ptr Affinity;dword PriorityClass;dword SchedulingClass;'
Global Const $tagJOBOBJECT_BASIC_PROCESS_ID_LIST = 'dword NumberOfAssignedProcesses;dword NumberOfProcessIdsInList;' ; & 'ulong_ptr ProcessIdList[n];'
Global Const $tagJOBOBJECT_BASIC_UI_RESTRICTIONS = 'dword UIRestrictionsClass;'
Global Const $tagJOBOBJECT_END_OF_JOB_TIME_INFORMATION = 'dword EndOfJobTimeAction;'
Global Const $tagJOBOBJECT_EXTENDED_LIMIT_INFORMATION = $tagJOBOBJECT_BASIC_LIMIT_INFORMATION & $tagIO_COUNTERS & 'ulong_ptr ProcessMemoryLimit;ulong_ptr JobMemoryLimit;ulong_ptr PeakProcessMemoryUsed;ulong_ptr PeakJobMemoryUsed;'
Global Const $tagJOBOBJECT_GROUP_INFORMATION = '' ; & 'ushort ProcessorGroup[n];'
Global Const $tagJOBOBJECT_SECURITY_LIMIT_INFORMATION = 'dword SecurityLimitFlags;ptr JobToken;ptr SidsToDisable;ptr PrivilegesToDelete;ptr RestrictedSids;'
Global Const $tagLOGBRUSH = 'uint Style;dword Color;ulong_ptr Hatch;'
Global Const $tagLOGPEN = 'uint Style;dword Width;dword Color;'
Global Const $tagMAT2 = 'short eM11[2];short eM12[2];short eM21[2];short eM22[2];'
Global Const $tagMODULEINFO = 'ptr BaseOfDll;dword SizeOfImage;ptr EntryPoint;'
Global Const $tagMSGBOXPARAMS = 'uint Size;hwnd hOwner;ptr hInstance;int_ptr Text;int_ptr Caption;dword Style;int_ptr Icon;dword_ptr ContextHelpId;ptr MsgBoxCallback;dword LanguageId;'
Global Const $tagNOTIFYICONDATA = 'dword Size;hwnd hWnd;uint ID;uint Flags;uint CallbackMessage;ptr hIcon;wchar Tip[128];dword State;dword StateMask;wchar Info[256];uint Version;wchar InfoTitle[64];dword InfoFlags;'
Global Const $tagNOTIFYICONDATA_V3 = $tagNOTIFYICONDATA & $tagGUID & ';'
Global Const $tagNOTIFYICONDATA_V4 = $tagNOTIFYICONDATA_V3 & 'ptr hBalloonIcon;'
Global Const $tagNUMBERFMT = 'uint NumDigits;uint LeadingZero;uint Grouping;ptr DecimalSep;ptr ThousandSep;uint NegativeOrder;' ; & 'wchar DecimalSepChars[n];wchar ThousandSepChars[n];'
Global Const $tagOSVERSIONINFO = 'dword OSVersionInfoSize;dword MajorVersion;dword MinorVersion;dword BuildNumber;dword PlatformId;wchar CSDVersion[128];'
Global Const $tagOSVERSIONINFOEX = $tagOSVERSIONINFO & 'ushort ServicePackMajor;ushort ServicePackMinor;ushort SuiteMask;byte ProductType;byte Reserved;'
Global Const $tagPAGESETUPDLG = 'dword Size;hwnd hOwner;ptr hDevMode;ptr hDevNames;dword Flags;long PaperWidth;long PaperHeight;long MarginMinLeft;long MarginMinTop;long MarginMinRight;long MarginMinBottom;long MarginLeft;long MarginTop;long MarginRight;long MarginBottom;ptr hInstance;lparam lParam;ptr PageSetupHook;ptr PagePaintHook;ptr PageSetupTemplateName;ptr hPageSetupTemplate;'
Global Const $tagPAINTSTRUCT = 'hwnd hDC;int fErase;dword rPaint[4];int fRestore;int fIncUpdate;byte rgbReserved[32];'
Global Const $tagPANOSE = 'byte bFamilyType;byte bSerifStyle;byte bWeight;byte bProportion;byte bContrast;byte bStrokeVariation;byte bArmStyle;byte bLetterform;byte bMidline;byte bXHeight;'
Global Const $tagPRINTDLG = 'align 2;dword_ptr Size;hwnd hOwner;ptr hDevMode;ptr hDevNames;hwnd hDC;dword Flags;ushort FromPage;ushort ToPage;ushort MinPage;ushort MaxPage;' & __Iif(@AutoItX64, 'uint', 'ushort') & ' Copies;ptr hInstance;lparam lParam;ptr PrintHook;ptr SetupHook;ptr PrintTemplateName;ptr SetupTemplateName;ptr hPrintTemplate;ptr hSetupTemplate;'
Global Const $tagPRINTDLGEX = 'dword Size;hwnd hOwner;ptr hDevMode;ptr hDevNames;hwnd hDC;dword Flags;dword Flags2;dword ExclusionFlags;dword NumPageRanges;dword MaxPageRanges;ptr PageRanges;dword MinPage;dword MaxPage;dword Copies;ptr hInstance;ptr PrintTemplateName;lparam lParam;dword NumPropertyPages;ptr hPropertyPages;dword StartPage;dword ResultAction;'
Global Const $tagPRINTPAGERANGE = 'dword FromPage;dword ToPage;'
Global Const $tagRAWINPUTDEVICE = 'ushort UsagePage;ushort Usage;dword Flags;hwnd hTarget;'
Global Const $tagRAWINPUTHEADER = 'dword Type;dword Size;ptr hDevice;wparam wParam;'
Global Const $tagRAWMOUSE = 'ushort Flags;ushort Alignment;ushort ButtonFlags;ushort ButtonData;ulong RawButtons;long LastX;long LastY;ulong ExtraInformation;'
Global Const $tagRAWKEYBOARD = 'ushort MakeCode;ushort Flags;ushort Reserved;ushort VKey;ushort;uint Message;ulong ExtraInformation;'
Global Const $tagRAWHID = 'dword SizeHid;dword Count;' ; & 'byte RawData[n];'
Global Const $tagRAWINPUTMOUSE = $tagRAWINPUTHEADER & $tagRAWMOUSE
Global Const $tagRAWINPUTKEYBOARD = $tagRAWINPUTHEADER & $tagRAWKEYBOARD
Global Const $tagRAWINPUTHID = $tagRAWINPUTHEADER & $tagRAWHID
Global Const $tagRGNDATAHEADER = 'dword Size;dword Type;dword Count;dword RgnSize;' & $tagRECT & ';'
;Global Const $tagRGNDATA = $tagRGNDATAHEADER ; & $tagRECT[n] & ';'
Global Const $tagRID_DEVICE_INFO_MOUSE = 'dword Id;dword NumberOfButtons;dword SampleRate;int HasHorizontalWheel;'
Global Const $tagRID_DEVICE_INFO_KEYBOARD = 'dword KbType;dword KbSubType;dword KeyboardMode;dword NumberOfFunctionKeys;dword NumberOfIndicators;dword NumberOfKeysTotal;'
Global Const $tagRID_DEVICE_INFO_HID = 'dword VendorId;dword ProductId;dword VersionNumber;ushort UsagePage;ushort Usage;'
Global Const $tagRID_INFO_MOUSE = 'dword Size;dword Type;' & $tagRID_DEVICE_INFO_MOUSE & 'dword Unused[2];'
Global Const $tagRID_INFO_KEYBOARD = 'dword Size;dword Type;' & $tagRID_DEVICE_INFO_KEYBOARD
Global Const $tagRID_INFO_HID = 'dword Size;dword Type;' & $tagRID_DEVICE_INFO_HID & 'dword Unused[2];'
Global Const $tagSHELLHOOKINFO = 'hwnd hWnd;' & $tagRECT & ';'
Global Const $tagSHFILEINFO = 'ptr hIcon;int iIcon;dword Attributes;wchar DisplayName[260];wchar TypeName[80];'
Global Const $tagSHFILEOPSTRUCT = 'hwnd hWnd;uint Func;ptr From;ptr To;dword Flags;int fAnyOperationsAborted;ptr hNameMappings;ptr ProgressTitle;'
Global Const $tagSHFOLDERCUSTOMSETTINGS = 'dword Size;dword Mask;ptr GUID;ptr WebViewTemplate;dword SizeWVT;ptr WebViewTemplateVersion;ptr InfoTip;dword SizeIT;ptr CLSID;dword Flags;ptr IconFile;dword SizeIF;int IconIndex;ptr Logo;dword SizeL;'
Global Const $tagSHSTOCKICONINFO = 'dword Size;ptr hIcon;int SysImageIndex;int iIcon;wchar Path[260];'
;Global Const $tagSTARTUPINFO = 'dword Size;ptr Reserved1;ptr Desktop;ptr Title;dword X;dword Y;dword XSize;dword YSize;dword XCountChars;dword YCountChars;dword FillAttribute;dword Flags;ushort ShowWindow;ushort Reserved2;ptr Reserved3;ptr hStdInput;ptr hStdOutput;ptr hStdError;'
;Global Const $tagTEXTMETRIC = 'long tmHeight;long tmAscent;long tmDescent;long tmInternalLeading;long tmExternalLeading;long tmAveCharWidth;long tmMaxCharWidth;long tmWeight;long tmOverhang;long tmDigitizedAspectX;long tmDigitizedAspectY;wchar tmFirstChar;wchar tmLastChar;wchar tmDefaultChar;wchar tmBreakChar;byte tmItalic;byte tmUnderlined;byte tmStruckOut;byte tmPitchAndFamily;byte tmCharSet;'
;Global Const $tagOUTLINETEXTMETRIC = 'uint otmSize;' & $tagTEXTMETRIC & 'byte otmFiller[4];' & $tagPANOSE & 'uint otmSelection;uint otmType;int otmCharSlopeRise;int otmCharSlopeRun;int otmItalicAngle;uint otmEMSquare;int otmAscent;int otmDescent;uint otmLineGap;uint otmCapEmHeight;uint otmXHeight;long otmFontBox[4];int otmMacAscent;int otmMacDescent;uint otmMacLineGap;uint otmMinimumPPEM;long otmSubscriptSize[2];long otmSubscriptOffset[2];long otmSuperscriptSize[2];long otmSuperscriptOffset[2];uint otmStrikeoutSize;int otmStrikeoutPosition;int otmUnderscoreSize;int otmUnderscorePosition;uint_ptr otmFamilyName;uint_ptr otmFaceName;uint_ptr otmStyleName;uint_ptr otmFullName;' ; & 'byte Data[n];'
Global Const $tagUSEROBJECTFLAGS = 'int Inherit;int Reserved;dword Flags;'
Global Const $tagVS_FIXEDFILEINFO = 'dword Signature;dword StrucVersion;dword FileVersionMS;dword FileVersionLS;dword ProductVersionMS;dword ProductVersionLS;dword FileFlagsMask;dword FileFlags;dword FileOS;dword FileType;dword FileSubtype;dword FileDateMS;dword FileDateLS;'
;Global Const $tagVS_VERSIONINFO = 'ushort Length;ushort ValueLength;ushort Type;wchar Key;ushort Padding1;' & $tagVS_FIXEDFILEINFO & 'ushort Padding2;ushort Children;'
;Global Const $tagWIN32_FIND_DATA = 'align 4;dword FileAttributes;uint64 CreationTime;uint64 LastAccessTime;uint64 LastWriteTime;dword FileSizeHigh;dword FileSizeLow;dword Reserved0;dword Reserved1;wchar FileName[260];wchar AlternateFileName[14];'
Global Const $tagWIN32_FIND_STREAM_DATA = 'int64 StreamSize;wchar StreamName[296];'
;Global Const $tagWIN32_STREAM_ID = 'dword StreamId;dword StreamAttributes;int64 Size;dword StreamNameSize;' ; & 'wchar StreamName[n];'
Global Const $tagWINDOWINFO = 'dword Size;dword rWindow[4];dword rClient[4];dword Style;dword ExStyle;dword WindowStatus;uint cxWindowBorders;uint cyWindowBorders;ushort atomWindowType;ushort CreatorVersion;'
Global Const $tagWNDCLASSEX = 'uint Size;uint Style;ptr hWndProc;int ClsExtra;int WndExtra;ptr hInstance;ptr hIcon;ptr hCursor;ptr hBackground;ptr MenuName;ptr ClassName;ptr hIconSm;'
Global Const $tagXFORM = 'float eM11;float eM12;float eM21;float eM22;float eDx;float eDy;'

#EndRegion Global Variables and Constants

#Region Local Variables and Constants

Global $__Data, $__Dlg, $__Dll = 0, $__Ext = 0, $__Val, $__Heap = 0, $__Text = 0, $__FR, $__Buff = 16385, $__Enum = 8388608, $__RGB = 1

#EndRegion Local Variables and Constants

#Region Public Functions

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AbortPath
; Description....: Closes and discards any paths in the specified device context.
; Syntax.........: _WinAPI_AbortPath ( $hDC )
; Parameters.....: $hDC    - Handle to the device context from which a path will be discarded.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ AbortPath
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AbortPath($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'AbortPath', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AbortPath

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AboutDlg
; Description....: Displays a Windows About dialog box.
; Syntax.........: _WinAPI_AboutDlg ( $sTitle, $sName, $sText [, $hIcon [, $hParent]] )
; Parameters.....: $sTitle  - The title of the Windows About dialog box.
;                  $sName   - The first line after the text "Microsoft".
;                  $sText   - The text to be displayed in the dialog box after the version and copyright information.
;                  $hIcon   - Handle to the icon that the function displays in the dialog box.
;                  $hParent - Handle to a parent window.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ShellAbout
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AboutDlg($sTitle, $sName, $sText, $hIcon = 0, $hParent = 0)

	Local $Ret = DllCall('shell32.dll', 'int', 'ShellAboutW', 'hwnd', $hParent, 'wstr', $sTitle & '#' & $sName, 'wstr', $sText, 'ptr', $hIcon)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AboutDlg

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ActivateKeyboardLayout
; Description....: Sets the input locale identifier for the calling thread or the current process.
; Syntax.........: _WinAPI_ActivateKeyboardLayout ( $hLocale [, $iFlag] )
; Parameters.....: $hLocale - The input locale identifier to be activated. This parameter must be either the handle to a keyboard
;                             layout or one of the following values.
;
;                             $HKL_NEXT
;                             $HKL_PREV
;
;                  $iFlag   - The flag that specifies how the input locale identifier is to be activated. This parameter can be
;                             one of the following values.
;
;                             $KLF_REORDER
;                             $KLF_RESET
;                             $KLF_SETFORPROCESS
;                             $KLF_SHIFTLOCK
;
; Return values..: Success  - The previous input locale identifier.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ActivateKeyboardLayout
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ActivateKeyboardLayout($hLocale, $iFlag = 0)

	Local $Ret = DllCall('user32.dll', 'uint_ptr', 'ActivateKeyboardLayout', 'uint_ptr', $hLocale, 'uint', $iFlag)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ActivateKeyboardLayout

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AddClipboardFormatListener
; Description....: Places the given window in the system-maintained clipboard format listener list.
; Syntax.........: _WinAPI_AddClipboardFormatListener ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to be placed.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ AddClipboardFormatListener
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AddClipboardFormatListener($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'AddClipboardFormatListener', 'hwnd', $hWnd)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AddClipboardFormatListener

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AddFontMemResourceEx
; Description....: Adds the font resource from a memory image to the system.
; Syntax.........: _WinAPI_AddFontMemResourceEx ( $pData, $iSize )
; Parameters.....: $pData  - The pointer to a font resource.
;                  $iSize  - The number of bytes in the font resource.
; Return values..: Success - The handle uniquely identifies the fonts that were installed on the system, @extended flag will contain
;                            a number of fonts added to the system as a result of this call.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function allows an application to get a font that is embedded in a document or a Web page. A font that is
;                  added by this is always private to the process that made the call and is not enumerable.
;
;                  When the function succeeds, the caller of this function can free the memory pointed to by $pData because the system
;                  has made its own copy of the memory. To remove the fonts that were installed, call _WinAPI_RemoveFontMemResourceEx().
;                  However, when the process goes away, the system will unload the fonts.
; Related........:
; Link...........: @@MsdnLink@@ AddFontMemResourceEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AddFontMemResourceEx($pData, $iSize)

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'AddFontMemResourceEx', 'ptr', $pData, 'dword', $iSize, 'ptr', 0, 'dword*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, $Ret[4], $Ret[0])
EndFunc   ;==>_WinAPI_AddFontMemResourceEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AddFontResourceEx
; Description....: Adds the font resource from the specified file to the system font table.
; Syntax.........: _WinAPI_AddFontResourceEx ( $sFont [, $iFlag [, $fNotify]] )
; Parameters.....: $sFont   - String that contains a valid font file name. This parameter can specify any of the following files:
;
;                             .fon - Font resource file.
;                             .fnt - Raw bitmap font file.
;                             .ttf - Raw TrueType file.
;                             .ttc - East Asian Windows: TrueType font collection.
;                             .fot - TrueType resource file.
;                             .otf - PostScript OpenType font.
;                             .mmm - Multiple master Type1 font resource file. It must be used with .pfm and .pfb files.
;                             .pfb - Type 1 font bits file. It is used with a .pfm file.
;                             .pfm - Type 1 font metrics file. It is used with a .pfb file.
;
;                             To add a font whose information comes from several resource files, they must be separated by a "|".
;                             For example, abcxxxxx.pfm|abcxxxxx.pfb.
;
;                  $iFlag   - The characteristics of the font to be added to the system. This parameter can be one of the following values.
;
;                             $FR_PRIVATE
;                             $FR_NOT_ENUM
;
;                  $fNotify - Specifies whether sends a WM_FONTCHANGE message, valid values:
;                  |TRUE    - Send the WM_FONTCHANGE message to all top-level windows after changing the pool of font resources.
;                  |FALSE   - Don`t send. (Default)
; Return values..: Success  - The value that specifies the number of fonts added.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function installs the font only for the current session. When the system restarts, the font will not be present.
;                  To have the font installed even after restarting the system, the font must be listed in the registry.
; Related........:
; Link...........: @@MsdnLink@@ AddFontResourceEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AddFontResourceEx($sFont, $iFlag = 0, $fNotify = 0)

	Local $Ret = DllCall('gdi32.dll', 'int', 'AddFontResourceExW', 'wstr', $sFont, 'dword', $iFlag, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	If $fNotify Then
		DllCall('user32.dll', 'none', 'SendMessage', 'hwnd', 0xFFFF, 'uint', 0x001D, 'wparam', 0, 'lparam', 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_AddFontResourceEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AddIconOverlay
; Description....: Creates an icon by merging the source icon and overlay mask.
; Syntax.........: _WinAPI_AddIconOverlay ( $hIcon, $hOverlay )
; Parameters.....: $hIcon    - Handle to the source icon.
;                  $hOverlay - Handle to the icon to use as an overlay mask.
; Return values..: Success   - Handle to the newly created icon.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The source and overlay icons must be the same size but can have different color depth. This function internally
;                  converts the specified icons to the 32 bits-per-pixel icon.
;
;                  When you are finished using the icon, destroy it using the _WinAPI_DestroyIcon() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AddIconOverlay($hIcon, $hOverlay)

	Local $tSIZE, $Ret, $hIL, $hResult = 0
	Local $hDev[2] = [0, 0]

	$tSIZE = _WinAPI_GetIconDimension($hIcon)
	$hIL = DllCall('comctl32.dll', 'ptr', 'ImageList_Create', 'int', DllStructGetData($tSIZE, 1), 'int', DllStructGetData($tSIZE, 2), 'uint', 0x0021, 'int', 2, 'int', 2)
	If (@error) Or (Not $hIL[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Do
		$hDev[0] = _WinAPI_Create32BitHICON($hIcon)
		If @error Then
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'int', 'ImageList_ReplaceIcon', 'ptr', $hIL[0], 'int', -1, 'ptr', $hDev[0])
		If (@error) Or ($Ret[0] = -1) Then
			ExitLoop
		EndIf
		$hDev[1] = _WinAPI_Create32BitHICON($hOverlay)
		If @error Then
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'int', 'ImageList_ReplaceIcon', 'ptr', $hIL[0], 'int', -1, 'ptr', $hDev[1])
		If (@error) Or ($Ret[0] = -1) Then
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'int', 'ImageList_SetOverlayImage', 'ptr', $hIL[0], 'int', 1, 'int', 1)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'ptr', 'ImageList_GetIcon', 'ptr', $hIL[0], 'int', 0, 'uint', 0x00000100)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$hResult = $Ret[0]
	Until 1
	DllCall('comctl32.dll', 'int', 'ImageList_Destroy', 'ptr', $hIL[0])
	For $i = 0 To 1
		If $hDev[$i] Then
			_WinAPI_DestroyIcon($hDev[$i])
		EndIf
	Next
	If Not $hResult Then
		Return SetError(1, 0, 0)
	EndIf
	Return $hResult
EndFunc   ;==>_WinAPI_AddIconOverlay

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AddIconTransparency
; Description....: Adds a transparency to the specified 32 bits-per-pixel icon.
; Syntax.........: _WinAPI_AddIconTransparency ( $hIcon [, $iPercent [, $fDelete]] )
; Parameters.....: $hIcon    - Handle to the icon.
;                  $iPercent - A value (in percent) that specifies how much to decrease the values of the alpha channel for the
;                              specified icon. If this parameter is 0, the function returns a fully transparent icon.
;                  $fDelete  - Specifies whether to delete the icon after the function is successful, valid values:
;                  |TRUE     - Icon will be deleted if the function succeeds.
;                  |FALSE    - Do not delete, you must release the icon when you are finished using it. (Default)
; Return values..: Success   - Handle to the newly created icon.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function only works with 32 bits-per-pixel with alpha chanel (RGB + Alpha) icons. If the source icon
;                  has no alpha chanel, the resulting icon will be the same as the source icon. If the source icon is non
;                  32 bits-per-pixel, the function fails.
;
;                  When you are finished using the icon, destroy it using the _WinAPI_DestroyIcon() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AddIconTransparency($hIcon, $iPercent = 50, $fDelete = 0)

	Local $tICONINFO, $tBITMAP, $Ret, $hDib = 0, $hResult = 0
	Local $hBitmap[2]

	$tICONINFO = DllStructCreate($tagICONINFO)
	$Ret = DllCall('user32.dll', 'int', 'GetIconInfo', 'ptr', $hIcon, 'ptr', DllStructGetPtr($tICONINFO))
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	For $i = 0 To 1
		$hBitmap[$i] = DllStructGetData($tICONINFO, $i + 4)
	Next
	Do
		$hDib = _WinAPI_CopyBitmap($hBitmap[1])
		If @error Then
			ExitLoop
		EndIf
		$tBITMAP = DllStructCreate($tagBITMAP)
		If (Not _WinAPI_GetObject($hDib, DllStructGetSize($tBITMAP), DllStructGetPtr($tBITMAP))) Or (DllStructGetData($tBITMAP, 'bmBitsPixel') <> 32) Then
			ExitLoop
		EndIf
		$Ret = DllCall('user32.dll', 'int', 'CallWindowProc', 'ptr', __TransparencyProc(), 'ptr', 0, 'uint', $iPercent, 'ptr', DllStructGetPtr($tBITMAP), 'ptr', 0)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		If $Ret[0] = -1 Then
			$hResult = _WinAPI_CreateEmptyIcon(DllStructGetData($tBITMAP, 'bmWidth'), DllStructGetData($tBITMAP, 'bmHeight'))
		Else
			$hResult = _WinAPI_CreateIconIndirect($hDib, $hBitmap[0])
		EndIf
	Until 1
	If $hDib Then
		_WinAPI_DeleteObject($hDib)
	EndIf
	For $i = 0 To 1
		If $hBitmap[$i] Then
			_WinAPI_DeleteObject($hBitmap[$i])
		EndIf
	Next
	If Not $hResult Then
		Return SetError(1, 0, 0)
	EndIf
	If $fDelete Then
		_WinAPI_DestroyIcon($hIcon)
	EndIf
	Return $hResult
EndFunc   ;==>_WinAPI_AddIconTransparency

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AddMRUString
; Description....: Adds a string to the top of the most recently used (MRU) list.
; Syntax.........: _WinAPI_AddMRUString ( $hMRU, $sStr )
; Parameters.....: $hMRU   - Handle of the MRU list.
;                  $sStr   - The string be added.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ AddMRUStringW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AddMRUString($hMRU, $sStr)

	Local $Ret = DllCall('comctl32.dll ', 'int', 'AddMRUStringW', 'ptr', $hMRU, 'wstr', $sStr)

	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AddMRUString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AdjustBitmap
; Description....: Creates a new device-depended bitmap (DDB) from the source bitmap with new dimensions and color adjustment.
; Syntax.........: _WinAPI_AdjustBitmap ( $hBitmap, $iWidth, $iHeight [, $iMode [, $tAdjustment]] )
; Parameters.....: $hBitmap     - A handle to the source bitmap.
;                  $iWidth      - The width of the new bitmap, in pixels. If this parameter is (-1), the width will be the same
;                                 as in the source bitmap.
;                  $iHeight     - The height of the new bitmap, in pixels. If this parameter is (-1), the height will be the same
;                                 as in the source bitmap.
;                  $iMode       - The stretching mode. This parameter can be one of the following values.
;
;                                 $BLACKONWHITE
;                                 $COLORONCOLOR
;                                 $HALFTONE
;                                 $WHITEONBLACK
;                                 $STRETCH_ANDSCANS
;                                 $STRETCH_DELETESCANS
;                                 $STRETCH_HALFTONE
;                                 $STRETCH_ORSCANS
;
;                  $tAdjustment - $tagCOLORADJUSTMENT structure containing the color adjustment values. This color adjustment is
;                                 used only if $HALFTONE ($STRETCH_HALFTONE) stretching mode are set.
; Return values..: Success      - A handle to the newly created bitmap (DDB).
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_AdjustBitmap() creates a device-depended bitmaps compatible with the application's current screen.
;
;                  This function does not support bitmaps with alpha channel, you can use the _WinAPI_AlphaBlend() function to work
;                  with these bitmaps.
;
;                  When you are finished using the bitmap, destroy it using the _WinAPI_DeleteObject() function. The function
;                  does not destroy the original bitmap, you must to destroy it yourself.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AdjustBitmap($hBitmap, $iWidth, $iHeight, $iMode = 3, $tAdjustment = 0)

	Local $Ret, $tObj, $hBmp, $hDC, $hDestDC, $hDestSv, $hSrcDC, $hSrcSv

    $tObj = DllStructCreate($tagBITMAP)
	$Ret = DllCall('gdi32.dll', 'int', 'GetObject', 'int', $hBitmap, 'int', DllStructGetSize($tObj), 'ptr', DllStructGetPtr($tObj))
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	If $iWidth = -1 Then
		$iWidth = DllStructGetData($tObj, 'bmWidth')
	EndIf
	If $iHeight = -1 Then
		$iHeight = DllStructGetData($tObj, 'bmHeight')
	EndIf
	$Ret = DllCall('user32.dll', 'hwnd', 'GetDC', 'hwnd', 0)
	$hDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'CreateCompatibleDC', 'hwnd', $hDC)
	$hDestDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'CreateCompatibleBitmap', 'hwnd', $hDC, 'int', $iWidth, 'int', $iHeight)
	$hBmp = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'SelectObject', 'hwnd', $hDestDC, 'ptr', $hBmp)
	$hDestSv = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'CreateCompatibleDC', 'hwnd', $hDC)
	$hSrcDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'SelectObject', 'hwnd', $hSrcDC, 'ptr', $hBitmap)
	$hSrcSv = $Ret[0]
	If _WinAPI_SetStretchBltMode($hDestDC, $iMode) Then
		Switch $iMode
			Case 4 ; HALFTONE
				If IsDllStruct($tAdjustment) Then
					If Not _WinAPI_SetColorAdjustment($hDestDC, $tAdjustment) Then
						; Nothing
					EndIf
				EndIf
			Case Else

		EndSwitch
	EndIf
	$Ret = _WinAPI_StretchBlt($hDestDC, 0, 0, $iWidth, $iHeight, $hSrcDC, 0, 0, DllStructGetData($tObj, 'bmWidth'), DllStructGetData($tObj, 'bmHeight'), 0x00CC0020)
	DllCall('user32.dll', 'int', 'ReleaseDC', 'hwnd', 0, 'hwnd', $hDC)
	DllCall('gdi32.dll', 'ptr', 'SelectObject', 'hwnd', $hDestDC, 'ptr', $hDestSv)
	DllCall('gdi32.dll', 'ptr', 'SelectObject', 'hwnd', $hSrcDC, 'ptr', $hSrcSv)
	DllCall('gdi32.dll', 'int', 'DeleteDC', 'hwnd', $hDestDC)
	DllCall('gdi32.dll', 'int', 'DeleteDC', 'hwnd', $hSrcDC)
	If Not $Ret Then
		Return SetError(1, 0, 0)
	EndIf
	Return $hBmp
EndFunc   ;==>_WinAPI_AdjustBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AdjustTokenPrivileges
; Description....: Enables or disables privileges in the specified access token.
; Syntax.........: _WinAPI_AdjustTokenPrivileges ( $hToken, $aPrivileges, $iAttributes, ByRef $aAdjust )
; Parameters.....: $hToken      - Handle to the access token that contains the privileges to be modified. The handle must have
;                                 $TOKEN_ADJUST_PRIVILEGES and $TOKEN_QUERY accesses to the token.
;                  $aPrivileges - The variable that specifies a privileges. If this parameter is (-1), the function disables of the token's
;                                 privileges and ignores the $iAttributes parameter. $aPrivileges can be one of the following types.
;
;                                 The privilege constant ($SE_*).
;                                 1D array of $SE_* constants.
;                                 2D array of $SE_* constants and their attributes (see below).
;
;                                 [0][0] - Privilege
;                                 [0][1] - Attributes
;                                 [n][0] - Privilege
;                                 [n][1] - Attributes
;
;                  $iAttributes - The privilege attributes. If $aPrivileges parameter is 1D array, $iAttributes applied to the entire
;                                 array. If $aPrivileges parameter is (-1) or 2D array, the function ignores this parameter and will
;                                 use the attributes that specified in this array. This parameter can be 0 (disables privilege)
;                                 or any combination of the following values.
;
;                                 $SE_PRIVILEGE_ENABLED
;                                 $SE_PRIVILEGE_ENABLED_BY_DEFAULT
;                                 $SE_PRIVILEGE_REMOVED
;                                 $SE_PRIVILEGE_USED_FOR_ACCESS
;
;                  $aAdjust     - 2D array of the previous state of any privileges that the function modifies. That is, if a privilege has
;                                 been modified by this function, the privilege and its previous state are contained in this array.
; Return values..: Success      - 1 and sets the @extended flag to the following values.
;
;                                 0 - The function adjusted all specified privileges.
;                                 1 - The token does not have one or more of the privileges specified in the $aPrivileges parameter.
;
;                                 To determine whether the function success and adjusted all of the specified privileges, check the
;                                 @error and @extended flags both, for example:
;
;                                 If Not (@error Or @extended) Then
;                                     ...
;                                 EndIf
;
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function cannot add new privileges to the access token. It can only enable or disable the token's
;                  existing privileges.
; Related........:
; Link...........: @@MsdnLink@@ AdjustTokenPrivileges
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AdjustTokenPrivileges($hToken, $aPrivileges, $iAttributes, ByRef $aAdjust)

	Local $tTP1 = 0, $tTP2, $tData, $Count, $Result, $Ret, $Struct, $Disable = 0, $Prev = 0

	$aAdjust = 0

	If (Not $aPrivileges) And (IsNumber($aPrivileges)) Then
		Return 0
	EndIf
	If $aPrivileges = -1 Then
		$tTP2 = DllStructCreate('dword')
		$Ret = DllCall('advapi32.dll', 'int', 'AdjustTokenPrivileges', 'ptr', $hToken, 'int', 1, 'ptr', 0, 'dword', 0, 'ptr', DllStructGetPtr($tTP2), 'dword*', 0)
		If @error Then
			Return SetError(1, 0, 0)
		Else
			Switch _WinAPI_GetLastError()
				Case 122 ; ERROR_INSUFFICIENT_BUFFER
					$tTP2 = DllStructCreate('dword;dword[' & ($Ret[6] / 4 - 1) & ']')
					If @error Then
						ContinueCase
					EndIf
				Case Else
					Return SetError(1, 0, 0)
			EndSwitch
		EndIf
		$Disable = 1
	Else
		If Not IsArray($aPrivileges) Then
			Dim $Prev[1][2]
			$Prev[0][0] = $aPrivileges
			$Prev[0][1] = $iAttributes
		Else
			If Not UBound($aPrivileges, 2) Then
				$Count = UBound($aPrivileges)
				Dim $Prev[$Count][2]
				For $i = 0 To $Count - 1
					$Prev[$i][0] = $aPrivileges[$i]
					$Prev[$i][1] = $iAttributes
				Next
			EndIf
		EndIf
		If IsArray($Prev) Then
			$aPrivileges = $Prev
		EndIf
		$Struct = 'dword;dword[' & (3 * UBound($aPrivileges)) & ']'
		$tTP1 = DllStructCreate($Struct)
		$tTP2 = DllStructCreate($Struct)
		If @error Then
			Return SetError(1, 0, 0)
		EndIf
		DllStructSetData($tTP1, 1, UBound($aPrivileges))
		For $i = 0 To UBound($aPrivileges) - 1
			DllStructSetData($tTP1, 2, $aPrivileges[$i][1], 3 * $i + 3)
			$Ret = DllCall('advapi32.dll', 'int', 'LookupPrivilegeValueW', 'ptr', 0, 'wstr', $aPrivileges[$i][0], 'ptr', DllStructGetPtr($tTP1, 2) + 12 * $i)
			If (@error) Or (Not $Ret[0]) Then
				Return SetError(1, 0, 0)
			EndIf
		Next
	EndIf
	$Ret = DllCall('advapi32.dll', 'int', 'AdjustTokenPrivileges', 'ptr', $hToken, 'int', $Disable, 'ptr', DllStructGetPtr($tTP1), 'dword', DllStructGetSize($tTP2), 'ptr', DllStructGetPtr($tTP2), 'dword*', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Switch _WinAPI_GetLastError()
		Case 1300 ; ERROR_NOT_ALL_ASSIGNED
			$Result = 1
		Case Else
			$Result = 0
	EndSwitch
	$Count = DllStructGetData($tTP2, 1)
	If $Count Then
		$tData = DllStructCreate('wchar[128]')
		Dim $aPrivileges[$Count][2]
		For $i = 0 To $Count - 1
			$Ret = DllCall('advapi32.dll', 'int', 'LookupPrivilegeNameW', 'ptr', 0, 'ptr', DllStructGetPtr($tTP2, 2) + 12 * $i, 'ptr', DllStructGetPtr($tData), 'dword*', 128)
			If (@error) Or (Not $Ret[0]) Then
				Return SetError(1, 0, 0)
			EndIf
			$aPrivileges[$i][1] = DllStructGetData($tTP2, 2, 3 * $i + 3)
			$aPrivileges[$i][0] = DllStructGetData($tData, 1)
		Next
		$aAdjust = $aPrivileges
	EndIf
	Return SetError(0, $Result, 1)
EndFunc   ;==>_WinAPI_AdjustTokenPrivileges

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AdjustWindowRectEx
; Description....: Calculates the required size of the window rectangle, based on the desired size of the client rectangle.
; Syntax.........: _WinAPI_AdjustWindowRectEx ( ByRef $tRECT, $iStyle [, $iExStyle [, $fMenu] )
; Parameters.....: $tRECT    - $tagRECT structure that contains the coordinates of the desired client area. This structure must be
;                              created before function call.
;                  $iStyle   - The window style of the window whose required size is to be calculated. Note that you cannot
;                              specify the $WS_OVERLAPPED style.
;                  $iExStyle - The extended window style of the window whose required size is to be calculated.
;                  $fMenu    - Specifies whether the window has a menu, valid values:
;                  |TRUE     - The window has a menu.
;                  |FALSE    - The window does not has a menu. (Default)
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ AdjustWindowRectEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AdjustWindowRectEx(ByRef $tRECT, $iStyle, $iExStyle = 0, $fMenu = 0)

	Local $Ret = DllCall('user32.dll', 'int', 'AdjustWindowRectEx', 'ptr', DllStructGetPtr($tRECT), 'dword', $iStyle, 'int', $fMenu, 'dword', $iExStyle)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AdjustWindowRectEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AlphaBlend
; Description....: Displays bitmaps that have transparent or semitransparent pixels.
; Syntax.........: _WinAPI_AlphaBlend ( $hDestDC, $iXDest, $iYDest, $iWidthDest, $iHeightDest, $hSrcDC, $iXSrc, $iYSrc, $iWidthSrc, $iHeightSrc, $iAlpha [, $fAlpha] )
; Parameters.....: $hDestDC     - Handle to the destination device context.
;                  $iXDest      - The x-coordinate, in logical units, of the upper-left corner of the destination rectangle.
;                  $iYDest      - The y-coordinate, in logical units, of the upper-left corner of the destination rectangle.
;                  $iWidthDest  - The width, in logical units, of the destination rectangle.
;                  $iHeightDest - The height, in logical units, of the destination rectangle.
;                  $hSrcDC      - Handle to the source device context.
;                  $iXSrc       - The x-coordinate, in logical units, of the upper-left corner of the source rectangle.
;                  $iYSrc       - The y-coordinate, in logical units, of the upper-left corner of the source rectangle.
;                  $iWidthSrc   - The width, in logical units, of the source rectangle.
;                  $iHeightSrc  - The height, in logical units, of the source rectangle.
;                  $iAlpha      - The alpha transparency value to be used on the entire source bitmap. This value is combined with
;                                 any per-pixel alpha values in the source bitmap. If you set $iAlpha to 0, it is assumed that
;                                 your image is transparent. Set $iAlpha value to 255 (opaque) when you only want to use per-pixel
;                                 alpha values.
;                  $fAlpha      - Specifies whether uses an alpha channel from the source bitmap, valid values:
;                  |TRUE        - Use the alpha channel (that is, per-pixel alpha). Note that the APIs use premultiplied alpha,
;                                 which means that the red, green and blue channel values in the bitmap must be premultiplied with the
;                                 alpha channel value. For example, if the alpha channel value is x, the red, green and blue channels
;                                 must be multiplied by x and divided by 255 prior to the call.
;                  |FALSE       - Do not use the alpha channel. (Default)
; Return values..: Success      - 1.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the source rectangle and destination rectangle are not the same size, the source bitmap is stretched to
;                  match the destination rectangle. If the _WinAPI_SetStretchBltMode() function is used, the stretching mode value
;                  is automatically converted to $COLORONCOLOR for this function (that is, $BLACKONWHITE, $WHITEONBLACK, and
;                  $HALFTONE are changed to $COLORONCOLOR).
;
;                  If destination and source bitmaps do not have the same color format, _WinAPI_AlphaBlend() function converts
;                  the source bitmap to match the destination bitmap.
; Related........:
; Link...........: @@MsdnLink@@ GdiAlphaBlend
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AlphaBlend($hDestDC, $iXDest, $iYDest, $iWidthDest, $iHeightDest, $hSrcDC, $iXSrc, $iYSrc, $iWidthSrc, $iHeightSrc, $iAlpha, $fAlpha = 0)

	Local $iBlend = BitOR(BitShift(Not ($fAlpha = 0), -24), BitShift(BitAND($iAlpha, 0xFF), -16))
	Local $Ret  = DllCall('gdi32.dll', 'int', 'GdiAlphaBlend', 'hwnd', $hDestDC, 'int', $iXDest, 'int', $iYDest, 'int', $iWidthDest, 'int', $iHeightDest, 'hwnd', $hSrcDC, 'int', $iXSrc, 'int', $iYSrc, 'int', $iWidthSrc, 'int', $iHeightSrc, 'dword', $iBlend)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AlphaBlend

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AngleArc
; Description....: Draws a line segment and an arc.
; Syntax.........: _WinAPI_AngleArc ( $hDC, $iX, $iY, $iRadius, $nStartAngle, $nSweepAngle )
; Parameters.....: $hDC         - Handle to a device context.
;                  $iX          - The x-coordinate, in logical units, of the center of the circle.
;                  $iY          - The y-coordinate, in logical units, of the center of the circle.
;                  $iRadius     - The radius, in logical units, of the circle.
;                  $nStartAngle - The start angle, in degrees, relative to the x-axis.
;                  $nSweepAngle - The sweep angle, in degrees, relative to the starting angle.
; Return values..: Success      - 1.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_AngleArc() function draws lines by using the current pen. The figure is not filled. This function
;                  moves the current position to the ending point of the arc.
; Related........:
; Link...........: @@MsdnLink@@ AngleArc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AngleArc($hDC, $iX, $iY, $iRadius, $nStartAngle, $nSweepAngle)

	Local $Ret = DllCall('gdi32.dll', 'int', 'AngleArc', 'hwnd', $hDC, 'int', $iX, 'int', $iY, 'dword', $iRadius, 'float', $nStartAngle, 'float', $nSweepAngle)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AngleArc

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AnimateWindow
; Description....: Enables you to produce special effects when showing or hiding windows.
; Syntax.........: _WinAPI_AnimateWindow ( $hWnd, $iFlags [, $iDuration] )
; Parameters.....: $hWnd      - Handle to the window to animate.
;                  $iFlags    - The flags that specify the type of animation. This parameter can be one or more of the following
;                               values. Note that, by default, these flags take effect when showing a window. To take effect when
;                               hiding a window, use AW_HIDE and a logical OR operator with the appropriate flags.
;
;                               $AW_ACTIVATE
;                               $AW_BLEND
;                               $AW_CENTER
;                               $AW_HIDE
;                               $AW_HOR_NEGATIVE
;                               $AW_HOR_POSITIVE
;                               $AW_SLIDE
;                               $AW_VER_NEGATIVE
;                               $AW_VER_POSITIVE
;
;                  $iDuration - Specifies how long it takes to play the animation, in milliseconds. Default is 1000.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ AnimateWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AnimateWindow($hWnd, $iFlags, $iDuration = 1000)

	Local $Ret = DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $hWnd, 'dword', $iDuration, 'dword', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_AnimateWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_Arc
; Description....: Draws an elliptical arc.
; Syntax.........: _WinAPI_Arc ( $hDC, $tRECT, $iXStartArc, $iYStartArc, $iXEndArc, $iYEndArc )
; Parameters.....: $hDC         - Handle to the device context.
;                  $tRECT       - $tagRECT structure that contains the logical coordinates of the bounding rectangle.
;                  $iXStartArc  - The x-coordinate, in logical units, of the ending point of the radial line defining the starting point of the arc.
;                  $iYStartArc  - The y-coordinate, in logical units, of the ending point of the radial line defining the starting point of the arc.
;                  $iXEndArc    - The x-coordinate, in logical units, of the ending point of the radial line defining the ending point of the arc.
;                  $iYEndArc    - The y-coordinate, in logical units, of the ending point of the radial line defining the ending point of the arc.
; Return values..: Success      - 1.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The arc is drawn using the current pen; it is not filled. The current position is neither used nor updated by
;                  _WinAPI_Arc() function.
;
;                  Use the _WinAPI_GetArcDirection() and _WinAPI_SetArcDirection() functions to get and set the current drawing
;                  direction for a device context. The default drawing direction is counterclockwise.
; Related........:
; Link...........: @@MsdnLink@@ Arc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_Arc($hDC, $tRECT, $iXStartArc, $iYStartArc, $iXEndArc, $iYEndArc)

	Local $Ret = DllCall('gdi32.dll', 'int', 'Arc', 'hwnd', $hDC, 'int', DllStructGetData($tRECT, 1), 'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4), 'int', $iXStartArc, 'int', $iYStartArc, 'int', $iXEndArc, 'int', $iYEndArc)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_Arc

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ArcTo
; Description....: Draws an elliptical arc.
; Syntax.........: _WinAPI_ArcTo ( $hDC, $tRECT, $iXRadial1, $iYRadial1, $iXRadial2, $iYRadial2 )
; Parameters.....: $hDC       - Handle to the device context.
;                  $tRECT     - $tagRECT structure that contains the logical coordinates of the bounding rectangle.
;                  $iXRadial1 - The x-coordinate, in logical units, of the endpoint of the radial defining the starting point of the arc.
;                  $iYRadial1 - The y-coordinate, in logical units, of the endpoint of the radial defining the starting point of the arc.
;                  $iXRadial2 - The x-coordinate, in logical units, of the endpoint of the radial defining the ending point of the arc.
;                  $iYRadial2 - The y-coordinate, in logical units, of the endpoint of the radial defining the ending point of the arc.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The arc is drawn using the current pen; it is not filled. _WinAPI_ArcTo() is similar to the _WinAPI_Arc() function,
;                  except that the current position is updated.
; Related........:
; Link...........: @@MsdnLink@@ ArcTo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ArcTo($hDC, $tRECT, $iXRadial1, $iYRadial1, $iXRadial2, $iYRadial2)

	Local $Ret = DllCall('gdi32.dll', 'int', 'ArcTo', 'hwnd', $hDC, 'int', DllStructGetData($tRECT, 1), 'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4), 'int', $iXRadial1, 'int', $iYRadial1, 'int', $iXRadial2, 'int', $iYRadial2)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_ArcTo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ArrayToStruct
; Description....: Converts an array of strings to the structure.
; Syntax.........: _WinAPI_ArrayToStruct ( Const ByRef $aData [, $iStart [, $iEnd]] )
; Parameters.....: $aData  - The array to convert.
;                  $iStart - The index of array to start converting at.
;                  $iEnd   - The index of array to stop converting at.
; Return values..: Success - The structure of the type "string1;{0};string2;{0}; ... ;stringN;{0};{0}".
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function works for Unicode strings only.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ArrayToStruct(Const ByRef $aData, $iStart = 0, $iEnd = -1)

	If Not IsArray($aData) Then
		Return SetError(2, 0, 0)
	EndIf

	Local $tData, $Count, $Struct = ''

	If $iStart < 0 Then
		$iStart = 0
	EndIf
	If ($iEnd < 0) Or ($iEnd > UBound($aData) - 1) Then
		$iEnd = UBound($aData) - 1
	EndIf
	For $i = $iStart To $iEnd
		$Struct &= 'wchar[' & (StringLen($aData[$i]) + 1) & '];'
	Next
	$tData = DllStructCreate($Struct & 'wchar[1]')
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$Count = 1
	For $i = $iStart To $iEnd
		DllStructSetData($tData, $Count, $aData[$i])
		$Count += 1
	Next
	DllStructSetData($tData, $Count, ChrW(0))
	Return $tData
EndFunc   ;==>_WinAPI_ArrayToStruct

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AssignProcessToJobObject
; Description....: Assigns a process to an existing job object.
; Syntax.........: _WinAPI_AssignProcessToJobObject ( $hJob, $hProcess )
; Parameters.....: $hJob     - Handle to the job object to which the process will be associated. The handle must have the
;                              $JOB_OBJECT_ASSIGN_PROCESS access right.
;                  $hProcess - Handle to the process to associate with the job object. The process must not already be assigned to a job.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After you associate a process with a job object, the process is subject to the limits set for the job. To set
;                  limits for a job, use the _WinAPI_SetInformationJobObject() function.
;
;                  The process can be associated only with a single job. The process inherits limits from the job it is associated
;                  with and adds its accounting information to the job. If a process is associated with a job, all processes it
;                  creates are associated with that job by default.
; Related........:
; Link...........: @@MsdnLink@@ AssignProcessToJobObject
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AssignProcessToJobObject($hJob, $hProcess)

	Local $Ret = DllCall('kernel32.dll', 'int', 'AssignProcessToJobObject', 'ptr', $hJob, 'ptr', $hProcess)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_AssignProcessToJobObject

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AssocGetPerceivedType
; Description....: Retrieves a file's perceived type based on its extension.
; Syntax.........: _WinAPI_AssocGetPerceivedType ( $sExt )
; Parameters.....: $sExt   - The file's extension. This should include the leading period, for example ".txt".
; Return values..: Success - The array containing the following information:
;
;                            [0] - The perceived type ($PERCEIVED_TYPE_*).
;                            [1] - The source of the perceived type information ($PERCEIVEDFLAG_*).
;                            [2] - The perceived type string, for instance "text" or "video".
;
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ AssocGetPerceivedType
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AssocGetPerceivedType($sExt)

	Local $Ret = DllCall('shlwapi.dll', 'uint', 'AssocGetPerceivedType', 'wstr', $sExt, 'int*', 0, 'dword*', 0, 'wstr*', '')

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf

	Local $Result[3]

	For $i = 0 To 2
		$Result[$i] = $Ret[$i + 2]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_AssocGetPerceivedType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AssocQueryString
; Description....: Searches for and retrieves a file or protocol association-related string from the registry.
; Syntax.........: _WinAPI_AssocQueryString ( $sAssoc, $iType [, $iFlags [, $sExtra]] )
; Parameters.....: $sAssoc - The string that is used to determine the root key. The following four types of strings can be used.
;
;                            The file name extension, such as ".txt".
;                            The class identifier (CLSID) GUID in the standard "{GUID}" format.
;                            The application's ProgID, such as Word.Document.8.
;                            The name of an application's .exe file. The $ASSOCF_OPEN_BYEXENAME flag must be set.
;
;                  $iType  - The value that specifies the type of string that is to be returned. This parameter can be one of the
;                            following values.
;
;                            $ASSOCSTR_COMMAND
;                            $ASSOCSTR_EXECUTABLE
;                            $ASSOCSTR_FRIENDLYDOCNAME
;                            $ASSOCSTR_FRIENDLYAPPNAME
;                            $ASSOCSTR_NOOPEN
;                            $ASSOCSTR_SHELLNEWVALUE
;                            $ASSOCSTR_DDECOMMAND
;                            $ASSOCSTR_DDEIFEXEC
;                            $ASSOCSTR_DDEAPPLICATION
;                            $ASSOCSTR_DDETOPIC
;                            $ASSOCSTR_INFOTIP
;                            $ASSOCSTR_QUICKTIP
;                            $ASSOCSTR_TILEINFO
;                            $ASSOCSTR_CONTENTTYPE
;                            $ASSOCSTR_DEFAULTICON
;                            $ASSOCSTR_SHELLEXTENSION
;
;                  $iFlags - The flags that can be used to control the search. It can be any combination of the following
;                            values, except that only one $ASSOCF_INIT_* value can be included.
;
;                            $ASSOCF_INIT_NOREMAPCLSID
;                            $ASSOCF_INIT_BYEXENAME
;                            $ASSOCF_OPEN_BYEXENAME
;                            $ASSOCF_INIT_DEFAULTTOSTAR
;                            $ASSOCF_INIT_DEFAULTTOFOLDER
;                            $ASSOCF_NOUSERSETTINGS
;                            $ASSOCF_NOTRUNCATE
;                            $ASSOCF_VERIFY
;                            $ASSOCF_REMAPRUNDLL
;                            $ASSOCF_NOFIXUPS
;                            $ASSOCF_IGNOREBASECLASS
;                            $ASSOCF_INIT_IGNOREUNKNOWN
;
;                  $sExtra - The optional string with additional information about the location of the string. It is typically
;                            set to a Shell verb such as open.
; Return values..: Success - The string that contains the requested ($ASSOCSTR_*) information.
;                  Failure - Empty string and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ AssocQueryString
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_AssocQueryString($sAssoc, $iType, $iFlags = 0, $sExtra = '')

	Local $TypeOfExtra = 'wstr'

	If Not StringStripWS($sExtra, 3) Then
		$TypeOfExtra = 'ptr'
		$sExtra = 0
	EndIf

	Local $Ret = DllCall('shlwapi.dll', 'uint', 'AssocQueryStringW', 'dword', $iFlags, 'dword', $iType, 'wstr', $sAssoc, $TypeOfExtra, $sExtra, 'wstr', '', 'dword*', 4096)

	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_AssocQueryString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BackupRead
; Description....: Backs up a file or directory, including the security information.
; Syntax.........: _WinAPI_BackupRead ( $hFile, $pBuffer, $iLength, ByRef $iBytes, ByRef $pContext [, $fSecurity] )
; Parameters.....: $hFile     - Handle to the file or directory to be backed up. To obtain the handle, call the _WinAPI_CreateFileEx()
;                               function. The SACLs are not read unless the file handle was created with the $ACCESS_SYSTEM_SECURITY
;                               access right.
;                  $pBuffer   - A pointer to a buffer that receives the data.
;                  $iLength   - The size of the buffer, in bytes. The buffer size must be greater than the size of the
;                               $tagWIN32_STREAM_ID structure (see MSDN for more information).
;                  $iBytes    - The number of bytes read.
;                  $pContext  - A pointer to an internal data structure used by this function to maintain context information during
;                               a backup operation. You must set this variable to 0 before the first call to _WinAPI_BackupRead()
;                               for the specified file or directory. The function allocates memory for the data structure, and then
;                               sets the variable to point to that structure. You must not change this variable or the variable
;                               that it points to between calls to _WinAPI_BackupRead().
;                  $fSecurity - Specifies whether the function will backup the access-control list (ACL) data, valid values:
;                  |TRUE      - The ACL data will be backed up.
;                  |FALSE     - The ACL data will be omitted. (Default)
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_BackupRead() is not intended for use in backing up files encrypted under the Encrypted File System (EFS).
;
;                  If an error occurs during the data reading, the calling process can skip the bad data by calling the
;                  _WinAPI_BackupSeek() function.
;
;                  When you are done using _WinAPI_BackupRead(), you must call _WinAPI_BackupReadAbort() function with the appropriate
;                  parameter to release the memory used by the internal data structure.
;
;                  The file or directory should be restored using the _WinAPI_BackupWrite() function.
; Related........:
; Link...........: @@MsdnLink@@ BackupRead
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BackupRead($hFile, $pBuffer, $iLength, ByRef $iBytes, ByRef $pContext, $fSecurity = 0)

	$iBytes = 0

	Local $Ret = DllCall('kernel32.dll', 'int', 'BackupRead', 'ptr', $hFile, 'ptr', $pBuffer, 'dword', $iLength, 'dword*', 0, 'int', 0, 'int', $fSecurity, 'ptr*', $pContext)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$iBytes = $Ret[4]
	$pContext = $Ret[7]
	Return 1
EndFunc   ;==>_WinAPI_BackupRead

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BackupReadAbort
; Description....: Finishes the use of _WinAPI_BackupRead() on the handle.
; Syntax.........: _WinAPI_BackupRead ( ByRef $pContext )
; Parameters.....: $pContext - A pointer to an internal data structure used by _WinAPI_BackupRead() function to maintain context
;                              information during a backup operation.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ BackupRead
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BackupReadAbort(ByRef $pContext)

	Local $Ret = DllCall('kernel32.dll', 'int', 'BackupRead', 'ptr', 0, 'ptr', 0, 'dword', 0, 'ptr', 0, 'int', 1, 'int', 0, 'ptr*', $pContext)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$pContext = $Ret[7]
	Return 1
EndFunc   ;==>_WinAPI_BackupReadAbort

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BackupSeek
; Description....: Seeks forward in a data stream initially accessed by using the _WinAPI_BackupRead() or _WinAPI_BackupWrite() function.
; Syntax.........: _WinAPI_BackupSeek ( $hFile, $iSeek, ByRef $iBytes, ByRef $pContext )
; Parameters.....: $hFile    - Handle to the file or directory.
;                  $iSeek    - The number of bytes to seek.
;                  $iBytes   - The number of bytes the function actually seeks.
;                  $pContext - A pointer to an internal data structure. This structure must be the same structure that was initialized
;                              by the _WinAPI_BackupRead(). An application must not touch the contents of this structure.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Applications use the _WinAPI_BackupSeek() to skip portions of a data stream that cause errors. This function does
;                  not seek across stream headers.
; Related........:
; Link...........: @@MsdnLink@@ BackupSeek
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BackupSeek($hFile, $iSeek, ByRef $iBytes, ByRef $pContext)

	$iBytes = 0

	Local $Ret = DllCall('kernel32.dll', 'int', 'BackupSeek', 'ptr', $hFile, 'dword', _WinAPI_LoDWord($iSeek), 'dword', _WinAPI_HiDWord($iSeek), 'dword*', 0, 'dword*', 0, 'ptr*', $pContext)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$iBytes = _WinAPI_MakeQWord($Ret[4], $Ret[5])
	$pContext = $Ret[6]
	Return 1
EndFunc   ;==>_WinAPI_BackupSeek

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BackupWrite
; Description....: Restore a file or directory that was backed up using _WinAPI_BackupRead().
; Syntax.........: _WinAPI_BackupWrite ( $hFile, $pBuffer, $iLength, ByRef $iBytes, ByRef $pContext [, $fSecurity] )
; Parameters.....: $hFile     - Handle to the file or directory to be restored. To obtain the handle, call the _WinAPI_CreateFileEx()
;                               function. The SACLs are not restored unless the file handle was created with the $ACCESS_SYSTEM_SECURITY
;                               access right. To ensure that the integrity ACEs are restored correctly, the file handle must also
;                               have been created with the $WRITE_OWNER access right.
;                  $pBuffer   - A pointer to a buffer that the function writes data from.
;                  $iLength   - The size of the buffer, in bytes. The buffer size must be greater than the size of the
;                               $tagWIN32_STREAM_ID structure (see MSDN for more information).
;                  $iBytes    - The number of bytes written.
;                  $pContext  - A pointer to an internal data structure used by this function to maintain context information during
;                               a restore operation. You must set this variable to 0 before the first call to _WinAPI_BackupWrite()
;                               for the specified file or directory. The function allocates memory for the data structure, and then
;                               sets the variable to point to that structure. You must not change this variable or the variable
;                               that it points to between calls to _WinAPI_BackupWrite().
;                  $fSecurity - Specifies whether the function will restore the access-control list (ACL) data, valid values:
;                  |TRUE      - The ACL data will be restored. Furthermore, you need to specify $WRITE_OWNER and $WRITE_DAC access when
;                               opening the file or directory handle. If the handle does not have those access rights, the operating
;                               system denies access to the ACL data, and ACL data restoration will not occur.
;                  |FALSE     - The ACL data will be omitted. (Default)
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_BackupWrite() is not intended for use in restoring files encrypted under the Encrypted File System (EFS).
;
;                  When you are done using _WinAPI_BackupWrite(), you must call _WinAPI_BackupWriteAbort() function with the
;                  appropriate parameter to release the memory used by the internal data structure.
;
; Related........:
; Link...........: @@MsdnLink@@ BackupRead
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BackupWrite($hFile, $pBuffer, $iLength, ByRef $iBytes, ByRef $pContext, $fSecurity = 0)

	$iBytes = 0

	Local $Ret = DllCall('kernel32.dll', 'int', 'BackupWrite', 'ptr', $hFile, 'ptr', $pBuffer, 'dword', $iLength, 'dword*', 0, 'int', 0, 'int', $fSecurity, 'ptr*', $pContext)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$iBytes = $Ret[4]
	$pContext = $Ret[7]
	Return 1
EndFunc   ;==>_WinAPI_BackupWrite

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BackupWriteAbort
; Description....: Finishes the use of _WinAPI_BackupWrite() on the handle.
; Syntax.........: _WinAPI_BackupWriteAbort ( ByRef $pContext )
; Parameters.....: $pContext - A pointer to an internal data structure used by _WinAPI_BackupWrite() function to maintain context
;                              information during a restore operation.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ BackupWrite
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BackupWriteAbort(ByRef $pContext)

	Local $Ret = DllCall('kernel32.dll', 'int', 'BackupWrite', 'ptr', 0, 'ptr', 0, 'dword', 0, 'ptr', 0, 'int', 1, 'int', 0, 'ptr*', $pContext)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$pContext = $Ret[7]
	Return 1
EndFunc   ;==>_WinAPI_BackupWriteAbort

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BeginBufferedPaint
; Description....: Begins a buffered paint operation.
; Syntax.........: _WinAPI_BeginBufferedPaint ( $hDC, $tTarget, ByRef $hNewDC [, $iFormat [, $iFlags [, $tExclude [, $iAlpha]]]] )
; Parameters.....: $hDC      - Handle of the target DC on which the buffer will be painted.
;                  $tTarget  - $tagRECT structure that specifies the area of the target DC in which to paint.
;                  $hNewDC   - Handle of the new device context.
;                  $iFormat  - The format of the buffer. This parameter can be one of the following values.
;
;                              $BPBF_COMPATIBLEBITMAP
;                              $BPBF_DIB
;                              $BPBF_TOPDOWNDIB
;                              $BPBF_TOPDOWNMONODIB
;
;                  $iFlags   - The additional flags, one or more of the following values.
;
;                              $BPPF_ERASE
;                              $BPPF_NOCLIP
;                              $BPPF_NONCLIENT
;
;                  $tExclude - $tagRECT structure that specifies the area which is excluded from the clipping region.
;                  $iAlpha   - The alpha transparency value to be used on the entire source bitmap. If this parameter is not
;                              specified or (-1), the source buffer is copied to the destination with no blending.
; Return values..: Success   - The handle to the buffered paint context.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ BeginBufferedPaint
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BeginBufferedPaint($hDC, $tTarget, ByRef $hNewDC, $iFormat = 0, $iFlags = 0, $tExclude = 0, $iAlpha = -1)

	Local $tPP = DllStructCreate('dword;dword;ptr;ptr')
	Local $tBF = 0

	$hNewDC = 0

	If $iAlpha <> -1 Then
		$tBF = DllStructCreate($tagBLENDFUNCTION)
		DllStructSetData($tBF, 1, 0)
		DllStructSetData($tBF, 2, 0)
		DllStructSetData($tBF, 3, $iAlpha)
		DllStructSetData($tBF, 4, 1)
	EndIf

	DllStructSetData($tPP, 1, DllStructGetSize($tPP))
	DllStructSetData($tPP, 2, $iFlags)
	DllStructSetData($tPP, 3, DllStructGetPtr($tExclude))
	DllStructSetData($tPP, 4, DllStructGetPtr($tBF))

	Local $Ret = DllCall('uxtheme.dll', 'ptr', 'BeginBufferedPaint', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tTarget), 'dword', $iFormat, 'ptr', DllStructGetPtr($tPP), 'hwnd*', 0)

	If (@error) Or (Not $Ret[0]) Or (Not $Ret[5]) Then
		Return SetError(1, 0, 0)
	EndIf
	$hNewDC = $Ret[5]
	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginBufferedPaint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BeginDeferWindowPos
; Description....: Allocates memory for a multiple-window-position structure.
; Syntax.........: _WinAPI_BeginDeferWindowPos ( [$iAmount] )
; Parameters.....: $iAmount - The initial number of windows for which to store position information.
; Return values..: Success  - The value identifies the multiple-window-position structure.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: KaFu
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ BeginDeferWindowPos
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BeginDeferWindowPos($iAmount = 1)

	Local $Ret = DllCall('user32.dll', 'ptr', 'BeginDeferWindowPos', 'int', $iAmount)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginDeferWindowPos

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BeginPaint
; Description....: Prepares the specified window for painting.
; Syntax.........: _WinAPI_BeginPaint ( $hWnd, ByRef $tPAINTSTRUCT )
; Parameters.....: $hWnd         - Handle to the window to be repainted.
;                  $tPAINTSTRUCT - $tagPAINTSTRUCT structure that will receive painting information. When the function call, this
;                                  parameter should be any valid variable, the function creates this structure itself.
; Return values..: Success       - Handle to a display device context for the specified window.
;                  Failure       - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function automatically sets the clipping region of the device context to exclude any area outside the
;                  update region. The update region is set by the _WinAPI_InvalidateRect() or _WinAPI_InvalidateRgn() function and
;                  by the system after sizing, moving, creating, scrolling, or any other operation that affects the client area.
;                  If the update region is marked for erasing, _WinAPI_BeginPaint() sends a WM_ERASEBKGND message to the window.
;
;                  An application should not call _WinAPI_BeginPaint() except in response to a WM_PAINT message. Each call to
;                  _WinAPI_BeginPaint() must have a corresponding call to the _WinAPI_EndPaint() function.
; Related........:
; Link...........: @@MsdnLink@@ BeginPaint
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BeginPaint($hWnd, ByRef $tPAINTSTRUCT)

	$tPAINTSTRUCT = DllStructCreate($tagPAINTSTRUCT)

	Local $Ret = DllCall('user32.dll', 'hwnd', 'BeginPaint', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tPAINTSTRUCT))

	If (@error) Or (Not $Ret[0]) Then
		$tPAINTSTRUCT = 0
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginPaint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BeginPath
; Description....: Opens a path bracket in the specified device context.
; Syntax.........: _WinAPI_BeginPath ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After a path bracket is open, an application can begin calling GDI drawing functions to define the points that
;                  lie in the path. An application can close an open path bracket by calling the _WinAPI_EndPath() function.
;
;                  When an application calls _WinAPI_BeginPath() for a device context, any previous paths are discarded from that
;                  device context.
; Related........:
; Link...........: @@MsdnLink@@ BeginPath
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BeginPath($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'BeginPath', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_BeginPath

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BeginUpdateResource
; Description....: Retrieves a handle that can be used to add, delete, or replace resources in a binary module.
; Syntax.........: _WinAPI_BeginUpdateResource ( $sFile [, $fDelete] )
; Parameters.....: $sFile   - The binary file in which to update resources. An application must be able to obtain write-access to
;                             this file; the file referenced by $sFile cannot be currently executing.
;                  $fDelete - Specifies whether to delete existing resources, valid values:
;                  |TRUE    - The resources are deleted and the updated file includes only resources added with the _WinAPI_UpdateResource().
;                  |FALSE   - The updated file includes existing resources. (Default)
; Return values..: Success  - Handle that can be used by the _WinAPI_UpdateResource() and _WinAPI_EndUpdateResource() functions.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: It is recommended that the resource file is not loaded before this function is called. However, if that file
;                  is already loaded, it will not cause an error to be returned.
; Related........:
; Link...........: @@MsdnLink@@ BeginUpdateResource
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BeginUpdateResource($sFile, $fDelete = 0)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'BeginUpdateResourceW', 'wstr', $sFile, 'int', $fDelete)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginUpdateResource

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BringWindowToTop
; Description....: Brings the specified window to the top of the Z order.
; Syntax.........: _WinAPI_BringWindowToTop ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to bring to the top of the Z order.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ BringWindowToTop
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BringWindowToTop($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'BringWindowToTop', 'hwnd', $hWnd)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_BringWindowToTop

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BroadcastSystemMessage
; Description....: Sends a message to the specified recipients.
; Syntax.........: _WinAPI_BroadcastSystemMessage ( $iMsg [, $wParam [, $lParam [, $iFlags [, $iRecipients]]]] )
; Parameters.....: $iMsg        - The message to be sent.
;                  $wParam      - The message-specific information.
;                  $lParam      - The message-specific information.
;                  $iFlags      - The broadcast option. This parameter can be one or more of the following values.
;
;                                 $BSF_ALLOWSFW
;                                 $BSF_FLUSHDISK
;                                 $BSF_FORCEIFHUNG
;                                 $BSF_IGNORECURRENTTASK
;                                 $BSF_NOHANG
;                                 $BSF_NOTIMEOUTIFNOTHUNG
;                                 $BSF_POSTMESSAGE
;                                 $BSF_QUERY
;                                 $BSF_SENDNOTIFYMESSAGE
;
;                  $iRecipients - The recipients of the message. This parameter can be one or more of the following values.
;
;                                 $BSM_ALLCOMPONENTS
;                                 $BSM_ALLDESKTOPS
;                                 $BSM_APPLICATIONS
;                                 $BSM_INSTALLABLEDRIVERS
;                                 $BSM_NETDRIVER
;                                 $BSM_VXDS
;
; Return values..: Success      - 1 or 0 (see below), @extended flag receives a combination of $BSM_* values identifying which
;                                 recipients actually received the message.
;                  Failure      - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the $iFlags parameter is $BSF_QUERY and at least one recipient returned BROADCAST_QUERY_DENY to the corresponding
;                  message, the return value is 0.
;
;                  The system only does marshalling for system messages (those in the range 0 to (WM_USER-1)). To send other messages
;                  (those >= WM_USER) to another process, you must do custom marshalling.
; Related........:
; Link...........: @@MsdnLink@@ BroadcastSystemMessage
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BroadcastSystemMessage($iMsg, $wParam = 0, $lParam = 0, $iFlags = 0, $iRecipients = 0)

	Local $Ret = DllCall('user32.dll', 'long', 'BroadcastSystemMessageW', 'dword', $iFlags, 'dword*', $iRecipients, 'uint', $iMsg, 'wparam', $wParam, 'lparam', $lParam)

	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, -1)
	EndIf
	Return SetError(0, $Ret[2], $Ret[0])
EndFunc   ;==>_WinAPI_BroadcastSystemMessage

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BrowseForFolderDlg
; Description....: Displays a dialog box that enables the user to select a Shell folder.
; Syntax.........: _WinAPI_BrowseForFolderDlg ( [$sRoot [, $sText [, $iFlags [, $pBrowseProc [, $lParam [, $hParent] )
; Parameters.....: $sRoot       - The root folder from which to start browsing. Only the specified folder and its subfolders in the
;                                 namespace hierarchy appear in the dialog box. If this parameter is 0, the namespace root
;                                 (the Desktop folder) is used.
;                  $sText       - The string that is displayed above the tree view control in the dialog box.
;                  $iFlags      - Flags that specify the options for the dialog box. This parameter can a combination of the
;                                 following values.
;
;                                 $BIF_BROWSEFORCOMPUTER
;                                 $BIF_BROWSEFORPRINTER
;                                 $BIF_BROWSEINCLUDEFILES
;                                 $BIF_BROWSEINCLUDEURLS
;                                 $BIF_DONTGOBELOWDOMAIN
;                                 $BIF_EDITBOX
;                                 $BIF_NEWDIALOGSTYLE
;                                 $BIF_NONEWFOLDERBUTTON
;                                 $BIF_NOTRANSLATETARGETS
;                                 $BIF_RETURNFSANCESTORS
;                                 $BIF_RETURNONLYFSDIRS
;                                 $BIF_SHAREABLE
;                                 $BIF_STATUSTEXT
;                                 $BIF_USENEWUI
;                                 $BIF_UAHINT
;                                 $BIF_VALIDATE
;
;                                 Windows 7 or later
;
;                                 $BIF_BROWSEFILEJUNCTIONS
;
;                  $pBrowseProc - Pointer to a callback function that the dialog box calls when an event occurs. This function will
;                                 receive one of the following event messages.
;
;                                 $BFFM_INITIALIZED
;                                 $BFFM_IUNKNOWN
;                                 $BFFM_SELCHANGED
;                                 $BFFM_VALIDATEFAILED
;
;                                 (See MSDN for more information)
;
;                  $lParam      - The value that the dialog box passes to the callback function.
;                  $hParent     - Handle to the parent window for the dialog box.
; Return values..: Success      - The full path for chosen folder, or an empty string if user cancels/closes the dialog.
;                  Failure      - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ SHBrowseForFolder
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BrowseForFolderDlg($sRoot = '', $sText = '', $iFlags = 0, $pBrowseProc = 0, $lParam = 0, $hParent = 0)

	Local $tBROWSEINFO = DllStructCreate('hwnd;ptr;ptr;ptr;int;ptr;uint_ptr;int;wchar[' & (StringLen($sText) + 1) & '];wchar[260]')
	Local $PIDL = 0, $Path, $Result = ''

	If StringStripWS($sRoot, 3) Then
		$Path = _WinAPI_PathSearchAndQualify($sRoot, 1)
		If @error Then
			$Path = $sRoot
		EndIf
		$PIDL = _WinAPI_ShellILCreateFromPath($Path)
		If @error Then
			; Nothing
		EndIf
	EndIf

	DllStructSetData($tBROWSEINFO, 1, $hParent)
	DllStructSetData($tBROWSEINFO, 2, $PIDL)
	DllStructSetData($tBROWSEINFO, 3, DllStructGetPtr($tBROWSEINFO, 10))
	DllStructSetData($tBROWSEINFO, 4, DllStructGetPtr($tBROWSEINFO, 9))
	DllStructSetData($tBROWSEINFO, 5, $iFlags)
	DllStructSetData($tBROWSEINFO, 6, $pBrowseProc)
	DllStructSetData($tBROWSEINFO, 7, $lParam)
	DllStructSetData($tBROWSEINFO, 8, 0)
	DllStructSetData($tBROWSEINFO, 9, $sText)

	Local $Ret = DllCall('shell32.dll', 'ptr', 'SHBrowseForFolderW', 'ptr', DllStructGetPtr($tBROWSEINFO))

	If @error Then
		Return SetError(1, 0, '')
	Else
		If Not $Ret[0] Then
			Return ''
		EndIf
	EndIf
	$Result = _WinAPI_ShellGetPathFromIDList($Ret[0])
	_WinAPI_CoTaskMemFree($Ret[0])
	If $PIDL Then
		_WinAPI_CoTaskMemFree($PIDL)
	EndIf
	If Not $Result Then
		Return SetError(1, 0, '')
	EndIf
	Return $Result
EndFunc   ;==>_WinAPI_BrowseForFolderDlg

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BufferedPaintClear
; Description....: Clears a specified rectangle in the buffer to ARGB = {0,0,0,0}.
; Syntax.........: _WinAPI_BufferedPaintClear ( $hBP [, $tRECT] )
; Parameters.....: $hBP    - Handle of the buffered paint context.
;                  $tRECT  - $tagRECT structure that specifies the rectangle to clear. If this parameter is 0, the entire buffer is used.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ BufferedPaintClear
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BufferedPaintClear($hBP, $tRECT = 0)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'BufferedPaintClear', 'ptr', $hBP, 'ptr', DllStructGetPtr($tRECT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_BufferedPaintClear

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BufferedPaintInit
; Description....: Initialize buffered painting for the current thread.
; Syntax.........: _WinAPI_BufferedPaintInit ( )
; Parameters.....: None
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: Each call to _WinAPI_BufferedPaintInit() should be matched with a call to _WinAPI_BufferedPaintUnInit() when
;                  calls to buffered paint APIs are no longer needed.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ BufferedPaintInit
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BufferedPaintInit()

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'BufferedPaintInit')

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_BufferedPaintInit

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BufferedPaintSetAlpha
; Description....: Sets the alpha to a specified value in a given rectangle.
; Syntax.........: _WinAPI_BufferedPaintSetAlpha ( $hBP [, $iAlpha [, $tRECT]] )
; Parameters.....: $hBP    - Handle of the buffered paint context.
;                  $iAlpha - The alpha value to set. The alpha value can range from zero (fully transparent) to 255 (fully opaque).
;                  $tRECT  - $tagRECT structure that specifies the rectangle in which to set the alpha. If this parameter is 0,
;                            the entire buffer is used.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ BufferedPaintSetAlpha
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BufferedPaintSetAlpha($hBP, $iAlpha = 255, $tRECT = 0)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'BufferedPaintSetAlpha', 'ptr', $hBP, 'ptr', DllStructGetPtr($tRECT), 'byte', $iAlpha)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_BufferedPaintSetAlpha

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_BufferedPaintUnInit
; Description....: Closes down buffered painting for the current thread.
; Syntax.........: _WinAPI_BufferedPaintUnInit ( )
; Parameters.....: None
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ BufferedPaintUnInit
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_BufferedPaintUnInit()

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'BufferedPaintUnInit')

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_BufferedPaintUnInit

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CalculatePopupWindowPosition
; Description....: Calculates an appropriate pop-up window position.
; Syntax.........: _WinAPI_CalculatePopupWindowPosition ( $iX, $iY, $iWidth, $iHeight [, $iFlags [, $tExclude]] )
; Parameters.....: $iX       - The x-coordinate, in logical units, of the specified anchor point.
;                  $iY       - The y-coordinate, in logical units, of the specified anchor point.
;                  $iWidth   - The width, in logical units, of the specified window.
;                  $iHeight  - The height, in logical units, of the specified window.
;                  $iFlags   - The flags that specify how the function positions the pop-up window horizontally and vertically.
;
;                              $TPM_CENTERALIGN
;                              $TPM_LEFTALIGN
;                              $TPM_RIGHTALIGN
;
;                              $TPM_BOTTOMALIGN
;                              $TPM_TOPALIGN
;                              $TPM_VCENTERALIGN
;
;                              $TPM_HORIZONTAL
;                              $TPM_VERTICAL
;
;                              $TPM_WORKAREA
;
;                  $tExclude - $tagRECT structure that specifies the exclude rectangle.
; Return values..: Success   - $tagRECT structure that contains the pop-up window position.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows 7 or later.
; Related........:
; Link...........: @@MsdnLink@@ CalculatePopupWindowPosition
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CalculatePopupWindowPosition($iX, $iY, $iWidth, $iHeight, $iFlags = 0, $tExclude = 0)

	Local $tAnchor = _WinAPI_CreatePoint($iX, $iY)
	Local $tSize = _WinAPI_CreateSize($iWidth, $iHeight)
	Local $tPos =  DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'int', 'CalculatePopupWindowPosition', 'ptr', DllStructGetPtr($tAnchor), 'ptr', DllStructGetPtr($tSize), 'uint', $iFlags, 'ptr', DllStructGetPtr($tExclude), 'ptr', DllStructGetPtr($tPos))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tPos
EndFunc   ;==>_WinAPI_CalculatePopupWindowPosition

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CallWindowProcW
; Description....: Passes message information to the specified window procedure.
; Syntax.........: _WinAPI_CallWindowProcW ( $pPrevWndProc, $hWnd, $iMsg, $wParam, $lParam )
; Parameters.....: $pPrevWndProc - The address of a previous window procedure, or a special internal value meaningful only to
;                                  _WinAPI_CallWindowProcW() function.
;                  $hWnd         - A handle to the window procedure that received the message.
;                  $iMsg         - The message.
;                  $wParam       - Additional message-specific information. The content of this parameter depends on the message.
;                  $lParam       - Additional message-specific information. The content of this parameter depends on the message.
; Return values..: Success       - The result of the message processing and depends on the message sent.
;                  Failure       - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Use this function for window subclassing. Usually, all windows with the same class share one window procedure.
;                  A subclass is a window or set of windows with the same class whose messages are intercepted and processed by
;                  another window procedure (or procedures) before being passed to the window procedure of the class.
;
;                  The _WinAPI_CallWindowProcW() function handles Unicode-to-ANSI conversion. You cannot take advantage
;                  of this conversion if you call the window procedure directly.
; Related........:
; Link...........: @@MsdnLink@@ CallWindowProc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CallWindowProcW($pPrevWndProc, $hWnd, $iMsg, $wParam, $lParam)

	Local $Ret = DllCall('user32.dll', 'lresult', 'CallWindowProcW', 'ptr', $pPrevWndProc, 'hwnd', $hWnd, 'uint', $iMsg, 'wparam', $wParam, 'lparam', $lParam)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CallWindowProcW

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CascadeWindows
; Description....: Cascades the specified child windows of the specified parent window.
; Syntax.........: _WinAPI_CascadeWindows ( $aWnds [, $tRECT [, $hParent [, $iFlags [, $iStart [, $iEnd]]]]] )
; Parameters.....: $aWnds   - The array of handles to the child windows to arrange. If a specified child window is a top-level window
;                             with the style $WS_EX_TOPMOST or $WS_EX_TOOLWINDOW, the child window is not arranged. If this parameter
;                             is 0, all child windows of the specified parent window (or of the desktop window) are arranged.
;                  $tRECT   - $tagRECT structure that specifies the rectangular area, in client coordinates, within which the windows
;                             are arranged. This parameter can be 0, in which case the client area of the parent window is used.
;                  $hParent - Handle to the parent window. If this parameter is 0, the desktop window is assumed.
;                  $iFlags  - A cascade flag. This parameter can be one or more of the following values.
;
;                             $MDITILE_SKIPDISABLED
;                             $MDITILE_ZORDER
;
;                  $iStart  - The index of array to start arranging at.
;                  $iEnd    - The index of array to stop arranging at.
; Return values..: Success  - The value is the number of windows arranged.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CascadeWindows
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CascadeWindows($aWnds, $tRECT = 0, $hParent = 0, $iFlags = 0, $iStart = 0, $iEnd = -1)

	Local $Count, $tWnds = 0

	If IsArray($aWnds) Then
		If $iStart < 0 Then
			$iStart = 0
		EndIf
		If ($iEnd < 0) Or ($iEnd > UBound($aWnds) - 1) Then
			$iEnd = UBound($aWnds) - 1
		EndIf
		$Count = $iEnd - $iStart + 1
		If $Count < 1 Then
			Return SetError(1, 0, 0)
		EndIf
		$tWnds = DllStructCreate('hwnd[' & $Count & ']')
		If @error Then
			Return SetError(1, 0, 0)
		EndIf
		$Count = 1
		For $i = $iStart To $iEnd
			DllStructSetData($tWnds, 1, $aWnds[$i], $Count)
			$Count += 1
		Next
	Else
		If $aWnds Then
			Return SetError(2, 0, 0)
		EndIf
	EndIf

	Local $Ret = DllCall('user32.dll', 'ushort', 'CascadeWindows', 'hwnd', $hParent, 'uint', $iFlags, 'ptr', DllStructGetPtr($tRECT), 'uint', $Count - 1, 'ptr', DllStructGetPtr($tWnds))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CascadeWindows

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ChangeWindowMessageFilterEx
; Description....: Modifies the User Interface Privilege Isolation (UIPI) message filter for a specified window.
; Syntax.........: _WinAPI_ChangeWindowMessageFilterEx ( $hWnd, $iMsg, $iAction )
; Parameters.....: $hWnd    - Handle to the window whose UIPI message filter is to be modified. If this parameter is 0, the UIPI
;                             message filter will be modified in a process-wide manner. Moreover, under Windows Vista this parameter
;                             is not used and should be set to 0.
;                  $iMsg    - The message that the message filter allows through or blocks.
;                  $iAction - The action to be performed. This parameter can be one of the following values.
;
;                             $MSGFLT_ALLOW
;                             $MSGFLT_DISALLOW
;
;                             Windows 7 or later
;
;                             $MSGFLT_RESET
;
; Return values..: Success  - 1 and sets the @extended flag to 0 or one of the following values (only under Windows 7 and later).
;
;                             $MSGFLTINFO_ALLOWED_HIGHER
;                             $MSGFLTINFO_ALREADYALLOWED_FORWND
;                             $MSGFLTINFO_ALREADYDISALLOWED_FORWND
;                             $MSGFLTINFO_NONE
;
;                             (See MSDN for more information)
;
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: UIPI is a security feature that prevents messages from being received from a lower-integrity-level sender.
;                  You can use this function to allow specific messages to be delivered to a window even if the message originates
;                  from a process at a lower integrity level.
;
;                  Certain messages whose value is smaller than WM_USER are required to be passed through the filter, regardless
;                  of the filter setting. There will be no effect when you attempt to use this function to allow or block such
;                  messages.
;
;                  This function requires Windows Vista or later.
;
; Related........:
; Link...........: @@MsdnLink@@ ChangeWindowMessageFilterEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ChangeWindowMessageFilterEx($hWnd, $iMsg, $iAction)

	Local $tCFS, $Ret

	If ($hWnd) And ($__WINVER > 0x0600) Then
		$tCFS = DllStructCreate('dword;dword')
		DllStructSetData($tCFS, 1, 4)
		$Ret = DllCall('user32.dll', 'int', 'ChangeWindowMessageFilterEx', 'hwnd', $hWnd, 'uint', $iMsg, 'dword', $iAction, 'ptr', DllStructGetPtr($tCFS))
	Else
		$tCFS = 0
		$Ret = DllCall('user32.dll', 'int', 'ChangeWindowMessageFilter', 'uint', $iMsg, 'dword', $iAction)
	EndIf
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, DllStructGetData($tCFS, 2), 1)
EndFunc   ;==>_WinAPI_ChangeWindowMessageFilterEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CharToOem
; Description....: Converts a string into the OEM-defined character set.
; Syntax.........: _WinAPI_CharToOem ( $sStr )
; Parameters.....: $sStr   - The string that must be converted.
; Return values..: Success - The converted string.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CharToOem
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CharToOem($sStr)

	Local $Ret = DllCall('user32.dll', 'int', 'CharToOem', 'str', $sStr, 'str', '')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_CharToOem

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ChildWindowFromPointEx
; Description....: Determines which, if any, of the child windows belonging to the specified parent window contains the specified point.
; Syntax.........: _WinAPI_ChildWindowFromPointEx ( $hWnd, $tPOINT [, $iFlags] )
; Parameters.....: $hWnd   - Handle to the parent window.
;                  $tPOINT - $tagPOINT structure that defines the client coordinates (relative to hwndParent) of the point to
;                            be checked.
;                  $iFlags - The flags that specify which child windows to skip. This parameter can be one or more of the
;                            following values.
;
;                            $CWP_ALL
;                            $CWP_SKIPINVISIBLE
;                            $CWP_SKIPDISABLED
;                            $CWP_SKIPTRANSPARENT
;
; Return values..: Success - Handle to the first child window. If the point is within the parent window but not within any child
;                            window that meets the criteria, the return value is a handle to the parent window. If the point lies
;                            outside the parent window, the return value is 0.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The system maintains an internal list that contains the handles of the child windows associated with a
;                  parent window. The order of the handles in the list depends on the Z order of the child windows. If more than
;                  one child window contains the specified point, the system returns a handle to the first window in the list
;                  that contains the point and meets the criteria specified by $iFlags.
; Related........:
; Link...........: @@MsdnLink@@ ChildWindowFromPointEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ChildWindowFromPointEx($hWnd, $tPOINT, $iFlags = 0)

	Local $Ret = DllCall('user32.dll', 'hwnd', 'ChildWindowFromPointEx', 'hwnd', $hWnd, 'int', DllStructGetData($tPOINT, 1), 'int', DllStructGetData($tPOINT, 2), 'uint', $iFlags)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ChildWindowFromPointEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ClipCursor
; Description....: Confines the cursor to a rectangular area on the screen.
; Syntax.........: _WinAPI_ClipCursor ( $tRECT )
; Parameters.....: $tRECT  - $tagRECT structure that contains the screen coordinates of the confining rectangle. If this parameter is 0,
;                            the cursor is free to move anywhere on the screen.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The cursor is a shared resource. If an application confines the cursor, it must release the cursor by using
;                  _WinAPI_ClipCursor() before relinquishing control to another application.
; Related........:
; Link...........: @@MsdnLink@@ ClipCursor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ClipCursor($tRECT)

	Local $Ret = DllCall('user32.dll', 'int', 'ClipCursor', 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_ClipCursor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CloseDesktop
; Description....: Closes an open handle to a desktop object.
; Syntax.........: _WinAPI_CloseDesktop ( $hDesktop )
; Parameters.....: $hDesktop - Handle to the desktop to be closed.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CloseDesktop() function will fail if any thread in the calling process is using the specified desktop
;                  handle or if the handle refers to the initial desktop of the calling process.
; Related........:
; Link...........: @@MsdnLink@@ CloseDesktop
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CloseDesktop($hDesktop)

	Local $Ret = DllCall('user32.dll', 'int', 'CloseDesktop', 'ptr', $hDesktop)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CloseDesktop

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CloseEnhMetaFile
; Description....: Closes an enhanced-metafile device context and returns a handle that identifies an enhanced-format metafile.
; Syntax.........: _WinAPI_CloseEnhMetaFile ( $hDC )
; Parameters.....: $hDC    - Handle to an enhanced-metafile device context.
; Return values..: Success - Handle to an enhanced metafile.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When the application no longer needs an enhanced-metafile handle, it should delete the handle by calling the
;                  _WinAPI_DeleteEnhMetaFile() function.
; Related........:
; Link...........: @@MsdnLink@@ CloseEnhMetaFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CloseEnhMetaFile($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'CloseEnhMetaFile', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CloseEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CloseFigure
; Description....: Closes an open figure in a path.
; Syntax.........: _WinAPI_CloseFigure ( $hDC )
; Parameters.....: $hDC    - Handle to the device context in which the figure will be closed.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CloseFigure() function closes the figure by drawing a line from the current position to the first
;                  point of the figure (usually, the point specified by the most recent call to the _WinAPI_MoveToEx() function)
;                  and then connects the lines by using the line join style.
; Related........:
; Link...........: @@MsdnLink@@ CloseFigure
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CloseFigure($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'CloseFigure', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CloseFigure

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CloseThemeData
; Description....: Closes the theme data handle.
; Syntax.........: _WinAPI_CloseThemeData ( $hTheme )
; Parameters.....: $hTheme - Handle to a window's specified theme data.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CloseThemeData
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CloseThemeData($hTheme)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'CloseThemeData', 'ptr', $hTheme)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CloseThemeData

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CloseWindow
; Description....: Minimizes (but does not destroy) the specified window.
; Syntax.........: _WinAPI_CloseWindow ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to be minimized.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CloseWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CloseWindow($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'CloseWindow', 'hwnd', $hWnd)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CloseWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CloseWindowStation
; Description....: Closes an open window station handle.
; Syntax.........: _WinAPI_CloseWindowStation ( $hStation )
; Parameters.....: $hStation - Handle to the window station to be closed.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CloseWindowStation() function will fail if the handle being closed is for the window station
;                  assigned to the calling process.
; Related........:
; Link...........: @@MsdnLink@@ CloseWindowStation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CloseWindowStation($hStation)

	Local $Ret = DllCall('user32.dll', 'int', 'CloseWindowStation', 'ptr', $hStation)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CloseWindowStation

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CoInitialize
; Description....: Initializes the COM library for use by the calling process.
; Syntax.........: _WinAPI_CoInitialize ( [$iFlags] )
; Parameters.....: $iFlags - This parameter can be one or more of the following values.
;
;                            $COINIT_APARTMENTTHREADED
;                            $COINIT_DISABLE_OLE1DDE
;                            $COINIT_MULTITHREADED
;                            $COINIT_SPEED_OVER_MEMORY
;
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CoInitializeEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CoInitialize($iFlags = 0)

	Local $Ret = DllCall('ole32.dll', 'uint', 'CoInitializeEx', 'ptr', 0, 'dword', $iFlags)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CoInitialize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ColorAdjustLuma
; Description....: Changes the luminance of a RGB value.
; Syntax.........: _WinAPI_ColorAdjustLuma ( $iRGB, $iPercent [, $fScale] )
; Parameters.....: $iRGB     - The initial RGB value.
;                  $iPercent - The luminance of the total range, in percent, or absolute luminance.
;                  $fScale   - Specifies how to use the $iPercent parameter, valid values:
;                  |TRUE     - The $iPercent specifies how much to increment or decrement the current luminance, $iPercent can range from -1000 to +1000.
;                  |FALSE    - The $iPercent specifies the absolute luminance, $iPercent can range 0 to 1000. Available luminance values range
;                              from 0 to a maximum. If the requested value is negative or exceeds the maximum, the luminance will be set to
;                              either zero or the maximum value, respectively.
; Return values..: Success   - The modified RGB value.
;                  Failure   - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ColorAdjustLuma
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ColorAdjustLuma($iRGB, $iPercent, $fScale = 1)

	If $fScale Then
		$iPercent = Floor($iPercent * 10)
	EndIf

	Local $Ret = DllCall('shlwapi.dll', 'dword', 'ColorAdjustLuma', 'dword', __RGB($iRGB), 'int', $iPercent, 'int', $fScale)

	If @error Then
		Return SetError(1, 0, -1)
	EndIf
	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_ColorAdjustLuma

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ColorHLSToRGB
; Description....: Converts colors from hue-luminance-saturation (HLS) to RGB format.
; Syntax.........: _WinAPI_ColorHLSToRGB ( $iHue, $iLuminance, $iSaturation )
; Parameters.....: $iHue        - HLS hue value.
;                  $iLuminance  - HLS luminance value.
;                  $iSaturation - HLS saturation value.
; Return values..: Success      - The RGB value.
;                  Failure      - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ColorHLSToRGB
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ColorHLSToRGB($iHue, $iLuminance, $iSaturation)

	If Not $iSaturation Then
		$iHue = 160
	EndIf

	Local $Ret = DllCall('shlwapi.dll', 'dword', 'ColorHLSToRGB', 'dword', $iHue, 'dword', $iLuminance, 'dword', $iSaturation)

	If @error Then
		Return SetError(1, 0, -1)
	EndIf
	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_ColorHLSToRGB

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ColorRGBToHLS
; Description....: Converts colors from RGB to hue-luminance-saturation (HLS) format.
; Syntax.........: _WinAPI_ColorRGBToHLS ( $iRGB, ByRef $iHue, ByRef $iLuminance, ByRef $iSaturation )
; Parameters.....: $iRGB        - RGB color.
;                  $iHue        - HLS hue value.
;                  $iLuminance  - HLS luminance value.
;                  $iSaturation - HLS saturation value.
; Return values..: Success      - 1.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ColorRGBToHLS
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ColorRGBToHLS($iRGB, ByRef $iHue, ByRef $iLuminance, ByRef $iSaturation)

	Local $Ret = DllCall('shlwapi.dll', 'none', 'ColorRGBToHLS', 'dword', __RGB($iRGB), 'dword*', 0, 'dword*', 0, 'dword*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$iHue = $Ret[2]
	$iLuminance = $Ret[3]
	$iSaturation = $Ret[4]
	Return 1
EndFunc   ;==>_WinAPI_ColorRGBToHLS

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CombineTransform
; Description....: Concatenates two world-space to page-space transformations.
; Syntax.........: _WinAPI_CombineTransform ( $tXFORM1, $tXFORM2 )
; Parameters.....: $tXFORM1 - $tagXFORM structure that specifies the first transformation.
;                  $tXFORM2 - $tagXFORM structure that specifies the second transformation.
; Return values..: Success  - $tagXFORM structure that contains the combined transformation.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Applying the combined transformation has the same effect as applying the first transformation and then
;                  applying the second transformation.
; Related........:
; Link...........: @@MsdnLink@@ CombineTransform
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CombineTransform($tXFORM1, $tXFORM2)

	Local $tXFORM = DllStructCreate($tagXFORM)
	Local $Ret = DllCall('gdi32.dll', 'int', 'CombineTransform', 'ptr', DllStructGetPtr($tXFORM), 'ptr', DllStructGetPtr($tXFORM1), 'ptr', DllStructGetPtr($tXFORM2))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tXFORM
EndFunc   ;==>_WinAPI_CombineTransform

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CommandLineToArgv
; Description....: Parses a command-line string and returns an array of the command-line arguments.
; Syntax.........: _WinAPI_CommandLineToArgv ( $sCmd )
; Parameters.....: $sCmd   - The string that contains the full command line. If this parameter is an empty string the function returns
;                            an empty array (zeroth element is 0).
; Return values..: Success - The array of the command-line arguments. The zeroth array element contains the number of arguments.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CommandLineToArgvW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CommandLineToArgv($sCmd)

	Local $Result[1] = [0]

	$sCmd = StringStripWS($sCmd, 3)
	If Not $sCmd Then
		Return $Result
	EndIf

	Local $Ret = DllCall('shell32.dll', 'ptr', 'CommandLineToArgvW', 'wstr', $sCmd, 'int*', 0)

	If (@error) Or (Not $Ret[0]) Or (Not $Ret[2]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tPtr = DllStructCreate('ptr[' & $Ret[2] & ']', $Ret[0])

	Dim $Result[$Ret[2] + 1] = [$Ret[2]]
	For $i = 1 To $Ret[2]
		$Result[$i] = _WinAPI_GetString(DllStructGetData($tPtr, 1, $i))
	Next
	_WinAPI_LocalFree($Ret[0])
	Return $Result
EndFunc   ;==>_WinAPI_CommandLineToArgv

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CommDlgExtendedErrorEx
; Description....: Returns a common dialog box error code.
; Syntax.........: _WinAPI_CommDlgExtendedErrorEx ( )
; Parameters.....: None
; Return values..: The general error codes for any of the common dialog box functions ($CDERR_*, $PDERR_*, $CFERR_*, $FNERR_*, and $FRERR_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CommDlgExtendedError
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CommDlgExtendedErrorEx()

	Local $Ret = DllCall('comdlg32.dll', 'dword', 'CommDlgExtendedError')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CommDlgExtendedErrorEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CompareString
; Description....: Compares two character strings for a specified locale.
; Syntax.........: _WinAPI_CompareString ( $LCID, $sString1, $sString2 [, $iFlags] )
; Parameters.....: $LCID     - The locale identifier (LCID) that specifies the locale or one of the following predefined values.
;
;                              $LOCALE_INVARIANT
;                              $LOCALE_SYSTEM_DEFAULT
;                              $LOCALE_USER_DEFAULT
;
;                              Windows Vista or later
;
;                              $LOCALE_CUSTOM_DEFAULT
;                              $LOCALE_CUSTOM_UI_DEFAULT
;                              $LOCALE_CUSTOM_UNSPECIFIED
;
;                  $sString1 - The first string to compare.
;                  $sString2 - The second string to compare.
;                  $iFlags   - The flags that indicate how the function compares the two strings. This parameter can be 0 or
;                              combination of the following values.
;
;                              $LINGUISTIC_IGNORECASE
;                              $LINGUISTIC_IGNOREDIACRITIC
;
;                              $NORM_IGNORECASE
;                              $NORM_IGNOREKANATYPE
;                              $NORM_IGNORENONSPACE
;                              $NORM_IGNORESYMBOLS
;                              $NORM_IGNOREWIDTH
;                              $NORM_LINGUISTIC_CASING
;
;                              $SORT_STRINGSORT
;
;                              Windows 7 or later
;
;                              $SORT_DIGITSASNUMBERS
;
; Return values..: Success   - The one of the following values that indicates a result of the comparison strings.
;
;                              $CSTR_LESS_THAN
;                              $CSTR_EQUAL
;                              $CSTR_GREATER_THAN
;
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Normally, for case-insensitive comparisons, _WinAPI_CompareString() maps the lowercase "i" to the uppercase "I",
;                  even when the locale is Turkish or Azeri. The $NORM_LINGUISTIC_CASING flag overrides this behavior for Turkish
;                  or Azeri. If this flag is specified in conjunction with Turkish or Azeri, LATIN SMALL LETTER DOTLESS I (U+0131)
;                  is the lowercase form of LATIN CAPITAL LETTER I (U+0049) and LATIN SMALL LETTER I (U+0069) is the lowercase
;                  form of LATIN CAPITAL LETTER I WITH DOT ABOVE (U+0130).
; Related........:
; Link...........: @@MsdnLink@@ CompareString
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CompareString($LCID, $sString1, $sString2, $iFlags = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'CompareStringW', 'ulong', $LCID, 'dword', $iFlags, 'wstr', $sString1, 'int', -1, 'wstr', $sString2, 'int', -1)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CompareString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CompressBitmapBits
; Description....: Creates a compressed data block from the specified bitmap.
; Syntax.........: _WinAPI_CompressBitmapBits ( $hBitmap, ByRef $pBuffer [, $iCompression [, $iQuality]] )
; Parameters.....: $hBitmap      - A handle to the bitmap to be compressed.
;                  $pBuffer      - A pointer to a memory block (buffer) that receives the compressed data. Optionaly, you can set this
;                                  parameter to 0 before function call, then the function will allocate the required memory block itself.
;                                  Otherwise, it must be a valid memory pointer returned by the _WinAPI_CreateBuffer() function, or
;                                  by previously calling this function.
;                  $iCompression - The compression method. This parameter can be one of the following values.
;
;                                  $COMPRESSION_BITMAP_PNG
;                                  $COMPRESSION_BITMAP_JPEG
;
;                  $iQuality     - The quality of JPEG image, in percent. This value is ignored for non JPEG compression.
; Return values..: Success       - The number of bytes copied to the buffer.
;                  Failure       - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: In fact, the data that returns this function represent .jpeg or .png image file in binary form. You can use the
;                  _WinAPI_WriteFile() function to create the appropriate image file directly from this data.
;
;                  The returned data always represent a 24-bit color depth .jpeg image, or 32-bit color depth (with or without
;                  alpha chanel) .png image independent on the color depth of the source bitmap.
;
;                  When you no longer need the buffer allocated by this function, you must call the _WinAPI_FreeMemory() function
;                  (do not use any other memory routines) to release occupied memory.
;
;                  This function internally uses the GDI+ DLL library.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CompressBitmapBits($hBitmap, ByRef $pBuffer, $iCompression = 0, $iQuality = 100)

	Local $Size[2], $Count, $Format, $Length, $Mime, $Ret, $hDC, $hSv, $hMem, $tBits, $tInfo, $tData, $pData, $Error = 1
	Local $hSource = 0, $hImage = 0, $hToken = 0, $pEncoder = 0, $pStream = 0, $tParam = 0
	Local $tDIB = DllStructCreate($tagDIBSECTION)

	If Not __DLL('gdiplus.dll') Then
		Return SetError(3, 0, 0)
	EndIf

	Do
		Switch $iCompression
			Case 0
				$Mime = 'image/png'
			Case 1
				$Mime = 'image/jpeg'
			Case Else
				ExitLoop
		EndSwitch
		While $hBitmap
			If Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tDIB), DllStructGetPtr($tDIB)) Then
				ExitLoop 2
			EndIf
			If (DllStructGetData($tDIB, 'bmBitsPixel') = 32) And (Not DllStructGetData($tDIB, 'biCompression')) Then
				ExitLoop
			EndIf
			If $hSource Then
				ExitLoop 2
			EndIf
			$hSource = _WinAPI_CreateDIB(DllStructGetData($tDIB, 'bmWidth'), DllStructGetData($tDIB, 'bmHeight'))
			If @error Then
				ExitLoop 2
			EndIf
			$hDC = _WinAPI_CreateCompatibleDC(0)
			$hSv = _WinAPI_SelectObject($hDC, $hSource)
			If _WinAPI_DrawBitmap($hDC, 0, 0, $hBitmap) Then
				$hBitmap = $hSource
			Else
				$hBitmap = 0
			EndIf
			_WinAPI_SelectObject($hDC, $hSv)
			_WinAPI_DeleteDC($hDC)
		WEnd
		If Not $hBitmap Then
			ExitLoop
		EndIf
		For $i = 0 To 1
			$Size[$i] = DllStructGetData($tDIB, $i + 2)
		Next
		$tBits = DllStructCreate('byte[' & ($Size[0] * $Size[1] * 4) & ']')
		If Not _WinAPI_GetBitmapBits($hBitmap, DllStructGetSize($tBits), DllStructGetPtr($tBits)) Then
			ExitLoop
		EndIf
		$tData = DllStructCreate('uint;ptr;int;int')
		DllStructSetData($tData, 1, 1)
		$Ret = DllCall('gdiplus.dll', 'uint', 'GdiplusStartup', 'ptr*', 0, 'ptr', DllStructGetPtr($tData), 'ptr', 0)
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		If _WinAPI_IsAlphaBitmap($hBitmap) Then
			$Format = 0x0026200A
		Else
			$Format = 0x00022009
		EndIf
		$hToken = $Ret[1]
		$Ret = DllCall('gdiplus.dll', 'uint', 'GdipCreateBitmapFromScan0', 'int', $Size[0], 'int', $Size[1], 'uint', $Size[0] * 4, 'uint', $Format, 'ptr', DllStructGetPtr($tBits), 'ptr*', 0)
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		$hImage = $Ret[6]
		$Ret = DllCall('gdiplus.dll', 'uint', 'GdipGetImageEncodersSize', 'uint*', 0, 'uint*', 0)
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		$Count = $Ret[1]
		$tData = DllStructCreate('byte[' & $Ret[2] & ']')
		If @error Then
			ExitLoop
		EndIf
		$pData = DllStructGetPtr($tData)
		$Ret = DllCall('gdiplus.dll', 'uint', 'GdipGetImageEncoders', 'uint', $Count, 'uint', $Ret[2], 'ptr', $pData)
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		For $i = 1 To $Count
			$tInfo = DllStructCreate('byte[16];byte[16];ptr[5];dword[4];ptr[2]', $pData)
			If Not StringInStr(_WinAPI_WideCharToMultiByte(DllStructGetData($tInfo, 3, 5)), $Mime) Then
				$pData += DllStructGetSize($tInfo)
			Else
				$pEncoder = $pData
				ExitLoop
			EndIf
		Next
		If Not $pEncoder Then
			ExitLoop
		EndIf
		Switch $iCompression
			Case 0
				; Nothing
			Case 1
				$tParam = DllStructCreate('dword;byte[16];dword;dword;ptr;ulong')
				DllStructSetData($tParam, 1, 1)
				DllStructSetData($tParam, 3, 1)
				DllStructSetData($tParam, 4, 4)
				DllStructSetData($tParam, 5, DllStructGetPtr($tParam, 6))
				DllStructSetData($tParam, 6, $iQuality)
				$Ret = DllCall('ole32.dll', 'uint', 'CLSIDFromString', 'wstr', '{1D5BE4B5-FA4A-452D-9CDD-5DB35105E7EB}', 'ptr', DllStructGetPtr($tParam, 2))
				If (@error) Or ($Ret[0]) Then
					$tParam = 0
				EndIf
		EndSwitch
		$pStream = _WinAPI_CreateStreamOnHGlobal()
		$Ret = DllCall('gdiplus.dll', 'uint', 'GdipSaveImageToStream', 'ptr', $hImage, 'ptr', $pStream, 'ptr', $pEncoder, 'ptr', DllStructGetPtr($tParam))
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		$hMem = _WinAPI_GetHGlobalFromStream($pStream)
		$Ret = DllCall('kernel32.dll', 'ulong_ptr', 'GlobalSize', 'ptr', $hMem)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Length = $Ret[0]
		$Ret = DllCall('kernel32.dll', 'ptr', 'GlobalLock', 'ptr', $hMem)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$pBuffer = __HeapReAlloc($pBuffer, $Length, 1)
		If Not @error Then
			If _WinAPI_MoveMemory($pBuffer, $Ret[0], $Length) Then
				$Error = 0
			EndIf
		EndIf
	Until 1
	If $pStream Then
		_WinAPI_ReleaseStream($pStream)
	EndIf
	If $hImage Then
		DllCall('gdiplus.dll', 'uint', 'GdipDisposeImage', 'ptr', $hImage)
	EndIf
	If $hToken Then
		DllCall('gdiplus.dll', 'none', 'GdiplusShutdown', 'ptr', $hToken)
	EndIf
	If $hSource Then
		_WinAPI_DeleteObject($hSource)
	EndIf
	If $Error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Length
EndFunc   ;==>_WinAPI_CompressBitmapBits

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CompressBuffer
; Description....: Compresses a buffer with specified compression format and engine type.
; Syntax.........: _WinAPI_CompressBuffer ( $pUncompressedBuffer, $iUncompressedSize, $pCompressedBuffer, $iCompressedSize [, $iFormatAndEngine] )
; Parameters.....: $pUncompressedBuffer - A pointer to a caller-allocated buffer that contains the data to be compressed.
;                  $iUncompressedSize   - The size of the uncompressed buffer, in bytes.
;                  $pCompressedBuffer   - A pointer to a caller-allocated buffer that receives the compressed data.
;                  $iCompressedSize     - The size of the compressed buffer, in bytes.
;                  $iFormatAndEngine    - A bitmask that specifies the compression format and engine type. This parameter must be
;                                         set to a valid bitwise OR combination of one format type and one engine type.
;
;                                         $COMPRESSION_FORMAT_LZNT1
;                                         $COMPRESSION_FORMAT_XPRESS
;                                         $COMPRESSION_FORMAT_XPRESS_HUFF
;
;                                         $COMPRESSION_ENGINE_STANDARD
;                                         $COMPRESSION_ENGINE_MAXIMUM
;
; Return values..: Success              - The size of the compressed data stored in compressed buffer, in bytes.
;                  Failure              - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CompressBuffer() function takes as input an uncompressed buffer and produces its compressed equivalent
;                  provided that the compressed data fits within the specified destination buffer.
;
;                  To decompress a compressed buffer, use the _WinAPI_DecompressBuffer() function.
; Related........:
; Link...........: @@MsdnLink@@ RtlCompressBuffer
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CompressBuffer($pUncompressedBuffer, $iUncompressedSize, $pCompressedBuffer, $iCompressedSize, $iFormatAndEngine = 0x0002)

	Local $Ret, $pWorkSpace = 0, $Error = 1

	Do
		$Ret = DllCall('ntdll.dll', 'uint', 'RtlGetCompressionWorkSpaceSize', 'ushort', $iFormatAndEngine, 'ulong*', 0, 'ulong*', 0)
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		$pWorkSpace = __HeapAlloc($Ret[2])
		If @error Then
			ExitLoop
		EndIf
		$Ret = DllCall('ntdll.dll', 'uint', 'RtlCompressBuffer', 'ushort', $iFormatAndEngine, 'ptr', $pUncompressedBuffer, 'ulong', $iUncompressedSize, 'ptr', $pCompressedBuffer, 'ulong', $iCompressedSize, 'ulong', 4096, 'ulong*', 0, 'ptr', $pWorkSpace)
		If (@error) Or ($Ret[0]) Or (Not $Ret[7]) Then
			ExitLoop
		EndIf
		$Error = 0
	Until 1
	__HeapFree($pWorkSpace)
	If $Error Then
		If IsArray($Ret) Then
			Return SetError(1, $Ret[0], 0)
		Else
			Return SetError(9, 0, 0)
		EndIf
	EndIf
	Return $Ret[7]
EndFunc   ;==>_WinAPI_CompressBuffer

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ComputeCrc32
; Description....: Calculates the CRC32 checksum of a block of memory.
; Syntax.........: _WinAPI_ComputeCrc32 ( $pMemory, $iLength )
; Parameters.....: $pMemory - A pointer to the memory block to calculate the checksum.
;                  $iLength - The number of bytes to be calculated.
; Return values..: Success  - The CRC32 checksum (DWORD).
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ RtlComputeCrc32
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ComputeCrc32($pMemory, $iLength)

	Local $Ret = DllCall('ntdll.dll', 'dword', 'RtlComputeCrc32', 'dword', 0, 'ptr', $pMemory, 'int', $iLength)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ComputeCrc32

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ConfirmCredentials
; Description....: Confirms the validity of the credential harvested.
; Syntax.........: _WinAPI_ConfirmCredentials ( $sTarget, $fConfirm )
; Parameters.....: $sTarget  - The string that contains the name of the target for the credentials, typically a domain or server name.
;                              This must be the same value passed to _WinAPI_ShellUserAuthenticationDlg() function.
;                  $fConfirm - Specifies whether the credentials returned from the prompt function are valid, valid values:
;                  |TRUE     - The credentials are stored in the credential manager.
;                  |FALSE    - The credentials are not stored and various pieces of memory are cleaned up.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function function must be called after each successful call to _WinAPI_ShellUserAuthenticationDlg()
;                  with the $CREDUI_FLAGS_EXPECT_CONFIRMATION flag set.
; Related........:
; Link...........: @@MsdnLink@@ CredUIConfirmCredentials
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ConfirmCredentials($sTarget, $fConfirm)

	If Not __DLL('credui.dll') Then
		Return SetError(3, 0, 0)
	EndIf

	Local $Ret = DllCall('credui.dll', 'dword', 'CredUIConfirmCredentialsW', 'wstr', $sTarget, 'int', $fConfirm)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_ConfirmCredentials

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CopyBitmap
; Description....: Creates a duplicate of a specified bitmap with a device-independent bitmap (DIB) section.
; Syntax.........: _WinAPI_CopyBitmap ( $hBitmap )
; Parameters.....: $hBitmap - Handle to the bitmap to be duplicated.
; Return values..: Success  - Handle to the new bitmap that was created.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you are finished using the bitmap, destroy it using the _WinAPI_DeleteObject() function.
; Related........:
; Link...........: @@MsdnLink@@ CopyImage
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CopyBitmap($hBitmap)
	$hBitmap = _WinAPI_CopyImage($hBitmap, 0, 0, 0, 0x2000)
	If @error Then
		Return SetError(1, 0, $hBitmap)
	EndIf
	Return $hBitmap
EndFunc   ;==>_WinAPI_CopyBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CopyCursor
; Description....: Creates a duplicate of a specified cursor.
; Syntax.........: _WinAPI_CopyCursor ( $hCursor )
; Parameters.....: $hCursor - Handle to the cursor to be duplicated.
; Return values..: Success  - Handle to the new cursor that was created.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you are finished using the cursor, destroy it using the _WinAPI_DestroyCursor() function.
; Related........:
; Link...........: @@MsdnLink@@ CopyIcon
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CopyCursor($hCursor)
	Return _WinAPI_CopyIcon($hCursor)
EndFunc   ;==>_WinAPI_CopyCursor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CopyEnhMetaFile
; Description....: Copies the contents of an enhanced-format metafile to a specified file.
; Syntax.........: _WinAPI_CopyEnhMetaFile ( $hEmf [, $sFile] )
; Parameters.....: $hEmf   - Handle to the enhanced metafile to be copied.
;                  $sFile  - The name of the destination file (.emf). If this parameter is 0, the source metafile is copied to memory.
; Return values..: Success - Handle to the copy of the enhanced metafile.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When the application no longer needs an enhanced-metafile handle, it should delete the handle by calling the
;                  _WinAPI_DeleteEnhMetaFile() function.
; Related........:
; Link...........: @@MsdnLink@@ CopyEnhMetaFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CopyEnhMetaFile($hEmf, $sFile = '')

	Local $TypeOfFile = 'wstr'

	If Not StringStripWS($sFile, 3) Then
		$TypeOfFile = 'ptr'
		$sFile = 0
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CopyEnhMetaFileW', 'ptr', $hEmf, $TypeOfFile, $sFile)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CopyEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CopyFileEx
; Description....: Copies an existing file to a new file, notifying the application of its progress through a callback function.
; Syntax.........: _WinAPI_CopyFileEx ( $sExistingFile, $sNewFile [, $iFlags [, $pProgressProc [, $pData] )
; Parameters.....: $sExistingFile - The name of an existing file.
;                  $sNewFile      - The name of the new file.
;                  $iFlags        - The flags that specify how the file is to be copied. This parameter can be a combination
;                                   of the following values.
;
;                                   $COPY_FILE_ALLOW_DECRYPTED_DESTINATION
;                                   $COPY_FILE_COPY_SYMLINK
;                                   $COPY_FILE_FAIL_IF_EXISTS
;                                   $COPY_FILE_NO_BUFFERING
;                                   $COPY_FILE_OPEN_SOURCE_FOR_WRITE
;                                   $COPY_FILE_RESTARTABLE
;
;                  $pProgressProc - The address of a callback function that is called each time another portion of the file
;                                   has been copied.
;
;                                   (See MSDN for more information)
;
;                  $pData         - The argument to be passed to the callback function.
; Return values..: Success        - 1.
;                  Failure        - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CopyFileEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CopyFileEx($sExistingFile, $sNewFile, $iFlags = 0, $pProgressProc = 0, $pData = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'CopyFileExW', 'wstr', $sExistingFile, 'wstr', $sNewFile, 'ptr', $pProgressProc, 'long_ptr', $pData, 'ptr', 0, 'dword', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CopyFileEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CopyImage
; Description....: Creates a new image (icon, cursor, or bitmap) and copies the attributes of the specified image to the new one.
; Syntax.........: _WinAPI_CopyImage ( $hImage [, $iType [, $xDesired [, $yDesired [, $iFlags]]]] )
; Parameters.....: $hImage   - Handle to the image to be copied.
;                  $iType    - Specifies the type of image to be copied. This parameter can be one of the following values.
;
;                              $IMAGE_BITMAP
;                              $IMAGE_CURSOR
;                              $IMAGE_ICON
;
;                  $xDesired - Specifies the desired width, in pixels, of the image. If this is zero, then the returned image will
;                              have the same width as the original $hImage.
;                  $yDesired - Specifies the desired height, in pixels, of the image. If this is zero, then the returned image will
;                              have the same height as the original $hImage.
;                  $iFlags   - This parameter can be one or more of the following values.
;
;                              $LR_COPYDELETEORG
;                              $LR_COPYFROMRESOURCE
;                              $LR_COPYRETURNORG
;                              $LR_CREATEDIBSECTION
;                              $LR_DEFAULTSIZE
;                              $LR_MONOCHROME
;
; Return values..: Success   - Handle to the newly created image.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you are finished using the resource, you can release its associated memory by calling _WinAPI_DeleteObject()
;                  function respectively for bitmaps, cursors, or icons. The system automatically deletes the resource when its
;                  process terminates, however, calling the appropriate function saves memory and decreases the size of the
;                  process's working set.
; Related........:
; Link...........: @@MsdnLink@@ CopyImage
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CopyImage($hImage, $iType = 0, $xDesired = 0, $yDesired = 0, $iFlags = 0)

	Local $Ret = DllCall('user32.dll', 'ptr', 'CopyImage', 'ptr', $hImage, 'int', $iType, 'int', $xDesired, 'int', $yDesired, 'int', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CopyImage

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CopyRect
; Description....: Copies the coordinates of one rectangle to another.
; Syntax.........: _WinAPI_CopyRect ( $tRECT )
; Parameters.....: $tRECT  - $tagRECT structure whose coordinates are to be copied in logical units.
; Return values..: Success - $tagRECT structure that contains the logical coordinates of the source rectangle.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CopyRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CopyRect($tRECT)

	Local $tData = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'int', 'CopyRect ', 'ptr', DllStructGetPtr($tData), 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tData
EndFunc   ;==>_WinAPI_CopyRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CopyStruct
; Description....: Creates a duplicate of a specified structure.
; Syntax.........: _WinAPI_CopyStruct ( $tStruct [, $sStruct] )
; Parameters.....: $tStruct - The structure to be duplicated.
;                  $sStruct - The string representing the structure (same as for the DllStructCreate() function).
; Return values..: Success  - "byte[n]" or $sStruct structure that was created.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CopyStruct($tStruct, $sStruct = '')

	Local $Size = DllStructGetSize($tStruct)

	If Not $Size Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tResult

	If Not StringStripWS($sStruct, 7) Then
		$tResult = DllStructCreate('byte[' & $Size & ']')
	Else
		$tResult = DllStructCreate($sStruct)
	EndIf
	If DllStructGetSize($tResult) < $Size Then
		Return SetError(1, 0, 0)
	EndIf
	If Not _WinAPI_MoveMemory(DllStructGetPtr($tResult), DllStructGetPtr($tStruct), $Size) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tResult
EndFunc   ;==>_WinAPI_CopyStruct

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CoTaskMemAlloc
; Description....: Allocates a block of task memory.
; Syntax.........: _WinAPI_CoTaskMemAlloc ( $iSize )
; Parameters.....: $iSize  - The size of the memory block to be allocated, in bytes.
; Return values..: Success - The allocated memory block.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If $iSize is 0, _WinAPI_CoTaskMemAlloc() allocates a zero-length item and returns a valid pointer to that item.
;                  The allocated block may be larger than $iSize bytes because of the space required for alignment and for
;                  maintenance information.
; Related........:
; Link...........: @@MsdnLink@@ CoTaskMemAlloc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CoTaskMemAlloc($iSize)

	Local $Ret = DllCall('ole32.dll', 'ptr', 'CoTaskMemAlloc', 'uint_ptr', $iSize)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CoTaskMemAlloc

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CoTaskMemFree
; Description....: Frees a block of task memory.
; Syntax.........: _WinAPI_CoTaskMemFree ( $pMemory )
; Parameters.....: $pMemory - The pointer to the memory block to be freed.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CoTaskMemFree
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CoTaskMemFree($pMemory)
	DllCall('ole32.dll', 'none', 'CoTaskMemFree', 'ptr', $pMemory)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CoTaskMemFree

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CoTaskMemRealloc
; Description....: Changes the size of a previously allocated block of task memory.
; Syntax.........: _WinAPI_CoTaskMemRealloc ( $pMemory, $iSize )
; Parameters.....: $pMemory - The pointer to the memory block to be reallocated.
;                  $iSize   - The size of the memory block to be reallocated, in bytes.
; Return values..: Success  - The reallocated memory block.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If $pMemory is 0, function allocates a new memory block in the same way as the _WinAPI_CoTaskMemAlloc() function.
;                  If $pMemory is not 0, it should be a pointer returned by a prior call to _WinAPI_CoTaskMemAlloc().
;
;                  The contents of the block are unchanged up to the shorter of the new and old sizes, although the new block
;                  can be in a different location. If $pMemory is not 0 and $iSize is 0, then the memory pointed to by
;                  $pMemory is freed.
; Related........:
; Link...........: @@MsdnLink@@ CoTaskMemRealloc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CoTaskMemRealloc($pMemory, $iSize)

	Local $Ret = DllCall('ole32.dll', 'ptr', 'CoTaskMemRealloc', 'ptr', $pMemory, 'uint_ptr', $iSize)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CoTaskMemRealloc

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CoUninitialize
; Description....: Closes the COM library on the current process.
; Syntax.........: _WinAPI_CoUninitialize ( )
; Parameters.....: None
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CoUninitialize
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CoUninitialize()
	DllCall('ole32.dll', 'none', 'CoUninitialize')
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CoUninitialize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_Create32BitHBITMAP
; Description....: Creates a 32 bits-per-pixel bitmap from the specified icon.
; Syntax.........: _WinAPI_Create32BitHBITMAP ( $hIcon [, $fDib [, $fDelete]] )
; Parameters.....: $hIcon   - Handle to the source icon.
;                  $fDib    - Specifies whether to create device-independent (DIB) or device-dependent (DDB) bitmap, valid values:
;                  |TRUE    - Creates DIB.
;                  |FALSE   - Creates DDB. (Default)
;                  $fDelete - Specifies whether to delete the icon after the function is successful, valid values:
;                  |TRUE    - Icon will be deleted if the function succeeds.
;                  |FALSE   - Do not delete, you must release the icon when you are finished using it. (Default)
; Return values..: Success  - Handle to the created bitmap.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_Create32BitHBITMAP() creates a 32 bits-per-pixel bitmap with alpha chanel (if possible) from the icons
;                  with any color depth. The function internally converts the specified icon to the 32 bits-per-pixel icon.
;
;                  When you are finished using the bitmap, destroy it using the _WinAPI_DeleteObject() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_Create32BitHBITMAP($hIcon, $fDib = 0, $fDelete = 0)

	Local $tBITMAP, $tICONINFO, $hDC, $hSv, $Ret, $hTemp, $hBitmap = 0
	Local $DIB[2] = [0, 0]

	$hTemp = _WinAPI_Create32BitHICON($hIcon)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Do
		$tICONINFO = DllStructCreate($tagICONINFO)
		$Ret = DllCall('user32.dll', 'int', 'GetIconInfo', 'ptr', $hTemp, 'ptr', DllStructGetPtr($tICONINFO))
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		For $i = 0 To 1
			$DIB[$i] = DllStructGetData($tICONINFO, $i + 4)
		Next
		$tBITMAP = DllStructCreate($tagBITMAP)
		If Not _WinAPI_GetObject($DIB[0], DllStructGetSize($tBITMAP), DllStructGetPtr($tBITMAP)) Then
			ExitLoop
		EndIf
		If $fDib Then
			$hBitmap = _WinAPI_CreateDIB(DllStructGetData($tBITMAP, 'bmWidth'), DllStructGetData($tBITMAP, 'bmHeight'))
			$hDC = _WinAPI_CreateCompatibleDC(0)
			$hSv = _WinAPI_SelectObject($hDC, $hBitmap)
			_WinAPI_DrawIconEx($hDC, 0, 0, $hTemp)
			_WinAPI_SelectObject($hDC, $hSv)
			_WinAPI_DeleteDC($hDC)
		Else
			$hBitmap = $DIB[1]
			$DIB[1] = 0
		EndIf
	Until 1
	For $i = 0 To 1
		If $DIB[$i] Then
			_WinAPI_DeleteObject($DIB[$i])
		EndIf
	Next
	_WinAPI_DestroyIcon($hTemp)
	If Not $hBitmap Then
		Return SetError(1, 0, 0)
	EndIf
	If $fDelete Then
		_WinAPI_DestroyIcon($hIcon)
	EndIf
	Return $hBitmap
EndFunc   ;==>_WinAPI_Create32BitHBITMAP

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_Create32BitHICON
; Description....: Converts an icon to a 32 bits-per-pixel format and copies to the new icon.
; Syntax.........: _WinAPI_Create32BitHICON ( $hIcon [, $fDelete] )
; Parameters.....: $hIcon   - Handle to the icon to be converted.
;                  $fDelete - Specifies whether to delete the icon after the function is successful, valid values:
;                  |TRUE    - Icon will be deleted if the function succeeds.
;                  |FALSE   - Do not delete, you must release the icon themselves when you are finished using it. (Default)
; Return values..: Success  - Handle to the newly created icon.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function converts an icon with any color depth into an icon with 32 bits-per-pixel (RGB + Alpha) format.
;                  If the source icon already is a 32 bits-per-pixel icon, and has an alpha chanel, the function generates the new
;                  AND bitmask bitmap, and copies it to a new icon. If the source icon has a 32 bits-per-pixel color depth, and
;                  do not have an alpha chanel, the function creates an alpha chanel from its AND bitmask. If the source icon is
;                  non 32 bits-per-pixel icon, it will be converted into a 32 bits-per-pixel format with alpha chanel.
;                  The _WinAPI_Create32BitHICON() always creates an icon with alpha channel and AND bitmask, although it
;                  is not used to display icons that contain an alpha channel.
;
;                  Note that to display the fully transparent icons used only its AND bitmask, not the alpha channel. Therefore,
;                  its XOR and AND bitmasks will remain unchanged.
;
;                  When you are finished using the icon, destroy it using the _WinAPI_DestroyIcon() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_Create32BitHICON($hIcon, $fDelete = 0)

	Local $tICONINFO, $tSIZE, $hBitmap[2], $Size[2], $Ret, $hSrcDC, $hSrcSv, $hDstDC, $hDstSv, $hResult = 0
	Local $DIB[2][2] = [[0, 0], [0, 0]]

	$tICONINFO = DllStructCreate($tagICONINFO)
	$Ret = DllCall('user32.dll', 'int', 'GetIconInfo', 'ptr', $hIcon, 'ptr', DllStructGetPtr($tICONINFO))
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	For $i = 0 To 1
		$hBitmap[$i] = DllStructGetData($tICONINFO, $i + 4)
	Next
	If _WinAPI_IsAlphaBitmap($hBitmap[1]) Then
		$DIB[0][0] = _WinAPI_CreateANDBitmap($hBitmap[1])
		If Not @error Then
			$hResult = _WinAPI_CreateIconIndirect($hBitmap[1], $DIB[0][0])
		EndIf
	Else
		$tSIZE = _WinAPI_GetBitmapDimension($hBitmap[1])
		For $i = 0 To 1
			$Size[$i] = DllStructGetData($tSIZE, $i + 1)
		Next
		$hSrcDC = _WinAPI_CreateCompatibleDC(0)
		$hDstDC = _WinAPI_CreateCompatibleDC(0)
		For $i = 0 To 1
			$DIB[$i][0] = _WinAPI_CreateDIB($Size[0], $Size[1])
			$DIB[$i][1] = $__Ext
			$hSrcSv = _WinAPI_SelectObject($hSrcDC, $hBitmap[$i])
			$hDstSv = _WinAPI_SelectObject($hDstDC, $DIB[$i][0])
			_WinAPI_BitBlt($hDstDC, 0, 0, $Size[0], $Size[1], $hSrcDC, 0, 0, 0x00C000CA)
			_WinAPI_SelectObject($hSrcDC, $hSrcSv)
			_WinAPI_SelectObject($hDstDC, $hDstSv)
		Next
		_WinAPI_DeleteDC($hSrcDC)
		_WinAPI_DeleteDC($hDstDC)
		$Ret = DllCall('user32.dll', 'int', 'CallWindowProc', 'ptr', __XORProc(), 'ptr', 0, 'uint', $Size[0] * $Size[1] * 4, 'ptr', $DIB[0][1], 'ptr', $DIB[1][1])
		If (Not @error) And ($Ret[0]) Then
			$hResult = _WinAPI_CreateIconIndirect($DIB[1][0], $hBitmap[0])
		EndIf
	EndIf
	For $i = 0 To 1
		_WinAPI_DeleteObject($hBitmap[$i])
		If $DIB[$i][0] Then
			_WinAPI_DeleteObject($DIB[$i][0])
		EndIf
	Next
	If Not $hResult Then
		Return SetError(1, 0, 0)
	EndIf
	If $fDelete Then
		_WinAPI_DestroyIcon($hIcon)
	EndIf
	Return $hResult
EndFunc   ;==>_WinAPI_Create32BitHICON

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateANDBitmap
; Description....: Creates AND bitmask device-independent bitmap (DIB) from the specified bitmap.
; Syntax.........: _WinAPI_CreateANDBitmap ( $hBitmap )
; Parameters.....: $hBitmap - Handle to the bitmap from which to create AND bitmask DIB.
; Return values..: Success  - Handle to the DIB.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CreateANDBitmap() creates a 1 bits-per-pixel AND bitmask DIB from the 32 bits-per-pixel DIB or DDB.
;                  If the source bitmap is non 32 bits-per-pixel bitmap, or is a compressed bitmap, the function fails.
;
;                  You can use the bitmap returned by this function to create icon by using the _WinAPI_CreateIconIndirect().
;
;                  When you are finished using the bitmap, destroy it using the _WinAPI_DeleteObject() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateANDBitmap($hBitmap)

	Local $tDIB[2], $Ret, $Error, $hDib = 0

	$hBitmap = _WinAPI_CopyBitmap($hBitmap)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Do
		$Error = 1
		$tDIB[0] = DllStructCreate($tagDIBSECTION)
		If (Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tDIB[0]), DllStructGetPtr($tDIB[0]))) Or (DllStructGetData($tDIB[0], 'bmBitsPixel') <> 32) Or (DllStructGetData($tDIB[0], 'biCompression')) Then
			ExitLoop
		EndIf
		$tDIB[1] = DllStructCreate($tagBITMAP)
		$hDib = _WinAPI_CreateDIB(DllStructGetData($tDIB[0], 'bmWidth'), DllStructGetData($tDIB[0], 'bmHeight'), 1)
		If Not _WinAPI_GetObject($hDib, DllStructGetSize($tDIB[1]), DllStructGetPtr($tDIB[1])) Then
			ExitLoop
		EndIf
		$Ret = DllCall('user32.dll', 'int', 'CallWindowProc', 'ptr', __ANDProc(), 'ptr', 0, 'uint', 0, 'ptr', DllStructGetPtr($tDIB[0]), 'ptr', DllStructGetPtr($tDIB[1]))
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Error = 0
	Until 1
	_WinAPI_DeleteObject($hBitmap)
	If $Error Then
		If $hDib Then
			_WinAPI_DeleteObject($hDib)
		EndIf
		$hDib = 0
	EndIf
	Return SetError($Error, 0, $hDib)
EndFunc   ;==>_WinAPI_CreateANDBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateBitmapIndirect
; Description....: Creates a bitmap with the specified width, height, and color format (color planes and bits-per-pixel).
; Syntax.........: _WinAPI_CreateBitmapIndirect ( $tBITMAP )
; Parameters.....: $tBITMAP - $tagBITMAP structure that contains information about the bitmap. If an application sets the "bmWidth"
;                             or "bmHeight" members to zero, _WinAPI_CreateBitmapIndirect() returns the handle to a 1-by-1 pixel,
;                             monochrome bitmap.
; Return values..: Success  - Handle to the device-dependent (DDB) bitmap.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you no longer need the bitmap, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: @@MsdnLink@@ CreateBitmapIndirect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateBitmapIndirect($tBITMAP)

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreateBitmapIndirect', 'ptr', DllStructGetPtr($tBITMAP))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateBitmapIndirect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateBrushIndirect
; Description....: Creates a logical brush that has the specified style, color, and pattern.
; Syntax.........: _WinAPI_CreateBrushIndirect ( $iStyle, $iRGB, $iHatch )
; Parameters.....: $iStyle - The brush style. This parameter can be one of the following styles.
;
;                            $BS_DIBPATTERN
;                            $BS_DIBPATTERN8X8
;                            $BS_DIBPATTERNPT
;                            $BS_HATCHED
;                            $BS_HOLLOW
;                            $BS_NULL
;                            $BS_PATTERN
;                            $BS_PATTERN8X8
;                            $BS_SOLID
;
;                  $iRGB   - The color of a brush, in RGB, or one of the following values.
;
;                            $DIB_PAL_COLORS
;                            $DIB_RGB_COLORS
;
;                  $iHatch - A hatch style. The meaning depends on the brush style defined by $iStyle parameter.
;
;                            $BS_DIBPATTERN
;                            Contains a handle to a packed DIB.
;
;                            $BS_DIBPATTERNPT
;                            Contains a pointer to a packed DIB.
;
;                            $BS_HATCHED
;                            Specifies the orientation of the lines used to create the hatch. It can be one of the orientation constants ($HS_*).
;
;                            $BS_PATTERN
;                            Contains a handle to the bitmap that defines the pattern. The bitmap cannot be a DIB section bitmap.
;
;                            $BS_HOLLOW, $BS_SOLID
;                            Ignored.
;
; Return values..: Success - Handle to the brush.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After an application creates a brush by calling _WinAPI_CreateBrushIndirect(), it can select it into any
;                  device context by calling the _WinAPI_SelectObject() function. When you no longer need the brush,
;                  call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: @@MsdnLink@@ CreateBrushIndirect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateBrushIndirect($iStyle, $iRGB, $iHatch = 0)

	Local $tLOGBRUSH = DllStructCreate($tagLOGBRUSH)

	DllStructSetData($tLOGBRUSH, 1, $iStyle)
	DllStructSetData($tLOGBRUSH, 2, __RGB($iRGB))
	DllStructSetData($tLOGBRUSH, 3, $iHatch)

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreateBrushIndirect', 'ptr', DllStructGetPtr($tLOGBRUSH))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateBrushIndirect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateBuffer
; Description....: Allocates a block of memory from the internal library heap.
; Syntax.........: _WinAPI_CreateBuffer ( $iLength [, $pBuffer [, $fAbort]] )
; Parameters.....: $iLength  - The required buffer length, in bytes.
;                  $pBuffer  - A pointer to a buffer that to be replaced by a new buffer. If this parameter is a valid buffer pointer,
;                              the memory will be reallocated for a new buffer. However, a new memory is allocated at a different
;                              location. Therefore, you should always use a pointer that returns this function. If this parameter is
;                              0, omitted, or an invalid buffer pointer, the function just allocates a new memory.
;                  $fAbort   - Specifies whether to exit the script if not enough memory, valid values:
;                  |TRUE     - Displaying an error message and exit the script with code 1. (Default)
;                  |FALSE    - Continue the script and return an error.
; Return values..: Success   - A pointer to the new buffer.
;                  Failure   - 0 and sets the @error flag to non-zero (if an exceptions is not set).
; Author.........: Yashied
; Modified.......:
; Remarks........: When a buffer is no longer needed, you must destroy it by calling the _WinAPI_FreeMemory() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateBuffer($iLength, $pBuffer = 0, $fAbort = 1)
	$pBuffer = __HeapReAlloc($pBuffer, $iLength, 0, $fAbort)
	If @error Then
		Return SetError(@error, 0, 0)
	EndIf
	Return $pBuffer
EndFunc   ;==>_WinAPI_CreateBuffer

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateCaret
; Description....: Creates a new shape for the system caret and assigns ownership of the caret to the specified window.
; Syntax.........: _WinAPI_CreateCaret ( $hWnd, $hBitmap [, $iWidth [, $iHeight]] )
; Parameters.....: $hWnd    - Handle to the window that owns the caret.
;                  $hBitmap - Handle to the bitmap that defines the caret shape. If this parameter is 0, the caret is solid.
;                             If this parameter is 1, the caret is gray. If this parameter is a bitmap handle, the caret is
;                             the specified bitmap.
;                  $iWidth  - The width of the caret in logical units. If this parameter is 0, the width is set to the system-defined
;                             window border width. If $hBitmap is a bitmap handle, _WinAPI_CreateCaret() ignores this parameter.
;                  $iHeight - The height of the caret in logical units. If this parameter is 0, the height is set to the system-defined
;                             window border height. If $hBitmap  is a bitmap handle, _WinAPI_CreateCaret() ignores this parameter.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: _WinAPI_CreateCaret() automatically destroys the previous caret shape, if any, regardless of the window that owns the caret.
;                  The caret is hidden until the application calls the _WinAPI_ShowCaret() function to make the caret visible.
;
;                  The system provides one caret per queue. A window should create a caret only when it has the keyboard focus or is active.
;                  The window should destroy the caret before losing the keyboard focus or becoming inactive.
;
;                  You can retrieve the width or height of the system's window border by using the _WinAPI_GetSystemMetrics() function,
;                  specifying the $SM_CXBORDER and $SM_CYBORDER values. Using the window border width or height guarantees that the
;                  caret will be visible on a high-resolution screen.
; Related........:
; Link...........: @@MsdnLink@@ CreateCaret
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateCaret($hWnd, $hBitmap, $iWidth = 0, $iHeight = 0)

	Local $Ret = DllCall('user32.dll', 'int', 'CreateCaret', 'hwnd', $hWnd, 'ptr', $hBitmap, 'int', $iWidth, 'int', $iHeight)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CreateCaret

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateColorAdjustment
; Description....: Ceates $tagCOLORADJUSTMENT structure specifies the color adjustment.
; Syntax.........: _WinAPI_CreateColorAdjustment ( [$iFlags [, $iIlluminant [, $iGammaR [, $iGammaG [, $iGammaB [, $iBlack [, $iWhite [, $iContrast [, $iBrightness [, $iColorfulness [, $iTint]]]]]]]]]]] )
; Parameters.....: $iFlags        - The flags that specify how the output image should be prepared. This parameter can be 0 or any
;                                   combination of the following values.
;
;                                   $CA_NEGATIVE
;                                   $CA_LOG_FILTER
;
;                  $iIlluminant   - The type of standard light source under which the image is viewed. This parameter can be only
;                                   one of the following values.
;
;                                   $ILLUMINANT_DEVICE_DEFAULT
;                                   $ILLUMINANT_A
;                                   $ILLUMINANT_B
;                                   $ILLUMINANT_C
;                                   $ILLUMINANT_D50
;                                   $ILLUMINANT_D55
;                                   $ILLUMINANT_D65
;                                   $ILLUMINANT_D75
;                                   $ILLUMINANT_F2
;                                   $ILLUMINANT_TUNGSTEN
;                                   $ILLUMINANT_DAYLIGHT
;                                   $ILLUMINANT_FLUORESCENT
;                                   $ILLUMINANT_NTSC
;
;                  $iGammaR       - The n(th) power gamma-correction value for the red primary of the source colors. The value
;                                   must be in the range from 2500 to 65,000. A value of 10,000 means no gamma correction.
;                  $iGammaG       - The n(th) power gamma-correction value for the green primary of the source colors. The value
;                                   must be in the range from 2500 to 65,000. A value of 10,000 means no gamma correction.
;                  $iGammaB       - The n(th) power gamma-correction value for the blue primary of the source colors. The value
;                                   must be in the range from 2500 to 65,000. A value of 10,000 means no gamma correction.
;                  $iBlack        - The black reference for the source colors. Any colors that are darker than this are treated
;                                   as black. The value must be in the range from 0 to 4000.
;                  $iWhite        - The white reference for the source colors. Any colors that are lighter than this are treated
;                                   as white. The value must be in the range from 6000 to 10,000.
;                  $iContrast     - The amount of contrast to be applied to the source object. The value must be in the range
;                                   from -100 to 100. A value of 0 means no contrast adjustment.
;                  $iBrightness   - The amount of brightness to be applied to the source object. The value must be in the range
;                                   from -100 to 100. A value of 0 means no brightness adjustment.
;                  $iColorfulness - The amount of colorfulness to be applied to the source object. The value must be in the range
;                                   from -100 to 100. A value of 0 means no colorfulness adjustment.
;                  $iTint         - The amount of red or green tint adjustment to be applied to the source object. The value must
;                                   be in the range from -100 to 100. Positive numbers adjust toward red and negative numbers
;                                   adjust toward green. A value of 0 means no tint adjustment.
; Return values..: Success - $tagCOLORADJUSTMENT structure containing the color adjustment values.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateColorAdjustment($iFlags = 0, $iIlluminant = 0, $iGammaR = 10000, $iGammaG = 10000, $iGammaB = 10000, $iBlack = 0, $iWhite = 10000, $iContrast = 0, $iBrightness = 0, $iColorfulness = 0, $iTint = 0)

	Local $tCA = DllStructCreate($tagCOLORADJUSTMENT)

	DllStructSetData($tCA, 1, DllStructGetSize($tCA))
	DllStructSetData($tCA, 2, $iFlags)
	DllStructSetData($tCA, 3, $iIlluminant)
	DllStructSetData($tCA, 4, $iGammaR)
	DllStructSetData($tCA, 5, $iGammaG)
	DllStructSetData($tCA, 6, $iGammaB)
	DllStructSetData($tCA, 7, $iBlack)
	DllStructSetData($tCA, 8, $iWhite)
	DllStructSetData($tCA, 9, $iContrast)
	DllStructSetData($tCA, 10, $iBrightness)
	DllStructSetData($tCA, 11, $iColorfulness)
	DllStructSetData($tCA, 12, $iTint)

	Return $tCA
EndFunc   ;==>_WinAPI_GetColorAdjustment

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateCompatibleBitmapEx
; Description....: Creates a bitmap compatible with the device and fills it the specified color.
; Syntax.........: _WinAPI_CreateSolidBitmapEx ( $hDC, $iWidth, $iHeight, $iRGB )
; Parameters.....: $hDC     - Handle to a device context.
;                  $iWidht  - The bitmap width, in pixels.
;                  $iHeight - The bitmap height, in pixels.
;                  $iRGB    - The bitmap color, in RGB.
; Return values..: Success  - Handle to the compatible solid bitmap (DDB).
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The color format of the bitmap created by the _WinAPI_CreateCompatibleBitmapEx() function matches the color
;                  format of the device identified by the hdc parameter. This bitmap can be selected into any memory device context
;                  that is compatible with the original device.
;
;                  When you no longer need the bitmap, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateCompatibleBitmapEx($hDC, $iWidth, $iHeight, $iRGB)

	Local $Ret, $tRECT, $hBmp, $hBrush, $hDestDC, $hDestSv

	$hBrush = _WinAPI_CreateBrushIndirect(0, $iRGB)
	$Ret = DllCall('gdi32.dll', 'hwnd', 'CreateCompatibleDC', 'hwnd', $hDC)
	$hDestDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'CreateCompatibleBitmap', 'hwnd', $hDC, 'int', $iWidth, 'int', $iHeight)
	$hBmp = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'SelectObject', 'hwnd', $hDestDC, 'ptr', $hBmp)
	$hDestSv = $Ret[0]
	$tRECT = _WinAPI_CreateRectEx(0, 0, $iWidth, $iHeight)
	$Ret = DllCall('user32.dll', 'int', 'FillRect', 'hwnd', $hDestDC, 'ptr', DllStructGetPtr($tRECT), 'ptr', $hBrush)
	If (@error) Or (Not $Ret[0]) Then
		_WinAPI_DeleteObject($hBmp)
		$Ret = 0
	EndIf
	_WinAPI_DeleteObject($hBrush)
	DllCall('gdi32.dll', 'ptr', 'SelectObject', 'hwnd', $hDestDC, 'ptr', $hDestSv)
	DllCall('gdi32.dll', 'int', 'DeleteDC', 'hwnd', $hDestDC)
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $hBmp
EndFunc   ;==>_WinAPI_CreateCompatibleBitmapEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateDesktop
; Description....: Creates a new desktop, associates it with the current window station of the calling process.
; Syntax.........: _WinAPI_CreateDesktop ( $sName [, $iAccess [, $iFlags [, $iHeap [, $tSecurity]]]] )
; Parameters.....: $sName     - The name of the desktop to be created. Desktop names are case-insensitive and may not contain backslash characters (\).
;                  $iAccess   - The requested access to the desktop. This parameter can be one or more of the following values.
;
;                               $DESKTOP_ALL_ACCESS
;                               $DESKTOP_CREATEMENU
;                               $DESKTOP_CREATEWINDOW
;                               $DESKTOP_ENUMERATE
;                               $DESKTOP_HOOKCONTROL
;                               $DESKTOP_JOURNALPLAYBACK
;                               $DESKTOP_JOURNALRECORD
;                               $DESKTOP_READOBJECTS
;                               $DESKTOP_SWITCHDESKTOP
;                               $DESKTOP_WRITEOBJECTS
;
;                  $iFlags    - The optional flags. It can be zero or the following value.
;
;                               $DF_ALLOWOTHERACCOUNTHOOK
;
;                  $iHeap     - The size of the desktop heap, in kilobytes.
;                  $tSecurity - $tagSECURITY_ATTRIBUTES structure that determines whether the returned handle can be inherited by
;                               child processes. If this parameter is 0, the handle cannot be inherited.
; Return values..: Success    - Handle to the newly created desktop. If the specified desktop already exists, the function succeeds and
;                               returns a handle to the existing desktop.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The number of desktops that can be created is limited by the size of the system desktop heap. You can increase the
;                  number of desktops that can be created by increasing the size of the desktop heap or by reducing the default heap
;                  reserved for each desktop in the interactive window station. The default size of the desktop heap depends on factors
;                  such as hardware architecture. To retrieve the size of the heap, call the _WinAPI_GetUserObjectInformation()
;                  function with $UOI_HEAPSIZE.
;
;                  When you are finished using the desktop, call the _WinAPI_CloseDesktop() function to close it.
; Related........:
; Link...........: @@MsdnLink@@ CreateDesktopEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateDesktop($sName, $iAccess = 0x0002, $iFlags = 0, $iHeap = 0, $tSecurity = 0)

	Local $Ret

	If $iHeap Then
		$Ret = DllCall('user32.dll', 'ptr', 'CreateDesktopExW', 'wstr', $sName, 'ptr', 0, 'ptr', 0, 'dword', $iFlags, 'dword', $iAccess, 'ptr', DllStructGetPtr($tSecurity), 'ulong', $iHeap, 'ptr', 0)
	Else
		$Ret = DllCall('user32.dll', 'ptr', 'CreateDesktopW', 'wstr', $sName, 'ptr', 0, 'ptr', 0, 'dword', $iFlags, 'dword', $iAccess, 'ptr', DllStructGetPtr($tSecurity))
	EndIf
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateDesktop

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateDIB
; Description....: Creates an uncompressed device-independent bitmap (DIB) with the specified width, height, and color depth.
; Syntax.........: _WinAPI_CreateDIB ( $iWidth, $iHeight [, $iBitsPerPel [, $tColorTable [, $iColorCount]]] )
; Parameters.....: $iWidth      - The width of the bitmap, in pixels.
;                  $iHeight     - The height of the bitmap, in pixels. If this value is positive, the bitmap is a bottom-up DIB
;                                 and its origin is the lower-left corner, otherwise, the bitmap is a top-down DIB and its origin
;                                 is the upper-left corner.
;                  $iBitsPerPel - The number of bits that define each pixel and the maximum number of colors in the bitmap.
;                  $tColorTable - "dword[n]" structure that represents a DIB color table. The number of colors in this table
;                                 depends on the values of the $iBitsPerPel parameters.
;                  $iColorCount - The number of color indexes in the DIB color table that are actually used by the bitmap.
;                                 The value of this parameter should not exceed the number of colors in the color table pointed
;                                 to by the $pColorTable parameter.
; Return values..: Success      - Handle to the DIB.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the bitmap is monochrome (1 bits-per-pixel), the color table should contain two entries. If the color table
;                  is not specified, the function creates a monochrome bitmap with black and white colors. If the bitmap use 4 or
;                  8 bits-per-pixel, the color table should contain up to 16 or 256 entries respectively. In this case, if the
;                  color table is not specified, the function creates an empty color table (all colors is black) with the maximum
;                  possible number of entries for the specified color depth. You can fill out this color table later by using the
;                  _WinAPI_SetDIBColorTable() function. If the bitmap use 16, 24, or 32 bits-per-pixel, the color table is not
;                  used, and $tColorTable parameter is ignored.
;
;                  This function does not create a compressed 16, 24, or 32 bits-per-pixel bitmaps, that is the "biCompression"
;                  member of $tagBITMAPINFO structure is always 0 ($BI_RGB).
;
;                  When you are finished using the bitmap, destroy it using the _WinAPI_DeleteObject() function.
;
;                  Call _WinAPI_GetExtended() to retrieve a pointer to the location of the DIB bit values.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateDIB($iWidth, $iHeight, $iBitsPerPel = 32, $tColorTable = 0, $iColorCount = 0)

	Local $tBITMAPINFO, $RGBQ[2], $hBitmap, $Colors

	Switch $iBitsPerPel
		Case 1
			$Colors = 2
		Case 4
			$Colors = 16
		Case 8
			$Colors = 256
		Case Else
			$Colors = 0
	EndSwitch
	If $Colors Then
		If Not IsDllStruct($tColorTable) Then
			Switch $iBitsPerPel
				Case 1
					$RGBQ[0] = 0
					$RGBQ[1] = 0xFFFFFF
					$tColorTable = _WinAPI_CreateDIBColorTable($RGBQ)
				Case Else

			EndSwitch
		Else
			If $Colors > $iColorCount Then
				$Colors = $iColorCount
			EndIf
			If (Not $Colors) Or ((4 * $Colors) > DllStructGetSize($tColorTable)) Then
				Return SetError(1, 0, 0)
			EndIf
		EndIf
		$RGBQ = 'dword[' & $Colors & ']'
	Else
		$RGBQ = ''
	EndIf
	$tBITMAPINFO = DllStructCreate($tagBITMAPINFOHEADER & $RGBQ)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	DllStructSetData($tBITMAPINFO, 'biSize', 40)
	DllStructSetData($tBITMAPINFO, 'biWidth', $iWidth)
	DllStructSetData($tBITMAPINFO, 'biHeight', $iHeight)
	DllStructSetData($tBITMAPINFO, 'biPlanes', 1)
	DllStructSetData($tBITMAPINFO, 'biBitCount', $iBitsPerPel)
	DllStructSetData($tBITMAPINFO, 'biCompression', 0)
	DllStructSetData($tBITMAPINFO, 'biSizeImage', 0)
	DllStructSetData($tBITMAPINFO, 'biXPelsPerMeter', 0)
	DllStructSetData($tBITMAPINFO, 'biYPelsPerMeter', 0)
	DllStructSetData($tBITMAPINFO, 'biClrUsed', $Colors)
	DllStructSetData($tBITMAPINFO, 'biClrImportant', 0)
	If $Colors Then
		If IsDllStruct($tColorTable) Then
			_WinAPI_MoveMemory(DllStructGetPtr($tBITMAPINFO) + 40, DllStructGetPtr($tColorTable), 4 * $Colors)
		Else
			_WinAPI_ZeroMemory(DllStructGetPtr($tBITMAPINFO) + 40, 4 * $Colors)
		EndIf
	EndIf
	$hBitmap = _WinAPI_CreateDIBSection(0, $tBITMAPINFO, 0, $__Ext)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $hBitmap
EndFunc   ;==>_WinAPI_CreateDIB

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateDIBColorTable
; Description....: Creates RGB color table from the specified array of colors.
; Syntax.........: _WinAPI_CreateDIBColorTable ( Const ByRef $aColorTable [, $iStart [, $iEnd]] )
; Parameters.....: $aColorTable - The array of colors, in RGB, that to be make up the DIB color table.
;                  $iStart      - The index of array to start creating at.
;                  $iEnd        - The index of array to stop creating at.
; Return values..: Success      - "dword[n]" structure that represents a DIB color table.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The color table created by this function is typically used in _WinAPI_CreateDIB() or _WinAPI_CreateDIBSection()
;                  function to create 1, 4, or 8 bits-per-pixel device-independent bitmap (DIB).
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateDIBColorTable(Const ByRef $aColorTable, $iStart = 0, $iEnd = -1)

	If Not IsArray($aColorTable) Then
		Return SetError(2, 0, 0)
	EndIf

	Local $tColorTable, $Count = 1

	If $iStart < 0 Then
		$iStart = 0
	EndIf
	If ($iEnd < 0) Or ($iEnd > UBound($aColorTable) - 1) Then
		$iEnd = UBound($aColorTable) - 1
	EndIf
	$tColorTable = DllStructCreate('dword[' & ($iEnd - $iStart + 1) & ']')
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	For $i = $iStart To $iEnd
		DllStructSetData($tColorTable, 1, _WinAPI_SwitchColor(__RGB($aColorTable[$i])), $Count)
		$Count += 1
	Next
	Return $tColorTable
EndFunc   ;==>_WinAPI_CreateDIBColorTable

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateDIBitmap
; Description....: Creates a compatible bitmap (DDB) from a DIB and, optionally, sets the bitmap bits.
; Syntax.........: _WinAPI_CreateDIBitmap ( $hDC, $tBITMAPINFO, $iUsage [, $pBits] )
; Parameters.....: $hDC         - Handle to a device context.
;                  $tBITMAPINFO - $tagBITMAPINFO structure that specifies various attributes of the DIB, including the bitmap
;                                 dimensions and colors. Note that a positive value for the height indicates a bottom-up DIB while
;                                 a negative value for the height indicates a top-down DIB.
;                  $iUsage      - The type of colors used. This parameter must be one of the following values.
;
;                                 $DIB_PAL_COLORS
;                                 $DIB_RGB_COLORS
;
;                  $pBits       - A pointer to an array of bytes containing the initial bitmap data.
; Return values..: Success      - Handle to the compatible bitmap that will be whatever bit depth a reference DC is.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you no longer need the bitmap, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: @@MsdnLink@@ CreateDIBitmap
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateDIBitmap($hDC, $tBITMAPINFO, $iUsage, $pBits = 0)

	Local $pBI = DllStructGetPtr($tBITMAPINFO)
	Local $Init = 0

	If $pBits Then
		$Init = 0x04
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreateDIBitmap', 'hwnd', $hDC, 'ptr', $pBI, 'dword', $Init, 'ptr', $pBits, 'ptr', $pBI, 'uint', $iUsage)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateDIBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateDIBSection
; Description....: Creates a DIB that applications can write to directly.
; Syntax.........: _WinAPI_CreateDIBSection ( $hDC, $tBITMAPINFO, $iUsage, ByRef $pBits [, $hSection [, $iOffset]] )
; Parameters.....: $hDC         - Handle to a device context. If the value of $iUsage is $DIB_PAL_COLORS, the function uses this
;                                 device context's logical palette to initialize the DIB colors.
;                  $tBITMAPINFO - $tagBITMAPINFO structure that specifies various attributes of the DIB, including the bitmap
;                                 dimensions and colors.
;                  $iUsage      - The type of colors used (either logical palette indexes or literal RGB values). The following
;                                 values are defined.
;
;                                 $DIB_PAL_COLORS
;                                 $DIB_RGB_COLORS
;
;                  $pBits       - A pointer to the location of the DIB bit values.
;                  $hSection    - Handle to a file-mapping object that the function will use to create the DIB.
;                  $iOffset     - The offset from the beginning of the file-mapping object referenced by $hSection where storage
;                                 for the bitmap bit values is to begin. This value is ignored if $hSection is 0.
; Return values..: Success      - Handle to the newly created DIB, and $pBits points to the bitmap bit values. You can create
;                                 the structure by using $pBits pointer to further its filling. For example,
;                                 DllStructCreate('dword[256]', $pBits).
;                  Failure      - 0 and sets the @error flag to non-zero, $pBits also is 0.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you no longer need the bitmap, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: @@MsdnLink@@ CreateDIBSection
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateDIBSection($hDC, $tBITMAPINFO, $iUsage, ByRef $pBits, $hSection = 0, $iOffset = 0)

	$pBits = 0

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreateDIBSection', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tBITMAPINFO), 'uint', $iUsage, 'ptr*', 0, 'ptr', $hSection, 'dword', $iOffset)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$pBits = $Ret[4]
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateDIBSection

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateDirectory
; Description....: Creates a new directory.
; Syntax.........: _WinAPI_CreateDirectory ( $sDir [, $tSecurity] )
; Parameters.....: $sDir      - The path of the directory to be created.
;                  $tSecurity - $tagSECURITY_ATTRIBUTES structure that specifies a security descriptor for the new directory.
;                               If this parameter is 0, the directory gets a default security descriptor. The ACL in the default
;                               security descriptor for a directory are inherited from its parent directory.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CreateDirectory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateDirectory($sDir, $tSecurity = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'CreateDirectoryW', 'wstr', $sDir, 'ptr', DllStructGetPtr($tSecurity))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CreateDirectory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateDirectoryEx
; Description....: Creates a new directory with the attributes of a specified template directory.
; Syntax.........: _WinAPI_CreateDirectoryEx ( $sNewDir, $sTemplateDir [, $tSecurity] )
; Parameters.....: $sNewDir      - The path of the directory to be created.
;                  $sTemplateDir - The path of the directory to use as a template when creating the new directory.
;                  $tSecurity    - $tagSECURITY_ATTRIBUTES structure that specifies a security descriptor for the new directory.
;                                  If this parameter is 0, the directory gets a default security descriptor. The ACL in the default
;                                  security descriptor for a directory are inherited from its parent directory.
; Return values..: Success       - 1.
;                  Failure       - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CreateDirectoryEx() function allows you to create directories that inherit stream information
;                  from other directories. This function is useful, for example, when you are using Macintosh directories, which
;                  have a resource stream that is needed to properly identify directory contents as an attribute.
; Related........:
; Link...........: @@MsdnLink@@ CreateDirectoryEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateDirectoryEx($sNewDir, $sTemplateDir, $tSecurity = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'CreateDirectoryExW', 'wstr', $sTemplateDir, 'wstr', $sNewDir, 'ptr', DllStructGetPtr($tSecurity))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CreateDirectoryEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateEllipticRgn
; Description....: Creates an elliptical region.
; Syntax.........: _WinAPI_CreateEllipticRgn ( $tRECT )
; Parameters.....: $tRECT  - $tagRECT structure that contains the coordinates of the upper-left and lower-right corners of the
;                            bounding rectangle of the ellipse in logical units.
; Return values..: Success - The handle to the region.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: A bounding rectangle defines the size, shape, and orientation of the region: The long sides of the rectangle
;                  define the length of the ellipse's major axis; the short sides define the length of the ellipse's minor axis;
;                  and the center of the rectangle defines the intersection of the major and minor axes.
;
;                  When you no longer need the HRGN object, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: @@MsdnLink@@ CreateEllipticRgnIndirect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateEllipticRgn($tRECT)

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreateEllipticRgnIndirect', 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateEllipticRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateEmptyIcon
; Description....: Creates a fully transparent icon with the specified width, height, and color depth.
; Syntax.........: _WinAPI_CreateEmptyIcon ( $iWidth, $iHeight [, $iBitsPerPel] )
; Parameters.....: $iWidth      - The width, in pixels, of the icon.
;                  $iHeight     - The height, in pixels, of the icon.
;                  $iBitsPerPel - The number of bits-per-pixel in the XOR bitmask of the icon.
; Return values..: Success      - Handle to the created icon.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function creates an icon with black XOR, and white AND bitmask bitmaps. This icon has no alpha channel,
;                  it will be displayed only by using its AND bitmask.
;
;                  When you are finished using the icon, destroy it using the _WinAPI_DestroyIcon() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateEmptyIcon($iWidth, $iHeight, $iBitsPerPel = 32)

	Local $tRECT, $hDC, $hSv, $hBrush, $hXOR, $hAND, $hIcon

	$hXOR = _WinAPI_CreateDIB($iWidth, $iHeight, $iBitsPerPel)
	$hAND = _WinAPI_CreateDIB($iWidth, $iHeight, 1)
	$hDC = _WinAPI_CreateCompatibleDC(0)
	$hSv = _WinAPI_SelectObject($hDC, $hAND)
	$hBrush = _WinAPI_CreateSolidBrush(0xFFFFFF)
	$tRECT = _WinAPI_CreateRect(0, 0, $iWidth, $iHeight)
	_WinAPI_FillRect($hDC, DllStructGetPtr($tRECT), $hBrush)
	_WinAPI_DeleteObject($hBrush)
	_WinAPI_SelectObject($hDC, $hSv)
	_WinAPI_DeleteDC($hDC)
	$hIcon = _WinAPI_CreateIconIndirect($hXOR, $hAND)
	If $hXOR Then
		_WinAPI_DeleteObject($hXOR)
	EndIf
	If $hAND Then
		_WinAPI_DeleteObject($hAND)
	EndIf
	If Not $hIcon Then
		Return SetError(1, 0, 0)
	EndIf
	Return $hIcon
EndFunc   ;==>_WinAPI_CreateEmptyIcon

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateEnhMetaFile
; Description....: Creates a device context for an enhanced-format metafile.
; Syntax.........: _WinAPI_CreateEnhMetaFile ( [$hDC [, $tRECT [, $fPixels [, $sFile [, $sDescription]]]]] )
; Parameters.....: $hDC          - Handle to a reference device for the enhanced metafile. The system uses this device context to
;                                  record the resolution and units of the device on which a picture originally appeared.
;                                  If this parameter is 0, it uses the current display device for reference.
;                  $tRECT        - $tagRECT structure that specifies the dimensions of the picture to be stored in the enhanced metafile.
;                                  If this parameter is 0, the graphics device interface computes the dimensions of the smallest
;                                  rectangle that surrounds the picture drawn by the application.
;                  $fPixels      - Specifies whether the $tRECT structure defined in pixels, valid values:
;                  |TRUE         - In logical units (pixels).
;                  |FALSE        - In .01-millimeter units. (Default)
;                  $sFile        - The file name for the enhanced metafile to be created. If this parameter is 0, the enhanced
;                                  metafile is memory based and its contents are lost when it is deleted by using the
;                                  _WinAPI_DeleteEnhMetaFile() function.
;                  $sDescription - The string that specifies the name of the application that created the picture, as well as the
;                                  picture's title. This string must be an empty string or represented as follows:
;
;                                  "application name|picture name"
;
; Return values..: Success       - Handle to the device context for the enhanced metafile.
;                  Failure       - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Applications use the device context created by this function to store a graphics picture in an enhanced metafile.
;                  The handle identifying this device context can be passed to any GDI function.
;
;                  After an application stores a picture in an enhanced metafile, it can display the picture on any output device by
;                  calling the _WinAPI_PlayEnhMetaFile() function. When displaying the picture, the system uses the rectangle pointed
;                  to by the $tRECT parameter and the resolution data from the reference device to position and scale the picture.
;
;                  The file name for the enhanced metafile should use the .emf extension.
; Related........:
; Link...........: @@MsdnLink@@ CreateEnhMetaFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateEnhMetaFile($hDC = 0, $tRECT = 0, $fPixels = 0, $sFile = '', $sDescription = '')

	Local $TypeOfFile = 'wstr'

	If Not StringStripWS($sFile, 3) Then
		$TypeOfFile = 'ptr'
		$sFile = 0
	EndIf

	Local $tData = 0, $aData = StringSplit($sDescription, '|', 2)

	If UBound($aData) < 2 Then
		ReDim $aData[2]
		$aData[1] = ''
	EndIf
	For $i = 0 To 1
		$aData[$i] = StringStripWS($aData[$i], 3)
	Next
	If ($aData[0]) Or ($aData[1]) Then
		$tData = _WinAPI_ArrayToStruct($aData)
	EndIf

	Local $Xp, $Yp, $Xm, $Ym, $hRef = 0

	If ($fPixels) And (IsDllStruct($tRECT)) Then
		If Not $hDC Then
			$hRef = _WinAPI_GetDC(0)
		EndIf
		$Xp = _WinAPI_GetDeviceCaps($hRef, 8 )
		$Yp = _WinAPI_GetDeviceCaps($hRef, 10)
		$Xm = _WinAPI_GetDeviceCaps($hRef, 4 )
		$Ym = _WinAPI_GetDeviceCaps($hRef, 6 )
		If $hRef Then
			_WinAPI_ReleaseDC(0, $hRef)
		EndIf
		For $i = 1 To 3 Step 2
			DllStructSetData($tRECT, $i, Round(DllStructGetData($tRECT, $i) * $Xm / $Xp * 100))
		Next
		For $i = 2 To 4 Step 2
			DllStructSetData($tRECT, $i, Round(DllStructGetData($tRECT, $i) * $Ym / $Yp * 100))
		Next
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'hwnd', 'CreateEnhMetaFileW', 'hwnd', $hDC, $TypeOfFile, $sFile, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tData))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateFileEx
; Description....: Creates or opens a file or I/O device.
; Syntax.........: _WinAPI_CreateFileEx ( $sFile, $iCreation [, $iAccess [, $iShare [, $iFlagsAndAttributes [, $tSecurity [, $hTemplate]]]]] )
; Parameters.....: $sFile               - The name of the file or device to be created or opened.
;                  $iCreation           - The action to take on a file or device that exists or does not exist. This parameter must be
;                                         one of the following values, which cannot be combined.
;
;                                         $CREATE_NEW
;                                         $CREATE_ALWAYS
;                                         $OPEN_EXISTING
;                                         $OPEN_ALWAYS
;                                         $TRUNCATE_EXISTING
;
;                  $iAccess             - The requested access to the file or device, which can be summarized as read, write, both
;                                         or neither (zero).
;
;                                         $GENERIC_READ
;                                         $GENERIC_WRITE
;
;                                         (See MSDN for more information)
;
;                  $iShare              - The requested sharing mode of the file or device, which can be read, write, both,
;                                         delete, all of these, or none. If this parameter is 0 and _WinAPI_CreateFileEx() succeeds,
;                                         the file or device cannot be shared and cannot be opened again until the handle to
;                                         the file or device is closed.
;
;                                         $FILE_SHARE_DELETE
;                                         $FILE_SHARE_READ
;                                         $FILE_SHARE_WRITE
;
;                  $iFlagsAndAttributes - The file or device attributes and flags. This parameter can be one or more of the
;                                         following values.
;
;                                         $FILE_ATTRIBUTE_READONLY
;                                         $FILE_ATTRIBUTE_HIDDEN
;                                         $FILE_ATTRIBUTE_SYSTEM
;                                         $FILE_ATTRIBUTE_DIRECTORY
;                                         $FILE_ATTRIBUTE_ARCHIVE
;                                         $FILE_ATTRIBUTE_DEVICE
;                                         $FILE_ATTRIBUTE_NORMAL
;                                         $FILE_ATTRIBUTE_TEMPORARY
;                                         $FILE_ATTRIBUTE_SPARSE_FILE
;                                         $FILE_ATTRIBUTE_REPARSE_POINT
;                                         $FILE_ATTRIBUTE_COMPRESSED
;                                         $FILE_ATTRIBUTE_OFFLINE
;                                         $FILE_ATTRIBUTE_NOT_CONTENT_INDEXED
;                                         $FILE_ATTRIBUTE_ENCRYPTED
;
;                                         $FILE_FLAG_BACKUP_SEMANTICS
;                                         $FILE_FLAG_DELETE_ON_CLOSE
;                                         $FILE_FLAG_NO_BUFFERING
;                                         $FILE_FLAG_OPEN_NO_RECALL
;                                         $FILE_FLAG_OPEN_REPARSE_POINT
;                                         $FILE_FLAG_OVERLAPPED
;                                         $FILE_FLAG_POSIX_SEMANTICS
;                                         $FILE_FLAG_RANDOM_ACCESS
;                                         $FILE_FLAG_SEQUENTIAL_SCAN
;                                         $FILE_FLAG_WRITE_THROUGH
;
;                                         $SECURITY_ANONYMOUS
;                                         $SECURITY_CONTEXT_TRACKING
;                                         $SECURITY_DELEGATION
;                                         $SECURITY_EFFECTIVE_ONLY
;                                         $SECURITY_IDENTIFICATION
;                                         $SECURITY_IMPERSONATION
;
;                  $tSecurity           - $tagSECURITY_ATTRIBUTES structure that contains two separate but related data members:
;                                         an optional security descriptor, and a Boolean value that determines whether the returned
;                                         handle can be inherited by child processes. If this parameter is 0, the handle cannot
;                                         be inherited by any child processes the application may create and the file or device
;                                         associated with the returned handle gets a default security descriptor.
;                  $hTemplate           - Handle to a template file with the $GENERIC_READ access right. The template file supplies
;                                         file attributes and extended attributes for the file that is being created.
; Return values..: Success              - Handle to the specified file, device, named pipe, or mail slot.
;                  Failure              - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When an application is finished using the object handle returned by this function, use the _WinAPI_CloseHandle()
;                  function to close the handle. This not only frees up system resources, but can have wider influence on things
;                  like sharing the file or device and committing data to disk.
; Related........:
; Link...........: @@MsdnLink@@ CreateFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateFileEx($sFile, $iCreation, $iAccess = 0, $iShare = 0, $iFlagsAndAttributes = 0, $tSecurity = 0, $hTemplate = 0)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'CreateFileW', 'wstr', $sFile, 'dword', $iAccess, 'dword', $iShare, 'ptr', DllStructGetPtr($tSecurity), 'dword', $iCreation, 'dword', $iFlagsAndAttributes, 'ptr', $hTemplate)

	If (@error) Or ($Ret[0] = Ptr(-1)) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateFileEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateFileMapping
; Description....: Creates or opens a named or unnamed file mapping object for a specified file.
; Syntax.........: _WinAPI_CreateFileMapping ( $hFile [, $iSize [, $sName [, $iProtect [, $tSecurity]]]] )
; Parameters.....: $hFile     - Handle to the file from which to create a file mapping object. If this parameter is (-1), the calling
;                               process must also specify a size for the file mapping object in the $iSize parameters. In this scenario,
;                               _WinAPI_CreateFileMapping() creates a file mapping object of a specified size that is backed by the
;                               system paging file instead of by a file in the file system.
;                  $iSize     - The maximum size of the file mapping object. If this parameter is 0, the maximum size of the file
;                               mapping object is equal to the current size of the file that $hFile identifies.
;                  $sName     - The name of the file mapping object.
;                  $iProtect  - Specifies the page protection of the file mapping object and can be one of the following values.
;
;                               $PAGE_EXECUTE_READ
;                               $PAGE_EXECUTE_READWRITE
;                               $PAGE_EXECUTE_WRITECOPY
;                               $PAGE_READONLY
;                               $PAGE_READWRITE
;                               $PAGE_WRITECOPY
;
;                               An application can specify one or more of the following attributes for the file mapping object
;                               by combining them with one of the preceding page protection values.
;
;                               $SEC_COMMIT
;                               $SEC_IMAGE
;                               $SEC_LARGE_PAGES
;                               $SEC_NOCACHE
;                               $SEC_RESERVE
;                               $SEC_WRITECOMBINE
;
;                  $tSecurity - $tagSECURITY_ATTRIBUTES structure that determines whether a returned handle can be inherited by
;                               child processes. If this parameter is 0, the handle cannot be inherited and the file mapping object
;                               gets a default security descriptor.
; Return values..: Success    - Handle to the newly created file mapping object. If the object exists before the function call,
;                               the function returns a handle to the existing object (with its current size, not the specified
;                               size), and sets the @extended flag to 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After a file mapping object is created, the size of the file must not exceed the size of the file mapping object;
;                  if it does, not all of the file contents are available for sharing.
;
;                  Multiple processes can share a view of the same file by either using a single shared file mapping object or creating
;                  separate file mapping objects backed by the same file. A single file mapping object can be shared by multiple processes
;                  through inheriting the handle at process creation, duplicating the handle, or opening the file mapping object by name.
;
;                  A file mapping object does not actually map the view into a process address space. The _WinAPI_MapViewOfFile()
;                  functions map a view of a file into a process address space.
;
;                  Mapped views of a file mapping object maintain internal references to the object, and a file mapping object does
;                  not close until all references to it are released. Therefore, to fully close a file mapping object, an application
;                  must unmap all mapped views of the file mapping object by calling _WinAPI_UnmapViewOfFile() and close the file
;                  mapping object handle by calling _WinAPI_CloseHandle(). These functions can be called in any order.
; Related........:
; Link...........: @@MsdnLink@@ CreateFileMapping
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateFileMapping($hFile, $iSize = 0, $sName = '', $iProtect = 0x0004, $tSecurity = 0)

	Local $TypeOfName = 'wstr'

	If Not StringStripWS($sName, 3) Then
		$TypeOfName = 'ptr'
		$sName = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'CreateFileMappingW', 'ptr', $hFile, 'ptr', DllStructGetPtr($tSecurity), 'dword', $iProtect, 'dword', _WinAPI_HiDWord($iSize), 'dword', _WinAPI_LoDWord($iSize), $TypeOfName, $sName)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, Number(_WinAPI_GetLastError() = 183), $Ret[0])
EndFunc   ;==>_WinAPI_CreateFileMapping

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateGUID
; Description....: Creates a globally unique identifier (GUID).
; Syntax.........: _WinAPI_CreateGUID ( )
; Parameters.....: None
; Return values..: Success - The string representation of the GUID.
;                  Failure - Empty string and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateGUID()

	Local $tGUID, $Ret

	$tGUID = DllStructCreate($tagGUID)
	$Ret = DllCall('ole32.dll', 'uint', 'CoCreateGuid', 'ptr', DllStructGetPtr($tGUID))
	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	$Ret = DllCall('ole32.dll', 'int', 'StringFromGUID2', 'ptr', DllStructGetPtr($tGUID), 'wstr', '', 'int', 39)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_CreateGUID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateHardLink
; Description....: Establishes a hard link between an existing file and a new file.
; Syntax.........: _WinAPI_CreateHardLink ( $sNewFile, $sExistingFile )
; Parameters.....: $sNewFile      - The name of the new file.
;                  $sExistingFile - The name of the existing file.
; Return values..: Success        - 1.
;                  Failure        - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CreateHardLink() is only supported on the NTFS file system, and only for files, not directories.
;
;                  The security descriptor belongs to the file to which a hard link points. The link itself is only a directory entry,
;                  and does not have a security descriptor. Therefore, when you change the security descriptor of a hard link, you
;                  a change the security descriptor of the underlying file, and all hard links that point to the file allow the newly
;                  specified access. You cannot give a file different security descriptors on a per-hard-link basis.
;
;                  Use _WinAPI_DeleteFile() function to delete hard links. You can delete them in any order regardless of the
;                  order in which they are created.
; Related........:
; Link...........: @@MsdnLink@@ CreateHardLink
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateHardLink($sNewFile, $sExistingFile)

	Local $Ret = DllCall('kernel32.dll', 'int', 'CreateHardLinkW', 'wstr', $sNewFile, 'wstr', $sExistingFile, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CreateHardLink

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateIcon
; Description....: Creates an icon that has the specified size, colors, and bit patterns.
; Syntax.........: _WinAPI_CreateIcon ( $hInstance, $iWidth, $iHeight, $iPlanes, $iBitsPixel, $pANDBits, $pXORBits )
; Parameters.....: $hInstance  - Handle to the instance of the module creating the icon.
;                  $iWidth     - The width, in pixels, of the icon.
;                  $iHeight    - The height, in pixels, of the icon.
;                  $iPlanes    - The number of planes in the XOR bitmask of the icon.
;                  $iBitsPixel - The number of bits-per-pixel in the XOR bitmask of the icon.
;                  $pANDBits   - An array of bytes that contains the bit values for the AND bitmask of the icon. This bitmask describes
;                                a monochrome bitmap.
;                  $pXORBits   - An array of bytes that contains the bit values for the XOR bitmask of the icon. This bitmask describes
;                                a monochrome or device-dependent color bitmap.
; Return values..: Success     - Handle to the icon that is created.
;                  Failure     - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you are finished using the icon, destroy it using the _WinAPI_DestroyIcon() function.
; Related........:
; Link...........: @@MsdnLink@@ CreateIcon
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateIcon($hInstance, $iWidth, $iHeight, $iPlanes, $iBitsPixel, $pANDBits, $pXORBits)

	Local $Ret = DllCall('user32.dll', 'ptr', 'CreateIcon', 'ptr', $hInstance, 'int', $iWidth, 'int', $iHeight, 'byte', $iPlanes, 'byte', $iBitsPixel, 'ptr', $pANDBits, 'ptr', $pXORBits)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateIcon

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateIconFromResourceEx
; Description....: Creates an icon or cursor from resource bits describing the icon.
; Syntax.........: _WinAPI_CreateIconFromResourceEx ( $pData, $iSize [, $fIcon [, $xDesired [, $yDesired [, $iFlags]]]] )
; Parameters.....: $pData    - The icon or cursor resource bits. These bits are typically loaded by calls to the _WinAPI_LookupIconIdFromDirectoryEx()
;                              and _WinAPI_LoadResource() functions.
;                  $iSize    - The size, in bytes, of the set of bits pointed to by the $pData parameter.
;                  $fIcon    - Specifies whether an icon or a cursor is to be created, valid values:
;                  |TRUE     - An icon is to be created. (Default)
;                  |FALSE    - A cursor is to be created.
;                  $xDesired - The desired width, in pixels, of the icon or cursor. If this parameter is zero, the function uses the
;                              system metric value to set the width.
;                  $yDesired - The desired height, in pixels, of the icon or cursor. If this parameter is zero, the function uses the
;                              system metric value to set the height.
;                  $iFlags   - This parameter can be one or more of the following values.
;
;                              $LR_DEFAULTCOLOR
;                              $LR_DEFAULTSIZE
;                              $LR_MONOCHROME
;                              $LR_SHARED
;
; Return values..: Success   - Handle to the icon or cursor.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: You should call _WinAPI_DestroyIcon() for icons created with _WinAPI_CreateIconFromResourceEx() function.
; Related........:
; Link...........: @@MsdnLink@@ CreateIconFromResourceEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateIconFromResourceEx($pData, $iSize, $fIcon = 1, $xDesired = 0, $yDesired = 0, $iFlags = 0)

	Local $Ret = DllCall('user32.dll', 'ptr', 'CreateIconFromResourceEx', 'ptr', $pData, 'dword', $iSize, 'int', $fIcon, 'dword', 0x00030000, 'int', $xDesired, 'int', $yDesired, 'uint', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateIconFromResourceEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateIconIndirect
; Description....: Creates an icon or cursor that has the specified size, colors, and bit patterns.
; Syntax.........: _WinAPI_CreateIconIndirect ( $hBitmap, $hMask [, $XHotspot [, $YHotspot [, $fIcon]]] )
; Parameters.....: $hBitmap  - Handle to the icon color bitmap.
;                  $hMask    - Handle to the icon bitmask bitmap.
;                  $XHotspot - Specifies the x-coordinate of a cursor's hot spot. If creates an icon, the hot spot is always in the
;                              center of the icon, and this parameter is ignored.
;                  $YHotspot - Specifies the y-coordinate of a cursor's hot spot. If creates an icon, the hot spot is always in the
;                              center of the icon, and this parameter is ignored.
;                  $fIcon    - Specifies whether creates an icon or a cursor, valid values:
;                  |TRUE     - Creates an icon. (Default)
;                  |FALSE    - Creates a cursor.
; Return values..: Success   - Handle to the icon or cursor that is created.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The system copies the bitmaps before creating the icon or cursor. Because the system may temporarily select this
;                  bitmaps in a device context, $hBitmap and $hMask should not already be selected into a device context.
;                  The application must continue to manage the original bitmaps and delete them by using _WinAPI_DeleteObject()
;                  when they are no longer necessary.
; Related........:
; Link...........: @@MsdnLink@@ CreateIconIndirect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateIconIndirect($hBitmap, $hMask, $XHotspot = 0, $YHotspot = 0, $fIcon = 1)

	Local $tICONINFO = DllStructCreate($tagICONINFO)

	DllStructSetData($tICONINFO, 1, $fIcon)
	DllStructSetData($tICONINFO, 2, $XHotspot)
	DllStructSetData($tICONINFO, 3, $YHotspot)
	DllStructSetData($tICONINFO, 4, $hMask)
	DllStructSetData($tICONINFO, 5, $hBitmap)

	Local $Ret = DllCall('user32.dll', 'ptr', 'CreateIconIndirect', 'ptr', DllStructGetPtr($tICONINFO))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateIconIndirect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateJobObject
; Description....: Creates or opens a job object.
; Syntax.........: _WinAPI_CreateJobObject ( [$sName [, $tSecurity] )
; Parameters.....: $sName     - The name of the job. Name comparison is case-sensitive. If this parameter is 0, the job is
;                               created without a name.
;                  $tSecurity - $tagSECURITY_ATTRIBUTES structure that specifies the security descriptor for the job object
;                               and determines whether child processes can inherit the returned handle. If this parameter is 0,
;                               the job object gets a default security descriptor and the handle cannot be inherited.
; Return values..: Success    - Handle to the job object. If the object existed before the function call, the function
;                               returns a handle to the existing job object.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When a job is created, its accounting information is initialized to zero, all limits are inactive, and there
;                  are no associated processes. To assign a process to a job object, use the _WinAPI_AssignProcessToJobObject()
;                  function. To set limits for a job, use the _WinAPI_SetInformationJobObject() function. To query accounting
;                  information, use the _WinAPI_QueryInformationJobObject() function.
;
;                  All processes associated with a job must run in the same session. A job is associated with the session of the
;                  first process to be assigned to the job.
;
;                  To close a job object handle, use the _WinAPI_CloseHandle() function. The job is destroyed when its last
;                  handle has been closed and all associated processes have exited.
; Related........:
; Link...........: @@MsdnLink@@ CreateJobObject
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateJobObject($sName = '', $tSecurity = 0)

	Local $TypeOfName = 'wstr'

	If Not StringStripWS($sName, 3) Then
		$TypeOfName = 'ptr'
		$sName = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'CreateJobObjectW', 'ptr', $tSecurity, $TypeOfName, $sName)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateJobObject

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateMargins
; Description....: Creates $tagMARGINS structure with specified left, right, top, and bottom retaining borders.
; Syntax.........: _WinAPI_CreateMargins ( $iLeftWidth, $iRightWidth, $iTopHeight, $iBottomHeight )
; Parameters.....: $iLeftWidth    - The width of the left border that retains its size.
;                  $iRightWidth   - The width of the right border that retains its size.
;                  $iTopHeight    - The height of the top border that retains its size.
;                  $iBottomHeight - The height of the bottom border that retains its size.
; Return values..: Success        - $tagMARGINS structure that contains the specified retaining borders.
;                  Failure        - 0.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateMargins($iLeftWidth, $iRightWidth, $iTopHeight, $iBottomHeight)

	Local $tMARGINS = DllStructCreate($tagMARGINS)

	DllStructSetData($tMARGINS, 1, $iLeftWidth)
	DllStructSetData($tMARGINS, 2, $iRightWidth)
	DllStructSetData($tMARGINS, 3, $iTopHeight)
	DllStructSetData($tMARGINS, 4, $iBottomHeight)

	Return $tMARGINS
EndFunc   ;==>_WinAPI_CreateMargins

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateMRUList
; Description....: Creates a new most recently used (MRU) list.
; Syntax.........: _WinAPI_CreateMRUList ( $hKey, $sSubKey [, $iMax]] )
; Parameters.....: $hKey     - Handle to the currently open key, or one of the following predefined values under which to store the MRU data.
;
;                              $HKEY_CURRENT_USER
;                              $HKEY_LOCAL_MACHINE
;
;                  $sSubKey  - The subkey under which to store the MRU data.
;                  $iMax     - The maximum number of entries in the MRU list. Default is 26 (A..Z).
; Return values..: Success   - Handle to the new MRU list.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CreateMRUListW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateMRUList($hKey, $sSubKey, $iMax = 26)

	Local $tMRUINFO = DllStructCreate('dword;uint;uint;ulong_ptr;ptr;ptr;wchar[' & (StringLen($sSubKey) + 1) & ']')

	DllStructSetData($tMRUINFO, 1, DllStructGetPtr($tMRUINFO, 7) - DllStructGetPtr($tMRUINFO))
	DllStructSetData($tMRUINFO, 2, $iMax)
	DllStructSetData($tMRUINFO, 3, 0)
	DllStructSetData($tMRUINFO, 4, $hKey)
	DllStructSetData($tMRUINFO, 5, DllStructGetPtr($tMRUINFO, 7))
	DllStructSetData($tMRUINFO, 6, 0)
	DllStructSetData($tMRUINFO, 7, $sSubKey)

	Local $Ret = DllCall('comctl32.dll ', 'int', 'CreateMRUListW', 'ptr', DllStructGetPtr($tMRUINFO))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateMRUList

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateMutex
; Description....: Creates or opens a named or unnamed mutex object.
; Syntax.........: _WinAPI_CreateMutex ( $sMutex [, $fInitial [, $tSecurity]] )
; Parameters.....: $sMutex    - The name of the mutex object. Name comparisons are case sensitive.
;                  $fInitial  - Specifies whether the calling process obtains the initial ownership of the mutex object, valid values:
;                  |TRUE      - The calling thread obtains initial ownership of the mutex object. (Default)
;                  |FALSE     - The calling thread does not obtain ownership of the mutex object.
;                  $tSecurity - $tagSECURITY_ATTRIBUTES structure that specifies a security descriptor for the new mutex. If this
;                               parameter is 0, the mutex gets a default security descriptor.
; Return values..: Success    - The handle to the newly created mutex object.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the mutex is a named mutex and the object existed before this function call, the return value is a handle to
;                  the existing object, _WinAPI_GetLastError() returns ERROR_ALREADY_EXISTS (183), $fInitial is ignored, and the calling
;                  thread is not granted ownership. However, if the caller has limited access rights, the function will fail with
;                  ERROR_ACCESS_DENIED (5) and the caller should use the _WinAPI_OpenMutex() function.
;
;                  Any process can specify the mutex-object handle in a call to one of the wait functions. The single-object wait
;                  functions return when the state of the specified object is signaled. The multiple-object wait functions can be
;                  instructed to return either when any one or when all of the specified objects are signaled. When a wait function
;                  returns, the waiting thread is released to continue its execution.
;
;                  Two or more processes can call _WinAPI_CreateMutex() to create the same named mutex. The first process actually
;                  creates the mutex, and subsequent processes with sufficient access rights simply open a handle to the existing
;                  mutex. This enables multiple processes to get handles of the same mutex, while relieving the user of the responsibility
;                  of ensuring that the creating process is started first. When using this technique, you should set the $fInitial
;                  parameter to FALSE; otherwise, it can be difficult to be certain which process has initial ownership.
;
;                  Use the _WinAPI_CloseHandle() function to close the handle. The system closes the handle automatically when the
;                  process terminates. The mutex object is destroyed when its last handle has been closed.
; Related........:
; Link...........: @@MsdnLink@@ CreateMutex
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateMutex($sMutex, $fInitial = 1, $tSecurity = 0)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'CreateMutexW', 'ptr', DllStructGetPtr($tSecurity), 'int', $fInitial, 'wstr', $sMutex)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateMutex

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateNullRgn
; Description....: Creates an empty region.
; Syntax.........: _WinAPI_CreateNullRgn ( )
; Parameters.....: None
; Return values..: Success - The handle to the region.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you no longer need the HRGN object, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateNullRgn()

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreateRectRgn', 'int', 0, 'int', 0, 'int', 0, 'int', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateNullRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateNumberFormatInfo
; Description....: Creates a $tagNUMBERFMT structure with the specified number formatting information.
; Syntax.........: _WinAPI_CreateNumberFormatInfo ( $iNumDigits, $iLeadingZero, $iGrouping, $sDecimalSep, $sThousandSep, $iNegativeOrder )
; Parameters.....: $iNumDigits     - The number of fractional digits placed after the decimal separator.
;                  $iLeadingZero   - Specifier for leading zeros in decimal fields, valid values:
;                  |0 - No leading zeros.
;                  |1 - Leading zeros.
;                  $iGrouping      - The number of digits in each group of numbers to the left of the decimal separator. The values
;                                    in the range 0 through 9 and 32 are valid. Typical examples are: 0 to group digits as in 123456789.00;
;                                    3 to group digits as in 123,456,789.00; and 32 to group digits as in 12,34,56,789.00.
;                  $sDecimalSep    - The decimal separator string.
;                  $sThousandSep   - The thousand separator string.
;                  $iNegativeOrder - The negative number mode, valid values:
;                  |0 - Left parenthesis, number, right parenthesis; for example, (1.1).
;                  |1 - Negative sign, number; for example, -1.1.
;                  |2 - Negative sign, space, number; for example, - 1.1.
;                  |3 - Number, negative sign; for example, 1.1-.
;                  |4 - Number, space, negative sign; for example, 1.1 -.
; Return values..: $tagNUMBERFMT structure that contains number formatting information.
; Author.........: Yashied
; Modified.......:
; Remarks........: Typically, the structure returned by this function is used in the _WinAPI_GetNumberFormat() function.
; Related........:
; Link...........: @@MsdnLink@@ NUMBERFMT
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateNumberFormatInfo($iNumDigits, $iLeadingZero, $iGrouping, $sDecimalSep, $sThousandSep, $iNegativeOrder)

	Local $tFMT = DllStructCreate($tagNUMBERFMT & 'wchar[' & (StringLen($sDecimalSep) + 1) & '];wchar[' & (StringLen($sThousandSep) + 1) & ']')

	DllStructSetData($tFMT, 1, $iNumDigits)
	DllStructSetData($tFMT, 2, $iLeadingZero)
	DllStructSetData($tFMT, 3, $iGrouping)
	DllStructSetData($tFMT, 4, DllStructGetPtr($tFMT, 7))
	DllStructSetData($tFMT, 5, DllStructGetPtr($tFMT, 8))
	DllStructSetData($tFMT, 6, $iNegativeOrder)
	DllStructSetData($tFMT, 7, $sDecimalSep)
	DllStructSetData($tFMT, 8, $sThousandSep)

	Return $tFMT
EndFunc   ;==>_WinAPI_CreateNumberFormatInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateObjectID
; Description....: Creates or retrieves the object identifier for the specified file or directory.
; Syntax.........: _WinAPI_CreateObjectID ( $sPath )
; Parameters.....: $sPath  - Path to the file or directory to create or retrieve object identifier.
; Return values..: Success - $tagGUID structure that contains the object identifier for the file or directory within the volume on which it resides.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the object identifier of a file or directory does not already have one, the _WinAPI_CreateObjectID() creates it.
;                  If the object identifier already exists, the function just returns it.
; Related........:
; Link...........: @@MsdnLink@@ FSCTL_CREATE_OR_GET_OBJECT_ID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateObjectID($sPath)

	Local $hFile = _WinAPI_CreateFileEx($sPath, 3, 0, 0x03, 0x02000000)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tFOID = DllStructCreate('byte[16];byte[48]')
	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x000900C0, 'ptr', 0, 'dword', 0, 'ptr', DllStructGetPtr($tFOID), 'dword', DllStructGetSize($tFOID), 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf

	Local $tGUID = DllStructCreate($tagGUID)

	If Not _WinAPI_MoveMemory(DllStructGetPtr($tGUID), DllStructGetPtr($tFOID), 16) Then
		Return SetError(3, 0, 0)
	EndIf
	Return $tGUID
EndFunc   ;==>_WinAPI_CreateObjectID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreatePoint
; Description....: Creates $tagPOINT structure with the x- and y-coordinates of the specified point.
; Syntax.........: _WinAPI_CreatePoint ( $iX, $iY )
; Parameters.....: $iX     - The x-coordinate of the point.
;                  $iY     - The y-coordinate of the point.
; Return values..: Success - $tagPOINT structure that contains the specified point.
;                  Failure - 0.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreatePoint($iX, $iY)

	Local $tPOINT = DllStructCreate($tagPOINT)

	DllStructSetData($tPOINT, 1, $iX)
	DllStructSetData($tPOINT, 2, $iY)

	Return $tPOINT
EndFunc   ;==>_WinAPI_CreatePoint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreatePolygonRgn
; Description....: Creates a polygonal region.
; Syntax.........: _WinAPI_CreatePolygonRgn ( Const ByRef $aPoint [, $iStart [, $iEnd [, $iMode]]] )
; Parameters.....: $aPoint - The 2D array ([x1, y1], [x2, y2], ... [xN, yN]) that contains the vertices of the polygon in logical
;                            units. The polygon is presumed closed. Each vertex can be specified only once.
;                  $iStart - The index of array to start creating at.
;                  $iEnd   - The index of array to stop creating at.
;                  $iMode  - The fill mode used to determine which pixels are in the region. This parameter can be one of the
;                            following values.
;
;                            $ALTERNATE
;                            $WINDING
;
; Return values..: Success - The handle to the region.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you no longer need the HRGN object, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: @@MsdnLink@@ CreatePolygonRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreatePolygonRgn(Const ByRef $aPoint, $iStart = 0, $iEnd = -1, $iMode = 1)

	If UBound($aPoint, 2) < 2  Then
		Return SetError(2, 0, 0)
	EndIf

	Local $Count, $tData, $Struct = ''

	If $iStart < 0 Then
		$iStart = 0
	EndIf
	If ($iEnd < 0) Or ($iEnd > UBound($aPoint) - 1) Then
		$iEnd = UBound($aPoint) - 1
	EndIf
	For $i = $iStart To $iEnd
		$Struct &= 'int[2];'
	Next
	$tData = DllStructCreate($Struct)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$Count = 1
	For $i = $iStart To $iEnd
		For $j = 0 To 1
			DllStructSetData($tData, $Count, $aPoint[$i][$j], $j + 1)
		Next
		$Count += 1
	Next

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreatePolygonRgn', 'ptr', DllStructGetPtr($tData), 'int', $Count - 1, 'int', $iMode)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreatePolygonRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateProcessWithToken
; Description....: Creates a new process and its primary thread in the security context of the specified token.
; Syntax.........: _WinAPI_CreateProcessWithToken ( $sApp, $sCmd, $iFlags, $pStartupInfo, $pProcessInfo, $hToken [, $iLogon [, $pEnvironment [, $sDir]]] )
; Parameters.....: $sApp         - The name of the module to be executed. If this parameter is an empty string, the module name must
;                                  be the first white spacedelimited token in the command line string.
;                  $sCmd         - The command line to be executed. If this parameter is an empty string, the function uses the
;                                  module name as the command line.
;                  $iFlags       - The flags that control how the process is created. The $CREATE_DEFAULT_ERROR_MODE, $CREATE_NEW_CONSOLE,
;                                  and $CREATE_NEW_PROCESS_GROUP are enabled by default. You can specify additional flags as noted.
;
;                                  $CREATE_DEFAULT_ERROR_MODE
;                                  $CREATE_NEW_CONSOLE
;                                  $CREATE_NEW_PROCESS_GROUP
;                                  $CREATE_SEPARATE_WOW_VDM
;                                  $CREATE_SUSPENDED
;                                  $CREATE_UNICODE_ENVIRONMENT
;
;                  $pStartupInfo - A pointer to a $tagSTARTUPINFO structure.
;                  $pProcessInfo - A pointer to a $tagPROCESS_INFORMATION structure that receives information for the new process,
;                                  including a handle to the process.
;                  $hToken       - A handle to the primary token that represents a user. The handle must have the $TOKEN_QUERY,
;                                  $TOKEN_DUPLICATE, and $TOKEN_ASSIGN_PRIMARY access rights.
;                  $iLogon       - The logon option. This parameter can be zero or one of the following values.
;
;                                  $LOGON_WITH_PROFILE
;                                  $LOGON_NETCREDENTIALS_ONLY
;
;                  $pEnvironment - A pointer to an environment block for the new process.
;                  $sDir         - The path to the current directory for the process. If this parameter is an empty string, the new
;                                  process will have the same current drive and directory as the calling process.
; Return values..: Success       - 1.
;                  Failure       - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: To retrieve a security token, pass the process handle in the $tagPROCESS_INFORMATION structure to the
;                  _WinAPI_OpenProcessToken() function.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ CreateProcessWithTokenW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateProcessWithToken($sApp, $sCmd, $iFlags, $pStartupInfo, $pProcessInfo, $hToken, $iLogon = 0, $pEnvironment = 0, $sDir = '')

	Local $TypeOfApp = 'wstr', $TypeOfCmd = 'wstr', $TypeOfDir = 'wstr'

	If Not StringStripWS($sApp, 3) Then
		$TypeOfApp = 'ptr'
		$sApp = 0
	EndIf
	If Not StringStripWS($sCmd, 3) Then
		$TypeOfCmd = 'ptr'
		$sCmd = 0
	EndIf
	If Not StringStripWS($sDir, 3) Then
		$TypeOfDir = 'ptr'
		$sDir = 0
	EndIf

	Local $Ret = DllCall('advapi32.dll', 'int', 'CreateProcessWithTokenW', 'ptr', $hToken, 'dword', $iLogon, $TypeOfApp, $sApp, $TypeOfCmd, $sCmd, 'dword', $iFlags, 'ptr', $pEnvironment, $TypeOfDir, $sDir, 'ptr', $pStartupInfo, 'ptr', $pProcessInfo)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CreateProcessWithToken

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateRect
; Description....: Creates $tagRECT structure with the coordinates of the specified rectangle.
; Syntax.........: _WinAPI_CreateRect ( $iLeft, $iTop, $iRight, $iBottom )
; Parameters.....: $iLeft   - The x-coordinate of the upper-left corner of the rectangle.
;                  $iTop    - The y-coordinate of the upper-left corner of the rectangle.
;                  $iRight  - The x-coordinate of the lower-right corner of the rectangle.
;                  $iBottom - The y-coordinate of the lower-right corner of the rectangle.
; Return values..: Success  - $tagRECT structure that contains the specified rectangle.
;                  Failure  - 0.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateRect($iLeft, $iTop, $iRight, $iBottom)

	Local $tRECT = DllStructCreate($tagRECT)

	DllStructSetData($tRECT, 1, $iLeft)
	DllStructSetData($tRECT, 2, $iTop)
	DllStructSetData($tRECT, 3, $iRight)
	DllStructSetData($tRECT, 4, $iBottom)

	Return $tRECT
EndFunc   ;==>_WinAPI_CreateRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateRectEx
; Description....: Creates $tagRECT structure with the coordinates of the specified rectangle.
; Syntax.........: _WinAPI_CreateRectEx ( $iX, $iY, $iWidth, $iHeight )
; Parameters.....: $iX      - The x-coordinate of the upper-left corner of the rectangle.
;                  $iY      - The y-coordinate of the upper-left corner of the rectangle.
;                  $iWidth  - The width of the rectangle.
;                  $iHeight - The height of the rectangle.
; Return values..: Success  - $tagRECT structure that contains the specified rectangle.
;                  Failure  - 0.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateRectEx($iX, $iY, $iWidth, $iHeight)

	Local $tRECT = DllStructCreate($tagRECT)

	DllStructSetData($tRECT, 1, $iX)
	DllStructSetData($tRECT, 2, $iY)
	DllStructSetData($tRECT, 3, $iX + $iWidth)
	DllStructSetData($tRECT, 4, $iY + $iHeight)

	Return $tRECT
EndFunc   ;==>_WinAPI_CreateRectEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateRectRgnIndirect
; Description....: Creates a rectangular region.
; Syntax.........: _WinAPI_CreateRectRgnIndirect ( $tRECT )
; Parameters.....: $tRECT  - $tagRECT structure that contains the coordinates of the upper-left and lower-right corners of the
;                            rectangle that defines the region in logical units.
; Return values..: Success - The handle to the region.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you no longer need the HRGN object, call the _WinAPI_DeleteObject() function to delete it.
; Related........:
; Link...........: @@MsdnLink@@ CreateRectRgnIndirect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateRectRgnIndirect($tRECT)

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'CreateRectRgnIndirect', 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateRectRgnIndirect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateSemaphore
; Description....: Creates or opens a named or unnamed semaphore object.
; Syntax.........: _WinAPI_CreateSemaphore ( $sSemaphore, $iInitial, $iMaximum [, $tSecurity] )
; Parameters.....: $sSemaphore - The name of the semaphore to be opened. Name comparisons are case sensitive.
;                  $iInitial   - The initial count for the semaphore object. This value must be greater than or equal to zero and
;                                less than or equal to $iMaximum.
;                  $iMaximum   - The maximum count for the semaphore object. This value must be greater than zero.
;                  $tSecurity  - $tagSECURITY_ATTRIBUTES structure that specifies a security descriptor for the new semaphore.
;                                If this parameter is 0, the semaphore gets a default security descriptor.
; Return values..: Success     - The handle to the newly created semaphore object.
;                  Failure     - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the named semaphore object existed before the function call, the function returns a handle to the existing object.
;
;                  Any process can specify the semaphore-object handle in a call to _WinAPI_WaitFor... functions. The single-object
;                  wait functions return when the state of the specified object is signaled. The multiple-object wait functions can
;                  be instructed to return either when any one or when all of the specified objects are signaled. When a wait function
;                  returns, the waiting process is released to continue its execution.
;
;                  The state of a semaphore object is signaled when its count is greater than zero, and nonsignaled when its count
;                  is equal to zero. The $iInitial parameter specifies the initial count. Each time a waiting process is released
;                  because of the semaphore's signaled state, the count of the semaphore is decreased by one. Use the _WinAPI_ReleaseSemaphore()
;                  function to increment a semaphore's count by a specified amount. The count can never be less than zero or greater
;                  than the value specified in the $iMaximum parameter.
;
;                  Use the _WinAPI_CloseHandle() function to close the handle. The system closes the handle automatically when the
;                  process terminates. The semaphore object is destroyed when its last handle has been closed.
; Related........:
; Link...........: @@MsdnLink@@ CreateSemaphore
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateSemaphore($sSemaphore, $iInitial, $iMaximum, $tSecurity = 0)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'CreateSemaphoreW', 'ptr', DllStructGetPtr($tSecurity), 'int', $iInitial, 'int', $iMaximum, 'wstr', $sSemaphore)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateSemaphore

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateSize
; Description....: Creates $tagSIZE structure with the width and height of the specified rectangle.
; Syntax.........: _WinAPI_CreateSize ( $iWidth, $iHeight )
; Parameters.....: $iWidth  - The width of the rectangle.
;                  $iHeight - The height of the rectangle.
; Return values..: Success  - $tagSIZE structure that contains the specified rectangle.
;                  Failure  - 0.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateSize($iWidth, $iHeight)

	Local $tSIZE = DllStructCreate($tagSIZE)

	DllStructSetData($tSIZE, 1, $iWidth)
	DllStructSetData($tSIZE, 2, $iHeight)

	Return $tSIZE
EndFunc   ;==>_WinAPI_CreateSize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateStreamOnHGlobal
; Description....: Creates a stream object that uses a memory handle to store the stream contents.
; Syntax.........: _WinAPI_CreateStreamOnHGlobal ( [$hGlobal [, $fDeleteOnRelease]] )
; Parameters.....: $hGlobal          - The memory handle, or if 0 a new handle is to be allocated instead. The handle must be
;                                      allocated as moveable and nondiscardable.
;                  $fDeleteOnRelease - Specifies whether the underlying handle for this stream object should be automatically
;                                      freed when the stream object is released, valid values:
;                  |TRUE             - The final release will automatically free the $hGlobal parameter. (Default)
;                  |FALSE            - The user must free the $hGlobal after the final release.
; Return values..: Success           - The pointer to the new stream object.
;                  Failure           - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: If $hGlobal is 0, the function allocates a new memory handle and the stream is initially empty, otherwise, the
;                  initial contents of the stream are the current contents of the memory block. Thus, _WinAPI_CreateStreamOnHGlobal()
;                  can be used to open an existing stream in memory. The memory handle and its contents are undisturbed by the
;                  creation of the new stream object.
;
;                  After creating the stream object with _WinAPI_CreateStreamOnHGlobal(), call _WinAPI_GetHGlobalFromStream() to
;                  retrieve the memory handle associated with the stream object.
;
;                  To release the stream object, use the _WinAPI_ReleaseStream() function.
; Related........:
; Link...........: @@MsdnLink@@ CreateStreamOnHGlobal
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateStreamOnHGlobal($hGlobal = 0, $fDeleteOnRelease = 1)

	Local $Ret = DllCall('ole32.dll', 'uint', 'CreateStreamOnHGlobal', 'ptr', $hGlobal, 'int', $fDeleteOnRelease, 'ptr*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_CreateStreamOnHGlobal

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateString
; Description....: Copies a specified string to the newly allocated memory block and returns its pointer.
; Syntax.........: _WinAPI_CreateString ( $sString [, $pString [, $iLength [, $fUnicode [, $fAbort]]]] )
; Parameters.....: $sString  - The source string to be copied.
;                  $pString  - A pointer to a string that to be replaced by a new string. If this parameter is a valid string pointer,
;                              the memory will be reallocated for a new string. However, a new memory is allocated at a different
;                              location. Therefore, you should always use a pointer that returns this function. If this parameter is
;                              0, omitted, or an invalid string pointer, the function just allocates a new memory.
;                  $iLength  - The required buffer length, in TCHARs, without null-terminating character. If this parameter is (-1),
;                              the buffer length will be equal to the length of the source string. If $iLength is less than
;                              a source string, the string will be truncated to the specified length.
;                  $fUnicode - Specifies whether a string is Unicode or ASCII code of a character, valid values:
;                  |TRUE     - Unicode. (Default)
;                  |FALSE    - ASCII.
;                  $fAbort   - Specifies whether to exit the script if not enough memory, valid values:
;                  |TRUE     - Displaying an error message and exit the script with code 1. (Default)
;                  |FALSE    - Continue the script and return an error.
; Return values..: A pointer to the new null-terminated string, @extended returns the length of the string buffer, in TCHARs
;                  (not including the null-terminating character).
; Author.........: Yashied
; Modified.......:
; Remarks........: When a string is no longer needed, you must destroy it by calling the _WinAPI_FreeMemory() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateString($sString, $pString = 0, $iLength = -1, $fUnicode = 1, $fAbort = 1)

	Local $Size

	$iLength = Number($iLength)
	If $iLength >= 0 Then
		$sString = StringLeft($sString, $iLength)
	Else
		$iLength = StringLen($sString)
	EndIf
	$Size = $iLength + 1
	If $fUnicode Then
		$Size *= 2
	EndIf
	$pString = __HeapReAlloc($pString, $Size, 0, $fAbort)
	If @error Then
		Return SetError(@error, 0, 0)
	EndIf
	DllStructSetData(DllStructCreate(__Iif($fUnicode, 'wchar', 'char') & '[' & ($iLength + 1) & ']', $pString), 1, $sString)
	Return SetError(0, $iLength, $pString)
EndFunc   ;==>_WinAPI_CreateString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateSymbolicLink
; Description....: Creates a symbolic link.
; Syntax.........: _WinAPI_CreateSymbolicLink ( $sSymlink, $sTarget [, $fDirectory] )
; Parameters.....: $sSymlink   - The name of the new file.
;                  $sTarget    - The name of the existing file.
;                  $fDirectory - Specifies whether the link target is a directory.
;                  |TRUE       - The link target is a directory.
;                  |FALSE      - The link target is a file. (Default)
; Return values..: Success     - 1.
;                  Failure     - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: To remove a symbolic link, delete the file (using _WinAPI_DeleteFile() or similar APIs) or remove the directory
;                  (using _WinAPI_RemoveDirectory() or similar APIs) depending on what type of symbolic link is used.
;
;                  The calling process must have $SE_CREATE_SYMBOLIC_LINK_NAME privilege, otherwise, the function fails, and
;                  _WinAPI_GetLastError() returns ERROR_PRIVILEGE_NOT_HELD (1314).
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ CreateSymbolicLink
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateSymbolicLink($sSymlink, $sTarget, $fDirectory = 0)

	If $fDirectory Then
		$fDirectory = 1
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'CreateSymbolicLink', 'str', $sSymlink, 'str', $sTarget, 'dword', $fDirectory)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_CreateSymbolicLink

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateTransform
; Description....: Ceates $tagXFORM structure specifies a world-space to page-space transformation.
; Syntax.........: _WinAPI_CreateTransform ( [$nM11 [, $nM12 [, $nM21 [, $nM22 [, $nDX [, $nDY]]]]]] )
; Parameters.....: $nM11   - The following.
;
;                            Rotation   - Cosine of rotation angle.
;                            Scaling    - Horizontal scaling component.
;                            Shear      - Not used.
;                            Reflection - Horizontal component.
;
;                  $nM12   - The following.
;
;                            Rotation   - Sine of the rotation angle.
;                            Scaling    - Not used.
;                            Shear      - Horizontal proportionality constant.
;                            Reflection - Not used.
;
;                  $nM21   - The following.
;
;                            Rotation   - Negative sine of the rotation angle.
;                            Scaling    - Not used.
;                            Shear      - Vertical proportionality constant.
;                            Reflection - Not used.
;
;                  $nM22   - The following.
;
;                            Rotation   - Cosine of rotation angle.
;                            Scaling    - Vertical scaling component.
;                            Shear      - Not used.
;                            Reflection - Vertical reflection component.
;
;                  $nDx    - The horizontal translation component, in logical units.
;                  $nDy    - The vertical translation component, in logical units.
; Return values..: Success - $tagXFORM structure that contains the transformation data.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateTransform($nM11 = 1, $nM12 = 0, $nM21 = 0, $nM22 = 1, $nDx = 0, $nDy = 0)

	Local $tXFORM = DllStructCreate($tagXFORM)

	DllStructSetData($tXFORM, 1, $nM11)
	DllStructSetData($tXFORM, 2, $nM12)
	DllStructSetData($tXFORM, 3, $nM21)
	DllStructSetData($tXFORM, 4, $nM22)
	DllStructSetData($tXFORM, 5, $nDX)
	DllStructSetData($tXFORM, 6, $nDY)

	Return $tXFORM
EndFunc   ;==>_WinAPI_CreateTransform

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateWindowStation
; Description....: Creates a window station object, associates it with the calling process, and assigns it to the current session.
; Syntax.........: _WinAPI_CreateWindowStation ( [$sName [, $iAccess [, $iFlags [, $tSecurity]]]] )
; Parameters.....: $sName     - The name of the window station to be created. Window station names are case-insensitive and cannot
;                               contain backslash characters (\). Only members of the Administrators group are allowed to  specify
;                               a name. If lthis parameter is empty string, the system forms a window station name using the logon
;                               session identifier for the calling process.
;                  $iAccess   - The type of access the returned handle has to the window station. This parameter can be one or
;                               more of the following values.
;
;                               $WINSTA_ALL_ACCESS
;                               $WINSTA_ACCESSCLIPBOARD
;                               $WINSTA_ACCESSGLOBALATOMS
;                               $WINSTA_CREATEDESKTOP
;                               $WINSTA_ENUMDESKTOPS
;                               $WINSTA_ENUMERATE
;                               $WINSTA_EXITWINDOWS
;                               $WINSTA_READATTRIBUTES
;                               $WINSTA_READSCREEN
;                               $WINSTA_WRITEATTRIBUTES
;
;                  $iFlags    - The optional flags. It can be zero or the following value.
;
;                               $CWF_CREATE_ONLY
;
;                  $tSecurity - $tagSECURITY_ATTRIBUTES structure that determines whether the returned handle can be inherited by
;                               child processes. If this parameter is 0, the handle cannot be inherited.
; Return values..: Success    - Handle to the newly created window station. If the specified window station already exists,
;                               the function succeeds and returns a handle to the existing window station.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After you are done with the handle, you must call _WinAPI_CloseWindowStation() to free the handle.
; Related........:
; Link...........: @@MsdnLink@@ CreateWindowStation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_CreateWindowStation($sName = '', $iAccess = 0, $iFlags = 0, $tSecurity = 0)

	Local $Ret = DllCall('user32.dll', 'ptr', 'CreateWindowStationW', 'wstr', $sName, 'dword', $iFlags, 'dword', $iAccess, 'ptr', DllStructGetPtr($tSecurity))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateWindowStation

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DecompressBuffer
; Description....: Decompresses an entire compressed buffer.
; Syntax.........: _WinAPI_DecompressBuffer ( $pUncompressedBuffer, $iUncompressedSize, $pCompressedBuffer, $iCompressedSize [, $iFormat] )
; Parameters.....: $pUncompressedBuffer - A pointer to a caller-allocated buffer that receives the decompressed data from compressed buffer.
;                  $iUncompressedSize   - The size of the uncompressed buffer, in bytes.
;                  $pCompressedBuffer   - A pointer to the buffer that contains the data to decompress.
;                  $iCompressedSize     - The size of the compressed buffer, in bytes.
;                  $iFormat             - The compression format of the data in compressed buffer. This parameter must be one of the
;                                         following values.
;
;                                         $COMPRESSION_FORMAT_LZNT1
;                                         $COMPRESSION_FORMAT_XPRESS
;                                         $COMPRESSION_FORMAT_XPRESS_HUFF
;
; Return values..: Success              - The size of the decompressed data stored in uncompressed buffer, in bytes.
;                  Failure              - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_DecompressBuffer() function takes as input an entire compressed buffer and produces its decompressed
;                  equivalent provided that the uncompressed data fits within the specified destination buffer.
;
;                  To compress an uncompressed buffer, use the _WinAPI_CompressBuffer function.
; Related........:
; Link...........: @@MsdnLink@@ RtlDecompressBuffer
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DecompressBuffer($pUncompressedBuffer, $iUncompressedSize, $pCompressedBuffer, $iCompressedSize, $iFormat = 0x0002)

	Local $Ret = DllCall('ntdll.dll', 'uint', 'RtlDecompressBuffer', 'ushort', $iFormat, 'ptr', $pUncompressedBuffer, 'ulong', $iUncompressedSize, 'ptr', $pCompressedBuffer, 'ulong', $iCompressedSize, 'ulong*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_DecompressBuffer

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DecryptFile
; Description....: Decrypts an encrypted file or directory.
; Syntax.........: _WinAPI_DecryptFile ( $sFile )
; Parameters.....: $sFile  - The name of the file or directory to be decrypted. If $sFile specifies a read-only file, the function
;                            fails and the last error code is ERROR_FILE_READ_ONLY (6009). If $sFile specifies a directory that
;                            contains a read-only file, the functions succeeds but the directory is not decrypted.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_DecryptFile() function requires exclusive access to the file being decrypted, and will fail
;                  if another process is using the file.
;
;                  If the file is not encrypted, the function simply returns a nonzero value, which indicates success.
; Related........:
; Link...........: @@MsdnLink@@ DecryptFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DecryptFile($sFile)

	Local $Ret = DllCall('advapi32.dll', 'int', 'DecryptFileW', 'wstr', $sFile, 'dword', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DecryptFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DeferWindowPos
; Description....: Updates the specified multiple-window-position structure for the specified window.
; Syntax.........: _WinAPI_DeferWindowPos ( $hInfo, $hWnd, $hAfter, $iX, $iY, $iWidth, $iHeight, $iFlags )
; Parameters.....: $hInfo   - Handle to a multiple-window-position structure that contains size and position information for one
;                             or more windows. This structure is returned by _WinAPI_BeginDeferWindowPos() or by the most recent
;                             call to _WinAPI_DeferWindowPos().
;                  $hWnd    - Handle to the window for which update information is stored in the structure. All windows in a
;                             multiple-window-position structure must have the same parent.
;                  $hAfter  - Handle to the window that precedes the positioned window in the Z order. This parameter must be a
;                             window handle or one of the following values. This parameter is ignored if the $SWP_NOZORDER flag
;                             is set in the $iFlags parameter.
;
;                             $HWND_BOTTOM
;                             $HWND_NOTOPMOST
;                             $HWND_TOP
;                             $HWND_TOPMOST
;
;                  $iX      - The x-coordinate of the window's upper-left corner.
;                  $iY      - The y-coordinate of the window's upper-left corner.
;                  $iWidth  - The window's new width, in pixels.
;                  $iHeight - The window's new height, in pixels.
;                  $iFlags  - A combination of the following values that affect the size and position of the window.
;
;                             $SWP_DRAWFRAME
;                             $SWP_FRAMECHANGED
;                             $SWP_HIDEWINDOW
;                             $SWP_NOACTIVATE
;                             $SWP_NOCOPYBITS
;                             $SWP_NOMOVE
;                             $SWP_NOOWNERZORDER
;                             $SWP_NOREDRAW
;                             $SWP_NOREPOSITION
;                             $SWP_NOSENDCHANGING
;                             $SWP_NOSIZE
;                             $SWP_NOZORDER
;                             $SWP_SHOWWINDOW
;
; Return values..: Success  - The return value identifies the updated multiple-window-position structure.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: KaFu
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DeferWindowPos
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DeferWindowPos($hInfo, $hWnd, $hAfter, $iX, $iY, $iWidth, $iHeight, $iFlags)

    Local $Ret = DllCall('user32.dll', 'ptr', 'DeferWindowPos', 'ptr', $hInfo, 'hwnd', $hWnd, 'hwnd', $hAfter, 'int', $iX, 'int', $iY, 'int', $iWidth, 'int', $iHeight, 'uint', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_DeferWindowPos

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DefineDosDevice
; Description....: Defines, redefines, or deletes MS-DOS device names.
; Syntax.........: _WinAPI_DefineDosDevice ( $sDevice, $iFlags [, $sPath] )
; Parameters.....: $sDevice - The name of the MS-DOS device.
;                  $iFlags  - This parameter can be one or more of the following values.
;
;                             $DDD_EXACT_MATCH_ON_REMOVE
;                             $DDD_NO_BROADCAST_SYSTEM
;                             $DDD_RAW_TARGET_PATH
;                             $DDD_REMOVE_DEFINITION
;
;                  $sPath   - The path that will implement device.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DefineDosDevice
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DefineDosDevice($sDevice, $iFlags, $sPath = '')

	Local $TypeOfPath = 'wstr'

	If Not StringStripWS($sPath, 3) Then
		$TypeOfPath = 'ptr'
		$sPath = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'DefineDosDeviceW', 'dword', $iFlags, 'wstr', $sDevice, $TypeOfPath, $sPath)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DefineDosDevice

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DefRawInputProc
; Description....: Calls the default raw input procedure to process the raw input messages that an application does not process.
; Syntax.........: _WinAPI_DefRawInputProc ( $pRawInput, $iInput )
; Parameters.....: $pRawInput - A pointer to an array of $tagRAWINPUT structures that is returned by _WinAPI_GetRawInputBuffer().
;                  $iInput    - The number of structures in array.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DefRawInputProc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DefRawInputProc($pRawInput, $iInput)

	Local $Ret = DllCall('user32.dll', 'uint', 'DefRawInputProc', 'ptr', $pRawInput, 'int', $iInput, 'uint', __Iif(@AutoItX64, 24, 16))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DefRawInputProc

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DefSubclassProc
; Description....: Calls the next handler in a window's subclass chain.
; Syntax.........: _WinAPI_DefSubclassProc ( $hWnd, $iMsg, $wParam, $lParam )
; Parameters.....: $hWnd   - Handle to the window being subclassed.
;                  $iMsg   - The message to be sent.
;                  $wParam - The message-specific information.
;                  $lParam - The message-specific information.
; Return values..: Success - The returned value is specific to the message sent.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The last handler in the subclass chain is the original window procedure for the specified window. You do not
;                  need  to call the default window procedure; this function calls it automatically.
; Related........:
; Link...........: @@MsdnLink@@ DefSubclassProc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DefSubclassProc($hWnd, $iMsg, $wParam, $lParam)

	Local $Ret = DllCall('comctl32.dll', 'lresult', 'DefSubclassProc', 'hwnd', $hWnd, 'uint', $iMsg, 'wparam', $wParam, 'lparam', $lParam)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_DefSubclassProc

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DefWindowProcW
; Description....: Calls the default window procedure to provide default processing for any window messages.
; Syntax.........: _WinAPI_DefWindowProcW ( $hWnd, $iMsg, $wParam, $lParam )
; Parameters.....: $hWnd     - A handle to the window procedure that received the message.
;                  $iMsg     - The message.
;                  $wParam   - Additional message-specific information. The content of this parameter depends on the message.
;                  $lParam   - Additional message-specific information. The content of this parameter depends on the message.
; Return values..: Success   - The result of the message processing and depends on the message sent.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DefWindowProc
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DefWindowProcW($hWnd, $iMsg, $wParam, $lParam)

	Local $Ret = DllCall('user32.dll', 'lresult', 'DefWindowProcW', 'hwnd', $hWnd, 'uint', $iMsg, 'wparam', $wParam, 'lparam', $lParam)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_DefWindowProcW

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DeleteEnhMetaFile
; Description....: Deletes an enhanced-format metafile or an enhanced-format metafile handle.
; Syntax.........: _WinAPI_DeleteEnhMetaFile ( $hEmf )
; Parameters.....: $hEmf   - Handle to an enhanced metafile.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the $hEmf parameter identifies an enhanced metafile stored in memory, the _WinAPI_DeleteEnhMetaFile() function
;                  deletes the metafile. If $hEmf identifies a metafile stored on a disk, the function deletes the metafile handle but
;                  does not destroy the actual metafile. An application can retrieve the file by calling the _WinAPI_GetEnhMetaFile()
;                  function.
; Related........:
; Link...........: @@MsdnLink@@ DeleteEnhMetaFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DeleteEnhMetaFile($hEmf)

	Local $Ret = DllCall('gdi32.dll', 'int', 'DeleteEnhMetaFile', 'ptr', $hEmf)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DeleteEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DeleteFile
; Description....: Deletes an existing file.
; Syntax.........: _WinAPI_DeleteFile ( $sFile )
; Parameters.....: $sFile  - The name of the file to be deleted.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DeleteFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DeleteFile($sFile)

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeleteFileW', 'wstr', $sFile)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DeleteFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DeleteObjectID
; Description....: Removes the object identifier from a specified file or directory.
; Syntax.........: _WinAPI_DeleteObjectID ( $sPath )
; Parameters.....: $sPath  - Path to the file or directory from the object identifier that is to be deleted.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The calling process must have $SE_BACKUP_NAME privilege, otherwise, the function fails, and _WinAPI_GetLastError()
;                  returns ERROR_ACCESS_DENIED (5).
; Related........:
; Link...........: @@MsdnLink@@ FSCTL_DELETE_OBJECT_ID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DeleteObjectID($sPath)

	Local $hFile = _WinAPI_CreateFileEx($sPath, 3, 0x40000000, 0x03, 0x02000000)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x000900A0, 'ptr', 0, 'dword', 0, 'ptr', 0, 'dword', 0, 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DeleteObjectID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DeleteVolumeMountPoint
; Description....: Deletes a drive letter or mounted folder.
; Syntax.........: _WinAPI_DeleteVolumeMountPoint ( $sPath )
; Parameters.....: $sPath  - The drive letter or mounted folder to be deleted (for example, X:\ or Y:\MountX\).
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Deleting a mounted folder does not cause the underlying directory to be deleted.
; Related........:
; Link...........: @@MsdnLink@@ DeleteVolumeMountPoint
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DeleteVolumeMountPoint($sPath)

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeleteVolumeMountPointW', 'wstr', $sPath)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DeleteVolumeMountPoint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DeregisterShellHookWindow
; Description....: Unregisters a specified Shell window that is registered to receive Shell hook messages.
; Syntax.........: _WinAPI_DeregisterShellHookWindow ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to unregister from receiving Shell hook messages.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DeregisterShellHookWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DeregisterShellHookWindow($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'DeregisterShellHookWindow', 'hwnd', $hWnd)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DeregisterShellHookWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DestroyCaret
; Description....: Destroys the caret's current shape, frees the caret from the window, and removes the caret from the screen.
; Syntax.........: _WinAPI_DestroyCaret ( )
; Parameters.....: None
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: _WinAPI_DestroyCaret() destroys the caret only if a window in the current task owns the caret. If a window that
;                  is not in the current task owns the caret, _WinAPI_DestroyCaret() does nothing and returns 0.
;
;                  The window should destroy the caret before losing the keyboard focus or becoming inactive.
; Related........:
; Link...........: @@MsdnLink@@ DestroyCaret
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DestroyCaret()

	Local $Ret = DllCall('user32.dll', 'int', 'DestroyCaret')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DestroyCaret

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DestroyCursor
; Description....: Destroys a cursor and frees any memory the cursor occupied.
; Syntax.........: _WinAPI_DestroyCursor ( $hCursor )
; Parameters.....: $hCursor - Handle to the cursor to be destroyed. The cursor must not be in use.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function destroys a nonshared cursor. Do not use this function to destroy a shared cursor. A shared cursor
;                  is valid as long as the module from which it was loaded remains in memory.
; Related........:
; Link...........: @@MsdnLink@@ DestroyCursor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DestroyCursor($hCursor)

	Local $Ret = DllCall('user32.dll', 'int', 'DestroyCursor', 'ptr', $hCursor)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DestroyCursor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DeviceIoControl
; Description....: Sends a control code directly to a specified device driver.
; Syntax.........: _WinAPI_DeviceIoControl ( $hDevice, $iControlCode [, $pInBuffer [, $iInBufferSize [, $pOutBuffer [, $iOutBufferSize]]]] )
; Parameters.....: $hDevice        - Handle to the device on which the operation is to be performed. The device is typically a volume,
;                                    directory, file, or stream. To retrieve a device handle, use the _WinAPI_CreateFileEx function.
;                                    To specify a device name, use the following format:
;
;                                    _WinAPI_CreateFileEx("\\.\DeviceName", ...)
;
;                  $iControlCode   - The control code for the operation. This value identifies the specific operation to be performed
;                                    and the type of device on which to perform it.
;                  $pInBuffer      - A pointer to the input buffer that contains the data required to perform the operation.
;                  $iInBufferSize  - The size of the input buffer, in bytes.
;                  $pOutBuffer     - A pointer to the output buffer that is to receive the data returned by the operation.
;                  $iOutBufferSize - The size of the output buffer, in bytes.
; Return values..: Success - 1 and @extended flag contains the size of the data stored in the output buffer, in bytes.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DeviceIoControl
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DeviceIoControl($hDevice, $iControlCode, $pInBuffer = 0, $iInBufferSize = 0, $pOutBuffer = 0, $iOutBufferSize = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hDevice, 'dword', $iControlCode, 'ptr', $pInBuffer, 'dword', $iInBufferSize, 'ptr', $pOutBuffer, 'dword', $iOutBufferSize, 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, $Ret[7], 1)
EndFunc   ;==>_WinAPI_DeviceIoControl

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DisplayStruct
; Description....: Displays data from the specified structure or memory address as a list.
; Syntax.........: _WinAPI_DisplayStruct ( $tStruct [, $sStruct [, $sTitle [, $iItem [, $iSubItem [, $iFlags [, $fTop [, $hParent]]]]]]] )
; Parameters.....: $tStruct  - A structure that was created by DllStructCreate(), or memory address to be display its data.
;                  $sStruct  - A string representing the structure. If $tStruct is a structure, this parameter can be omitted or be
;                              an empty string. In this case, the structure will display as "byte[n]" structure. If $tStruct is a
;                              memory address, $sStruct should be a string representing the structure, otherwise, the function
;                              fail, and @error set to 1.
;                  $sTitle   - The title of the window, deault is "Structure: ListView Display".
;                  $iItem    - The 1-based index or name of the structure member to be selected in the list. If this parameter is 0,
;                              or an incorrect index or name, the first element of the structure will be selected.
;                  $iSubItem - The 1-based index of the array in the structure member pointed to by the $iItem parameter to be
;                              selected. If $iItem was not defined as an array in the $sStruct, or invalid array index, the element
;                              pointed to by the $iItem parameter will be selected.
;                  $iFlags   - A set of bit flags that specifies an additional displaying options. This parameter can be 0, or any
;                              combination of the following values.
;
;                              1 - Prevent displaying "<struct>" and "<endstruct>" fields at the beginning and end of the list.
;                              2 - Prevent displaying "<alignment>" fields.
;                              4 - Prevent displaying "<unnamed>" in "Member" column of the list if the structure element has no name.
;                              8 - Prevent highlighting structure elements that are defined as an array.
;                             16 - Prevent perceiving structure elements named "Reserved*" as unused elements.
;                             32 - Prevent using double-click to copy values of the structure elements to the clipboard.
;                             64 - Forced to expand structure elements of BYTE[n], UBYTE[n], and BOOLEAN[n] types (elements of CHAR[n] and WCHAR[n] types always displays as a string).
;                            128 - Forced to display the values of the structure elements in the hexadecimal representation, if possibly.
;                            256 - Forced to return error code instead of displaying a message box if a memory access error occurred.
;                            512 - Forced to disable checking the read access memory allocated to a given structure.
;
;                  $fTop     - Specifies whether create a window with "Always On Top" attribute, valid values:
;                  |TRUE     - The window is created with the $WS_EX_TOPMOST extended style. (Default)
;                  |FALSE    - The window will not have the "TOPMOST" flag set.
;                  $hParent  - Handle to the parent window.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to the one of the following values:
;
;                              1 - The $sStruct parameter is not a string.
;                              2 - There is an unknown data type in the string passed.
;                              3 - Failed to allocate the memory needed for the structure, or invalid pointer.
;                              4 - Unspecified error.
;                              5 - Error accessing memory to read data.
;
; Author.........: Yashied
; Modified.......:
; Remarks........: This function is intended primarily for debugging and should not be used in the final script, since no useful
;                  information for the end user does not carry.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DisplayStruct($tStruct, $sStruct = '', $sTitle = '', $iItem = 0, $iSubItem = 0, $iFlags = 0, $fTop = 1, $hParent = 0)

	Local $aData, $iData, $tData, $pData

	If Not StringStripWS($sTitle, 3) Then
		$sTitle = 'Structure: ListView Display'
	EndIf
	$sStruct = StringRegExpReplace(StringStripWS($sStruct, 7), ';+\Z', '')
	If IsDllStruct($tStruct) Then
		$pData = DllStructGetPtr($tStruct)
		If Not $sStruct Then
			$sStruct = 'byte[' & DllStructGetSize($tStruct) & ']'
			$iFlags = BitOR($iFlags, 64)
		EndIf
	Else
		$pData = $tStruct
		If Not $sStruct Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	$tData = DllStructCreate($sStruct, $pData)
	If @error Then
		Return SetError(@error, 0, 0)
	EndIf
	$iData = DllStructGetSize($tData)
	If (Not BitAND($iFlags, 512)) And (_WinAPI_IsBadReadPtr($pData, $iData)) Then
		If Not BitAND($iFlags, 256) Then
			_WinAPI_MsgBox(0x00040010, $sTitle, 'The memory range allocated to a given structure could not be read.' & @CRLF & @CRLF & Ptr($pData) & ' - ' & Ptr($pData + $iData - 1) & @CRLF & @CRLF & 'Press OK to exit.')
			Exit -1073741819
		EndIf
		Return SetError(5, 0, 0)
	EndIf

	Local $LV, $hLV, $ID, $Init, $Dummy
	Local $pDll, $aItem, $rItem, $sItem, $iMode, $iSize, $Index, $Offset, $Pattern, $Count = 0, $Prev = 0
	Local $tParam = DllStructCreate('ptr;uint')
	Local $Opt1 = Opt('GUIDataSeparatorChar', '|')
	Local $Opt2 = Opt('GUIOnEventMode', 0)
	Local $Opt3 = Opt('GUICloseOnESC', 1)
	Local $iStyle = 0x00000001
	Local $Width[6] = [30, 130, 76, 100, 50, 167]
	Local $Sel[2] = [0, 0]
	Local $Val[101] = [0]
	Local $Type[29][2] = _
		   [['BYTE',      1], _
			['UBYTE',     1], _
			['BOOLEAN',   1], _
			['CHAR',      1], _
			['WCHAR',     2], _
			['short',     2], _
			['USHORT',    2], _
			['WORD',      2], _
			['int',       4], _
			['long',      4], _
			['BOOL',      4], _
			['UINT',      4], _
			['ULONG',     4], _
			['DWORD',     4], _
			['INT64',     8], _
			['UINT64',    8], _
			['ptr',       __Iif(@AutoItX64, 8, 4)], _
			['HWND',      __Iif(@AutoItX64, 8, 4)], _
			['HANDLE',    __Iif(@AutoItX64, 8, 4)], _
			['float',     4], _
			['double',    8], _
			['INT_PTR',   __Iif(@AutoItX64, 8, 4)], _
			['LONG_PTR',  __Iif(@AutoItX64, 8, 4)], _
			['LRESULT',   __Iif(@AutoItX64, 8, 4)], _
			['LPARAM',    __Iif(@AutoItX64, 8, 4)], _
			['UINT_PTR',  __Iif(@AutoItX64, 8, 4)], _
			['ULONG_PTR', __Iif(@AutoItX64, 8, 4)], _
			['DWORD_PTR', __Iif(@AutoItX64, 8, 4)], _
			['WPARAM',    __Iif(@AutoItX64, 8, 4)]]

	If $hParent Then
		GUISetState(@SW_DISABLE, $hParent)
	EndIf
	If $fTop Then
		$iStyle = BitOR($iStyle, 0x00000008)
	EndIf
	$__Dlg = GUICreate($sTitle, 570, 620, -1, -1, 0x80C70000, $iStyle, $hParent)
	$LV = GUICtrlCreateListView('#|Member|Offset|Type|Size|Value', 0, 0, 570, 620, 0x0000800D, __Iif($__WINVER < 0x0600, 0x00010031, 0x00010030))
	$hLV = GUICtrlGetHandle($LV)
	If $__WINVER >= 0x0600 Then
		_WinAPI_SetWindowTheme($hLV, 'Explorer')
	EndIf
	GUICtrlSetResizing(-1, 0x0066)
	GUICtrlSetFont(-1, 8.5, 400, 0, 'Tahoma')
	GUICtrlSetState(-1, 0x0100)
	If Not BitAND($iFlags, 1) Then
		__Inc($Val)
		$Val[$Val[0]] = ''
		GUICtrlCreateListViewItem('-|-|' & $pData & '|<struct>|0|-', $LV)
		GUICtrlSetColor(-1, 0x9C9C9C)
	EndIf
	$aData = StringSplit($sStruct, ';')
	For $i = 1 To $aData[0]
		$aItem = StringSplit(StringStripWS($aData[$i], 3), ' ')
		Switch $aItem[1]
			Case 'ALIGN', 'STRUCT', 'ENDSTRUCT'
				ContinueLoop
			Case Else

		EndSwitch
		$Count+= 1
		$iMode = 1
		$sItem = $Count & '|'
		If $aItem[0] > 1 Then
			$rItem = StringRegExpReplace($aItem[2], '\[.*\Z', '')
			$sItem &= $rItem & '|'
			If (Not BitAND($iFlags, 16)) And (Not StringCompare(StringRegExpReplace($rItem, '[0-9]+\Z', ''), 'RESERVED')) Then
				$iMode = 0
			EndIf
			If Not IsString($iItem) Then
				$rItem = $Count
			EndIf
			$Index = 2
		Else
			If Not BitAND($iFlags, 4) Then
				$sItem &= '<unnamed>|'
			Else
				$sItem &= '|'
			EndIf
			If Not IsString($iItem) Then
				$rItem = $Count
			Else
				$rItem = 0
			EndIf
			$Index = 1
		EndIf
		If (Not $Sel[0]) And ($rItem) And ($iItem) And ($rItem = $iItem) Then
			$Sel[0] = $Count
		EndIf
		$Offset = Number(DllStructGetPtr($tData, $Count) - $pData)
		$Index = StringRegExp($aItem[$Index], '\[(\d+)\]', 3)
		Do
			ReDim $aItem[3]
			$rItem = StringRegExpReplace($aItem[1], '\[.*\Z', '')
			For $j = 0 To UBound($Type) - 1
				If Not StringCompare($Type[$j][0], $rItem) Then
					$aItem[1] = $Type[$j][0]
					$aItem[2] = $Type[$j][1]
					$iSize = $aItem[2]
					ExitLoop 2
				EndIf
			Next
			$aItem[1] = '?'
			$aItem[2] = '?'
			$iSize = 0
		Until 1
		$sItem &= $Offset & '|'
		If (IsArray($Index)) And ($Index[0] > '1') Then
			If $iSize Then
				$aItem[2] = $aItem[2] * $Index[0]
			EndIf
			Do
				Switch $aItem[1]
					Case 'BYTE', 'UBYTE', 'BOOLEAN'
						If Not BitAND($iFlags, 64) Then
							ContinueCase
						EndIf
					Case 'CHAR', 'WCHAR'
						$sItem &= $aItem[1] & '[' & $Index[0] & ']|' & $aItem[2] & '|'
						$Index = 0
						ExitLoop
					Case Else

				EndSwitch
				If ($iSize) And ($iMode) Then
					$sItem &= $aItem[1] & '[' & $Index[0] & ']|' & $aItem[2] & ' (' & $iSize & ')' & '|'
				Else
					$sItem &= $aItem[1] & '[' & $Index[0] & ']|' & $aItem[2] & '|'
				EndIf
				If $iMode Then
					$Index = $Index[0]
				Else
					$Index = 0
				EndIf
			Until 1
		Else
			$sItem &= $aItem[1] & '|' & $aItem[2] & '|'
			$Index = 0
		EndIf
		If (Not BitAND($iFlags, 2)) And ($Prev) And ($Offset > $Prev) Then
			__Inc($Val)
			$Val[$Val[0]] = ''
			GUICtrlCreateListViewItem('-|-|-|<alignment>|' & ($Offset - $Prev) & '|-', $LV)
			GUICtrlSetColor(-1, 0xFF0000)
		EndIf
		If $iSize Then
			$Prev = $Offset + $aItem[2]
		Else
			$Prev = 0
		EndIf
		If $Index Then
			$Pattern = '[%0' & StringLen($Index) & 'd] '
			For $j = 1 To $Index
				__Inc($Val)
				$Val[$Val[0]] = DllStructGetData($tData, $Count, $j)
				If BitAND($iFlags, 128) Then
					$Val[$Val[0]] = __Hex($Val[$Val[0]], $aItem[1])
				EndIf
				$ID = GUICtrlCreateListViewItem($sItem & StringFormat($Pattern, $j) & $Val[$Val[0]], $LV)
				If ($Sel[0] = $Count) And (Not $Sel[1]) Then
					If ($iSubItem < 1) Or ($iSubItem > $Index) Or ($iSubItem = $j) Then
						$Sel[1] = $ID
					EndIf
				EndIf
				If (Not $Init) And ($Count = 1) Then
					$Init = $ID
				EndIf
				If Not BitAND($iFlags, 8) Then
					GUICtrlSetBkColor(-1, 0xF5F5F5)
				EndIf
				If $iSize Then
					$sItem = '-|-|' & ($Offset + $j * $iSize) & '|-|-|'
				Else
					GUICtrlSetColor(-1, 0xFF8800)
					$sItem = '-|-|-|-|-|'
				EndIf
			Next
		Else
			__Inc($Val)
			If $iMode Then
				$Val[$Val[0]] = DllStructGetData($tData, $Count)
				If BitAND($iFlags, 128) Then
					$Val[$Val[0]] = __Hex($Val[$Val[0]], $aItem[1])
				EndIf
				$ID = GUICtrlCreateListViewItem($sItem & $Val[$Val[0]], $LV)
			Else
				$Val[$Val[0]] = ''
				$ID = GUICtrlCreateListViewItem($sItem & '-', $LV)
			EndIf
			If ($Sel[0] = $Count) And (Not $Sel[1]) Then
				$Sel[1] = $ID
			EndIf
			If (Not $Init) And ($Count = 1) Then
				$Init = $ID
			EndIf
			If Not $iSize Then
				GUICtrlSetColor(-1, 0xFF8800)
			EndIf
		EndIf
		If (Not BitAND($iFlags, 2)) And (Not $iSize) Then
			__Inc($Val)
			$Val[$Val[0]] = ''
			GUICtrlCreateListViewItem('-|-|-|<alignment>|?|-', $LV)
			GUICtrlSetColor(-1, 0xFF8800)
		EndIf
	Next
	If (Not BitAND($iFlags, 2)) And ($Prev) And ($iData > $Prev) Then
		__Inc($Val)
		$Val[$Val[0]] = ''
		GUICtrlCreateListViewItem('-|-|-|<alignment>|' & ($iData - $Prev) & '|-', $LV)
		GUICtrlSetColor(-1, 0xFF0000)
	EndIf
	If Not BitAND($iFlags, 1) Then
		__Inc($Val)
		$Val[$Val[0]] = ''
		GUICtrlCreateListViewItem('-|-|' & ($pData + $iData - 0) & '|<endstruct>|' & $iData & '|-', $LV)
		GUICtrlSetColor(-1, 0x9C9C9C)
	EndIf
	If $Sel[1] Then
		GUICtrlSetState($Sel[1], 0x0100)
	Else
		GUICtrlSetState($Init, 0x0100)
	EndIf
	$Dummy = GUICtrlCreateDummy()
	For $i = 0 To UBound($Width) - 1
		GUICtrlSendMsg($LV, 0x101E, $i, $Width[$i])
	Next
	DllStructSetData($tParam, 1, $hLV)
	If Not BitAND($iFlags, 32) Then
		DllStructSetData($tParam, 2, $Dummy)
	Else
		DllStructSetData($tParam, 2, 0)
	EndIf
	$__Dll = DllCallbackRegister('__DlgSubclassProc', 'lresult', 'hwnd;uint;wparam;lparam;uint;ptr')
	$pDll = DllCallbackGetPtr($__Dll)
	If _WinAPI_SetWindowSubclass($__Dlg, $pDll, 1000, DllStructGetPtr($tParam)) Then
		OnAutoItExitRegister('__Quit')
	Else
		DllCallbackFree($__Dll)
		$__Dll = 0
	EndIf
	GUISetState()
	While 1
		Switch GUIGetMsg()
			Case  0
				ContinueLoop
			Case -3
				ExitLoop
			Case $Dummy
				$Index = GUICtrlRead($Dummy)
				If ($Index >= 0) And ($Index < $Val[0]) Then
					ClipPut($Val[$Index + 1])
				EndIf
		EndSwitch
	WEnd
	If $__Dll Then
		OnAutoItExitUnregister('__Quit')
	EndIf
	__Quit()
	If $hParent Then
		GUISetState(@SW_ENABLE, $hParent)
	EndIf
	GUIDelete($__Dlg)
	Opt('GUIDataSeparatorChar', $Opt1)
	Opt('GUIOnEventMode', $Opt2)
	Opt('GUICloseOnESC', $Opt3)
	Return 1
EndFunc   ;==>_WinAPI_DisplayStruct

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DllGetVersion
; Description....: Retrieves a DLL-specific version information.
; Syntax.........: _WinAPI_DllGetVersion ( $sPath )
; Parameters.....: $sPath  - The path to the DLL file from which information is retrieved.
; Return values..: Success - The array containing the following information:
;
;                            [0] - The major version.
;                            [1] - The minor version.
;                            [2] - The build number.
;                            [3] - The platform for which the DLL was built ($DLLVER_PLATFORM_*).
;
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function is not an API. It is exported by name from each DLL that implements it. Currently, most of the Windows Shell
;                  and common controls DLLs implement DllGetVersion. These include, but are not limited to, shell32.dll, comctl32.dll,
;                  shdocvw.dll, and shlwapi.dll.
; Related........:
; Link...........: @@MsdnLink@@ DllGetVersion
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DllGetVersion($sPath)

	Local $tVersion = DllStructCreate('dword[5]')

	DllStructSetData($tVersion, 1, DllStructGetSize($tVersion), 1)

	Local $Ret = DllCall($sPath, 'uint', 'DllGetVersion', 'ptr', DllStructGetPtr($tVersion))

	If @error Then
		Return SetError(@error, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf

	Local $Result[4]

	For $i = 0 To 3
		$Result[$i] = DllStructGetData($tVersion, 1, $i + 2)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_DllGetVersion

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DllInstall
; Description....: Registers OLE controls such as DLL or ActiveX Controls (OCX) files.
; Syntax.........: _WinAPI_DllInstall ( $sPath )
; Parameters.....: $sPath  - The path to the DLL file that will be registered.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DllInstall($sPath)

    Local $Ret = RunWait(@SystemDir & '\regsvr32.exe /s ' & $sPath)

    If (@error) Or ($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
    Return 1
EndFunc   ;==>_WinAPI_DllInstall

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DllUninstall
; Description....: Unregisters OLE controls such as DLL or ActiveX Controls (OCX) files.
; Syntax.........: _WinAPI_DllUninstall ( $sPath )
; Parameters.....: $sPath  - The path to the DLL file that will be unregistered.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DllUninstall($sPath)

    Local $Ret = RunWait(@SystemDir & '\regsvr32.exe /s /u ' & $sPath)

    If (@error) Or ($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
    Return 1
EndFunc   ;==>_WinAPI_DllUninstall

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DPtoLP
; Description....: Converts device coordinates into logical coordinates.
; Syntax.........: _WinAPI_DPtoLP ( $hDC, ByRef $tPOINT [, $iCount = 1] )
; Parameters.....: $hDC    - Handle to the device context.
;                  $tPOINT - $tagPOINT structure or structure of points ("long x1;long y1;...long xN;long yN") containing the
;                            x- and y-coordinates to be transformed.
;                  $iCount - The number of points.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_DPtoLP() function fails if the device coordinates exceed 27 bits, or if the converted logical coordinates
;                  exceed 32 bits. In the case of such an overflow, the results for all the points are undefined.
; Related........:
; Link...........: @@MsdnLink@@ DPtoLP
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DPtoLP($hDC, ByRef $tPOINT, $iCount = 1)

	Local $Ret = DllCall('gdi32.dll', 'int', 'DPtoLP', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tPOINT), 'int', $iCount)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DPtoLP

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DragAcceptFiles
; Description....: Registers whether a window accepts dropped files.
; Syntax.........: _WinAPI_DragAcceptFiles ( $hWnd [, $fAccept] )
; Parameters.....: $hWnd    - Handle to the window that is registering whether it will accept dropped files.
;                  $fAccept - Specifies whether a window accepts dropped files, valid values:
;                  |TRUE    - Accept dropped files. (Default)
;                  |FALSE   - Discontinue accepting dropped files.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DragAcceptFiles
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DragAcceptFiles($hWnd, $fAccept = 1)
	DllCall('shell32.dll', 'none', 'DragAcceptFiles', 'hwnd', $hWnd, 'int', $fAccept)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DragAcceptFiles

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DragFinish
; Description....: Releases memory that the system allocated for use in transferring file names to the application.
; Syntax.........: _WinAPI_DragFinish ( $hDrop )
; Parameters.....: $hDrop  - Handle of the drop structure that describes the dropped file. This parameter is passed to
;                            WM_DROPFILES message with WPARAM parameter.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DragFinish
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DragFinish($hDrop)
	DllCall('shell32.dll', 'none', 'DragFinish', 'ptr', $hDrop)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DragFinish

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DragQueryFileEx
; Description....: Retrieves the names of dropped files that result from a successful drag-and-drop operation.
; Syntax.........: _WinAPI_DragQueryFileEx ( $hDrop [, $iFlag] )
; Parameters.....: $hDrop  - Handle of the drop structure that describes the dropped file. This parameter is passed to
;                            WM_DROPFILES message with WPARAM parameter.
;                  $iFlag  - The flag that specifies whether to return files folders or both, valid values:
;                  |0 - Return both files and folders. (Default)
;                  |1 - Return files only.
;                  |2 - Return folders only.
; Return values..: Success - The array of the names of a dropped files. The zeroth array element contains the number of file names.
;                            If no files that satisfy the condition ($iFlag), the function fails.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DragQueryFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DragQueryFileEx($hDrop, $iFlag = 0)

	Local $Ret, $Count, $Dir, $Result

	$Ret = DllCall('shell32.dll', 'int', 'DragQueryFileW', 'ptr', $hDrop, 'uint', -1, 'ptr', 0, 'uint', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$Count = $Ret[0]
	Dim $Result[$Count + 1]
	For $i = 0 To $Count - 1
		$Ret = DllCall('shell32.dll', 'int', 'DragQueryFileW', 'ptr', $hDrop, 'uint', $i, 'wstr', '', 'uint', 4096)
		If Not $Ret[0] Then
			Return SetError(1, 0, 0)
		EndIf
		If $iFlag Then
			$Dir = _WinAPI_PathIsDirectory($Ret[3])
			If (@error) Or (($iFlag = 1) And ($Dir)) Or (($iFlag = 2) And (Not $Dir)) Then
				ContinueLoop
			EndIf
		EndIf
		$Result[$i + 1] = $Ret[3]
		$Result[0] += 1
	Next
	If Not $Result[0] Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($Result, -1)
	Return $Result
EndFunc   ;==>_WinAPI_DragQueryFileEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DragQueryPoint
; Description....: Retrieves the position of the mouse pointer at the time a file was dropped during a drag-and-drop operation.
; Syntax.........: _WinAPI_DragQueryPoint ( $hDrop )
; Parameters.....: $hDrop  - Handle of the drop structure that describes the dropped file. This parameter is passed to
;                            WM_DROPFILES message with WPARAM parameter.
; Return values..: Success - $tagPOINT structure that contains the coordinates of the mouse pointer at the time the
;                            file was dropped.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DragQueryPoint
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DragQueryPoint($hDrop)

	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('shell32.dll', 'int', 'DragQueryPoint', 'ptr', $hDrop, 'ptr', DllStructGetPtr($tPOINT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tPOINT
EndFunc   ;==>_WinAPI_DragQueryPoint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawAnimatedRects
; Description....: Animates the caption of a window to indicate the opening of an icon or the minimizing or maximizing of a window.
; Syntax.........: _WinAPI_DrawAnimatedRects ( $hWnd, $tRectFrom, $tRectTo )
; Parameters.....: $hWnd      - Handle to the window whose caption should be animated on the screen.
;                  $tRectFrom - $tagRECT structure specifying the location and size of the icon or minimized window.
;                  $tRectTo   - $tagRECT structure specifying the location and size of the restored window.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The window caption will animate from the position specified by $tRectFrom to the position specified by $tRectTo.
;                  The effect is similar to minimizing or maximizing a window.
; Related........:
; Link...........: @@MsdnLink@@ DrawAnimatedRects
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawAnimatedRects($hWnd, $tRectFrom, $tRectTo)

	Local $Ret = DllCall('user32.dll', 'int', 'DrawAnimatedRects', 'hwnd', $hWnd, 'int', 3, 'ptr', DllStructGetPtr($tRectFrom), 'ptr', DllStructGetPtr($tRectTo))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawAnimatedRects

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawBitmap
; Description....: Draws a bitmap into the specified device context.
; Syntax.........: _WinAPI_DrawBitmap ( $hDC, $iX, $iY, $hBitmap [, $iRop] )
; Parameters.....: $hDC     - Handle to the device context into which the bitmap will be drawn.
;                  $iX      - Specifies the logical x-coordinate of the upper-left corner of the bitmap.
;                  $iY      - Specifies the logical y-coordinate of the upper-left corner of the bitmap.
;                  $hBitmap - Handle to the bitmap to be drawn.
;                  $iRop    - The raster-operation code (same as for _WinAPI_BitBlt()).
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function does not support bitmaps with alpha channel, use _WinAPI_AlphaBlend() to work with them.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawBitmap($hDC, $iX, $iY, $hBitmap, $iRop = 0x00CC0020)

	Local $Ret, $tObj, $_hDC, $hSrcDC, $hSrcSv

    $tObj = DllStructCreate($tagBITMAP)
	$Ret = DllCall('gdi32.dll', 'int', 'GetObject', 'int', $hBitmap, 'int', DllStructGetSize($tObj), 'ptr', DllStructGetPtr($tObj))
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$Ret = DllCall('user32.dll', 'hwnd', 'GetDC', 'hwnd', 0)
	$_hDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'CreateCompatibleDC', 'hwnd', $_hDC)
	$hSrcDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'hwnd', 'SelectObject', 'hwnd', $hSrcDC, 'ptr', $hBitmap)
	$hSrcSv = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'int', 'BitBlt', 'hwnd', $hDC, 'int', $iX, 'int', $iY, 'int', DllStructGetData($tObj, 'bmWidth'), 'int', DllStructGetData($tObj, 'bmHeight'), 'hwnd', $hSrcDC, 'int', 0, 'int', 0, 'int', $iRop)
	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	DllCall('user32.dll', 'int', 'ReleaseDC', 'hwnd', 0, 'hwnd', $_hDC)
	DllCall('gdi32.dll', 'ptr', 'SelectObject', 'hwnd', $hSrcDC, 'ptr', $hSrcSv)
	DllCall('gdi32.dll', 'int', 'DeleteDC', 'hwnd', $hSrcDC)
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawFocusRect
; Description....: Draws a rectangle in the style used to indicate that the rectangle has the focus.
; Syntax.........: _WinAPI_DrawFocusRect ( $hDC, $tRECT )
; Parameters.....: $hDC    - A handle to the device context.
;                  $tRECT  - $tagRECT structure that specifies the logical coordinates of the rectangle that is to be drawn.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_DrawFocusRect() is an XOR function, so calling it a second time with the same rectangle
;                  removes the rectangle from the screen.
; Related........:
; Link...........: @@MsdnLink@@ DrawFocusRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawFocusRect($hDC, $tRECT)

	Local $Ret = DllCall('user32.dll', 'int', 'DrawFocusRect', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawFocusRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawShadowText
; Description....: Draws formatted text in the specified rectangle with a drop shadow.
; Syntax.........: _WinAPI_DrawShadowText ( $hDC, $sText, $rgbText, $rgbShadow [, $iXOffset [, $iYOffset [, $tRECT [, $iFlags]]]] )
; Parameters.....: $hDC       - Handle to a device context.
;                  $sText     - The string that contains the text to be drawn.
;                  $rgbText   - The color of the text, in RGB.
;                  $rgbShadow - The color of the shadow, in RGB.
;                  $iXOffset  - The x-coordinate of where the text should begin.
;                  $iYOffset  - The y-coordinate of where the text should begin.
;                  $tRECT     - $tagRECT structure that contains, in logical coordinates, the rectangle in which the text is to
;                               be drawn. If this parameter is 0, the size will be equal size of the device context ($hDC).
;                  $iFlags    - The flags that specifies how the text is to be drawn. This parameter can be a combination of
;                               the formatting text constants ($DT_*).
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Rover
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DrawShadowText
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawShadowText($hDC, $sText, $rgbText, $rgbShadow, $iXOffset = 0, $iYOffset = 0, $tRECT = 0, $iFlags = 0)

	Local $Ret

	If Not IsDllStruct($tRECT) Then
		$tRECT = DllStructCreate($tagRECT)
		$Ret = DllCall('user32.dll', 'int', 'GetClientRect', 'hwnd', _WinAPI_WindowFromDC($hDC), 'ptr', DllStructGetPtr($tRECT))
		If (@error) Or (Not $Ret[0]) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	$Ret = DllCall('comctl32.dll', 'int', 'DrawShadowText', 'hwnd', $hDC, 'wstr', $sText, 'uint', -1, 'ptr', DllStructGetPtr($tRECT), 'dword', $iFlags, 'int', __RGB($rgbText), 'int', __RGB($rgbShadow), 'int', $iXOffset, 'int', $iYOffset)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawShadowText

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawThemeBackground
; Description....: Draws the border and fill defined by the visual style for the specified control part.
; Syntax.........: _WinAPI_DrawThemeBackground ( $hTheme, $iPartId, $iStateId, $hDC, $tRECT [, $tCLIP] )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part to draw.
;                  $iStateId - The state of the part to draw.
;                  $hDC      - Handle to the device context for drawing the theme-defined background image.
;                  $tRECT    - $tagRECT structure that contains the rectangle in which the background image is drawn.
;                  $tCLIP    - $tagRECT structure that contains a clipping rectangle.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DrawThemeBackground
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawThemeBackground($hTheme, $iPartId, $iStateId, $hDC, $tRECT, $tCLIP = 0)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'DrawThemeBackground', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tCLIP))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawThemeBackground

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawThemeEdge
; Description....: Draws one or more edges defined by the visual style of a rectangle.
; Syntax.........: _WinAPI_DrawThemeEdge ( $hTheme, $iPartId, $iStateId, $hDC, $tRECT, $iEdge, $iFlags [, $tAREA] )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the rectangle.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context.
;                  $tRECT    - $tagRECT structure that contains the rectangle.
;                  $iEdge    - The type of inner and outer edges to draw. This parameter must be a combination of one inner-border
;                              flag and one outer-border flag ($BDR_*), or one of the combination flags ($EDGE_*).
;                  $iFlags   - The type of border to draw. It can be a combination of the BF_* constants.
;                  $tAREA    - $tagRECT structure that contains the rectangle that receives the interior rectangle, if $BF_ADJUST is used.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DrawThemeEdge
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawThemeEdge($hTheme, $iPartId, $iStateId, $hDC, $tRECT, $iEdge, $iFlags, $tAREA = 0)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'DrawThemeEdge', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tRECT), 'uint', $iEdge, 'uint', $iFlags, 'ptr', DllStructGetPtr($tAREA))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawThemeEdge

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawThemeIcon
; Description....: Draws an image from an image list with the icon effect defined by the visual style.
; Syntax.........: _WinAPI_DrawThemeIcon ( $hTheme, $iPartId, $iStateId, $hDC, $tRECT, $hIL, $iIndex )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part in which the image is drawn.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context.
;                  $tRECT    - $tagRECT structure that contains the rectangle in which the image is drawn.
;                  $hIL      - Handle to an image list that contains the image to draw.
;                  $iIndex   - The index of the image to draw.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DrawThemeIcon
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawThemeIcon($hTheme, $iPartId, $iStateId, $hDC, $tRECT, $hIL, $iIndex)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'DrawThemeIcon', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tRECT), 'ptr', $hIL, 'int', $iIndex)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawThemeIcon

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawThemeParentBackground
; Description....: Draws the part of a parent control that is covered by a partially-transparent or alpha-blended child control.
; Syntax.........: _WinAPI_DrawThemeParentBackground ( $hWnd, $hDC [, $tRECT] )
; Parameters.....: $hWnd   - Handle of the child control.
;                  $hDC    - Handle to the child control's DC.
;                  $tRECT  - $tagRECT structure that defines the area, in the child window's coordinates, to be drawn.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DrawThemeParentBackground
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawThemeParentBackground($hWnd, $hDC, $tRECT = 0)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'DrawThemeParentBackground', 'hwnd', $hWnd, 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawThemeParentBackground

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawThemeText
; Description....: Draws text using the color and font defined by the visual style.
; Syntax.........: _WinAPI_DrawThemeText ( $hTheme, $iPartId, $iStateId, $hDC, $sText, $tRECT, $iFlags )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that has the desired text appearance. If this value is 0, the text is drawn in the
;                              default font, or a font selected into the device context.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context to use for drawing.
;                  $sText    - The string that contains the text to draw.
;                  $tRECT    - $tagRECT structure that contains the rectangle in which the text is to be drawn.
;                  $iFlags   - The string's formatting flags ($DT_*).
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ DrawThemeText
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawThemeText($hTheme, $iPartId, $iStateId, $hDC, $sText, $tRECT, $iFlags)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'DrawThemeText', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'wstr', $sText, 'int', -1, 'dword', $iFlags, 'dword', 0, 'ptr', DllStructGetPtr($tRECT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawThemeText

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DrawThemeTextEx
; Description....: Draws text using the color and font defined by the visual style.
; Syntax.........: _WinAPI_DrawThemeTextEx ( $hTheme, $iPartId, $iStateId, $hDC, $sText, $tRECT, $iFlags, $tDTTOPTS )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that has the desired text appearance. If this value is 0, the text is drawn in the
;                              default font, or a font selected into the device context.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context to use for drawing.
;                  $sText    - The string that contains the text to draw.
;                  $tRECT    - $tagRECT structure that contains the rectangle in which the text is to be drawn.
;                  $iFlags   - The string's formatting flags ($DT_*).
;                  $tDTTOPTS - $tagDTTOPTS structure that defines additional formatting options.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DrawThemeTextEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DrawThemeTextEx($hTheme, $iPartId, $iStateId, $hDC, $sText, $tRECT, $iFlags, $tDTTOPTS)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'DrawThemeTextEx', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'wstr', $sText, 'int', -1, 'dword', $iFlags, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tDTTOPTS))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DrawThemeTextEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DuplicateEncryptionInfoFile
; Description....: Copies the EFS metadata from one file or directory to another.
; Syntax.........: _WinAPI_DuplicateEncryptionInfoFile ( $sSrcFile, $sDestFile [, $iCreation [, $iAttributes [, $tSecurity]]] )
; Parameters.....: $sSrcFile    - The name of the file or directory from which the EFS metadata is to be copied. This source
;                                 file or directory must be encrypted.
;                  $sDestFile   - The name of the file or directory to which the EFS metadata is to be copied. This destination file
;                                 or directory does not have to be encrypted before the call to this function. If the source is
;                                 a file, this parameter must also specify a file, and likewise for directories.
;                  $iCreation   - Specifies how the destination file or directory is to be opened. The following are the valid
;                                 values of this parameter.
;
;                                 $CREATE_NEW
;                                 $CREATE_ALWAYS
;
;                  $iAttributes - The file attributes of the destination file or directory. The $FILE_READ_ONLY attribute is currently
;                                 not processed by this function.
;                  $tSecurity   - $tagSECURITY_ATTRIBUTES structure that specifies the security attributes of the destination file
;                                 or directory, if it does not already exist. If this parameter is 0, the file or directory gets
;                                 a default security descriptor. The access-control lists (ACL) in the default security descriptor
;                                 for a file or directory are inherited from its parent directory.
; Return values..: Success      - 1.
;                  Failure      - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The caller should have the EFS key for the source file or directory, and at least the $READ_ATTRIBUTE ACL for the
;                  source file or directory.
;
;                  The specified source and destination file or directories should reside on the same computer; otherwise,
;                  the function fails.
; Related........:
; Link...........: @@MsdnLink@@ DuplicateEncryptionInfoFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DuplicateEncryptionInfoFile($sSrcFile, $sDestFile, $iCreation = 2, $iAttributes = 0, $tSecurity = 0)

	Local $Ret = DllCall('advapi32.dll', 'dword', 'DuplicateEncryptionInfoFile', 'wstr', $sSrcFile, 'wstr', $sDestFile, 'dword', $iCreation, 'dword', $iAttributes, 'ptr', DllStructGetPtr($tSecurity))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DuplicateEncryptionInfoFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DuplicateHandle
; Description....: Duplicates an object handle.
; Syntax.........: _WinAPI_DuplicateHandle ( $hProcess, $hSource, $hTarget [, $iAccess [, $iOptions [, $fInherit]]] )
; Parameters.....: $hProcess - Handle to the process with the handle to be duplicated. The handle must have the $PROCESS_DUP_HANDLE access right.
;                  $hSource  - Handle to be duplicated. This is an open object handle that is valid in the context of the source process.
;                  $hTarget  - Handle to the process that is to receive the duplicated handle. The handle must have the
;                              $PROCESS_DUP_HANDLE access right.
;                  $iAccess  - The access requested for the new handle. This parameter is ignored if the $iOptions parameter
;                              specifies the $DUPLICATE_SAME_ACCESS flag. Otherwise, the flags that can be specified depend on the
;                              type of object whose handle is to be duplicated.
;                  $iOptions - Optional actions. This parameter can be zero, or any combination of the following values.
;
;                              $DUPLICATE_CLOSE_SOURCE
;                              $DUPLICATE_SAME_ACCESS
;
;                  $fInherit - Specifies whether the handle is inheritable, valid values:
;                  |TRUE     - The duplicate handle can be inherited by new processes created by the target process.
;                  |FALSE    - The new handle cannot be inherited. (Default)
; Return values..: Success   - The duplicate handle. This handle is valid in the context of the target process.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The duplicate handle refers to the same object as the original handle. Therefore, any changes to the object are
;                  reflected through both handles. For example, if you duplicate a file handle, the current file position is always
;                  the same for both handles. For file handles to have different file positions, use the _WinAPI_CreateFileEx()
;                  function to create file handles that share access to the same file.
; Related........:
; Link...........: @@MsdnLink@@ DuplicateHandle
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DuplicateHandle($hProcess, $hSource, $hTarget, $iAccess = 0, $iOptions = 2, $fInherit = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'DuplicateHandle', 'ptr', $hProcess, 'ptr', $hSource, 'ptr', $hTarget, 'ptr*', 0, 'dword', $iAccess, 'int', $fInherit, 'dword', $iOptions)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[4]
EndFunc   ;==>_WinAPI_DuplicateHandle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DuplicateTokenEx
; Description....: Creates a new primary or impersonation access token that duplicates an existing token.
; Syntax.........: _WinAPI_DuplicateTokenEx ( $hToken, $iAccess, $iLevel [, $iType [, $tSecurity]] )
; Parameters.....: $hToken    - A handle to an access token opened with $TOKEN_DUPLICATE access.
;                  $iAccess   - The requested access rights for the new token. To request the same access rights as the existing
;                               token, specify zero. To request all access rights that are valid for the caller, specify the
;                               $TOKEN_ALL_ACCESS access.
;                  $iLevel    - The security impersonation levels.
;
;                               $SecurityAnonymous
;                               $SecurityIdentification
;                               $SecurityImpersonation
;                               $SecurityDelegation
;
;                  $iType     - The token type.
;
;                               $TokenPrimary
;                               $TokenImpersonation
;
;                  $tSecurity - $tagSECURITY_ATTRIBUTES structure that specifies a security descriptor for the new token and
;                               determines whether child processes can inherit the token. If this parameter is 0, the token gets
;                               a default security descriptor and the handle cannot be inherited. If the security descriptor
;                               contains a system access control list, the token gets $ACCESS_SYSTEM_SECURITY access right,
;                               even if it was not requested.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you have finished using the new token, call the _WinAPI_CloseHandle() function to close the token handle.
; Related........:
; Link...........: @@MsdnLink@@ DuplicateTokenEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DuplicateTokenEx($hToken, $iAccess, $iLevel, $iType = 1, $tSecurity = 0)

	Local $Ret = DllCall('advapi32.dll', 'int', 'DuplicateTokenEx', 'ptr', $hToken, 'dword', $iAccess, 'ptr', DllStructGetPtr($tSecurity), 'uint', $iLevel, 'uint', $iType, 'ptr*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_DuplicateTokenEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmEnableBlurBehindWindow
; Description....: Enables the blur effect on a specified window.
; Syntax.........: _WinAPI_DwmEnableBlurBehindWindow ( $hWnd [, $fEnable [, $fTransition [, $hRgn]]] )
; Parameters.....: $hWnd        - Handle to the window on which the blur behind data is applied.
;                  $fEnable     - Specifies whether register or unregister the window handle to DWM blur behind, valid values:
;                  |TRUE        - Register.
;                  |FALSE       - Unregister.
;                  $fTransition - Specifies whether colorize transition to match the maximized windows, valid values:
;                  |TRUE        - The window's should be colorized.
;                  |FALSE       - Otherwise.
;                  $hRgn        - The region within the client area to apply the blur behind. A zeroth value will apply the blur
;                                 behind the entire client area.
; Return values..: Success      - 1.
;                  Failure      - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The alpha values in the window are honored and the rendering atop the blur will use these alpha values.
;                  It is the application's responsibility for ensuring that the alpha values of all pixels in the window are correct.
;                  Some Windows Graphics Device Interface (GDI) operations do not preserve alpha values, so care must be taken when
;                  presenting child windows because the alpha values they contribute are unpredictable.
;
;                  This function must be called whenever Desktop Window Manager (DWM) composition is toggled. Handle the
;                  WM_DWMCOMPOSITIONCHANGED message for composition change notification.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmEnableBlurBehindWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmEnableBlurBehindWindow($hWnd, $fEnable = 1, $fTransition = 0, $hRgn = 0)

	Local $tBLURBEHIND = DllStructCreate('dword;int;ptr;int')
	Local $Flags = 0

	If $hRgn Then
		$Flags += 2
		DllStructSetData($tBLURBEHIND, 3, $hRgn)
	EndIf

	DllStructSetData($tBLURBEHIND, 1, BitOR($Flags, 0x05))
	DllStructSetData($tBLURBEHIND, 2, $fEnable)
	DllStructSetData($tBLURBEHIND, 4, $fTransition)

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmEnableBlurBehindWindow', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tBLURBEHIND))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmEnableBlurBehindWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmEnableComposition
; Description....: Enables or disables Desktop Window Manager (DWM) composition.
; Syntax.........: _WinAPI_DwmEnableComposition ( $fEnable )
; Parameters.....: $fEnable  - Specifies whether enable or disable DWM composition, valid values:
;                  |TRUE     - Enable.
;                  |FALSE    - Disable.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: Disabling DWM composition disables it for the entire desktop. DWM composition will be automatically enabled
;                  when all processes that have disabled composition have called _WinAPI_DwmEnableComposition() to enable it or have
;                  been terminated. The WM_DWMCOMPOSITIONCHANGED notification is sent when DWM composition has enabled or disabled.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmEnableComposition
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmEnableComposition($fEnable)

	If $fEnable Then
		$fEnable = 1
	EndIf

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmEnableComposition', 'uint', $fEnable)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmEnableComposition

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmGetColorizationColor
; Description....: Retrieves the current color used for Desktop Window Manager (DWM) glass composition.
; Syntax.........: _WinAPI_DwmGetColorizationColor ( )
; Parameters.....: None
; Return values..: Success - The current color (0xAARRGGBB) used for glass composition, @extended flag indicates whether the
;                            color is an opaque blend:
;                            1 - The color is an opaque blend.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmGetColorizationColor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmGetColorizationColor()

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmGetColorizationColor', 'dword*', 0, 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return SetError(0, $Ret[2], $Ret[1])
EndFunc   ;==>_WinAPI_DwmGetColorizationColor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmGetWindowAttribute
; Description....: Retrieves the current value of a specified attribute applied to the window.
; Syntax.........: _WinAPI_DwmGetWindowAttribute ( $hWnd, $iAttribute )
; Parameters.....: $hWnd       - Handle to the window for which the attribute data is retrieved.
;                  $iAttribute - The attribute to retrieve. This parameter can be one of the following values.
;
;                                $DWMWA_NCRENDERING_ENABLED
;                                $DWMWA_CAPTION_BUTTON_BOUNDS
;                                $DWMWA_EXTENDED_FRAME_BOUNDS
;
; Return values..: Success     - The value that contains the current value of the attribute. The type of the returned value depends
;                                on the value of the $iAttribute parameter.
;                  Failure     - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmGetWindowAttribute
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmGetWindowAttribute($hWnd, $iAttribute)

	Local $Struct

	Switch $iAttribute
		Case 5, 9
			$Struct = $tagRECT
		Case 1
			$Struct = 'uint'
		Case Else
			Return SetError(1, 0, 0)
	EndSwitch

	Local $tData = DllStructCreate($Struct)
	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmGetWindowAttribute', 'hwnd', $hWnd, 'dword', $iAttribute, 'ptr', DllStructGetPtr($tData), 'dword', DllStructGetSize($tData))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Switch $iAttribute
		Case 1
			Return DllStructGetData($tData, 1)
		Case Else
			Return $tData
	EndSwitch
EndFunc   ;==>_WinAPI_DwmGetWindowAttribute

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmExtendFrameIntoClientArea
; Description....: Extends the window frame behind the client area.
; Syntax.........: _WinAPI_DwmExtendFrameIntoClientArea ( $hWnd [, $tMARGINS] )
; Parameters.....: $hWnd     - Handle to the window for which the frame is extended into the client area.
;                  $tMARGINS - $tagMARGINS structure that describes the margins to use when extending the frame into the client area.
;                              Negative margins are used to create the "sheet of glass" effect where the client area is rendered as
;                              a solid surface with no window border.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function must be called whenever Desktop Window Manager (DWM) composition is toggled. Handle the
;                  WM_DWMCOMPOSITIONCHANGED message for composition change notification.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmExtendFrameIntoClientArea
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmExtendFrameIntoClientArea($hWnd, $tMARGINS = 0)

	If Not IsDllStruct($tMARGINS) Then
		$tMARGINS = _WinAPI_CreateMargins(-1, -1, -1, -1)
	EndIf

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmExtendFrameIntoClientArea', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tMARGINS))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmExtendFrameIntoClientArea

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmInvalidateIconicBitmaps
; Description....: Indicates that all previously provided iconic bitmaps from a window, both thumbnails and peek representations, should be refreshed.
; Syntax.........: _WinAPI_DwmInvalidateIconicBitmaps ( $hWnd )
; Parameters.....: $hWnd    - Handle to the window or tab whose bitmaps are being invalidated through this call.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: Calling this function causes the Desktop Window Manager (DWM) to invalidate its current bitmaps for the window
;                  and request new bitmaps from the window when they are next needed. _WinAPI_DwmInvalidateIconicBitmaps() should
;                  not be called frequently. Doing so can lead to poor performance as new bitmaps are created and retrieved.
;
;                  This function requires Windows 7 or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmInvalidateIconicBitmaps
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmInvalidateIconicBitmaps($hWnd)

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmInvalidateIconicBitmaps', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmInvalidateIconicBitmaps

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmIsCompositionEnabled
; Description....: Determines whether Desktop Window Manager (DWM) composition is enabled.
; Syntax.........: _WinAPI_DwmIsCompositionEnabled ( )
; Parameters.....: None
; Return values..: Success - 1 - DWM composition is enabled.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmIsCompositionEnabled
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmIsCompositionEnabled()

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmIsCompositionEnabled', 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[1]
EndFunc   ;==>_WinAPI_DwmIsCompositionEnabled

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmQueryThumbnailSourceSize
; Description....: Returns the source size of the Desktop Window Manager (DWM) thumbnail.
; Syntax.........: _WinAPI_DwmUnregisterThumbnail ( $hThumbnail )
; Parameters.....: $hThumbnail - Handle of the thumbnail to retrieve the source window size from.
; Return values..: Success     - $tagSIZE structure that contains the size of the source thumbnail.
;                  Failure     - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmQueryThumbnailSourceSize
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmQueryThumbnailSourceSize($hThumbnail)

	Local $tSIZE = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmQueryThumbnailSourceSize', 'ptr', $hThumbnail, 'ptr', DllStructGetPtr($tSIZE))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tSIZE
EndFunc   ;==>_WinAPI_DwmQueryThumbnailSourceSize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmRegisterThumbnail
; Description....: Creates a Desktop Window Manager (DWM) thumbnail relationship between the destination and source windows.
; Syntax.........: _WinAPI_DwmRegisterThumbnail ( $hDestination, $hSource )
; Parameters.....: $hDestination - Handle to the window that will use the DWM thumbnail.
;                  $hSource      - Handle to the window to use as the thumbnail source.
; Return values..: Success       - Handle that represents the registration of the DWM thumbnail.
;                  Failure       - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The window designated by $hDestination must either be the desktop window itself or be owned by the process that
;                  is calling _WinAPI_DwmRegisterThumbnail().
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmRegisterThumbnail
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmRegisterThumbnail($hDestination, $hSource)

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmRegisterThumbnail', 'hwnd', $hDestination, 'hwnd', $hSource, 'ptr*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_DwmRegisterThumbnail

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmSetIconicLivePreviewBitmap
; Description....: Sets a static, iconic bitmap to display a live preview (also known as a Peek preview) of a window or tab.
; Syntax.........: _WinAPI_DwmSetIconicLivePreviewBitmap ( $hWnd, $hBitmap [, $fFrame [, $tClient]] )
; Parameters.....: $hWnd    - Handle to the window or tab.
;                  $hBitmap - Handle to the device-independent bitmap (DIB) to represent the specified window.
;                  $fFrame  - Specifies whether display a frame around the provided bitmap, valid values:
;                  |TRUE    - Display frame.
;                  |FALSE   - Do not display frame. (Default)
;                  $tClient - $tagPOINT structure that contains The offset of a tab window's client region from the host window's
;                             frame. This offset enables the tab window's contents to be drawn correctly in a live preview when
;                             it is drawn without its frame.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: A window typically calls the _WinAPI_DwmSetIconicLivePreviewBitmap() function in response to a
;                  WM_DWMSENDICONICLIVEPREVIEWBITMAP message. The returned bitmap must not be larger than the client area of the
;                  window or frame and must have 32-bit color depth.
;
;                  The DWM uses a copy of the bitmap, but the caller retains ownership of the original bitmap and is responsible
;                  for freeing the resources that it uses when it is no longer needed. The DWM does not keep its copy of the
;                  bitmap when the DWM stops displaying the live preview representation.
;
;                  This function requires Windows 7 or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmSetIconicLivePreviewBitmap
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmSetIconicLivePreviewBitmap($hWnd, $hBitmap, $fFrame = 0, $tClient = 0)

	Local $Flags

	If $fFrame Then
		$Flags = 0x00000001
	Else
		$Flags = 0
	EndIf

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmSetIconicLivePreviewBitmap', 'hwnd', $hWnd, 'ptr', $hBitmap, 'ptr', DllStructGetPtr($tClient), 'dword', $Flags)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmSetIconicLivePreviewBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmSetIconicThumbnail
; Description....: Sets a static, iconic bitmap on a window or tab to use as a thumbnail representation.
; Syntax.........: _WinAPI_DwmSetIconicThumbnail ( $hWnd, $hBitmap [, $fFrame] )
; Parameters.....: $hWnd    - Handle to the window or tab.
;                  $hBitmap - Handle to the device-independent bitmap (DIB) to represent the specified window.
;                  $fFrame  - Specifies whether display a frame around the provided thumbnail, valid values:
;                  |TRUE    - Display frame.
;                  |FALSE   - Do not display frame. (Default)
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: A window typically calls the _WinAPI_DwmSetIconicThumbnail() function after it receives a WM_DWMSENDICONICTHUMBNAIL
;                  message. The thumbnail should not exceed the maximum x-coordinate and y-cordinate that are specified in the
;                  WM_DWMSENDICONICTHUMBNAIL. The thumbnail must also have a 32-bit color depth.
;
;                  The DWM uses a copy of the bitmap, but the application can release this copy at any time because of memory
;                  constraints. If this occurs, the window is not notified but it might receive a subsequent WM_DWMSENDICONICTHUMBNAIL
;                  request when its thumbnail is needed again. The caller retains ownership of the original bitmap and is responsible
;                  for freeing the resources that it uses when it is no longer needed.
;
;                  This function requires Windows 7 or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmSetIconicThumbnail
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmSetIconicThumbnail($hWnd, $hBitmap, $fFrame = 0)

	Local $Flags

	If $fFrame Then
		$Flags = 0x00000001
	Else
		$Flags = 0
	EndIf

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmSetIconicThumbnail', 'hwnd', $hWnd, 'ptr', $hBitmap, 'dword', $Flags)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmSetIconicThumbnail

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmSetWindowAttribute
; Description....: Sets the value of the specified attributes for non-client rendering to apply to the window.
; Syntax.........: _WinAPI_DwmSetWindowAttribute ( $hWnd, $iAttribute, $iData )
; Parameters.....: $hWnd       - The window handle to apply the given attribute.
;                  $iAttribute - The attribute to apply to the window. This parameter can be one of the following values.
;
;                                $DWMWA_NCRENDERING_POLICY
;                                $DWMWA_TRANSITIONS_FORCEDISABLED
;                                $DWMWA_ALLOW_NCPAINT
;                                $DWMWA_NONCLIENT_RTL_LAYOUT
;                                $DWMWA_FORCE_ICONIC_REPRESENTATION
;                                $DWMWA_FLIP3D_POLICY
;
;                                Windows 7 or later
;
;                                $DWMWA_HAS_ICONIC_BITMAP
;                                $DWMWA_DISALLOW_PEEK
;                                $DWMWA_EXCLUDED_FROM_PEEK
;
;                  $iData      - The value of the attribute.
; Return values..: Success     - 1.
;                  Failure     - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmSetWindowAttribute
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmSetWindowAttribute($hWnd, $iAttribute, $iData)
	Switch $iAttribute
		Case 2, 3, 4, 6, 7, 8, 10, 11, 12

		Case Else
			Return SetError(1, 0, 0)
	EndSwitch

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmSetWindowAttribute', 'hwnd', $hWnd, 'dword', $iAttribute, 'uint*', $iData, 'dword', 4)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmSetWindowAttribute

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmUnregisterThumbnail
; Description....: Removes a Desktop Window Manager (DWM) thumbnail relationship.
; Syntax.........: _WinAPI_DwmUnregisterThumbnail ( $hThumbnail )
; Parameters.....: $hThumbnail - Handle to the thumbnail relationship to be removed.
; Return values..: Success     - 1.
;                  Failure     - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmUnregisterThumbnail
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmUnregisterThumbnail($hThumbnail)

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmUnregisterThumbnail', 'ptr', $hThumbnail)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmUnregisterThumbnail

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DwmUpdateThumbnailProperties
; Description....: Specifies Desktop Window Manager (DWM) thumbnail properties.
; Syntax.........: _WinAPI_DwmUpdateThumbnailProperties ( $hThumbnail [, $fVisible [, $fClientAreaOnly [, $iOpacity [, $tRectDest [, $tRectSrc]]]]] )
; Parameters.....: $hThumbnail      - Handle of the thumbnail to retrieve the source window size from.
;                  $fVisible        - Specifies whether make the thumbnail visible or invisible, valid values:
;                  |TRUE            - Visible.
;                  |FALSE           - Invisible.
;                  $fClientAreaOnly - Specifies whether use only the thumbnail source's client area or entire window, valid values:
;                  |TRUE            - Use only source's client area.
;                  |FALSE           - Use entire window.
;                  $iOpacity        - The opacity with which to render the thumbnail. 0 is fully transparent while 255 is fully opaque.
;                  $tRectDest       - $tagRECT structure containing the rectangle in the destination window the thumbnail will be
;                                     rendered. By default, the size of this rectangle equal to the source size of the DWM thumbnail
;                                     which returns the _WinAPI_DwmQueryThumbnailSourceSize() function.
;                  $tRectSrc        - $tagRECT structure containing the rectangle that specifies the region of the source window
;                                     to use as the thumbnail. By default, the entire window is used as the thumbnail.
; Return values..: Success          - 1.
;                  Failure          - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: Thumbnail relationships created by _WinAPI_DwmRegisterThumbnail() will not be rendered to the destination window
;                  until this function is called. Subsequent calls will update the thumbnail according to the properties.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ DwmUpdateThumbnailProperties
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DwmUpdateThumbnailProperties($hThumbnail, $fVisible = 1, $fClientAreaOnly = 0, $iOpacity = 255, $tRectDest = 0, $tRectSrc = 0)

	Local $tTHUMBNAIL = DllStructCreate('dword;int[4];int[4];byte;int;int')
	Local $tSIZE, $Flags = 0

	If Not IsDllStruct($tRectDest) Then
		$tSIZE = _WinAPI_DwmQueryThumbnailSourceSize($hThumbnail)
		If @error Then
			Return SetError(1, 0, 0)
		EndIf
		$tRectDest = _WinAPI_CreateRectEx(0, 0, DllStructGetData($tSIZE, 1), DllStructGetData($tSIZE, 2))
	EndIf
	For $i = 1 To 4
		DllStructSetData($tTHUMBNAIL, 2, DllStructGetData($tRectDest, $i), $i)
	Next
	If IsDllStruct($tRectSrc) Then
		$Flags += 2
		For $i = 1 To 4
			DllStructSetData($tTHUMBNAIL, 3, DllStructGetData($tRectSrc, $i), $i)
		Next
	EndIf

	DllStructSetData($tTHUMBNAIL, 1, BitOR($Flags, 0x1D))
	DllStructSetData($tTHUMBNAIL, 4, $iOpacity)
	DllStructSetData($tTHUMBNAIL, 5, $fVisible)
	DllStructSetData($tTHUMBNAIL, 6, $fClientAreaOnly)

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmUpdateThumbnailProperties', 'ptr', $hThumbnail, 'ptr', DllStructGetPtr($tTHUMBNAIL))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_DwmUpdateThumbnailProperties

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DWordToFloat
; Description....: Converts a value of type DWORD to a value of type FLOAT.
; Syntax.........: _WinAPI_DWordToFloat ( $iValue )
; Parameters.....: $iValue - The value to be converted.
; Return values..: The converted (FLOAT) value.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DWordToFloat($iValue)

	Local $tDWord = DllStructCreate('dword')
	Local $tFloat = DllStructCreate('float', DllStructGetPtr($tDWord))

	DllStructSetData($tDWord, 1, $iValue)

	Return DllStructGetData($tFloat, 1)
EndFunc   ;==>_WinAPI_DWordToFloat

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_DWordToInt
; Description....: Converts a value of type DWORD to a value of type INT.
; Syntax.........: _WinAPI_DWordToInt ( $iValue )
; Parameters.....: $iValue - The value to be converted.
; Return values..: The converted (INT) value.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_DWordToInt($iValue)

	Local $tData = DllStructCreate('int')

	DllStructSetData($tData, 1, $iValue)

	Return DllStructGetData($tData, 1)
EndFunc   ;==>_WinAPI_DWordToInt

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EjectMedia
; Description....: Ejects media from a device.
; Syntax.........: _WinAPI_EjectMedia ( $sDrive )
; Parameters.....: $sDrive - The drive letter of the CD tray to eject, in the format D:, E:, etc.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IOCTL_STORAGE_EJECT_MEDIA
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EjectMedia($sDrive)

	Local $hFile = _WinAPI_CreateFileEx('\\.\' & $sDrive, 3, 0x80000000, 0x03)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x002D4808, 'ptr', 0, 'dword', 0, 'ptr', 0, 'dword', 0, 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EjectMedia

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_Ellipse
; Description....: Draws an ellipse.
; Syntax.........: _WinAPI_Ellipse ( $hDC, $tRECT )
; Parameters.....: $hDC     - Handle to the device context.
;                  $tRECT   - $tagRECT structure that contains the logical coordinates of the bounding rectangle.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The ellipse is outlined by using the current pen and is filled by using the current brush.
; Related........:
; Link...........: @@MsdnLink@@ Ellipse
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_Ellipse($hDC, $tRECT)

	Local $Ret = DllCall('gdi32.dll', 'int', 'Ellipse', 'hwnd', $hDC, 'int', DllStructGetData($tRECT, 1), 'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_Ellipse

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EmptyWorkingSet
; Description....: Removes as many pages as possible from the working set of the specified process.
; Syntax.........: _WinAPI_EmptyWorkingSet ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EmptyWorkingSet
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EmptyWorkingSet($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000500, 0x00001100), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EmptyWorkingSet', 'ptr', $hProcess[0])

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EmptyWorkingSet

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EncryptFile
; Description....: Encrypts a file or directory.
; Syntax.........: _WinAPI_EncryptFile ( $sFile )
; Parameters.....: $sFile  - The name of the file or directory to be encrypted. If $sFile specifies a read-only file, the function
;                            fails and the last error code is ERROR_FILE_READ_ONLY (6009). If $sFile specifies a directory that
;                            contains a read-only file, the functions succeeds but the directory is not encrypted.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_EncryptFile() function requires exclusive access to the file being encrypted, and will fail
;                  if another process is using the file.
;
;                  If the file is already encrypted, the function simply returns a nonzero value, which indicates success.
;                  If the file is compressed, the function will decompress the file before encrypting it.
;
;                  To decrypt an encrypted file, use the _WinAPI_DecryptFile() function.
; Related........:
; Link...........: @@MsdnLink@@ EncryptFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EncryptFile($sFile)

	Local $Ret = DllCall('advapi32.dll', 'int', 'EncryptFileW', 'wstr', $sFile)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EncryptFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EncryptionDisable
; Description....: Disables or enables encryption of the specified directory and the files in it.
; Syntax.........: _WinAPI_EncryptionDisable ( $sDir, $fDisable )
; Parameters.....: $sDir     - The name of the directory for which to enable or disable encryption. If this parameter specifies
;                              a file, the attempt will fail.
;                  $fDisable - Specifies whether to disable or enable encryption, valid values:
;                  |TRUE     - Disable.
;                  |FALSE    - Enable.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If encryption is disabled, the function will write the following to the Desktop.ini file in the directory
;                  (creating it if necessary):
;
;                  [Encryption]
;                  Disable=1
;
;                  The user can also manually add or edit the above lines in the Desktop.ini file and produce the same effect.
;                  Thereafter, _WinAPI_EncryptFile() function will fail on the directory and the files in it, and the last error
;                  code will be ERROR_DIR_EFS_DISALLOWED (6010). This function does not affect encryption of subdirectories
;                  within the given directory.
;
;                  If encryption is enabled, the function will write the following to the Desktop.ini file:
;
;                  [Encryption]
;                  Disable=0
;
; Related........:
; Link...........: @@MsdnLink@@ EncryptionDisable
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EncryptionDisable($sDir, $fDisable)

	Local $Ret = DllCall('advapi32.dll', 'int', 'EncryptionDisable', 'wstr', $sDir, 'int', $fDisable)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EncryptionDisable

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EndBufferedPaint
; Description....: Completes a buffered paint operation and frees the associated buffered paint handle.
; Syntax.........: _WinAPI_EndBufferedPaint ( $hBP [, $fUpdate] )
; Parameters.....: $hBP     - Handle of the buffered paint context.
;                  $fUpdate - Specifies whether copy the buffer to the target DC, valid values:
;                  |TRUE    - The target DC will be updated from the buffer. (Default)
;                  |FALSE   - The target DC remains unchanged.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ EndBufferedPaint
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EndBufferedPaint($hBP, $fUpdate = 1)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'EndBufferedPaint', 'ptr', $hBP, 'int', $fUpdate)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EndBufferedPaint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EndDeferWindowPos
; Description....: Simultaneously updates the position and size of one or more windows in a single screen-refreshing cycle.
; Syntax.........: _WinAPI_EndDeferWindowPos ( $hInfo )
; Parameters.....: $hInfo  - Handle to a multiple-window-position structure that contains size and position information for one or
;                            more windows. This internal structure is returned by the _WinAPI_BeginDeferWindowPos() function or by
;                            the most recent call to the _WinAPI_DeferWindowPos() function.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: KaFu
; Modified.......: Yashied
; Remarks........: The _WinAPI_EndDeferWindowPos() function sends the WM_WINDOWPOSCHANGING and WM_WINDOWPOSCHANGED messages to
;                  each window identified in the internal structure.
; Related........:
; Link...........: @@MsdnLink@@ EndDeferWindowPos
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EndDeferWindowPos($hInfo)

	Local $Ret = DllCall('user32.dll', 'int', 'EndDeferWindowPos', 'ptr', $hInfo)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EndDeferWindowPos

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EndPaint
; Description....: Marks the end of painting in the specified window.
; Syntax.........: _WinAPI_EndPaint ( $hWnd, ByRef $tPAINTSTRUCT )
; Parameters.....: $hWnd         - Handle to the window that has been repainted.
;                  $tPAINTSTRUCT - $tagPAINTSTRUCT structure that contains the painting information retrieved by _WinAPI_BeginPaint().
; Return values..: Success       - 1.
;                  Failure       - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function is required for each call to the _WinAPI_BeginPaint() function, but only after painting is complete.
; Related........:
; Link...........: @@MsdnLink@@ EndPaint
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EndPaint($hWnd, ByRef $tPAINTSTRUCT)

	Local $Ret = DllCall('user32.dll', 'int', 'EndPaint', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tPAINTSTRUCT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EndPaint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EndPath
; Description....: Closes a path bracket and selects the path defined by the bracket into the specified device context.
; Syntax.........: _WinAPI_EndPath ( $hDC )
; Parameters.....: $hDC    - Handle to the device context into which the new path is selected.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EndPath
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EndPath($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'EndPath', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EndPath

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EndUpdateResource
; Description....: Commits or discards a changes of the resources within module.
; Syntax.........: _WinAPI_EndUpdateResource ( $hUpdate [, $fDiscard] )
; Parameters.....: $hUpdate  - A module handle returned by the _WinAPI_BeginUpdateResource(), and used by _WinAPI_UpdateResource(),
;                              referencing the file to be updated.
;                  $fDiscard - Specifies whether to write the resource updates to the file, valid values:
;                  |TRUE     - The changes are discarded.
;                  |FALSE    - The changes are made: the resource updates will take effect. (Default)
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EndUpdateResource
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EndUpdateResource($hUpdate, $fDiscard = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'EndUpdateResourceW', 'ptr', $hUpdate, 'int', $fDiscard)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EndUpdateResource

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumChildProcess
; Description....: Enumerates a child processes that belong to the specified process.
; Syntax.........: _WinAPI_EnumChildProcess ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The 2D array of the PIDs and process names.
;
;                            [0][0] - Number of rows in array (n)
;                            [0][1] - Unused
;                            [n][0] - PID
;                            [n][1] - Process name
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumChildProcess($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hSnapshot = DllCall('kernel32.dll', 'ptr', 'CreateToolhelp32Snapshot', 'dword', 0x00000002, 'dword', 0)

	If (@error) Or (Not $hSnapshot[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tPROCESSENTRY32 = DllStructCreate('dword Size;dword Usage;dword ProcessID;ulong_ptr DefaultHeapID;dword ModuleID;dword Threads;dword ParentProcessID;long PriClassBase;dword Flags;wchar ExeFile[260]')
	Local $pPROCESSENTRY32 = DllStructGetPtr($tPROCESSENTRY32)
	Local $Ret, $Result[101][2] = [[0]]

	$hSnapshot = $hSnapshot[0]
	DllStructSetData($tPROCESSENTRY32, 'Size', DllStructGetSize($tPROCESSENTRY32))
	$Ret = DllCall('kernel32.dll', 'int', 'Process32FirstW', 'ptr', $hSnapshot, 'ptr', $pPROCESSENTRY32)
	While (Not @error) And ($Ret[0])
		If DllStructGetData($tPROCESSENTRY32, 'ParentProcessID') = $PID Then
			__Inc($Result)
			$Result[$Result[0][0]][0] = DllStructGetData($tPROCESSENTRY32, 'ProcessID')
			$Result[$Result[0][0]][1] = DllStructGetData($tPROCESSENTRY32, 'ExeFile')
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'Process32NextW', 'ptr', $hSnapshot, 'ptr', $pPROCESSENTRY32)
	WEnd
	_WinAPI_CloseHandle($hSnapshot)
	If Not $Result[0][0] Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($Result, -1)
	Return $Result
EndFunc   ;==>_WinAPI_EnumChildProcess

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumChildWindows
; Description....: Enumerates a child windows that belong to the specified parent window.
; Syntax.........: _WinAPI_EnumChildWindows ( $hWnd [, $fVisible] )
; Parameters.....: $hWnd     - Handle to the parent window whose child windows are to be enumerated. If this parameter is 0,
;                              this function is equivalent to _WinAPI_EnumWindows().
;                  $fVisible - Specifies whether enumerates the invisible window, valid values:
;                  |TRUE     - Enumerate only visible windows. (Default)
;                  |FALSE    - Enumerate all windows.
; Return values..: Success   - The 2D array of the handles to the child windows and classes for the specified parent window.
;
;                              [0][0] - Number of rows in array (n)
;                              [0][1] - Unused
;                              [n][0] - Window handle
;                              [n][1] - Window class name
;
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumChildWindows
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumChildWindows($hWnd, $fVisible = 1)

	If Not _WinAPI_GetWindow($hWnd, 5) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $hEnumProc = DllCallbackRegister('__EnumWindowsProc', 'int', 'hwnd;lparam')

	Dim $__Data[101][2] = [[0]]
	DllCall('user32.dll', 'int', 'EnumChildWindows', 'hwnd', $hWnd, 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', $fVisible)
	If (@error) Or (Not $__Data[0][0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumChildWindows

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumDesktops
; Description....: Enumerates all desktops associated with the specified window station of the calling process.
; Syntax.........: _WinAPI_EnumDesktops ( $hStation )
; Parameters.....: $hStation - Handle to the window station whose desktops are to be enumerated. This handle must have the
;                              $WINSTA_ENUMDESKTOPS access right.
; Return values..: Success   - The array of the desktop names. The zeroth array element contains the number of desktop.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_EnumDesktops() enumerates only those desktops for which the calling process has the
;                  $DESKTOP_ENUMERATE access right.
; Related........:
; Link...........: @@MsdnLink@@ EnumDesktops
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumDesktops($hStation)

	If StringCompare(_WinAPI_GetUserObjectInformation($hStation, 3), 'WindowStation') Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumDefaultProc', 'int', 'hwnd;lparam')

	Dim $__Data[101] = [0]
	$Ret = DllCall('user32.dll', 'int', 'EnumDesktopsW', 'ptr', $hStation, 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', 0)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumDesktops

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumDesktopWindows
; Description....: Enumerates all top-level windows associated with the specified desktop.
; Syntax.........: _WinAPI_EnumDesktopWindows ( $hDesktop [, $fVisible] )
; Parameters.....: $hDesktop - Handle to the desktop whose top-level windows are to be enumerated. This handle must have the
;                              $DESKTOP_READOBJECTS access right.
;                  $fVisible - Specifies whether enumerates the invisible window, valid values:
;                  |TRUE     - Enumerate only visible windows. (Default)
;                  |FALSE    - Enumerate all windows.
; Return values..: Success   - The 2D array of the handles to the window and its class associated with the specified desktop.
;
;                              [0][0] - Number of rows in array (n)
;                              [0][1] - Unused
;                              [n][0] - Window handle
;                              [n][1] - Window class name
;
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumDesktopWindows
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumDesktopWindows($hDesktop, $fVisible = 1)

	If StringCompare(_WinAPI_GetUserObjectInformation($hDesktop, 3), 'Desktop') Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumWindowsProc', 'int', 'hwnd;lparam')

	Dim $__Data[101][2] = [[0]]
	$Ret = DllCall('user32.dll', 'int', 'EnumDesktopWindows', 'ptr', $hDesktop, 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', $fVisible)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0][0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumDesktopWindows

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumDeviceDrivers
; Description....: Retrieves the load address for each device driver in the system.
; Syntax.........: _WinAPI_EnumDeviceDrivers ( )
; Parameters.....: None
; Return values..: Success - The array of device driver addresses. The zeroth array element contains the number of addresses.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumDeviceDrivers
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumDeviceDrivers()

	Local $tData, $Size, $Ret, $Result

	$Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EnumDeviceDrivers', 'ptr', 0, 'dword', 0, 'dword*', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	If @AutoItX64 Then
		$Size = $Ret[3] / 8
	Else
		$Size = $Ret[3] / 4
	EndIf
	$tData = DllStructCreate('ptr[' & $Size & ']')
	$Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EnumDeviceDrivers', 'ptr', DllStructGetPtr($tData), 'dword', DllStructGetSize($tData), 'dword*', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Dim $Result[$Size + 1] = [$Size]
	For $i = 1 To $Size
		$Result[$i] = DllStructGetData($tData, 1, $i)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_EnumDeviceDrivers

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumDisplayMonitors
; Description....: Enumerates display monitors (including invisible pseudo-monitors associated with the mirroring drivers).
; Syntax.........: _WinAPI_EnumDisplayMonitors ( [$hDC [, $tRECT]] )
; Parameters.....: $hDC    - Handle to a display device context that defines the visible region of interest. If it's 0, the visible
;                            region of interest is the virtual screen that encompasses all the displays on the desktop.
;                  $tRECT  - $tagRECT structure that specifies a clipping rectangle. This parameter can be 0 if you don't want to
;                            clip the specified region.
; Return values..: Success - The 2D array containing the following information:
;
;                            [0][0] - Number of rows in array (n)
;                            [0][1] - Unused
;                            [n][0] - A handle to the display monitor.
;                            [n][1] - $tagRECT structure defining a display monitor rectangle or the clipping area.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumDisplayMonitors
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumDisplayMonitors($hDC = 0, $tRECT = 0)

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumDisplayMonitorsProc', 'int', 'ptr;hwnd;ptr;lparam')

	Dim $__Data[101][2] = [[0]]
	$Ret = DllCall('user32.dll', 'int', 'EnumDisplayMonitors', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', 0)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0][0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumDisplayMonitors

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumDisplaySettings
; Description....: Retrieves information about one of the graphics modes for a display device.
; Syntax.........: _WinAPI_EnumDisplaySettings ( $sDevice, $iMode )
; Parameters.....: $sDevice - The display device about whose graphics mode the function will obtain information. An empty string
;                             specifies the current display device on the computer on which the calling process is running.
;                  $iMode   - The type of information to be retrieved. This value can be a graphics mode index or one of the
;                             following values.
;
;                             $ENUM_CURRENT_SETTINGS
;                             $ENUM_REGISTRY_SETTINGS
;
;                             Graphics mode indexes start at zero. To obtain information for all of a display device's graphics
;                             modes, make a series of calls to _WinAPI_EnumDisplaySettings(), as follows: Set $iMode to zero for
;                             the first call, and increment $iMode by one for each subsequent call. Continue calling the function
;                             until the return value is zero.
;
;                             When you call _WinAPI_EnumDisplaySettings() with $iMode set to zero, the operating system initializes
;                             and caches information about the display device. When you call _WinAPI_EnumDisplaySettings() with
;                             $iMode set to a non-zero value, the function returns the information that was cached the last time
;                             the function was called with $iMode set to zero.
;
; Return values..: Success  - The array containing the following information:
;
;                             [0] - The width, in pixels, of the visible device surface.
;                             [1] - The height, in pixels, of the visible device surface.
;                             [2] - The color resolution, in bits per pixel, of the display device.
;                             [3] - The frequency, in hertz (cycles per second), of the display device in a particular mode.
;                             [4] - The device's display mode ($DM_*).
;
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumDisplaySettings
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumDisplaySettings($sDevice, $iMode)

	Local $TypeOfDevice = 'wstr'

	If Not StringStripWS($sDevice, 3) Then
		$TypeOfDevice = 'ptr'
		$sDevice = 0
	EndIf

	Local $tDEVMODE = DllStructCreate($tagDEVMODE_DISPLAY)

	DllStructSetData($tDEVMODE, 'Size', DllStructGetSize($tDEVMODE))
	DllStructSetData($tDEVMODE, 'DriverExtra', 0)

	Local $Ret = DllCall('user32.dll', 'int', 'EnumDisplaySettingsW', $TypeOfDevice, $sDevice, 'dword', $iMode, 'ptr', DllStructGetPtr($tDEVMODE))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[5]

	$Result[0] = DllStructGetData($tDEVMODE, 'PelsWidth')
	$Result[1] = DllStructGetData($tDEVMODE, 'PelsHeight')
	$Result[2] = DllStructGetData($tDEVMODE, 'BitsPerPel')
	$Result[3] = DllStructGetData($tDEVMODE, 'DisplayFrequency')
	$Result[4] = DllStructGetData($tDEVMODE, 'DisplayFlags')

	Return $Result
EndFunc   ;==>_WinAPI_EnumDisplaySettings

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumDllProc
; Description....: Enumerates an exported functions of the specified dynamic-link library (DLL).
; Syntax.........: _WinAPI_EnumDllProc ( $sPath [, $sMask [, $iFlags]] )
; Parameters.....: $sPath  - The path to the library. Although this function searches for a file path when it specified as the relative
;                            path or the name without a path, will better to specify a fully qualified path to the library for an
;                            unequivocal result.
;                  $sMask  - A wildcard string that indicates the function names to be enumerated. This string can optionally
;                            contain the wildcards, "*" and "?". If this parameter is an empty string or omitted, all the exported
;                            functions will be enumerated.
;                  $iFlags - The optional flags. This parameter can be one or more of the following values.
;
;                            $SYMOPT_CASE_INSENSITIVE
;                            $SYMOPT_UNDNAME
;
; Return values..: Success - The 2D array containing the following information:
;
;                            [0][0] - Number of rows in array (n)
;                            [0][1] - Unused
;                            [n][0] - The function address relative to the library base address (UINT64).
;                            [n][1] - The function name.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function works with 32- and 64-bit DLLs regardless of the system (32- or 64-bit), although 64-bit executables
;                  cannot load 32-bit DLLs and vice-versa.
;
;                  Call _WinAPI_GetExtended() to retrieve a fully qualified path to the found library that was used to enumerate.
; Related........:
; Link...........: @@MsdnLink@@ SymEnumSymbols
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumDllProc($sPath, $sMask = '', $iFlags = 0)

	Local $Ret, $hEnumProc, $hLibrary, $hProcess, $pAddress = 0, $Init = 0, $Options = Default
	Local $TypeOfMask = 'wstr'

	If Not __DLL('dbghelp.dll') Then
		Return SetError(3, 0, 0)
	EndIf

	$__Ext = _WinAPI_PathSearchAndQualify($sPath, 1)
	If @error Then
		Return SetError(2, 0, 0)
	EndIf
	Do
		$__Data = 0
		$hLibrary = _WinAPI_LoadLibraryEx($__Ext, 0x00000003)
		If Not $hLibrary Then
			ExitLoop
		EndIf
		$Ret = DllCall('dbghelp.dll', 'dword', 'SymGetOptions')
		If @error Then
			ExitLoop
		EndIf
		$Options = $Ret[0]
		$Ret = DllCall('dbghelp.dll', 'dword', 'SymSetOptions', 'dword', BitOR(BitAND($iFlags, 0x00000003), 0x00000204))
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$hProcess = _WinAPI_GetCurrentProcess()
		$Ret = DllCall('dbghelp.dll', 'int', 'SymInitializeW', 'ptr', $hProcess, 'ptr', 0, 'int', 1)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Init = 1
		$Ret = DllCall('dbghelp.dll', 'uint64', 'SymLoadModuleExW', 'ptr', $hProcess, 'ptr', 0, 'wstr', $__Ext, 'ptr', 0, 'uint64', $hLibrary, 'dword', 0, 'ptr', 0, 'dword', 0)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$pAddress = $Ret[0]
		If Not StringStripWS($sMask, 3) Then
			$TypeOfMask = 'ptr'
			$sMask = 0
		EndIf
		Dim $__Data[501][2] = [[0]]
		$hEnumProc = DllCallbackRegister('__EnumSymbolsProc', 'int', 'ptr;ulong;lparam')
		$Ret = DllCall('dbghelp.dll', 'int', 'SymEnumSymbolsW', 'ptr', $hProcess, 'uint64', $pAddress, $TypeOfMask, $sMask, 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', 0)
		If (@error) Or (Not $Ret[0]) Or (Not $__Data[0][0]) Then
			$__Data = 0
		EndIf
		DllCallbackFree($hEnumProc)
		If IsArray($__Data) Then
			__Inc($__Data, -1)
		EndIf
	Until 1
	If $pAddress Then
		DllCall('dbghelp.dll', 'int', 'SymUnloadModule64', 'ptr', $hProcess, 'uint64', $pAddress)
	EndIf
	If $Init Then
		DllCall('dbghelp.dll', 'int', 'SymCleanup', 'ptr', $hProcess)
	EndIf
	If Not IsKeyword($Options) Then
		DllCall('dbghelp.dll', 'dword', 'SymSetOptions', 'dword', $Options)
	EndIf
	If $hLibrary Then
		_WinAPI_FreeLibrary($hLibrary)
	EndIf
	If IsArray($__Data) Then
		Return SetError(0, __Binary($__Ext), $__Data)
	Else
		Return SetError(1, 0, 0)
	EndIf
EndFunc   ;==>_WinAPI_EnumDllProc

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumFiles
; Description....: Enumerates the files and subdirectories for the specified directory with a name that matches the template.
; Syntax.........: _WinAPI_EnumFiles ( $sDir [, $iFlag [, $sTemplate [, $fExclude]]] )
; Parameters.....: $sDir      - The path to the directory.
;                  $iFlag     - The flag that specifies whether to enumerate files, subdirectories, or both. This parameter can be
;                               one of the following values.
;
;                               0 - Enumerate both files and subdirectories. (Default)
;                               1 - Enumerate files only.
;                               2 - Enumerate subdirectories only.
;
;                  $sTemplate - A template that using to enumerating files and directories. For example, "*.jpe;*.jpeg;*.jpg".
;                  $fExclude  - Specifies whether the specified template is used to exclude files, valid values:
;                  |TRUE  - The files matching the template will not be enumerated.
;                  |FALSE - The only those files that match the template will be enumerated. (Default)
; Return values..: Success    - The 2D array containing the following information:
;
;                               [0][0] - Number of rows in array (n)
;                               [0][i] - Unused
;                               [n][0] - The name of the file.
;                               [n][1] - The time (UTC) when the file was created.
;                               [n][2] - The time (UTC) when the file was last accessed.
;                               [n][3] - The time (UTC) when the file was last changed.
;                               [n][4] - The size of the file, in bytes.
;                               [n][5] - The allocation size of the file, in bytes.
;                               [n][6] - The file attributes ($FILE_ATTRIBUTE_*).
;
;                  Failure    - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the target directory is empty or no files matched the specified criteria, the function still returns an array
;                  where zeroth array element set to 0.
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryDirectoryFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumFiles($sDir, $iFlag = 0, $sTemplate = '', $fExclude = 0)

	Local $tFDI, $tIOSB, $hDir, $pBuffer, $Attrib, $Target, $Ret = 0, $Error = 1, $Length = 0, $Offset = 0
	Local $aData[501][7] = [[0]]

	$hDir = _WinAPI_CreateFileEx($sDir, 3, 0x00000001, 0x07, 0x02000000)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$pBuffer = __HeapAlloc($__Enum)
	If @error Then

	Else
		$tIOSB = DllStructCreate('ptr;ulong_ptr')
		$Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryDirectoryFile', 'ptr', $hDir, 'ptr', 0, 'ptr', 0, 'ptr', 0, 'ptr', DllStructGetPtr($tIOSB), 'ptr', $pBuffer, 'ulong', 8388608, 'uint', 1, 'int', 0, 'ptr', 0, 'int', 1)
		If (Not @error) And (Not $Ret[0]) Then
			$Error = 0
		EndIf
	EndIf
	_WinAPI_CloseHandle($hDir)
	If $Error Then
		__HeapFree($pBuffer, 1)
		If IsArray($Ret) Then
			Return SetError(2, $Ret[0], 0)
		Else
			Return SetError(9, 0, 0)
		EndIf
	EndIf
	Do
		$Length += $Offset
		$tFDI = DllStructCreate('ulong;ulong;int64;int64;int64;int64;int64;int64;ulong;ulong;wchar[' & (DllStructGetData(DllStructCreate('ulong', $pBuffer + $Length + 60), 1) / 2) & ']', $pBuffer + $Length)
		$Target = DllStructGetData($tFDI, 11)
		$Attrib = DllStructGetData($tFDI, 9)
		$Offset = DllStructGetData($tFDI, 1)
		Switch $Target
			Case '.', '..'
				ContinueLoop
			Case Else
				Switch $iFlag
					Case 1, 2
						If BitAND($Attrib, 0x00000010) Then
							If $iFlag = 1 Then
								ContinueLoop
							EndIf
						Else
							If $iFlag = 2 Then
								ContinueLoop
							EndIf
						EndIf
				EndSwitch
				If $sTemplate Then
					$Ret = DllCall('shlwapi.dll', 'int', 'PathMatchSpecW', 'wstr', $Target, 'wstr', $sTemplate)
					If (@error) Or (($Ret[0]) And ($fExclude)) Or ((Not $Ret[0]) And (Not $fExclude)) Then
						ContinueLoop
					EndIf
				EndIf
		EndSwitch
		__Inc($aData, 500)
		$aData[$aData[0][0]][0] = $Target
		$aData[$aData[0][0]][1] = DllStructGetData($tFDI, 3)
		$aData[$aData[0][0]][2] = DllStructGetData($tFDI, 4)
		$aData[$aData[0][0]][3] = DllStructGetData($tFDI, 5)
		$aData[$aData[0][0]][4] = DllStructGetData($tFDI, 7)
		$aData[$aData[0][0]][5] = DllStructGetData($tFDI, 8)
		$aData[$aData[0][0]][6] = $Attrib
	Until Not $Offset
	__HeapFree($pBuffer)
	__Inc($aData, -1)
	Return $aData
EndFunc   ;==>_WinAPI_EnumFiles

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumFileStreams
; Description....: Enumerates all streams with a ::$DATA stream type in the specified file or directory.
; Syntax.........: _WinAPI_EnumFileStreams ( $sFile )
; Parameters.....: $sFile  - The path to the file or directory. The file must be located on volume with NTFS file system.
; Return values..: Success - The 2D array of the stream names and its sizes.
;
;                            [0][0] - Number of rows in array (n)
;                            [0][1] - Unused
;                            [n][0] - Stream name.
;                            [n][1] - Stream size, in bytes.
;
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryInformationFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumFileStreams($sFile)

	Local $tFSI, $tIOSB, $hFile, $Ret, $Length = 0, $Offset = 0
	Local $tData = DllStructCreate('byte[32768]')
	Local $pData = DllStructGetPtr($tData)
	Local $aData[101][2] = [[0]]

	$hFile = _WinAPI_CreateFileEx($sFile, 3, 0, 0x03, 0x02000000)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$tIOSB = DllStructCreate('ptr;ulong_ptr')
	$Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryInformationFile', 'ptr', $hFile, 'ptr', DllStructGetPtr($tIOSB), 'ptr', $pData, 'ulong', 32768, 'uint', 22)
	If @error Then
		$Ret = 0
	Else
		If $Ret[0] Then
			$Ret = $Ret[0]
		EndIf
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, $Ret, 0)
	EndIf
	Do
		$Length += $Offset
		$tFSI = DllStructCreate('ulong;ulong;int64;int64;wchar[' & (DllStructGetData(DllStructCreate('ulong', $pData + $Length + 4), 1) / 2) & ']', $pData + $Length)
		__Inc($aData)
		$aData[$aData[0][0]][0] = DllStructGetData($tFSI, 5)
		$aData[$aData[0][0]][1] = DllStructGetData($tFSI, 3)
		$Offset = DllStructGetData($tFSI, 1)
	Until Not $Offset
	__Inc($aData, -1)
	Return $aData
EndFunc   ;==>_WinAPI_EnumFileStreams

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumHardLinks
; Description....: Enumerates all the hard links to the specified file.
; Syntax.........: _WinAPI_EnumHardLinks ( $sFile )
; Parameters.....: $sFile  - The path to the file whose links are to be enumerated.
; Return values..: Success - The array of the full paths to the links. The zeroth array element contains the number of links.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_CreateHardLink() function is only supported on the NTFS file system.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryInformationFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumHardLinks($sFile)

	Local $tFLEI, $tIOSB, $aData, $hFile, $hPath, $sPath, $Ret, $Count, $Error, $Length = 8
	Local $tData = DllStructCreate('byte[32768]')
	Local $pData = DllStructGetPtr($tData)

	$hFile = _WinAPI_CreateFileEx($sFile, 3, 0, 0x03)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$tIOSB = DllStructCreate('ptr;ulong_ptr')
	$Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryInformationFile', 'ptr', $hFile, 'ptr', DllStructGetPtr($tIOSB), 'ptr', $pData, 'ulong', 32768, 'uint', 46)
	If (@error) Or ($Ret[0]) Then
		_WinAPI_CloseHandle($hFile)
		If IsArray($Ret) Then
			Return SetError(2, $Ret[0], 0)
		Else
			Return SetError(2, 0, 0)
		EndIf
	EndIf
	$Count = DllStructGetData(DllStructCreate('ulong;ulong', $pData), 2)
	Dim $aData[$Count + 1] = [$Count]
	For $i = 1 To $Count
		$tFLEI = DllStructCreate('ulong;int64;ulong;wchar[' & (DllStructGetData(DllStructCreate('ulong', $pData + $Length + 16), 1)) & ']', $pData + $Length)
		Do
			$Error = 1
			$hPath = _WinAPI_OpenFileById($hFile, DllStructGetData($tFLEI, 2), 0x00100080, 0x03, 0x02000000)
			If @error Then
				ExitLoop
			EndIf
			$sPath = _WinAPI_GetFinalPathNameByHandleEx($hPath)
			If @error Then
				ExitLoop
			EndIf
			$Error = 0
		Until 1
		If $hPath Then
			_WinAPI_CloseHandle($hPath)
		EndIf
		If $Error Then
			ExitLoop
		EndIf
		$aData[$i] = _WinAPI_PathAppend($sPath, DllStructGetData($tFLEI, 4))
		$Length += DllStructGetData($tFLEI, 1)
	Next
	_WinAPI_CloseHandle($hFile)
	If $Error Then
		Return SetError(3, 0, 0)
	EndIf
	Return $aData
EndFunc   ;==>_WinAPI_EnumHardLinks

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumMRUList
; Description....: Enumerates the contents of the most recently used (MRU) list.
; Syntax.........: _WinAPI_EnumMRUList ( $hMRU, $iItem )
; Parameters.....: $hMRU    - Handle of the MRU list, obtained when the list was created.
;                  $iItem   - The item to return. If this value is (-1), the function returns the number of items in the MRU list.
; Return values..: Success  - The item requested in $iItem. If $iItem is (-1), the number of items in the MRU list.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumMRUListW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumMRUList($hMRU, $iItem)

	Local $Ret = DllCall('comctl32.dll ', 'int', 'EnumMRUListW', 'ptr', $hMRU, 'int', $iItem, 'wstr', '', 'uint', 4096)

	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, 0)
	EndIf
	If $iItem < 0 Then
		Return $Ret[0]
	Else
		If Not $Ret[0] Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_EnumMRUList

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumPageFiles
; Description....: Retrieves information for each installed pagefile in the system.
; Syntax.........: _WinAPI_EnumPageFiles ( )
; Parameters.....: None
; Return values..: Success - The 2D array containing pagefile's information.
;
;                            [0][0] - Number of rows in array (n)
;                            [0][i] - Unused
;                            [n][0] - The path to pagefile.
;                            [n][1] - The total size of the pagefile, in bytes.
;                            [n][2] - The current pagefile usage, in bytes.
;                            [n][3] - The peak pagefile usage, in bytes.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumPageFiles
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumPageFiles()

	Local $Info = _WinAPI_GetSystemInfo()

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumPageFilesProc', 'int', 'lparam;ptr;ptr')

	Dim $__Data[101][4] = [[0]]
	$Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EnumPageFilesW', 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', $Info[1])
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0][0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumPageFiles

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumProcessHandles
; Description....: Enumerates a handles that belong to the specified process.
; Syntax.........: _WinAPI_EnumProcessHandles ( [$PID [, $iType ]] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
;                  $iType  - The value associated with the type of the objects that should be enumerated. This value depends on the
;                            operating system. If this parameter is 0, all handles of the specified process will be enumerated.
; Return values..: Success - The 2D array containing the following information:
;
;                            [0][0] - Number of rows in array (n)
;                            [0][i] - Unused
;                            [n][0] - Handle
;                            [n][1] - Type (depends on the operating system)
;                            [n][2] - Attributes
;                            [n][3] - Access
;
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQuerySystemInformation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumProcessHandles($PID = 0, $iType = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $tSHI, $tHandle, $pData, $Ret, $Size
	Local $Result[101][4] = [[0]]

	$tSHI = DllStructCreate('ulong;byte[4194304]')
	$Ret = DllCall('ntdll.dll', 'uint', 'ZwQuerySystemInformation', 'uint', 16, 'ptr', DllStructGetPtr($tSHI), 'ulong', DllStructGetSize($tSHI), 'ulong*', 0)
	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	$pData = DllStructGetPtr($tSHI, 2)
	$Size = DllStructGetSize(DllStructCreate('ulong;ubyte;ubyte;ushort;ptr;ulong'))
	For $i = 1 To DllStructGetData($tSHI, 1)
		$tHandle = DllStructCreate('ulong;ubyte;ubyte;ushort;ptr;ulong', $pData + ($i - 1) * $Size)
		If (DllStructGetData($tHandle, 1) = $PID) And ((Not $iType) Or ($iType = DllStructGetData($tHandle, 2))) Then
			__Inc($Result)
			$Result[$Result[0][0]][0] = Ptr(DllStructGetData($tHandle, 4))
			$Result[$Result[0][0]][1] = DllStructGetData($tHandle, 2)
			$Result[$Result[0][0]][2] = DllStructGetData($tHandle, 3)
			$Result[$Result[0][0]][3] = DllStructGetData($tHandle, 6)
		EndIf
	Next
	If Not $Result[0][0] Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($Result, -1)
	Return $Result
EndFunc   ;==>_WinAPI_EnumProcessHandles

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumProcessModules
; Description....: Retrieves a handle and name for each module in the specified process.
; Syntax.........: _WinAPI_EnumProcessModules ( [$PID [, $iFlag]] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
;                  $iFlag  - The filter criteria. This parameter is valid only for Windows Vista and later, and can be one of the
;                            following values.
;
;                            $LIST_MODULES_32BIT
;                            $LIST_MODULES_64BIT
;                            $LIST_MODULES_ALL
;                            $LIST_MODULES_DEFAULT
;
; Return values..: Success - The 2D array containing the following information:
;
;                            [0][0] - Number of rows in array (n)
;                            [0][1] - Unused
;                            [n][0] - Handle to the module.
;                            [n][1] - The path to the file that contains the module.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function does not retrieve handles for modules that were loaded with the $LOAD_LIBRARY_AS_DATAFILE flag.
;                  For more information, see _WinAPI_LoadLibraryEx().
;
;                  Do not call _WinAPI_CloseHandle() on any of the handles returned by this function. The information comes
;                  from a snapshot, so there are no resources to be freed.
;
;                  Windows XP: If _WinAPI_EnumProcessModules() is called from a 32-bit application running on WOW64, it can only
;                  enumerate the modules of a 32-bit process. If the process is a 64-bit process, this function fails and the
;                  last error code is ERROR_PARTIAL_COPY (299).
; Related........:
; Link...........: @@MsdnLink@@ EnumProcessModulesEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumProcessModules($PID = 0, $iFlag = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess, $tPtr, $Count, $Ret, $Result = 0

	$hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000410, 0x00001010), 'int', 0, 'dword', $PID)
	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Do
		If $__WINVER >= 0x0600 Then
			$Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EnumProcessModulesEx', 'ptr', $hProcess[0], 'ptr', 0, 'dword', 0, 'dword*', 0, 'dword', $iFlag)
		Else
			$Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EnumProcessModules', 'ptr', $hProcess[0], 'ptr', 0, 'dword', 0, 'dword*', 0)
		EndIf
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		If @AutoItX64 Then
			$Count = $Ret[4] / 8
		Else
			$Count = $Ret[4] / 4
		EndIf
		$tPtr = DllStructCreate('ptr[' & $Count & ']')
		If @error Then
			ExitLoop
		EndIf
		If $__WINVER >= 0x0600 Then
			$Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EnumProcessModulesEx', 'ptr', $hProcess[0], 'ptr', DllStructGetPtr($tPtr), 'dword', DllStructGetSize($tPtr), 'dword*', 0, 'dword', $iFlag)
		Else
			$Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'EnumProcessModules', 'ptr', $hProcess[0], 'ptr', DllStructGetPtr($tPtr), 'dword', DllStructGetSize($tPtr), 'dword*', 0)
		EndIf
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		Dim $Result[$Count + 1][2] = [[$Count]]
		For $i = 1 To $Count
			$Result[$i][0] = DllStructGetData($tPtr, 1, $i)
			$Result[$i][1] = _WinAPI_GetModuleFileNameEx($hProcess[0], $Result[$i][0])
		Next
	Until 1
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Result) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Result
EndFunc   ;==>_WinAPI_EnumProcessModules

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumProcessThreads
; Description....: Enumerates a threads that belong to the specified process.
; Syntax.........: _WinAPI_EnumProcessThreads ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The array of threads identifiers (ID). The zeroth array element contains the number of threads.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumProcessThreads($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hSnapshot = DllCall('kernel32.dll', 'ptr', 'CreateToolhelp32Snapshot', 'dword', 0x00000004, 'dword', 0)

	If (@error) Or (Not $hSnapshot[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tTHREADENTRY32 = DllStructCreate('dword Size;dword Usage;dword ThreadID;dword OwnerProcessID;long BasePri;long DeltaPri;dword Flags')
	Local $pTHREADENTRY32 = DllStructGetPtr($tTHREADENTRY32)
	Local $Ret, $Result[101] = [0]

	$hSnapshot = $hSnapshot[0]
	DllStructSetData($tTHREADENTRY32, 'Size', DllStructGetSize($tTHREADENTRY32))
	$Ret = DllCall('kernel32.dll', 'int', 'Thread32First', 'ptr', $hSnapshot, 'ptr', $pTHREADENTRY32)
	While (Not @error) And ($Ret[0])
		If DllStructGetData($tTHREADENTRY32, 'OwnerProcessID') = $PID Then
			__Inc($Result)
			$Result[$Result[0]] = DllStructGetData($tTHREADENTRY32, 'ThreadID')
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'Thread32Next', 'ptr', $hSnapshot, 'ptr', $pTHREADENTRY32)
	WEnd
	_WinAPI_CloseHandle($hSnapshot)
	If Not $Result[0] Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($Result, -1)
	Return $Result
EndFunc   ;==>_WinAPI_EnumProcessThreads

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumProcessWindows
; Description....: Enumerates a windows that belong to the specified process.
; Syntax.........: _WinAPI_EnumProcessWindows ( [$PID [, $fVisible]] )
; Parameters.....: $PID      - The PID of the process. Default (0) is the current process.
;                  $fVisible - Specifies whether enumerates the invisible window, valid values:
;                  |TRUE     - Enumerate only visible windows. (Default)
;                  |FALSE    - Enumerate all windows.
; Return values..: Success   - The 2D array of the handles to the window and class for the specified process.
;
;                              [0][0] - Number of rows in array (n)
;                              [0][1] - Unused
;                              [n][0] - Window handle
;                              [n][1] - Window class name
;
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumProcessWindows($PID = 0, $fVisible = 1)

	Local $Threads = _WinAPI_EnumProcessThreads($PID)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $hEnumProc = DllCallbackRegister('__EnumWindowsProc', 'int', 'hwnd;lparam')

	Dim $__Data[101][2] = [[0]]
	For $i = 1 To $Threads[0]
		DllCall('user32.dll', 'int', 'EnumThreadWindows', 'dword', $Threads[$i], 'ptr',  DllCallbackGetPtr($hEnumProc), 'lparam', $fVisible)
		If @error Then
			ExitLoop
		EndIf
	Next
	DllCallbackFree($hEnumProc)
	If Not $__Data[0][0] Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumProcessWindows

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumRawInputDevices
; Description....: Enumerates the raw input devices attached to the system.
; Syntax.........: _WinAPI_EnumRawInputDevices ( )
; Parameters.....: None
; Return values..: Success - The 2D array of the device handles and types.
;
;                            [0][0] - Number of rows in array (n)
;                            [0][1] - Unused
;                            [n][0] - A handle to the raw input device.
;                            [n][1] - A type of device ($RIM_*).
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetRawInputDeviceList
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumRawInputDevices()

	Local $tRIDL, $tData, $pData, $Ret, $Result, $Length = __Iif(@AutoItX64, 16, 8)

	$Ret = DllCall('user32.dll', 'uint', 'GetRawInputDeviceList', 'ptr', 0, 'uint*', 0, 'uint', $Length)
	If (@error) Or ($Ret[0] = 4294967295) Or (Not $Ret[2]) Then
		Return SetError(1, 0, 0)
	EndIf
	$tData = DllStructCreate('byte[' & ($Ret[2] * $Length) & ']')
	$pData = DllStructGetPtr($tData)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$Ret = DllCall('user32.dll', 'uint', 'GetRawInputDeviceList', 'ptr', $pData, 'uint*', $Ret[2], 'uint', $Length)
	If (@error) Or ($Ret[0] = 4294967295) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Dim $Result[$Ret[2] + 1][2] = [[$Ret[2]]]
	For $i = 1 To $Ret[2]
		$tRIDL = DllStructCreate('ptr;dword', $pData + $Length * ($i - 1))
		For $j = 0 to 1
			$Result[$i][$j] = DllStructGetData($tRIDL, $j + 1)
		Next
	Next
	Return $Result
EndFunc   ;==>_WinAPI_EnumRawInputDevices

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumResourceLanguages
; Description....: Enumerates a language-specific resources, of the specified type and name, associated with a binary module.
; Syntax.........: _WinAPI_EnumResourceLanguages ( $hModule, $sType, $sName )
; Parameters.....: $hModule - The handle to a module to be searched. Also, this parameter can specify the name of the module to load,
;                             it must be a full or relative path. If this parameter is 0 or an empty string, that is equivalent to
;                             passing in a handle to the module used to create the current process.
;                  $sType   - The type of resource for which the language is being enumerated. It can be a string or an integer
;                             value representing a predefined resource type.
;                  $sName   - The name of the resource for which the language is being enumerated. It can be a string or an
;                             integer value representing a predefined resource type.
; Return values..: Success  - The array of the language identifiers for the specified resource type and name.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumResourceLanguages
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumResourceLanguages($hModule, $sType, $sName)

	Local $Ret, $hEnumProc, $Library = 0, $TypeOfType = 'int', $TypeOfName = 'int'

	If IsString($hModule) Then
		If StringStripWS($hModule, 3) Then
			$hModule = _WinAPI_LoadLibraryEx($hModule, 0x00000003)
			If Not $hModule Then
				Return SetError(1, 0, 0)
			EndIf
			$Library = 1
		Else
			$hModule = 0
		EndIf
	EndIf
	If IsString($sType) Then
		$TypeOfType = 'wstr'
	EndIf
	If IsString($sName) Then
		$TypeOfName = 'wstr'
	EndIf
	Dim $__Data[101] = [0]
	$hEnumProc = DllCallbackRegister('__EnumResLanguagesProc', 'int', 'ptr;ptr;ptr;ushort;long_ptr')
	$Ret = DllCall('kernel32.dll', 'int', 'EnumResourceLanguagesW', 'ptr', $hModule, $TypeOfType, $sType, $TypeOfName, $sName, 'ptr', DllCallbackGetPtr($hEnumProc), 'long_ptr', 0)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	If $Library Then
		_WinAPI_FreeLibrary($hModule)
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumResourceLanguages

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumResourceNames
; Description....: Enumerates the resources of a specified type within a binary module.
; Syntax.........: _WinAPI_EnumResourceNames ( $hModule, $sType )
; Parameters.....: $hModule - The handle to a module to be searched. Also, this parameter can specify the name of the module to load,
;                             it must be a full or relative path. If this parameter is 0 or an empty string, that is equivalent to
;                             passing in a handle to the module used to create the current process.
;                  $sType   - The type of the resource for which the name is being enumerated. It can be a string or an integer
;                             value representing a predefined resource type.
; Return values..: Success  - The array of the names for the specified resource type.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumResourceNames
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumResourceNames($hModule, $sType)

	Local $Ret, $hEnumProc, $Library = 0, $TypeOfType = 'int'

	If IsString($hModule) Then
		If StringStripWS($hModule, 3) Then
			$hModule = _WinAPI_LoadLibraryEx($hModule, 0x00000003)
			If Not $hModule Then
				Return SetError(1, 0, 0)
			EndIf
			$Library = 1
		Else
			$hModule = 0
		EndIf
	EndIf
	If IsString($sType) Then
		$TypeOfType = 'wstr'
	EndIf
	Dim $__Data[101] = [0]
	$hEnumProc = DllCallbackRegister('__EnumResNamesProc', 'int', 'ptr;ptr;ptr;long_ptr')
	$Ret = DllCall('kernel32.dll', 'int', 'EnumResourceNamesW', 'ptr', $hModule, $TypeOfType, $sType, 'ptr', DllCallbackGetPtr($hEnumProc), 'long_ptr', 0)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	If $Library Then
		_WinAPI_FreeLibrary($hModule)
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumResourceNames

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumResourceTypes
; Description....: Enumerates the resource types within a binary module.
; Syntax.........: _WinAPI_EnumResourceTypes ( $hModule )
; Parameters.....: $hModule - The handle to a module to be searched. Also, this parameter can specify the name of the module to load,
;                             it must be a full or relative path. If this parameter is 0 or an empty string, that is equivalent to
;                             passing in a handle to the module used to create the current process.
; Return values..: Success  - The array of the types of the resources for the specified module.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumResourceTypes
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumResourceTypes($hModule)

	Local $Ret, $hEnumProc, $Library = 0

	If IsString($hModule) Then
		If StringStripWS($hModule, 3) Then
			$hModule = _WinAPI_LoadLibraryEx($hModule, 0x00000003)
			If Not $hModule Then
				Return SetError(1, 0, 0)
			EndIf
			$Library = 1
		Else
			$hModule = 0
		EndIf
	EndIf
	Dim $__Data[101] = [0]
	$hEnumProc = DllCallbackRegister('__EnumResTypesProc', 'int', 'ptr;ptr;long_ptr')
	$Ret = DllCall('kernel32.dll', 'int', 'EnumResourceTypesW', 'ptr', $hModule, 'ptr', DllCallbackGetPtr($hEnumProc), 'long_ptr', 0)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	If $Library Then
		_WinAPI_FreeLibrary($hModule)
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumResourceTypes

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumSystemGeoID
; Description....: Enumerates the geographical location identifiers (GEOID) that are available on the operating system.
; Syntax.........: _WinAPI_EnumSystemGeoID ( )
; Parameters.....: None
; Return values..: Success - The array of the GEOID. The zeroth array element contains the number of identifiers.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumSystemGeoID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumSystemGeoID()

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumGeoIDProc', 'int', 'long')

	Dim $__Data[101] = [0]
	$Ret = DllCall('kernel32.dll', 'int', 'EnumSystemGeoID', 'uint', 16, 'long', 0, 'ptr', DllCallbackGetPtr($hEnumProc))
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumSystemGeoID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumSystemLocales
; Description....: Enumerates the locales that are either installed on or supported by an operating system.
; Syntax.........: _WinAPI_EnumSystemLocales ( $iFlag )
; Parameters.....: $iFlag  - The flag specifying the locale identifiers to enumerate. This parameter can have one of the
;                            following values.
;
;                            $LCID_INSTALLED
;                            $LCID_SUPPORTED
;
; Return values..: Success - The array of the locale identifiers.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumSystemLocales
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumSystemLocales($iFlag)

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumLocalesProc', 'int', 'ptr')

	Dim $__Data[101] = [0]
	$Ret = DllCall('kernel32.dll', 'int', 'EnumSystemLocalesW', 'ptr', DllCallbackGetPtr($hEnumProc), 'dword', $iFlag)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumSystemLocales

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumUILanguages
; Description....: Enumerates the user interface languages that are available on the operating system.
; Syntax.........: _WinAPI_EnumUILanguages ( [$iFlag] )
; Parameters.....: $iFlag  - The flag identifying the language format. This parameter must be 0 (Windows XP) or one of the
;                            following values (Windows Vista or later).
;
;                            $MUI_LANGUAGE_ID
;                            $MUI_LANGUAGE_NAME
;
; Return values..: Success - The array of the UI language identifiers or language names.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EnumUILanguages
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumUILanguages($iFlag = 0)

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumUILanguagesProc', 'int', 'ptr;lparam')
	Local $ID = 1

	If $__WINVER >= 0x0600 Then
		If BitAND($iFlag, 0x0008) Then
			$ID = 0
		EndIf
	Else
		$iFlag = 0
	EndIf
	Dim $__Data[101] = [0]
	$Ret = DllCall('kernel32.dll', 'int', 'EnumUILanguagesW', 'ptr', DllCallbackGetPtr($hEnumProc), 'dword', $iFlag, 'lparam', $ID)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumUILanguages

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EnumWindowStations
; Description....: Enumerates all window stations in the current session.
; Syntax.........: _WinAPI_EnumWindowStations ( )
; Parameters.....: None
; Return values..: Success - The array of the window station names. The zeroth array element contains the number of window station.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_EnumWindowStations() enumerates only those window stations for which the calling process has the
;                  $WINSTA_ENUMERATE access right.
; Related........:
; Link...........: @@MsdnLink@@ EnumWindowStations
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EnumWindowStations()

	Local $Ret, $hEnumProc = DllCallbackRegister('__EnumDefaultProc', 'int', 'ptr;lparam')

	Dim $__Data[101] = [0]
	$Ret = DllCall('user32.dll', 'int', 'EnumWindowStationsW', 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', 0)
	If (@error) Or (Not $Ret[0]) Or (Not $__Data[0]) Then
		$__Data = 0
	EndIf
	DllCallbackFree($hEnumProc)
	If Not IsArray($__Data) Then
		Return SetError(1, 0, 0)
	EndIf
	__Inc($__Data, -1)
	Return $__Data
EndFunc   ;==>_WinAPI_EnumWindowStations

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EqualMemory
; Description....: Compares two blocks of memory to determine whether the specified number of bytes are identical.
; Syntax.........: _WinAPI_EqualMemory ( $pSource1, $pSource2, $iLength )
; Parameters.....: $pSource1 - A pointer to the block of memory to compare.
;                  $pSource2 - A pointer to the block of memory that is compared to the block of memory to which $pSource1 points.
;                  $iLength  - The number of bytes to be compared.
; Return values..: Success   - 1 - The two memory blocks are equivalent.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ RtlCompareMemory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EqualMemory($pSource1, $pSource2, $iLength)

	Local $Ret = DllCall('ntdll.dll', 'ulong_ptr', 'RtlCompareMemory', 'ptr', $pSource1, 'ptr', $pSource2, 'ulong_ptr', $iLength)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return Number($Ret[0] = $iLength)
EndFunc   ;==>_WinAPI_EqualMemory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EqualRect
; Description....: Determines whether the two specified rectangles are equal.
; Syntax.........: _WinAPI_EqualRect ( $tRECT1, $tRECT2 )
; Parameters.....: $tRECT1 - $tagRECT structure that contains the logical coordinates of the first rectangle.
;                  $tRECT2 - $tagRECT structure that contains the logical coordinates of the second rectangle.
; Return values..: Success - 1 - The two rectangles are identical.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function does not treat empty rectangles as equal if their coordinates are different.
; Related........:
; Link...........: @@MsdnLink@@ EqualRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EqualRect($tRECT1, $tRECT2)

	Local $Ret = DllCall('user32.dll', 'int', 'EqualRect', 'ptr', DllStructGetPtr($tRECT1), 'ptr', DllStructGetPtr($tRECT2))

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_EqualRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_EqualRgn
; Description....: Checks the two specified regions to determine whether they are identical.
; Syntax.........: _WinAPI_EqualRgn ( $hRgn1, $hRgn2 )
; Parameters.....: $hRgn1  - Handle to a region.
;                  $hRgn2  - Handle to a region.
; Return values..: Success - 1 - The two regions are equal.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ EqualRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_EqualRgn($hRgn1, $hRgn2)

	Local $Ret = DllCall('gdi32.dll', 'int', 'EqualRgn', 'ptr', $hRgn1, 'ptr', $hRgn2)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_EqualRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ExcludeClipRect
; Description....: Creates a new clipping region that consists of the existing clipping region minus the specified rectangle.
; Syntax.........: _WinAPI_ExcludeClipRect ( $hDC, $tRECT )
; Parameters.....: $hDC    - Handle to the device context.
;                  $tRECT  - $tagRECT structure that contains the logical coordinates of the specified rectangle.
; Return values..: Success - The value that specifies the new clipping region's complexity; it can be one of the following values.
;
;                            $COMPLEXREGION
;                            $NULLREGION
;                            $SIMPLEREGION
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ExcludeClipRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ExcludeClipRect($hDC, $tRECT)

	Local $Ret = DllCall('gdi32.dll', 'int', 'ExcludeClipRect', 'hwnd', $hDC, 'int', DllStructGetData($tRECT, 1), 'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExcludeClipRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ExtCreatePen
; Description....: Creates a logical cosmetic or geometric pen that has the specified style, width, and brush attributes.
; Syntax.........: _WinAPI_ExtCreatePen ( $iPenStyle, $iWidth, $iBrushStyle, $iRGB [, $iHatch [, $aUserStyle [, $iStart [, $iEnd]]]] )
; Parameters.....: $iPenStyle   - A combination of type, style, end cap, and join attributes. The values from each category are
;                                 combined by using the bitwise operation.
;
;                                 The pen type can be one of the following values.
;
;                                 $PS_GEOMETRIC
;                                 $PS_COSMETIC
;
;                                 The pen style can be one of the following values.
;
;                                 $PS_SOLID
;                                 $PS_DASH
;                                 $PS_DOT
;                                 $PS_DASHDOT
;                                 $PS_DASHDOTDOT
;                                 $PS_NULL
;                                 $PS_INSIDEFRAME
;                                 $PS_USERSTYLE
;                                 $PS_ALTERNATE
;
;                                 The end cap is only specified for geometric pens and can be one of the following values.
;
;                                 $PS_ENDCAP_ROUND
;                                 $PS_ENDCAP_SQUARE
;                                 $PS_ENDCAP_FLAT
;
;                                 The join is only specified for geometric pens and can be one of the following values.
;
;                                 $PS_JOIN_BEVEL
;                                 $PS_JOIN_MITER
;                                 $PS_JOIN_ROUND
;
;                  $iWidth      - The width of the pen. If $PS_GEOMETRIC type is specified, the width is given in logical units,
;                                 otherwise, the width must be set to 1.
;                  $iBrushStyle - A brush style. This parameter can be one of the $BS_* constants.
;                  $iRGB        - The color of a pen, in RGB.
;                  $iHatch      - A hatch style. For more information, see _WinAPI_CreateBrushIndirect().
;                  $aUserStyle  - The array (dash1, space1, dash2, space2, ... dashN, spaceN) that contains the length of the dashes
;                                 and spaces in a user-defined style. The first value specifies the length of the first dash,
;                                 the second value specifies the length of the first space, and so on. This parameter is ignored
;                                 if $PS_USERSTYLE style is not specified. The style count is limited to 16.
;                  $iStart      - The index of array to start filling at.
;                  $iEnd        - The index of array to stop filling at.
; Return values..: Success      - Handle to the logical pen.
;                  Failure      - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After an application creates a pen by calling _WinAPI_ExtCreatePen(), it can select it into any device context by
;                  calling the _WinAPI_SelectObject() function. When an application no longer requires a specified pen, it should
;                  call the _WinAPI_DeleteObject() function to delete the pen.
; Related........:
; Link...........: @@MsdnLink@@ ExtCreatePen
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ExtCreatePen($iPenStyle, $iWidth, $iBrushStyle, $iRGB, $iHatch = 0, $aUserStyle = 0, $iStart = 0, $iEnd = -1)

	Local $Count = 0, $tStyle = 0

	If BitAND($iPenStyle, 0xFF) = 7 Then
		If Not IsArray($aUserStyle) Then
			Return SetError(2, 0, 0)
		EndIf
		If $iStart < 0 Then
			$iStart = 0
		EndIf
		If ($iEnd < 0) Or ($iEnd > UBound($aUserStyle) - 1) Then
			$iEnd = UBound($aUserStyle) - 1
		EndIf
		$tStyle = DllStructCreate('dword[' & ($iEnd - $iStart + 1) & ']')
		If @error Then
			Return SetError(1, 0, 0)
		EndIf
		For $i = $iStart To $iEnd
			DllStructSetData($tStyle, 1, $aUserStyle[$i], $Count + 1)
			$Count += 1
		Next
	EndIf

    Local $tLOGBRUSH = DllStructCreate($tagLOGBRUSH)

	DllStructSetData($tLOGBRUSH, 1, $iBrushStyle)
	DllStructSetData($tLOGBRUSH, 2, __RGB($iRGB))
	DllStructSetData($tLOGBRUSH, 3, $iHatch)

    Local $Ret = DllCall('gdi32.dll', 'ptr', 'ExtCreatePen', 'dword', $iPenStyle, 'dword', $iWidth, 'ptr', DllStructGetPtr($tLOGBRUSH), 'dword', $Count, 'ptr', DllStructGetPtr($tStyle))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtCreatePen

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ExtCreateRegion
; Description....: Creates a region from the specified region and transformation data.
; Syntax.........: _WinAPI_ExtCreateRegion ( $tRGNDATA [, $tXFORM] )
; Parameters.....: $tRGNDATA - $tagRGNDATA structure that contains the region data in logical units.
;                  $tXFORM   - $tagXFORM structure that defines the transformation to be performed on the region.
; Return values..: Success   - The handle to the region.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ExtCreateRegion
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ExtCreateRegion($tRGNDATA, $tXFORM = 0)

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'ExtCreateRegion', 'ptr', DllStructGetPtr($tXFORM), 'dword', DllStructGetSize($tRGNDATA), 'ptr', DllStructGetPtr($tRGNDATA))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtCreateRegion

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ExtFloodFill
; Description....: Fills an area of the display surface with the current brush.
; Syntax.........: _WinAPI_ExtFloodFill ( $hDC, $iX, $iY, $iRGB [, $iType] )
; Parameters.....: $hDC    - Handle to the device context.
;                  $iX     - The x-coordinate, in logical units, of the point where filling is to start.
;                  $iY     - The y-coordinate, in logical units, of the point where filling is to start.
;                  $iRGB   - The color of the boundary or of the area to be filled, in RGB. The interpretation of color depends on
;                            the value of the $iType parameter.
;                  $iType  - The type of fill operation to be performed. This parameter must be one of the following values.
;
;                            $FLOODFILLBORDER
;                            $FLOODFILLSURFACE
;
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ExtFloodFill
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ExtFloodFill($hDC, $iX, $iY, $iRGB, $iType = 0)

	Local $Ret = DllCall('gdi32.dll', 'int', 'ExtFloodFill', 'hwnd', $hDC, 'int', $iX, 'int', $iY, 'dword', __RGB($iRGB), 'uint', $iType)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtFloodFill

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ExtractIcon
; Description....: Extracts an icon from the specified executable file, DLL, or icon file.
; Syntax.........: _WinAPI_ExtractIcon ( $sIcon, $iIndex [, $fSmall] )
; Parameters.....: $sIcon  - The name of an executable file, DLL, or icon file from which icons will be extracted.
;                  $iIndex - The zero-based index of the icon to extract. If this value is a negative number, the function extracts
;                            the icon whose resource identifier is equal to the absolute value of $iIndex.
;                  $fSmall - Specifies whether extract a small icon, valid values:
;                  |TRUE   - Extract a small icon.
;                  |FALSE  - Extract a large icon. (Default)
; Return values..: Success - Handle to the extracted icon.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you are finished using the icon, destroy it using the _WinAPI_DestroyIcon() function.
; Related........:
; Link...........: @@MsdnLink@@ ExtractIconEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ExtractIcon($sIcon, $iIndex, $fSmall = 0)

	Local $pLarge, $pSmall, $tPtr = DllStructCreate('ptr')

	If $fSmall Then
		$pLarge = 0
		$pSmall = DllStructGetPtr($tPtr)
	Else
		$pLarge = DllStructGetPtr($tPtr)
		$pSmall = 0
	EndIf

	Local $Ret = DllCall('shell32.dll', 'uint', 'ExtractIconExW', 'wstr', $sIcon, 'int', $iIndex, 'ptr', $pLarge, 'ptr', $pSmall, 'uint', 1)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return DllStructGetData($tPtr, 1)
EndFunc   ;==>_WinAPI_ExtractIcon

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_ExtSelectClipRgn
; Description....: Combines the specified region with the current clipping region.
; Syntax.........: _WinAPI_ExtSelectClipRgn ( $hDC, $hRgn [, $iMode] )
; Parameters.....: $hDC    - Handle to the device context.
;                  $hRgn   - Handle to the region to be selected. This parameter can only be 0 when the $RGN_COPY mode is specified.
;                  $iMode  - The operation to be performed. It must be one of the following values.
;
;                            $RGN_AND
;                            $RGN_COPY
;                            $RGN_DIFF
;                            $RGN_OR
;                            $RGN_XOR
;
; Return values..: Success - The value that specifies the new clipping region's complexity; it can be one of the following values.
;
;                            $COMPLEXREGION
;                            $NULLREGION
;                            $SIMPLEREGION
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ExtSelectClipRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_ExtSelectClipRgn($hDC, $hRgn, $iMode = 5)

	Local $Ret = DllCall('gdi32.dll', 'int', 'ExtSelectClipRgn', 'hwnd', $hDC, 'ptr', $hRgn, 'int', $iMode)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtSelectClipRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FatalExit
; Description....: Transfers execution control to the debugger.
; Syntax.........: _WinAPI_FatalExit ( $iCode )
; Parameters.....: $iCode - The error code associated with the exit.
; Return values..: None
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FatalExit
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FatalExit($iCode)
	DllCall('kernel32.dll', 'none', 'FatalExit', 'int', $iCode)
EndFunc   ;==>_WinAPI_FatalExit

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FileEncryptionStatus
; Description....: Retrieves the encryption status of the specified file.
; Syntax.........: _WinAPI_FileEncryptionStatus ( $sFile )
; Parameters.....: $sFile  - The name of the file to retrieve encryption status.
; Return values..: Success - The encryption status ($FILE_*).
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FileEncryptionStatus
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FileEncryptionStatus($sFile)

	Local $Ret = DllCall('advapi32.dll', 'int', 'FileEncryptionStatusW', 'wstr', $sFile, 'dword*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, -1)
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_FileEncryptionStatus

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FileExists
; Description....: Tests whether the specified path is existing file.
; Syntax.........: _WinAPI_FileExists ( $sFile )
; Parameters.....: $sFile  - The path to the file to test.
; Return values..: Success - 1 - The path is an existing file.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The function sets the @extended flag to 1 if the specified path is an existing directory (not a file).
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FileExists($sFile)
	If FileExists($sFile) Then
		If _WinAPI_PathIsDirectory($sFile) Then
			Return SetError(0, 1, 0)
		Else
			If @error Then
				Return SetError(1, 0, 0)
			Else
				Return 1
			EndIf
		EndIf
	Else
		Return 0
	EndIf
EndFunc   ;==>_WinAPI_FileExists

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FileInUse
; Description....: Tests whether the specified file in use by another application.
; Syntax.........: _WinAPI_FileInUse ( $sFile )
; Parameters.....: $sFile  - The name of the file to test. If the path specifies a directory, the function fails.
; Return values..: Success - 1 - File in use by another application.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FileInUse($sFile)

	Local $hFile = _WinAPI_CreateFileEx($sFile, 3, 0x80000000)

	If @error Then
		Switch _WinAPI_GetLastError()
			Case 32 ; ERROR_SHARING_VIOLATION
				Return 1
			Case Else
				Return SetError(1, 0, 0)
		EndSwitch
	EndIf
	_WinAPI_CloseHandle($hFile)
	Return 0
EndFunc   ;==>_WinAPI_FileInUse

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FillMemory
; Description....: Fills a block of memory with the given value.
; Syntax.........: _WinAPI_FillMemory ( $pMemory, $iLength [, $iValue] )
; Parameters.....: $pMemory - A pointer to the starting address of a memory to be filled.
;                  $iLength - The number of bytes to be filled.
;                  $iValue  - The value to fill the memory.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ RtlFillMemory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FillMemory($pMemory, $iLength, $iValue = 0)
	DllCall('ntdll.dll', 'none', 'RtlFillMemory', 'ptr', $pMemory, 'ulong_ptr', $iLength, 'byte', $iValue)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FillMemory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FillPath
; Description....: Closes any open figures in the current path and fills the path's interior by using the current brush.
; Syntax.........: _WinAPI_FillPath ( $hDC )
; Parameters.....: $hDC    - Handle to a device context that contains a valid path.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After its interior is filled, the path is discarded from the DC identified by the $hDC parameter.
; Related........:
; Link...........: @@MsdnLink@@ FillPath
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FillPath($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'FillPath', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FillPath

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FillRect
; Description....: Fills a rectangle by using the specified brush.
; Syntax.........: _WinAPI_FillRect ( $hDC, $tRECT, $hBrush )
; Parameters.....: $hDC    - Handle to the device context.
;                  $tRECT  - $tagRECT structure that contains the logical coordinates of the rectangle to be filled.
;                  $hBrush - Handle to the brush used to fill the rectangle.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FillRect
; Example........: Yes
; ===============================================================================================================================

#cs

Func _WinAPI_FillRect($hDC, $tRECT, $hBrush)

	Local $Ret = DllCall('user32.dll', 'int', 'FillRect', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT), 'ptr', $hBrush)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FillRect

#ce

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FillRgn
; Description....: Fills a region by using the specified brush.
; Syntax.........: _WinAPI_FillRgn ( $hDC, $hRgn, $hBrush )
; Parameters.....: $hDC    - Handle to the device context.
;                  $hRgn   - Handle to the region to be filled. The region's coordinates are presumed to be in logical units.
;                  $hBrush - Handle to the brush to be used to fill the region.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FillRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FillRgn($hDC, $hRgn, $hBrush)

	Local $Ret = DllCall('gdi32.dll', 'int', 'FillRgn', 'hwnd', $hDC, 'ptr', $hRgn, 'ptr', $hBrush)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FillRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindClose
; Description....: Closes a file search handle.
; Syntax.........: _WinAPI_FindClose ( $hSearch )
; Parameters.....: $hSearch - The file search handle opened by the _WinAPI_FindFirst... functions.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FindClose
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindClose($hSearch)

	Local $Ret = DllCall('kernel32.dll', 'int', 'FindClose', 'ptr', $hSearch)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FindClose

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindCloseChangeNotification
; Description....: Stops change notification handle monitoring.
; Syntax.........: _WinAPI_FindCloseChangeNotification ( $hChange )
; Parameters.....: $hChange - A handle to a change notification handle created by the _WinAPI_FindFirstChangeNotification() function.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FindCloseChangeNotification
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindCloseChangeNotification($hChange)

	Local $Ret = DllCall('kernel32.dll', 'int', 'FindCloseChangeNotification', 'ptr', $hChange)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FindCloseChangeNotification

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindFirstChangeNotification
; Description....: Creates a change notification handle and sets up initial change notification filter conditions.
; Syntax.........: _WinAPI_FindFirstChangeNotification ( $sDirectory, $iFlags [, $fSubtree] )
; Parameters.....: $sDirectory - The full path of the directory to be watched.
;                  $iFilter    - The filter conditions that satisfy a change notification wait. This parameter can be one or more of the
;                                following values.
;
;                                $FILE_NOTIFY_CHANGE_FILE_NAME
;                                $FILE_NOTIFY_CHANGE_DIR_NAME
;                                $FILE_NOTIFY_CHANGE_ATTRIBUTES
;                                $FILE_NOTIFY_CHANGE_SIZE
;                                $FILE_NOTIFY_CHANGE_LAST_WRITE
;                                $FILE_NOTIFY_CHANGE_SECURITY
;
;                  $fSubtree   - Specifies whether to monitor the subdirectories of the specified directory, valid values:
;                  |TRUE  - Monitor the directory tree rooted at the specified directory.
;                  |FALSE - Monitor only the specified directory. (Default)
; Return values..: Success     - A handle to a find change notification object.
;                  Failure     - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_Wait... functions can monitor the specified directory or subtree by using the handle returned by this
;                  function. A wait is satisfied when one of the filter conditions occurs in the monitored directory or subtree.
;
;                  After the wait has been satisfied, the application can respond to this condition and continue monitoring the directory
;                  by calling the _WinAPI_FindNextChangeNotification() function and the appropriate wait function. When the handle is
;                  no longer needed, it can be closed by using the _WinAPI_FindCloseChangeNotification() function.
;
;                  Notifications may not be returned when calling _WinAPI_FindFirstChangeNotification() for a remote file system.
; Related........:
; Link...........: @@MsdnLink@@ FindFirstChangeNotification
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindFirstChangeNotification($sDirectory, $iFilter, $fSubtree = 0)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'FindFirstChangeNotificationW', 'wstr', $sDirectory, 'int', $fSubtree, 'dword', $iFilter)

	If (@error) Or ($Ret[0] = Ptr(-1)) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindFirstChangeNotification

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindFirstFile
; Description....: Searches a directory for a file or subdirectory with a name that matches a specific name.
; Syntax.........: _WinAPI_FindFirstFile ( $sPath, $pData )
; Parameters.....: $sPath  - The directory or path, and the file name, which can include wildcard characters, for example, an asterisk
;                            "*" or a question mark "?". If the string ends with a wildcard, period ".", or directory name, the user
;                            must have access permissions to the root and all subdirectories on the path.
;                  $pData  - A pointer to the $tagWIN32_FIND_DATA structure that receives information about a found file or directory.
; Return values..: Success - The search handle.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function opens a search handle and returns information about the first file that the file system finds with
;                  a name that matches the specified pattern. This may or may not be the first file or directory that appears in
;                  a directory-listing application when given the same file name string pattern.
;
;                  After the search handle is established, you can use it to search for other files that match the same pattern by
;                  using the _WinAPI_FindNextFile() function.
;
;                  If the function fails because no matching files can be found, the @extended flag will contain ERROR_FILE_NOT_FOUND (2)
;                  system error code.
;
;                  When the search handle is no longer needed, close it by using the _WinAPI_FindClose() function.
; Related........:
; Link...........: @@MsdnLink@@ FindFirstFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindFirstFile($sPath, $pData)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'FindFirstFileW', 'wstr', $sPath, 'ptr', $pData)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] = Ptr(-1) Then
			Return SetError(1, _WinAPI_GetLastError(), 0)
		EndIf
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindFirstFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindFirstFileName
; Description....: Creates an enumeration of all the hard links to the specified file.
; Syntax.........: _WinAPI_FindFirstFileName ( $sPath, ByRef $sLink )
; Parameters.....: $sPath  - The name of the file.
;                  $sLink  - The first link name found for the specified file.
; Return values..: Success - The search handle.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: After the search handle has been established, use it in the _WinAPI_FindNextFileName() function to search for
;                  other hard links to the specified file.
;
;                  When the search handle is no longer needed, it should be closed using the _WinAPI_FindClose() function.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ FindFirstFileNameW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindFirstFileName($sPath, ByRef $sLink)

	$sLink = ''

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'FindFirstFileNameW', 'wstr', $sPath, 'dword', 0, 'dword*', 4096, 'wstr', '')

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] = Ptr(-1) Then
			Return SetError(1, _WinAPI_GetLastError(), 0)
		EndIf
	EndIf
	$sLink = $Ret[4]
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindFirstFileName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindFirstStream
; Description....: Enumerates the first stream with a ::$DATA stream type in the specified file or directory.
; Syntax.........: _WinAPI_FindFirstStream ( $sPath, $pData )
; Parameters.....: $sPath  - The fully-qualified file name.
;                  $pData  - A pointer to the $tagWIN32_FIND_STREAM_DATA structure that receives information about the stream.
; Return values..: Success - The search handle.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function function opens a search handle and returns information about the first stream in the specified file
;                  or directory. For files, this is always the default data stream, "::$DATA". After the search handle has been established,
;                  use it in the _WinAPI_FindNextStream() function to search for other streams in the specified file or directory.
;
;                  If the function fails because no streams can be found, the @extended flag will contain ERROR_HANDLE_EOF (38)
;                  system error code.
;
;                  When the search handle is no longer needed, it should be closed using the _WinAPI_FindClose() function.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ FindFirstStreamW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindFirstStream($sPath, $pData)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'FindFirstStreamW', 'wstr', $sPath, 'uint', 0, 'ptr', $pData, 'dword', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] = Ptr(-1) Then
			Return SetError(1, _WinAPI_GetLastError(), 0)
		EndIf
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindFirstStream

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindNextChangeNotification
; Description....: Requests that the operating system signal a change notification handle the next time it detects an appropriate change.
; Syntax.........: _WinAPI_FindNextChangeNotification ( $hChange )
; Parameters.....: $hChange - A handle to a change notification handle created by the _WinAPI_FindFirstChangeNotification() function.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After the _WinAPI_FindNextChangeNotification() function returns successfully, the application can wait for
;                  notification that a change has occurred by using the _WinAPI_Wait... functions.
;
;                  The _WinAPI_FindNextChangeNotification() function should not be used more than once on the same handle without using
;                  one of the wait functions. An application may miss a change notification if it uses _WinAPI_FindNextChangeNotification()
;                  when there is a change request outstanding.
; Related........:
; Link...........: @@MsdnLink@@ FindNextChangeNotification
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindNextChangeNotification($hChange)

	Local $Ret = DllCall('kernel32.dll', 'int', 'FindNextChangeNotification', 'ptr', $hChange)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FindNextChangeNotification

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindNextFile
; Description....: Continues a file or directory search.
; Syntax.........: _WinAPI_FindNextFile ( $hSearch, $pData )
; Parameters.....: $hSearch - The search handle returned by a previous call to the _WinAPI_FindFirstFile() function.
;                  $pData   - A pointer to the $tagWIN32_FIND_DATA structure that receives information about a found file or directory.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The order in which the search returns the files, such as alphabetical order, is not guaranteed. If the data
;                  must be sorted, the application must do the ordering after obtaining all the results.
;
;                  If the function fails because no more matching files can be found, the @extended flag will contain
;                  ERROR_NO_MORE_FILES (18) system error code.
; Related........:
; Link...........: @@MsdnLink@@ FindNextFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindNextFile($hSearch, $pData)

	Local $Ret = DllCall('kernel32.dll', 'int', 'FindNextFileW', 'ptr', $hSearch, 'ptr', $pData)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If Not $Ret[0] Then
			Return SetError(1, _WinAPI_GetLastError(), 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FindNextFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindNextFileName
; Description....: Continues enumerating the hard links.
; Syntax.........: _WinAPI_FindNextFileName ( $hSearch, ByRef $sLink )
; Parameters.....: $hSearch - A handle to the enumeration that is returned by a successful call to _WinAPI_FindFirstFileName() function.
;                  $sLink   - The next link name that was found.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the function fails because no matching files can be found,, the @extended flag will contain ERROR_HANDLE_EOF (38)
;                  system error code.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ FindNextFileNameW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindNextFileName($hSearch, ByRef $sLink)

	$sLink = ''

	Local $Ret = DllCall('kernel32.dll', 'int', 'FindNextFileNameW', 'ptr', $hSearch, 'dword*', 4096, 'wstr', '')

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If Not $Ret[0] Then
			Return SetError(1, _WinAPI_GetLastError(), 0)
		EndIf
	EndIf
	$sLink = $Ret[3]
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindNextFileName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindNextStream
; Description....: Continues a stream search.
; Syntax.........: _WinAPI_FindNextStream ( $hSearch, $pData )
; Parameters.....: $hSearch - The search handle returned by a previous call to the _WinAPI_FindFirstStream() function.
;                  $pData   - A pointer to the $tagWIN32_FIND_STREAM_DATA structure that receives information about the stream.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the function fails because no more streams can be found, the @extended flag will contain ERROR_HANDLE_EOF (38)
;                  system error code.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ FindNextStreamW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindNextStream($hSearch, $pData)

	Local $Ret = DllCall('kernel32.dll', 'int', 'FindNextStreamW', 'ptr', $hSearch, 'ptr', $pData)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If Not $Ret[0] Then
			Return SetError(1, _WinAPI_GetLastError(), 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FindNextStream

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindResource
; Description....: Determines the location of a resource with the specified type and name in the specified module.
; Syntax.........: _WinAPI_FindResource ( $hInstance, $sType, $sName )
; Parameters.....: $hInstance - Handle to the module whose executable file contains the resource. A value of 0 specifies the module
;                               handle associated with the image file that the operating system used to create the current process.
;                  $sType     - The type of the resource. This parameter can be string or integer value.
;                  $sName     - The name of the resource. This parameter can be string or integer value.
; Return values..: Success    - Handle to the specified resource's information block. To obtain a handle to the resource, pass this
;                               handle to the _WinAPI_LoadResource() function.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the first character of the string of the $sName or $sType parameter is a pound sign (#), the remaining
;                  characters represent a decimal number that specifies the integer identifier of the resource's name or type.
;                  For example, the string "#258" represents the integer identifier 258.
;
;                  To reduce the amount of memory required for a resource, an application should refer to it by integer identifier
;                  instead of by name.
;
;                  An application can use _WinAPI_FindResource() to find any type of resource, but this function should be used
;                  only if the application must access the binary resource data when making subsequent calls to _WinAPI_LockResource().
; Related........:
; Link...........: @@MsdnLink@@ FindResource
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindResource($hInstance, $sType, $sName)

	Local $TypeOfType = 'int', $TypeOfName = 'int'

	If IsString($sType) Then
		$TypeOfType = 'wstr'
	EndIf
	If IsString($sName) Then
		$TypeOfName = 'wstr'
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'FindResourceW', 'ptr', $hInstance, $TypeOfName, $sName, $TypeOfType, $sType)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindResource

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindResourceEx
; Description....: Determines the location of the resource with the specified type, name, and language in the specified module.
; Syntax.........: _WinAPI_FindResourceEx ( $hInstance, $sType, $sName, $iLanguage )
; Parameters.....: $hInstance - Handle to the module whose executable file contains the resource. A value of 0 specifies the module
;                               handle associated with the image file that the operating system used to create the current process.
;                  $sType     - The type of the resource. This parameter can be string or integer value.
;                  $sName     - The name of the resource. This parameter can be string or integer value.
;                  $iLanguage - The language of the resource.
; Return values..: Success    - Handle to the specified resource's information block. To obtain a handle to the resource, pass this
;                               handle to the _WinAPI_LoadResource() function.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the first character of the string of the $sName or $sType parameter is a pound sign (#), the remaining
;                  characters represent a decimal number that specifies the integer identifier of the resource's name or type.
;                  For example, the string "#258" represents the integer identifier 258.
;
;                  To reduce the amount of memory required for a resource, an application should refer to it by integer identifier
;                  instead of by name.
;
;                  An application can use _WinAPI_FindResource() to find any type of resource, but this function should be used
;                  only if the application must access the binary resource data when making subsequent calls to _WinAPI_LockResource().
; Related........:
; Link...........: @@MsdnLink@@ FindResourceEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindResourceEx($hInstance, $sType, $sName, $iLanguage)

	Local $TypeOfType = 'int', $TypeOfName = 'int'

	If IsString($sType) Then
		$TypeOfType = 'wstr'
	EndIf
	If IsString($sName) Then
		$TypeOfName = 'wstr'
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'FindResourceExW', 'ptr', $hInstance, $TypeOfType, $sType, $TypeOfName, $sName, 'ushort', $iLanguage)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindResourceEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindTextDlg
; Description....: Creates a system-defined modeless Find dialog box to search for text in a document.
; Syntax.........: _WinAPI_FindTextDlg ( $hOwner [, $sFindWhat [, $iFlags [, $pFindProc [, $lParam]]]] )
; Parameters.....: $hOwner    - A handle to the window that owns the dialog box. The window procedure of the specified window
;                               receives FINDMSGSTRING messages from the dialog box. This parameter can be any valid window handle,
;                               but it must not be 0.
;                  $sFindWhat - The search string that is displayed when you initialize the dialog box.
;                  $iFlags    - A set of bit flags that used to initialize the dialog box. The dialog box sets these flags when it
;                               sends the FINDMSGSTRING registered message to indicate the user's input. This parameter can be one
;                               or more of the following values.
;
;                               $FR_DIALOGTERM
;                               $FR_DOWN
;                               $FR_ENABLEHOOK
;                               $FR_ENABLETEMPLATE
;                               $FR_ENABLETEMPLATEHANDLE
;                               $FR_FINDNEXT
;                               $FR_HIDEUPDOWN
;                               $FR_HIDEMATCHCASE
;                               $FR_HIDEWHOLEWORD
;                               $FR_MATCHCASE
;                               $FR_NOMATCHCASE
;                               $FR_NOUPDOWN
;                               $FR_NOWHOLEWORD
;                               $FR_REPLACE
;                               $FR_REPLACEALL
;                               $FR_SHOWHELP
;                               $FR_WHOLEWORD
;
;                  $pFindProc - Pointer to an hook procedure that can process messages intended for the dialog box. This parameter is
;                               ignored unless the $FR_ENABLEHOOK flag is not set.
;
;                               (See MSDN for more information)
;
;                  $lParam    - Application-defined data that the system passes to the hook procedure.
; Return values..: Success    - The window handle to the dialog box.
;                  Failure    - 0 and sets the @error flag to non-zero, @extended flag may contain the dialog box error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_FindText() does not perform a search operation. Instead, the dialog box sends FINDMSGSTRING registered
;                  messages to the window procedure of the owner window of the dialog box.
;
;                  Before calling _WinAPI_FindText(), you must call the _WinAPI_RegisterWindowMessage() function to get the identifier
;                  for the FINDMSGSTRING message. The dialog box procedure uses this identifier to send messages when the user clicks the
;                  "Find Next" button, or when the dialog box is closing. The "lParam" parameter of the FINDMSGSTRING message contains
;                  a pointer to a $tagFINDREPLACE structure. The "Flags" member of this structure indicates the event that caused the
;                  message. Other members of the structure indicate the user's input.
;
;                  The _WinAPI_FindText() uses an internal buffer to hold the string that the user typed in the "Find What" edit controls.
;                  You can increase the size of this buffer by using the _WinAPI_SetFRBuffer() function. In addition to free the memory
;                  allocated for the internal buffer, you must call the _WinAPI_FlushFRBuffer() in response to the FINDMSGSTRING
;                  message with $FR_DIALOGTERM flag set.
; Related........:
; Link...........: @@MsdnLink@@ FindText
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FindTextDlg($hOwner, $sFindWhat = '', $iFlags = 0, $pFindProc = 0, $lParam = 0)

	$__Text = __HeapReAlloc($__Text, 2 * $__Buff)
	If @error Then
		Return SetError(9, 0, 0)
	EndIf
	DllStructSetData(DllStructCreate('wchar[' & $__Buff & ']', $__Text), 1, StringLeft($sFindWhat, $__Buff - 1))
	$__FR = DllStructCreate($tagFINDREPLACE)
	DllStructSetData($__FR, 'Size', DllStructGetSize($__FR))
	DllStructSetData($__FR, 'hOwner', $hOwner)
	DllStructSetData($__FR, 'hInstance', 0)
	DllStructSetData($__FR, 'Flags', $iFlags)
	DllStructSetData($__FR, 'FindWhat', $__Text)
	DllStructSetData($__FR, 'ReplaceWith', 0)
	DllStructSetData($__FR, 'FindWhatLen', 2 * $__Buff)
	DllStructSetData($__FR, 'ReplaceWithLen', 0)
	DllStructSetData($__FR, 'lParam', $lParam)
	DllStructSetData($__FR, 'Hook', $pFindProc)
	DllStructSetData($__FR, 'TemplateName', 0)

	Local $Ret = DllCall('comdlg32.dll', 'hwnd', 'FindTextW', 'ptr', DllStructGetPtr($__FR))

	If (@error) Or (Not $Ret[0]) Then
		__HeapFree($__Text)
		If IsArray($Ret) Then
			Return SetError(1, _WinAPI_CommDlgExtendedErrorEx(), 0)
		Else
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_FindTextDlg

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FlattenPath
; Description....: Transforms any curves in the path that is selected into the current DC, turning each curve into a sequence of lines.
; Syntax.........: _WinAPI_FlattenPath ( $hDC )
; Parameters.....: $hDC    - Handle to a device context that contains a valid path.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FlattenPath
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FlattenPath($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'FlattenPath', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FlattenPath

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FloatToDWord
; Description....: Converts a value of type FLOAT to a value of type DWORD.
; Syntax.........: _WinAPI_FloatToDWord ( $iValue )
; Parameters.....: $iValue - The value to be converted.
; Return values..: The converted (DWORD) value.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FloatToDWord($iValue)

	Local $tFloat = DllStructCreate('float')
	Local $tDWord = DllStructCreate('dword', DllStructGetPtr($tFloat))

	DllStructSetData($tFloat, 1, $iValue)

	Return DllStructGetData($tDWord, 1)
EndFunc   ;==>_WinAPI_FloatToDWord

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FlushFRBuffer
; Description....: Destroys the internal buffer that used the _WinAPI_FindTextDlg() and _WinAPI_ReplaceTextDlg() functions.
; Syntax.........: _WinAPI_FlushFRBuffer ( )
; Parameters.....: None
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_FlushFRBuffer() can be called only in response to the FINDMSGSTRING message with $FR_DIALOGTERM flag set.
;                  For more information, see _WinAPI_FindTextDlg() and _WinAPI_ReplaceTextDlg() functions.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FlushFRBuffer()
	If Not __HeapFree($__Text, 1) Then
		Return SetError(@error, @extended, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FlushFRBuffer

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FlushViewOfFile
; Description....: Writes to the disk a byte range within a mapped view of a file.
; Syntax.........: _WinAPI_FlushViewOfFile ( $pAddress [, $iBytes] )
; Parameters.....: $pAddress - A pointer to the base address of the byte range to be flushed to the disk representation of the mapped file.
;                  $iBytes   - The number of bytes to be flushed. If $iBytes is 0, the file is flushed from the base address to the
;                              end of the mapping.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FlushViewOfFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FlushViewOfFile($pAddress, $iBytes = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'FlushViewOfFile', 'ptr', $pAddress, 'dword', $iBytes)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FlushViewOfFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FormatDriveDlg
; Description....: Opens the Shell's Format dialog.
; Syntax.........: _WinAPI_FormatDriveDlg ( $sDrive [, $iOption [, $hParent]] )
; Parameters.....: $sDrive  - The drive to format, in the format D:, E:, etc.
;                  $iOption - This parameter must be 0 or one of the following values that alter the default format options in the dialog.
;
;                             $SHFMT_OPT_FULL
;                             $SHFMT_OPT_QUICKFORMAT
;                             $SHFMT_OPT_SYSONLY
;
;                  $hParent - Handle of the parent window of the dialog.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to one of the following constant.
;
;                             $SHFMT_ERROR
;                             $SHFMT_CANCEL
;                             $SHFMT_NOFORMAT
;
; Author.........: Yashied
; Modified.......:
; Remarks........: The format is controlled by the dialog interface. That is, the user must click the OK button to actually begin the
;                  formatthe format cannot be started programmatically.
; Related........:
; Link...........: @@MsdnLink@@ SHFormatDrive
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FormatDriveDlg($sDrive, $iOption = 0, $hParent = 0)

	If Not IsString($sDrive) Then
		Return SetError(-1, 0, 0)
	EndIf
	$sDrive = StringLeft(StringUpper(StringStripWS($sDrive, 1)), 1)
	If Not $sDrive Then
		Return SetError(-1, 0, 0)
	EndIf
	$sDrive = Asc($sDrive) - 65
	If ($sDrive < 0) Or ($sDrive > 25) Then
		Return SetError(-1, 0, 0)
	EndIf

	Local $Ret = DllCall('shell32.dll', 'int', 'SHFormatDrive', 'hwnd', $hParent, 'uint', $sDrive, 'uint', 0xFFFF, 'uint', $iOption)

	If @error Then
		Return SetError(-1, 0, 0)
	Else
		If $Ret[0] < 0 Then
			Return SetError($Ret[0], 0, 0)
		EndIf
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FormatDriveDlg

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FrameRect
; Description....: Draws a border around the specified rectangle by using the specified brush.
; Syntax.........: _WinAPI_FrameRect ( $hDC, $tRECT, $hBrush )
; Parameters.....: $hDC    - Handle to the device context in which the border is drawn.
;                  $tRECT  - $tagRECT structure that contains the logical coordinates of the upper-left and lower-right
;                            corners of the rectangle.
;                  $hBrush - Handle to the brush used to draw the border.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FrameRect
; Example........: Yes
; ===============================================================================================================================

#cs

Func _WinAPI_FrameRect($hDC, $tRECT, $hBrush)

	Local $Ret = DllCall('user32.dll', 'int', 'FrameRect', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT), 'ptr', $hBrush)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FrameRect

#ce

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FrameRgn
; Description....: Draws a border around the specified region by using the specified brush.
; Syntax.........: _WinAPI_FrameRgn ( $hDC, $hRgn, $hBrush, $iWidth, $iHeight )
; Parameters.....: $hDC     - Handle to the device context.
;                  $hRgn    - Handle to the region to be enclosed in a border. The region's coordinates are presumed to be in
;                             logical units.
;                  $hBrush  - Handle to the brush to be used to draw the border.
;                  $iWidth  - The width, in logical units, of vertical brush strokes.
;                  $iHeight - The height, in logical units, of horizontal brush strokes.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FrameRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FrameRgn($hDC, $hRgn, $hBrush, $iWidth, $iHeight)

	Local $Ret = DllCall('gdi32.dll', 'int', 'FrameRgn', 'hwnd', $hDC, 'ptr', $hRgn, 'ptr', $hBrush, 'int', $iWidth, 'int', $iHeight)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FrameRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FreeMemory
; Description....: Frees a memory block in the internal library heap.
; Syntax.........: _WinAPI_FreeMemory ( $pMemory )
; Parameters.....: $pMemory - A pointer to the valid memory block to be freed.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_FreeMemory() function accepts only the pointers returned by some _WinAPI_* functions (see description).
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FreeMemory($pMemory)
	If Not __HeapFree($pMemory, 1) Then
		Return SetError(@error, @extended, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FreeMemory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FreeMRUList
; Description....: Frees the handle associated with the most recently used (MRU) list and writes cached data to the registry.
; Syntax.........: _WinAPI_FreeMRUList ( $hMRU )
; Parameters.....: $hMRU   - Handle of the MRU list to free.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FreeMRUList
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FreeMRUList($hMRU)

	Local $Ret = DllCall('comctl32.dll ', 'int', 'FreeMRUList', 'ptr', $hMRU)

	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FreeMRUList

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FreeResource
; Description....: Decrements (decreases by one) the reference count of a loaded resource.
; Syntax.........: _WinAPI_FreeResource ( $hData )
; Parameters.....: $hData  - Handle of the resource was created by _WinAPI_LoadResource().
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The reference count for a resource is incremented (increased by one) each time an application calls the
;                  _WinAPI_LoadResource() function for the resource. This function is obsolete and is only supported for backward
;                  compatibility with 16-bit Microsoft Windows. For 32-bit Windows applications, it is not necessary to free the
;                  resources loaded using function _WinAPI_LoadResource().
; Related........:
; Link...........: @@MsdnLink@@ FreeResource
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_FreeResource($hData)

	Local $Ret = DllCall('kernel32.dll', 'int', 'FreeResource', 'ptr', $hData)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_FreeResource

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GdiComment
; Description....: Copies a comment from a buffer into a specified enhanced-format metafile.
; Syntax.........: _WinAPI_GdiComment ( $hDC, $pBuffer, $iSize )
; Parameters.....: $hDC     - Handle to an enhanced-metafile device context.
;                  $pBuffer - A pointer to the buffer that contains the comment.
;                  $iSize   - The length of the comment buffer, in bytes.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GdiComment
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GdiComment($hDC, $pBuffer, $iSize)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GdiComment', 'hwnd', $hDC, 'uint', $iSize, 'ptr', $pBuffer)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_GdiComment

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetActiveWindow
; Description....: Retrieves the window handle to the active window attached to the calling process's message queue.
; Syntax.........: _WinAPI_GetActiveWindow ( )
; Parameters.....: None
; Return values..: Success - Handle to the active window attached to the calling process's message queue.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetActiveWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetActiveWindow()

	Local $Ret = DllCall('user32.dll', 'hwnd', 'GetActiveWindow')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetActiveWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetAllUsersProfileDirectory
; Description....: Retrieves the path to the root of the directory that contains program data shared by all users.
; Syntax.........: _WinAPI_GetAllUsersProfileDirectory ( )
; Parameters.....: None
; Return values..: Success - The path to the directory.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetAllUsersProfileDirectory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetAllUsersProfileDirectory()

	Local $Ret = DllCall('userenv.dll', 'int', 'GetAllUsersProfileDirectoryW', 'wstr', '', 'dword*', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[1]
EndFunc   ;==>_WinAPI_GetAllUsersProfileDirectory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetApplicationRestartSettings
; Description....: Retrieves the restart information registered for the specified process.
; Syntax.........: _WinAPI_GetApplicationRestartSettings ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The restart command line.
;                            [1] - The flags.
;
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This information is available only for the current process; you cannot call _WinAPI_GetApplicationRestartSettings()
;                  function after your program is restarted to get the restart command line.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetApplicationRestartSettings
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetApplicationRestartSettings($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000410, 0x00001010), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'uint', 'GetApplicationRestartSettings', 'ptr', $hProcess[0], 'wstr', '', 'dword*', 4096, 'dword*', 0)

	If @error Then
		$Ret = 0
	Else
		If $Ret[0] Then
			$Ret = $Ret[0]
		EndIf
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, $Ret, 0)
	EndIf

	Local $Result[2]

	$Result[0] = $Ret[2]
	$Result[1] = $Ret[4]

	Return $Result
EndFunc   ;==>_WinAPI_GetApplicationRestartSettings

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetArcDirection
; Description....: Retrieves the current arc direction for the specified device context.
; Syntax.........: _WinAPI_GetArcDirection ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The current arc direction ($AD_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetArcDirection
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetArcDirection($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetArcDirection', 'hwnd', $hDC)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		Switch $Ret[0]
			Case 1, 2

			Case Else
				Return SetError(1, 0, 0)
		EndSwitch
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetArcDirection

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetAsyncKeyState
; Description....: Determines whether a key is up or down at the time the function is called.
; Syntax.........: _WinAPI_GetAsyncKeyState ( $vKey )
; Parameters.....: $vKey   - The virtual-key code ($VK_*).
; Return values..: Success - If the 16th (15) bit is set, the key is down, and if the 1st (0) bit is set, the key was pressed
;                            after the previous call to _WinAPI_GetAsyncKeyState().
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Although the least significant bit of the return value indicates whether the key has been pressed since the last
;                  query, due to the pre-emptive multitasking nature of Windows, another application can call _WinAPI_GetAsyncKeyState()
;                  and receive the "recently pressed" bit instead of your application.
;
;                  You can use the virtual-key code constants $VK_SHIFT, $VK_CONTROL, and $VK_MENU as values for the $vKey parameter.
;                  This gives the state of the SHIFT, CTRL, or ALT keys without distinguishing between left and right.
; Related........:
; Link...........: @@MsdnLink@@ GetAsyncKeyState
; Example........: Yes
; ===============================================================================================================================

#cs

Func _WinAPI_GetAsyncKeyState($vKey)

	Local $Ret = DllCall('user32.dll', 'short', 'GetAsyncKeyState', 'int', $vKey)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return BitAND($Ret[0], 0x8001)
EndFunc   ;==>_WinAPI_GetAsyncKeyState

#ce

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBinaryType
; Description....: Determines whether a file is an executable (.exe) file, and if so, which subsystem runs the executable file.
; Syntax.........: _WinAPI_GetBinaryType ( $sPath )
; Parameters.....: $sPath  - The full path of the file whose executable type is to be determined.
; Return values..: Success - 1 - The file is executable, @extended flag will be contain one of the $SCS_* constants to
;                                indicate the file's executable type.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetBinaryType
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBinaryType($sPath)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetBinaryTypeW', 'wstr', $sPath, 'dword*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	If Not $Ret[0] Then
		$Ret[2] = 0
	EndIf
	Return SetError(0, $Ret[2], $Ret[0])
EndFunc   ;==>_WinAPI_GetBinaryType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBitmapBits
; Description....: Copies the bitmap bits of a specified device-dependent bitmap into a buffer.
; Syntax.........: _WinAPI_GetBitmapBits ( $hBitmap, $iSize, $pBits )
; Parameters.....: $hBitmap - Handle to the device-dependent bitmap.
;                  $iSize   - The number of bytes to copy from the bitmap into the buffer.
;                  $pBits   - A pointer to a buffer to receive the bitmap bits.
; Return values..: Success  - The number of bytes copied to the buffer.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetBitmapBits
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBitmapBits($hBitmap, $iSize, $pBits)

	Local $Ret = DllCall('gdi32.dll', 'dword', 'GetBitmapBits', 'ptr', $hBitmap, 'dword', $iSize, 'ptr', $pBits)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetBitmapBits

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBitmapDimension
; Description....: Retrieves a dimension of the specified bitmap.
; Syntax.........: _WinAPI_GetBitmapDimension ( $hBitmap )
; Parameters.....: $hBitmap - Handle to the bitmap to retrieve dimension.
; Return values..: Success  - $tagSIZE structure that contains the bitmap dimension, in pixels.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBitmapDimension($hBitmap)

    Local $tObj = DllStructCreate($tagBITMAP)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetObject', 'int', $hBitmap, 'int', DllStructGetSize($tObj), 'ptr', DllStructGetPtr($tObj))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tSIZE = DllStructCreate($tagSIZE)

	DllStructSetData($tSIZE, 1, DllStructGetData($tObj, 'bmWidth'))
	DllStructSetData($tSIZE, 2, DllStructGetData($tObj, 'bmHeight'))

	Return $tSIZE
EndFunc   ;==>_WinAPI_GetBitmapDimension

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBitmapDimensionEx
; Description....: Retrieves the dimensions of a compatible bitmap.
; Syntax.........: _WinAPI_GetBitmapDimensionEx ( $hBitmap )
; Parameters.....: $hBitmap - Handle to a compatible bitmap (DDB).
; Return values..: Success  - $tagSIZE structure that contains fields for the height and width of the bitmap, in .01-mm units.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the dimensions have not yet been set, the structure that is returned will have zeros in those fields.
; Related........:
; Link...........: @@MsdnLink@@ GetBitmapDimensionEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBitmapDimensionEx($hBitmap)

	Local $tSIZE = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetBitmapDimensionEx', 'ptr', $hBitmap, 'ptr', DllStructGetPtr($tSIZE))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tSIZE
EndFunc   ;==>_WinAPI_GetBitmapDimensionEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBkColor
; Description....: Retrieves the current background color for the specified device context.
; Syntax.........: _WinAPI_GetBkColor ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The value of the current background color, in RGB.
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetBkColor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBkColor($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetBkColor', 'hwnd', $hDC)

	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, -1)
	EndIf
	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_GetBkColor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBoundsRect
; Description....: Obtains the current accumulated bounding rectangle for a specified device context.
; Syntax.........: _WinAPI_GetBoundsRect ( $hDC [, $iFlags] )
; Parameters.....: $hDC    - Handle to the device context whose bounding rectangle the function will return.
;                  $iFlags - The flags that specifies how the function will behave. This parameter can be the following value.
;
;                            $DCB_RESET
;
; Return values..: Success - $tagRECT structure that contains the current bounding rectangle, @extended flag will contain the
;                            value specifies the state of the accumulated bounding rectangle ($DCB_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetBoundsRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBoundsRect($hDC, $iFlags = 0)

	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetBoundsRect', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT), 'uint', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, $Ret[0], $tRECT)
EndFunc   ;==>_WinAPI_GetBoundsRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBufferedPaintBits
; Description....: Retrieves a pointer to the buffer bitmap if the buffer is a device-independent bitmap (DIB).
; Syntax.........: _WinAPI_GetBufferedPaintBits ( $hBP )
; Parameters.....: $hBP    - Handle of the buffered paint context.
; Return values..: Success - A pointer to the address of the buffer bitmap pixels, @extended flag will contain the width of the buffer bitmap, in pixels.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetBufferedPaintBits
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBufferedPaintBits($hBP)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetBufferedPaintBits', 'ptr', $hBP, 'ptr*', 0, 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return SetError(0, $Ret[3], $Ret[2])
EndFunc   ;==>_WinAPI_GetBufferedPaintBits

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBufferedPaintDC
; Description....: Gets the paint device context (DC).
; Syntax.........: _WinAPI_GetBufferedPaintDC ( $hBP )
; Parameters.....: $hBP    - Handle of the buffered paint context.
; Return values..: Success - Handle of the requested DC. This is the same DC that is returned by _WinAPI_BeginBufferedPaint().
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetBufferedPaintDC
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBufferedPaintDC($hBP)

	Local $Ret = DllCall('uxtheme.dll', 'hwnd', 'GetBufferedPaintDC', 'ptr', $hBP)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetBufferedPaintDC

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBufferedPaintTargetDC
; Description....: Retrieves the target device context (DC).
; Syntax.........: _WinAPI_GetBufferedPaintTargetDC ( $hBP )
; Parameters.....: $hBP    - Handle of the buffered paint context.
; Return values..: Success - Handle of the requested DC. This is the same DC that was passed to _WinAPI_BeginBufferedPaint().
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetBufferedPaintTargetDC
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBufferedPaintTargetDC($hBP)

	Local $Ret = DllCall('uxtheme.dll', 'hwnd', 'GetBufferedPaintTargetDC', 'ptr', $hBP)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetBufferedPaintTargetDC

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBufferedPaintTargetRect
; Description....: Retrieves the target rectangle.
; Syntax.........: _WinAPI_GetBufferedPaintTargetRect ( $hBP )
; Parameters.....: $hBP    - Handle of the buffered paint context.
; Return values..: Success - $tagRECT structure that contains the rectangle specified by _WinAPI_BeginBufferedPaint() function.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetBufferedPaintTargetRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBufferedPaintTargetRect($hBP)

	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetBufferedPaintTargetRect', 'ptr', $hBP, 'ptr', DllStructGetPtr($tRECT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tRECT
EndFunc   ;==>_WinAPI_GetBufferedPaintTargetRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetBValue
; Description....: Retrieves an intensity value for the blue component of a 32-bit RGB value.
; Syntax.........: _WinAPI_GetBValue ( $iRGB )
; Parameters.....: $iRGB - The color value, in RGB.
; Return values..: The intensity of the blue component of the specified RGB color.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetBValue($iRGB)
	Return BitShift(BitAND(__RGB($iRGB), 0xFF0000), 16)
EndFunc   ;==>_WinAPI_GetBValue

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCaretBlinkTime
; Description....: Returns the time required to invert the caret's pixels.
; Syntax.........: _WinAPI_GetCaretBlinkTime ( )
; Parameters.....: None
; Return values..: Success - The blink time, in milliseconds.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCaretBlinkTime
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCaretBlinkTime()

	Local $Ret = DllCall('user32.dll', 'uint', 'GetCaretBlinkTime')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetCaretBlinkTime

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCaretPos
; Description....: Retrieves the caret's position.
; Syntax.........: _WinAPI_GetCaretPos ( )
; Parameters.....: None
; Return values..: Success - The array that contains the client coordinates of the caret.
;
;                            [0] - x-coordinate of the caret.
;                            [1] - y-coordinate of the caret.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCaretPos
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCaretPos()

	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('user32.dll', 'int', 'GetCaretPos', 'ptr', DllStructGetPtr($tagPOINT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[2]

	For $i = 0 To 1
		$Result[$i] = DllStructGetData($tPOINT, $i + 1)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetCaretPos

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCDType
; Description....: Retrieves a type of the media which is loaded into a specified CD-ROM device.
; Syntax.........: _WinAPI_GetCDType ( $sDrive )
; Parameters.....: $sDrive - The drive letter of the CD tray to retrieve information, in the format D:, E:, etc.
; Return values..: Success - The type of the media, it must be one of the following values.
;
;                            0x0000 - No media
;                            0x0008 - CD-ROM
;                            0x0009 - CD-R
;                            0x000A - CD-RW
;                            0x0010 - DVD-ROM
;                            0x0011 - DVD-R Sequential Recording
;                            0x0012 - DVD-RAM
;                            0x0013 - DVD-RW Restricted Overwrite
;                            0x0014 - DVD-RW Sequential Recording
;                            0x0015 - DVD-R Dual Layer
;                            0x0016 - DVD-R Dual Layer Jump Recording
;                            0x0017 - DVD-RW Dual Layer
;                            0x0018 - DVD-Download Disc Recording
;                            0x001A - DVD+RW
;                            0x001B - DVD+R
;                            0x0040 - BD-ROM
;                            0x0041 - BD-R Sequential Recording Mode (SRM)
;                            0x0042 - BD-R Random Recording Mode (RRM)
;                            0x0043 - BD-RE
;                            0x0050 - HD DVD-ROM
;                            0x0051 - HD DVD-R
;                            0x0052 - HD DVD-RAM
;                            0x0053 - HD DVD-RW
;                            0x0058 - HD DVD-R Dual Layer
;                            0x005A - HD DVD-RW Dual Layer
;                            0xFFFF - Unknown
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IOCTL_SCSI_PASS_THROUGH
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCDType($sDrive)

	Local $hFile = _WinAPI_CreateFileEx('\\.\' & $sDrive, 3, 0xC0000000, 0x03)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tSPT = DllStructCreate('ushort Length;byte ScsiStatus;byte PathId;byte TargetId;byte Lun;byte CdbLength;byte SenseInfoLength;byte DataIn;byte Alignment[3];ulong DataTransferLength;ulong TimeOutValue;ulong_ptr DataBufferOffset;ulong SenseInfoOffset;byte Cdb[16]' & __Iif(@AutoItX64, ';byte[4]', '') & ';byte Hdr[8]')
	Local $tCDB = DllStructCreate('byte;byte;byte[2];byte[3];byte[2];byte;byte[2];byte[4]', DllStructGetPtr($tSPT, 'Cdb'))
	Local $tHDR = DllStructCreate('byte[4];byte;byte;byte[2]', DllStructGetPtr($tSPT, 'Hdr'))
	Local $Size = DllStructGetPtr($tSPT, 'Hdr') - DllStructGetPtr($tSPT)

	DllStructSetData($tSPT, 'Length', $Size)
	DllStructSetData($tSPT, 'ScsiStatus', 0)
	DllStructSetData($tSPT, 'PathId', 0)
	DllStructSetData($tSPT, 'TargetId', 0)
	DllStructSetData($tSPT, 'Lun', 0)
	DllStructSetData($tSPT, 'CdbLength', 12)
	DllStructSetData($tSPT, 'SenseInfoLength', 0)
	DllStructSetData($tSPT, 'DataIn', 1)
	DllStructSetData($tSPT, 'DataTransferLength', 8)
	DllStructSetData($tSPT, 'TimeOutValue', 86400)
	DllStructSetData($tSPT, 'DataBufferOffset', $Size)
	DllStructSetData($tSPT, 'SenseInfoOffset', 0)

	DllStructSetData($tCDB, 1, 0x46)
	DllStructSetData($tCDB, 2, 0)
	DllStructSetData($tCDB, 3, 0, 1)
	DllStructSetData($tCDB, 3, 0, 2)
	DllStructSetData($tCDB, 5, 0, 1)
	DllStructSetData($tCDB, 5, 8, 2)
	DllStructSetData($tCDB, 6, 0)
	DllStructSetData($tCDB, 7, 0, 1)
	DllStructSetData($tCDB, 7, 0, 2)

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x0004D004, 'ptr', DllStructGetPtr($tSPT), 'dword', $Size, 'ptr', DllStructGetPtr($tSPT), 'dword', DllStructGetSize($tSPT), 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf
	Return BitOR(BitShift(DllStructGetData($tHDR, 4, 1), -8), DllStructGetData($tHDR, 4, 2))
EndFunc   ;==>_WinAPI_GetCDType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetClassInfoEx
; Description....: Retrieves information about a window class.
; Syntax.........: _WinAPI_GetClassInfoEx ( $sClass [, $hInstance] )
; Parameters.....: $sClass    - The class name. The name must be that of a preregistered class or a class registered by a previous
;                               call to the _WinAPI_RegisterClass() or _WinAPI_RegisterClassEx() function. Alternatively, this
;                               parameter can be a class atom. The atom must be in the low-order word of $sClass; the high-order
;                               word must be zero.
;                  $hInstance - Handle to the instance of the application that created the class. To retrieve information about
;                               classes defined by the system (such as buttons or list boxes), set this parameter to 0.
; Return values..: Success    - $tagWNDCLASSEX structure that contains the information about the class.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetClassInfoEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetClassInfoEx($sClass, $hInstance = 0)

	Local $TypeOfClass = 'ptr'

	If IsString($sClass) Then
		$TypeOfClass = 'wstr'
	EndIf

	Local $tWNDCLASSEX = DllStructCreate($tagWNDCLASSEX)
	Local $Ret = DllCall('user32.dll', 'int', 'GetClassInfoExW', 'ptr', $hInstance, $TypeOfClass, $sClass, 'ptr', DllStructGetPtr($tWNDCLASSEX))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tWNDCLASSEX
EndFunc   ;==>_WinAPI_GetClassInfoEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetClassLongEx
; Description....: Retrieves the specified value associated with the specified window.
; Syntax.........: _WinAPI_GetClassLongEx ( $hWnd, $iIndex )
; Parameters.....: $hWnd   - Handle to the window.
;                  $iIndex - The value to retrieve. This parameter can be one of the following values.
;
;                            $GCL_CBCLSEXTRA
;                            $GCL_CBWNDEXTRA
;                            $GCL_HBRBACKGROUND
;                            $GCL_HCURSOR
;                            $GCL_HICON
;                            $GCL_HICONSM
;                            $GCL_HMODULE
;                            $GCL_MENUNAME
;                            $GCL_STYLE
;                            $GCL_WNDPROC
;
; Return values..: Success - The requested value.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetClassLong
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetClassLongEx($hWnd, $iIndex)

	Local $Ret

	If @AutoItX64 Then
		$Ret = DllCall('user32.dll', 'ulong_ptr', 'GetClassLongPtrW', 'hwnd', $hWnd, 'int', $iIndex)
	Else
		$Ret = DllCall('user32.dll', 'ulong', 'GetClassLongW', 'hwnd', $hWnd, 'int', $iIndex)
	EndIf
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetClassLongEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetClipboardSequenceNumber
; Description....: Retrieves the clipboard sequence number for the current window station.
; Syntax.........: _WinAPI_GetClipboardSequenceNumber ( )
; Parameters.....: None
; Return values..: Success - The clipboard sequence number.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetClipboardSequenceNumber
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetClipboardSequenceNumber()

	Local $Ret = DllCall('user32.dll', 'dword', 'GetClipboardSequenceNumber')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetClipboardSequenceNumber

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetClipBox
; Description....: Retrieves the dimensions of the bounding rectangle of the visible area.
; Syntax.........: _WinAPI_GetClipBox ( $hDC, ByRef $tRECT )
; Parameters.....: $hDC    - Handle to the device context.
;                  $tRECT  - $tagRECT structure that is created by this function, and contains the rectangle dimensions, in logical units.
; Return values..: Success - The value that specifies the region's complexity; it can be one of the following values.
;
;                            $COMPLEXREGION
;                            $NULLREGION
;                            $SIMPLEREGION
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetClipBox
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetClipBox($hDC, ByRef $tRECT)

	$tRECT = DllStructCreate($tagRECT)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetClipBox', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		$tRECT = 0
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetClipBox

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetClipCursor
; Description....: Retrieves the screen coordinates of the rectangular area to which the cursor is confined.
; Syntax.........: _WinAPI_GetClipCursor ( )
; Parameters.....: None
; Return values..: Success - $tagRECT structure that receives the screen coordinates of the confining rectangle.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetClipCursor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetClipCursor()

	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'int', 'GetClipCursor', 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tRECT
EndFunc   ;==>_WinAPI_GetClipCursor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetClipRgn
; Description....: Retrieves a handle identifying the current application-defined clipping region.
; Syntax.........: _WinAPI_GetClipRgn ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - Handle to a copy of the current clipping region.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: An application-defined clipping region is a clipping region identified by the _WinAPI_SelectClipRgn() function.
;                  It is not a clipping region created when the application calls the _WinAPI_BeginPaint().
; Related........:
; Link...........: @@MsdnLink@@ GetClipRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetClipRgn($hDC)

	Local $hRgn = _WinAPI_CreateRectRgn(0, 0, 0, 0)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetClipRgn', 'hwnd', $hDC, 'ptr', $hRgn)

	If (@error) Or ($Ret[0] = -1) Then
		$Ret = 0
	Else
		If Not $Ret[0] Then
			$Ret = 1
		EndIf
	EndIf
	If Not IsArray($Ret) Then
		_WinAPI_DeleteObject($hRgn)
		If Not $Ret Then
			Return SetError(1, 0, 0)
		Else
			Return 0
		EndIf
	EndIf
	Return $hRgn
EndFunc   ;==>_WinAPI_GetClipRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetColorAdjustment
; Description....: Retrieves the color adjustment for the specified device context (DC).
; Syntax.........: _WinAPI_GetColorAdjustment ( $hDC )
; Parameters.....: $hDC    - A handle to the device context.
; Return values..: Success - $tagCOLORADJUSTMENT structure that receives the color adjustment values.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetColorAdjustment
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetColorAdjustment($hDC)

	Local $tAdjustment = DllStructCreate($tagCOLORADJUSTMENT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetColorAdjustment', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tAdjustment))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tAdjustment
EndFunc   ;==>_WinAPI_GetColorAdjustment

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCompressedFileSize
; Description....: Retrieves the actual number of bytes of disk storage used to store a specified file.
; Syntax.........: _WinAPI_GetCompressedFileSize ( $sFile )
; Parameters.....: $sFile   - The name of the file.
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the file is not located on a volume that supports compression or sparse files, or if the file is not compressed
;                  or a sparse file, the value obtained is the actual file size.
; Related........:
; Link...........: @@MsdnLink@@ GetCompressedFileSize
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCompressedFileSize($sFile)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetCompressedFileSizeW', 'wstr', $sFile, 'dword*', 0)

	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, 0)
	EndIf
	Return _WinAPI_MakeQWord($Ret[0], $Ret[2])
EndFunc   ;==>_WinAPI_GetCompressedFileSize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCompression
; Description....: Retrieves the current compression state of a file or directory.
; Syntax.........: _WinAPI_GetCompression ( $sPath )
; Parameters.....: $sPath  - The path to the file or directory to retrieve compression state.
; Return values..: Success - The current compression state ($COMPRESSION_FORMAT_*).
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FSCTL_GET_COMPRESSION
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCompression($sPath)

	Local $hFile = _WinAPI_CreateFileEx($sPath, 3, 0x80000000, 0x03, 0x02000000)

	If @error Then
		Return SetError(1, 0, -1)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x0009003C, 'ptr', 0, 'dword', 0, 'ushort*', 0, 'dword', 2, 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, -1)
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_GetCompression

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetConnectedDlg
; Description....: Launches the Get Connected wizard within the calling application to enable network connectivity.
; Syntax.........: _WinAPI_GetConnectedDlg ( $iDlg [, $iFlags [, $hParent]] )
; Parameters.....: $iDlg    - Specifies which the dialog should be launched, valid values:
;                  |0 - Local area network connectivity.
;                  |1 - Internet connectivity.
;                  |2 - Virtual private network (VPN) connectivity.
;                  $iFlags  - Specifies an additional options. This parameter can be one or more of the following values.
;                  |0 - Default.
;                  |1 - Do not display the Get Connected wizard page that shows whether or not the user has a working or active Internet connection.
;                  |2 - Do not display the Get Connected wizard page that shows a list of existing internet connections.
;                  |4 - Hide the finish page of the Get Connected wizard.
;                  $hParent - Handle to the parent window that called this API.
; Return values..: Success  - 1 - The Internet is connected.
;                             0 - Otherwise.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetConnectedDlg($iDlg, $iFlags = 0, $hParent = 0)

	If Not __DLL('connect.dll') Then
		Return SetError(3, 0, 0)
	EndIf

	Switch $iDlg
		Case 0
			$iDlg = 'GetNetworkConnected'
		Case 1
			$iDlg = 'GetInternetConnected'
		Case 2
			$iDlg = 'GetVPNConnected'
		Case Else
			Return SetError(1, 0, 0)
	EndSwitch

	Local $Str = ''

	If BitAND($iFlags, 1) Then
		$Str &= '-SkipInternetDetection '
	EndIf
	If BitAND($iFlags, 2) Then
		$Str &= '-SkipExistingConnections '
	EndIf
	If BitAND($iFlags, 4) Then
		$Str &= '-HideFinishPage '
	EndIf

	Local $Ret = DllCall('connect.dll', 'uint', $iDlg, 'hwnd', $hParent, 'dword', 0, 'dword', 0, 'dword', 0, 'ptr', 0, 'wstr', StringStripWS($Str, 2))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		Switch $Ret[0]
			Case 0, 1 ; S_OK, S_FALSE

			Case Else
				Return SetError(1, $Ret[0], 0)
		EndSwitch
	EndIf
	Return Number(Not $Ret[0])
EndFunc   ;==>_WinAPI_GetConnectedDlg

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCurrentDirectory
; Description....: Retrieves the current directory for the current process.
; Syntax.........: _WinAPI_GetCurrentDirectory ( )
; Parameters.....: None
; Return values..: Success - The absolute path to the current directory.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCurrentDirectory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCurrentDirectory()

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetCurrentDirectoryW', 'dword', 4096, 'wstr', '')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetCurrentDirectory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCurrentHwProfile
; Description....: Retrieves information about the current hardware profile for the local computer.
; Syntax.........: _WinAPI_GetCurrentHwProfile ( )
; Parameters.....: None
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The reported docking state of the computer (DOCKINFO_*).
;                            [1] - The globally unique identifier (GUID) string for the current hardware profile.
;                            [2] - The display name for the current hardware profile.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCurrentHwProfile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCurrentHwProfile()

	Local $tHWPI = DllStructCreate('dword;wchar[39];wchar[80]')
	Local $Ret = DllCall('advapi32.dll', 'int', 'GetCurrentHwProfileW', 'ptr', DllStructGetPtr($tHWPI))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[3]

	For $i = 0 To 2
		$Result[$i] = DllStructGetData($tHWPI, $i + 1)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetCurrentHwProfile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCurrentObject
; Description....: Retrieves a handle to an object of the specified type that has been selected into the specified device context.
; Syntax.........: _WinAPI_GetCurrentObject ( $hDC, $iType )
; Parameters.....: $hDC    - Handle to the device context.
;                  $iType  - The object type to be queried. This parameter can be one of the following values.
;
;                            $OBJ_BITMAP
;                            $OBJ_BRUSH
;                            $OBJ_COLORSPACE
;                            $OBJ_FONT
;                            $OBJ_PAL
;                            $OBJ_PEN
;
; Return values..: Success - Handle to the specified object.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCurrentObject
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCurrentObject($hDC, $iType)

	Local $Ret  = DllCall('gdi32.dll', 'ptr', 'GetCurrentObject', 'hwnd', $hDC, 'uint', $iType)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetCurrentObject

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCurrentPosition
; Description....: Retrieves the current position for the specified device context.
; Syntax.........: _WinAPI_GetCurrentPosition ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - $tagPOINT structure that contains the logical coordinates of the current position.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCurrentPositionEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCurrentPosition($hDC)

	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetCurrentPositionEx', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tPOINT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tPOINT
EndFunc   ;==>_WinAPI_GetCurrentPosition

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCurrentProcessExplicitAppUserModelID
; Description....: Retrieves the application-defined, explicit Application User Model ID for the current process.
; Syntax.........: _WinAPI_GetCurrentProcessExplicitAppUserModelID ( )
; Parameters.....: None
; Return values..: Success - The string that represents an Application User Model ID (AppUserModelID).
;                  Failure - Empty string and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: An application can only retrieve an AppUserModelID that has been explicitly set by using the _WinAPI_SetCurrentProcessExplicitAppUserModelID()
;                  function. System-assigned default AppUserModelIDs cannot be retrieved.
;
;                  This function requires Windows 7 or later.
; Related........:
; Link...........: @@MsdnLink@@ GetCurrentProcessExplicitAppUserModelID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCurrentProcessExplicitAppUserModelID()

	Local $Ret = DllCall('shell32.dll', 'uint', 'GetCurrentProcessExplicitAppUserModelID', 'ptr*', 0)

	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf

	Local $ID = _WinAPI_GetString($Ret[1])

	_WinAPI_CoTaskMemFree($Ret[1])
	Return $ID
EndFunc   ;==>_WinAPI_GetCurrentProcessExplicitAppUserModelID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCurrentThemeName
; Description....: Retrieves the name of the current visual styles, color scheme name, and size name.
; Syntax.........: _WinAPI_GetCurrentThemeName ( )
; Parameters.....: None
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The theme path and file name.
;                            [1] - The color scheme name.
;                            [2] - The size name.
;
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCurrentThemeName
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCurrentThemeName()

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetCurrentThemeName', 'wstr', '', 'int', 4096, 'wstr', '', 'int', 2048, 'wstr', '', 'int', 2048)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf

	Local $Result[3]

	For $i = 0 To 2
		$Result[$i] = $Ret[$i * 2 + 1]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetCurrentThemeName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetCursor
; Description....: Retrieves a handle to the current cursor.
; Syntax.........: _WinAPI_GetCursor ( )
; Parameters.....: None
; Return values..: Success - Handle to the current cursor. If there is no cursor, the return value is 0.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetCursor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetCursor()

	Local $Ret = DllCall('user32.dll', 'ptr', 'GetCursor')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetCursor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDateFormat
; Description....: Formats a date as a date string for a locale specified by the locale identifier.
; Syntax.........: _WinAPI_GetDateFormat ( [$LCID [, $tSYSTEMTIME [, $iFlag [, $sFormat]]]] )
; Parameters.....: $LCID        - The locale identifier (LCID) that specifies the locale or one of the following predefined values.
;
;                                 $LOCALE_INVARIANT
;                                 $LOCALE_SYSTEM_DEFAULT
;                                 $LOCALE_USER_DEFAULT
;
;                                 Windows Vista or later
;
;                                 $LOCALE_CUSTOM_DEFAULT
;                                 $LOCALE_CUSTOM_UI_DEFAULT
;                                 $LOCALE_CUSTOM_UNSPECIFIED
;
;                  $tSYSTEMTIME - $tagSYSTEMTIME structure that contains the date information to format. If this parameter is 0,
;                                 the function will use the current local system date.
;                  $iFlag       - The flags that specifies the date format options. This parameter can be one or more of the
;                                 following values.
;
;                                 $DATE_LONGDATE
;                                 $DATE_SHORTDATE (Default)
;                                 $DATE_USE_ALT_CALENDAR
;
;                                 Windows Vista or later
;
;                                 $DATE_LTRREADING
;                                 $DATE_RTLREADING
;                                 $DATE_YEARMONTH
;
;                                 Windows 7 or later
;
;                                 $DATE_AUTOLAYOUT
;
;                  $sFormat     - The string that is used to form the date. For example, "dddd dd, yyyy". If this parameter is
;                                 omitted or an empty string, the function returns the string according to the date format
;                                 for the specified locale.
; Return values..: Success      - The formatted date string.
;                  Failure      - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDateFormat
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDateFormat($LCID = 0, $tSYSTEMTIME = 0, $iFlags = 0, $sFormat = '')

	Local $TypeOfFormat = 'wstr'

	If Not $LCID Then
		$LCID = 0x0400
	EndIf
	If Not StringStripWS($sFormat, 3) Then
		$TypeOfFormat = 'ptr'
		$sFormat = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetDateFormatW', 'ulong', $LCID, 'dword', $iFlags, 'ptr', DllStructGetPtr($tSYSTEMTIME), $TypeOfFormat, $sFormat, 'wstr', '', 'int', 2048)

    If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
    Return $Ret[5]
EndFunc   ;==>_WinAPI_GetDateFormat

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDCEx
; Description....: Retrieves a handle to a device context (DC) for the client area of a specified window.
; Syntax.........: _WinAPI_GetDCEx ( $hWnd, $hRgn, $iFlags )
; Parameters.....: $hWnd   - Handle to the window whose DC is to be retrieved. If this value is 0, _WinAPI_GetDCEx() retrieves the
;                            DC for the entire screen. If the value of $iFlags parameter is $DCX_INTERSECTRGN or DCX_EXCLUDERGN,
;                            then the operating system assumes ownership of the region and will automatically delete it when it is
;                            no longer needed. In this case, the application should not use or delete the region after a successful
;                            call to _WinAPI_GetDCEx().
;                  $hRgn   - A clipping region that may be combined with the visible region of the DC.
;                  $iFlags - Flags that specifies how the DC is created. This parameter can be one or more of the following values.
;
;                            $DCX_WINDOW
;                            $DCX_CACHE
;                            $DCX_PARENTCLIP
;                            $DCX_CLIPSIBLINGS
;                            $DCX_CLIPCHILDREN
;                            $DCX_NORESETATTRS
;                            $DCX_LOCKWINDOWUPDATE
;                            $DCX_EXCLUDERGN
;                            $DCX_INTERSECTRGN
;                            $DCX_INTERSECTUPDATE
;                            $DCX_VALIDATE
;
; Return values..: Success - Handle to the DC for the specified window.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Unless the display DC belongs to a window class, the _WinAPI_ReleaseDC() function must be called to release the
;                  DC after painting.
; Related........:
; Link...........: @@MsdnLink@@ GetDCEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDCEx($hWnd, $hRgn, $iFlags)

	Local $Ret = DllCall('user32.dll', 'hwnd', 'GetDCEx', 'hwnd', $hWnd, 'ptr', $hRgn, 'dword', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetDCEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDefaultPrinter
; Description....: Retrieves the printer name of the default printer for the current user on the local computer.
; Syntax.........: _WinAPI_GetDefaultPrinter ( )
; Parameters.....: None
; Return values..: Success - String containing the default printer name.
;                  Failure - Empty string and sets the @error flag to:
;                            1 - Function fails or not found
;                            2 - No default printer
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDefaultPrinter
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDefaultPrinter()

	Local $Ret = DllCall('winspool.drv', 'int', 'GetDefaultPrinterW', 'wstr', '', 'dword*', 2048)

    If (@error) Or (Not $Ret[0]) Then
		Return SetError(1 + (_WinAPI_GetLastError() = 2), 0, '')
	EndIf
    Return $Ret[1]
EndFunc   ;==>_WinAPI_GetDefaultPrinter

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDefaultUserProfileDirectory
; Description....: Retrieves the path to the root of the default user's profile.
; Syntax.........: _WinAPI_GetDefaultUserProfileDirectory ( )
; Parameters.....: None
; Return values..: Success - The path to the directory.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDefaultUserProfileDirectory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDefaultUserProfileDirectory()

	Local $Ret = DllCall('userenv.dll', 'int', 'GetDefaultUserProfileDirectoryW', 'wstr', '', 'dword*', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[1]
EndFunc   ;==>_WinAPI_GetDefaultUserProfileDirectory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDeviceDriverBaseName
; Description....: Retrieves the base name of the specified device driver.
; Syntax.........: _WinAPI_GetDeviceDriverBaseName ( $hDriver )
; Parameters.....: $hDriver - The load address of the device driver. This value can be retrieved using the _WinAPI_EnumDeviceDrivers() function.
; Return values..: Success  - The base name of the device driver.
;                  Failure  - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDeviceDriverBaseName
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDeviceDriverBaseName($hDriver)

	Local $Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'GetDeviceDriverBaseNameW', 'ptr', $hDriver, 'wstr', '', 'dword', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetDeviceDriverBaseName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDeviceDriverFileName
; Description....: Retrieves the path available for the specified device driver.
; Syntax.........: _WinAPI_GetDeviceDriverFileName ( $hDriver )
; Parameters.....: $hDriver - The load address of the device driver. This value can be retrieved using the _WinAPI_EnumDeviceDrivers() function.
; Return values..: Success  - The path to the device driver.
;                  Failure  - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDeviceDriverFileName
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDeviceDriverFileName($hDriver)

	Local $Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'GetDeviceDriverFileNameW', 'ptr', $hDriver, 'wstr', '', 'dword', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetDeviceDriverFileName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDeviceGammaRamp
; Description....: Gets the gamma ramp on direct color display boards that support downloadable gamma ramps in hardware.
; Syntax.........: _WinAPI_GetDeviceGammaRamp ( $hDC, ByRef $aRamp )
; Parameters.....: $hDC    - Handle to a device context of the direct color display board in question.
;                  $aRamp  - The 2D array ([r1, g1, b1], [r2, g2, b2], ... [r256, g256, b256]) that is created by this function,
;                            and where the function place the current gamma ramp of the color display board. Each element in
;                            this array is an integer value with a range from 0 to 65535 which is a mapping between RGB values
;                            in the frame buffer and digital-analog-converter (DAC) values.
;
;                            (See MSDN for more information)
;
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Direct color display modes do not use color lookup tables and are usually 16, 24, or 32 bit. Not all direct
;                  color video boards support loadable gamma ramps. The _WinAPI_GetDeviceGammaRamp() succeeds only for devices
;                  with drivers that support downloadable gamma ramps in hardware.
; Related........:
; Link...........: @@MsdnLink@@ GetDeviceGammaRamp
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDeviceGammaRamp($hDC, ByRef $aRamp)

	$aRamp = 0

	Local $tData = DllStructCreate('ushort[256];ushort[256];ushort[256]')
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetDeviceGammaRamp', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tData))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Dim $aRamp[256][3]

	For $i = 0 to 2
		For $j = 0 To 255
			$aRamp[$j][$i] = DllStructGetData($tData, $i + 1, $j + 1)
		Next
	Next
	Return 1
EndFunc   ;==>_WinAPI_GetDeviceGammaRamp

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDIBColorTable
; Description....: Retrieves RGB color table from the DIB section bitmap.
; Syntax.........: _WinAPI_GetDIBColorTable ( $hBitmap )
; Parameters.....: $hBitmap - A DIB section bitmap from which to retrieve the color table.
; Return values..: Success  - "dword[n]" structure that contains a color information from the DIB color table, @extended flag
;                             will contain the number of colors in this structure.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_GetDIBColorTable() function retrieves a color table for DIB section bitmaps that use 1, 4, or
;                  8 bits-per-pixel. A DIB section bitmaps that use bits-per-pixel value greater than eight do not have a color
;                  table, but they do have associated color masks. Call the _WinAPI_GetObject() function to retrieve those
;                  color masks.
; Related........:
; Link...........: @@MsdnLink@@ GetDIBColorTable
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDIBColorTable($hBitmap)

	Local $hDC, $hSv, $tData, $tPeak, $Ret

	$hDC = _WinAPI_CreateCompatibleDC(0)
	$hSv = _WinAPI_SelectObject($hDC, $hBitmap)
	$tPeak = DllStructCreate('dword[256]')
	$Ret = DllCall('gdi32.dll', 'uint', 'GetDIBColorTable', 'hwnd', $hDC, 'uint', 0, 'uint', 256, 'ptr', DllStructGetPtr($tPeak))
	If (@error) Or (Not $Ret[0]) Or (Not $Ret[4]) Then
		$Ret = 0
	EndIf
	_WinAPI_SelectObject($hDC, $hSv)
	_WinAPI_DeleteDC($hDC)
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
	$tData = DllStructCreate('dword[' & $Ret[0] & ']')
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	If Not _WinAPI_MoveMemory(DllStructGetPtr($tData), $Ret[4], 4 * $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, $Ret[0], $tData)
EndFunc   ;==>_WinAPI_GetDIBColorTable

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDiskFreeSpaceEx
; Description....: Retrieves information about the amount of space that is available on a disk volume.
; Syntax.........: _WinAPI_GetDiskFreeSpaceEx ( $sDrive )
; Parameters.....: $sDrive - The drive to retrieve information, in the format D:, E:, etc.
; Return values..: Success - The array containing the following information:
;
;                            [0] - The total number of available free bytes on a disk. If per-user quotas are being used, this value
;                                  may be less than the total number of free bytes on a disk.
;                            [1] - The total number of available bytes on a disk. If per-user quotas are being used, this value
;                                  may be less than the total number of bytes on a disk.
;                            [2] - The total number of free bytes on a disk.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDiskFreeSpaceEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDiskFreeSpaceEx($sDrive)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetDiskFreeSpaceEx', 'str', $sDrive, 'int64*', 0, 'int64*', 0, 'int64*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[3]

	For $i = 0 To 2
		$Result[$i] = $Ret[$i + 2]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetDiskFreeSpaceEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDllDirectory
; Description....: Retrieves the application-specific portion of the search path used to locate DLLs for the application.
; Syntax.........: _WinAPI_GetDllDirectory ( )
; Parameters.....: None
; Return values..: Success  - The search path.
;                  Failure  - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDllDirectory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDllDirectory()

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetDllDirectoryW', 'dword', 4096, 'wstr', '')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetDllDirectory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDriveBusType
; Description....: Retrieves a bus type for the specified drive.
; Syntax.........: _WinAPI_GetDriveBusType ( $sDrive )
; Parameters.....: $sDrive - The drive letter to retrieve information, in the format D:, E:, etc.
; Return values..: Success - The bus type constant ($DRIVE_BUS_TYPE_*).
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function works with the Plug and Play drivers only.
; Related........:
; Link...........: @@MsdnLink@@ IOCTL_STORAGE_QUERY_PROPERTY
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDriveBusType($sDrive)

	Local $hFile = _WinAPI_CreateFileEx('\\.\' & $sDrive, 3, 0, 0x03)

	If @error Then
		Return SetError(1, 0, -1)
	EndIf

	Local $tSPQ = DllStructCreate('ulong PropertyId;ulong QueryType;byte AdditionalParameters[4]')
	Local $tSDD = DllStructCreate('ulong Version;ulong Size;byte DeviceType;byte DeviceTypeModifier;byte RemovableMedia;byte CommandQueueing;ulong VendorIdOffset;ulong ProductIdOffset;ulong ProductRevisionOffset;ulong SerialNumberOffset;ulong BusType;ulong RawPropertiesLength;byte RawDeviceProperties[1]')

	DllStructSetData($tSPQ, 'PropertyId', 0)
	DllStructSetData($tSPQ, 'QueryType', 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x002D1400, 'ptr', DllStructGetPtr($tSPQ), 'dword', DllStructGetSize($tSPQ), 'ptr', DllStructGetPtr($tSDD), 'dword', DllStructGetSize($tSDD), 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, -1)
	EndIf
	Return DllStructGetData($tSDD, 'BusType')
EndFunc   ;==>_WinAPI_GetDriveBusType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDriveGeometryEx
; Description....: Retrieves extended information about the disk's geometry.
; Syntax.........: _WinAPI_GetDriveGeometryEx ( $iDrive )
; Parameters.....: $iDrive - The physical drive number (0, 1, 2, etc) to retrieve information.
; Return values..: Success - The array containing the following information:
;
;                            [0] - The number of cylinders.
;                            [1] - The type of media.
;                            [2] - The number of tracks per cylinder.
;                            [3] - The number of sectors per track.
;                            [4] - The number of bytes per sector.
;                            [5] - The disk size, in bytes.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IOCTL_DISK_GET_DRIVE_GEOMETRY_EX
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDriveGeometryEx($iDrive)

	Local $hFile = _WinAPI_CreateFileEx('\\.\PhysicalDrive' & $iDrive, 3, 0, 0x03)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tDGEX = DllStructCreate('int64;dword;dword;dword;dword;int64')
	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x000700A0, 'ptr', 0, 'dword', 0, 'ptr', DllStructGetPtr($tDGEX), 'dword', DllStructGetSize($tDGEX), 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf

	Local $Result[6]

	For $i = 0 To 5
		$Result[$i] = DllStructGetData($tDGEX, $i + 1)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetDriveGeometryEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDriveNumber
; Description....: Retrieves a device type, device number, and partition number for the specified drive.
; Syntax.........: _WinAPI_GetDriveNumber ( $sDrive )
; Parameters.....: $sDrive - The drive letter to retrieve information, in the format D:, E:, etc.
; Return values..: Success - The array containing the following information:
;
;                            [0] - The type of device ($FILE_DEVICE_*).
;                            [1] - The device number.
;                            [2] - The partition number, or (-1) if device cannot be partitioned.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IOCTL_STORAGE_GET_DEVICE_NUMBER
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDriveNumber($sDrive)

	Local $hFile = _WinAPI_CreateFileEx('\\.\' & $sDrive, 3, 0, 0x03)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tSDN = DllStructCreate('dword;ulong;ulong')
	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x002D1080, 'ptr', 0, 'dword', 0, 'ptr', DllStructGetPtr($tSDN), 'dword', DllStructGetSize($tSDN), 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf

	Local $Result[3]

	For $i = 0 To 2
		$Result[$i] = DllStructGetData($tSDN, $i + 1)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetDriveNumber

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDriveType
; Description....: Determines whether a disk drive is a removable, fixed, CD-ROM, RAM disk, or network drive.
; Syntax.........: _WinAPI_GetDriveType ( [$sDrive] )
; Parameters.....: $sDrive - The drive letter to retrieve information, in the format D:, E:, etc.
; Return values..: Success - The type of drive ($DRIVE_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetDriveType
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDriveType($sDrive = '')

	Local $TypeOfDrive = 'str'

	If Not StringStripWS($sDrive, 3) Then
		$TypeOfDrive = 'ptr'
		$sDrive = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetDriveType', $TypeOfDrive, $sDrive)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetDriveType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetDurationFormat
; Description....: Formats a duration of time as a time string for a locale specified by identifier.
; Syntax.........: _WinAPI_GetDurationFormat ( $LCID, $iDuration [, $sFormat] )
; Parameters.....: $LCID      - The locale identifier (LCID) that specifies the locale or one of the following predefined values.
;
;                               $LOCALE_INVARIANT
;                               $LOCALE_SYSTEM_DEFAULT
;                               $LOCALE_USER_DEFAULT
;
;                               Windows Vista or later
;
;                               $LOCALE_CUSTOM_DEFAULT
;                               $LOCALE_CUSTOM_UI_DEFAULT
;                               $LOCALE_CUSTOM_UNSPECIFIED
;
;                  $iDuration - The number of 100-nanosecond intervals in the duration. Alternatively, this parameter can be
;                               a $tagSYSTEMTIME structure that contains the time duration information to format.
;                  $sFormat   - The string that is used to form the duration. For example, "hh:mm:ss.ff". If this parameter is
;                               omitted or an empty string, the function returns the string according to the duration format
;                               for the specified locale.
; Return values..: Success    - The formatted duration string.
;                  Failure    - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetDurationFormat
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetDurationFormat($LCID, $iDuration, $sFormat = '')

	Local $pST, $Val, $TypeOfFormat = 'wstr'

	If Not $LCID Then
		$LCID = 0x0400
	EndIf
	If IsDllStruct($iDuration) Then
		$pST = DllStructGetPtr($iDuration)
		$Val = 0
	Else
		$pST = 0
		$Val = $iDuration
	EndIf
	If Not StringStripWS($sFormat, 3) Then
		$TypeOfFormat = 'ptr'
		$sFormat = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetDurationFormat', 'ulong', $LCID, 'dword', 0, 'ptr', $pST, 'uint64', $Val, $TypeOfFormat, $sFormat, 'wstr', '', 'int', 2048)

    If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
    Return $Ret[6]
EndFunc   ;==>_WinAPI_GetDurationFormat

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetEnhMetaFile
; Description....: Creates a handle that identifies the enhanced-format metafile stored in the specified file.
; Syntax.........: _WinAPI_GetEnhMetaFile ( $sFile )
; Parameters.....: $sFile  - The name of an enhanced metafile (.emf).
; Return values..: Success - Handle to the enhanced metafile.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When the application no longer needs an enhanced-metafile handle, it should delete the handle by calling the
;                  _WinAPI_DeleteEnhMetaFile() function.
; Related........:
; Link...........: @@MsdnLink@@ GetEnhMetaFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetEnhMetaFile($sFile)

	Local $Ret = DllCall('gdi32.dll', 'ptr', 'GetEnhMetaFileW', 'wstr', $sFile)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetEnhMetaFileBits
; Description....: Retrieves the contents of the specified enhanced-format metafile.
; Syntax.........: _WinAPI_GetEnhMetaFileBits ( $hEmf, ByRef $pBuffer )
; Parameters.....: $hEmf    - Handle to the enhanced metafile.
;                  $pBuffer - A pointer to a memory block (buffer) that receives the metafile data. Optionaly, you can set this
;                             parameter to 0 before function call, then the function will allocate the required memory block itself.
;                             Otherwise, it must be a valid memory pointer returned by the _WinAPI_CreateBuffer() function, or
;                             by previously calling this function.
; Return values..: Success  - The number of bytes copied to the buffer.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: After the enhanced-metafile bits are retrieved, they can be used to create a memory-based metafile by calling the
;                  _WinAPI_SetEnhMetaFileBits() function.
;
;                  When you no longer need the buffer allocated by this function, you must call the _WinAPI_FreeMemory() function
;                  (do not use any other memory routines) to release occupied memory.
; Related........:
; Link...........: @@MsdnLink@@ GetEnhMetaFileBits
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetEnhMetaFileBits($hEmf, ByRef $pBuffer)

	Local $Ret

	$Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileBits', 'ptr', $hEmf, 'uint', 0, 'ptr', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$pBuffer = __HeapReAlloc($pBuffer, $Ret[0], 1)
	If @error Then
		Return SetError(9, 0, 0)
	EndIf
	$Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileBits', 'ptr', $hEmf, 'uint', $Ret[0], 'ptr', $pBuffer)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetEnhMetaFileBits

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetEnhMetaFileDescription
; Description....: Retrieves an optional text description from an enhanced-format metafile.
; Syntax.........: _WinAPI_GetEnhMetaFileDescription ( $hEmf )
; Parameters.....: $hEmf   - Handle to the enhanced metafile.
; Return values..: Success - If the optional text description does not exist, the return value is 0, otherwise an array that
;                            contains the following information:
;
;                            [0] - Application name
;                            [1] - Picture name
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetEnhMetaFileDescription
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetEnhMetaFileDescription($hEmf)

	Local $tData = DllStructCreate('wchar[4096]')
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileDescriptionW', 'ptr', $hEmf, 'uint', 4096, 'ptr', DllStructGetPtr($tData))

	If (@error) Or ($Ret[0] = 0xFFFF) Then
		Return SetError(1, 0, 0)
	Else
		If Not $Ret[0] Then
			Return 0
		EndIf
	EndIf

	Local $aData = _WinAPI_StructToArray($tData)

	If Not IsArray($aData) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[2]

	For $i = 0 To 1
		If $aData[0] > $i Then
			$Result[$i] = $aData[$i + 1]
		Else
			$Result[$i] = ''
		EndIf
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetEnhMetaFileDescription

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetEnhMetaFileDimension
; Description....: Retrieves a dimension of the specified enhanced-format metafile.
; Syntax.........: _WinAPI_GetEnhMetaFileHeader ( $hEmf )
; Parameters.....: $hEmf   - Handle to the enhanced metafile to retrirve dimension.
; Return values..: Success - $tagSIZE structure that contains the enhanced metafile dimension, in pixels.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetEnhMetaFileDimension($hEmf)

	Local $tENHMETAHEADER = _WinAPI_GetEnhMetaFileHeader($hEmf)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tSIZE = DllStructCreate($tagSIZE)

	DllStructSetData($tSIZE, 1, Round((DllStructGetData($tENHMETAHEADER, 'rcFrame', 3) - DllStructGetData($tENHMETAHEADER, 'rcFrame', 1)) * DllStructGetData($tENHMETAHEADER, 'Device', 1) / DllStructGetData($tENHMETAHEADER, 'Millimeters', 1) / 100))
	DllStructSetData($tSIZE, 2, Round((DllStructGetData($tENHMETAHEADER, 'rcFrame', 4) - DllStructGetData($tENHMETAHEADER, 'rcFrame', 2)) * DllStructGetData($tENHMETAHEADER, 'Device', 2) / DllStructGetData($tENHMETAHEADER, 'Millimeters', 2) / 100))

	Return $tSIZE
EndFunc   ;==>_WinAPI_GetEnhMetaFileDimension

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetEnhMetaFileHeader
; Description....: Retrieves the record containing the header for the specified enhanced-format metafile.
; Syntax.........: _WinAPI_GetEnhMetaFileHeader ( $hEmf )
; Parameters.....: $hEmf   - Handle to the enhanced metafile for which the header is to be retrieved.
; Return values..: Success - $tagENHMETAHEADER structure that contains the header record, @extended flag will contain the
;                            number of bytes copied to the structure, in bytes.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetEnhMetaFileHeader
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetEnhMetaFileHeader($hEmf)

	Local $tENHMETAHEADER = DllStructCreate($tagENHMETAHEADER)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileHeader', 'ptr', $hEmf, 'uint', DllStructGetSize($tENHMETAHEADER), 'ptr', DllStructGetPtr($tENHMETAHEADER))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, $Ret[0], $tENHMETAHEADER)
EndFunc   ;==>_WinAPI_GetEnhMetaFileHeader

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetErrorMessage
; Description....: Retrieves a text error message for the specified system error code.
; Syntax.........: _WinAPI_GetErrorMessage ( $iCode [, $iLanguage] )
; Parameters.....: $iCode     - The system error code to retrieve a message.
;                  $iLanguage - The language identifier.
; Return values..: Success    - The requested message.
;                  Failure    - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ FormatMessage
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetErrorMessage($iCode, $iLanguage = 0)

	Local $Ret = DllCall('kernel32.dll', 'dword', 'FormatMessageW', 'dword', 0x1000, 'ptr', 0, 'dword', $iCode, 'dword', $iLanguage, 'wstr', '', 'dword', 4096, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return StringRegExpReplace($Ret[5], '[' & @LF & ',' & @CR & ']*\Z', '')
EndFunc   ;==>_WinAPI_GetErrorMessage

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetErrorMode
; Description....: Retrieves the error mode for the current process.
; Syntax.........: _WinAPI_GetErrorMode ( )
; Parameters.....: None
; Return values..: Success - The process error mode ($SEM_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetErrorMode
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetErrorMode()

	Local $Ret = DllCall('kernel32.dll', 'uint', 'GetErrorMode')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetErrorMode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetExitCodeProcess
; Description....: Retrieves the termination status of the specified process.
; Syntax.........: _WinAPI_GetExitCodeProcess ( $hProcess )
; Parameters.....: $hProcess - Handle to the process.
; Return values..: Success   - The process termination status. If the process has not terminated and the function succeeds,
;                              the status returned is STILL_ACTIVE (259).
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetExitCodeProcess
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetExitCodeProcess($hProcess)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetExitCodeProcess', 'ptr', $hProcess, 'dword*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetExitCodeProcess

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetExtended
; Description....: Retrieves the last extended function return value.
; Syntax.........: _WinAPI_GetExtended ( )
; Parameters.....: None
; Return values..: The last extended value.
; Author.........: Yashied
; Modified.......:
; Remarks........: Note that not all the functions returns the extended value. For example, _WinAPI_CreateDIB() function returns
;                  a pointer to the location of the DIB bit values. The _WinAPI_GetExtended() must be called immediately after
;                  calling the appropriate function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetExtended()
	Return $__Ext
EndFunc   ;==>_WinAPI_GetExtended

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileAttributes
; Description....: Retrieves file system attributes for a specified file or directory.
; Syntax.........: _WinAPI_GetFileAttributes ( $sFile )
; Parameters.....: $sFile  - The name of the file or directory.
; Return values..: Success - The value contains the attributes of the specified file or directory ($FILE_ATTRIBUTE_).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetFileAttributes
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileAttributes($sFile)

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetFileAttributesW', 'wstr', $sFile)

	If (@error) Or ($Ret[0] = 4294967295) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetFileAttributes

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileID
; Description....: Retrieves the file system's 8-byte file reference number for a file.
; Syntax.........: _WinAPI_GetFileID ( $hFile )
; Parameters.....: $hFile  - A handle to the file or directory whose reference number is to be retrieved.
; Return values..: Success - The 8-byte file reference number for the file.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The file reference number is assigned by the file system and is file-system-specific. (Note that this is not the same
;                  as the 16-byte "file object ID" that was added to NTFS for Microsoft Windows 2000.)
;
;                  The file reference numbers, also called file IDs, are guaranteed to be unique only within a static file system.
;                  They are not guaranteed to be unique over time, because file systems are free to reuse them. Nor are they guaranteed to
;                  remain constant. For example, the FAT file system generates the file reference number for a file from the byte offset
;                  of the file's directory entry record (DIRENT) on the disk. Defragmentation can change this byte offset. Thus a FAT
;                  file reference number can change over time.
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryInformationFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileID($hFile)

	Local $tIOSB = DllStructCreate('ptr;ulong_ptr')
	Local $Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryInformationFile', 'ptr', $hFile, 'ptr', DllStructGetPtr($tIOSB), 'int64*', 0, 'ulong', 8, 'uint', 6)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetFileID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileInformationByHandle
; Description....: Retrieves file information for the specified file.
; Syntax.........: _WinAPI_GetFileInformationByHandle ( $hFile )
; Parameters.....: $hFile  - Handle to the file that contains the information to be retrieved.
; Return values..: Success - The array containing the following information:
;
;                            [0] - The file attributes (FILE_ATTRIBUTE_*).
;                            [1] - $tagFILETIME structure that specifies when a file or directory is created.
;                            [2] - $tagFILETIME structure that specifies the last time that a file is read from or written to.
;                            [3] - $tagFILETIME structure that specifies the last time that a file is written to.
;                            [4] - The serial number of the volume that contains a file.
;                            [5] - The file size.
;                            [6] - The number of links to this file.
;                            [7] - The unique identifier that is associated with a file.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetFileInformationByHandle
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileInformationByHandle($hFile)

	Local $tBHFI = DllStructCreate('dword;dword[2];dword[2];dword[2];dword;dword;dword;dword;dword;dword')
	Local $Ret = DllCall('kernel32.dll', 'int', 'GetFileInformationByHandle', 'ptr', $hFile, 'ptr', DllStructGetPtr($tBHFI))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[8]

	$Result[0] = DllStructGetData($tBHFI, 1)
	For $i = 1 To 3
		If DllStructGetData($tBHFI, $i + 1) Then
			$Result[$i] = DllStructCreate($tagFILETIME)
			If Not _WinAPI_MoveMemory(DllStructGetPtr($Result[$i]), DllStructGetPtr($tBHFI, $i + 1), 8) Then
				Return SetError(1, 0, 0)
			EndIf
		Else
			$Result[$i] = 0
		EndIf
	Next
	$Result[4] = DllStructGetData($tBHFI, 5)
	$Result[5] = _WinAPI_MakeQWord(DllStructGetData($tBHFI, 7), DllStructGetData($tBHFI, 6))
	$Result[6] = DllStructGetData($tBHFI, 8)
	$Result[7] = _WinAPI_MakeQWord(DllStructGetData($tBHFI, 9), DllStructGetData($tBHFI, 10))
	Return $Result
EndFunc   ;==>_WinAPI_GetFileInformationByHandle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileInformationByHandleEx
; Description....: Retrieves file information for the specified file.
; Syntax.........: _WinAPI_GetFileInformationByHandleEx ( $hFile )
; Parameters.....: $hFile  - Handle to the file that contains the information to be retrieved.
; Return values..: Success - $tagFILEINFO structure containing information for a file.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryInformationFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileInformationByHandleEx($hFile)

	Local $tFI = DllStructCreate($tagFILEINFO)
	Local $tIOSB = DllStructCreate('ptr;ulong_ptr')
	Local $Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryInformationFile', 'ptr', $hFile, 'ptr', DllStructGetPtr($tIOSB), 'ptr', DllStructGetPtr($tFI), 'ulong', DllStructGetSize($tFI), 'uint', 4)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tFI
EndFunc   ;==>_WinAPI_GetFileInformationByHandleEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFilePointerEx
; Description....: Retrieves the file pointer of the specified file.
; Syntax.........: _WinAPI_GetFilePointerEx ( $hFile )
; Parameters.....: $hFile  - Handle to the file.
; Return values..: Success - The byte offset from the beginning of the file of the current file pointer.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryInformationFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFilePointerEx($hFile)

	Local $tIOSB = DllStructCreate('ptr;ulong_ptr')
	Local $Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryInformationFile', 'ptr', $hFile, 'ptr', DllStructGetPtr($tIOSB), 'int64*', 0, 'ulong', 8, 'uint', 14)

	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetFilePointerEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileSizeOnDisk
; Description....: Retrieves the file allocation size on disk.
; Syntax.........: _WinAPI_GetFileSizeOnDisk ( $sFile )
; Parameters.....: $sFile  - The name of the file to retrieve allocation size.
; Return values..: Success - The allocation size, in bytes. This value is a multiple of the sector or cluster size of the specified
;                            physical device.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileSizeOnDisk($sFile)

	Local $Size = FileGetSize($sFile)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

    Local $Ret = DllCall('kernel32.dll', 'int', 'GetDiskFreeSpaceW', 'wstr', _WinAPI_PathStripToRoot(_WinAPI_GetFullPathName($sFile)), 'dword*', 0, 'dword*', 0, 'dword*', 0, 'dword*', 0)

    If (@error) Or (Not $Ret[0]) Then
        Return SetError(1, 0, 0)
    EndIf
    Return Ceiling($Size / ($Ret[2] * $Ret[3])) * ($Ret[2] * $Ret[3])
EndFunc   ;==>_WinAPI_GetFileSizeOnDisk

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileTitle
; Description....: Retrieves the name of the specified file.
; Syntax.........: _WinAPI_GetFileTitle ( $sFile )
; Parameters.....: $sFile  - The name and location of a file.
; Return values..: Success - The name of the file.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: _WinAPI_GetFileTitle() should only be called with legal file names; using an illegal file name has an undefined result.
;
;                  _WinAPI_GetFileTitle() returns the string that the system would use to display the file name to the user.
;                  The display name includes an extension only if that is the user's preference for displaying file names. This means
;                  that the returned string may not accurately identify the file if it is used in calls to file system functions.
; Related........:
; Link...........: @@MsdnLink@@ GetFileTitle
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileTitle($sFile)

	Local $Ret = DllCall('comdlg32.dll', 'short', 'GetFileTitleW', 'wstr', $sFile, 'wstr', '', 'ushort', 4096)

	If (@error) Or ($Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetFileTitle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileType
; Description....: Retrieves the file type of the specified file.
; Syntax.........: _WinAPI_GetFileType ( $hFile )
; Parameters.....: $hFile  - Handle to the file.
; Return values..: Success - The file type ($FILE_TYPE_*).
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetFileType
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileType($hFile)

	Local $Ret = DllCall('kernel32.dll ', 'dword', 'GetFileType', 'ptr', $hFile)

	If @error Then
		Return SetError(1, 0, -1)
	Else
		If (Not $Ret[0]) And (_WinAPI_GetLastError()) Then
			Return SetError(1, 0, -1)
		EndIf
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetFileType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFileVersionInfo
; Description....: Retrieves version information for the specified file.
; Syntax.........: _WinAPI_GetFileVersionInfo ( $sFile, ByRef $pBuffer [, $iFlags] )
; Parameters.....: $sFile   - The name of the file.
;                  $pBuffer - A pointer to a memory block (buffer) that receives the file-version information. Optionaly, you can
;                             set this parameter to 0 before function call, then the function will allocate the required memory block
;                             itself. Otherwise, it must be a valid memory pointer returned by the _WinAPI_CreateBuffer()
;                             function, or by previously calling this function.
;                  $iFlags  - The flags that controls which MUI DLLs (if any) from which the version resource is extracted.
;                             It can be 0 or more of the following values (valid only for Windows Vista or later).
;
;                             $FILE_VER_GET_LOCALISED
;                             $FILE_VER_GET_NEUTRAL
;                             $FILE_VER_GET_PREFETCHED
;
; Return values..: Success  - The number of bytes copied to the buffer.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When you no longer need the buffer allocated by this function, you must call the _WinAPI_FreeMemory() function
;                  (do not use any other memory routines) to release occupied memory.
; Related........:
; Link...........: @@MsdnLink@@ GetFileVersionInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFileVersionInfo($sFile, ByRef $pBuffer, $iFlags = 0)

	Local $Ret

	If $__WINVER >= 0x0600 Then
		$Ret = DllCall('version.dll', 'dword', 'GetFileVersionInfoSizeExW', 'dword', BitAND($iFlags, 0x03), 'wstr', $sFile, 'ptr', 0)
	Else
		$Ret = DllCall('version.dll', 'dword', 'GetFileVersionInfoSizeW', 'wstr', $sFile, 'ptr', 0)
	EndIf
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$pBuffer = __HeapReAlloc($pBuffer, $Ret[0], 1)
	If @error Then
		Return SetError(9, 0, 0)
	EndIf
	If $__WINVER >= 0x0600 Then
		$Ret = DllCall('version.dll', 'int', 'GetFileVersionInfoExW', 'dword', BitAND($iFlags, 0x07), 'wstr', $sFile, 'dword', 0, 'dword', $Ret[0], 'ptr', $pBuffer)
	Else
		$Ret = DllCall('version.dll', 'int', 'GetFileVersionInfoW', 'wstr', $sFile, 'dword', 0, 'dword', $Ret[0], 'ptr', $pBuffer)
	EndIf
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	If $__WINVER >= 0x0600 Then
		Return $Ret[4]
	Else
		Return $Ret[3]
	EndIf
EndFunc   ;==>_WinAPI_GetFileVersionInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFinalPathNameByHandle
; Description....: Retrieves the final path of the specified file.
; Syntax.........: _WinAPI_GetFinalPathNameByHandle ( $hFile )
; Parameters.....: $hFile  - Handle to a file or directory whose path is to be retrieved.
; Return values..: Success - The path of the file.
;                  Failure - Empty string and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryInformationFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFinalPathNameByHandle($hFile)

	Local $tFNI, $tIOSB, $Ret, $Length

	$tFNI = DllStructCreate('ulong;wchar[4096]')
	$tIOSB = DllStructCreate('ptr;ulong_ptr')
	$Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryInformationFile', 'ptr', $hFile, 'ptr', DllStructGetPtr($tIOSB), 'ptr', DllStructGetPtr($tFNI), 'ulong', DllStructGetSize($tFNI), 'uint', 9)
	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
	$Length = DllStructGetData($tFNI, 1)
	If Not $Length Then
		Return SetError(2, 0, '')
	EndIf
	Return DllStructGetData(DllStructCreate('wchar[' & ($Length / 2) & ']', DllStructGetPtr($tFNI, 2)), 1)
EndFunc   ;==>_WinAPI_GetFinalPathNameByHandle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFinalPathNameByHandleEx
; Description....: Retrieves the final path of the specified file.
; Syntax.........: _WinAPI_GetFinalPathNameByHandleEx ( $hFile [, $iFlags] )
; Parameters.....: $hFile  - Handle to a file or directory.
;                  $iFlags - The type of result to return. This parameter can be combination of one $FILE_NAME_* and one
;                            $VOLUME_NAME_* values.
;
;                            $FILE_NAME_NORMALIZED
;                            $FILE_NAME_OPENED
;
;                            $VOLUME_NAME_DOS
;                            $VOLUME_NAME_GUID
;                            $VOLUME_NAME_NONE
;                            $VOLUME_NAME_NT
;
; Return values..: Success - The path of the file.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetFinalPathNameByHandle
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFinalPathNameByHandleEx($hFile, $iFlags = 0)

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetFinalPathNameByHandleW', 'ptr', $hFile, 'wstr', '', 'dword', 4096, 'dword', $iFlags)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetFinalPathNameByHandleEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFontResourceInfo
; Description....: Retrieves the fontname from the specified font resource file.
; Syntax.........: _WinAPI_GetFontResourceInfo ( $sFont [, $fForce] )
; Parameters.....: $sFont  - String that names a font resource file. To retrieve a fontname whose information comes from several
;                            resource files, they must be separated by a "|" . For example, abcxxxxx.pfm | abcxxxxx.pfb.
;                  $fForce - Specifies whether adds a file to the font table, valid values:
;                  |TRUE   - Forced add the specified file to the system font table and remove it after retrieving the fontname.
;                  |FALSE  - Don`t add and remove. (Default)
; Return values..: Success - The name of the font.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFontResourceInfo($sFont, $fForce = 0)

	If $fForce Then
		If Not _WinAPI_AddFontResourceEx($sFont, 0x20) Then
			Return SetError(1, 0, '')
		EndIf
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetFontResourceInfoW', 'wstr', $sFont, 'dword*', 4096, 'wstr', '', 'dword', 0x01)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	If $fForce Then
		_WinAPI_RemoveFontResourceEx($sFont, 0x20)
	EndIf
	If Not IsArray($Ret) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetFontResourceInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetForegroundWindow
; Description....: Returns a handle to the foreground window.
; Syntax.........: _WinAPI_GetForegroundWindow ( )
; Parameters.....: None
; Return values..: Success - Handle to the foreground window.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetForegroundWindow
; Example........: Yes
; ===============================================================================================================================

#cs

Func _WinAPI_GetForegroundWindow()

	Local $Ret = DllCall('user32.dll', 'hwnd', 'GetForegroundWindow')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetForegroundWindow

#ce

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFRBuffer
; Description....: Retrieves the current size of the internal buffer that used the _WinAPI_FindTextDlg() and _WinAPI_ReplaceTextDlg() functions.
; Syntax.........: _WinAPI_GetFRBuffer ( )
; Parameters.....: None
; Return values..: The size, in TCHARs, of the internal buffer.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFRBuffer()
	Return $__Buff - 1
EndFunc   ;==>_WinAPI_GetFRBuffer

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetFullPathName
; Description....: Retrieves the full path and file name of the specified file.
; Syntax.........: _WinAPI_GetFullPathName ( $sFile )
; Parameters.....: $sFile   - The name of the file.
; Return values..: Success  - The drive and path.
;                  Failure  - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_GetFullPathName() merges the name of the current drive and directory with a specified file name to
;                  determine the full path and file name of a specified file. This function does not verify that the resulting
;                  path and file name are valid, or that they see an existing file on the associated volume.
; Related........:
; Link...........: @@MsdnLink@@ GetFullPathName
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetFullPathName($sFile)

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetFullPathNameW', 'wstr', $sFile, 'dword', 4096, 'wstr', '', 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetFullPathName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetGeoInfo
; Description....: Retrieves information about a specified geographical location.
; Syntax.........: _WinAPI_GetGeoInfo ( $GEOID, $iType [, $iLanguage] )
; Parameters.....: $GEOID     - The identifier for the geographical location (GEOID) for which to get information.
;                  $iType     - The type of information to retrieve. It can be one of the following values.
;
;                               $GEO_NATION
;                               $GEO_LATITUDE
;                               $GEO_LONGITUDE
;                               $GEO_ISO2
;                               $GEO_ISO3
;                               $GEO_LCID
;                               $GEO_FRIENDLYNAME
;                               $GEO_OFFICIALNAME
;                               $GEO_TIMEZONES
;                               $GEO_OFFICIALLANGUAGES
;
;                               Windows Vista or later
;
;                               $GEO_RFC1766
;
;                               Windows 8 or later
;
;                               $GEO_ISO_UN_NUMBER
;                               $GEO_PARENT
;
;                  $iLanguage - The language identifier, used with the geographical location.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetGeoInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetGeoInfo($GEOID, $iType, $iLanguage = 0)

    Local $Ret = DllCall('kernel32.dll', 'int', 'GetGeoInfoW', 'long', $GEOID, 'uint', $iType, 'wstr', '', 'int', 4096, 'ushort', $iLanguage)

    If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
    Return $Ret[3]
EndFunc   ;==>_WinAPI_GetGeoInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetGlyphOutline
; Description....: Retrieves the outline or bitmap for a character in the TrueType font.
; Syntax.........: _WinAPI_GetGlyphOutline ( $hDC, $sChar, $iFormat, ByRef $pBuffer [, $tMAT2] )
; Parameters.....: $hDC     - A handle to the device context which font is selected.
;                  $sChar   - The character for which data is to be returned.
;                  $iFormat - The format of the data that the function retrieves. This parameter can be one of the following values.
;
;                             $GGO_BEZIER
;                             $GGO_BITMAP
;                             $GGO_GLYPH_INDEX
;                             $GGO_GRAY2_BITMAP
;                             $GGO_GRAY4_BITMAP
;                             $GGO_GRAY8_BITMAP
;                             $GGO_METRICS
;                             $GGO_NATIVE
;                             $GGO_UNHINTED
;
;                  $pBuffer - A pointer to a memory block (buffer) that receives the outline or bitmap data. Optionaly, you can
;                             set this parameter to 0 before function call, then the function will allocate the required memory block
;                             itself. Otherwise, it must be a valid memory pointer returned by the _WinAPI_CreateBuffer()
;                             function, or by previously calling this function. If the $GGO_METRICS is specified, this parameter is
;                             ignored, and function only returns the information about a glyph (see below).
;                  $tMAT2   - $tagMAT2 structure specifying a transformation matrix for the character. If this parameter is
;                             0 or omitted, the transformation will not be used (it is identity matrix).
; Return values..: Success  - $tagGLYPHMETRICS structure containing information about the placement and orientation of a glyph,
;                             @extended flag returns a number of bytes copied to the buffer (if used), in bytes.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Note that, for the $GGO_GRAY... values, the function retrieves a glyph bitmap that contains n^2+1 (n squared plus
;                  one) levels of gray.
;
;                  The glyph bitmap returned by _WinAPI_GetGlyphOutline() when $GGO_BITMAP is specified is a DWORD-aligned, row-oriented,
;                  monochrome bitmap. When $GGO_GRAY2_BITMAP is specified, the bitmap returned is a DWORD-aligned, row-oriented array
;                  of bytes whose values range from 0 to 4. When $GGO_GRAY4_BITMAP is specified, the bitmap returned is a DWORD-aligned,
;                  row-oriented array of bytes whose values range from 0 to 16. When $GGO_GRAY8_BITMAP is specified, the bitmap
;                  returned is a DWORD-aligned, row-oriented array of bytes whose values range from 0 to 64.
;
;                  When you no longer need the buffer allocated by this function, you must call the _WinAPI_FreeMemory() function
;                  (do not use any other memory routines) to release occupied memory.
; Related........:
; Link...........: @@MsdnLink@@ GetGlyphOutline
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetGlyphOutline($hDC, $sChar, $iFormat, ByRef $pBuffer, $tMAT2 = 0)

	Local $tGM = DllStructCreate($tagGLYPHMETRICS)
	Local $Ret, $Length = 0

	If Not IsDllStruct($tMAT2) Then
		$tMAT2 = DllStructCreate('short[8]')
		DllStructSetData($tMAT2, 1, 1, 2)
		DllStructSetData($tMAT2, 1, 1, 8)
	EndIf
	Switch $iFormat
		Case 0
			; Nothing
		Case Else
			$Ret = DllCall('gdi32.dll', 'int', 'GetGlyphOutlineW', 'hwnd', $hDC, 'uint', AscW($sChar), 'uint', $iFormat, 'ptr', DllStructGetPtr($tGM), 'dword', 0, 'ptr', 0, 'ptr', DllStructGetPtr($tMAT2))
			If (@error) Or ($Ret[0] = -1) Then
				Return SetError(1, 0, 0)
			EndIf
			$Length = $Ret[0]
			$pBuffer = __HeapReAlloc($pBuffer,  $Length, 1)
			If @error Then
				Return SetError(9, 0, 0)
			EndIf
	EndSwitch
	$Ret = DllCall('gdi32.dll', 'int', 'GetGlyphOutlineW', 'hwnd', $hDC, 'uint', AscW($sChar), 'uint', $iFormat, 'ptr', DllStructGetPtr($tGM), 'dword', $Length, 'ptr', $pBuffer, 'ptr', DllStructGetPtr($tMAT2))
	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, $Length, $tGM)
EndFunc   ;==>_WinAPI_GetGlyphOutline

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetGraphicsMode
; Description....: Retrieves the current graphics mode for the specified device context.
; Syntax.........: _WinAPI_GetGraphicsMode ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The current graphics mode ($GM_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetGraphicsMode
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetGraphicsMode($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetGraphicsMode', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetGraphicsMode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetGUIThreadInfo
; Description....: Retrieves information about the active window or a specified GUI thread.
; Syntax.........: _WinAPI_GetGUIThreadInfo ( $iThreadID )
; Parameters.....: $iThreadID - The identifier for the thread for which information is to be retrieved.
; Return values..: Success    - The array that contains the following information:
;
;                               [0 ] - The thread state. It can be one or more of the $GUI_* values.
;                               [1 ] - A handle to the active window within the thread.
;                               [2 ] - A handle to the window that has the keyboard focus.
;                               [3 ] - A handle to the window that has captured the mouse.
;                               [4 ] - A handle to the window that owns any active menus.
;                               [5 ] - A handle to the window in a move or size loop.
;                               [6 ] - A handle to the window that is displaying the caret.
;                               [7 ] - The x-coordinate of the upper-left corner of the caret's bounding rectangle, in client coordinates.
;                               [8 ] - The y-coordinate of the upper-left corner of the caret's bounding rectangle, in client coordinates.
;                               [9 ] - The width of the caret's bounding rectangle.
;                               [10] - The height of the caret's bounding rectangle.
;
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: KaFu
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetGUIThreadInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetGUIThreadInfo($iThreadID)

	Local $tGUITI = DllStructCreate('dword;dword;hwnd;hwnd;hwnd;hwnd;hwnd;hwnd;long;long;long;long')

	DllStructSetData($tGUITI, 1, DllStructGetSize($tGUITI))

	Local $Ret = DllCall('user32.dll', 'int', 'GetGUIThreadInfo', 'dword', $iThreadID, 'ptr', DllStructGetPtr($tGUITI))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[11]

	For $i = 0 To 10
		$Result[$i] = DllStructGetData($tGUITI, $i + 2)
	Next
	For $i = 9 To 10
		$Result[$i] -= $Result[$i - 2]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetGUIThreadInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetGValue
; Description....: Retrieves an intensity value for the green component of a 32-bit RGB value.
; Syntax.........: _WinAPI_GetGValue ( $iRGB )
; Parameters.....: $iRGB - The color value, in RGB.
; Return values..: The intensity of the green component of the specified RGB color.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetGValue($iRGB)
	Return BitShift(BitAND(__RGB($iRGB), 0x00FF00), 8)
EndFunc   ;==>_WinAPI_GetGValue

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetHandleInformation
; Description....: Retrieves certain properties of an object handle.
; Syntax.........: _WinAPI_GetHandleInformation ( $hObject )
; Parameters.....: $hObject - Handle to an object whose information is to be retrieved.
; Return values..: Success  - The value that specifies the properties of the object handle ($HANDLE_FLAG_*).
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetHandleInformation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetHandleInformation($hObject)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetHandleInformation', 'ptr', $hObject, 'dword*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetHandleInformation

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetHGlobalFromStream
; Description....: Retrieves the global memory handle to a stream.
; Syntax.........: _WinAPI_GetHGlobalFromStream ( $pStream )
; Parameters.....: $pStream - Pointer to the stream object previously created by a call to the _WinAPI_CreateStreamOnHGlobal() function.
; Return values..: Success  - Pointer to the current memory handle used by the specified stream object.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function can be called only from within the same process from which the byte array was created.
; Related........:
; Link...........: @@MsdnLink@@ GetHGlobalFromStream
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetHGlobalFromStream($pStream)

	Local $Ret = DllCall('ole32.dll', 'uint', 'GetHGlobalFromStream', 'ptr', $pStream, 'ptr*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetHGlobalFromStream

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetIconDimension
; Description....: Retrieves a dimension of the specified icon.
; Syntax.........: _WinAPI_GetIconDimension ( $hIcon )
; Parameters.....: $hIcon  - Handle to the icon to retrieve dimension.
; Return values..: Success - $tagSIZE structure that contains the icon dimension, in pixels.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetIconDimension($hIcon)

	Local $tICONINFO = DllStructCreate($tagICONINFO)
	Local $Ret = DllCall('user32.dll', 'int', 'GetIconInfo', 'ptr', $hIcon, 'ptr', DllStructGetPtr($tICONINFO))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tSIZE = _WinAPI_GetBitmapDimension(DllStructGetData($tICONINFO, 5))

	For $i = 4 To 5
		_WinAPI_DeleteObject(DllStructGetData($tICONINFO, $i))
	Next
	If Not IsDllStruct($tSIZE) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tSIZE
EndFunc   ;==>_WinAPI_GetIconDimension

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetIconInfoEx
; Description....: Retrieves information about the specified icon or cursor.
; Syntax.........: _WinAPI_GetIconInfoEx ( $hIcon )
; Parameters.....: $hIcon  - Handle to the icon or cursor. To retrieve information about a standard icon or cursor, use $IDC_* constants.
; Return values..: Success - The array that contains the following information:
;
;                            [0] - A value of 1 specifies an icon; 0 specifies a cursor.
;                            [1] - The x-coordinate of the cursor's hot spot.
;                            [2] - The y-coordinate of the cursor's hot spot.
;                            [3] - A handle to the icon bitmask bitmap.
;                            [4] - A handle to the icon color bitmap.
;                            [5] - The icon or cursor resource bits.
;                            [6] - The fully qualified path of the module.
;                            [7] - The fully qualified path of the resource.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_GetIconInfoEx() creates bitmaps [3] and [4]. The calling application must manage these bitmaps and
;                  delete them when they are no longer necessary.
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetIconInfoEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetIconInfoEx($hIcon)

	Local $tIIEX = DllStructCreate('dword;int;dword;dword;ptr;ptr;ushort;wchar[260];wchar[260]')

	DllStructSetData($tIIEX, 1, DllStructGetSize($tIIEX))

	Local $Ret = DllCall('user32.dll', 'int', 'GetIconInfoExW', 'ptr', $hIcon, 'ptr', DllStructGetPtr($tIIEX))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[8]

	For $i = 0 To 7
		$Result[$i] = DllStructGetData($tIIEX, $i + 2)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetIconInfoEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetIdleTime
; Description....: Retrieves the time that has elapsed since the last input.
; Syntax.........: _WinAPI_GetIdleTime ( )
; Parameters.....: None
; Return values..: Success - The elapsed time, in milliseconds.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetLastInputInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetIdleTime()

	Local $tLASTINPUTINFO = DllStructCreate('uint;dword')

	DllStructSetData($tLASTINPUTINFO, 1, DllStructGetSize($tLASTINPUTINFO))

	Local $Ret = DllCall('user32.dll', 'int', 'GetLastInputInfo', 'ptr', DllStructGetPtr($tLASTINPUTINFO))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return _WinAPI_GetTickCount() - DllStructGetData($tLASTINPUTINFO, 2)
EndFunc   ;==>_WinAPI_GetIdleTime

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetKeyboardLayout
; Description....: Retrieves the active input locale identifier for the specified window.
; Syntax.........: _WinAPI_GetKeyboardLayout ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to retrieve the input locale identifier.
; Return values..: Success - The input locale identifier.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetKeyboardLayout
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetKeyboardLayout($hWnd)

	Local $Ret

	$Ret = DllCall('user32.dll', 'dword', 'GetWindowThreadProcessId', 'hwnd', $hWnd, 'ptr', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	$Ret = DllCall('user32.dll', 'uint_ptr', 'GetKeyboardLayout', 'dword', $Ret[0])
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetKeyboardLayout

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetKeyboardLayoutList
; Description....: Retrieves the all input locale identifiers corresponding to the current set of input locales in the system.
; Syntax.........: _WinAPI_GetKeyboardLayoutList ( )
; Parameters.....: None
; Return values..: Success - The array of input locale identifiers. The zeroth array element contains the number of identifiers.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetKeyboardLayoutList
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetKeyboardLayoutList()

	Local $Ret

	$Ret = DllCall('user32.dll', 'uint', 'GetKeyboardLayoutList', 'int', 0, 'ptr', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tData = DllStructCreate('uint_ptr[' & $Ret[0] & ']')

	$Ret = DllCall('user32.dll', 'uint', 'GetKeyboardLayoutList', 'int', $Ret[0], 'ptr', DllStructGetPtr($tData))
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $List[$Ret[0] + 1] = [$Ret[0]]

	For $i = 1 To $List[0]
		$List[$i] = DllStructGetData($tData, 1, $i)
	Next
	Return $List
EndFunc   ;==>_WinAPI_GetKeyboardLayoutList

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetKeyboardState
; Description....: Copies the status of the 256 virtual keys to the specified buffer.
; Syntax.........: _WinAPI_GetKeyboardState ( )
; Parameters.....: None
; Return values..: Success - The structure of "byte[256]" that receives the status data for each virtual key.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: An application can call this function to retrieve the current status of all the virtual keys. The status changes
;                  as a process removes keyboard messages from its message queue. The status does not change as keyboard messages are
;                  posted to the process's message queue, nor does it change as keyboard messages are posted to or retrieved from
;                  message queues of other processes.
;
;                  When the function returns, each member of the array contains status data for a virtual key. If the high-order
;                  bit is 1, the key is down; otherwise, it is up. If the key is a toggle key, for example CAPS LOCK, then the
;                  low-order bit is 1 when the key is toggled and is 0 if the key is untoggled. The low-order bit is meaningless for
;                  non-toggle keys. A toggle key is said to be toggled when it is turned on. A toggle key's indicator light (if any)
;                  on the keyboard will be on when the key is toggled, and off when the key is untoggled.
;
;                  To retrieve status information for an individual key, use the _WinAPI_GetKeyState() function. To retrieve the
;                  current state for an individual key regardless of whether the corresponding keyboard message has been retrieved
;                  from the message queue, use the _WinAPI_GetAsyncKeyState() function.
;
; Related........:
; Link...........: @@MsdnLink@@ GetKeyboardState
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetKeyboardState()

	Local $tData = DllStructCreate('byte[256]')
	Local $Ret = DllCall('user32.dll', 'int', 'GetKeyboardState', 'ptr', DllStructGetPtr($tData))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tData
EndFunc   ;==>_WinAPI_GetKeyboardState

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetKeyboardType
; Description....: Retrieves information about the current keyboard.
; Syntax.........: _WinAPI_GetKeyboardType ( $iType )
; Parameters.....: $iType   - The type of keyboard information to be retrieved, valid values:
;                  |0 - Keyboard type.
;                  |1 - Keyboard subtype (original equipment manufacturer (OEM)-dependent value).
;                  |2 - The number of function keys on the keyboard.
; Return values..: Success  - The value that specifies the requested information. If $iType is 0, return value may be one of the following values.
;                  |1 - IBM PC/XT or compatible (83-key) keyboard.
;                  |2 - Olivetti "ICO" (102-key) keyboard.
;                  |3 - IBM PC/AT (84-key) or similar keyboard.
;                  |4 - IBM enhanced (101- or 102-key) keyboard.
;                  |5 - Nokia 1050 and similar keyboards.
;                  |6 - Nokia 9140 and similar keyboards.
;                  |7 - Japanese keyboard.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When a single USB keyboard is connected to the computer, this function returns the code 81.
; Related........:
; Link...........: @@MsdnLink@@ GetKeyboardType
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetKeyboardType($iType)

	Local $Ret = DllCall('user32.dll', 'int', 'GetKeyboardType', 'int', $iType)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetKeyboardType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetKeyNameText
; Description....: Retrieves a string that represents the name of a key.
; Syntax.........: _WinAPI_GetKeyNameText ( $lParam )
; Parameters.....: $lParam - Specifies the second parameter of the keyboard message (such as WM_KEYDOWN) to be processed.
; Return values..: Success - String containing the name of the key.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The format of the key-name string depends on the current keyboard layout. The keyboard driver maintains a list
;                  of names in the form of character strings for keys with names longer than a single character. The key name
;                  is translated according to the layout of the currently installed keyboard, thus the function may give different
;                  results for different input locales. The name of a character key is the character itself. The names of dead
;                  keys are spelled out in full.
; Related........:
; Link...........: @@MsdnLink@@ GetKeyNameText
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetKeyNameText($lParam)

	Local $Ret = DllCall('user32.dll', 'int', 'GetKeyNameTextW', 'long', $lParam, 'wstr', '', 'int', 128)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetKeyNameText

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetKeyState
; Description....: Retrieves the status of the specified virtual key.
; Syntax.........: _WinAPI_GetKeyState ( $vKey )
; Parameters.....: $vKey   - Specifies a virtual key ($VK_*). If the desired virtual key is a letter or digit (A through Z,
;                            a through z, or 0 through 9).
; Return values..: Success - The value that specifies the status of the specified virtual key. If the high-order bit is 1, the key is
;                            down; otherwise, it is up. If the low-order bit is 1, the key is toggled. A key, such as the
;                            CAPS LOCK key, is toggled if it is turned on. The key is off and untoggled if the low-order bit is 0.
;                            A toggle key's indicator light (if any) on the keyboard will be on when the key is toggled, and off
;                            when the key is untoggled.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The key status returned from this function changes as a process reads key messages from its message queue.
;                  The status does not reflect the interrupt-level state associated with the hardware. Use the _WinAPI_GetAsyncKeyState()
;                  function to retrieve that information.
; Related........:
; Link...........: @@MsdnLink@@ GetKeyState
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetKeyState($vKey)

	Local $Ret = DllCall('user32.dll', 'int', 'GetKeyState', 'int', $vKey)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetKeyState

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetLastActivePopup
; Description....: Determines which pop-up window owned by the specified window was most recently active.
; Syntax.........: _WinAPI_GetLastActivePopup ( $hWnd )
; Parameters.....: $hWnd   - Handle to the owner window.
; Return values..: Success - Handle of the most recently active pop-up window.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetLastActivePopup
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetLastActivePopup($hWnd)

	Local $Ret = DllCall('user32.dll', 'hwnd', 'GetLastActivePopup', 'hwnd', $hWnd)

	If (@error) Or (Not $Ret[0]) Or ($Ret[0] = $hWnd) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetLastActivePopup

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetLayeredWindowAttributes
; Description....: Retrieves the opacity and transparency color key of a layered window.
; Syntax.........: _WinAPI_GetLayeredWindowAttributes ( $hWnd )
; Parameters.....: $hWnd   - Handle to the layered window.
; Return values..: Success - The array containing the following information:
;
;                            [0] - The transparency color key to be used when composing the layered window. All pixels painted
;                                  by the window in this color will be transparent. This can be 0 if the argument is not needed.
;                            [1] - The alpha value used to describe the opacity of the layered window. When the variable is 0,
;                                  the window is completely transparent. When the variable is 255, the window is opaque.
;                                  This can be 0 if the argument is not needed.
;                            [2] - The layering flag ($LWA_*).
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Progandy
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetLayeredWindowAttributes
; Example........: Yes
; ===============================================================================================================================

#cs

Func _WinAPI_GetLayeredWindowAttributes($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'GetLayeredWindowAttributes', 'hwnd', $hWnd, 'long*', 0, 'byte*', 0, 'long*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[3]

	$Result[0] = __RGB($Ret[2])
	$Result[1] = $Ret[3]
	$Result[2] = $Ret[4]

	Return $Result
EndFunc   ;==>_WinAPI_GetLayeredWindowAttributes

#ce

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetLocaleInfo
; Description....: Retrieves information about a locale specified by identifier.
; Syntax.........: _WinAPI_GetLocaleInfo ( $LCID, $iType )
; Parameters.....: $LCID   - The locale identifier (LCID) that specifies the locale or one of the following predefined values.
;
;                            $LOCALE_INVARIANT
;                            $LOCALE_SYSTEM_DEFAULT
;                            $LOCALE_USER_DEFAULT
;
;                            Windows Vista or later
;
;                            $LOCALE_CUSTOM_DEFAULT
;                            $LOCALE_CUSTOM_UI_DEFAULT
;                            $LOCALE_CUSTOM_UNSPECIFIED
;
;                  $iType  - The one of the locale information constants ($LOCALE_*) to retrieve.
; Return values..: Success - String containing the requested information.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: WideBoyDixon
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetLocaleInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetLocaleInfo($LCID, $iType)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetLocaleInfoW', 'ulong', $LCID, 'dword', $iType, 'wstr', '', 'int', 2048)

    If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
    Return $Ret[3]
EndFunc   ;==>_WinAPI_GetLocaleInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetLogicalDrives
; Description....: Retrieves a bitmask representing the currently available disk drives.
; Syntax.........: _WinAPI_GetLogicalDrives ( )
; Parameters.....: None
; Return values..: Success - The value is a bitmask representing the currently available disk drives. Bit position 0 (the least-significant bit)
;                            is drive A, bit position 1 is drive B, bit position 2 is drive C, and so on.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetLogicalDrives
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetLogicalDrives()

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetLogicalDrives')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetLogicalDrives

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetMapMode
; Description....: Retrieves the current mapping mode.
; Syntax.........: _WinAPI_GetMapMode ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The value specifies the mapping mode (MM_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetMapMode
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetMapMode($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetMapMode', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetMapMode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetMemorySize
; Description....: Retrieves the size of a memory block allocated from the internal library heap.
; Syntax.........: _WinAPI_GetMemorySize ( $pMemory )
; Parameters.....: $pMemory - A pointer to the valid memory block whose size to be retrieved.
; Return values..: Success  - The size of the specified memory block, in bytes.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_GetMemorySize() function accepts only the pointers returned by some _WinAPI_* functions (see description).
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetMemorySize($pMemory)

	Local $Result = __HeapSize($pMemory, 1)

	If @error Then
		Return SetError(@error, 0, 0)
	EndIf
	Return $Result
EndFunc   ;==>_WinAPI_GetMemorySize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetMessageExtraInfo
; Description....: Retrieves the extra message information for the current thread.
; Syntax.........: _WinAPI_GetMessageExtraInfo ( )
; Parameters.....: None
; Return values..: Success - The value associated with the current thread.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetMessageExtraInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetMessageExtraInfo()

	Local $Ret = DllCall('user32.dll', 'lparam', 'GetMessageExtraInfo')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetMessageExtraInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetModuleFileNameEx
; Description....: Retrieves the fully-qualified path for the file containing the specified module.
; Syntax.........: _WinAPI_GetModuleFileNameEx ( $hProcess [, $hModule] )
; Parameters.....: $hProcess - Handle to the process that contains the module. The handle must have the $PROCESS_QUERY_INFORMATION or
;                              $PROCESS_QUERY_LIMITED_INFORMATION access right and the $PROCESS_VM_READ access right.
;                  $hModule  - Handle to the module. If this parameter is 0, the function retrieves the path of the executable
;                              file of the process.
; Return values..: Success   - The fully-qualified path to the module.
;                  Failure   - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function does not retrieve the path for modules that were loaded using the $LOAD_LIBRARY_AS_DATAFILE flag.
;                  For more information, see _WinAPI_LoadLibraryEx().
; Related........:
; Link...........: @@MsdnLink@@ GetModuleFileNameEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetModuleFileNameEx($hProcess, $hModule = 0)

	Local $Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'GetModuleFileNameExW', 'ptr', $hProcess, 'ptr', $hModule, 'wstr', '', 'int', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetModuleFileNameEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetModuleHandleEx
; Description....: Retrieves a module handle for the specified module.
; Syntax.........: _WinAPI_GetModuleHandleEx ( $sModule [, $iFlags] )
; Parameters.....: $sModule - The name of the loaded module (either a .dll or .exe file), or a pointer to an address in the module
;                             (if the $GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS flag is specified). If this parameter is 0 or an empty
;                             string, the function returns a handle to the file used to create the calling process (.exe file).
;                  $iFlags  - This parameter can be one or more of the following values.
;
;                             $GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS
;                             $GET_MODULE_HANDLE_EX_FLAG_PIN
;                             $GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT
;                             $GET_MODULE_HANDLE_EX_FLAG_DEFAULT
;
; Return values..: Success  - Handle to the specified module.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetModuleHandleEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetModuleHandleEx($sModule, $iFlags = 0)

	Local $TypeOfModule = 'ptr'

	If IsString($sModule) Then
		If StringStripWS($sModule, 3) Then
			$TypeOfModule = 'wstr'
		Else
			$sModule = 0
		EndIf
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetModuleHandleExW', 'dword', $iFlags, $TypeOfModule, $sModule, 'ptr*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetModuleHandleEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetModuleInformation
; Description....: Retrieves information about the specified module.
; Syntax.........: _WinAPI_GetModuleInformation ( $hProcess, $hModule )
; Parameters.....: $hProcess - Handle to the process that contains the module. The handle must have the $PROCESS_QUERY_INFORMATION or
;                              $PROCESS_QUERY_LIMITED_INFORMATION access right and the $PROCESS_VM_READ access right.
;                  $hModule  - Handle to the module. If this parameter is 0, the function retrieves information only about the
;                              executable file ("SizeOfImage" and "EntryPoint" members of the $tagMODULEINFO structure).
; Return values..: Success   - $tagMODULEINFO structure that contains information about the module.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function does not retrieve information for modules that were loaded with the $LOAD_LIBRARY_AS_DATAFILE flag.
;                  For more information, see _WinAPI_LoadLibraryEx().
; Related........:
; Link...........: @@MsdnLink@@ GetModuleInformation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetModuleInformation($hProcess, $hModule = 0)

	Local $tMODULEINFO = DllStructCreate($tagMODULEINFO)
	Local $Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'GetModuleInformation', 'ptr', $hProcess, 'ptr', $hModule, 'ptr', DllStructGetPtr($tMODULEINFO), 'dword', DllStructGetSize($tMODULEINFO))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tMODULEINFO
EndFunc   ;==>_WinAPI_GetModuleInformation

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetMonitorInfo
; Description....: Retrieves information about a display monitor.
; Syntax.........: _WinAPI_GetMonitorInfo ( $hMonitor )
; Parameters.....: $hMonitor - A handle to the display monitor of interest.
; Return values..: Success   - The array containing the following information:
;
;                              [0] - $tagRECT structure that specifies the display monitor rectangle, in virtual-screen coordinates.
;                              [1] - $tagRECT structure that specifies the work area rectangle of the display monitor that can be used by applications, in virtual-screen coordinates.
;                              [2] - 1 (True) for the primary display monitor, or 0 (False) otherwise.
;                              [3] - The device name of the monitor being used, e.g. "\\.\DISPLAY1".
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetMonitorInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetMonitorInfo($hMonitor)

	Local $tMIEX = DllStructCreate('dword;long[4];long[4];dword;wchar[32]')

	DllStructSetData($tMIEX, 1, DllStructGetSize($tMIEX))

	Local $Ret = DllCall('user32.dll', 'int', 'GetMonitorInfoW', 'ptr', $hMonitor, 'ptr', DllStructGetPtr($tMIEX))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[4]

	For $i = 0 To 1
		$Result[$i] = DllStructCreate($tagRECT)
		If Not _WinAPI_MoveMemory(DllStructGetPtr($Result[$i]), DllStructGetPtr($tMIEX, $i + 1), 16) Then
			Return SetError(1, 0, 0)
		EndIf
	Next
	$Result[3] = DllStructGetData($tMIEX, 5)
	Switch DllStructGetData($tMIEX, 4)
		Case 1 ; MONITORINFOF_PRIMARY
			$Result[2] = 1
		Case Else
			$Result[2] = 0
	EndSwitch
	Return $Result
EndFunc   ;==>_WinAPI_GetMonitorInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetNumberFormat
; Description....: Formats a number string as a number string customized for a locale specified by identifier.
; Syntax.........: _WinAPI_GetNumberFormat ( $LCID, $sNumber [, $tNUMBERFMT] )
; Parameters.....: $LCID       - The locale identifier (LCID) that specifies the locale or one of the following predefined values.
;
;                                $LOCALE_INVARIANT
;                                $LOCALE_SYSTEM_DEFAULT
;                                $LOCALE_USER_DEFAULT
;
;                                Windows Vista or later
;
;                                $LOCALE_CUSTOM_DEFAULT
;                                $LOCALE_CUSTOM_UI_DEFAULT
;                                $LOCALE_CUSTOM_UNSPECIFIED
;
;                  $sNumber    - The string containing the number string to format. This string can only contain the following
;                                characters. All other characters are invalid.
;
;                                Characters "0" through "9".
;                                A minus sign in the first character position if the number is a negative value.
;                                One decimal point (dot) if the number is a floating-point value.
;
;                  $tNUMBERFMT - $tagNUMBERFMT structure that contains number formatting information. If this parameter is omitted
;                                or 0, the function returns the string according to the number format for the specified locale.
;                                You can use the _WinAPI_CreateNumberFormatInfo() function to create this structure.
; Return values..: Success     - The formatted number string.
;                  Failure     - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetNumberFormat
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetNumberFormat($LCID, $sNumber, $tNUMBERFMT = 0)

	If Not $LCID Then
		$LCID = 0x0400
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetNumberFormatW', 'ulong', $LCID, 'dword', 0, 'wstr', $sNumber, 'ptr', DllStructGetPtr($tNUMBERFMT), 'wstr', '', 'int', 2048)

    If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
    Return $Ret[5]
EndFunc   ;==>_WinAPI_GetNumberFormat

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetObjectID
; Description....: Retrieves the object identifier for the specified file or directory.
; Syntax.........: _WinAPI_GetObjectID ( $sPath )
; Parameters.....: $sPath  - Path to the file or directory from which the object identifier is to be retrieved.
; Return values..: Success - $tagGUID structure that contains the object identifier for the file or directory within the volume on which it resides.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Unlike _WinAPI_CreateObjectID(), this function only returns the object identifier. If a file or directory does not
;                  have an object identifier, the function fails.
; Related........:
; Link...........: @@MsdnLink@@ FSCTL_GET_OBJECT_ID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetObjectID($sPath)

	Local $hFile = _WinAPI_CreateFileEx($sPath, 3, 0, 0x03, 0x02000000)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tFOID = DllStructCreate('byte[16];byte[48]')
	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x0009009C, 'ptr', 0, 'dword', 0, 'ptr', DllStructGetPtr($tFOID), 'dword', DllStructGetSize($tFOID), 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf

	Local $tGUID = DllStructCreate($tagGUID)

	If Not _WinAPI_MoveMemory(DllStructGetPtr($tGUID), DllStructGetPtr($tFOID), 16) Then
		Return SetError(3, 0, 0)
	EndIf
	Return $tGUID
EndFunc   ;==>_WinAPI_GetObjectID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetObjectInfoByHandle
; Description....: Retrieves information about a specified object.
; Syntax.........: _WinAPI_GetObjectInfoByHandle ( $hObject )
; Parameters.....: $hObject - A handle to the object to obtain information about.
; Return values..: Success  - The array containing the following information:
;
;                             [0] - The attributes of the object.
;                             [1] - A mask that represents the granted access to the object.
;                             [2] - The number of handles to the object.
;                             [3] - The number of pointers to the object.
;
;                  Failure  - 0 string and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryObject
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetObjectInfoByHandle($hObject)

	Local $tPOBI = DllStructCreate('ulong;ulong;ulong;ulong;ulong[10]')
	Local $Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryObject', 'ptr', $hObject, 'uint', 0, 'ptr', DllStructGetPtr($tPOBI), 'ulong', DllStructGetSize($tPOBI), 'ptr', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf

	Local $Result[4]

	For $i = 0 To 3
		$Result[$i] = DllStructGetData($tPOBI, $i + 1)
	Next

	Return $Result
EndFunc   ;==>_WinAPI_GetObjectInfoByHandle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetObjectNameByHandle
; Description....: Retrieves a name of the specified object.
; Syntax.........: _WinAPI_GetObjectNameByHandle ( $hObject )
; Parameters.....: $hObject - A handle to the object to obtain its name.
; Return values..: Success  - The name of the object.
;                  Failure  - Empty string and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryObject
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetObjectNameByHandle($hObject)

	Local $tPOTI = DllStructCreate('ushort;ushort;ptr;byte[128]')
	Local $Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryObject', 'ptr', $hObject, 'uint', 2, 'ptr', DllStructGetPtr($tPOTI), 'ulong', DllStructGetSize($tPOTI), 'ptr', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf

	Local $pData = DllStructGetData($tPOTI, 3)

	If Not $pData Then
		Return SetError(1, 0, 0)
	EndIf
	Return _WinAPI_GetString($pData)
EndFunc   ;==>_WinAPI_GetObjectNameByHandle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetObjectType
; Description....: Retrieves the type of the specified object.
; Syntax.........: _WinAPI_GetObjectType ( $hObject )
; Parameters.....: $hObject - Handle to the graphics object.
; Return values..: Success  - The value identifies the object ($OBJ_*).
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetObjectType
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetObjectType($hObject)

	Local $Ret  = DllCall('gdi32.dll', 'dword', 'GetObjectType', 'ptr', $hObject)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetObjectType

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetOutlineTextMetrics
; Description....: Retrieves text metrics for TrueType fonts.
; Syntax.........: _WinAPI_GetOutlineTextMetrics ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - $tagOUTLINETEXTMETRIC structure that contains the text metrics.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetOutlineTextMetrics
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetOutlineTextMetrics($hDC)

	Local $Ret, $tOLTM

	$Ret = DllCall('gdi32.dll', 'uint', 'GetOutlineTextMetricsW', 'hwnd', $hDC, 'uint', 0, 'ptr', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
;	$tOLTM = DllStructCreate($tagOUTLINETEXTMETRIC)
	$tOLTM = DllStructCreate('uint otmSize;long tmHeight;long tmAscent;long tmDescent;long tmInternalLeading;long tmExternalLeading;long tmAveCharWidth;long tmMaxCharWidth;long tmWeight;long tmOverhang;long tmDigitizedAspectX;long tmDigitizedAspectY;wchar tmFirstChar;wchar tmLastChar;wchar tmDefaultChar;wchar tmBreakChar;byte tmItalic;byte tmUnderlined;byte tmStruckOut;byte tmPitchAndFamily;byte tmCharSet;byte otmFiller[4];' & $tagPANOSE & 'uint otmSelection;uint otmType;int otmCharSlopeRise;int otmCharSlopeRun;int otmItalicAngle;uint otmEMSquare;int otmAscent;int otmDescent;uint otmLineGap;uint otmCapEmHeight;uint otmXHeight;long otmFontBox[4];int otmMacAscent;int otmMacDescent;uint otmMacLineGap;uint otmMinimumPPEM;long otmSubscriptSize[2];long otmSubscriptOffset[2];long otmSuperscriptSize[2];long otmSuperscriptOffset[2];uint otmStrikeoutSize;int otmStrikeoutPosition;int otmUnderscoreSize;int otmUnderscorePosition;uint_ptr otmFamilyName;uint_ptr otmFaceName;uint_ptr otmStyleName;uint_ptr otmFullName')
;	$tOLTM = DllStructCreate($tagOUTLINETEXTMETRIC & 'byte[' & ($Ret[0] - DllStructGetSize($tOLTM)) & ']')
	$tOLTM = DllStructCreate('uint otmSize;long tmHeight;long tmAscent;long tmDescent;long tmInternalLeading;long tmExternalLeading;long tmAveCharWidth;long tmMaxCharWidth;long tmWeight;long tmOverhang;long tmDigitizedAspectX;long tmDigitizedAspectY;wchar tmFirstChar;wchar tmLastChar;wchar tmDefaultChar;wchar tmBreakChar;byte tmItalic;byte tmUnderlined;byte tmStruckOut;byte tmPitchAndFamily;byte tmCharSet;byte otmFiller[4];' & $tagPANOSE & 'uint otmSelection;uint otmType;int otmCharSlopeRise;int otmCharSlopeRun;int otmItalicAngle;uint otmEMSquare;int otmAscent;int otmDescent;uint otmLineGap;uint otmCapEmHeight;uint otmXHeight;long otmFontBox[4];int otmMacAscent;int otmMacDescent;uint otmMacLineGap;uint otmMinimumPPEM;long otmSubscriptSize[2];long otmSubscriptOffset[2];long otmSuperscriptSize[2];long otmSuperscriptOffset[2];uint otmStrikeoutSize;int otmStrikeoutPosition;int otmUnderscoreSize;int otmUnderscorePosition;uint_ptr otmFamilyName;uint_ptr otmFaceName;uint_ptr otmStyleName;uint_ptr otmFullName;byte[' & ($Ret[0] - DllStructGetSize($tOLTM)) & ']')
	$Ret = DllCall('gdi32.dll', 'uint', 'GetOutlineTextMetricsW', 'hwnd', $hDC, 'uint', $Ret[0], 'ptr', DllStructGetPtr($tOLTM))
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tOLTM
EndFunc   ;==>_WinAPI_GetOutlineTextMetrics

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetParentProcess
; Description....: Retrieves the PID of the parent process for the specified process.
; Syntax.........: _WinAPI_GetParentProcess ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The PID of the parent process.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetParentProcess($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hSnapshot = DllCall('kernel32.dll', 'ptr', 'CreateToolhelp32Snapshot', 'dword', 0x00000002, 'dword', 0)

	If (@error) Or (Not $hSnapshot[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tPROCESSENTRY32 = DllStructCreate('dword Size;dword Usage;dword ProcessID;ulong_ptr DefaultHeapID;dword ModuleID;dword Threads;dword ParentProcessID;long PriClassBase;dword Flags;wchar ExeFile[260]')
	Local $pPROCESSENTRY32 = DllStructGetPtr($tPROCESSENTRY32)
	Local $Ret, $Result = 0

	$hSnapshot = $hSnapshot[0]
	DllStructSetData($tPROCESSENTRY32, 'Size', DllStructGetSize($tPROCESSENTRY32))
	$Ret = DllCall('kernel32.dll', 'int', 'Process32FirstW', 'ptr', $hSnapshot, 'ptr', $pPROCESSENTRY32)
	While (Not @error) And ($Ret[0])
		If DllStructGetData($tPROCESSENTRY32, 'ProcessID') = $PID Then
			$Result = DllStructGetData($tPROCESSENTRY32, 'ParentProcessID')
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'Process32NextW', 'ptr', $hSnapshot, 'ptr', $pPROCESSENTRY32)
	WEnd
	_WinAPI_CloseHandle($hSnapshot)
	If Not $Result Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Result
EndFunc   ;==>_WinAPI_GetParentProcess

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetPerformanceInfo
; Description....: Retrieves the performance information.
; Syntax.........: _WinAPI_GetPerformanceInfo ( )
; Parameters.....: None
; Return values..: Success - The array containing the following information:
;
;                            [0] - The memory that currently committed by the system, in bytes.
;                            [1] - The current maximum memory that can be committed by the system without extending the paging file(s), in bytes.
;                            [2] - The maximum memory that were simultaneously in the committed state since the last system reboot, in bytes.
;                            [3] - The amount of actual physical memory, in bytes.
;                            [4] - The amount of physical memory currently available, in bytes.
;                            [5] - The amount of system cache memory, in bytes.
;                            [6] - The sum of the memory currently in the paged and nonpaged kernel pools, in bytes.
;                            [7] - The memory currently in the paged kernel pool, in bytes.
;                            [8] - The memory currently in the nonpaged kernel pool, in bytes.
;                            [9] - The size of a page, in bytes.
;                           [10] - The current number of open handles.
;                           [11] - The current number of processes.
;                           [12] - The current number of threads.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetPerformanceInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetPerformanceInfo()

	Local $tPI = DllStructCreate('dword;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;dword;dword;dword')
	Local $Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'GetPerformanceInfo', 'ptr', DllStructGetPtr($tPI), 'dword', DllStructGetSize($tPI))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[13]

	For $i = 0 To 12
		$Result[$i] = DllStructGetData($tPI, $i + 2)
	Next
	For $i = 0 To 8
		$Result[$i] *= $Result[9]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetPerformanceInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetPhysicallyInstalledSystemMemory
; Description....: Retrieves the amount of RAM that is physically installed on the computer.
; Syntax.........: _WinAPI_GetPhysicallyInstalledSystemMemory ( )
; Parameters.....: None
; Return values..: Success - The amount of physically installed RAM, in kilobytes.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The amount of memory available to the operating system can be less than the amount of memory physically installed
;                  in the computer because the BIOS and some drivers may reserve memory as I/O regions for memory-mapped devices,
;                  making the memory unavailable to the operating system and applications.
;
;                  This function requires Windows Vista with SP1 or later.
; Related........:
; Link...........: @@MsdnLink@@ GetPhysicallyInstalledSystemMemory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetPhysicallyInstalledSystemMemory()

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetPhysicallyInstalledSystemMemory', 'uint64*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[1]
EndFunc   ;==>_WinAPI_GetPhysicallyInstalledSystemMemory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetPixel
; Description....: Retrieves the color value of the pixel at the specified coordinates.
; Syntax.........: _WinAPI_GetPixel ( $hDC, $iX, $iY )
; Parameters.....: $hDC    - Handle to the device context.
;                  $iX     - The x-coordinate, in logical units, of the pixel to be examined.
;                  $iY     - The y-coordinate, in logical units, of the pixel to be examined.
; Return values..: Success - The color of the pixel, in RGB.
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetPixel
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetPixel($hDC, $iX, $iY)

	Local $Ret = DllCall('gdi32.dll', 'dword', 'GetPixel', 'hwnd', $hDC, 'int', $iX, 'int', $iY)

	If (@error) Or ($Ret[0] = 4294967295) Then
		Return SetError(1, 0, -1)
	EndIf
	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_GetPixel

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetPolyFillMode
; Description....: Retrieves the current polygon fill mode.
; Syntax.........: _WinAPI_GetPolyFillMode ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The polygon fill mode, which can be one of the following values.
;
;                            $ALTERNATE
;                            $WINDING
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetPolyFillMode
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetPolyFillMode($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetPolyFillMode', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetPolyFillMode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetPosFromRect
; Description....: Interprets the coordinates of the rectangle as offset and position coordinates.
; Syntax.........: _WinAPI_GetPosFromRect ( $tRECT )
; Parameters.....: $tRECT  - $tagRECT structure that contains the logical coordinates of the rectangle.
; Return values..: Success - The array containing the following information:
;
;                            [0] - The x-coordinate of the upper-left corner of the rectangle.
;                            [1] - The y-coordinate of the upper-left corner of the rectangle.
;                            [2] - The width of the rectangle.
;                            [3] - The height of the rectangle.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function is inverse to the _WinAPI_CreateRectEx().
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetPosFromRect($tRECT)

	Local $Result[4]

	For $i = 0 To 3
		$Result[$i] = DllStructGetData($tRECT, $i + 1)
		If @error Then
			Return SetError(1, 0, 0)
		EndIf
	Next
	For $i = 2 To 3
		$Result[$i] -= $Result[$i - 2]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetPosFromRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetPriorityClass
; Description....: Retrieves the priority class for the specified process.
; Syntax.........: _WinAPI_GetPriorityClass ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The priority class of the specified process ($*_PRIORITY_CLASS).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: KaFu
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetPriorityClass
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetPriorityClass($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000400, 0x00001000), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetPriorityClass', 'ptr', $hProcess[0])

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetPriorityClass

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcAddress
; Description....: Retrieves the address of a function from the specified dynamic-link library (DLL).
; Syntax.........: _WinAPI_GetProcAddress ( $hModule, $sProc )
; Parameters.....: $hModule - Handle to the DLL module that contains the function.
;                  $sProc   - The function name.
; Return values..: Success  - The address of the function.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProcAddress
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcAddress($hModule, $sProc)

	Local $Ret = DllCall('kernel32.dll', 'ptr', 'GetProcAddress', 'ptr', $hModule, 'str', $sProc)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetProcAddress

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessCommandLine
; Description....: Retrieves the command-line string for the specified process.
; Syntax.........: _WinAPI_GetProcessCommandLine ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The command-line string.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function uses undocumented API functions and may stop working properly in future versions of Windows.
;
;                  Using this function for some processes may require full access rights. Use _WinAPI_AdjustTokenPrivileges()
;                  function to enable $SE_DEBUG_NAME privilege before calling this function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessCommandLine($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $Ret, $hProcess, $Error = 1

	$Ret = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000410, 0x00001010), 'int', 0, 'dword', $PID)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf

	$hProcess = $Ret[0]

	Local $tPBI = DllStructCreate('ulong_ptr ExitStatus;ptr PebBaseAddress;ulong_ptr AffinityMask;ulong_ptr BasePriority;ulong_ptr UniqueProcessId;ulong_ptr InheritedFromUniqueProcessId')
	Local $tPEB = DllStructCreate('byte InheritedAddressSpace;byte ReadImageFileExecOptions;byte BeingDebugged;byte Spare;ptr Mutant;ptr ImageBaseAddress;ptr LoaderData;ptr ProcessParameters;ptr SubSystemData;ptr ProcessHeap;ptr FastPebLock;ptr FastPebLockRoutine;ptr FastPebUnlockRoutine;ulong EnvironmentUpdateCount;ptr KernelCallbackTable;ptr EventLogSection;ptr EventLog;ptr FreeList;ulong TlsExpansionCounter;ptr TlsBitmap;ulong TlsBitmapBits[2];ptr ReadOnlySharedMemoryBase;ptr ReadOnlySharedMemoryHeap;ptr ReadOnlyStaticServerData;ptr AnsiCodePageData;ptr OemCodePageData;ptr UnicodeCaseTableData;ulong NumberOfProcessors;ulong NtGlobalFlag;byte Spare2[4];int64 CriticalSectionTimeout;ulong HeapSegmentReserve;ulong HeapSegmentCommit;ulong HeapDeCommitTotalFreeThreshold;ulong HeapDeCommitFreeBlockThreshold;ulong NumberOfHeaps;ulong MaximumNumberOfHeaps;ptr ProcessHeaps;ptr GdiSharedHandleTable;ptr ProcessStarterHelper;ptr GdiDCAttributeList;ptr LoaderLock;ulong OSMajorVersion;ulong OSMinorVersion;ulong OSBuildNumber;ulong OSPlatformId;ulong ImageSubSystem;ulong ImageSubSystemMajorVersion;ulong ImageSubSystemMinorVersion;ulong GdiHandleBuffer[34];ulong PostProcessInitRoutine;ulong TlsExpansionBitmap;byte TlsExpansionBitmapBits[128];ulong SessionId')
	Local $tUPP = DllStructCreate('ulong AllocationSize;ulong ActualSize;ulong Flags;ulong Unknown1;ushort LengthUnknown2;ushort MaxLengthUnknown2;ptr Unknown2;ptr InputHandle;ptr OutputHandle;ptr ErrorHandle;ushort LengthCurrentDirectory;ushort MaxLengthCurrentDirectory;ptr CurrentDirectory;ptr CurrentDirectoryHandle;ushort LengthSearchPaths;ushort MaxLengthSearchPaths;ptr SearchPaths;ushort LengthApplicationName;ushort MaxLengthApplicationName;ptr ApplicationName;ushort LengthCommandLine;ushort MaxLengthCommandLine;ptr CommandLine;ptr EnvironmentBlock;ulong Unknown[9];ushort LengthUnknown3;ushort MaxLengthUnknown3;ptr Unknown3;ushort LengthUnknown4;ushort MaxLengthUnknown4;ptr Unknown4;ushort LengthUnknown5;ushort MaxLengthUnknown5;ptr Unknown5')
	Local $tCMD

	Do
		$Ret = DllCall('ntdll.dll', 'int', 'NtQueryInformationProcess', 'ptr', $hProcess, 'ulong', 0, 'ptr', DllStructGetPtr($tPBI), 'ulong', DllStructGetSize($tPBI), 'ulong*', 0)
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'ReadProcessMemory', 'ptr', $hProcess, 'ptr', DllStructGetData($tPBI, 'PebBaseAddress'), 'ptr', DllStructGetPtr($tPEB), 'ulong_ptr', DllStructGetSize($tPEB), 'ulong_ptr*', 0)
		If (@error) Or (Not $Ret[0]) Or (Not $Ret[5]) Then
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'ReadProcessMemory', 'ptr', $hProcess, 'ptr', DllStructGetData($tPEB, 'ProcessParameters'), 'ptr', DllStructGetPtr($tUPP), 'ulong_ptr', DllStructGetSize($tUPP), 'ulong_ptr*', 0)
		If (@error) Or (Not $Ret[0]) Or (Not $Ret[5]) Then
			ExitLoop
		EndIf
		$tCMD = DllStructCreate('byte[' & DllStructGetData($tUPP, 'MaxLengthCommandLine') & ']')
		If @error Then
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'ReadProcessMemory', 'ptr', $hProcess, 'ptr', DllStructGetData($tUPP, 'CommandLine'), 'ptr', DllStructGetPtr($tCMD), 'ulong_ptr', DllStructGetSize($tCMD), 'ulong_ptr*', 0)
		If (@error) Or (Not $Ret[0]) Or (Not $Ret[5]) Then
			ExitLoop
		EndIf
		$Error = 0
	Until 1
	_WinAPI_CloseHandle($hProcess)
	If $Error Then
		Return SetError(1, 0, '')
	EndIf
	Return StringStripWS(_WinAPI_PathGetArgs(_WinAPI_GetString(DllStructGetPtr($tCMD, 1))), 3)
EndFunc   ;==>_WinAPI_GetProcessCommandLine

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessFileName
; Description....: Retrieves the fully-qualified path of the executable file for the specified process.
; Syntax.........: _WinAPI_GetProcessFileName ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The fully-qualified path to the file.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetModuleFileNameEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessFileName($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000410, 0x00001010), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, '')
	EndIf

	Local $Path = _WinAPI_GetModuleFileNameEx($hProcess[0])

	_WinAPI_CloseHandle($hProcess[0])
	If Not $Path Then
		Return SetError(1, 0, '')
	EndIf
	Return $Path
EndFunc   ;==>_WinAPI_GetProcessFileName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessHandleCount
; Description....: Retrieves the number of open handles that belong to the specified process.
; Syntax.........: _WinAPI_GetProcessHandleCount ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The number of open handles.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProcessHandleCount
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessHandleCount($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000400, 0x00001000), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetProcessHandleCount', 'ptr', $hProcess[0], 'dword*', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetProcessHandleCount

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessID
; Description....: Retrieves the process identifier of the specified process.
; Syntax.........: _WinAPI_GetProcessID ( $hProcess )
; Parameters.....: $hProcess - Handle to the process. The handle must have the $PROCESS_QUERY_INFORMATION or
;                              $PROCESS_QUERY_LIMITED_INFORMATION access right.
; Return values..: Success   - The process identifier.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProcessId
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessID($hProcess)

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetProcessId', 'ptr', $hProcess)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetProcessID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessIoCounters
; Description....: Retrieves accounting information for all I/O operations performed by the specified process.
; Syntax.........: _WinAPI_GetProcessIoCounters ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The number of read operations performed.
;                            [1] - The number of write operations performed.
;                            [2] - The number of I/O operations performed, other than read and write operations.
;                            [3] - The number of bytes read.
;                            [4] - The number of bytes written.
;                            [5] - The number of bytes transferred during operations other than read and write operations.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProcessIoCounters
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessIoCounters($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000400, 0x00001000), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tIO_COUNTERS = DllStructCreate('uint64[6]')
	Local $Ret = DllCall('kernel32.dll', 'int', 'GetProcessIoCounters', 'ptr', $hProcess[0], 'ptr', DllStructGetPtr($tIO_COUNTERS))

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[6]

	For $i = 0 To 5
		$Result[$i] = DllStructGetData($tIO_COUNTERS, 1, $i + 1)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetProcessIoCounters

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessMemoryInfo
; Description....: Retrieves information about the memory usage of the specified process.
; Syntax.........: _WinAPI_GetProcessMemoryInfo ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The number of page faults.
;                            [1] - The peak working set size, in bytes.
;                            [2] - The current working set size, in bytes.
;                            [3] - The peak paged pool usage, in bytes.
;                            [4] - The current paged pool usage, in bytes.
;                            [5] - The peak nonpaged pool usage, in bytes.
;                            [6] - The current nonpaged pool usage, in bytes.
;                            [7] - The current space allocated for the pagefile, in bytes.
;                            [8] - The peak space allocated for the pagefile, in bytes.
;                            [9] - The current amount of memory that cannot be shared with other processes, in bytes.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProcessMemoryInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessMemoryInfo($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000410, 0x00001010), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tPMC_EX = DllStructCreate('dword;dword;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr;ulong_ptr')
	Local $Ret = DllCall(@SystemDir & '\psapi.dll', 'int', 'GetProcessMemoryInfo', 'ptr', $hProcess[0], 'ptr', DllStructGetPtr($tPMC_EX), 'int', DllStructGetSize($tPMC_EX))

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[10]

	For $i = 0 To 9
		$Result[$i] = DllStructGetData($tPMC_EX, $i + 2)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetProcessMemoryInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessName
; Description....: Retrieves the name for the specified process.
; Syntax.........: _WinAPI_GetProcessName ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The process name.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessName($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hSnapshot = DllCall('kernel32.dll', 'ptr', 'CreateToolhelp32Snapshot', 'dword', 0x00000002, 'dword', 0)

	If (@error) Or (Not $hSnapshot[0]) Then
		Return SetError(1, 0, '')
	EndIf

	Local $tPROCESSENTRY32 = DllStructCreate('dword Size;dword Usage;dword ProcessID;ulong_ptr DefaultHeapID;dword ModuleID;dword Threads;dword ParentProcessID;long PriClassBase;dword Flags;wchar ExeFile[260]')
	Local $pPROCESSENTRY32 = DllStructGetPtr($tPROCESSENTRY32)
	Local $Ret, $Error = 1

	$hSnapshot = $hSnapshot[0]
	DllStructSetData($tPROCESSENTRY32, 'Size', DllStructGetSize($tPROCESSENTRY32))
	$Ret = DllCall('kernel32.dll', 'int', 'Process32FirstW', 'ptr', $hSnapshot, 'ptr', $pPROCESSENTRY32)
	While (Not @error) And ($Ret[0])
		If DllStructGetData($tPROCESSENTRY32, 'ProcessID') = $PID Then
			$Error = 0
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'Process32NextW', 'ptr', $hSnapshot, 'ptr', $pPROCESSENTRY32)
	WEnd
	_WinAPI_CloseHandle($hSnapshot)
	If $Error Then
		Return SetError(1, 0, '')
	EndIf
	Return DllStructGetData($tPROCESSENTRY32, 'ExeFile')
EndFunc   ;==>_WinAPI_GetProcessName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessShutdownParameters
; Description....: Retrieves the shutdown parameters for the currently calling process.
; Syntax.........: _WinAPI_GetProcessShutdownParameters ( )
; Parameters.....: None
; Return values..: Success - The shutdown priority level (see _WinAPI_SetProcessShutdownParameters()). If @extended flag is set,
;                            a retry dialog box for the user will be display.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProcessShutdownParameters
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessShutdownParameters()

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetProcessShutdownParameters', 'dword*', 0, 'dword*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return SetError(0, Number(Not $Ret[2]), $Ret[1])
EndFunc   ;==>_WinAPI_GetProcessShutdownParameters

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessTimes
; Description....: Retrieves timing information for the specified process.
; Syntax.........: _WinAPI_GetProcessTimes ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The array that contains the following information:
;
;                            [0] - $tagFILETIME structure that contains the creation time of the process.
;                            [1] - The time that the process has executed in kernel mode, in 100-nanosecond time units.
;                            [2] - The time that the process has executed in user mode, in 100-nanosecond time units.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProcessTimes
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessTimes($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000400, 0x00001000), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tFILETIME = DllStructCreate($tagFILETIME)
	Local $Ret = DllCall('kernel32.dll', 'int', 'GetProcessTimes', 'ptr', $hProcess[0], 'ptr', DllStructGetPtr($tFILETIME), 'uint64*', 0, 'uint64*', 0, 'uint64*', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[3]

	$Result[0] = $tFILETIME
	$Result[1] = $Ret[4]
	$Result[2] = $Ret[5]

	Return $Result
EndFunc   ;==>_WinAPI_GetProcessTimes

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessUser
; Description....: Retrieves the user and domain name for the specified process.
; Syntax.........: _WinAPI_GetProcessUser ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The user (account) name.
;                            [1] - The domain name.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Using this function for some processes may require full access rights. Use _WinAPI_AdjustTokenPrivileges()
;                  function to enable $SE_DEBUG_NAME privilege before calling this function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessUser($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $tSID, $hProcess, $hToken, $Ret
	Local $Error = 1

	$hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000400, 0x00001000), 'int', 0, 'dword', $PID)
	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Do
		$hToken = _WinAPI_OpenProcessToken(0x00000008, $hProcess[0])
		If Not $hToken Then
			ExitLoop
		EndIf
		$tSID = DllStructCreate('ptr;byte[1024]')
		$Ret = DllCall('advapi32.dll', 'int', 'GetTokenInformation', 'ptr', $hToken, 'uint', 1, 'ptr', DllStructGetPtr($tSID), 'dword', DllStructGetSize($tSID), 'dword*', 0)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Ret = DllCall('advapi32.dll', 'int', 'LookupAccountSidW', 'ptr', 0, 'ptr', DllStructGetData($tSID, 1), 'wstr', '', 'dword*', 2048, 'wstr', '', 'dword*', 2048, 'uint*', 0)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Error = 0
	Until 1
	If $hToken Then
		_WinAPI_CloseHandle($hToken)
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If $Error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[2]

	$Result[0] = $Ret[3]
	$Result[1] = $Ret[5]

	Return $Result
EndFunc   ;==>_WinAPI_GetProcessUser

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessWindowStation
; Description....: Retrieves a handle to the current window station for the calling process.
; Syntax.........: _WinAPI_GetProcessWindowStation ( )
; Parameters.....: None
; Return values..: Success    - Handle to the window station for the current process.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Do not close the handle returned by this function.
; Related........:
; Link...........: @@MsdnLink@@ GetProcessWindowStation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessWindowStation()

	Local $Ret = DllCall('user32.dll', 'ptr', 'GetProcessWindowStation')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetProcessWindowStation

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProcessWorkingDirectory
; Description....: Retrieves the current working directory for the specified process.
; Syntax.........: _WinAPI_GetProcessWorkingDirectory ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - The path to the working directory.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function uses undocumented API functions and may stop working properly in future versions of Windows.
;
;                  Using this function for some processes may require full access rights. Use _WinAPI_AdjustTokenPrivileges()
;                  function to enable $SE_DEBUG_NAME privilege before calling this function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProcessWorkingDirectory($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $Ret, $hProcess, $Error = 1

	$Ret = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000410, 0x00001010), 'int', 0, 'dword', $PID)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf

	$hProcess = $Ret[0]

	Local $tPBI = DllStructCreate('ulong_ptr ExitStatus;ptr PebBaseAddress;ulong_ptr AffinityMask;ulong_ptr BasePriority;ulong_ptr UniqueProcessId;ulong_ptr InheritedFromUniqueProcessId')
	Local $tPEB = DllStructCreate('byte InheritedAddressSpace;byte ReadImageFileExecOptions;byte BeingDebugged;byte Spare;ptr Mutant;ptr ImageBaseAddress;ptr LoaderData;ptr ProcessParameters;ptr SubSystemData;ptr ProcessHeap;ptr FastPebLock;ptr FastPebLockRoutine;ptr FastPebUnlockRoutine;ulong EnvironmentUpdateCount;ptr KernelCallbackTable;ptr EventLogSection;ptr EventLog;ptr FreeList;ulong TlsExpansionCounter;ptr TlsBitmap;ulong TlsBitmapBits[2];ptr ReadOnlySharedMemoryBase;ptr ReadOnlySharedMemoryHeap;ptr ReadOnlyStaticServerData;ptr AnsiCodePageData;ptr OemCodePageData;ptr UnicodeCaseTableData;ulong NumberOfProcessors;ulong NtGlobalFlag;byte Spare2[4];int64 CriticalSectionTimeout;ulong HeapSegmentReserve;ulong HeapSegmentCommit;ulong HeapDeCommitTotalFreeThreshold;ulong HeapDeCommitFreeBlockThreshold;ulong NumberOfHeaps;ulong MaximumNumberOfHeaps;ptr ProcessHeaps;ptr GdiSharedHandleTable;ptr ProcessStarterHelper;ptr GdiDCAttributeList;ptr LoaderLock;ulong OSMajorVersion;ulong OSMinorVersion;ulong OSBuildNumber;ulong OSPlatformId;ulong ImageSubSystem;ulong ImageSubSystemMajorVersion;ulong ImageSubSystemMinorVersion;ulong GdiHandleBuffer[34];ulong PostProcessInitRoutine;ulong TlsExpansionBitmap;byte TlsExpansionBitmapBits[128];ulong SessionId')
	Local $tUPP = DllStructCreate('ulong AllocationSize;ulong ActualSize;ulong Flags;ulong Unknown1;ushort LengthUnknown2;ushort MaxLengthUnknown2;ptr Unknown2;ptr InputHandle;ptr OutputHandle;ptr ErrorHandle;ushort LengthCurrentDirectory;ushort MaxLengthCurrentDirectory;ptr CurrentDirectory;ptr CurrentDirectoryHandle;ushort LengthSearchPaths;ushort MaxLengthSearchPaths;ptr SearchPaths;ushort LengthApplicationName;ushort MaxLengthApplicationName;ptr ApplicationName;ushort LengthCommandLine;ushort MaxLengthCommandLine;ptr CommandLine;ptr EnvironmentBlock;ulong Unknown[9];ushort LengthUnknown3;ushort MaxLengthUnknown3;ptr Unknown3;ushort LengthUnknown4;ushort MaxLengthUnknown4;ptr Unknown4;ushort LengthUnknown5;ushort MaxLengthUnknown5;ptr Unknown5')
	Local $tDIR

	Do
		$Ret = DllCall('ntdll.dll', 'int', 'NtQueryInformationProcess', 'ptr', $hProcess, 'ulong', 0, 'ptr', DllStructGetPtr($tPBI), 'ulong', DllStructGetSize($tPBI), 'ulong*', 0)
		If (@error) Or ($Ret[0]) Then
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'ReadProcessMemory', 'ptr', $hProcess, 'ptr', DllStructGetData($tPBI, 'PebBaseAddress'), 'ptr', DllStructGetPtr($tPEB), 'ulong_ptr', DllStructGetSize($tPEB), 'ulong_ptr*', 0)
		If (@error) Or (Not $Ret[0]) Or (Not $Ret[5]) Then
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'ReadProcessMemory', 'ptr', $hProcess, 'ptr', DllStructGetData($tPEB, 'ProcessParameters'), 'ptr', DllStructGetPtr($tUPP), 'ulong_ptr', DllStructGetSize($tUPP), 'ulong_ptr*', 0)
		If (@error) Or (Not $Ret[0]) Or (Not $Ret[5]) Then
			ExitLoop
		EndIf
		$tDIR = DllStructCreate('byte[' & DllStructGetData($tUPP, 'MaxLengthCurrentDirectory') & ']')
		If @error Then
			ExitLoop
		EndIf
		$Ret = DllCall('kernel32.dll', 'int', 'ReadProcessMemory', 'ptr', $hProcess, 'ptr', DllStructGetData($tUPP, 'CurrentDirectory'), 'ptr', DllStructGetPtr($tDIR), 'ulong_ptr', DllStructGetSize($tDIR), 'ulong_ptr*', 0)
		If (@error) Or (Not $Ret[0]) Or (Not $Ret[5]) Then
			ExitLoop
		EndIf
		$Error = 0
	Until 1
	_WinAPI_CloseHandle($hProcess)
	If $Error Then
		Return SetError(1, 0, '')
	EndIf
	Return _WinAPI_PathRemoveBackslash(_WinAPI_GetString(DllStructGetPtr($tDIR)))
EndFunc   ;==>_WinAPI_GetProcessWorkingDirectory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetProfilesDirectory
; Description....: Retrieves the path to the root directory where user profiles are stored.
; Syntax.........: _WinAPI_GetProfilesDirectory ( )
; Parameters.....: None
; Return values..: Success - The path to the directory.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetProfilesDirectory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetProfilesDirectory()

	Local $Ret = DllCall('userenv.dll', 'int', 'GetProfilesDirectoryW', 'wstr', '', 'dword*', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[1]
EndFunc   ;==>_WinAPI_GetProfilesDirectory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetPwrCapabilities
; Description....: Retrieves information about the system power capabilities.
; Syntax.........: _WinAPI_GetPwrCapabilities ( )
; Parameters.....: None
; Return values..: Success - The array that contains the following information:
;
;                            [0 ] - If TRUE, there is a system power button.
;                            [1 ] - If TRUE, there is a system sleep button.
;                            [2 ] - If TRUE, there is a lid switch.
;                            [3 ] - If TRUE, the operating system supports sleep state S1.
;                            [4 ] - If TRUE, the operating system supports sleep state S2.
;                            [5 ] - If TRUE, the operating system supports sleep state S3.
;                            [6 ] - If TRUE, the operating system supports sleep state S4 (hibernation).
;                            [7 ] - If TRUE, the operating system supports power off state S5 (soft off).
;                            [8 ] - If TRUE, the system hibernation file is present.
;                            [9 ] - If TRUE, the system supports wake capabilities.
;                            [10] - If TRUE, the system supports video display dimming capabilities.
;                            [11] - If TRUE, the system supports APM BIOS power management features.
;                            [12] - If TRUE, there is an uninterruptible power supply (UPS).
;                            [13] - If TRUE, the system supports thermal zones.
;                            [14] - If TRUE, the system supports processor throttling.
;                            [15] - The minimum level of system processor throttling supported, expressed as a percentage.
;                            [16] - The maximum level of system processor throttling supported, expressed as a percentage.
;                            [17] - If TRUE, the system supports the hybrid sleep state.
;                            [18] - If TRUE, the system supports allowing the removal of power to fixed disk devices.
;                            [19] - If TRUE, there are one or more batteries in the system.
;                            [20] - If TRUE, the system batteries are short-term. Short-term batteries are used in uninterruptible power supplies (UPS).
;                            [21] - The lowest system sleep state (Sx) that will generate a wake event when the system is on AC power.
;                            [22] - The lowest system sleep state (Sx) that will generate a wake event via the lid switch.
;                            [23] - The lowest system sleep state (Sx) supported by hardware that will generate a wake event via the RTC.
;                            [24] - The minimum allowable system power state supporting wake events.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetPwrCapabilities
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetPwrCapabilities()

	If Not __DLL('powrprof.dll') Then
		Return SetError(3, 0, 0)
	EndIf

	Local $tSPC = DllStructCreate('byte[18];byte[3];byte;byte[8];byte[2];ulong[6];ulong[5]')
	Local $Ret = DllCall('powrprof.dll', 'int', 'GetPwrCapabilities', 'ptr', DllStructGetPtr($tSPC))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[25]

	For $i =  0 to 17
		$Result[$i] = DllStructGetData($tSPC, 1, $i + 1)
	Next
	$Result[18] = DllStructGetData($tSPC, 3)
	For $i = 19 to 20
		$Result[$i] = DllStructGetData($tSPC, 5, $i - 18)
	Next
	For $i = 21 to 24
		$Result[$i] = DllStructGetData($tSPC, 7, $i - 20)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetPwrCapabilities

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRawInputBuffer
; Description....: Performs a buffered read of the raw input data.
; Syntax.........: _WinAPI_GetRawInputBuffer ( $pBuffer, $iLength )
; Parameters.....: $pBuffer - A pointer to the buffer to receive an array of $tagRAWINPUT structures containing the raw input data.
;                  $iLength - The size of the buffer, in bytes.
; Return values..: Success  - The number of $tagRAWINPUT structures written to the buffer.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: To obtain the minimum required buffer size to call this function, use _WinAPI_GetRawInputBufferLength().
;
;                  To ensure the _WinAPI_GetRawInputBuffer() function behaves properly on WOW64, you must align the
;                  $tagRAWINPUT structure by 8 bytes.
; Related........:
; Link...........: @@MsdnLink@@ GetRawInputBuffer
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRawInputBuffer($pBuffer, $iLength)

	Local $Ret = DllCall('user32.dll', 'uint', 'GetRawInputBuffer', 'ptr', $pBuffer, 'uint*', $iLength, 'uint', __Iif(@AutoItX64, 24, 16))

	If (@error) Or ($Ret[0] = 4294967295) Or (Not $Ret[1]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetRawInputBuffer

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRawInputBufferLength
; Description....: Retrieves the required buffer size to call the _WinAPI_GetRawInputBuffer() function.
; Syntax.........: _WinAPI_GetRawInputBufferLength ( )
; Parameters.....: None
; Return values..: Success - The minimum required buffer size, in bytes.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetRawInputBuffer
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRawInputBufferLength()

	Local $Ret = DllCall('user32.dll', 'uint', 'GetRawInputBuffer', 'ptr', 0, 'uint*', 0, 'uint', __Iif(@AutoItX64, 24, 16))

	If (@error) Or ($Ret[0] = 4294967295) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[2] * 8
EndFunc   ;==>_WinAPI_GetRawInputBufferLength

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRawInputData
; Description....: Retrieves the raw input from the specified device.
; Syntax.........: _WinAPI_GetRawInputData ( $hRawInput, $pBuffer, $iLength, $iFlag )
; Parameters.....: $hRawInput - A handle to the $tagRAWINPUT structure (not a pointer). This comes from the "lParam" in WM_INPUT.
;                  $pBuffer   - A pointer to the buffer to receive a data that comes from the $tagRAWINPUT structure. This depends
;                               on the value of a command flag (see below). If this parameter is 0, the function returns the
;                               required size of the buffer, in bytes.
;                  $iLength   - The size of the buffer, in bytes.
;                  $iFlag     - The command flag. This parameter can be one of the following values.
;
;                               $RID_HEADER
;                               $RID_INPUT
;
; Return values..: Success    - The number of bytes required or copied into the buffer.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetRawInputData
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRawInputData($hRawInput, $pBuffer, $iLength, $iFlag)

	Local $Ret = DllCall('user32.dll', 'uint', 'GetRawInputData', 'ptr', $hRawInput, 'uint', $iFlag, 'ptr', $pBuffer, 'uint*', $iLength, 'uint', __Iif(@AutoItX64, 24, 16))

	If (@error) Or ($Ret[0] = 4294967295) Then
		Return SetError(1, 0, 0)
	EndIf
	Return __Iif($Ret[3], $Ret[0], $Ret[4])
EndFunc   ;==>_WinAPI_GetRawInputData

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRawInputDeviceInfo
; Description....: Retrieves information about the raw input device.
; Syntax.........: _WinAPI_GetRawInputDeviceInfo ( $hDevice, $pBuffer, $iLength, $iFlag )
; Parameters.....: $hDevice - A handle to the raw input device. This comes from the "lParam" of the WM_INPUT message, from the
;                             "hDevice" member of the $tagRAWINPUTHEADER structure, or from the _WinAPI_EnumRawInputDevices() function.
;                  $pBuffer - A pointer to the buffer that receives an information specified by a command flag (see below).
;                             If this parameter is 0, the function returns the required size of the buffer, in bytes or characters.
;                  $iLength - The size of the buffer, in bytes. For $RIDI_DEVICENAME only, this value is the character count,
;                             including null-terminating character (not the byte count).
;                  $iFlag   - The command flag that specifies what information will be returned. This parameter can be one
;                             of the following values.
;
;                             $RIDI_DEVICENAME
;                             $RIDI_DEVICEINFO
;                             $RIDI_PREPARSEDDATA
;
; Return values..: Success  - The number of bytes or characters required or copied into the buffer.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetRawInputDeviceInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRawInputDeviceInfo($hDevice, $pBuffer, $iLength, $iFlag)

	Local $Ret = DllCall('user32.dll', 'uint', 'GetRawInputDeviceInfoW', 'ptr', $hDevice, 'uint', $iFlag, 'ptr', $pBuffer, 'uint*', $iLength)

	If (@error) Or ($Ret[0] = 4294967295) Then
		Return SetError(1, 0, 0)
	EndIf
	Return __Iif($Ret[3], $Ret[0], $Ret[4])
EndFunc   ;==>_WinAPI_GetRawInputDeviceInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRegionData
; Description....: Fills the specified buffer with data describing a region.
; Syntax.........: _WinAPI_GetRegionData ( $hRgn, ByRef $tRGNDATA )
; Parameters.....: $hRgn     - Handle to the region.
;                  $tRGNDATA - $tagRGNDATA structure that is created by this function, and contains the region data, in logical units.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetRegionData
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRegionData($hRgn, ByRef $tRGNDATA)

	Local $Ret

	$Ret = DllCall('gdi32.dll', 'dword', 'GetRegionData', 'ptr', $hRgn, 'dword', 0, 'ptr', 0)
	If (@error) Or (Not $Ret[0]) Then
		$tRGNDATA = 0
		Return SetError(1, 0, 0)
	EndIf
	If $Ret[0] > 32 Then
		$tRGNDATA = DllStructCreate($tagRGNDATAHEADER & 'byte[' & ($Ret[0] - 32) & ']')
	Else
		$tRGNDATA = DllStructCreate($tagRGNDATAHEADER)
	EndIf
	$Ret = DllCall('gdi32.dll', 'dword', 'GetRegionData', 'ptr', $hRgn, 'dword', $Ret[0], 'ptr', DllStructGetPtr($tRGNDATA))
	If (@error) Or (Not $Ret[0]) Then
		$tRGNDATA = 0
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_GetRegionData

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRegisteredRawInputDevices
; Description....: Retrieves the information about the raw input devices for the current application.
; Syntax.........: _WinAPI_GetRegisteredRawInputDevices ( $pBuffer, $iLength )
; Parameters.....: $pBuffer - A pointer to the buffer to receive an array of $tagRAWINPUTDEVICE structures for the application.
;                             If this parameter is 0, the function returns the required buffer size, in bytes.
;                  $iLength - The size of the buffer, in bytes.
; Return values..: Success  - The number of $tagRAWINPUTDEVICE structures written to the buffer.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetRegisteredRawInputDevices
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRegisteredRawInputDevices($pBuffer, $iLength)

	Local $Length = __Iif(@AutoItX64, 16, 12)
	Local $Ret = DllCall('user32.dll', 'uint', 'GetRegisteredRawInputDevices', 'ptr', $pBuffer, 'uint*', Floor($iLength / $Length), 'uint', $Length)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] = 4294967295 Then
			Switch _WinAPI_GetLastError()
				Case 122 ; ERROR_INSUFFICIENT_BUFFER
					Return SetError(0, 0, $Ret[2] * $Length)
				Case Else
					Return SetError(1, 0, 0)
			EndSwitch
		EndIf
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetRegisteredRawInputDevices

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRegKeyNameByHandle
; Description....: Retrieves a name of the specified registry key.
; Syntax.........: _WinAPI_GetRegKeyNameByHandle ( $hKey )
; Parameters.....: $hKey   - Handle to an open registry key.
; Return values..: Success - The name of the key.
;                  Failure - Empty string and sets the @error flag to non-zero, @extended flag may contain the NTSTATUS code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ ZwQueryKey
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRegKeyNameByHandle($hKey)

	Local $tKNI, $Ret, $Length

	$tKNI = DllStructCreate('ulong;wchar[4096]')
	$Ret = DllCall('ntdll.dll', 'uint', 'ZwQueryKey', 'ulong_ptr', $hKey, 'uint', 3, 'ptr', DllStructGetPtr($tKNI), 'ulong', DllStructGetSize($tKNI), 'ulong*', 0)
	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	$Length = DllStructGetData($tKNI, 1)
	If Not $Length Then
		Return SetError(2, 0, 0)
	EndIf
	Return DllStructGetData(DllStructCreate('wchar[' & ($Length / 2) & ']', DllStructGetPtr($tKNI, 2)), 1)
EndFunc   ;==>_WinAPI_GetRegKeyNameByHandle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRgnBox
; Description....: Retrieves the bounding rectangle of the specified region.
; Syntax.........: _WinAPI_GetRgnBox ( $hRgn, ByRef $tRECT )
; Parameters.....: $hRgn   - Handle to the region.
;                  $tRECT  - $tagRECT structure that is created by this function, and contains the bounding rectangle, in logical units.
; Return values..: Success - The value that specifies the region's complexity; it can be one of the following values.
;
;                            $COMPLEXREGION
;                            $NULLREGION
;                            $SIMPLEREGION
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetRgnBox
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRgnBox($hRgn, ByRef $tRECT)

	$tRECT = DllStructCreate($tagRECT)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetRgnBox', 'ptr', $hRgn, 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		$tRECT = 0
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetRgnBox

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetROP2
; Description....: Retrieves the foreground mix mode of the specified device context.
; Syntax.........: _WinAPI_GetROP2 ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The value that specifies the foreground mix mode ($R2_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetROP2
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetROP2($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetROP2', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetROP2

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetRValue
; Description....: Retrieves an intensity value for the red component of a 32-bit RGB value.
; Syntax.........: _WinAPI_GetRValue ( $iRGB )
; Parameters.....: $iRGB - The color value, in RGB.
; Return values..: The intensity of the red component of the specified RGB color.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetRValue($iRGB)
	Return BitAND(__RGB($iRGB), 0x0000FF)
EndFunc   ;==>_WinAPI_GetRValue

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetShellWindow
; Description....: Retrieves a handle to the Shell's desktop window.
; Syntax.........: _WinAPI_GetShellWindow ( )
; Parameters.....: None
; Return values..: Success - The handle of the Shell's desktop window.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetShellWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetShellWindow()

	Local $Ret = DllCall('user32.dll', 'hwnd', 'GetShellWindow')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetShellWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetStartupInfo
; Description....: Retrieves the contents of the STARTUPINFO structure that was specified when the calling process was created.
; Syntax.........: _WinAPI_GetStartupInfo ( )
; Parameters.....: None
; Return values..: Success - $tagSTARTUPINFO structure that contains the startup information.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetStartupInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetStartupInfo()

	Local $tSI = DllStructCreate($tagSTARTUPINFO)

	DllCall('kernel32.dll', 'none', 'GetStartupInfoW', 'ptr', DllStructGetPtr($tSI))
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tSI
EndFunc   ;==>_WinAPI_GetStartupInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetStretchBltMode
; Description....: Retrieves the current stretching mode.
; Syntax.........: _WinAPI_GetStretchBltMode ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The current stretching mode ($STRETCH_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetStretchBltMode
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetStretchBltMode($hDC)

	Local $Ret  = DllCall('gdi32.dll', 'int', 'GetStretchBltMode', 'hwnd', $hDC)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetStretchBltMode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetString
; Description....: Returns a string located at the specified memory address.
; Syntax.........: _WinAPI_GetString ( $pString [, $fUnicode] )
; Parameters.....: $pString  - Pointer to a null-terminated string.
;                  $fUnicode - Specifies whether a string is Unicode or ASCII code of a character, valid values:
;                  |TRUE     - Unicode. (Default)
;                  |FALSE    - ASCII.
; Return values..: Success   - A string. @extended returns the length of the string, in TCHARs (not including the null-terminating character).
;                  Failure   - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the pointer is incorrect, _WinAPI_GetString() does not set @error flag but always returns an empty string.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetString($pString, $fUnicode = 1)

	Local $Length = _WinAPI_StrLen($pString, $fUnicode)

	If @error Then
		Return SetError(1, 0, '')
	EndIf
	If Not $Length Then
		Return ''
	EndIf

	Local $tString = DllStructCreate(__Iif($fUnicode, 'wchar', 'char') & '[' & ($Length + 1) & ']', $pString)

	If @error Then
		Return SetError(1, 0, '')
	EndIf
	Return SetError(0, $Length, DllStructGetData($tString, 1))
EndFunc   ;==>_WinAPI_GetString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemDefaultLangID
; Description....: Returns the language identifier for the system locale.
; Syntax.........: _WinAPI_GetSystemDefaultLangID ( )
; Parameters.....: None
; Return values..: Success - The language identifier for the system locale.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetSystemDefaultLangID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemDefaultLangID()

    Local $Ret = DllCall('kernel32.dll', 'ushort', 'GetSystemDefaultLangID')

    If @error Then
		Return SetError(1, 0, 0)
	EndIf
    Return $Ret[0]
EndFunc   ;==>_WinAPI_GetSystemDefaultLangID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemDefaultLCID
; Description....: Returns the locale identifier (LCID) for the system locale.
; Syntax.........: _WinAPI_GetSystemDefaultLCID ( )
; Parameters.....: None
; Return values..: Success - The default LCID for the system.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetSystemDefaultLCID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemDefaultLCID()

    Local $Ret = DllCall('kernel32.dll', 'ulong', 'GetSystemDefaultLCID')

    If @error Then
		Return SetError(1, 0, 0)
	EndIf
    Return $Ret[0]
EndFunc   ;==>_WinAPI_GetSystemDefaultLCID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemDefaultUILanguage
; Description....: Retrieves the language identifier for the system default UI language of the operating system.
; Syntax.........: _WinAPI_GetSystemDefaultUILanguage ( )
; Parameters.....: None
; Return values..: Success - The language identifier.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetSystemDefaultUILanguage
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemDefaultUILanguage()

	Local $Ret = DllCall('kernel32.dll', 'ushort', 'GetSystemDefaultUILanguage')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetSystemDefaultUILanguage

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemDEPPolicy
; Description....: Gets the data execution prevention (DEP) policy setting for the system.
; Syntax.........: _WinAPI_GetSystemDEPPolicy ( )
; Parameters.....: None
; Return values..: Success - The DEP policy setting, which can be one of the following values.
;
;                            0 - AlwaysOff
;                                DEP is disabled for all parts of the system, regardless of hardware support for DEP. The processor
;                                runs in PAE mode with 32-bit versions of Windows unless PAE is disabled in the boot configuration data.
;
;                            1 - AlwaysOn
;                                DEP is enabled for all parts of the system. All processes always run with DEP enabled. DEP cannot
;                                be explicitly disabled for selected applications. System compatibility fixes are ignored.
;
;                            2 - OptIn
;                                On systems with processors that are capable of hardware-enforced DEP, DEP is automatically enabled
;                                only for operating system components. This is the default setting for client versions of Windows.
;                                DEP can be explicitly enabled for selected applications or the current process.
;
;                            3 - OptOut
;                                DEP is automatically enabled for operating system components and all processes. This is the default
;                                setting for Windows Server versions. DEP can be explicitly disabled for selected applications or
;                                the current process. System compatibility fixes for DEP are in effect.
;
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: KaFu
; Modified.......: Yashied
; Remarks........: This function requires Windows XP with SP3, Windows Vista with SP1 or later.
; Related........:
; Link...........: @@MsdnLink@@ GetSystemDEPPolicy
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemDEPPolicy()

	Local $Ret = DllCall('kernel32.dll', 'uint', 'GetSystemDEPPolicy')

	If @error Then
		Return SetError(1, 0, -1)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetSystemDEPPolicy

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemInfo
; Description....: Retrieves information about the current system.
; Syntax.........: _WinAPI_GetSystemInfo ( )
; Parameters.....: None
; Return values..: Success - The array containing the following information:
;
;                  [0] - The processor architecture of the installed operating system ($PROCESSOR_ARCHITECTURE_*).
;                  [1] - The page size and the granularity of page protection and commitment.
;                  [2] - A pointer to the lowest memory address accessible to applications and dynamic-link libraries (DLLs).
;                  [3] - A pointer to the highest memory address accessible to applications and DLLs.
;                  [4] - A mask representing the set of processors configured into the system. Bit 0 is processor 0; bit 31 is processor 31.
;                  [5] - The number of physical processors in the system.
;                  [6] - An obsolete member that is retained for compatibility ($PROCESSOR_*).
;                  [7] - The granularity for the starting address at which virtual memory can be allocated.
;                  [8] - The architecture-dependent processor level.
;                  [9] - The architecture-dependent processor revision (0x0000xxyy; xx - model; yy - stepping).
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetSystemInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemInfo()

	Local $Proc

	If _WinAPI_IsWow64Process() Then
		$Proc = 'GetNativeSystemInfo'
	Else
		$Proc = 'GetSystemInfo'
	EndIf

	Local $tagSYSTEMINFO = DllStructCreate('ushort;ushort;dword;ptr;ptr;dword_ptr;dword;dword;dword;ushort;ushort')

	DllCall('kernel32.dll', 'none', $Proc, 'ptr', DllStructGetPtr($tagSYSTEMINFO))
	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[10]

	$Result[0] = DllStructGetData($tagSYSTEMINFO, 1)
	For $i = 1 To 9
		$Result[$i] = DllStructGetData($tagSYSTEMINFO, $i + 2)
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetSystemInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemPowerStatus
; Description....: Retrieves the power status of the system.
; Syntax.........: _WinAPI_GetSystemPowerStatus ( )
; Parameters.....: None
; Return values..: Success - The array containing the following information:
;
;                            [0] - The AC power status. This parameter can be one of the following values.
;                                    0 - Offline
;                                    1 - Online
;                                  255 - Unknown status
;                            [1] - The battery charge status. This parameter can be a combination of the following values.
;                                    0 - The battery is not being charged and its capacity is between low and high
;                                    1 - High - the battery capacity is at more than 66 percent
;                                    2 - Low - the battery capacity is at less than 33 percent
;                                    4 - Critical - the battery capacity is at less than 5 percent
;                                    8 - Charging
;                                  128 - No system battery
;                                  255 - Unknown status - unable to read the battery flag information
;                            [2] - The percentage of full battery charge remaining. This member can be a value in the range 0 to 100, or 255 if status is unknown.
;                            [3] - The number of seconds of battery life remaining, or (1) if remaining seconds are unknown.
;                            [4] - The number of seconds of battery life when at full charge, or (1) if full battery lifetime is unknown.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetSystemPowerStatus
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemPowerStatus()

	Local $tSYSTEM_POWER_STATUS = DllStructCreate('byte;byte;byte;byte;dword;dword')
	Local $Ret = DllCall('kernel32.dll', 'int', 'GetSystemPowerStatus', 'ptr', DllStructGetPtr($tSYSTEM_POWER_STATUS))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[5]

	$Result[0] = DllStructGetData($tSYSTEM_POWER_STATUS, 1)
	$Result[1] = DllStructGetData($tSYSTEM_POWER_STATUS, 2)
	$Result[2] = DllStructGetData($tSYSTEM_POWER_STATUS, 3)
	$Result[3] = DllStructGetData($tSYSTEM_POWER_STATUS, 5)
	$Result[4] = DllStructGetData($tSYSTEM_POWER_STATUS, 6)

	For $i = 3 To 4
		If $Result[$i] = 4294967295 Then
			$Result[$i] = -1
		EndIf
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetSystemPowerStatus

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemTimes
; Description....: Retrieves system timing information.
; Syntax.........: _WinAPI_GetSystemTimes ( )
; Parameters.....: None
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The time that the system has been idle.
;                            [1] - The time that the system has spent executing in kernel mode, in 100-nanosecond time units.
;                            [2] - The time that the system has spent executing in user mode, in 100-nanosecond time units.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: On a multiprocessor system, the _WinAPI_GetSystemTimes() returns a values are the sum of the designated times
;                  across all processors.
; Related........:
; Link...........: @@MsdnLink@@ GetSystemTimes
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemTimes()

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetSystemTimes', 'uint64*', 0, 'uint64*', 0, 'uint64*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[3]

	For $i = 0 To 2
		$Result[$i] = $Ret[$i + 1]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetSystemTimes

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetSystemWow64Directory
; Description....: Retrieves the path of the system directory used by WOW64.
; Syntax.........: _WinAPI_GetSystemWow64Directory ( )
; Parameters.....: None
; Return values..: Success - The path of the system directory. This path does not end with a backslash.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This directory is not present on 32-bit Windows.
; Related........:
; Link...........: @@MsdnLink@@ GetSystemWow64Directory
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetSystemWow64Directory()

	Local $Ret = DllCall('kernel32.dll', 'uint', 'GetSystemWow64DirectoryW', 'wstr', '', 'uint', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[1]
EndFunc   ;==>_WinAPI_GetSystemWow64Directory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTempFileName
; Description....: Creates a name for a temporary file.
; Syntax.........: _WinAPI_GetTempFileName ( $sPath [, $sPrefix] )
; Parameters.....: $sPath   - The directory path for the file name. Applications typically specify a period (.) for the current directory.
;                  $sPrefix - The prefix string. The function uses up to the first three characters of this string as the prefix of the
;                             file name.
; Return values..: Success  - The temporary file name.
;                  Failure  - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Temporary files whose names have been created by this function are not automatically deleted.
; Related........:
; Link...........: @@MsdnLink@@ GetTempFileName
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTempFileName($sPath, $sPrefix = '')

	Local $Ret = DllCall('kernel32.dll', 'uint', 'GetTempFileNameW', 'wstr', $sPath, 'wstr', $sPrefix, 'uint', 0, 'wstr', '')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[4]
EndFunc   ;==>_WinAPI_GetTempFileName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTextAlign
; Description....: Retrieves the text-alignment setting for the specified device context.
; Syntax.........: _WinAPI_GetTextAlign ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The status of the text-alignment flags. The return value is a combination of the $TA_* and $VTA_* constants.
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetTextAlign
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTextAlign($hDC)

	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetTextAlign', 'hwnd', $hDC)

	If (@error) Or ($Ret[0] = 4294967295) Then
		Return SetError(1, 0, -1)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetTextAlign

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTextCharacterExtra
; Description....: Retrieves the current intercharacter spacing for the specified device context.
; Syntax.........: _WinAPI_GetTextCharacterExtra ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The current intercharacter spacing, in logical coordinates.
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetTextCharacterExtra
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTextCharacterExtra($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetTextCharacterExtra', 'hwnd', $hDC)

	If (@error) Or ($Ret[0] = 0x8000000) Then
		Return SetError(1, 0, -1)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetTextCharacterExtra

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTextColor
; Description....: Retrieves the current text color for the specified device context.
; Syntax.........: _WinAPI_GetTextColor ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The value of the current text color, in RGB.
;                  Failure - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetTextColor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTextColor($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetTextColor', 'hwnd', $hDC)

	If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, -1)
	EndIf
	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_GetTextColor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTextFace
; Description....: Retrieves the typeface name of the font that is selected into the specified device context.
; Syntax.........: _WinAPI_GetTextFace ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - The typeface name.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetTextFace
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTextFace($hDC)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetTextFaceW', 'hwnd', $hDC, 'int', 2048, 'wstr', '')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetTextFace

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTextMetrics
; Description....: Retrieves basic information for the currently selected font.
; Syntax.........: _WinAPI_GetTextMetrics ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - $tagTEXTMETRIC structure that contains the information about the currently selected font.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetTextMetrics
; Example........: Yes
; ===============================================================================================================================

#cs

Func _WinAPI_GetTextMetrics($hDC)

;	Local $tTEXTMETRIC = DllStructCreate($tagTEXTMETRIC)
	Local $tTEXTMETRIC = DllStructCreate('long tmHeight;long tmAscent;long tmDescent;long tmInternalLeading;long tmExternalLeading;long tmAveCharWidth;long tmMaxCharWidth;long tmWeight;long tmOverhang;long tmDigitizedAspectX;long tmDigitizedAspectY;wchar tmFirstChar;wchar tmLastChar;wchar tmDefaultChar;wchar tmBreakChar;byte tmItalic;byte tmUnderlined;byte tmStruckOut;byte tmPitchAndFamily;byte tmCharSet')
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetTextMetricsW', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tTEXTMETRIC))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tTEXTMETRIC
EndFunc   ;==>_WinAPI_GetTextMetrics

#ce

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeAppProperties
; Description....: Retrieves the property flags that control how visual styles are applied in the current application.
; Syntax.........: _WinAPI_GetThemeAppProperties ( )
; Parameters.....: None
; Return values..: Success - The property bit flags ($STAP_ALLOW_*) combined with a logical OR operator.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Individual flags can be extracted from the result by combining the result with the logical
;                  AND of the desired flag.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeAppProperties
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeAppProperties()

	Local $Ret = DllCall('uxtheme.dll', 'int', 'GetThemeAppProperties')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThemeAppProperties

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeBackgroundContentRect
; Description....: Retrieves the size of the content area for the background defined by the visual style.
; Syntax.........: _WinAPI_GetThemeBackgroundContentRect ( $hTheme, $iPartId, $iStateId, $hDC, $tRECT )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the content area.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context to use when drawing.
;                  $tRECT    - $tagRECT structure that contains the total background rectangle. This is the area inside the borders or margins.
; Return values..: Success   - $tagRECT structure that contains the content area background rectangle.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeBackgroundContentRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeBackgroundContentRect($hTheme, $iPartId, $iStateId, $hDC, $tRECT)

	Local $tAREA = DllStructCreate($tagRECT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeBackgroundContentRect', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tAREA))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tAREA
EndFunc   ;==>_WinAPI_GetThemeBackgroundContentRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeBackgroundExtent
; Description....: Calculates the size and location of the background, defined by the visual style, given the content area.
; Syntax.........: _WinAPI_GetThemeBackgroundExtent ( $hTheme, $iPartId, $iStateId, $hDC, $tRECT )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the content area.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context to use when drawing.
;                  $tRECT    - $tagRECT structure that contains the content background rectangle.
; Return values..: Success   - $tagRECT structure that contains the background rectangle.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeBackgroundExtent
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeBackgroundExtent($hTheme, $iPartId, $iStateId, $hDC, $tRECT)

	Local $tAREA = DllStructCreate($tagRECT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeBackgroundExtent', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tAREA))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tAREA
EndFunc   ;==>_WinAPI_GetThemeBackgroundExtent

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeBackgroundRegion
; Description....: Computes the region for a regular or partially transparent background that is bounded by a specified rectangle.
; Syntax.........: _WinAPI_GetThemeBackgroundRegion ( $hTheme, $iPartId, $iStateId, $hDC, $tRECT )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the region.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context to draw into.
;                  $tRECT    - $tagRECT structure that contains the specified rectangle used to compute the region.
; Return values..: Success   - Handle to the computed region.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: The region handle that is returned by this function should be released when it is no longer needed,
;                  using _WinAPI_DeleteObject().
; Related........:
; Link...........: @@MsdnLink@@ GetThemeBackgroundRegion
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeBackgroundRegion($hTheme, $iPartId, $iStateId, $hDC, $tRECT)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeBackgroundRegion', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tRECT), 'ptr*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_GetThemeBackgroundExtent

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeBitmap
; Description....: Retrieves the bitmap associated with a particular theme, part, state, and property.
; Syntax.........: _WinAPI_GetThemeBitmap ( $hTheme, $iPartId, $iStateId, $iPropId [, $iFlag] )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the bitmap.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve. Set this parameter to 0 to automatically select the first available bitmap
;                              for this part and state, or use one of the following values.
;
;                              $TMT_DIBDATA
;                              $TMT_GLYPHDIBDATA
;                              $TMT_HBITMAP
;
;                  $iFlag    - This parameter can be one of the following values.
;
;                              $GBF_DIRECT
;                              $GBF_COPY
;                              $GBF_VALIDBITS
;
; Return values..: Success   - Handle to the requested bitmap.
;                  Failure   - (-1) and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: If $iFlag is set to $GBF_COPY, release the bitmap returned by this function when no longer needed by calling
;                  _WinAPI_DeleteObject().
;
;                  This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeBitmap
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeBitmap($hTheme, $iPartId, $iStateId, $iPropId, $iFlag = 0x01)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeBitmap', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'ulong', $iFlag, 'ptr*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_GetThemeBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeBool
; Description....: Retrieves the value of a BOOL property from the SysMetrics section of theme data.
; Syntax.........: _WinAPI_GetThemeBool ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the BOOL property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve. It can be one of the following values.
;
;                              $TMT_TRANSPARENT
;                              $TMT_AUTOSIZE
;                              $TMT_BORDERONLY
;                              $TMT_COMPOSITED
;                              $TMT_BGFILL
;                              $TMT_GLYPHTRANSPARENT
;                              $TMT_GLYPHONLY
;                              $TMT_ALWAYSSHOWSIZINGBAR
;                              $TMT_MIRRORIMAGE
;                              $TMT_UNIFORMSIZING
;                              $TMT_INTEGRALSIZING
;                              $TMT_SOURCEGROW
;                              $TMT_SOURCESHRINK
;                              $TMT_USERPICTURE
;
; Return values..: Success   - The retrieved property value.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeBool
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeBool($hTheme, $iPartId, $iStateId, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeBool', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_GetThemeBool

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeColor
; Description....: Retrieves the value of a color property.
; Syntax.........: _WinAPI_GetThemeColor ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the color property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - The color value, in RGB.
;                  Failure   - (-1) and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeColor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeColor($hTheme, $iPartId, $iStateId, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeColor', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'dword*', 0)

	If @error Then
		Return SetError(1, 0, -1)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], -1)
		EndIf
	EndIf
	Return __RGB($Ret[5])
EndFunc   ;==>_WinAPI_GetThemeColor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeDocumentationProperty
; Description....: Retrieves the value for a theme property from the documentation section of the specified theme file.
; Syntax.........: _WinAPI_GetThemeDocumentationProperty ( $sFile, $sProperty )
; Parameters.....: $sFile     - The name of the theme file that will be opened to query for the property.
;                  $sProperty - The name of the theme property to query. This parameter can be one of the following values.
;
;                               $SZ_THDOCPROP_AUTHOR
;                               $SZ_THDOCPROP_CANONICALNAME
;                               $SZ_THDOCPROP_DISPLAYNAME
;                               $SZ_THDOCPROP_TOOLTIP
;
; Return values..: Success    - The property string value.
;                  Failure    - Empty string and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeDocumentationProperty
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeDocumentationProperty($sFile, $sProperty)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeDocumentationProperty', 'wstr', $sFile, 'wstr', $sProperty, 'wstr', '', 'int', 4096)

	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetThemeDocumentationProperty

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeEnumValue
; Description....: Retrieves the value of an enumerated type property.
; Syntax.........: _WinAPI_GetThemeEnumValue ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the enumerated type property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - The enumerated type value.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeEnumValue
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeEnumValue($hTheme, $iPartId, $iStateId, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeEnumValue', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_GetThemeEnumValue

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeFilename
; Description....: Retrieves the value of a filename property.
; Syntax.........: _WinAPI_GetThemeFilename ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the filename property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - The retrieved file name.
;                  Failure   - Empty string and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeFilename
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeFilename($hTheme, $iPartId, $iStateId, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeFilename', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'wstr', '', 'int', 4096)

	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_GetThemeFilename

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeFont
; Description....: Retrieves the value of a font property.
; Syntax.........: _WinAPI_GetThemeFont ( $hTheme, $iPartId, $iStateId, $iPropId [, $hDC] )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the font property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
;                  $hDC      - Handle to the device context.
; Return values..: Success   - $tagLOGFONT structure that contains a font property value.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeFont
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeFont($hTheme, $iPartId, $iStateId, $iPropId, $hDC = 0)

	Local $tLOGFONT = DllStructCreate($tagLOGFONT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeFont', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'ptr', DllStructGetPtr($tLOGFONT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tLOGFONT
EndFunc   ;==>_WinAPI_GetThemeFont

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeInt
; Description....: Retrieves the value of an INT property.
; Syntax.........: _WinAPI_GetThemeInt ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the INT property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - The retrieved property value.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeInt
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeInt($hTheme, $iPartId, $iStateId, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeInt', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_GetThemeInt

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeMargins
; Description....: Retrieves the value of a margins property.
; Syntax.........: _WinAPI_GetThemeMargins ( $hTheme, $iPartId, $iStateId, $iPropId, $hDC, $tRECT )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the MARGINS property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
;                  $hDC      - Handle to a device context to select fonts into.
;                  $tRECT    - $tagRECT structure that contains the rectangle that specifies the area to be drawn into.
; Return values..: Success   - $tagMARGINS structure that contains a margins value.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeMargins
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeMargins($hTheme, $iPartId, $iStateId, $iPropId, $hDC, $tRECT)

	Local $tMARGINS = DllStructCreate($tagMARGINS)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeMargins', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tMARGINS))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tMARGINS
EndFunc   ;==>_WinAPI_GetThemeMargins

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeMetric
; Description....: Retrieves the value of a metric property.
; Syntax.........: _WinAPI_GetThemeMetric ( $hTheme, $iPartId, $iStateId, $iPropId [, $hDC] )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the metric property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve. It can be one of the following values.
;
;                              $TMT_ALPHALEVEL
;                              $TMT_ALPHATHRESHOLD
;                              $TMT_BORDERSIZE
;                              $TMT_GLYPHINDEX
;                              $TMT_GRADIENTRATIO1
;                              $TMT_GRADIENTRATIO2
;                              $TMT_GRADIENTRATIO3
;                              $TMT_GRADIENTRATIO4
;                              $TMT_GRADIENTRATIO5
;                              $TMT_HEIGHT
;                              $TMT_IMAGECOUNT
;                              $TMT_MINDPI1
;                              $TMT_MINDPI2
;                              $TMT_MINDPI3
;                              $TMT_MINDPI4
;                              $TMT_MINDPI5
;                              $TMT_PROGRESSCHUNKSIZE
;                              $TMT_PROGRESSSPACESIZE
;                              $TMT_ROUNDCORNERWIDTH
;                              $TMT_ROUNDCORNERHEIGHT
;                              $TMT_SATURATION
;                              $TMT_TEXTBORDERSIZE
;                              $TMT_TRUESIZESTRETCHMARK
;                              $TMT_WIDTH
;
;                  $hDC      - Handle to the device context.
; Return values..: Success   - The metric property value.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeMetric
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeMetric($hTheme, $iPartId, $iStateId, $iPropId, $hDC = 0)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeMetric', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_GetThemeMetric

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemePartSize
; Description....: Calculates the original size of the part defined by a visual style.
; Syntax.........: _WinAPI_GetThemePartSize ( $hTheme, $iPartId, $iStateId, $hDC, $tRECT, $iType )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part part to calculate the size of.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to a device context to select fonts into.
;                  $tRECT    - $tagRECT structure that contains the rectangle used for the part drawing destination.
;                  $iType    - The type of size to retrieve. This parameter can be one of the following values.
;
;                              $TS_MIN
;                              $TS_TRUE
;                              $TS_DRAW
;
; Return values..: Success   - $tagSIZE structure that contains a dimensions of the specified part.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemePartSize
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemePartSize($hTheme, $iPartId, $iStateId, $hDC, $tRECT, $iType)

	Local $tSIZE = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemePartSize', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tRECT), 'int', $iType, 'ptr', DllStructGetPtr($tSIZE))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tSIZE
EndFunc   ;==>_WinAPI_GetThemePartSize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemePosition
; Description....: Retrieves the value of a position property.
; Syntax.........: _WinAPI_GetThemePosition ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the position property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - $tagPOINT structure that contains a position value.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemePosition
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemePosition($hTheme, $iPartId, $iStateId, $iPropId)

	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemePosition', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'ptr', DllStructGetPtr($tPOINT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tPOINT
EndFunc   ;==>_WinAPI_GetThemePosition

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemePropertyOrigin
; Description....: Retrieves the location of the theme property definition for a property.
; Syntax.........: _WinAPI_GetThemePropertyOrigin ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the theme.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - The value that indicates where the property was found. It can be one of the following values.
;
;                              0 - Property was found in the state section.
;                              1 - Property was found in the part section.
;                              2 - Property was found in the class section.
;                              3 - Property was found in the list of global variables.
;                              4 - Property was not found.
;
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemePropertyOrigin
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemePropertyOrigin($hTheme, $iPartId, $iStateId, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemePropertyOrigin', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'uint*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then

			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_GetThemePropertyOrigin

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeRect
; Description....: Retrieves the value of a RECT property.
; Syntax.........: _WinAPI_GetThemeRect ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part containing the RECT property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - $tagRECT structure that contains a rectangle.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeRect($hTheme, $iPartId, $iStateId, $iPropId)

	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeRect', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'ptr', DllStructGetPtr($tRECT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tRECT
EndFunc   ;==>_WinAPI_GetThemeRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeString
; Description....: Retrieves the value of a string property.
; Syntax.........: _WinAPI_GetThemeString ( $hTheme, $iPartId, $iStateId, $iPropId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part that contains the string property.
;                  $iStateId - The state of the part.
;                  $iPropId  - The property to retrieve ($TMT_*).
; Return values..: Success   - The retrieved string value.
;                  Failure   - Empty string and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeString
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeString($hTheme, $iPartId, $iStateId, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeString', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId, 'int', $iPropId, 'wstr', '', 'int', 4096)

	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_GetThemeString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeSysBool
; Description....: Retrieves the Boolean value of a system metric.
; Syntax.........: _WinAPI_GetThemeSysBool ( $hTheme, $iBoolId )
; Parameters.....: $hTheme  - Handle to the theme data.
;                  $iBoolId - The value that specifies the system Boolean metric desired. It may be the following value.
;
;                             $TMT_FLATMENUS
;
; Return values..: Success  - The value of desired system metric.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the theme data handle is not 0, this function returns the desired BOOL from the SysMetrics section of the
;                  visual style, otherwise, the function returns the value of the specified system Boolean.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeSysBool
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeSysBool($hTheme, $iBoolId)

	Local $Ret = DllCall('uxtheme.dll', 'int', 'GetThemeSysBool', 'ptr', $hTheme, 'int', $iBoolId)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThemeSysBool

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeSysColor
; Description....: Retrieves the value of a system color.
; Syntax.........: _WinAPI_GetThemeSysColor ( $hTheme, $iColorId )
; Parameters.....: $hTheme   - Handle to the theme data.
;                  $iColorId - The value that specifies the color number. It may be one of the $COLOR_* constants.
; Return values..: Success   - The value of the specified system color.
;                  Failure   - (-1) and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the theme data handle is not 0, this function returns the color from the SysMetrics section of the current
;                  visual style, otherwise, the function returns the color matching the global system color.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeSysColor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeSysColor($hTheme, $iColorId)

	Local $Ret = DllCall('uxtheme.dll', 'dword', 'GetThemeSysColor', 'ptr', $hTheme, 'int', $iColorId)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThemeSysColor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeSysColorBrush
; Description....: Retrieves a system color brush.
; Syntax.........: _WinAPI_GetThemeSysColorBrush ( $hTheme, $iColorId )
; Parameters.....: $hTheme   - Handle to the theme data.
;                  $iColorId - The value that specifies the number of the desired system color. It may be one of the following values.
;
;                              $TMT_SCROLLBAR
;                              $TMT_BACKGROUND
;                              $TMT_ACTIVECAPTION
;                              $TMT_INACTIVECAPTION
;                              $TMT_WINDOW
;                              $TMT_WINDOWFRAME
;                              $TMT_MENUTEXT
;                              $TMT_WINDOWTEXT
;                              $TMT_CAPTIONTEXT
;                              $TMT_ACTIVEBORDER
;                              $TMT_INACTIVEBORDER
;                              $TMT_APPWORKSPACE
;                              $TMT_HIGHLIGHT
;                              $TMT_HIGHLIGHTTEXT
;                              $TMT_BTNFACE
;                              $TMT_BTNSHADOW
;                              $TMT_GRAYTEXT
;                              $TMT_BTNTEXT
;                              $TMT_INACTIVECAPTIONTEXT
;                              $TMT_BTNHIGHLIGHT
;                              $TMT_DKSHADOW3D
;                              $TMT_LIGHT3D
;                              $TMT_INFOTEXT
;                              $TMT_INFOBK
;                              $TMT_BUTTONALTERNATEFACE
;                              $TMT_HOTTRACKING
;                              $TMT_GRADIENTACTIVECAPTION
;                              $TMT_GRADIENTINACTIVECAPTION
;                              $TMT_MENUHILIGHT
;                              $TMT_MENUBAR
;
; Return values..: Success   - Handle to the brush.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the theme data handle is not 0, this function returns the brush that matches the specified color from the SysMetrics
;                  section of the visual style, otherwise, the function returns the brush matching the global system color.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeSysColorBrush
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeSysColorBrush($hTheme, $iColorId)

	Local $Ret = DllCall('uxtheme.dll', 'ptr', 'GetThemeSysColorBrush', 'ptr', $hTheme, 'int', $iColorId)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThemeSysColorBrush

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeSysFont
; Description....: Retrieves the font information of a system font.
; Syntax.........: _WinAPI_GetThemeSysFont ( $hTheme, $iFontId )
; Parameters.....: $hTheme  - Handle to the theme data.
;                  $iFontId - The value that specifies a system font. It may be one of the following values.
;
;                             $TMT_CAPTIONFONT
;                             $TMT_SMALLCAPTIONFONT
;                             $TMT_MENUFONT
;                             $TMT_STATUSFONT
;                             $TMT_MSGBOXFONT
;                             $TMT_ICONTITLEFONT
;
; Return values..: Success  - $tagLOGFONT structure that contains the font information.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the theme data handle is not 0, this function returns the font information from the SysMetrics section of the
;                  visual style, otherwise, the function returns the value of the global system metric.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeSysFont
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeSysFont($hTheme, $iFontId)

	Local $tLOGFONT = DllStructCreate($tagLOGFONT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeSysFont', 'ptr', $hTheme, 'int', $iFontId, 'ptr', DllStructGetPtr($tLOGFONT))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tLOGFONT
EndFunc   ;==>_WinAPI_GetThemeSysFont

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeSysInt
; Description....: Retrieves the value of a system INT.
; Syntax.........: _WinAPI_GetThemeSysInt ( $hTheme, $iIntId )
; Parameters.....: $hTheme  - Handle to the theme data.
;                  $iBoolId - The value that specifies the desired system INT. It may be the following value.
;
;                             $TMT_MINCOLORDEPTH
;
; Return values..: Success  - The system integer value.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeSysInt
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeSysInt($hTheme, $iIntId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeSysInt', 'ptr', $hTheme, 'int', $iIntId, 'int*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetThemeSysInt

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeSysSize
; Description....: Retrieves the value of a system size metric from theme data.
; Syntax.........: _WinAPI_GetThemeSysSize ( $hTheme, $iSizeId )
; Parameters.....: $hTheme  - Handle to the theme data.
;                  $iSizeId - The value that specifies the system size metric desired. The following values are valid.
;
;                             $SM_CXBORDER
;                             $SM_CXVSCROLL
;                             $SM_CXHSCROLL
;                             $SM_CXSIZE
;                             $SM_CYSIZE
;                             $SM_CXSMSIZE
;                             $SM_CYSMSIZE
;                             $SM_CXMENUSIZE
;                             $SM_CYMENUSIZE
;                             $SM_CXPADDEDBORDER
;
; Return values..: Success  - The size in pixels.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If $hTheme is not 0, this function returns the size stored in the current visual style (SysMetrics section
;                  of the visual style) scaled to the current screen dpi. If $hTheme is 0, this function returns the global system
;                  metric in pixels that is scaled to the current dpi only if the application is marked as dpi-aware; otherwise,
;                  the pixels returned are unscaled.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeSysSize
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeSysSize($hTheme, $iSizeId)

	Local $Ret = DllCall('uxtheme.dll', 'int', 'GetThemeSysSize', 'ptr', $hTheme, 'int', $iSizeId)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThemeSysSize

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeSysString
; Description....: Retrieves the value of a system string.
; Syntax.........: _WinAPI_GetThemeSysString ( $hTheme, $iStringId )
; Parameters.....: $hTheme    - Handle to the theme data.
;                  $iStringId - The value that specifies a system string. It may be one of the following values.
;
;                               $TMT_CSSNAME
;                               $TMT_XMLNAME
;
; Return values..: Success    - The string value.
;                  Failure    - Empty string and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the theme data handle is not 0, this function returns the desired string from the SysMetrics section of the
;                  visual style, otherwise, the function returns the value of the global system metric.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeSysString
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeSysString($hTheme, $iStringId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeSysString', 'ptr', $hTheme, 'int', $iStringId, 'wstr', '', 'int', 4096)

	If @error Then
		Return SetError(1, 0, '')
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetThemeSysString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeTextExtent
; Description....: Calculates the size and location of the specified text when rendered in the visual style font.
; Syntax.........: _WinAPI_GetThemeTextExtent ( $hTheme, $iPartId, $iStateId, $hDC, $sText, $tRECT, $iFlags )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part in which the text will be drawn.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context to select the font into.
;                  $sText    - The string that contains the text to draw.
;                  $tRECT    - $tagRECT structure that contains the rectangle used to control layout of the text. This parameter may be set to 0.
;                  $iFlags   - The string's formatting flags ($DT_*).
; Return values..: Success   - $tagRECT structure that contains, in logical coordinates, the rectangle required to fit the rendered text.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeTextExtent
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeTextExtent($hTheme, $iPartId, $iStateId, $hDC, $sText, $tRECT, $iFlags)

	Local $tAREA = DllStructCreate($tagRECT)
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeTextExtent', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'wstr', $sText, 'int', -1, 'dword', $iFlags, 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tAREA))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tAREA
EndFunc   ;==>_WinAPI_GetThemeTextExtent

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeTextMetrics
; Description....: Retrieves information about the font specified by a visual style for a particular part.
; Syntax.........: _WinAPI_GetThemeTextMetrics ( $hTheme, $iPartId, $iStateId [, $hDC] )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part to retrieve font information about.
;                  $iStateId - The state of the part.
;                  $hDC      - Handle to the device context to use for screen context.
; Return values..: Success   - $tagTEXTMETRIC structure that contains the font information.
;                  Failure   - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThemeTextMetrics
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeTextMetrics($hTheme, $iPartId, $iStateId, $hDC = 0)

;	Local $tTEXTMETRIC = DllStructCreate($tagTEXTMETRIC)
	Local $tTEXTMETRIC = DllStructCreate('long tmHeight;long tmAscent;long tmDescent;long tmInternalLeading;long tmExternalLeading;long tmAveCharWidth;long tmMaxCharWidth;long tmWeight;long tmOverhang;long tmDigitizedAspectX;long tmDigitizedAspectY;wchar tmFirstChar;wchar tmLastChar;wchar tmDefaultChar;wchar tmBreakChar;byte tmItalic;byte tmUnderlined;byte tmStruckOut;byte tmPitchAndFamily;byte tmCharSet')
	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeTextMetrics', 'ptr', $hTheme, 'hwnd', $hDC, 'int', $iPartId, 'int', $iStateId, 'ptr', DllStructGetPtr($tTEXTMETRIC))

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $tTEXTMETRIC
EndFunc   ;==>_WinAPI_GetThemeTextMetrics

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThemeTransitionDuration
; Description....: Gets the duration for the specified transition.
; Syntax.........: _WinAPI_GetThemeTransitionDuration ( $hTheme, $iPartId, $iStateIdFrom, $iStateIdTo, $iPropId )
; Parameters.....: $hTheme       - Handle of the theme data.
;                  $iPartId      - ID of the part.
;                  $iStateIdFrom - The state ID of the part before the transition.
;                  $iStateIdTo   - The state ID of the part after the transition.
;                  $iPropId      - The property ID ($TMT_*).
; Return values..: Success       - The transition duration, in milliseconds.
;                  Failure       - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetThemeTransitionDuration
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThemeTransitionDuration($hTheme, $iPartId, $iStateIdFrom, $iStateIdTo, $iPropId)

	Local $Ret = DllCall('uxtheme.dll', 'uint', 'GetThemeTransitionDuration', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateIdFrom, 'int', $iStateIdTo, 'int', $iPropId, 'dword*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_GetThemeTransitionDuration

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThreadDesktop
; Description....: Retrieves a handle to the desktop assigned to the specified thread.
; Syntax.........: _WinAPI_GetThreadDesktop ( $iThreadID )
; Parameters.....: $iThreadID - The thread identifier. The _WinAPI_CreateProcess() and _WinAPI_GetCurrentThreadID() return thread identifiers.
; Return values..: Success    - Handle to the desktop associated with the specified thread.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: You do not need to call the _WinAPI_CloseDesktop() function to close the returned handle.
; Related........:
; Link...........: @@MsdnLink@@ GetThreadDesktop
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThreadDesktop($iThreadID)

	Local $Ret = DllCall('user32.dll', 'ptr', 'GetThreadDesktop', 'dword', $iThreadID)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThreadDesktop

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThreadErrorMode
; Description....: Retrieves the error mode for the calling thread.
; Syntax.........: _WinAPI_GetThreadErrorMode ( )
; Parameters.....: None
; Return values..: Success - The process error mode ($SEM_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows 7 or later.
; Related........:
; Link...........: @@MsdnLink@@ GetThreadErrorMode
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThreadErrorMode()

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetThreadErrorMode')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThreadErrorMode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThreadLocale
; Description....: Retrieves the locale identifier of the current locale for the calling thread.
; Syntax.........: _WinAPI_GetThreadLocale ( )
; Parameters.....: None
; Return values..: Success - The locale identifier (LCID) of the locale associated with the current thread.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetThreadLocale
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThreadLocale()

	Local $Ret = DllCall('kernel32.dll', 'ulong', 'GetThreadLocale')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThreadLocale

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetThreadUILanguage
; Description....: Retrieves the language identifier of the first user interface language for the current thread.
; Syntax.........: _WinAPI_GetThreadUILanguage ( )
; Parameters.....: None
; Return values..: Success - The identifier for a language associated with the current thread.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetThreadUILanguage
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetThreadUILanguage()

	Local $Ret = DllCall('kernel32.dll', 'ushort', 'GetThreadUILanguage')

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetThreadUILanguage

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTickCount
; Description....: Retrieves the number of milliseconds that have elapsed since the system was started.
; Syntax.........: _WinAPI_GetTickCount ( )
; Parameters.....: None
; Return values..: Success - The number of milliseconds that have elapsed since the system was started.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The time will wrap around to zero if the system is run continuously for 49.7 days. You should check for an
;                  overflow condition when comparing times. To obtain the time elapsed since the computer was started, retrieve the
;                  System Up Time counter in the performance data in the registry key HKEY_PERFORMANCE_DATA.
; Related........:
; Link...........: @@MsdnLink@@ GetTickCount
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTickCount()

	Local $Ret = DllCall('kernel32.dll', 'dword', 'GetTickCount')

    If @error Then
		Return SetError(1, 0, 0)
	EndIf
    Return $Ret[0]
EndFunc   ;==>_WinAPI_GetTickCount

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTickCount64
; Description....: Retrieves the number of milliseconds that have elapsed since the system was started.
; Syntax.........: _WinAPI_GetTickCount64 ( )
; Parameters.....: None
; Return values..: Success - The number of milliseconds that have elapsed since the system was started.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetTickCount64
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTickCount64()

	Local $Ret = DllCall('kernel32.dll', 'uint64', 'GetTickCount64')

    If @error Then
		Return SetError(1, 0, 0)
	EndIf
    Return $Ret[0]
EndFunc   ;==>_WinAPI_GetTickCount64

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTimeFormat
; Description....: Formats time as a time string for a locale specified by identifier.
; Syntax.........: _WinAPI_GetTimeFormat ( [$LCID [, $tSYSTEMTIME [, $iFlag [, $sFormat]]]] )
; Parameters.....: $LCID        - The locale identifier (LCID) that specifies the locale or one of the following predefined values.
;
;                                 $LOCALE_INVARIANT
;                                 $LOCALE_SYSTEM_DEFAULT
;                                 $LOCALE_USER_DEFAULT
;
;                                 Windows Vista or later
;
;                                 $LOCALE_CUSTOM_DEFAULT
;                                 $LOCALE_CUSTOM_UI_DEFAULT
;                                 $LOCALE_CUSTOM_UNSPECIFIED
;
;                  $tSYSTEMTIME - $tagSYSTEMTIME structure that contains the time information to format. If this parameter is 0,
;                                 the function will use the current local system time.
;                  $iFlag       - The flags that specifies the time format options. This parameter can be one or more of the
;                                 following values.
;
;                                 $TIME_FORCE24HOURFORMAT
;                                 $TIME_NOMINUTESORSECONDS
;                                 $TIME_NOSECONDS
;                                 $TIME_NOTIMEMARKER
;
;                  $sFormat     - The string that is used to form the time. For example, "hh:mm:ss tt". If this parameter is
;                                 omitted or an empty string, the function returns the string according to the time format
;                                 for the specified locale.
; Return values..: Success      - The formatted time string.
;                  Failure      - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetTimeFormat
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTimeFormat($LCID = 0, $tSYSTEMTIME = 0, $iFlags = 0, $sFormat = '')

	Local $TypeOfFormat = 'wstr'

	If Not $LCID Then
		$LCID = 0x0400
	EndIf
	If Not StringStripWS($sFormat, 3) Then
		$TypeOfFormat = 'ptr'
		$sFormat = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetTimeFormatW', 'ulong', $LCID, 'dword', $iFlags, 'ptr', DllStructGetPtr($tSYSTEMTIME), $TypeOfFormat, $sFormat, 'wstr', '', 'int', 2048)

    If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
    Return $Ret[5]
EndFunc   ;==>_WinAPI_GetTimeFormat

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetTopWindow
; Description....: Retrieves a handle to the child window at the top of the Z order.
; Syntax.........: _WinAPI_GetTopWindow ( $hWnd )
; Parameters.....: $hWnd   - Handle to the parent window whose child windows are to be examined. If this parameter is 0, the function
;                            returns a handle to the window at the top of the Z order.
; Return values..: Success - Handle to the child window at the top of the Z order. If the specified window has no child windows,
;                            the return value is 0.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetTopWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetTopWindow($hWnd)

	Local $Ret = DllCall('user32.dll', 'hwnd', 'GetTopWindow', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetTopWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUDFColorMode
; Description....: Retrieves the current color mode for WinAPIEx UDF library.
; Syntax.........: _WinAPI_GetUDFColorMode ( )
; Parameters.....: None
; Return values..: The current UDF color mode ($UDF_*).
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUDFColorMode()
	Return Number($__RGB)
EndFunc   ;==>_WinAPI_GetUDFColorMode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUDFVersion
; Description....: Retrieves the current version of WinAPIEx UDF library.
; Syntax.........: _WinAPI_GetUDFVersion ( )
; Parameters.....: None
; Return values..: The version of this UDF library.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUDFVersion()
	Return $__UDFVER
EndFunc   ;==>_WinAPI_GetUDFVersion

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUpdateRect
; Description....: Retrieves the coordinates of the rectangle that completely encloses the update region of the specified window.
; Syntax.........: _WinAPI_GetUpdateRect ( $hWnd [, $fErase] )
; Parameters.....: $hWnd   - Handle to the window whose update region is to be retrieved.
;                  $fErase - Specifies whether the background in the update region is to be erased, valid values:
;                  |TRUE   - The background is erased. (Default)
;                  |FALSE  - The background remains unchanged.
; Return values..: Success - $tagRECT structure that contains the coordinates of the enclosing rectangle, in device units.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The update rectangle retrieved by the _WinAPI_BeginPaint() function is identical to that retrieved by
;                  _WinAPI_GetUpdateRect()
;
;                  _WinAPI_BeginPaint() automatically validates the update region, so any call to _WinAPI_GetUpdateRect() made
;                   immediately after the call to _WinAPI_BeginPaint() retrieves an empty update region.
; Related........:
; Link...........: @@MsdnLink@@ GetUpdateRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUpdateRect($hWnd, $fErase = 1)

	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'int', 'GetUpdateRect', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tRECT), 'int', $fErase)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tRECT
EndFunc   ;==>_WinAPI_GetUpdateRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUpdateRgn
; Description....: Retrieves the update region of a window by copying it into the specified region.
; Syntax.........: _WinAPI_GetUpdateRgn ( $hWnd, $hRgn [, $fErase] )
; Parameters.....: $hWnd   - Handle to the window with an update region that is to be retrieved.
;                  $hRgn   - Handle to the region to receive the update region.
;                  $fErase - Specifies whether the background in the update region is to be erased, valid values:
;                  |TRUE   - The background is erased. (Default)
;                  |FALSE  - The background remains unchanged.
; Return values..: Success - The value that indicates the complexity of the resulting region; it can be one of the following values.
;
;                            $COMPLEXREGION
;                            $NULLREGION
;                            $SIMPLEREGION
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: _WinAPI_BeginPaint() automatically validates the update region, so any call to _WinAPI_GetUpdateRgn() made
;                  immediately after the call to _WinAPI_BeginPaint() retrieves an empty update region.
; Related........:
; Link...........: @@MsdnLink@@ GetUpdateRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUpdateRgn($hWnd, $hRgn, $fErase = 1)

	Local $Ret = DllCall('user32.dll', 'int', 'GetUpdateRgn', 'hwnd', $hWnd, 'ptr', $hRgn, 'int', $fErase)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetUpdateRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUserDefaultLangID
; Description....: Returns the language identifier for the current user locale.
; Syntax.........: _WinAPI_GetUserDefaultLangID ( )
; Parameters.....: None
; Return values..: Success - The language identifier for the current user locale.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetUserDefaultLangID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUserDefaultLangID()

    Local $Ret = DllCall('kernel32.dll', 'ulong', 'GetUserDefaultLangID')

    If @error Then
		Return SetError(1, 0, 0)
	EndIf
    Return $Ret[0]
EndFunc   ;==>_WinAPI_GetUserDefaultLangID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUserDefaultLCID
; Description....: Returns the locale identifier (LCID) for the user default locale.
; Syntax.........: _WinAPI_GetUserDefaultLCID ( )
; Parameters.....: None
; Return values..: Success - The default LCID for the user.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetUserDefaultLCID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUserDefaultLCID()

    Local $Ret = DllCall('kernel32.dll', 'ulong', 'GetUserDefaultLCID')

    If @error Then
		Return SetError(1, 0, 0)
	EndIf
    Return $Ret[0]
EndFunc   ;==>_WinAPI_GetUserDefaultLCID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUserDefaultUILanguage
; Description....: Returns the language identifier for the user UI language for the current user.
; Syntax.........: _WinAPI_GetUserDefaultUILanguage ( )
; Parameters.....: None
; Return values..: Success - The language identifier.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If Multilingual User Interface (MUI) is not installed on the operating system, the function returns the default
;                  computer user interface language.
; Related........:
; Link...........: @@MsdnLink@@ GetUserDefaultUILanguage
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUserDefaultUILanguage()

	Local $Ret = DllCall('kernel32.dll', 'ushort', 'GetUserDefaultUILanguage')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetUserDefaultUILanguage

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUserGeoID
; Description....: Retrieves information about the geographical location of the user.
; Syntax.........: _WinAPI_GetUserGeoID ( )
; Parameters.....: None
; Return values..: Success - The geographical location identifier of the user.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetUserGeoID
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUserGeoID()

    Local $Ret = DllCall('kernel32.dll', 'long', 'GetUserGeoID', 'uint', 16)

    If (@error) Or ($Ret[0] = -1) Then
		Return SetError(1, 0, 0)
	EndIf
    Return $Ret[0]
EndFunc   ;==>_WinAPI_GetUserGeoID

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetUserObjectInformation
; Description....: Retrieves information about the specified window station or desktop object.
; Syntax.........: _WinAPI_GetUserObjectInformation ( $hObject, $iIndex )
; Parameters.....: $hObject - Handle to the window station or desktop object.
;                  $iIndex  - The information to be retrieved. The parameter can be one of the following values.
;
;                             $UOI_FLAGS
;                             $tagUSEROBJECTFLAGS structure containing information about a window station or desktop handle.
;
;                             $UOI_HEAPSIZE
;                             The size of the desktop heap, in KB.
;
;                             $UOI_IO
;                             1 if the object is a handle to the desktop that is receiving input from the user, 0 otherwise.
;
;                             $UOI_NAME
;                             The name of the object, as a string.
;
;                             $UOI_TYPE
;                             The type of the object, as a string.
;
;                             $UOI_USER_SID
;                             The security identifier (SID) structure as "byte[n]".
;
; Return values..: Success  - The object information. Return type depends on the information type (see above).
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetUserObjectInformation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetUserObjectInformation($hObject, $iIndex)

	Local $Ret, $tData

	$Ret = DllCall('user32.dll', 'int', 'GetUserObjectInformationW', 'ptr', $hObject, 'int', $iIndex, 'ptr', 0, 'dword', 0, 'dword*', 0)
	If (@error) Or (Not $Ret[5]) Then
		Return SetError(1, 0, 0)
	EndIf
	Switch $iIndex
		Case 1
			$tData = DllStructCreate($tagUSEROBJECTFLAGS)
		Case 5, 6
			$tData = DllStructCreate('uint')
		Case 2, 3
			$tData = DllStructCreate('wchar[' & $Ret[5] & ']')
		Case 4
			$tData = DllStructCreate('byte[' & $Ret[5] & ']')
		Case Else
			Return SetError(1, 0, 0)
	EndSwitch
	$Ret = DllCall('user32.dll', 'int', 'GetUserObjectInformationW', 'ptr', $hObject, 'int', $iIndex, 'ptr', DllStructGetPtr($tData), 'dword', DllStructGetSize($tData), 'dword*', 0)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Switch $iIndex
		Case 1, 4
			Return $tData
		Case Else
			Return DllStructGetData($tData, 1)
	EndSwitch
EndFunc   ;==>_WinAPI_GetUserObjectInformation

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetVersion
; Description....: Retrieves version of the current operating system.
; Syntax.........: _WinAPI_GetVersion ( )
; Parameters.....: None
; Return values..: Success - The string containing the current OS version.
;
;                            "6.1" - Windows 7 / Windows Server 2008 R2
;                            "6.0" - Windows Server 2008 / Windows Vista
;                            "5.2" - Windows Server 2003 R2 / Windows Home Server / Windows Server 2003 / Windows XP Professional x64 Edition
;                            "5.1" - Windows XP
;                            "5.0" - Windows 2000
;
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetVersion()
	Return _WinAPI_HiByte($__WINVER) & '.' & _WinAPI_LoByte($__WINVER)
EndFunc   ;==>_WinAPI_GetVersion

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetVersionEx
; Description....: Retrieves information about the current operating system.
; Syntax.........: _WinAPI_GetVersionEx ( )
; Parameters.....: None
; Return values..: Success - $tagOSVERSIONINFOEX structure that contains the information about the current operating system.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When using the GetVersionEx function to determine whether your application is running on a particular version of
;                  the operating system, check for version numbers that are greater than or equal to the desired version numbers.
;                  This ensures that the test succeeds for later versions of the operating system.
; Related........:
; Link...........: @@MsdnLink@@ GetVersionEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetVersionEx()

	Local $tOSVERSIONINFOEX = DllStructCreate($tagOSVERSIONINFOEX)

	DllStructSetData($tOSVERSIONINFOEX, 'OSVersionInfoSize', DllStructGetSize($tOSVERSIONINFOEX))

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetVersionExW', 'ptr', DllStructGetPtr($tOSVERSIONINFOEX))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tOSVERSIONINFOEX
EndFunc   ;==>_WinAPI_GetVersionEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetVolumeInformation
; Description....: Retrieves information about the file system and volume associated with the specified root directory.
; Syntax.........: _WinAPI_GetVolumeInformation ( [$sRoot] )
; Parameters.....: $sRoot  - The root directory of the volume to be described. If this parameter is empty string, the root
;                            of the current directory is used. A trailing backslash is required. For example, you specify
;                            "\\MyServer\MyShare" as "\\MyServer\MyShare\", or the "C" drive as "C:\".
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The name of a volume.
;                            [2] - The serial number of a volume.
;                            [1] - The maximum length, in TCHARs, of a file name component that a file system supports.
;                            [3] - The flags associated with the file system ($FILE_*).
;                            [4] - The name of the file system, for example, "FAT", "NTFS", etc.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: When a user attempts to get information about a floppy drive that does not have a floppy disk, or a CD-ROM
;                  drive that does not have a compact disc, the system displays a message box for the user to insert a floppy disk
;                  or a compact disc, respectively. To prevent the system from displaying this message box, call the
;                  _WinAPI_SetErrorMode() function with $SEM_FAILCRITICALERRORS.
; Related........:
; Link...........: @@MsdnLink@@ GetVolumeInformation
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetVolumeInformation($sRoot = '')

	Local $TypeOfRoot = 'wstr'

	If Not StringStripWS($sRoot, 3) Then
		$TypeOfRoot = 'ptr'
		$sRoot = 0
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetVolumeInformationW', $TypeOfRoot, $sRoot, 'wstr', '', 'dword', 4096, 'dword*', 0, 'dword*', 0, 'dword*', 0, 'wstr', '', 'dword', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[5]

	For $i = 0 To 4
		Switch $i
			Case 0
				$Result[$i] = $Ret[2]
			Case Else
				$Result[$i] = $Ret[$i + 3]
		EndSwitch
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetVolumeInformation

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetVolumeInformationByHandle
; Description....: Retrieves information about the file system and volume associated with the specified file.
; Syntax.........: _WinAPI_GetVolumeInformationByHandle ( $hFile )
; Parameters.....: $hFile  - A handle to the file.
; Return values..: Success - The array that contains the following information:
;
;                            [0] - The name of a volume.
;                            [2] - The serial number of a volume.
;                            [1] - The maximum length, in TCHARs, of a file name component that a file system supports.
;                            [3] - The flags associated with the file system ($FILE_*).
;                            [4] - The name of the file system, for example, "FAT", "NTFS", etc.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ GetVolumeInformationByHandleW
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetVolumeInformationByHandle($hFile)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetVolumeInformationByHandleW', 'ptr', $hFile, 'wstr', '', 'dword', 4096, 'dword*', 0, 'dword*', 0, 'dword*', 0, 'wstr', '', 'dword', 4096)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Result[5]

	For $i = 0 To 4
		Switch $i
			Case 0
				$Result[$i] = $Ret[2]
			Case Else
				$Result[$i] = $Ret[$i + 3]
		EndSwitch
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetVolumeInformationByHandle

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetVolumeNameForVolumeMountPoint
; Description....: Retrieves a volume GUID path for the volume that is associated with the specified volume mount point.
; Syntax.........: _WinAPI_GetVolumeNameForVolumeMountPoint ( $sPath )
; Parameters.....: $sPath  - The path of a mounted folder (for example, Y:\MountX\) or a drive letter (for example, X:\).
; Return values..: Success - The volume GUID path. This path is of the form "\\?\Volume{GUID}\" where GUID is a GUID that
;                            identifies the volume. If there is more than one volume GUID path for the volume, only the first one
;                            in the mount manager's cache is returned.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetVolumeNameForVolumeMountPoint
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetVolumeNameForVolumeMountPoint($sPath)

	Local $Ret = DllCall('kernel32.dll', 'int', 'GetVolumeNameForVolumeMountPointW', 'wstr', $sPath, 'wstr', '', 'dword', 80)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, '')
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetVolumeNameForVolumeMountPoint

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowDisplayAffinity
; Description....: Retrieves the current display affinity setting, from any process, for a given window.
; Syntax.........: _WinAPI_GetWindowDisplayAffinity ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window for which display affinity setting is retrieved.
; Return values..: Success - The current window's display affinity setting ($WDA_*).
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function succeeds only when the window is layered and Desktop Windows Manager (DWM) is composing the desktop.
;                  For more information, see _WinAPI_SetWindowDisplayAffinity().
;
;                  This function requires Windows 7 or later.
; Related........:
; Link...........: @@MsdnLink@@ GetWindowDisplayAffinity
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowDisplayAffinity($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'GetWindowDisplayAffinity', 'hwnd', $hWnd, 'dword*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetWindowDisplayAffinity

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowExt
; Description....: Retrieves the x-extent and y-extent of the window for the specified device context.
; Syntax.........: _WinAPI_GetWindowExt ( $hDC )
; Parameters.....: $hDC      - Handle to the device context.
; Return values..: Success   - $tagSIZE structure that contains the x- and y-extents in page-space units, that is, logical units.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetWindowExtEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowExt($hDC)

	Local $tSIZE = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetWindowExtEx', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tSIZE))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tSIZE
EndFunc   ;==>_WinAPI_GetWindowExt

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowFileName
; Description....: Retrieves the fully-qualified path of the module associated with the specified window handle.
; Syntax.........: _WinAPI_GetWindowFileName ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window whose module file name will be retrieved.
; Return values..: Success - The full path and file name.
;                  Failure - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowFileName($hWnd)

	Local $PID = 0, $Result

	If _WinAPI_IsWindow($hWnd) Then
		_WinAPI_GetWindowThreadProcessId($hWnd, $PID)
	EndIf
	If Not $PID Then
		Return SetError(1, 0, '')
	EndIf
	$Result = _WinAPI_GetProcessFileName($PID)
	If @error Then
		Return SetError(1, 0, '')
	EndIf
	Return $Result
EndFunc   ;==>_WinAPI_GetWindowFileName

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowInfo
; Description....: Retrieves information about the specified window.
; Syntax.........: _WinAPI_GetWindowInfo ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window whose information is to be retrieved.
; Return values..: Success - $tagWINDOWINFO structure that contains the information about the specified window.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetWindowInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowInfo($hWnd)

	Local $tWINDOWINFO = DllStructCreate($tagWINDOWINFO)

	DllStructSetData($tWINDOWINFO, 'Size', DllStructGetSize($tWINDOWINFO))

	Local $Ret = DllCall('user32.dll', 'int', 'GetWindowInfo', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tWINDOWINFO))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tWINDOWINFO
EndFunc   ;==>_WinAPI_GetWindowInfo

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowLongEx
; Description....: Retrieves information about the specified window.
; Syntax.........: _WinAPI_GetWindowLongEx ( $hWnd, $iIndex )
; Parameters.....: $hWnd   - Handle to the window and, indirectly, the class to which the window belongs.
;                  $iIndex - The zero-based offset to the value to be retrieved. Valid values are in the range zero through the
;                            number of bytes of extra window memory, minus the size of an integer. To retrieve any other value,
;                            specify one of the following values.
;
;                            $GWL_EXSTYLE
;                            $GWL_HINSTANCE
;                            $GWL_HWNDPARENT
;                            $GWL_ID
;                            $GWL_STYLE
;                            $GWL_USERDATA
;                            $GWL_WNDPROC
;
; Return values..: Success - The requested value.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If _WinAPI_SetWindowLongEx() has not been called previously, _WinAPI_GetWindowLongEx() returns 0.
; Related........:
; Link...........: @@MsdnLink@@ GetWindowLong
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowLongEx($hWnd, $iIndex)

	Local $Ret

	If @AutoItX64 Then
		$Ret = DllCall('user32.dll', 'long_ptr', 'GetWindowLongPtrW', 'hwnd', $hWnd, 'int', $iIndex)
	Else
		$Ret = DllCall('user32.dll', 'long', 'GetWindowLongW', 'hwnd', $hWnd, 'int', $iIndex)
	EndIf
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetWindowLongEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowOrg
; Description....: Retrieves the x-coordinates and y-coordinates of the window origin for the specified device context.
; Syntax.........: _WinAPI_GetWindowOrg ( $hDC )
; Parameters.....: $hDC      - Handle to the device context.
; Return values..: Success   - $tagPOINT structure that receives the coordinates, in logical units, of the window origin.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetWindowOrgEx
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowOrg($hDC)

	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetWindowOrgEx', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tPOINT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tPOINT
EndFunc   ;==>_WinAPI_GetWindowOrg

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowRgnBox
; Description....: Retrieves the dimensions of the tightest bounding rectangle for the window region of a window.
; Syntax.........: _WinAPI_GetWindowRgnBox ( $hWnd, ByRef $tRECT )
; Parameters.....: $hWnd   - Handle to the window.
;                  $tRECT  - $tagRECT structure that is created by this function, and contains the rectangle dimensions, in device
;                            units relative to the upper-left corner of the window.
; Return values..: Success - The value that specifies the region's complexity; it can be one of the following values.
;
;                            $COMPLEXREGION
;                            $NULLREGION
;                            $SIMPLEREGION
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetWindowRgnBox
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowRgnBox($hWnd, ByRef $tRECT)

	$tRECT = DllStructCreate($tagRECT)

	Local $Ret = DllCall('gdi32.dll', 'int', 'GetWindowRgnBox', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		$tRECT = 0
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetWindowRgnBox

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowSubclass
; Description....: Retrieves the reference data for the specified window subclass callback.
; Syntax.........: _WinAPI_GetWindowSubclass ( $hWnd, $pSubclassProc, $ID )
; Parameters.....: $hWnd          - Handle of the window being subclassed.
;                  $pSubclassProc - A pointer to a window procedure. This pointer and the subclass ID uniquely identify this subclass callback.
;
;                                   (See MSDN for more information)
;
;                  $ID            - The subclass ID.
; Return values..: Success - The reference data for the window subclass callback.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetWindowSubclass
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowSubclass($hWnd, $pSubclassProc, $ID)

	Local $Ret = DllCall('comctl32.dll', 'int', 'GetWindowSubclass', 'hwnd', $hWnd, 'ptr', $pSubclassProc, 'uint_ptr', $ID, 'dword_ptr*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[4]
EndFunc   ;==>_WinAPI_GetWindowSubclass

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWindowTheme
; Description....: Retrieves a theme handle to a window that has visual styles applied.
; Syntax.........: _WinAPI_GetWindowTheme ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window.
; Return values..: Success - Handle to the theme or 0 if no visual style is applied.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ GetWindowTheme
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWindowTheme($hWnd)

	Local $Ret = DllCall('uxtheme.dll', 'ptr', 'GetWindowTheme', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetWindowTheme

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWorkArea
; Description....: Retrieves the size of the working area on the primary display monitor.
; Syntax.........: _WinAPI_GetWorkArea ( )
; Parameters.....: None
; Return values..: Success - $tagRECT structure that contains the screen coordinates of the working area.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ SystemParametersInfo
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWorkArea()

	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'int', 'SystemParametersInfo', 'uint', 48, 'uint', 0, 'ptr', DllStructGetPtr($tRECT), 'uint', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tRECT
EndFunc   ;==>_WinAPI_GetWorkArea

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GetWorldTransform
; Description....: Retrieves the current world-space to page-space transformation.
; Syntax.........: _WinAPI_GetWorldTransform ( $hDC )
; Parameters.....: $hDC    - Handle to the device context.
; Return values..: Success - $tagXFORM structure that contains the current world-space to page-space transformation.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The precision of the transformation may be altered if an application calls the _WinAPI_ModifyWorldTransform()
;                  prior to calling _WinAPI_GetWorldTransform(). This is because the internal format for storing transformation
;                  values uses a higher precision than a FLOAT value.
; Related........:
; Link...........: @@MsdnLink@@ GetWorldTransform
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GetWorldTransform($hDC)

	Local $tXFORM = DllStructCreate($tagXFORM)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetWorldTransform', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tXFORM))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tXFORM
EndFunc   ;==>_WinAPI_GetWorldTransform

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_GradientFill
; Description....: Fills rectangle or triangle gradient.
; Syntax.........: _WinAPI_GradientFill ( $hDC, Const ByRef $aVertex [, $iStart [, $iEnd [, $fRotate]]] )
; Parameters.....: $hDC     - Handle to the device context.
;                  $aVertex - The 2D array ([x1, y1, $rgb1], [x2, y2, $rgb2], ... [xN, yN, $rgbN]) that contains the necessary
;                             gradient vertices. Each vertex in this array contains the following parameters.
;
;                             x   - The x-coordinate, in logical units.
;                             y   - The y-coordinate, in logical units
;                             rgb - The color information at the point of x, y.
;
;                  $iStart  - The index of array to start filling at.
;                  $iEnd    - The index of array to stop filling at.
;                  $fRotate - Specifies whether fills a rectangle from left to right edge (horizontal gradient). $fRotate used
;                             only for the rectangular gradients, for the triangular gradients this parameter will be ignored,
;                             valid values:
;                  |TRUE    - Fills from left to right edge.
;                  |FALSE   - Fills from top to bottom edge. (Default)
; Return values..: Success  - 1.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the number of vertices defined by using $iStart and $iEnd parameters is 2, _WinAPI_GradientFill() function
;                  fills a rectangle. If the number of vertices is 3, fills a triangle. For the rectangle, the vertices must
;                  specify its upper left and lower right corners. Note that $aVertex array may contain any number of vertices
;                  of the gradient, but only 2 or 3 vertices may be used at the same time from this array.
;                  Otherwise, the function is fails.
;
;                  _WinAPI_GradientFill() function can only fill the rectangle or triangle at one call. Use multiple calls this
;                  function to fill a complex gradients.
; Related........:
; Link...........: @@MsdnLink@@ GdiGradientFill
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_GradientFill($hDC, Const ByRef $aVertex, $iStart = 0, $iEnd = -1, $fRotate = 0)

	If UBound($aVertex, 2) < 3  Then
		Return SetError(2, 0, 0)
	EndIf

	Local $Count, $Mode, $Point, $tGradient, $tVertex, $Struct = ''

	If $iStart < 0 Then
		$iStart = 0
	EndIf
	If ($iEnd < 0) Or ($iEnd > UBound($aVertex) - 1) Then
		$iEnd = UBound($aVertex) - 1
	EndIf
	$Point = $iEnd - $iStart + 1
	If $Point > 3 Then
		$iEnd = $iStart + 2
		$Point = 3
	EndIf
	Switch $Point
		Case 2
			$Mode = Number(Not $fRotate)
		Case 3
			$Mode = 2
		Case Else
			Return SetError(1, 0, 0)
	EndSwitch
	For $i = $iStart To $iEnd
		$Struct &= 'ushort[8];'
	Next
	$tVertex = DllStructCreate($Struct)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$Count = 1
	$tGradient = DllStructCreate('ulong[' & $Point & ']')
	For $i = $iStart To $iEnd
		DllStructSetData($tGradient, 1, $Count - 1, $Count)
		DllStructSetData($tVertex, $Count, _WinAPI_LoWord($aVertex[$i][0]), 1)
		DllStructSetData($tVertex, $Count, _WinAPI_HiWord($aVertex[$i][0]), 2)
		DllStructSetData($tVertex, $Count, _WinAPI_LoWord($aVertex[$i][1]), 3)
		DllStructSetData($tVertex, $Count, _WinAPI_HiWord($aVertex[$i][1]), 4)
		DllStructSetData($tVertex, $Count, BitShift(_WinAPI_GetRValue($aVertex[$i][2]), -8), 5)
		DllStructSetData($tVertex, $Count, BitShift(_WinAPI_GetGValue($aVertex[$i][2]), -8), 6)
		DllStructSetData($tVertex, $Count, BitShift(_WinAPI_GetBValue($aVertex[$i][2]), -8), 7)
		DllStructSetData($tVertex, $Count, 0, 8)
		$Count += 1
	Next

	Local $Ret = DllCall('gdi32.dll', 'int', 'GdiGradientFill', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tVertex), 'ulong', $Point, 'ptr', DllStructGetPtr($tGradient), 'ulong', 1, 'ulong', $Mode)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_GradientFill

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_HashData
; Description....: Hashes a memory block.
; Syntax.........: _WinAPI_HashData ( $pMemory, $iSize [, $iLength] )
; Parameters.....: $pMemory - A pointer to a memory block containing data to hash.
;                  $iSize   - The size of the memory block, in bytes.
;                  $iLength - The length of the hash data, in bytes. It should be no larger than 256, otherwise, the function fails.
; Return values..: Success  - The hash data in binary form.
;                  Failure  - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ HashData
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_HashData($pMemory, $iSize, $iLength = 32)

	If $iLength > 256 Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tData = DllStructCreate('byte[' & $iLength & ']')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

    Local $Ret = DllCall('shlwapi.dll', 'uint', 'HashData', 'ptr', $pMemory, 'dword', $iSize, 'ptr', DllStructGetPtr($tData), 'dword', $iLength)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], '')
		EndIf
	EndIf
    Return DllStructGetData($tData, 1)
EndFunc   ;==>_WinAPI_HashData

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_HashString
; Description....: Hashes a string.
; Syntax.........: _WinAPI_HashString ( $sString [, $fCaseSensitive [, $iLength]] )
; Parameters.....: $sString        - The string to hash.
;                  $fCaseSensitive - Specifies whether to treat the string as case sensitive when computing the hash value, valid values:
;                  |TRUE  - The lowercase and uppercase string hash to the different value. (Default)
;                  |FALSE - The lowercase and uppercase string hash to the same value.
;                  $iLength        - The length of the hash data, in bytes. It should be no larger than 256, otherwise, the function fails.
; Return values..: Success         - The hash data in binary form.
;                  Failure         - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_HashString($sString, $fCaseSensitive = 1, $iLength = 32)

	Local $tString, $Hash, $Length = StringLen($sString)

	If (Not $Length) Or ($iLength > 256) Then
		Return SetError(1, 0, 0)
	EndIf
	$tString = DllStructCreate('wchar[' & ($Length + 1) & ']')
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	If Not $fCaseSensitive Then
		$sString = StringLower($sString)
	EndIf
	DllStructSetData($tString, 1, $sString)
	$Hash = _WinAPI_HashData(DllStructGetPtr($tString), 2 * $Length, $iLength)
	If @error Then
		Return SetError(1, @extended, 0)
	EndIf
    Return $Hash
EndFunc   ;==>_WinAPI_HashString

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_Hex64
; Description....: Converts an integer value into a string of its hexadecimal representation.
; Syntax.........: _WinAPI_Hex64 ( $iValue [, $iLength] )
; Parameters.....: $iValue  - The expression to convert.
;                  $iLength - The number of characters to be returned (up to 16) for integer. Characters are truncated from the
;                             left-hand side if length is too small.
; Return values..: Success  - 1.
;                  Failure  - Empty string and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_Hex64($iValue, $iLength = 16)

	If (Not IsNumber($iValue)) Or ($iLength < 1) Or ($iLength > 16) Then
		Return SetError(1, 0, '')
	EndIf

	Local $tInt64 = DllStructCreate('int64')
	Local $tDWord = DllStructCreate('dword;dword', DllStructGetPtr($tInt64))

	DllStructSetData($tInt64, 1, $iValue)
	If @error Then
		Return SetError(1, 0, '')
	EndIf
	Return StringRight(Hex(DllStructGetData($tDWord, 2)) & Hex(DllStructGetData($tDWord, 1)), $iLength)
EndFunc   ;==>_WinAPI_Hex64

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_HiByte
; Description....: Returns the high BYTE of a 16-bit (2 bytes) value.
; Syntax.........: _WinAPI_HiByte ( $iValue )
; Parameters.....: $iValue - 16-bit value.
; Return values..: High BYTE value.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_HiByte($iValue)
	Return BitAND(BitShift($iValue, 8), 0xFF)
EndFunc   ;==>_WinAPI_HiByte

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_HideCaret
; Description....: Removes the caret from the screen.
; Syntax.........: _WinAPI_HideCaret ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window that owns the caret. If this parameter is 0, _WinAPI_HideCaret() searches the
;                            current task for the window that owns the caret.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: _WinAPI_HideCaret() hides the caret only if the specified window owns the caret. If the specified window does
;                  not own the caret, _WinAPI_HideCaret() does nothing and returns 0.
;
;                  Hiding is cumulative. If your application calls _WinAPI_HideCaret() five times in a row, it must also call
;                  _WinAPI_ShowCaret() five times before the caret is displayed.
; Related........:
; Link...........: @@MsdnLink@@ HideCaret
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_HideCaret($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'HideCaret', 'hwnd', $hWnd)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_HideCaret

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_HiDWord
; Description....: Returns the high DWORD of a 64-bit (8 bytes) value.
; Syntax.........: _WinAPI_HiDWord ( $iValue )
; Parameters.....: $iValue - 64-bit value.
; Return values..: High DWORD value.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_HiDWord($iValue)

	Local $tInt64 = DllStructCreate('int64')
	Local $tQWord = DllStructCreate('dword;dword', DllStructGetPtr($tInt64))

	DllStructSetData($tInt64, 1, $iValue)

	Return DllStructGetData($tQWord, 2)
EndFunc   ;==>_WinAPI_HiDWord

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_InflateRect
; Description....: Increases or decreases the width and height of the specified rectangle.
; Syntax.........: _WinAPI_InflateRect ( ByRef $tRECT, $DX, $DY )
; Parameters.....: $tRECT  - $tagRECT structure that increases or decreases in size.
;                  $DX     - The amount to increase or decrease (negative value) the rectangle width.
;                  $DY     - The amount to increase or decrease (negative value) the rectangle height.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ InflateRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_InflateRect(ByRef $tRECT, $DX, $DY)

	Local $Ret = DllCall('user32.dll', 'int', 'InflateRect', 'ptr', DllStructGetPtr($tRECT), 'int', $DX, 'int', $DY)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_InflateRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IntersectClipRect
; Description....: Creates a new clipping region from the intersection of the current clipping region and the specified rectangle.
; Syntax.........: _WinAPI_IntersectClipRect ( $hDC, $tRECT )
; Parameters.....: $hDC    - Handle to the device context.
;                  $tRECT  - $tagRECT structure that contains the logical coordinates of the specified rectangle.
; Return values..: Success - The value that specifies the new clipping region's complexity; it can be one of the following values.
;
;                            $COMPLEXREGION
;                            $NULLREGION
;                            $SIMPLEREGION
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IntersectClipRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IntersectClipRect($hDC, $tRECT)

	Local $Ret = DllCall('gdi32.dll', 'int', 'IntersectClipRect', 'hwnd', $hDC, 'int', DllStructGetData($tRECT, 1), 'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IntersectClipRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IntersectRect
; Description....: Creates the intersection of two rectangles.
; Syntax.........: _WinAPI_IntersectRect ( $tRECT1, $tRECT2 )
; Parameters.....: $tRECT1 - $tagRECT structure that contains the first source rectangle.
;                  $tRECT2 - $tagRECT structure that contains the second source rectangle.
; Return values..: Success - $tagRECT structure that contains the intersection of the $tRECT1 and $tRECT2 rectangles.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: If the source rectangles do not intersect, an empty rectangle (in which all coordinates are set to zero) is
;                  placed into the destination rectangle.
; Related........:
; Link...........: @@MsdnLink@@ IntersectRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IntersectRect($tRECT1, $tRECT2)

	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'int', 'IntersectRect', 'ptr', DllStructGetPtr($tRECT), 'ptr', DllStructGetPtr($tRECT1), 'ptr', DllStructGetPtr($tRECT2))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $tRECT
EndFunc   ;==>_WinAPI_IntersectRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IntToDWord
; Description....: Converts a value of type INT to a value of type DWORD.
; Syntax.........: _WinAPI_IntToDWord ( $iValue )
; Parameters.....: $iValue - The value to be converted.
; Return values..: The converted (DWORD) value.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IntToDWord($iValue)

	Local $tData = DllStructCreate('dword')

	DllStructSetData($tData, 1, $iValue)

	Return DllStructGetData($tData, 1)
EndFunc   ;==>_WinAPI_IntToDWord

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_InvalidateRect
; Description....: Adds a rectangle to the specified window's update region.
; Syntax.........: _WinAPI_InvalidateRect ( $hWnd [, $tRECT [, $fErase]] )
; Parameters.....: $hWnd   - Handle to the window whose update region has changed. If this parameter is 0, the system invalidates
;                            and redraws all windows, and sends the WM_ERASEBKGND and WM_NCPAINT messages to the window procedure
;                            before the function returns.
;                  $tRECT  - $tagRECT structure that contains the client coordinates of the rectangle to be added to the update
;                            region. If this parameter is 0, the entire client area is added to the update region.
;                  $fErase - Specifies whether the background within the update region is to be erased when the
;                            update region is processed, valid values:
;                  |TRUE   - The background is erased. (Default)
;                  |FALSE  - The background remains unchanged.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ InvalidateRect
; Example........: Yes
; ===============================================================================================================================

#cs

Func _WinAPI_InvalidateRect($hWnd, $tRECT = 0, $fErase = 1)

	Local $Ret = DllCall('user32.dll', 'int', 'InvalidateRect', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tRECT), 'int', $fErase)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_InvalidateRect

#ce

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_InvalidateRgn
; Description....: Adds a region to the specified window's update region.
; Syntax.........: _WinAPI_InvalidateRgn ( $hWnd [, $hRgn [, $fErase]] )
; Parameters.....: $hWnd   - Handle to the window with an update region that is to be modified.
;                  $hRgn   - Handle to the region to be added to the update region. The region is assumed to have client coordinates.
;                            If this parameter is 0, the entire client area is added to the update region.
;                  $fErase - Specifies whether the background within the update region is to be erased when the
;                            update region is processed, valid values:
;                  |TRUE   - The background is erased. (Default)
;                  |FALSE  - The background remains unchanged.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ InvalidateRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_InvalidateRgn($hWnd, $hRgn = 0, $fErase = 1)

	Local $Ret = DllCall('user32.dll', 'int', 'InvalidateRgn', 'hwnd', $hWnd, 'ptr', $hRgn, 'int', $fErase)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_InvalidateRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_InvertANDBitmap
; Description....: Inverts the specified AND bitmask bitmap by performing a logical NOT operation.
; Syntax.........: _WinAPI_InvertANDBitmap ( $hBitmap [, $fDelete] )
; Parameters.....: $hBitmap - Handle to the source bitmap that must be inverted.
;                  $fDelete - Specifies whether to delete the source bitmap after the function is successful, valid values:
;                  |TRUE    - The bitmap will be destroyed when the function succeeds.
;                  |FALSE   - Do not delete, you must destroy a bitmap when it no longer needed. (Default)
; Return values..: Success  - Handle to the inverted bitmap.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_InvertANDBitmap() creates a 1 bits-per-pixel inverted bitmask DIB from the 1 bits-per-pixel AND bitmask bitmap.
;                  If the source bitmap is not a 1 bits-per-pixel bitmap, the function fails.
;
;                  When you are finished using the bitmap, destroy it using the _WinAPI_DeleteObject() function.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_InvertANDBitmap($hBitmap, $fDelete = 0)

	Local $tBITMAP, $hSrcDC, $hSrcSv, $hDstDC, $hDstSv, $hResult

	$tBITMAP = DllStructCreate($tagBITMAP)
	If (Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tBITMAP), DllStructGetPtr($tBITMAP))) Or (DllStructGetData($tBITMAP, 'bmBitsPixel') <> 1) Then
		Return SetError(1, 0, 0)
	EndIf
	$hResult = _WinAPI_CreateDIB(DllStructGetData($tBITMAP, 'bmWidth'), DllStructGetData($tBITMAP, 'bmHeight'), 1)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$hSrcDC = _WinAPI_CreateCompatibleDC(0)
	$hSrcSv = _WinAPI_SelectObject($hSrcDC, $hBitmap)
	$hDstDC = _WinAPI_CreateCompatibleDC(0)
	$hDstSv = _WinAPI_SelectObject($hDstDC, $hResult)
	_WinAPI_BitBlt($hDstDC, 0, 0, DllStructGetData($tBITMAP, 'bmWidth'), DllStructGetData($tBITMAP, 'bmHeight'), $hSrcDC, 0, 0, 0x00330008)
	_WinAPI_SelectObject($hSrcDC, $hSrcSv)
	_WinAPI_DeleteDC($hSrcDC)
	_WinAPI_SelectObject($hDstDC, $hDstSv)
	_WinAPI_DeleteDC($hDstDC)
	If $fDelete Then
		_WinAPI_DeleteObject($hBitmap)
	EndIf
	Return $hResult
EndFunc   ;==>_WinAPI_InvertANDBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_InvertColor
; Description....: Inverts (negative) the specified color.
; Syntax.........: _WinAPI_InvertColor ( $iColor )
; Parameters.....: $iColor - The color to be inverted. This color can be specified in RGB or BGR format.
; Return values..: The inverted color.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_InvertColor($iColor)
	Return 0xFFFFFF - BitAND($iColor, 0xFFFFFF)
EndFunc   ;==>_WinAPI_InvertColor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_InvertRect
; Description....: Inverts a rectangle in a window by performing a logical NOT operation on the color values for each pixel.
; Syntax.........: _WinAPI_InvertRect ( $hDC, $tRECT )
; Parameters.....: $hDC    - Handle to the device context.
;                  $tRECT  - $tagRECT structure that contains the logical coordinates of the rectangle to be inverted.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: On monochrome screens, the _WinAPI_InvertRect() makes white pixels black and black pixels white. On color screens,
;                  the inversion depends on how colors are generated for the screen. Calling _WinAPI_InvertRect() twice for the same
;                  rectangle restores the display to its previous colors.
; Related........:
; Link...........: @@MsdnLink@@ InvertRect
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_InvertRect($hDC, $tRECT)

	Local $Ret = DllCall('user32.dll', 'int', 'InvertRect', 'hwnd', $hDC, 'ptr', DllStructGetPtr($tRECT))

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_InvertRect

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_InvertRgn
; Description....: Inverts the colors in the specified region.
; Syntax.........: _WinAPI_InvertRgn ( $hDC, $hRgn )
; Parameters.....: $hDC    - Handle to the device context.
;                  $hRgn   - Handle to the region for which colors are inverted. The region's coordinates are
;                            presumed to be logical coordinates.
; Return values..: Success - 1.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: On monochrome screens, the _WinAPI_InvertRgn() function makes white pixels black and black pixels white. On color
;                  screens, this inversion is dependent on the type of technology used to generate the colors for the screen.
; Related........:
; Link...........: @@MsdnLink@@ InvertRgn
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_InvertRgn($hDC, $hRgn)

	Local $Ret = DllCall('gdi32.dll', 'int', 'InvertRgn', 'hwnd', $hDC, 'ptr', $hRgn)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_InvertRgn

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IOCTL
; Description....: Create a unique system I/O control code (IOCTL).
; Syntax.........: _WinAPI_IOCTL ( $iDeviceType, $iFunction, $iMethod, $iAccess )
; Parameters.....: $iDeviceType - The type of device.
;                  $iFunction   - The action within the device category.
;                  $iMethod     - The method codes for how buffers are passed for I/O and file system controls.
;                  $iAccess     - The access check value for any access.
; Return values..: The IOCTL (DWORD) value.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ CTL_CODE
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IOCTL($iDeviceType, $iFunction, $iMethod, $iAccess)
	Return BitOR(BitShift($iDeviceType, -16), BitShift($iAccess, -14), BitShift($iFunction, -2), $iMethod)
EndFunc   ;==>_WinAPI_IOCTL

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsAlphaBitmap
; Description....: Determines whether the specified bitmap has an alpha channel.
; Syntax.........: _WinAPI_IsAlphaBitmap ( $hBitmap )
; Parameters.....: $hBitmap - Handle to the bitmap to test. This bitmap must be a 32 bits-per-pixel.
; Return values..: Success  - 1 - The specified bitmap has an alpha channel.
;                             0 - Otherwise.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function only works with 32 bits-per-pixel uncompressed bitmaps. If the source bitmap is non 32 bits-per-pixel
;                  bitmap, or is a compressed bitmap, the _WinAPI_IsAlphaBitmap() always returns 0.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsAlphaBitmap($hBitmap)

	Local $tDIB, $Ret, $Error

	$hBitmap = _WinAPI_CopyBitmap($hBitmap)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Do
		$Error = 1
		$tDIB = DllStructCreate($tagDIBSECTION)
		If (Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tDIB), DllStructGetPtr($tDIB))) Or (DllStructGetData($tDIB, 'bmBitsPixel') <> 32) Or (DllStructGetData($tDIB, 'biCompression')) Then
			ExitLoop
		EndIf
		$Ret = DllCall('user32.dll', 'int', 'CallWindowProc', 'ptr', __AlphaProc(), 'ptr', 0, 'uint', 0, 'ptr', DllStructGetPtr($tDIB), 'ptr', 0)
		If (@error) Or ($Ret[0] = -1) Then
			ExitLoop
		EndIf
		$Error = 0
	Until 1
	_WinAPI_DeleteObject($hBitmap)
	If $Error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsAlphaBitmap

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsBadCodePtr
; Description....: Determines whether the calling process has read access to the memory at the specified address.
; Syntax.........: _WinAPI_IsBadCodePtr ( $pAddress )
; Parameters.....: $pAddress - A pointer to a memory address.
; Return values..: Success   - 1 - The calling process does not have read access to the specified memory.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsBadCodePtr
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsBadCodePtr($pAddress)

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsBadCodePtr', 'ptr', $pAddress)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>IsBadCodePtr

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsBadReadPtr
; Description....: Verifies that the calling process has read access to the specified range of memory.
; Syntax.........: _WinAPI_IsBadReadPtr ( $pAddress, $iLength )
; Parameters.....: $pAddress - A pointer to the first byte of the memory block.
;                  $iLength  - The size of the memory block, in bytes.
; Return values..: Success   - 1 - The calling process does not have read access to all bytes in the specified memory range.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsBadReadPtr
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsBadReadPtr($pAddress, $iLength)

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsBadReadPtr', 'ptr', $pAddress, 'uint_ptr', $iLength)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsBadReadPtr

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsBadStringPtr
; Description....: Verifies that the calling process has read access to the specified range of memory.
; Syntax.........: _WinAPI_IsBadStringPtr ( $pAddress, $iLength )
; Parameters.....: $pAddress - A pointer to a null-terminated string, either Unicode or ASCII.
;                  $iLength  - The maximum size of the string, in TCHARs.
; Return values..: Success   - 1 - The calling process does not have read access to all characters up to the string's terminating null
;                                  character or up to the number of specified characters.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function checks for read access in all characters up to the string's terminating null character or up to the
;                  number of characters specified by this parameter, whichever is smaller.
; Related........:
; Link...........: @@MsdnLink@@ IsBadStringPtr
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsBadStringPtr($pAddress, $iLength)

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsBadStringPtr', 'ptr', $pAddress, 'uint_ptr', $iLength)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsBadStringPtr

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsBadWritePtr
; Description....: Verifies that the calling process has write access to the specified range of memory.
; Syntax.........: _WinAPI_IsBadWritePtr ( $pAddress, $iLength )
; Parameters.....: $pAddress - A pointer to the first byte of the memory block.
;                  $iLength  - The size of the memory block, in bytes.
; Return values..: Success   - 1 - The calling process does not have write access to all bytes in the specified memory range.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsBadWritePtr
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsBadWritePtr($pAddress, $iLength)

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsBadWritePtr', 'ptr', $pAddress, 'uint_ptr', $iLength)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsBadWritePtr

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsChild
; Description....: Tests whether a window is a child window of a specified parent window.
; Syntax.........: _WinAPI_IsChild ( $hWnd, $hWndParent )
; Parameters.....: $hWnd       - Handle to the window to be tested.
;                  $hWndParent - Handle to the parent window.
; Return values..: Success     - 1 - The window is a child window of the specified parent window.
;                                0 - Otherwise.
;                  Failure     - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsChild
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsChild($hWnd, $hWndParent)

	Local $Ret = DllCall('user32.dll', 'int', 'IsChild', 'hwnd', $hWndParent, 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsChild

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsDoorOpen
; Description....: Checks if a CD (DVD) tray is open.
; Syntax.........: _WinAPI_IsDoorOpen ( $sDrive )
; Parameters.....: $sDrive - The drive letter of the CD tray to check, in the format D:, E:, etc.
; Return values..: Success - 1 - CD (DVD) tray is open.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: G.Sandler (CreatoR)
; Modified.......: Yashied
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IOCTL_SCSI_PASS_THROUGH
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsDoorOpen($sDrive)

	Local $hFile = _WinAPI_CreateFileEx('\\.\' & $sDrive, 3, 0xC0000000, 0x03)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $tSPT = DllStructCreate('ushort Length;byte ScsiStatus;byte PathId;byte TargetId;byte Lun;byte CdbLength;byte SenseInfoLength;byte DataIn;byte Alignment[3];ulong DataTransferLength;ulong TimeOutValue;ulong_ptr DataBufferOffset;ulong SenseInfoOffset;byte Cdb[16]' & __Iif(@AutoItX64, ';byte[4]', '') & ';byte Hdr[8]')
	Local $tCDB = DllStructCreate('byte;byte;byte[6];byte[2];byte;byte;byte[4]', DllStructGetPtr($tSPT, 'Cdb'))
	Local $tHDR = DllStructCreate('byte;byte;byte[3];byte;byte[2]', DllStructGetPtr($tSPT, 'Hdr'))
	Local $Size = DllStructGetPtr($tSPT, 'Hdr') - DllStructGetPtr($tSPT)

	DllStructSetData($tSPT, 'Length', $Size)
	DllStructSetData($tSPT, 'ScsiStatus', 0)
	DllStructSetData($tSPT, 'PathId', 0)
	DllStructSetData($tSPT, 'TargetId', 0)
	DllStructSetData($tSPT, 'Lun', 0)
	DllStructSetData($tSPT, 'CdbLength', 12)
	DllStructSetData($tSPT, 'SenseInfoLength', 0)
	DllStructSetData($tSPT, 'DataIn', 1)
	DllStructSetData($tSPT, 'DataTransferLength', 8)
	DllStructSetData($tSPT, 'TimeOutValue', 86400)
	DllStructSetData($tSPT, 'DataBufferOffset', $Size)
	DllStructSetData($tSPT, 'SenseInfoOffset', 0)

	DllStructSetData($tCDB, 1, 0xBD)
	DllStructSetData($tCDB, 2, 0)
	DllStructSetData($tCDB, 4, 0, 1)
	DllStructSetData($tCDB, 4, 8, 2)
	DllStructSetData($tCDB, 5, 0)
	DllStructSetData($tCDB, 6, 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x0004D004, 'ptr', DllStructGetPtr($tSPT), 'dword', $Size, 'ptr', DllStructGetPtr($tSPT), 'dword', DllStructGetSize($tSPT), 'dword*', 0, 'ptr', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf
	Return Number(BitAND(DllStructGetData($tHDR, 2), 0x10) = 0x10)
EndFunc   ;==>_WinAPI_IsDoorOpen

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsElevated
; Description....: Determines whether the current process is elevated.
; Syntax.........: _WinAPI_IsElevated ( )
; Parameters.....: None
; Return values..: Success - 1 - The current process is elevated.
;                            0 - Otherwise.
;
;                            Additionally, the function always sets the @extended flag to one of the following values (any other value
;                            indicates an unexpected error).
;
;                            0 - Indicates that either the User Account Control (UAC) is disabled, or the process is started by a standard
;                                user (not a member of the Administrators group).
;
;                            The following two values can be returned only if both the UAC is enabled and the user is a member
;                            of the Administrators group (that is, the user has a "split" token).
;
;                            1 - Indicates that the process is running elevated.
;                            2 - Indicates that the process is not running elevated.
;
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsElevated()

	Local $hToken, $Val[2], $Ret, $Error = 1

	$hToken = _WinAPI_OpenProcessToken(0x0008)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Do
		$Ret = DllCall('advapi32.dll', 'int', 'GetTokenInformation', 'ptr', $hToken, 'uint', 20, 'uint*', 0, 'dword', 4, 'dword*', 0)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Val[0] = $Ret[3]
		$Ret = DllCall('advapi32.dll', 'int', 'GetTokenInformation', 'ptr', $hToken, 'uint', 18, 'uint*', 0, 'dword', 4, 'dword*', 0)
		If (@error) Or (Not $Ret[0]) Then
			ExitLoop
		EndIf
		$Val[1] = $Ret[3]
		$Error = 0
	Until 1
	_WinAPI_CloseHandle($hToken)
	If $Error Then
		Return SetError(2, 0, 0)
	EndIf
	Return SetError(0, $Val[1] - 1, $Val[0])
EndFunc   ;==>_WinAPI_IsElevated

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsHungAppWindow
; Description....: Determines whether the specified application is not responding.
; Syntax.........: _WinAPI_IsHungAppWindow ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window.
; Return values..: Success - 1 - The window stops responding.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: An application is considered to be not responding if it is not waiting for input, is not in startup processing,
;                  and did not responded to messages within the internal timeout period of 5 seconds.
; Related........:
; Link...........: @@MsdnLink@@ IsHungAppWindow
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsHungAppWindow($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'IsHungAppWindow', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsHungAppWindow

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsIconic
; Description....: Determines whether the specified window is minimized (iconic).
; Syntax.........: _WinAPI_IsIconic ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to test.
; Return values..: Success - 1 - The window is iconic.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsIconic
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsIconic($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'IsIconic', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsIconic

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsInternetConnected
; Description....: Determines whether the current user is connected to the Internet.
; Syntax.........: _WinAPI_IsInternetConnected ( )
; Parameters.....: None
; Return values..: Success - 1 - The user is connected to the Internet.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ IsInternetConnected
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsInternetConnected()

	If Not __DLL('connect.dll') Then
		Return SetError(3, 0, 0)
	EndIf

	Local $Ret = DllCall('connect.dll', 'uint', 'IsInternetConnected')

	If @error Then
		Return SetError(1, 0, 0)
	Else
		Switch $Ret[0]
			Case 0, 1 ; S_OK, S_FALSE

			Case Else
				Return SetError(1, $Ret[0], 0)
		EndSwitch
	EndIf
	Return Number(Not $Ret[0])
EndFunc   ;==>_WinAPI_IsInternetConnected

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsLoadKBLayout
; Description....: Determines whether the specified input locale loaded into the system.
; Syntax.........: _WinAPI_IsLoadKBLayout ( $iLanguage )
; Parameters.....: $iLanguage - The input locale identifier to check.
; Return values..: Success    - 1 - Input locale is loaded.
;                               0 - Otherwise.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsLoadKBLayout($iLanguage)

	Local $Layout = _WinAPI_GetKeyboardLayoutList()

	If Not IsArray($Layout) Then
		Return SetError(1, 0, 0)
	EndIf
	For $i = 1 To $Layout[0]
		If $Layout[$i] = $iLanguage Then
			Return 1
		EndIf
	Next
	Return 0
EndFunc   ;==>_WinAPI_IsLoadKBLayout

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsMemory
; Description....: Determines whether the specified pointer points to the memory block in the internal library heap.
; Syntax.........: _WinAPI_IsMemory ( $pMemory )
; Parameters.....: $pMemory - A pointer to the memory block that to be tested.
; Return values..: Success  - 1 - The specified pointer is a valid memory pointer.
;                             0 - Otherwise.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_IsMemory() function accepts only the pointers returned by some _WinAPI_* functions (see description),
;                  otherwise always returns zero.
; Related........:
; Link...........: None
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsMemory($pMemory)

	Local $Result = __HeapValidate($pMemory)

	If @error Then
		Return SetError(@error, 0, 0)
	EndIf
	Return $Result
EndFunc   ;==>_WinAPI_IsMemory

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsNetworkAlive
; Description....: Determines whether or not a local system is connected to a network, and identifies the type of network connection.
; Syntax.........: _WinAPI_IsNetworkAlive ( )
; Parameters.....: None
; Return values..: Success - The type of network connection ($NETWORK_ALIVE_*) if a local system is connected to a network.
;                            0 - Is no connection.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: Always check @error flag before checking the return value of this function. If the @error is not 0,
;                  the function has failed and the following values do not apply.
;
;                  This function is only available for TCP/IP connections.
; Related........:
; Link...........: @@MsdnLink@@ IsNetworkAlive
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsNetworkAlive()

	If Not __DLL('sensapi.dll') Then
		Return SetError(3, 0, 0)
	EndIf

	Local $Ret = DllCall('sensapi.dll', 'int', 'IsNetworkAlive', 'int*', 0)

	If (@error) Or (Not $Ret[0]) Or (_WinAPI_GetLastError()) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[1]
EndFunc   ;==>_WinAPI_IsNetworkAlive

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsProcessInJob
; Description....: Determines whether the process is running in the specified job.
; Syntax.........: _WinAPI_IsProcessInJob ( $hProcess [, $hJob] )
; Parameters.....: $hProcess - Handle to the process to be tested. The handle must have the $PROCESS_QUERY_INFORMATION or
;                              $PROCESS_QUERY_LIMITED_INFORMATION access right.
;                  $hJob     - Handle to the job. If this parameter is 0, the function tests if the process is running under any job.
; Return values..: Success   - 1 - The process is running in the job.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: An application cannot obtain a handle to the job object in which it is running unless it has the name of the job
;                  object. However, an application can call the _WinAPI_QueryInformationJobObject() function with 0 to obtain
;                  information about the job object.
; Related........:
; Link...........: @@MsdnLink@@ IsProcessInJob
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsProcessInJob($hProcess, $hJob = 0)

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsProcessInJob', 'ptr', $hProcess, 'ptr', $hJob, 'int*', 0)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[3]
EndFunc   ;==>_WinAPI_IsProcessInJob

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsProcessorFeaturePresent
; Description....: Determines whether the specified processor feature is supported by the current computer.
; Syntax.........: _WinAPI_IsProcessorFeaturePresent ( $iFeature )
; Parameters.....: $iFeature - The processor feature to be tested. This parameter can be one of the $PF_* constants.
; Return values..: Success   - 1 - The feature is supported.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsProcessorFeaturePresent
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsProcessorFeaturePresent($iFeature)

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsProcessorFeaturePresent', 'dword', $iFeature)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsProcessorFeaturePresent

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsRectEmpty
; Description....: Determines whether the specified rectangle is empty.
; Syntax.........: _WinAPI_IsRectEmpty ( $tRECT )
; Parameters.....: $tRECT  - $tagRECT structure that contains the logical coordinates of the rectangle.
; Return values..: Success - 1 - The rectangle is empty.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: An empty rectangle is one that has no area; that is, the coordinate of the right side is less than or equal
;                  to the coordinate of the left side, or the coordinate of the bottom side is less than or equal to the
;                  coordinate of the top side.
; Related........:
; Link...........: @@MsdnLink@@ IsRectEmpty
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsRectEmpty($tRECT)

	Local $Ret = DllCall('user32.dll', 'int', 'IsRectEmpty', 'ptr', DllStructGetPtr($tRECT))

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsRectEmpty

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsThemeActive
; Description....: Tests if a visual style for the current application is active.
; Syntax.........: _WinAPI_IsThemeActive ( )
; Parameters.....: None
; Return values..: Success - 1 - The visual style is enabled.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsThemeActive
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsThemeActive()

	Local $Ret = DllCall('uxtheme.dll', 'int', 'IsThemeActive')

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsThemeActive

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsThemeBackgroundPartiallyTransparent
; Description....: Retrieves whether the background specified by the visual style has transparent pieces or alpha-blended pieces.
; Syntax.........: _WinAPI_IsThemeBackgroundPartiallyTransparent ( $hTheme, $iPartId, $iStateId )
; Parameters.....: $hTheme   - Handle to a window's specified theme data.
;                  $iPartId  - The part.
;                  $iStateId - The state of the part.
; Return values..: Success   - 1 - The theme-specified background has transparent pieces or alpha-blended pieces.
;                              0 - Otherwise.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsThemeBackgroundPartiallyTransparent
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsThemeBackgroundPartiallyTransparent($hTheme, $iPartId, $iStateId)

	Local $Ret = DllCall('uxtheme.dll', 'int', 'IsThemeBackgroundPartiallyTransparent', 'ptr', $hTheme, 'int', $iPartId, 'int', $iStateId)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsThemeBackgroundPartiallyTransparent

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsThemePartDefined
; Description....: Retrieves whether a visual style has defined parameters for the specified part.
; Syntax.........: _WinAPI_IsThemePartDefined ( $hTheme, $iPartId )
; Parameters.....: $hTheme  - Handle to a window's specified theme data.
;                  $iPartId - The part.
; Return values..: Success  - 1 - The theme has defined parameters for the specified $iPartId.
;                             0 - Otherwise.
;                  Failure  - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsThemePartDefined
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsThemePartDefined($hTheme, $iPartId)

	Local $Ret = DllCall('uxtheme.dll', 'int', 'IsThemePartDefined', 'ptr', $hTheme, 'int', $iPartId, 'int', 0)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsThemePartDefined

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsValidLocale
; Description....: Determines if the specified locale is installed or supported on the operating system.
; Syntax.........: _WinAPI_IsValidLocale ( $LCID [, $iFlag] )
; Parameters.....: $LCID   - The locale identifier (LCID) that specifies the locale or one of the following predefined values.
;
;                            $LOCALE_INVARIANT
;                            $LOCALE_SYSTEM_DEFAULT
;                            $LOCALE_USER_DEFAULT
;
;                            Windows Vista or later
;
;                            $LOCALE_CUSTOM_DEFAULT
;                            $LOCALE_CUSTOM_UI_DEFAULT
;                            $LOCALE_CUSTOM_UNSPECIFIED
;
;                  $iFlag  - Flag specifying the validity test to apply to the locale identifier. This parameter can have one
;                            of the following values.
;
;                            $LCID_INSTALLED
;                            $LCID_SUPPORTED
;
; Return values..: Success - 1 - The locale identifier passes the specified validity test.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsValidLocale
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsValidLocale($LCID, $iFlag)

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsValidLocale', 'ulong', $LCID, 'dword', $iFlag)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsValidLocale

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsWindowEnabled
; Description....: Determines whether the specified window is enabled for mouse and keyboard input.
; Syntax.........: _WinAPI_IsWindowEnabled ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to test.
; Return values..: Success - 1 - The window is enabled.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: A child window receives input only if it is both enabled and visible.
; Related........:
; Link...........: @@MsdnLink@@ IsWindowEnabled
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsWindowEnabled($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'IsWindowEnabled', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsWindowEnabled

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsWindowUnicode
; Description....: Determines whether the specified window is a native Unicode window.
; Syntax.........: _WinAPI_IsWindowUnicode ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to test.
; Return values..: Success - 1 - The window is a native Unicode window.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsWindowUnicode
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsWindowUnicode($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'IsWindowUnicode', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsWindowUnicode

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsWow64Process
; Description....: Determines whether the specified process is running under WOW64.
; Syntax.........: _WinAPI_IsWow64Process ( [$PID] )
; Parameters.....: $PID    - The PID of the process. Default (0) is the current process.
; Return values..: Success - 1 - The process is running under WOW64.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsWow64Process
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsWow64Process($PID = 0)

	If Not $PID Then
		$PID = @AutoItPID
	EndIf

	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'dword', __Iif($__WINVER < 0x0600, 0x00000400, 0x00001000), 'int', 0, 'dword', $PID)

	If (@error) Or (Not $hProcess[0]) Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'IsWow64Process', 'ptr', $hProcess[0], 'int*', 0)

	If (@error) Or (Not $Ret[0]) Then
		$Ret = 0
	EndIf
	_WinAPI_CloseHandle($hProcess[0])
	If Not IsArray($Ret) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[2]
EndFunc   ;==>_WinAPI_IsWow64Process

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsWritable
; Description....: Determines whether a disk is writable.
; Syntax.........: _WinAPI_IsWritable ( $sDrive )
; Parameters.....: $sDrive - The drive letter of the disk to check, in the format D:, E:, etc.
; Return values..: Success - 1 - The disk is writable.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IOCTL_DISK_IS_WRITABLE
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsWritable($sDrive)

	Local $hFile = _WinAPI_CreateFileEx('\\.\' & $sDrive, 3, 0, 0x03)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	Local $Ret = DllCall('kernel32.dll', 'int', 'DeviceIoControl', 'ptr', $hFile, 'dword', 0x00070024, 'ptr', 0, 'dword', 0, 'ptr', 0, 'dword', 0, 'dword*', 0, 'ptr', 0)

	If @error Then
		$Ret = 0
	Else
		If Not $Ret[0] Then
			Switch _WinAPI_GetLastError()
				Case 19 ; ERROR_WRITE_PROTECT

				Case Else
					$Ret = 0
			EndSwitch
		EndIf
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not IsArray($Ret) Then
		Return SetError(2, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsWritable

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_IsZoomed
; Description....: Determines whether a window is maximized.
; Syntax.........: _WinAPI_IsZoomed ( $hWnd )
; Parameters.....: $hWnd   - Handle to the window to test.
; Return values..: Success - 1 - The window is zoomed.
;                            0 - Otherwise.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ IsZoomed
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_IsZoomed($hWnd)

	Local $Ret = DllCall('user32.dll', 'int', 'IsZoomed', 'hwnd', $hWnd)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsZoomed

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_Keybd_Event
; Description....: Synthesizes a keystroke.
; Syntax.........: _WinAPI_Keybd_Event ( $vKey, $iFlags [, $iScanCode [, $iExtraInfo]] )
; Parameters.....: $vKey       - The virtual-key code ($VK_*). The code must be a value in the range 1 to 254.
;
;                                0x01 - Left mouse button
;                                0x02 - Right mouse button
;                                0x03 - Control-break processing
;                                0x04 - Middle mouse button (three-button mouse)
;                                0x05 - X1 mouse button
;                                0x06 - X2 mouse button
;
;                                0x08 - BACKSPACE key
;                                0x09 - TAB key
;
;                                0x0C - CLEAR key
;                                0x0D - ENTER key
;
;                                0x10 - SHIFT key
;                                0x11 - CTRL key
;                                0x12 - ALT key
;                                0x13 - PAUSE key
;                                0x14 - CAPS LOCK key
;
;                                0x1B - ESC key
;
;                                0x20 - SPACEBAR key
;                                0x21 - PAGE UP key
;                                0x22 - PAGE DOWN key
;                                0x23 - END key
;                                0x24 - HOME key
;                                0x25 - LEFT ARROW key
;                                0x26 - UP ARROW key
;                                0x27 - RIGHT ARROW key
;                                0x28 - DOWN ARROW key
;                                0x29 - SELECT key
;                                0x2A - PRINT key
;                                0x2B - EXECUTE key
;                                0x2C - PRINT SCREEN key
;                                0x2D - INS key
;                                0x2E - DEL key
;                                0x2F - HELP key
;                                0x30 - 0x39 - (0 - 9) key
;
;                                0x41 - 0x5A - (A - Z) key
;                                0x5B - Left Windows key
;                                0x5C - Right Windows key
;                                0x5D - Applications key
;
;                                0x5F - Computer Sleep key
;                                0x60 - 0x69 - Numeric keypad (0 - 9) key
;                                0x6A - Multiply key
;                                0x6B - Add key
;                                0x6C - Separator key
;                                0x6D - Subtract key
;                                0x6E - Decimal key
;                                0x6F - Divide key
;                                0x70 - 0x87 - (F1 - F24) key
;
;                                0x90 - NUM LOCK key
;                                0x91 - SCROLL LOCK key
;
;                                0xA0 - Left SHIFT key
;                                0xA1 - Right SHIFT key
;                                0xA2 - Left CONTROL key
;                                0xA3 - Right CONTROL key
;                                0xA4 - Left MENU key
;                                0xA5 - Right MENU key
;                                0xA6 - Browser Back key
;                                0xA7 - Browser Forward key
;                                0xA8 - Browser Refresh key
;                                0xA9 - Browser Stop key
;                                0xAA - Browser Search key
;                                0xAB - Browser Favorites key
;                                0xAC - Browser Start and Home key
;                                0xAD - Volume Mute key
;                                0xAE - Volume Down key
;                                0xAF - Volume Up key
;                                0xB0 - Next Track key
;                                0xB1 - Previous Track key
;                                0xB2 - Stop Media key
;                                0xB3 - Play/Pause Media key
;                                0xB4 - Start Mail key
;                                0xB5 - Select Media key
;                                0xB6 - Start Application 1 key
;                                0xB7 - Start Application 2 key
;
;                                0xBA - ';:' key
;                                0xBB - '+' key
;                                0xBC - ',' key
;                                0xBD - '-' key
;                                0xBE - '.' key
;                                0xBF - '/?' key
;                                0xC0 - '`~' key
;
;                                0xDB - '[{' key
;                                0xDC - '\|' key
;                                0xDD - ']}' key
;                                0xDE - 'single-quote/double-quote' key
;
;                                0xE2 - Either the angle bracket key or the backslash key on the RT 102-key keyboard
;
;                                0xE7 - Used to pass Unicode characters as if they were keystrokes
;
;                                0xF6 - Attn key
;                                0xF7 - CrSel key
;                                0xF8 - ExSel key
;                                0xF9 - Erase EOF key
;                                0xFA - Play key
;                                0xFB - Zoom key
;
;                                0xFD - PA1 key
;                                0xFE - Clear key
;
;                  $iFlags     - This parameter can be one or more of the following values.
;
;                                $KEYEVENTF_EXTENDEDKEY
;                                $KEYEVENTF_KEYUP
;
;                  $iScanCode  - The hardware scan code for the key.
;                  $iExtraInfo - The additional value associated with the key stroke.
; Return values..: Success     - 1.
;                  Failure     - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ keybd_event
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_Keybd_Event($vKey, $iFlags, $iScanCode = 0, $iExtraInfo = 0)
	DllCall('user32.dll', 'int', 'keybd_event', 'int', $vKey, 'int', $iScanCode, 'int', $iFlags, 'ptr', $iExtraInfo)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_Keybd_Event

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_KillTimer
; Description....: Destroys the specified timer.
; Syntax.........: _WinAPI_KillTimer ( $hWnd, $iTimerID )
; Parameters.....: $hWnd     - Handle to the window associated with the specified timer. This value must be the same as the
;                              $hWnd value passed to the _WinAPI_SetTimer() function that created the timer.
;                  $iTimerID - The timer identifier which specifies the timer to be destroyed.
; Return values..: Success   - 1.
;                  Failure   - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function does not remove WM_TIMER messages already posted to the message queue.
; Related........:
; Link...........: @@MsdnLink@@ KillTimer
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_KillTimer($hWnd, $iTimerID)

	Local $Ret = DllCall('user32.dll', 'int', 'KillTimer', 'hwnd', $hWnd, 'uint_ptr', $iTimerID)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_KillTimer

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_LineDDA
; Description....: Determines which pixels should be highlighted for a line.
; Syntax.........: _WinAPI_LineDDA ( $X1, $Y1, $X2, $Y2, $pLineProc [, $pData] )
; Parameters.....: $X1        - Specifies the x-coordinate, in logical units, of the line's starting point.
;                  $Y1        - Specifies the y-coordinate, in logical units, of the line's starting point.
;                  $X2        - Specifies the x-coordinate, in logical units, of the line's ending point.
;                  $Y2        - Specifies the y-coordinate, in logical units, of the line's ending point.
;                  $pLineProc - Pointer to an application-defined callback function.
;                  $pData     - Pointer to the application-defined data.
; Return values..: Success    - 1.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: The _WinAPI_LineDDA() function passes the coordinates for each point along the line, except for the line's ending
;                  point, to the application-defined callback function. In addition to passing the coordinates of a point, this
;                  function passes any existing application-defined data.
; Related........:
; Link...........: @@MsdnLink@@ LineDDA
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_LineDDA($X1, $Y1, $X2, $Y2, $pLineProc, $pData = 0)

	Local $Ret = DllCall('gdi32.dll', 'int', 'LineDDA', 'int', $X1, 'int', $Y1, 'int', $X2, 'int', $Y2, 'ptr', $pLineProc, 'lparam', $pData)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_LineDDA

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_LoadCursor
; Description....: Loads the specified cursor resource from the executable (.EXE) file.
; Syntax.........: _WinAPI_LoadCursor ( $hInstance, $sName )
; Parameters.....: $hInstance - Handle to an instance of the module whose executable file contains the cursor to be loaded.
;                  $sName     - The name of the cursor resource or resource identifier to be loaded. To use one of the predefined
;                               cursors, the application must set the $hInstance parameter to 0 and the $sName parameter to one
;                               of the following values.
;
;                               $IDC_APPSTARTING
;                               $IDC_HAND
;                               $IDC_ARROW
;                               $IDC_CROSS
;                               $IDC_IBEAM
;                               $IDC_ICON
;                               $IDC_NO
;                               $IDC_SIZE
;                               $IDC_SIZEALL
;                               $IDC_SIZENESW
;                               $IDC_SIZENS
;                               $IDC_SIZENWSE
;                               $IDC_SIZEWE
;                               $IDC_UPARROW
;                               $IDC_WAIT
;
; Return values..: Success    - Handle to the newly loaded cursor.
;                  Failure    - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function loads the cursor resource only if it has not been loaded; otherwise, it retrieves the handle to
;                  the existing resource.
; Related........:
; Link...........: @@MsdnLink@@ LoadCursor
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_LoadCursor($hInstance, $sName)

	Local $TypeOfName = 'int'

	If IsString($sName) Then
		$TypeOfName = 'wstr'
	EndIf

	Local $Ret = DllCall('user32.dll', 'ptr', 'LoadCursorW', 'ptr', $hInstance, $TypeOfName, $sName)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_LoadCursor

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_LoadCursorFromFile
; Description....: Creates a cursor based on data contained in a file.
; Syntax.........: _WinAPI_LoadCursorFromFile ( $sFile )
; Parameters.....: $sFile  - The file data to be used to create the cursor. The data in the file must be in either .CUR or .ANI format.
; Return values..: Success - Handle to the new cursor.
;                  Failure - 0 and sets the @error flag to non-zero.
; Author.........: Yashied
; Modified.......:
; Remarks........: None
; Related........:
; Link...........: @@MsdnLink@@ LoadCursorFromFile
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_LoadCursorFromFile($sFile)

	Local $Ret = DllCall('user32.dll', 'ptr', 'LoadCursorFromFileW', 'wstr', $sFile)

	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_LoadCursorFromFile

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_LoadIconWithScaleDown
; Description....: Loads an icon and scales down a larger image instead of scaling up a smaller image.
; Syntax.........: _WinAPI_LoadIconWithScaleDown ( $hInstance, $sName, $iWidth, $iHeight )
; Parameters.....: $hInstance - Handle to the module of either a DLL or executable (.exe) file that contains the icon to be loaded.
;                  $sName     - The information about the icon to load. If $hInstance is not 0, $sName specifies the icon resource
;                               either by name or ordinal, otherwise, $sName specifies either the name of a standalone icon (.ico)
;                               file or the identifier of a predefined icon to load.
;
;                               $IDI_APPLICATION
;                               $IDI_ASTERISK
;                               $IDI_ERROR
;                               $IDI_EXCLAMATION
;                               $IDI_HAND
;                               $IDI_INFORMATION
;                               $IDI_QUESTION
;                               $IDI_SHIELD
;                               $IDI_WARNING
;                               $IDI_WINLOGO
;
;                  $iWidth    - The desired width, in pixels, of the icon.
;                  $iHeight   - The desired height, in pixels, of the icon.
; Return values..: Success    - The icon handle.
;                  Failure    - 0 and sets the @error flag to non-zero, @extended flag may contain the system error code.
; Author.........: Yashied
; Modified.......:
; Remarks........: This function requires Windows Vista or later.
; Related........:
; Link...........: @@MsdnLink@@ LoadIconWithScaleDown
; Example........: Yes
; ===============================================================================================================================

Func _WinAPI_LoadIconWithScaleDown($hInstance, $sName, $iWidth, $iHeight)

	Local $TypeOfName = 'int'

	If IsString($sName) Then
		$TypeOfName = 'wstr'
	EndIf

	Local $Ret = DllCall('comctl32.dll ', 'uint', 'LoadIconWithScaleDown', 'ptr', $hInstance, $TypeOfName, $sName, 'int', $iWidth, 'int', $iHeight, 'ptr*', 0)

	If @error Then
		Return SetError(1, 0, 0)
	Else
		If $Ret[0] Then
			Return SetError(1, $Ret[0], 0)
		EndIf
	EndIf
	Return $Ret[5]
EndFunc   ;==>_WinAPI_LoadIconWithScaleDown

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_LoadIndirectString
; Description....: Extracts the string from the specified resource when given an indirect string.
; Syntax