#include-once

Func _FileSearch($sPath, $sExt = '', $sPart = 0, $Depth = 0, $Array = 1)
	If StringCompare(StringRight($sPath, 1), '\') Then $sPath = $sPath & '\'
	Local $sFileList, $aFiles
	If StringInStr($sExt, '|') Then
		Local $sDelim = StringSplit($sExt, '|')
		For $i = 1 To $sDelim[0]
			__FileSearchAll($sFileList, $sPath, $sDelim[$i], $sPart, $Depth)
		Next
	Else
		__FileSearchAll($sFileList, $sPath, $sExt, $sPart, $Depth)
	EndIf
	$sFileList = StringStripWS(StringTrimRight($sFileList, 1), 3)
	If Not $sFileList Then Return SetError(1)
	$aFiles = StringSplit($sFileList, '|', $Array)
	Return $aFiles
EndFunc   ;==>_FileSearch

Func __FileSearchAll(ByRef $sFileList, $sPath, $sExt = '', $sPart = 0, $Depth = 0)
	Local $sFile, $FirstFile = FileFindFirstFile($sPath & '*')
	Local $getext
	If $FirstFile = -1 Then Return
	While 1
		$sFile = FileFindNextFile($FirstFile)
		If @error Then ExitLoop
		If @extended Then
			If $sPart = 3 Then $sFileList &= $sPath & $sFile & '|'
			If Not $Depth Then __FileSearchAll($sFileList, $sPath & $sFile & '\', $sExt, $sPart, $Depth)
		Else
			If $sExt <> '' And $sPart < 3 Then
				$getext = _GetExtNamePath($sPath & $sFile, $sPart)
				If Not StringCompare($getext, $sExt) Then $sFileList &= $sPath & $sFile & '|'
			ElseIf $sExt = '' And $sPart < 3 Then
				$sFileList &= $sPath & $sFile & '|'
			EndIf
		EndIf
	WEnd
	FileClose($FirstFile)
EndFunc   ;==>__FileSearchAll

Func _GetExtNamePath($sString, $sPart = 0)
	Local $RetString, $lastpoint
	Local $lastslash = StringInStr($sString, '\', 0, -1)
	Switch $sPart
		Case 0;  
			$RetString = StringTrimLeft($sString, $lastslash)
		Case 1; 
			Local $cutleft = StringTrimLeft($sString, $lastslash)
			$lastpoint = StringInStr($cutleft, '.', 0, -1)
			$RetString = StringLeft($cutleft, $lastpoint - 1)
		Case 2;
			Local $lastpoint = StringInStr($sString, '.', 0, -1)
			$RetString = StringTrimLeft($sString, $lastpoint)
	EndSwitch
	Return $RetString
EndFunc   ;==>_GetExtNamePath
