##icon=Axialis.ico
##upx=9
##lang=1049
##comments=  AutoIT
##legalcopyright=Joiner
##legaltrademarks=http://autoit-script.ru/ ( Joiner)
##originalfilename=WrapperAutoit3.exe
##companyname=http://autoit-script.ru/ (Joiner)
##productname=WrapperAutoit3
##internalname=WrapperAutoit3.exe
##filedescription=  AutoIT
##compile=rtm;v3.3.12.0
##bit=x86

#cs ---------------------------------------------------------------------------
	AutoIt Version: 3.3.12.0
	Author:         Joiner
	Script Function:Compiling, Resource update
	Forum Topic:    http://autoit-script.ru/index.php?topic=17953.0
#ce ----------------------------------------------------------------------------

#RequireAdmin
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <TabConstants.au3>
#include <WindowsConstants.au3>
#include <File.au3>
#include <WinAPIEx.au3>
#include <ComboConstants.au3>
#include <Date.au3>
#include <String.au3>
Opt("TrayMenuMode", 1)
Global $GetPathAuExe = _GetPathAuexe(), $AutoITPath = '', $FlagCompile = 0
Global $GetVerRTM = RegRead('HKEY_LOCAL_MACHINE\SOFTWARE\AutoIt v3\AutoIt', 'Version')
Global $GetVerBeta = RegRead('HKEY_LOCAL_MACHINE\SOFTWARE\AutoIt v3\AutoIt', 'betaVersion')
Global $INP_Fileversion = '0.0.0.0', $INP_Comment = '', $INP_Description = '', $INP_LegalCopyright = ''
Global $INP_ProductVersion = '0.0.0.0'
Global $INP_OriginalFileName = ''
Global $INP_Res_Language = 2057, $contry = ''
Global $INP_CompanyName = '', $INP_InternalName = '', $INP_LegalTradeMarks = '', $INP_ProductName = ''
Global $ResVer = @ScriptDir & "\temp.res", $stringparam = '', $inisetting = @ScriptDir & '\WrapperAutoit3.ini'
Global $RTM = 0, $BETA = 0, $PWA = @HomeDrive & '\WrapperAutoit3\WrapperAutoit3.exe'
Global $alllang[116][2] = [["Afrikaans", "1078"], ["Albanian", "1052"], ["Arabic (Algeria)", "5121"], ["Arabic (Bahrain)", "15361"], _
		["Arabic (Egypt)", "3073"], ["Arabic (Iraq)", "2049"], ["Arabic (Jordan)", "11265"], ["Arabic (Kuwait)", "13313"], ["Arabic (Lebanon)", "12289"], _
		["Arabic (Libya)", "4097"], ["Arabic (Morocco)", "6145"], ["Arabic (Oman)", "8193"], ["Arabic (Qatar)", "16385"], ["Arabic (Saudi Arabia)", "1025"], _
		["Arabic (Syria)", "10241"], ["Arabic (Tunisia)", "7169"], ["Arabic (U.A.E.)", "14337"], ["Arabic (Yemen)", "9217"], ["Basque", "1069"], _
		["Belarusian", "1059"], ["Bulgarian", "1026"], ["Catalan", "1027"], ["Chinese (Hong Kong SAR)", "3076"], ["Chinese (PRC)", "2052"], _
		["Chinese (Singapore)", "4100"], ["Chinese (Taiwan)", "1028"], ["Croatian", "1050"], ["Czech", "1029"], ["Danish", "1030"], _
		["Dutch", "1043"], ["Dutch (Belgium)", "2067"], ["English (Australia)", "3081"], ["English (Belize)", "10249"], ["English (Canada)", "4105"], _
		["English (Ireland)", "6153"], ["English (Jamaica)", "8201"], ["English (New Zealand)", "5129"], ["English (South Africa)", "7177"], _
		["English (Trinidad)", "11273"], ["English (United Kingdom)", "2057"], ["English (United States)", "1033"], ["Estonian", "1061"], _
		["Faeroese", "1080"], ["Farsi", "1065"], ["Finnish", "1035"], ["French (Standard)", "1036"], ["French (Belgium)", "2060"], _
		["French (Canada)", "3084"], ["French (Luxembourg)", "5132"], ["French (Switzerland)", "4108"], ["Gaelic (Scotland)", "1084"], _
		["German (Standard)", "1031"], ["German (Austrian)", "3079"], ["German (Liechtenstein)", "5127"], ["German (Luxembourg)", "4103"], _
		["German (Switzerland)", "2055"], ["Greek", "1032"], ["Hebrew", "1037"], ["Hindi", "1081"], ["Hungarian", "1038"], ["Icelandic", "1039"], _
		["Indonesian", "1057"], ["Italian (Standard)", "1040"], ["Italian (Switzerland)", "2064"], ["Japanese", "1041"], ["Korean", "1042"], _
		["Latvian", "1062"], ["Lithuanian", "1063"], ["Macedonian (FYROM)", "1071"], ["Malay (Malaysia)", "1086"], ["Maltese", "1082"], _
		["Norwegian (Bokml)", "1044"], ["Polish", "1045"], ["Portuguese (Brazil)", "1046"], ["Portuguese (Portugal)", "2070"], _
		["Raeto (Romance)", "1047"], ["Romanian", "1048"], ["Romanian (Moldova)", "2072"], ["Russian", "1049"], ["Russian (Moldova)", "2073"], _
		["Serbian (Cyrillic)", "3098"], ["Setsuana", "1074"], ["Slovak", "1051"], ["Slovenian", "1060"], ["Sorbian", "1070"], _
		["Spanish (Argentina)", "11274"], ["Spanish (Bolivia)", "16394"], ["Spanish (Chile)", "13322"], ["Spanish (Columbia)", "9226"], _
		["Spanish (Costa Rica)", "5130"], ["Spanish (Dominican Republic)", "7178"], ["Spanish (Ecuador)", "12298"], ["Spanish (El Salvador)", "17418"], _
		["Spanish (Guatemala)", "4106"], ["Spanish (Honduras)", "18442"], ["Spanish (Mexico)", "2058"], ["Spanish (Nicaragua)", "19466"], _
		["Spanish (Panama)", "6154"], ["Spanish (Paraguay)", "15370"], ["Spanish (Peru)", "10250"], ["Spanish (Puerto Rico)", "20490"], _
		["Spanish (Spain)", "1034"], ["Spanish (Uruguay)", "14346"], ["Spanish (Venezuela)", "8202"], ["Sutu", "1072"], _
		["Swedish", "1053"], ["Swedish (Finland)", "2077"], ["Thai", "1054"], ["Turkish", "1055"], ["Tsonga", "1073"], _
		["Ukranian", "1058"], ["Urdu (Pakistan)", "1056"], ["Vietnamese", "1066"], ["Xhosa", "1076"], ["Yiddish", "1085"], ["Zulu", "1077"]]

If $CmdLine[0] <> 0 Then
	If StringRight($CmdLine[1], 4) = '.au3' Then
		$FlagCompile = 1
		_ReadAU3($CmdLine[1])
	ElseIf $CmdLine[1] = StringUpper('/GUI') Then
		_GuiResUp($CmdLine[2])
		_ReadAU3($CmdLine[2])
	EndIf
Else
	Local $au3 = FileOpenDialog('   ', '', '(*.au3)')
	If @error Then Exit
	_GuiResUp($au3)
	_ReadAU3($au3)
EndIf

Func _GetPathAuexe()
	Local $ArrayPathAuexe[1][2], $auexe86 = '', $getpath86 = '', $auexe86b = '', $getpath86b = ''
	$auexe86 = RegRead('HKEY_CLASSES_ROOT\AutoIt3Script\Shell\Compile\Command', '')
	$auexe86b = RegRead('HKEY_CLASSES_ROOT\AutoIt3ScriptBeta\Shell\Compile\Command', '')
	If Not $auexe86 = '' Then
		$getpath86 = _StringBetween($auexe86, '"', '"')
		If Not @error Then $ArrayPathAuexe[0][0] = $getpath86[0]
	EndIf
	If Not $auexe86b = '' Then
		Local $getpath86b = _StringBetween($auexe86b, '"', '"')
		If Not @error Then $ArrayPathAuexe[0][1] = $getpath86b[0]
	EndIf
	Return $ArrayPathAuexe
EndFunc   ;==>_GetPathAuexe

Func _GuiResUp($iPath)
	Local $pathfile = $iPath
	For $i = 0 To UBound($alllang) - 1
		$contry &= $alllang[$i][0] & '|'
	Next
	Global $Form1 = GUICreate("WrapperAutoit3", 656, 528, -1, -1)
	GUISetBkColor(0xA8A8A5)
	Local $PathScitePr = _GetPathSciTE()
	Local $RegExists = _RegExists()
	$forum = GUICtrlCreateLabel("WrapperAutoit3 -   ", 10, 500, 250, 17)
	GUICtrlSetCursor(-1, 0)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	GUICtrlSetColor(-1, 0x0000FF)
	$Button = GUICtrlCreateButton("", 496, 490, 75, 25)
	$Save = GUICtrlCreateButton("", 400, 490, 75, 25)
	$Tab1 = GUICtrlCreateTab(5, 5, 648, 480)
	GUICtrlCreateTabItem("  ")
	$fau3 = GUICtrlCreateLabel(" .au3", 24, 40, 100, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	$pau3 = GUICtrlCreateInput($pathfile, 24, 60, 450, 21, $ES_READONLY)
	GUICtrlSetBkColor(-1, 0xFBFBFB)
	$Label1 = GUICtrlCreateLabel(" ", 24, 90, 150, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input1 = GUICtrlCreateInput("", 24, 110, 450, 21)
	$Button1 = GUICtrlCreateButton("", 496, 110, 75, 21)
	$Label2 = GUICtrlCreateLabel(" ", 24, 140, 150, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input2 = GUICtrlCreateInput("", 24, 160, 449, 21)
	$Label3 = GUICtrlCreateLabel(" ", 24, 190, 200, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	GUIStartGroup()
	Global $Checkbox1 = GUICtrlCreateRadio("x86", 24, 210, 41, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	GUICtrlSetState(-1, $GUI_CHECKED)
	Global $Checkbox2 = GUICtrlCreateRadio("x64", 24, 235, 41, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	$Label4 = GUICtrlCreateLabel("  (1 - 9)", 24, 260, 200, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input3 = GUICtrlCreateInput("", 24, 280, 33, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_CENTER, $ES_NUMBER))
	GUIStartGroup()
	$VersLabel = GUICtrlCreateLabel('  AutoIT  ', 24, 310, 300, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $RTM = GUICtrlCreateRadio('', 24, 330, 150, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	GUICtrlSetData(-1, 'RTM: ' & $GetVerRTM)
	GUICtrlSetState(-1, $GUI_CHECKED)
	Global $BETA = GUICtrlCreateRadio('', 24, 355, 150, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	GUICtrlSetData(-1, 'BETA: ' & $GetVerBeta)
	GUICtrlCreateTabItem("  ")
	$Label6 = GUICtrlCreateLabel("", 24, 32, 148, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input5 = GUICtrlCreateInput("", 24, 56, 563, 21)
	$Label7 = GUICtrlCreateLabel(" ", 24, 88, 156, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input6 = GUICtrlCreateInput("", 24, 115, 563, 21)
	$Label8 = GUICtrlCreateLabel(" ", 24, 152, 156, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input7 = GUICtrlCreateInput("", 24, 176, 276, 21)
	$Label9 = GUICtrlCreateLabel(" (0.0.0.0)", 24, 208, 156, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input8 = GUICtrlCreateInput("", 24, 232, 276, 21)
	$Label10 = GUICtrlCreateLabel(" (0.0.0.0)", 24, 264, 156, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input9 = GUICtrlCreateInput("", 24, 288, 276, 21)
	$Label11 = GUICtrlCreateLabel("  ", 24, 320, 156, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input10 = GUICtrlCreateInput("", 24, 344, 276, 21)
	$Label12 = GUICtrlCreateLabel("", 310, 152, 80, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input11 = GUICtrlCreateInput("", 310, 176, 276, 21)
	$Label13 = GUICtrlCreateLabel(" ", 310, 208, 156, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input12 = GUICtrlCreateInput("", 310, 232, 276, 21)
	$Label14 = GUICtrlCreateLabel("  ", 310, 264, 156, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input13 = GUICtrlCreateInput("", 310, 288, 276, 21)
	$Label15 = GUICtrlCreateLabel(" ", 310, 320, 100, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	Global $Input14 = GUICtrlCreateInput("", 310, 344, 276, 21)
	$Label5 = GUICtrlCreateLabel(" ", 24, 380, 150, 17)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	$http = GUICtrlCreateLabel("http://support.microsoft.com/kb/221435/ru", 316, 400, 250, 17)
	GUICtrlSetCursor(-1, 0)
	GUICtrlSetFont(-1, 8, 800, 1, "MS Sans Serif")
	GUICtrlSetColor(-1, 0x0000FF)
	Global $Input4 = GUICtrlCreateCombo("", 24, 400, 276, 25, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSendMsg(-1, $CB_SETMINVISIBLE, 10, 0)
	GUICtrlSetData(-1, $contry, "English (United Kingdom)")
	GUICtrlCreateTabItem(" ")
	Global $Edit1 = GUICtrlCreateEdit("", 24, 75, 600, 150)
	GUICtrlSetFont(-1, 9, 800, 0, "Arial")
	GUICtrlSetBkColor(-1, 0xD8AF88)
	$Label16 = GUICtrlCreateLabel("  .BMP  .ICO (    |  | ).  - '|'", 24, 32, 600, 35)
	GUICtrlSetFont(-1, 9, 800, 0, "Arial")
	$Button2 = GUICtrlCreateButton("", 555, 230, 60, 25)
	Global $Edit2 = GUICtrlCreateEdit("", 24, 300, 600, 150)
	GUICtrlSetFont(-1, 9, 800, 0, "Arial")
	GUICtrlSetBkColor(-1, 0xD8AF88)
	$Button3 = GUICtrlCreateButton("", 555, 455, 60, 25)
	$Label17 = GUICtrlCreateLabel(" . (    |  |  | [True - ,False( )]).  - '|'", 24, 260, 600, 35)
	GUICtrlSetFont(-1, 9, 800, 0, "Arial")
	GUICtrlCreateTabItem("")
	Local $inreg = GUICtrlCreateCheckbox('   ', 24, 40, 200, 17)
	GUICtrlSetFont(-1, 9, 800, 0, "Arial")
	If $RegExists Then GUICtrlSetState(-1, $GUI_CHECKED)
	Local $insc = GUICtrlCreateCheckbox('  SciTE', 24, 90, 200, 17)
	GUICtrlSetFont(-1, 9, 800, 0, "Arial")
	If $PathScitePr Then
		If FileExists($PathScitePr & '\oldawau3.properties') Then GUICtrlSetState(-1, $GUI_CHECKED)
	EndIf
	GUISetState(@SW_SHOW)
	_ReadDirect($pathfile)
	While 1
		$nMsg = GUIGetMsg()
		Switch $nMsg
			Case $GUI_EVENT_CLOSE
				GUIDelete($Form1)
				Exit
			Case $http
				ShellExecute('http://support.microsoft.com/kb/221435/ru')
			Case $forum
				ShellExecute('http://autoit-script.ru/index.php?topic=17953.0')
			Case $Button1
				$fileico = FileOpenDialog('', @ScriptDir, '(*.ico*)', 2, '', $Form1)
				If Not @error Then GUICtrlSetData($Input1, $fileico)
			Case $Button2
				$fileicobmp = FileOpenDialog('', @ScriptDir, '(*.ico;*.bmp)', 2, '', $Form1)
				If Not @error Then
					If StringRight($fileicobmp, 4) = '.bmp' Then $fileicobmp = $fileicobmp & '|2|' & StringTrimRight(StringRegExpReplace($fileicobmp, '.*\\', ''), 4)
					If StringRight($fileicobmp, 4) = '.ico' Then $fileicobmp = $fileicobmp & '|3|' & StringTrimRight(StringRegExpReplace($fileicobmp, '.*\\', ''), 4)
					Local $readedit1 = GUICtrlRead($Edit1)
					If $readedit1 <> '' Then
						GUICtrlSetData($Edit1, $readedit1 & @CRLF & $fileicobmp)
					Else
						GUICtrlSetData($Edit1, $fileicobmp)
					EndIf
				EndIf
			Case $Button3
				Local $allfiledata = '', $readedit2 = GUICtrlRead($Edit2)
				Local $allfile = FileOpenDialog('', @ScriptDir, '(*.*)', 6, '', $Form1)
				If Not @error Then
					If StringInStr($allfile, '|') Then
						Local $stringrepld = StringReplace($allfile, '|', '\', 1)
						Local $sDrive = "", $sDir = "", $sFilename = "", $sExtension = ""
						Local $aPathSplit = _PathSplit($stringrepld, $sDrive, $sDir, $sFilename, $sExtension)
						Local $newstring = StringReplace($stringrepld, '|', '*' & $aPathSplit[1] & $aPathSplit[2])
						Local $delimfile = StringSplit($newstring, '*')
						For $i = 1 To $delimfile[0]
							$allfiledata &= $delimfile[$i] & '|10|' & StringTrimRight(StringRegExpReplace($delimfile[$i], '.*\\', ''), 4) & @CRLF
						Next
						If $readedit2 <> '' Then
							GUICtrlSetData($Edit2, $readedit2 & @CRLF & $allfiledata)
						Else
							GUICtrlSetData($Edit2, $allfiledata)
						EndIf
					Else
						$allfiledata = $allfile
						If $readedit2 <> '' Then
							GUICtrlSetData($Edit2, $readedit2 & @CRLF & $allfiledata & '|10|' & StringTrimRight(StringRegExpReplace($allfiledata, '.*\\', ''), 4))
						Else
							GUICtrlSetData($Edit2, $allfiledata & '|10|' & StringTrimRight(StringRegExpReplace($allfiledata, '.*\\', ''), 4))
						EndIf
					EndIf
				EndIf
			Case $Button
				_FileRewrite($pathfile)
				If Not @error Then
					GUIDelete($Form1)
					ExitLoop
				Else
					$stringparam = ''
					TrayTip('WrapperAutoit3', ' ', 3, 3)
				EndIf
			Case $Save
				_FileRewrite($pathfile)
				If Not @error Then
					$stringparam = ''
					TrayTip('WrapperAutoit3', '', 3, 1)
				Else
					$stringparam = ''
					TrayTip('WrapperAutoit3', ' ', 3, 3)
				EndIf
			Case $inreg
				Local $checkwn = GUICtrlRead($inreg)
				If $checkwn = 1 Then
					_RegWrite()
					If Not @error Then
						TrayTip('WrapperAutoit3', '  ', 3, 1)
					Else
						GUICtrlSetState($inreg, $GUI_UNCHECKED)
						TrayTip('WrapperAutoit3', '   ', 3, 3)
					EndIf
				ElseIf $checkwn = 4 Then
					_RegDel()
					TrayTip('WrapperAutoit3', '   ', 3, 1)
				EndIf
			Case $insc
				Local $checksc = GUICtrlRead($insc)
				If $checksc = 1 Then
					If FileCopy(@ScriptFullPath, $PWA, 9) Then
						Local $addstring = '# 35  WrapperAutoIt3' & @CRLF & _
								'command.35.$(au3)="' & $PWA & '" /gui "$(FilePath)"' & @CRLF & _
								'command.name.35.$(au3)=WrapperAutoIt3 + Edit' & @CRLF & _
								'command.shortcut.35.$(au3)=Alt+1' & @CRLF & _
								'command.35.filter.$(au3)=1' & @CRLF & _
								'# 36 WrapperAutoIt3' & @CRLF & _
								'command.36.$(au3)="' & $PWA & '" "$(FilePath)"' & @CRLF & _
								'command.name.36.$(au3)=WrapperAutoIt3' & @CRLF & _
								'command.shortcut.36.$(au3)=Alt+2' & @CRLF & _
								'command.36.filter.$(au3)=1'
						$PathScitePr = _GetPathSciTE(2)
						If $PathScitePr Then
							If Not FileExists($PathScitePr & '\oldawau3.properties') Then
								Local $Readau3 = FileRead($PathScitePr & '\au3.properties')
								FileCopy($PathScitePr & '\au3.properties', $PathScitePr & '\oldawau3.properties')
								Local $ofpr = FileOpen($PathScitePr & '\au3.properties', 2)
								FileWrite($ofpr, $Readau3 & @CRLF & $addstring)
								FileClose($ofpr)
							Else
								FileCopy($PathScitePr & '\oldawau3.properties', $PathScitePr & '\au3.properties', 1)
								Local $Readau3 = FileRead($PathScitePr & '\au3.properties')
								Local $ofpr = FileOpen($PathScitePr & '\au3.properties', 2)
								FileWrite($ofpr, $Readau3 & @CRLF & $addstring)
								FileClose($ofpr)
							EndIf
							TrayTip('WrapperAutoIt3', '  SciTE', 3, 1)
						Else
							GUICtrlSetState($insc, $GUI_UNCHECKED)
							TrayTip('WrapperAutoIt3', '  SciTE', 3, 3)
						EndIf
					Else
						TrayTip('WrapperAutoIt3', ' ,    ', 3, 3)
					EndIf
				ElseIf $checksc = 4 Then
					FileMove($PathScitePr & '\oldawau3.properties', $PathScitePr & '\au3.properties', 1)
					TrayTip('WrapperAutoIt3', '  SciTE', 3, 1)
				EndIf
		EndSwitch
	WEnd
EndFunc   ;==>_GuiResUp

Func _GetPathSciTE($FlagSearch = 1)
	Local $scitepr = ''
	Local $pathscite = RegRead('HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AutoIt3Script\Shell\Edit\Command', '')
	Local $pathsciteb = RegRead('HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AutoIt3ScriptBeta\Shell\Edit\Command', '')
	If Not $pathscite = '' Then
		Local $getpathscite = _StringBetween($pathscite, '"', '"')
		If Not @error Then
			Local $clpath = StringRegExp($getpathscite[0], '^(.*\\)([^\\]*?)(\.[^.]+)?$', 3)
			$scitepr = $clpath[0] & 'Properties'
		EndIf
	ElseIf Not $pathsciteb = '' Then
		Local $getpathsciteb = _StringBetween($pathsciteb, '"', '"')
		If Not @error Then
			Local $clpathb = StringRegExp($getpathsciteb[0], '^(.*\\)([^\\]*?)(\.[^.]+)?$', 3)
			$scitepr = $clpathb[0] & 'Properties'
		EndIf
	ElseIf $pathscite = '' And $pathsciteb = '' Then
		$scitepr = IniRead($inisetting, 'path', 'scite', 'non')
		If $scitepr = 'non' And $FlagSearch = 2 Then
			Local $pathopen = FileSelectFolder('   SciTE', @ProgramFilesDir, 0, '', $Form1)
			If @error Then
				$scitepr = ''
			Else
				If FileExists($pathopen & '\Properties\au3.properties') Then
					$scitepr = $pathopen & '\Properties'
					IniWrite($inisetting, 'path', 'scite', $scitepr)
				Else
					$scitepr = ''
				EndIf
			EndIf
		EndIf
	EndIf
	Return $scitepr
EndFunc   ;==>_GetPathSciTE

Func _RegExists()
	Local $regex = 0
	If Not RegRead('HKEY_CLASSES_ROOT\.au3\shell\WrapperAutoit3\command', '') Then Return $regex
	If Not RegRead('HKEY_CLASSES_ROOT\.au3\shell\WrapperAutoit3 \command', '') Then Return $regex
	If Not RegRead('HKEY_CLASSES_ROOT\AutoIt3Script\Shell\WrapperAutoit3\Command', '') Then Return $regex
	If Not RegRead('HKEY_CLASSES_ROOT\AutoIt3Script\Shell\WrapperAutoit3 \Command', '') Then Return $regex
	If Not RegRead('HKEY_CLASSES_ROOT\AutoIt3ScriptBeta\Shell\WrapperAutoit3\Command', '') Then Return $regex
	If Not RegRead('HKEY_CLASSES_ROOT\AutoIt3ScriptBeta\Shell\WrapperAutoit3 \Command', '') Then Return $regex
	$regex = 1
	Return $regex
EndFunc   ;==>_RegExists

Func _RegWrite()
	If Not FileCopy(@ScriptFullPath, $PWA, 9) Then Return SetError(-1, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\.au3\shell\WrapperAutoit3', '', 'REG_SZ', 'WrapperAutoit3') Then Return SetError(1, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\.au3\shell\WrapperAutoit3\command', '', 'REG_SZ', '"' & $PWA & '" "%l"') Then Return SetError(2, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\.au3\shell\WrapperAutoit3 ', '', 'REG_SZ', 'WrapperAutoit3 ') Then Return SetError(3, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\.au3\shell\WrapperAutoit3 \command', '', 'REG_SZ', '"' & $PWA & '" /Gui "%l"') Then Return SetError(4, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\AutoIt3Script\Shell\WrapperAutoit3\Command', '', 'REG_SZ', '"' & $PWA & '" "%l"') Then Return SetError(5, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\AutoIt3Script\Shell\WrapperAutoit3 \Command', '', 'REG_SZ', '"' & $PWA & '" /Gui "%l"') Then Return SetError(6, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\AutoIt3ScriptBeta\Shell\WrapperAutoit3\Command', '', 'REG_SZ', '"' & $PWA & '" "%l"') Then Return SetError(7, 0, 0)
	If Not RegWrite('HKEY_CLASSES_ROOT\AutoIt3ScriptBeta\Shell\WrapperAutoit3 \Command', '', 'REG_SZ', '"' & $PWA & '" /Gui "%l"') Then Return SetError(8, 0, 0)
EndFunc   ;==>_RegWrite

Func _RegDel()
	RegDelete('HKEY_CLASSES_ROOT\.au3\shell')
	RegDelete('HKEY_CLASSES_ROOT\AutoIt3Script\Shell\WrapperAutoit3')
	RegDelete('HKEY_CLASSES_ROOT\AutoIt3ScriptBeta\Shell\WrapperAutoit3')
	RegDelete('HKEY_CLASSES_ROOT\AutoIt3Script\Shell\WrapperAutoit3 ')
	RegDelete('HKEY_CLASSES_ROOT\AutoIt3ScriptBeta\Shell\WrapperAutoit3 ')
EndFunc   ;==>_RegDel

Func _FileRewrite($pathfileau3)
	If Not FileCopy($pathfileau3, $pathfileau3 & '.old', 1) Then Return SetError(-1, 0, 0)
	Local $strcod = '', $compile = ''
	Local $ri1 = StringStripWS(GUICtrlRead($Input1), 3)
	If $ri1 <> '' Then $stringparam &= '##icon=' & $ri1 & @CRLF
	Local $ri2 = StringStripWS(GUICtrlRead($Input2), 3)
	If $ri2 <> '' Then
		Local $strexe = StringRight($ri2, 4)
		If $strexe = '.exe' Then
			$stringparam &= '##exename=' & $ri2 & @CRLF
		Else
			$stringparam &= '##exename=' & $ri2 & '.exe' & @CRLF
		EndIf
	EndIf
	Local $ri3 = StringStripWS(GUICtrlRead($Input3), 3)
	If $ri3 <> '' Then
		$stringparam &= '##upx=' & $ri3 & @CRLF
	Else
		$stringparam &= '##upx=n' & @CRLF
	EndIf
	Local $ri4 = GUICtrlRead($Input4)
	For $i = 0 To UBound($alllang) - 1
		If $ri4 = $alllang[$i][0] Then
			$ri4 = $alllang[$i][1]
			ExitLoop
		EndIf
	Next
	If $ri4 <> '' Then $stringparam &= '##lang=' & $ri4 & @CRLF
	Local $ri5 = StringStripWS(GUICtrlRead($Input5), 3)
	If $ri5 <> '' Then $stringparam &= '##comments=' & $ri5 & @CRLF
	Local $ri6 = StringStripWS(GUICtrlRead($Input6), 3)
	If $ri6 <> '' Then $stringparam &= '##legalcopyright=' & $ri6 & @CRLF
	Local $ri7 = StringStripWS(GUICtrlRead($Input7), 3)
	If $ri7 <> '' Then $stringparam &= '##legaltrademarks=' & $ri7 & @CRLF
	Local $ri8 = StringStripWS(GUICtrlRead($Input8), 3)
	If $ri8 <> '' Then
		Local $checkparampv = StringSplit($ri8, '.')
		If $checkparampv[0] = 4 Then
			$stringparam &= '##productversion=' & $ri8 & @CRLF
		Else
			$stringparam &= '##productversion=0.0.0.0' & @CRLF
		EndIf
	EndIf
	Local $ri9 = StringStripWS(GUICtrlRead($Input9), 3)
	If $ri9 <> '' Then
		Local $checkparamfv = StringSplit($ri9, '.')
		If $checkparamfv[0] = 4 Then
			$stringparam &= '##fileversion=' & $ri9 & @CRLF
		Else
			$stringparam &= '##fileversion=0.0.0.0' & @CRLF
		EndIf
	EndIf
	Local $ri10 = StringStripWS(GUICtrlRead($Input10), 3)
	If $ri10 <> '' Then $stringparam &= '##originalfilename=' & $ri10 & @CRLF
	Local $ri11 = StringStripWS(GUICtrlRead($Input11), 3)
	If $ri11 <> '' Then $stringparam &= '##companyname=' & $ri11 & @CRLF
	Local $ri12 = StringStripWS(GUICtrlRead($Input12), 3)
	If $ri12 <> '' Then $stringparam &= '##productname=' & $ri12 & @CRLF
	Local $ri13 = StringStripWS(GUICtrlRead($Input13), 3)
	If $ri13 <> '' Then $stringparam &= '##internalname=' & $ri13 & @CRLF
	Local $ri14 = StringStripWS(GUICtrlRead($Input14), 3)
	If $ri14 <> '' Then $stringparam &= '##filedescription=' & $ri14 & @CRLF
	If GUICtrlRead($Checkbox1) = 1 Then
		$bit = 'x86'
	ElseIf GUICtrlRead($Checkbox2) = 1 Then
		$bit = 'x64'
	EndIf
	If GUICtrlRead($RTM) = 1 Then
		If Not $GetVerRTM = '' Then $compile = 'rtm' & ';' & $GetVerRTM
	ElseIf GUICtrlRead($BETA) = 1 Then
		If Not $GetVerBeta = '' Then $compile = 'beta' & ';' & $GetVerBeta
	EndIf
	If Not $compile = '' Then $stringparam &= '##compile=' & $compile & @CRLF
	$stringparam &= '##bit=' & $bit & @CRLF
	Local $getres1 = StringSplit(GUICtrlRead($Edit1), @CRLF, 1)
	If Not @error And GUICtrlRead($Edit1) <> '' Then
		For $i = 1 To $getres1[0]
			If $getres1[$i] <> '' Then $stringparam &= '##addresbmpico=' & $getres1[$i] & @CRLF
		Next
	ElseIf @error And GUICtrlRead($Edit1) <> '' Then
		$stringparam &= '##addresbmpico=' & GUICtrlRead($Edit1) & @CRLF
	EndIf
	Local $getres2 = StringSplit(GUICtrlRead($Edit2), @CRLF, 1)
	If Not @error And GUICtrlRead($Edit2) <> '' Then
		For $i = 1 To $getres2[0]
			If $getres2[$i] <> '' Then $stringparam &= '##addres=' & $getres2[$i] & @CRLF
		Next
	ElseIf @error And GUICtrlRead($Edit2) <> '' Then
		$stringparam &= '##addres=' & GUICtrlRead($Edit2) & @CRLF
	EndIf
	$stringparam = StringTrimRight($stringparam, 2)
	Local $frta = FileReadToArray($pathfileau3), $dellparam, $nsp
	If Not @error Then
		For $i = 0 To UBound($frta) - 1
			$dellparam = StringStripWS($frta[$i], 3)
			$nsp = StringLeft($dellparam, 2)
			If $nsp = '##' Then
				ContinueLoop
			Else
				$strcod &= $frta[$i] & @CRLF
			EndIf
		Next
		Local $fonc = FileOpen($pathfileau3, 2)
		If $fonc = -1 Then Return SetError(1, 0, 0)
		Local $wrcode = FileWrite($fonc, $stringparam & @CRLF & $strcod)
		If $wrcode = 0 Then
			FileClose($fonc)
			Return SetError(2, 0, 0)
		Else
			FileDelete($pathfileau3 & '.old')
			FileClose($fonc)
		EndIf
	EndIf
EndFunc   ;==>_FileRewrite

Func _ReadDirect($iPathau3)
	Local $stringres, $stringbmpico
	Local $arrayaddres[0][5], $arrayaddpic[0][3], $pathcompf, $ratio = 5, $dellresico, $flagupx
	Local $param, $allparamres, $getfn, $namefunc, $ns, $fr, $ico, $outexe, $compressexe, $pathexe, $numparam
	Local $count = 1, $indres = 0, $dellparamWS, $dellWS, $semicolon, $position, $dellcomm, $checkparamfv, $checkparampv
	Local $frtgui = FileReadToArray($iPathau3)
	If @error Then Exit
	For $rf = 0 To UBound($frtgui) - 1
		$dellWS = StringStripWS($frtgui[$rf], 3)
		$ns = StringLeft($dellWS, 2)
		If $ns = '##' Then
			$semicolon = StringInStr($dellWS, ';')
			If $semicolon <> 0 Then
				$position = StringMid($dellWS, $semicolon)
				$dellcomm = StringReplace($dellWS, $position, '')
				$dellWS = StringStripWS($dellcomm, 3)
			EndIf
			$param = StringSplit($dellWS, '=', 1)
			If @error Or $param[2] = '' Then ContinueLoop
			$getfn = StringTrimLeft($param[1], 2)
			$namefunc = StringUpper(StringStripWS($getfn, 3))
			$dellparamWS = StringStripWS($param[2], 3)
			Switch $namefunc
				Case 'COMPILE'
					If StringUpper($dellparamWS) = 'RTM' Then
						GUICtrlSetState($RTM, $GUI_CHECKED)
					ElseIf StringUpper($dellparamWS) = 'BETA' Then
						GUICtrlSetState($BETA, $GUI_CHECKED)
					EndIf
				Case 'ICON'
					GUICtrlSetData($Input1, $dellparamWS)
				Case 'EXENAME'
					GUICtrlSetData($Input2, $dellparamWS)
				Case 'ADDRES'
					$stringres &= $dellparamWS & @CRLF
				Case 'ADDRESBMPICO'
					$stringbmpico &= $dellparamWS & @CRLF
				Case 'UPX'
					If StringUpper($dellparamWS) = 'N' Then
						GUICtrlSetData($Input3, '')
					Else
						GUICtrlSetData($Input3, $dellparamWS)
					EndIf
				Case 'BIT'
					If StringUpper($dellparamWS) = 'X64' Then
						GUICtrlSetState($Checkbox2, $GUI_CHECKED)
					ElseIf StringUpper($dellparamWS) = 'X86' Then
						GUICtrlSetState($Checkbox1, $GUI_CHECKED)
					EndIf
				Case 'COMMENTS'
					GUICtrlSetData($Input5, $dellparamWS)
				Case 'COMPANYNAME'
					GUICtrlSetData($Input11, $dellparamWS)
				Case 'FILEDESCRIPTION'
					GUICtrlSetData($Input14, $dellparamWS)
				Case 'INTERNALNAME'
					GUICtrlSetData($Input13, $dellparamWS)
				Case 'LEGALCOPYRIGHT'
					GUICtrlSetData($Input6, $dellparamWS)
				Case 'LEGALTRADEMARKS'
					GUICtrlSetData($Input7, $dellparamWS)
				Case 'ORIGINALFILENAME'
					GUICtrlSetData($Input10, $dellparamWS)
				Case 'PRODUCTNAME'
					GUICtrlSetData($Input12, $dellparamWS)
				Case 'FILEVERSION'
					$checkparamfv = StringSplit($dellparamWS, '.')
					If $checkparamfv[0] = 4 Then GUICtrlSetData($Input9, $dellparamWS)
				Case 'PRODUCTVERSION'
					$checkparampv = StringSplit($dellparamWS, '.')
					If $checkparampv[0] = 4 Then GUICtrlSetData($Input8, $dellparamWS)
				Case 'LANG'
					For $i = 1 To UBound($alllang) - 1
						If $alllang[$i][1] = $dellparamWS Then GUICtrlSetData($Input4, $alllang[$i][0])
					Next
			EndSwitch
		EndIf
	Next
	GUICtrlSetData($Edit2, StringStripWS($stringres, 3))
	GUICtrlSetData($Edit1, StringStripWS($stringbmpico, 3))
EndFunc   ;==>_ReadDirect

Func _ReadAU3($PathAU3)
	Local $verinfo = '', $arraycode
	If $FlagCompile = 1 Then $AutoITPath = $GetPathAuExe[0][0]
	If $stringparam <> '' Then
		$arraycode = StringSplit($stringparam, @CRLF, 3)
		If @error Then
			Local $arraycode[1]
		EndIf
	ElseIf $stringparam = '' Then
		$arraycode = FileReadToArray($PathAU3)
		If @error Then
			Local $arraycode[1]
		EndIf
	EndIf
	Local $arrayaddres[0][4], $arrayaddpic[0][4], $ratio = '', $flagupx = 0, $flagver = 0
	Local $param, $allparamres, $getfn, $namefunc, $ns, $ico, $outexe, $compressexe
	Local $count = 1, $indres = 0, $paramaddicobmp, $indib = 0, $dellparamWS, $dellWS, $semicolon, $position, $dellcomm
	Local $bit = '', $checkparampv, $checkparamfv
	For $i = 0 To UBound($arraycode) - 1
		$dellWS = StringStripWS($arraycode[$i], 3)
		$ns = StringLeft($dellWS, 2)
		If $ns = '##' Then
			$semicolon = StringInStr($dellWS, ';')
			If $semicolon <> 0 Then
				$position = StringMid($dellWS, $semicolon)
				$dellcomm = StringReplace($dellWS, $position, '')
				$dellWS = StringStripWS($dellcomm, 3)
			EndIf
			$param = StringSplit($dellWS, '=', 1)
			If @error Or $param[2] = '' Then ContinueLoop
			$getfn = StringTrimLeft($param[1], 2)
			$namefunc = StringUpper(StringStripWS($getfn, 3))
			$dellparamWS = StringStripWS($param[2], 3)
			Switch $namefunc
				Case 'COMPILE'
					If StringUpper($dellparamWS) = 'BETA' Then
						$flagver = 1
						$AutoITPath = $GetPathAuExe[0][1]
						$verinfo = $GetVerBeta
					ElseIf StringUpper($dellparamWS) = 'RTM' Then
						$flagver = 0
						$AutoITPath = $GetPathAuExe[0][0]
						$verinfo = $GetVerRTM
					EndIf
				Case 'ICON'
					If FileExists($dellparamWS) Then
						$ico = ' /icon ' & '"' & $dellparamWS & '"'
					Else
						$ico = ''
					EndIf
				Case 'EXENAME'
					If StringRight($dellparamWS, 4) = '.exe' Then
						$onlypath = StringRegExp($PathAU3, '^(.*\\)([^\\]*?)(\.[^.]+)?$', 3)
						$outexe = ' /out ' & '"' & $dellparamWS & '"'
						$compressexe = $onlypath[0] & $dellparamWS
					Else
						$outexe = ''
						$compressexe = ''
					EndIf
				Case 'ADDRES'
					$allparamres = StringSplit($dellparamWS, '|', 1)
					If Not @error And $allparamres[0] >= 3 Then
						Switch $allparamres[0]
							Case 4
								ReDim $arrayaddres[$indres + 1][5]
								$arrayaddres[$indres][0] = $allparamres[1]
								$arrayaddres[$indres][1] = $allparamres[2]
								$arrayaddres[$indres][2] = $allparamres[3]
								$arrayaddres[$indres][3] = $allparamres[4]
								$indres += 1
							Case 3
								ReDim $arrayaddres[$indres + 1][5]
								$arrayaddres[$indres][0] = $allparamres[1]
								$arrayaddres[$indres][1] = $allparamres[2]
								$arrayaddres[$indres][2] = $allparamres[3]
								$arrayaddres[$indres][3] = False
								$indres += 1
						EndSwitch
					EndIf
				Case 'ADDRESBMPICO'
					$paramaddicobmp = StringSplit($dellparamWS, '|', 1)
					If Not @error And $paramaddicobmp[0] = 3 Then
						Switch $paramaddicobmp[0]
							Case 3
								ReDim $arrayaddpic[$indib + 1][3]
								$arrayaddpic[$indib][0] = $paramaddicobmp[1]
								$arrayaddpic[$indib][1] = $paramaddicobmp[2]
								$arrayaddpic[$indib][2] = $paramaddicobmp[3]
								$indib += 1
						EndSwitch
					EndIf
				Case 'UPX'
					$flagupx = 1
					If StringUpper($dellparamWS) = 'N' Then
						$ratio = ''
					Else
						$ratio = Number($dellparamWS)
					EndIf
				Case 'BIT'
					If StringUpper($dellparamWS) = 'X64' Then
						$bit = ' /x64 '
					ElseIf StringUpper($dellparamWS) = 'X86' Then
						$bit = ' /x86 '
					EndIf
				Case 'COMMENTS'
					$INP_Comment = $dellparamWS
				Case 'COMPANYNAME'
					$INP_CompanyName = $dellparamWS
				Case 'FILEDESCRIPTION'
					$INP_Description = $dellparamWS
				Case 'INTERNALNAME'
					$INP_InternalName = $dellparamWS
				Case 'LEGALCOPYRIGHT'
					$INP_LegalCopyright = $dellparamWS
				Case 'LEGALTRADEMARKS'
					$INP_LegalTradeMarks = $dellparamWS
				Case 'ORIGINALFILENAME'
					$INP_OriginalFileName = $dellparamWS
				Case 'PRODUCTNAME'
					$INP_ProductName = $dellparamWS
				Case 'FILEVERSION'
					$checkparamfv = StringSplit($dellparamWS, '.')
					If $checkparamfv[0] = 4 Then $INP_Fileversion = $dellparamWS
				Case 'PRODUCTVERSION'
					$checkparampv = StringSplit($dellparamWS, '.')
					If $checkparampv[0] = 4 Then $INP_ProductVersion = $dellparamWS
				Case 'LANG'
					$INP_Res_Language = Number($dellparamWS)
			EndSwitch
		EndIf
	Next
	If $verinfo = '' Then $verinfo = $GetVerRTM
	ProgressOn(' Autoit - ' & $verinfo, '', StringRegExpReplace($PathAU3, '.*\\', ''), 10, 10)
	ProgressSet(30)
	If $outexe = '' Then
		$compressexe = StringTrimRight($PathAU3, 4) & '.exe'
		$outexe = ' /out ' & '"' & $compressexe & '"'
	EndIf
	If Not FileExists($AutoITPath) Then
		Local $IniReadPathC
		If $flagver = 0 Then
			$IniReadPathC = IniRead($inisetting, 'path', 'compiler', 'non')
		ElseIf $flagver = 1 Then
			$IniReadPathC = IniRead($inisetting, 'path', 'compilerb', 'non')
		EndIf
		If $IniReadPathC = 'non' Then
			$AutoITPath = FileOpenDialog('  ', '', '(*.exe)')
			If @error Then
				Exit
			Else
				If $flagver = 0 Then
					IniWrite($inisetting, 'path', 'compiler', $AutoITPath)
				ElseIf $flagver = 1 Then
					IniWrite($inisetting, 'path', 'compilerb', $AutoITPath)
				EndIf
				If $flagupx = 1 Then
					Local $packer = StringReplace($AutoITPath, StringRegExpReplace($AutoITPath, '.*\\', ''), '') & 'upx.exe'
					If FileExists($packer) Then IniWrite($inisetting, 'path', 'packer', $packer)
				EndIf
			EndIf
		Else
			$AutoITPath = $IniReadPathC
			If Not FileExists($AutoITPath) Then Exit
		EndIf
	EndIf
	RunWait($AutoITPath & ' /in ' & '"' & $PathAU3 & '"' & $outexe & $ico & $bit)
	If FileExists($compressexe) Then
		If UBound($arrayaddpic) <> 0 Then
			Local $CountInd = 49, $namenextf = '', $inderror = 1
			For $i = 0 To UBound($arrayaddpic) - 1
				If StringIsDigit($arrayaddpic[$i][2]) And StringRight($arrayaddpic[$i][0], 4) = '.ico' Then
					$namenextf = '"' & $arrayaddpic[$i][2] & '"'
				Else
					$namenextf = $arrayaddpic[$i][2]
				EndIf
				ProgressSet(50, StringRegExpReplace($arrayaddpic[$i][0], '.*\\', ''), '  ')
				Local $retind = _AddResBMPICO($compressexe, $arrayaddpic[$i][0], $arrayaddpic[$i][1], $namenextf, $CountInd, $INP_Res_Language)
				If @error >= 4 And @error <= 9 Then
					If $inderror = 10 Then
						FileDelete($compressexe)
						Exit
					EndIf
					$i -= 1
					$inderror += 1
					Sleep(1000)
				ElseIf @error = 0 Then
					$inderror = 1
				EndIf
				$CountInd += $retind
			Next
		EndIf
		If UBound($arrayaddres) <> 0 Then
			Local $inderror = 1
			For $i = 0 To UBound($arrayaddres) - 1
				ProgressSet(70, StringRegExpReplace($arrayaddres[$i][0], '.*\\', ''), '  ')
				_AddRes($compressexe, $arrayaddres[$i][0], $arrayaddres[$i][1], $arrayaddres[$i][2], $arrayaddres[$i][3], $INP_Res_Language)
				If @error >= 8 Then
					If $inderror = 10 Then
						FileDelete($compressexe)
						Exit
					EndIf
					$i -= 1
					$inderror += 1
					Sleep(1000)
				ElseIf @error = 0 Then
					$inderror = 1
				EndIf
			Next
		EndIf
		ProgressSet(80, '  ')
		For $i = 1 To 10
			_Create_RTVersion($compressexe)
			If @error Then
				If $i = 10 Then
					FileDelete($compressexe)
					Exit
				EndIf
				Sleep(1000)
			Else
				ExitLoop
			EndIf
		Next
		If $flagupx = 1 Then
			If $ratio <> '' Then
				$AutoITPath = StringReplace($AutoITPath, StringRegExpReplace($AutoITPath, '.*\\', ''), '') & 'upx.exe'
				ProgressSet(90, StringRegExpReplace($compressexe, '.*\\', ''), ' ')
				If Not FileExists($AutoITPath) Then
					Local $IniReadPathP = IniRead($inisetting, 'path', 'packer', 'non')
					If $IniReadPathP = 'non' Then
						$AutoITPath = FileOpenDialog('  ', '', '(*.exe)')
						If @error Then
							MsgBox(16, 'Error!', '  ')
							Exit
						Else
							IniWrite($inisetting, 'path', 'packer', $AutoITPath)
						EndIf
					Else
						$AutoITPath = $IniReadPathP
						If Not FileExists($AutoITPath) Then
							MsgBox(16, 'Error!', '  ')
							Exit
						EndIf
					EndIf
				EndIf
				RunWait($AutoITPath & ' -' & $ratio & ' ' & '"' & $compressexe & '"', '', Default)
			EndIf
		EndIf
	EndIf
	ProgressSet(100)
	Sleep(500)
	ProgressOff()
EndFunc   ;==>_ReadAU3

;===============  =====================================================================================
Func _Create_RTVersion($PathFileRes)
	_Res_Create_RTVersion($ResVer)
	_AddRes($PathFileRes, $ResVer, 16, 1)
	If @error < 9 And @error > 0 Then
		FileDelete($ResVer)
		Return SetError(1, 0, 0)
	ElseIf @error >= 9 Then
		Return SetError(2, @error, 0)
	Else
		FileDelete($ResVer)
	EndIf
EndFunc   ;==>_Create_RTVersion
;===================================================   =============================================================
;: _AddRes()
;:   (exe) .
;: $iPathFile -    
;           $iResFile -   ( )
;          $RType -  
;           $sResName -    (        )
;           $iCompress:
;                     |True -   
;                     |False-  ( )
;           $RLanguage -  .
;:      - 0
;-----------------------------------------------------------------------------------------------------------------------------------
Func _AddRes($iPathFile, $iResFile, $RType, $sResName, $iCompress = False, $RLanguage = 2057)
	Local $tBuffer = 0
	If $iPathFile = '' Or $iResFile = '' Or $RType = '' Or $sResName = '' Then Return SetError(1, 0, 0)
	If StringIsDigit($RType) Then $RType = Number($RType)
	If StringIsDigit($sResName) Then $sResName = Number($sResName)
	Local $iFileSize = FileGetSize($iResFile)
	If @error = 1 Or $iFileSize = 0 Then Return SetError(2, 0, 0)
	Local $tfile = DllStructCreate('byte[' & $iFileSize & ']')
	If @error <> 0 Then Return SetError(3, @error, 0)
	Local $pfile = DllStructGetPtr($tfile)
	If $pfile = 0 Then Return SetError(4, @error, 0)
	Local $hFile = _WinAPI_CreateFile($iResFile, 2, 2)
	If $hFile = 0 Then Return SetError(5, _WinAPI_GetLastError(), 0)
	Local $iBytes = 0
	If Not _WinAPI_ReadFile($hFile, $pfile, DllStructGetSize($tfile), $iBytes) Then Return SetError(6, _WinAPI_GetLastError(), 0)
	If Not _WinAPI_CloseHandle($hFile) Then Return SetError(7, _WinAPI_GetLastError(), 0)
	If $iCompress Then
		$iBytes = _WinAPI_LZNTCompress($tfile, $tBuffer)
		If @error <> 0 Then Return SetError(8, 0, 0)
		$pfile = DllStructGetPtr($tBuffer)
	EndIf
	Local $hUpdate = _WinAPI_BeginUpdateResource_($iPathFile)
	If Not $hUpdate = 1 Then Return SetError(9, _WinAPI_GetLastError(), 0)
	If Not _WinAPI_UpdateResource_($hUpdate, $RType, $sResName, $RLanguage, $pfile, $iBytes) Then Return SetError(10, 0, 0)
	If Not _WinAPI_EndUpdateResource_($hUpdate) Then Return SetError(11, _WinAPI_GetLastError(), 0)
EndFunc   ;==>_AddRes
;-------------------------------------------------------------------------------------------------------------------------------------
;: _GetRes()
;:    (exe)
;: $hInstance -  ,    .      _WinAPI_LoadLibraryEx()
;          $RType -  
;           $sResName -  
;           $isCompressed:
;                        |True -   (  ,    .    )
;                        |False -    .   ( )
;:        .
;--------------------------------------------------------------------------------------------------------------------------------------
Func _GetRes($hInstance, $RType, $sResName, $isCompressed = False)
	Local $hRes = _WinAPI_FindResource($hInstance, $RType, $sResName)
	If $hRes = 0 Then Return SetError(1, 0, 0)
	Local $dSize = _WinAPI_SizeOfResource($hInstance, $hRes)
	If $dSize = 0 Then Return SetError(2, 0, 0)
	Local $hLoad = _WinAPI_LoadResource($hInstance, $hRes)
	If $hLoad = 0 Then Return SetError(3, 0, 0)
	Local $pData = _WinAPI_LockResource($hLoad)
	If $pData = 0 Then Return SetError(4, 0, 0)
	Local $tBuffer = DllStructCreate("byte[" & $dSize & "]")
	If @error <> 0 Then Return SetError(5, 0, 0)
	_WinAPI_MoveMemory(DllStructGetPtr($tBuffer), $pData, $dSize)
	If $isCompressed Then
		Local $oBuffer
		_WinAPI_LZNTDecompress($tBuffer, $oBuffer)
		If @error Then Return SetError(6, 0, 0)
		$tBuffer = $oBuffer
	EndIf
	Return DllStructGetData($tBuffer, 1)
EndFunc   ;==>_GetRes
;---------------------------------------------------------------------------------------------------------------------
; _RemoveRes()
;:    
;:
;          $iPathFile -   
;          $RType -  
;          $sResName -  
;          $RLanguage -  .
;-----------------------------------------------------------------------------------------------------------------------
Func _RemoveRes($iPathFile, $RType, $sResName, $RLanguage = 2057)
	Local $hUpdate = _WinAPI_BeginUpdateResource_($iPathFile)
	If @error Then Return SetError(1, _WinAPI_GetLastError(), 0)
	Local $RetUpdate = _WinAPI_UpdateResource_($hUpdate, $RType, $sResName, $RLanguage, 0, 0)
	If @error Then Return SetError(2, _WinAPI_GetLastError(), 0)
	Local $UpdateRes = _WinAPI_EndUpdateResource_($hUpdate)
	If @error Then Return SetError(3, _WinAPI_GetLastError(), 0)
EndFunc   ;==>_RemoveRes

Func _WinAPI_BeginUpdateResource_($sFile, $fDelete = 0)
	Local $Ret = DllCall('kernel32.dll', 'ptr', 'BeginUpdateResourceW', 'wstr', $sFile, 'int', $fDelete)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginUpdateResource_

Func _WinAPI_UpdateResource_($hUpdate, $sType, $sName, $iLanguage, $pData, $iSize)
	Local $TypeOfType = 'int', $TypeOfName = 'int'
	If IsString($sType) Then
		$TypeOfType = 'wstr'
	EndIf
	If IsString($sName) Then
		$TypeOfName = 'wstr'
	EndIf
	Local $Ret = DllCall('kernel32.dll', 'int', 'UpdateResourceW', 'ptr', $hUpdate, $TypeOfType, $sType, $TypeOfName, $sName, 'ushort', $iLanguage, 'ptr', $pData, 'dword', $iSize)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_UpdateResource_

Func _WinAPI_EndUpdateResource_($hUpdate, $fDiscard = 0)
	Local $Ret = DllCall('kernel32.dll', 'int', 'EndUpdateResourceW', 'ptr', $hUpdate, 'int', $fDiscard)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EndUpdateResource_

;-----------------------------------------------------------------------------------------------------------------------
; _AddResBMPICO()
;:   (      ),
;:
;          $iPathFile -   
;          $InpResFile -   
;          $RType -  .        - "2"  "3".
;          $RName -  ,     .
;          $IconResBase -    .     ,     .
;                             "0",        .
;          $RLanguage -  
;--------------------------------------------------------------------------------------------------------------------------
Func _AddResBMPICO($iPathFile, $InpResFile, $RType, $RName, $IconResBase = 49, $RLanguage = 2057)
	If $iPathFile = '' Or $InpResFile = '' Or $RType = '' Or $RName = '' Then Return SetError(1, 0, 0)
	If Not FileExists($InpResFile) Then Return SetError(2, 0, 0)
	Local $result, $hFile, $tSize, $tBuffer, $pBuffer, $oBuffer, $bread = 0
	Local $RType_Type, $RName_Type
	Local $aRESOURCE_TYPES[2] = ["RT_BITMAP", "RT_ICON"]
	If StringIsDigit($RType) Then $RType = Number($RType)
	If StringIsDigit($RName) Then $RName = Number($RName)
	If IsString($RType) Then
		For $k = 0 To UBound($aRESOURCE_TYPES) - 1
			If $RType = $aRESOURCE_TYPES[$k] Then
				$RType = $k + 2
				$RType_Type = "long"
			EndIf
		Next
	EndIf
	If IsString($RType) Then
		$RType_Type = "wstr"
		$RType = StringUpper($RType)
	Else
		$RType_Type = "long"
	EndIf
	If IsString($RName) Then
		$RName_Type = "wstr"
		$RName = StringUpper($RName)
	Else
		$RName_Type = "long"
	EndIf
	$hFile = _WinAPI_CreateFile($InpResFile, 2, 2)
	If Not $hFile Then Return SetError(3, 0, 0)
	Local $hUpdate = _WinAPI_BeginUpdateResource_($iPathFile)
	If Not $hUpdate = 1 Then Return SetError(4, _WinAPI_GetLastError(), 0)
	Switch $RType
		Case 2
			$tSize = FileGetSize($InpResFile) - 14
			$tBuffer = DllStructCreate("byte Text[" & $tSize & "]")
			$pBuffer = DllStructGetPtr($tBuffer)
			_WinAPI_SetFilePointer($hFile, 14)
			_WinAPI_ReadFile($hFile, $pBuffer, $tSize, $bread, 0)
			If $hFile Then _WinAPI_CloseHandle($hFile)
			If $bread > 0 Then
				DllCall("kernel32.dll", "int", "UpdateResourceW", "ptr", $hUpdate, $RType_Type, $RType, $RName_Type, $RName, "ushort", $RLanguage, "ptr", $pBuffer, "dword", $tSize)
				If @error Then Return SetError(5, 0, 0)
				Local $resendupdbmp = _WinAPI_EndUpdateResource_($hUpdate)
				If Not $resendupdbmp = 1 Then Return SetError(6, _WinAPI_GetLastError(), 0)
			EndIf
		Case 3
			Local $tSize = FileGetSize($InpResFile)
			Local $tI_Input_Header = DllStructCreate("word res;word type;word ImageCount;byte rest[" & $tSize - 6 & "]")
			_WinAPI_ReadFile($hFile, DllStructGetPtr($tI_Input_Header), FileGetSize($InpResFile), $bread, 0)
			_WinAPI_CloseHandle($hFile)
			Local $IconType = DllStructGetData($tI_Input_Header, "Type")
			Local $IconCount = DllStructGetData($tI_Input_Header, "ImageCount")
			Local $tB_IconGroupHeader = DllStructCreate("align 2;word res;word type;word ImageCount;byte rest[" & $IconCount * 14 & "]")
			Local $pB_IconGroupHeader = DllStructGetPtr($tB_IconGroupHeader)
			DllStructSetData($tB_IconGroupHeader, "Res", 0)
			DllStructSetData($tB_IconGroupHeader, "Type", $IconType)
			DllStructSetData($tB_IconGroupHeader, "ImageCount", $IconCount)
			For $x = 1 To $IconCount
				Local $pB_Input_IconHeader = DllStructGetPtr($tI_Input_Header, "rest") + ($x - 1) * 16
				Local $tB_Input_IconHeader = DllStructCreate("byte Width;byte Height;byte Colors;byte res;word Planes;word BitsPerPixel;dword ImageSize;dword ImageOffset", $pB_Input_IconHeader)
				Local $IconWidth = DllStructGetData($tB_Input_IconHeader, "Width")
				Local $IconHeight = DllStructGetData($tB_Input_IconHeader, "Height")
				Local $IconColors = DllStructGetData($tB_Input_IconHeader, "Colors")
				Local $IconPlanes = DllStructGetData($tB_Input_IconHeader, "Planes")
				Local $IconBitsPerPixel = DllStructGetData($tB_Input_IconHeader, "BitsPerPixel")
				Local $IconImageSize = DllStructGetData($tB_Input_IconHeader, "ImageSize")
				Local $IconImageOffset = DllStructGetData($tB_Input_IconHeader, "ImageOffset")
				$pB_IconGroupHeader = DllStructGetPtr($tB_IconGroupHeader, "rest") + ($x - 1) * 14
				Local $tB_GroupIcon = DllStructCreate("align 2;byte Width;byte Height;byte Colors;byte res;word Planes;word BitsPerPixel;dword ImageSize;word ResourceID", $pB_IconGroupHeader)
				DllStructSetData($tB_GroupIcon, "Width", $IconWidth)
				DllStructSetData($tB_GroupIcon, "Height", $IconHeight)
				DllStructSetData($tB_GroupIcon, "Colors", $IconColors)
				DllStructSetData($tB_GroupIcon, "res", 0)
				DllStructSetData($tB_GroupIcon, "Planes", $IconPlanes)
				DllStructSetData($tB_GroupIcon, "BitsPerPixel", $IconBitsPerPixel)
				DllStructSetData($tB_GroupIcon, "ImageSize", $IconImageSize)
				$IconResBase += 1
				DllStructSetData($tB_GroupIcon, "ResourceID", $IconResBase)
				Local $pB_IconData = DllStructGetPtr($tI_Input_Header) + $IconImageOffset
				DllCall("kernel32.dll", "int", "UpdateResourceW", "ptr", $hUpdate, "long", 3, "long", $IconResBase, "ushort", $RLanguage, "ptr", $pB_IconData, "dword", $IconImageSize)
				If @error <> 0 Then Return SetError(7, 0, 0)
			Next
			$pB_IconGroupHeader = DllStructGetPtr($tB_IconGroupHeader)
			DllCall("kernel32.dll", "int", "UpdateResourceW", "ptr", $hUpdate, "long", 14, $RName_Type, $RName, "ushort", 0, "ptr", $pB_IconGroupHeader, "dword", DllStructGetSize($tB_IconGroupHeader))
			If @error <> 0 Then Return SetError(8, 0, 0)
			Local $resendupdico = _WinAPI_EndUpdateResource_($hUpdate)
			If Not $resendupdico = 1 Then Return SetError(9, _WinAPI_GetLastError(), 0)
			Return $IconCount
	EndSwitch
EndFunc   ;==>_AddResBMPICO
;==========================================================================================================================
Func _Res_Create_RTVersion_BuildStringTableEntry($Key, $value)
	Local $padding = 1 - Mod(6 + StringLen($Key) + 1, 2)
	Local $padding2 = 1 - Mod(6 + StringLen($Key) + 1 + $padding + StringLen($value) + 1, 2)
	Local $p_VS_String = DllStructCreate( _
			"short   wLength;" & _
			"short   wValueLength;" & _
			"short   wType;" & _
			"wchar   szKey[" & StringLen($Key) + 1 + $padding & "];" & _
			"wchar   Value[" & StringLen($value) + 1 + $padding2 & "]")
	DllStructSetData($p_VS_String, "Wlength", DllStructGetSize($p_VS_String) - $padding2 * 2)
	DllStructSetData($p_VS_String, "wValueLength", StringLen($value) + 1)
	DllStructSetData($p_VS_String, "wType", 1)
	DllStructSetData($p_VS_String, "szKey", $Key)
	DllStructSetData($p_VS_String, "Value", $value)
	Return StringMid(DllStructGetData(DllStructCreate("byte[" & DllStructGetSize($p_VS_String) & "]", DllStructGetPtr($p_VS_String)), 1), 3)
EndFunc   ;==>_Res_Create_RTVersion_BuildStringTableEntry

Func _Res_Create_RTVersion(ByRef $OutResPath)
	Local $Res_StringTable_Children = "0x"
	$Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("FileVersion", $INP_Fileversion)
	If $INP_Comment <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("Comments", $INP_Comment)
	If $INP_Description <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("FileDescription", $INP_Description)
	If $INP_ProductVersion <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("ProductVersion", $INP_ProductVersion)
	If $INP_LegalCopyright <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("LegalCopyright", $INP_LegalCopyright)
	If $INP_CompanyName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("CompanyName", $INP_CompanyName)
	If $INP_InternalName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("InternalName", $INP_InternalName)
	If $INP_LegalTradeMarks <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("LegalTradeMarks", $INP_LegalTradeMarks)
	If $INP_ProductName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("ProductName", $INP_ProductName)
	If $INP_OriginalFileName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("OriginalFileName", $INP_OriginalFileName)
	Local $p_VS_StringTable = DllStructCreate( _
			"short   wLength;" & _
			"short   wValueLength;" & _
			"short   wType;" & _
			"byte    szKey[16];" & _
			"byte    Padding[2];" & _
			"byte    Children[" & (StringLen($Res_StringTable_Children) - 2) / 2 & "]")
	DllStructSetData($p_VS_StringTable, "Wlength", DllStructGetSize($p_VS_StringTable))
	DllStructSetData($p_VS_StringTable, "wValueLength", 0)
	DllStructSetData($p_VS_StringTable, "wType", 1)
	DllStructSetData($p_VS_StringTable, "szKey", StringToBinary(Hex($INP_Res_Language, 4) & '04b0', 2))
	DllStructSetData($p_VS_StringTable, "Children", Binary($Res_StringTable_Children))
	Local $p_VS_StringFileInfo = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"WCHAR  szKey[15];" & _
			"byte   Children[" & DllStructGetSize($p_VS_StringTable) & "]")
	DllStructSetData($p_VS_StringFileInfo, "Wlength", DllStructGetSize($p_VS_StringFileInfo))
	DllStructSetData($p_VS_StringFileInfo, "wValueLength", 0)
	DllStructSetData($p_VS_StringFileInfo, "wType", 1)
	DllStructSetData($p_VS_StringFileInfo, "szKey", "StringFileInfo")
	Local $p_VS_StringTable_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_StringTable) & "]", DllStructGetPtr($p_VS_StringTable))
	DllStructSetData($p_VS_StringFileInfo, "Children", DllStructGetData($p_VS_StringTable_Total, 1))
	Local $p_VS_Var = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"WCHAR  szKey[12];" & _
			"char  Padding[1];" & _
			"short  lang;" & _
			"short  lang2")
	DllStructSetData($p_VS_Var, "Wlength", DllStructGetSize($p_VS_Var))
	DllStructSetData($p_VS_Var, "wValueLength", 4)
	DllStructSetData($p_VS_Var, "wType", 0)
	DllStructSetData($p_VS_Var, "szKey", "Translation")
	DllStructSetData($p_VS_Var, "lang", $INP_Res_Language)
	DllStructSetData($p_VS_Var, "lang2", 0x04B0)
	Local $p_VS_VarFileInfo = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"WCHAR szKey[12];" & _
			"char  Padding[2];" & _
			"Byte   Children[" & DllStructGetSize($p_VS_Var) & "]")
	DllStructSetData($p_VS_VarFileInfo, "Wlength", DllStructGetSize($p_VS_VarFileInfo))
	DllStructSetData($p_VS_VarFileInfo, "wValueLength", 0)
	DllStructSetData($p_VS_VarFileInfo, "wType", 1)
	DllStructSetData($p_VS_VarFileInfo, "szKey", "VarFileInfo")
	Local $p_VS_Var_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_Var) & "]", DllStructGetPtr($p_VS_Var))
	DllStructSetData($p_VS_VarFileInfo, "Children", DllStructGetData($p_VS_Var_Total, 1))
	Local $p_VS_FIXEDFILEINFO = DllStructCreate( _
			"DWORD dwSignature;" & _
			"DWORD dwStrucVersion;" & _
			"DWORD dwFileVersionMS;" & _
			"DWORD dwFileVersionLS;" & _
			"DWORD dwProductVersionMS;" & _
			"DWORD dwProductVersionLS;" & _
			"DWORD dwFileFlagsMask;" & _
			"DWORD dwFileFlags;" & _
			"DWORD dwFileOS;" & _
			"DWORD dwFileType;" & _
			"DWORD dwFileSubtype;" & _
			"DWORD dwFileDateMS;" & _
			"DWORD dwFileDateLS")
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwSignature", 0xFEEF04BD)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwStrucVersion", 0x00010000)
	Local $tFileversion = StringSplit($INP_Fileversion, ".")
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileVersionMS", Number("0x" & Hex($tFileversion[1], 4) & Hex($tFileversion[2], 4)))
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileVersionLS", Number("0x" & Hex($tFileversion[3], 4) & Hex($tFileversion[4], 4)))
	$tFileversion = StringSplit($INP_ProductVersion, ".")
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwProductVersionMS", Number("0x" & Hex($tFileversion[1], 4) & Hex($tFileversion[2], 4)))
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwProductVersionLS", Number("0x" & Hex($tFileversion[3], 4) & Hex($tFileversion[4], 4)))
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileFlagsMask", 0)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileFlags", 0)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileOS", 0x00004)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileType", 0x00001)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileSubtype", 0)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileDateLS", 0)
	Local $p_VS_VERSIONINFO = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"wchar  szKey[16];" & _
			"wchar  Padding1[1];" & _
			"byte   value[" & DllStructGetSize($p_VS_FIXEDFILEINFO) & "];" & _
			"byte   Children[" & DllStructGetSize($p_VS_StringFileInfo) & "];" & _
			"byte   Children2[" & DllStructGetSize($p_VS_VarFileInfo) & "]")
	DllStructSetData($p_VS_VERSIONINFO, "Wlength", DllStructGetSize($p_VS_VERSIONINFO))
	DllStructSetData($p_VS_VERSIONINFO, "wValueLength", DllStructGetSize($p_VS_FIXEDFILEINFO))
	DllStructSetData($p_VS_VERSIONINFO, "wType", 0)
	DllStructSetData($p_VS_VERSIONINFO, "szKey", "VS_VERSION_INFO")
	Local $p_VS_FIXEDFILEINFO_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_FIXEDFILEINFO) & "]", DllStructGetPtr($p_VS_FIXEDFILEINFO))
	DllStructSetData($p_VS_VERSIONINFO, "value", DllStructGetData($p_VS_FIXEDFILEINFO_Total, 1))
	Local $p_VS_StringFileInfo_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_StringFileInfo) & "]", DllStructGetPtr($p_VS_StringFileInfo))
	DllStructSetData($p_VS_VERSIONINFO, "Children", DllStructGetData($p_VS_StringFileInfo_Total, 1))
	Local $p_VS_VarFileInfo_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_VarFileInfo) & "]", DllStructGetPtr($p_VS_VarFileInfo))
	DllStructSetData($p_VS_VERSIONINFO, "Children2", DllStructGetData($p_VS_VarFileInfo_Total, 1))
	Local $p_VS_VERSIONINFO_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_VERSIONINFO) & "]", DllStructGetPtr($p_VS_VERSIONINFO))
	Local $Fh = FileOpen($OutResPath, 2 + 16)
	FileWrite($Fh, DllStructGetData($p_VS_VERSIONINFO_Total, 1))
	FileClose($Fh)
EndFunc   ;==>_Res_Create_RTVersion

Func _WinAPI_LZNTDecompress(ByRef $tInput, ByRef $tOutput)
	Local $iUncompressedSize = 16 * DllStructGetSize($tInput)
	Local $tBuffer, $Ret
	$tOutput = 0
	$tBuffer = DllStructCreate("byte[" & $iUncompressedSize & "]")
	If @error Then Return SetError(1, 0, 0)
	$Ret = DllCall("ntdll.dll", "long", "RtlDecompressBuffer", "ushort", 2, "struct*", $tBuffer, "ulong", $iUncompressedSize, "struct*", $tInput, "ulong", DllStructGetSize($tInput), "ulong*", 0)
	If @error <> 0 Then Return SetError(2, 0, 0)
	If $Ret[0] Then Return SetError(3, $Ret[0], 0)
	$tOutput = DllStructCreate("byte[" & $Ret[6] & "]")
	DllCall("ntdll.dll", "none", "RtlMoveMemory", "struct*", $tOutput, "struct*", $tBuffer, "ulong_ptr", $Ret[6])
	If @error <> 0 Then
		$tOutput = 0
		Return SetError(4, 0, 0)
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_LZNTDecompress

Func _WinAPI_LZNTCompress(ByRef $tInput, ByRef $tOutput)
	Local $tBuffer, $tWorkSpace, $Ret
	Local $COMPRESSION_FORMAT_LZNT1 = 0x0002, $COMPRESSION_ENGINE_MAXIMUM = 0x0100
	$COMPRESSION_FORMAT_LZNT1 = BitOR($COMPRESSION_FORMAT_LZNT1, $COMPRESSION_ENGINE_MAXIMUM)
	$tOutput = 0
	$Ret = DllCall("ntdll.dll", "uint", "RtlGetCompressionWorkSpaceSize", "ushort", $COMPRESSION_FORMAT_LZNT1, "ulong*", 0, "ulong*", 0)
	If @error Then Return SetError(1, 0, 0)
	If $Ret[0] Then Return SetError(2, $Ret[0], 0)
	$tWorkSpace = DllStructCreate("byte[" & $Ret[2] & "]")
	$tBuffer = DllStructCreate("byte[" & (2 * DllStructGetSize($tInput)) & "]")
	$Ret = DllCall("ntdll.dll", "uint", "RtlCompressBuffer", "ushort", $COMPRESSION_FORMAT_LZNT1, "struct*", $tInput, "ulong", DllStructGetSize($tInput), "struct*", $tBuffer, "ulong", DllStructGetSize($tBuffer), "ulong", 4096, "ulong*", 0, "struct*", $tWorkSpace)
	If @error Then Return SetError(3, 0, 0)
	If $Ret[0] Then Return SetError(4, $Ret[0], 0)
	$tOutput = DllStructCreate("byte[" & $Ret[7] & "]")
	DllCall("ntdll.dll", "none", "RtlMoveMemory", "struct*", $tOutput, "struct*", $tBuffer, "ulong_ptr", $Ret[7])
	If @error <> 0 Then
		$tOutput = 0
		Return SetError(5, 0, 0)
	EndIf
	Return $Ret[7]
EndFunc   ;==>_WinAPI_LZNTCompress

