#include-once
#include <WinAPIEx.au3>
Opt("MustDeclareVars", 1)
Global $ResVer = @ScriptDir & "\temp.res"
Global $INP_Comment = '  JMPack 1.9'
Global $INP_LegalCopyright = 'Joiner';   = $Namepack
Global $INP_LegalTradeMarks = 'Joiner' ;   = $Namepack
Global $INP_CompanyName = 'Joiner';   = $Namepack
Global $INP_ProductName = 'ModPackInstall' ;   = $Namepack
Global $INP_Description = ' ' ;'   ' & $opt & ' ' & $NumberWoT
Global $INP_Fileversion = '0.1.9.0'
Global $INP_ProductVersion = '0.1.9.0';  = $INP_Fileversion
Global $INP_Res_Language = 1049
Global $INP_InternalName = 'ModPackInstall' ;   = $Namepack
Global $INP_OriginalFileName = 'ModPackInstall' ;   = $Namepack
;===================================================   =============================================================
Func _Create_RTVersion($PathFileRes)
	_Res_Create_RTVersion($ResVer)
	_AddRes($PathFileRes, $ResVer, 16, 1)
	If @error < 9 And @error > 0 Then
		FileDelete($ResVer)
		Return SetError(1, 0, 0)
	ElseIf @error >= 9 Then
		Return SetError(2, @error, 0)
	Else
		FileDelete($ResVer)
	EndIf
EndFunc   ;==>_Create_RTVersion

Func _Res_Create_RTVersion_BuildStringTableEntry($Key, $value)
	Local $padding = 1 - Mod(6 + StringLen($Key) + 1, 2)
	Local $padding2 = 1 - Mod(6 + StringLen($Key) + 1 + $padding + StringLen($value) + 1, 2)
	Local $p_VS_String = DllStructCreate( _
			"short   wLength;" & _
			"short   wValueLength;" & _
			"short   wType;" & _
			"wchar   szKey[" & StringLen($Key) + 1 + $padding & "];" & _
			"wchar   Value[" & StringLen($value) + 1 + $padding2 & "]")
	DllStructSetData($p_VS_String, "Wlength", DllStructGetSize($p_VS_String) - $padding2 * 2)
	DllStructSetData($p_VS_String, "wValueLength", StringLen($value) + 1)
	DllStructSetData($p_VS_String, "wType", 1)
	DllStructSetData($p_VS_String, "szKey", $Key)
	DllStructSetData($p_VS_String, "Value", $value)
	Return StringMid(DllStructGetData(DllStructCreate("byte[" & DllStructGetSize($p_VS_String) & "]", DllStructGetPtr($p_VS_String)), 1), 3)
EndFunc   ;==>_Res_Create_RTVersion_BuildStringTableEntry

Func _Res_Create_RTVersion(ByRef $OutResPath)
	Local $Res_StringTable_Children = "0x"
	$Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("FileVersion", $INP_Fileversion)
	If $INP_Comment <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("Comments", $INP_Comment)
	If $INP_Description <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("FileDescription", $INP_Description)
	If $INP_ProductVersion <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("ProductVersion", $INP_ProductVersion)
	If $INP_LegalCopyright <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("LegalCopyright", $INP_LegalCopyright)
	If $INP_CompanyName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("CompanyName", $INP_CompanyName)
	If $INP_InternalName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("InternalName", $INP_InternalName)
	If $INP_LegalTradeMarks <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("LegalTradeMarks", $INP_LegalTradeMarks)
	If $INP_ProductName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("ProductName", $INP_ProductName)
	If $INP_OriginalFileName <> "" Then $Res_StringTable_Children &= _Res_Create_RTVersion_BuildStringTableEntry("OriginalFileName", $INP_OriginalFileName)
	Local $p_VS_StringTable = DllStructCreate( _
			"short   wLength;" & _
			"short   wValueLength;" & _
			"short   wType;" & _
			"byte    szKey[16];" & _
			"byte    Padding[2];" & _
			"byte    Children[" & (StringLen($Res_StringTable_Children) - 2) / 2 & "]")
	DllStructSetData($p_VS_StringTable, "Wlength", DllStructGetSize($p_VS_StringTable))
	DllStructSetData($p_VS_StringTable, "wValueLength", 0)
	DllStructSetData($p_VS_StringTable, "wType", 1)
	DllStructSetData($p_VS_StringTable, "szKey", StringToBinary(Hex($INP_Res_Language, 4) & '04b0', 2))
	DllStructSetData($p_VS_StringTable, "Children", Binary($Res_StringTable_Children))
	Local $p_VS_StringFileInfo = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"WCHAR  szKey[15];" & _
			"byte   Children[" & DllStructGetSize($p_VS_StringTable) & "]")
	DllStructSetData($p_VS_StringFileInfo, "Wlength", DllStructGetSize($p_VS_StringFileInfo))
	DllStructSetData($p_VS_StringFileInfo, "wValueLength", 0)
	DllStructSetData($p_VS_StringFileInfo, "wType", 1)
	DllStructSetData($p_VS_StringFileInfo, "szKey", "StringFileInfo")
	Local $p_VS_StringTable_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_StringTable) & "]", DllStructGetPtr($p_VS_StringTable))
	DllStructSetData($p_VS_StringFileInfo, "Children", DllStructGetData($p_VS_StringTable_Total, 1))
	Local $p_VS_Var = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"WCHAR  szKey[12];" & _
			"char  Padding[1];" & _
			"short  lang;" & _
			"short  lang2")
	DllStructSetData($p_VS_Var, "Wlength", DllStructGetSize($p_VS_Var))
	DllStructSetData($p_VS_Var, "wValueLength", 4)
	DllStructSetData($p_VS_Var, "wType", 0)
	DllStructSetData($p_VS_Var, "szKey", "Translation")
	DllStructSetData($p_VS_Var, "lang", $INP_Res_Language)
	DllStructSetData($p_VS_Var, "lang2", 0x04B0)
	Local $p_VS_VarFileInfo = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"WCHAR szKey[12];" & _
			"char  Padding[2];" & _
			"Byte   Children[" & DllStructGetSize($p_VS_Var) & "]")
	DllStructSetData($p_VS_VarFileInfo, "Wlength", DllStructGetSize($p_VS_VarFileInfo))
	DllStructSetData($p_VS_VarFileInfo, "wValueLength", 0)
	DllStructSetData($p_VS_VarFileInfo, "wType", 1)
	DllStructSetData($p_VS_VarFileInfo, "szKey", "VarFileInfo")
	Local $p_VS_Var_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_Var) & "]", DllStructGetPtr($p_VS_Var))
	DllStructSetData($p_VS_VarFileInfo, "Children", DllStructGetData($p_VS_Var_Total, 1))
	Local $p_VS_FIXEDFILEINFO = DllStructCreate( _
			"DWORD dwSignature;" & _
			"DWORD dwStrucVersion;" & _
			"DWORD dwFileVersionMS;" & _
			"DWORD dwFileVersionLS;" & _
			"DWORD dwProductVersionMS;" & _
			"DWORD dwProductVersionLS;" & _
			"DWORD dwFileFlagsMask;" & _
			"DWORD dwFileFlags;" & _
			"DWORD dwFileOS;" & _
			"DWORD dwFileType;" & _
			"DWORD dwFileSubtype;" & _
			"DWORD dwFileDateMS;" & _
			"DWORD dwFileDateLS")
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwSignature", 0xFEEF04BD)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwStrucVersion", 0x00010000)
	Local $tFileversion = StringSplit($INP_Fileversion, ".")
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileVersionMS", Number("0x" & Hex($tFileversion[1], 4) & Hex($tFileversion[2], 4)))
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileVersionLS", Number("0x" & Hex($tFileversion[3], 4) & Hex($tFileversion[4], 4)))
	$tFileversion = StringSplit($INP_ProductVersion, ".")
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwProductVersionMS", Number("0x" & Hex($tFileversion[1], 4) & Hex($tFileversion[2], 4)))
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwProductVersionLS", Number("0x" & Hex($tFileversion[3], 4) & Hex($tFileversion[4], 4)))
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileFlagsMask", 0)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileFlags", 0)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileOS", 0x00004)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileType", 0x00001)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileSubtype", 0)
	DllStructSetData($p_VS_FIXEDFILEINFO, "dwFileDateLS", 0)
	Local $p_VS_VERSIONINFO = DllStructCreate( _
			"short  wLength;" & _
			"short  wValueLength;" & _
			"short  wType;" & _
			"wchar  szKey[16];" & _
			"wchar  Padding1[1];" & _
			"byte   value[" & DllStructGetSize($p_VS_FIXEDFILEINFO) & "];" & _
			"byte   Children[" & DllStructGetSize($p_VS_StringFileInfo) & "];" & _
			"byte   Children2[" & DllStructGetSize($p_VS_VarFileInfo) & "]")
	DllStructSetData($p_VS_VERSIONINFO, "Wlength", DllStructGetSize($p_VS_VERSIONINFO))
	DllStructSetData($p_VS_VERSIONINFO, "wValueLength", DllStructGetSize($p_VS_FIXEDFILEINFO))
	DllStructSetData($p_VS_VERSIONINFO, "wType", 0)
	DllStructSetData($p_VS_VERSIONINFO, "szKey", "VS_VERSION_INFO")
	Local $p_VS_FIXEDFILEINFO_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_FIXEDFILEINFO) & "]", DllStructGetPtr($p_VS_FIXEDFILEINFO))
	DllStructSetData($p_VS_VERSIONINFO, "value", DllStructGetData($p_VS_FIXEDFILEINFO_Total, 1))
	Local $p_VS_StringFileInfo_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_StringFileInfo) & "]", DllStructGetPtr($p_VS_StringFileInfo))
	DllStructSetData($p_VS_VERSIONINFO, "Children", DllStructGetData($p_VS_StringFileInfo_Total, 1))
	Local $p_VS_VarFileInfo_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_VarFileInfo) & "]", DllStructGetPtr($p_VS_VarFileInfo))
	DllStructSetData($p_VS_VERSIONINFO, "Children2", DllStructGetData($p_VS_VarFileInfo_Total, 1))
	Local $p_VS_VERSIONINFO_Total = DllStructCreate("byte Children[" & DllStructGetSize($p_VS_VERSIONINFO) & "]", DllStructGetPtr($p_VS_VERSIONINFO))
	Local $Fh = FileOpen($OutResPath, 2 + 16)
	FileWrite($Fh, DllStructGetData($p_VS_VERSIONINFO_Total, 1))
	FileClose($Fh)
EndFunc   ;==>_Res_Create_RTVersion
;---------------------------------------------------------------------------------------------------------------------
; _RemoveRes()
;:    
;:
;          $iPathFile -   
;          $RType -  
;          $sResName -  
;          $RLanguage -  .
;-----------------------------------------------------------------------------------------------------------------------
Func _RemoveRes($iPathFile, $RType, $sResName, $RLanguage = 2057)
	Local $hUpdate = _WinAPI_BeginUpdateResource_($iPathFile)
	If @error Then Return SetError(1, _WinAPI_GetLastError(), 0)
	Local $RetUpdate = _WinAPI_UpdateResource_($hUpdate, $RType, $sResName, $RLanguage, 0, 0)
	If @error Then Return SetError(2, _WinAPI_GetLastError(), 0)
	Local $UpdateRes = _WinAPI_EndUpdateResource_($hUpdate)
	If @error Then Return SetError(3, _WinAPI_GetLastError(), 0)
EndFunc   ;==>_RemoveRes

;----------------------------------------------------------------------------------------------------------------------------------
;: _AddRes()
;:   (exe) .
;: $iPathFile -    
;           $iResFile -   ( )
;          $RType -  
;           $sResName -    (        )
;           $RLanguage -  .
;:      - 0
;-----------------------------------------------------------------------------------------------------------------------------------
Func _AddRes($iPathFile, $iResFile, $RType, $sResName, $RLanguage = 2057)
	Local $tBuffer = 0
	If $iPathFile = '' Or $iResFile = '' Or $RType = '' Or $sResName = '' Then Return SetError(1, 0, 0)
	If StringIsDigit($RType) Then $RType = Number($RType)
	If StringIsDigit($sResName) Then $sResName = Number($sResName)
	Local $iFileSize = FileGetSize($iResFile)
	If @error = 1 Or $iFileSize = 0 Then Return SetError(2, 0, 0)
	Local $tfile = DllStructCreate('byte[' & $iFileSize & ']')
	If @error <> 0 Then Return SetError(3, @error, 0)
	Local $pfile = DllStructGetPtr($tfile)
	If $pfile = 0 Then Return SetError(4, @error, 0)
	Local $hFile = _WinAPI_CreateFile($iResFile, 2, 2)
	If $hFile = 0 Then Return SetError(5, _WinAPI_GetLastError(), 0)
	Local $iBytes = 0
	If Not _WinAPI_ReadFile($hFile, $pfile, DllStructGetSize($tfile), $iBytes) Then Return SetError(6, _WinAPI_GetLastError(), 0)
	If Not _WinAPI_CloseHandle($hFile) Then Return SetError(7, _WinAPI_GetLastError(), 0)
	Local $hUpdate = _WinAPI_BeginUpdateResource_($iPathFile)
	If Not $hUpdate = 1 Then Return SetError(9, _WinAPI_GetLastError(), 0)
	If Not _WinAPI_UpdateResource_($hUpdate, $RType, $sResName, $RLanguage, $pfile, $iBytes) Then Return SetError(10, 0, 0)
	If Not _WinAPI_EndUpdateResource_($hUpdate) Then Return SetError(11, _WinAPI_GetLastError(), 0)
EndFunc   ;==>_AddRes

;-----------------------------------------------------------------------------------------------------------------------
; _AddResBMPICO()
;:   (      ),
;:
;          $iPathFile -   
;          $InpResFile -   
;          $RType -  .        - "2"  "3".
;          $RName -  ,     .
;          $IconResBase -    .     ,     .
;                             "0",        .
;          $RLanguage -  
;--------------------------------------------------------------------------------------------------------------------------
Func _AddResBMPICO($iPathFile, $InpResFile, $RType, $RName, $IconResBase = 49, $RLanguage = 2057)
	If $iPathFile = '' Or $InpResFile = '' Or $RType = '' Or $RName = '' Then Return SetError(1, 0, 0)
	If Not FileExists($InpResFile) Then Return SetError(2, 0, 0)
	Local $result, $hFile, $tSize, $tBuffer, $pBuffer, $oBuffer, $bread = 0
	Local $RType_Type, $RName_Type
	Local $aRESOURCE_TYPES[2] = ["RT_BITMAP", "RT_ICON"]
	If StringIsDigit($RType) Then $RType = Number($RType)
	If StringIsDigit($RName) Then $RName = Number($RName)
	If IsString($RType) Then
		For $k = 0 To UBound($aRESOURCE_TYPES) - 1
			If $RType = $aRESOURCE_TYPES[$k] Then
				$RType = $k + 2
				$RType_Type = "long"
			EndIf
		Next
	EndIf
	If IsString($RType) Then
		$RType_Type = "wstr"
		$RType = StringUpper($RType)
	Else
		$RType_Type = "long"
	EndIf
	If IsString($RName) Then
		$RName_Type = "wstr"
		$RName = StringUpper($RName)
	Else
		$RName_Type = "long"
	EndIf
	$hFile = _WinAPI_CreateFile($InpResFile, 2, 2)
	If Not $hFile Then Return SetError(3, 0, 0)
	Local $hUpdate = _WinAPI_BeginUpdateResource_($iPathFile)
	If Not $hUpdate = 1 Then Return SetError(4, _WinAPI_GetLastError(), 0)
	Switch $RType
		Case 2
			$tSize = FileGetSize($InpResFile) - 14
			$tBuffer = DllStructCreate("byte Text[" & $tSize & "]")
			$pBuffer = DllStructGetPtr($tBuffer)
			_WinAPI_SetFilePointer($hFile, 14)
			_WinAPI_ReadFile($hFile, $pBuffer, $tSize, $bread, 0)
			If $hFile Then _WinAPI_CloseHandle($hFile)
			If $bread > 0 Then
				DllCall("kernel32.dll", "int", "UpdateResourceW", "ptr", $hUpdate, $RType_Type, $RType, $RName_Type, $RName, "ushort", $RLanguage, "ptr", $pBuffer, "dword", $tSize)
				If @error Then Return SetError(5, 0, 0)
				Local $resendupdbmp = _WinAPI_EndUpdateResource_($hUpdate)
				If Not $resendupdbmp = 1 Then Return SetError(6, _WinAPI_GetLastError(), 0)
			EndIf
		Case 3
			Local $tSize = FileGetSize($InpResFile)
			Local $tI_Input_Header = DllStructCreate("word res;word type;word ImageCount;byte rest[" & $tSize - 6 & "]")
			_WinAPI_ReadFile($hFile, DllStructGetPtr($tI_Input_Header), FileGetSize($InpResFile), $bread, 0)
			_WinAPI_CloseHandle($hFile)
			Local $IconType = DllStructGetData($tI_Input_Header, "Type")
			Local $IconCount = DllStructGetData($tI_Input_Header, "ImageCount")
			Local $tB_IconGroupHeader = DllStructCreate("align 2;word res;word type;word ImageCount;byte rest[" & $IconCount * 14 & "]")
			Local $pB_IconGroupHeader = DllStructGetPtr($tB_IconGroupHeader)
			DllStructSetData($tB_IconGroupHeader, "Res", 0)
			DllStructSetData($tB_IconGroupHeader, "Type", $IconType)
			DllStructSetData($tB_IconGroupHeader, "ImageCount", $IconCount)
			For $x = 1 To $IconCount
				Local $pB_Input_IconHeader = DllStructGetPtr($tI_Input_Header, "rest") + ($x - 1) * 16
				Local $tB_Input_IconHeader = DllStructCreate("byte Width;byte Height;byte Colors;byte res;word Planes;word BitsPerPixel;dword ImageSize;dword ImageOffset", $pB_Input_IconHeader)
				Local $IconWidth = DllStructGetData($tB_Input_IconHeader, "Width")
				Local $IconHeight = DllStructGetData($tB_Input_IconHeader, "Height")
				Local $IconColors = DllStructGetData($tB_Input_IconHeader, "Colors")
				Local $IconPlanes = DllStructGetData($tB_Input_IconHeader, "Planes")
				Local $IconBitsPerPixel = DllStructGetData($tB_Input_IconHeader, "BitsPerPixel")
				Local $IconImageSize = DllStructGetData($tB_Input_IconHeader, "ImageSize")
				Local $IconImageOffset = DllStructGetData($tB_Input_IconHeader, "ImageOffset")
				$pB_IconGroupHeader = DllStructGetPtr($tB_IconGroupHeader, "rest") + ($x - 1) * 14
				Local $tB_GroupIcon = DllStructCreate("align 2;byte Width;byte Height;byte Colors;byte res;word Planes;word BitsPerPixel;dword ImageSize;word ResourceID", $pB_IconGroupHeader)
				DllStructSetData($tB_GroupIcon, "Width", $IconWidth)
				DllStructSetData($tB_GroupIcon, "Height", $IconHeight)
				DllStructSetData($tB_GroupIcon, "Colors", $IconColors)
				DllStructSetData($tB_GroupIcon, "res", 0)
				DllStructSetData($tB_GroupIcon, "Planes", $IconPlanes)
				DllStructSetData($tB_GroupIcon, "BitsPerPixel", $IconBitsPerPixel)
				DllStructSetData($tB_GroupIcon, "ImageSize", $IconImageSize)
				$IconResBase += 1
				DllStructSetData($tB_GroupIcon, "ResourceID", $IconResBase)
				Local $pB_IconData = DllStructGetPtr($tI_Input_Header) + $IconImageOffset
				DllCall("kernel32.dll", "int", "UpdateResourceW", "ptr", $hUpdate, "long", 3, "long", $IconResBase, "ushort", $RLanguage, "ptr", $pB_IconData, "dword", $IconImageSize)
				If @error <> 0 Then Return SetError(7, 0, 0)
			Next
			$pB_IconGroupHeader = DllStructGetPtr($tB_IconGroupHeader)
			DllCall("kernel32.dll", "int", "UpdateResourceW", "ptr", $hUpdate, "long", 14, $RName_Type, $RName, "ushort", 0, "ptr", $pB_IconGroupHeader, "dword", DllStructGetSize($tB_IconGroupHeader))
			If @error <> 0 Then Return SetError(8, 0, 0)
			Local $resendupdico = _WinAPI_EndUpdateResource_($hUpdate)
			If Not $resendupdico = 1 Then Return SetError(9, _WinAPI_GetLastError(), 0)
			Return $IconCount
	EndSwitch
EndFunc   ;==>_AddResBMPICO

Func _WinAPI_BeginUpdateResource_($sFile, $fDelete = 0)
	Local $Ret = DllCall('kernel32.dll', 'ptr', 'BeginUpdateResourceW', 'wstr', $sFile, 'int', $fDelete)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginUpdateResource_

Func _WinAPI_UpdateResource_($hUpdate, $sType, $sName, $iLanguage, $pData, $iSize)
	Local $TypeOfType = 'int', $TypeOfName = 'int'
	If IsString($sType) Then
		$TypeOfType = 'wstr'
	EndIf
	If IsString($sName) Then
		$TypeOfName = 'wstr'
	EndIf
	Local $Ret = DllCall('kernel32.dll', 'int', 'UpdateResourceW', 'ptr', $hUpdate, $TypeOfType, $sType, $TypeOfName, $sName, 'ushort', $iLanguage, 'ptr', $pData, 'dword', $iSize)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_UpdateResource_

Func _WinAPI_EndUpdateResource_($hUpdate, $fDiscard = 0)
	Local $Ret = DllCall('kernel32.dll', 'int', 'EndUpdateResourceW', 'ptr', $hUpdate, 'int', $fDiscard)
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_WinAPI_EndUpdateResource_