#include-once

Global Enum $nDict_BinaryCompare, $nDict_TextCompare
Global $oLast_Dict

;~ $oDict = _Dict_Init()

;~ _Dict_KeyAdd('c:\test', 'test1')
;~ _Dict_KeyAdd('C:\Test', 'test2')

;~ ConsoleWrite(_Dict_GetItemsCount() & @LF)

Func _Dict_Init($nCompare = $nDict_TextCompare)
	Local $oDict = ObjCreate('Scripting.Dictionary')
	
	If Not IsObj($oDict) Then
		Return SetError(1, 0, 0)
	EndIf
	
	If $nCompare <> -1 And Not IsKeyword($nCompare) Then
		_Dict_SetCompareMode($nCompare, $oDict)
	EndIf
	
	$oLast_Dict = $oDict
	
	Return $oDict
EndFunc

Func _Dict_SetCompareMode($nCompare = -1, $oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
	EndIf
	
	$oDict.CompareMode = $nCompare
	Return 1
EndFunc

Func _Dict_GetItemsCount($oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.Count()
EndFunc

Func _Dict_KeyAdd($sKey, $sItem, $oDict = -1, $bReplace = True)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	If $bReplace Then
		If _Dict_KeyExists($sKey, $oDict) Then
			_Dict_KeyRemove($sKey, $oDict)
		EndIf
	EndIf
	
	Return $oDict.Add($sKey, $sItem)
EndFunc

Func _Dict_KeyExists($sKey, $oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.Exists($sKey)
EndFunc

Func _Dict_GetItem($sKey, $oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.Item($sKey)
EndFunc

Func _Dict_GetItems($oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.Items()
EndFunc

Func _Dict_KeyRename($sOldKey, $sNewKey, $oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.Key($sOldKey) = $sNewKey
EndFunc

Func _Dict_GetKeys($oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.Keys()
EndFunc

Func _Dict_KeyRemove($sKey, $oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.Remove($sKey)
EndFunc

Func _Dict_RemoveAll($oDict = -1)
	If $oDict = -1 Or Not IsObj($oDict) Then
		$oDict = $oLast_Dict
		
		If Not IsObj($oDict) Then
			Return SetError(1, 0, 0)
		EndIf
	EndIf
	
	Return $oDict.RemoveAll()
EndFunc
