#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Change2CUI=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include "cURL.au3"
#include "cURLConstants.au3"

$sHeaders = ''
$sBody = ''

_cURL_Startup()

$hCURL = _cURL_Easy_Init()

_cURL_Easy_SetOpt($hCURL, $cURL_OPT_URL, "http://google.com/")
_cURL_Easy_SetOpt($hCURL, $cURL_OPT_FOLLOWLOCATION, 1)

Dim $aHeaders[2] = ['Header1: Value1', 'Header2: Value2']
_cURL_Easy_SetOpt($hCURL, $cURL_OPT_HTTPHEADER, $aHeaders)

_cURL_Easy_SetWriteFuncMode($hCURL)
$callb = DllCallbackRegister('cURL_CallBack', 'int', $cURL_tagCALLBACKARGS)

$structHeaders = DllStructCreate($cURL_tagCALLBACKDATA)
DllStructSetData($structHeaders, 'func', DllCallbackGetPtr($callb))
DllStructSetData($structHeaders, 'data', 1)
_cURL_Easy_SetOpt($hCURL, $cURL_OPT_HEADERDATA, DllStructGetPtr($structHeaders))

$structBody = DllStructCreate($cURL_tagCALLBACKDATA)
DllStructSetData($structBody, 'func', DllCallbackGetPtr($callb))
DllStructSetData($structBody, 'data', 2)
_cURL_Easy_SetOpt($hCURL, $cURL_OPT_WRITEDATA, DllStructGetPtr($structBody))

_cURL_Easy_Perform($hCURL)
_cURL_Easy_Cleanup($hCURL)

_cURL_Shutdown()

ConsoleWrite('Headers:' & @CRLF & $sHeaders & @CRLF & '-------------------------' & @CRLF & @CRLF)
ConsoleWrite('Body:' & @CRLF & $sBody & @CRLF)

Func cURL_CallBack($pAddr, $iSize, $iCount, $pExtra)
	$struct = DllStructCreate('char val[' & ($iSize * $iCount) & ']', $pAddr)
	If $pExtra = 1 Then $sHeaders &= DllStructGetData($struct, 'val')
	If $pExtra = 2 Then $sBody &= DllStructGetData($struct, 'val')
	$struct = 0
	Return $iSize * $iCount
EndFunc   ;==>cURL_CallBack

