#pragma compile(Out, ..\SMC.exe)
#pragma compile(Icon, Resources\Icon.ico)
#pragma compile(x64, False)
#pragma compile(ExecLevel, HighestAvailable)
#pragma compile(Compatibility, Win7)
#pragma compile(AutoItExecuteAllowed, True)
#pragma compile(Stripper, True)
#pragma compile(FileVersion, 1.4.0.0)
#pragma compile(ProductVersion, 1.4.0.0)
#pragma compile(ProductName, "SMC")
#pragma compile(FileDescription, "SMC - Show My Click (Visualize mouse click)")
#pragma compile(LegalCopyright, "Copyright  2015 G.Sandler (CreatoR), www.autoit-script.ru. All rights reserved.")
#pragma compile(CompanyName, "CreatoR's Lab")
#pragma compile(Comments, "Program made by G.Sandler")
#pragma compile(Sign, G.Sandler)

#Au3Stripper_Ignore_Funcs=_Settings_Show,_Exit

#Region Header

#NoTrayIcon

#CS
	Name:				SMC - Show My Click (Visualize mouse click)
	Author:				G.Sandler (CreatoR)
	AutoIt version:		3.3.10.2+
	
	History:
						1.4
						* Inputs replaced with sliders.
						* Minor fixes.
						
						1.3
						+ Added Tray Icon (optionaly).
						* Changed default Exit hotKey to CTRL + ALT + Q.
						
						1.2
						* Now when option "Hide circle on mouse move" is unset, the click circle will follow mouse pointer untill it's released.
						
						1.1
						* Changed mouse events method (hooks replaced with RawInput, thanks to Yashied).
						* Changed default hotkeys:
							Settings HotKey is SHIFT + P.
							Exit HotKey is CTRL + ALT + E.
						+ Added option to disable "click show" on mouse move.
						+ Added option to disable SMC functionality.
						
						1.0
						* First public version.
	
#CE

#include <GUIConstantsEx.au3>
#include <EditConstants.au3>
#include <TrayConstants.au3>
#include <Misc.au3>
#include <Sound.au3>
#include <WinAPISys.au3>

#include <Includes\Hotkey.au3>
#include <Includes\HotkeyInput.au3>

#EndRegion

#Region Global Vars

Global $sApp_Name 				= _GetResData('FileDescription')
Global $sConfig_File 			= StringTrimRight(@ScriptFullPath, 3) & 'ini'
Global $sSound_File 			= @TempDir & '\Click.mp3'
Global $fClick 					= False
Global $fClickReleased 			= False
Global $fDblClick 				= False
Global $iDblClckTimer 			= 0

Global _
		$hSettings_GUI, _
		$iEnable_CB, $iShowTrayIcon_CB, $iPlaySound_CB, $iHideOnMove_CB, $iCircleThick_Slider, $iCircleSize_Slider, $iCircleSize_Slider, $iCircleDuration_Slider, _
		$iCircleColor_Bttn, $iTransparency_Slider, $iSettings_HK, $iExit_HK, $iOk_Bttn, $iCancel_Bttn

Global $iMainCircle_Graphic 	= 0
Global $iDblClckCircle_Graphic 	= 0
Global $iDblClckTime 			= _MouseGetDoubleClickTime()
Global $iClicksCount 			= 0

Global $ahSounds[1]				= [0]

;RawInput Vars
Global Const $tagRAWINPUT_MOUSE = $tagRAWINPUTHEADER & $tagRAWMOUSE
Global $iRI_HeaderStructSize 	= 0

Global $fDef_Enable 			= 'True'
Global $fDef_ShowTrayIcon 		= 'True'
Global $fDef_PlaySound 			= 'True'
Global $fDef_HideOnMove 		= 'False'
Global $iDef_Thickness 			= 3
Global $iDef_Size 				= 30
Global $iDef_Duration 			= 50
Global $nDef_Color 				= 0xFF8080
Global $iDef_Transparency 		= 255 ;Set Lower for transparency
Global $iDef_SettingsHotKey		= BitOR($CK_SHIFT, $VK_P)
Global $iDef_ExitHotKey			= BitOR($CK_CONTROL, $CK_ALT, $VK_Q)

Global $fEnable 				= (IniRead($sConfig_File, 'Prefs', 'Enable', $fDef_Enable) = 'True')
Global $fShowTrayIcon 			= (IniRead($sConfig_File, 'Prefs', 'Show Tray Icon', $fDef_ShowTrayIcon) = 'True')
Global $fPlaySound 				= (IniRead($sConfig_File, 'Prefs', 'Play Sound', $fDef_PlaySound) = 'True')
Global $fHideOnMove 			= (IniRead($sConfig_File, 'Prefs', 'Hide On Move', $fDef_HideOnMove) = 'True')
Global $iThickness 				= IniRead($sConfig_File, 'Prefs', 'Thickness', $iDef_Thickness)
Global $iSize 					= IniRead($sConfig_File, 'Prefs', 'Size', $iDef_Size)
Global $iDuration 				= IniRead($sConfig_File, 'Prefs', 'Duration', $iDef_Duration)
Global $nColor 					= IniRead($sConfig_File, 'Prefs', 'Color', $nDef_Color)
Global $iTransparency 			= IniRead($sConfig_File, 'Prefs', 'Transparency', $iDef_Transparency)

Global $iSettings_HotKey 		= IniRead($sConfig_File, 'HotKeys', 'Settings', $iDef_SettingsHotKey)
Global $iExit_HotKey 			= IniRead($sConfig_File, 'HotKeys', 'Exit', $iDef_ExitHotKey)

#EndRegion Global Vars

#Region Initialization

If WinExists('[CLASS:AutoIt v3;TITLE:~' & $sApp_Name & '~]') Then
	Exit
EndIf

AutoItWinSetTitle('~' & $sApp_Name & '~')

FileInstall('Resources\Click.mp3', $sSound_File, 1)

Opt('GUIOnEventMode', 1)
Opt('GUICloseOnESC', 0)
Opt('TrayMenuMode', 3)
Opt('TrayOnEventMode', 1)

TraySetClick(16)

$iSettings_TrayItem = TrayCreateItem('Settings	(' & _KeyToStr($iSettings_HotKey) & ')')
TrayItemSetOnEvent($iSettings_TrayItem, '_Settings_Show')
TrayItemSetState($iSettings_TrayItem, $TRAY_DEFAULT)
TrayCreateItem('')
$iExit_TrayItem = TrayCreateItem('Exit	(' & _KeyToStr($iExit_HotKey) & ')')
TrayItemSetOnEvent($iExit_TrayItem, '_Exit')

If $fShowTrayIcon Then
	TraySetState($TRAY_ICONSTATE_SHOW)
	TraySetToolTip($sApp_Name)
EndIf

_HotKeyAssign($iSettings_HotKey, '_Settings_Show')
_HotKeyAssign($iExit_HotKey, '_Exit')

#EndRegion Initialization

#Region GUI

$hCircle_GUI = GUICreate($sApp_Name, $iSize, $iSize, 0, 0, $WS_POPUP, BitOR($WS_EX_TOPMOST, $WS_EX_TOOLWINDOW, $WS_EX_TRANSPARENT, $WS_EX_LAYERED))
GUISetBkColor(0xABCDEF, $hCircle_GUI)
_WinAPI_SetLayeredWindowAttributes($hCircle_GUI, 0xABCDEF, $iTransparency)

_Circle_Create()
_Settings_Create()
_RawInput_Init()

#EndRegion GUI

While 1
	If $iDblClckTimer And TimerDiff($iDblClckTimer) > $iDblClckTime Then
		$iDblClckTimer = 0
		$iClicksCount = 0
	EndIf
	
	If $iClicksCount > 2 Then
		$iClicksCount = 0
	EndIf
	
	If $fClick Then
		$fClick = False
		$fDblClick = False
		
		Switch $iClicksCount
			Case 1
				$iDblClckTimer = TimerInit()
			Case 2
				If TimerDiff($iDblClckTimer) <= $iDblClckTime Then
					$fDblClick = True
				EndIf
		EndSwitch
		
		If $iDblClckCircle_Graphic Then
			If $fDblClick Then
				GUICtrlSetState($iDblClckCircle_Graphic, $GUI_SHOW)
			Else
				GUICtrlSetState($iDblClckCircle_Graphic, $GUI_HIDE)
			EndIf
		EndIf
		
		If $fPlaySound Then
			$ahSounds[0] += 1
			ReDim $ahSounds[$ahSounds[0] + 1]
			$ahSounds[$ahSounds[0]] = _SoundOpen($sSound_File)
			
			_SoundPlay($ahSounds[$ahSounds[0]])
			
			If $ahSounds[0] = 1 Then
				AdlibRegister('_CheckSoundPlay', 100)
			EndIf
		EndIf
		
		_Circle_Move()
		GUISetState(@SW_SHOWNA, $hCircle_GUI)
		
		If $fHideOnMove Then
			$iTimer = TimerInit()
			
			While TimerDiff($iTimer) < $iDuration
				Sleep(10)
				
				If $fClickReleased Then
					ExitLoop
				EndIf
			WEnd
			
			GUISetState(@SW_HIDE, $hCircle_GUI)
		EndIf
	EndIf
	
	If $fClickReleased Then
		$fClickReleased = False
		GUISetState(@SW_HIDE, $hCircle_GUI)
	EndIf
	
	Sleep(10)
WEnd

Func _CheckSoundPlay()
	For $i = 1 To $ahSounds[0]
		If _SoundStatus($ahSounds[$i]) <> 'playing' Then
			_SoundClose($ahSounds[$i])
			Local $aTmp[1] = [0]
			
			For $y = 1 To $ahSounds[0]
				If $y <> $i Then
					$aTmp[0] += 1
					ReDim $aTmp[$aTmp[0] + 1]
					$aTmp[$aTmp[0]] = $ahSounds[$y]
				EndIf
			Next
			
			$ahSounds = $aTmp
			ExitLoop
		EndIf
	Next
	
	If $ahSounds[0] = 0 Then
		AdlibUnRegister('_CheckSoundPlay')
	EndIf
EndFunc

Func _Circle_Create()
	GUISwitch($hCircle_GUI)
	
	If $iMainCircle_Graphic Then
		GUICtrlDelete($iMainCircle_Graphic)
		GUICtrlDelete($iDblClckCircle_Graphic)
	EndIf
	
	$iMainCircle_Graphic = GUICtrlCreateGraphic(0, 0, $iSize - ($iThickness + 2), $iSize - ($iThickness + 2))
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlSetGraphic(-1, $GUI_GR_PENSIZE, $iThickness)
	GUICtrlSetGraphic(-1, $GUI_GR_COLOR, $nColor)
	GUICtrlSetGraphic(-1, $GUI_GR_ELLIPSE, ($iThickness + 2) + 2, ($iThickness + 2) + 2, $iSize - ((($iThickness + 2) + 2) * 2), $iSize - ((($iThickness + 2) + 2) * 2))
	
	$iDblClckCircle_Graphic = GUICtrlCreateGraphic(0, 0, $iSize, $iSize)
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlSetGraphic(-1, $GUI_GR_PENSIZE, $iThickness)
	GUICtrlSetGraphic(-1, $GUI_GR_COLOR, $nColor)
	GUICtrlSetGraphic(-1, $GUI_GR_ELLIPSE, 2, 2, $iSize - 4, $iSize - 4)
	GUICtrlSetState(-1, $GUI_HIDE)
EndFunc

Func _Circle_Move()
	Local $aMPos = MouseGetPos()
	WinMove($hCircle_GUI, '', $aMPos[0] - ($iSize / 2), $aMPos[1] - ($iSize / 2), $iSize, $iSize)
EndFunc

Func _Settings_Create()
	Local $iColor, $iWidth = 400, $iHeight = 450
	Local $iFirst_ID, $iLast_ID
	
	$hSettings_GUI = GUICreate($sApp_Name, $iWidth, $iHeight)
	
	$iFirst_ID = GUICtrlCreateDummy() + 1
	
	$iEnable_CB = GUICtrlCreateCheckbox('Enable SMC', 20, 10)
	GUICtrlSetState($iEnable_CB, ($fEnable ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	$iShowTrayIcon_CB = GUICtrlCreateCheckbox('Show tray icon', 20, 35)
	GUICtrlSetState($iShowTrayIcon_CB, ($fShowTrayIcon ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	$iPlaySound_CB = GUICtrlCreateCheckbox('Play click sound', 20, 60)
	GUICtrlSetState($iPlaySound_CB, ($fPlaySound ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	$iHideOnMove_CB = GUICtrlCreateCheckbox('Hide circle on mouse move', 20, 85)
	GUICtrlSetState($iHideOnMove_CB, ($fHideOnMove ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	GUICtrlCreateLabel('Thickness:', 20, 140)
	GUICtrlCreateLabel('1', 155, 142)
	GUICtrlSetFont(-1, 8)
	$iCircleThick_Slider = GUICtrlCreateSlider(170, 142, $iWidth - 210, 20)
	GUICtrlSetLimit($iCircleThick_Slider, 9, 1)
	GUICtrlSetData($iCircleThick_Slider, $iThickness)
	GUICtrlCreateLabel('9', $iWidth - 40, 142)
	GUICtrlSetFont(-1, 8)
	
	GUICtrlCreateLabel('Size:', 20, 165)
	GUICtrlCreateLabel('15', 155, 167)
	GUICtrlSetFont(-1, 8)
	$iCircleSize_Slider = GUICtrlCreateSlider(170, 167, $iWidth - 210, 20)
	GUICtrlSetLimit($iCircleSize_Slider, 30, 15)
	GUICtrlSetData($iCircleSize_Slider, $iSize)
	GUICtrlCreateLabel('30', $iWidth - 40, 167)
	GUICtrlSetFont(-1, 8)
	
	GUICtrlCreateLabel('Duration (ms):', 20, 192)
	GUICtrlCreateLabel('10', 155, 194)
	GUICtrlSetFont(-1, 8)
	$iCircleDuration_Slider = GUICtrlCreateSlider(170, 194, $iWidth - 210, 20)
	GUICtrlSetLimit($iCircleDuration_Slider, 1000, 10)
	GUICtrlSetData($iCircleDuration_Slider, $iDuration)
	GUICtrlCreateLabel('1000', $iWidth - 40, 194)
	GUICtrlSetFont(-1, 8)
	
	GUICtrlCreateLabel('Click circle color:', 20, 233)
	$iCircleColor_Bttn = GUICtrlCreateButton('', 150, 230, 20, 20)
	GUICtrlSetBkColor($iCircleColor_Bttn, $nColor)
	
	GUICtrlCreateLabel('Click circle Transparency:', 20, 270)
	GUICtrlCreateLabel('20', 155, 272)
	GUICtrlSetFont(-1, 8)
	$iTransparency_Slider = GUICtrlCreateSlider(170, 271, $iWidth - 210, 20)
	GUICtrlSetLimit($iTransparency_Slider, 255, 20)
	GUICtrlSetData($iTransparency_Slider, $iTransparency)
	GUICtrlCreateLabel('255', $iWidth - 40, 272)
	GUICtrlSetFont(-1, 8)
	
	GUICtrlCreateLabel('Settings HotKey:', 20, $iHeight - 100)
	$iSettings_HK = _GUICtrlCreateHotkeyInput(Int($iSettings_HotKey), 120, $iHeight - 102, $iWidth - 140, 20)
	
	GUICtrlCreateLabel('Exit HotKey:', 20, $iHeight - 70)
	$iExit_HK = _GUICtrlCreateHotkeyInput(Int($iExit_HotKey), 120, $iHeight - 72, $iWidth - 140, 20)
	
	_KeyLock(0x062E) ; Lock CTRL-ALT-DEL for Hotkey Input control, but not for Windows
	
	$iOk_Bttn = GUICtrlCreateButton('OK', 20, $iHeight - 30, 70, 20)
	$iCancel_Bttn = GUICtrlCreateButton('Cancel', 100, $iHeight - 30, 70, 20)
	
	$iLast_ID = GUICtrlCreateDummy() - 1
	
	GUISetOnEvent($GUI_EVENT_CLOSE, '_Settings_Events', $hSettings_GUI)
	
	For $iID = $iFirst_ID To $iLast_ID
		GUICtrlSetOnEvent($iID, '_Settings_Events')
	Next
EndFunc

Func _Settings_Show()
	If BitAND(WinGetState($hSettings_GUI), 2) Then
		WinActivate($hSettings_GUI)
	Else
		GUISetState(@SW_SHOW, $hSettings_GUI)
	EndIf
EndFunc

Func _Settings_Events()
	Switch @GUI_CtrlId
		Case $iOk_Bttn
			$i_Settings_HotKey = _GUICtrlReadHotKeyInput($iSettings_HK)
			$i_Exit_HotKey = _GUICtrlReadHotKeyInput($iExit_HK)
			
			If $i_Settings_HotKey = $i_Exit_HotKey Then
				MsgBox(48, 'Attention', 'Hotkeys can not be identical', 0, $hSettings_GUI)
				Return
			EndIf
			
			GUISetState(@SW_HIDE, $hSettings_GUI)
			
			$iSettings_HotKey = $i_Settings_HotKey
			$iExit_HotKey = $i_Exit_HotKey
			
			_HotKeyRelease()
			
			_HotKeyAssign($iSettings_HotKey, '_Settings_Show')
			_HotKeyAssign($iExit_HotKey, '_Exit')
			
			TrayItemSetText($iSettings_TrayItem, 'Settings	(' & _KeyToStr($iSettings_HotKey) & ')')
			TrayItemSetText($iExit_TrayItem, 'Exit	(' & _KeyToStr($iExit_HotKey) & ')')
			TraySetState(($fShowTrayIcon ? $TRAY_ICONSTATE_SHOW : $TRAY_ICONSTATE_HIDE))
			
			IniWrite($sConfig_File, 'Prefs', 'Enable', $fEnable)
			IniWrite($sConfig_File, 'Prefs', 'Show Tray Icon', $fShowTrayIcon)
			IniWrite($sConfig_File, 'Prefs', 'Play Sound', $fPlaySound)
			IniWrite($sConfig_File, 'Prefs', 'Hide On Move', $fHideOnMove)
			IniWrite($sConfig_File, 'Prefs', 'Thickness', $iThickness)
			IniWrite($sConfig_File, 'Prefs', 'Size', $iSize)
			IniWrite($sConfig_File, 'Prefs', 'Duration', $iDuration)
			IniWrite($sConfig_File, 'Prefs', 'Color', $nColor)
			IniWrite($sConfig_File, 'Prefs', 'Transparency', $iTransparency)
			
			IniWrite($sConfig_File, 'HotKeys', 'Settings', $iSettings_HotKey)
			IniWrite($sConfig_File, 'HotKeys', 'Exit', $iExit_HotKey)
		Case $GUI_EVENT_CLOSE, $iCancel_Bttn
			GUISetState(@SW_HIDE, $hSettings_GUI)
			
			$fEnable = (IniRead($sConfig_File, 'Prefs', 'Enable', $fDef_Enable) = 'True')
			$fShowTrayIcon = (IniRead($sConfig_File, 'Prefs', 'Show Tray Icon', $fDef_ShowTrayIcon) = 'True')
			$fPlaySound = (IniRead($sConfig_File, 'Prefs', 'Play Sound', $fDef_PlaySound) = 'True')
			$fHideOnMove = (IniRead($sConfig_File, 'Prefs', 'Hide On Move', $fDef_HideOnMove) = 'True')
			$iThickness = IniRead($sConfig_File, 'Prefs', 'Thickness', $iDef_Thickness)
			$iSize = IniRead($sConfig_File, 'Prefs', 'Size', $iDef_Size)
			$iDuration = IniRead($sConfig_File, 'Prefs', 'Duration', $iDef_Duration)
			$nColor = IniRead($sConfig_File, 'Prefs', 'Color', $nDef_Color)
			$iTransparency = IniRead($sConfig_File, 'Prefs', 'Transparency', $iDef_Transparency)
			
			GUICtrlSetState($iEnable_CB, ($fEnable ? $GUI_CHECKED : $GUI_UNCHECKED))
			GUICtrlSetState($iShowTrayIcon_CB, ($fShowTrayIcon ? $GUI_CHECKED : $GUI_UNCHECKED))
			GUICtrlSetState($iPlaySound_CB, ($fPlaySound ? $GUI_CHECKED : $GUI_UNCHECKED))
			GUICtrlSetState($iHideOnMove_CB, ($fHideOnMove ? $GUI_CHECKED : $GUI_UNCHECKED))
			GUICtrlSetData($iCircleThick_Slider, $iThickness)
			GUICtrlSetData($iCircleSize_Slider, $iSize)
			GUICtrlSetData($iCircleDuration_Slider, $iDuration)
			GUICtrlSetBkColor($iCircleColor_Bttn, $nColor)
			GUICtrlSetData($iTransparency_Slider, $iTransparency)
			
			_GUICtrlSetHotKeyInput($iSettings_HK, Int($iSettings_HotKey))
			_GUICtrlSetHotKeyInput($iExit_HK, Int($iExit_HotKey))
			
			_WinAPI_SetLayeredWindowAttributes($hCircle_GUI, 0xABCDEF, $iTransparency)
		Case $iEnable_CB
			$fEnable = (GUICtrlRead($iEnable_CB) = $GUI_CHECKED)
		Case $iShowTrayIcon_CB
			$fShowTrayIcon = (GUICtrlRead($iShowTrayIcon_CB) = $GUI_CHECKED)
		Case $iHideOnMove_CB
			$fHideOnMove = (GUICtrlRead($iHideOnMove_CB) = $GUI_CHECKED)
		Case $iPlaySound_CB
			$fPlaySound = (GUICtrlRead($iPlaySound_CB) = $GUI_CHECKED)
		Case $iCircleThick_Slider
			$iThickness = GUICtrlRead($iCircleThick_Slider)
		Case $iCircleSize_Slider
			$iSize = GUICtrlRead($iCircleSize_Slider)
		Case $iCircleDuration_Slider
			$iDuration = GUICtrlRead($iCircleDuration_Slider)
		Case $iCircleColor_Bttn
			GUISetState(@SW_HIDE, $hCircle_GUI)
			Local $iColor = _ChooseColor(2, $nColor, 2, $hSettings_GUI)
			
			If Not @error Then
				$nColor = $iColor
				GUICtrlSetBkColor($iCircleColor_Bttn, $nColor)
			EndIf
		Case $iTransparency_Slider
			$iTransparency = GUICtrlRead($iTransparency_Slider)
			_WinAPI_SetLayeredWindowAttributes($hCircle_GUI, 0xABCDEF, $iTransparency)
			Return
	EndSwitch
	
	_Circle_Create()
EndFunc

Func _GetResData($sRes)
	If @Compiled Then
		Return FileGetVersion(@AutoItExe, $sRes)
	EndIf
	
	Local $sRet = StringRegExpReplace(FileRead(@ScriptFullPath), '(?si)^.*?#pragma compile\(' & $sRes & ', [''"]?(.*?)[''"]?\)\r\n.*$', '\1')
	
	If @extended = 0 Then
		$sRet = StringRegExpReplace(FileRead(@ScriptFullPath), '(?si)^.*?#AutoIt3Wrapper_Res_' & $sRes & '=([^\r\n]+).*$', '\1')
		
		If @extended = 0 Then
			Return $sRes
		EndIf
	EndIf
	
	Return StringStripWS($sRet, 3)
EndFunc

Func _MouseGetDoubleClickTime()
	Local $sRet = RegRead('HKEY_CURRENT_USER\Control Panel\Mouse', 'DoubleClickSpeed')
	Local $aGDCT = DllCall('User32.dll', 'uint', 'GetDoubleClickTime')
	
	If Not @error And $aGDCT[0] > 0 Then
		$sRet = $aGDCT[0]
	EndIf
	
	Return $sRet
EndFunc

Func _RawInput_Init()
	; To obtain the values of "UsagePage" and "Usage" members of this structure read HID Usage Tables documentation
	; http://www.usb.org/developers/devclass_docs/HID1_11.pdf
	
	Local $tRID, $pRID
	
	$tRID = DllStructCreate($tagRAWINPUTDEVICE)
	DllStructSetData($tRID, 'UsagePage', 0x01) ; Generic Desktop Controls
	DllStructSetData($tRID, 'Usage', 0x02) ; Mouse
	DllStructSetData($tRID, 'Flags', $RIDEV_INPUTSINK)
	DllStructSetData($tRID, 'hTarget', $hCircle_GUI)
	$pRID = DllStructGetPtr($tRID)
	
	; Register HID input to obtain row input from mice
	_WinAPI_RegisterRawInputDevices($pRID)
	
	; Register WM_INPUT message
	GUIRegisterMsg($WM_INPUT, '_RawInput_WM_INPUT')
EndFunc

Func _RawInput_WM_INPUT($hWnd, $iMsg, $wParam, $lParam)
	If Not $fEnable Then
		Return $GUI_RUNDEFMSG
	EndIf
	
	Local $tRIM = DllStructCreate($tagRAWINPUTMOUSE)
	
	If _WinAPI_GetRawInputData($lParam, DllStructGetPtr($tRIM), DllStructGetSize($tRIM), $RID_INPUT) Then
		Local $iFlags = DllStructGetData($tRIM, 'ButtonFlags')
		
		Select
			Case BitAND($iFlags, $RI_MOUSE_LEFT_BUTTON_DOWN)
				$iClicksCount += 1
				$fClick = True
				$fClickReleased = False
				
				If $iClicksCount = 2 And $iDblClckTimer = 0 Then
					$iDblClckTimer = TimerInit()
				EndIf
			Case BitAND($iFlags, $RI_MOUSE_LEFT_BUTTON_UP)
				$fClickReleased = True
			Case BitAND($iFlags, $RI_MOUSE_RIGHT_BUTTON_DOWN)
				
			Case BitAND($iFlags, $RI_MOUSE_RIGHT_BUTTON_UP)
				
			Case BitAND($iFlags, $RI_MOUSE_MIDDLE_BUTTON_DOWN)
				
			Case BitAND($iFlags, $RI_MOUSE_MIDDLE_BUTTON_UP)
				
			Case BitAND($iFlags, $RI_MOUSE_WHEEL)
				
			Case Else ;Mouse move?
				If $fHideOnMove Then
					GUISetState(@SW_HIDE, $hCircle_GUI)
				Else
					_Circle_Move()
				EndIf
		EndSelect
	EndIf
	
	Return $GUI_RUNDEFMSG
EndFunc

Func _Exit()
	FileDelete($sSound_File)
	Exit
EndFunc
