#NoTrayIcon

Global Const $Gui = GUICreate('    - ',400,300,-1,-1)

GUICtrlCreateLabel(' :',20,25,75,20)
Global Const $InputUrl = GUICtrlCreateInput('www.yandex.ru',100,20,280,20)

GUICtrlCreateLabel('- :   _________________________________',20,60,300,20)
Global Const $InputAmount = GUICtrlCreateInput('100',330,55,50,20,0x2000+0x01)
Global Const $UpdownAmount = GUICtrlCreateUpdown($InputAmount)
GUICtrlSetLimit($UpdownAmount,999,1)

GUICtrlCreateLabel('    (.):   ____________________',20,95,300,20)
Global Const $InputTimeOut = GUICtrlCreateInput('1',330,90,50,20,0x2000+0x01)
Global Const $UpdownTimeOut = GUICtrlCreateUpdown($InputTimeOut)
GUICtrlSetLimit($UpdownTimeOut,10,1)

Global Const $EditConsole = GUICtrlCreateEdit('',20,125,360,120)

Global Const $ButtonStart = GUICtrlCreateButton('',180,260,100,25)
Global Const $ButtonCancel = GUICtrlCreateButton('',280,260,100,25)

GUISetState(@SW_SHOW,$Gui)

While 1
   Switch GUIGetMsg()
	  Case -3, $ButtonCancel
		 ExitLoop
	  Case $ButtonStart
		 CheckPing()
   EndSwitch
WEnd

Func CheckPing()
   ShowHideButtons(0)
   Local $Url = GUICtrlRead($InputUrl)
   If $Url = '' Then
	  GUICtrlSetData($EditConsole,'  .','')
	  ShowHideButtons(1)
	  Return 0
   EndIf
   Local $TimeOut = GUICtrlRead($InputTimeOut)*1000
   If Ping($Url,$TimeOut) = 0 Then
	  GUICtrlSetData($EditConsole,'        .','')
	  ShowHideButtons(1)
	  Return 0
   EndIf
   Local $Amount = GUICtrlRead($InputAmount)
   Local $MinPing, $MaxPing, $BufferPing, $Ping, $a
   $MinPing = $TimeOut
   GUICtrlSetData($EditConsole,' : '&@HOUR&':'&@MIN&':'&@SEC&' .'&@MSEC&' .'&@CRLF&@CRLF,'')
   For $a = 1 To $Amount
	  $Ping = Ping($Url,$TimeOut)
	  If $Ping = 0 Then
		 GUICtrlSetData($EditConsole,'  '&$a&': '&$TimeOut&' .'&@CRLF,' ')
		 $BufferPing += $TimeOut
		 $MaxPing = $TimeOut
	  Else
		 GUICtrlSetData($EditConsole,'  '&$a&': '&$Ping&' .'&@CRLF,' ')
		 $BufferPing += $Ping
		 If $Ping > $MaxPing Then
			$MaxPing = $Ping
		 ElseIf $Ping < $MinPing Then
			$MinPing = $Ping
		 EndIf
	  EndIf
	  Switch GUIGetMsg()
		 Case -3, $ButtonCancel
			Exit
		 Case $ButtonStart
			GUICtrlSetData($EditConsole,'  .','')
			ShowHideButtons(1)
			Return 0
	  EndSwitch
   Next
   GUICtrlSetData($EditConsole,@CRLF&' : '&@HOUR&':'&@MIN&':'&@SEC&' .'&@MSEC&' .'&@CRLF&@CRLF,' ')
   GUICtrlSetData($EditConsole,' : '&$MaxPing&' .'&@CRLF&' : '&Round($BufferPing/$Amount)&' .'&@CRLF&' : '&$MinPing&' .',' ')
   ShowHideButtons(1)
EndFunc

Func ShowHideButtons($Key=1)
   If $Key = 0 Then
	  GUICtrlSetState($InputUrl,128)
	  GUICtrlSetState($InputAmount,128)
	  GUICtrlSetState($UpdownAmount,128)
	  GUICtrlSetState($InputTimeOut,128)
	  GUICtrlSetState($UpdownTimeOut,128)
	  GUICtrlSetState($EditConsole,128)
	  GUICtrlSetData($ButtonStart,'')
   Else
	  GUICtrlSetState($InputUrl,64)
	  GUICtrlSetState($InputAmount,64)
	  GUICtrlSetState($UpdownAmount,64)
	  GUICtrlSetState($InputTimeOut,64)
	  GUICtrlSetState($UpdownTimeOut,64)
	  GUICtrlSetState($EditConsole,64)
	  GUICtrlSetData($ButtonStart,'')
   EndIf
EndFunc
