#pragma compile(Icon, wInformer.ico)
#pragma compile(UPX, false)
#pragma compile(FileVersion, 1.3.0.0)
#AutoIt3Wrapper_Run_Au3Stripper=Y
#AutoIt3Wrapper_Run_After=del wInformer_stripped.au3
#AutoIt3Wrapper_Res_HiDpi=Y

#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#include <EditConstants.au3>
#include <GuiConstantsEx.au3>
#include <Misc.au3>
#include <WinAPISys.au3>
#include <GuiTreeView.au3>
#include <ScreenCapture.au3>
#include "MultiMon.au3"

#NoTrayIcon

Opt("WinWaitDelay", 0)
Opt("GUIResizeMode", $GUI_DOCKALL)

Global $RegKey = "HKCU\Software\SoftInnI\wInformer"
Global $PrevCurPos[2] = [-1], $CursorPos[2] = [0], $ParentWnd = -1, $CurrentWnd = -1, $WndRect
Global $PixelColor, $FrameColor, $WinVisibleText, $WinHiddenText, $ForHierarchy = 0
Global $WindowInfo[9][3] = [[""," Title : ",""],[""," Class : ",""],[""," Position : ",""],[""," Size : ",""],[""," Client Size : ",""], _
                            [""," Style : ",""],[""," ExStyle : ",""],[""," Handle : ",""],[""," PID : ",""]]
Global $ControlInfo[13][3] = [[""," Class : ",""],[""," Instance : ",""],[""," ClassnameNN : ",""],[""," ID : ",""],[""," Text : ",""], _
                              [""," Position : ",""],[""," Size : ",""],[""," ControlClick : ",""],[""," Style : ",""],[""," ExStyle : ",""], _
                              [""," Handle : ",""],[""," IsVisible : ",""],[""," IsEnabled : ",""]]
Global $MouseInfo[6][3] = [[""," Position (screen) : ",""],[""," Position (window) : ",""],[""," Position (client) : ",""], _
                           [""," Pixel Color (hex) : ",""],[""," Pixel Color (dec) : ",""],[""," Cursor ID : ",""]]
Global $Hints[4][2] = [[""," win+shift - lock info"],[""," win+ctrl - screenshot"],[""," ctrl down - tooltip on/off"], _
                       [""," shift down - frame on/off"]]
Global $Checked[4 + UBound($WindowInfo, 1) + UBound($ControlInfo, 1) + UBound($MouseInfo, 1) + UBound($Hints)]

DllCall("User32.dll", "bool", "SetProcessDPIAware")
Global $Scale = RegRead("HKCU\Control Panel\Desktop\WindowMetrics", "AppliedDPI") / 96
If @error Or $Scale < 1 Then $Scale = 1

$GUI = GUICreate("wInformer", 280 * $Scale, 500 * $Scale)
$BtnStart = GUICtrlCreateButton("START   ( Stop : Win+Shift )", 5 * $Scale, 5 * $Scale, 235 * $Scale, 30 * $Scale)
GUICtrlSetFont(-1, 10, 700)
$BtnConfig = GUICtrlCreateButton(">>", 245 * $Scale, 5 * $Scale, 30 * $Scale, 30 * $Scale)
$TreeView = GUICtrlCreateTreeView(5 * $Scale, 40 * $Scale, 270 * $Scale, 455 * $Scale, BitOR($GUI_SS_DEFAULT_TREEVIEW, $TVS_CHECKBOXES), $WS_EX_CLIENTEDGE)
$iWindow = GUICtrlCreateTreeViewItem(" Window Info", $TreeView)
For $i = 0 To UBound($WindowInfo, 1) - 1
  $WindowInfo[$i][0] = GUICtrlCreateTreeViewItem($WindowInfo[$i][1], $iWindow)
Next
$iControl = GUICtrlCreateTreeViewItem(" Control Info", $TreeView)
For $i = 0 To UBound($ControlInfo, 1) - 1
  $ControlInfo[$i][0] = GUICtrlCreateTreeViewItem($ControlInfo[$i][1], $iControl)
Next
$iMouse = GUICtrlCreateTreeViewItem(" Mouse Info", $TreeView)
For $i = 0 To UBound($MouseInfo, 1) - 1
  $MouseInfo[$i][0] = GUICtrlCreateTreeViewItem($MouseInfo[$i][1], $iMouse)
Next
$iHint = GUICtrlCreateTreeViewItem(" Hints", $TreeView)
For $i = 0 To UBound($Hints, 1) - 1
  $Hints[$i][0] = GUICtrlCreateTreeViewItem($Hints[$i][1], $iHint)
Next
GUICtrlCreateGroup(" Settings ", 285 * $Scale, 5 * $Scale, 170 * $Scale, 490 * $Scale)
$ChkOnTop = GUICtrlCreateCheckbox("Always On Top", 295 * $Scale, 25 * $Scale, 150 * $Scale, 20 * $Scale)
$ChkTooltip = GUICtrlCreateCheckbox("Show Tooltip *", 295 * $Scale, 50 * $Scale, 150 * $Scale, 20 * $Scale)
$ChkFrame = GUICtrlCreateCheckbox("Show Frame", 295 * $Scale, 75 * $Scale, 150 * $Scale, 20 * $Scale)
$ChkMagnifier = GUICtrlCreateCheckbox("Show Magnifier", 295 * $Scale, 100 * $Scale, 150 * $Scale, 20 * $Scale)
$ChkHidden = GUICtrlCreateCheckbox("Search Hidden Controls", 295 * $Scale, 125 * $Scale, 150 * $Scale, 20 * $Scale)
$ChkOnRun = GUICtrlCreateCheckbox("Start On Run", 295 * $Scale, 150 * $Scale, 150 * $Scale, 20 * $Scale)
$ChkIntoSciTE = GUICtrlCreateCheckbox("DblClick Paste Into SciTE", 295 * $Scale, 175 * $Scale, 150 * $Scale, 20 * $Scale)
$LblColor = GUICtrlCreateLabel("", 295 * $Scale, 210 * $Scale, 30 * $Scale, 20 * $Scale, -1, $WS_EX_CLIENTEDGE)
GUICtrlCreateLabel("Frame Color", 330 * $Scale, 210 * $Scale, 115 * $Scale, 20 * $Scale, $SS_CENTERIMAGE)
$InpThickness = GUICtrlCreateInput("", 295 * $Scale, 240 * $Scale, 30 * $Scale, 20 * $Scale, $ES_READONLY)
GUICtrlCreateUpdown($InpThickness)
GUICtrlSetLimit(-1, 9, 1)
GUICtrlCreateLabel("Frame Thickness", 330 * $Scale, 240 * $Scale, 115 * $Scale, 20 * $Scale, $SS_CENTERIMAGE)
$InpOffset = GUICtrlCreateInput("", 295 * $Scale, 270 * $Scale, 30 * $Scale, 20 * $Scale, BitOR($ES_NUMBER, $ES_CENTER))
GUICtrlCreateLabel("Tooltip Offset", 330 * $Scale, 270 * $Scale, 115 * $Scale, 20 * $Scale, $SS_CENTERIMAGE)
GUICtrlCreateLabel("Screenshot Filename", 295 * $Scale, 300 * $Scale, 150 * $Scale, 20 * $Scale, $SS_CENTERIMAGE)
$InpScrName = GUICtrlCreateInput("", 295 * $Scale, 320 * $Scale, 100 * $Scale, 20 * $Scale)
$CmbScrExt = GUICtrlCreateCombo("", 395 * $Scale, 320 * $Scale, 50 * $Scale, 20 * $Scale, 0x3) ; $CBS_DROPDOWNLIST
GUICtrlCreateLabel("* only checked treeview items will be shown in tooltip", 295 * $Scale, 460 * $Scale, 150 * $Scale, 30 * $Scale)

$Frame = GUICreate("", 100, 100, 100, 100, $WS_POPUP, BitOR($WS_EX_TOPMOST, $WS_EX_TRANSPARENT, $WS_EX_LAYERED), $GUI)
GUISetBkColor(0xFFFFE1)
_WinAPI_SetLayeredWindowAttributes($Frame, 0xFFFFE1, 0, $LWA_COLORKEY)

$Magnifier = GUICreate("Magnifier", 195 * $Scale, 195 * $Scale, -1, -1, $WS_CAPTION, BitOR($WS_EX_TOPMOST, $WS_EX_CONTROLPARENT), $GUI)

$Menu = GUICtrlCreateContextMenu($TreeView)
$iCopySelected = GUICtrlCreateMenuItem("Copy Selected Value", $Menu)
$iCopyAll = GUICtrlCreateMenuItem("Copy All Info", $Menu)
GUICtrlCreateMenuItem("", $Menu)
$iWinText = GUICtrlCreateMenuItem("Window Text...", $Menu)
$iHierarchy = GUICtrlCreateMenuItem("Window Hierarchy...", $Menu)

LoadConfig()
GUISetState(@SW_SHOW, $GUI)
If BitAND(GUICtrlRead($ChkOnTop), $GUI_CHECKED) Then WinSetOnTop($GUI, "", 1)
$GuiWindow = WinGetPos($GUI)
$GuiClient = WinGetClientSize($GUI)
$Borders = $GuiWindow[2] - $GuiClient[0]
If BitAND(GUICtrlRead($ChkOnRun), $GUI_CHECKED) Then GUICtrlSendMsg($BtnStart, 0xF5, 0, 0) ; $BM_CLICK

$ShiftEsc = GUICtrlCreateDummy()
Global $AccelKeys[1][2] = [["+{esc}", $ShiftEsc]]
GUISetAccelerators($AccelKeys)

GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")

While 1
  Switch GUIGetMsg()
    Case $GUI_EVENT_CLOSE
      SaveConfig()
      Exit
    Case $BtnStart
      GUISetState(@SW_HIDE, $GUI)
      If BitAND(GUICtrlRead($ChkMagnifier), $GUI_CHECKED) Then GUISetState(@SW_SHOWNOACTIVATE, $Magnifier)
      While _IsPressed("5B") Or _IsPressed("5C") And _IsPressed("10")
        GUIGetMsg()
      WEnd
      Do
        $CursorPos = MouseGetPos()
        If $PrevCurPos[0] <> $CursorPos[0] Or $PrevCurPos[1] <> $CursorPos[1] Or Not WinExists($CurrentWnd) Then
          $CurrentWnd = WindowFromPoint()
          If Not $CurrentWnd Then ContinueLoop
          ShowFrame()
          SetWindowInfo()
          SetControlInfo($CurrentWnd)
          $PixelColor = PixelGetColor($CursorPos[0], $CursorPos[1])
          SetMouseInfo()
          DrawMagnifier()
          $PrevCurPos = $CursorPos
          SetTooltipInfo()
        EndIf
        If _IsPressed("5B") And _IsPressed("11") Then Screenshot($GUI)
        While _IsPressed("5B") And _IsPressed("12")
          If CursorMove($CursorPos[0], $CursorPos[1]) Then ExitLoop
        WEnd
        GUIGetMsg()
      Until _IsPressed("5B") Or _IsPressed("5C") And _IsPressed("10")
      ToolTip("")
      FillTreeView()
      WindowGetText()
      $PrevCurPos[0] = -1
      GUISetState(@SW_HIDE, $Frame)
      GUISetState(@SW_HIDE, $Magnifier)
      GUISetState(@SW_SHOWNORMAL, $GUI)
      While _IsPressed("5B") Or _IsPressed("5C") And _IsPressed("10")
        GUIGetMsg()
      WEnd
    Case $ChkOnTop
      If BitAND(GUICtrlRead($ChkOnTop), $GUI_CHECKED) Then
        WinSetOnTop($GUI, "", 1)
      Else
        WinSetOnTop($GUI, "", 0)
      EndIf
    Case $LblColor
      $tmp = _ChooseColor(1, $FrameColor, 1, $GUI)
      If $tmp <> -1 Then
        $FrameColor = $tmp
        GUICtrlSetBkColor($LblColor, _WinAPI_SwitchColor($FrameColor))
      EndIf
    Case $iCopySelected
      $Value = GetValue()
      If $Value <> "" Then ClipPut($Value)
    Case $iCopyAll
      CopyAll()
    Case $iWinText
      ShowWinText()
    Case $iHierarchy
      ShowHierarchy()
    Case $BtnConfig
      If GUICtrlRead($BtnConfig) = ">>" Then
        WinMove($GUI, "", Default, Default, 460 * $Scale + $Borders)
        GUICtrlSetData($BtnConfig, "<<")
      Else
        WinMove($GUI, "", Default, Default, 280 * $Scale + $Borders)
        GUICtrlSetData($BtnConfig, ">>")
      EndIf
    Case $ShiftEsc
      GUISetState(@SW_MINIMIZE, $GUI)
  EndSwitch
  If _IsPressed("5B") Or _IsPressed("5C") And _IsPressed("10") Then GUICtrlSendMsg($BtnStart, 0xF5, 0, 0) ; $BM_CLICK
WEnd

Func WindowFromPoint()
  Local $ChildRect, $Result, $Wins
  Local $Point = DllStructCreate($tagPoint)
  $Point.X = $CursorPos[0]
  $Point.Y = $CursorPos[1]
  $Result = _WinAPI_WindowFromPoint($Point)
  If Not $Result Then Return 0
  $ParentWnd = _WinAPI_GetAncestor($Result, 2)
  $WndRect = _WinAPI_GetWindowRect($ParentWnd)
  $Wins = _WinAPI_EnumChildWindows($ParentWnd, BitAND(GUICtrlRead($ChkHidden), $GUI_UNCHECKED))
  If IsArray($Wins) Then
    For $i = 1 To $Wins[0][0]
      $ChildRect = _WinAPI_GetWindowRect($Wins[$i][0])
      If _WinAPI_PtInRect($ChildRect, $Point) Then
        If BitAND(_WinAPI_GetWindowLong($Wins[$i][0], $GWL_EXSTYLE), $WS_EX_MDICHILD) Then
          $Result = $Wins[$i][0]
          $WndRect = $ChildRect
          $Wins = _WinAPI_EnumChildWindows($Wins[$i][0], BitAND(GUICtrlRead($ChkHidden), $GUI_UNCHECKED))
          If IsArray($Wins) Then
            For $i = 1 To $Wins[0][0]
              $ChildRect = _WinAPI_GetWindowRect($Wins[$i][0])
              If _WinAPI_PtInRect($ChildRect, $Point) Then
                If ($ChildRect.Right - $ChildRect.Left) * ($ChildRect.Bottom - $ChildRect.Top) <= ($WndRect.Right - $WndRect.Left) * ($WndRect.Bottom - $WndRect.Top) Then
                  $Result = $Wins[$i][0]
                  $WndRect = $ChildRect
                EndIf
              EndIf
            Next
          EndIf
          ExitLoop
        EndIf
        If ($ChildRect.Right - $ChildRect.Left) * ($ChildRect.Bottom - $ChildRect.Top) <= ($WndRect.Right - $WndRect.Left) * ($WndRect.Bottom - $WndRect.Top) Then
          $Result = $Wins[$i][0]
          $WndRect = $ChildRect
        EndIf
      EndIf
    Next
  EndIf
  Return $Result
EndFunc

Func ShowFrame()
  If (BitAND(GUICtrlRead($ChkFrame), $GUI_CHECKED) And Not _IsPressed("10")) _
  Or (BitAND(GUICtrlRead($ChkFrame), $GUI_UNCHECKED) And _IsPressed("10")) Then
    Local $w = $WndRect.Right - $WndRect.Left
    Local $h = $WndRect.Bottom - $WndRect.Top
    If $w > 0 And $h > 0 Then
      WinMove($Frame, "", $WndRect.Left, $WndRect.Top, $w, $h)
      GUISetState(@SW_SHOWNOACTIVATE, $Frame)
      WinSetOnTop($Frame, "", 1)
      Local $DC, $Brush, $Rect
      $DC = _WinAPI_GetWindowDC($Frame)
      $Brush = _WinAPI_CreateSolidBrush($FrameColor)
      $Rect = DllStructCreate($tagRECT)
      For $i = 0 To GUICtrlRead($InpThickness) - 1
        $Rect.Left = $i
        $Rect.Top = $i
        $Rect.Right = $w - $i
        $Rect.Bottom = $h - $i
        _WinAPI_FrameRect($DC, DllStructGetPtr($Rect), $Brush)
      Next
      _WinAPI_DeleteObject($Brush)
      _WinAPI_ReleaseDC($Frame, $DC)
    Else
      GUISetState(@SW_HIDE, $Frame)
    EndIf
  Else
    GUISetState(@SW_HIDE, $Frame)
  EndIf
EndFunc

Func GetInstance($Control)
  Local $Class, $Wins, $Inst = 0
  $Class = _WinAPI_GetClassName($Control)
  If @error Then Return ""
  $Wins = _WinAPI_EnumChildWindows($ParentWnd, False)
  If IsArray($Wins) Then
    For $i = 1 To $Wins[0][0]
      If $Wins[$i][1] = $Class Then $Inst += 1
      If $Wins[$i][0] = $Control Then Return $Inst
    Next
  EndIf
  Return ""
EndFunc

Func SetWindowInfo()
  Local $Pos
  $WindowInfo[0][2] = WinGetTitle($ParentWnd)
  $WindowInfo[1][2] = _WinAPI_GetClassName($ParentWnd)
  $Pos = WinGetPos($ParentWnd)
  If IsArray($Pos) Then
    $WindowInfo[2][2] = $Pos[0] & ", " & $Pos[1]
    $WindowInfo[3][2] = $Pos[2] & ", " & $Pos[3]
  Else
    $WindowInfo[2][2] = ""
    $WindowInfo[3][2] = ""
  EndIf
  $Pos = WinGetClientSize($ParentWnd)
  If IsArray($Pos) Then
    $WindowInfo[4][2] = $Pos[0] & ", " & $Pos[1]
  Else
    $WindowInfo[4][2] = ""
  EndIf
  $WindowInfo[5][2] = "0x" & Hex(_WinAPI_GetWindowLong($ParentWnd, $GWL_STYLE))
  $WindowInfo[6][2] = "0x" & Hex(_WinAPI_GetWindowLong($ParentWnd, $GWL_EXSTYLE))
  $WindowInfo[7][2] = $ParentWnd
  $WindowInfo[8][2] = WinGetProcess($ParentWnd)
EndFunc

Func SetControlInfo($CtrlWnd)
  If $CtrlWnd = $ParentWnd Or Not WinExists($CtrlWnd) Then
    For $i = 0 To UBound($ControlInfo, 1) - 1
      $ControlInfo[$i][2] = ""
    Next
    Return
  EndIf
  Local $ID, $Pos
  $ControlInfo[0][2] = _WinAPI_GetClassName($CtrlWnd)
  $ControlInfo[1][2] = GetInstance($CtrlWnd)
  $ControlInfo[2][2] = $ControlInfo[0][2] & $ControlInfo[1][2]
  $ID = _WinAPI_GetDlgCtrlID($CtrlWnd)
  If $ID <= 0 Then $ID = ""
  $ControlInfo[3][2] = $ID
  $ControlInfo[4][2] = StringLeft(ControlGetText($ParentWnd, "", $CtrlWnd), 48)
  $Pos = ControlGetPos($ParentWnd, "", $CtrlWnd)
  If IsArray($Pos) Then
    $ControlInfo[5][2] = $Pos[0] & ", " & $Pos[1]
    $ControlInfo[6][2] = $Pos[2] & ", " & $Pos[3]
  Else
    $ControlInfo[5][2] = ""
    $ControlInfo[6][2] = ""
  EndIf
  $ControlInfo[7][2] = $CursorPos[0] - $WndRect.Left & ", " & $CursorPos[1] - $WndRect.Top
  $ControlInfo[8][2] = "0x" & Hex(_WinAPI_GetWindowLong($CtrlWnd, $GWL_STYLE))
  $ControlInfo[9][2] = "0x" & Hex(_WinAPI_GetWindowLong($CtrlWnd, $GWL_EXSTYLE))
  $ControlInfo[10][2] = $CtrlWnd
  $ControlInfo[11][2] = ControlCommand($ParentWnd, "", $CtrlWnd, "IsVisible")
  $ControlInfo[12][2] = ControlCommand($ParentWnd, "", $CtrlWnd, "IsEnabled")
  If $ForHierarchy Then $ControlInfo[7][2] = ""
EndFunc

Func SetMouseInfo()
  If $ForHierarchy Then
    For $i = 0 To UBound($MouseInfo, 1) - 1
      $MouseInfo[$i][2] = ""
    Next
    Return
  EndIf
  Local $Pos, $ParentPos
  $MouseInfo[0][2] = $CursorPos[0] & ", " & $CursorPos[1]
  $ParentPos = WinGetPos($ParentWnd)
  If IsArray($ParentPos) Then
    $MouseInfo[1][2] = $CursorPos[0] - $ParentPos[0] & ", " & $CursorPos[1] - $ParentPos[1]
    $Pos = _WinAPI_GetMousePos(True, $ParentWnd)
    $MouseInfo[2][2] = $Pos.X & ", " & $Pos.Y
  Else
    $MouseInfo[1][2] = ""
    $MouseInfo[2][2] = ""
  EndIf
  $MouseInfo[3][2] = "0x" & Hex($PixelColor, 6)
  $MouseInfo[4][2] = $PixelColor
  $MouseInfo[5][2] = MouseGetCursor()
EndFunc

Func SetTooltipInfo()
  If (BitAND(GUICtrlRead($ChkTooltip), $GUI_CHECKED) And Not _IsPressed("11")) _
  Or (BitAND(GUICtrlRead($ChkTooltip), $GUI_UNCHECKED) And _IsPressed("11")) Then
    Local $TooltipInfo = ""
    If BitAND(GUICtrlRead($iWindow), $GUI_CHECKED) Then $TooltipInfo &= "--- Window Info ---" & @CRLF
    For $i = 0 To UBound($WindowInfo, 1) - 1
      If BitAND(GUICtrlRead($WindowInfo[$i][0]), $GUI_CHECKED) Then $TooltipInfo &= $WindowInfo[$i][1] & $WindowInfo[$i][2] & @CRLF
    Next
    If BitAND(GUICtrlRead($iControl), $GUI_CHECKED) Then $TooltipInfo &= "--- Control Info ---" & @CRLF
    For $i = 0 To UBound($ControlInfo, 1) - 1
      If BitAND(GUICtrlRead($ControlInfo[$i][0]), $GUI_CHECKED) Then $TooltipInfo &= $ControlInfo[$i][1] & $ControlInfo[$i][2] & @CRLF
    Next
    If BitAND(GUICtrlRead($iMouse), $GUI_CHECKED) Then $TooltipInfo &= "--- Mouse Info ---" & @CRLF
    For $i = 0 To UBound($MouseInfo, 1) - 1
      If BitAND(GUICtrlRead($MouseInfo[$i][0]), $GUI_CHECKED) Then $TooltipInfo &= $MouseInfo[$i][1] & $MouseInfo[$i][2] & @CRLF
    Next
    If BitAND(GUICtrlRead($iHint), $GUI_CHECKED) Then $TooltipInfo &= "--- Hints ---" & @CRLF
    For $i = 0 To UBound($Hints, 1) - 1
      If BitAND(GUICtrlRead($Hints[$i][0]), $GUI_CHECKED) Then $TooltipInfo &= $Hints[$i][1] & @CRLF
    Next
    $TooltipInfo = StringTrimRight($TooltipInfo, 2)
    If $TooltipInfo = "" Then Return
    Local $Monitor = _GetMonitorFromPoint()
    If $Monitor > 0 And $Monitor <= $__MonitorList[0][0] Then
      Local $MonitorRight = $__MonitorList[$Monitor][3]
      Local $MonitorBottom = $__MonitorList[$Monitor][4]
      ToolTip($TooltipInfo, $__MonitorList[0][3], $__MonitorList[0][4])
      Local $Tool, $List = WinList("[class:tooltips_class32]")
      For $i = 1 To $List[0][0]
        If BitAND(WinGetState($List[$i][1]), 2) Then
          $Tool = $List[$i][1]
          ExitLoop
        EndIf
      Next
      Local $Pos = WinGetPos($Tool)
      If IsArray($Pos) Then
        $Pos[0] = $CursorPos[0] + GUICtrlRead($InpOffset)
        $Pos[1] = $CursorPos[1] + GUICtrlRead($InpOffset)
        If $Pos[0] + $Pos[2] > $MonitorRight Then $Pos[0] = $CursorPos[0] - $Pos[2] - GUICtrlRead($InpOffset)
        If $Pos[1] + $Pos[3] > $MonitorBottom Then $Pos[1] = $CursorPos[1] - $Pos[3] - GUICtrlRead($InpOffset)
        WinMove($Tool, "", $Pos[0], $Pos[1])
      Else
        WinMove($Tool, "", $CursorPos[0] + GUICtrlRead($InpOffset), $CursorPos[1] + GUICtrlRead($InpOffset))
      EndIf
    Else
      ToolTip($TooltipInfo, $CursorPos[0] + GUICtrlRead($InpOffset), $CursorPos[1] + GUICtrlRead($InpOffset))
    EndIf
  Else
    ToolTip("")
  EndIf
EndFunc

Func FillTreeView()
  _GUICtrlTreeView_BeginUpdate(GUICtrlGetHandle($TreeView))
  For $i = 0 To UBound($WindowInfo, 1) - 1
    GUICtrlSetData($WindowInfo[$i][0], $WindowInfo[$i][1] & $WindowInfo[$i][2])
  Next
  For $i = 0 To UBound($ControlInfo, 1) - 1
    GUICtrlSetData($ControlInfo[$i][0], $ControlInfo[$i][1] & $ControlInfo[$i][2])
  Next
  For $i = 0 To UBound($MouseInfo, 1) - 1
    GUICtrlSetData($MouseInfo[$i][0], $MouseInfo[$i][1] & $MouseInfo[$i][2])
  Next
  _GUICtrlTreeView_EndUpdate(GUICtrlGetHandle($TreeView))
EndFunc

Func WindowGetText()
  Local $Wins, $Text
  $WinVisibleText = ""
  $WinHiddenText = ""
  $Wins = _WinAPI_EnumChildWindows($ParentWnd, False)
  If Not IsArray($Wins) Then Return
  For $i = 1 To $Wins[0][0]
    $Text = ControlGetText($ParentWnd, "", $Wins[$i][0])
    If $Text <> "" Then
      Switch ControlCommand($ParentWnd, "", $Wins[$i][0], "IsVisible")
        Case 1
          $WinVisibleText &= $Text & @CRLF
        Case 0
          $WinHiddenText &= $Text & @CRLF
      EndSwitch
    EndIf
  Next
EndFunc

Func DrawMagnifier()
  If BitAND(GUICtrlRead($ChkMagnifier), $GUI_UNCHECKED) Then Return
  Local $dDC, $mDC, $cDC, $Bmp, $Brush, $Rect
  $dDC = _WinAPI_GetDC(0)
  $cDC = _WinAPI_CreateCompatibleDC($dDC)
  $Bmp = _WinAPI_CreateCompatibleBitmap($dDC, 13, 13)
  _WinAPI_SelectObject($cDC, $Bmp)
  _WinAPI_BitBlt($cDC, 0, 0, 13, 13, $dDC, $CursorPos[0] - 6, $CursorPos[1] - 6, $SRCCOPY)
  $mDC = _WinAPI_GetDC($Magnifier)
  _WinAPI_StretchBlt($mDC, 0, 0, 195 * $Scale, 195 * $Scale, $cDC, 0, 0, 13, 13, $SRCCOPY)
  $Rect = DllStructCreate($tagRECT)
  $Brush = _WinAPI_CreateSolidBrush(0xFFFFFF)
  $Rect.Left = 90 * $Scale
  $Rect.Top = 90 * $Scale
  $Rect.Right = 105 * $Scale
  $Rect.Bottom = 105 * $Scale
  _WinAPI_FrameRect($mDC, DllStructGetPtr($Rect), $Brush)
  _WinAPI_DeleteObject($Brush)
  $Brush = _WinAPI_CreateSolidBrush(0x000000)
  $Rect.Left = 90 * $Scale - 1
  $Rect.Top = 90 * $Scale - 1
  $Rect.Right = 105 * $Scale + 1
  $Rect.Bottom = 105 * $Scale + 1
  _WinAPI_FrameRect($mDC, DllStructGetPtr($Rect), $Brush)
  _WinAPI_DeleteObject($Brush)
  _WinAPI_DeleteObject($Bmp)
  _WinAPI_ReleaseDC(0, $dDC)
  _WinAPI_ReleaseDC($Magnifier, $mDC)
  _WinAPI_DeleteDC($cDC)
  WinSetTitle($Magnifier, "", "RGB 0x" & Hex($PixelColor, 6) & " (" & $PixelColor & ")")
  WinSetOnTop($Magnifier, "", 1)
EndFunc

Func GetValue($Item = "")
  Local $Str, $Pos
  If $Item = "" Then
    $Str = GUICtrlRead($TreeView, 1)
  Else
    $Str = GUICtrlRead($Item, 1)
  EndIf
  $Pos = StringInStr($Str, ":")
  If $Pos > 0 Then
    $Str = StringTrimLeft($Str, $Pos + 1)
    If $Str <> "" Then
      If StringIsDigit(StringLeft($Str, 1)) Then
        Return $Str
      Else
        Return '"' & $Str & '"'
      EndIf
    EndIf
  EndIf
  Return ""
EndFunc

Func CopyAll()
  Local $Str = ""
  $Str &= "--- Window Info ---" & @CRLF
  For $i = 0 To UBound($WindowInfo, 1) - 1
    $Str &= $WindowInfo[$i][1] & $WindowInfo[$i][2] & @CRLF
  Next
  $Str &= @CRLF
  $Str &= "--- Control Info ---" & @CRLF
  For $i = 0 To UBound($ControlInfo, 1) - 1
    $Str &= $ControlInfo[$i][1] & $ControlInfo[$i][2] & @CRLF
  Next
  $Str &= @CRLF
  $Str &= "--- Mouse Info ---" & @CRLF
  For $i = 0 To UBound($MouseInfo, 1) - 1
    $Str &= $MouseInfo[$i][1] & $MouseInfo[$i][2] & @CRLF
  Next
  ClipPut($Str)
EndFunc

Func LoadConfig()
  Local $AlwaysOnTop = RegRead($RegKey, "AlwaysOnTop")
  If $AlwaysOnTop = "0" Then
    GUICtrlSetState($ChkOnTop, $GUI_UNCHECKED)
  Else
    GUICtrlSetState($ChkOnTop, $GUI_CHECKED)
  EndIf
  Local $ShowTooltip = RegRead($RegKey, "ShowTooltip")
  If $ShowTooltip = "0" Then
    GUICtrlSetState($ChkTooltip, $GUI_UNCHECKED)
  Else
    GUICtrlSetState($ChkTooltip, $GUI_CHECKED)
  EndIf
  Local $ShowFrame = RegRead($RegKey, "ShowFrame")
  If $ShowFrame = "0" Then
    GUICtrlSetState($ChkFrame, $GUI_UNCHECKED)
  Else
    GUICtrlSetState($ChkFrame, $GUI_CHECKED)
  EndIf
  Local $ShowMagnifier = RegRead($RegKey, "ShowMagnifier")
  If $ShowMagnifier = "1" Then
    GUICtrlSetState($ChkMagnifier, $GUI_CHECKED)
  Else
    GUICtrlSetState($ChkMagnifier, $GUI_UNCHECKED)
  EndIf
  Local $Hidden = RegRead($RegKey, "SearchHidden")
  If $Hidden = "1" Then
    GUICtrlSetState($ChkHidden, $GUI_CHECKED)
  Else
    GUICtrlSetState($ChkHidden, $GUI_UNCHECKED)
  EndIf
  Local $OnRun = RegRead($RegKey, "StartOnRun")
  If $OnRun = "1" Then
    GUICtrlSetState($ChkOnRun, $GUI_CHECKED)
  Else
    GUICtrlSetState($ChkOnRun, $GUI_UNCHECKED)
  EndIf
  Local $IntoSciTE = RegRead($RegKey, "PasteIntoSciTE")
  If $IntoSciTE = "1" Then
    GUICtrlSetState($ChkIntoSciTE, $GUI_CHECKED)
  Else
    GUICtrlSetState($ChkIntoSciTE, $GUI_UNCHECKED)
  EndIf
  $FrameColor = RegRead($RegKey, "FrameColor")
  If StringLen($FrameColor) <> 8 Or StringLeft($FrameColor, 2) <> "0x" _
  Or Not StringIsXDigit(StringRight($FrameColor, 6)) Then $FrameColor = "0x0000FF"
  GUICtrlSetBkColor($LblColor, _WinAPI_SwitchColor($FrameColor))
  Local $Thickness = RegRead($RegKey, "FrameThickness")
  If StringLen($Thickness) <> 1 Or $Thickness < 1 Or $Thickness > 9 Then
    GUICtrlSetData($InpThickness, 2)
  Else
    GUICtrlSetData($InpThickness, $Thickness)
  EndIf
  Local $Offset = RegRead($RegKey, "TooltipOffset")
  If Not StringIsInt($Offset) Or Int($Offset) < 0 Then
    GUICtrlSetData($InpOffset, 50)
  Else
    GUICtrlSetData($InpOffset, $Offset)
  EndIf
  Local $ScrName = RegRead($RegKey, "ScreenshotName")
  If @error Then
    GUICtrlSetData($InpScrName, "Screenshot")
  Else
    GUICtrlSetData($InpScrName, $ScrName)
  EndIf
  Local $Ext = RegRead($RegKey, "ScreenshotExt")
  Switch $Ext
    Case ".BMP",".JPG",".PNG",".GIF",".TIF"
      GUICtrlSetData($CmbScrExt, ".BMP|.JPG|.PNG|.GIF|.TIF", $Ext)
    Case Else
      GUICtrlSetData($CmbScrExt, ".BMP|.JPG|.PNG|.GIF|.TIF", ".BMP")
  EndSwitch
  Local $Str = RegRead($RegKey, "Expanded")
  If StringLen($Str) <> 4 Then $Str = "1100"
  If StringLeft($Str, 1) <> "0" Then GUICtrlSetState($iWindow, $GUI_EXPAND)
  If StringMid($Str, 2, 1) <> "0" Then GUICtrlSetState($iControl, $GUI_EXPAND)
  If StringMid($Str, 3, 1) = "1" Then GUICtrlSetState($iMouse, $GUI_EXPAND)
  If StringRight($Str, 1) = "1" Then GUICtrlSetState($iHint, $GUI_EXPAND)
  ControlTreeView($GUI, "", $TreeView, "Select", "#0")
  $Str = RegRead($RegKey, "Checked")
  If StringLen($Str) <> UBound($Checked) Then $Str = "111110000011100011100000111110011111"
  $Checked = StringSplit($Str, "", 2)
  If $Checked[0] = "1" Then GUICtrlSetState($iWindow, $GUI_CHECKED)
  For $i = 0 To UBound($WindowInfo) - 1
    If $Checked[$i + 1] = "1" Then GUICtrlSetState($WindowInfo[$i][0], $GUI_CHECKED)
  Next
  Local $Pos = 1 + UBound($WindowInfo, 1)
  If $Checked[$Pos] = "1" Then GUICtrlSetState($iControl, $GUI_CHECKED)
  For $i = 0 To UBound($ControlInfo) - 1
    If $Checked[$i + $Pos + 1] = "1" Then GUICtrlSetState($ControlInfo[$i][0], $GUI_CHECKED)
  Next
  $Pos = 2 + UBound($WindowInfo, 1) + UBound($ControlInfo, 1)
  If $Checked[$Pos] = "1" Then GUICtrlSetState($iMouse, $GUI_CHECKED)
  For $i = 0 To UBound($MouseInfo) - 1
    If $Checked[$i + $Pos + 1] = "1" Then GUICtrlSetState($MouseInfo[$i][0], $GUI_CHECKED)
  Next
  $Pos = 3 + UBound($WindowInfo, 1) + UBound($ControlInfo, 1) + UBound($MouseInfo, 1)
  If $Checked[$Pos] = "1" Then GUICtrlSetState($iHint, $GUI_CHECKED)
  For $i = 0 To UBound($Hints) - 1
    If $Checked[$i + $Pos + 1] = "1" Then GUICtrlSetState($Hints[$i][0], $GUI_CHECKED)
  Next
  _GUICtrlTreeView_SetBold($TreeView, $iWindow)
  _GUICtrlTreeView_SetBold($TreeView, $iControl)
  _GUICtrlTreeView_SetBold($TreeView, $iMouse)
EndFunc

Func SaveConfig()
  RegWrite($RegKey, "AlwaysOnTop", "REG_SZ", BitAND(GUICtrlRead($ChkOnTop), $GUI_CHECKED))
  RegWrite($RegKey, "ShowTooltip", "REG_SZ", BitAND(GUICtrlRead($ChkTooltip), $GUI_CHECKED))
  RegWrite($RegKey, "ShowFrame", "REG_SZ", BitAND(GUICtrlRead($ChkFrame), $GUI_CHECKED))
  RegWrite($RegKey, "ShowMagnifier", "REG_SZ", BitAND(GUICtrlRead($ChkMagnifier), $GUI_CHECKED))
  RegWrite($RegKey, "SearchHidden", "REG_SZ", BitAND(GUICtrlRead($ChkHidden), $GUI_CHECKED))
  RegWrite($RegKey, "StartOnRun", "REG_SZ", BitAND(GUICtrlRead($ChkOnRun), $GUI_CHECKED))
  RegWrite($RegKey, "PasteIntoSciTE", "REG_SZ", BitAND(GUICtrlRead($ChkIntoSciTE), $GUI_CHECKED))
  RegWrite($RegKey, "FrameColor", "REG_SZ", $FrameColor)
  RegWrite($RegKey, "FrameThickness", "REG_SZ", GUICtrlRead($InpThickness))
  RegWrite($RegKey, "TooltipOffset", "REG_SZ", GUICtrlRead($InpOffset))
  RegWrite($RegKey, "ScreenshotName", "REG_SZ", GUICtrlRead($InpScrName))
  RegWrite($RegKey, "ScreenshotExt", "REG_SZ", GUICtrlRead($CmbScrExt))
  Local $Str = ""
  $Str &= Int(_GUICtrlTreeView_GetExpanded($TreeView, $iWindow))
  $Str &= Int(_GUICtrlTreeView_GetExpanded($TreeView, $iControl))
  $Str &= Int(_GUICtrlTreeView_GetExpanded($TreeView, $iMouse))
  $Str &= Int(_GUICtrlTreeView_GetExpanded($TreeView, $iHint))
  RegWrite($RegKey, "Expanded", "REG_SZ", $Str)
  $Str = ""
  $Str &= BitAND(GUICtrlRead($iWindow), $GUI_CHECKED)
  For $i = 0 To UBound($WindowInfo, 1) - 1
    $Str &= BitAND(GUICtrlRead($WindowInfo[$i][0]), $GUI_CHECKED)
  Next
  $Str &= BitAND(GUICtrlRead($iControl), $GUI_CHECKED)
  For $i = 0 To UBound($ControlInfo, 1) - 1
    $Str &= BitAND(GUICtrlRead($ControlInfo[$i][0]), $GUI_CHECKED)
  Next
  $Str &= BitAND(GUICtrlRead($iMouse), $GUI_CHECKED)
  For $i = 0 To UBound($MouseInfo, 1) - 1
    $Str &= BitAND(GUICtrlRead($MouseInfo[$i][0]), $GUI_CHECKED)
  Next
  $Str &= BitAND(GUICtrlRead($iHint), $GUI_CHECKED)
  For $i = 0 To UBound($Hints, 1) - 1
    $Str &= BitAND(GUICtrlRead($Hints[$i][0]), $GUI_CHECKED)
  Next
  RegWrite($RegKey, "Checked", "REG_SZ", $Str)
EndFunc

Func Screenshot($ParentDialog)
  Local $hBMP, $FilePath
  GUISetState(@SW_HIDE, $Frame)
  ToolTip("")
  $hBMP = _ScreenCapture_CaptureWnd("", $CurrentWnd, 0, 0, -1, -1, False)
  If Not $hBMP Then Return
  $FilePath = FileSaveDialog("", "", "Pictures (*.bmp;*.jpg;*.png;*.gif;*.tif)", 18, GUICtrlRead($InpScrName) & StringLower(GUICtrlRead($CmbScrExt)), $ParentDialog)
  If @error Then
    _WinAPI_DeleteObject($hBMP)
  Else
    Switch StringRight($FilePath, 4)
      Case ".BMP",".JPG",".PNG",".GIF",".TIF"
      Case Else
        $FilePath &= StringLower(GUICtrlRead($CmbScrExt))
    EndSwitch
    _ScreenCapture_SaveImage($FilePath, $hBMP)
  EndIf
EndFunc

Func ShowWinText()
  GUISetState(@SW_DISABLE, $GUI)
  $WinTextGui = GUICreate("Window Text", 515 * $Scale, 400 * $Scale, -1, -1, BitOR($WS_CAPTION, $WS_SYSMENU), -1, $GUI)
  GUICtrlCreateLabel("Visible Text", 5 * $Scale, 5 * $Scale, 250 * $Scale, 20 * $Scale, $SS_CENTER)
  $EdtVisibleText = GUICtrlCreateEdit("", 5 * $Scale, 25 * $Scale, 250 * $Scale, 370 * $Scale, BitOR($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
  GUICtrlCreateLabel("HiddenText", 260 * $Scale, 5 * $Scale, 250 * $Scale, 20 * $Scale, $SS_CENTER)
  $EdtHiddenText = GUICtrlCreateEdit("", 260 * $Scale, 25 * $Scale, 250 * $Scale, 370 * $Scale, BitOR($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
  GUICtrlSetData($EdtVisibleText, $WinVisibleText)
  GUICtrlSetData($EdtHiddenText, $WinHiddenText)
  CenterWindow($WinTextGui)
  GUISetState(@SW_SHOW, $WinTextGui)
  Do
  Until GUIGetMsg() = $GUI_EVENT_CLOSE
  GUIDelete($WinTextGui)
  GUISetState(@SW_ENABLE, $GUI)
  WinActivate($GUI)
EndFunc

Func ShowHierarchy()
  If Not WinExists($ParentWnd) Then
    MsgBox(0, "Window Hierarchy", "Window not found : " & $ParentWnd, 0, $GUI)
    Return
  EndIf
  GUISetState(@SW_HIDE, $GUI)
  Global $TvClose = 0
  Global $WinHierarchy = GUICreate("Window Hierarchy", 350 * $Scale, 400 * $Scale, -1, -1, $WS_OVERLAPPEDWINDOW)
  Global $TvHierarchy = GUICtrlCreateTreeView(0, 0, 350 * $Scale, 400 * $Scale)
  GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
  $TvMenu = GUICtrlCreateContextMenu($TvHierarchy)
  Global $iRefresh = GUICtrlCreateMenuItem("Refresh Hierarchy", $TvMenu)
  $TvHierarchy = GUICtrlGetHandle($TvHierarchy)
  CenterWindow($WinHierarchy)
  GUISetState(@SW_SHOW, $WinHierarchy)
  If BitAND(GUICtrlRead($ChkOnTop), $GUI_CHECKED) Then WinSetOnTop($WinHierarchy, "", 1)
  CreateHierarchy()
  Do
    Switch GUIGetMsg()
      Case $GUI_EVENT_MOUSEMOVE
        HierarchyInfo()
      Case $GUI_EVENT_CLOSE
        ExitLoop
      Case $iRefresh
        CreateHierarchy()
    EndSwitch
    If Not BitAND(WinGetState($WinHierarchy), 8) Then
      GUISetState(@SW_HIDE, $Frame)
      ToolTip("")
    EndIf
    If Not WinExists($ParentWnd) Then
      GUISetState(@SW_HIDE, $Frame)
      MsgBox(0, "Window Hierarchy", "Window not found : " & $ParentWnd, 0, $WinHierarchy)
      ExitLoop
    EndIf
    If _IsPressed("21") Or _IsPressed("22") Or _IsPressed("23") Or _IsPressed("24") _
    Or _IsPressed("25") Or _IsPressed("26") Or _IsPressed("27") Or _IsPressed("28") _
    And BitAND(WinGetState($WinHierarchy), 8) Then HierarchyInfo()
    If _IsPressed("5B") And _IsPressed("11") Then Screenshot($WinHierarchy)
    If _IsPressed("5B") And _IsPressed("10") Then $TvClose = 1
    If $TvClose Then
      HierarchyInfo()
      $TvClose = 0
      ExitLoop
    EndIf
  Until 0
  GUIDelete($WinHierarchy)
  ToolTip("")
  GUISetState(@SW_HIDE, $Frame)
  GUISetState(@SW_SHOWNORMAL, $GUI)
  WinActivate($GUI)
  While _IsPressed("5B") Or _IsPressed("5C") And _IsPressed("10")
    GUIGetMsg()
  WEnd
EndFunc

Func CreateHierarchy()
  Local $Wins, $Root, $Item, $Parent = $ParentWnd, $Rect, $Point
  GUISetState(@SW_HIDE, $Frame)
  GUICtrlSetState($iRefresh, $GUI_DISABLE)
  _GUICtrlTreeView_DeleteAll($TvHierarchy)
  $Root = _GUICtrlTreeView_AddFirst($TvHierarchy, 0, $ParentWnd & " : " & $WindowInfo[1][2])
  _GUICtrlTreeView_SetBold($TvHierarchy, $Root)
  _GUICtrlTreeView_BeginUpdate($TvHierarchy)
  $Wins = _WinAPI_EnumChildWindows($ParentWnd, BitAND(GUICtrlRead($ChkHidden), $GUI_UNCHECKED))
  If IsArray($Wins) Then
    Do
      For $i = 1 To $Wins[0][0]
        If $Wins[$i][0] = -1 Then ContinueLoop
        If _WinAPI_GetParent($Wins[$i][0]) = $Parent Then
          $Item = _GUICtrlTreeView_AddChild($TvHierarchy, $Root, $Wins[$i][0] & " : " & $Wins[$i][1])
          If ControlCommand($ParentWnd, "", $Wins[$i][0], "IsVisible") Then _GUICtrlTreeView_SetBold($TvHierarchy, $Item)
          $Wins[$i][0] = -1
        EndIf
      Next
      $Root = _GUICtrlTreeView_GetNext($TvHierarchy, $Root)
      $Parent = StringLeft(_GUICtrlTreeView_GetText($TvHierarchy, $Root), 10)
    Until $Root = 0
  EndIf
  _GUICtrlTreeView_EndUpdate($TvHierarchy)
  $Item = GetValue($ControlInfo[10][0])
  If $Item = "" Or _GUICtrlTreeView_FindItem($TvHierarchy, $Item, True) = 0 Then
    _SendMessage($TvHierarchy, $TVM_EXPAND, $TVE_EXPAND, _GUICtrlTreeView_GetFirstItem($TvHierarchy))
    $Rect = _GUICtrlTreeView_DisplayRect($TvHierarchy, _GUICtrlTreeView_GetFirstItem($TvHierarchy), True)
  Else
    _GUICtrlTreeView_SelectItem($TvHierarchy, _GUICtrlTreeView_FindItem($TvHierarchy, $Item, True))
    $Rect = _GUICtrlTreeView_DisplayRect($TvHierarchy, _GUICtrlTreeView_FindItem($TvHierarchy, $Item, True), True)
  EndIf
  $Point = DllStructCreate($tagPoint)
  $Point.X = ($Rect[0] + $Rect[2]) / 2
  $Point.Y = ($Rect[1] + $Rect[3]) / 2
  _WinAPI_ClientToScreen($TvHierarchy, $Point)
  CursorMove($Point.X, $Point.Y)
  GUICtrlSetState($iRefresh, $GUI_ENABLE)
EndFunc

Func HierarchyInfo()
  $ForHierarchy = 1
  Local $Pos = _WinAPI_GetMousePos(True, $TvHierarchy)
  Local $Item = _GUICtrlTreeView_HitTestItem($TvHierarchy, $Pos.X, $Pos.Y)
  If $Item <> 0 And Not $TvClose Then _GUICtrlTreeView_SelectItem($TvHierarchy, $Item)
  Local $Ctrl = HWnd(StringLeft(_GUICtrlTreeView_GetText($TvHierarchy, _GUICtrlTreeView_GetSelection($TvHierarchy)), 10))
  $CursorPos = MouseGetPos()
  $WndRect = _WinAPI_GetWindowRect($Ctrl)
  If Not @error Then ShowFrame()
  SetWindowInfo()
  SetControlInfo($Ctrl)
  SetMouseInfo()
  If $Item = _GUICtrlTreeView_GetSelection($TvHierarchy) Then
    SetTooltipInfo()
  Else
    ToolTip("")
  EndIf
  If $TvClose Then FillTreeView()
  $ForHierarchy = 0
EndFunc

Func CenterWindow($Wnd)
  Local $GuiPos = WinGetPos($GUI)
  Local $WndPos = WinGetPos($Wnd)
  Local $Left = $GuiPos[0] + $GuiPos[2] / 2 - $WndPos[2] / 2
  Local $Top = $GuiPos[1] + $GuiPos[3] / 2 - $WndPos[3] / 2
  WinMove($Wnd, "", $Left, $Top)
EndFunc

Func WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
  Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $hTreeView, $tMPos, $hItem, $Value
  $hTreeView = GUICtrlGetHandle($TreeView)
  $tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
  $hWndFrom = HWnd($tNMHDR.hWndFrom)
  $iIDFrom = $tNMHDR.IDFrom
  $iCode = $tNMHDR.Code
  Switch $hWndFrom
    Case $hTreeView
      Switch $iCode
        Case $NM_DBLCLK
          $Value = GetValue()
          If $Value <> "" Then
            ClipPut($Value)
            If BitAND(GUICtrlRead($ChkIntoSciTE), $GUI_CHECKED) And WinExists("[class:SciTEWindow]") Then
              WinActivate("[class:SciTEWindow]")
              Send("+{ins}")
            EndIf
          EndIf
        Case $NM_RCLICK
          $tMPos = _WinAPI_GetMousePos(True, $hWndFrom)
          $hItem = _GUICtrlTreeView_HitTestItem($hWndFrom, $tMPos.X, $tMPos.Y)
          If $hItem > 0 Then
            _GUICtrlTreeView_SelectItem($hTreeView, $hItem)
          EndIf
          $Value = GetValue()
          If $Value = "" Then
            GUICtrlSetState($iCopySelected, $GUI_DISABLE)
          Else
            GUICtrlSetState($iCopySelected, $GUI_ENABLE)
          EndIf
          If $WindowInfo[7][2] = "" Then
            GUICtrlSetState($iWinText, $GUI_DISABLE)
            GUICtrlSetState($iHierarchy, $GUI_DISABLE)
          Else
            GUICtrlSetState($iWinText, $GUI_ENABLE)
            GUICtrlSetState($iHierarchy, $GUI_ENABLE)
          EndIf
      EndSwitch
  EndSwitch
  Return $GUI_RUNDEFMSG
EndFunc

Func CursorMove($X, $Y)
  DllCall("user32.dll", "bool", "SetCursorPos", "int", $X, "int", $Y)
  Select
    Case _IsPressed("25")
      $X -= 1
    Case _IsPressed("26")
      $Y -= 1
    Case _IsPressed("27")
      $X += 1
    Case _IsPressed("28")
      $Y += 1
    Case Else
      Return Not Sleep(1)
  EndSelect
  DllCall("user32.dll", "bool", "SetCursorPos", "int", $X, "int", $Y)
  Return Sleep(50)
EndFunc