#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=ToDoIt_Icon.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=Program by G.Sandler & D.Kozhanov (specially for autoit-script.ru)
#AutoIt3Wrapper_Res_Description=ToDo Lists Manager
#AutoIt3Wrapper_Res_Fileversion=1.0.2.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2010 G.Sandler (CreatoR), D.Kozhanov (Medic84). All rights reserved.
#AutoIt3Wrapper_Res_Field=CompanyName|http://autoit-script.ru
#AutoIt3Wrapper_Res_Field=ProductVersion|1,0,2,0
#AutoIt3Wrapper_Res_Icon_Add=Icons\1.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\2.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\3.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\4.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\5.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\6.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\7.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\8.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\9.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\10.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\11.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\12.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\13.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\14.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\15.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\16.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\17.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\18.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\19.ico
#AutoIt3Wrapper_Res_Icon_Add=Icons\20.ico
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#Region Header

#CS
	Title:          ToDoIt - ToDo List Manager.
    Program name:   ToDoIt.au3
    Description:    Allows to manage ToDo lists.
    Author:         G.Sandler (CreatoR), D.Kozhanov (Medic84), www.autoit-script.ru
    Requirements:   AutoIt v3.3.6.1, Developed/Tested on Windows XP (Service Pack 3)
    Notes:          
#CE

#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <ComboConstants.au3>
#include <GUIListView.au3>
#include <GUIImageList.au3>
#include <GUIButton.au3>
#include <GUIDateTimePicker.au3>
#include <Date.au3>
#include <Misc.au3>
#include <File.au3>

#include "Includes\AboutBox.au3"
#include "Includes\ListViewEdit.au3"
#include "Includes\WinAPIEx.au3"
#include "Includes\ModernMenuRaw.au3"

Opt("GUIOnEventMode", 1)
;Opt("TrayOnEventMode", 1)
;Opt("TrayMenuMode", 1 + 2)

#EndRegion Header

#Region Global Variables

Global $sConfig_File 					= StringTrimRight(@ScriptFullPath, 3) & "ini"
Global $sIcons_File 					= @AutoItExe
Global $sTDITAgent_File 				= @ScriptDir & "\TDITAgent.exe"
Global $sApp_Path						= @AutoItExe
Global $sApp_Icon						= @AutoItExe
Global $sLangs_Path 					= @ScriptDir & "\Langs"
Global $sLanguage 						= IniRead($sConfig_File, "Main", "Language", "Eng")

If Not @Compiled Then
	$sIcons_File = @ScriptDir & "\Icons\Icons.icl"
	$sApp_Path = @AutoItExe & " " & FileGetShortName(@ScriptFullPath)
	$sApp_Icon = @ScriptDir & "\ToDoIt_Icon.ico"
EndIf

FileInstall("TDITAgent\TDITAgent.exe", 	$sTDITAgent_File, 1)

#Region Translation Vars

Global Enum _
	$iMsg_First = 0, _
		$iMsg_AppName, $iMsg_AboutApp, $iMsg_AboutAppVers, $iMsg_Dedication, _
		$iMsg_TitleCol, $iMsg_MarkCol, $iMsg_PriorCol, $iMsg_PrgrsCol, $iMsg_AlertCol, $iMsg_NotesCol, _
		$iMsg_MarkColDeflt, $iMsg_PriorColDeflt, $iMsg_PrgrsColDeflt, _
		$iMsg_TrayShowApp, $iMsg_TraySettings, $iMsg_TrayAbout, $iMsg_TrayExit, _
		$iMsg_GUIFileMenu, $iMsg_GUIOpnToDoListMItem, $iMsg_GUINewToDoListMItem, $iMsg_GUISavToDoListMItem, $iMsg_GUISavAsToDoListMItem, $iMsg_GUIRegstAppMItem, _
		$iMsg_GUISttngsMItem, $iMsg_GUIUnRegstAppMItem, $iMsg_GUIRcntToDoListMItem, $iMsg_GUIExitMItem, $iMsg_GUIHelpMenu, $iMsg_GUIAboutMItem, $iMsg_GUIMItem, _
		$iMsg_GUISavToDoListBtn, $iMsg_GUISavAsToDoListBtn, $iMsg_GUIOpnToDoListBtn, $iMsg_GUIClrToDoListBtn, $iMsg_GUIMarkLbl, $iMsg_GUIPriorLbl, $iMsg_GUIPrgrsLbl, _
		$iMsg_GUIAlertLbl, _
		$iMsg_GUIAlrtCmbDsbl, $iMsg_GUIAlrtCmbRunOnce, $iMsg_GUIAlrtCmbEvryDay, $iMsg_GUIAlrtCmbEvryWeek, $iMsg_GUIAlrtCmbEvryMonth, $iMsg_GUIAlrtCmbEvryYear, _
		$iMsg_GUIAlrtChckBxSu, $iMsg_GUIAlrtChckBxMo, $iMsg_GUIAlrtChckBxTu, $iMsg_GUIAlrtChckBxWe, $iMsg_GUIAlrtChckBxTh, $iMsg_GUIAlrtChckBxFr, $iMsg_GUIAlrtChckBxSa, _
		$iMsg_GUIAlrtActionBtn, $iMsg_KwrdsAlertAction, $iMsg_GUIAlrtDaysUnSlctd, _
		$iMsg_GUIAddToDoBtn, $iMsg_GUIEditToDoBtn, $iMsg_GUIRemvToDoBtn, _
		$iMsg_KwrdsNo, $iMsg_KwrdsCanceled, $iMsg_KwrdsShowMsg, $iMsg_KwrdsPlaySound, $iMsg_KwrdsRunProgram, _
		$iMsg_MsgTitlsAboutApp, $iMsg_MsgTitlsTskAlrt, $iMsg_MsgTitlsAtntn, $iMsg_MsgTitlsErr, $iMsg_MsgOptDontShow, _
		$iMsg_AskRemvToDoTsk, $iMsg_AskClrToDoList, $iMsg_AskSavToDoList, _
		$iMsg_OpnToDoListTitl, $iMsg_OpnToDoListFltr, $iMsg_OpnToDoListWrngFile, $iMsg_SavToDoListTitl, _
		$iMsg_SttngsMainTitle, $iMsg_SttngsMainGrp, $iMsg_SttngsLangLbl, _
		$iMsg_SttngsRunPrgrmWithWndsChckBx, $iMsg_SttngsRunTskAgntWithWndsChckBx, $iMsg_SttngsAppSetOnTopChckBx, _
		$iMsg_SttngsHidAppToTrayOnClsChckBx, $iMsg_SttngsHidAppToTrayOnMinChckBx, _
		$iMsg_SttngsOtherGrp, $iMsg_SttngsActnTskAlrtLbl, $iMsg_SttngsTskAlrtShowMsgChckBx, $iMsg_SttngsTskAlrtPlaySndChckBx, $iMsg_SttngsTskAlrtRunPrgrmChckBx, _
		$iMsg_SttngsTskAlrtPrgrmPrmsLbl, $iMsg_SttngsEditMarkListLbl, $iMsg_SttngsAskToDoRemoveChckBx, $iMsg_SttngsAskToDoListClearChckBx, _
		$iMsg_SttngsMrkTskAsDnAftrAlrtChckBx, _
		$iMsg_SttngsPrgrmRstrtRqirdLbl, $iMsg_SttngsOkBtn, $iMsg_SttngsCancelBtn, _
		$iMsg_SttngsSelSoundFileTitle, $iMsg_SttngsAudioFilesFltr, $iMsg_SttngsSelProgramTitle, $iMsg_SttngsProgramFilesFltr, _
	$iMsg_Last

#EndRegion Translation Vars

Global $aMessage 						= _AppRegisterTranslation($sLangs_Path & "\" & $sLanguage & ".lng")

Global $sApp_Title 						= $aMessage[$iMsg_AppName] ;"ToDoIt - ToDo List Manager"
Global $sApp_Version 					= "1.02 (beta)"

Global $sCopyright_Msg 					= "Copyright  2010 G.Sandler (CreatoR), D.Kozhanov (Medic84). All rights reserved."
Global $sWWW_URL 						= "www.autoit-script.ru"

Global $sToDoFileExt 					= "todo"

Global $sMSG_RECVD 						= "", $iMSG_RECVD_MARK = 0
_AppRegisterInteraction("__AppRegisterInteraction__" & $sApp_Title, Execute("$CmdLine[1]"))

Global $iSttngsGUI_Width 				= 650
Global $iSttngsGUI_Height 				= 450

Global $iMainGUI_Width 					= 750
Global $iMainGUI_Height 				= 655

If $iMainGUI_Width > @DesktopWidth Then
	$iMainGUI_Width 					= @DesktopWidth - 60
EndIf

If $iMainGUI_Height > @DesktopHeight Then
	$iMainGUI_Height 					= @DesktopHeight - 100
EndIf

Global $iToDoNotesEdit_Top				= $iMainGUI_Height - 60 - 40 - 220
Global $iToDoNotesEdit_Width 			= $iMainGUI_Width - 260
Global $iToDoNotesEdit_Height			= 180

Global $hExpnd_ImageList
Global $aRecentToDoList[2] 				= [0, -1]
Global $sCurr_ToDoList_File 			= ""
Global $bEditChanged 					= False
Global $bToDoListChanged 				= False

Global $aColumns_Data[7][2] 			= [ _
	[6], _
		[$aMessage[$iMsg_TitleCol], 	160], _
		[$aMessage[$iMsg_MarkCol], 		90], _
		[$aMessage[$iMsg_PriorCol], 	70], _
		[$aMessage[$iMsg_PrgrsCol], 	70], _
		[$aMessage[$iMsg_AlertCol], 	180], _
		[$aMessage[$iMsg_NotesCol], 	0] _
	]

Global $iTitle_Col 						= 0
Global $iMark_Col 						= 1
Global $iPriority_Col 					= 2
Global $iProgress_Col 					= 3
Global $iAlert_Col 						= 4
Global $iNotes_Col 						= 5

Global $iAsk_ToDoRemove					= IniRead($sConfig_File, "Main", "Ask When Removing ToDo Task", 1)
Global $iAsk_ToDoListClear				= IniRead($sConfig_File, "Main", "Ask When Clearing ToDo List", 1)

Global $iAppSetOnTop					= IniRead($sConfig_File, "Main", "Set On Top Attribute", 0)
Global $iHideAppToTrayOnClose			= IniRead($sConfig_File, "Main", "Hide To Tray When Closing", 0)
Global $iHideAppToTrayOnMinimize		= IniRead($sConfig_File, "Main", "Hide To Tray When Minimizing", 1)

Global $sTitle_Col_Default 				= ""
Global $sMark_Col_Default 				= IniRead($sConfig_File, "Main", "Mark Column Default", $aMessage[$iMsg_MarkColDeflt])
Global $sPriority_Col_Default 			= $aMessage[$iMsg_PriorColDeflt]
Global $sProgress_Col_Default 			= $aMessage[$iMsg_PrgrsColDeflt]

$sMark_Col_Default 						= _Iif($sMark_Col_Default = "", $aMessage[$iMsg_MarkColDeflt], $sMark_Col_Default)

Global $sAlert_Col_Default 				= _
	$aMessage[$iMsg_GUIAlrtCmbDsbl] & "|" & $aMessage[$iMsg_GUIAlrtCmbRunOnce] & "|" & $aMessage[$iMsg_GUIAlrtCmbEvryDay] & "|" & _
	$aMessage[$iMsg_GUIAlrtCmbEvryWeek] & "|" & $aMessage[$iMsg_GUIAlrtCmbEvryMonth] & "|" & $aMessage[$iMsg_GUIAlrtCmbEvryYear]

Global $sNotes_Col_Default 				= ""

Global $aLVEdit_ColCtrls[6] 			= _
	[ _
		0, _ 	;Edit
		1, _ 	;Combo
		1, _ 	;Combo
		1, _ 	;Combo
		0, _ 	;Edit
		0 _ 	;Edit
	]

Global $hImageList = _GUIImageList_Create(16, 16, 5, 3)
_GUIImageList_AddIcon($hImageList, $sIcons_File, 12)
_GUIImageList_AddIcon($hImageList, $sIcons_File, 11)
_GUIImageList_AddIcon($hImageList, $sIcons_File, 17)

#EndRegion Global Variables

#Region Tray

$nTrayIcon = _TrayIconCreate("", $sIcons_File, 0, "_Tray_Callback")
_TrayIconSetClick($nTrayIcon, 16)

$nTrayMenu = _TrayCreateContextMenu($nTrayIcon)
$nTray_SideItem = _CreateSideMenu($nTrayMenu)
_SetSideMenuText($nTray_SideItem, "Tray Menu")
_SetSideMenuColor($nTray_SideItem, 0x00FFFF) ; yellow; default color - white
_SetSideMenuBkColor($nTray_SideItem, 0x802222) ; bottom start color - dark blue
_SetSideMenuBkGradColor($nTray_SideItem, 0x4477AA) ; top end color - orange

$nShowApp_TrayItem = _TrayCreateItem($aMessage[$iMsg_TrayShowApp], $nTrayMenu)
_TrayItemSetIcon($nShowApp_TrayItem, $sIcons_File, 0)
GUICtrlSetState($nShowApp_TrayItem, $GUI_DEFBUTTON)
GUICtrlSetOnEvent($nShowApp_TrayItem, "_Tray_Events")
$nSettings_TrayItem = _TrayCreateItem($aMessage[$iMsg_TraySettings], $nTrayMenu)
_TrayItemSetIcon($nSettings_TrayItem, $sIcons_File, -21)
GUICtrlSetOnEvent($nSettings_TrayItem, "_Tray_Events")
$nAbout_TrayItem = _TrayCreateItem($aMessage[$iMsg_TrayAbout], $nTrayMenu)
_TrayItemSetIcon($nAbout_TrayItem, $sIcons_File, -22)
GUICtrlSetOnEvent($nAbout_TrayItem, "_Tray_Events")
_TrayCreateItem("", $nTrayMenu)
_TrayItemSetIcon(-1, "", 0)
$nExit_TrayItem = _TrayCreateItem($aMessage[$iMsg_TrayExit], $nTrayMenu)
_TrayItemSetIcon($nExit_TrayItem, $sIcons_File, -20)
GUICtrlSetOnEvent($nExit_TrayItem, "_Tray_Events")

#EndRegion Tray

#Region GUI

$hGUI = GUICreate($sApp_Title, $iMainGUI_Width, $iMainGUI_Height, -1, -1, BitOR($GUI_SS_DEFAULT_GUI, $WS_CLIPSIBLINGS, $WS_CLIPCHILDREN))
GUISetIcon($sApp_Icon, $hGUI)

GUISetOnEvent($GUI_EVENT_CLOSE, "_Main_Events")
GUISetOnEvent($GUI_EVENT_MINIMIZE, "_Main_Events")

#Region Menu

$nFile_Menu = GUICtrlCreateMenu($aMessage[$iMsg_GUIFileMenu])
$nFile_SideItem = _CreateSideMenu($nFile_Menu)
_SetSideMenuText($nFile_SideItem, "File Menu")
_SetSideMenuColor($nFile_SideItem, 0xFFFFFF)
_SetSideMenuBkColor($nFile_SideItem, 0x921801)
_SetSideMenuBkGradColor($nFile_SideItem, 0xFBCE92)

$nNewToDoList_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUINewToDoListMItem] & @TAB & "(CTRL + N)", $nFile_Menu, $sIcons_File, -9)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nOpenToDoList_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUIOpnToDoListMItem] & @TAB & "(CTRL + SHIFT + O)", $nFile_Menu, $sIcons_File, -7)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nSaveToDoList_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUISavToDoListMItem] & @TAB & "(CTRL + S)", $nFile_Menu, $sIcons_File, -5)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nSaveAsToDoList_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUISavAsToDoListMItem] & @TAB & "(CTRL + SHIFT + S)", $nFile_Menu, $sIcons_File, -6)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $nFile_Menu, "", 0)

$nSettings_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUISttngsMItem] & @TAB & "(SHIFT + S)", $nFile_Menu, $sIcons_File, -21)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $nFile_Menu, "", 0)

$nRegisterApp_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUIRegstAppMItem], $nFile_Menu, $sIcons_File, -23)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nUnRegisterApp_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUIUnRegstAppMItem], $nFile_Menu, $sIcons_File, -24)
GUICtrlSetOnEvent(-1, "_Main_Events")

If RegRead("HKCR\" & $sToDoFileExt & "file\shell\Open\command", "") = "" Then
	GUICtrlSetState($nUnRegisterApp_MenuItem, $GUI_DISABLE)
Else
	GUICtrlSetState($nRegisterApp_MenuItem, $GUI_DISABLE)
EndIf

_GUICtrlCreateODMenuItem("", $nFile_Menu, "", 0)

$nRecentToDoListFiles_Menu = _GUICtrlCreateODMenu($aMessage[$iMsg_GUIRcntToDoListMItem], $nFile_Menu, $sIcons_File, -13)
_FillRecentToDoListFiles_Proc($nRecentToDoListFiles_Menu)

_GUICtrlCreateODMenuItem("", $nFile_Menu, "", 0)

$nExit_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUIExitMItem] & @TAB & "(ALT + F4)", $nFile_Menu, $sIcons_File, -20)
GUICtrlSetOnEvent(-1, "_Main_Events")

$nHelp_Menu = GUICtrlCreateMenu($aMessage[$iMsg_GUIHelpMenu])
;~ $nHelp_SideItem = _CreateSideMenu($nHelp_Menu)
;~ _SetSideMenuText($nHelp_SideItem, "About")
;~ _SetSideMenuColor($nHelp_SideItem, 0xFFFFFF)
;~ _SetSideMenuBkColor($nHelp_SideItem, 0x921801)
;~ _SetSideMenuBkGradColor($nHelp_SideItem, 0xFBCE92)

$nAbout_MenuItem = _GUICtrlCreateODMenuItem($aMessage[$iMsg_GUIAboutMItem] & @TAB & "(F1)", $nHelp_Menu, $sIcons_File, -22)
GUICtrlSetOnEvent(-1, "_Main_Events")

#EndRegion Menu

#Region Front Elements

$nMainStatusLbl = GUICtrlCreateLabel("", 10, 5, $iMainGUI_Width - 20, 15)
GUICtrlSetColor(-1, 0xFF0000)
GUICtrlSetFont(-1, 9, 800)

$nSaveToDoList_Btn = _GUICtrlCreateButtonEx($aMessage[$iMsg_GUISavToDoListBtn], 10, 25, 90, 25, -1, -1, $sIcons_File, 4)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetTip(-1, "(CTRL + S)")
$nSaveAsToDoList_Btn = _GUICtrlCreateButtonEx($aMessage[$iMsg_GUISavAsToDoListBtn], 110, 25, 110, 25, -1, -1, $sIcons_File, 5)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetTip(-1, "(CTRL + SHIFT + S)")
$nOpenToDoList_Btn = _GUICtrlCreateButtonEx($aMessage[$iMsg_GUIOpnToDoListBtn], 240, 25, 90, 25, -1, -1, $sIcons_File, 6)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetTip(-1, "(CTRL + SHIFT + O)")
$nClearToDoList_Btn = _GUICtrlCreateButtonEx($aMessage[$iMsg_GUIClrToDoListBtn], $iMainGUI_Width - 120 - 10, 25, 120, 25, -1, -1, $sIcons_File, 7)
GUICtrlSetOnEvent(-1, "_Main_Events")

_InitEditLib("WM_NOTIFY")

$nListView = GUICtrlCreateListView("", 10, 60, $iMainGUI_Width - 20, $iMainGUI_Height - 90 - 40, -1, BitOR($WS_EX_DLGMODALFRAME, $WS_EX_CLIENTEDGE))
$hListView = GUICtrlGetHandle($nListView)
$nLVEdit_LV_CTRL = $nListView
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlListView_SetImageList($hListView, $hImageList, 1)
_GUICtrlListView_SetExtendedListViewStyle($nListView, BitOR($LVS_EX_FULLROWSELECT, $LVS_EX_GRIDLINES, $LVS_EX_CHECKBOXES))

For $i = 1 To $aColumns_Data[0][0]
	_GUICtrlListView_InsertColumn($nListView, $i-1, $aColumns_Data[$i][0], $aColumns_Data[$i][1])
Next

$nAddToDo_Btn = _GUICtrlCreateButtonEx($aMessage[$iMsg_GUIAddToDoBtn], 10, $iMainGUI_Height - 65, 130, 25, -1, -1, $sIcons_File, 8)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetTip(-1, "(SHIFT + A)")

$nEditToDo_Btn = GUICtrlCreateButton($aMessage[$iMsg_GUIEditToDoBtn], $iMainGUI_Width - 155 - 10, $iMainGUI_Height - 65, 155, 25, $BS_ICON)
GUICtrlSetOnEvent(-1, "_Main_Events")
_GUICtrlButton_SetImageEx($hExpnd_ImageList, $nEditToDo_Btn, $sIcons_File, 9)
GUICtrlSetTip(-1, "(SHIFT + E)")

$nRemoveToDo_Btn = _GUICtrlCreateButtonEx($aMessage[$iMsg_GUIRemvToDoBtn], $iMainGUI_Width - 310, $iMainGUI_Height - 65, 130, 25, -1, -1, $sIcons_File, 17)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetTip(-1, "(SHIFT + DEL)")

$iHyprLnkWidth = __AboutBox_GUICtrlLabelGetTextWidth($aMessage[$iMsg_Dedication])
$nAutoItScript_ru_Hyperlink = __AboutBox_GUICtrlHyperlink_Create($aMessage[$iMsg_Dedication], _
	($iMainGUI_Width / 2) - ($iHyprLnkWidth[0] / 2), $iMainGUI_Height - 35, -1, 15, 0x804000, $sWWW_URL)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetFont($nAutoItScript_ru_Hyperlink, 8.5, -1, 0)

#EndRegion Front Elements

#Region Hidden Edit ToDo controls

$nFirstToDoEdit_Ctrl = GUICtrlCreateDummy() + 1

$nToDoNotes_Edit = GUICtrlCreateEdit("", 10,  $iToDoNotesEdit_Top + 70, $iToDoNotesEdit_Width - 15, $iToDoNotesEdit_Height)

GUICtrlCreateLabel($aMessage[$iMsg_GUIMarkLbl], $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 70, -1, 15)
$nToDoMark_Combo = GUICtrlCreateCombo("", $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 85, 120, 50)
GUICtrlSetData(-1, $sMark_Col_Default)
GUICtrlSetOnEvent(-1, "_Main_Events")

GUICtrlCreateLabel($aMessage[$iMsg_GUIPriorLbl], $iMainGUI_Width - 130, $iToDoNotesEdit_Top + 70, -1, 15)
$nToDoPriority_Combo = GUICtrlCreateCombo("", $iMainGUI_Width - 130, $iToDoNotesEdit_Top + 70 + 15, 120, 50)
GUICtrlSetData(-1, $sPriority_Col_Default)
GUICtrlSetOnEvent(-1, "_Main_Events")

GUICtrlCreateLabel($aMessage[$iMsg_GUIPrgrsLbl], $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 70 + 43, -1, 15)
$nToDoProgress_Combo = GUICtrlCreateCombo("", $iMainGUI_Width - 200, $iToDoNotesEdit_Top + 70 + 40, 190, 50)
GUICtrlSetData(-1, $sProgress_Col_Default)
GUICtrlSetOnEvent(-1, "_Main_Events")

GUICtrlCreateLabel($aMessage[$iMsg_GUIAlertLbl], $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 70 + 65, 250, 15, $SS_CENTER)
$nToDoAlert_Combo = GUICtrlCreateCombo("", $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 70 + 80, $iMainGUI_Width - $iToDoNotesEdit_Width - 10, 30, _
	BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetData(-1, $sAlert_Col_Default, $aMessage[$iMsg_GUIAlrtCmbDsbl])

$nToDoAlert_Date = GUICtrlCreateDate("", $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 70 + 105, 120, 20, $DTS_SHORTDATEFORMAT)
GUICtrlSendMsg(-1, $DTM_SETFORMATW, 0, "dd.MM.yyyy")
GUICtrlSetOnEvent(-1, "_Main_Events")

$nToDoAlert_Time = GUICtrlCreateDate("", $iMainGUI_Width - 130, $iToDoNotesEdit_Top + 70 + 105, 120, 20, $DTS_TIMEFORMAT)
GUICtrlSendMsg(-1, $DTM_SETFORMATW, 0, "HH:mm:ss")
GUICtrlSetOnEvent(-1, "_Main_Events")

$nToDoAlertSu_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_GUIAlrtChckBxSu], $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 70 + 130, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nToDoAlertMo_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_GUIAlrtChckBxMo], $iToDoNotesEdit_Width + 70, $iToDoNotesEdit_Top + 70 + 130, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nToDoAlertTu_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_GUIAlrtChckBxTu], $iToDoNotesEdit_Width + 140, $iToDoNotesEdit_Top + 70 + 130, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nToDoAlertWe_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_GUIAlrtChckBxWe], $iToDoNotesEdit_Width + 210, $iToDoNotesEdit_Top + 70 + 130, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nToDoAlertTh_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_GUIAlrtChckBxTh], $iToDoNotesEdit_Width + 35, $iToDoNotesEdit_Top + 70 + 145, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nToDoAlertFr_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_GUIAlrtChckBxFr], $iToDoNotesEdit_Width + 105, $iToDoNotesEdit_Top + 70 + 145, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
$nToDoAlertSa_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_GUIAlrtChckBxSa], $iToDoNotesEdit_Width + 175, $iToDoNotesEdit_Top + 70 + 145, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")

$nToDoAlertAction_Btn = GUICtrlCreateButton($aMessage[$iMsg_GUIAlrtActionBtn], $iToDoNotesEdit_Width, $iToDoNotesEdit_Top + 70 + 162, 250, 20)
GUICtrlSetOnEvent(-1, "_Main_Events")

$nLastToDoEdit_Ctrl = GUICtrlCreateDummy() - 1

For $nCtrlID = $nFirstToDoEdit_Ctrl To $nLastToDoEdit_Ctrl
	GUICtrlSetState($nCtrlID, BitOR($GUI_HIDE, $GUI_DISABLE))
Next

#EndRegion Hidden Edit ToDo controls

#EndRegion GUI

#Region Initialization

$nDummyCtrl = GUICtrlCreateDummy()
$nSpace_Ctrl = GUICtrlCreateDummy()
GUICtrlSetOnEvent($nSpace_Ctrl, "_Main_Events")

Dim $aAccelKeys[24][2] = _
	[ _
		["{SPACE}", 	$nSpace_Ctrl], _	; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["^{SPACE}", 	$nDummyCtrl], _		; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["+{SPACE}", 	$nDummyCtrl], _		; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["!{SPACE}", 	$nDummyCtrl], _		; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["^+{SPACE}", 	$nDummyCtrl], _		; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["^!{SPACE}", 	$nDummyCtrl], _		; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["+!{SPACE}", 	$nDummyCtrl], _		; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["^+!{SPACE}", 	$nDummyCtrl], _		; ======== Prevent LV item checkbox from beeen checked via keyboard ========
		["{F1}", 		$nAbout_MenuItem], _
		["^n", 			$nNewToDoList_MenuItem], _
		["^", 			$nNewToDoList_MenuItem], _
		["^+o", 		$nOpenToDoList_MenuItem], _
		["^+", 		$nOpenToDoList_MenuItem], _
		["^s", 			$nSaveToDoList_MenuItem], _
		["^", 			$nSaveToDoList_MenuItem], _
		["^+s", 		$nSaveAsToDoList_MenuItem], _
		["^+", 		$nSaveAsToDoList_MenuItem], _
		["+s", 			$nSettings_MenuItem], _
		["+", 			$nSettings_MenuItem], _
		["+e", 			$nEditToDo_Btn], _
		["+", 			$nEditToDo_Btn], _
		["+a", 			$nAddToDo_Btn], _
		["+", 			$nAddToDo_Btn], _
		["+{DEL}", 		$nRemoveToDo_Btn] _
	]

GUISetAccelerators($aAccelKeys, $hGUI)
GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
_GUICtrlListView_RegisterSortCallBackEx($hListView)
GUISetState(@SW_SHOW, $hGUI)
WinSetOnTop($hGUI, "", $iAppSetOnTop)

If $CmdLine[0] > 0 Then
	_OpenToDoList_Proc($CmdLine[1])
Else
	_OpenLastToDoList_Proc()
EndIf

If _RegIsFirstAppRun("ToDoIt") Then
	_RegSetFirstAppRun("ToDoIt")
	_RegisterApp_Proc()
	ProcessClose("TDITAgent.exe")
	ProcessWaitClose("TDITAgent.exe", 2000)
EndIf

Run(@ScriptDir & "\TDITAgent.exe")
_WinAPI_EmptyWorkingSet()

#EndRegion Initialization

#Region Main Loop

While 1
	_MonitorEditState($hGUI, $nLVEdit_MainCtrl, $iLVEdit_EditFlag, $nLVEdit_LV_CTRL, $aLVEdit_DATA, $aLVEdit_ColCtrls)
	
	If $bLVItemChanged Then
		$bLVItemChanged = False
		
		$iIndex = _GUICtrlListView_GetSelectedIndices($nListView)
		
		$sDateFormat = "dd.MM.yyyy"
		$iAlertDaysChckBx_State = BitOR($GUI_DISABLE, $GUI_UNCHECKED)
		$iAlertDate_State = $GUI_DISABLE
		$iAlertTime_State = $GUI_DISABLE
		$iAlertAction_State = $GUI_DISABLE
		
		If $iIndex <> "" Then
			$iIndex = Number($iIndex)
			$iChecked = _GUICtrlListView_GetItemChecked($nListView, $iIndex)
			
			$nState = $GUI_ENABLE
			If $iChecked Then $nState = $GUI_DISABLE
			
			$sMark = _GUICtrlListView_GetItemText($nListView, $iIndex, $iMark_Col)
			$sPriority = _GUICtrlListView_GetItemText($nListView, $iIndex, $iPriority_Col)
			$sProgress = _GUICtrlListView_GetItemText($nListView, $iIndex, $iProgress_Col)
			$sAlertData = _GUICtrlListView_GetItemText($nListView, $iIndex, $iAlert_Col)
			$sNotes = _GUICtrlListView_GetItemText($nListView, $iIndex, $iNotes_Col)
			
			$sAlertType = StringRegExpReplace($sAlertData, "^(.*?):.*", "\1")
			$sAlertDate = StringRegExpReplace($sAlertData, "^.*?:.*?(\d{2}(?:\.\d{2})?(?:\.\d{4})?).*", "\1")
			$sAlertTime = StringRegExpReplace($sAlertData, "^.*?:.*?(\d{2}:\d{2}:\d{2}).*", "\1")
			$aAlertDays = StringRegExp($sAlertData, "([^\d]{3}),", 3)
			
			Switch $sAlertType
				Case $aMessage[$iMsg_GUIAlrtCmbRunOnce]
					$iAlertDate_State = $nState
					$iAlertTime_State = $nState
					$iAlertAction_State = $nState
				Case $aMessage[$iMsg_GUIAlrtCmbEvryDay]
					$iAlertTime_State = $nState
					$iAlertAction_State = $nState
				Case $aMessage[$iMsg_GUIAlrtCmbEvryWeek]
					$iAlertDaysChckBx_State = BitOR($nState, $GUI_UNCHECKED)
					$iAlertTime_State = $nState
					$iAlertAction_State = $nState
				Case $aMessage[$iMsg_GUIAlrtCmbEvryMonth], $aMessage[$iMsg_GUIAlrtCmbEvryYear]
					$iAlertDate_State = $nState
					$iAlertTime_State = $nState
					$iAlertAction_State = $nState
					
					If $sAlertType = $aMessage[$iMsg_GUIAlrtCmbEvryMonth] Then
						$sDateFormat = "dd"
						$sAlertDate = @YEAR & "." & @MON & "." & $sAlertDate
					Else
						$sDateFormat = "dd.MM"
						$sAlertDate = @YEAR & "." & StringRight($sAlertDate, 2) & "." & StringLeft($sAlertDate, 2)
					EndIf
				Case Else
					$iAlertTime_State = $GUI_DISABLE
					$iAlertDaysChckBx_State = BitOR($GUI_DISABLE, $GUI_UNCHECKED)
			EndSwitch
			
			For $nCtrlID = $nToDoAlertSu_ChckBx To $nToDoAlertSa_ChckBx
				GUICtrlSetState($nCtrlID, $iAlertDaysChckBx_State)
			Next
			
			For $i = 0 To UBound($aAlertDays)-1
				Switch $aAlertDays[$i]
					Case $aMessage[$iMsg_GUIAlrtChckBxSu]
						GUICtrlSetState($nToDoAlertSu_ChckBx, BitOR($nState, $GUI_CHECKED))
					Case $aMessage[$iMsg_GUIAlrtChckBxMo]
						GUICtrlSetState($nToDoAlertMo_ChckBx, BitOR($nState, $GUI_CHECKED))
					Case $aMessage[$iMsg_GUIAlrtChckBxTu]
						GUICtrlSetState($nToDoAlertTu_ChckBx, BitOR($nState, $GUI_CHECKED))
					Case $aMessage[$iMsg_GUIAlrtChckBxWe]
						GUICtrlSetState($nToDoAlertWe_ChckBx, BitOR($nState, $GUI_CHECKED))
					Case $aMessage[$iMsg_GUIAlrtChckBxTh]
						GUICtrlSetState($nToDoAlertTh_ChckBx, BitOR($nState, $GUI_CHECKED))
					Case $aMessage[$iMsg_GUIAlrtChckBxFr]
						GUICtrlSetState($nToDoAlertFr_ChckBx, BitOR($nState, $GUI_CHECKED))
					Case $aMessage[$iMsg_GUIAlrtChckBxSa]
						GUICtrlSetState($nToDoAlertSa_ChckBx, BitOR($nState, $GUI_CHECKED))
				EndSwitch
			Next
		Else
			$nState = $GUI_DISABLE
			$iAlertDaysChckBx_State = BitOR($GUI_DISABLE, $GUI_UNCHECKED)
			
			$sMark = ""
			$sPriority = ""
			$sProgress = ""
			$sAlertType = ""
			$sAlertDate = ""
			$sAlertTime = ""
			$sNotes = ""
			
			For $nCtrlID = $nToDoAlertSu_ChckBx To $nToDoAlertSa_ChckBx
				GUICtrlSetState($nCtrlID, $iAlertDaysChckBx_State)
			Next
		EndIf
		
		For $nCtrlID = $nFirstToDoEdit_Ctrl To $nLastToDoEdit_Ctrl
			If $nCtrlID = $nToDoAlertSu_ChckBx Then
				For $nSubCtrlID = $nCtrlID To $nToDoAlertSa_ChckBx
					$nCtrlID += 1
				Next
			EndIf
			
			If $nCtrlID <> $nToDoAlert_Date And $nCtrlID <> $nToDoAlert_Time And $nCtrlID <> $nToDoAlertAction_Btn Then
				GUICtrlSetState($nCtrlID, $nState)
			EndIf
		Next
		
		If $sMark = "" Then
			GUICtrlSetData($nToDoMark_Combo, "")
			$sMark = $sMark_Col_Default
		EndIf
		
		If $sPriority = "" Then
			GUICtrlSetData($nToDoPriority_Combo, "")
			$sPriority = $sPriority_Col_Default
		EndIf
		
		If $sProgress = "" Then
			GUICtrlSetData($nToDoProgress_Combo, "")
			$sProgress = $sProgress_Col_Default
		EndIf
		
		If $sAlertType = "" Or $sAlertType = $sAlertData Then
			GUICtrlSetData($nToDoAlert_Combo, "")
			$sAlertType = $sAlert_Col_Default
		EndIf
		
		GUICtrlSetData($nToDoMark_Combo, $sMark, $sMark)
		GUICtrlSetData($nToDoPriority_Combo, $sPriority, $sPriority)
		GUICtrlSetData($nToDoProgress_Combo, $sProgress, $sProgress)
		GUICtrlSetData($nToDoAlert_Combo, $sAlertType, $aMessage[$iMsg_GUIAlrtCmbDsbl])
		GUICtrlSetData($nToDoNotes_Edit, StringReplace($sNotes, "\n", @CRLF))
		
		GUICtrlSendMsg($nToDoAlert_Date, $DTM_SETFORMATW, 0, $sDateFormat)
		GUICtrlSetData($nToDoAlert_Date, $sAlertDate)
		GUICtrlSetState($nToDoAlert_Date, $iAlertDate_State)
		GUICtrlSetState($nToDoAlert_Time, $iAlertTime_State)
		GUICtrlSetState($nToDoAlertAction_Btn, $iAlertTime_State)
		
		If $sAlertTime = "" Or $sAlertTime = $sAlertData Then
			GUICtrlSetData($nToDoAlert_Time, "")
		Else
			Dim $a_Date[7] = [False, @YEAR, "1", "1", StringLeft($sAlertTime, 2), StringMid($sAlertTime, 4, 2), StringRight($sAlertTime, 2)]
			_GUICtrlDTP_SetSystemTime(GUICtrlGetHandle($nToDoAlert_Time), $a_Date)
		EndIf
	EndIf
	
	If $bEditChanged Then
		$iCtrlID = $bEditChanged
		$bEditChanged = False
		
		$iIndex = _GUICtrlListView_GetSelectedIndices($nListView)
		
		Local $iSubIteml, $sData = GUICtrlRead($iCtrlID)
		
		Switch $iCtrlID
			Case $nToDoMark_Combo
				$iSubItem = $iMark_Col
			Case $nToDoPriority_Combo
				$iSubItem = $iPriority_Col
			Case $nToDoProgress_Combo
				$iSubItem = $iProgress_Col
			Case $nToDoAlert_Combo, $nToDoAlert_Date, $nToDoAlert_Time, $nToDoAlertSu_ChckBx To $nToDoAlertSa_ChckBx
				$iSubItem = $iAlert_Col
				Local $sItemText = _GUICtrlListView_GetItemText($nListView, Number($iIndex), $iSubItem)
				Local $sAlertActionData = StringRegExpReplace($sItemText, ".*?(" & $aMessage[$iMsg_KwrdsAlertAction] & ":.*)", "\1")
				Local $sToDoAlert_Combo_Read = GUICtrlRead($nToDoAlert_Combo)
				Local $sAlertDate = GUICtrlRead($nToDoAlert_Date), $sAlertTime = GUICtrlRead($nToDoAlert_Time)
				
				If $sAlertActionData = $sItemText Then
					$sAlertActionData = ""
				EndIf
				
				Switch $sToDoAlert_Combo_Read
					Case $aMessage[$iMsg_GUIAlrtCmbDsbl]
						$sData = $aMessage[$iMsg_KwrdsNo]
					Case $aMessage[$iMsg_GUIAlrtCmbRunOnce]
						$sData = $sToDoAlert_Combo_Read & ": " & $sAlertDate & " " & $sAlertTime & " " & $sAlertActionData
					Case $aMessage[$iMsg_GUIAlrtCmbEvryDay]
						$sData = $sToDoAlert_Combo_Read & ": " & $sAlertTime & " " & $sAlertActionData
					Case $aMessage[$iMsg_GUIAlrtCmbEvryWeek]
						Local $sDays = ""
						
						For $iCtrlID = $nToDoAlertSu_ChckBx To $nToDoAlertSa_ChckBx
							If BitAND(GUICtrlRead($iCtrlID), $GUI_CHECKED) = $GUI_CHECKED Then
								$sDays &= GUICtrlRead($iCtrlID, 1) & ", "
							EndIf
						Next
						
						If $sDays = "" Then
							$sDays = $aMessage[$iMsg_GUIAlrtDaysUnSlctd]
						Else
							$sDays &= $sAlertTime
						EndIf
						
						$sData = $sToDoAlert_Combo_Read & ": " & $sDays & " " & $sAlertActionData
					Case $aMessage[$iMsg_GUIAlrtCmbEvryMonth]
						$sData = $sToDoAlert_Combo_Read & ": " & StringLeft($sAlertDate, 2) & " , " & $sAlertTime & " " & $sAlertActionData
					Case $aMessage[$iMsg_GUIAlrtCmbEvryYear]
						$sData = $sToDoAlert_Combo_Read & ": " & _
							StringLeft($sAlertDate, 2) & "." & StringMid($sAlertDate, 4, 2) & ", " & $sAlertTime & " " & $sAlertActionData
				EndSwitch
			Case $nToDoNotes_Edit
				$iSubItem = $iNotes_Col
				$sData = StringReplace(GUICtrlRead($nToDoNotes_Edit), @CRLF, "\n")
			Case Else
				ContinueLoop
		EndSwitch
		
		If $iIndex <> "" Then
			_GUICtrlListView_SetItemText($nListView, Number($iIndex), $sData, $iSubItem)
			$bToDoListChanged = True
		EndIf
	EndIf
	
	If $bToDoListChanged Then
		$bToDoListChanged = False
		WinSetTitle($hGUI, "", StringRegExpReplace(WinGetTitle($hGUI), " \Q[*]\E$", "") & " [*]")
	EndIf
WEnd

#EndRegion Main Loop

#Region Program Functions

Func _AppRegisterTranslation($sLang_File, $sSection = "Translation")
	Local $aMessage[$iMsg_Last+1], $sMessage
	
	;Dedication string
	$aMessage[$iMsg_Dedication] = "Project made specialy for AutoIt Russian Community"
	
	;Options and vars
	$aMessage[$iMsg_AppName] = "ToDoIt - ToDo List Manager"
	$aMessage[$iMsg_AboutApp] = ""
	$aMessage[$iMsg_AboutAppVers] = "Version"
	$aMessage[$iMsg_TitleCol] = "Title"
	$aMessage[$iMsg_MarkCol] = "Mark"
	$aMessage[$iMsg_PriorCol] = "Priority"
	$aMessage[$iMsg_PrgrsCol] = "Progress"
	$aMessage[$iMsg_AlertCol] = "Alert"
	$aMessage[$iMsg_NotesCol] = "Notes"
	$aMessage[$iMsg_MarkColDeflt] = "Important|Canceled|Yesturday|Today|Tomorow"
	$aMessage[$iMsg_PriorColDeflt] = "1|2|3|4|5|6|7|8|9|10"
	$aMessage[$iMsg_PrgrsColDeflt] = "0%|10%|20%|30%|40%|50%|60%|70%|80%|90%|100%"
	
	;Tray
	$aMessage[$iMsg_TrayShowApp] = "Show program"
	$aMessage[$iMsg_TraySettings] = "Settings"
	$aMessage[$iMsg_TrayAbout] = "About program"
	$aMessage[$iMsg_TrayExit] = "Exit"
	
	;GUI -> Menu
	$aMessage[$iMsg_GUIFileMenu] = "&File"
	$aMessage[$iMsg_GUINewToDoListMItem] = "&New list"
	$aMessage[$iMsg_GUIOpnToDoListMItem] = "&Open"
	$aMessage[$iMsg_GUISavToDoListMItem] = "&Save"
	$aMessage[$iMsg_GUISavAsToDoListMItem] = "Save &as..."
	$aMessage[$iMsg_GUISttngsMItem] = "Se&ttings"
	$aMessage[$iMsg_GUIRegstAppMItem] = "&Register program in the system"
	$aMessage[$iMsg_GUIUnRegstAppMItem] = "&UnRegister program in the system"
	$aMessage[$iMsg_GUIRcntToDoListMItem] = "Recent Todo &lists"
	$aMessage[$iMsg_GUIExitMItem] = "&Exit"
	$aMessage[$iMsg_GUIHelpMenu] = "&Help"
	$aMessage[$iMsg_GUIAboutMItem] = "About &program"
	
	;GUI -> Front Interface
	$aMessage[$iMsg_GUISavToDoListBtn] = "Save"
	$aMessage[$iMsg_GUISavAsToDoListBtn] = "Save as..."
	$aMessage[$iMsg_GUIOpnToDoListBtn] = "Open"
	$aMessage[$iMsg_GUIClrToDoListBtn] = "Clear the list"
	
	;Hidden Control
	$aMessage[$iMsg_GUIMarkLbl] = "Mark:"
	$aMessage[$iMsg_GUIPriorLbl] = "Priority:"
	$aMessage[$iMsg_GUIPrgrsLbl] = "Progress:"
	$aMessage[$iMsg_GUIAlertLbl] = "Alert:"
	$aMessage[$iMsg_GUIAlrtCmbDsbl] = "Disabled"
	$aMessage[$iMsg_GUIAlrtCmbRunOnce] = "Run Once"
	$aMessage[$iMsg_GUIAlrtCmbEvryDay] = "Every day"
	$aMessage[$iMsg_GUIAlrtCmbEvryWeek] = "Every week"
	$aMessage[$iMsg_GUIAlrtCmbEvryMonth] = "Every month"
	$aMessage[$iMsg_GUIAlrtCmbEvryYear] = "Every year"
	$aMessage[$iMsg_GUIAlrtDaysUnSlctd] = "No selected days"
	$aMessage[$iMsg_GUIAlrtChckBxSu] = "Sun"
	$aMessage[$iMsg_GUIAlrtChckBxMo] = "Mon"
	$aMessage[$iMsg_GUIAlrtChckBxTu] = "Tue"
	$aMessage[$iMsg_GUIAlrtChckBxWe] = "Wen"
	$aMessage[$iMsg_GUIAlrtChckBxTh] = "Thu"
	$aMessage[$iMsg_GUIAlrtChckBxFr] = "Fri"
	$aMessage[$iMsg_GUIAlrtChckBxSa] = "Sat"
	$aMessage[$iMsg_GUIAlrtActionBtn] = "Alert action"
	;Hidden Control
	
	$aMessage[$iMsg_GUIAddToDoBtn] = "Add ToDo task"
	$aMessage[$iMsg_GUIEditToDoBtn] = "Edit task"
	$aMessage[$iMsg_GUIRemvToDoBtn] = "Delete task"
	
	;Keywords
	$aMessage[$iMsg_KwrdsNo] = "NO"
	$aMessage[$iMsg_KwrdsCanceled] = "Canceled"
	$aMessage[$iMsg_KwrdsAlertAction] = "Action"
	$aMessage[$iMsg_KwrdsShowMsg] = "Message"
	$aMessage[$iMsg_KwrdsPlaySound] = "Sound"
	$aMessage[$iMsg_KwrdsRunProgram] = "Program"
	
	;Message Titles
	$aMessage[$iMsg_MsgTitlsAboutApp] = "About program"
	$aMessage[$iMsg_MsgTitlsTskAlrt] = "Task Alert"
	$aMessage[$iMsg_MsgTitlsAtntn] = "Attention!"
	$aMessage[$iMsg_MsgTitlsErr] = "Error"
	
	;Do not show this message string
	$aMessage[$iMsg_MsgOptDontShow] = "Do not show this message again"
	
	;Remove ToDo task question
	$aMessage[$iMsg_AskRemvToDoTsk] = "This action will delete selected task, continue?"
	
	;Clear ToDo list question
	$aMessage[$iMsg_AskClrToDoList] = "The list will be cleared!\nContinue?"
	
	;Save current ToDo list question
	$aMessage[$iMsg_AskSavToDoList] = "Current list was modified.\nAll it's changes will be lost after this action, save ToDo list?"
	
	;Open/Save ToDo list file
	$aMessage[$iMsg_OpnToDoListTitl] = "Open ToDo list"
	$aMessage[$iMsg_OpnToDoListFltr] = "ToDo Lists"
	$aMessage[$iMsg_OpnToDoListWrngFile] = "Wrong file format"
	$aMessage[$iMsg_SavToDoListTitl] = "Save ToDo list..."
	
	;Settings
	$aMessage[$iMsg_SttngsMainTitle] = "Setting"
	$aMessage[$iMsg_SttngsMainGrp] = "Main"
	$aMessage[$iMsg_SttngsLangLbl] = "* Language:"
	$aMessage[$iMsg_SttngsRunPrgrmWithWndsChckBx] = "Run Program when windows start"
	$aMessage[$iMsg_SttngsRunTskAgntWithWndsChckBx] = "Run Tasks Agent when windows start"
	$aMessage[$iMsg_SttngsAppSetOnTopChckBx] = "Set 'On Top' attribute for main window"
	$aMessage[$iMsg_SttngsHidAppToTrayOnClsChckBx] = "Hide program window to tray when closing"
	$aMessage[$iMsg_SttngsHidAppToTrayOnMinChckBx] = "Hide program window to tray when minimizing"
	$aMessage[$iMsg_SttngsOtherGrp] = "Other"
	$aMessage[$iMsg_SttngsActnTskAlrtLbl] = "Default action on task alert:"
	$aMessage[$iMsg_SttngsTskAlrtShowMsgChckBx] = "Show simple alert message"
	$aMessage[$iMsg_SttngsTskAlrtPlaySndChckBx] = "Play sound"
	$aMessage[$iMsg_SttngsTskAlrtRunPrgrmChckBx] = "Run program"
	$aMessage[$iMsg_SttngsTskAlrtPrgrmPrmsLbl] = "Program parameters:"
	$aMessage[$iMsg_SttngsEditMarkListLbl] = "Edit Marks List:"
	$aMessage[$iMsg_SttngsAskToDoRemoveChckBx] = "Ask when removing ToDo task"
	$aMessage[$iMsg_SttngsAskToDoListClearChckBx] = "Ask when clearing ToDo list"
	$aMessage[$iMsg_SttngsMrkTskAsDnAftrAlrtChckBx] = "Mark task as completed after alert (only for 'Run Once' mode)"
	$aMessage[$iMsg_SttngsPrgrmRstrtRqirdLbl] = "* Program restart requierd"
	$aMessage[$iMsg_SttngsOkBtn] = "Ok"
	$aMessage[$iMsg_SttngsCancelBtn] = "Cancel"
	$aMessage[$iMsg_SttngsSelSoundFileTitle] = "Select Sound File"
	$aMessage[$iMsg_SttngsAudioFilesFltr] = "Audio Files"
	$aMessage[$iMsg_SttngsSelProgramTitle] = "Select Program"
	$aMessage[$iMsg_SttngsProgramFilesFltr] = "Program Files"
	
	If Not FileExists($sLang_File) Then
		Return $aMessage
	EndIf
	
	Local $aIni = IniReadSection($sLang_File, $sSection)
	
	For $iKey = 1 To UBound($aIni)-1
		$iMsg_Key = Eval("iMsg_" & $aIni[$iKey][0])
		$sMessage = StringRegExpReplace(BinaryToString(StringToBinary($aIni[$iKey][1]), 4), '^"+|"+$', '')
		
		If $iMsg_Key > 0 And $iMsg_Key <= $iMsg_Last And $sMessage <> "" Then
			$aMessage[$iMsg_Key] = $sMessage
		EndIf
	Next
	
	Return $aMessage
EndFunc

Func _Main_Events()
	Switch @GUI_CtrlId
		Case $nSpace_Ctrl
			$sFocusedCtrl = ControlGetFocus($hGUI)
			
			If $sFocusedCtrl <> "SysListView321" Then
				GUISetAccelerators(0, $hGUI)
				ControlSend($hGUI, "", $sFocusedCtrl, "{SPACE}")
				GUISetAccelerators($aAccelKeys, $hGUI)
			EndIf
		Case $GUI_EVENT_CLOSE, $nExit_MenuItem
			If $iHideAppToTrayOnClose = 1 Then
				_HideAppToTray_Proc()
			Else
				_Exit_Proc()
			EndIf
		Case $GUI_EVENT_MINIMIZE
			If $iHideAppToTrayOnMinimize = 1 Then
				_HideAppToTray_Proc()
			EndIf
		Case $nListView
			Local $iColumn = GUICtrlGetState($nListView) 
			_GUICtrlListView_SortItems($nListView, $iColumn)
			$bToDoListChanged = True
		Case $nSettings_MenuItem
			_Settings_Dialog($iSttngsGUI_Width, $iSttngsGUI_Height, $hGUI)
		Case $nRegisterApp_MenuItem
			_RegisterApp_Proc()
		Case $nUnRegisterApp_MenuItem
			_UnRegisterApp_Proc()
		Case $nToDoPriority_Combo, $nToDoMark_Combo, $nToDoProgress_Combo, $nToDoAlert_Date, $nToDoAlert_Time, $nToDoNotes_Edit
			$bEditChanged = @GUI_CtrlId
		Case $nToDoAlert_Combo, $nToDoAlertSu_ChckBx To $nToDoAlertSa_ChckBx
			Local $sDateFormat = "dd.MM.yyyy"
			Local $sToDoAlert_Combo_Read = GUICtrlRead($nToDoAlert_Combo)
			Local $iAlertDaysChckBx_State = $GUI_DISABLE
			Local $iAlertDate_State = $GUI_DISABLE
			Local $iAlertTime_State = $GUI_ENABLE
			Local $iAlertAction_State = $GUI_ENABLE
			
			Switch $sToDoAlert_Combo_Read
				Case $aMessage[$iMsg_GUIAlrtCmbDsbl]
					$iAlertTime_State = $GUI_DISABLE
					$iAlertAction_State = $GUI_DISABLE
				Case $aMessage[$iMsg_GUIAlrtCmbRunOnce]
					$iAlertDate_State = $GUI_ENABLE
				Case $aMessage[$iMsg_GUIAlrtCmbEvryDay]
					$iAlertTime_State = $GUI_ENABLE
				Case $aMessage[$iMsg_GUIAlrtCmbEvryWeek]
					$iAlertDaysChckBx_State = $GUI_ENABLE
				Case $aMessage[$iMsg_GUIAlrtCmbEvryMonth]
					$sDateFormat = "dd"
					$iAlertDate_State = $GUI_ENABLE
				Case $aMessage[$iMsg_GUIAlrtCmbEvryYear]
					$sDateFormat = "dd.MM"
					$iAlertDate_State = $GUI_ENABLE
			EndSwitch
			
			For $iCtrlID = $nToDoAlertSu_ChckBx To $nToDoAlertSa_ChckBx
				GUICtrlSetState($iCtrlID, $iAlertDaysChckBx_State)
			Next
			
			GUICtrlSendMsg($nToDoAlert_Date, $DTM_SETFORMATW, 0, $sDateFormat)
			GUICtrlSetState($nToDoAlert_Date, $iAlertDate_State)
			GUICtrlSetState($nToDoAlert_Time, $iAlertTime_State)
			GUICtrlSetState($nToDoAlertAction_Btn, $iAlertAction_State)
			
			$bEditChanged = @GUI_CtrlId
		Case $nToDoAlertAction_Btn
			_ToDoAlertSetAction_Proc(460, 250, $hGUI)
		Case $nAddToDo_Btn
			GUICtrlSetState($nListView, $GUI_FOCUS)
			
			If Not BitAND(GUICtrlGetState($nLVEdit_MainCtrl), $GUI_HIDE) Then
				_UpdateEdit($nLVEdit_MainCtrl, $nLVEdit_LV_CTRL, $aLVEdit_DATA[0], $aLVEdit_DATA[1])
				__IsPressedMod()
			EndIf
			
			GUIRegisterMsg($WM_NOTIFY, "")
			$iIndex = _AddToDo_Proc("||1|0%|" & $aMessage[$iMsg_KwrdsNo])
			GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
			
			;_GUICtrlListView_ClickItem($nListView, $iIndex, "Main", False, 1, 0)
			;_GUICtrlListView_ClickItem($nListView, $iIndex, "Main", False, 1, 0)
			
			$bToDoListChanged = True
			$iLVEdit_EditCol = 0
			$iLVEdit_EditFlag = 0
			
			_GUICtrlListView_EnsureVisible($nListView, $iIndex)
			_GUICtrlListView_SetItemSelected($nListView, $iIndex, 1, 0)
			
			If BitAND(GUICtrlGetState($nToDoNotes_Edit), $GUI_HIDE) Then
				ControlClick($hGUI, "", $nEditToDo_Btn)
			EndIf
			
			ListView_DoubleClick()
		Case $nEditToDo_Btn
			Local $bEditToDoIsVisible = BitAND(GUICtrlGetState($nToDoNotes_Edit), $GUI_HIDE)
			
			If $bEditToDoIsVisible Then
				$nState = $GUI_SHOW
				_GUICtrlButton_SetImageEx($hExpnd_ImageList, $nEditToDo_Btn, $sIcons_File, 10)
				GUICtrlSetPos($nListView, 10, 60, $iMainGUI_Width - 20, $iToDoNotesEdit_Top)
			Else
				$nState = $GUI_HIDE
				_GUICtrlButton_SetImageEx($hExpnd_ImageList, $nEditToDo_Btn, $sIcons_File, 9)
				GUICtrlSetPos($nListView, 10, 60, $iMainGUI_Width - 20, $iMainGUI_Height - 60 - 70)
			EndIf
			
			For $nCtrlID = $nFirstToDoEdit_Ctrl To $nLastToDoEdit_Ctrl
				GUICtrlSetState($nCtrlID, $nState)
			Next
			
			_WinAPI_RedrawWindow(GUICtrlGetHandle($nEditToDo_Btn))
		Case $nRemoveToDo_Btn
			_RemoveToDo_Proc()
		Case $nNewToDoList_MenuItem
			_NewToDoList_Proc()
		Case $nOpenToDoList_Btn, $nOpenToDoList_MenuItem, $aRecentToDoList[1] To $aRecentToDoList[$aRecentToDoList[0]]
			If @GUI_CtrlId = $nOpenToDoList_Btn Or @GUI_CtrlId = $nOpenToDoList_MenuItem Then
				_OpenToDoList_Proc()
			Else
				_OpenToDoList_Proc(_GetMenuText(@GUI_CtrlId), 0)
			EndIf
		Case $nSaveToDoList_Btn, $nSaveToDoList_MenuItem
			_SaveToDoList_Proc(1)
		Case $nSaveAsToDoList_Btn, $nSaveAsToDoList_MenuItem
			_SaveToDoList_Proc(0)
		Case $nClearToDoList_Btn
			_ClearToDoList_Proc(1)
		Case $nAutoItScript_ru_Hyperlink
			__AboutBox_GUICtrlHyperlink_Handler($hGUI, $nAutoItScript_ru_Hyperlink, $sWWW_URL, -1, 0x551A8B)
		Case $nAbout_MenuItem
			_About_Dialog()
	EndSwitch
EndFunc

Func _Tray_Events()
	Switch @GUI_CtrlId
		Case $nShowApp_TrayItem
			_RestoreAppFromTray_Proc()
		Case $nSettings_TrayItem, $nAbout_TrayItem
			Local $iAppInTray = Not BitAND(WinGetState($hGUI), 2)
			
			If $iAppInTray Then
				_RestoreAppFromTray_Proc()
			EndIf
			
			If @GUI_CtrlId = $nSettings_TrayItem Then
				_Settings_Dialog($iSttngsGUI_Width, $iSttngsGUI_Height, $hGUI)
			Else
				_About_Dialog()
			EndIf
			
			If $iAppInTray Then
				_HideAppToTray_Proc()
			EndIf
		Case $nExit_TrayItem
			_Exit_Proc()
	EndSwitch
EndFunc

Func _Tray_Callback($nID, $nMsg)
	Switch $nID
		Case $nTrayIcon
			Switch $nMsg
				;Case $NIN_BALLOONUSERCLICK, $NIN_BALLOONTIMEOUT
					;Put your stuff here
				;Case $WM_LBUTTONDOWN
					;Put your stuff here
				Case $WM_LBUTTONUP ;One click and double click to put together is difficult
					_RestoreAppFromTray_Proc()
				;Case $WM_LBUTTONDBLCLK
					;Put your stuff here
				;Case $WM_RBUTTONDOWN
					;Put your stuff here
				;Case $WM_RBUTTONUP
					;Put your stuff here
				;Case $WM_RBUTTONDBLCLK
					;Put your stuff here
				;Case $WM_MOUSEMOVE
					;Put your stuff here
			EndSwitch
	EndSwitch
EndFunc

Func _Settings_Dialog($iWidth, $iHeight, $hParent)
	Local $iGOEM_Opt = Opt("GUIOnEventMode", 0)
	Local $sLangs = "", $aLangFiles = _FileListToArray($sLangs_Path, "*.lng", 1)
	Local $iRestartRequierd = 0
	
	Local $nStngs_Msg, $hSettings_GUI, $nLangSel_Combo
	Local $nRunProgramWithWnds_ChckBx, $nRunTsksAgentWithWnds_ChckBx, $nAppSetOnTop_ChckBx, $nAlertActionShowMsg_ChckBx, $nAlertActionPlaySound_ChckBx
	Local $nAlertActionSoundFile_Input, $nAlertActionSoundFileSel_Btn, $nAlertActionRunPrgrm_ChckBx
	Local $nAlertActionPrgrmFile_Input, $nAlertActionPrgrmFilePrms_Input, $nAlertActionPrgrmFileSel_Btn
	Local $nMarkColDefault_Edit, $nProgramRestartRequierdLbl, $nOk_Btn
	
	Local $sRunProgramWithWnds = RegRead("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", "ToDoIt")
	Local $sRunTsksAgentWithWnds = RegRead("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", "TDITAgent")
	Local $iAlertActionShowMsg = IniRead($sConfig_File, "Main", "Alert Action Show Message", 1)
	Local $iAlertActionPlaySound = IniRead($sConfig_File, "Main", "Alert Action Play Sound", 0)
	Local $sAlertActionSoundFile = IniRead($sConfig_File, "Main", "Alert Action Sound File", "")
	Local $iAlertActionRunPrgrm = IniRead($sConfig_File, "Main", "Alert Action Run Program", 0)
	Local $sAlertActionPrgrmFile = IniRead($sConfig_File, "Main", "Alert Action Program File", "")
	Local $sAlertActionPrgrmFilePrms = IniRead($sConfig_File, "Main", "Alert Action Program File Parameters", "")
	Local $iMarkTskAsDoneAfterAlert = IniRead($sConfig_File, "Main", "Mark Task As Done After Alert", 0)
	
	$hSettings_GUI = GUICreate($aMessage[$iMsg_SttngsMainTitle], $iWidth, $iHeight, -1, -1, -1, $WS_EX_TOOLWINDOW, $hParent)
	
	GUICtrlCreateGroup($aMessage[$iMsg_SttngsMainGrp], 20, 20, $iWidth - 40, 165)
	GUICtrlCreateLabel($aMessage[$iMsg_SttngsLangLbl], 40, 40, -1, 15)
	$nLangSel_Combo = GUICtrlCreateCombo("", 180, 38, 120, 30, $CBS_DROPDOWNLIST)
	$nRunProgramWithWnds_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsRunPrgrmWithWndsChckBx], 40, 70)
	$nRunTsksAgentWithWnds_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsRunTskAgntWithWndsChckBx], 40, 90)
	$nAppSetOnTop_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsAppSetOnTopChckBx], 40, 110)
	$nHideAppToTrayOnClose_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsHidAppToTrayOnClsChckBx], 40, 130)
	$nHideAppToTrayOnMinimize_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsHidAppToTrayOnMinChckBx], 40, 150)
	
	GUICtrlCreateGroup($aMessage[$iMsg_SttngsOtherGrp], 20, 200, $iWidth - 40, 215)
	$nAskToDoRemove_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsAskToDoRemoveChckBx], 40, 215, -1, 15)
	$nAskToDoListClear_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsAskToDoListClearChckBx], 300, 215, -1, 15)
	$nMarkTskAsDoneAfterAlert_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsMrkTskAsDnAftrAlrtChckBx], 40, 233, -1, 15)
	
	GUICtrlCreateGroup($aMessage[$iMsg_SttngsActnTskAlrtLbl], 30, 260, 400, 135)
	$nAlertActionShowMsg_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsTskAlrtShowMsgChckBx], 40, 280)
	$nAlertActionPlaySound_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsTskAlrtPlaySndChckBx], 40, 310)
	$nAlertActionSoundFile_Input = GUICtrlCreateInput($sAlertActionSoundFile, 200, 312, 200, 20)
	$nAlertActionSoundFileSel_Btn = GUICtrlCreateButton("...", 405, 312, 20, 20)
	$nAlertActionRunPrgrm_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsTskAlrtRunPrgrmChckBx], 40, 340)
	$nAlertActionPrgrmFile_Input = GUICtrlCreateInput($sAlertActionPrgrmFile, 200, 342, 200, 20)
	$nAlertActionPrgrmFilePrms_Input = GUICtrlCreateInput($sAlertActionPrgrmFilePrms, 200, 367, 200, 20)
	$nAlertActionPrgrmFileSel_Btn = GUICtrlCreateButton("...", 405, 342, 20, 20)
	GUICtrlCreateLabel($aMessage[$iMsg_SttngsTskAlrtPrgrmPrmsLbl], 40, 370, -1, 15)
	
	GUICtrlCreateLabel($aMessage[$iMsg_SttngsEditMarkListLbl], 440, 255, -1, 15)
	$nMarkColDefault_Edit = GUICtrlCreateEdit(StringReplace($sMark_Col_Default, "|", @CRLF), 440, 270, 180, 125)
	
	$nProgramRestartRequierdLbl = GUICtrlCreateLabel($aMessage[$iMsg_SttngsPrgrmRstrtRqirdLbl], 200, $iHeight - 30, $iWidth - 200 - 20, 20, $SS_RIGHT)
	GUICtrlSetFont(-1, 9, 800)
	
	$nOk_Btn = GUICtrlCreateButton($aMessage[$iMsg_SttngsOkBtn], 20, $iHeight - 30, 70, 20)
	$nCancel_Btn = GUICtrlCreateButton($aMessage[$iMsg_SttngsCancelBtn], 110, $iHeight - 30, 70, 20)
	
	#Region Set defaults
	
	For $i = 1 To UBound($aLangFiles)-1
		$sLangs &= StringTrimRight($aLangFiles[$i], 4) & "|"
	Next
	
	GUICtrlSetData($nLangSel_Combo, StringTrimRight($sLangs, 1), $sLanguage)
	
	GUICtrlSetState($nRunProgramWithWnds_ChckBx, _Iif($sRunProgramWithWnds <> "", $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nRunTsksAgentWithWnds_ChckBx, _Iif($sRunProgramWithWnds <> "", $GUI_DISABLE, $GUI_ENABLE))
	GUICtrlSetState($nRunTsksAgentWithWnds_ChckBx, _Iif($sRunTsksAgentWithWnds <> "", $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAppSetOnTop_ChckBx, _Iif($iAppSetOnTop = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nHideAppToTrayOnClose_ChckBx, _Iif($iHideAppToTrayOnClose = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nHideAppToTrayOnMinimize_ChckBx, _Iif($iHideAppToTrayOnMinimize = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAskToDoRemove_ChckBx, _Iif($iAsk_ToDoRemove = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAskToDoListClear_ChckBx, _Iif($iAsk_ToDoListClear = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nMarkTskAsDoneAfterAlert_ChckBx, _Iif($iMarkTskAsDoneAfterAlert = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAlertActionShowMsg_ChckBx, _Iif($iAlertActionShowMsg = $GUI_CHECKED, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAlertActionPlaySound_ChckBx, _Iif($iAlertActionPlaySound = $GUI_CHECKED, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAlertActionSoundFile_Input, _Iif($iAlertActionPlaySound = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionSoundFileSel_Btn, _Iif($iAlertActionPlaySound = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionRunPrgrm_ChckBx, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAlertActionPrgrmFile_Input, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionPrgrmFilePrms_Input, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionPrgrmFileSel_Btn, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	
	#EndRegion Set defaults
	
	GUISetState(@SW_DISABLE, $hParent)
	GUISetState(@SW_SHOW, $hSettings_GUI)
	
	While 1
		$nStngs_Msg = GUIGetMsg()
		
		Switch $nStngs_Msg
			Case $GUI_EVENT_CLOSE, $nCancel_Btn
				ExitLoop
			Case $nLangSel_Combo
				If GUICtrlRead($nLangSel_Combo) <> $sLanguage Then
					$iRestartRequierd = 1
					GUICtrlSetColor($nProgramRestartRequierdLbl, 0xFF0000)
				Else
					$iRestartRequierd = 0
					GUICtrlSetColor($nProgramRestartRequierdLbl, 0x000000)
				EndIf
			Case $nAlertActionShowMsg_ChckBx
				If GUICtrlRead($nAlertActionPlaySound_ChckBx) <> $GUI_CHECKED And GUICtrlRead($nAlertActionRunPrgrm_ChckBx) <> $GUI_CHECKED Then
					GUICtrlSetState($nAlertActionShowMsg_ChckBx, $GUI_CHECKED)
				EndIf
			Case $nAlertActionPlaySound_ChckBx, $nAlertActionRunPrgrm_ChckBx
				$nState = $GUI_DISABLE
				
				If GUICtrlRead($nStngs_Msg) = $GUI_CHECKED Then
					$nState = $GUI_ENABLE
				EndIf
				
				GUICtrlSetState($nStngs_Msg+1, $nState)
				GUICtrlSetState($nStngs_Msg+2, $nState)
				
				If $nStngs_Msg = $nAlertActionRunPrgrm_ChckBx Then
					GUICtrlSetState($nStngs_Msg+3, $nState)
				EndIf
				
				If GUICtrlRead($nAlertActionPlaySound_ChckBx) <> $GUI_CHECKED And GUICtrlRead($nAlertActionRunPrgrm_ChckBx) <> $GUI_CHECKED Then
					GUICtrlSetState($nAlertActionShowMsg_ChckBx, $GUI_CHECKED)
				EndIf
			Case $nRunProgramWithWnds_ChckBx
				If GUICtrlRead($nRunProgramWithWnds_ChckBx) = $GUI_CHECKED Then
					GUICtrlSetState($nRunTsksAgentWithWnds_ChckBx, BitOR($GUI_UNCHECKED, $GUI_DISABLE))
				Else
					GUICtrlSetState($nRunTsksAgentWithWnds_ChckBx, $GUI_ENABLE)
				EndIf
			Case $nAlertActionSoundFileSel_Btn
				$sFile = FileOpenDialog($aMessage[$iMsg_SttngsSelSoundFileTitle], "", $aMessage[$iMsg_SttngsAudioFilesFltr] & " (*.wav;*.wma;*.mp3;*.ogg;*.mid;*.midi)", 3, _
					StringRegExpReplace(GUICtrlRead($nAlertActionSoundFile_Input), "^.*\\", ""), $hSettings_GUI)
				
				If @error Then
					ContinueLoop
				EndIf
				
				GUICtrlSetData($nAlertActionSoundFile_Input, $sFile)
			Case $nAlertActionPrgrmFileSel_Btn
				$sFile = FileOpenDialog($aMessage[$iMsg_SttngsSelProgramTitle], "", $aMessage[$iMsg_SttngsProgramFilesFltr] & " (*.exe)", 3, _
					StringRegExpReplace(GUICtrlRead($nAlertActionPrgrmFile_Input), "^.*\\", ""), $hSettings_GUI)
				
				If @error Then
					ContinueLoop
				EndIf
				
				GUICtrlSetData($nAlertActionPrgrmFile_Input, $sFile)
			Case $nOk_Btn
				RegDelete("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", "ToDoIt")
				RegDelete("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", "TDITAgent")
				
				If GUICtrlRead($nRunProgramWithWnds_ChckBx) = $GUI_CHECKED Then
					RegWrite("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", "ToDoIt", "REG_SZ", $sApp_Path)
				ElseIf GUICtrlRead($nRunTsksAgentWithWnds_ChckBx) = $GUI_CHECKED Then
					RegWrite("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", "TDITAgent", "REG_SZ", $sTDITAgent_File)
				EndIf
				
				$iAppSetOnTop = Number(GUICtrlRead($nAppSetOnTop_ChckBx) = $GUI_CHECKED)
				$iHideAppToTrayOnClose = Number(GUICtrlRead($nHideAppToTrayOnClose_ChckBx) = $GUI_CHECKED)
				$iHideAppToTrayOnMinimize = Number(GUICtrlRead($nHideAppToTrayOnMinimize_ChckBx) = $GUI_CHECKED)
				
				$iAsk_ToDoRemove = Number(GUICtrlRead($nAskToDoRemove_ChckBx) = $GUI_CHECKED)
				$iAsk_ToDoListClear = Number(GUICtrlRead($nAskToDoListClear_ChckBx) = $GUI_CHECKED)
				
				$iMarkTskAsDoneAfterAlert = Number(GUICtrlRead($nMarkTskAsDoneAfterAlert_ChckBx) = $GUI_CHECKED)
				
				$sLanguage = GUICtrlRead($nLangSel_Combo)
				$iAlertActionShowMsg = Number(GUICtrlRead($nAlertActionShowMsg_ChckBx) = $GUI_CHECKED)
				$iAlertActionPlaySound = Number(GUICtrlRead($nAlertActionPlaySound_ChckBx) = $GUI_CHECKED)
				$sAlertActionSoundFile = GUICtrlRead($nAlertActionSoundFile_Input)
				$iAlertActionRunPrgrm = Number(GUICtrlRead($nAlertActionRunPrgrm_ChckBx) = $GUI_CHECKED)
				$sAlertActionPrgrmFile = GUICtrlRead($nAlertActionPrgrmFile_Input)
				$sAlertActionPrgrmFilePrms = GUICtrlRead($nAlertActionPrgrmFilePrms_Input)
				
				$sMark_Col_Default = StringReplace(StringStripWS(GUICtrlRead($nMarkColDefault_Edit), 3), @CRLF, "|")
				$sMark_Col_Default = _Iif($sMark_Col_Default = "", $aMessage[$iMsg_MarkColDeflt], $sMark_Col_Default)
				
				IniWrite($sConfig_File, "Main", "Set On Top Attribute", $iAppSetOnTop)
				IniWrite($sConfig_File, "Main", "Hide To Tray When Closing", $iHideAppToTrayOnClose)
				IniWrite($sConfig_File, "Main", "Hide To Tray When Minimizing", $iHideAppToTrayOnMinimize)
				
				IniWrite($sConfig_File, "Main", "Ask When Removing ToDo Task", $iAsk_ToDoRemove)
				IniWrite($sConfig_File, "Main", "Ask When Clearing ToDo List", $iAsk_ToDoListClear)
				
				IniWrite($sConfig_File, "Main", "Mark Task As Done After Alert", $iMarkTskAsDoneAfterAlert)
				
				IniWrite($sConfig_File, "Main", "Language", $sLanguage)
				IniWrite($sConfig_File, "Main", "Alert Action Show Message", $iAlertActionShowMsg)
				IniWrite($sConfig_File, "Main", "Alert Action Play Sound", $iAlertActionPlaySound)
				IniWrite($sConfig_File, "Main", "Alert Action Sound File", $sAlertActionSoundFile)
				IniWrite($sConfig_File, "Main", "Alert Action Run Program", $iAlertActionRunPrgrm)
				IniWrite($sConfig_File, "Main", "Alert Action Program File", $sAlertActionPrgrmFile)
				IniWrite($sConfig_File, "Main", "Alert Action Program File Parameters", $sAlertActionPrgrmFilePrms)
				
				IniWrite($sConfig_File, "Main", "Mark Column Default", $sMark_Col_Default)
				
				WinSetOnTop($hGUI, "", $iAppSetOnTop)
				
				ExitLoop
		EndSwitch
	WEnd
	
	Opt("GUIOnEventMode", $iGOEM_Opt)
	
	GUISetState(@SW_ENABLE, $hParent)
	GUIDelete($hSettings_GUI)
	
	If $iRestartRequierd Then
		GUICtrlSetData($nMainStatusLbl, $aMessage[$iMsg_SttngsPrgrmRstrtRqirdLbl])
	Else
		GUICtrlSetData($nMainStatusLbl, "")
	EndIf
EndFunc

Func _About_Dialog()
	Local $sTitle, $sScrollText, $sMainLabel, $nLinkColor, $nBkColor, $aHyperLinks[4]
	
	$sTitle = $aMessage[$iMsg_MsgTitlsAboutApp]
	$sMainLabel = $sApp_Title
	
	$sScrollText =  $sApp_Title & "\n" & $sApp_Version & "\n\n" & _
		$aMessage[$iMsg_Dedication] & "\n\n" & _
		"==================\n" & _
		$sCopyright_Msg & "\n" & _
		"==================\n\n" & $aMessage[$iMsg_AboutApp] & "\n\n" & _
		"~~~~~\nCredits:\n~~~~~\n" & _
		"Stephen Podhajecki, Gary Frost\n(ListViewEdit.au3)\n" & _
		"Holger Kotsch\n(ModernMenuRaw.au3)\n" & _
		"Yashied\n(WinAPIEx.au3)"
	
	$nLinkColor = 0x0000FF
	$nBkColor = 0xFFFFF0
	
	$aHyperLinks[0] = UBound($aHyperLinks) - 1
	$aHyperLinks[1] = "AutoIt Russian Community|" & $sWWW_URL
	$aHyperLinks[2] = "CreatoR's Lab|http://creator-lab.ucoz.ru"
	$aHyperLinks[3] = "Medic's Lab|http://technophoenix.ru"
	
	$ABOUTBOX_ScrollMovieEffect = 1
	
	_AboutBox($sTitle, $sMainLabel, $aMessage[$iMsg_AboutAppVers] & ": " & @CRLF & "v" & $sApp_Version, _
		$sScrollText, $sCopyright_Msg, $aHyperLinks, $hGUI, $sApp_Icon, $nLinkColor, $nBkColor, 500, 300)
EndFunc

Func _FillRecentToDoListFiles_Proc($nRecent_Menu, $iLimit = 10)
	Local $aRecent_List = IniReadSection($sConfig_File, "Recent Lists")
	Local $iFound = 0
	
	For $i = 1 To UBound($aRecent_List)-1
		$aRecent_List[$i][1] = _PathFull($aRecent_List[$i][1])
		
		If FileExists($aRecent_List[$i][1]) Then
			$iFound = 0
			
			For $j = 1 To $aRecentToDoList[0]
				If _GetMenuText($aRecentToDoList[$j]) = $aRecent_List[$i][1] Then
					$iFound = 1
					ExitLoop
				EndIf
			Next
			
			If Not $iFound Then
				$aRecentToDoList[0] += 1
				ReDim $aRecentToDoList[$aRecentToDoList[0]+1]
				$aRecentToDoList[$aRecentToDoList[0]] = _GUICtrlCreateODMenuItem($aRecent_List[$i][1], $nRecent_Menu, $sIcons_File, -14)
				GUICtrlSetOnEvent(-1, "_Main_Events")
			EndIf
		EndIf
		
		If $i >= $iLimit Then
			ExitLoop
		EndIf
	Next
EndFunc

Func _AddRecentToDoList_Proc($sToDoList, $iLimit = 10)
	Local $sConfigRead = FileRead($sConfig_File)
	Local $aRecent_List = IniReadSection($sConfig_File, "Recent Lists")
	Local $iError = @error
	
	If StringInStr($sConfigRead, "=" & $sToDoList & @CRLF) Then
		If Not $iError Then
			$iCount = 1
			
			For $i = 1 To $aRecent_List[0][0]
				If $aRecent_List[$i][1] <> $sToDoList Then
					IniWrite($sConfig_File, "Recent Lists", $iCount, $aRecent_List[$i][1])
					$iCount += 1
				EndIf
			Next
			
			IniWrite($sConfig_File, "Recent Lists", $iCount, $sToDoList)
		EndIf
		
		Return
	EndIf
	
	If $iError Then
		IniWrite($sConfig_File, "Recent Lists", 1, $sToDoList)
	Else
		If $aRecent_List[0][0] >= $iLimit Then
			For $i = 2 To $iLimit
				IniWrite($sConfig_File, "Recent Lists", $i-1, $aRecent_List[$i][1])
			Next
		Else
			$aRecent_List[0][0] += 1
		EndIf
		
		IniWrite($sConfig_File, "Recent Lists", $aRecent_List[0][0], $sToDoList)
	EndIf
EndFunc

Func _AddToDo_Proc($sItem = "", $aIcons = 0, $iPlus = 0)
	Local $aItem = StringSplit($sItem, "|")
	
	If Not IsArray($aIcons) Then
		Dim $aIcons[$aItem[0]+1]
	EndIf
	
	Local $iCount = _GUICtrlListView_GetItemCount($nListView)
	Local $iIndex = _GUICtrlListView_AddItem($nListView, $aItem[1], $aIcons[0] + $iPlus, $iCount + 9999)
	
	For $x = 2 To $aItem[0]
		If $x = $iAlert_Col + 1 And $aItem[$x] = "" Then
			$aItem[$x] = $aMessage[$iMsg_KwrdsNo]
		EndIf
		
		_GUICtrlListView_AddSubItem($nListView, $iIndex, $aItem[$x], $x - 1, $aIcons[$x - 1] + $iPlus)
	Next
	
	_GUICtrlListView_SetColumnWidth($nListView, $iTitle_Col, $LVSCW_AUTOSIZE)
	
	If _GUICtrlListView_GetColumnWidth($nListView, $iTitle_Col) < 70 Then
		_GUICtrlListView_SetColumnWidth($nListView, $iTitle_Col, $aColumns_Data[$iTitle_Col+1][1])
	EndIf
	
	_GUICtrlListView_SetColumnWidth($nListView, $iMark_Col, $aColumns_Data[$iMark_Col+1][1])
	_GUICtrlListView_SetColumnWidth($nListView, $iPriority_Col, $LVSCW_AUTOSIZE_USEHEADER)
	_GUICtrlListView_SetColumnWidth($nListView, $iProgress_Col, $LVSCW_AUTOSIZE_USEHEADER)
	_GUICtrlListView_SetColumnWidth($nListView, $iAlert_Col, $aColumns_Data[$iAlert_Col+1][1])
	_GUICtrlListView_SetColumnWidth($nListView, $iNotes_Col, $aColumns_Data[$iNotes_Col+1][1])
	
	Return $iIndex
EndFunc

Func _RemoveToDo_Proc()
	Local $iIndex = _GUICtrlListView_GetSelectedIndices($nListView)
	
	If $iIndex = "" Then
		Return
	EndIf
	
	Local $iAsk = 6
	
	If $iAsk_ToDoRemove = 1 Then
		$iAsk = _GUIMsgBox(48 + 4, 2, $aMessage[$iMsg_MsgTitlsAtntn], $aMessage[$iMsg_AskRemvToDoTsk], _
			330, 120, $aMessage[$iMsg_MsgOptDontShow], 0, $hGUI, $aMessage[$iMsg_SttngsOkBtn], $aMessage[$iMsg_SttngsCancelBtn])
	EndIf
	
	If BitAND($iAsk, 6) = 6 Then
		_GUICtrlListView_DeleteItem($hListView, Number($iIndex))
		$bToDoListChanged = True
		
		If BitAND($iAsk, 8) = 8 Then
			$iAsk_ToDoRemove = 0
			IniWrite($sConfig_File, "Main", "Ask When Removing ToDo Task", 0)
		EndIf
	EndIf
EndFunc

Func _OpenLastToDoList_Proc()
	Local $aRecent_List = IniReadSection($sConfig_File, "Recent Lists")
	If @error Or Not FileExists($aRecent_List[$aRecent_List[0][0]][1]) Then Return
	
	_OpenToDoList_Proc($aRecent_List[$aRecent_List[0][0]][1], 0)
EndFunc

Func _NewToDoList_Proc()
	If _CheckChanges_Proc() = 2 Then Return
	
	_ClearToDoList_Proc(0)
	
	WinSetTitle($hGUI, "", $sApp_Title)
	$sCurr_ToDoList_File = ""
EndFunc

Func _OpenToDoList_Proc($sToDoList = "", $iFillRecentList = 1)
	If _CheckChanges_Proc() = 2 Then Return
	
	If $sToDoList = "" Or Not FileExists($sToDoList) Then
		$sToDoList = FileOpenDialog($aMessage[$iMsg_OpnToDoListTitl], "", _
			$aMessage[$iMsg_OpnToDoListFltr] & " (*." & $sToDoFileExt & ")", 3, StringRegExpReplace($sCurr_ToDoList_File, "^.*\\", ""), $hGUI)
		
		If @error Then
			Return
		EndIf
	EndIf
	
	_ClearToDoList_Proc(0)
	
	Local $aRead_Ini = IniReadSection($sToDoList, "ToDo List")
	
	If @error Then
		Return MsgBox(16, $aMessage[$iMsg_MsgTitlsErr], $aMessage[$iMsg_OpnToDoListWrngFile], 0, $hGUI)
	EndIf
	
	GUIRegisterMsg($WM_NOTIFY, "")
	
	For $i = 1 To $aRead_Ini[0][0]
		If StringLeft($aRead_Ini[$i][1], 1) = "1" Then
			$aRead_Ini[$i][1] = StringTrimLeft($aRead_Ini[$i][1], 2)
			$iIndex = _AddToDo_Proc($aRead_Ini[$i][1])
			_GUICtrlListView_SetItemChecked($nListView, $iIndex)
			
			If _GUICtrlListView_GetItemText($nListView, $iIndex, $iMark_Col) = $aMessage[$iMsg_KwrdsCanceled] Then
				_GUICtrlListView_SetItemImage($nListView, $iIndex, 2)
			Else
				_GUICtrlListView_SetItemImage($nListView, $iIndex, 1)
			EndIf
		ElseIf StringLeft($aRead_Ini[$i][1], 1) = "0" Then
			$aRead_Ini[$i][1] = StringTrimLeft($aRead_Ini[$i][1], 2)
			$iIndex = _AddToDo_Proc($aRead_Ini[$i][1])
			_GUICtrlListView_SetItemImage($nListView, $iIndex, 0)
		Else
			Return MsgBox(16, $aMessage[$iMsg_MsgTitlsErr], $aMessage[$iMsg_OpnToDoListWrngFile], 0, $hGUI)
		EndIf
	Next
	
	GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
	
	_AddRecentToDoList_Proc($sToDoList)
	
	If $iFillRecentList Then
		_FillRecentToDoListFiles_Proc($nRecentToDoListFiles_Menu)
	EndIf
	
	WinSetTitle($hGUI, "", $sApp_Title & " - " &  _GetShortString($sToDoList))
	$sCurr_ToDoList_File = $sToDoList
EndFunc

Func _SaveToDoList_Proc($iMode = 0)
	Local $sToDoList = $sCurr_ToDoList_File
	
	If $iMode = 0 Or Not FileExists($sToDoList) Then
		$sToDoList = FileSaveDialog($aMessage[$iMsg_SavToDoListTitl], "", _
			$aMessage[$iMsg_OpnToDoListFltr] & " (*." & $sToDoFileExt & ")", 16, StringRegExpReplace($sCurr_ToDoList_File, "^.*\\", ""), $hGUI)
		
		If @error Then
			Return 0
		EndIf
	EndIf
	
	If StringRight($sToDoList, 5) <> "." & $sToDoFileExt Then
		$sToDoList &= "." & $sToDoFileExt
	EndIf
	
	IniDelete($sToDoList, "ToDo List")
	FileWrite($sToDoList, "")
	
	Local $sItem = "", $sItemText
	Local $iItemCount = _GUICtrlListView_GetItemCount($nListView)
	Local $iColsCount = _GUICtrlListView_GetColumnCount($nListView)
	
	For $i = 0 To $iItemCount - 1
		If _GUICtrlListView_GetItemChecked($nListView, $i) = True Then
			$sItem = "1"
		Else
			$sItem = "0"
		EndIf
		
		For $j = 0 To $iColsCount - 1
			$sItemText = _GUICtrlListView_GetItemText($nListView, $i, $j)
			
			If $j = $iAlert_Col And $sItemText = $aMessage[$iMsg_KwrdsNo] Then
				$sItemText = ""
			EndIf
			
			$sItem &= "|" & StringReplace($sItemText, "|", ":")
			IniWrite($sToDoList, "ToDo List", $i, $sItem)
		Next
	Next
	
	_FillRecentToDoListFiles_Proc($nRecentToDoListFiles_Menu)
	
	WinSetTitle($hGUI, "", $sApp_Title & " - " &  _GetShortString($sToDoList))
	$sCurr_ToDoList_File = $sToDoList
EndFunc

Func _ClearToDoList_Proc($iAsk)
	Local $iWarn = 6
	
	If $iAsk Then
		$iWarn = 6
		
		If $iAsk_ToDoListClear = 1 Then
			$iWarn = _GUIMsgBox(256 + 48 + 4, 2, $aMessage[$iMsg_MsgTitlsAtntn], StringFormat($aMessage[$iMsg_AskClrToDoList]), _
				330, 120, $aMessage[$iMsg_MsgOptDontShow], 0, $hGUI, $aMessage[$iMsg_SttngsOkBtn], $aMessage[$iMsg_SttngsCancelBtn])
		EndIf
	EndIf
	
	If BitAND($iWarn, 6) = 6 Then
		_GUICtrlListView_DeleteAllItems($hListView)
		
		If $iAsk Then
			$bToDoListChanged = True
		EndIf
		
		If BitAND($iWarn, 8) = 8 Then
			$iAsk_ToDoListClear = 0
			IniWrite($sConfig_File, "Main", "Ask When Clearing ToDo List", 0)
		EndIf
	EndIf
EndFunc

Func _ToDoAlertSetAction_Proc($iWidth, $iHeight, $hParent)
	Local $iIndex = _GUICtrlListView_GetSelectedIndices($nListView)
	
	If $iIndex = "" Then
		Return
	EndIf
	
	$iIndex = Number($iIndex)
	Local $sAlertData = _GUICtrlListView_GetItemText($nListView, $iIndex, $iAlert_Col)
	Local $sActionLbl = $aMessage[$iMsg_KwrdsAlertAction]
	
	Local $iGOEM_Opt = Opt("GUIOnEventMode", 0)
	Local $nAlrtActn_Msg
	
	Local $iAlertActionShowMsg = StringRegExp($sAlertData, ".*?" & $sActionLbl & ":.*?" & $aMessage[$iMsg_KwrdsShowMsg] & ".*")
	Local $iAlertActionPlaySound = StringRegExp($sAlertData, ".*?" & $sActionLbl & ":.*?" & $aMessage[$iMsg_KwrdsPlaySound] & ".*")
	Local $sAlertActionSoundFile = StringRegExpReplace($sAlertData, ".*?" & $sActionLbl & ":.*?" & $aMessage[$iMsg_KwrdsPlaySound] & "\((.*?)\).*", "\1")
	Local $iAlertActionRunPrgrm = StringRegExp($sAlertData, ".*?" & $sActionLbl & ":.*?" & $aMessage[$iMsg_KwrdsRunProgram] & ".*")
	Local $sAlertActionPrgrmFile = StringRegExpReplace($sAlertData, ".*?" & $sActionLbl & ":.*?" & $aMessage[$iMsg_KwrdsRunProgram] & "\((.*?);.*\).*", "\1")
	Local $sAlertActionPrgrmFilePrms = StringRegExpReplace($sAlertData, ".*?" & $sActionLbl & ":.*?" & $aMessage[$iMsg_KwrdsRunProgram] & "\(.*?;(.*?)\).*", "\1")
	
	If $sAlertActionSoundFile = $sAlertData Then
		$sAlertActionSoundFile = ""
	EndIf
	
	If $sAlertActionPrgrmFile = $sAlertData Then
		$sAlertActionPrgrmFile = ""
	EndIf
	
	If $sAlertActionPrgrmFilePrms = $sAlertData Then
		$sAlertActionPrgrmFilePrms = ""
	EndIf
	
	$hAlertActn_GUI = GUICreate(" ", $iWidth, $iHeight, -1, -1, -1, $WS_EX_TOOLWINDOW, $hParent)
	
	GUICtrlCreateLabel($aMessage[$iMsg_SttngsActnTskAlrtLbl], 40, 20, -1, 15)
	$nAlertActionShowMsg_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsTskAlrtShowMsgChckBx], 40, 50)
	$nAlertActionPlaySound_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsTskAlrtPlaySndChckBx], 40, 80)
	$nAlertActionSoundFile_Input = GUICtrlCreateInput($sAlertActionSoundFile, 200, 82, 200, 20)
	$nAlertActionSoundFileSel_Btn = GUICtrlCreateButton("...", 405, 82, 20, 20)
	$nAlertActionRunPrgrm_ChckBx = GUICtrlCreateCheckbox($aMessage[$iMsg_SttngsTskAlrtRunPrgrmChckBx], 40, 110)
	$nAlertActionPrgrmFile_Input = GUICtrlCreateInput($sAlertActionPrgrmFile, 200, 112, 200, 20)
	$nAlertActionPrgrmFilePrms_Input = GUICtrlCreateInput($sAlertActionPrgrmFilePrms, 200, 137, 200, 20)
	$nAlertActionPrgrmFileSel_Btn = GUICtrlCreateButton("...", 405, 112, 20, 20)
	GUICtrlCreateLabel($aMessage[$iMsg_SttngsTskAlrtPrgrmPrmsLbl], 40, 140, -1, 15)
	
	$nOk_Btn = GUICtrlCreateButton($aMessage[$iMsg_SttngsOkBtn], 20, $iHeight - 30, 70, 20)
	$nCancel_Btn = GUICtrlCreateButton($aMessage[$iMsg_SttngsCancelBtn], 110, $iHeight - 30, 70, 20)
	
	#Region Set defaults
	
	GUICtrlSetState($nAlertActionShowMsg_ChckBx, _
		_Iif($iAlertActionShowMsg = $GUI_CHECKED Or ($iAlertActionPlaySound <> $GUI_CHECKED And $iAlertActionRunPrgrm <> $GUI_CHECKED), $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAlertActionPlaySound_ChckBx, _Iif($iAlertActionPlaySound = $GUI_CHECKED, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAlertActionSoundFile_Input, _Iif($iAlertActionPlaySound = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionSoundFileSel_Btn, _Iif($iAlertActionPlaySound = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionRunPrgrm_ChckBx, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($nAlertActionPrgrmFile_Input, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionPrgrmFilePrms_Input, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($nAlertActionPrgrmFileSel_Btn, _Iif($iAlertActionRunPrgrm = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE))
	
	#EndRegion Set defaults
	
	GUISetState(@SW_DISABLE, $hParent)
	GUISetState(@SW_SHOW, $hAlertActn_GUI)
	
	While 1
		$nAlrtActn_Msg = GUIGetMsg()
		
		Switch $nAlrtActn_Msg
			Case $GUI_EVENT_CLOSE, $nCancel_Btn
				ExitLoop
			Case $nAlertActionShowMsg_ChckBx
				If GUICtrlRead($nAlertActionPlaySound_ChckBx) <> $GUI_CHECKED And GUICtrlRead($nAlertActionRunPrgrm_ChckBx) <> $GUI_CHECKED Then
					GUICtrlSetState($nAlertActionShowMsg_ChckBx, $GUI_CHECKED)
				EndIf
			Case $nAlertActionPlaySound_ChckBx, $nAlertActionRunPrgrm_ChckBx
				$nState = $GUI_DISABLE
				
				If GUICtrlRead($nAlrtActn_Msg) = $GUI_CHECKED Then
					$nState = $GUI_ENABLE
				EndIf
				
				GUICtrlSetState($nAlrtActn_Msg+1, $nState)
				GUICtrlSetState($nAlrtActn_Msg+2, $nState)
				
				If $nAlrtActn_Msg = $nAlertActionRunPrgrm_ChckBx Then
					GUICtrlSetState($nAlrtActn_Msg+3, $nState)
				EndIf
				
				If GUICtrlRead($nAlertActionPlaySound_ChckBx) <> $GUI_CHECKED And GUICtrlRead($nAlertActionRunPrgrm_ChckBx) <> $GUI_CHECKED Then
					GUICtrlSetState($nAlertActionShowMsg_ChckBx, $GUI_CHECKED)
				EndIf
			Case $nAlertActionSoundFileSel_Btn
				$sFile = FileOpenDialog($aMessage[$iMsg_SttngsSelSoundFileTitle], "", $aMessage[$iMsg_SttngsAudioFilesFltr] & " (*.wav;*.wma;*.mp3;*.ogg;*.mid;*.midi)", 3, _
					StringRegExpReplace(GUICtrlRead($nAlertActionSoundFile_Input), "^.*\\", ""), $hAlertActn_GUI)
				
				If @error Then
					ContinueLoop
				EndIf
				
				GUICtrlSetData($nAlertActionSoundFile_Input, $sFile)
			Case $nAlertActionPrgrmFileSel_Btn
				$sFile = FileOpenDialog($aMessage[$iMsg_SttngsSelProgramTitle], "", $aMessage[$iMsg_SttngsProgramFilesFltr] & " (*.exe)", 3, _
					StringRegExpReplace(GUICtrlRead($nAlertActionPrgrmFile_Input), "^.*\\", ""), $hAlertActn_GUI)
				
				If @error Then
					ContinueLoop
				EndIf
				
				GUICtrlSetData($nAlertActionPrgrmFile_Input, $sFile)
			Case $nOk_Btn
				$iAlertActionShowMsg = GUICtrlRead($nAlertActionShowMsg_ChckBx)
				$iAlertActionPlaySound =  GUICtrlRead($nAlertActionPlaySound_ChckBx)
				$sAlertActionSoundFile = GUICtrlRead($nAlertActionSoundFile_Input)
				$iAlertActionRunPrgrm = GUICtrlRead($nAlertActionRunPrgrm_ChckBx)
				$sAlertActionPrgrmFile = GUICtrlRead($nAlertActionPrgrmFile_Input)
				$sAlertActionPrgrmFilePrms = GUICtrlRead($nAlertActionPrgrmFilePrms_Input)
				
				$sAlertData = StringRegExpReplace($sAlertData, "(.*?)\s*" & $sActionLbl & ":.*", "\1")
				
				If $sAlertData = $aMessage[$iMsg_KwrdsNo] Then
					$sAlertData = $sActionLbl & ": "
				Else
					$sAlertData &= " " & $sActionLbl & ": "
				EndIf
				
				If $iAlertActionShowMsg = $GUI_CHECKED Then
					$sAlertData &= $aMessage[$iMsg_KwrdsShowMsg] & ", "
				EndIf
				
				If $iAlertActionPlaySound = $GUI_CHECKED Then
					$sAlertData &= $aMessage[$iMsg_KwrdsPlaySound] & "(" & FileGetShortName($sAlertActionSoundFile) & "), "
				EndIf
				
				If $iAlertActionRunPrgrm = $GUI_CHECKED Then
					$sAlertData &= $aMessage[$iMsg_KwrdsRunProgram] & "(" & FileGetShortName($sAlertActionPrgrmFile) & ";" & $sAlertActionPrgrmFilePrms & ")"
				EndIf
				
				$sAlertData = StringRegExpReplace($sAlertData, "[, ]*$", "")
				_GUICtrlListView_SetItemText($nListView, $iIndex, $sAlertData, $iAlert_Col)
				
				$bEditChanged = $nToDoAlert_Combo
				ExitLoop
		EndSwitch
	WEnd
	
	Opt("GUIOnEventMode", $iGOEM_Opt)
	
	GUISetState(@SW_ENABLE, $hParent)
	GUIDelete($hAlertActn_GUI)
EndFunc

Func _CheckChanges_Proc()
	Local $sTitle = WinGetTitle($hGUI)
	
	If StringRegExp($sTitle, " \Q[*]\E$") Then
		$iAsk = MsgBox(48 + 3, $aMessage[$iMsg_MsgTitlsAtntn], StringFormat($aMessage[$iMsg_AskSavToDoList]), 0, $hGUI)
		
		If $iAsk = 6 Then
			;WinSetTitle($hGUI, "", StringRegExpReplace($sTitle, " \Q[*]\E$", ""))
			_SaveToDoList_Proc(1)
		ElseIf $iAsk = 2 Then
			Return 2 ;Action "Cancel".
		Else
			Return 0 ;Action "No".
		EndIf
	EndIf
	
	Return 1 ;Action "Yes".
EndFunc

Func _HideAppToTray_Proc()
	GUISetState(@SW_HIDE, $hGUI)
	_TrayIconSetState($nTrayIcon, 1)
	_TrayIconSetToolTip($nTrayIcon, $sApp_Title & _Iif($sCurr_ToDoList_File = "", "", " - " & _GetShortString($sCurr_ToDoList_File)))
EndFunc

Func _RestoreAppFromTray_Proc()
	GUISetState(@SW_SHOW, $hGUI)
	GUISetState(@SW_RESTORE, $hGUI)
	_TrayIconSetState($nTrayIcon, 2)
EndFunc

Func _GetShortString($sString, $iMaxRetLen = 30, $iShift = 0)
    Local $iString = StringLen($sString)
    If $iString <= $iMaxRetLen Then Return $sString

    Local $sMidl= "...", $iMidl = StringLen($sMidl)
    Local $iCut = $iString - $iMaxRetLen
    If $iCut < $iMidl Then $sMidl = StringLeft($sMidl, $iCut)

    $iMaxRetLen -= $iMidl
    If $iMaxRetLen < 0 Then $iMaxRetLen = 0

    Local $iEven = BitShift($iMaxRetLen, 1)
	
    If $iShift > $iEven Then $iShift = $iEven
    If $iShift < -$iEven Then $iShift = -$iEven
	
    Local $iLeft = $iEven + $iShift + BitAND($iMaxRetLen, 1)
    Local $iRight = $iEven - $iShift
	
	$sString = StringLeft($sString, $iLeft) & $sMidl & StringRight($sString, $iRight)
	
    Return $sString
EndFunc

Func _GUICtrlHyperlink_Create($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $iColor = 0x0000FF, $sToolTip = '', $iStyle = -1, $iExStyle = -1)
	Local $ID = GUICtrlCreateLabel($sText, $iLeft, $iTop, $iWidth, $iHeight, $iStyle, $iExStyle)
	
	If $ID Then
		GUICtrlSetFont($ID, -1, -1, 4)
		GUICtrlSetColor($ID, $iColor)
		GUICtrlSetCursor($ID, 0)
		GUICtrlSetTip($ID, $sToolTip)
	EndIf
	
	Return $ID
EndFunc

Func _GUICtrlHyperlink_Handler($hWnd, $iCtrlID, $sActionURL, $iAction = -1, $iVisitedColor = 0x551A8B)
	Local $aCurInfo = GUIGetCursorInfo($hWnd)
	If Not IsArray($aCurInfo) Then Return 0
	
	While IsArray($aCurInfo) And $aCurInfo[2] = 1
		$aCurInfo = GUIGetCursorInfo($hWnd)
		
		If $aCurInfo[4] <> $iCtrlID Then
			GUISetCursor(7, 1, $hWnd)
		Else
			GUISetCursor(2, 0, $hWnd)
		EndIf
		
		Sleep(10)
	WEnd
	
	GUISetCursor(2, 0, $hWnd)
	
	If IsArray($aCurInfo) And $aCurInfo[4] = $iCtrlID Then
		If $iAction = 1 Then
			Execute($sActionURL)
		ElseIf $iAction = -1 Then
			ShellExecute($sActionURL)
		EndIf
		
		If @error = 0 And $iVisitedColor Then
			GUICtrlSetColor($iCtrlID, $iVisitedColor)
		EndIf
		
		Return 1
	EndIf
	
	Return 0
EndFunc

Func _GUICtrlCreateButtonEx($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $nStyle = -1, $nExStyle = -1, $sIconFile = '', $nIconID = 0, $nAlign = -1)
	Local $nID = GUICtrlCreateButton($sText, $iLeft, $iTop, $iWidth, $iHeight, $nStyle, $nExStyle)
	
	If $sIconFile = '' Then
		Return $nID
	EndIf
	
	Local $hImgLst = _GUIImageList_Create(16, 16, 5, BitOr($ILC_MASK, $ILC_COLOR32), 0, 1)
	_GUIImageList_AddIcon($hImgLst, $sIconFile, $nIconID)
	_GUICtrlButton_SetImageList($nID, $hImgLst, $nAlign)
	
	Return $nID
EndFunc

Func _GUICtrlButton_SetImageEx(ByRef $hImageList, $nCtrl, $sIconFile, $nIconID=0, $nAlign=-1)
	If $hImageList Then _GUIImageList_Destroy($hImageList)
	
	$hImageList = _GUIImageList_Create(16, 16, 5, 1)
	_GUIImageList_AddIcon($hImageList, $sIconFile, $nIconID)
	
	Local $stBIL = DllStructCreate("dword;int[4];uint")
	
	DllStructSetData($stBIL, 1, $hImageList)
	DllStructSetData($stBIL, 2, 1, 1)
	DllStructSetData($stBIL, 2, 1, 2)
	DllStructSetData($stBIL, 2, 1, 3)
	DllStructSetData($stBIL, 2, 1, 4)
	DllStructSetData($stBIL, 3, $nAlign)
	
	Return GUICtrlSendMsg($nCtrl, $BCM_SETIMAGELIST, 0, DllStructGetPtr($stBIL))
EndFunc

Func _GUICtrlListView_RegisterSortCallBackEx($hWnd, $fNumbers = True, $fArrows = True)
	If $Debug_LV Then __UDF_ValidateClassName($hWnd, $__LISTVIEWCONSTANT_ClassName)
	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)

	Local $hHeader = _GUICtrlListView_GetHeader($hWnd)

	ReDim $aListViewSortInfo[UBound($aListViewSortInfo) + 1][$iLListViewSortInfoSize]

	$aListViewSortInfo[0][0] = UBound($aListViewSortInfo) - 1
	Local $iIndex = $aListViewSortInfo[0][0]

	$aListViewSortInfo[$iIndex][1] = $hWnd ; Handle/ID of listview

	$aListViewSortInfo[$iIndex][2] = DllCallbackRegister("_GUICtrlListView_SortCallback", "int", "int;int;hwnd") ; Handle of callback
	$aListViewSortInfo[$iIndex][3] = -1 ; $nColumn
	$aListViewSortInfo[$iIndex][4] = -1 ; nCurCol
	$aListViewSortInfo[$iIndex][5] = 1 ; $nSortDir
	$aListViewSortInfo[$iIndex][6] = -1 ; $nCol
	$aListViewSortInfo[$iIndex][7] = 0 ; $bSet
	$aListViewSortInfo[$iIndex][8] = $fNumbers ; Treat as numbers?
	$aListViewSortInfo[$iIndex][9] = $fArrows ; Use arrows in the header of the columns?
	$aListViewSortInfo[$iIndex][10] = $hHeader ; Handle to the Header

	Return $aListViewSortInfo[$iIndex][2] <> 0
EndFunc

Func _GUICtrlListView_SortCallback($nItem1, $nItem2, $hWnd)
	Local $iIndex, $tInfo, $val1, $val2, $nResult
	$tInfo = DllStructCreate($tagLVFINDINFO)
	DllStructSetData($tInfo, "Flags", $LVFI_PARAM)

	For $x = 1 To $aListViewSortInfo[0][0]
		If $hWnd = $aListViewSortInfo[$x][1] Then
			$iIndex = $x
			ExitLoop
		EndIf
	Next

	; Switch the sorting direction
	If $aListViewSortInfo[$iIndex][3] = $aListViewSortInfo[$iIndex][4] Then ; $nColumn = nCurCol ?
		If Not $aListViewSortInfo[$iIndex][7] Then ; $bSet
			$aListViewSortInfo[$iIndex][5] *= -1 ; $nSortDir
			$aListViewSortInfo[$iIndex][7] = 1 ; $bSet
		EndIf
	Else
		$aListViewSortInfo[$iIndex][7] = 1 ; $bSet
	EndIf
	$aListViewSortInfo[$iIndex][6] = $aListViewSortInfo[$iIndex][3] ; $nCol = $nColumn
	DllStructSetData($tInfo, "Param", $nItem1)
	$val1 = _GUICtrlListView_FindItem($hWnd, -1, $tInfo)
	DllStructSetData($tInfo, "Param", $nItem2)
	
	$val2 = _GUICtrlListView_FindItem($hWnd, -1, $tInfo)
	
	$iIndx1 = $val1
	$iIndx2 = $val2
	
	$val1 = _GUICtrlListView_GetItemText($hWnd, $val1, $aListViewSortInfo[$iIndex][3])
	$val2 = _GUICtrlListView_GetItemText($hWnd, $val2, $aListViewSortInfo[$iIndex][3])
	
	If $aListViewSortInfo[$iIndex][8] Then ; Treat As Number
		If (StringIsFloat($val1) Or StringIsInt($val1)) Then $val1 = Number($val1)
		If (StringIsFloat($val2) Or StringIsInt($val2)) Then $val2 = Number($val2)
	EndIf
	
	$nResult = 0 ; No change of item1 and item2 positions
	
	If $val1 < $val2 Then
		$nResult = -1 ; Put item2 before item1
	ElseIf $val1 > $val2 Then
		$nResult = 1 ; Put item2 behind item1
	EndIf
	
	$nResult *= $aListViewSortInfo[$iIndex][5] ; $nSortDir

	Return $nResult
EndFunc

Func _GUIMsgBox($iIcoType, $iBtnNum, $sTitle, $sTxt, $iW = 350, $iH = 130, $sCB_Txt = -1, $iTimer = -1, $hWnd = 0, $sB1Txt = -1, $sB2Txt = -1, $nExStyle = -1)
	Local $nYes_Button, $nNo_Button, $nOK_Button, $nCheckBox=-1, $hMsgBox_GUI, $iGuiHeight = $iH
	Local $nStyle = BitOR($WS_CAPTION, $WS_POPUP)
	Local $nMsg, $iReturnVal = 0
	Local $nDefButton, $sDefButtonText = $sB1Txt, $iCounter
	Local $iMessageBeep = -1, $iIcon_Id = 102
	
	Local $iOld_Opt_GOEM = Opt('GuiOnEventMode', 0)
	Local $iOld_Opt_GCOE = Opt('GUICloseOnESC', 0)
	
	If $iBtnNum = 1 Then $nStyle = BitOR($nStyle, $WS_SYSMENU)
	
	If BitAND($iIcoType, 262144) Then
		If $nExStyle = -1 Or $nExStyle = Default Then $nExStyle = 0
		$nExStyle = BitOR($nExStyle, $WS_EX_TOPMOST)
	EndIf
	
	If $sCB_Txt <> -1 Then $iGuiHeight += 25
	
	If $sB1Txt = -1 Then $sB1Txt = 'OK'
	If $sB2Txt = -1 Then $sB2Txt = 'Cancel'
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_DISABLE)
	
	$hMsgBox_GUI = GUICreate($sTitle, $iW, $iGuiHeight, -1, -1, $nStyle, $nExStyle, $hWnd)
	
	Select
		Case $iIcoType = 16 Or $iIcoType = 16 + 256
			$iIcon_Id = 103
			$iMessageBeep = 0x00000010
		Case $iIcoType = 32 Or $iIcoType = 32 + 256
			$iIcon_Id = 102
			$iMessageBeep = 0x00000020
		Case $iIcoType = 48 Or $iIcoType = 48 + 256
			$iIcon_Id = 101
			$iMessageBeep = 0x00000030
		Case $iIcoType = 64 Or $iIcoType = 64 + 256
			$iIcon_Id = 104
			$iMessageBeep = 0x00000040
	EndSelect
	
	GUICtrlCreateIcon('user32.dll', $iIcon_Id, 10, 10)
	GUICtrlCreateLabel($sTxt, 70, 15, $iW-80, $iH-50)
	
	Select
		Case $iBtnNum = 2
			$nYes_Button = GUICtrlCreateButton($sB1Txt, ($iW/2)-90, $iH-35, 70, 20, $BS_DEFPUSHBUTTON)
			$nDefButton = $nYes_Button
			
			Local $iSecButtDeffStyle = 0
			If BitAND($iIcoType, 256) Then $iSecButtDeffStyle = $BS_DEFPUSHBUTTON
			
			$nNo_Button = GUICtrlCreateButton($sB2Txt, ($iW/2)+20, $iH-35, 70, 20, $iSecButtDeffStyle)
			If BitAND($iIcoType, 256) Then $nDefButton = $nNo_Button
		Case Else
			$nOK_Button = GUICtrlCreateButton($sB1Txt, ($iW-70)/2, $iH-35, 70, 20)
			GUICtrlSetState($nOK_Button, $GUI_ONTOP)
			$nDefButton = $nOK_Button
	EndSelect
	
	If $sCB_Txt <> -1 Then $nCheckBox = GUICtrlCreateCheckbox($sCB_Txt, 15, $iH-10)
	
	GUISetState(@SW_SHOW, $hMsgBox_GUI)
	DllCall("user32.dll", "int", "MessageBeep", "int", $iMessageBeep)
	
	If $iTimer > 0 Then
		$iCounter = $iTimer
		$iTimer = TimerInit()
		$sDefButtonText = GUICtrlRead($nDefButton)
		GUICtrlSetData($nDefButton, $sDefButtonText & ' (' & $iCounter & ')')
	EndIf
	
	While 1
		$nMsg = GUIGetMsg()
		
		If $iTimer > 0 And TimerDiff($iTimer) >= 1000 Then
			$iTimer = TimerInit()
			$iCounter -= 1
			GUICtrlSetData($nDefButton, $sDefButtonText & ' (' & $iCounter & ')')
			If $iCounter < 0 Then $nMsg = $nDefButton
		EndIf
		
		Select
			Case $iBtnNum = 2 And $nMsg = $nYes_Button
				$iReturnVal = 6
				ExitLoop
			Case $iBtnNum = 2 And $nMsg = $nNo_Button
				$iReturnVal = 2
				ExitLoop
			Case $nMsg = -3 Or ($nMsg = $nOK_Button And $iBtnNum <> 2)
				$iReturnVal = 6
				ExitLoop
		EndSelect
	Wend
	
	If GUICtrlRead($nCheckBox) = 1 Then $iReturnVal += 8
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($hMsgBox_GUI)
	
	If IsHWnd($hWnd) Then GUISwitch($hWnd)
	
	Opt('GuiOnEventMode', $iOld_Opt_GOEM)
	Opt('GUICloseOnESC', $iOld_Opt_GCOE)
	
	Return $iReturnVal
EndFunc

Func _RegisterApp_Proc()
	_RegSetFileExt($sToDoFileExt, $sApp_Path & ' "%1"', "Open", 1, $sIcons_File & ",13", "ToDo List File (for " & $sApp_Title & " program)")
	_WinAPI_ShellChangeNotify($SHCNE_ASSOCCHANGED, $SHCNF_FLUSH)
	
	GUICtrlSetState($nRegisterApp_MenuItem, $GUI_DISABLE)
	GUICtrlSetState($nUnRegisterApp_MenuItem, $GUI_ENABLE)
EndFunc

Func _UnRegisterApp_Proc()
	_RegUnSetFileExt($sToDoFileExt, "")
	_WinAPI_ShellChangeNotify($SHCNE_ASSOCCHANGED, $SHCNF_FLUSH)
	
	GUICtrlSetState($nRegisterApp_MenuItem, $GUI_ENABLE)
	GUICtrlSetState($nUnRegisterApp_MenuItem, $GUI_DISABLE)
EndFunc

Func _RegSetFileExt($sExt, $sCommand, $sVerb, $iDefault = 0, $sIcon = "", $sDescription = "")
	Local $sExtRead = RegRead("HKCR\." & $sExt, "")
	
	If @error Then
		RegWrite("HKCR\." & $sExt, "", "REG_SZ", $sExt & "file")
		$sExtRead = $sExt & "file"
	EndIf
	
	Local $sCurrentDescription = RegRead("HKCR\" & $sExtRead, "")
	
	If @error Then
		If $sDescription <> "" Then RegWrite("HKCR\" & $sExtRead, "", "REG_SZ", $sDescription)
	Else
		If $sDescription <> "" And $sCurrentDescription <> $sDescription Then
			RegWrite("HKCR\" & $sExtRead, "", "REG_SZ", $sDescription)
			RegWrite("HKCR\" & $sExtRead, "olddesc", "REG_SZ", $sCurrentDescription)
		EndIf
		
		If $sCurrentDescription = "" And $sDescription <> "" Then RegWrite("HKCR\" & $sExtRead, "", "REG_SZ", $sDescription)
	EndIf
	
	Local $sCurrentVerb = RegRead("HKCR\" & $sExtRead & "\shell", "")
	Local $iError = @error
	
	If $iDefault = 1 Then
		RegWrite("HKCR\" & $sExtRead & "\shell\Open\Command", "", "REG_EXPAND_SZ", $sCommand)
		
		If $iError Then
			RegWrite("HKCR\" & $sExtRead & "\shell", "", "REG_SZ", $sVerb)
		Else
			RegWrite("HKCR\" & $sExtRead & "\shell", "", "REG_SZ", $sVerb)
			RegWrite("HKCR\" & $sExtRead & "\shell", "oldverb", "REG_SZ", $sCurrentVerb)
		EndIf
	EndIf
	
	Local $sCurrentCommand = RegRead("HKCR\" & $sExtRead & "\shell\" & $sVerb & "\command", "")
	
	If Not @error Then
		RegRead("HKCR\" & $sExtRead & "\shell\" & $sVerb & "\command", "oldcmd")
		If @error Then RegWrite("HKCR\" & $sExtRead & "\shell\" & $sVerb & "\command", "oldcmd", "REG_SZ", $sCurrentCommand)
	EndIf
	
	RegWrite("HKCR\" & $sExtRead & "\shell\" & $sVerb & "\command", "", "REG_SZ", $sCommand)
	
	If $sIcon <> "" Then
		Local $sCurrentIcon = RegRead("HKCR\" & $sExtRead & "\DefaultIcon", "")
		
		If @error Then
			RegWrite("HKCR\" & $sExtRead & "\DefaultIcon", "", "REG_SZ", $sIcon)
		Else
			RegWrite("HKCR\" & $sExtRead & "\DefaultIcon", "", "REG_SZ", $sIcon)
			RegWrite("HKCR\" & $sExtRead & "\DefaultIcon", "oldicon", "REG_SZ", $sCurrentIcon)
		EndIf
	EndIf
EndFunc

Func _RegUnSetFileExt($sExt, $sVerb="")
	Local $sExtRead = RegRead("HKCR\." & $sExt, "")
	
	If Not @error Then
		If $sVerb = "" Then
			RegDelete("HKCR\." & $sExt)
			RegDelete("HKCR\" & $sExtRead)
			
			Return 1
		EndIf
		
		Local $sOldIcon = RegRead("HKCR\" & $sExtRead & "\shell", "oldicon")
		
		If Not @error Then
			RegWrite("HKCR\" & $sExtRead & "\DefaultIcon", "", "REG_SZ", $sOldIcon)
		Else
			RegDelete("HKCR\" & $sExtRead & "\DefaultIcon", "")
		EndIf
		
		Local $sOldVerb = RegRead("HKCR\" & $sExtRead & "\shell", "oldverb")
		
		If Not @error Then
			RegWrite("HKCR\" & $sExtRead & "\shell", "", "REG_SZ", $sOldVerb)
		Else
			RegDelete("HKCR\" & $sExtRead & "\shell", "")
		EndIf
		
		Local $sOldDesc = RegRead("HKCR\" & $sExtRead, "olddesc")
		
		If Not @error Then
			RegWrite("HKCR\" & $sExtRead, "", "REG_SZ", $sOldDesc)
		Else
			RegDelete("HKCR\" & $sExtRead, "")
		EndIf
		
		Local $sOldCmd = RegRead("HKCR\" & $sExtRead & "\shell\" & $sVerb & "\command", "oldcmd")
		
		If Not @error Then
			RegWrite("HKCR\" & $sExtRead & "\shell\" & $sVerb & "\command", "", "REG_SZ", $sOldCmd)
			RegDelete("HKCR\" & $sExtRead & "\shell\" & $sVerb & "\command", "oldcmd")
		Else
			RegDelete("HKCR\" & $sExtRead & "\shell\" & $sVerb)
		EndIf
	EndIf
EndFunc

Func _RegIsFirstAppRun($sAppName)
	Return RegRead("HKEY_CURRENT_USER\Software\" & $sAppName, "App Started") <> @ScriptFullPath
EndFunc

Func _RegSetFirstAppRun($sAppName)
	Return RegWrite("HKEY_CURRENT_USER\Software\" & $sAppName, "App Started", "REG_SZ", @ScriptFullPath)
EndFunc

Func _AppInteraction_Proc()
	AdlibUnRegister("_AppInteraction_Proc")
	
	Select
		;NOT USED
		Case StringLeft($sMSG_RECVD, 7) = "/Alert:"
			$aSplit = StringSplit($sMSG_RECVD, ":|")
			
			$iIndex = $aSplit[2]
			$sTaskName = $aSplit[3]
			$sTaskNotes = $aSplit[4]
			
			_RestoreAppFromTray_Proc()
			_GUICtrlListView_SetItemSelected($nListView, $iIndex, 1, 1)
			MsgBox(64, $aMessage[$iMsg_MsgTitlsTskAlrt], "[" & $sTaskName & "]" & @CRLF & StringReplace($sTaskNotes, "\n", @CRLF), 0, $hGUI)
		Case StringLeft($sMSG_RECVD, 11) = "/CheckItem:"
			$aSplit = StringSplit($sMSG_RECVD, ":|")
			$sTaskName = $aSplit[2]
			$iIndex = _GUICtrlListView_FindText($nListView, $sTaskName)
			
			_GUICtrlListView_SetItemChecked($nListView, $iIndex, 1)
			
			If _GUICtrlListView_GetItemText($nListView, $iIndex, $iMark_Col) = $aMessage[$iMsg_KwrdsCanceled] Then
				_GUICtrlListView_SetItemImage($nListView, $iIndex, 2)
			Else
				_GUICtrlListView_SetItemImage($nListView, $iIndex, 1)
			EndIf
			
			_GUICtrlListView_SetItemText($nListView, $iIndex, "100%", $iProgress_Col)
		Case Else
			_RestoreAppFromTray_Proc()
			WinActivate($hGUI)
			_OpenToDoList_Proc($sMSG_RECVD)
	EndSelect
EndFunc

Func _AppRegisterInteraction($sTitle, $vMsg)
	Local $sOccurName = StringReplace($sApp_Title, "\", "")
	Local $ERROR_ALREADY_EXISTS = 183
	
	Local $hDll = DllCall("Kernel32.dll", "int", "CreateMutex", "int", 0, "long", 1, "str", $sOccurName)
	Local $iLastError = DllCall("Kernel32.dll", "int", "GetLastError")
	
	If $iLastError[0] = $ERROR_ALREADY_EXISTS Then
		_AU3COM_SendData($vMsg, WinGetHandle($sTitle))
		Exit
	Else
		GUICreate($sTitle)
		GUIRegisterMsg($WM_COPYDATA, "WM_COPYDATA")
	EndIf
EndFunc

Func _AU3COM_SendData($InfoToSend, $RecvWinHandle)
	Local $StructDef_COPYDATA = "dword var1;dword var2;ptr var3"
	Local $CDString = DllStructCreate("char var1[256];char var2[256]") ;the array to hold the string we are sending
	
	DllStructSetData($CDString, 1, $InfoToSend)
	Local $pCDString = DllStructGetPtr($CDString) ;the pointer to the string
	Local $vs_cds = DllStructCreate($StructDef_COPYDATA);create the message struct
	DllStructSetData($vs_cds, "var1", 0) ;0 here indicates to the receiving program that we are sending a string
	DllStructSetData($vs_cds, "var2", String(StringLen($InfoToSend) + 1));tell the receiver the length of the string
	DllStructSetData($vs_cds, "var3", $pCDString) ;the pointer to the string
	Local $pStruct = DllStructGetPtr($vs_cds)
	DllCall("user32.dll", "long", "SendMessage", "hwnd", $RecvWinHandle, "int", $WM_COPYDATA, "int", 0, "int", $pStruct)
	
	$vs_cds = 0 ;free the struct
	$CDString = 0 ;free the struct
	
	Return 1
EndFunc

Func _AU3COM_RecvData($iCOM_LParam)
	; $COM_LParam = Poiter to a COPYDATA Struct
	Local $STRUCTDEF_AU3MESSAGE = "char var1[256];int"
	Local $StructDef_COPYDATA = "dword var1;dword var2;ptr var3"
	Local $vs_cds = DllStructCreate($StructDef_COPYDATA, $iCOM_LParam)
	
	; Member No. 3 of COPYDATA Struct (PVOID lpData;) = Pointer to Costum Struct
	Local $vs_msg = DllStructCreate($STRUCTDEF_AU3MESSAGE, DllStructGetData($vs_cds, 3))
	Return $vs_msg
EndFunc

Func WM_COPYDATA($hWnd, $MsgID, $WParam, $LParam)
	If $MsgID = $WM_COPYDATA Then
		Local $vsMsg = _AU3COM_RecvData($LParam)
		$sMSG_RECVD = DllStructGetData($vsMsg, 1)
		
		;Here is go whatever we need to do with the recieved string ($sMSGRECVD)
		If Not $iMSG_RECVD_MARK Then
			$iMSG_RECVD_MARK = 1
			AdlibRegister("_AppInteraction_Proc", 1)
		Else
			$iMSG_RECVD_MARK = 0
		EndIf
	EndIf
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_COMMAND($hWnd, $nMsg, $wParam, $lParam)
	Local $nNotifyCode = BitShift($wParam, 16)
	Local $nID = BitAND($wParam, 0xFFFF)
	Local $hCtrl = $lParam
	
	Switch $nNotifyCode
		Case $EN_CHANGE, $EN_UPDATE, $CBN_EDITCHANGE, $CBN_EDITUPDATE
			$bEditChanged = $nID
		Case $EN_SETFOCUS, $CBN_SETFOCUS
			If $nID <> $nLVEdit_MainCtrl Then
				;_CancelEdit()
				$iClicked_Row = _GUICtrlListView_GetSelectedIndices($nLVEdit_LV_CTRL)
				$iClicked_Col = $iLVEdit_EditCol
				_FillLV_Info($nLVEdit_LV_CTRL, Number($iClicked_Row), $iClicked_Col, $aLVEdit_DATA)
				ListView_Click()
			EndIf
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_NOTIFY($hWndGUI, $MsgID, $wParam, $lParam)
	Local $TagNMHDR, $iEvent, $hWndFrom, $iClicked_Row, $iClicked_Col, $iItem
	
	$TagNMHDR = DllStructCreate("int hWndFrom;int iIDFrom;int iCode;int iItem;int iButton;ptr pitem", $lParam)
	If @error Then Return $GUI_RUNDEFMSG
	
	Local $hWndFrom = DllStructGetData($TagNMHDR, "hWndFrom")
	Local $iEvent = DllStructGetData($TagNMHDR, "iCode")
	Local $iItem = DllStructGetData($TagNMHDR, "iItem")
	
	Local $hLV_Header = GUICtrlSendMsg($nLVEdit_LV_CTRL, $LVM_GETHEADER, 0, 0)
	
	$tNMITEMACTIVATE = DllStructCreate("int;int;int;int;int;int;int;int;int", $lParam)
	$iClicked_Row = _GUICtrlListView_GetSelectedIndices($nLVEdit_LV_CTRL) ;DllStructGetData($tNMITEMACTIVATE, 4)
	$iClicked_Col = DllStructGetData($tNMITEMACTIVATE, 5)
	
	Local $tInfo = DllStructCreate($tagNMITEMACTIVATE, $lParam)
	Local $iIndex = DllStructGetData($tInfo, "Index")
	Local $iSubItem = DllStructGetData($tInfo, "SubItem")
	
	Switch $hWndFrom
		Case GUICtrlGetHandle($nLVEdit_LV_CTRL)
			Switch $iEvent
				Case $LVN_ITEMCHANGED, $NM_CLICK, $NM_RCLICK, $NM_DBLCLK
					Local $iChecked = _GUICtrlListView_GetItemChecked($nLVEdit_LV_CTRL, $iIndex)
					
					If $iEvent = $NM_DBLCLK And BitAND(GUICtrlGetState($nToDoNotes_Edit), $GUI_HIDE) Then
						ControlClick($hGUI, "", $nEditToDo_Btn)
					EndIf
					
					If $iIndex <> -1 Then
						Local $iX = DllStructGetData($tInfo, "X")
						Local $iPart = 1
						If _GUICtrlListView_GetView($nLVEdit_LV_CTRL) = 1 Then $iPart = 2 ;for large icons view
						
						Local $aIconRect = _GUICtrlListView_GetItemRect($nLVEdit_LV_CTRL, $iIndex, $iPart)
						
						If $iX < $aIconRect[0] And $iX >= 5 Then
							If $iChecked Then
								_GUICtrlListView_SetItemImage($nLVEdit_LV_CTRL, $iIndex, 0)
								_GUICtrlListView_SetItemText($nLVEdit_LV_CTRL, $iIndex, "0%", $iProgress_Col)
							Else
								If _GUICtrlListView_GetItemText($nLVEdit_LV_CTRL, $iIndex, $iMark_Col) = $aMessage[$iMsg_KwrdsCanceled] Then
									_GUICtrlListView_SetItemImage($nLVEdit_LV_CTRL, $iIndex, 2)
								Else
									_GUICtrlListView_SetItemImage($nLVEdit_LV_CTRL, $iIndex, 1)
								EndIf
								
								_GUICtrlListView_SetItemText($nLVEdit_LV_CTRL, $iIndex, "100%", $iProgress_Col)
							EndIf
							
							$bToDoListChanged = True
						EndIf
					EndIf
					
					If $iEvent <> $NM_DBLCLK Then
						$bLVItemChanged = True
						
						If $iClicked_Col = -1 Then
							$iClicked_Col = $iLVEdit_EditCol
						Else
							$iLVEdit_EditCol = $iClicked_Col
						EndIf
						
						If Not $iChecked Then
							_FillLV_Info($nLVEdit_LV_CTRL, Number($iClicked_Row), $iClicked_Col, $aLVEdit_DATA)
							ListView_Click()
						EndIf
					ElseIf Not $iChecked And $iEvent = $NM_DBLCLK Then
						ContinueCase
					EndIf
				Case $NM_DBLCLK
					If $iClicked_Row = "" Then Return $GUI_RUNDEFMSG
					;$bToDoListChanged = True
					
					GUICtrlSetData($nLVEdit_Combo, "")
					
					Switch $iClicked_Col
						Case $iTitle_Col ;Title column
							;GUICtrlSetData($nLVEdit_Edit, "")
						Case $iMark_Col ;Mark column
							GUICtrlSetData($nLVEdit_Combo, $sMark_Col_Default)
						Case $iPriority_Col ;Priority column
							GUICtrlSetData($nLVEdit_Combo, $sPriority_Col_Default)
						Case $iProgress_Col ;Progress column
							GUICtrlSetData($nLVEdit_Combo, $sProgress_Col_Default)
						Case $iAlert_Col ;Alert column
							Return $GUI_RUNDEFMSG
							;GUICtrlSetData($nLVEdit_Date, _GUICtrlListView_GetItemText($nLVEdit_LV_CTRL, Number($iClicked_Row), $iAlert_Col))
						Case $iNotes_Col ;Notes column
							;GUICtrlSetData($nLVEdit_Edit, "")
					EndSwitch
					
					$iLVEdit_EditCol = $iClicked_Col
					ListView_DoubleClick()
				Case $LVN_ITEMCHANGED
					;$bToDoListChanged = True
				Case $LVN_BEGINDRAG
					Return 1
				Case $LVN_INSERTITEM, $LVN_DELETEITEM, $LVN_DELETEALLITEMS
					;$bToDoListChanged = True
			EndSwitch
		Case $hLV_Header
			Switch $iEvent
				Case $HDN_ITEMCHANGED, $HDN_ITEMCHANGEDW
					Local $aPos = ControlGetPos($hWndGUI, "", $nLVEdit_MainCtrl)
					Local $iWidth = _GUICtrlListView_GetColumnWidth($nLVEdit_LV_CTRL, $iLVEdit_EditCol)
					Local $aRect = _GUICtrlListView_GetSubItemRect($nLVEdit_LV_CTRL, Number($iClicked_Row), $iLVEdit_EditCol)
					GUICtrlSetPos($nLVEdit_MainCtrl, $aRect[0] + 15, $aPos[1], $iWidth - 2)
					GUICtrlSetState($nLVEdit_MainCtrl, $GUI_FOCUS)
					_WinAPI_RedrawWindow(GUICtrlGetHandle($nLVEdit_MainCtrl))
				Case $HDN_ITEMCHANGING, $HDN_ITEMCHANGINGW
					If $iItem = $iNotes_Col And _GUICtrlListView_GetColumnWidth($nLVEdit_LV_CTRL, $iItem) = 0 Then
						Return 1 ;Do not allow showing of "Alert Data" and "Notes" columns
					EndIf
			EndSwitch
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

Func _UpdateEdit(ByRef $editCtrl, ByRef $nLVEdit_LV_CTRL, $iRow, $iCol)
	Local $sStruct = DllStructCreate("ushort[8]")
	Local $newText = GUICtrlRead($editCtrl)
	Local $item = GUICtrlRead($nLVEdit_LV_CTRL)
	
	If GUICtrlSendMsg($editCtrl, $DTM_GETSYSTEMTIME, 0, DllStructGetPtr($sStruct)) <> 0 Then
		$newText = $aMessage[$iMsg_KwrdsNo]
	EndIf
	
	_GUICtrlListView_SetItemText($nLVEdit_LV_CTRL, $iRow, $newText, $iCol)
	
	$bToDoListChanged = True
	_CancelEdit()
EndFunc

Func _Exit_Proc()
	If _CheckChanges_Proc() = 2 Then
		Return
	EndIf
	
	;Cleaning
	_GUICtrlListView_UnRegisterSortCallBack($nListView)
	_TrayIconDelete($nTrayIcon)
	
	Exit
EndFunc

#EndRegion Program Functions
