#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=TDITAgent_Icon.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=Program made by G.Sandler
#AutoIt3Wrapper_Res_Description=ToDo Lists Manager Agent
#AutoIt3Wrapper_Res_Fileversion=1.0.1.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2010 G.Sandler (CreatoR). All rights reserved.
#AutoIt3Wrapper_Res_Field=CompanyName|http://autoit-script.ru
#AutoIt3Wrapper_Res_Field=ProductVersion|1,0,1,0
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#Region Header

#CS
	Title:          TDITAgent - ToDo List Manager Anget.
    Program name:   TDITAgent.au3
    Description:    Agent module for ToDoIt program.
    Author:         G.Sandler (CreatoR), www.autoit-script.ru
    Requirements:   AutoIt v3.3.6.1, Developed/Tested on Windows XP (Service Pack 3)
    Notes:          
#CE

#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#include <SliderConstants.au3>
#include <GUIListView.au3>
#include <Date.au3>
#include <Misc.au3>
#include <Sound.au3>
#include <Timers.au3>

#include "..\Includes\WinAPIEx.au3"

#EndRegion Header

#Region Global Variables

Global $iDebug = Not @Compiled
Global $sScriptDir = @WorkingDir

If Not FileExists($sScriptDir & "\ToDoIt.exe") Then
	If Not $iDebug Then
		Exit
	Else
		FileChangeDir("..\")
		$sScriptDir = @WorkingDir
	EndIf
EndIf

Global $hSound_GUI, $nSound_Slider, $nClose_Buttton, $nPause_Buttton, $nPlay_Buttton
Global $hSound_Timer, $hSound_Open, $iSound_Timer, $iSound_Lenght

Global $hAppWnd, $aReadRcntList
Global $sToDoItIni = $sScriptDir & "\ToDoIt.ini"
Global $sEngLangFile = $sScriptDir & "\Langs\Eng.lng"
Global $sLanguageFile = $sScriptDir & "\Langs\" & IniRead($sToDoItIni, "Main", "Language", "Eng") & ".lng"
Global $sLastToDoIniTime = ""

Global $iAlertActionShowMsg = IniRead($sToDoItIni, "Main", "Alert Action Show Message", 1)
Global $iAlertActionPlaySound = IniRead($sToDoItIni, "Main", "Alert Action Play Sound", 0)
Global $sAlertActionSoundFile = IniRead($sToDoItIni, "Main", "Alert Action Sound File", "")
Global $iAlertActionRunPrgrm = IniRead($sToDoItIni, "Main", "Alert Action Run Program", 0)
Global $sAlertActionPrgrmFile = IniRead($sToDoItIni, "Main", "Alert Action Program File", "")
Global $sAlertActionPrgrmFilePrms = IniRead($sToDoItIni, "Main", "Alert Action Program File Parameters", "")
Global $iMarkTaskAsDoneAfterAlert = IniRead($sToDoItIni, "Main", "Mark Task As Done After Alert", 0)

Global $sAlrtPlaySndCloseBtn = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "AlrtPlaySndCloseBtn", "Close")), 4)
Global $sAlrtPlaySndPasueBtn = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "AlrtPlaySndPasueBtn", "Pause")), 4)
Global $sAlrtPlaySndPlayBtn = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "AlrtPlaySndPlayBtn", "Play")), 4)

Global $sAlrtAction = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "KwrdsAlertAction", "Action")), 4)
Global $sAlrtActionShowMsg = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "KwrdsShowMsg", "Message")), 4)
Global $sAlrtActionPlaySound = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "KwrdsPlaySound", "Sound")), 4)
Global $sAlrtActionRunProgram = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "KwrdsRunProgram", "Program")), 4)

Global $sAlertDisabled = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtCmbDsbl", "Disabled")), 4)
Global $sAlertRunOnce = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtCmbRunOnce", "Run Once")), 4)
Global $sAlertEveryDay = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtCmbEvryDay", "Every day")), 4)
Global $sAlertEveryWeek = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtCmbEvryWeek", "Every week")), 4)
Global $sAlertEveryMonth = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtCmbEvryMonth", "Every month")), 4)
Global $sAlertEveryYear = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtCmbEvryYear", "Every year")), 4)

Global $sAlertDaySun = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtChckBxSu", "Sun")), 4)
Global $sAlertDayMon = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtChckBxMo", "Mon")), 4)
Global $sAlertDayTue = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtChckBxTu", "Tue")), 4)
Global $sAlertDayWen = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtChckBxWe", "Wen")), 4)
Global $sAlertDayThu = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtChckBxTh", "Thu")), 4)
Global $sAlertDayFri = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtChckBxFr", "Fri")), 4)
Global $sAlertDaySat = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "GUIAlrtChckBxSa", "Sat")), 4)

Global $sAlertDaySun_Eng = BinaryToString(StringToBinary(IniRead($sEngLangFile, "Translation", "GUIAlrtChckBxSu", "Sun")), 4)
Global $sAlertDayMon_Eng = BinaryToString(StringToBinary(IniRead($sEngLangFile, "Translation", "GUIAlrtChckBxMo", "Mon")), 4)
Global $sAlertDayTue_Eng = BinaryToString(StringToBinary(IniRead($sEngLangFile, "Translation", "GUIAlrtChckBxTu", "Tue")), 4)
Global $sAlertDayWen_Eng = BinaryToString(StringToBinary(IniRead($sEngLangFile, "Translation", "GUIAlrtChckBxWe", "Wen")), 4)
Global $sAlertDayThu_Eng = BinaryToString(StringToBinary(IniRead($sEngLangFile, "Translation", "GUIAlrtChckBxTh", "Thu")), 4)
Global $sAlertDayFri_Eng = BinaryToString(StringToBinary(IniRead($sEngLangFile, "Translation", "GUIAlrtChckBxFr", "Fri")), 4)
Global $sAlertDaySat_Eng = BinaryToString(StringToBinary(IniRead($sEngLangFile, "Translation", "GUIAlrtChckBxSa", "Sat")), 4)

Global $sAppName = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "AppName", "ToDoIt - ToDo List Manager")), 4)
Global $sTaskAlertTitle = BinaryToString(StringToBinary(IniRead($sLanguageFile, "Translation", "MsgTitlsTskAlrt", "Task Alert")), 4)

#EndRegion Global Variables

#Region Initialization

If $CmdLine[0] > 0 And StringLeft($CmdLine[1], 7) = "/Alert:" Then
	_AlertHandler()
EndIf

_Singleton(StringReplace(@ScriptFullPath, "\", "/"))
AdlibRegister("_CheckToDoTaskAlert_Proc", 1000)

_WinAPI_EmptyWorkingSet()

#EndRegion Initialization

#Region Main Loop

While 1
	Sleep(10)
WEnd

#EndRegion Main Loop

#Region Program Functions

Func _CheckToDoTaskAlert_Proc()
	Local $sToDoIniTime = FileGetTime($sToDoItIni, 0, 1)
	Local $sLastToDoList, $aToDoList, $iCnt, $aSplit
	Local $iChecked, $sTaskName, $sTaskNotes, $sAlertData, $sAlertType, $sAlertDate, $sAlertTime
	
	If $sToDoIniTime <> $sLastToDoIniTime Then
		$sLastToDoIniTime = $sToDoIniTime
		
		$hAppWnd = WinGetHandle("[CLASS:AutoIt v3 GUI;REGEXPTITLE:(?i).*ToDoIt.*]")
		$aReadRcntList = IniReadSection($sToDoItIni, "Recent Lists")
	EndIf
	
	If Not IsArray($aReadRcntList) Then
		Return
	EndIf
	
	For $j = 1 To $aReadRcntList[0][0]
		$aToDoList = IniReadSection($aReadRcntList[$j][1], "ToDo List")
		$iCnt = 0
		
		For $i = 1 To UBound($aToDoList)-1
			$aSplit = StringSplit($aToDoList[$i][1], "|")
			
			If $aSplit[0] < 7 Then
				ContinueLoop
			EndIf
			
			$iChecked = $aSplit[1]
			$sTaskName = $aSplit[2]
			$sTaskNotes = $aSplit[7]
			$sAlertData = $aSplit[6]
			
			If $sAlertData = "" Then
				$iCnt += 1
				ContinueLoop
			EndIf
			
			If $iChecked = 1 Then
				ContinueLoop
			EndIf
			
			$sAlertType = StringRegExpReplace($sAlertData, "^(.*?):.*", "\1")
			$sAlertDate = StringRegExpReplace($sAlertData, "^.*?:.*?(\d{2}(?:\.\d{2})?(?:\.\d{4})?).*", "\1")
			$sAlertTime = StringRegExpReplace($sAlertData, "^.*?:.*?(\d{2}:\d{2}:\d{2}).*", "\1")
			$aAlertDays = StringRegExp($sAlertData, "([^\d]{3}),", 3)
			
			$sAlertDate = _DateFormate($sAlertDate, "yyyy.mm.dd")
			
			_RunTask_Proc($sAlertType, $aAlertDays, $sAlertDate, $sAlertTime, $sTaskName, $sTaskNotes, $sAlertData, _
				$aReadRcntList[$j][1], $aToDoList[$i][0], $aToDoList[$i][1])
		Next
	Next
	
;~ 	If $iCnt = $i-1 And Not ProcessExists("ToDoIt.exe") Then
;~ 		Exit
;~ 	EndIf
EndFunc

Func _RunTask_Proc($sAlertType, $aAlertDays, $sAlertDate, $sAlertTime, $sTaskName, $sTaskNotes, $sAlertData, $sToDoList, $sKey, $sVal)
	Local $sNow = _NowCalc(), $iAlert = 0, $iCheckMark = 0, $sThisDay = _DateDayOfWeek(@WDAY, 1)
	Local $aDateSplit = StringSplit($sAlertDate, ".")
	
	Switch $sAlertType
		Case $sAlertDisabled
			Return
		Case $sAlertRunOnce
			$sAlertDateTime = $sAlertDate & " " & $sAlertTime
			$iCheckMark = 1
		Case $sAlertEveryDay
			$sAlertDateTime = @YEAR & "." & @MON & "." & @MDAY & " " & $sAlertTime
		Case $sAlertEveryWeek
			$sAlertDateTime = @YEAR & "." & @MON & "." & @MDAY & " " & $sAlertTime
			
			For $i = 0 To UBound($aAlertDays)-1
				Switch $aAlertDays[$i]
					Case $sAlertDaySun
						$aAlertDays[$i] = $sAlertDaySun_Eng
					Case $sAlertDayMon
						$aAlertDays[$i] = $sAlertDayMon_Eng
					Case $sAlertDayTue
						$aAlertDays[$i] = $sAlertDayTue_Eng
					Case $sAlertDayWen
						$aAlertDays[$i] = $sAlertDayWen_Eng
					Case $sAlertDayThu
						$aAlertDays[$i] = $sAlertDayThu_Eng
					Case $sAlertDayFri
						$aAlertDays[$i] = $sAlertDayFri_Eng
					Case $sAlertDaySat
						$aAlertDays[$i] = $sAlertDaySat_Eng
				EndSwitch
				
				If $aAlertDays[$i] = $sThisDay Then
					$iAlert = 1
					ExitLoop
				EndIf
			Next
			
			If Not $iAlert Then
				Return
			EndIf
		Case $sAlertEveryMonth
			If $aDateSplit[0] < 1 Then Return
			$sAlertDateTime = @YEAR & "." & @MON & "." & $aDateSplit[1] & " " & $sAlertTime
		Case $sAlertEveryYear
			If $aDateSplit[0] < 2 Then Return
			$sAlertDateTime = @YEAR & "." & $aDateSplit[2] & "." & $aDateSplit[1] & " " & $sAlertTime
		Case Else
			Return
	EndSwitch
	
	Local $sNowDiff = _DateDiff("s", $sAlertDateTime, $sNow)
	Local $sFutureDiff = _DateDiff("s", $sAlertDateTime, _DateAdd("s", 1, $sNow))
	
	If $sNowDiff = 0 Or $sFutureDiff = 0 Then
		If $iCheckMark = 1 And $iMarkTaskAsDoneAfterAlert = 1 Then
			If IsHWnd($hAppWnd) And WinExists($hAppWnd) Then
				_AU3COM_SendData("/CheckItem:" & $sTaskName, $hAppWnd)
			EndIf
			
			IniWrite($sToDoList, "ToDo List", $sKey, "1" & StringTrimLeft($sVal, 1))
		EndIf
		
		If $iDebug Then
			;ToolTip("[" & $sTaskName & "]" & @CRLF & StringReplace($sTaskNotes, "\n", @CRLF), Default, Default, $sTaskAlertTitle, 1, 5)
			Run(@AutoItExe & ' "' & @ScriptFullPath & '" /Alert:' & $sTaskName & "|" & $sTaskNotes & "|" & $sAlertData)
		Else
			Run(@AutoItExe & " /Alert:" & $sTaskName & "|" & $sTaskNotes & "|" & $sAlertData)
		EndIf
	EndIf
EndFunc

Func _AlertHandler()
	Local $aSplit = StringSplit(StringRegExpReplace($CmdLineRaw, "^.*/Alert:", ""), "|")
	If @error Or $aSplit[0] < 3 Then Exit
	
	Local $sTaskName = $aSplit[1]
	Local $sTaskNotes = $aSplit[2]
	Local $sAlertData = $aSplit[3]
	
	$iTskActnRunPrgrm = StringRegExp($sAlertData, "^.*?" & $sAlrtAction & ":.*?\Q" & $sAlrtActionRunProgram & "\E.*")
	$sTskActnPrgrmFile = StringRegExpReplace($sAlertData, "^.*?" & $sAlrtAction & ":.*?\Q" & $sAlrtActionRunProgram & "\E\((.*?);.*?\).*", "\1")
	$sTskActnPrgrmFilePrms = StringRegExpReplace($sAlertData, "^.*?" & $sAlrtAction & ":.*?\Q" & $sAlrtActionRunProgram & "\E\(.*?;(.*?)\).*", "\1")
	
	$iTskActnPlaySound = StringRegExp($sAlertData, "^.*?" & $sAlrtAction & ":.*?\Q" & $sAlrtActionPlaySound & "\E.*")
	$sTskActnSoundFile = StringRegExpReplace($sAlertData, "^.*?" & $sAlrtAction & ":.*?\Q" & $sAlrtActionPlaySound & "\E\((.*?)\).*", "\1")
	
	$iTskActnShowMsg = StringRegExp($sAlertData, "^.*?" & $sAlrtAction & ":.*?\Q" & $sAlrtActionShowMsg & "\E.*")
	
	_Singleton($sTaskName)
	
	If $iTskActnRunPrgrm = $sAlertData And $iTskActnPlaySound = $sAlertData And $iTskActnShowMsg = $sAlertData Then
		$iTskActnRunPrgrm = $iAlertActionRunPrgrm
		$sTskActnPrgrmFile = $sAlertActionPrgrmFile
		$sTskActnPrgrmFilePrms = $sAlertActionPrgrmFilePrms
		
		$iTskActnPlaySound = $iAlertActionPlaySound
		$sTskActnSoundFile = $sAlertActionSoundFile
		
		$iTskActnShowMsg = $iAlertActionShowMsg
	EndIf
	
	If $iTskActnRunPrgrm = 1 Then
		Run($sTskActnPrgrmFile & StringStripWS(" " & $sTskActnPrgrmFilePrms, 2))
	EndIf
	
	If $iTskActnPlaySound = 1 Then
		$hSound_GUI = GUICreate($sAppName & " - " & $sTaskAlertTitle, 400, 150, -1, -1, -1, BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST))
		
		GUICtrlCreateLabel(StringRegExpReplace($sTskActnSoundFile, "^.*\\", ""), 10, 30, 400-20, 20, $SS_CENTER)
		GUICtrlSetFont(-1, 12, 800)
		$nSound_Slider = GUICtrlCreateSlider(10, 70, 400-20, 20, $TBS_NOTICKS)
		GUICtrlSetLimit($nSound_Slider, 100, 0)
		$nClose_Buttton = GUICtrlCreateButton($sAlrtPlaySndCloseBtn, 10, 120, 60, 20)
		$nPause_Buttton = GUICtrlCreateButton($sAlrtPlaySndPasueBtn, 400 - 140, 120, 60, 20)
		$nPlay_Buttton = GUICtrlCreateButton($sAlrtPlaySndPlayBtn, 400 - 70, 120, 60, 20)
		GUICtrlSetState($nPlay_Buttton, $GUI_DISABLE)
		
		$hSound_Open = _SoundOpen($sTskActnSoundFile)
		_SoundPlay($hSound_Open)
		$iSound_Timer = TimerInit()
		$iSound_Lenght = _SoundLength($hSound_Open, 2)
		$hSound_Timer = _Timer_SetTimer($hSound_GUI, 10, "_SoundPlay_Callback")
		
		GUISetState(@SW_SHOW, $hSound_GUI)
	EndIf
	
	If $iTskActnShowMsg = 1 Or ($iTskActnRunPrgrm <> 1 And $iTskActnPlaySound <> 1) Then
		MsgBox(262144+64, $sAppName & " - " & $sTaskAlertTitle, "[" & $sTaskName & "]" & @CRLF & StringReplace($sTaskNotes, "\n", @CRLF))
	EndIf
	
	If $iTskActnPlaySound = 1 Then
		While _SoundStatus($hSound_Open) <> "stopped" And WinExists($hSound_GUI)
			Sleep(100)
		WEnd
		
		_SoundClose($hSound_Open)
		_Timer_KillTimer($hSound_GUI, $hSound_Timer)
		GUIDelete($hSound_GUI)
	EndIf
	
	Exit
EndFunc

Func _SoundPlay_Callback($hWnd, $Msg, $iIDTimer, $dwTime)
	Switch GUIGetMsg()
		Case $nSound_Slider
			Local $iTicks = Round(GUICtrlRead($nSound_Slider) * ($iSound_Lenght / 100))
			Local $iHours, $iMins, $iSecs
			_TicksToTime($iTicks, $iHours, $iMins, $iSecs)
			_SoundSeek($hSound_Open, $iHours, $iMins, $iSecs)
			ContinueCase
		Case $nPlay_Buttton
			_SoundPlay($hSound_Open)
			GUICtrlSetState($nPause_Buttton, $GUI_ENABLE)
			GUICtrlSetState($nPlay_Buttton, $GUI_DISABLE)
		Case $nPause_Buttton
			_SoundPause($hSound_Open)
			GUICtrlSetState($nPause_Buttton, $GUI_DISABLE)
			GUICtrlSetState($nPlay_Buttton, $GUI_ENABLE)
		Case $GUI_EVENT_CLOSE, $nClose_Buttton
			_SoundStop($hSound_Open)
			_SoundClose($hSound_Open)
			_Timer_KillTimer($hSound_GUI, $hSound_Timer)
			GUIDelete($hSound_GUI)
		Case Else
			If _SoundStatus($hSound_Open) = "paused" Then
				Return
			EndIf
			
			If TimerDiff($iSound_Timer) >= 1000 Then
				$iSound_Timer = TimerInit()
				$iStep = 100 / ($iSound_Lenght / _SoundPos($hSound_Open, 2))
				GUICtrlSetData($nSound_Slider, $iStep)
			EndIf
	EndSwitch
EndFunc

Func _DateFormate($sDate, $sRetFormat = -1, $iLocale = 0, $iReplaceCount = 1)
	Local $sDelims_Pattern, $sDay_Pattern, $sMonth_Pattern, $sYear_Pattern, $sSearch_Pattern, $sDay, $sMonth, $sYear, $iMode
	
	If Not StringRegExp($sDate, '\d{2}(\.|/)\d{2}\1\d{4}|\d{4}(\.|/)\d{2}\2\d{2}') Then
		Return $sDate
	EndIf
	
	$sDelims_Pattern = '[\Q /\.,\E]+'
	$sDay_Pattern = '(\d{1,2})'
	$sMonth_Pattern = '(\d{1,2}|[]{3,8}|[decmbrnovtspaugjlyihf]{3,9})'
	$sYear_Pattern = '(\d{4})\h?(?:\.)?'
	
	$sSearch_Pattern = '(?i)' & $sDay_Pattern & $sDelims_Pattern & $sMonth_Pattern & $sDelims_Pattern & $sYear_Pattern
	
	Switch $sRetFormat
		Case -1, Default
			Return StringRegExp($sDate, $sSearch_Pattern, 3)
		Case Else
			$sDay = StringRegExpReplace($sDate, $sSearch_Pattern, '\1')
			$sMonth = StringRegExpReplace($sDate, $sSearch_Pattern, '\2')
			$sYear = StringRegExpReplace($sDate, $sSearch_Pattern, '\3')
			
			If StringIsDigit($sMonth) And Not StringRegExp($sRetFormat, '(?i)[^m]mm?[^m]') Then
				$iMode = 0
				
				If StringInStr($sRetFormat, 'mmm~') Then ;Needs to be expanded - for our reach russian language :)
					$iMode = 1
				EndIf
				
				$sMonth = _DateMonthIntToStr($sMonth, $iLocale, $iMode)
			ElseIf Not StringInStr($sRetFormat, 'mmm') Then
				$sMonth = _DateMonthStrToInt($sMonth)
			EndIf
			
			$sRet = StringReplace($sRetFormat, 'dd', StringFormat('%.2i', $sDay), $iReplaceCount)
			
			If @extended = 0 Then
				$sRet = StringReplace($sRet, 'd', StringFormat('%.1i', $sDay), $iReplaceCount)
			EndIf
			
			$sRet = StringRegExpReplace($sRet, '(?i)mmm~?', $sMonth, $iReplaceCount)
			
			If @extended = 0 Then
				$sRet = StringReplace($sRet, 'mm', StringFormat('%.2i', $sMonth), $iReplaceCount)
				
				If @extended = 0 Then
					$sRet = StringReplace($sRet, 'm', StringFormat('%.1i', $sMonth), $iReplaceCount)
				EndIf
			EndIf
			
			$sRet = StringReplace($sRet, 'yyyy', $sYear, $iReplaceCount)
			
			If @extended = 0 Then
				$sRet = StringReplace($sRet, 'yy', StringRight($sYear, 2), $iReplaceCount)
			EndIf
			
			Return $sRet
	EndSwitch
	
	Return SetError(1, 0, $sDate)
EndFunc

Func _DateMonthIntToStr($iMonth, $iLocale = 0, $iRetMode = 0)
	Local $aMonthNumber_En[13] = ["", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"]
	Local $aMonthNumber_Ru[13] = ["", "", "", "", "", "", "", "", "", "", "", "", ""]
	Local $aMonthNumber_Ru_Mod[13] = ["", "", "", "", "", "", "", "", "", "", "", "", ""]
	
	If Not StringIsInt($iMonth) Or $iMonth < 1 Or $iMonth > 12 Then
		Return SetError(1, 0, $iMonth)
	EndIf
	
	Switch $iLocale
		Case 1
			If $iRetMode = 1 Then
				Return StringUpper(StringLeft($aMonthNumber_Ru_Mod[$iMonth], 1)) & StringMid($aMonthNumber_Ru_Mod[$iMonth], 2)
			Else
				Return StringUpper(StringLeft($aMonthNumber_Ru[$iMonth], 1)) & StringMid($aMonthNumber_Ru[$iMonth], 2)
			EndIf
		Case Else
			Return StringUpper(StringLeft($aMonthNumber_En[$iMonth], 1)) & StringMid($aMonthNumber_En[$iMonth], 2)
	EndSwitch
EndFunc

Func _DateMonthStrToInt($sMonth)
	Local $aMonths_En = StringSplit('january|february|march|april|may|june|july|august|september|october|november|december', '|')
	Local $aMonths_En_Shrt = StringSplit('jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec', '|')
	
	For $i = 1 To $aMonths_En[0]
		If $sMonth = $aMonths_En[$i] Then
			Return StringFormat('%.2i', $i)
		EndIf
	Next
	
	For $i = 1 To $aMonths_En_Shrt[0]
		If $sMonth = $aMonths_En_Shrt[$i] Then
			Return StringFormat('%.2i', $i)
		EndIf
	Next
	
	Local $aMonths_Ru = StringSplit('|||||||||||', '|')
	Local $aMonths_Ru_Shrt = StringSplit('|||||||.||||', '|')
	Local $aMonths_Ru_Mod = StringSplit('|||||||||||', '|')
	
	For $i = 1 To $aMonths_Ru[0]
		If $sMonth = $aMonths_Ru[$i] Then
			Return StringFormat('%.2i', $i)
		EndIf
	Next
	
	For $i = 1 To $aMonths_Ru_Shrt[0]
		If $sMonth = $aMonths_Ru_Shrt[$i] Then
			Return StringFormat('%.2i', $i)
		EndIf
	Next
	
	For $i = 1 To $aMonths_Ru_Mod[0]
		If $sMonth = $aMonths_Ru_Mod[$i] Then
			Return StringFormat('%.2i', $i)
		EndIf
	Next
	
	Return SetError(1, 0, $sMonth)
EndFunc

Func _AU3COM_SendData($InfoToSend, $RecvWinHandle)
	Local $StructDef_COPYDATA = "dword var1;dword var2;ptr var3"
	Local $CDString = DllStructCreate("char var1[256];char var2[256]") ;the array to hold the string we are sending
	
	DllStructSetData($CDString, 1, $InfoToSend)
	Local $pCDString = DllStructGetPtr($CDString) ;the pointer to the string
	Local $vs_cds = DllStructCreate($StructDef_COPYDATA);create the message struct
	DllStructSetData($vs_cds, "var1", 0) ;0 here indicates to the receiving program that we are sending a string
	DllStructSetData($vs_cds, "var2", String(StringLen($InfoToSend) + 1));tell the receiver the length of the string
	DllStructSetData($vs_cds, "var3", $pCDString) ;the pointer to the string
	Local $pStruct = DllStructGetPtr($vs_cds)
	DllCall("user32.dll", "long", "SendMessage", "hwnd", $RecvWinHandle, "int", $WM_COPYDATA, "int", 0, "int", $pStruct)
	
	$vs_cds = 0 ;free the struct
	$CDString = 0 ;free the struct
	
	Return 1
EndFunc

#EndRegion Program Functions
