#include-once
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <EditConstants.au3>
#include <DateTimeConstants.au3>
#include <GUIListview.au3>
; ------------------------------------------------------------------------------
;
; AutoIt Version:     3.0
; Language:         English
; Description: Multi-column editable Listview  (EditInPlace)
;                    Stephen Podhajecki <gehossafats at netmdc.com/> Gary Frost <gafrost at charter dot net/>
;                    pdm for control array concept
;                    see http://www.autoitscript.com/forum/index.ph...mp;#entry322551
;==============================================================================
;    ######>>> set the type of control for each column <<<######
;    0 = Input/edit  1 = combobox 2 = date control
;    Global $aLVEdit_ColCtrls[4]=[0,0,1,2]
;    _InitEditLib();######>>>  add this before your ListView <<<######
;    _MonitorEditState($Gui, $nLVEdit_MainCtrl, $iLVEdit_EditFlag, $nLVEdit_LV_CTRL, $aLVEdit_DATA, $aLVEdit_ColCtrls);######>>>  add this in your message loop<<<######
;    _TermEditLib();######>>>  add this after your message loop<<<######
; $nLVEdit_LV_CTRL = $ListView1 ######>>> Set this to your ListView control <<<######
;==============================================================================


Global Const $DebugIt = 0

Global $nLVEdit_LV_CTRL = -999
Global $bLVItemChanged = False
Global $iLVEdit_EditFlag, $iLVEdit_EditCol
Global $nLVEdit_MainCtrl ;= the CtrlId of the editing control.
;;array dim to number of cols, value of each element determines control.
Global $aLVEdit_ColCtrls[1] = [0] ;0= edit, 1= combo, 2= calendar
Global $nLVEdit_Edit, $nLVEdit_Combo, $nLVEdit_Date
Global $aLVEdit_DATA[8]

Opt("GUICloseOnESC", 0);turn off exit on esc.

Func __IsPressedMod($dll = "user32.dll")
	Local $aR, $bRv, $hexKey, $i
	For $i = 8 To 128
		$hexKey = '0x' & Hex($i, 2)
		$aR = DllCall($dll, "int", "GetAsyncKeyState", "int", $hexKey)
		If $aR[0] <> 0 Then Return $i
		If Mod($i, 10) = 0 Then Sleep(5)
	Next
	Return 0
EndFunc   ;==>__IsPressedMod

;===============================================================================
; Function Name:    _CancelEdit
; Description:        Cancels the editing process, and kills the hot keys.
; Parameter(s):
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):
;===============================================================================
Func _CancelEdit()
	AdlibUnRegister("_CancelEdit")
	
	Local $hEditCtrl = GUICtrlGetHandle($nLVEdit_MainCtrl)
	
	If $hEditCtrl Then
		ControlSend("", "", $hEditCtrl, "{ENTER}") ;quit edit mode
	EndIf
	
	$iLVEdit_EditFlag = 0
	
	GUICtrlSetState($nLVEdit_MainCtrl, $GUI_HIDE)
	GUICtrlSetPos($nLVEdit_MainCtrl, 0, 0, 1, 1)
EndFunc   ;==>_CancelEdit

;===============================================================================
; Function Name:    _DebugHeader
; Description:        Gary's console debug header.
; Parameter(s):            $s_text         - IN -
;
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):
;===============================================================================
Func _DebugHeader($s_text)
	Return _
			"!===========================================================" & @LF & _
			"+===========================================================" & @LF & _
			"-->" & $s_text & @LF & _
			"+===========================================================" & @LF
EndFunc   ;==>_DebugHeader

;===============================================================================
; Function Name:    _FillLV_Info
; Description:        This fills the passed in array with row col and rect info for
;                        used by the editing controls
; Parameter(s):            $nLVEdit_LV_CTRL         - IN/OUT -
;                    $iRow         - IN -
;                    $iCol         - IN -
;                    $aLVI         - IN/OUT -
;
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):
;===============================================================================
Func _FillLV_Info(ByRef $nLVEdit_LV_CTRL, $iRow, $iCol, ByRef $aLVI)
	If $iRow < 0 Or $iCol < 0 Then Return 0
	Local $lvi_rect[4], $ret
	Local $pos = ControlGetPos("", "", $nLVEdit_LV_CTRL)
	If @error Then Return 0
	
	$ret = _GUICtrlListViewGetSubItemRect($nLVEdit_LV_CTRL, $iRow, $iCol, $lvi_rect)
	$aLVI[6] = $aLVI[0]
	$aLVI[7] = $aLVI[1]
	$aLVI[0] = $iRow
	$aLVI[1] = $iCol
	$aLVI[2] = $pos[0] + $lvi_rect[0] + 7
	$aLVI[3] = $pos[1] + $lvi_rect[1] + 4
	$aLVI[4] = _GUICtrlListView_GetColumnWidth($nLVEdit_LV_CTRL, $iCol) - 3
	$aLVI[5] = $lvi_rect[3] + 3
	
	Return 1
EndFunc   ;==>_FillLV_Info

;===============================================================================
; Function Name:    _GUICtrlListViewGetSubItemRect
; Description:     Get the bounding rect of a listview item
; Parameter(s):    $h_listview         - IN -
;                        $row         - IN -
;                        $col         - IN -
;                        $aRect         - IN/OUT -
;
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):
;===============================================================================
Func _GUICtrlListViewGetSubItemRect($h_listview, $row, $col, ByRef $aRect)
	Local $rectangle, $rv
	$rectangle = DllStructCreate("int;int;int;int") ;left, top, right, bottom
	DllStructSetData($rectangle, 1, $LVIR_BOUNDS)
	DllStructSetData($rectangle, 2, $col)
	If IsHWnd($h_listview) Then
		Local $a_ret = DllCall("user32.dll", "int", "SendMessage", "hwnd", $h_listview, "int", $LVM_GETSUBITEMRECT, "int", $row, "ptr", DllStructGetPtr($rectangle))
		$rv = $a_ret[0]
	Else
		$rv = GUICtrlSendMsg($h_listview, $LVM_GETSUBITEMRECT, $row, DllStructGetPtr($rectangle))
	EndIf
	ReDim $aRect[4]
	$aRect[0] = DllStructGetData($rectangle, 1)
	$aRect[1] = DllStructGetData($rectangle, 2)
	$aRect[2] = DllStructGetData($rectangle, 3)
	$aRect[3] = DllStructGetData($rectangle, 4) - $aRect[1]
	$rectangle = 0
	Return $rv
EndFunc   ;==>_GUICtrlListViewGetSubItemRect

;===============================================================================
; Function Name:    _InitEdit
; Description:        Bring forth the editing control and set focus on it.
; Parameter(s):    $aLVEdit_DATA         - IN -
;                        $aLVEdit_ColCtrls         - IN -
;
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):
;===============================================================================
Func _InitEdit($aLVEdit_DATA, $aLVEdit_ColCtrls)
	Local $CtrlType
	If $aLVEdit_DATA[0] < 0 Or $aLVEdit_DATA[1] < 0 Then Return 0
	
	If UBound($aLVEdit_ColCtrls) - 1 < $aLVEdit_DATA[1] Then
		$CtrlType = 0
	Else
		$CtrlType = $aLVEdit_ColCtrls[$aLVEdit_DATA[1]]
	EndIf
	
	;----------------------------------------------------------------------------------------------
	If $DebugIt Then ConsoleWrite(_DebugHeader("$CtrlType:" & $CtrlType))
	;----------------------------------------------------------------------------------------------
	
	Switch $CtrlType
		Case 1
			$nLVEdit_MainCtrl = $nLVEdit_Combo
		Case 2
			$nLVEdit_MainCtrl = $nLVEdit_Date
		Case Else
			GUICtrlSetData($nLVEdit_Edit, "")
			$nLVEdit_MainCtrl = $nLVEdit_Edit
	EndSwitch
	
	GUICtrlSetPos($nLVEdit_MainCtrl, $aLVEdit_DATA[2], $aLVEdit_DATA[3], $aLVEdit_DATA[4], $aLVEdit_DATA[5])
	Local $oldText = _GUICtrlListView_GetItemText($nLVEdit_LV_CTRL, $aLVEdit_DATA[0], $aLVEdit_DATA[1])
	
	If $oldText <> "" Then
		GUICtrlSetData($nLVEdit_MainCtrl, $oldText)
	EndIf
	
	GUICtrlSetState($nLVEdit_MainCtrl, $GUI_SHOW)
	GUICtrlSetState($nLVEdit_MainCtrl, $GUI_FOCUS)
	$iLVEdit_EditFlag = 1
EndFunc   ;==>_InitEdit

;===============================================================================
; Function Name:    _InitEditLib
; Description:        Create the editing controls and registers WM_NOTIFY handler.
; Parameter(s):
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):        Call this BEFORE you create your listview.
;===============================================================================
Func _InitEditLib($sRegisterFunc = "WM_NOTIFY")
	$nLVEdit_Edit = GUICtrlCreateInput("", 0, 0, 1, 1, BitOR($ES_AUTOHSCROLL, $ES_NOHIDESEL, $WS_BORDER), 0)
	GUICtrlSetState($nLVEdit_Edit, BitOR($GUI_HIDE, $GUI_ONTOP))
	$nLVEdit_Combo = GUICtrlCreateCombo("", 0, 0, 1, 1)
	GUICtrlSetState($nLVEdit_Combo, BitOR($GUI_HIDE, $GUI_ONTOP))
	$nLVEdit_Date = GUICtrlCreateDate("", 0, 0, 1, 1, BitOR($DTS_SHORTDATEFORMAT, $DTS_SHOWNONE))
	GUICtrlSendMsg($nLVEdit_Date, $DTM_SETFORMATW, 0, "yyyy/MM/dd HH:mm:ss")
	GUICtrlSetState($nLVEdit_Date, BitOR($GUI_HIDE, $GUI_ONTOP))
	GUIRegisterMsg($WM_NOTIFY, $sRegisterFunc)
EndFunc   ;==>_InitEditLib
; WM_NOTIFY event handler

;===============================================================================
; Function Name:    _MonitorEditState
; Description:        Handles {enter} {esc} and {f2}
; Parameter(s):    $h_gui     - IN/OUT -
;                        $nLVEdit_MainCtrl     - IN/OUT -
;                        $iLVEdit_EditFlag     - IN/OUT -
;                        $nLVEdit_LV_CTRL     - IN/OUT -
;                        $aLVEdit_DATA     - IN/OUT -
;                        $aLVEdit_ColCtrls         - IN -
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):
;===============================================================================
Func _MonitorEditState(ByRef $h_gui, ByRef $nLVEdit_MainCtrl, ByRef $iLVEdit_EditFlag, ByRef $nLVEdit_LV_CTRL, ByRef $aLVEdit_DATA, $aLVEdit_ColCtrls)
	Local $pressed = __IsPressedMod()
	
	If $iLVEdit_EditFlag And $pressed = 13 Then; pressed enter
		_UpdateEdit($nLVEdit_MainCtrl, $nLVEdit_LV_CTRL, $aLVEdit_DATA[0], $aLVEdit_DATA[1])
	ElseIf $iLVEdit_EditFlag And $pressed = 27 Then; pressed esc
		_CancelEdit()
		$iLVEdit_EditFlag = 0
	ElseIf Not $iLVEdit_EditFlag And $pressed = 113 Then; pressed f2
		;_InitEdit($aLVEdit_DATA, $aLVEdit_ColCtrls); hmmm, the control doesn't always focus correctly
		MouseClick("primary") ;workaround work all the time (if mouse is over the control)
		MouseClick("primary")
	EndIf
	
	Sleep(20)
EndFunc   ;==>_MonitorEditState

;===============================================================================
; Function Name:    _TermEditLib
; Description:        Deletes the editing controls and un-registers WM_NOTIFY handler.
; Parameter(s):
;Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):        Call this when close your gui if switching to another gui.
;===============================================================================
Func _TermEditLib()
	GUICtrlDelete($nLVEdit_Edit)
	GUICtrlDelete($nLVEdit_Combo)
	GUICtrlDelete($nLVEdit_Date)
	GUIRegisterMsg($WM_NOTIFY, "")
EndFunc   ;==>_TermEditLib

;===============================================================================
; Function Name:    ListView_Click
; Description:    Called from WN_NOTIFY event handler.
; Parameter(s):
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):
;===============================================================================
Func ListView_Click()
	;----------------------------------------------------------------------------------------------
	If $DebugIt Then ConsoleWrite(_DebugHeader("$NM_CLICK"))
	;----------------------------------------------------------------------------------------------
	Sleep(10)
	If $iLVEdit_EditFlag = 1 Then
		If UBound($aLVEdit_ColCtrls) - 1 < $aLVEdit_DATA[1] Then
			_CancelEdit()
		Else
			_UpdateEdit($nLVEdit_MainCtrl, $nLVEdit_LV_CTRL, $aLVEdit_DATA[6], $aLVEdit_DATA[7])
		EndIf
	EndIf
EndFunc   ;==>ListView_Click

;===============================================================================
; Function Name:    ListView_DoubleClick
; Description:    Called from WN_NOTIFY event handler.
; Parameter(s):
; Requirement(s):
; Return Value(s):
; User CallTip:
; Author(s):
; Note(s):            Initiates the edit process on a DblClick
;===============================================================================
Func ListView_DoubleClick()
	;----------------------------------------------------------------------------------------------
	If $DebugIt Then ConsoleWrite(_DebugHeader("$NM_DBLCLICK"))
	;----------------------------------------------------------------------------------------------
	If $iLVEdit_EditFlag = 0 Then
		_InitEdit($aLVEdit_DATA, $aLVEdit_ColCtrls)
	Else
		_CancelEdit()
	EndIf
EndFunc   ;==>ListView_DoubleClick
