#include <ButtonConstants.au3>
#include <GUIConstantsEx.au3>
#include <ProgressConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>

Func _ServerWindow_UploadFile($sFile, $hGui)
	GUISetState ( @SW_HIDE, $hGui)
$hTransferWnd = GUICreate(" FTP ", 305, 111)
	GUISetIcon ( @ScriptFullPath, 0 )
GUICtrlCreateLabel(" ...", 11, 14, 243, 17)
	$hProgress2 = GUICtrlCreateProgress(12, 42, 282, 17)
	$hCansel = GUICtrlCreateCheckbox("", 236, 87, 63, 19, BitOR($GUI_SS_DEFAULT_CHECKBOX,$BS_PUSHLIKE))
	$hLabel = GUICtrlCreateLabel(": "&$sFile, 16, 67, 214, 38)
GUISetState(@SW_SHOW)


_FTP_FileGetSize($hFtpServSession, $sFile)
	If NOT @Error Then
	Dim $iMsgBoxAnswer
	$iMsgBoxAnswer = MsgBox(49," FTP ","   ! ?", 0, $hTransferWnd)
	Select
	   Case $iMsgBoxAnswer = 1 ;OK
	   Case $iMsgBoxAnswer = 2 ;Cancel
		GUIDelete ( $hTransferWnd )
		GUISetState ( @SW_SHOW, $hGui)
		Return 0
	EndSelect
	EndIF

	If GUICtrlRead($hCansel) = 1 Then
	GUIDelete ( $hTransferWnd )
	GUISetState ( @SW_SHOW, $hGui)
	Return 0
	EndIF



Local $sErrorMsg
While 1
	If GUICtrlRead($hCansel) = 1 Then
	GUIDelete ( $hTransferWnd )
	GUISetState ( @SW_SHOW, $hGui)
	Return 0
	EndIF
GUICtrlSetData ( $hLabel, ": "&$sFile )
_FTP_ProgressUpload($hFtpServSession, $sFile, $sFile, "_ServerWindow_UploadFolder_ProgressFunc")
	If NOT @Error Then ExitLoop

Switch @Error
	Case -1
	$sErrorMsg = "["&@Error&"]     "

	Case -3
	$sErrorMsg = "["&@Error&"]    "

	Case -4
	$sErrorMsg = "["&@Error&"]    "

	Case -5
	$sErrorMsg = "["&@Error&"]    "

	Case -6
	GUIDelete ( $hTransferWnd )
	GUISetState ( @SW_SHOW, $hGui)
	Return 0

	Case Else
	$sErrorMsg = "["&@Error&"]  "
EndSwitch

GUICtrlSetData ( $hLabel, @Error&" : "&$sFile )
Dim $iMsgBoxAnswer
$iMsgBoxAnswer = MsgBox(53," FTP ","    :"&@CRLF&$sErrorMsg, 0, $hTransferWnd)
Select
   Case $iMsgBoxAnswer = 4 ;Retry
   Case $iMsgBoxAnswer = 2 ;Cancel
		GUIDelete ( $hTransferWnd )
		GUISetState ( @SW_SHOW, $hGui)
		Return 0
EndSelect
Wend

GUIDelete ( $hTransferWnd )
GUISetState ( @SW_SHOW, $hGui)
Return 1
EndFunc




Func _ServerWindow_DownloadFile($sFile, $hGui)
	GUISetState ( @SW_HIDE, $hGui)
$hTransferWnd = GUICreate(" FTP ", 305, 111)
	GUISetIcon ( @ScriptFullPath, 0 )
GUICtrlCreateLabel(" ...", 11, 14, 243, 17)
	$hProgress2 = GUICtrlCreateProgress(12, 42, 282, 17)
	$hCansel = GUICtrlCreateCheckbox("", 236, 87, 63, 19, BitOR($GUI_SS_DEFAULT_CHECKBOX,$BS_PUSHLIKE))
	$hLabel = GUICtrlCreateLabel(": "&$sFile, 16, 67, 214, 38)
GUISetState(@SW_SHOW)


	If FileExists( $sFile ) Then
	Dim $iMsgBoxAnswer
	$iMsgBoxAnswer = MsgBox(49," FTP ","   ! ?", 0, $hTransferWnd)
	Select
	   Case $iMsgBoxAnswer = 1 ;OK
	   Case $iMsgBoxAnswer = 2 ;Cancel
		GUIDelete ( $hTransferWnd )
		GUISetState ( @SW_SHOW, $hGui)
		Return 0
	EndSelect
	EndIF

	If GUICtrlRead($hCansel) = 1 Then
	GUIDelete ( $hTransferWnd )
	GUISetState ( @SW_SHOW, $hGui)
	Return 0
	EndIF



Local $sErrorMsg
While 1
	If GUICtrlRead($hCansel) = 1 Then
	GUIDelete ( $hTransferWnd )
	GUISetState ( @SW_SHOW, $hGui)
	Return 0
	EndIF
GUICtrlSetData ( $hLabel, ": "&$sFile )
_FTP_ProgressDownload($hFtpServSession, $sFile, $sFile, "_ServerWindow_UploadFolder_ProgressFunc")
	If NOT @Error Then ExitLoop

Switch @Error
	Case -1
	$sErrorMsg = "["&@Error&"]     "

	Case -2
	$sErrorMsg = "["&@Error&"]      "

	Case -3
	$sErrorMsg = "["&@Error&"]     "

	Case -4
	$sErrorMsg = "["&@Error&"]     "

	Case -5
	$sErrorMsg = "["&@Error&"]     "

	Case -6
	GUIDelete ( $hTransferWnd )
	GUISetState ( @SW_SHOW, $hGui)
	Return 0

	Case -7
	$sErrorMsg = "["&@Error&"]     "

	Case Else
	$sErrorMsg = "["&@Error&"]  "
EndSwitch

GUICtrlSetData ( $hLabel, @Error&" : "&$sFile )
Dim $iMsgBoxAnswer
$iMsgBoxAnswer = MsgBox(53," FTP ","    :"&@CRLF&$sErrorMsg, 0, $hTransferWnd)
Select
   Case $iMsgBoxAnswer = 4 ;Retry
   Case $iMsgBoxAnswer = 2 ;Cancel
		GUIDelete ( $hTransferWnd )
		GUISetState ( @SW_SHOW, $hGui)
		Return 0
EndSelect
Wend

GUIDelete ( $hTransferWnd )
GUISetState ( @SW_SHOW, $hGui)
Return 1
EndFunc
