#CS
=====================================================================================================

	:					_ContextMenu_Create
	:				  ContextMenu
	:				_ContextMenu_Create()
	 :	  (controlID).  -   0
=====================================================================================================

	:					_ContextMenu_Show
	:				  ContextMenu
	:				_ContextMenu_Show($hWnd, $CtrlID, $nContextID)
	:
		$hWnd = 		 ,     ContextMenu
		$CtrlID =		  (controlID),     ContextMenu.  !
		$nContextID = 	  -    _ContextMenu_Create
	 :	
	:				  $CtrlID    ,        ,       "1x1",  "100x20"
							   $CtrlID  "0",       ,  
=====================================================================================================

	:					_ContextMenu_Delete
	:				  ContextMenu
	:				_ContextMenu_Delete($sCtrlID)
	:
		$sCtrlID = 	  -    _ContextMenu_Create
	 :	1.   - 0
=====================================================================================================
#CE



Func _ContextMenu_Create()
	IF IsDeclared ( "ContextMenu_DataPM" ) <> 1 Then Global $ContextMenu_DataPM = 0
Local $OptionsDummy = GUICtrlCreateDummy()
Local $Return = GUICtrlCreateContextMenu($OptionsDummy)
$ContextMenu_DataPM = $Return&"|"&$OptionsDummy&@CRLF
Return $Return
EndFunc


Func _ContextMenu_Delete($sCtrlID)
GUICtrlDelete ( $sCtrlID )
	IF IsDeclared ( "ContextMenu_DataPM" ) <> 1 Then Return 0
Local $Lines = StringSplit ( $ContextMenu_DataPM, @CRLF )
Local $sEndData = ""
If $Lines[0] = 0 Then Return 0
	For $i = 1 To $Lines[0]
	Local $LineData = $Lines[$i]
	Local $Data
		If $LineData <> "" Then
			$Data = StringSplit ( $LineData, "|" )
			If $Data[0] = 2 Then
				If $Data[1] = $sCtrlID Then 
				GUICtrlDelete ( $Data[2] )
				Else
				$sEndData = $LineData&@CRLF
				EndIf
			Else
			$sEndData = $LineData&@CRLF
			EndIF
		EndIF
	Next
$ContextMenu_DataPM = $sEndData
Return 1
EndFunc


Func _ContextMenu_Show($hWnd, $CtrlID, $nContextID)
	Local $arPos, $x, $y
	Local $hMenu = GUICtrlGetHandle($nContextID)
	
If $CtrlID <> 0 Then
	$arPos = ControlGetPos($hWnd, "", $CtrlID)
	If NOT @error Then
	$x = $arPos[0]
	$y = $arPos[1] + $arPos[3]
	Else
		Local $Split = StringSplit ( $CtrlID, "x" )
		If $Split[0] <> 2 Then
		$x = 0
		$y = 0
		Else
		$x = $Split[1]
		$y = $Split[2]
		EndIF
	EndIF
Else
$arPos = GUIGetCursorInfo()
$x = $arPos[0]
$y = $arPos[1] 
EndIF
	
	_ContextMenu_ClientToScreen($hWnd, $x, $y)
	_ContextMenu_TrackPopupMenu($hWnd, $hMenu, $x, $y)
EndFunc   ;==>_ContextMenu_Show


Func _ContextMenu_ClientToScreen($hWnd, ByRef $x, ByRef $y)
	Local $stPoint = DllStructCreate("int;int")
	
	DllStructSetData($stPoint, 1, $x)
	DllStructSetData($stPoint, 2, $y)

	DllCall("user32.dll", "int", "ClientToScreen", "hwnd", $hWnd, "ptr", DllStructGetPtr($stPoint))
	
	$x = DllStructGetData($stPoint, 1)
	$y = DllStructGetData($stPoint, 2)
	; release Struct not really needed as it is a local
	$stPoint = 0
EndFunc   ;==>_ContextMenu_ClientToScreen


Func _ContextMenu_TrackPopupMenu($hWnd, $hMenu, $x, $y)
	DllCall("user32.dll", "int", "TrackPopupMenuEx", "hwnd", $hMenu, "int", 0, "int", $x, "int", $y, "hwnd", $hWnd, "ptr", 0)
EndFunc   ;==>_ContextMenu_TrackPopupMenu