#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <ListViewConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>

; Global $hFtpServContol, $hFtpServSession, $sFtpServLocalDir, $sFtpServRemoteDir, $sFtpServTitle
Global $sFtpServTitleHex


Func _ServerWindow()
$sFtpServTitleHex = StringTrimLeft(_StrToHex($sFtpServTitle), 2)
Local $hWnd, $hStatusLabel, $hFtpConfig, $iConnPause=0
$sFtpServTitle &= " -  FTP "
FileChangeDir( @MyDocumentsDir )

$hWnd = GUICreate($sFtpServTitle, 641, 448)
	GUISetIcon ( @ScriptFullPath, 0 )


Local $hLocalDirAddress, $hLocalDirOk, $hLocalDirSell, $hLocalContent, $hLocalSend, $hLocalOperations
GUICtrlCreateLabel(" :", 4, 4, 96, 17)
$hLocalDirAddress = GUICtrlCreateInput($sFtpServLocalDir, 3, 22, 296, 21)
$hLocalDirOk = GUICtrlCreateButton("", 223, 0, 75, 20)
$hLocalDirSell = GUICtrlCreateButton("...", 144, 0, 75, 20)

$hLocalContent = GUICtrlCreateListView("|||", 5, 56, 309, 307, -1, BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES,$LVS_EX_FULLROWSELECT))
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 0, 50)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 1, 150)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 2, 100)

$hLocalSend = GUICtrlCreateButton("  >", 162, 368, 152, 22)
$hLocalOperations = GUICtrlCreateButton("...", 6, 368, 152, 22)




GUICtrlCreateLabel("", 320, 0, 1, 400)
GUICtrlSetBkColor(-1, 0x000000)
$hStatusLabel = GUICtrlCreateLabel("  ...", 4, 426, 631, 17, $SS_CENTER)
$hFtpConfig = GUICtrlCreateButton("", 283, 401, 75, 25)



Local $hRemoteDirAddress, $hRemoteDirOk, $hRemoteDirSell, $hRemoteContent, $hRemoteOperations, $hRemoteGet
GUICtrlCreateLabel(" :", 340, 6, 96, 17)
$hRemoteDirAddress = GUICtrlCreateInput($sFtpServRemoteDir, 339, 24, 296, 21)
$hRemoteDirOk = GUICtrlCreateButton("", 559, 2, 75, 20)
$hRemoteDirSell = GUICtrlCreateButton("...", 480, 2, 75, 20)

$hRemoteContent = GUICtrlCreateListView("|||", 326, 57, 309, 307, -1, BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES,$LVS_EX_FULLROWSELECT))
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 0, 50)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 1, 150)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 2, 100)

$hRemoteOperations = GUICtrlCreateButton("...", 483, 369, 152, 22)
$hRemoteGet = GUICtrlCreateButton("<  ", 327, 369, 152, 22)


Local $hLocalContextMenu, $hRemoteContextMenu, $hLCM_OpenDir, $hRCM_OpenDir, $hLCM_UpDir, $hRCM_UpDir, $hLCM_Upload, $hRCM_Download, $hLCM_Update, $hRCM_Update, $hLCM_Delete, $hRCM_Delete, $hLCM_NewDir, $hRCM_NewDir
$hLocalContextMenu = GUICtrlCreateContextMenu ( $hLocalContent )
$hRemoteContextMenu = GUICtrlCreateContextMenu ( $hRemoteContent )
	$hLCM_OpenDir = 	_GUICtrlCreateODMenuItem ( "  ...", $hLocalContextMenu, @ScriptFullPath, $iOpenDirIconIndex)
	$hLCM_UpDir = 	_GUICtrlCreateODMenuItem ( "  ", $hLocalContextMenu, @ScriptFullPath, $iUpDirIconIndex )
	$hLCM_Update = 	_GUICtrlCreateODMenuItem ( "", $hLocalContextMenu, @ScriptFullPath, $iContentUpdateIconIndex )
					GUICtrlCreateMenuItem ( "", $hLocalContextMenu )
	$hLCM_Upload = 	_GUICtrlCreateODMenuItem ( "  >", $hLocalContextMenu, @ScriptFullPath, $iTransferSendIconIndex )
	$hLCM_Delete = 	_GUICtrlCreateODMenuItem ( " ", $hLocalContextMenu, @ScriptFullPath, $iDeleteIconIndex )
	$hLCM_Rename = 	_GUICtrlCreateODMenuItem ( " ", $hLocalContextMenu, @ScriptFullPath, $iRenameIconIndex )
	$hLCM_NewDir = 	_GUICtrlCreateODMenuItem ( " ", $hLocalContextMenu, @ScriptFullPath, $iCreateDirIconIndex )


	$hRCM_OpenDir = 	_GUICtrlCreateODMenuItem ( "  ...", $hRemoteContextMenu, @ScriptFullPath, $iOpenDirIconIndex )
	$hRCM_UpDir = 	_GUICtrlCreateODMenuItem ( "  ", $hRemoteContextMenu, @ScriptFullPath, $iUpDirIconIndex )
	$hRCM_Update = 	_GUICtrlCreateODMenuItem ( "", $hRemoteContextMenu, @ScriptFullPath, $iContentUpdateIconIndex )
					GUICtrlCreateMenuItem ( "", $hRemoteContextMenu )
	$hRCM_Download =	_GUICtrlCreateODMenuItem ( "<  ", $hRemoteContextMenu, @ScriptFullPath, $iTransferGetIconIndex )
	$hRCM_Delete =	_GUICtrlCreateODMenuItem ( " ", $hRemoteContextMenu, @ScriptFullPath, $iDeleteIconIndex )
	$hRCM_Rename =	_GUICtrlCreateODMenuItem ( " ", $hRemoteContextMenu, @ScriptFullPath, $iRenameIconIndex )
	$hRCM_NewDir =	_GUICtrlCreateODMenuItem ( " ", $hRemoteContextMenu, @ScriptFullPath, $iCreateDirIconIndex )



Local $hLocalOperationsContextMenu, $hLOCM_Transition, $hLOCMT_Home, $hLOCMT_Up, $hLOCM_Mark, $hLOCMM_Set, $hLOCMM_Del, $hLOCM_Delete, $hLOCM_Transfer
$hLocalOperationsContextMenu = _ContextMenu_Create()
	$hLOCM_Transition = _GUICtrlCreateODMenu ( "", $hLocalOperationsContextMenu, @ScriptFullPath, $iTransitionIconIndex)
		$hLOCMT_Home = _GUICtrlCreateODMenuItem ( "", $hLOCM_Transition, @ScriptFullPath, $iHomeIconIndex)
		$hLOCMT_Up = _GUICtrlCreateODMenuItem ( "  ", $hLOCM_Transition, @ScriptFullPath, $iUpDirIconIndex)
	$hLOCM_Mark = _GUICtrlCreateODMenu ( "", $hLocalOperationsContextMenu, @ScriptFullPath, $iMarkIconIndex)
		$hLOCMM_Set = _GUICtrlCreateODMenuItem ( " ", $hLOCM_Mark, @ScriptFullPath, $iMarkSetIconIndex)
		$hLOCMM_Del = _GUICtrlCreateODMenuItem ( " ", $hLOCM_Mark, @ScriptFullPath, $iMarkDelIconIndex)
	GUICtrlCreateMenuItem ( "", $hLocalOperationsContextMenu )
	$hLOCM_Delete = _GUICtrlCreateODMenuItem ( " ", $hLocalOperationsContextMenu, @ScriptFullPath, $iDeleteIconIndex)
	$hLOCM_Transfer = _GUICtrlCreateODMenuItem ( " ", $hLocalOperationsContextMenu, @ScriptFullPath, $iTransferSendIconIndex)
	$hLOCM_Explorer = _GUICtrlCreateODMenuItem ( "", $hLocalOperationsContextMenu, "explorer.exe", "0")

Local $hRemoteOperationsContextMenu, $hROCM_Transition, $hROCMT_Home, $hROCMT_Up, $hROCM_Mark, $hROCMM_Set, $hROCMM_Del, $hROCM_Delete, $hROCM_Transfer, $hROCM_Explorer, $hROCM_Explorer
$hRemoteOperationsContextMenu = _ContextMenu_Create()
	$hROCM_Transition = _GUICtrlCreateODMenu ( "", $hRemoteOperationsContextMenu, @ScriptFullPath, $iTransitionIconIndex)
		$hROCMT_Home = _GUICtrlCreateODMenuItem ( "", $hROCM_Transition, @ScriptFullPath, $iHomeIconIndex)
		$hROCMT_Up = _GUICtrlCreateODMenuItem ( "  ", $hROCM_Transition, @ScriptFullPath, $iUpDirIconIndex)
	$hROCM_Mark = _GUICtrlCreateODMenu ( "", $hRemoteOperationsContextMenu, @ScriptFullPath, $iMarkIconIndex)
		$hROCMM_Set = _GUICtrlCreateODMenuItem ( " ", $hROCM_Mark, @ScriptFullPath, $iMarkSetIconIndex)
		$hROCMM_Del = _GUICtrlCreateODMenuItem ( " ", $hROCM_Mark, @ScriptFullPath, $iMarkDelIconIndex)
	GUICtrlCreateMenuItem ( "", $hRemoteOperationsContextMenu )
	$hROCM_Delete = _GUICtrlCreateODMenuItem ( " ", $hRemoteOperationsContextMenu, @ScriptFullPath, $iDeleteIconIndex)
	$hROCM_Transfer = _GUICtrlCreateODMenuItem ( " ", $hRemoteOperationsContextMenu, @ScriptFullPath, $iTransferGetIconIndex)
	$hROCM_Explorer = _GUICtrlCreateODMenuItem ( "", $hRemoteOperationsContextMenu, "explorer.exe", "0")


Local $hOptionsContextMenu, $hOCM_Encoding, $hOCME_ANSI, $hOCME_OEM, $hOCME_UTF8, $hOCM_SaveRestoreMarks, $hOCMS_Save, $hOCMS_DelTec, $hOCMS_DelAll, $hOCM_Cfg, $hOCMC_Export, $hOCMC_Cls, $hOCMC_Help, $hOCM_Pause, $hOCM_Exit
$hOptionsContextMenu = _ContextMenu_Create()
	$hOCM_Encoding = _GUICtrlCreateODMenu ( " FTP", $hOptionsContextMenu, @ScriptFullPath, $iEncodingIconIndex)
		$hOCME_ANSI = _GUICtrlCreateODMenuItem ( "ANSI", $hOCM_Encoding, "", 0, 1)
		$hOCME_OEM = _GUICtrlCreateODMenuItem ( "OEM", $hOCM_Encoding, "", 0, 1)
		$hOCME_UTF8 = _GUICtrlCreateODMenuItem ( "UTF8", $hOCM_Encoding, "", 0, 1)
	$hOCM_SaveRestoreMarks = _GUICtrlCreateODMenu ( " /", $hOptionsContextMenu, @ScriptFullPath, $iSaveRestoreMarksIconIndex)
		$hOCMS_Save = _GUICtrlCreateODMenuItem ( "   ", $hOCM_SaveRestoreMarks, @ScriptFullPath, $iPlusIconIndex)
		$hOCMS_DelTec = _GUICtrlCreateODMenuItem ( "    ", $hOCM_SaveRestoreMarks, @ScriptFullPath, $iMinusIconIndex)
		$hOCMS_DelAll = _GUICtrlCreateODMenuItem ( "    ", $hOCM_SaveRestoreMarks, @ScriptFullPath, $iDeleteIconIndex)
	$hOCM_Cfg = _GUICtrlCreateODMenu ( "", $hOptionsContextMenu, @ScriptFullPath, $iConfigIconIndex)
		$hOCMC_Export = _GUICtrlCreateODMenuItem ( "   ", $hOCM_Cfg, @ScriptFullPath, $iExportIconIndex)
		$hOCMC_Cls = _GUICtrlCreateODMenuItem ( " ", $hOCM_Cfg, @ScriptFullPath, $iClsIconIndex)
		$hOCMC_Help = _GUICtrlCreateODMenuItem ( " ", $hOCM_Cfg, @ScriptFullPath, $iHelpIconIndex)
	GUICtrlCreateMenuItem ( "", $hOCM_SaveRestoreMarks )
	$hOCM_Pause = _GUICtrlCreateODMenuItem ( " ", $hOptionsContextMenu, @ScriptFullPath, $iPauseIconIndex)
	$hOCM_Exit = _GUICtrlCreateODMenuItem ( "", $hOptionsContextMenu, @ScriptFullPath, $iExitIconIndex)


_ServerWindow_SetEncodingMenu($hOCME_ANSI, $hOCME_OEM, $hOCME_UTF8)
_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
GUISetState(@SW_SHOW)


GUICtrlSetData ( $hStatusLabel, "  ..." )
FileChangeDir( $sFtpServLocalDir )
	If $sFtpServLocalDir = "\" Then 
	_ServerWindow_LocalPcListing($hLocalContent)
	GUICtrlSetData ( $hLocalDirAddress, "\" )
	Else
	_ServerWindow_LocalDirListing($hLocalContent)
	GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
	EndIF

GUICtrlSetData ( $hStatusLabel, "  ..." )
_FtpChangeDir($sFtpServRemoteDir)
_ServerWindow_RemoteDirListing($hRemoteContent)
GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )

_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
GUICtrlSetData ( $hStatusLabel, "!" )

While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, " ..." )
			_FTP_Close($hFtpServContol)
			GUIDelete ( $hWnd )
			Exit

		Case $hLOCMT_Home
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			FileChangeDir( "\" )
			GUICtrlSetData ( $hLocalDirAddress, "\" )
			_ServerWindow_LocalPcListing($hLocalContent)
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hROCMT_Home
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_FtpChangeDir("/")
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLocalDirSell
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			Local $sDir = FileSelectFolder ( "   ", "", 1+2+4, GUICtrlRead($hLocalDirAddress), $hWnd )
			If NOT @Error Then FileChangeDir( $sDir )
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLocalDirOk
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
				If GUICtrlRead($hLocalDirAddress) <> "" AND GUICtrlRead($hLocalDirAddress) <> "\" Then
				FileChangeDir( GUICtrlRead($hLocalDirAddress) )
				GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
				_ServerWindow_LocalDirListing($hLocalContent)
				Else
				FileChangeDir( "\" )
				GUICtrlSetData ( $hLocalDirAddress, "\" )
				_ServerWindow_LocalPcListing($hLocalContent)
				EndIF
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRemoteDirOk
				If GUICtrlRead($hRemoteDirAddress) <> "" Then
				_FtpChangeDir(GUICtrlRead($hRemoteDirAddress))
				Else
				_FtpChangeDir("/")
				EndIF
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )


		Case $hLCM_OpenDir
			Local $iSellect = GUICtrlRead($hLocalContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
				If $saSellect[3] <> "" Then
				MsgBox(48," FTP ","    !", 0, $hWnd)
				ContinueLoop
				EndIF	
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			FileChangeDir( $saSellect[2] )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRCM_OpenDir
			Local $iSellect = GUICtrlRead($hRemoteContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
				If $saSellect[3] <> "" Then
				MsgBox(48," FTP ","    !", 0, $hWnd)
				ContinueLoop
				EndIF	
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_FtpChangeDir($saSellect[2])
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLCM_UpDir, $hLOCMT_Up
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
				If StringLen ( @WorkingDir ) = 3 AND StringRight ( @WorkingDir, 2 ) = ":\" Then
				GUICtrlSetData ( $hLocalDirAddress, "\" )
				_ServerWindow_LocalPcListing($hLocalContent)
				Else
				FileChangeDir( ".." )
				_ServerWindow_LocalDirListing($hLocalContent)
				GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
				EndIF
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRCM_UpDir, $hROCMT_Up
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_FtpChangeDir("..")
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLCM_Upload
			Local $iSellect = GUICtrlRead($hLocalContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
				If $saSellect[3] = "" Then
				_ServerWindow_UploadFolder($saSellect[2], $hWnd)
				FileChangeDir( ".." )
				_FtpChangeDir("..")
				Else
				_ServerWindow_UploadFile($saSellect[2], $hWnd)
				EndIF
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRCM_Download
			Local $iSellect = GUICtrlRead($hRemoteContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
				If $saSellect[3] = "" Then
				_ServerWindow_DownloadFolder($saSellect[2], $hWnd)
				FileChangeDir( ".." )
				_FtpChangeDir("..")
				Else
				_ServerWindow_DownloadFile($saSellect[2], $hWnd)
				EndIF
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLCM_Update
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRCM_Update
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLCM_Delete
			Local $iSellect = GUICtrlRead($hLocalContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_DeleteLocalFile($saSellect[2], $hWnd)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRCM_Delete
			Local $iSellect = GUICtrlRead($hRemoteContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			If $saSellect[3] <> "" Then
			_ServerWindow_DeleteRemoteFile($saSellect[2], $hWnd)
			Else
			_ServerWindow_DeleteRemoteDir($saSellect[2], $hWnd)
			EndIF
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLCM_Rename
			Local $iSellect = GUICtrlRead($hLocalContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_RenameLocal($saSellect[2], $hWnd)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRCM_Rename
			Local $iSellect = GUICtrlRead($hRemoteContent)
			Local $saSellect = GUICtrlRead($iSellect)
				If $saSellect = "0" OR $saSellect = "" Then
				MsgBox(48," FTP ","  !", 0, $hWnd)
				ContinueLoop
				EndIF
			Local $iExist = 0
			$saSellect = StringSplit ( $saSellect, "|" )
				If @Error OR 	$saSellect[0] < 3 Then
				MsgBox(48," FTP "," !", 0, $hWnd)
				ContinueLoop
				EndIF
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_RenameRemote($saSellect[2], $hWnd)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLCM_NewDir
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_CreateLocalDir($hWnd)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hRCM_NewDir
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_CreateRemoteDir($hWnd)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLocalOperations
			_ContextMenu_Show($hWnd, $hLocalOperations, $hLocalOperationsContextMenu)


		Case $hLOCMM_Set
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			For $i = 1 To $aLocalDirListingControls[0]
			GUICtrlSetState ( $aLocalDirListingControls[$i], $GUI_CHECKED )
			Next
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)

		Case $hLOCMM_Del
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			For $i = 1 To $aLocalDirListingControls[0]
			GUICtrlSetState ( $aLocalDirListingControls[$i], $GUI_UNCHECKED )
			Next
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)

		Case $hRemoteOperations
			_ContextMenu_Show($hWnd, $hRemoteOperations, $hRemoteOperationsContextMenu)

		Case $hROCMM_Set
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			For $i = 1 To $aRemoteDirListingControls[0]
			GUICtrlSetState ( $aRemoteDirListingControls[$i], $GUI_CHECKED )
			Next
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)

		Case $hROCMM_Del
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			For $i = 1 To $aRemoteDirListingControls[0]
			GUICtrlSetState ( $aRemoteDirListingControls[$i], $GUI_UNCHECKED )
			Next
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)

		Case $hLOCM_Delete
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_DeleteLocalChecked($hWnd, $hStatusLabel)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hROCM_Delete
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_DeleteRemoteChecked($hWnd, $hStatusLabel)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hLOCM_Transfer, $hLocalSend
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_SendChecked($hWnd, $hStatusLabel)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hROCM_Transfer, $hRemoteGet
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_GetChecked($hWnd, $hStatusLabel)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_LocalDirListing($hLocalContent)
			GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hFtpConfig
				If $iConnPause = 1 Then
				GUICtrlSetState ( $hFtpConfig, $GUI_DISABLE )
				GUICtrlSetData ( $hStatusLabel, "..." )
				$hFtpServContol = _FTP_Open('MyFTP Control')
				$hFtpServSession = _FTP_Connect($hFtpServContol, $aConnServData[0], $aConnServData[1], $aConnServData[2], $aConnServData[3], $aConnServData[4])
					If @Error Then
					MsgBox(16," FTP ","   . : "&@Error&"", 0, $hWnd)
					ContinueLoop
					EndIF
				_FtpChangeDir(GUICtrlRead($hRemoteDirAddress))
				FileChangeDir(GUICtrlRead($hLocalDirAddress))
				GUICtrlSetData ( $hStatusLabel, "  ..." )
				_ServerWindow_LocalDirListing($hLocalContent)
				GUICtrlSetData ( $hLocalDirAddress, @WorkingDir )
				GUICtrlSetData ( $hStatusLabel, "  ..." )
				_ServerWindow_RemoteDirListing($hRemoteContent)
				GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
				_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
				GUICtrlSetData ( $hFtpConfig, "" )
				GUICtrlSetData ( $hStatusLabel, "!" )
				$iConnPause = 0
				ContinueLoop
				EndIF
			_ContextMenu_Show($hWnd, $hFtpConfig, $hOptionsContextMenu)

		Case $hOCME_ANSI
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_ActEncodingMenu("ANSI", $hOCME_ANSI, $hOCME_OEM, $hOCME_UTF8)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hOCME_OEM
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_ActEncodingMenu("OEM", $hOCME_ANSI, $hOCME_OEM, $hOCME_UTF8)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )


		Case $hOCME_UTF8
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_ActEncodingMenu("UTF8", $hOCME_ANSI, $hOCME_OEM, $hOCME_UTF8)
			GUICtrlSetData ( $hStatusLabel, "  ..." )
			_ServerWindow_RemoteDirListing($hRemoteContent)
			GUICtrlSetData ( $hRemoteDirAddress, _FtpWorkDir() )
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, "!" )

		Case $hOCMS_Save
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			_ServerWindow_MarksMenu_Save()
			_ServerWindow_ControlsSetState($GUI_ENABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)

		Case $hOCMS_DelTec
			RegDelete ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt\Marks\"&$sFtpServTitleHex&"\L\"&""&StringTrimLeft(_StrToHex(@WorkingDir), 2) )
			RegDelete ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt\Marks\"&$sFtpServTitleHex&"\R\"&""&StringTrimLeft(_StrToHex(_FtpWorkDir()), 2) )

		Case $hOCMS_DelAll
			RegDelete ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt\Marks\"&$sFtpServTitleHex )

		Case $hOCM_Exit
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, " ..." )
			_FTP_Close($hFtpServContol)
			GUIDelete ( $hWnd )
			_InWindow()
			Return 0

		Case $hOCM_Pause
			If $iConnPause = 0 Then
			_ServerWindow_ControlsSetState($GUI_DISABLE, $hFtpConfig,$hLocalDirAddress,$hLocalDirOk,$hLocalDirSell,$hLocalContent,$hLocalSend,$hLocalOperations,$hRemoteDirAddress,$hRemoteDirOk,$hRemoteDirSell,$hRemoteContent,$hRemoteOperations,$hRemoteGet)
			GUICtrlSetData ( $hStatusLabel, " ..." )
			_FTP_Close($hFtpServContol)
				If $aRemoteDirListingControls[0] > 0 Then
				For $i = 1 To $aRemoteDirListingControls[0]
				GUICtrlDelete ( $aRemoteDirListingControls[$i] )
				Next
				EndIF
				ReDim $aRemoteDirListingControls[1]
				$aRemoteDirListingControls[0] = 0
				If $aLocalDirListingControls[0] > 0 Then
				For $i = 1 To $aLocalDirListingControls[0]
				GUICtrlDelete ( $aLocalDirListingControls[$i] )
				Next
				EndIF
				ReDim $aLocalDirListingControls[1]
				$aLocalDirListingControls[0] = 0
			GUICtrlSetData ( $hStatusLabel, "..." )
			GUICtrlSetData ( $hFtpConfig, "" )
			GUICtrlSetState ( $hFtpConfig, $GUI_ENABLE )
			GUICtrlSetState ( $hFtpConfig, $GUI_FOCUS )
			$iConnPause = 1
			ContinueLoop
			EndIF

		Case $hOCMC_Export
			Local $sFile = FileSaveDialog ( " ...", "", "  (*.reg)", 18, "sFTPc.reg" )
				If @Error Then ContinueLoop
			If StringRight($sFile, 4 ) <> ".reg" Then $sFile &= ".reg"
				If RunWait('regedit.exe /e "'&$sFile&'" "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt"') Then 
				MsgBox(48," FTP ","  ", 0, $hWnd)
				Else
				MsgBox(64," FTP "," ", 0, $hWnd)
				EndIF

		Case $hOCMC_Cls
			If MsgBox(49," FTP ","     ,  ,   ....   !", 0, $hWnd) = 2 Then ContinueLoop
			_FTP_Close($hFtpServContol)
			GUIDelete ( $hWnd )
			RegDelete ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt" )
			Exit

		Case $hOCMC_Help
			MsgBox(64," FTP ","    ,    ""HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt""", 0, $hWnd)

		Case $hLOCM_Explorer
			Run('explorer.exe "'&@WorkingDir&'"')

		Case $hROCM_Explorer
			Local $sPuth = "ftp://"
			If $aConnServData[1] <> "" OR $aConnServData[2] <> "" Then $sPuth &= $aConnServData[1]&":"&$aConnServData[2]&"@"
			$sPuth &= $aConnServData[0]
			If $aConnServData[4] <> 21 Then $sPuth &= ":"&$aConnServData[4]
			$sPuth &= _FtpWorkDir()
			Run('explorer.exe "'&$sPuth&'"')
	EndSwitch
WEnd
EndFunc
