#include <FTPEx.au3>

#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <GUIListBox.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>



Func _InWindow_FtpGetDirs($hGui, $sServer, $sUserName, $sPassword, $sPassive, $sPort, $sDefDir)
Local $hWnd, $hWorkDir, $hDirsList, $hSellect, $hLabel
$hWnd = GUICreate(" FTP  -   ", 328, 265, -1, -1, -1, -1, $hGui)
	GUISetIcon ( @ScriptFullPath, 0 )

GUICtrlCreateLabel(": ", 6, 6, 55, 17)
$hWorkDir = GUICtrlCreateInput("", 65, 4, 260, 21, BitOR($GUI_SS_DEFAULT_INPUT,$ES_READONLY))
$hDirsList = GUICtrlCreateList("", 0, 29, 326, 188)

$hSellect = GUICtrlCreateButton("", 251, 220, 75, 20)
$hLabel = GUICtrlCreateLabel("  ...", 0, 242, 324, 17)

GUICtrlSetState($hWorkDir-1, $GUI_DISABLE)
GUICtrlSetState($hWorkDir, $GUI_DISABLE)
GUICtrlSetState($hDirsList, $GUI_DISABLE)
GUICtrlSetState($hSellect, $GUI_DISABLE)

GUISetState(@SW_SHOW)
Local $hFtpOpen, $hFtpConn
$hFtpOpen = _FTP_Open('MyFTP Control')
	If @Error Then
	MsgBox(16," FTP ","   ", 0, $hWnd)
	GUIDelete ( $hWnd )
	Return SetError(2,0,"")
	EndIF

$hFtpConn = _FTP_Connect($hFtpOpen, $sServer, $sUserName, $sPassword, $sPassive, $sPort)
	If @Error Then
	MsgBox(16," FTP ","    ", 0, $hWnd)
	GUIDelete ( $hWnd )
	Return SetError(3,0,"")
	EndIF


If $sDefDir = "" Then $sDefDir = "/"
_FTP_DirSetCurrent($hFtpConn, $sDefDir)
_InWindow_FtpGetDirs_AddToList($hFtpConn, $hDirsList, $hLabel)
GUICtrlSetData ( $hWorkDir, _FTP_DirGetCurrent($hFtpConn) )
GUICtrlSetState($hWorkDir-1, $GUI_ENABLE)
GUICtrlSetState($hWorkDir, $GUI_ENABLE)
GUICtrlSetState($hDirsList, $GUI_ENABLE)
GUICtrlSetState($hSellect, $GUI_ENABLE)


While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			GUICtrlSetState($hWorkDir-1, $GUI_DISABLE)
			GUICtrlSetState($hWorkDir, $GUI_DISABLE)
			GUICtrlSetState($hDirsList, $GUI_DISABLE)
			GUICtrlSetState($hSellect, $GUI_DISABLE)
			GUICtrlSetData ( $hLabel, " ..." )
			_FTP_Close($hFtpOpen)
			GUIDelete ( $hWnd )
			Return SetError(1,0,"")

		Case $hSellect
			Local $sDir = GUICtrlRead($hDirsList)
				If $sDir = "" OR $sDir = " " Then
				MsgBox(48," FTP ","    <*  *>!", 0, $hWnd)
				ContinueLoop
				EndIF
			GUICtrlSetState($hWorkDir-1, $GUI_DISABLE)
			GUICtrlSetState($hWorkDir, $GUI_DISABLE)
			GUICtrlSetState($hDirsList, $GUI_DISABLE)
			GUICtrlSetState($hSellect, $GUI_DISABLE)
			GUICtrlSetData ( $hLabel, " ..." )
				If $sDir = "<*    *>" Then
				_FTP_DirSetCurrent($hFtpConn, "..")
				_InWindow_FtpGetDirs_AddToList($hFtpConn, $hDirsList, $hLabel)
				ElseIF $sDir = "<*    *>" Then
				$sDir = _FTP_DirGetCurrent($hFtpConn)
				GUICtrlSetData ( $hLabel, " ..." )
				GUIDelete ( $hWnd )
				Return SetError(0,0,$sDir)
				Else
				_FTP_DirSetCurrent($hFtpConn, $sDir)
				_InWindow_FtpGetDirs_AddToList($hFtpConn, $hDirsList, $hLabel)
				EndIF
			GUICtrlSetData ( $hWorkDir, _FTP_DirGetCurrent($hFtpConn) )
			GUICtrlSetState($hWorkDir-1, $GUI_ENABLE)
			GUICtrlSetState($hWorkDir, $GUI_ENABLE)
			GUICtrlSetState($hDirsList, $GUI_ENABLE)
			GUICtrlSetState($hSellect, $GUI_ENABLE)
	EndSwitch
WEnd
EndFunc






Func _InWindow_FtpGetDirs_AddToList($hFtpConn, $hDirsList, $hLabel)
Local $h_Handle, $aFile
GUICtrlSetData ( $hDirsList, "" )
If _FTP_DirGetCurrent($hFtpConn) <> "/" Then GUICtrlSetData ( $hDirsList, "<*    *>" )
GUICtrlSetData ( $hDirsList, "<*    *>" )
GUICtrlSetData ( $hDirsList, "<___________________________________________________>" )

$aFile = _FTP_FindFileFirst($hFtpConn, "", $h_Handle)
If IsArray($aFile) AND UBound($aFile) > 9 AND $aFile[10] <> ".." AND $aFile[10] <> "." AND $aFile[10] <> "" AND $aFile[1] = 16 Then GUICtrlSetData ( $hDirsList, $aFile[10] )

GUICtrlSetData ( $hLabel, " ..." )
	While 1
	$aFile = _FTP_FindFileNext($h_Handle)
	If @Error Then ExitLoop
	If IsArray($aFile) AND UBound($aFile) > 9 AND $aFile[10] <> ".." AND $aFile[10] <> "." AND $aFile[10] <> "" AND $aFile[1] = 16 Then GUICtrlSetData ( $hDirsList, $aFile[10] )
	Wend

_FTP_FindFileClose($h_Handle)
GUICtrlSetData ( $hLabel, "!" )
EndFunc












