#NoTrayIcon

$Title="Mini - Clock"

;==================================================;
;->        <-;
;==================================================;
	DllCall("kernel32.dll","int","CreateMutex","int",0,"long",1,"str",StringReplace($Title,"\",""))
	$Check_Mutex=DllCall("kernel32.dll","int","GetLastError")
	If $Check_Mutex[0]=183 Then Exit
		
;============================================================;
;->         <-;
;============================================================;
	$Reg_Key="HKEY_CURRENT_USER\Software\MiniApplications\"&$Title
	$GUI_Transparency=RegRead($Reg_Key,"GUI_Transparency")
		If @error Or $GUI_Transparency>99 Or $GUI_Transparency<0 Then $GUI_Transparency=20
	$GUI_Position=StringSplit(RegRead($Reg_Key,"GUI_Position"),",")
		If $GUI_Position[0]<>2 Then $GUI_Position=StringSplit(@DesktopWidth/2-90&","&0,",")
	$Background_Color=RegRead($Reg_Key,"Background_Color")
		If @error Then $Background_Color=0x0080C0
	$Line_Color=RegRead($Reg_Key,"Line_Color")
		If @error Then $Line_Color=0x00FFFF
	$Font_Color=RegRead($Reg_Key,"Font_Color")
		If @error Then $Font_Color = 0xFFFFFF
	$Control_Position=StringSplit("64,67,3",",")
		If RegRead($Reg_Key,"Date_Top")>0 and not @error Then $Control_Position=StringSplit("23,3,26",",")
	$Timer_Options=StringSplit(RegRead($Reg_Key,"Timer_Options"),",")
		If $Timer_Options[0]<>4 Then $Timer_Options=StringSplit("0,1,1,0",",")
	$Audio_Alarm=0
		If RegRead($Reg_Key,"Audio_Alarm")>0 and not @error Then $Audio_Alarm=1
	$GUI_On_Top=0
		If RegRead($Reg_Key,"GUI_On_Top")>0 and not @error Then $GUI_On_Top=1
	$GUI_Bolt=0
		If RegRead($Reg_Key,"GUI_Bolt")>0 and not @error Then $GUI_Bolt=1
	$Micro_Clock=0
		If RegRead($Reg_Key,"Micro_Clock")>0 and not @error Then $Micro_Clock=1
	Local $Timer_Info=StringSplit("",""),$Date_Previous,$Clock_Previous,$Timer_Previous,$Show_Hide_Controls_Previous=0,$Message
	$Year_Month=StringSplit(",,,,,,,,,,,",",")
	$Week_Day=StringSplit(",,,,,,",",")
	$Timer_Messages = StringSplit("     ,     ,  ,   ",",")

;==================;
;->   <-;
;==================;
	$GUI=GUICreate(@ScriptFullPath,180,90,-1,-1,0x80880000,0x00000080)
	GUISetBkColor($Background_Color)
	GUISetCursor(2,1)
	WinMove($GUI,"",$GUI_Position[1]-1,$GUI_Position[2]-1,default,default)
	WinSetTrans($GUI,"",255-((255/100)*$GUI_Transparency))
	WinSetOnTop($GUI,"",$GUI_On_Top)
	
;==================================;
;->       <-;
;==================================;
	$Line_1=GuiCtrlCreateGraphic(0,0,180,3)
	$Line_2=GuiCtrlCreateGraphic(0,87,180,3)
	$Line_3=GuiCtrlCreateGraphic(0,0,3,90)
	$Line_4=GuiCtrlCreateGraphic(177,0,3,90)
	$Line_5=GuiCtrlCreateGraphic(0,$Control_Position[1],180,3)
	
;=================================================================================;
;->     ,      <-;
;=================================================================================;
	$Indicator_Date=GUICtrlCreateLabel($Title,3,$Control_Position[2],174,20,0x01+0x0200)
	$Indicator_Clock=GUICtrlCreateLabel(@HOUR&":"&@MIN,3,$Control_Position[3],174,61,0x01+0x0200)
	GUICtrlSetFont($Indicator_Date,9,700,0,"Tahoma")
	GUICtrlSetFont($Indicator_Clock,40,400,0,"DigifaceWide")
	GUICtrlSetColor($Indicator_Date,$Font_Color)
	GUICtrlSetColor($Indicator_Clock,$Font_Color)
	
;========================================================================;
;->     ,    <-;
;========================================================================;
	$List_Actions=GUICtrlCreateCombo("",5,5,170,default,0x0003+0x00200000)
	$List_Manners=GUICtrlCreateCombo("",5,26,60,default,0x0003+0x00200000)
	$List_Hours=GUICtrlCreateCombo("",65,26,48,default,0x0003+0x00200000)
	$List_Minutes=GUICtrlCreateCombo("",113,26,62,default,0x0003+0x00200000)
	$Button_On=GUICtrlCreateButton("",5,54,85,31)
	$Button_Off=GUICtrlCreateButton("",90,54,85,31)
	GUICtrlSetData($List_Actions,"  |  | |  ")
	GUICtrlSetData($List_Manners,":|:")
	GUICtrlSetData($List_Hours,"0 .|1 .|2 .|3 .|4 .|5 .|6 .|7 .|8 .|9 .|10 .|11 .|12 .|13 .|14 .|15 .|16 .|17 .|18 .|19 .|20 .|21 .|22 .|23 .")
	GUICtrlSetData($List_Minutes,"0 .|1 .|2 .|3 .|4 .|5 .|6 .|7 .|8 .|9 .|10 .|11 .|12 .|13 .|14 .|15 .|16 .|17 .|18 .|19 .|20 .|21 .|22 .|23 .|24 .|25 .|26 .|27 .|28 .|29 .|30 .|31 .|32 .|33 .|34 .|35 .|36 .|37 .|38 .|39 .|40 .|41 .|42 .|43 .|44 .|45 .|46 .|47 .|48 .|49 .|50 .|51 .|52 .|53 .|54 .|55 .|56 .|57 .|58 .|59 .")
	GUICtrlSendMsg($List_Actions,0x14E,$Timer_Options[1]-0,0)
	GUICtrlSendMsg($List_Manners,0x14E,$Timer_Options[2]-0,0)
	GUICtrlSendMsg($List_Hours,0x14E,$Timer_Options[3]-0,0)
	GUICtrlSendMsg($List_Minutes,0x14E,$Timer_Options[4]-0,0)
	GUICtrlSendMsg($List_Hours,0x1701,9,0)
	GUICtrlSendMsg($List_Minutes,0x1701,9,0)
	GUICtrlSetTip($List_Actions,"   .")
	GUICtrlSetTip($List_Manners,"   .")
	GUICtrlSetTip($List_Hours,"   .")
	GUICtrlSetTip($List_Minutes,"   .")
	GUICtrlSetCursor($List_Actions,0)
	GUICtrlSetCursor($List_Manners,0)
	GUICtrlSetCursor($List_Hours,0)
	GUICtrlSetCursor($List_Minutes,0)
	GUICtrlSetCursor($Button_On,0)
	GUICtrlSetCursor($Button_Off,0)

;====================;
;->   <-;
;====================;
	$Indicator_Timer=GUICtrlCreateLabel("",5,20,170,50,0x01)
	GUICtrlSetFont($Indicator_Timer,9,400,0,"Arial")
	GUICtrlSetColor($Indicator_Timer,$Font_Color)
	
;===============================;
;->    <-;
;===============================;
	$Frame=GUICtrlCreateLabel("",-2,-2,184,94,0x07)
	$Context_Menu=GUICtrlCreateContextMenu ($Frame)
	$On_Off_Timer=GUICtrlCreateMenuItem(". ",$Context_Menu)
	GUICtrlSetState($On_Off_Timer,512)
	$Computer=GUICtrlCreateMenu("",$Context_Menu)
	GUICtrlCreateMenuitem("",$Context_Menu)
	$Options=GUICtrlCreateMenu("",$Context_Menu)
	GUICtrlCreateMenuitem("",$Context_Menu)
	$Hide=GUICtrlCreateMenuItem("",$Context_Menu)
	$Quit=GUICtrlCreateMenuItem("",$Context_Menu)
	
;=========================================================;
;->       "" <-;
;=========================================================;
	$Computer_Sleep=GUICtrlCreateMenuItem(" ",$Computer)
	GUICtrlSetState($Computer_Sleep,512)
	$Computer_Wait=GUICtrlCreateMenuItem(" ",$Computer)
	GUICtrlCreateMenuitem("",$Computer)
	$Computer_Off=GUICtrlCreateMenuItem("",$Computer)
	$Computer_Reboot=GUICtrlCreateMenuItem("",$Computer)
	GUICtrlCreateMenuitem("",$Computer)
	$Computer_Quit=GUICtrlCreateMenuItem("",$Computer)
	
;=========================================================;
;->       "" <-;
;=========================================================;
	$Options_Bolt_Window=GUICtrlCreateMenuItem("",$Options)
	$Options_Auto_Start=GUICtrlCreateMenuItem("",$Options)
	$Options_On_Top=GUICtrlCreateMenuItem(" ",$Options)
	$Options_Micro_Clock=GUICtrlCreateMenuItem(" ",$Options)
	$Options_Audio_Alarm=GUICtrlCreateMenuItem(". ",$Options)
	GUICtrlCreateMenuitem("",$Options)
	$Options_Date_Top=GUICtrlCreateMenuItem(" ",$Options)
	$Options_Transparency=GUICtrlCreateMenu("",$Options)
	$Options_Color_Frame=GUICtrlCreateMenuItem (" ",$Options)
	$Options_Color_Background=GUICtrlCreateMenuItem (" ",$Options)
	$Options_Color_Font=GUICtrlCreateMenuItem(" ",$Options)
	GUICtrlCreateMenuitem("",$Options)
	$Options_Date_Time=GUICtrlCreateMenuItem("  ",$Options)
	GUICtrlCreateMenuitem("",$Options)
	$Options_Delete=GUICtrlCreateMenuItem("",$Options)
	If $GUI_Bolt>0 Then GUICtrlSetState($Options_Bolt_Window,1)
	If RegRead("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run",$Title)=@ScriptFullPath Then GUICtrlSetState($Options_Auto_Start,1)
	If $GUI_On_Top>0 Then GUICtrlSetState($Options_On_Top,1)
	If $Micro_Clock>0 Then GUICtrlSetState($Options_Micro_Clock,1)
	If $Audio_Alarm>0 Then GUICtrlSetState($Options_Audio_Alarm,1)
	If $Control_Position[1]=23 Then GUICtrlSetState($Options_Date_Top,1)
	
;============================================================;
;->       "" <-;
;============================================================;
	$Transparency_0=GUICtrlCreateMenuItem("0 %",$Options_Transparency)
	GUICtrlCreateMenuitem("",$Options_Transparency)
	$Transparency_10=GUICtrlCreateMenuItem("10 %",$Options_Transparency)
	$Transparency_20=GUICtrlCreateMenuItem("20 %",$Options_Transparency)
	$Transparency_30=GUICtrlCreateMenuItem("30 %",$Options_Transparency)
	$Transparency_40=GUICtrlCreateMenuItem("40 %",$Options_Transparency)
	$Transparency_50=GUICtrlCreateMenuItem("50 %",$Options_Transparency)
	GUICtrlCreateMenuitem("",$Options_Transparency)
	$Transparency_60=GUICtrlCreateMenuItem("60 %",$Options_Transparency)
	$Transparency_70=GUICtrlCreateMenuItem("70 %",$Options_Transparency)
	$Transparency_80=GUICtrlCreateMenuItem("80 %",$Options_Transparency)
	$Transparency_90=GUICtrlCreateMenuItem("90 %",$Options_Transparency)
	$Transparency_99=GUICtrlCreateMenuItem("99 %",$Options_Transparency)
	GUICtrlSetState(Eval("Transparency_"&$GUI_Transparency),1)
	
;===============================;
;->    <-;
;===============================;
	Update_Line_Color($Line_Color)
	Show_Hide_Controls(1)
	Observation_And_Update()
	AdlibEnable("Observation_And_Update",250)
	GUISetState(@SW_SHOW)	
	
;=================================;
;->     <-;
;=================================;
	While 1
	$msg=GUIGetMsg()
	Select
	;======================================;
	;->       <-;
	;======================================;
		Case $msg=-7
			$CursorInfo = GUIGetCursorInfo($GUI)
			If $GUI_Bolt<=0 And MouseGetCursor()<>0 And MouseGetCursor()<>9 And $CursorInfo[4] Then
				$New_GUI_Position=GUI_Move($GUI)
				RegWrite($Reg_Key,"GUI_Position","REG_SZ",$New_GUI_Position[1]&","&$New_GUI_Position[2])
			EndIf
	
	;======================================;
	;->     ". " <-;
	;======================================;
		Case $msg=$On_Off_Timer
			If $Timer_Info[0]>0 Then
				Off_Timer()
			Else
				Show_Hide_Controls(2)
			EndIf
	
	;===================================================;
	;->   " "   "" <-;
	;===================================================;
		Case $msg=$Computer_Sleep
			Off_Timer()
			Shutdown(64)
			
	;===================================================;
	;->   " "   "" <-;
	;===================================================;
		Case $msg=$Computer_Wait
			Off_Timer()
			Shutdown(32)
	
	;=================================================;
	;->   ""   "" <-;
	;=================================================;
		Case $msg=$Computer_Off
			Shutdown(13)
			Exit
			
	;===================================================;
	;->   ""   "" <-;
	;===================================================;
		Case $msg=$Computer_Reboot
			Shutdown(6)
			Exit
			
	;============================================;
	;->   ""   "" <-;
	;============================================;
		Case $msg=$Computer_Quit
			Shutdown(4)
			Exit
	
	;================================================;
	;->   ""   "" <-;
	;================================================;
		Case $msg=$Options_Bolt_Window
			If $GUI_Bolt>0 Then
				RegDelete($Reg_Key,"GUI_Bolt") 
				GUICtrlSetState($Options_Bolt_Window,4)
				$GUI_Bolt=0
			Else
				RegWrite($Reg_Key,"GUI_Bolt","REG_SZ","1")
				GUICtrlSetState($Options_Bolt_Window,1)
				$GUI_Bolt=1
			EndIf
	
	;================================================;
	;->   ""   "" <-;
	;================================================;
		Case $msg=$Options_Auto_Start
			If RegRead("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run",$Title)=@ScriptFullPath Then
				RegDelete("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run",$Title)
				GUICtrlSetState($Options_Auto_Start,4)
			Else
				RegWrite("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run",$Title,"REG_SZ",@ScriptFullPath)
				GUICtrlSetState($Options_Auto_Start,1)
			EndIf
	
	;=================================================;
	;->   " "   "" <-;
	;=================================================;
		Case $msg=$Options_Micro_Clock
			If $Micro_Clock>0 Then
				RegDelete($Reg_Key,"Micro_Clock")
				GUICtrlSetState($Options_Micro_Clock,4)
				$Micro_Clock=0
				ToolTip("")
			Else
				RegWrite($Reg_Key,"Micro_Clock","REG_SZ","1")
				GUICtrlSetState($Options_Micro_Clock,1)
				$Micro_Clock=1
			EndIf
			
	;=================================================;
	;->   ". "   "" <-;
	;=================================================;
		Case $msg=$Options_Audio_Alarm
			If $Audio_Alarm>0 Then
				RegDelete($Reg_Key,"Audio_Alarm")
				GUICtrlSetState($Options_Audio_Alarm,4)
				$Audio_Alarm=0
			Else
				RegWrite($Reg_Key,"Audio_Alarm","REG_SZ","1")
				GUICtrlSetState($Options_Audio_Alarm,1)
				$Audio_Alarm=1
			EndIf

	;===================================================;
	;->   " "   "" <-;
	;===================================================;
		Case $msg=$Options_On_Top
			If $GUI_On_Top>0 Then
				RegDelete($Reg_Key,"GUI_On_Top")
				GUICtrlSetState($Options_On_Top,4)
				WinSetOnTop($GUI,"",0)
				$GUI_On_Top=0
			Else
				RegWrite($Reg_Key,"GUI_On_Top","REG_SZ","1")
				GUICtrlSetState($Options_On_Top,1)
				WinSetOnTop($GUI,"",1)
				$GUI_On_Top=1
			EndIf
			
	;==================================================;
	;->   " "   "" <-;
	;==================================================;
		Case $msg=$Options_Date_Top
			If $Control_Position[1]=23 Then
				RegDelete($Reg_Key,"Date_Top")
				GUICtrlSetState($Options_Date_Top,4)
				$Control_Position=StringSplit("64,67,3",",")
			Else
				RegWrite($Reg_Key,"Date_Top","REG_SZ","1")
				GUICtrlSetState($Options_Date_Top,1)
				$Control_Position=StringSplit("23,3,26",",")
			EndIf
			GUICtrlSetPos($Line_5,0,$Control_Position[1],default,default)
			GUICtrlSetPos($Indicator_Date,3,$Control_Position[2],default,default)
			GUICtrlSetPos($Indicator_Clock,3,$Control_Position[3],default,default)
			
	;=================================================;
	;->       "" <-;
	;=================================================;
		Case $msg>=$Transparency_0 and $msg<=$Transparency_99
			For $1=$Transparency_0 to $Transparency_99 Step +1
				GUICtrlSetState($1,4)
			Next
			$1=StringSplit("0,-,10,20,30,40,50,-,60,70,80,90,99",",")
			GUICtrlSetState(Eval("Transparency_"&$1[$msg-$Transparency_0+1]),1)
			WinSetTrans($GUI,"",255-((255/100)*$1[$msg-$Transparency_0+1]))
			RegWrite($Reg_Key,"GUI_Transparency","REG_SZ",$1[$msg-$Transparency_0+1])
	
	;=================================================;
	;->   " "   "" <-;
	;=================================================;
		Case $msg=$Options_Color_Frame
			Lock_GUI(1)
			$1=Select_Color()
			If $1>0 Then
				Update_Line_Color($1)
				RegWrite($Reg_Key,"Line_Color","REG_SZ",$1)
			EndIf
			Lock_GUI(0)
	
	;================================================;
	;->   " "   "" <-;
	;================================================;
		Case $msg=$Options_Color_Background
			Lock_GUI(1)
			$1=Select_Color()
			If $1>0 Then
				GUISetBkColor($1)
				RegWrite($Reg_Key,"Background_Color","REG_SZ",$1)
			EndIf
			Lock_GUI(0)
			
	;==================================================;
	;->   " "   "" <-;
	;==================================================;
		Case $msg=$Options_Color_Font
			Lock_GUI(1)
			$1=Select_Color()
			If $1>0 Then
				GUICtrlSetColor($Indicator_Date,$1)
				GUICtrlSetColor($Indicator_Clock,$1)
				GUICtrlSetColor($Indicator_Timer,$1)
				RegWrite($Reg_Key,"Font_Color","REG_SZ",$1)
			EndIf
			Lock_GUI(0)
			
	;===================================================;
	;->   "  "   "" <-;
	;===================================================;
		Case $msg=$Options_Date_Time
			Run(@SystemDir&"\rundll32.exe "&@SystemDir&"\shell32.dll,Control_RunDLL """&@SystemDir&"\timedate.cpl"",  ")
			
	;==============================================;
	;->   ""   "" <-;
	;==============================================;
		Case $msg=$Options_Delete
			Lock_GUI(1)
			If MsgBox(262144+32+4,": "&$Title,"   """&$Title&""" ?")=6 Then
				GUISetState(@SW_HIDE)
				RegDelete("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run",$Title)
				RegDelete($Reg_Key)
				MsgBox(262144+64,": "&$Title,"   ,    """&$Title&""""&@CR&@CR&" : """&@ScriptFullPath&""""&@CR&@CR&"   , , .       !")
				Exit
			EndIf
			Lock_GUI(0)
	
	;===================================;
	;->     "" <-;
	;===================================;
		Case $msg=$Hide
			GUISetState(@SW_HIDE)
			Opt("TrayIconHide",0)
			Opt("TrayMenuMode",1)

	;================================;
	;->     "" <-;
	;================================;
		Case $msg=$Quit
			Exit
	
	;============================;
	;->   "" <-;
	;============================;
		Case $msg=$Button_Off
			Show_Hide_Controls(1)
			
	;===============================;
	;->   "" <-;
	;===============================;
		Case $msg=$Button_On
			Lock_GUI(1)
			$1=GUICtrlSendMsg($List_Hours,0x147,0,0)
			$2=GUICtrlSendMsg($List_Minutes,0x147,0,0)
			$3=GUICtrlSendMsg($List_Manners,0x147,0,0)
			$4=GUICtrlSendMsg($List_Actions,0x147,0,0)
			RegWrite($Reg_Key,"Timer_Options","REG_SZ",$4&","&$3&","&$1&","&$2)
			If $3>0 Then
				$Timer_Info=(($1*60)+$2)*60
				If $Timer_Info=0 Then $Timer_Info=86400
			Else
				If $1 = @HOUR and $2 = @MIN Then
					$1 = 23
					$2 = 59
				ElseIf $1<@HOUR and $2=@MIN Then
					$1=$1+(23-@HOUR)
					$2=59
				ElseIf $1>@HOUR and $2=@MIN Then
					$1=$1-@HOUR-1
					$2=59
				ElseIf $1=@HOUR and $2>@MIN Then
					$1=0
					$2=$2-@MIN-1
				ElseIf $1=@HOUR and $2<@MIN Then
					$1=23
					$2=$2+(59-@MIN)
				ElseIf $1<@HOUR and $2>@MIN Then
					$1=$1+(24-@HOUR)
					$2=$2-@MIN-1
				ElseIf $1>@HOUR and $2<@MIN Then
					$1=$1-@HOUR-1
					$2=$2+(59-@MIN)
				ElseIf $1<@HOUR and $2<@MIN Then
					$1=$1+(23-@HOUR)
					$2=$2+(59-@MIN)
				ElseIf $1>@HOUR and $2>@MIN Then
					$1=$1-@HOUR
					$2=$2-@MIN-1
				EndIf
				$Timer_Info = ((($1*60)+$2)*60)+(59-@SEC)
			EndIf
			$Timer_Info=StringSplit($Timer_Info&","&TimerInit()&","&$4&","&$Timer_Messages[$4+1],",")
			GUICtrlSetData($On_Off_Timer,". ")
			Show_Hide_Controls(1)
			Lock_GUI(0)
		
	;=============================;
	;->      <-;
	;=============================;
		Case $msg=0
		;==========================;
		;->     <-;
		;==========================;
			$msg=TrayGetMsg()
			If $msg=-7 Then
				Opt("TrayIconHide",1)
				GUISetState(@SW_SHOW)
			EndIf
		;============;
		;->  <-;
		;============;
			If $Micro_Clock>0 Then ToolTip(GUICtrlRead($Indicator_Clock),3,3)
	EndSelect
	WEnd
	
Func Update_Line_Color($1)
	GUICtrlSetBkColor($Line_1,$1)
	GUICtrlSetBkColor($Line_2,$1)
	GUICtrlSetBkColor($Line_3,$1)
	GUICtrlSetBkColor($Line_4,$1)
	GUICtrlSetBkColor($Line_5,$1)
EndFunc

Func Show_Hide_Controls($1)
	If $Show_Hide_Controls_Previous=$1 Then Return
	If $1=1 Then
		For $2 = $List_Actions to $Button_Off Step +1
			GUICtrlSetState($2,32)
		Next 
		GUICtrlSetState($Indicator_Timer,32)
		GUICtrlSetState($Indicator_Date,16)
		GUICtrlSetState($Indicator_Clock,16)
		GUICtrlSetState($Frame,16+2048)
		GUICtrlSetPos($Line_5,0,$Control_Position[1],default,default)
		$Show_Hide_Controls_Previous=1
	ElseIf $1=2 Then
		GUICtrlSetState($Indicator_Timer,32)
		GUICtrlSetState($Indicator_Date,32)
		GUICtrlSetState($Indicator_Clock,32)
		GUICtrlSetState($Frame,32)
		GUICtrlSetPos($Line_5,0,49,default,default)
		For $2 = $List_Actions to $Button_Off Step +1
			GUICtrlSetState($2,16)
		Next 
		$Show_Hide_Controls_Previous=2
	Else
		For $2 = $List_Actions to $Button_Off Step +1
			GUICtrlSetState($2,32)
		Next
		GUICtrlSetState($Indicator_Date,32)
		GUICtrlSetState($Indicator_Clock,32)
		GUICtrlSetPos($Line_5,0,0,default,default)
		GUICtrlSetState($Indicator_Timer,16)
		$Show_Hide_Controls_Previous=3
	EndIf
EndFunc

Func GUI_Move($1)
	$Difference_Distance=GUIGetCursorInfo($1)
	$Size_Interfase=WinGetPos($1)
	GUISetCursor(9,1)
	While 1		
		If GUIGetMsg()<>-8 And BitAnd(WinGetState($1,""),8) Then
			$Cursor_Position_Desktop=MouseGetPos()
			If $Cursor_Position_Desktop[0]<$Difference_Distance[0] Then
				MouseMove($Difference_Distance[0],$Cursor_Position_Desktop[1],0)
			ElseIf $Cursor_Position_Desktop[0]>@DesktopWidth-$Size_Interfase[2]+$Difference_Distance[0]+2 Then
				MouseMove(@DesktopWidth-$Size_Interfase[2]+$Difference_Distance[0]+2,$Cursor_Position_Desktop[1],0)
			ElseIf $Cursor_Position_Desktop[1]<$Difference_Distance[1] Then
				MouseMove($Cursor_Position_Desktop[0],$Difference_Distance[1],0)
			ElseIf $Cursor_Position_Desktop[1]>@DesktopHeight-$Size_Interfase[3]+$Difference_Distance[1]+2 Then
				MouseMove($Cursor_Position_Desktop[0],@DesktopHeight-$Size_Interfase[3]+$Difference_Distance[1]+2,0)
			Else
				WinMove($1,"",$Cursor_Position_Desktop[0]-$Difference_Distance[0]-1,$Cursor_Position_Desktop[1]-$Difference_Distance[1]-1,default,default)
			EndIf
		Else
			GUISetCursor(2,1)
			ExitLoop
		EndIf
	WEnd
	Return StringSplit($Cursor_Position_Desktop[0]-$Difference_Distance[0]&","&$Cursor_Position_Desktop[1]-$Difference_Distance[1],",")
EndFunc
	
Func Off_Timer()
	$Timer_Info=StringSplit("","")
	GUICtrlSetData($On_Off_Timer,". ")
	Show_Hide_Controls(1)
	WinSetOnTop($GUI,"",$GUI_On_Top)
EndFunc
  
Func Select_Color()
	Local $1=DllStructCreate("dword;int;int;int;ptr;dword;int;ptr;ptr")
	DllStructSetData($1,1,DllStructGetSize($1))
	DllStructSetData($1,2,0)
	DllStructSetData($1,4,0)
	DllStructSetData($1,5,DllStructGetPtr(DllStructCreate("int[16]")))
	DllStructSetData($1,6,BitOR(0x100,0x2,0x1))
	$2=DllCall("comdlg32.dll","long","ChooseColor","ptr",DllStructGetPtr($1))
	If ($2[0]==0) Then Return 0
	$2=Hex(String(DllStructGetData($1,4)),6)
	Return '0x'&StringMid($2,5,2)&StringMid($2,3,2)&StringMid($2,1,2)
EndFunc
		
Func Lock_GUI($1)	
	If $1>0 Then
		GUISetState(@SW_DISABLE)
		GUISetState(@SW_LOCK)
		GUISetCursor(15,1)
	Else
		GUISetState(@SW_UNLOCK)
		GUISetState(@SW_ENABLE)
		GUISetCursor(2,1)
	EndIf
EndFunc
			
Func Observation_And_Update()
	If $Date_Previous<>@MDAY&@MON&@WDAY Then
		$0=@MDAY
		If StringLeft(@MDAY,1)=0 Then $0=StringRight(@MDAY,1)
		GUICtrlSetData($Indicator_Date,$Week_Day[@WDAY]&" "&$0&" "&$Year_Month[@MON])
		$Date_Previous=@MDAY&@MON&@WDAY
	ElseIf $Clock_Previous <> @HOUR&@MIN Then
		$0 = @HOUR
		If StringLeft(@HOUR,1)=0 Then $0=StringRight(@HOUR,1)
		GUICtrlSetData($Indicator_Clock,$0&":"&@MIN)
		$Clock_Previous=@HOUR&@MIN
	EndIf
	;===========================================================
	If $Timer_Info[0]>0 Then
		$_0=$Timer_Info[1]-Round(TimerDiff($Timer_Info[2])/1000)
		If $_0<0 Then
			$1=$Timer_Info[3]
			Off_Timer()
			If $1=0 Then Shutdown(64)
			If $1=1 Then Shutdown(32)
			If $1=2 Then Shutdown(13)
			If $1=3 Then Shutdown(4)
		Else
			If $_0<61 Then
				Show_Hide_Controls(3)
				Opt("TrayIconHide",1)
				GUISetState(@SW_SHOW)
				WinSetOnTop($GUI,"",1)
				If Not BitAnd(WinGetState($GUI),8) Then WinActivate ($GUI)
				If $Audio_Alarm>0 Then
					If StringRight(@SEC,1)=1 Or StringRight(@SEC,1)=4 Or StringRight(@SEC,1)=7 Then Beep(500,250)
				EndIf
			Else
				$CursorInfo = GUIGetCursorInfo($GUI)
				If $CursorInfo[4] Then
					Show_Hide_Controls(3)
				Else
					Show_Hide_Controls(1)
				EndIf
			EndIf
			$_1=Int($_0/3600)
			$_0=Mod($_0,3600)
			$_2=Int($_0/60)
			$_3=Round(Mod($_0,60))
			$Message=$Timer_Messages[$Timer_Info[3]+1]&" :"&@CR
			If $_1>0 Then $Message=$Message&" "&$_1&" ."
			If $_2>0 Then $Message=$Message&" "&$_2&" ."
			If $_3>0 Then $Message=$Message&" "&$_3&" ."
			Message_Timer($_3,$Message)
		EndIf
	Else
		TraySetToolTip(GUICtrlRead($Indicator_Clock)&" "&GUICtrlRead($Indicator_Date))
	EndIf
EndFunc

Func Message_Timer($1,$2)
	If $Timer_Previous<>$1 Then
		GUICtrlSetData($Indicator_Timer,$2)
		TraySetToolTip ($2)
		$Timer_Previous=$1
	EndIf
EndFunc
			
			
			
			
