#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Resources\icon.ico
#AutoIt3Wrapper_Outfile=C:\Program Files\My Stacks\stack.exe
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=
#AutoIt3Wrapper_Res_Description=My Stacks
#AutoIt3Wrapper_Res_Fileversion=0.3.0.0
#AutoIt3Wrapper_Res_FileVersion_AutoIncrement=n
#AutoIt3Wrapper_Res_LegalCopyright=Bytek
#AutoIt3Wrapper_Res_Language=1049
#AutoIt3Wrapper_Run_Au3check=n
#AutoIt3Wrapper_Res_Field=Version|0.3.0
#AutoIt3Wrapper_Res_Field=Build|2014.04.10
#AutoIt3Wrapper_Res_Field=Coded by|Bytek
#AutoIt3Wrapper_Res_Field=CompanyName|Bytek_Soft
#AutoIt3Wrapper_Res_Field=Compile date|%longdate% %time%
#AutoIt3Wrapper_Res_Field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_Res_File_Add=Resources\option.png, PNG, OPTION
#AutoIt3Wrapper_Res_File_Add=Resources\close.png, PNG, CLOSE
#AutoIt3Wrapper_Res_File_Add=Resources\glass_stack.png, PNG, STACK
#AutoIt3Wrapper_Res_File_Add=Resources\glass_grid.png, PNG, GRID
#AutoIt3Wrapper_Res_Icon_Add=Resources\201.ico
#AutoIt3Wrapper_Res_Icon_Add=Resources\202.ico
#AutoIt3Wrapper_Res_Icon_Add=Resources\203.ico
#AutoIt3Wrapper_Res_Icon_Add=Resources\204.ico
#AutoIt3Wrapper_Res_Icon_Add=Resources\205.ico
#AutoIt3Wrapper_Res_Icon_Add=Resources\206.ico
#AutoIt3Wrapper_Res_Icon_Add=Resources\207.ico
#AutoIt3Wrapper_Res_File_Add=Resources\error.wav, WAVE, ERROR
#AutoIt3Wrapper_Res_File_Add=Resources\move.wav, WAVE, MOVE
#AutoIt3Wrapper_Res_File_Add=Resources\choose.wav, WAVE, CHOOSE
#AutoIt3Wrapper_Res_File_Add=Resources\hide.wav, WAVE, HIDE
#AutoIt3Wrapper_Res_File_Add=Resources\show.wav, WAVE, SHOW
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

#NoTrayIcon

#include <Color.au3>
#include <File.au3>
#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <GuiMenu.au3>
#include <Misc.au3>
#include <StaticConstants.au3>
#include <WinAPIEx.au3>
#include <WindowsConstants.au3>

#include <Includes\ExtMsgBox.au3>
#include <Includes\ModernMenuRaw.au3>
#include <Includes\GUICtrlOnHover.au3>

If $CmdLine[0] <= 0 Then Exit
If Not FileExists($CmdLine[1]) Then Exit

HotKeySet("{Esc}", "_Exit")

Dim $MousePos = MouseGetPos() ;   
Global $MousePosX = $MousePos[0]
Global $MousePosY = $MousePos[1]
Global $MouseOnTaskbar
Global Const $AC_SRC_ALPHA = 1, $BN_CLICKED = 0
Global Const $SND_ASYNC = 0x00000001
Global Const $SND_NOWAIT = 0x00002000
Global Const $SND_RESOURCE = 0x00040004
Global Const $TBS_NOTICKS = 0x0010

Global $DirProgram = $CmdLine[1]
Global $NameStack = $CmdLine[2]
Global $TipStack, $Files, $btn
Global $hInstance = _WinAPI_GetModuleHandleEx(0)
Global $Window_Width ;   
Global $Window_Height ;   
Global $TaskbarWidth, $TaskbarHeigth
Global $TaskbarPos, $WindowPosX, $WindowPosY
Global $FontName, $FontSize, $FontWeight, $FontColor, $FontBkColor, $FontColorRef, $FontAttribute
Global $FileLNK, $nIconID
Global $EffectNum, $Effect1, $Effect2, $EffectSpeed = 150
Global $DirBase = @ScriptDir & "\Data\" & $NameStack & "\"
Global $DirRes = @ScriptDir & "\Resources\"
Global $FullPath, $AllFiles, $DataFile = $DirBase & "data.cfg", $TextureFile
Global $error = False, $ChildLab, $SmallName
Global $hDLL = DllOpen("user32.dll")
Global $btnOption, $btnExit
Global $wTrans, $IconHeight, $IconSize, $btnOpt6, $AutoClose, $SoundOn, $ItemWidth
Global $IconWindow, $TransWindow, $TranSlider, $IconSlider, $TransLabel, $btnTransOk, $IconLabel, $btnIconOk

Dim $EffectArray[10][2] = [[0x80000, 0x80000 + 0x10000], [0x10, 0x10 + 0x10000], [0x1, 0x2 + 0x10000], [0x2, 0x1 +0x10000], [0x4, 0x8 + 0x10000], [0x8, 0x4 + 0x10000], _
											[0x1+0x4, 0x2+0x8+0x10000], [0x2+0x4, 0x1+0x8+0x10000], [0x1+0x8, 0x2+0x4+0x10000], [0x2+0x8, 0x1+0x4+0x10000]]
Dim $btnOpt5[10], $btnOpt7[2]

;If Not FileExists($DirRes) Then DirCreate(@ScriptDir & "\Resources\")
;FileInstall("d:\ \AutoIt\ \MyStacks\Resources\texture.jpg", $DirRes)

If RegRead("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload") = 1 Then
	$MousePosX = RegRead("HKEY_CURRENT_USER\Software\MyStacks\Data", "PosX")
	$MousePosY = RegRead("HKEY_CURRENT_USER\Software\MyStacks\Data", "PosY")
	RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload", "REG_SZ", 0)
Else
	RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "PosX", "REG_SZ", $MousePosX)
	RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "PosY", "REG_SZ", $MousePosY)
EndIf


_VerifyBase()
If $error Then _NewBase()

Switch $TipStack
	Case 1
		If $AllFiles <= 20 Then
			$korenX = 1
			$korenY = $AllFiles
			$ItemHeight = 32
		ElseIf $AllFiles > 20 And $AllFiles <= 40 Then
			$korenX = 2
			$korenY = Ceiling($AllFiles / $korenX)
			$ItemHeight = 28
		Else
			$korenX = Ceiling(Sqrt($AllFiles) / 3)
			$korenY = Ceiling($AllFiles / $korenX)
			$ItemHeight = 24
		EndIf
		$ItemWidth = $ItemWidth + $ItemHeight
		$Window_Width = $korenX * $ItemWidth + 8
		$Window_Height = $korenY * $ItemHeight + 34
	Case 2
		If $IconHeight = "" Then
			If $AllFiles <= 42 Then
				$IconSize = 64
				$ItemWidth = 128
			ElseIf $AllFiles > 42 And $AllFiles <= 100 Then
				$IconSize = 48
				$ItemWidth = 112
			Else
				$IconSize = 32
				$ItemWidth = 96
			EndIf
		Else
			$ItemWidth = $IconHeight + 64
			$IconSize = $IconHeight
		EndIf
		$korenX = Ceiling(Sqrt($AllFiles) /1.2)
		$korenY = Ceiling($AllFiles / $korenX)
		$ItemHeight = $IconSize  + 2 + 16
		$Window_Width = $korenX * $ItemWidth + 8
		$Window_Height = $korenY * $ItemHeight + 34
EndSwitch

If $Window_Width +48 > @DesktopWidth Or $Window_Height +48 > @DesktopHeight Then _Perebor()

_TaskbarPos() ;      ,    
_CoordCalculation() ;     
_GDIPlus_Startup()
_ExtMsgBoxSet(1 + 32, 1, -1, -1, 11, "Tahoma")

;	 
$Window = GUICreate("", $Window_Width, $Window_Height, $WindowPosX, $WindowPosY, BitOR($WS_POPUP, $WS_BORDER), BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST))
GUISetState(@SW_DISABLE, $Window)
_GuiSetDropShadow($Window, False)
GUICtrlCreatePic($TextureFile, 0, 0, $Window_Width, $Window_Height)
GUICtrlSetState(-1, $GUI_DISABLE)

;	     
_CreateShadowLabel($NameStack & " (" & $AllFiles & ")", 4, 4, $Window_Width - 46, 24, -1, 11, $FontWeight, 2, "Verdana", 0x264E00, 0xFFFF00)

;	  ""
$gImage = _LoadResourceImage($hInstance, "PNG", "OPTION")
$OptionBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($gImage)
$btnOption = GUICtrlCreatePic("", $Window_Width - 40, 4, 16, 16)
_GUICtrl_OnHoverRegister(-1, "_Hover_Proc", "_Leave_Hover_Proc")
$hbtnOption = GUICtrlGetHandle($btnOption)
GUICtrlSetTip(-1, "", "", 0, 0)
_SendMessage(GUICtrlGetHandle($btnOption), 0x0172, 0, $OptionBitmap)

;	  ""
$gImage = _LoadResourceImage($hInstance, "PNG", "CLOSE")
$CloseBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($gImage)
$btnExit = GUICtrlCreatePic("", $Window_Width - 20, 4, 16, 16)
_GUICtrl_OnHoverRegister(-1, "_Hover_Proc", "_Leave_Hover_Proc")
GUICtrlSetTip(-1, "", "", 0, 0)
_SendMessage(GUICtrlGetHandle($btnExit), 0x0172, 0, $CloseBitmap)

;	   .
$IconsArray = IniReadSection($DataFile, "ICONS")
$m = 1
$kolvo = 1
$n = 0
Switch $TipStack
	Case 1
		For $j = 0 To $korenX - 1
			If $kolvo > $AllFiles Then ExitLoop
			$xItem = $j * $ItemWidth + 4
			For $i = 0 To $korenY - 1
				If $kolvo > $AllFiles Then ExitLoop
				$yItem = $i * $ItemHeight + 28
				$btn[$n][4] = $WindowPosX + $xItem
				$btn[$n][5] = $WindowPosY + $yItem +1
				$btn[$n][0] = GUICtrlCreateLabel("", $xItem, $yItem, $ItemWidth, $ItemHeight) ;	  
			_GUICtrl_OnHoverRegister(-1, "_Hover_Proc", "_Leave_Hover_Proc")
				GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
				$adICON = _WinAPI_ShellExtractIcon($IconsArray[$m][1], $IconsArray[$m +1][1], $ItemHeight, $ItemHeight)
				$gBitmap = _WinAPI_Create32BitHBITMAP($adICON)
				$Pic1 = GUICtrlCreatePic("", $xItem  + 4, $yItem + 1, $ItemHeight, $ItemHeight)
				_SendMessage(GUICtrlGetHandle($Pic1), 0x0172, 0, $gBitmap)
				_CreateShadowLabel($btn[$n][2], $xItem + $ItemHeight + 8, $yItem, $ItemWidth - $ItemHeight - 10, $ItemHeight -1, $SS_CENTERIMAGE, $FontSize, $FontWeight, $FontAttribute, $FontName, $FontBkColor, $FontColor) ;	  
				$btn[$n][3] = $SmallName
				$kolvo += 1
				$n += 1
				$m += 2
			Next
		Next
	Case 2
		For $i = 0 To $korenY - 1
			If $kolvo > $AllFiles Then ExitLoop
			$yItem = $i * $ItemHeight + 28
			For $j = 0 To $korenX - 1
				If $kolvo > $AllFiles Then ExitLoop
				$xItem = $j * $ItemWidth + 4
				$btn[$n][4] = $WindowPosX + $xItem
				$btn[$n][5] = $WindowPosY + $yItem
				$btn[$n][0] = GUICtrlCreateLabel("", $xItem, $yItem, $ItemWidth, $ItemHeight) ;	  
				GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
				$adICON = _WinAPI_ShellExtractIcon($IconsArray[$m][1], $IconsArray[$m +1][1], $IconSize, $IconSize)
				$gBitmap = _WinAPI_Create32BitHBITMAP($adICON)
				$Pic1 = GUICtrlCreatePic("", $xItem + (($ItemWidth - $IconSize) / 2) + 1, $yItem + 1, $IconSize, $IconSize)
				_SendMessage(GUICtrlGetHandle($Pic1), 0x0172, 0, $gBitmap)
				_CreateShadowLabel($btn[$n][2], $xItem + 1, $yItem + $ItemHeight - 16, $ItemWidth -2, 16, $SS_CENTER, $FontSize, $FontWeight, $FontAttribute, $FontName, $FontBkColor, $FontColor) ;	  
				_GUICtrl_OnHoverRegister($btn[$n][0], "_Hover_Proc", "_Leave_Hover_Proc")
				$btn[$n][3] = $SmallName
				$kolvo += 1
				$n += 1
				$m += 2
			Next
		Next
EndSwitch

;	  ""
_SetOLBlueColors() ;	   
$ContMenu = GUICtrlCreateContextMenu(GUICtrlCreateDummy())
$hMenu = GUICtrlGetHandle($ContMenu)
$btnOpt1	= _GUICtrlCreateODMenuItem("  ", $ContMenu, @ScriptFullPath, 201)
$btnOpt2	= _GUICtrlCreateODMenuItem("  ", $ContMenu, @ScriptFullPath, 202)
$btnOpt3	= _GUICtrlCreateODMenuItem(" ", $ContMenu, @ScriptFullPath, 203)
$btnOpt4	= _GUICtrlCreateODMenuItem(" ", $ContMenu, @ScriptFullPath, 204)
$btnOpt5a = _GUICtrlCreateODMenu(" ", $ContMenu, @ScriptFullPath, 205)
$btnOpt5[0]	= _GUICtrlCreateODMenuItem(" ", $btnOpt5a)
$btnOpt5[1]	= _GUICtrlCreateODMenuItem("  ", $btnOpt5a)
$btnOpt5[2]	= _GUICtrlCreateODMenuItem(" ", $btnOpt5a)
$btnOpt5[3]	= _GUICtrlCreateODMenuItem(" ", $btnOpt5a)
$btnOpt5[4]	= _GUICtrlCreateODMenuItem(" ", $btnOpt5a)
$btnOpt5[5]	= _GUICtrlCreateODMenuItem(" ", $btnOpt5a)
$btnOpt5[6]	= _GUICtrlCreateODMenuItem("  +  ", $btnOpt5a)
$btnOpt5[7]	= _GUICtrlCreateODMenuItem("  +  ", $btnOpt5a)
$btnOpt5[8]	= _GUICtrlCreateODMenuItem("  +  ", $btnOpt5a)
$btnOpt5[9]	= _GUICtrlCreateODMenuItem("  +  ", $btnOpt5a)
GUICtrlSetState($btnOpt5[$EffectNum], $GUI_CHECKED)
;	   - ,      " "
If $TipStack = 2 Then $btnOpt6	= _GUICtrlCreateODMenuItem(" ", $ContMenu, @ScriptFullPath, 206)
$btnOpt7a = _GUICtrlCreateODMenu(" ", $ContMenu, @ScriptFullPath, 207)
$btnOpt7[0]	= _GUICtrlCreateODMenuItem("", $btnOpt7a)
$btnOpt7[1]	= _GUICtrlCreateODMenuItem("", $btnOpt7a)
GUICtrlSetState($btnOpt7[$TipStack -1], $GUI_CHECKED)
$btnOpt8	= _GUICtrlCreateODMenuItem(" ", $ContMenu)
If $AutoClose = 1 Then GUICtrlSetState($btnOpt8, $GUI_CHECKED)
$btnOpt9	= _GUICtrlCreateODMenuItem(" ", $ContMenu)
If $SoundOn = 1 Then GUICtrlSetState($btnOpt9, $GUI_CHECKED)

;	         
Switch $TipStack
	Case 1
		$gImage = _LoadResourceImage($hInstance, "PNG", "STACK")
	Case 2
		$gImage = _LoadResourceImage($hInstance, "PNG", "GRID")
EndSwitch
$ChildWinWidth = $ItemWidth +2
$ChildWinHeight = $ItemHeight + 4
$ChildWindow = GUICreate("", $ChildWinWidth, $ChildWinHeight, -1, -1, $WS_POPUP, $WS_EX_LAYERED, $Window)
SetBitmap($ChildWindow, $gImage, 255, $ChildWinWidth, $ChildWinHeight)
$ChildLab = GUICtrlCreateLabel("", 0, 0, $ChildWinWidth, $ChildWinHeight)

;	         
$TransWindow = GUICreate("", 140, 48, $WindowPosX + $Window_Width -140, $WindowPosY, BitOR($WS_POPUP, $WS_BORDER), BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST), $Window)
$TranSlider = GUICtrlCreateSlider(2, 2, 136, 24, $TBS_NOTICKS)
GUICtrlSetCursor(-1, 0)
GUICtrlSetLimit(-1, 255, 0)
GUICtrlSetData (-1, $wTrans)
$TransLabel =GUICtrlCreateLabel($wTrans & " %", 4, 32, 50, 16, $SS_LEFTNOWORDWRAP)
$btnTransOk = GUICtrlCreateButton("OK", 108, 26, 30, 20)
GUISetState(@SW_HIDE, $TransWindow)
GUISetState(@SW_DISABLE, $TransWindow)

;	        
$IconWindow = GUICreate("", 140, 48, $WindowPosX + $Window_Width -140, $WindowPosY, BitOR($WS_POPUP, $WS_BORDER), BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST), $Window)
$IconSlider = GUICtrlCreateSlider(2, 2, 136, 24, $TBS_NOTICKS)
GUICtrlSetCursor(-1, 0)
GUICtrlSetLimit(-1, 128, 15)
GUICtrlSetData (-1, $IconHeight)
$IconLabel =GUICtrlCreateLabel($IconHeight & " pix", 4, 32, 62, 16, $SS_LEFTNOWORDWRAP)
$btnIconOk = GUICtrlCreateButton("OK", 108, 26, 30, 20)
GUISetState(@SW_HIDE, $TransWindow)
GUISetState(@SW_DISABLE, $TransWindow)

If $SoundOn = 1 Then _WinAPI_PlaySound("SHOW", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
_Animated($Window, $EffectSpeed, $Effect1)	;	  
If $wTrans <> 255 Then ; 	  ,  .
	For $i = 255 To $wTrans Step -0.5
		WinSetTrans($Window, '', $i)
	Next
EndIf
GUISetState(@SW_SHOW, $Window)
GUISetState(@SW_ENABLE, $Window)
GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
GUIRegisterMsg($WM_HSCROLL, "WM_HVSCROLL")
$FullPath = ""

While 1 ;	 
	$tPoint = _WinAPI_GetMousePos()
	$dAdat = _WinAPI_GetAncestor(_WinAPI_WindowFromPoint($tPoint), $GA_ROOT)
	If $dAdat <> $Window And $dAdat <> $ChildWindow Then
		If _IsPressed('01', $hDLL)  And $AutoClose = 1 Then _Exit()	;	  :     ,  
		GUISetState(@SW_HIDE, $ChildWindow)
	EndIf
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $ChildLab	;	   ,   
				If FileExists($FullPath)  Then
					If $SoundOn = 1 Then _WinAPI_PlaySound("CHOOSE", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
					ShellExecute($FullPath) ;	 ,  
					_Animated($ChildWindow, 200, 0x10 + 0x10000)
					If $AutoClose = 1 Then _Exit()
				EndIf
		Case $btnExit	;		  "",  
			_Exit()
		Case $btnOpt1;		  "  ",    
			ShellExecute($DirProgram)
			_Exit()
		Case $btnOpt2 ;		  " "...
			$WallDir = RegRead("HKEY_CURRENT_USER\Software\MyStacks\Data", "WallPapersDir")
			If @error Then $WallDir = @WindowsDir & "\Web\Wallpaper\"
			$tf = FileOpenDialog(" ", $WallDir, " (*.jpg;*.bmp)", -1, "", $Window)
			If Not @error Then
				$TextureFile = StringReplace($tf, "|", @CRLF)
				IniWrite($DataFile, "DATA", "Texture", $TextureFile)
				$WallDir = StringRegExpReplace($TextureFile, '^(.*)\\(.*)$', '\1')
				RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "WallPapersDir", "REG_SZ", $WallDir)
				RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload", "REG_SZ", 1)
				_Reload()
			EndIf
		Case $btnOpt3 ;		  " "...
			Local $Italic = BitAND($FontAttribute, 2)
			Local $Underline = BitAND($FontAttribute, 4)
			Local $Strikethru = BitAND($FontAttribute, 8)
			Local $aFont = _ChooseFont($FontName, $FontSize, $FontColorRef, $FontWeight, $Italic, $Underline, $Strikethru, $Window)
			If Not @error Then
				Local $FontSTR = "FontName=" & $aFont[2] & @LF & _
												"FontSize=" & $aFont[3] & @LF & _
												"FontWeight=" & $aFont[4] & @LF & _
												"FontColorRef=" & $aFont[5] & @LF & _
												"FontAttribute=" & $aFont[1]
				IniWriteSection($DataFile, "FONT", $FontSTR)
				RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload", "REG_SZ", 1)
				IniDelete($DataFile, "FILE_NAME")
				_Reload()
			EndIf
		Case $btnOpt4 ;		  " "...
			_TransOption()
		Case $btnOpt6 ;		  " "...
			If $TipStack = 2 Then _IconSize()
		Case $btnOpt8 ;		  ""...
			If $AutoClose = 1 Then
				$AutoClose = 0
				GUICtrlSetState($btnOpt8, $GUI_UNCHECKED)
			Else
				$AutoClose = 1
				GUICtrlSetState($btnOpt8, $GUI_CHECKED)
			EndIf
			IniWrite($DataFile, "DATA", "AutoClose", $AutoClose)
		Case $btnOpt9 ;		  " "...
			If $SoundOn  = 1 Then
				$SoundOn = 0
				GUICtrlSetState($btnOpt9, $GUI_UNCHECKED)
			Else
				$SoundOn = 1
				GUICtrlSetState($btnOpt9, $GUI_CHECKED)
			EndIf
			IniWrite($DataFile, "DATA", "SoundOn", $SoundOn)
	EndSwitch
	For $cycl = 0 To 9 ;	  " "...
		If  $nMsg = $btnOpt5[$cycl] Then
			GUICtrlSetState($btnOpt5[$EffectNum], $GUI_UNCHECKED)
			$EffectNum = $cycl
			$Effect1 = $EffectArray[$EffectNum][0]
			$Effect2 = $EffectArray[$EffectNum][1]
			IniWrite($DataFile, "DATA", "EffectNum", $EffectNum)
			GUICtrlSetState($btnOpt5[$EffectNum], $GUI_CHECKED)
		EndIf
	Next
	For $cycl = 0 To 1 ;	  " "...
		If  $nMsg = $btnOpt7[$cycl] Then
			GUICtrlSetState($btnOpt7[$TipStack -1], $GUI_UNCHECKED)
			$TipStack = $cycl + 1

			If $TipStack = 1 Then
				IniWrite($DataFile, "FONT", "FontSize", 16)
				IniWrite($DataFile, "FONT", "FontWeight", 400)
			Else
				IniWrite($DataFile, "FONT", "FontSize", 9)
				IniWrite($DataFile, "FONT", "FontWeight", 400)
			EndIf

			IniWrite($DataFile, "DATA", "TIP", $TipStack)
			RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload", "REG_SZ", 1)
			IniDelete($DataFile, "FILE_NAME")
			_Reload()
		EndIf
	Next
WEnd

Func WM_HVSCROLL($hWndGUI, $MsgID, $WParam, $LParam) ;	  ""  " "
    Switch $LParam
		Case GUICtrlGetHandle($TranSlider)
			$wTrans = GUICtrlRead($TranSlider)
            GUICtrlSetData($TransLabel, $wTrans & " %")
			WinSetTrans($Window, '', $wTrans)
		Case GUICtrlGetHandle($IconSlider)
			$pix = " pix"
			$IconHeight = GUICtrlRead($IconSlider)
			If $IconHeight = 15 Then
				$IconHeight = ""
				$pix = ""
			EndIf
			_IconSizeSetTip()
			GUICtrlSetData($IconLabel, $IconHeight & $pix)
    EndSwitch
EndFunc

Func _TransOption() ;	  " "...
	GUISetState(@SW_DISABLE, $Window)
	_Animated($TransWindow, $EffectSpeed, 0x2+0x4)
	GUISetState(@SW_ENABLE, $TransWindow)
	GUISetState(@SW_SHOW, $TransWindow)
	While 1
		$tMsg = GUIGetMsg()
		If $tMsg = $btnTransOk Then
			_Animated($TransWindow, $EffectSpeed, 0x1+0x8+0x10000)
			GUISetState(@SW_HIDE, $TransWindow)
			GUISetState(@SW_DISABLE, $TransWindow)
			If $wTrans <> IniRead($DataFile, "DATA", "Transparent", "") Then
				IniWrite($DataFile, "DATA", "Transparent", $wTrans)
			EndIf
			GUISetState(@SW_ENABLE, $Window)
			Return
		EndIf
	WEnd
EndFunc

Func _IconSize() ;	  " "...
	GUISetState(@SW_DISABLE, $Window)
	_Animated($IconWindow, $EffectSpeed, 0x2+0x4)
	GUISetState(@SW_ENABLE, $IconWindow)
	GUISetState(@SW_SHOW, $IconWindow)
	_IconSizeSetTip()
	While 1
		$tMsg = GUIGetMsg()
		If $tMsg = $btnIconOk Then
			_Animated($IconWindow, $EffectSpeed, 0x1+0x8+0x10000)
			GUISetState(@SW_HIDE, $IconWindow)
			GUISetState(@SW_DISABLE, $IconWindow)
			If $IconHeight <> IniRead($DataFile, "DATA", "IconSize", "") Then
				IniWrite($DataFile, "DATA", "IconSize", $IconHeight)
				RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload", "REG_SZ", 1)
				_Reload()
			Else
				GUISetState(@SW_ENABLE, $Window)
				Return
			EndIf
		EndIf
	WEnd
EndFunc

Func _IconSizeSetTip()
	If $IconHeight = "" Then
		GUICtrlSetTip($IconLabel, "  ," & @LF & "   .", "", 0, 0)
	Else
		GUICtrlSetTip($IconLabel, "", "", 0, 0)
	EndIf
EndFunc

Func _Animated($hWnd, $EffectSpeed, $Effect) ;	  
	DllCall("User32.dll", "long", "AnimateWindow", "hwnd", $hWnd, "long", $EffectSpeed, "long", $Effect) ;  
EndFunc   ;==>_Animated

Func _Reload() ;	   
	ShellExecute(@ScriptFullPath, Chr(34) & $DirProgram & Chr(34) & " " & Chr(34) & $NameStack & Chr(34))
	_Exit()
EndFunc   ;==>_Reload

Func _Hover_Proc($iCtrlID) ;	,     ,    -    
	For $i = 0 To $AllFiles - 1
		If $iCtrlID = $btn[$i][0] Then
			If $SoundOn = 1 Then _WinAPI_PlaySound("MOVE", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
			WinMove($ChildWindow, "", $btn[$i][4], $btn[$i][5]) ;	  
			GUISetState(@SW_SHOW, $ChildWindow) ;	  
			GUICtrlSetCursor($ChildLab, 0)
			If $btn[$i][2] <> $btn[$i][3] Then ;	     ,
				GUICtrlSetTip($ChildLab, $btn[$i][2], $NameStack, 0, 2) ;	 
			Else
				GUICtrlSetTip($ChildLab, "", "", 0, 0) ;	  
			EndIf
			$FullPath = $DirProgram & "\" & $btn[$i][1]
			Return ;	  
		EndIf
	Next
	If $iCtrlID = $btnOption Or $iCtrlID = $btnExit Then GUISetState(@SW_HIDE, $ChildWindow)
EndFunc   ;==>_Hover_Proc

Func _Leave_Hover_Proc($iCtrlID)

EndFunc

Func _Exit() ;  -   .
	If $wTrans <> 255 Then WinSetTrans($Window, '', 255)
	GUIDelete($ChildWindow)
	If $SoundOn = 1 Then _WinAPI_PlaySound("HIDE", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
	_Animated($Window, $EffectSpeed +100, $Effect2)
	If $SoundOn = 1 Then Sleep(300)
	GUIDelete($Window)
	_GDIPlus_ImageDispose($gImage)
	_WinAPI_DeleteObject($gImage)
	_WinAPI_DeleteObject($gBitmap)
	_GDIPlus_Shutdown()
	Exit
EndFunc   ;==>_Exit

Func _TaskbarPos() ;   
	$TaskbarPos = WinGetPos("[CLASS:Shell_TrayWnd]")
	Local $x = $TaskbarPos[0] ; X-   
	Local $y = $TaskbarPos[1] ; Y-   
	$TaskbarWidth = $TaskbarPos[2] ;   
	$TaskbarHeigth = $TaskbarPos[3] ;   
	$MouseOnTaskbar = False ;     True,     
	If $x = 0 And $y = 0 And $TaskbarWidth = @DesktopWidth Then
		$TaskbarPos = 1 ;
		If $MousePosY < $TaskbarHeigth Then $MouseOnTaskbar = True
	ElseIf $x > 0 And $y = 0 And $TaskbarHeigth = @DesktopHeight Then
		$TaskbarPos = 2 ;
		If $MousePosX > $x Then $MouseOnTaskbar = True
	ElseIf $x = 0 And $y = 0 And $TaskbarHeigth = @DesktopHeight Then
		$TaskbarPos = 3 ;
		If $MousePosX < $TaskbarWidth Then $MouseOnTaskbar = True
	Else
		$TaskbarPos = 0 ; 
		If $MousePosY > @DesktopHeight - $TaskbarHeigth Then $MouseOnTaskbar = True
	EndIf
EndFunc   ;==>_TaskbarPos

Func _Search_Icon($gaDropFiles) ;	   
	; If $TrgSave_ini Then _Save_ini()
	Local $type = StringRegExpReplace($gaDropFiles, '.*\.([^\\/:*?"<>|]+)', '\1') ;   
	Local $aLNK[7]
	$aLNK[0] = $gaDropFiles
	If StringInStr(FileGetAttrib($gaDropFiles), "D") Then ;  , 
		$aLNK[4] = @SystemDir & '\shell32.dll' ;   
		$aLNK[5] = 3
		Opt('ExpandEnvStrings', 1) ;    desktop.ini     %name%
		If FileExists($gaDropFiles & '\desktop.ini') Then ;   desktop.ini,    
			$desktop1 = IniRead($gaDropFiles & '\desktop.ini', '.ShellClassInfo', 'IconFile', '-|-')
			$desktop2 = IniRead($gaDropFiles & '\desktop.ini', '.ShellClassInfo', 'IconIndex', '-|-')
			If FileExists($gaDropFiles & '\' & $desktop1) Then
				$aLNK[4] = $gaDropFiles & '\' & $desktop1
				$aLNK[5] = $desktop2
			ElseIf FileExists($desktop1) Then
				$aLNK[4] = $desktop1
				$aLNK[5] = $desktop2
			EndIf
		EndIf
		Opt('ExpandEnvStrings', 0)
	Else ;   
		Switch $type
			Case "lnk"
				Opt('ExpandEnvStrings', 1) ;    lnk     %name%
				$aLNK = FileGetShortcut($gaDropFiles)
				If Not @error And StringInStr(FileGetAttrib($aLNK[0]), "D") Then ;    , 
					$aLNK[4] = @SystemDir & '\shell32.dll'
					$aLNK[5] = 3
					If FileExists($aLNK[0] & '\desktop.ini') Then
						$desktop1 = IniRead($aLNK[0] & '\desktop.ini', '.ShellClassInfo', 'IconFile', '-|-')
						$desktop2 = IniRead($aLNK[0] & '\desktop.ini', '.ShellClassInfo', 'IconIndex', '-|-')
						If FileExists($aLNK[0] & '\' & $desktop1) Then
							$aLNK[4] = $aLNK[0] & '\' & $desktop1
							$aLNK[5] = $desktop2
						ElseIf FileExists($desktop1) Then
							$aLNK[4] = $desktop1
							$aLNK[5] = $desktop2
						EndIf
					EndIf
				ElseIf Not @error And $aLNK[4] = '' And StringRight($aLNK[0], 4) <> '.exe' Then ;    exe-, 
					$aPathIco = _TypeGetIco(StringRegExpReplace($aLNK[0], '.*\.([^\\/:*?"<>|]+)', '\1'))
					If Not @error Then
						$aLNK[4] = $aPathIco[0]
						If $aPathIco[2] <> '' Then $aLNK[5] = $aPathIco[2]
					EndIf
				EndIf
				Opt('ExpandEnvStrings', 0)
			Case 'exe', 'scr', 'ico' ;   exe-, 
				$aLNK[4] = $gaDropFiles
			Case Else
				$aPathIco = _TypeGetIco($type)
				If Not @error Then
					$aLNK[4] = $aPathIco[0]
					If $aPathIco[2] <> '' Then $aLNK[5] = $aPathIco[2]
				EndIf
		EndSwitch
	EndIf
	$FileLNK = $aLNK[4] ;	   
	$nIconID = $aLNK[5] ;	  ( 0)
	If $FileLNK = '' Then
		$FileLNK = $aLNK[0]
		$nIconID = 0
	EndIf
EndFunc   ;==>_Search_Icon

Func _TypeGetIco($type)
	Local $aPathErr[3] = [@SystemDir & '\shell32.dll', ',', 0]
	Local $typefile = RegRead('HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.' & $type, 'Progid'), $aPath[3]
	If @error Or $typefile = '' Then
		$typefile = RegRead('HKCR\.' & $type, '')
		If @error Then Return $aPathErr
	EndIf
	$typefile = RegRead('HKCR\' & $typefile & '\DefaultIcon', '')
	If @error Then Return $aPathErr
	Local $aPath = StringRegExp($typefile, '(?i)(^.*)(,)(.*)$', 3)
	If @error Then
		Local $aPath[3]
		$aPath[0] = $typefile
	Else
		$aPath[0] = StringReplace($aPath[0], '"', '')
	EndIf
	Opt('ExpandEnvStrings', 1)
	If FileExists($aPath[0]) Then
		$aPath[0] = $aPath[0]
		Opt('ExpandEnvStrings', 0)
		Return $aPath
	EndIf
	Opt('ExpandEnvStrings', 0)
	If FileExists(@SystemDir & '\' & $aPath[0]) Then
		$aPath[0] = @SystemDir & '\' & $aPath[0]
		Return $aPath
	ElseIf FileExists(@WindowsDir & '\' & $aPath[0]) Then
		$aPath[0] = @WindowsDir & '\' & $aPath[0]
		Return $aPath
	EndIf
	Return $aPathErr
EndFunc   ;==>_TypeGetIco

Func _CoordCalculation()	;	   
	If $MouseOnTaskbar Then ;    
		Switch $TaskbarPos
			Case 0 ;   
				$WindowPosX = $MousePosX - $Window_Width / 2
				$WindowPosY = @DesktopHeight - $TaskbarHeigth - $Window_Height - 6
				If $WindowPosX <= 0 Then $WindowPosX = 4
				If ($WindowPosX + $Window_Width) > @DesktopWidth Then $WindowPosX = @DesktopWidth - $Window_Width - 4

			Case 1 ;   
				$WindowPosX = $MousePosX - $Window_Width / 2
				$WindowPosY = $TaskbarHeigth + 4
				If $WindowPosX < 0 Then $WindowPosX = 4
				If ($WindowPosX + $Window_Width) > @DesktopWidth Then $WindowPosX = @DesktopWidth - $Window_Width - 4

			Case 2 ;   
				$WindowPosX = @DesktopWidth - $TaskbarWidth - $Window_Width - 8
				$WindowPosY = $MousePosY - $Window_Height / 2
				If $WindowPosY <= 0 Then $WindowPosY = 4
				If (@DesktopHeight - $MousePosY) < $Window_Height Then $WindowPosY = @DesktopHeight - $Window_Height - 14

			Case 3 ;   
				$WindowPosX = $TaskbarWidth + 4
				$WindowPosY = $MousePosY - $Window_Height / 2
				If $WindowPosY <= 0 Then $WindowPosY = 4
				If (@DesktopHeight - $MousePosY) < $Window_Height Then $WindowPosY = @DesktopHeight - $Window_Height - 14

		EndSwitch

	Else ;    
		$WindowPosX = $MousePosX + 16
		$WindowPosY = $MousePosY - $Window_Height / 2

		Switch $TaskbarPos

			Case 0 ;   
				If ($WindowPosX + $Window_Width) >= @DesktopWidth Then $WindowPosX = $MousePosX - $Window_Width - 16
				If $WindowPosY <= 0 Then $WindowPosY = 4
				If ($WindowPosY + $Window_Height) >= @DesktopHeight - $TaskbarHeigth Then $WindowPosY = @DesktopHeight - $TaskbarHeigth - $Window_Height - 6

			Case 1 ;   
				If $WindowPosX + $Window_Width >= @DesktopWidth Then $WindowPosX = $MousePosX - $Window_Width - 16
				If $WindowPosY <= $TaskbarHeigth Then $WindowPosY = $TaskbarHeigth + 4
				If ($WindowPosY + $Window_Height) >= @DesktopHeight - $TaskbarHeigth Then $WindowPosY = @DesktopHeight - $Window_Height - 6

			Case 2 ;   
				If ($WindowPosX + $Window_Width) >= @DesktopWidth - $TaskbarWidth Then $WindowPosX = $MousePosX - $Window_Width - 16
				If $WindowPosY <= 0 Then $WindowPosY = 4
				If ($WindowPosY + $Window_Height) >= @DesktopHeight Then $WindowPosY = @DesktopHeight - $Window_Height - 6

			Case 3 ;   
				If ($WindowPosX + $Window_Width) >= @DesktopWidth Then $WindowPosX = $MousePosX - $Window_Width - 16
				If $WindowPosY <= 0 Then $WindowPosY = 4
				If ($WindowPosY + $Window_Height) >= @DesktopHeight Then $WindowPosY = @DesktopHeight - $Window_Height - 6

		EndSwitch
	EndIf
EndFunc   ;==>_CoordCalculation

Func _NewBase()	;	   
	If Not FileExists($DirBase) Then DirCreate($DirBase)
	Dim $Files = _FileListToArray($DirProgram)
	Dim $btn[$Files[0]][6]
	Local $j = 0, $sLen = 0
	Local $FileNameArray = "", $IconsArray = ""
	$AllFiles = 0
	For $i = 1 To $Files[0] ;          .
		$FullPath = $DirProgram & $Files[$i]
		If StringRegExpReplace($FullPath, '.*\.([^\\/:*?"<>|]+)', '\1') = "lnk" Then
			Opt('ExpandEnvStrings', 1)
			$PathLNK = FileGetShortcut($FullPath)
			Opt('ExpandEnvStrings', 0)
			If Not FileExists($PathLNK[0]) Then
				FileRecycle($FullPath)
				$Files[0] -= 1
				ContinueLoop
			EndIf
		EndIf
		If StringInStr(FileGetAttrib($FullPath), "H") Then ContinueLoop ;	 /,    ,
		If StringInStr(FileGetAttrib($FullPath), "S") Then ContinueLoop ;	   
		_Search_Icon($FullPath)
		$IconsArray &= "IconFile_" & $AllFiles & "=" & $FileLNK & @LF & "IconID_" & $AllFiles & "=" & $nIconID & @LF
		$AllFiles += 1
		$FileNameArray &= $AllFiles & "=" & $Files[$i] & @LF

		$StrName = StringRegExpReplace($Files[$i], '^([^\\]+?)(?:\.[^.]+)?$', '\1') ;     
		$strLen = StringLen($StrName)
		If $sLen <> 25 Then
			If $strLen > 25 Then
				$sLen = 25
				$sName = StringTrimRight($StrName, $strLen - 25)
				$strWidth = _TextSize($sName, $FontSize, $FontWeight, $FontName)
			ElseIf $strLen > $sLen Then
				$sLen = $strLen
				$strWidth = _TextSize($StrName, $FontSize, $FontWeight, $FontName)
			EndIf
		EndIf

		$btn[$j][1] = $Files[$i]
		$btn[$j][2] = $StrName
		$j += 1
	Next
	IniWriteSection($DataFile, "ICONS", $IconsArray)
	IniWriteSection($DataFile, "FILE_NAME", $FileNameArray)
	$ItemWidth = $strWidth[0] +10
	Local $DataSTR = "TIP=" & $TipStack & @LF & _
									"FILES=" & $AllFiles & @LF & _
									"ALL_FILES=" & $Files[0] & @LF & _
									"Texture=" & $TextureFile & @LF & _
									"Transparent=" & $wTrans & @LF & _
									"EffectNum=" & $EffectNum & @LF & _
									"IconSize=" & $IconHeight & @LF & _
									"AutoClose=" & $AutoClose & @LF & _
									"SoundOn=" & $SoundOn & @LF & _
									"Width=" & $ItemWidth & @LF
	IniWriteSection($DataFile, "DATA", $DataSTR)
	Local $FontSTR = "FontName=" & $FontName & @LF & _
									"FontSize=" & $FontSize & @LF & _
									"FontWeight=" & $FontWeight & @LF & _
									"FontColorRef=" & $FontColorRef & @LF & _
									"FontAttribute=" & $FontAttribute & @LF
	IniWriteSection($DataFile, "FONT", $FontSTR)
EndFunc   ;==>_NewBase

Func _VerifyBase()		;	    
	Local $DataArray = IniReadSection($DataFile, "DATA")
	If @error Then
		$TipStack = 1
		$AllFiles = 0
		$RealFiles = 0
		$TextureFile = $DirRes & "texture.jpg"
		$wTrans = 255
		$EffectNum = 0
		$IconHeight = ""
		$AutoClose = 1
		$SoundOn = 0
		$ItemWidth = 200
	Else
		$TipStack = $DataArray[1][1]
		$AllFiles = $DataArray[2][1]
		$RealFiles = $DataArray[3][1]
		$TextureFile = $DataArray[4][1]
		$wTrans = $DataArray[5][1]
		$EffectNum = $DataArray[6][1]
		$IconHeight = $DataArray[7][1]
		$AutoClose = $DataArray[8][1]
		$SoundOn = $DataArray[9][1]
		$ItemWidth = $DataArray[10][1]
	EndIf
	$Effect1 = $EffectArray[$EffectNum][0]
	$Effect2 = $EffectArray[$EffectNum][1]
	If Not FileExists($TextureFile) Then $TextureFile = $DirRes & "texture.jpg"
	Local $FontArray = IniReadSection($DataFile, "FONT")
	If @error Then
		$FontName = "Tahoma"
		$FontSize = 14
		$FontWeight = 400
		$FontColorRef = 16777215
		$FontAttribute = 2
	Else
		$FontName = $FontArray[1][1]
		$FontSize = $FontArray[2][1]
		$FontWeight = $FontArray[3][1]
		$FontColorRef = $FontArray[4][1]
		$FontAttribute = $FontArray[5][1]
	EndIf

	$aColor = _ColorGetCOLORREF($FontColorRef)
	$FontColor = "0x" & Hex($aColor[0], 2) & Hex($aColor[1], 2) & Hex($aColor[2], 2)
	$FontBkColor = _CalcContrastColour($FontColor)
	Dim $Files = _FileListToArray($DirProgram)
	If @error = 4 Then _FilesNotFound()
	Dim $btn[$Files[0]][6]
	Local $FileNameArray = IniReadSection($DataFile, "FILE_NAME")
	If @error Then
		$error = True
		Return
	EndIf

	If $RealFiles <> $Files[0] Then
		$error = True
		Return
	EndIf

	$error = False
	Local $j = 0
	For $i = 1 To $Files[0]
		$FullPath = $DirProgram & $Files[$i]
		#cs
		If StringRegExpReplace($FullPath, '.*\.([^\\/:*?"<>|]+)', '\1') = "lnk" Then
			Opt('ExpandEnvStrings', 1)
			$PathLNK = FileGetShortcut($FullPath)
			Opt('ExpandEnvStrings', 0)
			If Not FileExists($PathLNK[0]) Then
				FileRecycle($FullPath)
				$error = True
			EndIf
		EndIf
		#ce
		If StringInStr(FileGetAttrib($FullPath), "H") Then ContinueLoop
		If StringInStr(FileGetAttrib($FullPath), "S") Then ContinueLoop
		$FileName = $FileNameArray[$j + 1][1]
		If $FileName <> $Files[$i] Then
			$error = True
			Return
		EndIf
		$btn[$j][1] = $FileName
		$btn[$j][2] = StringRegExpReplace($FileName, '^([^\\]+?)(?:\.[^.]+)?$', '\1') ;     
		$j += 1
	Next
EndFunc   ;==>_VerifyBase

Func SetBitmap($hGUI, $hImage, $iOpacity, $iWidth, $iHeight)
	Local $hScrDC, $hMemDC, $hBitmap, $hOld, $pSize, $tSize, $pSource, $tSource, $pBlend, $tBlend
	$hThumb = _GDIPlus_GetImageThumbnail($hImage, $iWidth, $iHeight)
	$hScrDC = _WinAPI_GetDC(0)
	$hMemDC = _WinAPI_CreateCompatibleDC($hScrDC)
	$hBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hThumb)
	$hOld = _WinAPI_SelectObject($hMemDC, $hBitmap)
	$tSize = DllStructCreate($tagSIZE)
	$pSize = DllStructGetPtr($tSize)
	DllStructSetData($tSize, "X", _GDIPlus_ImageGetWidth($hThumb))
	DllStructSetData($tSize, "Y", _GDIPlus_ImageGetHeight($hThumb))
	$tSource = DllStructCreate($tagPOINT)
	$pSource = DllStructGetPtr($tSource)
	$tBlend = DllStructCreate($tagBLENDFUNCTION)
	$pBlend = DllStructGetPtr($tBlend)
	DllStructSetData($tBlend, "Alpha", $iOpacity)
	DllStructSetData($tBlend, "Format", $AC_SRC_ALPHA)
	_WinAPI_UpdateLayeredWindow($hGUI, $hScrDC, 0, $pSize, $hMemDC, $pSource, 0, $pBlend, $ULW_ALPHA)
	_WinAPI_ReleaseDC(0, $hScrDC)
	_GDIPlus_ImageDispose($hThumb)
	_WinAPI_SelectObject($hMemDC, $hOld)
	_WinAPI_DeleteObject($hBitmap)
	_WinAPI_DeleteDC($hMemDC)
EndFunc   ;==>SetBitmap

Func _GDIPlus_GetImageThumbnail($hImage, $iWidth, $iHeight)
	Local $Ret = DllCall($ghGDIPDll, 'uint', 'GdipGetImageThumbnail', 'ptr', $hImage, 'uint', $iWidth, 'uint', $iHeight, 'ptr*', 0, 'ptr', 0, 'ptr', 0)
	If (@error) Or ($Ret[0]) Then
		Return SetError(@error, @extended, 0)
	EndIf
	Return $Ret[4]
EndFunc   ;==>_GDIPlus_GetImageThumbnail

;	    
Func _CreateShadowLabel($slText, $slX, $slY, $slWidth, $slHeight, $slStyle = $SS_LEFTNOWORDWRAP, $FontSize = 9, $FontWeight = 400, $FontAttribute = 0, $FontName = "Arial", $FontBkColor = 0x000000, $FontColor = 0xFFFFFF)
	GUICtrlCreateLabel("", $slX + 1, $slY, $slWidth, $slHeight, $slStyle)
	GUICtrlSetColor(-1, $FontBkColor)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetFont(-1, $FontSize, $FontWeight, $FontAttribute, $FontName)
	_GuiCtrlSetLabel(-1, $slText)

	GUICtrlCreateLabel($SmallName, $slX, $slY + 1, $slWidth, $slHeight, $slStyle)
	GUICtrlSetColor(-1, $FontBkColor)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetFont(-1, $FontSize, $FontWeight, $FontAttribute, $FontName)

	GUICtrlCreateLabel($SmallName, $slX + 1, $slY + 1, $slWidth, $slHeight, $slStyle)
	GUICtrlSetColor(-1, $FontBkColor)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetFont(-1, $FontSize, $FontWeight, $FontAttribute, $FontName)

	GUICtrlCreateLabel($SmallName, $slX, $slY, $slWidth, $slHeight, $slStyle)
	GUICtrlSetColor(-1, $FontColor)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetFont(-1, $FontSize, $FontWeight, $FontAttribute, $FontName)
EndFunc   ;==>_CreateShadowLabel

Func _GuiCtrlSetLabel($nID, $sPath, $iFit = 0)
	Local $hCtrl = GUICtrlGetHandle($nID)
	Local $hDC = _WinAPI_GetDC($hCtrl)
	Local $tPath = DllStructCreate("char[260]")
	Local $pPath = DllStructGetPtr($tPath)
	DllStructSetData($tPath, 1, $sPath)
	Local $hFont = _SendMessage($hCtrl, 49, 0, 0, 0, "wparam", "lparam", "hwnd") ;WM_GETFONT
	Local $hFont_old = _WinAPI_SelectObject($hDC, $hFont)
	Local $aPos = ControlGetPos($hCtrl, "", "")
	DllCall("Shlwapi.dll", "BOOL", "PathCompactPath", "handle", $hDC, "ptr", $pPath, "int", $aPos[2] - $iFit)
	_WinAPI_SelectObject($hDC, $hFont_old)
	_WinAPI_DeleteDC($hDC)
	$SmallName = DllStructGetData($tPath, 1)
	GUICtrlSetData($nID, DllStructGetData($tPath, 1))
	Return DllStructGetData($tPath, 1)
EndFunc   ;==>_GuiCtrlSetLabel

Func _LoadResourceImage($hInstance, $sResType, $sResName, $iResLanguage = 0)
	Local $hInfo, $hData, $pData, $iSize, $hMem, $pMem, $hStream, $hImage
	If $iResLanguage Then
		$hInfo = _WinAPI_FindResourceEx($hInstance, $sResType, $sResName, $iResLanguage)
	Else
		$hInfo = _WinAPI_FindResource($hInstance, $sResType, $sResName)
	EndIf
	$hData = _WinAPI_LoadResource($hInstance, $hInfo)
	$iSize = _WinAPI_SizeOfResource($hInstance, $hInfo)
	$pData = _WinAPI_LockResource($hData)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$hMem = DllCall("kernel32.dll", "ptr", "GlobalAlloc", "uint", 2, "ulong_ptr", $iSize)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$pMem = DllCall("kernel32.dll", "ptr", "GlobalLock", "ptr", $hMem[0])
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	DllCall("kernel32.dll", "none", "RtlMoveMemory", "ptr", $pMem[0], "ptr", $pData, "ulong_ptr", $iSize)
	DllCall("kernel32.dll", "int", "GlobalUnlock", "ptr", $hMem[0])
	$hStream = _WinAPI_CreateStreamOnHGlobal($hMem[0])
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	_GDIPlus_Startup()
	$hImage = DllCall("gdiplus.dll", "uint", "GdipCreateBitmapFromStream", "ptr", $hStream, "ptr*", 0)
	If (@error) Or ($hImage[0]) Or (Not $hImage[2]) Then
		$hImage = 0
	EndIf
	_GDIPlus_Shutdown()
	DllCall("kernel32.dll", "ptr", "GlobalFree", "ptr", $hMem[0])
	If Not IsArray($hImage) Then
		Return SetError(1, 0, 0)
	EndIf
	Return $hImage[2]
EndFunc   ;==>_LoadResourceImage

Func _GuiSetDropShadow($hWnd, $fDisrespectUser = True) ;	    
	If Not IsHWnd($hWnd) Then Return SetError(1, 1, 0)

	;check if hWnd is from current process
	Local $aResult = DllCall("User32.dll", "int", "GetWindowThreadProcessId", "hwnd", $hWnd, "int*", 0)
	If @error Or $aResult[2] <> @AutoItPID Then Return SetError(@error, 2, 0)

	If Not IsDeclared("SPI_GETDROPSHADOW") Then Local Const $SPI_GETDROPSHADOW = 0x1024
	If Not IsDeclared("SPI_SETDROPSHADOW") Then Local Const $SPI_SETDROPSHADOW = 0x1025
	If Not IsDeclared("CS_DROPSHADOW") Then Local Const $CS_DROPSHADOW = 0x00020000
	If Not IsDeclared("GCL_STYLE") Then Local Const $GCL_STYLE = -26

	$aResult = DllCall("user32.dll", "int", "SystemParametersInfo", "int", $SPI_GETDROPSHADOW, "int", 0, "int*", 0, "int", 0)
	Local $iErr = @error
	If $iErr Or Not IsArray($aResult) Then Return SetError($iErr, 3, 0)

	;if 'Show shadows under menus' option not set, try activating it.
	If Not $aResult[3] And $fDisrespectUser Then
		;turn on drop shadows
		$aResult = DllCall("user32.dll", "int", "SystemParametersInfo", "int", $SPI_SETDROPSHADOW, "int", 0, "int", True, "int", 0)
		$iErr = @error
		If $iErr Or Not IsArray($aResult) Or $aResult[0] <> 1 Then Return SetError($iErr, 4, 0)
	EndIf

	;get styles from WndClassEx struct
	$aResult = DllCall("user32.dll", "dword", "GetClassLong", "hwnd", $hWnd, "int", $GCL_STYLE)
	$iErr = @error
	If $iErr Or Not IsArray($aResult) Or Not $aResult[0] Then Return SetError($iErr, 5, 0)
	Local $OldStyle = $aResult[0]

	;add drop shadow style to styles
	Local $Style = BitOR($OldStyle, $CS_DROPSHADOW)

	If StringRight(@OSArch, 2) == "64" Then
		;if 64 bit windows (NOT TESTED)
		;see MSDN SetClassLong remarks
		;$aResult = DllCall("user32.dll", "ulong_ptr", "SetClassLongPtr", "hwnd", $hWnd, "int", $GCL_STYLE, "long_ptr", $Style)
		;$iErr = @error
		;If $iErr Or Not IsArray($aResult) Or Not $aResult[0] Then Return SetError($iErr, 6, 0)
	Else
		$aResult = DllCall("user32.dll", "dword", "SetClassLong", "hwnd", $hWnd, "int", $GCL_STYLE, "long", $Style)
		$iErr = @error
		If $iErr Or Not IsArray($aResult) Or Not $aResult[0] Then Return SetError($iErr, 7, 0)
		If $aResult[0] = $OldStyle Then Return SetError($iErr, 0, 1)
		Return SetError($iErr, 8, 0)
	EndIf
EndFunc   ;==>_GuiSetDropShadow

Func _CalcContrastColour($iColour, $iTolerance = 30) ;	     
	Switch $iTolerance
		Case 0 To 255
			$iTolerance = Int($iTolerance)
		Case Else
			$iTolerance = 30
	EndSwitch

	If (Abs(BitAND($iColour, 0xFF) - 0x80) <= $iTolerance And _
			Abs(BitAND(BitShift($iColour, 8), 0xFF) - 0x80) <= $iTolerance And _
			Abs(BitAND(BitShift($iColour, 16), 0xFF) - 0x80) <= $iTolerance) _
			Then Return BitAND((0x7F7F7F + $iColour), 0xFFFFFF)

	Return BitXOR($iColour, 0xFFFFFF)
EndFunc

Func WM_COMMAND($hWnd, $Msg, $wParam, $lParam) ;	  ""      
    #forceref $hWnd, $Msg
    Local $nNotifyCode = BitShift($wParam, 16)
    Local $nID = BitAND($wParam, 0x0000FFFF)
    Local $hCtrl = $lParam
    Switch $hCtrl
        Case $hbtnOption
            Switch $nNotifyCode
				Case $BN_CLICKED
					$aPos = ControlGetPos($Window, "", $btnOption)
					Local $tpoint = DllStructCreate("int X;int Y")
					DllStructSetData($tpoint, "X", $aPos[0] -120)
					DllStructSetData($tpoint, "Y", $aPos[1] + $aPos[3])
					_WinAPI_ClientToScreen($Window, $tpoint)
					_GUICtrlMenu_TrackPopupMenu($hMenu, $Window, DllStructGetData($tpoint, "X"), DllStructGetData($tpoint, "Y"), 1)
            EndSwitch
            Return 0 ; Only workout clicking on the button
    EndSwitch
    Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_COMMAND

Func _SetOLBlueColors() ;	   ""
	_SetMenuBkColor(0xFFFFFF)
	_SetMenuIconBkColor(0xFFEFE3)
	_SetMenuIconBkGrdColor(0xE4AD87)
	_SetMenuSelectBkColor(0xC2EEFF)
	_SetMenuSelectRectColor(0x800000)
	_SetMenuSelectTextColor(0x000000)
	_SetMenuTextColor(0x000000)
EndFunc

Func _TextSize($sString, $iSize = 9, $iWeight = 400, $sFontName = "Tahoma")
	Local $hWnd, $hGuiSwitch, $aCtrlSize, $aRetSize[2] = [0, 0]

	$hWnd = GUICreate($sString, 0, 0, 0, 0, BitOR(0x80000000, 0x20000000), BitOR(0x00000080, 0x00000020))
	$hGuiSwitch = GUISwitch($hWnd)
	GUISetFont($iSize, $iWeight, -1, $sFontName, $hWnd)
	$aCtrlSize = ControlGetPos($hWnd, "", GUICtrlCreateLabel($sString, 0, 0))
	GUIDelete($hWnd)
	GUISwitch($hGuiSwitch)

	If IsArray($aCtrlSize) Then
		$aRetSize[0] = $aCtrlSize[2]; Width
		$aRetSize[1] = $aCtrlSize[3]; Height
		Return SetError(0, 0, $aRetSize)
	EndIf
	Return SetError(1, 0, $aRetSize)
EndFunc

Func _Perebor() ;	     ,  ...
	If $TipStack = 1 And IniRead($DataFile, "DATA", "Width", "") > 160 Then
		RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload", "REG_SZ", 1)
		IniWrite($DataFile, "DATA", "Width", 160)
		IniWrite($DataFile, "FONT", "FontSize", 9)
		IniWrite($DataFile, "FONT", "FontWeight", 400)
		ShellExecute(@ScriptFullPath, Chr(34) & $DirProgram & Chr(34) & " " & Chr(34) & $NameStack & Chr(34))
		Exit
	ElseIf $TipStack = 2 And IniRead($DataFile, "DATA", "IconSize", "") > 24 Then
		RegWrite("HKEY_CURRENT_USER\Software\MyStacks\Data", "Reload", "REG_SZ", 1)
		IniWrite($DataFile, "DATA", "IconSize", "")
		ShellExecute(@ScriptFullPath, Chr(34) & $DirProgram & Chr(34) & " " & Chr(34) & $NameStack & Chr(34))
		Exit
	EndIf
	If $SoundOn = 1 Then _WinAPI_PlaySound("ERROR", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
	$mess = _ExtMsgBox(16, "|", "!", "     ." & @LF & "     ?" & @LF)
	If $mess = 1 Then ShellExecute($DirProgram)
	Exit
EndFunc

Func _FilesNotFound()
	If $SoundOn = 1 Then _WinAPI_PlaySound("ERROR", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
	_ExtMsgBoxSet(1 + 32, 1, -1, -1, 11, "Tahoma")
	$mess = _ExtMsgBox(16, "|", "!", "  ." & @LF & "  ?" & @LF)
	If $mess = 1 Then ShellExecute($DirProgram)
	Exit
EndFunc
