#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Resources\icon_creator.ico
#AutoIt3Wrapper_Outfile=C:\Program Files\My Stacks\StackCreator.exe
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Description=Program for create shortcuts for your stacks
#AutoIt3Wrapper_Res_Fileversion=0.3.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Bytek
#AutoIt3Wrapper_Res_Language=1049
#AutoIt3Wrapper_Res_Field=Version|0.3.0
#AutoIt3Wrapper_Res_Field=Build|2014.04.10
#AutoIt3Wrapper_Res_Field=Coded by|Bytek
#AutoIt3Wrapper_Res_Field=CompanyName|Bytek_Soft
#AutoIt3Wrapper_Res_Field=Compile date|%longdate% %time%
#AutoIt3Wrapper_Res_Field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_Run_AU3Check=n
#AutoIt3Wrapper_Res_File_Add=Resources\ok.wav, WAVE, OK
#AutoIt3Wrapper_Res_File_Add=Resources\error.wav, WAVE, ERROR
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#NoTrayIcon

#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <File.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include "WinAPIEx.au3"
#include <WindowsConstants.au3>

#include <Includes\ExtMsgBox.au3>

If WinExists(@ScriptName) Then Exit
AutoItWinSetTitle(@ScriptName)

Opt("GUICloseOnESC", 0)

Global Const $SND_ASYNC = 0x00000001
Global Const $SND_NOWAIT = 0x00002000
Global Const $SND_RESOURCE = 0x00040004
Global $iconPath = @ScriptDir &"\Resources\Icons.icl", $iconIdx = 3
Global $fileStack = @ScriptDir &"\stack.exe"
Global $font = "Verdana"
Global $DirStack = ""
Global $NameStack = " "
Global $TipStack = 1	;  : 1 - ; 2 - 
Global $WinPos[2]
Global $ConfigFile = @ScriptDir & "\config.cfg"
Global $DirBase = @ScriptDir & "\Data\"
Global $TextureFile = @ScriptDir & "\Resources\texture.jpg"
Global $hInstance = _WinAPI_GetModuleHandleEx(0)

_ExtMsgBoxSet(1 + 32, 1, -1, -1, 11, "Tahoma")

If Not FileExists($fileStack) Then
	_WinAPI_PlaySound("ERROR", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
	_ExtMsgBox(16, " OK", "!!!", "   - stack.exe!" & @LF & "  !" & @LF)
	Exit
EndIf

If Not FileExists($iconPath) Then $iconPath = @SystemDir & "\shell32.dll"

$WinPos[0]  = IniRead($ConfigFile, "DATA", "WindowPosX", "")
$WinPos[1]  = IniRead($ConfigFile, "DATA", "WindowPosY", "")
If $WinPos[0] = "" Or $WinPos[1] = "" Then
	$WinPos[0]  = -1
	$WinPos[1]  = -1
EndIf

$Window = GUICreate("", 462,258, $WinPos[0], $WinPos[1])
GUISetFont(11, 400, 0, $font)
WinSetTitle($Window, "", "My Stack Creator 3.0")
	GUICtrlCreateLabel("   ", 10, 10, 200, 20, $SS_LEFTNOWORDWRAP)
$DirInput = GUICtrlCreateInput($DirStack, 26, 30, 382, 26, $ES_AUTOHSCROLL)
$DirButton = GUICtrlCreateButton("...", 414, 30, 26, 26)
	GUICtrlSetCursor(-1, 0)
	GUICtrlCreateLabel(" ", 10, 56, 412, 20, $SS_LEFTNOWORDWRAP)
$NameInput = GUICtrlCreateInput($NameStack, 26, 76, 412, 26, $ES_AUTOHSCROLL)
	GUICtrlCreateLabel(" ", 10, 102, 412, 20, $SS_LEFTNOWORDWRAP)
$Input3 = GUICtrlCreateInput(" ", 26, 122, 352, 26, $ES_AUTOHSCROLL)
$iconPrew = GUICtrlCreateIcon($iconPath,  -($iconIdx + ($iconIdx > -1)), 384, 122 ,26 ,26)
$IconButton = GUICtrlCreateButton("...", 414, 122, 26, 26)
	GUICtrlSetCursor(-1, 0)

	GUICtrlCreateLabel("  :", 10, 148, 160, 20, $SS_LEFTNOWORDWRAP)
$StackButton = GUICtrlCreateRadio("", 26, 168, 80, 26)
	GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetCursor(-1, 0)
$GridButton = GUICtrlCreateRadio("", 120, 168, 90, 26)
	GUICtrlSetCursor(-1, 0)
$CreateButton = GUICtrlCreateButton(" ", 26, 210, 198, 32)
	GUICtrlSetCursor(-1, 0)
$ExitButton = GUICtrlCreateButton("  ", 236, 210, 198, 32)
	GUICtrlSetCursor(-1, 0)

GUISetState(@SW_SHOW)
While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			_Exit()
		Case $DirButton
			$DirStack = FileSelectFolder(" ", "", 2, $DirStack, $Window)
			GUICtrlSetData($DirInput, $DirStack)
			$db1 = StringSplit($DirStack, "\")
			$last = $db1[0]
			$NameStack = $db1[$last]
			GUICtrlSetData($NameInput, $NameStack)
		Case $IconButton
			_IconChooser()
			GUICtrlSetData($Input3, $iconPath& ", " & $iconidx)
			GUICtrlSetImage($iconPrew, $iconPath, -($iconIdx + ($iconIdx > -1)))
			GUISetState(@SW_HIDE, $Window)
			GUISetState(@SW_SHOW, $Window)
		Case $CreateButton
			$name = GUICtrlRead($NameInput)
			If $name = ""  Then $name = " "
			If $DirStack <> "" Then
				If GUICtrlRead($StackButton) = $GUI_CHECKED Then
					$TipStack = 1
				Else
					$TipStack = 2
				EndIf
				If StringRight($DirStack, 1) = "\" Then $DirStack = StringTrimRight($DirStack, 1)
				FileCreateShortcut($fileStack _
				, @DesktopDir & "\" & $name & ".lnk" _
				, "" _
				, " " & Chr(34) & $DirStack & "\" & Chr(34) & " " & Chr(34) & $name & Chr(34) _
				, $name, $iconPath, -1, $iconIdx)
				DirCreate($DirBase & $name)
				$DataFile = $DirBase & $name & "\data.cfg"
				$DataSTR = "TIP=" & $TipStack & @LF & _
									"FILES=" & 0 & @LF & _
									"ALL_FILES=" & 0 & @LF & _
									"Texture=" & $TextureFile & @LF & _
									"Transparent=" & 255 & @LF & _
									"EffectNum=" & 0 & @LF & _
									"IconSize=" & "" & @LF & _
									"AutoClose=" & 1 & @LF & _
									"SoundOn=" & 0 & @LF & _
									"Width=" & 200 & @LF
				IniWriteSection($DataFile, "DATA", $DataSTR)
				Switch $TipStack
					Case 1
						$FontName = "Tahoma"
						$FontSize = 14
						$FontWeight = 400
						$FontColorRef = 16777215
						$FontAttribute = 2
					Case 2
						$FontName = "Comic Sans MS"
						$FontSize = 9
						$FontWeight = 400
						$FontColorRef = 16777215
						$FontAttribute = 0
				EndSwitch
				$FontSTR = "FontName=" & $FontName & @LF & _
									"FontSize=" & $FontSize & @LF & _
									"FontWeight=" & $FontWeight & @LF & _
									"FontColorRef=" & $FontColorRef & @LF & _
									"FontAttribute=" & $FontAttribute & @LF
				IniWriteSection($DataFile, "FONT", $FontSTR)

				_WinAPI_PlaySound("OK", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
				_ExtMsgBox(64, " OK", "", "   " & @LF & "  ." & @LF, 5, $Window)
			Else
				_WinAPI_PlaySound("ERROR", BitOR($SND_ASYNC, $SND_NOWAIT, $SND_RESOURCE), $hInstance)
			EndIf
		Case $ExitButton
			_Exit()
	EndSwitch
WEnd

Func _Exit()	;        
	$WinPos = WinGetPos($Window)
	IniWrite($ConfigFile, "DATA", "WindowPosX", $WinPos[0])
	IniWrite($ConfigFile, "DATA", "WindowPosY", $WinPos[1])
	GUIDelete($Window)
	Exit
EndFunc

Func _IconChooser()
	GUISetState(@SW_DISABLE, $Window)
	;   
	$stIcon = DllStructCreate('int') ;   
	;     Unicode
		$nBuffersize = DllCall('KERNEL32.DLL', _
                       'int','MultiByteToWideChar', _
                       'int', 0, _
                       'int', 0x00000001, _
                       'str', $iconPath, _
                       'int', -1, _
                       'ptr', 0, _
                       'int', 0)
		$stString = DLLStructCreate("byte[" & 2 * $nBuffersize[0] & "]")
	DllCall('KERNEL32.DLL', _
			'int', 'MultiByteToWideChar', _
			'int', 0, _
			'int', 0x00000001, _
			'str', $iconPath, _
			'int', -1, _
			'ptr', DllStructGetPtr($stString), _
			'int', $nBuffersize[0])
	;    
	DllCall('SHELL32.DLL', _
			'none', 62, _
			'hwnd', 0, _
			'ptr', DllStructGetPtr($stString), _
			'int', DllStructGetSize($stString), _
			'ptr', DllStructGetPtr($stIcon))
	;       
	$nBuffersize = DllCall('KERNEL32.DLL', _
			'int', 'WideCharToMultiByte', _
			'int', 0, _
			'int', 0x00000200, _
			'ptr', DllStructGetPtr($stString), _
			'int', -1, _
			'ptr', 0, _
			'int', 0, _
			'ptr', 0, _
			'ptr', 0)
	$stFile = DLLStructCreate('char[' & $nBuffersize[0] & ']')
DllCall('KERNEL32.DLL', _
			'int', 'WideCharToMultiByte', _
			'int', 0, _
			'int', 0x00000200, _
			'ptr', DllStructGetPtr($stString), _
			'int', -1, _
			'ptr', DllStructGetPtr($stFile), _
			'int', $nBuffersize[0], _
			'ptr', 0, _
			'ptr', 0)
	$iconPath = DllStructGetData($stFile, 1)
	$iconidx = DllStructGetData($stIcon, 1) ;  
	GUISetState(@SW_ENABLE, $Window)
	WinActivate($Window)
EndFunc
