#Notrayicon
#Region
#AutoIt3Wrapper_Icon=Icon.ico
#AutoIt3Wrapper_OutFile=DebugReader.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_ProductVersion=1.0.0.0
#AutoIt3Wrapper_Res_FileVersion_AutoIncrement=N
#AutoIt3Wrapper_UseUpx=N
#AutoIt3Wrapper_Res_Comment=AutoIt Script Debug Reader
#AutoIt3Wrapper_Res_Description=AutoIt Script Debug Reader
#AutoIt3Wrapper_Res_Language=1049
#AutoIt3Wrapper_Res_LegalCopyright=Astel064
#AutoIt3Wrapper_res_requestedExecutionLevel=highestAvailable
#AutoIt3Wrapper_Res_Field= |%date% (%time%)
#AutoIt3Wrapper_Change2CUI=N
#EndRegion

#include <_UpdateExplorer.inc>
;================================================
	If $CmdLineRaw = "/Reg" Then
	RegWrite ( "HKEY_CLASSES_ROOT\.autdeb", "", "REG_SZ", "autdeb_auto_file" )
	RegWrite ( "HKEY_CLASSES_ROOT\autdeb_auto_file\shell\open\command", "", "REG_SZ", '"'&@ScriptFullPath&'" "%1"' )
	_UpdateExplorer()
	Exit
	EndIf
;================================================
	If $CmdLineRaw = "/Unreg" Then
	RegDelete ( "HKEY_CLASSES_ROOT\.autdeb" )
	RegDelete ( "HKEY_CLASSES_ROOT\autdeb_auto_file" )
	_UpdateExplorer()
	Exit
	EndIf

;================================================


#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <GuiStatusBar.au3>
#include <ListViewConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <GuiListView.au3>
#include <PuthsExtract.inc>


Global $iOpenPart=0, $iOldPart=0, $sDedlogFile="", $iSellectIndex=-1, $iFocus=-1
	If $CmdLine[0] > 0 Then
	$sDedlogFile=$CmdLine[1]
	Else
	$sDedlogFile=FileOpenDialog ( "  ...", "", "   (*.autdeb)|  (*.*)", 1, "" )
		If @Error Then Exit
	EndIF

Opt("GUIOnEventMode", 1)
$hWnd = GUICreate(" (Reader)", 618, 568, 192, 124)
	GUISetOnEvent(-3, "_EventExit")

$hListView = GUICtrlCreateListView("|0|0||0|0| ", 0, 0, 616, 518)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 0, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 1, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 2, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 3, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 4, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 5, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 6, 1500)

$hStatusBar = _GUICtrlStatusBar_Create($hWnd)
Dim $hStatusBar_PartsWidth[4] = [270, 390, 510, -1]
	_GUICtrlStatusBar_SetParts($hStatusBar, $hStatusBar_PartsWidth)
	_GUICtrlStatusBar_SetText($hStatusBar, "     ...", 0)
	_GUICtrlStatusBar_SetText($hStatusBar, ": ?", 1)
	_GUICtrlStatusBar_SetText($hStatusBar, ": ?", 2)
	_GUICtrlStatusBar_SetText($hStatusBar, " : 0", 3)

$hLabPart = GUICtrlCreateLabel(":", 8, 528, 38, 17)
$hPart = GUICtrlCreateInput("1", 56, 523, 49, 21, BitOR($GUI_SS_DEFAULT_INPUT,$ES_NUMBER))
	$hUpdown = GUICtrlCreateUpdown ( $hPart, 0x20 )
$bPart = GUICtrlCreateButton("OK", 110, 522, 51, 22, 1)
	GUICtrlSetOnEvent(-1, "_EventOpenPart")

$bInfo = GUICtrlCreateButton("", 524, 520, 91, 25)
	GUICtrlSetOnEvent(-1, "_EventInfo")

GUICtrlSetState ( $hListView, $GUI_DISABLE )
GUICtrlSetState ( $hLabPart, $GUI_DISABLE )
GUICtrlSetState ( $hPart, $GUI_DISABLE )
GUICtrlSetState ( $bPart, $GUI_DISABLE )
GUICtrlSetState ( $bInfo, $GUI_DISABLE )

GUISetState(@SW_SHOW)
_Startup()
While 1
	If $iOpenPart <> $iOldPart Then
	$iOldPart = $iOpenPart
	_PartOpenFunc($iOpenPart)
	EndIF
WEnd


Func _EventExit()
_GUICtrlListView_Scroll($hListView, 0, -10000000)
GUICtrlSetState ( $hListView, $GUI_DISABLE )
GUICtrlSetState ( $hLabPart, $GUI_DISABLE )
GUICtrlSetState ( $hPart, $GUI_DISABLE )
GUICtrlSetState ( $bPart, $GUI_DISABLE )
GUICtrlSetState ( $bInfo, $GUI_DISABLE )
_GUICtrlStatusBar_SetText($hStatusBar, "...", 0)
_GUICtrlListView_DeleteAllItems($hListView)
Exit
EndFunc


Func _EventInfo()
Local $iControl, $sControl, $aSplit
$iControl = GUICtrlRead($hListView)
$sControl = GUICtrlRead($iControl)
	If $iControl < 1 Then
	MsgBox(48,"","     !" & @CRLF & "" & @CRLF & "   ,     ", 0, $hWnd)
	Return 0
	EndIF
$aSplit = StringSplit ( $sControl, "|" )
	If @Error OR $aSplit[0] < 7 Then
	MsgBox(48,"","  ", 0, $hWnd)
	Return 0
	EndIF
MsgBox(64,"","---  ---" & @CRLF & " : "&$aSplit[4]&"" & @CRLF & " : "&$aSplit[1]&"", 0, $hWnd)
Return 1
EndFunc


Func _EventOpenPart()
$iOpenPart = GUICtrlRead($hPart)
EndFunc



Func _PartOpenFunc($iPart)
_GUICtrlListView_Scroll($hListView, 0, -10000000)
GUICtrlSetState ( $hListView, $GUI_DISABLE )
GUICtrlSetState ( $hLabPart, $GUI_DISABLE )
GUICtrlSetState ( $hPart, $GUI_DISABLE )
GUICtrlSetState ( $bPart, $GUI_DISABLE )
GUICtrlSetState ( $bInfo, $GUI_DISABLE )
_GUICtrlStatusBar_SetText($hStatusBar, " ...", 0)
	_LvReCreate()
	
	$iSellectIndex = -1
	$iFocus = -1
	Local $sDir, $hFile, $sLine, $sColor=0, $iCtrl
	
	$sDir = _PuthEx_Folder($sDedlogFile)
		If $sDir <> "" Then $sDir &= "\"
	$hFile = FileOpen ( $sDir&$iPart&".log", 0 )
		If $hFile = -1 Then
		MsgBox(48,"","   !", 0, $hWnd)
		GUICtrlSetState ( $hLabPart, $GUI_ENABLE )
		GUICtrlSetState ( $hPart, $GUI_ENABLE )
		GUICtrlSetState ( $bPart, $GUI_ENABLE )
		_GUICtrlStatusBar_SetText($hStatusBar, " !", 0)
		$iOpenPart=0
		$iOldPart=0
		Return 0
		EndIF
	While 1
	$sLine = FileReadLine ( $hFile )
		If @error Then ExitLoop
	$sLine = StringReplace ( $sLine, @CR, "" )
	$sLine = StringReplace ( $sLine, @LF, "" )
		If StringLeft($sLine, 19) = ">> Script Startup: " Then
		ElseIF StringLeft($sLine, 20) = ">> Script Shutdown: " Then
		$sColor=0xFF0000
		GUICtrlSetBKColor ( -1, 0xFFD8B0)
		Else
		$iCtrl = GUICtrlCreateListViewItem ( $sLine, $hListView )
			If $sColor <> 0 Then 
			GUICtrlSetColor ( -1, $sColor)
			Else
			$iSellectIndex += 1
			$iFocus = $iCtrl
			EndIF
		EndIF
	Wend
	FileClose ( $hFile )
	_GUICtrlListView_HideColumn($hListView, 0)
	_GUICtrlListView_HideColumn($hListView, 1)
	_GUICtrlListView_HideColumn($hListView, 2)
	_GUICtrlListView_HideColumn($hListView, 3)
	_GUICtrlListView_HideColumn($hListView, 4)
	_GUICtrlListView_HideColumn($hListView, 5)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 6, 1500)

GUICtrlSetState ( $hListView, $GUI_ENABLE )
GUICtrlSetState ( $hLabPart, $GUI_ENABLE )
GUICtrlSetState ( $hPart, $GUI_ENABLE )
GUICtrlSetState ( $bPart, $GUI_ENABLE )
GUICtrlSetState ( $bInfo, $GUI_ENABLE )
	If $iSellectIndex > -1 Then _GUICtrlListView_SetItemSelected($hListView, $iSellectIndex)
	If $iFocus <> -1 Then GUICtrlSetState ( $iFocus, $GUI_FOCUS )
	_GUICtrlListView_Scroll($hListView, 0, ($iSellectIndex+1)*16)
_GUICtrlStatusBar_SetText($hStatusBar, "", 0)
EndFunc




Func _Startup()
_GUICtrlStatusBar_SetText($hStatusBar, "     ...", 0)
Local $var, $iAll, $hFile, $sDir
$var = IniReadSection($sDedlogFile, "Parts")
	If @error Then 
	    MsgBox(16,"","  !", 0, $hWnd)
	    Exit
	Else
		$iAll = $var[0][0]
		$var = 0
		_GUICtrlStatusBar_SetText($hStatusBar, " : "&$iAll, 3)
		$sDir = _PuthEx_Folder($sDedlogFile)
			If $sDir <> "" Then $sDir &= "\"
		For $i = 1 To $iAll
			$hFile = FileOpen ( $sDir&$i&".log", 0 )
				If $hFile = -1 Then
				MsgBox(48,"","  "&$i&"  !", 0, $hWnd)
				ContinueLoop
				EndIF
	
			While 1
			$sLine = FileReadLine ( $hFile )
				If @error Then ExitLoop
			$sLine = StringReplace ( $sLine, @CR, "" )
			$sLine = StringReplace ( $sLine, @LF, "" )
				If StringLeft($sLine, 19) = ">> Script Startup: " Then
				_GUICtrlStatusBar_SetText($hStatusBar, ": "&StringTrimLeft($sLine, 19), 1)
				ElseIF StringLeft($sLine, 20) = ">> Script Shutdown: " Then
				_GUICtrlStatusBar_SetText($hStatusBar, ": "&StringTrimLeft($sLine, 20), 2)
				EndIF
			Wend
			FileClose ( $hFile )
		Next
	EndIf
GUICtrlSetLimit ( $hPart, $iAll, 1 )
GUICtrlSetLimit ( $hUpdown, $iAll, 1 )
GUICtrlSetData ( $hPart, $iAll )
_GUICtrlStatusBar_SetText($hStatusBar, "...", 0)
_EventOpenPart()
EndFunc




Func _LvReCreate()
_GUICtrlListView_DeleteAllItems($hListView)
GUICtrlDelete ( $hListView )
$hListView = GUICtrlCreateListView("|0|0||0|0| ", 0, 0, 616, 518)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 0, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 1, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 2, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 3, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 4, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 5, 0)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 6, 1500)
EndFunc