#Notrayicon
#Region
#AutoIt3Wrapper_Icon=Icon.ico
#AutoIt3Wrapper_OutFile=DebugCreator.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_ProductVersion=1.0.0.0
#AutoIt3Wrapper_Res_FileVersion_AutoIncrement=N
#AutoIt3Wrapper_UseUpx=N
#AutoIt3Wrapper_Res_Comment=AutoIt Script Debug Creator
#AutoIt3Wrapper_Res_Description=AutoIt Script Debug Creator
#AutoIt3Wrapper_Res_Language=1049
#AutoIt3Wrapper_Res_LegalCopyright=Astel064
#AutoIt3Wrapper_res_requestedExecutionLevel=highestAvailable
#AutoIt3Wrapper_Res_Field= |%date% (%time%)
#AutoIt3Wrapper_Change2CUI=Y
#EndRegion

#include <_UpdateExplorer.inc>
;================================================
	If $CmdLineRaw = "/Reg" Then
	$Read = RegRead ( "HKEY_CLASSES_ROOT\.au3", "" )
		If @Error Then
		MsgBox(16,"","  , ..   .au3  (Err1)")
		Exit
		EndIF
	$sKey = "HKEY_CLASSES_ROOT\"&$Read
	RegRead ( $sKey, "" )
		If @Error Then
		MsgBox(16,"","  , ..   .au3  (Err2)")
		Exit
		EndIF
	$sKey  &= "\shell\Debug"
	RegWrite ( $sKey, "", "REG_SZ", "  " )
	RegWrite ( $sKey&"\command", "", "REG_SZ", '"'&@ScriptFullPath&'" "%1"' )
	_UpdateExplorer()
	Exit
	EndIf
;================================================
	If $CmdLineRaw = "/Unreg" Then
	$Read = RegRead ( "HKEY_CLASSES_ROOT\.au3", "" )
		If @Error Then
		MsgBox(16,"","  , ..   .au3  (Err1)")
		Exit
		EndIF
	$sKey = "HKEY_CLASSES_ROOT\"&$Read
	RegRead ( $sKey, "" )
		If @Error Then
		MsgBox(16,"","  , ..   .au3  (Err2)")
		Exit
		EndIF
	$sKey  &= "\shell\Debug"
	RegDelete ( $sKey )
	_UpdateExplorer()
	Exit
	EndIf

;================================================

Global $hWnd = WinGetHandle ( @ScriptFullPath )
WinSetTitle ( $hWnd, "", "" )
#include <string.au3>
#include <PuthsExtract.inc>
#include <Crypt.au3>
#include <ConvertFileSize.inc>
Global $sOutFileName, $sInFile, $hOutFileName

If $CmdLine[0] < 1 Then
$sInFile = FileOpenDialog ( " ...", "", "  AutoIt (*.au3)|  (*.*)", 1, "" )
	If @Error Then Exit
Else
$sInFile = $CmdLine[1]
EndIF

If $CmdLine[0] < 2 Then
Local $sDefaultName = StringTrimRight( $sInFile, 1+StringLen(_PuthEx_FileMask($sInFile)) )&"_Debug.au3"
$sOutFileName = FileSaveDialog ( "  ...", "", "  AutoIt (*.au3)|  (*.*)", 18, $sDefaultName )
	If @Error Then Exit
Else
$sOutFileName = $CmdLine[2]
EndIF


$hOutFileName = FileOpen ( $sOutFileName, 2 )
Global $sAddedFiles  = "", $sEndStringLine = "", $iNCLines=0, $iYCLines=0




FileWriteLine ( $hOutFileName, ";Debug created: "&@MDAY&"\"&@MON&"\"&@YEAR&" "&@HOUR&"-"&@MIN&"-"&@SEC&","&@MSEC&@CRLF&FileRead( @ScriptDir&"\Creator.Template" ) )
AdlibRegister("_MyAdlib", 250)
$sStartTime = @HOUR&"-"&@MIN&"-"&@SEC&","&@MSEC
	_AutoitDebug_ReadFile($sInFile)
	FileClose ( $hOutFileName )
	$iNCSize = _ConvertFileSize(FileGetSize($sOutFileName))
	_AutoitDebug_EndParsing($sOutFileName)
	$iYCSize = _ConvertFileSize(FileGetSize($sOutFileName))
AdlibUnRegister("_MyAdlib")
_MyAdlib()
MsgBox(64,"","     : "&$sOutFileName&"" & @CRLF & "" & @CRLF & ": "&$iNCSize&" (- : "&$iNCLines&")" & @CRLF & ": "&$iYCSize&" (- : "&$iYCLines&")" & @CRLF & "" & @CRLF & " : "&$sStartTime&"" & @CRLF & " : "&@HOUR&"-"&@MIN&"-"&@SEC&","&@MSEC&"")
Exit


;	_AutoitDebug_WriteDataToConsole($vData)		_AutoitDebug_WriteDataToConsole()
;	#NotAutoItDebugEnable



Func _MyAdlib()
WinSetTitle ( $hWnd, "", " ("&_ConvertFileSize(FileGetSize($sOutFileName))&")" )
EndFunc





Func _AutoitDebug_ReadFile($sFile)
Local $hFile, $sRead, $aSplit, $i, $sIncludeFile, $aTempSplit, $sWorkDir, $vHash, $sWrite
$sWorkDir = _PuthEx_Folder($sFile)
	If $sWorkDir <> "" Then FileChangeDir ( $sWorkDir )
;ConsoleWrite ( _Encoding_ANSIToOEM(": "&$sFile)&@CRLF )



$hFile =  FileOpen ( $sFile, 0 )
$sRead = FileRead ( $hFile )
	If @Error Then Return SetError (-1,0,0)
FileClose ( $hFile )
		If StringRegExp ( $sRead, "#NotAutoItDebugEnable", 0 ) > 0 Then 
		FileWriteLine ( $hOutFileName, @CRLF&$sRead )
		Return 0
		EndIF

	StringReplace ( $sAddedFiles, "|"&$sFile&FileGetSize($sFile)&"|", "" )
		If @Extended > 0 Then Return 0
	$sAddedFiles  &= "|"&$sFile&FileGetSize($sFile)&"|"

$aSplit = StringSplit ( $sRead, @CRLF, 1 )
	If @Error OR $aSplit[0] < 2 Then
	FileWriteLine ( $hOutFileName, $sRead )
	Return SetError (-2,0,0)
	EndIF

For $i = 1 To $aSplit[0]
ConsoleWrite ( _Encoding_ANSIToOEM("Create *** "&$sFile&"|||"&$i&"|||"&$aSplit[$i])&@CRLF&@CRLF )
$sWrite = $aSplit[$i]
While 1
If StringRegExp ( $aSplit[$i], "#include-once", 0 ) > 0 Then ExitLoop
If StringRegExp ( $aSplit[$i], "#include", 0 ) < 1 Then ExitLoop
$aTempSplit = StringSplit ( $aSplit[$i], "#include", 1 )
	If @Error OR $aTempSplit[0] < 2 Then ExitLoop
	If StringRegExp ( $aTempSplit[1], ";", 0 ) > 0 Then ExitLoop

$sIncludeFile = _AutoitDebug_ParsingLine($aTempSplit[2])
	If @Error Then ExitLoop


	If FileExists( _PuthEx_Folder($sFile)&"\"&$sIncludeFile ) Then
	FileWriteLine ( $hOutFileName, @CRLF&"_AutoitDebug_WriteDataToConsole('0x"&_StringToHex($sFile&"|||"&$i&"|||"&$aSplit[$i])&"')" )
	$sWrite = ""
	_AutoitDebug_ReadFile(_PuthEx_Folder($sFile)&"\"&$sIncludeFile)
	Else
	FileWriteLine ( $hOutFileName, @CRLF&"_AutoitDebug_WriteDataToConsole('0x"&_StringToHex($sFile&"|||"&$i&"|||"&$aSplit[$i])&"')" )
	FileWriteLine ( $hOutFileName, $aSplit[$i] )
	$sWrite = ""
	$sEndStringLine = ""
	EndIF
ExitLoop
Wend
	If $sWrite <> "" Then
		If _CheckEndOfLine() Then FileWriteLine ( $hOutFileName, @CRLF&"_AutoitDebug_WriteDataToConsole('0x"&_StringToHex($sFile&"|||"&$i&"|||"&$aSplit[$i])&"')" )
		FileWriteLine ( $hOutFileName, $aSplit[$i] )
		$sEndStringLine = $aSplit[$i]
	EndIF	
Next
EndFunc














Func _AutoitDebug_ParsingLine($sLine)
Local $sReturn = "", $iStart = 0
	If StringLen ($sLine) < 1 Then Return SetError(1,0,0)

While 1
	While 1
	If NOT $iStart Then
		If StringLeft( $sLine, 1 ) = '<' OR StringLeft( $sLine, 1 ) = '"' OR StringLeft( $sLine, 1 ) = "'" Then $iStart = 1
		$sLine = StringTrimLeft( $sLine, 1 )
	Else
	If StringLeft( $sLine, 1 ) = '>' OR StringLeft( $sLine, 1 ) = '"' OR StringLeft( $sLine, 1 ) = "'" Then ExitLoop 2
	$sReturn &= StringLeft( $sLine, 1 )
	$sLine = StringTrimLeft( $sLine, 1 )
	EndIf
	If $sLine = "" Then ExitLoop 1
	Wend
Return SetError(2,0,0)
Wend
	If $sReturn = "" Then Return SetError(3,0,0)
Return SetError(0,0,$sReturn)
EndFunc







Func _AutoitDebug_EndParsing($sFile)
Local $hFile, $sRead, $aSplit, $iCommentStart = 0
ConsoleWrite ( _Encoding_ANSIToOEM("Eng parsing: "&$sFile)&@CRLF )

$hFile =  FileOpen ( $sFile, 0 )
$sRead = FileRead ( $hFile )
	If @Error Then
	FileClose ( $hFile )
	Return 0
	EndIf
FileClose ( $hFile )

$aSplit = StringSplit ( $sRead, @CRLF, 1 )
	If @Error OR $aSplit[0] < 2 Then Return 0
	$iNCLines = $aSplit[0]

$hFile =  FileOpen ( $sFile, 2 )
For $i = 1 To $aSplit[0]
	ConsoleWrite ( _Encoding_ANSIToOEM("Conpress *** "&"Line "&$i&":   "&$aSplit[$i])&@CRLF )
	If $aSplit[$i] = "" Then ContinueLoop
	While 1
	If $iCommentStart < 1 Then
		If StringLeft( $aSplit[$i], 1 ) = " " OR StringLeft( $aSplit[$i], 1 ) = "	" Then
		$aSplit[$i] = StringTrimLeft( $aSplit[$i], 1 )
		ElseIf StringLeft( $aSplit[$i], 1 ) = ";" Then
		ExitLoop
		ElseIf StringRegExp ( $aSplit[$i], "#CS", 0 ) > 0 OR StringRegExp ( $aSplit[$i], "#comments-start", 0 ) > 0 Then
		$iCommentStart = $iCommentStart + 1
		ExitLoop
		Else
		If $aSplit[$i] = "" Then ExitLoop
		FileWriteLine ( $hFile, $aSplit[$i] )
		$iYCLines += 1
		ExitLoop
		EndIF
	Else
		If StringRegExp ( $aSplit[$i], "#CE", 0 ) > 0 OR StringRegExp ( $aSplit[$i], "#comments-end", 0 ) > 0 Then $iCommentStart = $iCommentStart - 1
		ExitLoop
	EndIF
	Wend
Next
FileClose ( $hFile )
EndFunc





Func _CheckEndOfLine()
If $sEndStringLine = "" Then Return 1
If StringRegExp ( $sEndStringLine, "_", 0 ) < 1 Then Return 1
If StringRight( $sEndStringLine, 3 ) = "_  " Then Return 0
If StringRight( $sEndStringLine, 3 ) = "_	 " Then Return 0
If StringRight( $sEndStringLine, 3 ) = "_ 	" Then Return 0
If StringRight( $sEndStringLine, 2 ) = "_ " Then Return 0
If StringRight( $sEndStringLine, 2 ) = "_	" Then Return 0
If StringRight( $sEndStringLine, 1 ) = "_" Then Return 0
Return 1
EndFunc



Func _Encoding_ANSIToOEM($strText)
	Local $sBuffer = DllStructCreate("char[" & StringLen($strText) + 1 & "]")
	Local $aRet = DllCall("User32.dll", "int", "CharToOem", "str", $strText, "ptr", DllStructGetPtr($sBuffer))

	If Not IsArray($aRet) Then Return SetError(1, 0, '') ; DLL error
	If $aRet[0] = 0 Then Return SetError(2, $aRet[0], '') ; Function error

	Return DllStructGetData($sBuffer, 1)
EndFunc   ;==>_Encoding_ANSIToOEM



