; #FUNCTION# ====================================================================================================================
; Name ..........: _InfoTrack
; Description ...:
; Syntax ........: _InfoTrack($iStationID, $vNV)
;
; Parameters ....: 						$iStationID         -	   id .
;										####################-	 _InfoTrack(136, 0)
;                  						$vNV                -	      ""   .
;										####################-	 _InfoTrack(136, 0) =  
;										####################-	 _InfoTrack(136, 1) = 
;
; Return values .: 						$vServer			-	 
;										$vTitle				-	  +  
;										$vID				-	 
;										$vStart				-	 
;										$vFinish			-	 
;										$vEndTime			-	  
;										$vQueryTime			-	 ()  
;										$vSample			-	  
;
;#####################################	    ( )
;
;										$vTrackTitle		-	  2
;										$vAlbumTrackTitle	-	 
;										$vTrackTime			-	   
;										$vTrackName			-	   
;										$vCollectionName	-	   
;										$vArtistViewUrl		-	    
;										$vDurationSec		-	  
; Author ........: Ivsatel
; Modified ......:	4.11.2013
; Remarks .......:
; Related .......:
; Link ..........:	http://autoit-script.ru/index.php/topic,13973.0.html
; Example .......: No
; ===============================================================================================================================

#include <Constants.au3>
#include <GZIP_exe.au3>

Opt('MustDeclareVars', 1)

Global $aInfoTrack[1], $aGetInfoTrack[15], $sUrl, $sInfoTrackBinaryToString, $iStationID, $oHTTP, $sUserAgent, $sHTML, $sToken, $aToken, $sTokenread, _
		$sGetPlayList, $aPlayList, $sPlayList, $aFinalPlayList[1], $sValidURL, $oMyError, $vNV, $sPageSourse, $aNamePage, $vJob, $vServer, $vTitle, $vID, _
		$vStart, $vFinish, $vEndTime, $vQueryTime, $vSample, $vTrackTitle, $vAlbumTrackTitle, $vTrackTime, $vTrackName, $vCollectionName, $vArtistViewUrl, _
		$vDurationSec, $chek, $Label4, $vHttp, $asPlayList[2], $No_Play_url, $iStrRunning = 0

Local $bFileGZIP, $iPIDGZIP = ''

Func _Encoding_JavaUnicodeDecode($sString)
	Local $iOld_Opt_EVS = Opt("ExpandVarStrings", 0)
	Local $iOld_Opt_EES = Opt("ExpandEnvStrings", 0)

	Local $sOut = "", $aString = StringRegExp($sString, "(\\\\|\\'|\\u[[:xdigit:]]{4}|[[:ascii:]])", 3)

	For $i = 0 To UBound($aString) - 1
		Switch StringLen($aString[$i])
			Case 1
				$sOut &= $aString[$i]
			Case 2
				$sOut &= StringRight($aString[$i], 1)
			Case 6
				$sOut &= ChrW(Dec(StringRight($aString[$i], 4)))
		EndSwitch
	Next

	Opt("ExpandVarStrings", $iOld_Opt_EVS)
	Opt("ExpandEnvStrings", $iOld_Opt_EES)

	Return $sOut
EndFunc   ;==>_Encoding_JavaUnicodeDecode

Func _InfoTrack($iStationID, $vNV)

	$vJob = 1
	;##########################		 

	If $iStationID <> 0 Then

		If Not FileExists(@TempDir & '\GZIP_main.exe') Then
			$bFileGZIP = FileOpen(@TempDir & '\GZIP_main.exe', 26)
			FileWrite($bFileGZIP, $sGZIP_NAME)
			FileClose($bFileGZIP)
		EndIf

		While 1


			$chek += 1

			If StringLen($iStationID) > 3 Then
				Local $sChanUs = 'port_channel&userid='

			Else
				Local $sChanUs = 'port_channel_mp3&channel='

			EndIf

			$sTokenread = BinaryToString(InetRead('http://101.ru/?an=' & $sChanUs & $iStationID, 3))

			;ConsoleWrite($iStationID&@LF&StringLen($iStationID)&$sTokenread&@LF)

			$aToken = StringRegExp($sTokenread, "(?is)playerAPI[\.]Uppod[\.]AddParamPlayer[\(].*?[\{][\']st[\'][\:][\'].*?[\'][\,][\'].*?[\'][\:][\'](.*?)[\']", 3)

			If IsArray($aToken) And StringLen($iStationID) < 4 Then
				If StringInStr($aToken[0], '.mp3') Then

					$sToken = $aToken[0]
				Else

					$sToken = 'http://101.ru' & StringRegExpReplace(StringRegExpReplace(StringRegExpReplace($aToken[0], '[\|]', '&'), '-1', ''), 'mp3[\:]', '')
				EndIf
			ElseIf StringLen($iStationID) > 3 Then

				;$sToken = StringRegExpReplace(StringRegExpReplace(StringRegExpReplace($aToken[0], '[\|]', '&'), '-1', ''), 'mp3[\:]', '')
				$sToken = 'ERROR'
			Else

				$sToken = 'ERROR'
			EndIf

			;ConsoleWrite('$sToken = ' & $sToken & @LF)

			If $sToken = 'ERROR' And $chek = '10' Then

				MsgBox(16, 'Stop 1', '   .' & @LF & ' ')
				Return
			Else

				$chek = '0'
				ExitLoop
			EndIf
			;ConsoleWrite(' WEnd #1 $iStrRunning = '&@ScriptLineNumber&@LF)
		WEnd

		While 1
			$chek += 1


			If $sToken = 'ERROR' Then ExitLoop

			If Not StringInStr($sToken, '.mp3') Then

				$sGetPlayList = BinaryToString(InetRead($sToken))
				$aPlayList = StringRegExp($sGetPlayList, '(?si)file"[\:]"(.*?)"[\}]', 3)
			Else

				$aPlayList = StringRegExp($sToken, '(?si)(.*)', 3)
			EndIf

;~ 			For $i = 0 To UBound($aPlayList) - 1
;~ 				ConsoleWrite($aPlayList[$i] & @LF)
;~ 			Next

			For $i = 0 To UBound($aPlayList) - 1
				ReDim $aPlayList[UBound($aPlayList) + 1]
				$aPlayList[UBound($aPlayList) - 1] = StringRegExpReplace($aPlayList[$i], 'setst[\=](.*?)[\&]', '')
				;ConsoleWrite(StringRegExpReplace($aPlayList[$i], 'setst[\=](.*?)[\&]', '')&@LF)
			Next


;~ 			ConsoleWrite('****************************************************' & @LF)
;~ 			ConsoleWrite('****************************************************' & @LF)
;~ 			ConsoleWrite('****************************************************' & @LF)

;~ 			For $i = 0 To UBound($aPlayList) - 1
;~ 				ConsoleWrite($aPlayList[$i] & @LF)
;~ 			Next

			If Not IsArray($aPlayList) And StringLen($iStationID) < 4 Then
				$sPlayList = 'ERROR'
				;ConsoleWrite('$sPlayList = "ERROR"' & @LF)
			EndIf

			;ConsoleWrite($sPlayList&@LF)

			;##########################		 
			If $sPlayList <> 'ERROR' And $chek = '10' Then

				MsgBox(16, 'Stop 2', '   .' & @LF & ' ')
				Return
			Else

				$chek = '0'
				ExitLoop
			EndIf
			;ConsoleWrite(' Wend #2 $iStrRunning = '&@ScriptLineNumber&@LF)
		WEnd

		While 1
			$chek += 1

			;ConsoleWrite(' 3 '&$chek&@LF)
			;##########################		   

			$sUrl = 'http://f1.101.ru/api/getplayingtrackinfo.php?station_id=' & $iStationID & '&short=1&typechannel=channel'
			;ConsoleWrite('http://f1.101.ru/api/getplayingtrackinfo.php?station_id=' & $iStationID & '&short=1&typechannel=channel' & @LF)
			$sUserAgent = 'Mozilla/5.0 (Windows NT 5.1; rv:25.0) Gecko/20100101 Firefox/25.0'

			$oHTTP = ObjCreate('WinHttp.WinHttpRequest.5.1')
			$oMyError = ObjEvent("AutoIt.Error", "_ERROR")
			$oHTTP.Open("GET", $sUrl, True)
			$oHTTP.SetRequestHeader("Host", "f1.101.ru")
			$oHTTP.SetRequestHeader("User-Agent", $sUserAgent)
			$oHTTP.SetRequestHeader("Accept", 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8')
			$oHTTP.SetRequestHeader("Accept-Language", "ru-RU,ru;q=0.8,en-US;q=0.5,en;q=0.3")
			;$oHTTP.SetRequestHeader("Accept-Encoding", "chunked")
			$oHTTP.SetRequestHeader("Accept-Encoding", "gzip, deflate")
			$oHTTP.SetRequestHeader("DNT", "1")
			;$oHTTP.SetRequestHeader("Origin", "http://101.ru")
			$oHTTP.SetRequestHeader("X-ClickOnceSupport", "( .NET CLR 3.5.30729; .NET4.0E)")
			$oHTTP.SetRequestHeader("Connection", "keep-alive")
			$oHTTP.SetRequestHeader("Cache-Control", "max-age=0")
			;$oHTTP.GetResponseheader('set-Cookie')
			;$oHTTP.GetallResponseheaders
			;$oHTTP.SetRequestHeader("Referer", "http://101.ru/?an=port_channel_mp3&channel=" & $iStationID)
			$oHTTP.SetRequestHeader("Referer", "http://101.ru/static/js/uppod/uppod.swf")
			$oHTTP.Option(4) = 13056
			$oHTTP.SetClientCertificate("CURRENT_USERMYaCertificate")
			$oHTTP.Send()
			$oHTTP.WaitForResponse()
			;$sHTML = $oHTTP.ResponseText()
			;##########################		   

			;##########################		   

			;$sInfoTrackBinaryToString = _Encoding_JavaUnicodeDecode(BinaryToString($sHTML, 4))
			;$sInfoTrackBinaryToString = $sHTML

			;##########################
			$iPIDGZIP = Run(@TempDir & "\GZIP_main.exe -d", @TempDir, @SW_HIDE, $STDIN_CHILD + $STDOUT_CHILD)

			StdinWrite($iPIDGZIP, $oHTTP.ResponseBody())
			StdinWrite($iPIDGZIP)

			While True
				$sInfoTrackBinaryToString &= StdoutRead($iPIDGZIP)
				If @error Then ExitLoop
				Sleep(25)
			WEnd
			;##########################

			$sInfoTrackBinaryToString = _Encoding_JavaUnicodeDecode($sInfoTrackBinaryToString)

			;ConsoleWrite(' InfoTrack = '&$sInfoTrackBinaryToString & @LF)

			If $sInfoTrackBinaryToString = '' And $chek = '10' Then
				MsgBox(16, 'Stop 3', '   .' & @LF & ' ')
				Return
			Else
				$chek = '0'
				ExitLoop
			EndIf

		WEnd

		;##########################		   
		$oMyError = 0
		$oHTTP = 0

		;##########################		 
		$aGetInfoTrack[0] = '.*?"server"[\:]"(.*?)"[\,].*' ; Server -  
		$aGetInfoTrack[1] = '.*?"title"[\:]"(.*?)"[\,].*' ; Title -   +  
		$aGetInfoTrack[2] = '.*?"id"[\:]"(.*?)"[\,].*' ; ID - 
		$aGetInfoTrack[3] = '.*?"start[\_]time"[\:]"(.*?)"[\,].*' ; Start -  
		$aGetInfoTrack[4] = '.*?"finish[\_]time"[\:](.*?)[\,].*' ; Finish -  
		$aGetInfoTrack[5] = '.*?"end[\_]time"[\:](.*?)[\,].*' ; EndTime -   
		$aGetInfoTrack[6] = '.*?"query[\_]time"[\:](.*?)[\,].*' ; QueryTime -  ()  
		$aGetInfoTrack[7] = '.*?"sample"[\:]"(.*?)".*' ; Sample -   
		$aGetInfoTrack[8] = '.*?"track[\_]title"[\:]"(.*?)"[\,].*' ; Track Title -   2
		$aGetInfoTrack[9] = '.*?"executor[\_]title"[\:]"(.*?)"[\,].*' ; Album Track Title -  
		$aGetInfoTrack[10] = '.*?"trackTimeMillis"[\:](.*?)[\,].*' ; Track Time (ms) -    
		$aGetInfoTrack[11] = '.*?"trackName"[\:]"(.*?)"[\,].*' ; Track Name -       
		$aGetInfoTrack[12] = '.*?"collectionName"[\:]"(.*?)"[\,].*' ; Collection Name -    
		$aGetInfoTrack[13] = '.*?"artistViewUrl"[\:]"(.*?)"[\,].*' ; Artist View Url -     itunes.apple.com
		$aGetInfoTrack[14] = '.*?"duration_sec"[\:]"(.*?)"[\,].*' ; Duration Sec -   
		;##########################		 

		;##########################		    
		For $i = 0 To UBound($aGetInfoTrack) - 1
			ReDim $aInfoTrack[$i + 1]
			If $i = 6 Then
				$aInfoTrack[$i] = StringRegExpReplace($sInfoTrackBinaryToString, '(?i)' & $aGetInfoTrack[$i], '$1')
				If @extended = 0 Or $aInfoTrack[$i] = '' Then $aInfoTrack[$i] = 'ERROR'
			EndIf
			If $i = 7 Then
				$aInfoTrack[$i] = StringRegExpReplace($sInfoTrackBinaryToString, '(?i)' & $aGetInfoTrack[$i], '$1')
				If @extended = 0 Or $aInfoTrack[$i] = '' Then $aInfoTrack[$i] = 'ERROR'
			EndIf
			If $i = 10 Then
				$aInfoTrack[$i] = StringRegExpReplace($sInfoTrackBinaryToString, '(?i)' & $aGetInfoTrack[$i], '$1')
				If @extended = 0 Or $aInfoTrack[$i] = '' Then $aInfoTrack[$i] = 'ERROR'
			EndIf
			If $i = 13 Then
				$aInfoTrack[$i] = StringRegExpReplace($sInfoTrackBinaryToString, '(?i)' & $aGetInfoTrack[$i], '$1')
				If @extended = 0 Or $aInfoTrack[$i] = '' Then $aInfoTrack[$i] = 'ERROR'
			EndIf
			If $i <> 6 And $i <> 7 And $i <> 10 And $i <> 13 Then
				$aInfoTrack[$i] = StringRegExpReplace($sInfoTrackBinaryToString, '(?i)' & $aGetInfoTrack[$i], '$1')
				If @extended = 0 Or $aInfoTrack[$i] = '' Then $aInfoTrack[$i] = 'ERROR'
			EndIf
		Next

		$sInfoTrackBinaryToString = ''

		;##########################		    

		If Not IsArray($aInfoTrack) Then
			SetError(102, 'ERROR', 'ERROR')
			Return
		Else
			;######################################################################################################################
;~ 			For $i = 0 To UBound($aInfoTrack) - 1
;~ 				ConsoleWrite($aInfoTrack[$i] & @LF)
;~ 			Next
			;######################################################################################################################

			Global $vServer = $aInfoTrack[0]

			If $aInfoTrack[1] <> 'ERROR' Then

				Global $vTitle = StringRegExpReplace($aInfoTrack[1], '\&.*?;', '')
			ElseIf $aInfoTrack[1] == 'ERROR' And $aInfoTrack[9] <> 'ERROR' And $aInfoTrack[8] <> 'ERROR' Then

				Global $vTitle = StringRegExpReplace($aInfoTrack[9], '\&.*?;', '') & ' - ' & StringRegExpReplace($aInfoTrack[8], '\&.*?;', '')
			ElseIf $aInfoTrack[1] == 'ERROR' And $aInfoTrack[9] == 'ERROR' And $aInfoTrack[8] == 'ERROR' Then

				Global $vTitle = 'ERROR'
			EndIf

			Global $vID = $aInfoTrack[2]
			Global $vStart = $aInfoTrack[3]
			Global $vFinish = $aInfoTrack[4]
			Global $vEndTime = $aInfoTrack[5]
			Global $vQueryTime = $aInfoTrack[6]

			If $aInfoTrack[7] = 'ERROR' And $aInfoTrack[2] <> 'ERROR' Then
				Global $vSample = 'http://wz5.101.ru/full/' & $iStationID & '/' & $aInfoTrack[2] & '.mp3'
			Else
				Global $vSample = StringRegExpReplace($aInfoTrack[7], '\\', '')
			EndIf

			Global $vTrackTitle = StringRegExpReplace($aInfoTrack[8], '\&.*?;', '')
			Global $vAlbumTrackTitle = $aInfoTrack[9]
			Global $vTrackTime = $aInfoTrack[10]
			Global $vTrackName = $aInfoTrack[11]
			Global $vCollectionName = $aInfoTrack[12]
			Global $vArtistViewUrl = $aInfoTrack[13]
			Global $vDurationSec = $aInfoTrack[14]

			;######################################################################################################################
		EndIf

	EndIf

	If $vNV <> 0 Then

		For $i = 0 To UBound($aPlayList) - 1
			;##########################		   

			If StringLen($iStationID) > 3 Then
				$sValidURL = $vNV
				$sPageSourse = BinaryToString(InetRead('http://101.ru/?an=port_channel&userid=' & $iStationID, 3))
				$aNamePage = StringRegExp($sPageSourse, '(?is)(?is)[\<]title[\>].*?(.*?).*?[\<][\/]title[\>]', 3)
				ExitLoop
			Else
				If Not IsArray($aPlayList) And StringLen($iStationID) < 4 Then
					$sUrl = 'http://101.ru/?an=' & $sChanUs & $iStationID
				Else
					$sUrl = StringRegExpReplace($aPlayList[$i], '(.*?):8000.*', '$1')
				EndIf
			EndIf

			$sUserAgent = 'Mozilla/5.0 (Windows NT 5.1; rv:25.0) Gecko/20100101 Firefox/25.0'

			$oHTTP = ObjCreate('WinHttp.WinHttpRequest.5.1')
			$oMyError = ObjEvent("AutoIt.Error", "_ERROR")
			$oHTTP.Open("GET", $sUrl, True)
			$oHTTP.SetRequestHeader("Host", "101.ru")
			$oHTTP.SetRequestHeader("User-Agent", $sUserAgent)
			$oHTTP.SetRequestHeader("Accept-Language", "ru-RU,ru;q=0.8,en-US;q=0.5,en;q=0.3")
			;$oHTTP.SetRequestHeader("Accept-Encoding", "chunked")
			;$oHTTP.SetRequestHeader("Accept-Encoding", "gzip, deflate")
			$oHTTP.SetRequestHeader("Referer", "http://101.ru/static/js/uppod/uppod.swf")
			$oHTTP.SetRequestHeader("DNT", "1")
			$oHTTP.SetRequestHeader("Connection", "keep-alive")
			$oHTTP.Send()
			$oHTTP.WaitForResponse()
			$sHTML = $oHTTP.ResponseText()

			;##########################
			;ConsoleWrite(' 1  = '&$sHTML&@LF)
			$sHTML = _Encoding_JavaUnicodeDecode($sHTML)
			;ConsoleWrite(' 2  = '&$sHTML&@LF)
			$oHTTP = 0
			$oMyError = 0

			;##########################		   

			If StringRegExp($sHTML, '(?is).*?(Reference)', 0) = 1 And $sPlayList <> 'ERROR' Then
				ReDim $aFinalPlayList[$i + 1]
				$aFinalPlayList[$i] = StringRegExpReplace($sHTML, '(?is).*?(http[\:][\/][\/]\d+?[\.]\d+?[\.]\d+?[\.]\d+?[\:]\d+?[\/].*?)\z', '$1')
				$sValidURL = StringRegExpReplace($aPlayList[$i], 'setst[\=](.*?)[\&]', '')
				ExitLoop
			EndIf

			$sHTML = ''

		Next
		$oMyError = 0
		$oHTTP = 0
		;########################################	  
		While 1
			$chek += 1
			;ConsoleWrite(' 4 '&$chek&@LF)
			If StringLen($iStationID) < 4 Then
				$sPageSourse = BinaryToString(InetRead('http://101.ru/?an=port_channel_mp3&channel=' & $iStationID, 3))
				$aNamePage = StringRegExp($sPageSourse, '(?is)[\<]title[\>](.*?)(?:[\<]|\s+?[\-])', 3)
			Else
				ExitLoop
			EndIf
			If Not IsArray($aNamePage) And $chek = '10' Then
				MsgBox(16, 'Stop 4', '   .' & @LF & ' ')
				Return
			Else
				$chek = '0'
				ExitLoop
			EndIf
		WEnd
		;########################################	  
	EndIf
	$vJob = 0
EndFunc   ;==>_InfoTrack

Func _ERROR()
	Local $HexNumber = Hex($oMyError.number, 8)
	ConsoleWrite("We intercepted a COM Error !" & @CRLF & "Description is: " & $oMyError.description & @CRLF & "Number is: " & _
			$HexNumber & @CRLF & "Source: " & $oMyError.source & @CRLF & "Scriptline: " & $oMyError.scriptline & @CRLF & "Windescription is: " & $oMyError.windescription & @CRLF)
	Sleep(10)
	ConsoleWrite(' = 1 = ERROR IN InfoTrack-101' & @LF)
EndFunc   ;==>_ERROR
