#CS
============================================================================================
============================================================================================
============================================================================================

:		_ImgFile_ColorReplace
:	   -  ,         
:	_ImgFile_ColorReplace( $sInFile, $sOutFile, $sFoundColor, $sEndColor)
:
		    $sInFile		= ,     
		    $sOutFile		=   - 
		    $sFoundColor	=  
		    $sEndColor		=  

 : 
					   @Error = 0  Return = 1 - 
					   @Error = 1  Return = 0 - 

:
	-------------------------------------------------------------------------------------------------------------------------------------------------
	#include <ImgFile.inc>
	_ImgFile_ColorReplace( @ScriptDir & '\1.png', @ScriptDir & '\2.png', 0x000000, 0x0000A0)
	-------------------------------------------------------------------------------------------------------------------------------------------------

============================================================================================
============================================================================================
============================================================================================
:			_ImgFile_Glue()
:		  JPG   1 
:		_ImgFile_Glue($aImgs, $sOutPuth)
:
			$aImgs		=      (, ["0.png","1.jpg","2.jpg","3.jpg"])
			$sOutPuth	=    

 :	

:
	--------------------------------------------------------------------------------------------------------------------------
	#include <ImgFile.inc>
	Dim $aImgs[4] = ["0.png","1.jpg","2.jpg","3.jpg"]
	_ImgFile_Glue($aImgs, "NewFile.jpg")
	--------------------------------------------------------------------------------------------------------------------------

============================================================================================
============================================================================================
============================================================================================
:		_ImgFile_BrushPaint()
:	 -   
:	_ImgFile_BrushPaint($sInput, $sOutput, $aBrushData)
:
		    $sInput			=  
		    $sOutput		=   ()
		    $aBrushData	=   (. )
 : 

 ( 2 ):
	--------------------------------------------------------------------------------------------------------------------------
	#include <ImgFile.inc>
	Dim $aBrushData[2][5]
		$aBrushData[0][0] = 0xFFFF0000	;   1   ( )
		$aBrushData[0][1] = 5			; X    1
		$aBrushData[0][2] = 5			; Y    1
		$aBrushData[0][3] = 2			; X   1
		$aBrushData[0][4] = 2			; Y   1
		$aBrushData[1][0] = 0x7F00007F	;   2   ( )
		$aBrushData[1][1] = 7			; X    2
		$aBrushData[1][2] = 5			; Y    2
		$aBrushData[1][3] = 3			; X   2
		$aBrushData[1][4] = 2			; Y   2
	_ImgFile_BrushPaint("MyTest1.png", "MyTest2.png", $aBrushData)
	--------------------------------------------------------------------------------------------------------------------------
      2 , ,     10000,   1.

============================================================================================
============================================================================================
============================================================================================
:		_ImgFile_Convert_PngToBmp()
:	 PNG   Bmp
:	_ImgFile_Convert_PngToBmp($sInput, $sOutput)
:
		    $sInput			=  (PNG) 
		    $sOutput		=  (BMP)  ()

 : 
============================================================================================
============================================================================================
============================================================================================
 : GDIPlus.au3, ScreenCapture.au3

#CE






#include-once
#include <GDIPlus.au3>
#include <ScreenCapture.au3>


Func _ImgFile_Convert_PngToBmp($sInput, $sOutput)
_GDIPlus_Startup()
$hImage = _GDIPlus_ImageLoadFromFile($sInput)
$hBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage, 0xFFFFFFFF)
_ScreenCapture_SaveImage($sOutput, $hBitmap)
_GDIPlus_ImageDispose($hImage)
_GDIPlus_ShutDown()
EndFunc




Func _ImgFile_BrushPaint($sInput, $sOutput, $aBrushData)

_GDIPlus_Startup()
Local $hImage, $hGraphics, $hBrush
$hImage = _GDIPlus_ImageLoadFromFile($sInput)
$hGraphics = _GDIPlus_ImageGetGraphicsContext($hImage)


For $i = 0 To UBound ( $aBrushData )-1
$hBrush = _GDIPlus_BrushCreateSolid($aBrushData[$i][0])
	;_GDIPlus_BrushSetSolidColor($hBrush, $aBrushData[$i][0])
_GDIPlus_GraphicsFillRect($hGraphics, $aBrushData[$i][1], $aBrushData[$i][2], $aBrushData[$i][3], $aBrushData[$i][4], $hBrush)
_GDIPlus_BrushDispose($hBrush)
Next


_GDIPlus_ImageSaveToFile($hImage, $sOutput)

_GDIPlus_GraphicsDispose($hGraphics)
_GDIPlus_ImageDispose($hImage)
_GDIPlus_Shutdown()

EndFunc




Func _ImgFile_Glue($aImgs, $sOutPuth)
_GDIPlus_Startup()

Local $ahImage[UBound($aImgs)]
Local $iWidth, $iHeight, $hNewBitmap, $hNewBitmap2, $hGraphic

For $i = 0 To UBound($aImgs)-1
    $ahImage[$i] = _GDIPlus_ImageLoadFromFile($aImgs[$i])
Next

$iWidth = _GDIPlus_ImageGetWidth($ahImage[0])
$iHeight = _GDIPlus_ImageGetHeight($ahImage[0])

$hNewBitmap = _WinAPI_CreateBitmap($iWidth * UBound($aImgs), $iHeight, 1, 32)
$hNewBitmap2 = _GDIPlus_BitmapCreateFromHBITMAP($hNewBitmap)
$hGraphic = _GDIPlus_ImageGetGraphicsContext($hNewBitmap2)

For $i = 0 To UBound($ahImage)-1
    _GDIPlus_GraphicsDrawImageRect($hGraphic,$ahImage[$i],$i*$iWidth,0,$iWidth,$iHeight)
    _GDIPlus_ImageDispose($ahImage[$i])
Next

_GDIPlus_ImageSaveToFile($hNewBitmap2,$sOutPuth)
_GDIPlus_GraphicsDispose($hGraphic)
_WinAPI_CloseHandle($hNewBitmap)
_GDIPlus_ImageDispose($hNewBitmap2)

_GDIPlus_Shutdown()
EndFunc





Func _ImgFile_ColorReplace( $sInFile, $sOutFile, $sFoundColor, $sEndColor)
If NOT FileExists( $sInFile ) Then Return SetError(1,0,0)
Local $hSrc, $aSize, $hDst, $hGraphics, $hIA

_GDIPlus_Startup()
	$hSrc = _GDIPlus_ImageLoadFromFile($sInFile)
	$aSize = _ImgFile__GDIPlus_ImageGetDimension($hSrc)
	$hDst = _ImgFile__GDIPlus_BitmapCreateFromScan0($aSize[0], $aSize[1])
	$hGraphics = _GDIPlus_ImageGetGraphicsContext($hDst)
	$hIA = _ImgFile__GDIPlus_ImageAttributesCreate()
	Local $aTable[257][2] = [[256]]
	For $i = 0 To 255
	    $aTable[$i + 1][0] = BitOR(BitShift($i, -24), $sFoundColor)
	    $aTable[$i + 1][1] = BitOR(BitShift($i, -24), $sEndColor)
	Next
	_ImgFile__GDIPlus_ImageAttributesSetRemapTable($hIA, 1, 1, $aTable)
	_ImgFile__GDIPlus_GraphicsDrawImageRectRectIA($hGraphics, $hSrc, 0, 0, $aSize[0], $aSize[1], 0, 0, $aSize[0], $aSize[1], $hIA)
	_GDIPlus_ImageSaveToFile($hDst, $sOutFile)
	_ImgFile__GDIPlus_ImageAttributesDispose($hIA)
	_GDIPlus_GraphicsDispose($hGraphics)
	_GDIPlus_ImageDispose($hDst)
	_GDIPlus_ImageDispose($hSrc)
_GDIPlus_Shutdown()
Return SetError(0,0,1)
EndFunc




Func _ImgFile__GDIPlus_ImageGetDimension($hImage)
	Local $aSize[2], $aResult

	$aResult = DllCall($ghGDIPDll, "uint", "GdipGetImageDimension", "hwnd", $hImage, "float*", 0, "float*", 0)
	If @error Then Return SetError(@error, @extended, -1)

	$GDIP_STATUS = $aResult[0]
	If $GDIP_STATUS Then Return -1

	$aSize[0] = $aResult[2]
	$aSize[1] = $aResult[3]
	Return $aSize
EndFunc   


Func _ImgFile__GDIPlus_BitmapCreateFromScan0($iWidth, $iHeight, $iStride = 0, $iPixelFormat = 0x0026200A, $pScan0 = 0)
	Local $aResult = DllCall($ghGDIPDll, "uint", "GdipCreateBitmapFromScan0", "int", $iWidth, "int", $iHeight, "int", $iStride, "int", $iPixelFormat, "ptr", $pScan0, "int*", 0)

	If @error Then Return SetError(@error, @extended, 0)
	$GDIP_STATUS = $aResult[0]
	Return $aResult[6]
EndFunc   ;==>_ImgFile__GDIPlus_BitmapCreateFromScan0


Func _ImgFile__GDIPlus_ImageAttributesCreate()
	Local $aResult = DllCall($ghGDIPDll, "uint", "GdipCreateImageAttributes", "int*", 0)

	If @error Then Return SetError(@error, @extended, 0)
	$GDIP_STATUS = $aResult[0]
	Return $aResult[1]
EndFunc   ;==>_ImgFile__GDIPlus_ImageAttributesCreate


Func _ImgFile__GDIPlus_ImageAttributesSetRemapTable($hImageAttributes, $iColorAdjustType = 0, $fEnable = False, $aColorMap = 0)
	Local $iI, $iCount, $tColorMap, $pColorMap, $aResult

	If IsArray($aColorMap) Then
		$iCount = $aColorMap[0][0]
		$tColorMap = DllStructCreate("uint[" & $iCount * 2 & "]")
		$pColorMap = DllStructGetPtr($tColorMap)

		For $iI = 1 To $iCount
			DllStructSetData($tColorMap, 1, $aColorMap[$iI][0], ($iI - 1) * 2 + 1)
			DllStructSetData($tColorMap, 1, $aColorMap[$iI][1], ($iI - 1) * 2 + 2)
		Next

		$aResult = DllCall($ghGDIPDll, "uint", "GdipSetImageAttributesRemapTable", "hwnd", $hImageAttributes, "int", $iColorAdjustType, "int", $fEnable, "int", $iCount, "ptr", $pColorMap)
	Else
		$aResult = DllCall($ghGDIPDll, "uint", "GdipSetImageAttributesRemapTable", "hwnd", $hImageAttributes, "int", $iColorAdjustType, "int", $fEnable, "int", 0, "ptr", 0)
	EndIf

	If @error Then Return SetError(@error, @extended, False)
	$GDIP_STATUS = $aResult[0]
	Return $aResult[0] = 0
EndFunc   ;==>_ImgFile__GDIPlus_ImageAttributesSetRemapTable


Func _ImgFile__GDIPlus_GraphicsDrawImageRectRectIA($hGraphics, $hImage, $nSrcX, $nSrcY, $nSrcWidth, $nSrcHeight, $nDstX, $nDstY, $nDstWidth, $nDstHeight, $hImageAttributes = 0, $iUnit = 2)
	Local $aResult = DllCall($ghGDIPDll, "int", "GdipDrawImageRectRect", "hwnd", $hGraphics, "hwnd", $hImage, "float", $nDstX, "float", _
			$nDstY, "float", $nDstWidth, "float", $nDstHeight, "float", $nSrcX, "float", $nSrcY, "float", $nSrcWidth, "float", _
			$nSrcHeight, "int", $iUnit, "hwnd", $hImageAttributes, "int", 0, "int", 0)

	If @error Then Return SetError(@error, @extended, False)
	$GDIP_STATUS = $aResult[0]
	Return $aResult[0] = 0
EndFunc   ;==>_ImgFile__GDIPlus_GraphicsDrawImageRectRectIA


Func _ImgFile__GDIPlus_ImageAttributesDispose($hImageAttributes)
	Local $aResult = DllCall($ghGDIPDll, "uint", "GdipDisposeImageAttributes", "hwnd", $hImageAttributes)

	If @error Then Return SetError(@error, @extended, False)
	$GDIP_STATUS = $aResult[0]
	Return $aResult[0] = 0
EndFunc   ;==>_ImgFile__GDIPlus_ImageAttributesDispose
