#include-once
#include <Array.au3>
#Include <FreeImage.au3>
#Include <Array2D.inc>
#include "Captcha_PNG.inc"
#include "ImgFile.inc"
#include "GetImageResolution.au3"
Global $aCFCG_CaptchaConfig[4][2] = [ [90,90], [1], [1], [@ScriptDir&"\FreeImage.dll"] ]

;------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _Captcha_SetConfig($iRotate_Min=-90, $iRotate_Max=90, $iLabelAutoColor=1, $iShowNet=1, $sDllPuth="")
If $sDllPuth = "" Then $sDllPuth=@ScriptDir&"\FreeImage.dll"
$aCFCG_CaptchaConfig[0][0] = $iRotate_Min*1
$aCFCG_CaptchaConfig[0][1] = $iRotate_Max*1
$aCFCG_CaptchaConfig[1][0] = $iLabelAutoColor*1
$aCFCG_CaptchaConfig[2][0] = $iShowNet*1
$aCFCG_CaptchaConfig[3][0] = $sDllPuth
EndFunc

;------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _Captcha_FileGenerate($sFilePuth, $iCols=4)
$iCols = $iCols*1
If $iCols < 1 Then $iCols = 4

Local $sTempDir, $iNum, $isReturnNum, $iRotate, $File_A, $File_B, $File_C, $sMask, $aFilst[1]
For $i = 0 To 10000
	If NOT FileExists( @TempDir&"\Cpth_"&$i&"\" ) Then
	$sTempDir = @TempDir&"\Cpth_"&$i
	ExitLoop
	EndIF
Next
If $sTempDir = "" Then Return SetError(-1,0,-1)
If NOT DirCreate( $sTempDir ) Then Return SetError(-2,0,-1)


$sMask = "png"
$File_A = $sTempDir&"\A."&$sMask
$File_B = $sTempDir&"\B."&$sMask
$File_C = $sTempDir&"\C."&$sMask
_FreeImage_LoadDLL($aCFCG_CaptchaConfig[3][0])
_FreeImage_Initialise()



For $i = 1 To $iCols
	$iNum = Random(0,9,1)*1
	$isReturnNum &= $iNum
	$iRotate = Random($aCFCG_CaptchaConfig[0][0], $aCFCG_CaptchaConfig[0][1], 1)
	
	
	$FileOpen = FileOpen ( $File_A, 2 )
	FileWrite ( $FileOpen, BinaryToString($aPngKey[$iNum]) );	A
	FileClose ( $FileOpen )
	
	
	If $aCFCG_CaptchaConfig[1][0] = 1 Then 
	_ImgFile_ColorReplace( $File_A, $File_B, 0x0026FF, 0x0000A0-Random(1,10000,1)+Random(1,10000,1)+Random(1,10000,1)/3);	A-B
	Else
	FileCopy ( $File_A, $File_B, 1 ) 
	EndIF
	

If $aCFCG_CaptchaConfig[0][0] <> 0 OR $aCFCG_CaptchaConfig[0][1] <> 0 Then
		$hImage = _FreeImage_LoadU($FIF_PNG, $File_B)
		$hImg = _FreeImage_RotateClassic($hImage, $iRotate)
		_FreeImage_SaveU($FIF_PNG, $hImg, $File_C);	B-C
	_FreeImage_Unload($hImage)
	_FreeImage_Unload($hImg)
Else
FileCopy ( $File_B, $File_C, 1 ) 
EndIF
	
	_ImgFile_Convert_PngToBmp($File_C, $sTempDir&"\"&$i&"."&$sMask);	C-END
	_ArrayAdd ( $aFilst, $sTempDir&"\"&$i&"."&$sMask )

	;MsgBox(0,$i,$iCols)
	FileDelete ( $File_A )
	FileDelete ( $File_B )
	FileDelete ( $File_C )
Next




_FreeImage_DeInitialise()
_ArrayDelete ( $aFilst, 0 )

_ImgFile_Glue($aFilst, $sTempDir&"\E."&$sMask)
$aResolution = _GetImageResolution($sTempDir&"\E."&$sMask, 1)
	If @Error Then
	DirRemove( $sTempDir, 1 )
	Return SetError(1,0,-1)
	EndIF

If $aResolution[0] < 1 OR $aResolution[1] < 1 Then 
DirRemove( $sTempDir, 1 )
Return SetError(1,0,-1)
EndIF

Local $iResolution_X = $aResolution[0], $iResolution_Y = $aResolution[1], $aPaintArray = _Array2D_Create(5)
Local $aColors[11] = [0, 0xFFFF0000-Random(1,100,1), 0x7F00007F+1000-Random(1,100,1), 0xFFFF0000+1000-Random(1,100,1), 0x7F00007F+2000-Random(1,100,1), 0xFFFF0000+2000-Random(1,100,1), 0x7F00007F+4000-Random(1,100,1), 0xFFFF0000+4000-Random(1,100,1), 0x7F00007F+6000-Random(1,100,1), 0xFFFF0000+6000-Random(1,100,1), 0x7F00007F-Random(1,100,1)]
Local $WriteColor = $aColors[0], $iResY

$iResY = $iResolution_Y
For $i = 0 To $iResolution_X Step 1
$WriteColor = $aColors[Random(0,10, 1)*1]
If $iResY >= $iResolution_Y Then $iResY = $iResolution_Y
If $iResY < 2 Then $iResY = $iResolution_Y
Local $iRandomVal = Random(0,10, 1)
	If $iRandomVal = 1 OR $iRandomVal = 3 OR $iRandomVal = 5 OR $iRandomVal = 7 OR $iRandomVal = 9 Then
	$iResY = $iResY + 2
	Else
	$iResY = $iResY - 2
	EndIF
Local $aaData[5] = [$WriteColor, $i, $iResY, 1, 1]
$aPaintArray = _Array2D_Add($aPaintArray, $aaData)
Next

$iResY = $iResolution_Y
For $i = 0 To $iResolution_X Step 1
$WriteColor = $aColors[Random(0,10, 1)*1]
If $iResY >= $iResolution_Y Then $iResY = $iResolution_Y
If $iResY < 2 Then $iResY = $iResolution_Y
Local $iRandomVal = Random(0,10, 1)
	If $iRandomVal = 1 OR $iRandomVal = 3 OR $iRandomVal = 5 OR $iRandomVal = 7 OR $iRandomVal = 9 Then
	$iResY = $iResY + 2
	Else
	$iResY = $iResY - 2
	EndIF
Local $aaData[5] = [$WriteColor, $i, $iResY, 1, 1]
$aPaintArray = _Array2D_Add($aPaintArray, $aaData)
Next


If $aCFCG_CaptchaConfig[2][0] = 1 Then 
_ImgFile_BrushPaint($sTempDir&"\E."&$sMask, $sTempDir&"\END."&$sMask, $aPaintArray)
Else
FileCopy ( $sTempDir&"\E."&$sMask, $sTempDir&"\END."&$sMask, 1 )
EndIF
;MsgBox(0,"00","00")
FileDelete ( $sTempDir&"\E."&$sMask )

If NOT FileExists( $sTempDir&"\END."&$sMask ) Then 
DirRemove( $sTempDir, 1 )
Return SetError(2,0,-1)
EndIF

	_FreeImage_LoadDLL($aCFCG_CaptchaConfig[3][0])
	_FreeImage_Initialise()
	$hImage = _FreeImage_LoadU($FIF_PNG, $sTempDir&"\END."&$sMask)
	_FreeImage_SaveU($FIF_BMP, $hImage, $sTempDir&"\END."&$sMask);	O-O
	_FreeImage_Unload($hImage)
	_FreeImage_DeInitialise()


If NOT FileMove ( $sTempDir&"\END."&$sMask, $sFilePuth, 1 ) Then
DirRemove( $sTempDir, 1 )
Return SetError(3,0,-1)
Else
DirRemove( $sTempDir, 1 )
Local $aReturn[3] = [$isReturnNum, $aResolution[0], $aResolution[1]]
Return SetError(0,0,$aReturn)
EndIf
EndFunc

;------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------