#include <GUIConstantsEx.au3>
#include <DateTimeConstants.au3>
#include <Array.au3>
#include "TimeEvent.au3"

$hGUI = GUICreate('TimeEvent Example', 250, 200)

GUICtrlCreateLabel('Event Name:', 20, 20)
$iEventName_Input = GUICtrlCreateInput('MyEvent', 100, 18, 100, 20)

GUICtrlCreateLabel('Time:', 20, 70)
GUICtrlSetFont(-1, 9, 800)
$iEventTime_Time = GUICtrlCreateDate('', 100, 68, 100, 22, BitOR($DTS_TIMEFORMAT, $DTS_UPDOWN))
GUICtrlSendMsg($iEventTime_Time, $DTM_SETFORMATW, 0, 'HH' & $s_TE_Time_Sep & 'mm' & $s_TE_Time_Sep & 'ss')

GUICtrlCreateLabel('Date:', 20, 100)
GUICtrlSetFont(-1, 9, 800)
$iEventTime_Date = GUICtrlCreateDate('', 100, 98, 100, 20, $DTS_SHORTDATEFORMAT)
GUICtrlSendMsg($iEventTime_Date, $DTM_SETFORMATW, 0, 'dd' & $s_TE_Date_Sep & 'MM' & $s_TE_Date_Sep & 'yyyy')

$iSet_Bttn = GUICtrlCreateButton('Set event', 20, 170, 70, 20)

GUISetState(@SW_SHOW, $hGUI)

While 1
	$nMsg = GUIGetMsg()

	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			Exit
		Case $iSet_Bttn
			$sEvent = GUICtrlRead($iEventName_Input)
			$sDate = GUICtrlRead($iEventTime_Date)
			$sTime = GUICtrlRead($iEventTime_Time)
			
			_TimeEvent_Add($sEvent, $sDate, $sTime, '_MyEvent_Proc', 'Some extra data', True)
			
			$aEvents = _TimeEvent_GetEvents()
			
			_ArrayDisplay($aEvents, 'Events count: ' & $aEvents[0])
			$aAddedData = _TimeEvent_GetData($aEvents[1])
			$sData = ''
			
			For $i = 0 To UBound($aAddedData)-1
				$sData &= $aAddedData[$i] & @CRLF
			Next
			
			MsgBox(64, 'Event [' & $aEvents[1] & '] data', $sData, 0, $hGUI)
			
			$aNextEvent = _TimeEvent_GetNextEvent()
			
			If Not @error Then
				_ArrayDisplay($aNextEvent, 'Next event')
			Else
				MsgBox(48, 'Attention', 'No upcoming events', 0, $hGUI)
			EndIf
	EndSwitch
WEnd

Func _MyEvent_Proc($aParams)
	Local $sEvent = $aParams[0]
	Local $sDate = $aParams[1]
	Local $sTime = $aParams[2]
	Local $sParams = $aParams[3]
	Local $bRemove = $aParams[4]
	
	MsgBox(64, 'Event [' & $sEvent & '] fired', _
		'Event fired at: ' & $sDate & ' ' & $sTime & @CRLF & _
		'With params: ' & $sParams & @CRLF & _
		'Event should be removed: ' & $bRemove, 0, $hGUI)
	
	If $bRemove Then
		;Some actions when the event should be removed (the remove of the event itself handeled by the TimeEvent UDF)
		MsgBox(48, 'Attention', 'Event removed', 0, $hGUI)
	EndIf
EndFunc
