#include <GUIConstantsEx.au3>
#include <InetConstants.au3>
#include <EditConstants.au3>
#include "ScrollText.au3"

Global $bPaused = False
Global $sImageFile = @TempDir & '\ST_autoit.jpg'

If Not FileExists($sImageFile) Then
	InetGet('https://www.autoitscript.com/autoit3/files/graphics/autoit_fire_wall_1024x768.jpg', $sImageFile)
EndIf

Global $iGUI_Width = 600
Global $iGUI_Height = 500

$hMain_GUI = GUICreate('ScrollText UDF Example', $iGUI_Width, $iGUI_Height)

Dim $sScrollData = _
        'Scrolling text(Comic Sans MS,48)\n' & _
        'using GDIPlus(Comic Sans MS,24)\n' & _
        '\n\nNow with images support...(Verdana,20,0x51A2A2,2)\n' & _
        '<img>' & $sImageFile & '</img>\n' & _
        '(Arial,50)\n' & _
        'UDF(Verdana,30)\n' & _
        'by(Times New Roman,40)\n' & _
        'CreatoR(Arial Black,60,0xFF0000,4)\n' & _
        '(Arial,100)\n' & _
        'Thanks to:(Tunga,40,0xB95C00,5)\n' & _
        'UEZ:(Impact,44)\n' & _
        'Yashied:(Impact,44)\n' & _
        'AutoIt Team:(Impact,32)\n' & _
        'AutoIt Community(MV Boli,32)'

_ScrollText_Create($hMain_GUI, $sScrollData, -1, 30, 500, 400, True, 1, 0, 11)

Dim $sScrollData = _
        'Scrolling 1 text(Comic Sans MS,48)\n' & _
        'using GDIPlus(Comic Sans MS,24)\n' & _
        '\n\nNow with images support...(Verdana,20,0x51A2A2,2)\n' & _
        '<img>' & $sImageFile & '</img>\n' & _
        '(Arial,50)\n' & _
        'UDF(Verdana,30)\n' & _
        'by(Times New Roman,40)\n' & _
        'CreatoR(Arial Black,60,0xFF0000,4)\n' & _
        '(Arial,100)\n' & _
        'Thanks to:(Tunga,40,0xB95C00,5)\n' & _
        'UEZ:(Impact,44)\n' & _
        'Yashied:(Impact,44)\n' & _
        'AutoIt Team:(Impact,32)\n' & _
        'AutoIt Community(MV Boli,32)'

;_ScrollText_SetData($sScrollData)

GUICtrlCreateLabel('Scroll Speed:', 60, $iGUI_Height - 28, 70, 20)
$iSpeed_Input = GUICtrlCreateInput('1', 140, $iGUI_Height - 30, 60, 20, BitOR($GUI_SS_DEFAULT_INPUT, $ES_READONLY))
$iSpeed_UpDown = GUICtrlCreateUpdown(-1)
GUICtrlSetLimit(-1, 10, 1)

$iEnableMouseScroll_CB = GUICtrlCreateCheckbox('Enable scroll by mouse', 260, $iGUI_Height - 30)
GUICtrlSetState(-1, $GUI_CHECKED)

$iPause_Bttn = GUICtrlCreateButton('Pause', $iGUI_Width - 110, $iGUI_Height - 30, 60, 20)

GUISetState(@SW_SHOW, $hMain_GUI)

While 1
    $nMsg = GUIGetMsg()
    
    Switch $nMsg
        Case $GUI_EVENT_CLOSE
            _ScrollText_Destroy()
            Exit
		Case $iSpeed_UpDown
			_ScrollText_SetScrollSpeed(GUICtrlRead($iSpeed_Input))
		Case $iEnableMouseScroll_CB
			_ScrollText_EnableMouseScroll(GUICtrlRead($iEnableMouseScroll_CB) = $GUI_CHECKED)
		Case $iPause_Bttn
			$sText = $bPaused ? 'Pause' : 'Resume'
			
			_ScrollText_SetPause(Not $bPaused)
			GUICtrlSetData($iPause_Bttn, $sText)
			
			$bPaused = Not $bPaused
    EndSwitch
WEnd
