#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Resources\Icon.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=Program made by G.Sandler
#AutoIt3Wrapper_Res_Description=SIP - Selected Image Preview
#AutoIt3Wrapper_Res_Fileversion=1.4.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2012 G.Sandler (CreatoR), www.autoit-script.ru. All rights reserved.
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#Obfuscator_Ignore_Funcs=__MousePrimary_Event,__MouseWheelScroll_Event

#Region Header

#CS
	Name: 				SIP - Selected Image Preview
	Description:		Allows to preview image file by holding down left (main) mouse button on selected file in explorer window (or on desktop).
	Author: 			Copyright  2012 CreatoR's Lab (G.Sandler), www.creator-lab.ucoz.ru, www.autoit-script.ru. All rights reserved.
	AutoIt version: 	3.3.8.1
	
	Known Issues:
	* Image preview shown even when the mouse button held down not on the image file (while the image is selected in background).
	
	History:
	v1.4
	* Fixed issue with opening large Avi files. Only small avi files are supported.
	* Now the Avi preview is centered.
	
	v1.3
	* Empty cursor now generated from memory instead of file write.
	* Replaced color picker.
	* Icons now handled separatly.
	* Animations now supported partially (gif, ani, avi).
	
	v1.2
	* Again Preview mechanism completely rewritten (thanks to Yashied).
	* Added Tray Icon (optionaly).
	* Added Settings dialog (from tray, or by command line: /Settings).
	* Added About dialog (from tray, or by command line: /About).
	* Now the preview window does not focused.
	* Full compatibility with WinXP.
	* Changed program icon.
	* Fixed issue with called file rename action.
	* Fixed issue with mouse buttons swap (left/right handed).
	
	v1.1
	* Now compatible with WinXP.
	* Complete rewrite of Preview mechanism (thanks to Yashied). Now should better handle preview scaling and different images load.
	* Fixed issue with not working preview when files extension is hidden.
	* Fixed issue with crashing program/explorer on some objects.
	* Fixed issue with activating explorer window.
	* Fixed issue with hiding cursor while moving preview.
	
	v1.0
	* First release.
#CE

#include <GUIConstantsEx.au3>
#include <EditConstants.au3>
#include <ComboConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <GUIAVI.au3>
#include <GUIListView.au3>
#include <Misc.au3>
#include <File.au3>

#include "Includes\APIConstants.au3"
#include "Includes\AboutBox.au3"
#include "Includes\ColorPicker.au3"
#include "Includes\GDIP.au3"
#include "Includes\GUIResourcePic.au3"
#include "Includes\MouseOnEvent.au3"
#include "Includes\WinAPIEx.au3"

#EndRegion Header

#Region Global Variables

Global $sApp_Name 						= 'SIP - Selected Image Preview'
Global $sApp_Ver						= StringLeft(_Iif(@Compiled, FileGetVersion(@AutoItExe, "FileVersion"), StringRegExpReplace(FileRead(@ScriptFullPath), '(?s).*?#AutoIt3Wrapper_Res_Fileversion=(.*?)\r?\n.*', '\1')), 3)
Global $sApp_Config						= StringTrimRight(@ScriptFullPath, 3) & 'ini'

Global $sCompanyName_1					= 'CreatoR''s Lab'
Global $sCopyRight_URL_1 				= 'http://creator-lab.ucoz.ru'
Global $sCompanyName_2					= 'AutoIt Russian Community'
Global $sCopyRight_URL_2 				= 'http://autoit-script.ru'
Global $sCopyRight_String 				= 'Copyright  2012 ' & $sCompanyName_1 & ' (G.Sandler)'

Global $sPreview_Rast_Extensions		= 'BMP|JPEG|JPG|PNG|TIFF|TIF'		;Used to find image file name on desktop if the files extension are hidden
Global $sPreview_Ani_Extensions			= 'APNG|GIF|ANI|AVI' 				;Partialy implemented (gif, ani, avi)

Global $bMouseBlockDefProc				= False
Global $bMousePrimaryDown_Event			= False
Global $bMouseWheelSroll_Event			= False
Global $iMouseWheelSroll_Direction		= 0

Global $iDef_StartWithWindows			= 0 ;Start program with windows
Global $iDef_UseFileCopyMethod			= 0 ;Get selected file using file copy method ("Ctrl + INS" is sent to copy the file and get the path with ClipGet)
Global $iDef_EmptyWorkingSet			= 1 ;Empty process memory (can slow down preview display on slow machines)
Global $iDef_ShowTrayIcon				= 1 ;Show tray icon

Global $iDef_Preview_AutoSize			= 1 								;Preview AutoSize, if 0, $iDef_Preview_Width and $iDef_Preview_Height is used
Global $iDef_Preview_Width				= 400 								;Preview width
Global $iDef_Preview_Height				= 300 								;Preview height
Global $iDef_Preview_Delay				= 300 								;Preview delay (wait before the preview is shown after pressing mouse button)
Global $iDef_Preview_Fade				= 100 								;Preview fade speed, 0 to disable fade
Global $iDef_Preview_Frame_Mode			= 3 								;Preview frame mode: 0 - No frame, 1 - Simple frame, 2 - Shadow frame, 3 - Shadow + Simple frame
Global $iDef_Preview_InnerFrame_Width	= 2 								;Preview inner-simple frame width, used for $iDef_Preview_Frame_Mode
Global $iDef_Preview_InnerFrame_Color	= 0x606060							;Preview inner-simple frame color, used for $iPreview_Frame_Mode

Global $iStartWithWindows, $iUseFileCopyMethod, $iEmptyWorkingSet, $iShowTrayIcon
Global $iPreview_AutoSize, $iPreview_Width, $iPreview_Height, $iPreview_Delay, $iPreview_Fade, $iPreview_Frame_Mode, $iPreview_InnerFrame_Width, $iPreview_InnerFrame_Color

Global $hEmpty_Cursor					= __CreateEmptyCursor()

Global $oCOMError						= ObjEvent('AutoIt.Error', '__ObjectEvent')
Global $hPreview_GUI					= GUICreate('Preview - ' & $sApp_Name, $iPreview_Width, $iPreview_Height, -1, -1, $WS_POPUP, BitOR($WS_EX_TOPMOST, $WS_EX_TOOLWINDOW, $WS_EX_LAYERED))
GUISetCursor(16, 1, $hPreview_GUI)

#EndRegion Global Variables

#Region Options and initializing

;Must be checked at the begining
_Config_Read()

;This too
If $CmdLine[0] > 0 Then
	Switch $CmdLine[1]
		Case '/Settings'
			_Settings_GUI($sApp_Name & ' - Settings')
			
			If WinExists('[CLASS:AutoIt v3;TITLE:' & $sApp_Name & ']') Then
				MsgBox(262144+64, $sApp_Name, 'Please restart the program.')
			EndIf
		Case '/About'
			_About_GUI($sApp_Name & ' - About')
	EndSwitch
	
	Exit
EndIf

;Fix for keyboard layout issue for HotKeySet and other hotkeys functions
__WinAPI_LoadKeyboardLayout(0x0409)

If Not $iShowTrayIcon Then
	HotKeySet('^+q', '_Quit')
EndIf

Opt('WinWaitDelay', 0)
Opt('SendKeyDelay', 0)
Opt('SendKeyDownDelay', 0)

If WinExists('[CLASS:AutoIt v3;TITLE:' & $sApp_Name & ']') Then Exit
AutoItWinSetTitle($sApp_Name)

_GDIPlus_Startup()
_MouseSetEvents(1)

If $iEmptyWorkingSet Then
	_WinAPI_EmptyWorkingSet(@AutoItPID)
EndIf

#EndRegion Options and initializing

#Region Tray

Opt('TrayMenuMode', 3)
Opt('TrayOnEventMode', 1)

$iSettings_TrayItem = TrayCreateItem('Settings')
TrayItemSetOnEvent(-1, '_Tray_Events')
TrayItemSetState(-1, $TRAY_DEFAULT)
$iAbout_TrayItem = TrayCreateItem('About')
TrayItemSetOnEvent(-1, '_Tray_Events')
TrayCreateItem('')
$iExit_TrayItem = TrayCreateItem('Exit')
TrayItemSetOnEvent(-1, '_Tray_Events')

If $iShowTrayIcon Then
	TraySetState(1)
	TraySetIcon(_Iif(@Compiled, @AutoItExe, @ScriptDir & '\Resources\Icon.ico'))
	TraySetToolTip($sApp_Name)
	TraySetClick(16)
	TraySetOnEvent($TRAY_EVENT_SECONDARYUP, '_Tray_Events')
	TraySetOnEvent($TRAY_EVENT_SECONDARYDOWN, '_Tray_Events')
EndIf

#EndRegion Tray

#Region Main Loop

While 1
	Sleep(10)
	
	If $bMousePrimaryDown_Event Then
		_Preview_Event()
		$bMousePrimaryDown_Event = False
	EndIf
WEnd

#EndRegion Main Loop

#Region Program Functions

Func _About_GUI($sTitle, $hParent = 0)
	Local $aData[5], $aHyperLinks[3]
	
	$aData[0] = $sApp_Name
	$aData[1] = 'Version: ' & @CRLF & $sApp_Ver
	$aData[2] = _
		$sApp_Name & '(Impact,16)\n\n\nCredits:(,14,0x0,4)\n\nYashied\n(WinAPIEx.au3, ColorPicker.au3)\nAuthenticity\n(GDIP.au3)\n\nAutoIt Team\nAutoIt Community\nAutoIt Russian Community\n\n\n' & _
		'Tested on:(,14,0x0,4)\n\nWin 7 [x86, x64] / Win XP [x86](Tahoma,8,0xFF0000)'
	$aData[3] = $sCopyRight_String
	$aData[4] = 'Play sound'
	
	$aHyperLinks[0] = UBound($aHyperLinks) - 1
	$aHyperLinks[1] = $sCompanyName_1 & '|' & $sCopyRight_URL_1
	$aHyperLinks[2] = $sCompanyName_2 & '|' & $sCopyRight_URL_2
	
	_AboutBox($sTitle, $aData, $aHyperLinks, $hParent, _Iif(@Compiled, @AutoItExe, @ScriptDir & '\Resources\Icon.ico'), 0x0000FF, 0xFFFFFF, 1, -1, $WS_EX_TOPMOST)
EndFunc

Func _Settings_GUI($sTitle, $iWidth = 450, $iHeight = 530, $hParent = 0)
	Local $hGUI, $iStartWithWindows_CB, $iUseFileCopyMethod_CB, $iEmptyWorkingSet_CB, $iShowTrayIcon_CB
	Local $iPreview_AutoSize_CB, $iPreview_Width_Input, $iPreview_Height_Input, $iPreview_Delay_Input, $iPreview_Fade_Input
	Local $iPreview_Frame_Mode_Combo, $iPreview_InnerFrame_Width_Input, $iPreview_InnerFrame_Color_Picker
	Local $iOK_Button, $iCancel_Button
	Local $iColor, $iGroupTop
	
	If $iPreview_AutoSize Then
		$iPreview_Width = $iDef_Preview_Width
		$iPreview_Height = $iDef_Preview_Height
	EndIf
	
	GUISetState(@SW_DISABLE, $hParent)
	$hGUI = GUICreate($sTitle, $iWidth, $iHeight, -1, -1, -1, BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST, $WS_EX_APPWINDOW), $hParent)
	
	GUICtrlCreateLabel('Settings', 0, 15, $iWidth, 25, $SS_CENTER)
	GUICtrlSetFont(-1, 14, 800)
	
	GUICtrlCreateGroup('General', 20, 40, $iWidth - 40, 160)
	$iStartWithWindows_CB = GUICtrlCreateCheckbox('Start with Windows', 30, 60, -1, 15)
	If $iStartWithWindows Then GUICtrlSetState(-1, $GUI_CHECKED)
	$iUseFileCopyMethod_CB = GUICtrlCreateCheckbox('Use file copy method to get selected file', 30, 80, -1, 15)
	If $iUseFileCopyMethod Then GUICtrlSetState(-1, $GUI_CHECKED)
	$iEmptyWorkingSet_CB = GUICtrlCreateCheckbox('Empty process memory', 30, 100, -1, 15)
	If $iEmptyWorkingSet Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlCreateLabel('(can slow down preview display on slow machines)', 45, 120, -1, 15)
	GUICtrlSetColor(-1, 0x888888)
	$iShowTrayIcon_CB = GUICtrlCreateCheckbox('Show tray icon', 30, 140, -1, 15)
	If $iShowTrayIcon Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlCreateLabel('(if disabled, use <Ctrl + Shift + Q> to exit the program)', 45, 160, -1, 15)
	GUICtrlSetColor(-1, 0x888888)
	
	$iGroupTop = $iHeight - 260 - 40
	
	GUICtrlCreateGroup('Preview', 20, $iGroupTop, $iWidth - 40, 250)
	$iPreview_AutoSize_CB = GUICtrlCreateCheckbox('Preview AutoSize', 30, $iGroupTop + 20, -1, 15)
	GUICtrlCreateLabel('Preview Width:', 30, $iGroupTop + 47, -1, 15)
	$iPreview_Width_Input = GUICtrlCreateInput($iPreview_Width, $iWidth - 60 - 30, $iGroupTop + 45, 60, 20, $ES_NUMBER)
	GUICtrlCreateLabel('Preview Height:', 30, $iGroupTop + 72, -1, 15)
	$iPreview_Height_Input = GUICtrlCreateInput($iPreview_Height, $iWidth - 60 - 30, $iGroupTop + 70, 60, 20, $ES_NUMBER)
	GUICtrlCreateLabel('Preview Show Delay:', 30, $iGroupTop + 97, -1, 15)
	$iPreview_Delay_Input = GUICtrlCreateInput($iPreview_Delay, $iWidth - 60 - 30, $iGroupTop + 95, 60, 20, $ES_NUMBER)
	GUICtrlCreateLabel('Preview Show Fade:', 30, $iGroupTop + 122, -1, 15)
	$iPreview_Fade_Input = GUICtrlCreateInput($iPreview_Fade, $iWidth - 60 - 30, $iGroupTop + 120, 60, 20, $ES_NUMBER)
	GUICtrlCreateLabel('Preview Frame Mode:', 30, $iGroupTop + 147, -1, 15)
	$iPreview_Frame_Mode_Combo = GUICtrlCreateCombo('', $iWidth - 60 - 30, $iGroupTop + 145, 60, 20, BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSetData(-1, '0|1|2|3', $iPreview_Frame_Mode)
	GUICtrlCreateLabel('(0 - No frame, 1 - Simple frame, 2 - Shadow frame, 3 - Shadow + Simple frame)', 30, $iGroupTop + 170, -1, 15)
	GUICtrlSetColor(-1, 0x888888)
	GUICtrlCreateLabel('Preview Simple Frame Width:', 30, $iGroupTop + 192, -1, 15)
	$iPreview_InnerFrame_Width_Input = GUICtrlCreateInput($iPreview_InnerFrame_Width, $iWidth - 60 - 30, $iGroupTop + 190, 60, 20, $ES_NUMBER)
	GUICtrlCreateLabel('Preview Simple Frame Color:', 30, $iGroupTop + 217, -1, 15)
	$iPreview_InnerFrame_Color_Picker = _GUIColorPicker_Create('', $iWidth - 60 - 30, $iGroupTop + 215, 60, 20, $iPreview_InnerFrame_Color, _
		BitOR($CP_FLAG_CHOOSERBUTTON, $CP_FLAG_ARROWSTYLE, $CP_FLAG_MOUSEWHEEL), 0, 4, 5, 0, '', 'More...')
	
	If $iPreview_AutoSize Then
		GUICtrlSetState($iPreview_AutoSize_CB, $GUI_CHECKED)
		GUICtrlSetState($iPreview_Width_Input, $GUI_DISABLE)
		GUICtrlSetState($iPreview_Height_Input, $GUI_DISABLE)
	EndIf
	
	If $iPreview_Frame_Mode = 0 Or $iPreview_Frame_Mode = 2 Then
		GUICtrlSetState($iPreview_InnerFrame_Width_Input, $GUI_DISABLE)
		GUICtrlSetState($iPreview_InnerFrame_Color_Picker, $GUI_DISABLE)
	EndIf
	
	$iOK_Button = GUICtrlCreateButton('OK', 20, $iHeight - 30, 70, 20)
	$iCancel_Button = GUICtrlCreateButton('Cancel', 100, $iHeight - 30, 70, 20)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $iCancel_Button
				ExitLoop
			Case $iPreview_AutoSize_CB
				If GUICtrlRead($iPreview_AutoSize_CB) = $GUI_CHECKED Then
					GUICtrlSetState($iPreview_Width_Input, $GUI_DISABLE)
					GUICtrlSetState($iPreview_Height_Input, $GUI_DISABLE)
				Else
					GUICtrlSetState($iPreview_Width_Input, $GUI_ENABLE)
					GUICtrlSetState($iPreview_Height_Input, $GUI_ENABLE)
				EndIf
			Case $iPreview_Frame_Mode_Combo
				Switch GUICtrlRead($iPreview_Frame_Mode_Combo)
					Case 0, 2
						GUICtrlSetState($iPreview_InnerFrame_Width_Input, $GUI_DISABLE)
						GUICtrlSetState($iPreview_InnerFrame_Color_Picker, $GUI_DISABLE)
					Case Else
						GUICtrlSetState($iPreview_InnerFrame_Width_Input, $GUI_ENABLE)
						GUICtrlSetState($iPreview_InnerFrame_Color_Picker, $GUI_ENABLE)
				EndSwitch
			Case $iOK_Button
				;Read settings
				$iStartWithWindows = Number(GUICtrlRead($iStartWithWindows_CB) = $GUI_CHECKED)
				$iUseFileCopyMethod = Number(GUICtrlRead($iUseFileCopyMethod_CB) = $GUI_CHECKED)
				$iEmptyWorkingSet = Number(GUICtrlRead($iEmptyWorkingSet_CB) = $GUI_CHECKED)
				$iShowTrayIcon = Number(GUICtrlRead($iShowTrayIcon_CB) = $GUI_CHECKED)
				
				$iPreview_AutoSize = Number(GUICtrlRead($iPreview_AutoSize_CB) = $GUI_CHECKED)
				$iPreview_Width = GUICtrlRead($iPreview_Width_Input)
				$iPreview_Height = GUICtrlRead($iPreview_Height_Input)
				$iPreview_Fade = GUICtrlRead($iPreview_Fade_Input)
				$iPreview_Frame_Mode = GUICtrlRead($iPreview_Frame_Mode_Combo)
				$iPreview_InnerFrame_Width = GUICtrlRead($iPreview_InnerFrame_Width_Input)
				$iPreview_InnerFrame_Color = '0x' & Hex(_GUIColorPicker_GetColor($iPreview_InnerFrame_Color_Picker), 6)
				
				If $iStartWithWindows Then
					RegWrite("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run", "SIP", "REG_SZ", _Iif(@Compiled, @ScriptFullPath, @AutoItExe & ' "' & @ScriptFullPath & '"'))
				Else
					RegDelete("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run", "SIP")
				EndIf
				
				If $iShowTrayIcon Then
					HotKeySet('^+q')
				Else
					HotKeySet('^+q', '_Quit')
				EndIf
				
				_Config_Write()
				
				ExitLoop
		EndSwitch
		
		If $bMousePrimaryDown_Event Then
			_Preview_Event()
			$bMousePrimaryDown_Event = False
		EndIf
	WEnd
	
	_GUIColorPicker_Delete($iPreview_InnerFrame_Color_Picker)
	GUISetState(@SW_ENABLE, $hParent)
	GUIDelete($hGUI)
EndFunc

Func _Tray_Events()
	_MouseSetEvents(0)
	
	Switch @TRAY_ID
		Case $iSettings_TrayItem, $iAbout_TrayItem
			TraySetState(2)
			
			If @TRAY_ID = $iSettings_TrayItem Then
				_Settings_GUI($sApp_Name & ' - Settings')
			Else
				_About_GUI($sApp_Name & ' - About')
			EndIf
			
			If $iShowTrayIcon Then
				TraySetState(1)
			EndIf
		Case $iExit_TrayItem
			Exit
	EndSwitch
	
	_MouseSetEvents(1)
EndFunc

Func _Preview_Event()
	If Not $bMousePrimaryDown_Event Then
		Return SetError(1)
	EndIf
	
	Local $tPoint, $hWinFromPoint, $sWinClassName, $sWinClassNameNN, $hExplorer, $sOldClip, $sImage_Path, $sImage_Ext, $iAniCtrl, $bImageIsAni, $aSize, $aIcon, $hIcon, $hImage, $hPreview, $hGraphics, $hPen
	Local $iTimer_Init, $aMouse_Init, $hOld_Cursor, $iOld_DragWidth, $iOld_DragHeight
	
	$bImageIsAni = False
	
	$tPoint = _WinAPI_GetMousePos()
	$hWinFromPoint = _WinAPI_WindowFromPoint($tPoint)
	$sWinClassName = _WinAPI_GetClassName($hWinFromPoint)
	$sWinClassNameNN = __WinAPI_GetClassNameNN($hWinFromPoint, $hExplorer)
	
	If Not StringRegExp($sWinClassNameNN, '^(SysListView321|DirectUIHWND3)$') Then
		Return SetError(5)
	EndIf
	
	$hExplorer = __WinActiveEx('[REGEXPCLASS:((Cabinet|Explore)WClass|Progman|WorkerW)]')
	
	If Not IsHWnd($hExplorer) Then
		$hExplorer = _WinAPI_GetAncestor($hWinFromPoint, $GA_ROOTOWNER)
		
		If Not IsHWnd($hExplorer) Or Not StringRegExp($sWinClassName, '^((Cabinet|Explore)WClass|Progman|WorkerW)$') Then
			Return SetError(2)
		EndIf
	EndIf
	
	If $iUseFileCopyMethod Then
		$sOldClip = ClipGet()
		ClipPut('')
		
		SendKeepActive($hExplorer)
		Send('^{INS}')
		SendKeepActive('')
		
		$iTimer_Init = TimerInit()
		
		Do
		Until ClipGet() <> '' Or TimerDiff($iTimer_Init) >= 1000
		
		$sImage_Path = ClipGet()
		ClipPut($sOldClip)
	Else
		$sImage_Path = __Explorer_GetSelectedItem($hExplorer)
	EndIf
	
	If @error Or Not FileExists($sImage_Path) Then
		Return SetError(3)
	EndIf
	
	$sImage_Ext = StringRegExpReplace($sImage_Path, '^.*\.([^\.]*)$', '\1')
	
	If StringRegExp($sImage_Ext, '(?i)^(' & $sPreview_Ani_Extensions & ')$') Then
		;Handle here the animation stuff to preview
		$bImageIsAni = True
		
		GUISetStyle(-1, BitOR($WS_EX_TOPMOST, $WS_EX_TOOLWINDOW), $hPreview_GUI)
		
		;Use ANI UDF instead
		Switch $sImage_Ext
			Case 'Avi'
				$iAniCtrl = _GUICtrlAVI_Create($hPreview_GUI, '', -1, 0, 0, $iPreview_Width, $iPreview_Height, BitOR($ACS_TRANSPARENT, $ACS_AUTOPLAY, $ACS_CENTER))
				;$iAniCtrl = GUICtrlCreateAvi($sImage_Path, 0, 0, 0, $iPreview_Width, $iPreview_Height, BitOR($ACS_TRANSPARENT, $ACS_AUTOPLAY, $ACS_CENTER))
				
				If _GUICtrlAVI_Open($iAniCtrl, $sImage_Path) = False Then
					Return SetError(-1)
				EndIf
			Case 'Ani'
				$iAniCtrl = GUICtrlCreateIcon($sImage_Path, 0, ($iPreview_Width / 2) - 16, ($iPreview_Height / 2) - 16, 32, 32)
			Case 'Gif'
				$aSize = __GetGifSize($sImage_Path)
				
				If UBound($aSize) < 2 Then
					Dim $aSize[2]
				EndIf
				
				If $aSize[0] > $iPreview_Width Then
					$aSize[0] = $iPreview_Width - 20
				EndIf
				
				If $aSize[1] > $iPreview_Height Then
					$aSize[1] = $iPreview_Height - 20
				EndIf
				
				$iAniCtrl = _GUICtrlPic_Create($sImage_Path, ($iPreview_Width / 2) - ($aSize[0] / 2), ($iPreview_Height / 2) - ($aSize[1] / 2), $aSize[0], $aSize[1])
			Case Else
				Return SetError(4)
		EndSwitch
	Else
		GUISetStyle(-1, BitOR($WS_EX_TOPMOST, $WS_EX_TOOLWINDOW, $WS_EX_LAYERED), $hPreview_GUI)
	EndIf
	
	If StringRegExp($sImage_Path, '(?i)^.*\.(ico)$') Then
		Dim $aBitCount[5] = [32, 24, 8, 4, 1]
		
		For $i = 0 To UBound($aBitCount)-1
			$aIcon = __WinAPI_GetLargestIcon($sImage_Path, $aBitCount[$i])
			
			If $aIcon[0] > -1 Then
				ExitLoop
			EndIf
		Next
		
		$hIcon = _WinAPI_ShellExtractIcon($sImage_Path, -$aIcon[0], $aIcon[1], $aIcon[2])
		$hImage = __GDIPlus_BitmapCreateFromHICONEx($hIcon)
		_WinAPI_DestroyIcon($hIcon)
	EndIf
	
	If Not $bImageIsAni Then
		If Not $hImage Then
			$hImage = _GDIPlus_ImageLoadFromFile($sImage_Path)
		EndIf
		
		If @error Or Not $hImage Then
			Return SetError(6)
		EndIf
	EndIf
	
	$iTimer_Init = TimerInit()
	$aMouse_Init = _MouseInit()
	$hOld_Cursor = _WinAPI_CopyCursor(_WinAPI_LoadCursor(0, $OCR_NORMAL))
	
	$iOld_DragWidth = RegRead('HKEY_CURRENT_USER\Control Panel\Desktop', 'DragWidth')
	$iOld_DragHeight = RegRead('HKEY_CURRENT_USER\Control Panel\Desktop', 'DragHeight')
	
	While $bMousePrimaryDown_Event
		Sleep(10)
		
		If $iTimer_Init <> -1 And TimerDiff($iTimer_Init) >= $iPreview_Delay Then
			$iTimer_Init = -1
			
			;Mouse has moved
			If _MouseDiff($aMouse_Init) <> 0 Then
				ExitLoop
			EndIf
			
			;Disabling file drag (can be bugie on XP)
			;_WinAPI_SystemParametersInfo($SPI_SETDRAGWIDTH, 9999, 0, $SPIF_SENDCHANGE)
			;_WinAPI_SystemParametersInfo($SPI_SETDRAGHEIGHT, 9999, 0, $SPIF_SENDCHANGE)
			
			;This should be better to avoid "rename action" problems
			MouseMove($aMouse_Init[0]+$iOld_DragWidth+1, $aMouse_Init[1], 0)
			MouseUp('Main')
			SendKeepActive($hExplorer)
			Send('{ESC}')
			SendKeepActive('')
			MouseMove($aMouse_Init[0], $aMouse_Init[1], 0)
			$bMousePrimaryDown_Event = True
			
			If $bImageIsAni Then
				Switch $sImage_Ext
					Case 'Avi'
						_GUICtrlAVI_Play($iAniCtrl)
					Case 'Ani'
						
					Case 'Gif'
						
				EndSwitch
				
				_PreviewMove_Proc()
				GUISetState(@SW_SHOWNOACTIVATE, $hPreview_GUI)
			Else
				$hPreview = __GDIPlus_ImageCreatePreview($hImage, 0, $iPreview_Frame_Mode, $iPreview_AutoSize, $iPreview_Width, $iPreview_Height, $iPreview_InnerFrame_Width, $iPreview_InnerFrame_Color)
				If Not $hPreview Then ExitLoop
				
				If $iPreview_AutoSize Then
					$iPreview_Width = _GDIPlus_ImageGetWidth($hPreview)
					$iPreview_Height = _GDIPlus_ImageGetHeight($hPreview)
				EndIf
				
				_PreviewMove_Proc()
				
				;Updated before GUI is shown, to prevent old image to blink before we show our new image
				;_WinAPI_UpdateLayeredWindowEx($hPreview_GUI, -1, -1, _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage), 0, 1)
				GUISetState(@SW_SHOWNOACTIVATE, $hPreview_GUI)
				__GDIPlus_ImageShowPreview($hPreview_GUI, $hPreview, 1, $iPreview_Fade)
			EndIf
			
			;Set mouse cursor to Empty/Drag cursor
			_WinAPI_SetSystemCursor($hEmpty_Cursor, $OCR_NORMAL)
		ElseIf $iTimer_Init = -1 Then
			_PreviewMove_Proc($hPreview, $hImage)
		EndIf
	WEnd
	
	;_WinAPI_SystemParametersInfo($SPI_SETDRAGWIDTH, $iOld_DragWidth, 0, $SPIF_SENDCHANGE)
	;_WinAPI_SystemParametersInfo($SPI_SETDRAGHEIGHT, $iOld_DragHeight, 0, $SPIF_SENDCHANGE)
	_WinAPI_SetSystemCursor($hOld_Cursor, $OCR_NORMAL)
	
	If $hImage Then
		_WinAPI_UpdateLayeredWindowEx($hPreview_GUI, -1, -1, _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage), 0, 1)
		_GDIPlus_ImageDispose($hImage)
	EndIf
	
	If $iAniCtrl Then
		Switch $sImage_Ext
			Case 'Avi'
				_GUICtrlAVI_Close($iAniCtrl)
				_GUICtrlAVI_Destroy($iAniCtrl)
			Case 'Gif'
				_GUICtrlPic_Delete($iAniCtrl)
				ContinueCase
			Case Else
				GUICtrlDelete($iAniCtrl)
		EndSwitch
	EndIf
	
	GUISetState(@SW_HIDE, $hPreview_GUI)
	
	If $iEmptyWorkingSet Then
		_WinAPI_EmptyWorkingSet(@AutoItPID)
	EndIf
EndFunc

Func _PreviewMove_Proc($hPreview = 0, $hImage = 0)
	Local $aMPos = MouseGetPos()
	
	Local $iLeft = $aMPos[0] - ($iPreview_Width / 2)
	Local $iTop = $aMPos[1] - ($iPreview_Height / 2)
	Local $iRight = $aMPos[0] + ($iPreview_Width / 2)
	Local $iBottom = $aMPos[1] + ($iPreview_Height / 2)
	
	If $iLeft < 0 Then $iLeft = 0
	If $iTop < 0 Then $iTop = 0
	If $iRight > @DesktopWidth Then $iLeft = @DesktopWidth - $iPreview_Width
	If $iBottom > (@DesktopHeight) Then $iTop = @DesktopHeight - $iPreview_Height
	
	If $bMouseWheelSroll_Event Then
		$bMouseWheelSroll_Event = False
		
		Local $iZoom = -50
		
		If $iMouseWheelSroll_Direction = 1 Then
			$iZoom = +50
		EndIf
		
		;Size the graphic here...
		;__GDIPlus_ImageZoomPreview($hPreview_GUI, $hPreview, $iZoom)
	EndIf
	
	WinMove($hPreview_GUI, "", $iLeft, $iTop, $iPreview_Width, $iPreview_Height)
EndFunc

Func _MouseInit()
	Return MouseGetPos()
EndFunc

Func _MouseDiff($a_InitMousePos)
	Local $a_DiffMousePos = MouseGetPos()
	Local $aRetDiffs[2]
	
	If $a_DiffMousePos[0] = $a_InitMousePos[0] And $a_DiffMousePos[1] = $a_InitMousePos[1] Then
		Return 0 ;No differences
	EndIf
	
	For $i = 0 To 1
		$aRetDiffs[$i] = $a_DiffMousePos[$i] - $a_InitMousePos[$i]
	Next
	
	Return $aRetDiffs
EndFunc

Func _MouseSetEvents($iSet)
	If $iSet Then
		_MouseSetOnEvent($MOUSE_PRIMARYDOWN_EVENT, '__MousePrimary_Event', 0, -1)
		_MouseSetOnEvent($MOUSE_PRIMARYUP_EVENT, '__MousePrimary_Event', 0, 0)
		_MouseSetOnEvent($MOUSE_WHEELSCROLLDOWN_EVENT, '__MouseWheelScroll_Event', 0, 0)
		_MouseSetOnEvent($MOUSE_WHEELSCROLLUP_EVENT, '__MouseWheelScroll_Event', 0, 0)
	Else
		_MouseSetOnEvent($MOUSE_PRIMARYDOWN_EVENT)
		_MouseSetOnEvent($MOUSE_PRIMARYUP_EVENT)
		_MouseSetOnEvent($MOUSE_WHEELSCROLLDOWN_EVENT)
		_MouseSetOnEvent($MOUSE_WHEELSCROLLUP_EVENT)
	EndIf
EndFunc

Func _Config_Read()
	$iStartWithWindows = __IniRead($sApp_Config, 'Main', 'StartWithWindows', $iDef_StartWithWindows)
	$iUseFileCopyMethod = __IniRead($sApp_Config, 'Main', 'UseFileCopyMethod', $iDef_UseFileCopyMethod)
	$iEmptyWorkingSet = __IniRead($sApp_Config, 'Main', 'EmptyWorkingSet', $iDef_EmptyWorkingSet)
	$iShowTrayIcon = __IniRead($sApp_Config, 'Main', 'ShowTrayIcon', $iDef_ShowTrayIcon)
	
	$iPreview_AutoSize = __IniRead($sApp_Config, 'Preview', 'Preview_AutoSize', $iDef_Preview_AutoSize)
	$iPreview_Width = __IniRead($sApp_Config, 'Preview', 'Preview_Width', $iDef_Preview_Width)
	$iPreview_Height = __IniRead($sApp_Config, 'Preview', 'Preview_Height', $iDef_Preview_Height)
	$iPreview_Delay = __IniRead($sApp_Config, 'Preview', 'Preview_Delay', $iDef_Preview_Delay)
	$iPreview_Fade = __IniRead($sApp_Config, 'Preview', 'Preview_Fade', $iDef_Preview_Fade)
	$iPreview_Frame_Mode = __IniRead($sApp_Config, 'Preview', 'Preview_Frame_Mode', $iDef_Preview_Frame_Mode)
	$iPreview_InnerFrame_Width = __IniRead($sApp_Config, 'Preview', 'Preview_InnerFrame_Width', $iDef_Preview_InnerFrame_Width)
	$iPreview_InnerFrame_Color = __IniRead($sApp_Config, 'Preview', 'Preview_InnerFrame_Color', $iDef_Preview_InnerFrame_Color, 0)
EndFunc

Func _Config_Write()
	IniWrite($sApp_Config, 'Main', 'StartWithWindows', $iStartWithWindows)
	IniWrite($sApp_Config, 'Main', 'UseFileCopyMethod', $iUseFileCopyMethod)
	IniWrite($sApp_Config, 'Main', 'EmptyWorkingSet', $iEmptyWorkingSet)
	IniWrite($sApp_Config, 'Main', 'ShowTrayIcon', $iShowTrayIcon)
	
	IniWrite($sApp_Config, 'Preview', 'Preview_AutoSize', $iPreview_AutoSize)
	IniWrite($sApp_Config, 'Preview', 'Preview_Width', $iPreview_Width)
	IniWrite($sApp_Config, 'Preview', 'Preview_Height', $iPreview_Height)
	IniWrite($sApp_Config, 'Preview', 'Preview_Delay', $iPreview_Delay)
	IniWrite($sApp_Config, 'Preview', 'Preview_Fade', $iPreview_Fade)
	IniWrite($sApp_Config, 'Preview', 'Preview_Frame_Mode', $iPreview_Frame_Mode)
	IniWrite($sApp_Config, 'Preview', 'Preview_InnerFrame_Width', $iPreview_InnerFrame_Width)
	IniWrite($sApp_Config, 'Preview', 'Preview_InnerFrame_Color', $iPreview_InnerFrame_Color)
EndFunc

Func _Quit()
	Exit
EndFunc

#EndRegion Program Functions

#Region Internal functions

Func __MousePrimary_Event($iEvent)
	Switch $iEvent
		Case $MOUSE_PRIMARYDOWN_EVENT
			$bMousePrimaryDown_Event = True
			Return $bMouseBlockDefProc
		Case $MOUSE_PRIMARYUP_EVENT
			$bMousePrimaryDown_Event = False
	EndSwitch
EndFunc

Func __MouseWheelScroll_Event($iEvent)
	If $bMousePrimaryDown_Event Then
		$bMouseWheelSroll_Event = True
		
		Switch $iEvent
			Case $MOUSE_WHEELSCROLLDOWN_EVENT
				$iMouseWheelSroll_Direction = -1
			Case $MOUSE_WHEELSCROLLUP_EVENT
				$iMouseWheelSroll_Direction = 1
		EndSwitch
	EndIf
EndFunc

Func __Explorer_GetSelectedItem($hWnd)
	If Not IsHWnd($hWnd) Then
		Return SetError(1)
	EndIf
	
	If StringRegExp(_WinAPI_GetClassName($hWnd), '^(Progman|WorkerW)$') Then
		Local $sSelected, $hSearch
		Local $hLV = ControlGetHandle($hWnd, "", "SysListView321")
		Local $iIndex = _GUICtrlListView_GetSelectedIndices($hLV)
		
		If $iIndex = "" Then
			Return SetError(2)
		EndIf
		
		$sSelected = _GUICtrlListView_GetItemText($hLV, Int($iIndex))
		
		If Not FileExists(@DesktopDir & "\" & $sSelected) Then ;Search the extension for file...
			$hSearch = FileFindFirstFile(@DesktopDir & "\" & $sSelected & ".*")
			
			While 1
				$sSelected = FileFindNextFile($hSearch)
				If @error Then Return SetError(3)
				
				If StringRegExp($sSelected, '(?i)^.*\.(' & $sPreview_Rast_Extensions & ')$') Then
					ExitLoop
				EndIf
			WEnd
			
			FileClose($hSearch)
		EndIf
		
		Return @DesktopDir & '\' & $sSelected
	Else
		Local $oSHFolderView = __ObjectSHFolderViewFromWin($hWnd)
		
		If @error Or Not IsObj($oSHFolderView) Then
			Return SetError(4)
		EndIf
		
		Local $oSelectedFolderItems = $oSHFolderView.SelectedItems
		
		For $oFolderItem In $oSelectedFolderItems
			If FileExists($oFolderItem.Path) Then
				Return $oFolderItem.Path
			EndIf
		Next
	EndIf
	
	Return SetError(5)
EndFunc

Func __GDIPlus_ImageCreatePreview($hImage, $fDelete = 0, $iFrameMode = -1, $iAutoSize = 1, $iWidth = -1, $iHeight = -1, $iFrameWidth = 1, $iFrameColor = 0x606060)
	Local $aSize = _GDIPlus_ImageGetDimension($hImage)
	If Not IsArray($aSize) Then Return 0
	
	If $iAutoSize Then
		Local Const $iMin = 128, $iMax = 512
		Local $aTmpSize = $aSize, $aK[2] = [1, 1]
		
		For $i = 0 To 1
			If $aTmpSize[$i] > $iMax Then
				$aK[$i] = $iMax / $aTmpSize[$i]
			EndIf
		Next
		
		For $i = 0 To 1
			If $aK[1] > $aK[0] Then
				$aTmpSize[$i] *= $aK[0]
			Else
				$aTmpSize[$i] *= $aK[1]
			EndIf
			
			If $aTmpSize[$i] < $iMin Then $aTmpSize[$i] = $iMin
		Next
		
		$iWidth = $aTmpSize[0] + 36
		$iHeight = $aTmpSize[1] + 36
	EndIf
	
	Local $aPart[4][5] = [[17, 5, $iWidth - 34, 12, -90], [$iWidth - 17, 17, 12, $iHeight - 34, 0], [17, $iHeight - 17, $iWidth - 34, 12, 90], [5, 17, 12, $iHeight - 34, 180]]
	Local $aK[2] = [1, 1]
	Local $aSize, $tRect, $hGraphics, $hBrush, $hPen, $hPreview
	
	If ($iWidth - 36) < $aSize[0] Then
		$aK[0] = ($iWidth - 36) / $aSize[0]
	EndIf
	
	If ($iHeight - 36) < $aSize[1] Then
		$aK[1] = ($iHeight - 36) / $aSize[1]
	EndIf
	
	For $i = 0 To 1
		If $aK[1] > $aK[0] Then
			$aSize[$i] *= $aK[0]
		Else
			$aSize[$i] *= $aK[1]
		EndIf
	Next
	
	$hPreview = _GDIPlus_BitmapCreateFromScan0($iWidth, $iHeight)
	$hGraphics = _GDIPlus_ImageGetGraphicsContext($hPreview)
	_GDIPlus_GraphicsClear($hGraphics, 0)
	
	$hBrush = _GDIPlus_BrushCreateSolid(0x28000000)
	_GDIPlus_GraphicsFillRect($hGraphics, 17, 17, $iWidth - 34, $iHeight - 34, $hBrush)
	_GDIPlus_BrushDispose($hBrush)
	
	$hBrush = _GDIPlus_HatchBrushCreate(50, 0xFFFFFFFF, 0xFFEBEBEB) ;$HatchStyleLargeCheckerBoard = 50
	_GDIPlus_GraphicsFillRect($hGraphics, 18, 18, $iWidth - 36, $iHeight - 36, $hBrush)
	_GDIPlus_GraphicsDrawImageRect($hGraphics, $hImage, Round(($iWidth - $aSize[0]) / 2), Round(($iHeight - $aSize[1]) / 2), $aSize[0], $aSize[1])
	_GDIPlus_BrushDispose($hBrush)
	
	Switch $iFrameMode
		Case 2, 3 ;Shadow (3 with inner-simple frame, 2 without it)
			__GDIPlus_GraphicsDrawRadialGradient($hGraphics, 17, 17, 12, 0x28000000, 0, -180, -90)
			__GDIPlus_GraphicsDrawRadialGradient($hGraphics, $iWidth - 17, 17, 12, 0x28000000, 0, -90, 0)
			__GDIPlus_GraphicsDrawRadialGradient($hGraphics, $iWidth - 17, $iHeight - 17, 12, 0x28000000, 0, 0, 90)
			__GDIPlus_GraphicsDrawRadialGradient($hGraphics, 17, $iHeight - 17, 12, 0x28000000, 0, 90, 180)
			
			For $i = 0 To 3
				$tRect = DllStructCreate($tagGDIPRECTF)
				
				For $j = 0 To 4
					DllStructSetData($tRect, $j + 1, $aPart[$i][$j])
				Next
				
				$hBrush = _GDIPlus_LineBrushCreateFromRectWithAngle($tRect, 0x28000000, 0, $aPart[$i][4], 0, 3)
				_GDIPlus_GraphicsFillRect($hGraphics, $aPart[$i][0], $aPart[$i][1], $aPart[$i][2], $aPart[$i][3], $hBrush)
				_GDIPlus_BrushDispose($hBrush)
			Next
			
			If $iFrameMode = 3 Then ContinueCase
		Case 1 ;Simple frame
			$hPen = _GDIPlus_PenCreate('0xFF' & Hex($iFrameColor, 6), $iFrameWidth, 2)
			_GDIPlus_GraphicsDrawRect($hGraphics, 17, 17, $iWidth - 36, $iHeight - 36, $hPen)
			_GDIPlus_PenDispose($hPen)
		Case 0 ;No frame (Default)
			
	EndSwitch
	
	_GDIPlus_GraphicsDispose($hGraphics)
	
	If ($hPreview) And ($fDelete) Then
		_GDIPlus_ImageDispose($hImage)
	EndIf
	
	Return $hPreview
EndFunc

Func __GDIPlus_ImageShowPreview($hWnd, $hPreview, $fDelete = 0, $iSpeed = 100, $iX = -1, $iY = -1)
	Local $iW, $iH, $aSize, $iTimer, $iDelay, $hGraphics, $hImage
	
	If Not IsHWnd($hWnd) Then Return 0
	
	$aSize = _GDIPlus_ImageGetDimension($hPreview)
	If Not IsArray($aSize) Then Return 0
	
	If ($iX <> -1) And ($iY <> -1) Then
		$iX -= $aSize[0] / 2
		$iY -= $aSize[1] / 2
	EndIf
	
	$hImage = _GDIPlus_BitmapCreateFromScan0($aSize[0], $aSize[1])
	$hGraphics = _GDIPlus_ImageGetGraphicsContext($hImage)
	
	For $i = 15 To 255 Step 40
		$iTimer = TimerInit()
		
		If $i = 255 Then
			$iW = $aSize[0]
			$iH = $aSize[1]
		Else
			$iW = Round($aSize[0] * Sin(2 * ATan(1) * $i / 255))
			If Mod($iW, 2) Then $iW += 1
			
			$iH = Round($aSize[1] * Sin(2 * ATan(1) * $i / 255))
			If Mod($iH, 2) Then $iH += 1
		EndIf
		
		_GDIPlus_GraphicsDrawImageRect($hGraphics, $hPreview, ($aSize[0] - $iW) / 2, ($aSize[1] - $iH) / 2, $iW, $iH)
		_WinAPI_UpdateLayeredWindowEx($hWnd, $iX, $iY, _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage), $i, 1)
		
		$iDelay = $iSpeed / 7 - TimerDiff($iTimer)
		If $iDelay < 0 Then $iDelay = 0
		
		$iTimer = TimerInit()
		
		Do
		Until TimerDiff($iTimer) >= $iDelay
	Next
	
	_GDIPlus_GraphicsDispose($hGraphics)
	_GDIPlus_ImageDispose($hImage)
	
	If $fDelete Then
		_GDIPlus_ImageDispose($hPreview)
	EndIf
	
	Return 1
EndFunc

Func __GDIPlus_GraphicsDrawRadialGradient($hGraphics, $iX, $iY, $iRadius, $iARGB1, $iARGB2, $iStartAngle = 0, $iEndAngle = 360, $iStep = 5)
	If $iStep < 1 Then $iStep = 1
	
	Local $Xi = $iX - $iRadius, $Yi = $iY - $iRadius, $Di = 2 * $iRadius
	Local $hBrush, $hMatrix, $Smooth = _GDIPlus_GraphicsGetSmoothingMode($hGraphics)
	Local $iStart = True
	
	_GDIPlus_GraphicsSetSmoothingMode($hGraphics, 0)
	$hBrush = _GDIPlus_LineBrushCreate(0, 0, $iRadius, 0, $iARGB1, $iARGB2, 3)
	$hMatrix = _GDIPlus_MatrixCreate()
	_GDIPlus_MatrixTranslate($hMatrix, $iX, $iY)
	
	While $iStartAngle < $iEndAngle
		If $iStartAngle + $iStep > $iEndAngle Then
			$iStep = $iEndAngle - $iStartAngle
		EndIf
		
		If $iStart Then
			_GDIPlus_MatrixRotate($hMatrix, $iStartAngle + $iStep / 2)
			$iStart = False
		Else
			_GDIPlus_MatrixRotate($hMatrix, $iStep)
		EndIf
		
		_GDIPlus_LineBrushSetTransform($hBrush, $hMatrix)
		_GDIPlus_GraphicsFillPie($hGraphics, $Xi, $Yi, $Di, $Di, $iStartAngle, $iStep, $hBrush)
		$iStartAngle += $iStep
	WEnd
	
	_GDIPlus_GraphicsSetSmoothingMode($hGraphics, $Smooth)
	_GDIPlus_MatrixDispose($hMatrix)
	_GDIPlus_BrushDispose($hBrush)
	
	Return 1
EndFunc

Func __GDIPlus_BitmapCreateFromHICONEx($hIcon)
	Local $iW, $iH, $tBITMAP, $tBits, $tData, $aIcon, $hImage = 0
	
	$aIcon = _WinAPI_GetIconInfo($hIcon)
	
	If (Not IsArray($aIcon)) Or (Not $aIcon[5]) Then
		Return 0
	EndIf
	
	If Not _WinAPI_IsAlphaBitmap($aIcon[5]) Then
		$hImage = _GDIPlus_BitmapCreateFromHICON($hIcon)
	Else
		Do
			$tBITMAP = DllStructCreate($tagBITMAP)
			
			If (Not _WinAPI_GetObject($aIcon[5], DllStructGetSize($tBITMAP), DllStructGetPtr($tBITMAP))) Or (DllStructGetData($tBITMAP, 'bmBitsPixel') <> 32) Then
				ExitLoop
			EndIf
			
			$iW = DllStructGetData($tBITMAP, 'bmWidth')
			$iH = DllStructGetData($tBITMAP, 'bmHeight')
			$tBits = DllStructCreate('byte[' & ($iW * $iH * 4) & ']')
			
			If Not _WinAPI_GetBitmapBits($aIcon[5], DllStructGetSize($tBits), DllStructGetPtr($tBits)) Then
				ExitLoop
			EndIf
			
			$hImage = _GDIPlus_BitmapCreateFromScan0($iW, $iH)
			
			If Not $hImage Then
				ExitLoop
			EndIf
			
			$tData = _GDIPlus_BitmapLockBits($hImage, 0, 0, $iW, $iH, $GDIP_ILMWRITE, $GDIP_PXF32ARGB)
			
			If Not _WinAPI_MoveMemory(DllStructGetData($tData, 'Scan0'), DllStructGetPtr($tBits), DllStructGetSize($tBits)) Then
				; Nothing
			EndIf
			
			_GDIPlus_BitmapUnlockBits($hImage, $tData)
		Until 1
	EndIf
	
	For $i = 4 To 5
		_WinAPI_DeleteObject($aIcon[$i])
	Next
	
	Return $hImage
EndFunc

Func __GetGifSize($hfile)
    Local $read = FileRead($hfile)
    If StringLeft($read, 3) <> 'GIF'  Then Return
    Local $ret[2] = [Dec(Hex(BinaryMid($read, 7, 1))) + Dec(Hex(BinaryMid($read, 8, 1))) * 256, Dec(Hex(BinaryMid($read, 9, 1))) + Dec(Hex(BinaryMid($read, 10, 1))) * 256]
    Local $packed = Dec(Hex(BinaryMid($read, 11, 1)))
    Return SetExtended(2 ^ (BitAND($packed, 7) + 1) * ($packed > 127), $ret)
EndFunc

Func __ObjectSHFolderViewFromWin($hWnd, $iRetWindowsObj = 0)
	If Not IsHWnd($hWnd) Then Return SetError(1, 0, 0)
	Local $oShell, $oShellWindows, $oIEObject, $oSHFolderView
	
	; Shell Object
	$oShell = ObjCreate("Shell.Application")
	If Not IsObj($oShell) Then Return SetError(2, 0, 0)
	
	;Get a 'ShellWindows Collection' object
	$oShellWindows = $oShell.Windows()
	If Not IsObj($oShellWindows) Then Return SetError(3, 0, 0)
	
	If $iRetWindowsObj Then Return $oShellWindows
	
	;Iterate through the collection - each of type 'InternetExplorer' Object
	
	For $oIEObject In $oShellWindows
		If $oIEObject.HWnd = $hWnd Then
			; InternetExplorer->Document = ShellFolderView object
			$oSHFolderView = $oIEObject.Document
			
			If IsObj($oSHFolderView) Then
				Return $oSHFolderView
			EndIf
			
			Return SetError(4, 0, 0)
		EndIf
	Next
	
	Return SetError(-1, 0, 0)
EndFunc

Func __ObjectEvent()
	SetError(1)
EndFunc

Func __WinActiveEx($sTitle, $iVisible = 1)
	If Not $iVisible Then
		Return WinActive($sTitle)
	EndIf
	
	Local $aWinList = WinList($sTitle)
	
	For $i = 1 To UBound($aWinList)-1
		If BitAND(WinGetState($aWinList[$i][1]), 2) = 2 And WinActive($aWinList[$i][1]) Then
			Return $aWinList[$i][1]
		EndIf
	Next
	
	Return WinActive($sTitle)
EndFunc

Func __WinAPI_GetClassNameNN($hCtrlWnd, $hWinWnd = 0)
	If $hWinWnd = 0 Then
		$hWinWnd = _WinAPI_GetAncestor($hCtrlWnd, $GA_ROOTOWNER)
	EndIf
	
	$hCtrlWnd = ControlGetHandle($hWinWnd, "", $hCtrlWnd)
	$sClassName = _WinAPI_GetClassName($hCtrlWnd)
	$aClassList = StringSplit(WinGetClassList($hWinWnd), @CRLF)
    
	For $iC In $aClassList
		If $iC = $sClassName Then
			For $j = 1 To UBound($aClassList)
				If ControlGetHandle($hWinWnd, "", $iC & $j) = $hCtrlWnd Then
					Return $iC & $j
				EndIf
			Next
		EndIf
	Next
	
	Return $sClassName
EndFunc

Func __WinAPI_GetLargestIcon($sFile, $iBitCount = 32)
	Local Const $tagICOHEADER = 'ushort Reserved;ushort Type;ushort Count'
	Local Const $tagICOENTRY = 'byte Width;byte Height;byte ColorCount;byte Reserved;ushort Planes;ushort BitCount;long Size;long Offset'
	Local Const $tagIHDR = 'dword Width;dword Height;byte BitDepth;byte ColorType;byte CompressionMethod;byte FilterMethod;byte InterlaceMethod'
	
	Local $iSize, $tData, $pData, $hFile, $tHdr, $iCount, $i, $tEntry, $pIcon, $iOffset, $iWidth, $iHeight, $sPng
	Local $aRet[3] = [-1]
	
	$iSize = FileGetSize($sFile)
	$tData = DllStructCreate('byte[' & $iSize & ']')
	$pData = DllStructGetPtr($tData)
	
	$hFile = _WinAPI_CreateFile($sFile, 2, 2, 6)
	_WinAPI_ReadFile($hFile, $pData, $iSize, $iSize)
	_WinAPI_CloseHandle($hFile)
	
	$tHdr = DllStructCreate($tagICOHEADER, $pData)
	$iCount = DllStructGetData($tHdr, 'Count')
	
	For $i = 1 To $iCount
		$tEntry = DllStructCreate($tagICOENTRY, $pData + 6 + 16 * ($i - 1))
		$pIcon = $pData + DllStructGetData($tEntry, 'Offset')
		$iOffset = DllStructGetData($tEntry, 'Offset')
		
		If DllStructGetData(DllStructCreate('byte[8]', $pIcon), 1) = Binary('0x89504E470D0A1A0A') Then
			; PNG => Retrieve IHDR chunk data (always first chunk, offset = 8)
			$tHdr = DllStructCreate($tagIHDR, $pIcon + 16)
			$iWidth = _WinAPI_SwapDWord(DllStructGetData($tHdr, 'Width'))
			$iHeight = _WinAPI_SwapDWord(DllStructGetData($tHdr, 'Height'))
		Else
			; ICO => Retrieve BITMAPINFOHEADER structure
			$tHdr = DllStructCreate($tagBITMAPINFOHEADER, $pIcon)
			$iWidth = DllStructGetData($tHdr, 'biWidth')
			$iHeight = DllStructGetData($tHdr, 'biHeight') / 2
		EndIf
		
		If DllStructGetData($tEntry, 'BitCount') = $iBitCount And $iWidth + $iHeight > $aRet[1] + $aRet[2] Then
			$aRet[0] = $i - 1
			$aRet[1] = $iWidth
			$aRet[2] = $iHeight
		EndIf
	Next
	
	Return $aRet
EndFunc

Func __WinAPI_LoadKeyboardLayout($sLayoutID, $hWnd = 0)
	Local Const $WM_INPUTLANGCHANGEREQUEST = 0x50
	Local $aRet = DllCall("user32.dll", "long", "LoadKeyboardLayoutW", "wstr", Hex($sLayoutID, 8), "int", 0)
	
	If Not @error And $aRet[0] Then
		If $hWnd = 0 Then
			$hWnd = WinGetHandle(AutoItWinGetTitle())
		EndIf
		
		DllCall("user32.dll", "ptr", "SendMessage", "hwnd", $hWnd, "int", $WM_INPUTLANGCHANGEREQUEST, "int", 1, "int", $aRet[0])
		Return 1
	EndIf
	
	Return SetError(1)
EndFunc

Func __CreateEmptyCursor()
	Local $hBitmap[2], $hCursor
	
	$hBitmap[0] = _WinAPI_CreateBitmap(1, 1, 1, 16)
	$hBitmap[1] = _WinAPI_InvertANDBitmap(_WinAPI_CreateBitmap(1, 1, 1, 1), 1)
	$hCursor = _WinAPI_CreateIconIndirect($hBitmap[0], $hBitmap[1], 0, 0, 0)
	
	For $i = 0 To 1
		_WinAPI_DeleteObject($hBitmap[$i])
	Next
	
	Return $hCursor
EndFunc

Func __IniRead($sFile, $sSect, $sKey, $sDefault, $iCheckInt = 1)
	Local $sRead = IniRead($sFile, $sSect, $sKey, $sDefault)
	
	If $iCheckInt And StringIsDigit($sRead) Then
		$sRead = Int($sRead)
	EndIf
	
	Return $sRead
EndFunc

#EndRegion Internal functions
