#Region Header

#CS Info
	Title:          _AboutBox UDF
    Filename:       AboutBox.au3
    Description:    Shows "About program" dialog box with few nice features.
    Author:         G.Sandler a.k.a (Mr)CreatoR (CreatoR's Lab - www.creator-lab.ucoz.ru, www.autoit-script.ru)
    Version:        0.6
    Requirements:   AutoIt v3.3.6.1 +, Developed/Tested on WinXP Service Pack 2/3, Win 7 (rus).
	
    Uses:           Constants.au3, GUIConstantsEx.au3, StaticConstants.au3, WindowsConstants.au3, GDIPlus.au3, Misc.au3, WinAPI.au3.
	Forum Link:     http://www.autoitscript.com/forum/index.php?showtopic=64738
    
	Notes:          * This UDF registers $WM_ACTIVATE and $WM_MOVE using GUIRegisterMsg.
	                * Global variable (option) $ABOUTBOX_PlaySound can be used to set initial sound playing state.
	
	Credits:		Un4seen Developments (BASSMOD.dll), Yashied (Help with cover for scrolling GUI).
#CE

#CS Example
	#include "AboutBox.au3"
	
	_Example()
	
	Func _Example()
		Local $hParent_GUI, $iMainMenu, $iAbout_MenuItem, $aAccelKeys
		Local $sTitle, $sScrollText, $sMainLabel, $sCopyRLabel, $iLinkColor, $iBkColor, $aHyperLinks[4], $aData[5]
		
		$hParent_GUI = GUICreate('Parent For "About Program" Demo', 330, 100)
		
		$iMainMenu = GUICtrlCreateMenu("Help")
		$iAbout_MenuItem = GUICtrlCreateMenuItem("About...	(F1)", $iMainMenu)
		
		Dim $aAccelKeys[1][2] = [["{F1}", $iAbout_MenuItem]]
		GUISetAccelerators($aAccelKeys, $hParent_GUI)
		
		GUISetState(@SW_SHOW, $hParent_GUI)
		
		;Set for initial state
		$ABOUTBOX_PlaySound = 1
		
		While 1
			Switch GUIGetMsg()
				Case $GUI_EVENT_CLOSE
					Exit
				Case $iAbout_MenuItem
					$sTitle = "About Info"
					
					$aData[0] = "My program Name"
					$aData[1] = "Version: " & @CRLF & "v1.0"
					$aData[2] = "I want to express special gratitude to:\n\n\n\nAutoIt Team\n\nAutoIt Community\n\nAutoIt Russian Community\n\n\n\n\n... and many other good people"
					$aData[3] = "Copyright  " & @YEAR & " Company/Author. All rights reserved."
					$aData[4] = "Play sound"
					
					$iLinkColor = 0x0000FF
					$iBkColor = 0xFFFFFF
					
					$aHyperLinks[0] = UBound($aHyperLinks) - 1
					$aHyperLinks[1] = "App Web Page|http://www.autoitscript.com"
					$aHyperLinks[2] = "Email|mailto:my_email@mail.com"
					$aHyperLinks[3] = "Some additional link|http://personalwebpafe.com"
					
					_AboutBox($sTitle, $aData, $aHyperLinks, $hParent_GUI, @AutoItExe, $iLinkColor, $iBkColor)
			EndSwitch
		WEnd
	EndFunc
#CE

#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <GDIPlus.au3>
#include <Misc.au3>
#include <WinAPI.au3>

#EndRegion Header

#Region Global Variables

Global $__AboutBox_hAboutGUI, $__AboutBox_hScrollGUI, $__AboutBox_iScrollLabel
Global $__AboutBox_hWinProc, $__AboutBox_ahScrollBrush[2]
Global $__AboutBox_iScrollWidth = 300, $__AboutBox_iScrollHeight = 200, $__AboutBox_iScrollCoverHeight = 50
Global $__AboutBox_iScrollPos, $__AboutBox_iFirstScroll, $__AboutBox_iScrollLines
Global $__AboutBox_iScrollTimer, $__AboutBox_iScrollSpeed = 1
Global $__AboutBox_iLastMouseYPos = -1, $__AboutBox_iIsScrolling = 0
Global $__AboutBox_sSoundFile = @SystemDir & "\oobe\images\title.wma"

Global $bMousePrimaryDown_Event = False

#EndRegion Global Variables

#Region Public Variables

Global $ABOUTBOX_PlaySound = 1
Global $ABOUTBOX_TempDir = @TempDir

#EndRegion Public Variables

#Region Public Functions

; #FUNCTION# ====================================================================================================
; Name...........:	_AboutBox
; Description....:	Shows "About program" dialog box.
;
; Syntax.........:	_AboutBox($sTitle, $aData, $aHyperLinks, $hParent = 0, $sIconFile = "", $iLinkColor = 0x0000FF, $iBkColor = 0xFFFFFF, $iScrlBorder = 1, $iStyle = -1, $iExStyle = -1)
;
; Parameters.....:	$sTitle         - Window title.
;					$aData          - 1D Array with text data, the data should be stored as follows:
;					                                              $aData[0] - Main text to be displayed at the top of About window.
;					                                              $aData[1] - The text to be displayed on the front of About window.
;					                                              $aData[2] - The text that will be scrolling from up to down.
;					                                              $aData[3] - Copyright line, displayed at the bottom of About window.
;					                                              $aData[4] - "Play sound" checkbox text.
;					$aHyperLinks    - 1D Array with hyperlinks info, the data should be stored as follows (up to 5 hyperlinks allowed):
;                                                                 $aHyperLinks[0] = 2
;                                                                 $aHyperLinks[1] = "App Web Page|http://www.autoitscript.com"
;                                                                 $aHyperLinks[2] = "Email|mailto:my_email@mail.com"
;					$hParent     - [Optional] Parent window handle (default is 0, no parent).
;					$sIconFile   - [Optional] Icon file, will be displayed at the left-top side of About window (default is "", no icon).
;					$iLinkColor  - [Optional] Initial color of the hyperlinks (default is 0x0000FF - Blue).
;					$iBkColor    - [Optional] Background color of the About window (default is 0xFFFFFF - White).
;					$iScrlBorder - [Optional] Defines whether the scrolling box will have a border or not (default is 1).
;					$iStyle      - [Optional] Defines the style of the window (use -1 for the default style, as used in AutoIt GUI window).
;					$iExStyle    - [Optional] Defines the extended style of the window (use -1 for the default exstyle, as used in AutoIt GUI window).
;					
; Return values..:	Success      - None.
;					Failure      - Returns 0 and sets @error as follows:
;                                                                        1 - $aHyperLinks includes more than 5 elements.
;                                                                        2 - The GUI window cannot be created.
;
; Author.........:	G.Sandler a.k.a (Mr)CreatoR (CreatoR's Lab - www.creator-lab.ucoz.ru, www.autoit-script.ru)
; Modified.......:	
; Remarks........:	Registers $WM_ACTIVATE and $WM_MOVE using GUIRegisterMsg.
; Related........:	
; Link...........:	
; Example........:	Yes.
; ===============================================================================================================
Func _AboutBox($sTitle, $aData, $aHyperLinks, $hParent = 0, $sIconFile = "", $iLinkColor = 0x0000FF, $iBkColor = 0xFFFFFF, $iScrlBorder = 1, $iStyle = -1, $iExStyle = -1)
	Local $iWidth = 600, $iHeight = 400, $iLeft = -1, $iTop = -1
	Local $iHyperLinks_Count = UBound($aHyperLinks)
	Local $anLinkLabel[$iHyperLinks_Count][2] = [[$iHyperLinks_Count - 1]], $iLinkTop = 120, $iDelim_Pos, $sURL, $sURL_Title
	Local $sMainLabelText = $aData[0], $sBodyText = $aData[1], $sScrollText = $aData[2], $sCopyRText = $aData[3], $sPlaySndText = $aData[4]
	Local $ahAbout_Sound
	
	$sScrollText = StringReplace($sScrollText, "\n", @CRLF)
	$__AboutBox_iScrollLines = @extended * 15 ;15 = Text line width (need more calculations - check separetly empty lines and text lines, for empty line it's probably less than 15...)
	
	If $iHyperLinks_Count > 6 Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $iOld_GOEM_Opt = Opt("GUIOnEventMode", 0)
	Local $iOld_WWD_Opt = Opt("WinWaitDelay", 0)
	
	;Forced/Default styles
	If $iExStyle = -1 Then $iExStyle = 0
	$iExStyle = BitOR($WS_EX_TOOLWINDOW, $iExStyle)
	
	If IsHWnd($hParent) Then
		WinSetState($hParent, "", @SW_DISABLE)
	Else
		$iExStyle = BitOR($WS_EX_APPWINDOW, $iExStyle)
	EndIf
	
	$__AboutBox_hAboutGUI = GUICreate($sTitle, $iWidth, $iHeight, $iLeft, $iTop, $iStyle, $iExStyle, $hParent)
	If @error Then Return SetError(2, 0, 0)
	
	GUISetBkColor($iBkColor)
	
	GUICtrlCreateLabel($sMainLabelText, 45, 20, $iWidth - 90, 40, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 14)
	
	GUICtrlCreateIcon($sIconFile, 0, 10, 20, 32, 32)
	GUICtrlSetState(-1, 128)
	
	GUICtrlCreateGraphic(5, 75, $iWidth - 10, 3, $SS_ETCHEDFRAME)
	
	For $i = 1 To $iHyperLinks_Count - 1
		$iDelim_Pos = StringInStr($aHyperLinks[$i], "|")
		$sURL = StringTrimLeft($aHyperLinks[$i], $iDelim_Pos)
		$sURL_Title = StringLeft($aHyperLinks[$i], $iDelim_Pos - 1)
		
		If $sURL = "" Then
			ContinueLoop
		EndIf
		
		$anLinkLabel[$i][0] = __AboutBox_GUICtrlHyperlink_Create($sURL_Title, $iWidth - 150, $iLinkTop, -1, 15, $iLinkColor, $sURL, $SS_CENTER)
		$anLinkLabel[$i][1] = $sURL
		
		$iLinkTop += 30
	Next
	
	$iPlayMusic_CB = GUICtrlCreateCheckbox($sPlaySndText, 10, 82, -1, 18)
	If $ABOUTBOX_PlaySound Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetFont(-1, 8)
	
	GUICtrlCreateLabel($sBodyText, 10, 120, 115, $iHeight/2)
	GUICtrlSetFont(-1, 10, 600, 0, "Tahoma")
	
	GUICtrlCreateLabel($sCopyRText, 0, $iHeight - 20, $iWidth, -1, 1)
	GUICtrlSetColor(-1, 0x969696)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	_GDIPlus_Startup()
	
	Local $tRect = DllStructCreate($tagGDIPRECTF)
	DllStructSetData($tRect, 1, 0)
	DllStructSetData($tRect, 2, 0)
	DllStructSetData($tRect, 3, $__AboutBox_iScrollWidth)
	DllStructSetData($tRect, 4, $__AboutBox_iScrollCoverHeight)
	
	$__AboutBox_ahScrollBrush[0] = __AboutBox_GDIPlus_LineBrushCreateFromRect($tRect, '0xFF' & Hex($iBkColor, 6), '0x00' & Hex($iBkColor, 6), 1)
	$__AboutBox_ahScrollBrush[1] = __AboutBox_GDIPlus_LineBrushCreateFromRect($tRect, '0x00' & Hex($iBkColor, 6), '0xFF' & Hex($iBkColor, 6), 1)
	
	$__AboutBox_hScrollGUI = GUICreate('hScroll', $__AboutBox_iScrollWidth, $__AboutBox_iScrollHeight, -1, -1, BitOR($WS_POPUP, _Iif($iScrlBorder = 1, $WS_BORDER, 0)), $WS_EX_COMPOSITED, $__AboutBox_hAboutGUI)
	If @error Then Return SetError(2, 0, 0)
	GUISetBkColor($iBkColor)
	
	GUICtrlCreateLabel('', 0, 0, $__AboutBox_iScrollWidth, $__AboutBox_iScrollHeight)
	GUICtrlSetState(-1, $GUI_DISABLE)
	Local $hCover_Label = GUICtrlGetHandle(-1)
	
	$__AboutBox_iScrollPos = -$__AboutBox_iScrollHeight
	$__AboutBox_iScrollLabel = GUICtrlCreateLabel($sScrollText, 0, -$__AboutBox_iScrollPos, $__AboutBox_iScrollWidth, $__AboutBox_iScrollLines, $SS_CENTER)
	GUICtrlSetCursor(-1, 0)
	GUICtrlSetFont(-1, 8.5, 0, 0, "Tahoma")
	
	Local $hWinProc_CallBack = DllCallbackRegister('__AboutBox_WinProc', 'ptr', 'hwnd;uint;wparam;lparam')
	$__AboutBox_hWinProc = _WinAPI_SetWindowLong($hCover_Label, $GWL_WNDPROC, DllCallbackGetPtr($hWinProc_CallBack))
	
	__AboutBox_WM_MESSAGE($__AboutBox_hAboutGUI, $WM_MOVE, 0, 0)
	
	GUISetState(@SW_SHOW, $__AboutBox_hAboutGUI)
	GUISetState(@SW_SHOW, $__AboutBox_hScrollGUI)
	GUIRegisterMsg($WM_ACTIVATE, '__AboutBox_WM_MESSAGE')
	GUIRegisterMsg($WM_MOVE, '__AboutBox_WM_MESSAGE')
	
	Local $hScroll_CallBack = DllCallbackRegister("__AboutBox_ScrollText_CallBack", "none", "hwnd;int;int;dword")
	Local $ahScroll_Timer = DllCall("user32.dll", "int", "SetTimer", "hwnd", $__AboutBox_hScrollGUI, "int", 1001, "int", 10, "ptr", DllCallbackGetPtr($hScroll_CallBack))
	
	GUISwitch($__AboutBox_hAboutGUI)
	WinActivate($__AboutBox_hAboutGUI)
	
	$bSndFilesExists = FileExists(@ScriptDir & "\Resources\BASSMOD.DLL") And FileExists(@ScriptDir & "\Resources\About.xm")
	
	If $bSndFilesExists Then
		FileChangeDir(@ScriptDir)
		FileInstall("Resources\BASSMOD.DLL", $ABOUTBOX_TempDir & "\BASSMOD.DLL", 1)
		FileInstall("Resources\About.xm", $ABOUTBOX_TempDir & "\About.xm", 1)
	EndIf
	
	If $ABOUTBOX_PlaySound Then
		If $bSndFilesExists Then
			$ahAbout_Sound = __AboutBox_BASSMOD_Start($ABOUTBOX_TempDir & "\BASSMOD.dll", $ABOUTBOX_TempDir & "\About.xm", 1024+4)
		EndIf
		
		If @error Or Not $bSndFilesExists Then
			SoundPlay($__AboutBox_sSoundFile, 0)
		EndIf
	EndIf
	
	While 1
		$iAbout_Msg = GUIGetMsg()
		
		Switch $iAbout_Msg
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $iPlayMusic_CB
				If GUICtrlRead($iPlayMusic_CB) = $GUI_CHECKED Then
					$ABOUTBOX_PlaySound = 1
					
					If $ABOUTBOX_PlaySound Then
						If $bSndFilesExists Then
							$ahAbout_Sound = __AboutBox_BASSMOD_Start($ABOUTBOX_TempDir & "\BASSMOD.dll", $ABOUTBOX_TempDir & "\About.xm", 1024+4)
						EndIf
						
						If @error Or Not $bSndFilesExists Then
							SoundPlay($__AboutBox_sSoundFile, 0)
						EndIf
					EndIf
				Else
					$ABOUTBOX_PlaySound = 0
					
					If IsArray($ahAbout_Sound) Then
						__AboutBox_BASSMOD_Close($ahAbout_Sound[0], $ahAbout_Sound[1])
						If @error Then SoundPlay("")
					Else
						SoundPlay("")
					EndIf
				EndIf
			Case $anLinkLabel[1][0] To $anLinkLabel[$anLinkLabel[0][0]][0]
				For $i = 1 To $anLinkLabel[0][0]
					If $iAbout_Msg = $anLinkLabel[$i][0] Then
						__AboutBox_GUICtrlHyperlink_Handler($__AboutBox_hAboutGUI, $anLinkLabel[$i][0], $anLinkLabel[$i][1], -1, 0x551A8B)
						ExitLoop
					EndIf
				Next
		EndSwitch
		
		If $bMousePrimaryDown_Event Then
			_Preview_Event()
			$bMousePrimaryDown_Event = False
		EndIf
	WEnd
	
	If IsArray($ahAbout_Sound) Then
		__AboutBox_BASSMOD_Close($ahAbout_Sound[0], $ahAbout_Sound[1])
		
		If Not @error Then
			FileDelete($ABOUTBOX_TempDir & "\BASSMOD.DLL")
			FileDelete($ABOUTBOX_TempDir & "\About.xm")
		Else
			SoundPlay("")
		EndIf
	Else
		SoundPlay("")
	EndIf
	
	If IsHWnd($hParent) Then
		WinSetState($hParent, "", @SW_ENABLE)
	EndIf
	
	GUIDelete($__AboutBox_hAboutGUI)
	GUISwitch($hParent)
	
	DllCall("user32.dll", "int", "KillTimer", "hwnd", $__AboutBox_hScrollGUI, "int", $ahScroll_Timer[0])
	DllCallbackFree($hScroll_CallBack)
	
	_WinAPI_SetWindowLong($hCover_Label, $GWL_WNDPROC, $__AboutBox_hWinProc)
    DllCallbackFree($hWinProc_CallBack)
	
	_GDIPlus_BrushDispose($__AboutBox_ahScrollBrush[0])
	_GDIPlus_BrushDispose($__AboutBox_ahScrollBrush[1])
	_GDIPlus_Shutdown()
	
	Opt("GUIOnEventMode", $iOld_GOEM_Opt)
	Opt("WinWaitDelay", $iOld_WWD_Opt)
EndFunc

#EndRegion Public Functions

#Region Internal Functions

Func __AboutBox_WM_MESSAGE($hWnd, $iMsg, $wParam, $lParam)
	Switch $iMsg
		Case $WM_MOVE
			If $hWnd = $__AboutBox_hAboutGUI Then
				Local $aPos = WinGetPos($hWnd)
				Local $aClientSize = WinGetClientSize($hWnd)
				Local $iBorder = ($aPos[2] - $aClientSize[0]) / 2
				Local $iCaption = $aPos[3] - $aClientSize[1] - $iBorder
				
				WinMove($__AboutBox_hScrollGUI, '', $aPos[0] + ($aPos[2] / 2) - (302 / 2), $aPos[1] + $iCaption + 120)
				
				If $wParam = 0 Then Return 0
			EndIf
		Case $WM_ACTIVATE
			If BitAND($wParam, 0xFFFF) And $hWnd <> $__AboutBox_hAboutGUI Then
				WinActivate($__AboutBox_hAboutGUI)
			EndIf
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

Func __AboutBox_WinProc($hWnd, $iMsg, $wParam, $lParam)
    Switch $iMsg
        Case $WM_PAINT
            Local $tPAINT, $tRect, $hDC, $hGraphic
			
            $hDC = __AboutBox_WinAPI_BeginPaint($hWnd, $tPAINT)
            $hGraphic = _GDIPlus_GraphicsCreateFromHDC($hDC)
            _GDIPlus_GraphicsFillRect($hGraphic, 0, 0, $__AboutBox_iScrollWidth, $__AboutBox_iScrollCoverHeight, $__AboutBox_ahScrollBrush[0])
            _GDIPlus_GraphicsFillRect($hGraphic, 0, $__AboutBox_iScrollHeight - $__AboutBox_iScrollCoverHeight, $__AboutBox_iScrollWidth, $__AboutBox_iScrollCoverHeight, $__AboutBox_ahScrollBrush[1])
            _GDIPlus_GraphicsDispose($hGraphic)
            __AboutBox_WinAPI_EndPaint($hWnd, $tPAINT)
			
            Return 0
	EndSwitch
	
    Return _WinAPI_CallWindowProc($__AboutBox_hWinProc, $hWnd, $iMsg, $wParam, $lParam)
EndFunc

Func __AboutBox_ScrollText_CallBack($hWnd, $iMsg, $wParam, $lParam)
	Local $iCurrent_Mouse_YPos = MouseGetPos(1)
	Local $iScroll_Speed
	
	If Not $__AboutBox_iIsScrolling And $__AboutBox_iLastMouseYPos <> $iCurrent_Mouse_YPos Then
		$__AboutBox_iLastMouseYPos = -1
	EndIf
	
	If _IsPressed(1) And ($__AboutBox_iIsScrolling Or __AboutBox_Control_GetHovered() = GUICtrlGetHandle($__AboutBox_iScrollLabel)) Then
		$__AboutBox_iIsScrolling = 1
		
		If $__AboutBox_iLastMouseYPos < $iCurrent_Mouse_YPos Then ;Move down
			$iScroll_Speed = ($iCurrent_Mouse_YPos - $__AboutBox_iLastMouseYPos)
			If $__AboutBox_iLastMouseYPos = -1 Then $iScroll_Speed = 1
			$__AboutBox_iScrollPos -= $iScroll_Speed
			
			GUICtrlSetPos($__AboutBox_iScrollLabel, 0, -$__AboutBox_iScrollPos)
			;ControlMove($__AboutBox_hScrollGUI, '', $__AboutBox_iScrollLabel, 0, -$__AboutBox_iScrollPos)
		ElseIf $__AboutBox_iLastMouseYPos > $iCurrent_Mouse_YPos Then ;Move up
			$iScroll_Speed = ($__AboutBox_iLastMouseYPos - $iCurrent_Mouse_YPos)
			If $__AboutBox_iLastMouseYPos = -1 Then $iScroll_Speed = 1
			$__AboutBox_iScrollPos += $iScroll_Speed
			
			GUICtrlSetPos($__AboutBox_iScrollLabel, 0, -$__AboutBox_iScrollPos)
			;ControlMove($__AboutBox_hScrollGUI, '', $__AboutBox_iScrollLabel, 0, -$__AboutBox_iScrollPos)
		EndIf
		
		GUICtrlSetCursor($__AboutBox_iScrollLabel, 11)
		
		$__AboutBox_iLastMouseYPos = MouseGetPos(1)
		$__AboutBox_iScrollTimer = TimerInit()
		$__AboutBox_iFirstScroll = 1
		
		If $__AboutBox_iScrollPos > $__AboutBox_iScrollLines Then
			$__AboutBox_iScrollPos = -$__AboutBox_iScrollHeight
		ElseIf $__AboutBox_iScrollPos < -$__AboutBox_iScrollLines Then
			$__AboutBox_iScrollPos = $__AboutBox_iScrollHeight
		EndIf
		
		Return
	ElseIf $__AboutBox_iIsScrolling Then
		$__AboutBox_iIsScrolling = 0
		GUICtrlSetCursor($__AboutBox_iScrollLabel, 0)
	EndIf
	
	If ($__AboutBox_iFirstScroll And TimerDiff($__AboutBox_iScrollTimer) > 1000) Or (Not $__AboutBox_iFirstScroll And TimerDiff($__AboutBox_iScrollTimer) > 30) Then
		$__AboutBox_iFirstScroll = 0
		$__AboutBox_iScrollTimer = TimerInit()
		$__AboutBox_iScrollPos += $__AboutBox_iScrollSpeed
		
		GUICtrlSetPos($__AboutBox_iScrollLabel, 0, -$__AboutBox_iScrollPos)
		;ControlMove($__AboutBox_hScrollGUI, '', $__AboutBox_iScrollLabel, 0, -$__AboutBox_iScrollPos)
		
		If $__AboutBox_iScrollPos > ($__AboutBox_iScrollLines + $__AboutBox_iScrollHeight) Then
			$__AboutBox_iScrollPos = -$__AboutBox_iScrollHeight
		EndIf
	EndIf
	
	;__AboutBox_WinProc($__AboutBox_hAboutGUI, $WM_MOVE, 0, 0)
EndFunc

Func __AboutBox_Control_GetHovered()
	Local $iOld_Opt_MCM = Opt("MouseCoordMode", 1)
	Local $Ret = DllCall("user32.dll", "hwnd", "WindowFromPoint", "long", MouseGetPos(0), "long", MouseGetPos(1))
	
	Opt("MouseCoordMode", $iOld_Opt_MCM)
	
	Return HWnd($Ret[0])
EndFunc

Func __AboutBox_GUICtrlHyperlink_Create($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $iColor = 0x0000FF, $sToolTip = '', $iStyle = -1, $iExStyle = -1)
	If $iWidth = -1 Then
		$iWidth = __AboutBox_GUICtrlLabelGetTextWidth($sText)
		$iWidth = $iWidth[0]
		
		If Not $iWidth Then
			$iWidth = -1
		EndIf
	EndIf
	
	If $iStyle <> -1 And BitAND($iStyle, $SS_CENTER) Then
		$iLeft += -($iWidth / 2) + 70
	EndIf
	
	Local $ID = GUICtrlCreateLabel($sText, $iLeft, $iTop, $iWidth, $iHeight, $iStyle, $iExStyle)
	
	If $ID Then
		GUICtrlSetFont($ID, -1, -1, 4)
		GUICtrlSetColor($ID, $iColor)
		GUICtrlSetCursor($ID, 0)
		GUICtrlSetTip($ID, $sToolTip)
	EndIf
	
	Return $ID
EndFunc

Func __AboutBox_GUICtrlHyperlink_Handler($hWnd, $iCtrlID, $sActionURL, $iAction = -1, $iVisitedColor = 0x551A8B)
	Local $aCurInfo = GUIGetCursorInfo($hWnd)
	
	If Not IsArray($aCurInfo) Then
		Return SetError(1, 0, 0)
	EndIf
	
	While IsArray($aCurInfo) And $aCurInfo[2] = 1
		$aCurInfo = GUIGetCursorInfo($hWnd)
		
		If $aCurInfo[4] <> $iCtrlID Then
			GUISetCursor(7, 1, $hWnd)
		Else
			GUISetCursor(2, 0, $hWnd)
		EndIf
		
		Sleep(10)
	WEnd
	
	GUISetCursor(2, 0, $hWnd)
	
	If IsArray($aCurInfo) And $aCurInfo[4] = $iCtrlID Then
		If $iAction = 1 Then
			Execute($sActionURL)
		ElseIf $iAction = -1 Then
			__AboutBox_ShellExecuteEx($sActionURL)
		EndIf
		
		If @error = 0 And $iVisitedColor Then
			GUICtrlSetColor($iCtrlID, $iVisitedColor)
		EndIf
		
		Return 1
	EndIf
	
	Return SetError(1, 0, 0)
EndFunc

Func __AboutBox_GUICtrlLabelGetTextWidth($s_Data, $i_FontSize = 8.5, $i_FontWeight = -1, $s_TextFont = "Arial")
	Local Const $DEFAULT_CHARSET = 0 ; ANSI character set
	Local Const $OUT_CHARACTER_PRECIS = 2
	Local Const $CLIP_DEFAULT_PRECIS = 0
	Local Const $PROOF_QUALITY = 2
	Local Const $FIXED_PITCH = 1
	Local Const $RGN_XOR = 3
	Local Const $LOGPIXELSY = 90
	
	If $i_FontWeight = "" Or $i_FontWeight = -1 Then
		$i_FontWeight = 400 ; default Font weight
	EndIf
	
	Local $hDC = _WinAPI_GetDC(0)
	Local $intDeviceCap = _WinAPI_GetDeviceCaps($hDC, $LOGPIXELSY)
	Local $intFontHeight = _WinAPI_MulDiv($i_FontSize, $intDeviceCap, 72)
	Local $hFont = _WinAPI_CreateFont(-$intFontHeight, 0, 0, 0, $i_FontWeight, 0, 0, 0, _
		$DEFAULT_CHARSET, $OUT_CHARACTER_PRECIS, $CLIP_DEFAULT_PRECIS, $PROOF_QUALITY, $FIXED_PITCH, $s_TextFont)
	
	_WinAPI_SelectObject($hDC, $hFont)
	Local $stRet = _WinAPI_GetTextExtentPoint32($hDC, $s_Data)
	
	_WinAPI_DeleteObject($hFont)
    _WinAPI_ReleaseDC(0, $hDC)
    ;_WinAPI_InvalidateRect(0, 0)
	
	Local $a_RetLen[2] = [DllStructGetData($stRet, 1), DllStructGetData($stRet, 2)]
	Return $a_RetLen
EndFunc

Func __AboutBox_GDIPlus_LineBrushCreateFromRect($tRectF, $iARGBClr1, $iARGBClr2, $iGradientMode = 0, $iWrapMode = 0)
	Local $pRectF, $aResult
	
	$pRectF = DllStructGetPtr($tRectF)
	$aResult = DllCall($ghGDIPDll, "uint", "GdipCreateLineBrushFromRect", "ptr", $pRectF, "uint", $iARGBClr1, "uint", $iARGBClr2, "int", $iGradientMode, "int", $iWrapMode, "int*", 0)
	
	If @error Then Return SetError(@error, @extended, 0)
	Return $aResult[6]
EndFunc

Func __AboutBox_WinAPI_BeginPaint($hWnd, ByRef $tPAINTSTRUCT)
	Local Const $tagPAINTSTRUCT = 'hwnd hDC;int fErase;dword rPaint[4];int fRestore;int fIncUpdate;byte rgbReserved[32];'
	$tPAINTSTRUCT = DllStructCreate($tagPAINTSTRUCT)
	
	Local $Ret = DllCall('user32.dll', 'hwnd', 'BeginPaint', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tPAINTSTRUCT))
	
	If (@error) Or (Not $Ret[0]) Then
		$tPAINTSTRUCT = 0
		Return SetError(1, 0, 0)
	EndIf
	
	Return $Ret[0]
EndFunc

Func __AboutBox_WinAPI_EndPaint($hWnd, ByRef $tPAINTSTRUCT)
	Local $Ret = DllCall('user32.dll', 'int', 'EndPaint', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tPAINTSTRUCT))
	
	If (@error) Or (Not $Ret[0]) Then
		Return SetError(1, 0, 0)
	EndIf
	
	Return 1
EndFunc

Func __AboutBox_BASSMOD_Start($sDllFile, $sSoundFile, $iFlag)
	If Not FileExists($sDllFile) Then
		Return SetError(1, 0, -1)
	EndIf
	
	Local $aRet[2]
	Local $hDll = DllOpen($sDllFile)
	
	If $hDll = -1 Then
		SetError(2, 0, -1)
	EndIf
	
	Local $Init = DllCall($hDll, "int", "BASSMOD_Init", "int", -1, _  ;device
		"int", 44100, _  ;freq Hz
		"int", 0)       ;flag
	
	Local $stFileName = DllStructCreate("char[255]")
	DllStructSetData($stFileName, 1, $sSoundFile)
	
	Local $aMusicLoad = DllCall($hDll, "int", "BASSMOD_MusicLoad", "int", False, _  ;loading from memory
		"ptr", DllStructGetPtr($stFileName), _ ;file
		"int", 0, _   ;offset
		"int", 0, _   ;length
		"int", $iFlag) ;flag
	
	Local $hSound = $aMusicLoad[0]
	DllCall($hDll, "int:cdecl", "BASSMOD_MusicPlay", "int", $hSound)
	
	$aRet[0] = $hDll
	$aRet[1] = $hSound
	
	Return $aRet
EndFunc

Func __AboutBox_BASSMOD_Close($hDll, $hSound)
	If $hDll = -1 Then
		Return SetError(1, 0, -1)
	EndIf
	
	DllCall($hDll, "int:cdecl", "BASSMOD_Free", "int", $hSound) ;clear resource
	DllClose($hDll)
EndFunc

Func __AboutBox_ShellExecuteEx($sCmd, $Args = "", $sFolder = "", $Verb = "", $rState = @SW_SHOWNORMAL, $hWnd = 0)
	Local $struINFO = DllStructCreate("long;long;long;ptr;ptr;ptr;ptr;long;long;long;ptr;long;long;long;long")
	Local $struVerb = DllStructCreate("char[15];char")
	Local $struPath = DllStructCreate("char[255];char")
	Local $struArgs = DllStructCreate("char[255];char")
	Local $struWDir = DllStructCreate("char[255];char")
	
	DllStructSetData($struVerb, 1, $Verb)
	
	If StringRight($sCmd, 3) = "lnk" Then
		Local $aShortcutInfo = FileGetShortcut($sCmd)
		
		If IsArray($aShortcutInfo) Then
			DllStructSetData($struPath, 1, $aShortcutInfo[0])
			DllStructSetData($struWDir, 1, $aShortcutInfo[1])
			DllStructSetData($struArgs, 1, $aShortcutInfo[2])
			$rState = $aShortcutInfo[6]
		Else
			Return SetError(1, 0, 0)
		EndIf
	Else
		DllStructSetData($struPath, 1, $sCmd)
		DllStructSetData($struWDir, 1, $sFolder)
		DllStructSetData($struArgs, 1, $Args)
	EndIf

	DllStructSetData($struINFO, 1, DllStructGetSize($struINFO))
	DllStructSetData($struINFO, 2, BitOR(0xC, 0x40, 0x400))
	DllStructSetData($struINFO, 3, $hWnd)
	DllStructSetData($struINFO, 4, DllStructGetPtr($struVerb))
	DllStructSetData($struINFO, 5, DllStructGetPtr($struPath))
	DllStructSetData($struINFO, 6, DllStructGetPtr($struArgs))
	DllStructSetData($struINFO, 7, DllStructGetPtr($struWDir))
	DllStructSetData($struINFO, 8, $rState)

	Local $iRet = DllCall("shell32.dll", "int", "ShellExecuteEx", "ptr", DllStructGetPtr($struINFO))
	If Not IsArray($iRet) Or Not $iRet[0] Then Return SetError(2, 0, 0)
	
	Return 1
EndFunc

#EndRegion Internal Functions
