;#AutoIt3Wrapper_Au3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6

#cs
	;#=#INDEX#==========================================================================================#
	;#  Title .........: _Ani.au3
	;#  Description ...: Animated Controls (.ani/.gif) for AutoIt.
	;#  Date ..........: 20.05.09
	;#  Version .......: 1.1 (added gif support, included timer functions, minor corrections)
	;#  History .......: 19.05.09 v 1.0
	;#  Author ........: jennico (jennicoattminusonlinedotde)    2009 by jennico
	;#  AutoIt Version : written in v 3.2.12.1, no includes, will not expire.
	;#  Main Functions : GUISetAni( $hfile, $hWnd [, $hspeed ] )
	;#           TraySetAni( $hfile, $hWnd [, $hspeed ] )
	;#           GUICtrlCreateGif( $hWnd, $hfile, $x, $y [, $w [, $h [, $istyle [, $iexstyle [, $hspeed ]]]]] )
	;#           GUICtrlCreateAni( $hWnd, $hfile, $x, $y [, $w [, $h [, $istyle [, $iexstyle [, $hspeed ]]]]] )
	;#           GUICtrlSetAni( $hWnd, $hctrl, $hfile [, $hspeed ] )
	;#           _Ani_PauseAnimation( $paused [, $hWnd ] )
	;#           _Ani_SetAnimationSpeed( $hspeed [, $hWnd ] )
	;#           _Ani_GetGifSize( $hfile )
	;#  Internal ......: __Ani_GetInstance($hctrl, $hmode = 0)
	;#           __Ani_GetTimer($iIDTimer)
	;#           __Ani_SplitAni($id, $hfile, $hWnd, $hspeed)
	;#           __Ani_SplitGif($id, $hfile, $hWnd, $hspeed)
	;#           __Ani_SetGUIAni($hWnd, $Msg, $iIDTimer, $dwTime)
	;#           __Ani_SetTrayAni($hWnd, $Msg, $iIDTimer, $dwTime)
	;#           __Ani_SetCtrlAni($hWnd, $Msg, $iIDTimer, $dwTime)
	;#           __Ani_NewTimer( $hWnd, $iElapse, $sTimerFunc )
	;#           __Ani_SetTimer($hWnd, $iElapse, $sTimerFunc, $iTimerID)
	;#==================================================================================================#
#ce

#Region;--------------------------Global declarations
;Global $sOnAutoItExit_Opt = Opt("OnExitFunc", "_Ani_OnAutoItExit_Proc")
OnAutoItExitRegister("_Ani_OnAutoItExit_Proc")

Global Const $tagANIHeader = "dword cbSizeOf;" & _ ; // Num bytes in AniHeader (36 bytes)
		"dword cFrames;" & _ ; // Number of unique Icons in this cursor
		"dword cSteps;" & _ ; // Number of Blits before the animation cycles = frames, wenn keine wiederholung
		"dword cx;" & _ ; // reserved, must be zero.
		"dword cy;" & _ ; // reserved, must be zero.
		"dword cBitCount;" & _ ; // reserved, must be zero.
		"dword cPlanes;" & _ ; // reserved, must be zero.{ 1 Jiffy = 1/60 sec }
		"dword JifRate;" & _ ; // Default Jiffies (1/60th of a second) if rate chunk not present.
		"dword flags" & _ ; // Animation Flag (see AF_ constants)
		""

Global Const $tagGifGraphicsControlExtension = "byte Introducer;" & _ ; /* Extension Introducer (always 21h) */
		"byte Label;" & _ ; /* Graphic Control Label (always F9h) */
		"byte BlockSize;" & _ ; /* Size of remaining fields (always 04h) */
		"byte Packed;" & _ ; /* Method of graphics disposal to use */
		"ushort DelayTime;" & _ ; /* Hundredths of seconds to wait   */
		"byte ColorIndex;" & _ ; /* Transparent Color Index */
		"byte Terminator;" & _ ; /* Block Terminator (always 0) */
		""

;Global Const $AF_ICON     = 0x00000001;
;Global Const $AF_SEQUENCE = 0x00000002;
;Global Const $FOURCC_ACON = 'ACON';
Global Const $FOURCC_RIFF = 'RIFF'
;Global Const $FOURCC_INFO = 'INFO';
Global Const $FOURCC_INAM = 'INAM'
Global Const $FOURCC_IART = 'IART'
;Global Const $FOURCC_LIST = 'LIST';
Global Const $FOURCC_anih = 'anih'
Global Const $FOURCC_rate = 'rate'
Global Const $FOURCC_seq = 'seq '
Global Const $FOURCC_fram = 'fram'
Global Const $FOURCC_icon = 'icon'

Global Const $ani_Separator = Chr(0x21) & Chr(0xF9) & Chr(0x04)
Global Const $ani_TempDir = @TempDir & "\_ani.au3\" & @AutoItPID & "_"

Global $_ani_aTimerIDs[1][3]
Global $ani_Instance, $ani_maxSteps = 1
Global $ani_hWnd[1], $ani_Count[1], $ani_Steps[1], $ani_Timer[1], _
		$ani_Speed[1], $ani_Paused[1], $ani_Data[1][1][2]

#EndRegion;--------------------------Global declarations
;

#Region;--------------------------Main Functions
#cs
	;#=#Function#================================================#
	;#  Name ..........: GUISetAni( $hfile, $hWnd [, $hspeed ] )
	;#  Description....: Sets an animated GUI Icon.
	;#  Parameters.....: $hfile = The .ani file to be set.
	;#           $hWnd = The GUI handle as returned by GuiCreate().
	;#           $hspeed = [optional] The animation speed (Default = 1).
	;#  Return Value ..: Success: Returns 1.
	;#           Failure: Returns 0.
	;#  Author ........: jennico
	;#  Date ..........: 19.05.09
	;#  Example........: yes
	;#===========================================================#
#ce
Func GUISetAni($hfile, $hWnd, $hspeed = 1)
	If FileExists($hfile) = 0 Then Return
	Local $id = __Ani_GetInstance($hWnd)
	If __Ani_SplitAni($id, $hfile, $hWnd, $hspeed) = 0 Then Return
	$ani_Timer[$id] = __Ani_NewTimer($hWnd, $ani_Data[$id][0][1] / 6 * 100 / $ani_Speed[$id], "__Ani_SetGUIAni")
	If $ani_Timer[$id] = 0 Then Return
	Return GUISetIcon($ani_TempDir & $id & "_" & $ani_Data[$id][$ani_Count[$id]][0], 0, $hWnd)
EndFunc ;==>GUISetAni

#cs
	;#=#Function#================================================#
	;#  Name ..........: TraySetAni( $hfile, $hWnd [, $hspeed ] )
	;#  Description....: Sets an animated Tray Icon.
	;#  Parameters.....: $hfile = The .ani file to be set.
	;#           $hWnd = One of the GUI handles as returned by GuiCreate().
	;#           $hspeed = [optional] The animation speed (Default = 1).
	;#  Return Value ..: Success: Returns 1.
	;#           Failure: Returns 0.
	;#  Author ........: jennico
	;#  Date ..........: 19.05.09
	;#  Example........: yes
	;#===========================================================#
#ce
Func TraySetAni($hfile, $hWnd, $hspeed = 1)
	If FileExists($hfile) = 0 Then Return
	Local $id = __Ani_GetInstance("Tray")
	If __Ani_SplitAni($id, $hfile, "Tray", $hspeed) = 0 Then Return
	$ani_Timer[$id] = __Ani_NewTimer($hWnd, $ani_Data[$id][0][1] / 6 * 100 / $ani_Speed[$id], "__Ani_SetTrayAni")
	If $ani_Timer[$id] = 0 Then Return
	Return TraySetIcon($ani_TempDir & $id & "_" & $ani_Data[$id][$ani_Count[$id]][0], 0)
EndFunc ;==>TraySetAni

#cs
	;#=#Function#================================================#
	;#  Name ..........: GUICtrlCreateGif( $hWnd, $hfile, $x, $y [, $w [, $h [, $istyle [, $iexstyle [, $hspeed ]]]]] )
	;#  Description....: Creates an animated .gif based GUI Control.
	;#  Parameters.....: $hWnd = The GUI handle as returned by GuiCreate().
	;#           $hfile = The .gif file to be set.
	;#           $x = The left side of the control. If -1 is used then left will be computed according to GUICoordMode.
	;#           $y = The top of the control. If -1 is used then top will be computed according to GUICoordMode.
	;#           $w = [optional] The width of the control (default is the previously used width).
	;#           $h = [optional] The height of the control (default is the previously used height).
	;#           $istyle = [optional] Defines the style of the control. See GUI Control Styles Appendix. Default (-1) : $SS_NOTIFY. Forced style : $SS_BITMAP.
	;#           $iexstyle = [optional] Defines the extended style of the control. See Extended Style Table. Default = -1
	;#           $hspeed = [optional] The animation speed (Default = 1).
	;#  Return Value ..: Success: Returns the identifier (controlID) of the new control.
	;#           Failure: Returns 0.
	;#  Author ........: jennico
	;#  Date ..........: 20.05.09
	;#  Remarks .......: The Gifcontrol is a Pic control. Please refer to GUICtrlCreatePic() in helpfile
	;#           Alternatively you may use GUICtrlCreatePic() with GUICtrlSetAni()
	;#           Due to the countless options and variations of a gif file, not every file can be displayed correctly (even IE is not able).
	;#           The following specifications are currently supported: GIF89a format with GCE (Graphic Control Extension) block, frames, frame duration. No stopping, no user input, no interlacing (GIF87a format). Maybe in later versions.
	;#           If a file is not supported, it will be displayed without animation and @error set to 1.
	;#  Example........: yes
	;#===========================================================#
#ce
Func GUICtrlCreateGif($hWnd, $hfile, $x, $y, $w = -1, $h = -1, $istyle = -1, $iexstyle = -1, $hspeed = 1)
	Local $oldhWnd = GUISwitch($hWnd)
	Local $hctrl = GUICtrlCreatePic($hfile, $x, $y, $w, $h, $istyle, $iexstyle)
	GUISwitch($oldhWnd)
	If $hctrl And $hfile And GUICtrlSetAni($hWnd, $hctrl, $hfile, $hspeed) = 0 Then Return SetError(1, 0, $hctrl)
	Return $hctrl
EndFunc ;==>GUICtrlCreateGif

#cs
	;#=#Function#================================================#
	;#  Name ..........: GUICtrlCreateAni( $hWnd, $hfile, $x, $y [, $w [, $h [, $istyle [, $iexstyle [, $hspeed ]]]]] )
	;#  Description....: Creates an animated .ani based GUI Control.
	;#  Parameters.....: $hWnd = The GUI handle as returned by GuiCreate().
	;#           $hfile = The .ani file to be set.
	;#           $x = The left side of the control. If -1 is used then left will be computed according to GUICoordMode.
	;#           $y = The top of the control. If -1 is used then top will be computed according to GUICoordMode.
	;#           $w = [optional] The width of the control (default is 32).
	;#           $h = [optional] The height of the control (default is 32).
	;#           $istyle = [optional] Defines the style of the control. See GUI Control Styles Appendix. default ( -1) : $SS_NOTIFY. forced styles : $WS_TABSTOP, $SS_ICON
	;#           $iexstyle = [optional] Defines the extended style of the control. See Extended Style Table. Default = -1
	;#           $hspeed = [optional] The animation speed (Default = 1).
	;#  Return Value ..: Success: Returns the identifier (controlID) of the new control.
	;#           Failure: Returns 0.
	;#  Author ........: jennico
	;#  Date ..........: 19.05.09
	;#  Remarks .......: The Anicontrol is an Icon control. Please refer to GUICtrlCreateIcon() in helpfile
	;#           Alternatively you may use GUICtrlCreateIcon() with GUICtrlSetAni()
	;#           If the ani fails to split, it will be displayed without animation and @error set to 1.
	;#  Example........: yes
	;#===========================================================#
#ce
Func GUICtrlCreateAni($hWnd, $hfile, $x, $y, $w = 32, $h = 32, $istyle = -1, $iexstyle = -1, $hspeed = 1)
	Local $oldhWnd = GUISwitch($hWnd)
	Local $hctrl = GUICtrlCreateIcon($hfile, 0, $x, $y, $w, $h, $istyle, $iexstyle)
	GUISwitch($oldhWnd)
	If $hctrl And $hfile And GUICtrlSetAni($hWnd, $hctrl, $hfile, $hspeed) = 0 Then Return SetError(1, 0, $hctrl)
	Return $hctrl
EndFunc ;==>GUICtrlCreateAni

#cs
	;#=#Function#================================================#
	;#  Name ..........: GUICtrlSetAni( $hWnd, $hctrl, $hfile [, $hspeed ] )
	;#  Description....: Sets an animated Icon (.ani) to an Ani / Icon control
	;#           resp. an animate Gif (.gif) to Gif / Pic control.
	;#  Parameters.....: $hWnd = The GUI handle as returned by GuiCreate().
	;#           $hctrl = The control ID as returned by GUICtrlCreateAni() or GUICtrlCreateIcon().
	;#       $hfile = The animated file to be set (.ani or .gif supported).
	;#           $hspeed = [optional] The animation speed (Default = 1).
	;#  Return Value ..: Success: Returns 1.
	;#           Failure: Returns 0. see remarks.
	;#  Remarks .......: If the ani fails to split, it will be displayed without animation.
	;#  Author ........: jennico
	;#  Date ..........: 19.05.09
	;#  Example........: yes
	;#===========================================================#
#ce
Func GUICtrlSetAni($hWnd, $hctrl, $hfile, $hspeed = 1)
	If FileExists($hfile) = 0 Then Return
	If GUICtrlSetImage($hctrl, $hfile, 0) = 0 Then Return
	Local $id = __Ani_GetInstance($hctrl)
	Local $ret = __Ani_SplitAni($id, $hfile, $hctrl, $hspeed)
	If $ret = 0 And IsArray($ret) = 0 Then Return
	$ani_Timer[$id] = __Ani_NewTimer($hWnd, $ani_Data[$id][0][1] / 6 * 100 / $ani_Speed[$id], "__Ani_SetCtrlAni")
	If $ani_Timer[$id] = 0 Then Return
	Return GUICtrlSetImage($ani_hWnd[$id], $ani_TempDir & $id & "_" & $ani_Data[$id][$ani_Count[$id]][0], 0)
EndFunc ;==>GUICtrlSetAni

#cs
	;#=#Function#================================================#
	;#  Name ..........: _Ani_PauseAnimation( $paused [, $hWnd ] )
	;#  Description....: Pauses or Resumes an animation.
	;#  Parameters.....: $paused = 1 = Pauses animation.
	;#                 0 = Resumes animation.
	;#           $hWnd = [optional] The GUI handle as returned by GuiCreate() if you want to pause the caption animation.
	;#                    The GUI control ID as returned by GUICtrlCreateAni() or GUICtrlCreateIcon() if you want to pause a GUI control.
	;#                    Default : if omitted, the Tray animation will be paused.
	;#  Return Value ..: Success: Returns 1.
	;#           Failure: Returns 0.
	;#  Author ........: jennico
	;#  Date ..........: 19.05.09
	;#  Example........: yes
	;#===========================================================#
#ce
Func _Ani_PauseAnimation($paused, $hWnd = "Tray")
	Local $id = __Ani_GetInstance($hWnd, 1)
	If $id = -1 Then Return
	$ani_Paused[$id] = $paused
	Return 1
EndFunc ;==>_Ani_PauseAnimation

#cs
	;#=#Function#================================================#
	;#  Name ..........: _Ani_SetAnimationSpeed( $hspeed [, $hWnd ] )
	;#  Description....: Sets the animation speed.
	;#  Parameters.....: $hspeed = The animation speed. Can be any floating number <> 0.
	;#                 1 means genuine ani speed, 2 double speed, 0.5 half speed.
	;#                 0 will be ignored !
	;#           $hWnd = [optional] The GUI handle as returned by GuiCreate() if you want to adjust the caption animation speed.
	;#                    The GUI control ID as returned by GUICtrlCreateAni() or GUICtrlCreateIcon() if you want to adjust a GUI control animation speed.
	;#                    Default : if omitted, the Tray animation will be adjusted.
	;#  Return Value ..: Success: Returns 1.
	;#           Failure: Returns 0.
	;#  Author ........: jennico
	;#  Date ..........: 19.05.09
	;#  Example........: yes
	;#===========================================================#
#ce
Func _Ani_SetAnimationSpeed($hspeed, $hWnd = "Tray")
	If $hspeed = 0 Then Return
	Local $id = __Ani_GetInstance($hWnd, 1)
	If $id = -1 Then Return
	$ani_Speed[$id] = Abs($hspeed)
	Return 1
EndFunc ;==>_Ani_SetAnimationSpeed

#cs
	;#=#Function#================================================#
	;#  Name ..........: _Ani_GetGifSize( $hfile )
	;#  Description....: Retrieves the size of a gif (GIF89a format) file.
	;#  Parameters.....: $hfile = The .gif file.
	;#  Return Value ..: Success: Returns a 2 element array, array[0] contains width, array[1] contains height of $hfile.
	;#           Failure: Returns 0.
	;#  Author ........: jennico
	;#  Date ..........: 20.05.09
	;#  Remarks .......: Only GIF89a format currently supported, not GIF87a format. Maybe in later versions.
	;#  Example........: yes
	;#===========================================================#
#ce
Func _Ani_GetGifSize($hfile)
	Local $read = FileRead($hfile)
	If StringLeft($read, 3) <> "GIF" Then Return
	Local $a = StringSplit($read, $ani_Separator, 1)
	If $a[0] < 2 Then Return
	Local $ret[2] = [Dec(Hex(BinaryMid($a[2], 11, 1))) + Dec(Hex(BinaryMid($a[2], 12, 1))) * 256, Dec(Hex(BinaryMid($a[2], 13, 1))) + Dec(Hex(BinaryMid($a[2], 14, 1))) * 256]
	Return $ret
EndFunc ;==>_Ani_GetGifSize

Func _Ani_ReleaseAllResources()
	For $i = 0 To UBound($_ani_aTimerIDs)-1
		If $_ani_aTimerIDs[$i][1] Then
			$id = __Ani_GetTimer($_ani_aTimerIDs[$i][1])
			
			If $id <> -1 Then
				DllCall("user32.dll", "bool", "KillTimer", "hwnd", $ani_hWnd[$id], "uint_ptr", $_ani_aTimerIDs[$i][1])
			EndIf
		EndIf
		
		If $_ani_aTimerIDs[$i][2] Then
			DllCallbackFree($_ani_aTimerIDs[$i][2])
		EndIf
	Next
	
	Dim $_ani_aTimerIDs = 0, $ani_hWnd = 0, $ani_Count = 0, $ani_Steps = 0, $ani_Timer = 0, $ani_Speed = 0, $ani_Paused = 0, $ani_Data = 0
	
	Dim $_ani_aTimerIDs[1][3]
	Dim $ani_Instance = 0, $ani_maxSteps = 1
	Dim $ani_hWnd[1], $ani_Count[1], $ani_Steps[1], $ani_Timer[1], $ani_Speed[1], $ani_Paused[1], $ani_Data[1][1][2]
	
	FileDelete($ani_TempDir & "*")
EndFunc

#EndRegion;--------------------------Main Functions
;

#Region;--------------------------Internal
Func __Ani_GetInstance($hctrl, $hmode = 0)
	For $i = 0 To $ani_Instance - 1
		If $ani_hWnd[$i] = $hctrl Then Return $i
	Next
	If $hmode Then Return -1
	$ani_Instance += 1
	ReDim $ani_hWnd[$ani_Instance], $ani_Count[$ani_Instance], _
			$ani_Steps[$ani_Instance], $ani_Timer[$ani_Instance], _
			$ani_Speed[$ani_Instance], $ani_Paused[$ani_Instance], _
			$ani_Data[$ani_Instance][$ani_maxSteps][2]
	Return $i
EndFunc ;==>__Ani_GetInstance

Func __Ani_GetTimer($iIDTimer)
	For $i = 0 To $ani_Instance - 1
		If $ani_Timer[$i] = $iIDTimer Then Return $i
	Next
	Return -1
EndFunc ;==>__Ani_GetTimer

Func __Ani_SplitAni($id, $hfile, $hWnd, $hspeed)
	Local $read = FileRead($hfile)
	If StringLeft($read, 4) <> $FOURCC_RIFF Then Return __Ani_SplitGif($id, $read, $hWnd, $hspeed)

	Local $a = StringSplit($read, $FOURCC_anih, 1)
	If $a[0] < 2 Then Return

	Local $tBinary = DllStructCreate("byte[36]")
	DllStructSetData($tBinary, 1, $a[2])
	Local $tResource = DllStructCreate($tagANIHeader, DllStructGetPtr($tBinary) + 4)
	Local $cFrames = DllStructGetData($tResource, "cFrames")
	Local $cSteps = DllStructGetData($tResource, "cSteps")
	Local $JifRate = DllStructGetData($tResource, "JifRate")

	#cs
		$a = StringSplit($read, $FOURCC_INAM, 1)
		If $a[0] > 1 Then MsgBox(0, "Description", StringMid($a[2], 5, Dec(Hex(BinaryMid($a[2], 1, 1)))))
		$a = StringSplit($read, $FOURCC_IART, 1)
		If $a[0] > 1 Then MsgBox(0, "Author", StringMid($a[2], 5, Dec(Hex(BinaryMid($a[2], 1, 1)))))
	#ce

	If $cSteps > $ani_maxSteps Then
		$ani_maxSteps = $cSteps
		ReDim $ani_Data[$ani_Instance][$ani_maxSteps][2]
	EndIf

	Local $rate = StringSplit($read, $FOURCC_rate, 1)
	Local $seq = StringSplit($read, $FOURCC_seq, 1)

	For $i = 0 To $cSteps - 1
		$ani_Data[$id][$i][0] = $i
		If $seq[0] > 1 Then $ani_Data[$id][$i][0] = Dec(Hex(BinaryMid($seq[2], ($i + 1) * 4 + 1, 1)))
		$ani_Data[$id][$i][1] = $JifRate
		If $rate[0] > 1 Then $ani_Data[$id][$i][1] = Dec(Hex(BinaryMid($rate[2], ($i + 1) * 4 + 1, 1)))
	Next

	If StringInStr($read, $FOURCC_fram & $FOURCC_icon) = 0 Then Return
	Local $b = StringSplit(StringMid($read, StringInStr($read, $FOURCC_fram & $FOURCC_icon) + 8), $FOURCC_icon, 1)

	For $i = 1 To $cFrames;$b[0]
		Local $gBinary = BinaryMid($b[$i], 5);, BinaryLen($b[$i]));$len)
		Local $write = FileOpen($ani_TempDir & $id & "_" & $i - 1, 26)
		If $write = 0 Then Return
		FileWrite($write, $gBinary)
		FileClose($write)
	Next

	$ani_hWnd[$id] = $hWnd
	$ani_Steps[$id] = $cSteps
	$ani_Speed[$id] = $hspeed
	$ani_Count[$id] = 0

	Return 1
EndFunc ;==>__Ani_SplitAni

Func __Ani_SplitGif($id, $read, $hWnd, $hspeed)
	If StringLeft($read, 3) <> "GIF" Then Return
	Local $a = StringSplit($read, $ani_Separator, 1)
	If $a[0] < 3 Then Return

	If $a[0] - 1 > $ani_maxSteps Then
		$ani_maxSteps = $a[0] - 1
		ReDim $ani_Data[$ani_Instance][$ani_maxSteps][2]
	EndIf

	For $i = 2 To $a[0]
		$ani_Data[$id][$i - 2][0] = $i - 2
		$ani_Data[$id][$i - 2][1] = (Dec(Hex(BinaryMid($a[$i], 2, 1))) + Dec(Hex(BinaryMid($a[$i], 3, 1))) * 256) * 3 / 5
		Local $write = FileOpen($ani_TempDir & $id & "_" & $i - 2, 26)
		If $write = 0 Then Return
		FileWrite($write, $a[1] & $ani_Separator & $a[$i] & Chr(0x3B))
		FileClose($write)
	Next

	$ani_hWnd[$id] = $hWnd
	$ani_Steps[$id] = $a[0] - 1
	$ani_Speed[$id] = $hspeed
	$ani_Count[$id] = 0

	Return 1
EndFunc ;==>__Ani_SplitGif

Func __Ani_SetGUIAni($hWnd, $Msg, $iIDTimer, $dwTime)
	Local $id = __Ani_GetTimer($iIDTimer)
	If $id = -1 Then Return
	If $ani_Paused[$id] Then Return
	$ani_Count[$id] += 1
	If $ani_Count[$id] = $ani_Steps[$id] Then $ani_Count[$id] = 0
	GUISetIcon($ani_TempDir & $id & "_" & $ani_Data[$id][$ani_Count[$id]][0], 0, $ani_hWnd[$id])
	__Ani_SetTimer($hWnd, $ani_Data[$id][$ani_Count[$id]][1] / 6 * 100 / $ani_Speed[$id], "__Ani_SetGUIAni", $iIDTimer)
EndFunc ;==>__Ani_SetGUIAni

Func __Ani_SetTrayAni($hWnd, $Msg, $iIDTimer, $dwTime)
	Local $id = __Ani_GetTimer($iIDTimer)
	If $id = -1 Then Return
	If $ani_Paused[$id] Then Return
	$ani_Count[$id] += 1
	If $ani_Count[$id] = $ani_Steps[$id] Then $ani_Count[$id] = 0
	TraySetIcon($ani_TempDir & $id & "_" & $ani_Data[$id][$ani_Count[$id]][0], 0)
	__Ani_SetTimer($hWnd, $ani_Data[$id][$ani_Count[$id]][1] / 6 * 100 / $ani_Speed[$id], "__Ani_SetTrayAni", $iIDTimer)
EndFunc ;==>__Ani_SetTrayAni

Func __Ani_SetCtrlAni($hWnd, $Msg, $iIDTimer, $dwTime)
	Local $id = __Ani_GetTimer($iIDTimer)
	If $id = -1 Then Return
	If $ani_Paused[$id] Then Return
	$ani_Count[$id] += 1
	If $ani_Count[$id] = $ani_Steps[$id] Then $ani_Count[$id] = 0
	GUICtrlSetImage($ani_hWnd[$id], $ani_TempDir & $id & "_" & $ani_Data[$id][$ani_Count[$id]][0], 0)
	__Ani_SetTimer($hWnd, $ani_Data[$id][$ani_Count[$id]][1] / 6 * 100 / $ani_Speed[$id], "__Ani_SetCtrlAni", $iIDTimer)
EndFunc ;==>__Ani_SetCtrlAni

#cs
	;#=#Function#================================================#
	;# Name...........: __Ani_NewTimer( $hWnd, $iElapse, $sTimerFunc )
	;# Author ........: Gary Frost / jennico
	;#===========================================================#
#ce
Func __Ani_NewTimer($hWnd, $iElapse, $sTimerFunc)
	Local $iResult[1], $pTimerFunc = 0, $hCallBack = 0, $iIndex = $_ani_aTimerIDs[0][0] + 1
	ReDim $_ani_aTimerIDs[$iIndex + 1][3]
	$_ani_aTimerIDs[0][0] = $iIndex
	$iTimerID = $iIndex + 1000
	For $x = 1 To $iIndex
		If $_ani_aTimerIDs[$x][0] = $iTimerID Then
			$iTimerID = $iTimerID + 1
			$x = 0
		EndIf
	Next
	$hCallBack = DllCallbackRegister($sTimerFunc, "none", "hwnd;int;int;dword")
	If $hCallBack = 0 Then Return SetError(-1, -1, 0)
	$pTimerFunc = DllCallbackGetPtr($hCallBack)
	If $pTimerFunc = 0 Then Return SetError(-1, -1, 0)
	$iResult = DllCall("user32.dll", "int", "SetTimer", "hwnd", $hWnd, "int", $iTimerID, "int", $iElapse, "ptr", $pTimerFunc)
	If @error Then Return
	$_ani_aTimerIDs[$iIndex][0] = $iResult[0] ; integer identifier
	$_ani_aTimerIDs[$iIndex][1] = $iTimerID ; timer id
	$_ani_aTimerIDs[$iIndex][2] = $hCallBack ; callback identifier, need this for the Kill Timer
	Return $iResult[0]
EndFunc ;==>__Ani_NewTimer

#cs
	;#=#Function#================================================#
	;# Name...........: __Ani_SetTimer( $hWnd, $iElapse, $sTimerFunc, $iTimerID )
	;# Author ........: Gary Frost / jennico
	;#===========================================================#
#ce
Func __Ani_SetTimer($hWnd, $iElapse, $sTimerFunc, $iTimerID)
	Local $iResult[1], $pTimerFunc = 0, $hCallBack = 0, $iIndex = $_ani_aTimerIDs[0][0] + 1
	For $x = 1 To $iIndex - 1
		If $_ani_aTimerIDs[$x][0] = $iTimerID Then
			$iTimerID = $_ani_aTimerIDs[$x][1]
			$hCallBack = $_ani_aTimerIDs[$x][2]
			If $hCallBack <> 0 Then ; call back was used to create the timer
				$pTimerFunc = DllCallbackGetPtr($hCallBack)
				If $pTimerFunc = 0 Then Return SetError(-1, -1, 0)
			EndIf
			$iResult = DllCall("user32.dll", "int", "SetTimer", "hwnd", $hWnd, "int", $iTimerID, "int", $iElapse, "ptr", $pTimerFunc)
			If @error Then Return
			ExitLoop
		EndIf
	Next
	Return $iResult[0]
EndFunc ;==>__Ani_SetTimer

#EndRegion;--------------------------Internal
;

Func _Ani_OnAutoItExit_Proc()
	;Call($sOnAutoItExit_Opt)
	_Ani_ReleaseAllResources()
EndFunc ;==>OnAutoItExit
