;This one needed to avoid problems after compilation
#Au3Stripper_Ignore_Funcs=__ST_Handler,__SoundPlay_Proc

#include <GUIConstantsEx.au3>
#include <Sound.au3>
#include <AboutBox.au3>

Global $hSound

_Example()

Func _Example()
	Local $hParent_GUI, $iMainMenu, $iAbout_MenuItem, $aAccelKeys
	
	$hParent_GUI = GUICreate('Parent For "About Program" Demo', 330, 100)
	
	$iMainMenu = GUICtrlCreateMenu('Help')
	$iAbout_MenuItem = GUICtrlCreateMenuItem('About...	(F1)', $iMainMenu)
	
	Dim $aAccelKeys[1][2] = [['{F1}', $iAbout_MenuItem]]
	GUISetAccelerators($aAccelKeys, $hParent_GUI)
	
	GUISetState(@SW_SHOW, $hParent_GUI)
	
	$hSound = _SoundOpen(@ScriptDir & '\Resources\About.mid') ;@WindowsDir & '\Media\cssamp1.mid'
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				_SoundClose($hSound)
				Exit
			Case $iAbout_MenuItem
				Local $sTitle, $iLinkColor, $iBkColor, $aHyperLinks[4], $aData[5]
				
				$sTitle = 'About Info'
				
				$aData[0] = 'My program name'
				$aData[1] = 'Version: ' & @CRLF & 'v1.0'
				$aData[2] = 'I want to express special gratitude to:(Georgia,12,0x000000)\n\n\n\nAutoIt Team(Impact,16)\nAutoIt Community(Impact,16)\nAutoIt Russian Community(Impact,16)\n\n\n\n... and many other good people'
				$aData[3] = 'Copyright  ' & @YEAR & ' Company/Author. All rights reserved.'
				$aData[4] = 'Play sound'
				
				$iLinkColor = 0x0000FF
				$iBkColor = 0xFFFFFF
				
				$aHyperLinks[0] = UBound($aHyperLinks) - 1
				$aHyperLinks[1] = 'App Web Page|http://www.autoitscript.com'
				$aHyperLinks[2] = 'Email|mailto:my_email@mail.com'
				$aHyperLinks[3] = 'Some additional link|http://personalwebpafe.com'
				
				_AboutBox($sTitle, $aData, $aHyperLinks, $hParent_GUI, @AutoItExe, $iLinkColor, $iBkColor, 1, -1, -1, '', '__SoundPlay_Proc')
				
				_SoundStop($hSound)
		EndSwitch
	WEnd
EndFunc

Func __SoundPlay_Proc($sAction)
	If Not IsArray($hSound) Then
		Return
	EndIf
	
	Switch $sAction
		Case $ABX_SOUND_PLAY
			_SoundResume($hSound)
			If @error Then _SoundPlay($hSound)
		Case $ABX_SOUND_PAUSE
			_SoundPause($hSound)
	EndSwitch
EndFunc
