#include "Opera.au3"

Global $sApp_Name = "My Opera Tool"

_App_Integrate_Call()

Func _App_Integrate_Call()
	Local $aMessages[13] = [ _
		$sApp_Name & " - Opera Integrator", _
		"Integration to Opera", _
		"Would you like to integrate this program into Opera Browser?", _
		"Path to browser Opera", _
		"Enter Opera Browser installation path:", _
		"OK", _
		"Cancel", _
		"Please Select Opera dir", _
		"Can not find Opera files (%s), please select folder with Opera Browser...", _
		"Attention", _
		"Finishing..", _
		"Integration to Opera is successfully completed!", _
		"There was an error (%i) while trying to integrate." _
		]
	
	_Opera_Integration_Module($aMessages, "_App_Integrate_Proc")
EndFunc

Func _App_Integrate_Proc($sOpPath)
	If Not @Compiled Then
		;Compile?
		Return SetError(1)
	EndIf
	
	If _OperaIsRunning($sOpPath) Then
		MsgBox(48, 'Attention', 'Opera is running, please close it and try again.')
		Return SetError(01)
	EndIf
	
	Local $sApp_Dest_Path = $sOpPath & "\" & $sApp_Name & "\" & @ScriptName
	
	FileCopy(@ScriptFullPath, $sApp_Dest_Path, 8+1)
	
	_OperaAddMenuItem("Tools.Menu", 'Item, "' & $sApp_Name & '"', 'Execute program, "' & $sApp_Dest_Path & '",,, "Attachment Archives"', 1, -1, $sOpPath)
	_OperaAddMenuItem("Tools.Menu", '------------' & StringStripWS($sApp_Name, 8), '', 2, -1, $sOpPath)
EndFunc