#Region Header

#CS
	Name:				GUIPasswordCombobox
	Description:		UDF to create and handle combobox with password set support
	Author:				Copyright  2012 CreatoR's Lab (G.Sandler), www.creator-lab.ucoz.ru, www.autoit-script.ru. All rights reserved.
	AutoIt version:		3.3.6.1
	UDF version:		1.0
	
	History:
	
	v1.02
	* Example updated.
	* Removed $iMax_Pass parameter in _GUICtrlPasswordCombobox_Create function. Should be handled manually by the user.
	* Now the _GUICtrlPasswordCombobox_DeletePassword function does not set the last password in edit box of the combo control. Should be handled manually by the user.
	* Now the _GUICtrlPasswordCombobox_AddPassword function does not empty edit box of the combo control. Should be handled manually by the user.
	+ Added _GUICtrlPasswordCombobox_EditSetText function.
	+ Added _GUICtrlPasswordCombobox_EditGetText function.
	
	v1.01
	* Fixed issue when adding password with | character.

	v1.0
	* First version.
#CE

;Includes
#include-once

#include <GUIConstantsEx.au3>
#include <EditConstants.au3>
#include <ButtonConstants.au3>
#include <GUIComboBoxEx.au3>
#include <WindowsConstants.au3>

#EndRegion Header

#Region Global Variables

Global $sGCPC_PassChar 		= Chr(149)

;$aGCPC_Array Sub Elements Explained
Global Enum _
	$iGCPC_iInputCtrl, _ 	; Password edit (input) Control ID
	$iGCPC_hInputCtrl, _ 	; Password edit (input) Control Handle
	$iGCPC_iComboCtrl, _ 	; Password combo Control ID
	$iGCPC_hComboCtrl, _ 	; Password combo Control Handle
	$iGCPC_sPassChar, _ 	; Password char
	$iGCPC_bShowPass, _ 	; Defines wheter to show the passwords or not
	$iGCPC_aBuff, _ 		; Passwords Buffer Array (Array in array)
	$iGCPC_iTotal 			; Total sub elements

Global $aGCPC_Array[1][$iGCPC_iTotal]

#EndRegion Global Variables

#Region Public Functions

Func _GUICtrlPasswordCombobox_Create($sText, $sDefault, $iX, $iY, $iW = -1, $iH = -1, $sPassChar = $sGCPC_PassChar)
	$aGCPC_Array[0][0] += 1
	ReDim $aGCPC_Array[$aGCPC_Array[0][0]+1][$iGCPC_iTotal]
	
	Local $aBuffer[1] = [0]
	
	$aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_iInputCtrl] 		= GUICtrlCreateInput('', $iX, $iY, $iW - 18, 21)
	$aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_hInputCtrl] 		= GUICtrlGetHandle($aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_iInputCtrl])
	$aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_iComboCtrl] 		= GUICtrlCreateCombo('', $iX, $iY, $iW, $iH, BitOr($GUI_SS_DEFAULT_COMBO, $WS_CLIPSIBLINGS))
	$aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_hComboCtrl] 		= GUICtrlGetHandle($aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_iComboCtrl])
	$aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_sPassChar] 			= $sPassChar
	$aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_bShowPass] 			= False
	$aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_aBuff] 				= $aBuffer
	
	__GUICtrlPasswordCombobox_ToggleEditPassChars($aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_hInputCtrl], 1, $sGCPC_PassChar)
	
	If $sText <> '' Then
		Local $aList = StringSplit($sText, '|')
		
		For $i = 1 To $aList[0]
			_GUICtrlPasswordCombobox_AddPassword($aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_iComboCtrl], $aList[$i])
		Next
		
		GUICtrlSetData($aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_iInputCtrl], $sDefault)
	EndIf
	
	If $aGCPC_Array[0][0] = 1 Then
		GUIRegisterMsg($WM_COMMAND, '__GUICtrlPasswordCombobox_WM_COMMAND')
	EndIf
	
	Return $aGCPC_Array[$aGCPC_Array[0][0]][$iGCPC_iComboCtrl]
EndFunc

Func _GUICtrlPasswordCombobox_Destroy($iCtrl)
	Local $aTmp[1][$iGCPC_iTotal]
	
	For $i = 1 To $aGCPC_Array[0][0]
		If $aGCPC_Array[$i][$iGCPC_iComboCtrl] = $iCtrl Then
			GUICtrlDelete($aGCPC_Array[$i][$iGCPC_iInputCtrl])
			GUICtrlDelete($aGCPC_Array[$i][$iGCPC_iComboCtrl])
		Else
			$aTmp[0][0] += 1
			ReDim $aTmp[$aTmp[0][0]+1][$iGCPC_iTotal]
			
			$aTmp[$aTmp[0][0]][$iGCPC_iInputCtrl] 	= $aGCPC_Array[$i][$iGCPC_iInputCtrl]
			$aTmp[$aTmp[0][0]][$iGCPC_hInputCtrl] 	= $aGCPC_Array[$i][$iGCPC_hInputCtrl]
			$aTmp[$aTmp[0][0]][$iGCPC_iComboCtrl] 	= $aGCPC_Array[$i][$iGCPC_iComboCtrl]
			$aTmp[$aTmp[0][0]][$iGCPC_hComboCtrl] 	= $aGCPC_Array[$i][$iGCPC_hComboCtrl]
			$aTmp[$aTmp[0][0]][$iGCPC_sPassChar] 	= $aGCPC_Array[$i][$iGCPC_sPassChar]
			$aTmp[$aTmp[0][0]][$iGCPC_bShowPass] 	= $aGCPC_Array[$i][$iGCPC_bShowPass]
			$aTmp[$aTmp[0][0]][$iGCPC_aBuff] 		= $aGCPC_Array[$i][$iGCPC_aBuff]
		EndIf
	Next
	
	$aGCPC_Array = $aTmp
	
	If $aGCPC_Array[0][0] = 0 Then
		GUIRegisterMsg($WM_COMMAND, '')
	EndIf
	
	Return $aGCPC_Array[0][0]
EndFunc

Func _GUICtrlPasswordCombobox_ShowPassword($iCtrl, $bShow = -1)
	For $i = 1 To $aGCPC_Array[0][0]
		If $aGCPC_Array[$i][$iGCPC_iComboCtrl] = $iCtrl Then
			$aBuffer = $aGCPC_Array[$i][$iGCPC_aBuff]
			$aGCPC_Array[$i][$iGCPC_bShowPass] = $bShow
			
			If $bShow == -1 Then
				$aGCPC_Array[$i][$iGCPC_bShowPass] = Not $aGCPC_Array[$i][$iGCPC_bShowPass]
			EndIf
			
			$iCount = _GUICtrlComboBox_GetCount($iCtrl)
			$sData = ''
			
			GUICtrlSetData($aGCPC_Array[$i][$iGCPC_iComboCtrl], '')
			
			For $j = 0 To $iCount-1
				If $aGCPC_Array[$i][$iGCPC_bShowPass] Then ;Show password
					_GUICtrlComboBox_AddString($aGCPC_Array[$i][$iGCPC_iComboCtrl], $aBuffer[$j+1])
				Else
					_GUICtrlComboBox_AddString($aGCPC_Array[$i][$iGCPC_iComboCtrl], StringRegExpReplace($aBuffer[$j+1], '.', $sGCPC_PassChar))
				EndIf
			Next
			
			__GUICtrlPasswordCombobox_ToggleEditPassChars($aGCPC_Array[$i][$iGCPC_hInputCtrl], Number(Not $aGCPC_Array[$i][$iGCPC_bShowPass]), $sGCPC_PassChar)
			
			ExitLoop
		EndIf
	Next
EndFunc

Func _GUICtrlPasswordCombobox_AddPassword($iCtrl, $sText = '')
	Local $sData = ''
	
	For $i = 1 To $aGCPC_Array[0][0]
		If $aGCPC_Array[$i][$iGCPC_iComboCtrl] = $iCtrl Then
			Local $aBuffer = $aGCPC_Array[$i][$iGCPC_aBuff]
			
			If $sText = '' Then
				$sText = GUICtrlRead($aGCPC_Array[$i][$iGCPC_iInputCtrl])
				If $sText = '' Then ExitLoop
			EndIf
			
			For $j = 1 To $aBuffer[0]
				If $aBuffer[$j] == $sText Then
					_GUICtrlComboBox_SetCurSel($iCtrl, $j - 1)
					ExitLoop 2
				EndIf
			Next
			
			$aBuffer[0] += 1
			ReDim $aBuffer[$aBuffer[0]+1]
			$aBuffer[$aBuffer[0]] = $sText
			
			GUICtrlSetData($iCtrl, '')
			
			For $j = 1 To $aBuffer[0]
				If $aGCPC_Array[$i][$iGCPC_bShowPass] Then ;Show password
					_GUICtrlComboBox_AddString($iCtrl, $aBuffer[$j])
				Else
					_GUICtrlComboBox_AddString($iCtrl, StringRegExpReplace($aBuffer[$j], '.', $sGCPC_PassChar))
				EndIf
			Next
			
			$aGCPC_Array[$i][$iGCPC_aBuff] = $aBuffer
			
			ExitLoop
		EndIf
	Next
EndFunc

Func _GUICtrlPasswordCombobox_DeletePassword($iCtrl, $sText = '')
	For $i = 1 To $aGCPC_Array[0][0]
		If $aGCPC_Array[$i][$iGCPC_iComboCtrl] = $iCtrl Then
			Local $aBuffer = $aGCPC_Array[$i][$iGCPC_aBuff]
			If $aBuffer[0] = 0 Then ExitLoop
			
			Local $aTmp[1], $iRet = 0
			
			If $sText = '' Then
				$sText = GUICtrlRead($aGCPC_Array[$i][$iGCPC_iInputCtrl])
			EndIf
			
			For $j = 1 To $aBuffer[0]
				If $aBuffer[$j] == $sText Then
					$iRet = $j-2
					_GUICtrlComboBox_DeleteString($iCtrl, $j-1)
				Else
					$aTmp[0] += 1
					ReDim $aTmp[$aTmp[0]+1]
					$aTmp[$aTmp[0]] = $aBuffer[$j]
				EndIf
			Next
			
			$aBuffer = $aTmp
			$aGCPC_Array[$i][$iGCPC_aBuff] = $aBuffer
			
			If $iRet = -1 Then $iRet = 0
			Return $iRet
		EndIf
	Next
EndFunc

Func _GUICtrlPasswordCombobox_EditSetText($iCtrl, $sText)
	For $i = 1 To $aGCPC_Array[0][0]
		If $aGCPC_Array[$i][$iGCPC_iComboCtrl] = $iCtrl Then
			GUICtrlSetData($aGCPC_Array[$i][$iGCPC_iInputCtrl], $sText)
			GUICtrlSetState($aGCPC_Array[$i][$iGCPC_iInputCtrl], $GUI_FOCUS)
			
			Return 1
		EndIf
	Next
EndFunc

Func _GUICtrlPasswordCombobox_EditGetText($iCtrl)
	For $i = 1 To $aGCPC_Array[0][0]
		If $aGCPC_Array[$i][$iGCPC_iComboCtrl] = $iCtrl Then
			Return GUICtrlRead($aGCPC_Array[$i][$iGCPC_iInputCtrl])
		EndIf
	Next
EndFunc

#EndRegion Public Functions

#Region Internal Functions

Func __GUICtrlPasswordCombobox_ToggleEditPassChars($hCtrl, $iToggleState = -1, $sPassChar = -1)
	If Not IsHWnd($hCtrl) Then
		Return SetError(1)
	EndIf
	
	Local Const $EM_SETPASSWORDCHAR = 0xCC
	Local Const $EM_GETPASSWORDCHAR = 0xD2
	
	Local $iGet_Pass_Char, $iSet_Pass_Char, $iDef_Pass_Char = 9679
	Local $aRet = DllCall("user32.dll", "long", "SendMessageW", "hwnd", $hCtrl, "int", $EM_GETPASSWORDCHAR, "int", 0, "int", 0)
	
	If Not @error And $aRet[0] Then
		$iGet_Pass_Char = $aRet[0]
	EndIf
	
	If $sPassChar = -1 Then
		$iSet_Pass_Char = $iGet_Pass_Char
	Else
		If StringLen($sPassChar) = 1 And IsString($sPassChar) Then
			$iSet_Pass_Char = AscW($sPassChar)
		Else
			$iSet_Pass_Char = Number($sPassChar)
		EndIf
		
		$iDef_Pass_Char = $iSet_Pass_Char
	EndIf
	
	If $iToggleState = -1 Then
		If $iGet_Pass_Char <> 0 Then
			$iSet_Pass_Char = 0
		Else
			$iSet_Pass_Char = $iDef_Pass_Char
		EndIf
	ElseIf $iToggleState = 0 Then
		$iSet_Pass_Char = 0
	ElseIf $iToggleState = 1 Then
		$iSet_Pass_Char = $iDef_Pass_Char
	EndIf
	
	DllCall("user32.dll", "none", "SendMessageW", "hwnd", $hCtrl, "int", $EM_SETPASSWORDCHAR, "int", $iSet_Pass_Char, "int", 0)
	DllCall("user32.dll", "none", "InvalidateRect", "hwnd", $hCtrl, "ptr", 0, "int", 1)
EndFunc

Func __GUICtrlPasswordCombobox_WM_COMMAND($hWnd, $nMsg, $wParam, $lParam)
	Local $nNotifyCode = BitShift($wParam, 16)
	Local $iID = BitAND($wParam, 0xFFFF)
	
	Switch $nNotifyCode
		Case $CBN_EDITCHANGE
			For $i = 1 To $aGCPC_Array[0][0]
				If $aGCPC_Array[$i][$iGCPC_iInputCtrl] = $iID Then
					_GUICtrlComboBox_SetEditText($aGCPC_Array[$i][$iGCPC_iComboCtrl], GUICtrlRead($iID))
					ExitLoop
				EndIf
			Next
		Case $CBN_SELCHANGE
			For $i = 1 To $aGCPC_Array[0][0]
				If $aGCPC_Array[$i][$iGCPC_iComboCtrl] = $iID Then
					Local $aBuffer = $aGCPC_Array[$i][$iGCPC_aBuff]
					Local $iIndex = _GUICtrlComboBox_GetCurSel($aGCPC_Array[$i][$iGCPC_iComboCtrl])
					
					If $iIndex >= 0 Then
						GUICtrlSetData($aGCPC_Array[$i][$iGCPC_iInputCtrl], $aBuffer[$iIndex+1])
					EndIf
					
					ExitLoop
				EndIf
			Next
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

#EndRegion Internal Functions
