#include "GUIPasswordCombobox.au3"

Global $sPasswords = 'password||12345|qwerty'
Global $sDefault_Password = '12345'
Global $iMinPasswords = 2
Global $iMaxPasswords = 5 ; -1 = Unlimited

_Example1()
_Example2()

Func _Example1()
	Local $hGUI, $iPass_ComboBox, $iShowPass_CB, $iAddPass_Bttn, $iRemovePass_Bttn
	
	$hGUI = GUICreate('Example #1', 300, 100)
	
	$iPass_ComboBox = _GUICtrlPasswordCombobox_Create($sPasswords, $sDefault_Password, 10, 10, 280, 50)
	_GUICtrlPasswordCombobox_ShowPassword($iPass_ComboBox, True)
	
	$iShowPass_CB = GUICtrlCreateCheckbox('Show passwords', 10, 35)
	GUICtrlSetState(-1, $GUI_CHECKED)
	
	$iAddPass_Bttn = GUICtrlCreateButton('Add', (300 / 2) - 20 - 70, 70, 70, 20, $BS_DEFPUSHBUTTON)
	$iRemovePass_Bttn = GUICtrlCreateButton('Remove', (300 / 2) + 20, 70, 70, 20)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				_GUICtrlPasswordCombobox_Destroy($iPass_ComboBox)
				GUIDelete($hGUI)
				ExitLoop
			Case $iShowPass_CB
				_GUICtrlPasswordCombobox_ShowPassword($iPass_ComboBox, BitAND(GUICtrlRead($iShowPass_CB), $GUI_CHECKED) = $GUI_CHECKED)
			Case $iAddPass_Bttn
				If _GUICtrlComboBox_GetCount($iPass_ComboBox) = $iMaxPasswords Then
					MsgBox(48, 'Attention', StringFormat('Passwords Maximum limit (%i) is reached.', $iMaxPasswords), 0, $hGUI)
				Else
					_GUICtrlPasswordCombobox_AddPassword($iPass_ComboBox)
					_GUICtrlPasswordCombobox_EditSetText($iPass_ComboBox, '')
				EndIf
			Case $iRemovePass_Bttn
				If _GUICtrlComboBox_GetCount($iPass_ComboBox) = $iMinPasswords Then
					MsgBox(48, 'Attention', StringFormat('Passwords Minimum limit (%i) is reached.', $iMinPasswords), 0, $hGUI)
					ContinueLoop
				EndIf
				
				Local $iIndex = _GUICtrlPasswordCombobox_DeletePassword($iPass_ComboBox)
				Local $sText = ''
				
				_GUICtrlComboBox_GetLBText($iPass_ComboBox, $iIndex, $sText)
				_GUICtrlComboBox_SetCurSel($iPass_ComboBox, $iIndex)
				
				_GUICtrlPasswordCombobox_EditSetText($iPass_ComboBox, $sText)
		EndSwitch
	WEnd
EndFunc

Func _Example2()
	Local $hGUI, $iPass_ComboBox, $iShowPass_CB, $iAddRemovePass_Bttn
	
	$hGUI = GUICreate('Example #2', 300, 100)
	
	$iPass_ComboBox = _GUICtrlPasswordCombobox_Create($sPasswords, $sDefault_Password, 10, 10, 280, 50)
	_GUICtrlPasswordCombobox_ShowPassword($iPass_ComboBox, True)
	
	$iShowPass_CB = GUICtrlCreateCheckbox('Show passwords', 10, 35)
	GUICtrlSetState(-1, $GUI_CHECKED)
	
	$iAddRemovePass_Bttn = GUICtrlCreateButton('Add/Remove', (300 / 2) - (70 / 2), 70, 70, 20, $BS_DEFPUSHBUTTON)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				_GUICtrlPasswordCombobox_Destroy($iPass_ComboBox)
				GUIDelete($hGUI)
				ExitLoop
			Case $iShowPass_CB
				_GUICtrlPasswordCombobox_ShowPassword($iPass_ComboBox, BitAND(GUICtrlRead($iShowPass_CB), $GUI_CHECKED) = $GUI_CHECKED)
			Case $iAddRemovePass_Bttn
				Local $iItems_Count = _GUICtrlComboBox_GetCount($iPass_ComboBox)
				Local $sEdit_Text = _GUICtrlPasswordCombobox_EditGetText($iPass_ComboBox)
				Local $sList_Text = ''
				Local $iAdd = 1
				
				For $i = 0 To $iItems_Count-1
					_GUICtrlComboBox_GetLBText($iPass_ComboBox, $i, $sList_Text)
					
					If $sEdit_Text = $sList_Text Then 	
						$iAdd = 0
						ExitLoop
					EndIf
				Next
				
				If $iAdd Then 	;Add password
					If $iItems_Count = $iMaxPasswords Then
						MsgBox(48, 'Attention', StringFormat('Passwords Maximum limit (%i) is reached.', $iMaxPasswords), 0, $hGUI)
						ContinueLoop
					EndIf
					
					_GUICtrlPasswordCombobox_AddPassword($iPass_ComboBox)
				Else			;Remove password
					If $iItems_Count = $iMinPasswords Then
						MsgBox(48, 'Attention', StringFormat('Passwords Minimum limit (%i) is reached.', $iMinPasswords), 0, $hGUI)
						ContinueLoop
					EndIf
					
					Local $iIndex = _GUICtrlPasswordCombobox_DeletePassword($iPass_ComboBox)
					_GUICtrlComboBox_SetCurSel($iPass_ComboBox, $iIndex)
					_GUICtrlComboBox_GetLBText($iPass_ComboBox, $iIndex, $sEdit_Text)
					_GUICtrlPasswordCombobox_EditSetText($iPass_ComboBox, $sEdit_Text)
				EndIf
		EndSwitch
	WEnd
EndFunc
