#include-once
#include <GUIConstantsEx.au3>
#include <ComboConstants.au3>
#include <WindowsConstants.au3>

Global Enum _
	$iMSG_First = 0, _
		$iMSG_BlockItUtility, $iMSG_ToBlockFilesFol_ToTheListBellow, $iMSG_BlockedItems, _
		$iMSG_BlockUnBlockSelected, $iMSG_RemoveSelected, $iMSG_AddFiles, $iMSG_AddFolder, $iMSG_Settings, _
		$iMSG_ShowSettingsDialog, $iMSG_PleaseSelectFileToBlock, $iMSG_PleaseSelectFolderToBlock, $iMSG_Attention, $iMSG_NoSelectedItems, _
		$iMSG_Attention_1, $iMSG_AreYouSureRemoveSelectedItems, $iMSG_General, $iMSG_Language, $iMSG_Start, $iMSG_WithWindows, _
		$iMSG_StartHidden, $iMSG_Hide, $iMSG_WhenClosing, $iMSG_Show, $iMSG_HotKey, _
		$iMSG_Other, $iMSG_SetMasterPasswordFor, $iMSG_Usage, $iMSG_OK, $iMSG_Cancel, $iMSG_RestartTheProgram, _
		$iMSG_ErrorUnableToBlockTheFile, $iMSG_ErrorUnableToBlockTheFolder, $iMSG_BlockFailedFileInUse, $iMSG_BlockFailed, $iMSG_ErrorUnableToBlockTheFile_1, _
		$iMSG_ErrorUnableToBlockTheFolder_1, $iMSG_CloseHandleFail, $iMSG_ErrorUnableToUnBlockTheFile, $iMSG_ErrorUnableToUnBlockTheFolder, $iMSG_Success, _
		$iMSG_FileUnBlocked, $iMSG_ErrorUnableToOpenTheFile, $iMSG_ThisFileIsBlockedBy, $iMSG_ErrorUnableToOpenTheFolder, $iMSG_ThisFolderIsBlockedBy, _
		$iMSG_MasterPassword, $iMSG_PleaseEnterPasswordToUnlock, $iMSG_Error, $iMSG_WrongPasswordPleaseEnterEgain, _
	$iMSG_Last

Global Const $LANGS_DIR = @ScriptDir & '\Languages'
Global $aTXT = _AppTranslation_Register($LANGS_DIR & "\English.lng")

Func _AppTranslation_Register($sLangFile, $sSetDataFunc = "")
	Local $aTXT[$iMSG_Last+1]
	Local $iFileEncoding = FileGetEncoding($sLangFile)
	
	;Default values
	$aTXT[$iMSG_BlockItUtility] = _AppTranslation_GetString($sLangFile, "BlockItUtility", "BlockIt", $iFileEncoding)
	$aTXT[$iMSG_ToBlockFilesFol_ToTheListBellow] = _AppTranslation_GetString($sLangFile, "ToBlockFilesFol_ToTheListBellow", "* To block, Drag && Drop Files/Folders to the list bellow", $iFileEncoding)
	$aTXT[$iMSG_BlockedItems] = _AppTranslation_GetString($sLangFile, "BlockedItems", "Blocked Items", $iFileEncoding)
	$aTXT[$iMSG_BlockUnBlockSelected] = _AppTranslation_GetString($sLangFile, "BlockUnBlockSelected", "Block/UnBlock selected", $iFileEncoding)
	$aTXT[$iMSG_RemoveSelected] = _AppTranslation_GetString($sLangFile, "RemoveSelected", "Remove selected", $iFileEncoding)
	$aTXT[$iMSG_AddFiles] = _AppTranslation_GetString($sLangFile, "AddFiles", "Add Files...", $iFileEncoding)
	$aTXT[$iMSG_AddFolder] = _AppTranslation_GetString($sLangFile, "AddFolder", "Add Folder...", $iFileEncoding)
	$aTXT[$iMSG_Settings] = _AppTranslation_GetString($sLangFile, "Settings", "Settings", $iFileEncoding)
	$aTXT[$iMSG_ShowSettingsDialog] = _AppTranslation_GetString($sLangFile, "ShowSettingsDialog", "Show settings dialog...", $iFileEncoding)
	$aTXT[$iMSG_PleaseSelectFileToBlock] = _AppTranslation_GetString($sLangFile, "PleaseSelectFileToBlock", "Please select Files to Block", $iFileEncoding)
	$aTXT[$iMSG_PleaseSelectFolderToBlock] = _AppTranslation_GetString($sLangFile, "PleaseSelectFolderToBlock", "Please select Folder to Block", $iFileEncoding)
	$aTXT[$iMSG_Attention] = _AppTranslation_GetString($sLangFile, "Attention", "Attention", $iFileEncoding)
	$aTXT[$iMSG_NoSelectedItems] = _AppTranslation_GetString($sLangFile, "NoSelectedItems", "No selected items.", $iFileEncoding)
	$aTXT[$iMSG_Attention_1] = _AppTranslation_GetString($sLangFile, "Attention_1", "Attention", $iFileEncoding)
	$aTXT[$iMSG_AreYouSureRemoveSelectedItems] = _AppTranslation_GetString($sLangFile, "AreYouSureRemoveSelectedItems", "Are you sure, remove selected items?", $iFileEncoding)
	$aTXT[$iMSG_General] = _AppTranslation_GetString($sLangFile, "General", "General", $iFileEncoding)
	$aTXT[$iMSG_Language] = _AppTranslation_GetString($sLangFile, "Language", "Language", $iFileEncoding)
	$aTXT[$iMSG_Start] = _AppTranslation_GetString($sLangFile, "Start", "Start ", $iFileEncoding)
	$aTXT[$iMSG_WithWindows] = _AppTranslation_GetString($sLangFile, "WithWindows", " with windows", $iFileEncoding)
	$aTXT[$iMSG_StartHidden] = _AppTranslation_GetString($sLangFile, "StartHidden", "Start hidden", $iFileEncoding)
	$aTXT[$iMSG_Hide] = _AppTranslation_GetString($sLangFile, "Hide", "Hide ", $iFileEncoding)
	$aTXT[$iMSG_WhenClosing] = _AppTranslation_GetString($sLangFile, "WhenClosing", " when closing", $iFileEncoding)
	$aTXT[$iMSG_Show] = _AppTranslation_GetString($sLangFile, "Show", "Show ", $iFileEncoding)
	$aTXT[$iMSG_HotKey] = _AppTranslation_GetString($sLangFile, "HotKey", " HotKey", $iFileEncoding)
	$aTXT[$iMSG_Other] = _AppTranslation_GetString($sLangFile, "Other", "Other", $iFileEncoding)
	$aTXT[$iMSG_SetMasterPasswordFor] = _AppTranslation_GetString($sLangFile, "SetMasterPasswordFor", "Set Master Password for ", $iFileEncoding)
	$aTXT[$iMSG_Usage] = _AppTranslation_GetString($sLangFile, "Usage", " usage", $iFileEncoding)
	$aTXT[$iMSG_OK] = _AppTranslation_GetString($sLangFile, "OK", "OK", $iFileEncoding)
	$aTXT[$iMSG_Cancel] = _AppTranslation_GetString($sLangFile, "Cancel", "Cancel", $iFileEncoding)
	$aTXT[$iMSG_RestartTheProgram] = _AppTranslation_GetString($sLangFile, "RestartTheProgram", "To change the language program should be restarted, restart now?", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToBlockTheFile] = _AppTranslation_GetString($sLangFile, "ErrorUnableToBlockTheFile", "Error - Unable to Block the File", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToBlockTheFolder] = _AppTranslation_GetString($sLangFile, "ErrorUnableToBlockTheFolder", "Error - Unable to Block the Folder", $iFileEncoding)
	$aTXT[$iMSG_BlockFailedFileInUse] = _AppTranslation_GetString($sLangFile, "BlockFailedFileInUse", "[Block Failed - File in use]:", $iFileEncoding)
	$aTXT[$iMSG_BlockFailed] = _AppTranslation_GetString($sLangFile, "BlockFailed", "[Block Failed]:", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToBlockTheFile_1] = _AppTranslation_GetString($sLangFile, "ErrorUnableToBlockTheFile_1", "Error - Unable to Block the File:", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToBlockTheFolder_1] = _AppTranslation_GetString($sLangFile, "ErrorUnableToBlockTheFolder_1", "Error - Unable to Block the Folder:", $iFileEncoding)
	$aTXT[$iMSG_CloseHandleFail] = _AppTranslation_GetString($sLangFile, "CloseHandleFail", "[CloseHandle Fail]: ", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToUnBlockTheFile] = _AppTranslation_GetString($sLangFile, "ErrorUnableToUnBlockTheFile", "Error - Unable to UnBlock the File ", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToUnBlockTheFolder] = _AppTranslation_GetString($sLangFile, "ErrorUnableToUnBlockTheFolder", "Error - Unable to UnBlock the Folder ", $iFileEncoding)
	$aTXT[$iMSG_Success] = _AppTranslation_GetString($sLangFile, "Success", "Success", $iFileEncoding)
	$aTXT[$iMSG_FileUnBlocked] = _AppTranslation_GetString($sLangFile, "FileUnBlocked", "File UnBlocked.", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToOpenTheFile] = _AppTranslation_GetString($sLangFile, "ErrorUnableToOpenTheFile", "Error - Unable to Open the File:", $iFileEncoding)
	$aTXT[$iMSG_ThisFileIsBlockedBy] = _AppTranslation_GetString($sLangFile, "ThisFileIsBlockedBy", "This File (%s) is blocked by ", $iFileEncoding)
	$aTXT[$iMSG_ErrorUnableToOpenTheFolder] = _AppTranslation_GetString($sLangFile, "ErrorUnableToOpenTheFolder", "Error - Unable to Open the Folder:", $iFileEncoding)
	$aTXT[$iMSG_ThisFolderIsBlockedBy] = _AppTranslation_GetString($sLangFile, "ThisFolderIsBlockedBy", "This Folder (%s) is blocked by ", $iFileEncoding)
	$aTXT[$iMSG_MasterPassword] = _AppTranslation_GetString($sLangFile, "MasterPassword", "Master Password", $iFileEncoding)
	$aTXT[$iMSG_PleaseEnterPasswordToUnlock] = _AppTranslation_GetString($sLangFile, "PleaseEnterPasswordToUnlock", "Please enter password to unlock ", $iFileEncoding)
	$aTXT[$iMSG_Error] = _AppTranslation_GetString($sLangFile, "Error", "Error", $iFileEncoding)
	$aTXT[$iMSG_WrongPasswordPleaseEnterEgain] = _AppTranslation_GetString($sLangFile, "WrongPasswordPleaseEnterEgain", "Wrong password, please enter again", $iFileEncoding)
	
	If $sSetDataFunc <> "" Then
		Call($sSetDataFunc, $aTXT)
	EndIf
	
	Return $aTXT
EndFunc

Func _AppTranslation_GetLanguages($sLangs_Dir, $bRetArray = False)
	Local $sRet, $sLngFileName, $hSearch = FileFindFirstFile($sLangs_Dir & "\*.lng")
	If $hSearch = -1 Then Return SetError(-1, 0, '')
	
	While 1
		$sLngFileName = FileFindNextFile($hSearch)
		If @error <> 0 Then ExitLoop
		$sRet &= StringLeft($sLngFileName, StringInStr($sLngFileName, ".", 2, -1) - 1) & "|"
	WEnd
	
	FileClose($hSearch)
	
	If $sRet = "" Then Return SetError(1, 0, "")
	
	$sRet = StringTrimRight($sRet, 1)
	If $bRetArray Then $sRet = StringSplit($sRet, "|")
	Return $sRet
EndFunc

Func _AppTranslation_GetString($sLangFile, $sIdentifier, $sDefault = "", $iFileEncoding = 0)
	Local $sStr = IniRead($sLangFile, "Translation", $sIdentifier, $sDefault)
	
	If $iFileEncoding >= 128 Then
		$sStr = BinaryToString(StringToBinary($sStr), 4)
	EndIf
	
	Return $sStr
EndFunc

Func _AppTranslation_SelectLangGUI($sAppName, $hParent = 0, $sDefLng = "")
	Local $hGUI, $nLng_Combo, $iMsg
	
	GUISetState(@SW_DISABLE, $hParent)
	$hGUI = GUICreate($sAppName, 300, 120, -1, -1, -1, $WS_EX_TOOLWINDOW, $hParent)
	
	GUICtrlCreateLabel("Language:", 20, 52, 80, 17)
	$nLng_Combo = GUICtrlCreateCombo("", 110, 50, 170, 50, BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSetData($nLng_Combo, _AppTranslation_GetLanguages($LANGS_DIR), $sDefLng)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $nLng_Combo
				$sDefLng = GUICtrlRead($nLng_Combo)
				$aTXT = _AppTranslation_Register($LANGS_DIR & "\" & $sDefLng & ".lng")
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $hParent)
	GUIDelete($hGUI)
	
	Return $sDefLng
EndFunc
