#include-once
#include <GUIConstants.au3>
#include <Misc.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#include <File.au3>

FileInstall('Resources\Titlebar.bmp', @TempDir & '\Titlebar.bmp')
FileInstall('Resources\Button.bmp', @TempDir & '\Button.bmp')
FileInstall('Resources\Leave.bmp', @TempDir & '\Leave.bmp')

OnAutoItExitRegister("_On_CBx_Exit")

Global $hDarkLayer = -1, $hCustomBox = -1, $Wd = 1, $nOK_Button = -1, $nYes_Button = -1, $nNo_Button = -1, $nCancel_Button = -1, $nAbort_Button = -1, $nRetry_Button = -1, $nIgnore_Button = -1, $nTryAgain_Button = -1, $nContinue_Button = -1

;_GUICtrlSetOnHover Global Variables
Global $aHOVER_CONTROLS_ARRAY[1][1]
Global $aLAST_HOVERED_ELEMENT[2] = [-1, -1]
Global $aLAST_HOVERED_ELEMENT_MARK = -1

Func _CustomBox($sTitle, $sText, $iOpt = 0, $Background = 1, $hWnd = 0, $iBeep = -1, $iX = -1, $iY = -1, $nTitle_LabelColor = 0x000000, $nTitle_LabelSize = 14, $nTitle_LabelWeight = 800, $nTitle_LabelStyle = $SS_CENTER, $nTitle_LabelFont = 'Arial', $nTextColor = 0xFF8000, $iTextSize = 15, $iTextWeight = 800, $sTextFont = 'Arial', $nTextStyle = $SS_CENTER)
	
	If IsHWnd($hWnd) Then GUISetState(@SW_DISABLE, $hWnd)
	
	If $Background = 1 Then
		$hDarkLayer = GUICreate($sTitle, @DesktopWidth, @DesktopHeight, 0, 0, $WS_POPUP, $WS_EX_TOPMOST, $hWnd)
		GUISetBkColor(0x000000)
		WinSetTrans($hDarkLayer, "", 100)
		GUISetState(@SW_SHOW, $hDarkLayer)
	EndIf
	
	If $Background = 1 Then
		$hCustomBox = GUICreate($sTitle, 500, 280, $iX, $iY, $WS_POPUPWINDOW, 0, $hDarkLayer)
	Else
		$hCustomBox = GUICreate($sTitle, 500, 280, $iX, $iY, $WS_POPUPWINDOW, -1, $hWnd)
	EndIf
	
	GUISetBkColor(0xC7ECF7)
	GUICtrlSetDefBkColor($GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetDefColor(0xC7ECF7)
	
	$nTitle_LabelPic = GUICtrlCreatePic(@TempDir & "\Titlebar.bmp", 0, 0, 500, 100, $WS_CLIPSIBLINGS, $GUI_WS_EX_PARENTDRAG)
	$nText_Label = GUICtrlCreateLabel($sText, 0, 110, 500, 110, $nTextStyle, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, $iTextSize, $iTextWeight, 0, $sTextFont)
	GUICtrlSetColor(-1, $nTextColor)
	$nTitle_Label = GUICtrlCreateLabel($sTitle, 0, 30, 500, 60, $nTitle_LabelStyle, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, $nTitle_LabelSize, $nTitle_LabelWeight, 0, $nTitle_LabelFont)
	GUICtrlSetColor(-1, $nTitle_LabelColor)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	$xLabel = GUICtrlCreateLabel("X", 500 - 15, 0, 11, 17)
	GUICtrlSetFont(-1, 10, 800, 0, "Comic Sans MS")
	GUICtrlSetColor(-1, 0x000000)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	_GUICtrlSetOnHover($xLabel, '_LabelHovered', '_LabelUnHovered')
	
	If $iOpt = 0 Then
		$nOK_Button = _GUICtrlCreateButton('Ok', 205, 220, 80, 40)
	ElseIf $iOpt = 1 Then
		$nOK_Button = _GUICtrlCreateButton('Ok', 150, 220, 80, 40)
		$nCancel_Button = _GUICtrlCreateButton('Cancel', 240, 220, 80, 40)
	ElseIf $iOpt = 2 Then
		$nAbort_Button = _GUICtrlCreateButton('Abort', 120, 220, 80, 40)
		$nRetry_Button = _GUICtrlCreateButton('Retry', 210, 220, 80, 40)
		$nIgnore_Button = _GUICtrlCreateButton('Ignore', 300, 220, 80, 40)
	ElseIf $iOpt = 3 Then
		$nYes_Button = _GUICtrlCreateButton('Yes', 120, 220, 80, 40)
		$nNo_Button = _GUICtrlCreateButton('No', 210, 220, 80, 40)
		$nCancel_Button = _GUICtrlCreateButton('Cancel', 300, 220, 80, 40)
	ElseIf $iOpt = 4 Then
		$nYes_Button = _GUICtrlCreateButton('Yes', 150, 220, 80, 40)
		$nNo_Button = _GUICtrlCreateButton('No', 240, 220, 80, 40)
	ElseIf $iOpt = 5 Then
		$nRetry_Button = _GUICtrlCreateButton('Retry', 150, 220, 80, 40)
		$nCancel_Button = _GUICtrlCreateButton('Cancel', 240, 220, 80, 40)
	ElseIf $iOpt = 6 Then
		$nCancel_Button = _GUICtrlCreateButton('Cancel', 120, 220, 80, 40)
		$nTryAgain_Button = _GUICtrlCreateButton('Try Again', 210, 220, 80, 40)
		$nContinue_Button = _GUICtrlCreateButton('Continue', 300, 220, 80, 40)
	EndIf
	
	Local $iReturn = 0
	Local $nDummy_Ctrl = GUICtrlCreateDummy()
	
	For $i = $xLabel+1 To $nDummy_Ctrl-1
		_GUICtrlSetOnHover($i, '_ButtonHovered', '_ButtonUnHovered')
	Next
	
	If $iBeep <> -1 Then DllCall("user32.dll", "int", "MessageBeep", "int", $iBeep)
	GUISetState(@SW_SHOW, $hCustomBox)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				$iReturn = 0
				ExitLoop
			Case $xLabel
				$iReturn = 0
				ExitLoop
			Case $nOK_Button
				If $iOpt = 0 Or $iOpt = 1 Then
					$iReturn = 1
					ExitLoop
				EndIf
			Case $nYes_Button
				If $iOpt = 3 Or $iOpt = 4 Then
					$iReturn = 6
					ExitLoop
				EndIf
			Case $nNo_Button
				If $iOpt = 3 Or $iOpt = 4 Then
					$iReturn = 7
					ExitLoop
				EndIf
			Case $nCancel_Button
				If $iOpt = 1 Or $iOpt = 3 Or $iOpt = 5 Or $iOpt = 6 Then
					$iReturn = 2
					ExitLoop
				EndIf
			Case $nAbort_Button
				If $iOpt = 2 Then
					$iReturn = 3
					ExitLoop
				EndIf
			Case $nRetry_Button
				If $iOpt = 2 Or $iOpt = 5 Then
					$iReturn = 4
					ExitLoop
				EndIf
			Case $nIgnore_Button
				If $iOpt = 2 Then
					$iReturn = 5
					ExitLoop
				EndIf
			Case $nTryAgain_Button
				If $iOpt = 6 Then
					$iReturn = 10
					ExitLoop
				EndIf
			Case $nContinue_Button
				If $iOpt = 6 Then
					$iReturn = 11
					ExitLoop
				EndIf
		EndSwitch
		
		__CALLBACK_HOVER_PROC()
	WEnd
	
	For $i = $xLabel To $nDummy_Ctrl-1
		_GUICtrlUnSetOnHover($i)
	Next
	
	If IsHWnd($hWnd) Then GUISetState(@SW_ENABLE, $hWnd)
	
	If IsHWnd($hDarkLayer) Then GUIDelete($hDarkLayer)
	GUIDelete($hCustomBox)
	
	Return $iReturn
EndFunc

Func _LabelHovered($CtrlID)
	GUICtrlSetColor($CtrlID, 0xF4BE1C)
EndFunc

Func _LabelUnHovered($CtrlID)
	GUICtrlSetColor($CtrlID, 0x000000)
EndFunc

Func _ButtonHovered($CtrlID)
	GUICtrlSetImage($CtrlID, @TempDir & '\Button.bmp')
EndFunc

Func _ButtonUnHovered($CtrlID)
	GUICtrlSetImage($CtrlID, @TempDir & '\Leave.bmp')
EndFunc

Func _GUICtrlCreateButton($sText, $iX, $iY, $iWidth, $iHeight)
	Local $iPic_Ctrl = GUICtrlCreatePic(@TempDir & '\Leave.bmp', $iX, $iY, $iWidth + 10, $iHeight + 10)
	
	GUICtrlCreateLabel($sText, $iX + 6, $iY + 15, $iWidth, $iHeight, $SS_CENTER)
	GUICtrlSetFont(-1, 12, 800)
	GUICtrlSetColor(-1, 0x000000)
	
	If $iPic_Ctrl = 0 Then Return 1
	Return $iPic_Ctrl
EndFunc

;===============================================================================
;
; Function Name:    _GUICtrlSetOnHover()
; Description:      Set function(s) to call when hovering/leave hovering GUI elements.
; Parameter(s):     $iCtrlID - The Ctrl ID to set hovering for (can be a -1 as indication to the last item created).
;                   $sHover_FuncName - Function to call when the mouse is hovering the control.
;                   $sLeaveHover_FuncName - [Optional] Function to call when the mouse is leaving hovering the control
;                       (-1 no function used).
;
; Return Value(s):  Always returns 1 regardless of success.
; Requirement(s):   AutoIt 3.2.10.0
; Note(s):          1) TreeView/ListView Items can not be set :(.
;                   2) When the window is not active, the hover/leave hover functions will still called,
;                      but not when the window is disabled.
;                   3) The hover/leave hover functions will be called even if the script is paused by such functions as MsgBox().
; Author(s):        G.Sandler (a.k.a CreatoR).
;
;===============================================================================
Func _GUICtrlSetOnHover($iCtrlID, $sHover_FuncName, $sLeaveHover_FuncName=-1)
	Local $iUbound = UBound($aHOVER_CONTROLS_ARRAY)
	
;~ 	AdlibRegister("__CALLBACK_HOVER_PROC", 10)
	
	ReDim $aHOVER_CONTROLS_ARRAY[$iUbound+1][3]
	$aHOVER_CONTROLS_ARRAY[$iUbound][0] = GUICtrlGetHandle($iCtrlID)
	$aHOVER_CONTROLS_ARRAY[$iUbound][1] = $sHover_FuncName
	$aHOVER_CONTROLS_ARRAY[$iUbound][2] = $sLeaveHover_FuncName
	$aHOVER_CONTROLS_ARRAY[0][0] = $iUbound
EndFunc

;UnSet Hovering for specified control (remove control id from hovering checking process)
Func _GUICtrlUnSetOnHover($iCtrlID)
	Local $aHOVER_CONTROLS_Tmp[1][1]
	
	For $i = 1 To UBound($aHOVER_CONTROLS_ARRAY)-1
		If GUICtrlGetHandle($iCtrlID) <> $aHOVER_CONTROLS_ARRAY[$i][0] Then
			$aHOVER_CONTROLS_Tmp[0][0] += 1
			ReDim $aHOVER_CONTROLS_Tmp[$aHOVER_CONTROLS_Tmp[0][0]+1][3]
			$aHOVER_CONTROLS_Tmp[$aHOVER_CONTROLS_Tmp[0][0]][0] = $aHOVER_CONTROLS_ARRAY[$i][0]
			$aHOVER_CONTROLS_Tmp[$aHOVER_CONTROLS_Tmp[0][0]][1] = $aHOVER_CONTROLS_ARRAY[$i][1]
			$aHOVER_CONTROLS_Tmp[$aHOVER_CONTROLS_Tmp[0][0]][2] = $aHOVER_CONTROLS_ARRAY[$i][2]
		EndIf
	Next
	
	If $aHOVER_CONTROLS_Tmp[0][0] < 1 Then
;~ 		AdlibUnRegister("__CALLBACK_HOVER_PROC")
	Else
		$aHOVER_CONTROLS_ARRAY = $aHOVER_CONTROLS_Tmp
	EndIf
EndFunc

;CallBack function to handle the hovering process
Func __CALLBACK_HOVER_PROC()
	If UBound($aHOVER_CONTROLS_ARRAY)-1 < 1 Then Return
	Local $iControl_Hovered = _ControlGetHovered()
	Local $sCheck_LHE = $aLAST_HOVERED_ELEMENT[1]
	
	If $iControl_Hovered = 0 Or ($sCheck_LHE <> -1 And $iControl_Hovered <> $sCheck_LHE) Then
		If $aLAST_HOVERED_ELEMENT_MARK = -1 Then Return
		If $aLAST_HOVERED_ELEMENT[0] <> -1 Then Call($aLAST_HOVERED_ELEMENT[0], $aLAST_HOVERED_ELEMENT[1])
		$aLAST_HOVERED_ELEMENT[0] = -1
		$aLAST_HOVERED_ELEMENT[1] = -1
		$aLAST_HOVERED_ELEMENT_MARK = -1
	Else
		For $i = 1 To $aHOVER_CONTROLS_ARRAY[0][0]
			If $aHOVER_CONTROLS_ARRAY[$i][0] = GUICtrlGetHandle($iControl_Hovered) Then
				If $aLAST_HOVERED_ELEMENT_MARK = $aHOVER_CONTROLS_ARRAY[$i][0] Then ExitLoop
				$aLAST_HOVERED_ELEMENT_MARK = $aHOVER_CONTROLS_ARRAY[$i][0]
				
				Call($aHOVER_CONTROLS_ARRAY[$i][1], $iControl_Hovered)
				
				If $aHOVER_CONTROLS_ARRAY[$i][2] <> -1 Then
					$aLAST_HOVERED_ELEMENT[0] = $aHOVER_CONTROLS_ARRAY[$i][2]
					$aLAST_HOVERED_ELEMENT[1] = $iControl_Hovered
				EndIf
				
				ExitLoop
			EndIf
		Next
	EndIf
EndFunc

;Thanks to amel27 for that one!!!
Func _ControlGetHovered()
	Local $Old_Opt_MCM = Opt("MouseCoordMode", 1)
	Local $aRet = DllCall("user32.dll", "int", "WindowFromPoint", _
		"long", MouseGetPos(0), _
		"long", MouseGetPos(1))
	$aRet = DllCall("user32.dll", "int", "GetDlgCtrlID", "hwnd", $aRet[0])
	Opt("MouseCoordMode", $Old_Opt_MCM)
	Return $aRet[0]
EndFunc

Func _On_CBx_Exit()
;~ 	AdlibUnRegister("__CALLBACK_HOVER_PROC")
	
	FileDelete(@TempDir & '\Titlebar.bmp')
	FileDelete(@TempDir & '\Button.bmp')
	FileDelete(@TempDir & '\Leave.bmp')
EndFunc
