#NoTrayIcon
#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Resources\Icon.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=Program made by G.Sandler
#AutoIt3Wrapper_Res_Description=BlockIt Utility to block File and Folders
#AutoIt3Wrapper_Res_Fileversion=0.4.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2012 G.Sandler (CreatoR), www.autoit-script.ru. All rights reserved.
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#Obfuscator_Ignore_Funcs=_Settings_GUI, _LabelHovered, _LabelUnHovered, _ButtonHovered, _ButtonUnHovered

#Region Header

#CS
;BlockIt Utility by G.Sandler (CreatoR) (main idea by rasim) - Alpha version.
;Tested on WinXP SP2/Win 7, Russian localization
;Download URL: http://creator-lab.ucoz.ru/Open_Source/BlockIt.zip

;Hostory:
			v0.4
			* Now when shortcut is dropped, the path taken from it's target.
			* Fixed encoding issues.
			* Fixed issue with loading block list.
			* Fixed issue with ublocked objects.
			* Improved error handling.
			
			v0.3
			* Added #RequireAdmin, this utility must be executed with admin rights.
			* Fixed crash when removing all list items.
			* Fixed issue with not removed list items.
			* Fixed master password related issue.
			* Fixed language encoding issue.
			* Fixed HotKeys and Accelerators issue.
			
			v0.2
			+ Added multilanguage support.
			* Compatibility with AutoIt 3.3.8.1.
			* Small fixes.
			
			v0.1
			First version.
			
#CE

#include <GUIConstantsEx.au3>
#include <GUIListView.au3>
#include <EditConstants.au3>
#include <WindowsConstants.au3>
#include <String.au3>
#include <Misc.au3>

#include "Includes\APIConstants.au3"
#include "Includes\Translation.au3"
#include "Includes\Encoding.au3"
#include "Includes\CustomBox.au3"
#include "Includes\GUIHyperLink.au3"
#include "Includes\GUIHotkey.au3"
#include "Includes\WinAPIEx.au3"

#EndRegion

#Region Global Variables

Global Enum $iBF_FileName, $iBF_FileHandle, $iBF_BlockState, $iBF_TotalItems
Global $aBF_List[1][$iBF_TotalItems]

Global $aDropped_Files[1]
Global $vItem_Checked = 0

Global $hSettings_GUI

Global $iGUI_W = 600
Global $iGUI_H = 450

Global $sConfig_File = @ScriptDir & "\Config.ini"

Global $sApp_Language = _IniReadEx($sConfig_File, "Main", "Language", "English")
Global $iStart_With_Windows = Number(_IniReadEx($sConfig_File, "Main", "Start With Windows", 0))
Global $iStart_Hidden = Number(_IniReadEx($sConfig_File, "Main", "Start Hidden", 0))
Global $iHide_On_Close = Number(_IniReadEx($sConfig_File, "Main", "Hide On Close", 0))
Global $sShowApp_HotKey = _IniReadEx($sConfig_File, "Main", "Show HotKey", "^+b")
Global $iSet_Master_Password = Number(_IniReadEx($sConfig_File, "Main", "Set Master Password", 0))
Global $sMaster_Password = _IniReadEx($sConfig_File, "Main", "Master Password", "")

$aTXT = _AppTranslation_Register($LANGS_DIR & '\' & $sApp_Language & '.lng')

Global $iCheckBlockMsg_Intrvl = 100
Global $sApp_Name = $aTXT[$iMSG_BlockItUtility]

If $sMaster_Password <> "" Then
	$sMaster_Password = _StringEncrypt(0, $sMaster_Password, $sApp_Name)
EndIf

#EndRegion

#Region Startup and Options

If WinExists("~@~" & $sApp_Name & "~@~") Then
	$sTitle = '[CLASS:AutoIt v3 GUI;REGEXPTITLE:' & $sApp_Name & '.*]'
	If BitAND(WinGetState($sTitle), 2) Then WinActivate($sTitle)
	Exit -1
EndIf

AutoItWinSetTitle("~@~" & $sApp_Name & "~@~")

Opt("GUICloseOnESC", 0)
Opt("WinWaitDelay", 1)
Opt("WinTextMatchMode", 2)

AdlibRegister("_Check_BlockMsg_Proc", $iCheckBlockMsg_Intrvl)

#EndRegion

#Region GUI

$hMain_GUI = GUICreate($sApp_Name & " - by G.Sandler (CreatoR) (main idea by rasim)", $iGUI_W, $iGUI_H, -1, -1, -1, $WS_EX_ACCEPTFILES)

$iMain_Dummy = GUICtrlCreateDummy()
$iSpaceCtrl_Dummy = GUICtrlCreateDummy()

GUICtrlCreateLabel($aTXT[$iMSG_ToBlockFilesFol_ToTheListBellow], 20, 10, $iGUI_W - 100, 17)
GUICtrlSetFont(-1, 9, 800)
GUICtrlSetColor(-1, 0xFF0000)

$iBlockFiles_LV = GUICtrlCreateListView($aTXT[$iMSG_BlockedItems], 20, 30, $iGUI_W - 40, $iGUI_H - 100, _
	BitOr($LVS_SHOWSELALWAYS, $LVS_NOCOLUMNHEADER), BitOR($LVS_EX_CHECKBOXES, $WS_EX_CLIENTEDGE, $WS_EX_DLGMODALFRAME))

GUICtrlSendMsg($iBlockFiles_LV, $LVM_SETCOLUMNWIDTH, 0, $iGUI_W - 50)
GUICtrlSetState($iBlockFiles_LV, $GUI_DROPACCEPTED)

$iBlockSelFiles_Bttn = GUICtrlCreateButton($aTXT[$iMSG_BlockUnBlockSelected], 20, $iGUI_H - 30, 160, 20)
$iRemoveSelFiles_Bttn = GUICtrlCreateButton($aTXT[$iMSG_RemoveSelected], 20, $iGUI_H - 60, 160, 20)

$iAddFiles_Bttn = GUICtrlCreateButton($aTXT[$iMSG_AddFiles], 200, $iGUI_H - 30, 110, 20)
$iAddFolder_Bttn = GUICtrlCreateButton($aTXT[$iMSG_AddFolder], 200, $iGUI_H - 60, 110, 20)

$iSettings_HyperLink = _GUICtrlHyperLink_Create($aTXT[$iMSG_Settings], $iGUI_W - 75, $iGUI_H - 25, 55, 15, 0x0000FF, 0x551A8B, 1, "_Settings_GUI()", $aTXT[$iMSG_ShowSettingsDialog], $hMain_GUI)

_BlockFileList_Load()

GUIRegisterMsg($WM_DROPFILES, "WM_DROPFILES")
GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")

If $iStart_Hidden = 0 And Not StringInStr($CmdLineRaw, "/Hide") Then
	GUISetState(@SW_SHOW, $hMain_GUI)
EndIf

#EndRegion

#Region Accelerators and HotKeys

Dim $aAccelKeys[8][2] = [ _
	["{Space}", $iSpaceCtrl_Dummy], _
	["^{Space}", $iSpaceCtrl_Dummy], _
	["!{Space}", $iSpaceCtrl_Dummy], _
	["+{Space}", $iSpaceCtrl_Dummy], _
	["^+{Space}", $iSpaceCtrl_Dummy], _
	["^+!{Space}", $iSpaceCtrl_Dummy], _
	["+!{Space}", $iSpaceCtrl_Dummy], _
	["^!{Space}", $iSpaceCtrl_Dummy]]

_FixAccelHotKeyLayout()
HotKeySet($sShowApp_HotKey, "_Show_App_Window_Proc")
GUISetAccelerators($aAccelKeys, $hMain_GUI)

#EndRegion Accelerators and HotKeys

#Region Main Loop

While 1
    Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			If $iHide_On_Close = 1 Then ContinueCase
			_Quit_Proc()
		Case $GUI_EVENT_MINIMIZE
			GUISetState(@SW_HIDE, $hMain_GUI)
		Case $GUI_EVENT_DROPPED
			_BlockFileList_AddFiles($aDropped_Files)
		Case $iAddFiles_Bttn
			AdlibUnRegister("_Check_BlockMsg_Proc")
			
			Local $sFile = FileOpenDialog($aTXT[$iMSG_PleaseSelectFileToBlock], "", "All files (*.*)", 15, "", $hMain_GUI)
			
			If Not @error Then
				Local $aFiles_Tmp = StringSplit($sFile, "|")
				If $aFiles_Tmp[0] = 1 Then Dim $aFiles_Tmp[3] = [2, @WorkingDir, StringRegExpReplace($sFile, ".*\\(.*)$", "\1")]
				
				Local $aFiles[$aFiles_Tmp[0]] = [$aFiles_Tmp[0]-1]
				
				$aFiles_Tmp[1] = StringRegExpReplace($aFiles_Tmp[1], "\\+$", "")
				
				For $i = 2 To $aFiles_Tmp[0]
					$aFiles[$i-1] = $aFiles_Tmp[1] & "\" & $aFiles_Tmp[$i]
				Next
				
				_BlockFileList_AddFiles($aFiles)
			EndIf
			
			AdlibRegister("_Check_BlockMsg_Proc", $iCheckBlockMsg_Intrvl)
		Case $iAddFolder_Bttn
			AdlibUnRegister("_Check_BlockMsg_Proc")
			
			Local $sFolder = FileSelectFolder($aTXT[$iMSG_PleaseSelectFolderToBlock], "", 6, @WorkingDir, $hMain_GUI)
			
			If Not @error Then
				Local $aFiles[2] = [1, $sFolder]
				_BlockFileList_AddFiles($aFiles)
			EndIf
			
			AdlibRegister("_Check_BlockMsg_Proc", $iCheckBlockMsg_Intrvl)
		Case $iBlockSelFiles_Bttn
			_BlockSelFiles_Proc()
		Case $iRemoveSelFiles_Bttn
			Local $iAsk
			Local $aTmp, $aSelItems, $iItem_Count, $sItem_Text, $iFind
			
			$aSelItems = _GUICtrlListView_GetSelectedIndices($iBlockFiles_LV, True)
			$iItem_Count = _GUICtrlListView_GetItemCount($iBlockFiles_LV)
			
			If $aSelItems[0] = 0 Then
				MsgBox(48, $aTXT[$iMSG_Attention], $aTXT[$iMSG_NoSelectedItems], 0, $hMain_GUI)
				ContinueLoop
			EndIf
			
			$iAsk = MsgBox(36, $aTXT[$iMSG_Attention_1], $aTXT[$iMSG_AreYouSureRemoveSelectedItems], 0, $hMain_GUI)
			
			If $iAsk = 6 Then
				Dim $aTmp[$iItem_Count + 1][$iBF_TotalItems]
				
				For $i = 1 To UBound($aSelItems)-1
					_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $aSelItems[$i], False)
				Next
				
				_BlockSelFiles_Proc()
				
				For $i = 1 To UBound($aSelItems)-1
					$sItem_Text = _GUICtrlListView_GetItemText($iBlockFiles_LV, $i)
					$iFind = _ArraySearch($aBF_List, $sItem_Text, 1, 0, 0, 2, 1, $iBF_FileName)
					
					If $iFind > 0 Then
						IniDelete($sConfig_File, 'List', $sItem_Text)
						_ArrayDelete($aBF_List, $iFind)
						$aBF_List[0][0] -= 1
					EndIf
				Next
				
				_GUICtrlListView_DeleteItemsSelected($iBlockFiles_LV)
			EndIf
		Case $iSpaceCtrl_Dummy
			If GUICtrlGetHandle($iBlockFiles_LV) <> ControlGetHandle($hMain_GUI, '', ControlGetFocus($hMain_GUI)) Then ContinueLoop
			
			Local $aSelItems = _GUICtrlListView_GetSelectedIndices($iBlockFiles_LV, True)
			Local $iItem_State
			
			For $i = 1 To UBound($aSelItems)-1
				$iItem_State = _GUICtrlListView_GetItemChecked($iBlockFiles_LV, $aSelItems[$i])
				_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $aSelItems[$i], Not $iItem_State)
			Next
			
			_BlockSelFiles_Proc()
	EndSwitch
	
	If $vItem_Checked > 0 Then
		_GUICtrlListView_SetItemSelected($iBlockFiles_LV, -1, False)
		_GUICtrlListView_SetItemSelected($iBlockFiles_LV, $vItem_Checked - 1, True, True)
		
		$vItem_Checked = 0
		
		_BlockSelFiles_Proc()
	EndIf
WEnd

#EndRegion

#Region Functions

Func _Settings_GUI()
	If IsHWnd($hSettings_GUI) Then Return
	
	GUISetState(@SW_DISABLE, $hMain_GUI)
	$hSettings_GUI = GUICreate($aTXT[$iMSG_Settings], 400, 300, -1, -1, -1, $WS_EX_TOOLWINDOW, $hMain_GUI)
	
	GUICtrlCreateGroup($aTXT[$iMSG_General], 20, 10, 360, 140)
	
	GUICtrlCreateLabel($aTXT[$iMSG_Language], 40, 27)
	$iLanguage_Combo = GUICtrlCreateCombo("", 100, 25, 260, 50, BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSetData($iLanguage_Combo, _AppTranslation_GetLanguages($LANGS_DIR), $sApp_Language)
	
	$iStartWithWindows_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_Start] & $sApp_Name & $aTXT[$iMSG_WithWindows], 40, 50)
	If $iStart_With_Windows = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$iStartHidden_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_StartHidden], 60, 70)
	If $iStart_Hidden = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$iHideOnClose_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_Hide] & $sApp_Name & $aTXT[$iMSG_WhenClosing], 40, 90)
	If $iHide_On_Close = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	GUICtrlCreateLabel($aTXT[$iMSG_Show] & $sApp_Name & $aTXT[$iMSG_HotKey], 40, 123)
	$hShowApp_Hotkey = _GUICtrlHotkey_Create($hSettings_GUI, 200, 120, 160, 22)
	_GUICtrlHotkey_SetHotkey($hShowApp_Hotkey, $sShowApp_HotKey)
	_GUICtrlHotkey_SetRules($hShowApp_Hotkey, $HKCOMB_NONE, BitOR($HOTKEYF_CONTROL, $HOTKEYF_SHIFT))
	
	GUICtrlCreateGroup($aTXT[$iMSG_Other], 20, 160, 360, 100)
	
	$iSetMasterPassword_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_SetMasterPasswordFor] & $sApp_Name & $aTXT[$iMSG_Usage], 40, 180)
	$iSetMasterPassword_Input = GUICtrlCreateInput($sMaster_Password, 40, 210, 200, 20, BitOR($GUI_SS_DEFAULT_INPUT, $ES_PASSWORD))
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	If $iSet_Master_Password = 1 Then
		GUICtrlSetState($iSetMasterPassword_CB, $GUI_CHECKED)
		GUICtrlSetState($iSetMasterPassword_Input, $GUI_ENABLE)
	EndIf
	
	$iOK_Bttn = GUICtrlCreateButton($aTXT[$iMSG_OK], 20, 270, 70, 20)
	$iCancel_Bttn = GUICtrlCreateButton($aTXT[$iMSG_Cancel], 100, 270, 70, 20)
	
	GUISetState(@SW_SHOW, $hSettings_GUI)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $GUI_EVENT_CLOSE, $iCancel_Bttn
				ExitLoop
			Case $iOK_Bttn
				HotKeySet($sShowApp_HotKey)
				
				Local $sSel_Language = GUICtrlRead($iLanguage_Combo)
				
				$iStart_With_Windows = Number(GUICtrlRead($iStartWithWindows_CB) = $GUI_CHECKED)
				$iStart_Hidden = Number(GUICtrlRead($iStartHidden_CB) = $GUI_CHECKED)
				$iHide_On_Close = Number(GUICtrlRead($iHideOnClose_CB) = $GUI_CHECKED)
				$sShowApp_HotKey = StringLower(_GUICtrlHotkey_GetHotkey($hShowApp_Hotkey))
				$iSet_Master_Password = Number(GUICtrlRead($iSetMasterPassword_CB) = $GUI_CHECKED)
				$sMaster_Password = GUICtrlRead($iSetMasterPassword_Input)
				
				_IniWriteEx($sConfig_File, "Main", "Start With Windows", $iStart_With_Windows)
				_IniWriteEx($sConfig_File, "Main", "Start Hidden", $iStart_Hidden)
				_IniWriteEx($sConfig_File, "Main", "Hide On Close", $iHide_On_Close)
				_IniWriteEx($sConfig_File, "Main", "Show HotKey", $sShowApp_HotKey)
				_IniWriteEx($sConfig_File, "Main", "Set Master Password", $iSet_Master_Password)
				_IniWriteEx($sConfig_File, "Main", "Master Password", _Iif($sMaster_Password <> "", _StringEncrypt(1, $sMaster_Password, $sApp_Name), ""))
				
				If $iStart_With_Windows = 1 Then
					RegWrite("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run", $sApp_Name, "REG_SZ", _Iif(@Compiled, @AutoItExe, @AutoItExe & ' "' & @ScriptFullPath & '"'))
				Else
					RegDelete("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run", $sApp_Name)
				EndIf
				
				HotKeySet($sShowApp_HotKey, "_Show_App_Window_Proc")
				
				If $sSel_Language <> $sApp_Language Then
					$sApp_Language = $sSel_Language
					_IniWriteEx($sConfig_File, "Main", "Language", $sApp_Language)
					
					$aTXT = _AppTranslation_Register($LANGS_DIR & "\" & $sApp_Language & ".lng")
					
					Local $iAsk = MsgBox(36, $aTXT[$iMSG_Attention], $aTXT[$iMSG_RestartTheProgram], 0, $hSettings_GUI)
					
					If $iAsk = 6 Then
						_ReleaseResources_Proc()
						Run(_Iif(@Compiled, @AutoItExe, @AutoItExe & ' "' & @ScriptFullPath & '"'), @ScriptDir)
						Exit
					EndIf
				EndIf
				
				ExitLoop
			Case $iSetMasterPassword_CB
				If GUICtrlRead($iSetMasterPassword_CB) = $GUI_CHECKED Then
					GUICtrlSetState($iSetMasterPassword_Input, $GUI_ENABLE)
				Else
					GUICtrlSetState($iSetMasterPassword_Input, $GUI_DISABLE)
				EndIf
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $hMain_GUI)
	GUIDelete($hSettings_GUI)
EndFunc

Func _BlockFileList_Load()
	Local $aSect = _IniReadSectionEx($sConfig_File, 'List')
	If @error Then Return SetError(1)
	
	Local $aFiles[$aSect[0][0] + 1]
	Dim $aBF_List[$aSect[0][0] + 1][$iBF_TotalItems] = [[0]]
	
	For $i = 1 To $aSect[0][0]
		If FileExists($aSect[$i][0]) Then
			$aFiles[0] += 1
			$aBF_List[0][0] += 1
			
			$aFiles[$aFiles[0]] = $aSect[$i][0]
			
			$aBF_List[$aBF_List[0][0]][$iBF_FileName] = $aSect[$i][0]
			$aBF_List[$aBF_List[0][0]][$iBF_FileHandle] = 0
			$aBF_List[$aBF_List[0][0]][$iBF_BlockState] = $aSect[$i][1]
		Else
			IniDelete($sConfig_File, 'List', $aSect[$i][0])
		EndIf
	Next
	
	ReDim $aFiles[$aFiles[0] + 1]
	ReDim $aBF_List[$aBF_List[0][0] + 1][$iBF_TotalItems]
	
	_BlockFileList_AddFiles($aFiles, 1)
EndFunc

Func _BlockFileList_AddFiles($aFiles, $iOnLoad = 0)
	Local $iLV_Item, $iFind, $iItem_Count, $aLnkPath
	
	$iItem_Count = _GUICtrlListView_GetItemCount($iBlockFiles_LV)
	_GUICtrlListView_SetItemSelected($iBlockFiles_LV, -1, False)
	
	For $i = 1 To $aFiles[0]
		If StringRight($aFiles[$i], 4) = '.lnk' Then
			$aLnkPath = FileGetShortcut($aFiles[$i])
			
			If Not @error And FileExists($aLnkPath[0]) Then
				$aFiles[$i] = $aLnkPath[0]
			EndIf
		EndIf
		
		$iFind = -1
		
		If Not $iOnLoad Then
			$iFind = _GUICtrlListView_FindText($iBlockFiles_LV, $aFiles[$i], -1, False)
		EndIf
		
		If $iFind <> -1 Then
			_GUICtrlListView_SetItemSelected($iBlockFiles_LV, $iFind, True, True)
		Else
			$iLV_Item = GUICtrlCreateListViewItem($aFiles[$i], $iBlockFiles_LV)
			_GUICtrlSetImageEx($iLV_Item, $aFiles[$i])
			_GUICtrlListView_EnsureVisible($iBlockFiles_LV, $iItem_Count - 1 + $i)
		EndIf
	Next
	
	GUICtrlSendMsg($iBlockFiles_LV, $LVM_SETCOLUMNWIDTH, 0, -1)
	
	If Not $iOnLoad Then
		IniDelete($sConfig_File, 'List')
	EndIf
	
	Local $sItem_Pass = ""
	Local $iItem_Count = _GUICtrlListView_GetItemCount($iBlockFiles_LV)
	
	If Not $iOnLoad Then
		Dim $aBF_List[$iItem_Count + 1][$iBF_TotalItems] = [[$iItem_Count]]
	EndIf
	
	For $i = 0 To $iItem_Count - 1
		$sItem_Pass = ""
		
		$sItem_Text = _GUICtrlListView_GetItemText($iBlockFiles_LV, $i)
		$iItem_State = _GUICtrlListView_GetItemChecked($iBlockFiles_LV, $i)
		
		$iFind = _ArraySearch($aBF_List, $sItem_Text, 1, 0, 0, 2, 1, $iBF_FileName)
		
		If $iFind > 0 Then
			$iItem_State = $aBF_List[$iFind][$iBF_BlockState]
		Else
			$aBF_List[$i + 1][$iBF_FileName] = $sItem_Text
			$aBF_List[$i + 1][$iBF_FileHandle] = 0
			$aBF_List[$i + 1][$iBF_BlockState] = $iItem_State
		EndIf
		
		If $iOnLoad Then
			_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $i, Number($iItem_State))
			
			If $iItem_State = 1 Then
				_BlockFile_Proc($sItem_Text, 0)
				
				If @error Then
					_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $i, False)
					$aBF_List[$iFind][$iBF_BlockState] = 0
				EndIf
			EndIf
		Else
			IniWrite($sConfig_File, 'List', _Encoding_ANSIToUTF8($sItem_Text), Number($iItem_State))
		EndIf
	Next
EndFunc

Func _BlockSelFiles_Proc()
	Local $aSelItems = _GUICtrlListView_GetSelectedIndices($iBlockFiles_LV, True)
	Local $iIndex, $sItem_Text, $iFind
	
	For $i = 1 To UBound($aSelItems)-1
		$iIndex = $aSelItems[$i]
		
		$sItem_Text = _GUICtrlListView_GetItemText($iBlockFiles_LV, $iIndex)
		$iFind = _ArraySearch($aBF_List, $sItem_Text, 1, 0, 0, 2, 1, $iBF_FileName)
		
		If $iFind > 0 Then
			If $aBF_List[$iFind][$iBF_BlockState] = 0 Then
				$aBF_List[$iFind][$iBF_BlockState] = 1
				_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $iIndex, True)
				
				_BlockFile_Proc($sItem_Text, 0)
				Local $iFileInUse = @extended
				
				If @error Then
					_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $iIndex, False)
					$aBF_List[$iFind][$iBF_BlockState] = 0
					
					$sErrorMsg = $aTXT[$iMSG_ErrorUnableToBlockTheFile]
					If _WinAPI_PathIsDirectory($sItem_Text) Then $sErrorMsg = $aTXT[$iMSG_ErrorUnableToBlockTheFolder]
					
					If $iFileInUse Then
						$sErrorMsg &= @CRLF & $aTXT[$iMSG_BlockFailedFileInUse]
					Else
						$sErrorMsg &= @CRLF & $aTXT[$iMSG_BlockFailed]
					EndIf
					
					AdlibUnRegister("_Check_BlockMsg_Proc")
					_CustomBox($sErrorMsg, $sItem_Text, 0, 0, $hMain_GUI, 0x00000014)
					AdlibRegister("_Check_BlockMsg_Proc", $iCheckBlockMsg_Intrvl)
				EndIf
			Else
				$aBF_List[$iFind][$iBF_BlockState] = 0
				_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $iIndex, False)
				
				_UnBlockFile_Proc($sItem_Text, 0)
				
				If @error Then
					_GUICtrlListView_SetItemChecked($iBlockFiles_LV, $iIndex, True)
					$aBF_List[$iFind][$iBF_BlockState] = 1
				EndIf
			EndIf
			
			IniWrite($sConfig_File, 'List', _Encoding_ANSIToUTF8($sItem_Text), Number($aBF_List[$iFind][$iBF_BlockState]))
		EndIf
	Next
EndFunc

Func _BlockFile_Proc($sFile, $iShowErrMsg = 1)
	If Not FileExists($sFile) Then Return SetError(1, 0, -1)
	
	Local $hFile = _WinAPI_CreateFileEx($sFile, $OPEN_EXISTING, BitOR($GENERIC_READ, $GENERIC_WRITE), 0, _Iif(_WinAPI_PathIsDirectory($sFile), $FILE_FLAG_BACKUP_SEMANTICS, 0))
	
	If @error Or $hFile = -1 Then
		If $iShowErrMsg Then
			Local $sErrorMsg = $aTXT[$iMSG_ErrorUnableToBlockTheFile_1]
			If _WinAPI_PathIsDirectory($sFile) Then $sErrorMsg = $aTXT[$iMSG_ErrorUnableToBlockTheFolder_1]
			
			AdlibUnRegister("_Check_BlockMsg_Proc")
			_CustomBox($sErrorMsg, $sFile, 0, 0, $hMain_GUI, 0x00000014)
			AdlibRegister("_Check_BlockMsg_Proc", $iCheckBlockMsg_Intrvl)
		EndIf
		
		Local $iFileInUse = 0
		
		If _WinAPI_GetLastError() = 32 Then ; ERROR_SHARING_VIOLATION
			$iFileInUse = 1
		EndIf
		
		Return SetError(1, $iFileInUse, 0)
	EndIf
	
	$iFind = _ArraySearch($aBF_List, $sFile, 1, 0, 0, 2, 1, $iBF_FileName)
	
	If $iFind > 0 Then
		$aBF_List[$iFind][$iBF_FileHandle] = $hFile
		$aBF_List[$iFind][$iBF_BlockState] = 1
		
		IniWrite($sConfig_File, 'List', _Encoding_ANSIToUTF8($sFile), '1')
	EndIf
EndFunc

Func _UnBlockFile_Proc($sFile, $iShowErrMsg = 1)
	Local $sFile_ErrMsg = "", $iRet, $sPass, $iFind
	
	$iFind = _ArraySearch($aBF_List, $sFile, 1, 0, 0, 2, 1, $iBF_FileName)
	
	If $iFind > 0 Then
		$iRet = _WinAPI_CloseHandle($aBF_List[$iFind][$iBF_FileHandle])
		
		If @error Or Not $iRet Then
			$sFile_ErrMsg = $aTXT[$iMSG_CloseHandleFail]
		Else
			$aBF_List[$iFind][$iBF_BlockState] = 0
			Return
		EndIf
	EndIf
	
	If $iShowErrMsg And $sFile_ErrMsg <> "" Then
		Local $sErrorMsg = $aTXT[$iMSG_ErrorUnableToUnBlockTheFile]
		If _WinAPI_PathIsDirectory($sFile) Then $sErrorMsg = $aTXT[$iMSG_ErrorUnableToUnBlockTheFolder]
		
		AdlibUnRegister("_Check_BlockMsg_Proc")
		_CustomBox($sErrorMsg & $sFile_ErrMsg, $sFile, 0, 0, $hMain_GUI, 0x00000014)
		AdlibRegister("_Check_BlockMsg_Proc", $iCheckBlockMsg_Intrvl)
		
		Return SetError(1, 0, $sFile_ErrMsg)
	Else
		;MsgBox(64, $aTXT[$iMSG_Success], $aTXT[$iMSG_FileUnBlocked], 0, $hMain_GUI)
	EndIf
EndFunc

Func _Check_BlockMsg_Proc()
	AdlibUnRegister("_Check_BlockMsg_Proc")
	
	Local $sFile, $sName, $sErrorMsg, $sErrorMsg_Body
	
	If WinExists('[CLASS:#32770;REGEXPTITLE:.+]') Then
		For $i = 1 To $aBF_List[0][0]
			$sFile = $aBF_List[$i][$iBF_FileName]
			$sName = StringRegExpReplace($sFile, "^.*\\", "")
			
			If $sFile = '' Then
				ContinueLoop
			EndIf
			
			$iWinExists_Txt = WinActive('[CLASS:#32770]', $sFile & '"') Or WinActive('[CLASS:#32770]', $sFile & '.') Or _
				WinActive('[CLASS:#32770;TITLE:' & $sFile & ']') Or WinActive('[CLASS:#32770]', $sName & '"') Or WinActive('[CLASS:#32770]', $sName & '.')
			
			$iWinExists_NoTxt = WinActive('[CLASS:#32770]', '') And Not $iWinExists_Txt
			
			If $iWinExists_Txt Or $iWinExists_NoTxt Then
				If $iWinExists_NoTxt Then
					$iPID = WinGetProcess('[CLASS:#32770]')
					
					If Not StringRegExp(_WinAPI_GetProcessCommandLine($iPID), '.*"?\Q' & $sFile & '\E"?.*') Then
						ContinueLoop
					EndIf
				EndIf
				
				WinClose('[ACTIVE]')
				
				$sErrorMsg = $aTXT[$iMSG_ErrorUnableToOpenTheFile]
				$sErrorMsg_Body = $aTXT[$iMSG_ThisFileIsBlockedBy] & $sApp_Name
				
				If _WinAPI_PathIsDirectory($sFile) Then
					$sErrorMsg = $aTXT[$iMSG_ErrorUnableToOpenTheFolder]
					$sErrorMsg_Body = $aTXT[$iMSG_ThisFolderIsBlockedBy] & $sApp_Name
				EndIf
				
				_CustomBox($sErrorMsg, StringFormat($sErrorMsg_Body, $sName), 0, 1, $hMain_GUI)
				
				ExitLoop
			EndIf
		Next
	EndIf
	
	AdlibRegister("_Check_BlockMsg_Proc", $iCheckBlockMsg_Intrvl)
EndFunc

Func _Show_App_Window_Proc()
	If Not BitAND(WinGetState($hMain_GUI), 2) Then
		GUISetState(@SW_SHOW, $hMain_GUI)
		GUISetState(@SW_RESTORE, $hMain_GUI)
	EndIf
	
	If $iSet_Master_Password = 1 Then
		Local $sPass
		
		While 1
			$sPass = InputBox($aTXT[$iMSG_MasterPassword], $aTXT[$iMSG_PleaseEnterPasswordToUnlock] & $sApp_Name & ":", "", "*", 300, 150, Default, Default, 0, $hMain_GUI)
			
			If @error Then
				GUISetState(@SW_HIDE, $hMain_GUI)
				ExitLoop
			EndIf
			
			If $sPass == $sMaster_Password Then
				ExitLoop
			Else
				MsgBox(48, $aTXT[$iMSG_Error], $aTXT[$iMSG_WrongPasswordPleaseEnterEgain], 5, $hMain_GUI)
			EndIf
		WEnd
	EndIf
EndFunc

Func _GUICtrlSetImageEx($iLV_Item, $sFile)
	$sIcon = _WinAPI_AssocQueryString($sFile, $ASSOCSTR_DEFAULTICON)
	$aIcon = _WinAPI_PathParseIconLocation($sIcon)
	$sIconPath = _WinAPI_PathUnquoteSpaces($aIcon[0])
	$iIconIndex = $aIcon[1]
	
	If Not FileExists($sIconPath) Then
		$aIcon = _FileGetIcon($sFile)
		
		$sIconPath = $aIcon[1]
		$iIconIndex = $aIcon[2]
		
		If Not FileExists($sIconPath) Then
			$sIconPath = "Shell32.dll"
			$iIconIndex = 0
		EndIf
	EndIf
	
	GUICtrlSetImage($iLV_Item, $sIconPath, _GetIconProperIndx($iIconIndex))
EndFunc

Func _GetIconProperIndx($iIndex)
	Select 
		Case $iIndex > 0
			Return -$iIndex - 1
		Case $iIndex < 0
			Return -$iIndex
		Case Else
			Return 0
	EndSelect
EndFunc

Func _FileGetIcon($sFile)
	Local $iOld_Opt_EES = Opt("ExpandEnvStrings", 1)
	Local $sRegDefault = "", $sDefIcon = "", $sExt, $hSearch, $sIconFile, $nIcon=0
	Local $aRet[3], $iError = 0
	
	If _WinAPI_PathIsDirectory($sFile) Then
		$sRegDefault = RegRead("HKCR\Folder", "")
		If $sRegDefault <> "" Then $sDefIcon = RegRead("HKCR\Folder\DefaultIcon", "")
	Else
		$sExt = StringRegExpReplace($sFile, '^.*\.', '.')
		
		If $sExt = ".lnk" Then
			Local $aLinkInfo = FileGetShortcut($sFile)
			
			If Not @error Then
				Opt("ExpandEnvStrings", $iOld_Opt_EES)
				
				If Not FileExists($aLinkInfo[4]) Then
					Local $a_LinkInfo = _FileGetIcon($aLinkInfo[0])
					
					If Not @error Then
						$aLinkInfo[4] = $a_LinkInfo[1]
						$aLinkInfo[5] = $a_LinkInfo[2]
					EndIf
				EndIf
				
				Dim $aRet[3] = [2, $aLinkInfo[4], $aLinkInfo[5]]
				Return $aRet
			EndIf
		EndIf
		
		If $sExt = $sFile Then
			$hSearch = FileFindFirstFile($sFile & ".*")
			$sExt = StringRegExpReplace(FileFindNextFile($hSearch), '^.*\.', '.')
			$sFile &= $sExt
			FileClose($hSearch)
		EndIf
		
		$sRegDefault = RegRead("HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" & $sExt, "ProgID")
		
		If $sRegDefault = "" Then $sRegDefault = RegRead("HKCR\" & $sExt, "")
		If $sRegDefault <> "" Then $sDefIcon = RegRead("HKCR\" & $sRegDefault & "\DefaultIcon", "")
	EndIf
	
	If $sDefIcon = "" Then
		$sIconFile = "shell32.dll"
	ElseIf $sDefIcon <> "%1" Then
		If StringRegExpReplace($sFile, "^.*\\", "") = "shell32.dll" Then
			$sIconFile = $sFile
			$nIcon = 0
		Else
			Local $aDefIconSplit = StringSplit($sDefIcon, ",")
			
			If IsArray($aDefIconSplit) Then
				$sIconFile = $aDefIconSplit[1]
				If $aDefIconSplit[0] > 1 Then $nIcon = $aDefIconSplit[2]
			Else
				$iError = 1
			EndIf
		EndIf
	ElseIf $sDefIcon = "%1" Then
		$sIconFile = $sFile
		$nIcon = 0
	EndIf
	
	Opt("ExpandEnvStrings", $iOld_Opt_EES)
	
	Dim $aRet[3] = [2, $sIconFile, $nIcon]
	Return SetError($iError, 0, $aRet)
EndFunc

Func _FixAccelHotKeyLayout()
	Local Const $WM_INPUTLANGCHANGEREQUEST = 0x50
	Local $aRet = DllCall("user32.dll", "long", "LoadKeyboardLayoutW", "wstr", 0x04090000, "int", 0)
	
	If Not @error And $aRet[0] Then
		DllCall("user32.dll", "ptr", "SendMessage", "hwnd", WinGetHandle(AutoItWinGetTitle()), "int", $WM_INPUTLANGCHANGEREQUEST, "int", 1, "int", $aRet[0])
		Return 1
	EndIf
	
	Return SetError(1, 0, 0)
EndFunc

Func _IniWriteEx($sIniFile, $sSection, $sKey, $sValue, $iUTFMode = 128)
	If BitOR($iUTFMode, 16, 32, 64, 128) <> Number(16+32+64+128) Then
		$iUTFMode = 128
	EndIf
	
	Local $sData = ""
	Local $sCRLF = @CRLF
	Local $aSplitKeyValue
	Local $iValueWasWritten = False
	Local $sReadFile = FileRead($sIniFile)
	Local $aFileArr = StringSplit(StringStripCR($sReadFile), @LF)
	Local $hFile = FileOpen($sIniFile, 10 + $iUTFMode)
	
	If $hFile = -1 Then
		Return IniWrite($sIniFile, $sSection, $sKey, $sValue)
	EndIf
	
	If @error Then
		If $sReadFile <> "" Then $sReadFile &= @CRLF
		$sData &= $sReadFile & "[" & $sSection & "]" & @CRLF
		$sData &= $sKey & "=" & $sValue
		
		FileWrite($hFile, $sData)
		FileClose($hFile)
		
		Return SetError(0, 0, 1)
	EndIf
	
	For $i = 1 To $aFileArr[0]
		If $i = $aFileArr[0] Then
			$sCRLF = ""
		EndIf
		
		$sData &= $aFileArr[$i] & $sCRLF
		
		If $aFileArr[$i] = "[" & $sSection & "]" Then
			For $j = $i+1 To $aFileArr[0]
				If $j = $aFileArr[0] Then
					$sCRLF = ""
				EndIf
				
				If Not $iValueWasWritten Then
					If StringRegExp(StringRegExpReplace($aFileArr[$j], '\s+=', '='), '(^|\r?\n)' & $sKey & '=') Then
						$aSplitKeyValue = StringSplit($aFileArr[$j], "=")
						$sData &= $aSplitKeyValue[1] & "=" & $sValue & $sCRLF
						$iValueWasWritten = True
					ElseIf $aFileArr[$j] = "" Then
						$sData &= $sKey & "=" & $sValue & $sCRLF
					ElseIf StringLeft($aFileArr[$j], 1) = "[" Or $j = $aFileArr[0] Then
						$sData &= $aFileArr[$j] & @CRLF & $sKey & "=" & $sValue & $sCRLF
					Else
						$sData &= $aFileArr[$j] & $sCRLF
					EndIf
				Else
					$sData &= $aFileArr[$j] & $sCRLF
				EndIf
			Next
			
			ExitLoop
		ElseIf $i = $aFileArr[0] Then
			$sData &= @CRLF & "[" & $sSection & "]" & @CRLF
			$sData &= $sKey & "=" & $sValue
		EndIf
	Next
	
	FileWrite($hFile, $sData)
	FileClose($hFile)
	
	Return SetError(0, 0, 1)
EndFunc

Func _IniReadEx($sIniFile, $sSection, $sKey, $sValue = '')
	Local $aFileArr = StringSplit(StringStripCR(FileRead($sIniFile)), @LF)
	
	If @error Then
		Return SetError(1, 0, "")
	EndIf
	
	Local $aSplitKeyValue
	
	For $i = 1 To $aFileArr[0]
		If $aFileArr[$i] = '[' & $sSection & ']' Then
			For $j = $i+1 To $aFileArr[0]
				If StringLeft($aFileArr[$j], 1) = '[' Then
					ExitLoop 2
				EndIf
				
				$aFileArr[$j] = StringRegExpReplace(StringStripWS($aFileArr[$j], 3), '\s+=', '=')
				
				If StringLeft($aFileArr[$j], StringLen($sKey)+1) = $sKey & '=' Then
					$aSplitKeyValue = StringSplit($aFileArr[$j], '=')
					
					If UBound($aSplitKeyValue)-1 >= 2 Then
						$sValue = StringStripWS($aSplitKeyValue[2], 3)
					EndIf
					
					Return $sValue
				EndIf
			Next
			
			ExitLoop
		EndIf
	Next
	
	Return $sValue
EndFunc

Func _IniReadSectionEx($sIniFile, $sSection)
	Local $aFileReadArr = StringSplit(StringStripCR(FileRead($sIniFile)), @LF)
	
	If @error Then
		Return SetError(1, 0, "")
	EndIf
	
	Local $aRetArr[1][1], $iUbound, $aSplitKeyValue, $sKey, $sValue
	
	For $i = 1 To $aFileReadArr[0]
		If $aFileReadArr[$i] = "[" & $sSection & "]" Then
			For $j = $i+1 To $aFileReadArr[0]
				If StringLeft($aFileReadArr[$j], 1) = "[" Then
					ExitLoop 2
				EndIf
				
				$aSplitKeyValue = StringSplit($aFileReadArr[$j], "=")
				
				If Not @error Then
					$sKey = $aSplitKeyValue[1]
					$sValue = ""
					
					If UBound($aSplitKeyValue)-1 >= 2 Then
						$sValue = $aSplitKeyValue[2]
					EndIf
					
					$aRetArr[0][0] += 1
					ReDim $aRetArr[$aRetArr[0][0]+1][2]
					$aRetArr[$aRetArr[0][0]][0] = $sKey
					$aRetArr[$aRetArr[0][0]][1] = $sValue
				EndIf
			Next
			
			ExitLoop
		EndIf
	Next
	
	Return $aRetArr
EndFunc

Func WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)
	Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $hWndListView
	$hWndListView = $iBlockFiles_LV
	If Not IsHWnd($iBlockFiles_LV) Then $hWndListView = GUICtrlGetHandle($iBlockFiles_LV)

	$tNMHDR = DllStructCreate($tagNMHDR, $lParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")
	
	Switch $hWndFrom
		Case $hWndListView
			Switch $iCode
				Case $NM_CLICK, $NM_DBLCLK, $NM_RCLICK, $LVN_ITEMCHANGED
					Local $tInfo = DllStructCreate($tagNMITEMACTIVATE, $lParam)
					Local $iIndex = DllStructGetData($tInfo, "Index")
					
					If $iIndex <> -1 Then
						Local $iX = DllStructGetData($tInfo, "X")
						Local $iPart = 1
						If _GUICtrlListView_GetView($iBlockFiles_LV) = 1 Then $iPart = 2 ;for large icons view
						
						Local $aIconRect = _GUICtrlListView_GetItemRect($iBlockFiles_LV, $iIndex, $iPart)
						
						If $iX < $aIconRect[0] And $iX >= 5 Then
							$vItem_Checked = $iIndex + 1
							Return 0
						EndIf
					EndIf
			EndSwitch
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_DROPFILES($hWnd, $msgID, $wParam, $lParam)
	$aDropped_Files = _WinAPI_DragQueryFileEx($wParam)
EndFunc

Func _ReleaseResources_Proc()
	For $i = 1 To $aBF_List[0][0]
		_WinAPI_CloseHandle($aBF_List[$i][$iBF_FileHandle])
	Next
	
	AdlibUnRegister("_Check_BlockMsg_Proc")
EndFunc

Func _Quit_Proc()
	_ReleaseResources_Proc()
	
	Exit
EndFunc

#EndRegion
