;Program by G.Sandler (a.k.a CreatoR), Constants Files by GaryFrost.

FileChangeDir(@ScriptDir)

#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#Include <GUIListView.au3>
#include <File.au3>
;

Opt("GuiOnEventMode", 1)
;~ Opt("RunErrorsFatal", 0)

;~ Global Const $WM_COMMAND 	= 0x0111
;~ Global Const $WM_NOTIFY 	= 0x004E

Global $AppVer				= "1.1"
Global $AppName				= "Constants Viewer v" & $AppVer & " by G.Sandler"

Global $Constants_Path 		= @ScriptDir & "\Constants"
Global $Const_Array[1]

Global $Begin_Drag 			= False
Global $Input_Changed		= False
Global $Const_Changed		= False
Global $Last_Topic 			= ""
Global $OldText 			= ""
Global $Old_Radio 			= ""

$Main_GUI = GUICreate($AppName, 600, 500, -1, -1, BitOR($WS_OVERLAPPEDWINDOW, $WS_CLIPSIBLINGS))
GUISetOnEvent($GUI_EVENT_CLOSE, "MainEvents")
GUIRegisterMsg($WM_COMMAND, "MY_WM_COMMAND")
GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY_EVENTS")

$ListView = GUICtrlCreateListView("Count|Const Name|Const Value", 5, 5, 390, 360, _
	$LVS_SHOWSELALWAYS+$LVS_NOSORTHEADER, $LVS_EX_GRIDLINES+$LVS_EX_FULLROWSELECT)

GUICtrlCreateLabel("Search:", 10, 373)
$Search_Input = GUICtrlCreateInput("", 70, 370, 325, 20)

$RegExpSearch_CB = GUICtrlCreateCheckbox("RegExp Search", 70, 395)
GUICtrlSetOnEvent(-1, "MainEvents")

$CaseSenseSearch_CB = GUICtrlCreateCheckbox("Case Sensitive", 180, 395)
GUICtrlSetOnEvent(-1, "MainEvents")

$WholeWordSearch_CB = GUICtrlCreateCheckbox("Whole Word Only", 290, 395)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateGroup("Filter by...", 5, 420, 390, 60)

$Const_Count_Radio = GUICtrlCreateRadio("Count", 20, 445)
GUICtrlSetOnEvent(-1, "MainEvents")

$Const_Name_Radio = GUICtrlCreateRadio("Const Name", 140, 445)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetState(-1, 1)
$Old_Radio = $Const_Name_Radio

$Const_Value_Radio = GUICtrlCreateRadio("Const Value", 260, 445)
GUICtrlSetOnEvent(-1, "MainEvents")

$Const_Files_List = GUICtrlCreateListView("Topic", 400, 5, 195, 385, $LVS_SINGLESEL+$LVS_SHOWSELALWAYS+$LVS_NOSORTHEADER)

_Set_Const_List($Constants_Path, $Const_Files_List)
_LV_Set_Equel_Width($Main_GUI, $ListView)

$Open_ConstFile_Button = GUICtrlCreateButton("Open Constant File", 485, 400, 110)
GUICtrlSetOnEvent(-1, "MainEvents")

GUISetState()

While 1
	Sleep(10)
	
	If $Input_Changed Then
		$Input_Changed = False
		SortByFilterProc($ListView)
	EndIf
	
	If $Const_Changed Then
		$Const_Changed = False
		
		$iIndex = _GUICtrlListView_GetSelectedIndices($Const_Files_List)
		$Current_Topic = _GUICtrlListView_GetItemText($Const_Files_List, Number($iIndex))
		
		If $Current_Topic <> $Last_Topic Then
			$Last_Topic = $Current_Topic
			_GUICtrlListView_DeleteAllItemsEx($ListView)
			$Const_Array = _Set_Const_Proc($Constants_Path & "\" & $Current_Topic & ".dat", $ListView)
		EndIf
	EndIf
	
	If $Begin_Drag Then
		$Begin_Drag = False
		DropItemHandler($Main_GUI, $ListView)
	EndIf
WEnd

Func MainEvents()
	Switch @GUI_CtrlId
		Case $GUI_EVENT_CLOSE
			Exit
		Case $Const_Count_Radio, $Const_Name_Radio, $Const_Value_Radio
			If @GUI_CtrlId <> $Old_Radio And GUICtrlRead($Search_Input) <> "" Then SortByFilterProc($ListView)
			$Old_Radio = @GUI_CtrlId
		Case $RegExpSearch_CB, $CaseSenseSearch_CB, $WholeWordSearch_CB
			If GUICtrlRead($Search_Input) <> "" Then SortByFilterProc($ListView)
		Case $Open_ConstFile_Button
			Local $iIndex = _GUICtrlListView_GetSelectedIndices($Const_Files_List)
			Local $Current_Topic = _GUICtrlListView_GetItemText($Const_Files_List, Number($iIndex))
			Local $Constants_FilePath = @ScriptDir & "\Constants\" & $Current_Topic & ".dat"
			
			If FileExists($Constants_FilePath) Then Run('Notepad.exe "' & $Constants_FilePath & '"')
	EndSwitch
EndFunc

Func TopicItemEvent()
	$Const_Changed = True
EndFunc

Func _LV_Set_Width($hLV, $iColumns="0")
	If StringInStr($iColumns, "|") Then
		Local $iColumnsArr = StringSplit($iColumns, "|")
	Else
		Local $iColumnsArr[2] = [1, $iColumns]
	EndIf
	
	For $i = 1 To $iColumnsArr[0]
		If StringInStr($iColumnsArr[$i], ",") Then
			Local $cSplitArr = StringSplit($iColumnsArr[$i], ",")
		Else
			Local $cSplitArr[3] = [2, $iColumnsArr[$i], -1]
		EndIf
		
		GUICtrlSendMsg($hLV, $LVM_SETCOLUMNWIDTH, Number($cSplitArr[1]), Number($cSplitArr[2]))
	Next
EndFunc

Func _LV_Set_Equel_Width($hWnd, $hLV)
	Local $Columns_Count = _GUICtrlListView_GetColumnCount($hLV)
	Local $LV_Width = ControlGetPos($hWnd, "", $hLV)
	If @error Then Return
	
	Local $iLV_Width = ($LV_Width[2]-20) / $Columns_Count
	
	For $i = 0 To $Columns_Count
		GUICtrlSendMsg($hLV, $LVM_SETCOLUMNWIDTH, $i, $iLV_Width)
	Next
EndFunc

Func _Set_Const_Proc($sPath, $hLV)
	Local $ReadFileArr, $Split_Line, $iIndex
	Local $RetArr[1][1], $iCounter = 1
	
	$ReadFileArr = StringSplit(StringStripCR(FileRead($sPath)), @LF)
	
	For $j = 1 To $ReadFileArr[0]
		$Split_Line = StringSplit($ReadFileArr[$j], "=")
		
		If $Split_Line[0] >= 2 Then
			ReDim $RetArr[$j+1][4]
			
			$RetArr[$j][1] = $iCounter
			$RetArr[$j][2] = StringStripWS($Split_Line[1], 3)
			$RetArr[$j][3] = StringStripWS($Split_Line[2], 3)
			
			$iIndex = _GUICtrlListView_InsertItem($hLV, "", -1)
			_GUICtrlListView_SetItemText($hLV, $iIndex, $RetArr[$j][1] & "|" & $RetArr[$j][2] & "|" & $RetArr[$j][3], -1)
			
			$iCounter += 1
		EndIf
		
		If $Const_Changed Or $Input_Changed Then ExitLoop
	Next
	
	;_LV_Set_Width($hLV, "0,60|1|2")
	_LV_Set_Equel_Width($Main_GUI, $ListView)
	
	Return $RetArr
EndFunc

Func _Set_Const_List($sPath, $hLV)
	Local $FilesArr = _FileListToArray($sPath, "*.dat", 1)
	_ArrayQSort($FilesArr, 1, UBound($FilesArr)-1)
	
	For $i = 1 To UBound($FilesArr)-1
		GUICtrlCreateListViewItem(StringTrimRight($FilesArr[$i], 4), $hLV)
		GUICtrlSetOnEvent(-1, "TopicItemEvent")
	Next
	
	_LV_Set_Width($hLV, "0")
EndFunc

Func SortByFilterProc($hLV)
	$OldText = GUICtrlRead($Search_Input)
	
	$IndexFilter = 1
	If GUICtrlRead($Const_Name_Radio) = 1 Then $IndexFilter = 2
	If GUICtrlRead($Const_Value_Radio) = 1 Then $IndexFilter = 3
	
	If $OldText = "" Then
		_LV_Filter($hLV, $Const_Array, 1, -1)
	Else
		_LV_Filter($hLV, $Const_Array, $IndexFilter, $OldText)
	EndIf
EndFunc

Func _GUICtrlListView_DeleteAllItemsEx($hWnd)
	Local $ctrlID, $index
	If _GUICtrlListView_GetItemCount($hWnd) == 0 Then Return True
	
	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)
	Return _SendMessage($hWnd, $LVM_DELETEALLITEMS) <> 0
EndFunc

Func _LV_Filter($hLV, ByRef $S_LV_Array2D, $LV_Collum_Index, $LV_Search_String)
	Local $vData = "", $iIndex, $nUbound = UBound($S_LV_Array2D)
	_GUICtrlListView_DeleteAllItemsEx($hLV)
	
	Local $iIndex = _GUICtrlListView_GetSelectedIndices($Const_Files_List)
	Local $Current_Topic = _GUICtrlListView_GetItemText($Const_Files_List, Number($iIndex))
	
	If $nUbound <= 1 And $Current_Topic = "" Then Return
	If $Current_Topic = "" Then $Current_Topic = $Last_Topic
	
	If GUICtrlRead($Search_Input) = "" Then
		_Set_Const_Proc($Constants_Path & "\" & $Current_Topic & ".dat", $hLV)
		Return
	EndIf
	
	If $LV_Search_String = -1 Then
		For $x = 1 To $nUbound - 1
			$vData = ""
			
			For $y = 1 To UBound($S_LV_Array2D, 2) - 1
				$vData &= $S_LV_Array2D[$x][$y] & "|"
				If $Const_Changed Or $Input_Changed Then ExitLoop 2
			Next
			
			$iIndex = _GUICtrlListView_InsertItem($hLV, "", -1)
			_GUICtrlListView_SetItemText($hLV, $iIndex, $vData, -1)
		Next
	Else
		Local $IsRegExpSearch = Number((GUICtrlRead($RegExpSearch_CB) - 3) < 0)
		Local $IsCaseSenseSearch = Number((GUICtrlRead($CaseSenseSearch_CB) - 3) < 0)
		Local $IsWholeWordSearch = Number((GUICtrlRead($WholeWordSearch_CB) - 3) < 0)
		
		Local $CurrentItem, $CaseSensVar, $CaseSensStr, $WholeWordStr
		
		For $x = 1 To $nUbound - 1
			If $Const_Changed Or $Input_Changed Then ExitLoop
			
			$CurrentItem = $S_LV_Array2D[$x][$LV_Collum_Index]
			
			If $IsRegExpSearch Then
				$CaseSensStr = "(?i)"
				$WholeWordStr = $LV_Search_String
				If $IsCaseSenseSearch Then $CaseSensStr = ""
				If $IsWholeWordSearch Then $WholeWordStr = "\b" & $WholeWordStr & "\b"
				If Not StringRegExp($CurrentItem, $CaseSensStr & $WholeWordStr) Then ContinueLoop
			Else
				$CaseSensVar = 2
				If $IsCaseSenseSearch Then $CaseSensVar = 1
				
				If $IsWholeWordSearch Then
					$CaseSensStr = "(?i)"
					If $CaseSensVar = 1 Then $CaseSensStr = ""
					If Not StringRegExp($CurrentItem, $CaseSensStr & "\b" & $LV_Search_String & "\b") Then ContinueLoop
				EndIf
				
				If Not StringInStr($CurrentItem, $LV_Search_String, $CaseSensVar) Then ContinueLoop
			EndIf
			
			$vData = ""
			
			For $y = 1 To UBound($S_LV_Array2D, 2) - 1
				$vData &= $S_LV_Array2D[$x][$y] & "|"
				If $Const_Changed Or $Input_Changed Then ExitLoop 2
			Next
			
			$iIndex = _GUICtrlListView_InsertItem($hLV, "", -1)
			_GUICtrlListView_SetItemText($hLV, $iIndex, $vData, -1)
		Next
	EndIf
	
	;If $vData <> "" Then _LV_Set_Width($hLV, "0,60|1|2")
	_LV_Set_Equel_Width($Main_GUI, $ListView)
EndFunc

Func _LV_GetSelectedText($ListView, $SubItem=-1)
	Local $ItemIndexArr = _GUICtrlListView_GetSelectedIndices($ListView, 1)
	If Not IsArray($ItemIndexArr) Then Return SetError(1, 0, -1)
	Local $SelText = "", $Ubound = UBound($ItemIndexArr)-1, $CRLF = @CRLF
	
	For $i = 1 To $Ubound
		If $i = $Ubound Then $CRLF = ""
		
		If StringInStr($SubItem, "|") Then
			$SplitSubItem = StringSplit($SubItem, "|")
			$SelText &= "Const $" & _GUICtrlListView_GetItemText($ListView, $ItemIndexArr[$i], $SplitSubItem[1]) & " = "
			$SelText &= _GUICtrlListView_GetItemText($ListView, $ItemIndexArr[$i], $SplitSubItem[2]) & $CRLF
		Else
			$SelText &= _GUICtrlListView_GetItemText($ListView, $ItemIndexArr[$i], $SubItem) & $CRLF
		EndIf
	Next
	Return $SelText
EndFunc

Func _ArrayQSort(ByRef $avArray, $Left, $Right)
	Local $i, $j, $t
	If $right - $left < 10 Then
		; InsertSort - fastest on small segments (= 25% total speedup)
		For $i = $left + 1 To $right
			$t = $avArray[$i]
			$j = $i
			While $j > $left _
					And ((IsNumber($avArray[$j - 1]) = IsNumber($t) And $avArray[$j - 1] > $t) _
					Or (IsNumber($avArray[$j - 1]) <> IsNumber($t) And String($avArray[$j - 1]) > String($t)))
				$avArray[$j] = $avArray[$j - 1]
				$j = $j - 1
			WEnd
			$avArray[$j] = $t
		Next
		Return
	EndIf

	; QuickSort - fastest on large segments
	Local $pivot = $avArray[Int(($left + $right) / 2) ]
	Local $L = $left
	Local $R = $right
	Do
		While ((IsNumber($avArray[$L]) = IsNumber($pivot) And $avArray[$L] < $pivot) _
				Or (IsNumber($avArray[$L]) <> IsNumber($pivot) And String($avArray[$L]) < String($pivot)))
			;While $avArray[$L] < $pivot
			$L = $L + 1
		WEnd
		While ((IsNumber($avArray[$R]) = IsNumber($pivot) And $avArray[$R] > $pivot) _
				Or (IsNumber($avArray[$R]) <> IsNumber($pivot) And String($avArray[$R]) > String($pivot)))
			;	While $avArray[$R] > $pivot
			$R = $R - 1
		WEnd
		; Swap
		If $L <= $R Then
			$t = $avArray[$L]
			$avArray[$L] = $avArray[$R]
			$avArray[$R] = $t
			$L = $L + 1
			$R = $R - 1
		EndIf
	Until $L > $R

	_ArrayQSort($avArray, $left, $R)
	_ArrayQSort($avArray, $L, $right)
EndFunc

Func DropItemHandler($hWnd, $hLV)
	Local $CurInfo = GUIGetCursorInfo($hWnd)
	If IsArray($CurInfo) And $CurInfo[4] = $hLV Then
		Local $SelText = _LV_GetSelectedText($hLV, "1|2")
		While IsArray($CurInfo) And $CurInfo[2] = 1
			$CurInfo = GUIGetCursorInfo($hWnd)
			Sleep(10)
		WEnd
		
		If $SelText <> "" And IsArray($CurInfo) And $CurInfo[4] <> $hLV Then
			MouseClick("LEFT")
			$OldClip = ClipGet()
			ClipPut($SelText)
			Send("+{Insert}")
			ClipPut($OldClip)
		EndIf
	EndIf
EndFunc

Func WM_NOTIFY_EVENTS($hWndGUI, $MsgID, $wParam, $lParam)
	If Not BitAND(WinGetState($hWndGUI), 2) Then Return $GUI_RUNDEFMSG
	
	Local $TagNMHDR = DllStructCreate("int;int;int;uint;uint;uint;int;int", $lParam)
	If @error Then Return $GUI_RUNDEFMSG
	
	Local Const $LVN_BEGINDRAG = 0xFFFFFF93
	Local $vEvent = DllStructGetData($TagNMHDR, 3)
	If $wParam = $ListView And $vEvent = $LVN_BEGINDRAG Then $Begin_Drag = True
	Return $GUI_RUNDEFMSG
EndFunc

Func MY_WM_COMMAND($hWnd, $iMsg, $wParam, $lParam)
	If $hWnd = 0 Or Not WinExists($hWnd) Then Return $GUI_RUNDEFMSG
	
	Local $nNotifyCode = BitShift($wParam, 16)
	Local $nID = BitAND($wParam, 0xFFFF)
	Local Const $EN_UPDATE = 0x400
	
	If $nID = $Search_Input And $nNotifyCode = $EN_UPDATE And _
		Not Execute(GUICtrlRead($Search_Input) == $OldText) Then $Input_Changed = True
	
	Return $GUI_RUNDEFMSG
EndFunc
