#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Icon.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=Program made by G.Sandler
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2009-2013 G.Sandler (CreatoR), www.autoit-script.ru. All rights reserved.
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <Constants.au3>
#include <Misc.au3>
#include <MouseOnEvent.au3>

Global $sIcons_File = @ScriptDir & '\Icons.icl'

Opt("TrayMenuMode", 1)
TraySetIcon($sIcons_File, -1)
TraySetClick(16)
TraySetState()

$CopyUseSelection_TrayItem = TrayCreateItem("  ")
TrayItemSetState(-1, $TRAY_CHECKED)

$SwitchMonitoring_TrayItem = TrayCreateItem("  ")
TrayItemSetState(-1, $TRAY_CHECKED)

TrayCreateItem("")

$Exit_TrayItem = TrayCreateItem("")

Global $sCopy_HotKey = "^+c"
Global $sToggleScriptPause_HotKey = "^+p"
Global $sExit_HotKey = "^+e"

Global $iMouse_X_Position = MouseGetPos(0)
Global $iSelected = False
Global $iPaused = True

Global $sFile = @ScriptDir & "\SelectedText.txt"

HotKeySet($sExit_HotKey, "_Quit")
HotKeySet($sToggleScriptPause_HotKey, "_SwitchMonitoring_Proc")

_SwitchMonitoring_Proc()

While 1
	Switch TrayGetMsg()
		Case $TRAY_EVENT_PRIMARYUP, $SwitchMonitoring_TrayItem
			_SwitchMonitoring_Proc()
		Case $CopyUseSelection_TrayItem
			If TrayItemGetState($CopyUseSelection_TrayItem) = 65 Then
				_SetMouseEvent_Proc(1)
				HotKeySet($sCopy_HotKey)
			Else
				_SetMouseEvent_Proc(0)
				HotKeySet($sCopy_HotKey, "_CopyUseHotkey_Proc")
			EndIf
		Case $Exit_TrayItem
			_Quit()
	EndSwitch
	
	If $iSelected Then
		$iSelected = False
		$sSelection = _GetSelectedText()
		
		If $sSelection <> "" Then
			$hFile = FileOpen($sFile, 1+128)
			FileWriteLine($hFile, $sSelection & @CRLF & @CRLF)
			FileClose($hFile)
		EndIf
	EndIf
WEnd

Func MousePrimaryDown_Event()
	$iMouse_X_Position = MouseGetPos(0)
EndFunc

Func MousePrimaryUp_Event()
	If $iMouse_X_Position <> MouseGetPos(0) Then $iSelected = True
EndFunc

Func _GetSelectedText()
	Local $sSelected_Data
	
	;This one is crashing the script :(
;~ 	Local $hWnd = WinGetHandle("")
;~ 	Local $sCtrlClass = ControlGetFocus($hWnd)
;~ 	
;~ 	If Not StringInStr($sCtrlClass, "Scintilla") Then
;~ 		$sSelected_Data = ControlCommand($hWnd, "", $sCtrlClass, "GetSelected")
;~ 		If IsString($sSelected_Data) Then Return $sSelected_Data
;~ 	EndIf
	
	Local $sOld_Clipboard_Data = ClipGet()
	
	ClipPut("")
	Send("^{INS}")
	Sleep(100)
	$sSelected_Data = ClipGet()
	ClipPut($sOld_Clipboard_Data)
	
	Return $sSelected_Data
EndFunc

Func _CopyUseHotkey_Proc()
	$iSelected = True
EndFunc

Func _SwitchMonitoring_Proc()
	$iPaused = Not $iPaused
	
	If $iPaused Then
		TrayItemSetText($SwitchMonitoring_TrayItem, "  ")
		TrayItemSetState($SwitchMonitoring_TrayItem, $TRAY_UNCHECKED)
		TraySetIcon($sIcons_File, -3)
		
		_SetMouseEvent_Proc(0)
	Else
		TrayItemSetText($SwitchMonitoring_TrayItem, "  ")
		TrayItemSetState($SwitchMonitoring_TrayItem, $TRAY_CHECKED)
		TraySetIcon($sIcons_File, -2)
		
		_SetMouseEvent_Proc(1)
	EndIf
EndFunc

Func _SetMouseEvent_Proc($iSet = 1)
	If $iSet = 1 And TrayItemGetState($CopyUseSelection_TrayItem) = 68 Then Return 0
	
	Switch $iSet
		Case 1
			_MouseSetOnEvent($MOUSE_PRIMARYDOWN_EVENT, "MousePrimaryDown_Event", 0, 0)
			_MouseSetOnEvent($MOUSE_PRIMARYUP_EVENT, "MousePrimaryUp_Event", 0, 0)
		Case Else
			_MouseSetOnEvent($MOUSE_PRIMARYDOWN_EVENT)
			_MouseSetOnEvent($MOUSE_PRIMARYUP_EVENT)
	EndSwitch
EndFunc

Func _Quit()
	_SetMouseEvent_Proc(0)
	Exit
EndFunc
